"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .responseformattextconfig import (
    ResponseFormatTextConfig,
    ResponseFormatTextConfigTypedDict,
)
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
    UnrecognizedStr,
)
from openrouter.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


ResponseTextConfigVerbosity = Union[
    Literal[
        "high",
        "low",
        "medium",
    ],
    UnrecognizedStr,
]


class ResponseTextConfigTypedDict(TypedDict):
    r"""Text output configuration including format and verbosity"""

    format_: NotRequired[ResponseFormatTextConfigTypedDict]
    r"""Text response format configuration"""
    verbosity: NotRequired[Nullable[ResponseTextConfigVerbosity]]


class ResponseTextConfig(BaseModel):
    r"""Text output configuration including format and verbosity"""

    format_: Annotated[
        Optional[ResponseFormatTextConfig], pydantic.Field(alias="format")
    ] = None
    r"""Text response format configuration"""

    verbosity: Annotated[
        OptionalNullable[ResponseTextConfigVerbosity],
        PlainValidator(validate_open_enum(False)),
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["format", "verbosity"]
        nullable_fields = ["verbosity"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
