"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from openrouter.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Any, Dict, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ToolDefinitionJSONFunctionTypedDict(TypedDict):
    name: str
    description: NotRequired[str]
    parameters: NotRequired[Dict[str, Any]]
    strict: NotRequired[Nullable[bool]]


class ToolDefinitionJSONFunction(BaseModel):
    name: str

    description: Optional[str] = None

    parameters: Optional[Dict[str, Any]] = None

    strict: OptionalNullable[bool] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "parameters", "strict"]
        nullable_fields = ["strict"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ToolDefinitionJSONTypedDict(TypedDict):
    function: ToolDefinitionJSONFunctionTypedDict
    type: Literal["function"]


class ToolDefinitionJSON(BaseModel):
    function: ToolDefinitionJSONFunction

    TYPE: Annotated[
        Annotated[Literal["function"], AfterValidator(validate_const("function"))],
        pydantic.Field(alias="type"),
    ] = "function"
