"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from openrouter.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class TopProviderInfoTypedDict(TypedDict):
    r"""Information about the top provider for this model"""

    is_moderated: bool
    r"""Whether the top provider moderates content"""
    context_length: NotRequired[Nullable[float]]
    r"""Context length from the top provider"""
    max_completion_tokens: NotRequired[Nullable[float]]
    r"""Maximum completion tokens from the top provider"""


class TopProviderInfo(BaseModel):
    r"""Information about the top provider for this model"""

    is_moderated: bool
    r"""Whether the top provider moderates content"""

    context_length: OptionalNullable[float] = UNSET
    r"""Context length from the top provider"""

    max_completion_tokens: OptionalNullable[float] = UNSET
    r"""Maximum completion tokens from the top provider"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["context_length", "max_completion_tokens"]
        nullable_fields = ["context_length", "max_completion_tokens"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
