"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from datetime import datetime
from openrouter import errors, models, utils
from openrouter._hooks import HookContext
from openrouter.models import (
    createauthkeyscodeop as models_createauthkeyscodeop,
    exchangeauthcodeforapikeyop as models_exchangeauthcodeforapikeyop,
)
from openrouter.types import OptionalNullable, UNSET
from openrouter.utils import get_security_from_env
from openrouter.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional


class OAuth(BaseSDK):
    r"""OAuth authentication endpoints"""

    def exchange_auth_code_for_api_key(
        self,
        *,
        code: str,
        code_verifier: Optional[str] = None,
        code_challenge_method: OptionalNullable[
            models_exchangeauthcodeforapikeyop.ExchangeAuthCodeForAPIKeyCodeChallengeMethod
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ExchangeAuthCodeForAPIKeyResponse:
        r"""Exchange authorization code for API key

        Exchange an authorization code from the PKCE flow for a user-controlled API key

        :param code: The authorization code received from the OAuth redirect
        :param code_verifier: The code verifier if code_challenge was used in the authorization request
        :param code_challenge_method: The method used to generate the code challenge
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ExchangeAuthCodeForAPIKeyRequest(
            code=code,
            code_verifier=code_verifier,
            code_challenge_method=code_challenge_method,
        )

        req = self._build_request(
            method="POST",
            path="/auth/keys",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ExchangeAuthCodeForAPIKeyRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="exchangeAuthCodeForAPIKey",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "403", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ExchangeAuthCodeForAPIKeyResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestResponseErrorData, http_res
            )
            raise errors.BadRequestResponseError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenResponseErrorData, http_res
            )
            raise errors.ForbiddenResponseError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerResponseErrorData, http_res
            )
            raise errors.InternalServerResponseError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.OpenRouterDefaultError("Unexpected response received", http_res)

    async def exchange_auth_code_for_api_key_async(
        self,
        *,
        code: str,
        code_verifier: Optional[str] = None,
        code_challenge_method: OptionalNullable[
            models_exchangeauthcodeforapikeyop.ExchangeAuthCodeForAPIKeyCodeChallengeMethod
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ExchangeAuthCodeForAPIKeyResponse:
        r"""Exchange authorization code for API key

        Exchange an authorization code from the PKCE flow for a user-controlled API key

        :param code: The authorization code received from the OAuth redirect
        :param code_verifier: The code verifier if code_challenge was used in the authorization request
        :param code_challenge_method: The method used to generate the code challenge
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ExchangeAuthCodeForAPIKeyRequest(
            code=code,
            code_verifier=code_verifier,
            code_challenge_method=code_challenge_method,
        )

        req = self._build_request_async(
            method="POST",
            path="/auth/keys",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ExchangeAuthCodeForAPIKeyRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="exchangeAuthCodeForAPIKey",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "403", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.ExchangeAuthCodeForAPIKeyResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestResponseErrorData, http_res
            )
            raise errors.BadRequestResponseError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenResponseErrorData, http_res
            )
            raise errors.ForbiddenResponseError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerResponseErrorData, http_res
            )
            raise errors.InternalServerResponseError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.OpenRouterDefaultError("Unexpected response received", http_res)

    def create_auth_code(
        self,
        *,
        callback_url: str,
        code_challenge: Optional[str] = None,
        code_challenge_method: Optional[
            models_createauthkeyscodeop.CreateAuthKeysCodeCodeChallengeMethod
        ] = None,
        limit: Optional[float] = None,
        expires_at: OptionalNullable[datetime] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateAuthKeysCodeData:
        r"""Create authorization code

        Create an authorization code for the PKCE flow to generate a user-controlled API key

        :param callback_url: The callback URL to redirect to after authorization. Note, only https URLs on ports 443 and 3000 are allowed.
        :param code_challenge: PKCE code challenge for enhanced security
        :param code_challenge_method: The method used to generate the code challenge
        :param limit: Credit limit for the API key to be created
        :param expires_at: Optional expiration time for the API key to be created
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateAuthKeysCodeRequest(
            callback_url=callback_url,
            code_challenge=code_challenge,
            code_challenge_method=code_challenge_method,
            limit=limit,
            expires_at=expires_at,
        )

        req = self._build_request(
            method="POST",
            path="/auth/keys/code",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.CreateAuthKeysCodeRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createAuthKeysCode",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CreateAuthKeysCodeResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestResponseErrorData, http_res
            )
            raise errors.BadRequestResponseError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedResponseErrorData, http_res
            )
            raise errors.UnauthorizedResponseError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerResponseErrorData, http_res
            )
            raise errors.InternalServerResponseError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.OpenRouterDefaultError("Unexpected response received", http_res)

    async def create_auth_code_async(
        self,
        *,
        callback_url: str,
        code_challenge: Optional[str] = None,
        code_challenge_method: Optional[
            models_createauthkeyscodeop.CreateAuthKeysCodeCodeChallengeMethod
        ] = None,
        limit: Optional[float] = None,
        expires_at: OptionalNullable[datetime] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateAuthKeysCodeData:
        r"""Create authorization code

        Create an authorization code for the PKCE flow to generate a user-controlled API key

        :param callback_url: The callback URL to redirect to after authorization. Note, only https URLs on ports 443 and 3000 are allowed.
        :param code_challenge: PKCE code challenge for enhanced security
        :param code_challenge_method: The method used to generate the code challenge
        :param limit: Credit limit for the API key to be created
        :param expires_at: Optional expiration time for the API key to be created
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.CreateAuthKeysCodeRequest(
            callback_url=callback_url,
            code_challenge=code_challenge,
            code_challenge_method=code_challenge_method,
            limit=limit,
            expires_at=expires_at,
        )

        req = self._build_request_async(
            method="POST",
            path="/auth/keys/code",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.CreateAuthKeysCodeRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createAuthKeysCode",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "401", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.CreateAuthKeysCodeResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestResponseErrorData, http_res
            )
            raise errors.BadRequestResponseError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedResponseErrorData, http_res
            )
            raise errors.UnauthorizedResponseError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerResponseErrorData, http_res
            )
            raise errors.InternalServerResponseError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.OpenRouterDefaultError("Unexpected response received", http_res)
