"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from enum import Enum
from openrouter import errors, models, utils
from openrouter._hooks import HookContext
from openrouter.types import OptionalNullable, UNSET
from openrouter.utils import eventstreaming, get_security_from_env
from openrouter.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, List, Literal, Mapping, Optional, Union, overload


class SendAcceptEnum(str, Enum):
    APPLICATION_JSON = "application/json"
    TEXT_EVENT_STREAM = "text/event-stream"


class Responses(BaseSDK):
    r"""beta.responses endpoints"""

    @overload
    def send(
        self,
        *,
        input: Optional[
            Union[models.OpenResponsesInput, models.OpenResponsesInputTypedDict]
        ] = None,
        instructions: OptionalNullable[str] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        tools: Optional[
            Union[
                List[models.OpenResponsesRequestToolUnion],
                List[models.OpenResponsesRequestToolUnionTypedDict],
            ]
        ] = None,
        tool_choice: Optional[
            Union[
                models.OpenAIResponsesToolChoiceUnion,
                models.OpenAIResponsesToolChoiceUnionTypedDict,
            ]
        ] = None,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        text: Optional[
            Union[
                models.OpenResponsesResponseText,
                models.OpenResponsesResponseTextTypedDict,
            ]
        ] = None,
        reasoning: OptionalNullable[
            Union[
                models.OpenResponsesReasoningConfig,
                models.OpenResponsesReasoningConfigTypedDict,
            ]
        ] = UNSET,
        max_output_tokens: OptionalNullable[float] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        top_k: Optional[float] = None,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        previous_response_id: OptionalNullable[str] = UNSET,
        prompt: OptionalNullable[
            Union[models.OpenAIResponsesPrompt, models.OpenAIResponsesPromptTypedDict]
        ] = UNSET,
        include: OptionalNullable[List[models.OpenAIResponsesIncludable]] = UNSET,
        background: OptionalNullable[bool] = UNSET,
        safety_identifier: OptionalNullable[str] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        service_tier: OptionalNullable[models.ServiceTier] = UNSET,
        truncation: OptionalNullable[models.Truncation] = UNSET,
        stream: Union[Literal[False], None] = None,
        provider: OptionalNullable[
            Union[models.Provider, models.ProviderTypedDict]
        ] = UNSET,
        plugins: Optional[
            Union[List[models.Plugin], List[models.PluginTypedDict]]
        ] = None,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.OpenResponsesNonStreamingResponse:
        r"""Create a response

        Creates a streaming or non-streaming response using OpenResponses API format

        :param input: Input for a response request - can be a string or array of items
        :param instructions:
        :param metadata: Metadata key-value pairs for the request. Keys must be ≤64 characters and cannot contain brackets. Values must be ≤512 characters. Maximum 16 pairs allowed.
        :param tools:
        :param tool_choice:
        :param parallel_tool_calls:
        :param model:
        :param models:
        :param text: Text output configuration including format and verbosity
        :param reasoning: Configuration for reasoning mode in the response
        :param max_output_tokens:
        :param temperature:
        :param top_p:
        :param top_k:
        :param prompt_cache_key:
        :param previous_response_id:
        :param prompt:
        :param include:
        :param background:
        :param safety_identifier:
        :param store:
        :param service_tier:
        :param truncation:
        :param stream:
        :param provider: When multiple model providers are available, optionally indicate your routing preference.
        :param plugins: Plugins you want to enable for this request, including their settings.
        :param user: A unique identifier representing your end-user, which helps distinguish between different users of your app. This allows your app to identify specific users in case of abuse reports, preventing your entire app from being affected by the actions of individual users. Maximum of 128 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """

    @overload
    def send(
        self,
        *,
        input: Optional[
            Union[models.OpenResponsesInput, models.OpenResponsesInputTypedDict]
        ] = None,
        instructions: OptionalNullable[str] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        tools: Optional[
            Union[
                List[models.OpenResponsesRequestToolUnion],
                List[models.OpenResponsesRequestToolUnionTypedDict],
            ]
        ] = None,
        tool_choice: Optional[
            Union[
                models.OpenAIResponsesToolChoiceUnion,
                models.OpenAIResponsesToolChoiceUnionTypedDict,
            ]
        ] = None,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        text: Optional[
            Union[
                models.OpenResponsesResponseText,
                models.OpenResponsesResponseTextTypedDict,
            ]
        ] = None,
        reasoning: OptionalNullable[
            Union[
                models.OpenResponsesReasoningConfig,
                models.OpenResponsesReasoningConfigTypedDict,
            ]
        ] = UNSET,
        max_output_tokens: OptionalNullable[float] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        top_k: Optional[float] = None,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        previous_response_id: OptionalNullable[str] = UNSET,
        prompt: OptionalNullable[
            Union[models.OpenAIResponsesPrompt, models.OpenAIResponsesPromptTypedDict]
        ] = UNSET,
        include: OptionalNullable[List[models.OpenAIResponsesIncludable]] = UNSET,
        background: OptionalNullable[bool] = UNSET,
        safety_identifier: OptionalNullable[str] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        service_tier: OptionalNullable[models.ServiceTier] = UNSET,
        truncation: OptionalNullable[models.Truncation] = UNSET,
        stream: Literal[True],
        provider: OptionalNullable[
            Union[models.Provider, models.ProviderTypedDict]
        ] = UNSET,
        plugins: Optional[
            Union[List[models.Plugin], List[models.PluginTypedDict]]
        ] = None,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStream[models.OpenResponsesStreamEvent]:
        r"""Create a response

        Creates a streaming or non-streaming response using OpenResponses API format

        :param input: Input for a response request - can be a string or array of items
        :param instructions:
        :param metadata: Metadata key-value pairs for the request. Keys must be ≤64 characters and cannot contain brackets. Values must be ≤512 characters. Maximum 16 pairs allowed.
        :param tools:
        :param tool_choice:
        :param parallel_tool_calls:
        :param model:
        :param models:
        :param text: Text output configuration including format and verbosity
        :param reasoning: Configuration for reasoning mode in the response
        :param max_output_tokens:
        :param temperature:
        :param top_p:
        :param top_k:
        :param prompt_cache_key:
        :param previous_response_id:
        :param prompt:
        :param include:
        :param background:
        :param safety_identifier:
        :param store:
        :param service_tier:
        :param truncation:
        :param stream:
        :param provider: When multiple model providers are available, optionally indicate your routing preference.
        :param plugins: Plugins you want to enable for this request, including their settings.
        :param user: A unique identifier representing your end-user, which helps distinguish between different users of your app. This allows your app to identify specific users in case of abuse reports, preventing your entire app from being affected by the actions of individual users. Maximum of 128 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """

    def send(
        self,
        *,
        input: Optional[
            Union[models.OpenResponsesInput, models.OpenResponsesInputTypedDict]
        ] = None,
        instructions: OptionalNullable[str] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        tools: Optional[
            Union[
                List[models.OpenResponsesRequestToolUnion],
                List[models.OpenResponsesRequestToolUnionTypedDict],
            ]
        ] = None,
        tool_choice: Optional[
            Union[
                models.OpenAIResponsesToolChoiceUnion,
                models.OpenAIResponsesToolChoiceUnionTypedDict,
            ]
        ] = None,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        text: Optional[
            Union[
                models.OpenResponsesResponseText,
                models.OpenResponsesResponseTextTypedDict,
            ]
        ] = None,
        reasoning: OptionalNullable[
            Union[
                models.OpenResponsesReasoningConfig,
                models.OpenResponsesReasoningConfigTypedDict,
            ]
        ] = UNSET,
        max_output_tokens: OptionalNullable[float] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        top_k: Optional[float] = None,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        previous_response_id: OptionalNullable[str] = UNSET,
        prompt: OptionalNullable[
            Union[models.OpenAIResponsesPrompt, models.OpenAIResponsesPromptTypedDict]
        ] = UNSET,
        include: OptionalNullable[List[models.OpenAIResponsesIncludable]] = UNSET,
        background: OptionalNullable[bool] = UNSET,
        safety_identifier: OptionalNullable[str] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        service_tier: OptionalNullable[models.ServiceTier] = UNSET,
        truncation: OptionalNullable[models.Truncation] = UNSET,
        stream: Optional[bool] = False,
        provider: OptionalNullable[
            Union[models.Provider, models.ProviderTypedDict]
        ] = UNSET,
        plugins: Optional[
            Union[List[models.Plugin], List[models.PluginTypedDict]]
        ] = None,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateResponsesResponse:
        r"""Create a response

        Creates a streaming or non-streaming response using OpenResponses API format

        :param input: Input for a response request - can be a string or array of items
        :param instructions:
        :param metadata: Metadata key-value pairs for the request. Keys must be ≤64 characters and cannot contain brackets. Values must be ≤512 characters. Maximum 16 pairs allowed.
        :param tools:
        :param tool_choice:
        :param parallel_tool_calls:
        :param model:
        :param models:
        :param text: Text output configuration including format and verbosity
        :param reasoning: Configuration for reasoning mode in the response
        :param max_output_tokens:
        :param temperature:
        :param top_p:
        :param top_k:
        :param prompt_cache_key:
        :param previous_response_id:
        :param prompt:
        :param include:
        :param background:
        :param safety_identifier:
        :param store:
        :param service_tier:
        :param truncation:
        :param stream:
        :param provider: When multiple model providers are available, optionally indicate your routing preference.
        :param plugins: Plugins you want to enable for this request, including their settings.
        :param user: A unique identifier representing your end-user, which helps distinguish between different users of your app. This allows your app to identify specific users in case of abuse reports, preventing your entire app from being affected by the actions of individual users. Maximum of 128 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OpenResponsesRequest(
            input=utils.get_pydantic_model(input, Optional[models.OpenResponsesInput]),
            instructions=instructions,
            metadata=metadata,
            tools=utils.get_pydantic_model(
                tools, Optional[List[models.OpenResponsesRequestToolUnion]]
            ),
            tool_choice=utils.get_pydantic_model(
                tool_choice, Optional[models.OpenAIResponsesToolChoiceUnion]
            ),
            parallel_tool_calls=parallel_tool_calls,
            model=model,
            models=models,
            text=utils.get_pydantic_model(
                text, Optional[models.OpenResponsesResponseText]
            ),
            reasoning=utils.get_pydantic_model(
                reasoning, OptionalNullable[models.OpenResponsesReasoningConfig]
            ),
            max_output_tokens=max_output_tokens,
            temperature=temperature,
            top_p=top_p,
            top_k=top_k,
            prompt_cache_key=prompt_cache_key,
            previous_response_id=previous_response_id,
            prompt=utils.get_pydantic_model(
                prompt, OptionalNullable[models.OpenAIResponsesPrompt]
            ),
            include=include,
            background=background,
            safety_identifier=safety_identifier,
            store=store,
            service_tier=service_tier,
            truncation=truncation,
            stream=stream,
            provider=utils.get_pydantic_model(
                provider, OptionalNullable[models.Provider]
            ),
            plugins=utils.get_pydantic_model(plugins, Optional[List[models.Plugin]]),
            user=user,
        )

        req = self._build_request(
            method="POST",
            path="/responses",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream" if stream else "application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.OpenResponsesRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createResponses",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "404",
                "408",
                "413",
                "422",
                "429",
                "4XX",
                "500",
                "502",
                "503",
                "524",
                "529",
                "5XX",
            ],
            stream=True,
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            return unmarshal_json_response(
                models.OpenResponsesNonStreamingResponse, http_res, http_res_text
            )
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStream(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw, models.CreateResponsesResponseBody
                ).data,
                sentinel="[DONE]",
                client_ref=self,
            )
        if utils.match_response(http_res, "400", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.BadRequestResponseErrorData, http_res, http_res_text
            )
            raise errors.BadRequestResponseError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "401", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.UnauthorizedResponseErrorData, http_res, http_res_text
            )
            raise errors.UnauthorizedResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "402", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.PaymentRequiredResponseErrorData, http_res, http_res_text
            )
            raise errors.PaymentRequiredResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "404", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.NotFoundResponseErrorData, http_res, http_res_text
            )
            raise errors.NotFoundResponseError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "408", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.RequestTimeoutResponseErrorData, http_res, http_res_text
            )
            raise errors.RequestTimeoutResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "413", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeResponseErrorData, http_res, http_res_text
            )
            raise errors.PayloadTooLargeResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "422", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityResponseErrorData, http_res, http_res_text
            )
            raise errors.UnprocessableEntityResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "429", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.TooManyRequestsResponseErrorData, http_res, http_res_text
            )
            raise errors.TooManyRequestsResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "500", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.InternalServerResponseErrorData, http_res, http_res_text
            )
            raise errors.InternalServerResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "502", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.BadGatewayResponseErrorData, http_res, http_res_text
            )
            raise errors.BadGatewayResponseError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "503", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableResponseErrorData, http_res, http_res_text
            )
            raise errors.ServiceUnavailableResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "524", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.EdgeNetworkTimeoutResponseErrorData, http_res, http_res_text
            )
            raise errors.EdgeNetworkTimeoutResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "529", "application/json"):
            http_res_text = utils.stream_to_text(http_res)
            response_data = unmarshal_json_response(
                errors.ProviderOverloadedResponseErrorData, http_res, http_res_text
            )
            raise errors.ProviderOverloadedResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        http_res_text = utils.stream_to_text(http_res)
        raise errors.OpenRouterDefaultError(
            "Unexpected response received", http_res, http_res_text
        )

    @overload
    async def send_async(
        self,
        *,
        input: Optional[
            Union[models.OpenResponsesInput, models.OpenResponsesInputTypedDict]
        ] = None,
        instructions: OptionalNullable[str] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        tools: Optional[
            Union[
                List[models.OpenResponsesRequestToolUnion],
                List[models.OpenResponsesRequestToolUnionTypedDict],
            ]
        ] = None,
        tool_choice: Optional[
            Union[
                models.OpenAIResponsesToolChoiceUnion,
                models.OpenAIResponsesToolChoiceUnionTypedDict,
            ]
        ] = None,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        text: Optional[
            Union[
                models.OpenResponsesResponseText,
                models.OpenResponsesResponseTextTypedDict,
            ]
        ] = None,
        reasoning: OptionalNullable[
            Union[
                models.OpenResponsesReasoningConfig,
                models.OpenResponsesReasoningConfigTypedDict,
            ]
        ] = UNSET,
        max_output_tokens: OptionalNullable[float] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        top_k: Optional[float] = None,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        previous_response_id: OptionalNullable[str] = UNSET,
        prompt: OptionalNullable[
            Union[models.OpenAIResponsesPrompt, models.OpenAIResponsesPromptTypedDict]
        ] = UNSET,
        include: OptionalNullable[List[models.OpenAIResponsesIncludable]] = UNSET,
        background: OptionalNullable[bool] = UNSET,
        safety_identifier: OptionalNullable[str] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        service_tier: OptionalNullable[models.ServiceTier] = UNSET,
        truncation: OptionalNullable[models.Truncation] = UNSET,
        stream: Union[Literal[False], None] = None,
        provider: OptionalNullable[
            Union[models.Provider, models.ProviderTypedDict]
        ] = UNSET,
        plugins: Optional[
            Union[List[models.Plugin], List[models.PluginTypedDict]]
        ] = None,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.OpenResponsesNonStreamingResponse:
        r"""Create a response

        Creates a streaming or non-streaming response using OpenResponses API format

        :param input: Input for a response request - can be a string or array of items
        :param instructions:
        :param metadata: Metadata key-value pairs for the request. Keys must be ≤64 characters and cannot contain brackets. Values must be ≤512 characters. Maximum 16 pairs allowed.
        :param tools:
        :param tool_choice:
        :param parallel_tool_calls:
        :param model:
        :param models:
        :param text: Text output configuration including format and verbosity
        :param reasoning: Configuration for reasoning mode in the response
        :param max_output_tokens:
        :param temperature:
        :param top_p:
        :param top_k:
        :param prompt_cache_key:
        :param previous_response_id:
        :param prompt:
        :param include:
        :param background:
        :param safety_identifier:
        :param store:
        :param service_tier:
        :param truncation:
        :param stream:
        :param provider: When multiple model providers are available, optionally indicate your routing preference.
        :param plugins: Plugins you want to enable for this request, including their settings.
        :param user: A unique identifier representing your end-user, which helps distinguish between different users of your app. This allows your app to identify specific users in case of abuse reports, preventing your entire app from being affected by the actions of individual users. Maximum of 128 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """

    @overload
    async def send_async(
        self,
        *,
        input: Optional[
            Union[models.OpenResponsesInput, models.OpenResponsesInputTypedDict]
        ] = None,
        instructions: OptionalNullable[str] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        tools: Optional[
            Union[
                List[models.OpenResponsesRequestToolUnion],
                List[models.OpenResponsesRequestToolUnionTypedDict],
            ]
        ] = None,
        tool_choice: Optional[
            Union[
                models.OpenAIResponsesToolChoiceUnion,
                models.OpenAIResponsesToolChoiceUnionTypedDict,
            ]
        ] = None,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        text: Optional[
            Union[
                models.OpenResponsesResponseText,
                models.OpenResponsesResponseTextTypedDict,
            ]
        ] = None,
        reasoning: OptionalNullable[
            Union[
                models.OpenResponsesReasoningConfig,
                models.OpenResponsesReasoningConfigTypedDict,
            ]
        ] = UNSET,
        max_output_tokens: OptionalNullable[float] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        top_k: Optional[float] = None,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        previous_response_id: OptionalNullable[str] = UNSET,
        prompt: OptionalNullable[
            Union[models.OpenAIResponsesPrompt, models.OpenAIResponsesPromptTypedDict]
        ] = UNSET,
        include: OptionalNullable[List[models.OpenAIResponsesIncludable]] = UNSET,
        background: OptionalNullable[bool] = UNSET,
        safety_identifier: OptionalNullable[str] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        service_tier: OptionalNullable[models.ServiceTier] = UNSET,
        truncation: OptionalNullable[models.Truncation] = UNSET,
        stream: Literal[True],
        provider: OptionalNullable[
            Union[models.Provider, models.ProviderTypedDict]
        ] = UNSET,
        plugins: Optional[
            Union[List[models.Plugin], List[models.PluginTypedDict]]
        ] = None,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> eventstreaming.EventStreamAsync[models.OpenResponsesStreamEvent]:
        r"""Create a response

        Creates a streaming or non-streaming response using OpenResponses API format

        :param input: Input for a response request - can be a string or array of items
        :param instructions:
        :param metadata: Metadata key-value pairs for the request. Keys must be ≤64 characters and cannot contain brackets. Values must be ≤512 characters. Maximum 16 pairs allowed.
        :param tools:
        :param tool_choice:
        :param parallel_tool_calls:
        :param model:
        :param models:
        :param text: Text output configuration including format and verbosity
        :param reasoning: Configuration for reasoning mode in the response
        :param max_output_tokens:
        :param temperature:
        :param top_p:
        :param top_k:
        :param prompt_cache_key:
        :param previous_response_id:
        :param prompt:
        :param include:
        :param background:
        :param safety_identifier:
        :param store:
        :param service_tier:
        :param truncation:
        :param stream:
        :param provider: When multiple model providers are available, optionally indicate your routing preference.
        :param plugins: Plugins you want to enable for this request, including their settings.
        :param user: A unique identifier representing your end-user, which helps distinguish between different users of your app. This allows your app to identify specific users in case of abuse reports, preventing your entire app from being affected by the actions of individual users. Maximum of 128 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """

    async def send_async(
        self,
        *,
        input: Optional[
            Union[models.OpenResponsesInput, models.OpenResponsesInputTypedDict]
        ] = None,
        instructions: OptionalNullable[str] = UNSET,
        metadata: OptionalNullable[Dict[str, str]] = UNSET,
        tools: Optional[
            Union[
                List[models.OpenResponsesRequestToolUnion],
                List[models.OpenResponsesRequestToolUnionTypedDict],
            ]
        ] = None,
        tool_choice: Optional[
            Union[
                models.OpenAIResponsesToolChoiceUnion,
                models.OpenAIResponsesToolChoiceUnionTypedDict,
            ]
        ] = None,
        parallel_tool_calls: OptionalNullable[bool] = UNSET,
        model: Optional[str] = None,
        models: Optional[List[str]] = None,
        text: Optional[
            Union[
                models.OpenResponsesResponseText,
                models.OpenResponsesResponseTextTypedDict,
            ]
        ] = None,
        reasoning: OptionalNullable[
            Union[
                models.OpenResponsesReasoningConfig,
                models.OpenResponsesReasoningConfigTypedDict,
            ]
        ] = UNSET,
        max_output_tokens: OptionalNullable[float] = UNSET,
        temperature: OptionalNullable[float] = UNSET,
        top_p: OptionalNullable[float] = UNSET,
        top_k: Optional[float] = None,
        prompt_cache_key: OptionalNullable[str] = UNSET,
        previous_response_id: OptionalNullable[str] = UNSET,
        prompt: OptionalNullable[
            Union[models.OpenAIResponsesPrompt, models.OpenAIResponsesPromptTypedDict]
        ] = UNSET,
        include: OptionalNullable[List[models.OpenAIResponsesIncludable]] = UNSET,
        background: OptionalNullable[bool] = UNSET,
        safety_identifier: OptionalNullable[str] = UNSET,
        store: OptionalNullable[bool] = UNSET,
        service_tier: OptionalNullable[models.ServiceTier] = UNSET,
        truncation: OptionalNullable[models.Truncation] = UNSET,
        stream: Optional[bool] = False,
        provider: OptionalNullable[
            Union[models.Provider, models.ProviderTypedDict]
        ] = UNSET,
        plugins: Optional[
            Union[List[models.Plugin], List[models.PluginTypedDict]]
        ] = None,
        user: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.CreateResponsesResponse:
        r"""Create a response

        Creates a streaming or non-streaming response using OpenResponses API format

        :param input: Input for a response request - can be a string or array of items
        :param instructions:
        :param metadata: Metadata key-value pairs for the request. Keys must be ≤64 characters and cannot contain brackets. Values must be ≤512 characters. Maximum 16 pairs allowed.
        :param tools:
        :param tool_choice:
        :param parallel_tool_calls:
        :param model:
        :param models:
        :param text: Text output configuration including format and verbosity
        :param reasoning: Configuration for reasoning mode in the response
        :param max_output_tokens:
        :param temperature:
        :param top_p:
        :param top_k:
        :param prompt_cache_key:
        :param previous_response_id:
        :param prompt:
        :param include:
        :param background:
        :param safety_identifier:
        :param store:
        :param service_tier:
        :param truncation:
        :param stream:
        :param provider: When multiple model providers are available, optionally indicate your routing preference.
        :param plugins: Plugins you want to enable for this request, including their settings.
        :param user: A unique identifier representing your end-user, which helps distinguish between different users of your app. This allows your app to identify specific users in case of abuse reports, preventing your entire app from being affected by the actions of individual users. Maximum of 128 characters.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param accept_header_override: Override the default accept header for this method
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OpenResponsesRequest(
            input=utils.get_pydantic_model(input, Optional[models.OpenResponsesInput]),
            instructions=instructions,
            metadata=metadata,
            tools=utils.get_pydantic_model(
                tools, Optional[List[models.OpenResponsesRequestToolUnion]]
            ),
            tool_choice=utils.get_pydantic_model(
                tool_choice, Optional[models.OpenAIResponsesToolChoiceUnion]
            ),
            parallel_tool_calls=parallel_tool_calls,
            model=model,
            models=models,
            text=utils.get_pydantic_model(
                text, Optional[models.OpenResponsesResponseText]
            ),
            reasoning=utils.get_pydantic_model(
                reasoning, OptionalNullable[models.OpenResponsesReasoningConfig]
            ),
            max_output_tokens=max_output_tokens,
            temperature=temperature,
            top_p=top_p,
            top_k=top_k,
            prompt_cache_key=prompt_cache_key,
            previous_response_id=previous_response_id,
            prompt=utils.get_pydantic_model(
                prompt, OptionalNullable[models.OpenAIResponsesPrompt]
            ),
            include=include,
            background=background,
            safety_identifier=safety_identifier,
            store=store,
            service_tier=service_tier,
            truncation=truncation,
            stream=stream,
            provider=utils.get_pydantic_model(
                provider, OptionalNullable[models.Provider]
            ),
            plugins=utils.get_pydantic_model(plugins, Optional[List[models.Plugin]]),
            user=user,
        )

        req = self._build_request_async(
            method="POST",
            path="/responses",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="text/event-stream" if stream else "application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.OpenResponsesRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="createResponses",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "404",
                "408",
                "413",
                "422",
                "429",
                "4XX",
                "500",
                "502",
                "503",
                "524",
                "529",
                "5XX",
            ],
            stream=True,
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            return unmarshal_json_response(
                models.OpenResponsesNonStreamingResponse, http_res, http_res_text
            )
        if utils.match_response(http_res, "200", "text/event-stream"):
            return eventstreaming.EventStreamAsync(
                http_res,
                lambda raw: utils.unmarshal_json(
                    raw, models.CreateResponsesResponseBody
                ).data,
                sentinel="[DONE]",
                client_ref=self,
            )
        if utils.match_response(http_res, "400", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.BadRequestResponseErrorData, http_res, http_res_text
            )
            raise errors.BadRequestResponseError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "401", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.UnauthorizedResponseErrorData, http_res, http_res_text
            )
            raise errors.UnauthorizedResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "402", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.PaymentRequiredResponseErrorData, http_res, http_res_text
            )
            raise errors.PaymentRequiredResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "404", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.NotFoundResponseErrorData, http_res, http_res_text
            )
            raise errors.NotFoundResponseError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "408", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.RequestTimeoutResponseErrorData, http_res, http_res_text
            )
            raise errors.RequestTimeoutResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "413", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeResponseErrorData, http_res, http_res_text
            )
            raise errors.PayloadTooLargeResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "422", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityResponseErrorData, http_res, http_res_text
            )
            raise errors.UnprocessableEntityResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "429", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.TooManyRequestsResponseErrorData, http_res, http_res_text
            )
            raise errors.TooManyRequestsResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "500", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.InternalServerResponseErrorData, http_res, http_res_text
            )
            raise errors.InternalServerResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "502", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.BadGatewayResponseErrorData, http_res, http_res_text
            )
            raise errors.BadGatewayResponseError(response_data, http_res, http_res_text)
        if utils.match_response(http_res, "503", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableResponseErrorData, http_res, http_res_text
            )
            raise errors.ServiceUnavailableResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "524", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.EdgeNetworkTimeoutResponseErrorData, http_res, http_res_text
            )
            raise errors.EdgeNetworkTimeoutResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "529", "application/json"):
            http_res_text = await utils.stream_to_text_async(http_res)
            response_data = unmarshal_json_response(
                errors.ProviderOverloadedResponseErrorData, http_res, http_res_text
            )
            raise errors.ProviderOverloadedResponseError(
                response_data, http_res, http_res_text
            )
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.OpenRouterDefaultError(
                "API error occurred", http_res, http_res_text
            )

        http_res_text = await utils.stream_to_text_async(http_res)
        raise errors.OpenRouterDefaultError(
            "Unexpected response received", http_res, http_res_text
        )
