from bam_masterdata.metadata.definitions import VocabularyTerm, VocabularyTypeDef
from bam_masterdata.metadata.entities import VocabularyType


class DefaultCollectionViews(VocabularyType):
    defs = VocabularyTypeDef(
        code="$DEFAULT_COLLECTION_VIEWS",
        description="""Default collection views""",
    )

    form_view = VocabularyTerm(
        code="FORM_VIEW",
        label="Form view",
        description="""""",
    )

    list_view = VocabularyTerm(
        code="LIST_VIEW",
        label="List view",
        description="""""",
    )


class StorageFormat(VocabularyType):
    defs = VocabularyTypeDef(
        code="$STORAGE_FORMAT",
        description="""The on-disk storage format of a data set""",
    )

    bds_directory = VocabularyTerm(
        code="BDS_DIRECTORY",
        label="",
        description="""""",
    )

    proprietary = VocabularyTerm(
        code="PROPRIETARY",
        label="",
        description="""""",
    )


class AccuracyClassVde0410(VocabularyType):
    defs = VocabularyTypeDef(
        code="ACCURACY_CLASS_VDE0410",
        description="""Accuracy Classes according to VDE 0410//Genauigkeitsklassen nach VDE 0410""",
    )

    accuracy_0_1 = VocabularyTerm(
        code="ACCURACY_0.1",
        label="Accuracy Class 0,1 (0,1 % Fullscale)",
        description="""Accuracy Class 0,1 (0,1 % Fullscale)//Genauigkeitsklasse 0,1 (0,1 % vom Skalenendwert)""",
    )

    accuracy_0_2 = VocabularyTerm(
        code="ACCURACY_0.2",
        label="Accuracy Class 0,2 (0,2 % Fullscale)",
        description="""Accuracy Class 0,2 (0,2 % Fullscale)//Genauigkeitsklasse 0,2 (0,2 % vom Skalenendwert)""",
    )

    accuracy_0_5 = VocabularyTerm(
        code="ACCURACY_0.5",
        label="Accuracy Class 0,5 (0,5 % Fullscale)",
        description="""Accuracy Class 0,5 (0,5 % Fullscale)//Genauigkeitsklasse 0,5 (0,5 % vom Skalenendwert)""",
    )

    accuracy_1 = VocabularyTerm(
        code="ACCURACY_1",
        label="Accuracy Class 1 (1 % Fullscale)",
        description="""Accuracy Class 1 (1 % Fullscale)//Genauigkeitsklasse 1 (1 % vom Skalenendwert)""",
    )

    accuracy_1_5 = VocabularyTerm(
        code="ACCURACY_1.5",
        label="Accuracy Class 1,5 (1,5 % Fullscale)",
        description="""Accuracy Class 1,5 (1,5 % Fullscale)//Genauigkeitsklasse 1,5 (1,5 % vom Skalenendwert)""",
    )

    accuracy_2_5 = VocabularyTerm(
        code="ACCURACY_2.5",
        label="Accuracy Class 2,5 (2,5 % Fullscale)",
        description="""Accuracy Class 2,5 (2,5 % Fullscale)//Genauigkeitsklasse 2,5 (2,5 % vom Skalenendwert)""",
    )

    accuracy_5 = VocabularyTerm(
        code="ACCURACY_5",
        label="Accuracy Class 5 (5 % Fullscale)",
        description="""Accuracy Class 5 (5 % Fullscale)//Genauigkeitsklasse 5 (5 % vom Skalenendwert)""",
    )


class AtomisticCalcType(VocabularyType):
    defs = VocabularyTypeDef(
        code="ATOMISTIC_CALC_TYPE",
        description="""Type of calculation//Art der Berechnung""",
    )

    atom_calc_mc = VocabularyTerm(
        code="ATOM_CALC_MC",
        label="Monte-Carlo",
        description="""Monte-Carlo calculation//Monte-Carlo Berechnung""",
    )

    atom_calc_md = VocabularyTerm(
        code="ATOM_CALC_MD",
        label="Molecular Dynamics",
        description="""Molecular dynamics (including ab initio)//Molekulardynamik (inklusive ab initio)""",
    )

    atom_calc_neb = VocabularyTerm(
        code="ATOM_CALC_NEB",
        label="NEB",
        description="""Nudged Elastic Band method//Geschobene Elastische Band Methode""",
    )

    atom_calc_sc = VocabularyTerm(
        code="ATOM_CALC_SC",
        label="Self-consistent Field",
        description="""Self-consistent field calculation//Selbstkonsistente Feldberechnung""",
    )

    atom_calc_struc_opt = VocabularyTerm(
        code="ATOM_CALC_STRUC_OPT",
        label="Minimization/Structural-optimization",
        description="""Minimization/structural-optimization//Minimierung/Strukturoptimierung""",
    )


class AtomKpointType(VocabularyType):
    defs = VocabularyTypeDef(
        code="ATOM_KPOINT_TYPE",
        description="""K-points specification type//K-Punkte-Spezifikation Typ""",
    )

    kpoints_kspacing = VocabularyTerm(
        code="KPOINTS_KSPACING",
        label="K-spacing",
        description="""K-spacing method//K-spacing Methode""",
    )

    kpoints_manual = VocabularyTerm(
        code="KPOINTS_MANUAL",
        label="Manually Defined",
        description="""Manually defined//Manuell definiert""",
    )

    kpoints_mp = VocabularyTerm(
        code="KPOINTS_MP",
        label="Monkhorst-Pack",
        description="""Monkhorst-Pack method//Monkhorst-Pack Methode""",
    )


class AtomPotentialStyle(VocabularyType):
    defs = VocabularyTypeDef(
        code="ATOM_POTENTIAL_STYLE",
        description="""Interatomic Potential Style//Interatomares Potential Stil""",
    )

    pot_style_eam = VocabularyTerm(
        code="POT_STYLE_EAM",
        label="Embedded Atom Model Potential",
        description="""Embedded atom model//Eingebettetes-Atom-Model""",
    )

    pot_style_ff = VocabularyTerm(
        code="POT_STYLE_FF",
        label="Force Field Potential",
        description="""Force field potential//Kraftfeld Potenzial""",
    )

    pot_style_lj = VocabularyTerm(
        code="POT_STYLE_LJ",
        label="Lennard-Jones Potential",
        description="""Lennard-Jones potential//Lennard-Jones Potenzial""",
    )

    pot_style_meam = VocabularyTerm(
        code="POT_STYLE_MEAM",
        label="Modified Embedded Atom Model Potential",
        description="""Modifiead embedded atom model//Modifiziertes Eingebettetes-Atom-Model""",
    )

    pot_style_mlip = VocabularyTerm(
        code="POT_STYLE_MLIP",
        label="Machine Learning Potential",
        description="""Machine learning potential//Machine-learning Potenzial""",
    )

    pot_style_sw = VocabularyTerm(
        code="POT_STYLE_SW",
        label="Stillinger-Weber Potential",
        description="""Stillinger-Weber potential//Stillinger-Weber Potenzial""",
    )

    pot_style_umlip = VocabularyTerm(
        code="POT_STYLE_UMLIP",
        label="Universal Machine Learning Potential",
        description="""Universal machine learning potential//Universelles Machine-learning Potenzial""",
    )


class AtomXcFunctional(VocabularyType):
    defs = VocabularyTypeDef(
        code="ATOM_XC_FUNCTIONAL",
        description="""Exchange-correlation functional//Austausch-Korrelations-Funktional""",
    )

    xc_func_b3lyp = VocabularyTerm(
        code="XC_FUNC_B3LYP",
        label="B3LYP",
        description="""B3LYP functional//B3LYP Funktional""",
    )

    xc_func_hse03 = VocabularyTerm(
        code="XC_FUNC_HSE03",
        label="HSE03",
        description="""HSE03 functional//HSE03 Funktional""",
    )

    xc_func_hse06 = VocabularyTerm(
        code="XC_FUNC_HSE06",
        label="HSE06",
        description="""HSE06 functional//HSE06 Funktional""",
    )

    xc_func_lda = VocabularyTerm(
        code="XC_FUNC_LDA",
        label="LDA",
        description="""Local Density Approximation//Lokale Dichtenäherung""",
    )

    xc_func_pbe = VocabularyTerm(
        code="XC_FUNC_PBE",
        label="PBE",
        description="""PBE-exchange-correlation functional//PBE-Austauschkorrelation Funktional""",
    )

    xc_func_pbe_sol = VocabularyTerm(
        code="XC_FUNC_PBE_SOL",
        label="PBEsol",
        description="""PBE functional revised for solids//PBE Funktional überarbeitet für Festkörper""",
    )

    xc_func_scan0 = VocabularyTerm(
        code="XC_FUNC_SCAN0",
        label="SCAN0",
        description="""SCAN0 functional//SCAN0 Funktional""",
    )


class AuxiliaryMaterialType(VocabularyType):
    defs = VocabularyTypeDef(
        code="AUXILIARY_MATERIAL_TYPE",
        description="""Auxiliary Material Types//Hilfsstofftyp""",
    )

    abrasive = VocabularyTerm(
        code="ABRASIVE",
        label="Abrasive",
        description="""Abrasive//Schleifmittel""",
    )

    adhesive = VocabularyTerm(
        code="ADHESIVE",
        label="Adhesive",
        description="""Adhesive//Klebstoff""",
    )

    cleaner = VocabularyTerm(
        code="CLEANER",
        label="Cleaner",
        description="""Cleaner//Reinigungsmittel""",
    )

    flux = VocabularyTerm(
        code="FLUX",
        label="Flux",
        description="""Flux//Flussmittel""",
    )

    lubricant = VocabularyTerm(
        code="LUBRICANT",
        label="Lubricant",
        description="""Lubricant//Schmierstoff""",
    )

    polishing_agent = VocabularyTerm(
        code="POLISHING_AGENT",
        label="Polishing Agent",
        description="""Polishing Agent//Poliermittel""",
    )

    razorblade = VocabularyTerm(
        code="RAZORBLADE",
        label="Razorblade",
        description="""Razorblade//Rasierklinge""",
    )

    solder = VocabularyTerm(
        code="SOLDER",
        label="Solder",
        description="""Solder//Lot""",
    )

    solvant = VocabularyTerm(
        code="SOLVANT",
        label="Solvent",
        description="""Solvent//Lösungsmittel""",
    )

    welding_additive = VocabularyTerm(
        code="WELDING_ADDITIVE",
        label="Welding Additive",
        description="""Welding Additive//Schweisszusatz""",
    )


class BamFieldOfActivity(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_FIELD_OF_ACTIVITY",
        description="""BAM Field of Activity//BAM Aktivitätsfeld""",
    )

    anal_sci_chemical_composition_and_trace_analysis = VocabularyTerm(
        code="ANAL_SCI_CHEMICAL_COMPOSITION_AND_TRACE_ANALYSIS",
        label="Analytical Sciences: Chemical composition and trace analysis",
        description="""Analytical Sciences: Chemical composition and trace analysis//Analytical Sciences: Spurenanalytik und chemische Zusammensetzung""",
    )

    anal_sci_non_destructive_testing_and_spectroscopy = VocabularyTerm(
        code="ANAL_SCI_NON_DESTRUCTIVE_TESTING_AND_SPECTROSCOPY",
        label="Analytical Sciences: Non-destructive testing and spectroscopy",
        description="""Analytical Sciences: Non-destructive testing and spectroscopy//Analytical Sciences: Zerstörungsfreie Prüfung und Spektroskopie""",
    )

    anal_sci_quality_assurance_and_data_science = VocabularyTerm(
        code="ANAL_SCI_QUALITY_ASSURANCE_AND_DATA_SCIENCE",
        label="Analytical Sciences: Quality assurance and data science",
        description="""Analytical Sciences: Quality assurance and data science//Analytical Sciences: Qualitätssicherung und Data Science""",
    )

    anal_sci_sensor_technology = VocabularyTerm(
        code="ANAL_SCI_SENSOR_TECHNOLOGY",
        label="Analytical Sciences: Sensor technology",
        description="""Analytical Sciences: Sensor technology//Analytical Sciences: Sensorik""",
    )

    anal_sci_structure_analysis_and_materialography = VocabularyTerm(
        code="ANAL_SCI_STRUCTURE_ANALYSIS_AND_MATERIALOGRAPHY",
        label="Analytical Sciences: Structure analysis and materialography",
        description="""Analytical Sciences: Structure analysis and materialography//Analytical Sciences: Strukturanalytik und Materialographie""",
    )

    anal_sci_surface_and_interface_analysis = VocabularyTerm(
        code="ANAL_SCI_SURFACE_AND_INTERFACE_ANALYSIS",
        label="Analytical Sciences: Surface and interface analysis",
        description="""Analytical Sciences: Surface and interface analysis//Analytical Sciences: Oberflächen- und Grenzflächenanalytik""",
    )

    central_services_cross_sectional_tasks = VocabularyTerm(
        code="CENTRAL_SERVICES_CROSS_SECTIONAL_TASKS",
        label="Central Services: Cross-sectional tasks",
        description="""Central Services: Cross-sectional tasks//Zentrale Dienstleistungen: Querschnittsaufgaben""",
    )

    energy_electrical_energy_storage = VocabularyTerm(
        code="ENERGY_ELECTRICAL_ENERGY_STORAGE",
        label="Energy: Electrical energy storage (Priority Theme)",
        description="""Energy: Electrical energy storage (Priority Theme)//Energie: Elektrische Energiespeicher (EES) (Schwerpunktthema)""",
    )

    energy_electrical_energy_storage_and_conversion = VocabularyTerm(
        code="ENERGY_ELECTRICAL_ENERGY_STORAGE_AND_CONVERSION",
        label="Energy: Electrical energy storage and conversion",
        description="""Energy: Electrical energy storage and conversion//Energie: Elektrische Energiespeicher und -umwandlung""",
    )

    energy_h2_safety_at_bam = VocabularyTerm(
        code="ENERGY_H2_SAFETY_AT_BAM",
        label="Energy: H2Safety@BAM (Priority Theme)",
        description="""Energy: H2Safety@BAM (Priority Theme)//Energie: H2Safety@BAM (Schwerpunktthema)""",
    )

    energy_hydrogen = VocabularyTerm(
        code="ENERGY_HYDROGEN",
        label="Energy: Hydrogen",
        description="""Energy: Hydrogen//Energie: Wasserstoff""",
    )

    energy_radioactive_waste_disposal = VocabularyTerm(
        code="ENERGY_RADIOACTIVE_WASTE_DISPOSAL",
        label="Energy: Radioactive waste disposal",
        description="""Energy: Radioactive waste disposal//Energie: Kerntechnische Entsorgung""",
    )

    energy_wind_at_bam = VocabularyTerm(
        code="ENERGY_WIND_AT_BAM",
        label="Energy: Wind@BAM (Priority Theme)",
        description="""Energy: Wind@BAM (Priority Theme)//Energie: Wind@BAM (Schwerpunktthema)""",
    )

    energy_wind_energy = VocabularyTerm(
        code="ENERGY_WIND_ENERGY",
        label="Energy: Wind energy",
        description="""Energy: Wind energy//Energie: Windenergie""",
    )

    env_behaviour_of_materials_and_products_in_the_env = VocabularyTerm(
        code="ENV_BEHAVIOUR_OF_MATERIALS_AND_PRODUCTS_IN_THE_ENV",
        label="Environment: Behaviour of materials and products in the environment",
        description="""Environment: Behaviour of materials and products in the environment//Umwelt: Umweltverhalten von Materialien und Produkten""",
    )

    env_environmental_pollutants = VocabularyTerm(
        code="ENV_ENVIRONMENTAL_POLLUTANTS",
        label="Environment: Environmental pollutants",
        description="""Environment: Environmental pollutants//Umwelt: Umweltschadstoffe""",
    )

    env_microbiologically_influenced_corrosion = VocabularyTerm(
        code="ENV_MICROBIOLOGICALLY_INFLUENCED_CORROSION",
        label="Environment: Microbiologically influenced corrosion (Priority Theme)",
        description="""Environment: Microbiologically influenced corrosion (Priority Theme)//Umwelt: Mikrobiell induzierte Korrosion (MIC) (Schwerpunktthema)""",
    )

    env_resource_recovery_and_material_recycling = VocabularyTerm(
        code="ENV_RESOURCE_RECOVERY_AND_MATERIAL_RECYCLING",
        label="Environment: Resource recovery and material recycling",
        description="""Environment: Resource recovery and material recycling//Umwelt: Ressourcenrückgewinnung und Materialverwertung""",
    )

    infra_fire_science = VocabularyTerm(
        code="INFRA_FIRE_SCIENCE",
        label="Infrastructure: ‌Fire Science",
        description="""Infrastructure: ‌Fire Science//Infrastruktur: Fire Science""",
    )

    infra_safety_and_life_cycle_of_structures = VocabularyTerm(
        code="INFRA_SAFETY_AND_LIFE_CYCLE_OF_STRUCTURES",
        label="Infrastructure: Safety and life cycle of structures",
        description="""Infrastructure: Safety and life cycle of structures//Infrastruktur: Sicherheit und Lebensdauer von Bauwerken""",
    )

    infra_safety_of_industrial_fac_and_traffic_routes = VocabularyTerm(
        code="INFRA_SAFETY_OF_INDUSTRIAL_FAC_AND_TRAFFIC_ROUTES",
        label="Infrastructure: Safety of industrial facilities and traffic routes",
        description="""Infrastructure: Safety of industrial facilities and traffic routes//Infrastruktur: Sicherheit von Industrieanlagen und Verkehrswegen""",
    )

    infra_security = VocabularyTerm(
        code="INFRA_SECURITY",
        label="Infrastructure: ‌Security",
        description="""Infrastructure: ‌Security//Infrastruktur: Security""",
    )

    infra_transport_and_stor_of_danger_subst_and_goods = VocabularyTerm(
        code="INFRA_TRANSPORT_AND_STOR_OF_DANGER_SUBST_AND_GOODS",
        label="Infrastructure: Transport and storage of dangerous substances and goods",
        description="""Infrastructure: Transport and storage of dangerous substances and goods//Infrastruktur: Transport und Lagerung von Gefahrstoffen und -gütern""",
    )

    infra_transport_infrastructures = VocabularyTerm(
        code="INFRA_TRANSPORT_INFRASTRUCTURES",
        label="Infrastructure: Transport Infrastructures (Priority Theme)",
        description="""Infrastructure: Transport Infrastructures (Priority Theme)//Infrastruktur: Verkehrsinfrastrukturen (Schwerpunktthema)""",
    )

    material_additive_manufacturing = VocabularyTerm(
        code="MATERIAL_ADDITIVE_MANUFACTURING",
        label="Material: Additive Manufacturing",
        description="""Material: Additive Manufacturing//Material: Additive Fertigung""",
    )

    material_am_at_bam = VocabularyTerm(
        code="MATERIAL_AM_AT_BAM",
        label="Material: AM@BAM (Priority Theme)",
        description="""Material: AM@BAM (Priority Theme)//Material: AM@BAM (Schwerpunktthema)""",
    )

    material_degradation_and_life_cycle_of_materials = VocabularyTerm(
        code="MATERIAL_DEGRADATION_AND_LIFE_CYCLE_OF_MATERIALS",
        label="Material: Characterization of advanced materials and substances",
        description="""Material: Characterization of advanced materials and substances//Material: Charakterisierung neuer Materialien und Stoffe""",
    )

    material_materials_and_substances = VocabularyTerm(
        code="MATERIAL_MATERIALS_AND_SUBSTANCES",
        label="Material: Degradation and life cycle of materials",
        description="""Material: Degradation and life cycle of materials//Material: Degradation und Life Cycle von Werkstoffen und Materialien""",
    )

    material_material_design = VocabularyTerm(
        code="MATERIAL_MATERIAL_DESIGN",
        label="Material: Material design",
        description="""Material: Material design//Material: Materialdesign""",
    )

    material_nano_at_bam = VocabularyTerm(
        code="MATERIAL_NANO_AT_BAM",
        label="Material: Nano@BAM",
        description="""Material: Nano@BAM//Material: Nano@BAM""",
    )


class BamFocusArea(VocabularyType):
    defs = VocabularyTypeDef(
        code="BAM_FOCUS_AREA",
        description="""BAM Focus Area//BAM Themenfeld""",
    )

    chemistry_and_process_engineering = VocabularyTerm(
        code="CHEMISTRY_AND_PROCESS_ENGINEERING",
        label="Chemistry and Process Engineering",
        description="""Chemistry and Process Engineering//Chemie und Prozesstechnik""",
    )

    energy = VocabularyTerm(
        code="ENERGY",
        label="Energy",
        description="""Energy//Energie""",
    )

    environment = VocabularyTerm(
        code="ENVIRONMENT",
        label="Environment",
        description="""Environment//Umwelt""",
    )

    infrastructure = VocabularyTerm(
        code="INFRASTRUCTURE",
        label="Infrastructure",
        description="""Infrastructure//Infrastruktur""",
    )

    materials = VocabularyTerm(
        code="MATERIALS",
        label="Materials",
        description="""Materials//Material""",
    )


class BravaisLattice(VocabularyType):
    defs = VocabularyTypeDef(
        code="BRAVAIS_LATTICE",
        description="""Bravais lattice//Bravais-Gitter""",
    )

    base_monoclinic = VocabularyTerm(
        code="BASE_MONOCLINIC",
        label="Base-Centered Monoclinic",
        description="""Base-centered monoclinic//Monoklin-basisflächenzentriert""",
    )

    base_orthormb = VocabularyTerm(
        code="BASE_ORTHORMB",
        label="Base-Centered Orthorhombic",
        description="""Base-centered orthorhombic//Orthorhombisch-basisflächenzentriert""",
    )

    body_center_cubic = VocabularyTerm(
        code="BODY_CENTER_CUBIC",
        label="Body-Centered Cubic (BCC)",
        description="""Body-centered cubic (BCC)//Kubisch-raumzentriert""",
    )

    body_center_tetra = VocabularyTerm(
        code="BODY_CENTER_TETRA",
        label="Body-Centered Tetragonal (BCT)",
        description="""Body-centered tetragonal (BCT)//Tetragonal-raumzentriert""",
    )

    body_orthormb = VocabularyTerm(
        code="BODY_ORTHORMB",
        label="Body-centered Orthorhombic",
        description="""Body-centered orthorhombic//Orthorhombisch-raumzentriert""",
    )

    face_center_cubic = VocabularyTerm(
        code="FACE_CENTER_CUBIC",
        label="Face-Centered Cubic (FCC)",
        description="""Face-centered cubic (FCC)//Kubisch-flächenzentriert""",
    )

    face_orthormb = VocabularyTerm(
        code="FACE_ORTHORMB",
        label="Face-Centered Orthorhombic",
        description="""Face-centered orthorhombic//Orthorhombisch-flächenzentriert""",
    )

    hex_close_pack = VocabularyTerm(
        code="HEX_CLOSE_PACK",
        label="Hexagonal Close Packed (HCP)",
        description="""Hexagonal close packed (HCP)//Hexagonal dicht gepackt""",
    )

    rhombohedral = VocabularyTerm(
        code="RHOMBOHEDRAL",
        label="Rhombohedral",
        description="""Rhombohedral//Rhomboedrisch""",
    )

    simple_cubic = VocabularyTerm(
        code="SIMPLE_CUBIC",
        label="Simple Cubic (SC)",
        description="""Simple cubic (SC)//Kubisch-primitiv""",
    )

    simple_monoclinic = VocabularyTerm(
        code="SIMPLE_MONOCLINIC",
        label="Simple Monoclinic",
        description="""Simple monoclinic//Monoklin-primitiv""",
    )

    simple_orthormb = VocabularyTerm(
        code="SIMPLE_ORTHORMB",
        label="Simple Orthorhombic",
        description="""Simple orthorhombic//Orthorhombisch-primitiv""",
    )

    simple_tetra = VocabularyTerm(
        code="SIMPLE_TETRA",
        label="Simple Tetragonal",
        description="""Simple tetragonal//Tetragonal-primitiv""",
    )

    triclinic = VocabularyTerm(
        code="TRICLINIC",
        label="Triclinic",
        description="""Triclinic//Triklin""",
    )


class BuildingMaterialType(VocabularyType):
    defs = VocabularyTypeDef(
        code="BUILDING_MATERIAL_TYPE",
        description="""Building Material Type//Baustofftyp""",
    )

    bituminous = VocabularyTerm(
        code="BITUMINOUS",
        label="Bituminous Material",
        description="""Bituminous Material//Bituminöses Material""",
    )

    mineral = VocabularyTerm(
        code="MINERAL",
        label="Mineral Material",
        description="""Mineral Material//Mineralischer Baustoff""",
    )

    plastic = VocabularyTerm(
        code="PLASTIC",
        label="Plastic Material",
        description="""Plastic Material//Kunststoff""",
    )

    wood = VocabularyTerm(
        code="WOOD",
        label="Wood-based Material",
        description="""Wood-based Material//Holzwerkstoff""",
    )


class CalibrationProvider(VocabularyType):
    defs = VocabularyTypeDef(
        code="CALIBRATION_PROVIDER",
        description="""Calibration provider//Kalibrierdienstleister""",
    )

    bam_fb8_1 = VocabularyTerm(
        code="BAM_FB8_1",
        label="BAM FB 8.1",
        description="""BAM FB 8.1""",
    )

    mpa_kalibrierdienst_gmbh = VocabularyTerm(
        code="MPA_KALIBRIERDIENST_GMBH",
        label="MPA Kalibrierdienst GmbH",
        description="""MPA Kalibrierdienst GmbH""",
    )


class CameraShutterMode(VocabularyType):
    defs = VocabularyTypeDef(
        code="CAMERA_SHUTTER_MODE",
        description="""Shutter modes of digital cameras//Belichtungsmodi digitaler Bildsensoren""",
    )

    camera_shutter_global = VocabularyTerm(
        code="CAMERA_SHUTTER_GLOBAL",
        label="global shutter",
        description="""Global shutter//Global shutter""",
    )

    camera_shutter_rolling = VocabularyTerm(
        code="CAMERA_SHUTTER_ROLLING",
        label="rolling shutter",
        description="""Rolling shutter//Rolling shutter""",
    )


class ChemicalProductCategory(VocabularyType):
    defs = VocabularyTypeDef(
        code="CHEMICAL_PRODUCT_CATEGORY",
        description="""Chemical Product Category according to REACH (Registration, Evaluation, Authorisation and Restriction of Chemicals); Corresponds to field `Product Category` in BAM`s hazardous materials database sigmaBAM; Source: Guidance on Information Requirements and Chemical Safety Assessment, Chapter R.12: Use description, Version 3.0, December 2015; Link: https://echa.europa.eu/documents/10162/17224/information_requirements_r12_en.pdf//Chemische Produktkategorie nach REACH; entspricht Feld `Verwendungstypen/Produktkategorie` in der BAM Gefahrstoffdatenbank sigmaBAM; Quelle: Guidance on Information Requirements and Chemical Safety Assessment, Kapitel R.12: Use description, Version 3.0, Dezember 2015; Link: https://echa.europa.eu/documents/10162/17224/information_requirements_r12_en.pdf""",
    )

    pc0 = VocabularyTerm(
        code="PC0",
        label="PC0 Other",
        description="""PC0 Other//Sonstige""",
    )

    pc1 = VocabularyTerm(
        code="PC1",
        label="PC01 Adhesives, sealants",
        description="""PC01 Adhesives, sealants//Klebstoffe, Dichtstoffe""",
    )

    pc2 = VocabularyTerm(
        code="PC2",
        label="PC02 Adsorbents",
        description="""PC02 Adsorbents//Adsorptionsmittel""",
    )

    pc3 = VocabularyTerm(
        code="PC3",
        label="PC03 Air care products",
        description="""PC03 Air care products//Luftbehandlungsprodukte""",
    )

    pc4 = VocabularyTerm(
        code="PC4",
        label="PC04 Anti-freeze and de-icing products",
        description="""PC04 Anti-freeze and de-icing products//Frostschutz- und Enteisungsmittel""",
    )

    pc7 = VocabularyTerm(
        code="PC7",
        label="PC07 Base metals and alloys",
        description="""PC07 Base metals and alloys//Grundmetalle und Legierungen""",
    )

    pc8 = VocabularyTerm(
        code="PC8",
        label="PC08 Biocidal products",
        description="""PC08 Biocidal products//Biozidprodukte""",
    )

    pc9a = VocabularyTerm(
        code="PC9A",
        label="PC09a Coatings and paints, thinners, paint removers",
        description="""PC09a Coatings and paints, thinners, paint removers//Beschichtungen, Farben, Verdünner, Farbentf.""",
    )

    pc9b = VocabularyTerm(
        code="PC9B",
        label="PC09b Fillers, putties, plasters, modelling clay",
        description="""PC09b Fillers, putties, plasters, modelling clay//Füllstoffe, Spachtelmasse, Mörtel, Modellierton""",
    )

    pc9c = VocabularyTerm(
        code="PC9C",
        label="PC09c Finger paints",
        description="""PC09c Finger paints//Fingerfarben""",
    )

    pc11 = VocabularyTerm(
        code="PC11",
        label="PC11 Explosives",
        description="""PC11 Explosives//Sprengstoffe""",
    )

    pc12 = VocabularyTerm(
        code="PC12",
        label="PC12 Fertilisers",
        description="""PC12 Fertilisers//Düngemittel""",
    )

    pc13 = VocabularyTerm(
        code="PC13",
        label="PC13 Fuels",
        description="""PC13 Fuels//Kraftstoffe""",
    )

    pc14 = VocabularyTerm(
        code="PC14",
        label="PC14 Metal surface treatment products",
        description="""PC14 Metal surface treatment products//Produkte zur Behandlung von Metalloberflächen""",
    )

    pc15 = VocabularyTerm(
        code="PC15",
        label="PC15 Non-metal surface treatment  products",
        description="""PC15 Non-metal surface treatment  products//Produkte zur Behandlung von Nichtmetalloberflächen""",
    )

    pc16 = VocabularyTerm(
        code="PC16",
        label="PC16 Heat transfer fluids",
        description="""PC16 Heat transfer fluids//Wärmeübertragungsflüssigkeiten""",
    )

    pc17 = VocabularyTerm(
        code="PC17",
        label="PC17 Hydraulic fluids",
        description="""PC17 Hydraulic fluids//Hydraulikflüssigkeiten""",
    )

    pc18 = VocabularyTerm(
        code="PC18",
        label="PC18 Ink and toners",
        description="""PC18 Ink and toners//Tinten und Toner""",
    )

    pc20 = VocabularyTerm(
        code="PC20",
        label="PC20 Processing aids such as pH-regulators, flocculants, precipitants, neutralisation agents",
        description="""PC20 Processing aids such as pH-regulators, flocculants, precipitants, neutralisation agents//Verarbeitungshilfsstoffe wie pH-Regulatoren""",
    )

    pc21 = VocabularyTerm(
        code="PC21",
        label="PC21 Laboratory chemicals",
        description="""PC21 Laboratory chemicals//Laborchemikalien""",
    )

    pc23 = VocabularyTerm(
        code="PC23",
        label="PC23 Leather treatment products",
        description="""PC23 Leather treatment products//Produkte zur Behandlung von Leder""",
    )

    pc24 = VocabularyTerm(
        code="PC24",
        label="PC24 Lubricants, greases, release products",
        description="""PC24 Lubricants, greases, release products//Schmiermittel, Schmierfette und Trennmittel""",
    )

    pc25 = VocabularyTerm(
        code="PC25",
        label="PC25 Metal working fluids",
        description="""PC25 Metal working fluids//Metallbearbeitungsöle""",
    )

    pc26 = VocabularyTerm(
        code="PC26",
        label="PC26 Paper and board treatment products",
        description="""PC26 Paper and board treatment products//Produkte zur Behandlung von Papier, Pappe""",
    )

    pc27 = VocabularyTerm(
        code="PC27",
        label="PC27 Plant protection products",
        description="""PC27 Plant protection products//Pflanzenschutzmittel""",
    )

    pc28 = VocabularyTerm(
        code="PC28",
        label="PC28 Perfumes, fragrances",
        description="""PC28 Perfumes, fragrances//Parfüme, Duftstoffe""",
    )

    pc29 = VocabularyTerm(
        code="PC29",
        label="PC29 Pharmaceuticals",
        description="""PC29 Pharmaceuticals//Pharmazeutika""",
    )

    pc30 = VocabularyTerm(
        code="PC30",
        label="PC30 Photochemicals",
        description="""PC30 Photochemicals//Fotochemikalien""",
    )

    pc31 = VocabularyTerm(
        code="PC31",
        label="PC31 Polishes and wax blends",
        description="""PC31 Polishes and wax blends//Poliermittel und Wachsmischungen""",
    )

    pc32 = VocabularyTerm(
        code="PC32",
        label="PC32 Polymer preparations and compounds",
        description="""PC32 Polymer preparations and compounds//Polymerzubereitungen und -verbindungen""",
    )

    pc33 = VocabularyTerm(
        code="PC33",
        label="PC33 Semiconductors",
        description="""PC33 Semiconductors//Halbleiter""",
    )

    pc34 = VocabularyTerm(
        code="PC34",
        label="PC34 Textile dyes, and impregnating products",
        description="""PC34 Textile dyes, and impregnating products//Textilfarben, -appreturen, -imprägniermittel""",
    )

    pc35 = VocabularyTerm(
        code="PC35",
        label="PC35 Washing and cleaning products",
        description="""PC35 Washing and cleaning products//Wasch- und Reinigungsmittel""",
    )

    pc36 = VocabularyTerm(
        code="PC36",
        label="PC36 Water softeners",
        description="""PC36 Water softeners//Wasserenthärter""",
    )

    pc37 = VocabularyTerm(
        code="PC37",
        label="PC37 Water treatment chemicals",
        description="""PC37 Water treatment chemicals//Wasserbehandlungschemikalien""",
    )

    pc38 = VocabularyTerm(
        code="PC38",
        label="PC38 Welding and soldering products, flux products",
        description="""PC38 Welding and soldering products, flux products//Schweiß- und Lötprodukte, Flussmittel""",
    )

    pc39 = VocabularyTerm(
        code="PC39",
        label="PC39 Cosmetics, personal care products",
        description="""PC39 Cosmetics, personal care products//Kosmetika, Körperpflegeprodukte""",
    )

    pc40 = VocabularyTerm(
        code="PC40",
        label="PC40 Extraction agents",
        description="""PC40 Extraction agents//Extraktionsmittel""",
    )

    pc41 = VocabularyTerm(
        code="PC41",
        label="PC41 Oil and gas exploration or production products",
        description="""PC41 Oil and gas exploration or production products//Exploration/Förderung von Erdöl/-gas""",
    )

    pc42 = VocabularyTerm(
        code="PC42",
        label="PC42 Electrolytes for batteries",
        description="""PC42 Electrolytes for batteries//Elektrolyte für Batterien""",
    )


class DcpdPotCal(VocabularyType):
    defs = VocabularyTypeDef(
        code="DCPD_POT_CAL",
        description="""DCPD Potential Calibration Options//DCPD Potential Kalibrier-Optionen""",
    )

    fem_fit = VocabularyTerm(
        code="FEM_FIT",
        label="Finite Element Fit",
        description="""Finite Element Fit//Finite Elemente Anpassung""",
    )

    johnson = VocabularyTerm(
        code="JOHNSON",
        label="Johnson Formula",
        description="""Johnson Formula//Johnson Formel""",
    )


class DfgDeviceCode(VocabularyType):
    defs = VocabularyTypeDef(
        code="DFG_DEVICE_CODE",
        description="""DFG Device Code; Link: https://www.dfg.de/download/pdf/foerderung/programme/wgi/geraetegruppenschluessel.xlsx//DFG Gerätegruppenschlüssel (GGS); Link: https://www.dfg.de/download/pdf/foerderung/programme/wgi/geraetegruppenschluessel.xlsx""",
    )

    dfg_0000_1 = VocabularyTerm(
        code="DFG_0000_1",
        label="0000 Air-cushion tracks, tables (demonstration apparatus for mechanics)",
        description="""Air-cushion tracks, tables (demonstration apparatus for mechanics)//Luftkissen-Bahnen, -Tische (Demonstrationsgeräte für Mechanik)""",
    )

    dfg_0005_1 = VocabularyTerm(
        code="DFG_0005_1",
        label="0005 Measuring and demonstration equipment for mechanics (except 0010, 0020, 2430, 2440, 2850 and 8800-8990)",
        description="""Measuring and demonstration equipment for mechanics (except 0010, 0020, 2430, 2440, 2850 and 8800-8990)//Mess- und Demonstrationsgeräte der Mechanik (außer 0010, 0020, 2430, 2440, 2850 und 8800-8990)""",
    )

    dfg_0010_1 = VocabularyTerm(
        code="DFG_0010_1",
        label="0010 Rotating balances",
        description="""Rotating balances//Drehwaagen""",
    )

    dfg_0010_2 = VocabularyTerm(
        code="DFG_0010_2",
        label="0010 Instruments for measuring gravitational force (rotating balances, pendulum instruments, except gravimeter 0410)",
        description="""Instruments for measuring gravitational force (rotating balances, pendulum instruments, except gravimeter 0410)//Geräte zur Messung der Gravitationskraft (Drehwaagen, Pendelgeräte, außer Gravimeter 0410)""",
    )

    dfg_0010_3 = VocabularyTerm(
        code="DFG_0010_3",
        label="0010 Pendulums (except tidal pendulums 0410)",
        description="""Pendulums (except tidal pendulums 0410)//Pendelgeräte (außer Gezeitenpendel 0410)""",
    )

    dfg_0020_1 = VocabularyTerm(
        code="DFG_0020_1",
        label="0020 Gyroscopes (compass)",
        description="""Gyroscopes (compass)//Aufsetzkreisel (Kompass)""",
    )

    dfg_0020_2 = VocabularyTerm(
        code="DFG_0020_2",
        label="0020 Gyroscopes",
        description="""Gyroscopes//Gyroskope""",
    )

    dfg_0020_3 = VocabularyTerm(
        code="DFG_0020_3",
        label="0020 Gyroscopes (compasses, position regulators, control gyroscopes)",
        description="""Gyroscopes (compasses, position regulators, control gyroscopes)//Kreiselgeräte (Kompasse, Lageregler, Steuerkreisel)""",
    )

    dfg_0020_4 = VocabularyTerm(
        code="DFG_0020_4",
        label="0020 Gyro compasses",
        description="""Gyro compasses//Kreiselkompasse""",
    )

    dfg_0020_5 = VocabularyTerm(
        code="DFG_0020_5",
        label="0020 Position control (gyroscopes), horizon indicator",
        description="""Position control (gyroscopes), horizon indicator//Lageregler (Kreiselgeräte), Horizontzeiger""",
    )

    dfg_0020_6 = VocabularyTerm(
        code="DFG_0020_6",
        label="0020 Special mechanical devices, gyroscopes",
        description="""Special mechanical devices, gyroscopes//Spezielle Geräte der Mechanik, Kreiselgeräte""",
    )

    dfg_0020_7 = VocabularyTerm(
        code="DFG_0020_7",
        label="0020 Stabilised platforms (except 0480)",
        description="""Stabilised platforms (except 0480)//Stabilisierte Plattformen (außer 0480)""",
    )

    dfg_0020_8 = VocabularyTerm(
        code="DFG_0020_8",
        label="0020 Surveying gyros",
        description="""Surveying gyros//Vermessungskreisel""",
    )

    dfg_0040_1 = VocabularyTerm(
        code="DFG_0040_1",
        label="0040 Hydrophones",
        description="""Hydrophones//Hydrophone""",
    )

    dfg_0040_2 = VocabularyTerm(
        code="DFG_0040_2",
        label="0040 Throat microphones",
        description="""Throat microphones//Kehlkopfmikrofone""",
    )

    dfg_0040_3 = VocabularyTerm(
        code="DFG_0040_3",
        label="0040 Condenser microphones",
        description="""Condenser microphones//Kondensatormikrofone""",
    )

    dfg_0040_4 = VocabularyTerm(
        code="DFG_0040_4",
        label="0040 Air and body sound recorders, microphones",
        description="""Air and body sound recorders, microphones//Luft- und Körperschallaufnehmer, Mikrofone""",
    )

    dfg_0040_5 = VocabularyTerm(
        code="DFG_0040_5",
        label="0040 Measuring microphones",
        description="""Measuring microphones//Messmikrofone""",
    )

    dfg_0040_6 = VocabularyTerm(
        code="DFG_0040_6",
        label="0040 Microphone stands",
        description="""Microphone stands//Mikrofonstative""",
    )

    dfg_0040_7 = VocabularyTerm(
        code="DFG_0040_7",
        label="0040 Directional microphones",
        description="""Directional microphones//Richtmikrofone""",
    )

    dfg_0040_8 = VocabularyTerm(
        code="DFG_0040_8",
        label="0040 Vibration transducers (except 0420)",
        description="""Vibration transducers (except 0420)//Schwingungsaufnehmer, -wandler (außer 0420)""",
    )

    dfg_0040_9 = VocabularyTerm(
        code="DFG_0040_9",
        label="0040 Vibration meters, vibration monitors (airborne and structure-borne sound recorders)",
        description="""Vibration meters, vibration monitors (airborne and structure-borne sound recorders)//Schwingungsmesser, Schwingungswächter (Luft- und Körperschallaufnehmer)""",
    )

    dfg_0050_1 = VocabularyTerm(
        code="DFG_0050_1",
        label="0050 Building acoustics measuring instruments, models",
        description="""Building acoustics measuring instruments, models//Bauakustische Messgeräte, Modelle""",
    )

    dfg_0050_2 = VocabularyTerm(
        code="DFG_0050_2",
        label="0050 Real-time terc analyzers",
        description="""Real-time terc analyzers//Echtzeit-Terz-Analysatoren""",
    )

    dfg_0050_3 = VocabularyTerm(
        code="DFG_0050_3",
        label="0050 Sound spectrographs",
        description="""Sound spectrographs//Klangspektrographen""",
    )

    dfg_0050_4 = VocabularyTerm(
        code="DFG_0050_4",
        label="0050 Noise analysers (sound spectrographs)",
        description="""Noise analysers (sound spectrographs)//Lärm-Analysatoren (Schallspektrographen)""",
    )

    dfg_0050_5 = VocabularyTerm(
        code="DFG_0050_5",
        label="0050 Reverberation analysers, measuring instruments",
        description="""Reverberation analysers, measuring instruments//Nachhall-Analysatoren, -Messgeräte""",
    )

    dfg_0050_6 = VocabularyTerm(
        code="DFG_0050_6",
        label="0050 Sound spectrographs and room acoustics measuring instruments",
        description="""Sound spectrographs and room acoustics measuring instruments//Schallspektrographen und Raumakustik-Messgeräte""",
    )

    dfg_0050_7 = VocabularyTerm(
        code="DFG_0050_7",
        label="0050 Sonagraphs (sound spectrographs)",
        description="""Sonagraphs (sound spectrographs)//Sonagraphen (Klangspektrographen)""",
    )

    dfg_0050_8 = VocabularyTerm(
        code="DFG_0050_8",
        label="0050 Audio frequency spectrographs (with third octave/octave filters)",
        description="""Audio frequency spectrographs (with third octave/octave filters)//Tonfrequenzspektrographen (mit Terz/Oktav-Filtern)""",
    )

    dfg_0060_1 = VocabularyTerm(
        code="DFG_0060_1",
        label="0060 Acoustic measuring and testing instruments with accessories",
        description="""Acoustic measuring and testing instruments with accessories//Akustische Mess- und Prüfgeräte mit Zubehör""",
    )

    dfg_0060_2 = VocabularyTerm(
        code="DFG_0060_2",
        label="0060 Noise meter",
        description="""Noise meter//Geräuschmesser""",
    )

    dfg_0060_3 = VocabularyTerm(
        code="DFG_0060_3",
        label="0060 Impulse sound level meters",
        description="""Impulse sound level meters//Impulsschallpegel-Messgeräte""",
    )

    dfg_0060_4 = VocabularyTerm(
        code="DFG_0060_4",
        label="0060 Calibration devices for acoustic instruments",
        description="""Calibration devices for acoustic instruments//Kalibriergeräte für akustische Geräte""",
    )

    dfg_0060_5 = VocabularyTerm(
        code="DFG_0060_5",
        label="0060 Kundt tubes (sound absorption measurement)",
        description="""Kundt tubes (sound absorption measurement)//Kundtsche Rohre (Schallabsorptionsmessung)""",
    )

    dfg_0060_6 = VocabularyTerm(
        code="DFG_0060_6",
        label="0060 Sound meters, dosimeters",
        description="""Sound meters, dosimeters//Lärmmessgeräte, -dosimeter""",
    )

    dfg_0060_7 = VocabularyTerm(
        code="DFG_0060_7",
        label="0060 Sound meters",
        description="""Sound meters//Lautstärkemesser""",
    )

    dfg_0060_8 = VocabularyTerm(
        code="DFG_0060_8",
        label="0060 Sound meters",
        description="""Sound meters//Phonmesser""",
    )

    dfg_0060_9 = VocabularyTerm(
        code="DFG_0060_9",
        label="0060 Sound meters",
        description="""Sound meters//Schalldämmzahlmesser""",
    )

    dfg_0060_10 = VocabularyTerm(
        code="DFG_0060_10",
        label="0060 Sound pressure meters, scales",
        description="""Sound pressure meters, scales//Schalldruckmessgeräte, -waagen""",
    )

    dfg_0060_11 = VocabularyTerm(
        code="DFG_0060_11",
        label="0060 Sound velocity meters",
        description="""Sound velocity meters//Schallgeschwindigkeits-Messgeräte""",
    )

    dfg_0060_12 = VocabularyTerm(
        code="DFG_0060_12",
        label="0060 Sound level meters",
        description="""Sound level meters//Schallpegelmesser""",
    )

    dfg_0070_1 = VocabularyTerm(
        code="DFG_0070_1",
        label="0070 Acoustic vibration exciters (except 6700)",
        description="""Acoustic vibration exciters (except 6700)//Akustische Schwingungserreger (außer 6700)""",
    )

    dfg_0070_2 = VocabularyTerm(
        code="DFG_0070_2",
        label="0070 Calibration exciters for the calibration of accelerometers",
        description="""Calibration exciters for the calibration of accelerometers//Eicherreger zur Eichung von Beschleunigungsaufnehmern""",
    )

    dfg_0070_3 = VocabularyTerm(
        code="DFG_0070_3",
        label="0070 Calibration sound sources",
        description="""Calibration sound sources//Eichschallquellen""",
    )

    dfg_0070_4 = VocabularyTerm(
        code="DFG_0070_4",
        label="0070 Microphone calibrators",
        description="""Microphone calibrators//Mikrofon-Eichgeräte""",
    )

    dfg_0070_5 = VocabularyTerm(
        code="DFG_0070_5",
        label="0070 Standard hammers (impact sound measurement)",
        description="""Standard hammers (impact sound measurement)//Normhammerwerke (Trittschall-Messung)""",
    )

    dfg_0070_6 = VocabularyTerm(
        code="DFG_0070_6",
        label="0070 Sound generators and mechanical vibration exciters",
        description="""Sound generators and mechanical vibration exciters//Schallgeneratoren und mechanische Schwingungserreger""",
    )

    dfg_0070_7 = VocabularyTerm(
        code="DFG_0070_7",
        label="0070 Vibration exciters",
        description="""Vibration exciters//Schwingungserreger""",
    )

    dfg_0070_8 = VocabularyTerm(
        code="DFG_0070_8",
        label="0070 Vibration exciters",
        description="""Vibration exciters//Vibrationserreger""",
    )

    dfg_0080_1 = VocabularyTerm(
        code="DFG_0080_1",
        label="0080 Transducers (Ultrasound)",
        description="""Transducers (Ultrasound)//Schallköpfe (Ultraschall)""",
    )

    dfg_0080_2 = VocabularyTerm(
        code="DFG_0080_2",
        label="0080 Vibration crystals (ultrasound, except 6360)",
        description="""Vibration crystals (ultrasound, except 6360)//Schwingquarze (Ultraschall, außer 6360)""",
    )

    dfg_0080_3 = VocabularyTerm(
        code="DFG_0080_3",
        label="0080 Sonotrodes",
        description="""Sonotrodes//Sonotroden""",
    )

    dfg_0080_4 = VocabularyTerm(
        code="DFG_0080_4",
        label="0080 Ultrasonic receivers, measuring devices",
        description="""Ultrasonic receivers, measuring devices//Ultraschallempfänger, -messgeräte""",
    )

    dfg_0080_5 = VocabularyTerm(
        code="DFG_0080_5",
        label="0080 Ultrasonic generators, transducers and measuring instruments (except 2290, 3900 and 4120)",
        description="""Ultrasonic generators, transducers and measuring instruments (except 2290, 3900 and 4120)//Ultraschall-Generatoren, -Schwinger und -Messgeräte (außer 2290, 3900 und 4120)""",
    )

    dfg_0080_6 = VocabularyTerm(
        code="DFG_0080_6",
        label="0080 Ultrasonic interferometers (except 4120)",
        description="""Ultrasonic interferometers (except 4120)//Ultraschall-Interferometer (außer 4120)""",
    )

    dfg_0080_7 = VocabularyTerm(
        code="DFG_0080_7",
        label="0080 Ultrasonic transducers, generators, quartz crystals",
        description="""Ultrasonic transducers, generators, quartz crystals//Ultraschall-Schwinger, -Erzeuger, -Quarze""",
    )

    dfg_0080_8 = VocabularyTerm(
        code="DFG_0080_8",
        label="0080 Ultrasonic universal laboratory instruments",
        description="""Ultrasonic universal laboratory instruments//Ultraschall-Universal-Laborgeräte""",
    )

    dfg_0090_1 = VocabularyTerm(
        code="DFG_0090_1",
        label="0090 Acoustic scaffold (except 0040-0080 and 6700)",
        description="""Acoustic scaffold (except 0040-0080 and 6700)//Akustische Geräte (außer 0040-0080 und 6700)""",
    )

    dfg_0090_2 = VocabularyTerm(
        code="DFG_0090_2",
        label="0090 Camera Silens, sound-absorbing booth",
        description="""Camera Silens, sound-absorbing booth//Camera Silens, schallabsorbierende Kabine""",
    )

    dfg_0090_3 = VocabularyTerm(
        code="DFG_0090_3",
        label="0090 Filters (acoustic and mechanical), resonators",
        description="""Filters (acoustic and mechanical), resonators//Filter (akustische und mechanische), Resonatoren""",
    )

    dfg_0090_4 = VocabularyTerm(
        code="DFG_0090_4",
        label="0090 Mitre protection cabins",
        description="""Mitre protection cabins//Gehörprüfkabinen""",
    )

    dfg_0090_5 = VocabularyTerm(
        code="DFG_0090_5",
        label="0090 Mitre guards",
        description="""Mitre guards//Gehörschutzgeräte""",
    )

    dfg_0090_6 = VocabularyTerm(
        code="DFG_0090_6",
        label="0090 Reflection-free rooms (acoustic)",
        description="""Reflection-free rooms (acoustic)//Reflexionsfreie Räume (Schall)""",
    )

    dfg_0090_7 = VocabularyTerm(
        code="DFG_0090_7",
        label="0090 Resonators, acoustic",
        description="""Resonators, acoustic//Resonatoren, akustische""",
    )

    dfg_0090_8 = VocabularyTerm(
        code="DFG_0090_8",
        label="0090 Sound dampers and equipment",
        description="""Sound dampers and equipment//Schalldämpfer und -Anlagen""",
    )

    dfg_0090_9 = VocabularyTerm(
        code="DFG_0090_9",
        label="0090 Sound measuring cabins, anechoic",
        description="""Sound measuring cabins, anechoic//Schallmesskabinen, reklexionsfreie""",
    )

    dfg_0090_10 = VocabularyTerm(
        code="DFG_0090_10",
        label="0090 Sound protection devices, sound shielding, sound insulation",
        description="""Sound protection devices, sound shielding, sound insulation//Schallschutzgeräte, Schallabschirmung, -isolation""",
    )

    dfg_0090_11 = VocabularyTerm(
        code="DFG_0090_11",
        label="0090 Vibration protection devices, insulation, vibration plates",
        description="""Vibration protection devices, insulation, vibration plates//Schwingungs-Schutzmittel, -Isolation, Schwingplatten""",
    )

    dfg_0090_12 = VocabularyTerm(
        code="DFG_0090_12",
        label="0090 Other mechanical and acoustic devices (except 0000-0080)",
        description="""Other mechanical and acoustic devices (except 0000-0080)//Sonstige Geräte der Mechanik und Akustik (außer 0000-0080)""",
    )

    dfg_0100_1 = VocabularyTerm(
        code="DFG_0100_1",
        label="0100 Electromagnets",
        description="""Electromagnets//Elektromagnete""",
    )

    dfg_0100_2 = VocabularyTerm(
        code="DFG_0100_2",
        label="0100 Laboratory magnets",
        description="""Laboratory magnets//Labormagnete""",
    )

    dfg_0110_1 = VocabularyTerm(
        code="DFG_0110_1",
        label="0110 High-stability magnets (with homogeneous or special field characteristics)",
        description="""High-stability magnets (with homogeneous or special field characteristics)//Hochstabile Magnete (mit homogenem oder speziellem Feldverlauf)""",
    )

    dfg_0120_1 = VocabularyTerm(
        code="DFG_0120_1",
        label="0120 High field magnets",
        description="""High field magnets//Hochfeldmagnete""",
    )

    dfg_0120_2 = VocabularyTerm(
        code="DFG_0120_2",
        label="0120 Cryogenic magnets",
        description="""Cryogenic magnets//Kryomagnete""",
    )

    dfg_0120_3 = VocabularyTerm(
        code="DFG_0120_3",
        label="0120 Solenoid coils (superconducting)",
        description="""Solenoid coils (superconducting)//Magnetspulen (supraleitende)""",
    )

    dfg_0120_4 = VocabularyTerm(
        code="DFG_0120_4",
        label="0120 Superconducting laboratory magnets",
        description="""Superconducting laboratory magnets//Supraleitende Labormagnete""",
    )

    dfg_0130_1 = VocabularyTerm(
        code="DFG_0130_1",
        label="0130 Analysis magnets",
        description="""Analysis magnets//Analysiermagnete""",
    )

    dfg_0130_2 = VocabularyTerm(
        code="DFG_0130_2",
        label="0130 Focusing magnets for microwave tubes and electron optics",
        description="""Focusing magnets for microwave tubes and electron optics//Fokussiermagnete für Mikrowellenröhren und Elektronenoptik""",
    )

    dfg_0130_3 = VocabularyTerm(
        code="DFG_0130_3",
        label="0130 Helmholtz coils, systems",
        description="""Helmholtz coils, systems//Helmholtz-Spulen, -Systeme""",
    )

    dfg_0130_4 = VocabularyTerm(
        code="DFG_0130_4",
        label="0130 Quadrupole magnets, magnetic lenses",
        description="""Quadrupole magnets, magnetic lenses//Quadrupolmagnete, magnetische Linsen""",
    )

    dfg_0130_5 = VocabularyTerm(
        code="DFG_0130_5",
        label="0130 Switching magnets (for nuclear physics)",
        description="""Switching magnets (for nuclear physics)//Schaltmagnete (für Kernphysik)""",
    )

    dfg_0130_6 = VocabularyTerm(
        code="DFG_0130_6",
        label="0130 Special magnets (beam guiding magnets, ultrahigh field magnets, except 0100-0120 and 6830)",
        description="""Special magnets (beam guiding magnets, ultrahigh field magnets, except 0100-0120 and 6830)//Spezielle Magnete (Strahlführungsmagnete, Höchstfeldmagnete, außer 0100-0120 und 6830)""",
    )

    dfg_0140_1 = VocabularyTerm(
        code="DFG_0140_1",
        label="0140 Field meters, magnetic field meters",
        description="""Field meters, magnetic field meters//Feldstärkemessgeräte, Magnetfeldmesser""",
    )

    dfg_0140_2 = VocabularyTerm(
        code="DFG_0140_2",
        label="0140 Fluxmeters, magnetic flux meters",
        description="""Fluxmeters, magnetic flux meters//Fluxmeter, Magnetflussmesser""",
    )

    dfg_0140_3 = VocabularyTerm(
        code="DFG_0140_3",
        label="0140 Magnetometera",
        description="""Magnetometers//Gauß-Meter""",
    )

    dfg_0140_4 = VocabularyTerm(
        code="DFG_0140_4",
        label="0140 Hall-effect meters",
        description="""Hall-effect meters//Hall-Effect-Messgeräte""",
    )

    dfg_0140_5 = VocabularyTerm(
        code="DFG_0140_5",
        label="0140 Nuclear magnetometers, proton magnetometers",
        description="""Nuclear magnetometers, proton magnetometers//Kernmagnetometer, Protonenmagnetometer""",
    )

    dfg_0140_6 = VocabularyTerm(
        code="DFG_0140_6",
        label="0140 Force flux probes, magnetic current search probes",
        description="""Force flux probes, magnetic current search probes//Kraftfluss-Sonden, Magnetstrom-Suchsonden""",
    )

    dfg_0140_7 = VocabularyTerm(
        code="DFG_0140_7",
        label="0140 Magnetic field and magnetic flux meters (except geomagnetics 0400)",
        description="""Magnetic field and magnetic flux meters (except geomagnetics 0400)//Magnetfeld- und -flussmessgeräte (außer Geomagnetik 0400)""",
    )

    dfg_0140_8 = VocabularyTerm(
        code="DFG_0140_8",
        label="0140 Magnetic probes (except 4140 and 4170)",
        description="""Magnetic probes (except 4140 and 4170)//Magnetsonden (außer 4140 und 4170)""",
    )

    dfg_0140_9 = VocabularyTerm(
        code="DFG_0140_9",
        label="0140 Proton magnetometers (except 0400 for geophysics)",
        description="""Proton magnetometers (except 0400 for geophysics)//Protonen-Magnetometer (außer 0400 für Geophysik)""",
    )

    dfg_0140_10 = VocabularyTerm(
        code="DFG_0140_10",
        label="0140 SQUID devices (Superconducting Quantum Interference Device)",
        description="""SQUID devices (Superconducting Quantum Interference Device)//SQUID-Geräte (Superconducting Quantum Interference Device)""",
    )

    dfg_0140_11 = VocabularyTerm(
        code="DFG_0140_11",
        label="0140 Teslameter",
        description="""Teslameter//Teslameter""",
    )

    dfg_0150_1 = VocabularyTerm(
        code="DFG_0150_1",
        label="0150 Iron (loss) meters for electrical sheets",
        description="""Iron (loss) meters for electrical sheets//Eisen- (Verlust-) Messgeräte für Elektrobleche""",
    )

    dfg_0150_2 = VocabularyTerm(
        code="DFG_0150_2",
        label="0150 Epstein gauges",
        description="""Epstein gauges//Epstein-Messplätze""",
    )

    dfg_0150_3 = VocabularyTerm(
        code="DFG_0150_3",
        label="0150 Foner magnetometers, vibrating magnetometers",
        description="""Foner magnetometers, vibrating magnetometers//Foner-Magnetometer, Vibrations-Magnetometer""",
    )

    dfg_0150_4 = VocabularyTerm(
        code="DFG_0150_4",
        label="0150 Instruments for measuring magnetic material properties",
        description="""Instruments for measuring magnetic material properties//Geräte zur Messung der magnetischen Materialeigenschaften""",
    )

    dfg_0150_5 = VocabularyTerm(
        code="DFG_0150_5",
        label="0150 Hysteresis measuring instruments (magnetic)",
        description="""Hysteresis measuring instruments (magnetic)//Hysteresemessgeräte (magnetisch)""",
    )

    dfg_0150_6 = VocabularyTerm(
        code="DFG_0150_6",
        label="0150 Coercimeter",
        description="""Coercimeter//Koerzimeter""",
    )

    dfg_0150_7 = VocabularyTerm(
        code="DFG_0150_7",
        label="0150 Magnetic material testers",
        description="""Magnetic material testers//Magnetwerkstoff-Prüfgeräte""",
    )

    dfg_0150_8 = VocabularyTerm(
        code="DFG_0150_8",
        label="0150 Permeability meters",
        description="""Permeability meters//Permeabilitätsmessgeräte""",
    )

    dfg_0150_9 = VocabularyTerm(
        code="DFG_0150_9",
        label="0150 Susceptibility meters",
        description="""Susceptibility meters//Suszeptibilitätsmessgeräte""",
    )

    dfg_0150_10 = VocabularyTerm(
        code="DFG_0150_10",
        label="0150 Vibrating magnetometers",
        description="""Vibrating magnetometers//Vibrations-Magnetometer""",
    )

    dfg_0160_1 = VocabularyTerm(
        code="DFG_0160_1",
        label="0160 Demagnetising apparatus and devices (except for magnetic tapes 7150)",
        description="""Demagnetising apparatus and devices (except for magnetic tapes 7150)//Entmagnetisierungsgeräte und Einrichtungen (außer für Magnetbänder 7150)""",
    )

    dfg_0160_2 = VocabularyTerm(
        code="DFG_0160_2",
        label="0160 Field regulating units",
        description="""Field regulating units//Feldreguliereinheiten""",
    )

    dfg_0160_3 = VocabularyTerm(
        code="DFG_0160_3",
        label="0160 Gradient pole shoes",
        description="""Gradient pole shoes//Gradienten-Polschuhe""",
    )

    dfg_0160_4 = VocabularyTerm(
        code="DFG_0160_4",
        label="0160 Hall stabilisers, magnetic field regulators",
        description="""Hall stabilisers, magnetic field regulators//Hall-Stabilisatoren, Magnetfeldregler""",
    )

    dfg_0160_5 = VocabularyTerm(
        code="DFG_0160_5",
        label="0160 Magnetic field stabilisers",
        description="""Magnetic field stabilisers//Magnetfeld-Stabilisatoren""",
    )

    dfg_0160_6 = VocabularyTerm(
        code="DFG_0160_6",
        label="0160 Magnetising devices",
        description="""Magnetising devices//Magnetisiergeräte""",
    )

    dfg_0160_7 = VocabularyTerm(
        code="DFG_0160_7",
        label="0160 Magnetic current regulators",
        description="""Magnetic current regulators//Magnetstromregler""",
    )

    dfg_0160_8 = VocabularyTerm(
        code="DFG_0160_8",
        label="0160 Magnetic power supplies",
        description="""Magnetic power supplies//Magnetzubehör""",
    )

    dfg_0160_9 = VocabularyTerm(
        code="DFG_0160_9",
        label="0160 Power supplies for superconducting magnets",
        description="""Power supplies for superconducting magnets//Netzgeräte für supraleitende Magnete""",
    )

    dfg_0160_10 = VocabularyTerm(
        code="DFG_0160_10",
        label="0160 Pole shoes",
        description="""Pole shoes//Polschuhe""",
    )

    dfg_0160_11 = VocabularyTerm(
        code="DFG_0160_11",
        label="0160 Power supply and control devices for magnets: accessories",
        description="""Power supply and control devices for magnets: accessories//Stromversorgungs- und Steuergeräte für Magnete: Zubehör""",
    )

    dfg_0160_12 = VocabularyTerm(
        code="DFG_0160_12",
        label="0160 Superconducting switches for cryogenic magnets",
        description="""Superconducting switches for cryogenic magnets//Supraleitende Schalter für Kryomagnete""",
    )

    dfg_0190_1 = VocabularyTerm(
        code="DFG_0190_1",
        label="0190 Lifting magnets",
        description="""Lifting magnets//Lasthebe-Magnete""",
    )

    dfg_0190_2 = VocabularyTerm(
        code="DFG_0190_2",
        label="0190 Magnets, other (except 0100-0130)",
        description="""Magnets, other (except 0100-0130)//Magnete, sonstige (außer 0100-0130)""",
    )

    dfg_0190_3 = VocabularyTerm(
        code="DFG_0190_3",
        label="0190 Special magnetic measuring and experimental equipment",
        description="""Special magnetic measuring and experimental equipment//Spezielle magnetische Mess- und Versuchseinrichtungen""",
    )

    dfg_0200_1 = VocabularyTerm(
        code="DFG_0200_1",
        label="0200 Neutron sources, generators (physics)",
        description="""Neutron sources, generators (physics)//Neutronenquellen, -generatoren (Physik)""",
    )

    dfg_0200_2 = VocabularyTerm(
        code="DFG_0200_2",
        label="0200 Positron sources",
        description="""Positron sources//Positronenquellen""",
    )

    dfg_0200_3 = VocabularyTerm(
        code="DFG_0200_3",
        label="0200 Prf radiators",
        description="""Prf radiators//Prüfstrahler""",
    )

    dfg_0200_4 = VocabularyTerm(
        code="DFG_0200_4",
        label="0200 Radioactive sources (physics)",
        description="""Radioactive sources (physics)//Radioaktive Quellen (Physik)""",
    )

    dfg_0200_5 = VocabularyTerm(
        code="DFG_0200_5",
        label="0200 Radiation sources (radioisotopes, neutron sources)",
        description="""Radiation sources (radioisotopes, neutron sources)//Strahlungsquellen (Radioisotope, Neutronenquellen)""",
    )

    dfg_0210_1 = VocabularyTerm(
        code="DFG_0210_1",
        label="0210 Betatrons (Physics)",
        description="""Betatrons (Physics)//Betatrons (Physik)""",
    )

    dfg_0210_2 = VocabularyTerm(
        code="DFG_0210_2",
        label="0210 Electron accelerators",
        description="""Electron accelerators//Elektronenbeschleuniger""",
    )

    dfg_0210_3 = VocabularyTerm(
        code="DFG_0210_3",
        label="0210 Ion accelerators, heavy ion accelerators (except ion implantation facilities 0910)",
        description="""Ion accelerators, heavy ion accelerators (except ion implantation facilities 0910)//Ionenbeschleuniger, Schwerionenbeschleuniger (außer Ionenimplantationsanlagen 0910)""",
    )

    dfg_0210_4 = VocabularyTerm(
        code="DFG_0210_4",
        label="0210 Cascade accelerators",
        description="""Cascade accelerators//Kaskadenbeschleuniger""",
    )

    dfg_0210_5 = VocabularyTerm(
        code="DFG_0210_5",
        label="0210 Linear accelerator (physics)",
        description="""Linear accelerator (physics)//Linearbeschleuniger (Physik)""",
    )

    dfg_0210_6 = VocabularyTerm(
        code="DFG_0210_6",
        label="0210 Proton accelerator",
        description="""Proton accelerator//Protonen-Beschleuniger""",
    )

    dfg_0210_7 = VocabularyTerm(
        code="DFG_0210_7",
        label="0210 Synchrocyclotrons, synchrotrons",
        description="""Synchrocyclotrons, synchrotrons//Synchrozyklotrons, Synchrotrons""",
    )

    dfg_0210_8 = VocabularyTerm(
        code="DFG_0210_8",
        label="0210 Tandem accelerator",
        description="""Tandem accelerator//Tandembeschleuniger""",
    )

    dfg_0210_9 = VocabularyTerm(
        code="DFG_0210_9",
        label="0210 Particle accelerators (physics)",
        description="""Particle accelerators (physics)//Teilchenbeschleuniger (Physik)""",
    )

    dfg_0210_10 = VocabularyTerm(
        code="DFG_0210_10",
        label="0210 Van de Graaff accelerators",
        description="""Van de Graaff accelerators//Van-de-Graaff-Beschleuniger""",
    )

    dfg_0210_11 = VocabularyTerm(
        code="DFG_0210_11",
        label="0210 Cyclotrons",
        description="""Cyclotrons//Zyklotrons""",
    )

    dfg_0220_1 = VocabularyTerm(
        code="DFG_0220_1",
        label="0220 Auxiliary and auxiliary equipment for particle accelerators",
        description="""Auxiliary and auxiliary equipment for particle accelerators//Hilfs- und Ergänzungseinrichtungen für Teilchenbeschleuniger""",
    )

    dfg_0220_2 = VocabularyTerm(
        code="DFG_0220_2",
        label="0220 Target chambers for nuclear physics investigations",
        description="""Target chambers for nuclear physics investigations//Target-Kammern für kernphysikalische Untersuchungen""",
    )

    dfg_0230_1 = VocabularyTerm(
        code="DFG_0230_1",
        label="0230 Nuclear reactors",
        description="""Nuclear reactors//Kernreaktoren""",
    )

    dfg_0240_1 = VocabularyTerm(
        code="DFG_0240_1",
        label="0240 Fuel elements",
        description="""Fuel elements//Brennelemente""",
    )

    dfg_0240_2 = VocabularyTerm(
        code="DFG_0240_2",
        label="0240 Nuclear fuels, elements",
        description="""Nuclear fuels, elements//Kernbrennstoffe, -elemente""",
    )

    dfg_0240_3 = VocabularyTerm(
        code="DFG_0240_3",
        label="0240 Nuclear reactor components",
        description="""Nuclear reactor components//Kernreaktor-Komponenten""",
    )

    dfg_0240_4 = VocabularyTerm(
        code="DFG_0240_4",
        label="0240 Components, auxiliary and supplementary equipment for nuclear reactors",
        description="""Components, auxiliary and supplementary equipment for nuclear reactors//Komponenten, Hilfs- und Ergänzungseinrichtungen für Kernreaktoren""",
    )

    dfg_0240_5 = VocabularyTerm(
        code="DFG_0240_5",
        label="0240 Reactor loading and unloading equipment",
        description="""Reactor loading and unloading equipment//Reaktorlade- und -entladeeinrichtungen""",
    )

    dfg_0260_1 = VocabularyTerm(
        code="DFG_0260_1",
        label="0260 Alpha, beta measuring plots",
        description="""Alpha, beta measuring plots//Alpha-, Beta-Messplätze""",
    )

    dfg_0260_2 = VocabularyTerm(
        code="DFG_0260_2",
        label="0260 C14 measuring splints, radiation measuring splints for age determination",
        description="""C14 measuring splints, radiation measuring splints for age determination//C14 -Messplätze, Strahlungsmessplätze für Altersbestimmung""",
    )

    dfg_0260_3 = VocabularyTerm(
        code="DFG_0260_3",
        label="0260 Detector towers for radiation measurement (complete with counting electronics)",
        description="""Detector towers for radiation measurement (complete with counting electronics)//Detektorssteme für Strahlungsmessung (vollständig mit Zählelektronik)""",
    )

    dfg_0260_4 = VocabularyTerm(
        code="DFG_0260_4",
        label="0260 Digital radiation gauges",
        description="""Digital radiation gauges//Digitale Strahlungsmessplätze""",
    )

    dfg_0260_5 = VocabularyTerm(
        code="DFG_0260_5",
        label="0260 Gamma measuring splints (except 3360 and 4050)",
        description="""Gamma measuring splints (except 3360 and 4050)//Gamma-Messplätze (außer 3360 und 4050)""",
    )

    dfg_0260_6 = VocabularyTerm(
        code="DFG_0260_6",
        label="0260 Pulse height analysers (complete radiation measuring systems)",
        description="""Pulse height analysers (complete radiation measuring systems)//Impulshöhen-Analysatoren (vollständige Strahlungsmessplätze)""",
    )

    dfg_0260_7 = VocabularyTerm(
        code="DFG_0260_7",
        label="0260 Neutron measuring splints, neutron flux meters",
        description="""Neutron measuring splints, neutron flux meters//Neutronenmessplätze, -flussmesser""",
    )

    dfg_0260_8 = VocabularyTerm(
        code="DFG_0260_8",
        label="0260 Radiation meters (except 0330, 3300-3390, 4050 and 6150-6190)",
        description="""Radiation meters (except 0330, 3300-3390, 4050 and 6150-6190)//Strahlungsmessplätze (außer 0330, 3300-3390, 4050 und 6150-6190)""",
    )

    dfg_0260_9 = VocabularyTerm(
        code="DFG_0260_9",
        label="0260 Radiation meters for solid samples (alpha, beta, gamma radiation)",
        description="""Radiation meters for solid samples (alpha, beta, gamma radiation)//Strahlungsmessplätze für feste Proben (Alpha-, Beta-, Gamma-Strahlung)""",
    )

    dfg_0270_1 = VocabularyTerm(
        code="DFG_0270_1",
        label="0270 Cerenkov counter",
        description="""Cerenkov counter//Cerenkov-Zähler""",
    )

    dfg_0270_2 = VocabularyTerm(
        code="DFG_0270_2",
        label="0270 Detectors for radiation measurement, nuclear trace emulsions",
        description="""Detectors for radiation measurement, nuclear trace emulsions//Detektoren für Strahlungsmessung, Kernspuremulsionen""",
    )

    dfg_0270_3 = VocabularyTerm(
        code="DFG_0270_3",
        label="0270 Flow-through chasers (radiation detectors)",
        description="""Flow-through chasers (radiation detectors)//Durchflußzähler (Strahlungsdetektoren)""",
    )

    dfg_0270_4 = VocabularyTerm(
        code="DFG_0270_4",
        label="0270 Gamma-ray tubes",
        description="""Gamma-ray tubes//Gamma-Zählrohre""",
    )

    dfg_0270_5 = VocabularyTerm(
        code="DFG_0270_5",
        label="0270 Ge(Li) detectors",
        description="""Ge(Li) detectors//Ge(Li)-Detektoren""",
    )

    dfg_0270_6 = VocabularyTerm(
        code="DFG_0270_6",
        label="0270 Geiger-Mller tubes",
        description="""Geiger-Mller tubes//Geiger-Müller-Zählrohre""",
    )

    dfg_0270_7 = VocabularyTerm(
        code="DFG_0270_7",
        label="0270 Semiconductor-Centres (Nuclear Metrology)",
        description="""Semiconductor-Centres (Nuclear Metrology)//Halbleiter-Zähler (Nuklear-Messtechnik)""",
    )

    dfg_0270_8 = VocabularyTerm(
        code="DFG_0270_8",
        label="0270 Ionisation chambers",
        description="""Ionisation chambers//Ionisationskammern""",
    )

    dfg_0270_9 = VocabularyTerm(
        code="DFG_0270_9",
        label="0270 Methane flowmeters",
        description="""Methane flowmeters//Methandurchflusszähler""",
    )

    dfg_0270_10 = VocabularyTerm(
        code="DFG_0270_10",
        label="0270 Neutron counters, counter tubes",
        description="""Neutron counters, counter tubes//Neutronenzähler, Zählrohre""",
    )

    dfg_0270_11 = VocabularyTerm(
        code="DFG_0270_11",
        label="0270 Surface barrier layer counters",
        description="""Surface barrier layer counters//Oberflächen-Sperrschicht-Zähler""",
    )

    dfg_0270_12 = VocabularyTerm(
        code="DFG_0270_12",
        label="0270 Planar detectors",
        description="""Planar detectors//Planar-Detektoren""",
    )

    dfg_0270_13 = VocabularyTerm(
        code="DFG_0270_13",
        label="0270 Proportional counters, counter tubes",
        description="""Proportional counters, counter tubes//Proportionalzähler, -zählrohre""",
    )

    dfg_0270_14 = VocabularyTerm(
        code="DFG_0270_14",
        label="0270 Si(Li) detectors",
        description="""Si(Li) detectors//Si(Li)-Detektoren""",
    )

    dfg_0270_15 = VocabularyTerm(
        code="DFG_0270_15",
        label="0270 Fission chambers (radiation measurement)",
        description="""Fission chambers (radiation measurement)//Spaltkammern (Strahlungsmessung)""",
    )

    dfg_0270_16 = VocabularyTerm(
        code="DFG_0270_16",
        label="0270 Radiation detectors",
        description="""Radiation detectors//Strahlungsdetektoren""",
    )

    dfg_0270_17 = VocabularyTerm(
        code="DFG_0270_17",
        label="0270 Scintillation probes",
        description="""Scintillation probes//Szintillationssonden""",
    )

    dfg_0270_18 = VocabularyTerm(
        code="DFG_0270_18",
        label="0270 Scintillators, liquid, crystal, plastic, etc.",
        description="""Scintillators, liquid, crystal, plastic, etc.//Szintillatoren, Flüssigkeits-, Kristall-, Kunststoff-""",
    )

    dfg_0270_19 = VocabularyTerm(
        code="DFG_0270_19",
        label="0270 Thermoluminescence detectors, dosimeters",
        description="""Thermoluminescence detectors, dosimeters//Thermolumineszenz-Detektoren, -Dosimeter""",
    )

    dfg_0270_20 = VocabularyTerm(
        code="DFG_0270_20",
        label="0270 Zhl tubes (radiation measurement)",
        description="""Zhl tubes (radiation measurement)//Zählrohre (Strahlenmessung)""",
    )

    dfg_0280_1 = VocabularyTerm(
        code="DFG_0280_1",
        label="0280 Beta cameras (with spark chamber)",
        description="""Beta cameras (with spark chamber)//Beta-Kameras (mit Funkenkammer)""",
    )

    dfg_0280_2 = VocabularyTerm(
        code="DFG_0280_2",
        label="0280 Bubble chambers, cloud chambers, other special measuring equipment in nuclear physics",
        description="""Bubble chambers, cloud chambers, other special measuring equipment in nuclear physics//Blasenkammern, Nebelkammern, andere spezielle Messeinrichtungen der Kernphysik""",
    )

    dfg_0280_3 = VocabularyTerm(
        code="DFG_0280_3",
        label="0280 Spark chambers",
        description="""Spark chambers//Funkenkammern""",
    )

    dfg_0280_4 = VocabularyTerm(
        code="DFG_0280_4",
        label="0280 Isotope cameras (with spark chamber detector)",
        description="""Isotope cameras (with spark chamber detector)//Isotopen-Kameras (mit Funkenkammer-Detektor)""",
    )

    dfg_0280_5 = VocabularyTerm(
        code="DFG_0280_5",
        label="0280 Radiochromatogram spark chambers",
        description="""Radiochromatogram spark chambers//Radiochromatogramm-Funkenkammern""",
    )

    dfg_0310_1 = VocabularyTerm(
        code="DFG_0310_1",
        label="0310 Manipulators, remote control for hot cells",
        description="""Manipulators, remote control for hot cells//Manipulatoren, Fernbedienung für heiße Zellen""",
    )

    dfg_0320_1 = VocabularyTerm(
        code="DFG_0320_1",
        label="0320 Shielding devices (radiation protection, except 3280)",
        description="""Shielding devices (radiation protection, except 3280)//Abschirmeinrichtungen (Strahlenschutz, außer 3280)""",
    )

    dfg_0320_2 = VocabularyTerm(
        code="DFG_0320_2",
        label="0320 Fume cupboards, fume cupboards for radioisotopes",
        description="""Fume cupboards, fume cupboards for radioisotopes//Abzüge, Abzugsschränke für Radioisotope""",
    )

    dfg_0320_3 = VocabularyTerm(
        code="DFG_0320_3",
        label="0320 Lead chambers",
        description="""Lead chambers//Bleikammern""",
    )

    dfg_0320_4 = VocabularyTerm(
        code="DFG_0320_4",
        label="0320 Lead bricks, lead blocks",
        description="""Lead bricks, lead blocks//Bleiziegel, Bleibausteine""",
    )

    dfg_0320_5 = VocabularyTerm(
        code="DFG_0320_5",
        label="0320 Protective equipment (radiation protection)",
        description="""Protective equipment (radiation protection)//Schutzeinrichtungen (Strahlenschutz)""",
    )

    dfg_0320_6 = VocabularyTerm(
        code="DFG_0320_6",
        label="0320 Radiation protection, hot cells (except for radiology 3280)",
        description="""Radiation protection, hot cells (except for radiology 3280)//Strahlenschutz, heiße Zellen (außer für Radiologie 3280)""",
    )

    dfg_0330_1 = VocabularyTerm(
        code="DFG_0330_1",
        label="0330 Aerosol monitors",
        description="""Aerosol monitors//Aerosol-Monitore""",
    )

    dfg_0330_2 = VocabularyTerm(
        code="DFG_0330_2",
        label="0330 Evaluators for dose measurement",
        description="""Evaluators for dose measurement//Auswertegeräte für Dosismessung""",
    )

    dfg_0330_3 = VocabularyTerm(
        code="DFG_0330_3",
        label="0330 Curie meters",
        description="""Curie meters//Curie-Meter""",
    )

    dfg_0330_4 = VocabularyTerm(
        code="DFG_0330_4",
        label="0330 Dosimeters, dose meters (radiation monitoring)",
        description="""Dosimeters, dose meters (radiation monitoring)//Dosimeter, Dosismesser (Strahlenüberwachung)""",
    )

    dfg_0330_5 = VocabularyTerm(
        code="DFG_0330_5",
        label="0330 Dosimeter chargers",
        description="""Dosimeter chargers//Dosimeter-Ladegeräte""",
    )

    dfg_0330_6 = VocabularyTerm(
        code="DFG_0330_6",
        label="0330 Dose rate meters (dose rate)",
        description="""Dose rate meters (dose rate)//Dosisleistungs-Messgeräte (Dose-Rate)""",
    )

    dfg_0330_7 = VocabularyTerm(
        code="DFG_0330_7",
        label="0330 Incorporation monitors",
        description="""Incorporation monitors//Inkorporations-Monitore""",
    )

    dfg_0330_8 = VocabularyTerm(
        code="DFG_0330_8",
        label="0330 Isotope calibrators, calibrators",
        description="""Isotope calibrators, calibrators//Isotopen-Kalibratoren, -Eichgeräte""",
    )

    dfg_0330_9 = VocabularyTerm(
        code="DFG_0330_9",
        label="0330 Contamination monitors",
        description="""Contamination monitors//Kontaminations-Monitore""",
    )

    dfg_0330_10 = VocabularyTerm(
        code="DFG_0330_10",
        label="0330 Air (gas) monitors",
        description="""Air (gas) monitors//Luft- (Gas-) Monitore""",
    )

    dfg_0330_11 = VocabularyTerm(
        code="DFG_0330_11",
        label="0330 Neutron SEM counters",
        description="""Neutron SEM counters//Neutronen-REM-Counter""",
    )

    dfg_0330_12 = VocabularyTerm(
        code="DFG_0330_12",
        label="0330 Radiation monitoring, monitors, warning devices",
        description="""Radiation monitoring, monitors, warning devices//Strahlenüberwachung, Monitore, Warngeräte""",
    )

    dfg_0330_13 = VocabularyTerm(
        code="DFG_0330_13",
        label="0330 Pocket dosimeters",
        description="""Pocket dosimeters//Taschendosimeter""",
    )

    dfg_0350_1 = VocabularyTerm(
        code="DFG_0350_1",
        label="0350 Containers and installations for transport and storage of irradiating material",
        description="""Containers and installations for transport and storage of irradiating material//Behälter und Anlagen für Transport und Lagerung von strahlendem Material""",
    )

    dfg_0360_1 = VocabularyTerm(
        code="DFG_0360_1",
        label="0360 Nuclear fuel production and processing facilities",
        description="""Nuclear fuel production and processing facilities//Anlagen zur Gewinnung und Bearbeitung von Kernbrennstoffen""",
    )

    dfg_0360_2 = VocabularyTerm(
        code="DFG_0360_2",
        label="0360 Enrichment plants (except diffusion plants 1130, gas centrifuges 1220, separation nozzle plants 1240)",
        description="""Enrichment plants (except diffusion plants 1130, gas centrifuges 1220, separation nozzle plants 1240)//Anreicherungsanlagen (außer Diffusionsanlagen 1130, Gaszentrifugen 1220, Trenndüsenanlagen 1240)""",
    )

    dfg_0360_3 = VocabularyTerm(
        code="DFG_0360_3",
        label="0360 Isotope separation plants for nuclear fuels (except 1130, 1220, 1240 and 1400)",
        description="""Isotope separation plants for nuclear fuels (except 1130, 1220, 1240 and 1400)//Isotopen-Trennanlagen für Kernbrennstoffe (außer 1130, 1220, 1240 und 1400)""",
    )

    dfg_0370_1 = VocabularyTerm(
        code="DFG_0370_1",
        label="0370 Waste disposal installations for radioactive laboratory aids (sample bottles)",
        description="""Waste disposal installations for radioactive laboratory aids (sample bottles)//Abfallbeseitigungsgeräte für radioaktive Laborhilfsmittel (Probefläschchen)""",
    )

    dfg_0370_2 = VocabularyTerm(
        code="DFG_0370_2",
        label="0370 Facilities for the reprocessing and disposal of fuel elements",
        description="""Facilities for the reprocessing and disposal of fuel elements//Anlagen zur Aufbereitung und Entsorgung von Brennelementen""",
    )

    dfg_0370_3 = VocabularyTerm(
        code="DFG_0370_3",
        label="0370 Reprocessing Plants (Nuclear Technology)",
        description="""Reprocessing Plants (Nuclear Technology)//Wiederaufbereitungsanlagen (Kerntechnik)""",
    )

    dfg_0380_1 = VocabularyTerm(
        code="DFG_0380_1",
        label="0380 Decontamination Plants",
        description="""Decontamination Plants//Dekontaminierungsanlagen""",
    )

    dfg_0390_1 = VocabularyTerm(
        code="DFG_0390_1",
        label="0390 Isotope Generators, Batteries",
        description="""Isotope Generators, Batteries//Isotopengeneratoren, -batterien""",
    )

    dfg_0390_2 = VocabularyTerm(
        code="DFG_0390_2",
        label="0390 Other nuclear physics equipment (except 0200-0380 and 6100-6190)",
        description="""Other nuclear physics equipment (except 0200-0380 and 6100-6190)//Sonstige Geräte der Atom- und Kernphysik (außer 0200-0380 und 6100-6190)""",
    )

    dfg_0390_3 = VocabularyTerm(
        code="DFG_0390_3",
        label="0390 Radiation measuring instruments - accessories",
        description="""Radiation measuring instruments - accessories//Strahlungsmessgeräte-Zubehör""",
    )

    dfg_0400_1 = VocabularyTerm(
        code="DFG_0400_1",
        label="0400 Bussols",
        description="""Bussols//Bussolen""",
    )

    dfg_0400_2 = VocabularyTerm(
        code="DFG_0400_2",
        label="0400 Geomagnetic and geoelectric measuring instruments",
        description="""Geomagnetic and geoelectric measuring instruments//Erdmagnetische und geoelektrische Messgeräte""",
    )

    dfg_0400_3 = VocabularyTerm(
        code="DFG_0400_3",
        label="0400 Geomagnetism meters+Z(1320)S",
        description="""Geomagnetism meters+Z(1320)S//Erdmagnetismus-Messgeräte+Z(1320)S""",
    )

    dfg_0400_4 = VocabularyTerm(
        code="DFG_0400_4",
        label="0400 Field balances (magnetic)",
        description="""Field balances (magnetic)//Feldwaagen (magnetische)""",
    )

    dfg_0400_5 = VocabularyTerm(
        code="DFG_0400_5",
        label="0400 Geovariographs",
        description="""Geovariographs//Geovariographen""",
    )

    dfg_0400_6 = VocabularyTerm(
        code="DFG_0400_6",
        label="0400 Magnetic compasses",
        description="""Magnetic compasses//Magnetkompasse""",
    )

    dfg_0400_7 = VocabularyTerm(
        code="DFG_0400_7",
        label="0400 Magnetographs",
        description="""Magnetographs//Magnetographen""",
    )

    dfg_0400_8 = VocabularyTerm(
        code="DFG_0400_8",
        label="0400 Magnetometers (earth-field)",
        description="""Magnetometers (earth-field)//Magnetometer (Erdfeld-)""",
    )

    dfg_0400_9 = VocabularyTerm(
        code="DFG_0400_9",
        label="0400 Magneto-telluric measuring equipment",
        description="""Magneto-telluric measuring equipment//Magneto-Tellurik-Messanlagen""",
    )

    dfg_0400_10 = VocabularyTerm(
        code="DFG_0400_10",
        label="0400 Torsion magnetometers",
        description="""Torsion magnetometers//Torsionsmagnetometer""",
    )

    dfg_0400_11 = VocabularyTerm(
        code="DFG_0400_11",
        label="0400 Variographs, variometers (earth-magnetic)",
        description="""Variographs, variometers (earth-magnetic)//Variographen, Variometer (erdmagnetische)""",
    )

    dfg_0410_1 = VocabularyTerm(
        code="DFG_0410_1",
        label="0410 Borehole inclinometers (tidal pendulums)",
        description="""Borehole inclinometers (tidal pendulums)//Bohrloch-Neigungsmesser (Gezeiten-Pendel)""",
    )

    dfg_0410_2 = VocabularyTerm(
        code="DFG_0410_2",
        label="0410 Earth tide gravimeters, recorders",
        description="""Earth tide gravimeters, recorders//Erdgezeiten-Gravimeter, -Registrieranlagen""",
    )

    dfg_0410_3 = VocabularyTerm(
        code="DFG_0410_3",
        label="0410 Gravimeters and tidal pendulums",
        description="""Gravimeters and tidal pendulums//Gravimeter und Gezeitenpendel""",
    )

    dfg_0410_4 = VocabularyTerm(
        code="DFG_0410_4",
        label="0410 Sea gravimeters",
        description="""Sea gravimeters//Seegravimeter""",
    )

    dfg_0410_5 = VocabularyTerm(
        code="DFG_0410_5",
        label="0410 Tiltmeter (inclination of the earth's surface)",
        description="""Tiltmeter (inclination of the earth`s surface)//Tiltmeter (Neigung der Erdoberfläche)""",
    )

    dfg_0420_1 = VocabularyTerm(
        code="DFG_0420_1",
        label="0420 Geophones",
        description="""Geophones//Geophone""",
    )

    dfg_0420_2 = VocabularyTerm(
        code="DFG_0420_2",
        label="0420 Hammer-blow seismometers",
        description="""Hammer-blow seismometers//Hammerschlag-Seismometer""",
    )

    dfg_0420_3 = VocabularyTerm(
        code="DFG_0420_3",
        label="0420 Horizontal seismometer",
        description="""Horizontal seismometer//Horizontal-Seismometer""",
    )

    dfg_0420_4 = VocabularyTerm(
        code="DFG_0420_4",
        label="0420 Seismometers and instruments for blast seismology",
        description="""Seismometers and instruments for blast seismology//Seismometer und Geräte für Sprengseismik""",
    )

    dfg_0420_5 = VocabularyTerm(
        code="DFG_0420_5",
        label="0420 Vertical seismometers",
        description="""Vertical seismometers//Vertikalseismometer""",
    )

    dfg_0420_6 = VocabularyTerm(
        code="DFG_0420_6",
        label="0420 Blasting machines",
        description="""Blasting machines//Zündmaschinen für Sprengungen""",
    )

    dfg_0430_1 = VocabularyTerm(
        code="DFG_0430_1",
        label="0430 Soil samplers, earth drilling equipment (for soil sampling)",
        description="""Soil samplers, earth drilling equipment (for soil sampling)//Bodenprobennehmer, Erdbohrgeräte (für Bodenproben)""",
    )

    dfg_0430_2 = VocabularyTerm(
        code="DFG_0430_2",
        label="0430 Plungers",
        description="""Plungers//Kolbenlote""",
    )

    dfg_0430_3 = VocabularyTerm(
        code="DFG_0430_3",
        label="0430 Ram probes",
        description="""Ram probes//Rammsonden""",
    )

    dfg_0440_1 = VocabularyTerm(
        code="DFG_0440_1",
        label="0440 Special equipment for exploring the earth's surface and subsoil (except 0400-0430)",
        description="""Special equipment for exploring the earth`s surface and subsoil (except 0400-0430)//Spezielle Geräte zur Erforschung von Erdoberfläche und Untergrund (außer 0400-0430)""",
    )

    dfg_0450_1 = VocabularyTerm(
        code="DFG_0450_1",
        label="0450 Multi-probes for pressure, temperature, conductivity",
        description="""Multi-probes for pressure, temperature, conductivity//Multisonden für Druck, Temperatur, Leitfähigkeit""",
    )

    dfg_0450_2 = VocabularyTerm(
        code="DFG_0450_2",
        label="0450 Salinometer, thermometer, combined probes",
        description="""Salinometer, thermometer, combined probes//Salinometer-, Thermometer-, kombinierte Sonden""",
    )

    dfg_0450_3 = VocabularyTerm(
        code="DFG_0450_3",
        label="0450 Probes (combined) for marine research",
        description="""Probes (combined) for marine research//Sonden (kombinierte) für Meeresforschung""",
    )

    dfg_0460_1 = VocabularyTerm(
        code="DFG_0460_1",
        label="0460 Echographs",
        description="""Echographs//Echographen""",
    )

    dfg_0460_2 = VocabularyTerm(
        code="DFG_0460_2",
        label="0460 Fish magnifiers",
        description="""Fish magnifiers//Fischlupen""",
    )

    dfg_0460_3 = VocabularyTerm(
        code="DFG_0460_3",
        label="0460 Depth gauges, echo sounders, sonars",
        description="""Depth gauges, echo sounders, sonars//Meerestiefenmesser, Echolote, Sonare""",
    )

    dfg_0460_4 = VocabularyTerm(
        code="DFG_0460_4",
        label="0460 Depth meters, depth-measuring probes",
        description="""Depth meters, depth-measuring probes//Tiefenmesser, Tiefenmess-Sonden""",
    )

    dfg_0470_1 = VocabularyTerm(
        code="DFG_0470_1",
        label="0470 Current-meters (marine current)",
        description="""Current-meters (marine current)//Current-Meter (Meeresströmung)""",
    )

    dfg_0470_2 = VocabularyTerm(
        code="DFG_0470_2",
        label="0470 Pingers (underwater sounders)",
        description="""Pingers (underwater sounders)//Pinger (Unterwasser-Schallgeber)""",
    )

    dfg_0470_3 = VocabularyTerm(
        code="DFG_0470_3",
        label="0470 Profiling current meters (oceanography, except 2440)",
        description="""Profiling current meters (oceanography, except 2440)//Profilstrommesser (Ozeanographie, außer 2440)""",
    )

    dfg_0470_4 = VocabularyTerm(
        code="DFG_0470_4",
        label="0470 Current meters, special remote measuring and control devices for marine research",
        description="""Current meters, special remote measuring and control devices for marine research//Strommesser, spezielle Fernmess- und Steuergeräte für Meeresforschung""",
    )

    dfg_0480_1 = VocabularyTerm(
        code="DFG_0480_1",
        label="0480 Measuring buoys",
        description="""Measuring buoys//Messbojen""",
    )

    dfg_0480_2 = VocabularyTerm(
        code="DFG_0480_2",
        label="0480 Special vehicles, marine research equipment (except ships 2400)",
        description="""Special vehicles, marine research equipment (except ships 2400)//Spezielle Fahrzeuge, Geräteträger der Meeresforschung (außer Schiffe 2400)""",
    )

    dfg_0490_1 = VocabularyTerm(
        code="DFG_0490_1",
        label="0490 Coastal research equipment",
        description="""Coastal research equipment//Küstenforschungsgeräte""",
    )

    dfg_0490_2 = VocabularyTerm(
        code="DFG_0490_2",
        label="0490 Oceanographic measuring instruments and equipment (except 0450-0480)",
        description="""Oceanographic measuring instruments and equipment (except 0450-0480)//Ozeanographische Messgeräte und Einrichtungen (außer 0450-0480)""",
    )

    dfg_0490_3 = VocabularyTerm(
        code="DFG_0490_3",
        label="0490 Water research measuring instruments (except 0450-0480, 0510-0530 and 1000-1990)",
        description="""Water research measuring instruments (except 0450-0480, 0510-0530 and 1000-1990)//Wasserforschung, Messgeräte (außer 0450-0480, 0510-0530 und 1000-1990)""",
    )

    dfg_0490_4 = VocabularyTerm(
        code="DFG_0490_4",
        label="0490 Wave height measuring instruments (marine research)",
        description="""Wave height measuring instruments (marine research)//Wellenhöhen-Messgeräte (Meeresforschung)""",
    )

    dfg_0500_1 = VocabularyTerm(
        code="DFG_0500_1",
        label="0500 Barometers, barographs",
        description="""Barometers, barographs//Barometer, Barographen""",
    )

    dfg_0500_2 = VocabularyTerm(
        code="DFG_0500_2",
        label="0500 Altimeters (barometric), pocket altimeters",
        description="""Altimeters (barometric), pocket altimeters//Höhenmesser (barometrisch), Taschenhöhenmesser""",
    )

    dfg_0500_3 = VocabularyTerm(
        code="DFG_0500_3",
        label="0500 Hypsometers, barometric altimeters",
        description="""Hypsometers, barometric altimeters//Hypsometer, barometrische Höhenmesser""",
    )

    dfg_0500_4 = VocabularyTerm(
        code="DFG_0500_4",
        label="0500 Air pressure recorders",
        description="""Air pressure recorders//Luftdruckschreiber""",
    )

    dfg_0500_5 = VocabularyTerm(
        code="DFG_0500_5",
        label="0500 Meteorographs",
        description="""Meteorographs//Meteorographen""",
    )

    dfg_0510_1 = VocabularyTerm(
        code="DFG_0510_1",
        label="0510 Hygrometers, humidity gauges, thermohygrographs",
        description="""Hygrometers, humidity gauges, thermohygrographs//Hygrometer, Luftfeuchtemesser, Thermohygrographen""",
    )

    dfg_0510_2 = VocabularyTerm(
        code="DFG_0510_2",
        label="0510 Psychrometers (air humidity)",
        description="""Psychrometers (air humidity)//Psychrometer (Luftfeuchte)""",
    )

    dfg_0510_3 = VocabularyTerm(
        code="DFG_0510_3",
        label="0510 Dew point meter",
        description="""Dew point meter//Taupunktmesser""",
    )

    dfg_0510_4 = VocabularyTerm(
        code="DFG_0510_4",
        label="0510 Thermographs",
        description="""Thermographs//Thermographen""",
    )

    dfg_0520_1 = VocabularyTerm(
        code="DFG_0520_1",
        label="0520 Precipitation gauges, water level gauges",
        description="""Precipitation gauges, water level gauges//Niederschlagsmessgeräte, Wasserstandsmessgeräte""",
    )

    dfg_0520_2 = VocabularyTerm(
        code="DFG_0520_2",
        label="0520 Ombrometer",
        description="""Ombrometer//Ombrometer""",
    )

    dfg_0520_3 = VocabularyTerm(
        code="DFG_0520_3",
        label="0520 Gauges (water level gauges)",
        description="""Gauges (water level gauges)//Pegel (Wasserstandsmessgeräte)""",
    )

    dfg_0520_4 = VocabularyTerm(
        code="DFG_0520_4",
        label="0520 Rain gauge",
        description="""Rain gauge//Regenmesser""",
    )

    dfg_0520_5 = VocabularyTerm(
        code="DFG_0520_5",
        label="0520 Rain drop spectrometer",
        description="""Rain drop spectrometer//Regentropfenspektrometer""",
    )

    dfg_0530_1 = VocabularyTerm(
        code="DFG_0530_1",
        label="0530 Acoustic Doppler radar systems (wind vector measurement)",
        description="""Acoustic Doppler radar systems (wind vector measurement)//Akustische Dopplerradarsysteme (Windvektormessung)""",
    )

    dfg_0530_2 = VocabularyTerm(
        code="DFG_0530_2",
        label="0530 Anemometers (meteorology, except 8860)",
        description="""Anemometers (meteorology, except 8860)//Anemometer (Meteorologie, außer 8860)""",
    )

    dfg_0530_3 = VocabularyTerm(
        code="DFG_0530_3",
        label="0530 Airfoil anemometer",
        description="""Airfoil anemometer//Flügelrad-Anemometer""",
    )

    dfg_0530_4 = VocabularyTerm(
        code="DFG_0530_4",
        label="0530 Wind pressure, velocity and direction measuring instruments",
        description="""Wind pressure, velocity and direction measuring instruments//Winddruck-, -geschwindigkeits-, -richtungsmessgeräte""",
    )

    dfg_0530_5 = VocabularyTerm(
        code="DFG_0530_5",
        label="0530 Anemometers",
        description="""Anemometers//Windmessgeräte""",
    )

    dfg_0540_1 = VocabularyTerm(
        code="DFG_0540_1",
        label="0540 Actinometer",
        description="""Actinometer//Aktinometer""",
    )

    dfg_0540_2 = VocabularyTerm(
        code="DFG_0540_2",
        label="0540 Solarimeter",
        description="""Solarimeter//Solarimeter""",
    )

    dfg_0540_3 = VocabularyTerm(
        code="DFG_0540_3",
        label="0540 Sunshine meter, total radiation meter",
        description="""Sunshine meter, total radiation meter//Sonnenscheinmesser, Gesamtstrahlungsmessgeräte""",
    )

    dfg_0540_4 = VocabularyTerm(
        code="DFG_0540_4",
        label="0540 Star pyranometers",
        description="""Star pyranometers//Sternpyranometer""",
    )

    dfg_0540_5 = VocabularyTerm(
        code="DFG_0540_5",
        label="0540 Radiation balance meters",
        description="""Radiation balance meters//Strahlungsbilanzmessgeräte""",
    )

    dfg_0550_1 = VocabularyTerm(
        code="DFG_0550_1",
        label="0550 Lidar-gear, light-radar",
        description="""Lidar-gear, light-radar//Lidar-Geräte, Licht-Radar""",
    )

    dfg_0550_2 = VocabularyTerm(
        code="DFG_0550_2",
        label="0550 Visibility meters, cloud meters",
        description="""Visibility meters, cloud meters//Sichtweitemessgeräte, Wolkenmesser""",
    )

    dfg_0560_1 = VocabularyTerm(
        code="DFG_0560_1",
        label="0560 Air-electricity meters, electron density meters",
        description="""Air-electricity meters, electron density meters//Messgeräte für Luftelektrizität, Elektronendichte""",
    )

    dfg_0570_1 = VocabularyTerm(
        code="DFG_0570_1",
        label="0570 Atmospheric analysers (stations)",
        description="""Atmospheric analysers (stations)//Atmosphärische Analysatoren (-Stationen)""",
    )

    dfg_0570_2 = VocabularyTerm(
        code="DFG_0570_2",
        label="0570 Balloon weather probes",
        description="""Balloon weather probes//Ballon-Wettersonden""",
    )

    dfg_0570_3 = VocabularyTerm(
        code="DFG_0570_3",
        label="0570 Radio-probe receivers",
        description="""Radio-probe receivers//Radio-Sonden-Empfänger""",
    )

    dfg_0570_4 = VocabularyTerm(
        code="DFG_0570_4",
        label="0570 Special meteorological measuring instruments (weather probes)",
        description="""Special meteorological measuring instruments (weather probes)//Spezielle meteorologische Messgeräte (Wettersonden)""",
    )

    dfg_0570_5 = VocabularyTerm(
        code="DFG_0570_5",
        label="0570 Weather-probe radars and receivers",
        description="""Weather-probe radars and receivers//Wettersonden-Radar und Empfangsgeräte""",
    )

    dfg_0580_1 = VocabularyTerm(
        code="DFG_0580_1",
        label="0580 Ionospheric research equipment",
        description="""Ionospheric research equipment//Ionosphärenforschungs-Apparaturen""",
    )

    dfg_0580_2 = VocabularyTerm(
        code="DFG_0580_2",
        label="0580 Special measuring instruments for research into the upper atmosphere",
        description="""Special measuring instruments for research into the upper atmosphere//Spezielle Messgeräte zur Erforschung der höheren Atmosphäre""",
    )

    dfg_0590_1 = VocabularyTerm(
        code="DFG_0590_1",
        label="0590 Aerometers (air weight measurement)",
        description="""Aerometers (air weight measurement)//Aerometer (Luftgewichts-Messung)""",
    )

    dfg_0590_2 = VocabularyTerm(
        code="DFG_0590_2",
        label="0590 Evaporimeter, evaporation meter",
        description="""Evaporimeter, evaporation meter//Evaporimeter, Verdunstungsmesser""",
    )

    dfg_0590_3 = VocabularyTerm(
        code="DFG_0590_3",
        label="0590 Field stations",
        description="""Field stations//Feldstationen""",
    )

    dfg_0590_4 = VocabularyTerm(
        code="DFG_0590_4",
        label="0590 Masts for meteorological measurements, environmental and air monitoring",
        description="""Masts for meteorological measurements, environmental and air monitoring//Masten für meteorologische Messungen, für Umwelt-, Luft-Überwachung""",
    )

    dfg_0590_5 = VocabularyTerm(
        code="DFG_0590_5",
        label="0590 Meteorological instruments and accessories (except 0500-0580)",
        description="""Meteorological instruments and accessories (except 0500-0580)//Meteorologische Geräte und Zubehör (außer 0500-0580)""",
    )

    dfg_0590_6 = VocabularyTerm(
        code="DFG_0590_6",
        label="0590 Meteorological measuring stations",
        description="""Meteorological measuring stations//Meteorologische Messwarten""",
    )

    dfg_0590_7 = VocabularyTerm(
        code="DFG_0590_7",
        label="0590 Other meteorological instruments and equipment",
        description="""Other meteorological instruments and equipment//Sonstige meteorologische Geräte und Einrichtungen""",
    )

    dfg_0590_8 = VocabularyTerm(
        code="DFG_0590_8",
        label="0590 Dew scales",
        description="""Dew scales//Tauwaagen""",
    )

    dfg_0590_9 = VocabularyTerm(
        code="DFG_0590_9",
        label="0590 Thermometers",
        description="""Thermometers//Thermometerhütten""",
    )

    dfg_0590_10 = VocabularyTerm(
        code="DFG_0590_10",
        label="0590 Evaporation gauges",
        description="""Evaporation gauges//Verdunstungsmessgeräte""",
    )

    dfg_0590_11 = VocabularyTerm(
        code="DFG_0590_11",
        label="0590 Weather stations",
        description="""Weather stations//Wetterhütten""",
    )

    dfg_0600_1 = VocabularyTerm(
        code="DFG_0600_1",
        label="0600 Bussole theodolites",
        description="""Bussole theodolites//Bussolen-Theodolite""",
    )

    dfg_0600_2 = VocabularyTerm(
        code="DFG_0600_2",
        label="0600 Tachymeter-bussols",
        description="""Tachymeter-bussols//Tachymeter-Bussolen""",
    )

    dfg_0600_3 = VocabularyTerm(
        code="DFG_0600_3",
        label="0600 Theodolites, mark-separating rulers",
        description="""Theodolites, mark-separating rulers//Theodoliten, Markscheidegeräte""",
    )

    dfg_0610_1 = VocabularyTerm(
        code="DFG_0610_1",
        label="0610 Levelling instruments",
        description="""Levelling instruments//Nivellier-Instrumente""",
    )

    dfg_0620_1 = VocabularyTerm(
        code="DFG_0620_1",
        label="0620 Basic rangefinders",
        description="""Basic rangefinders//Basis-Entfernungsmesser""",
    )

    dfg_0620_2 = VocabularyTerm(
        code="DFG_0620_2",
        label="0620 Electro-optical distance meters (Geodsie)",
        description="""Electro-optical distance meters (Geodsie)//Elektrooptische Distanzmesser (Geodäsie)""",
    )

    dfg_0620_3 = VocabularyTerm(
        code="DFG_0620_3",
        label="0620 Distance measuring instruments, tachymeters, tellurometers",
        description="""Distance measuring instruments, tachymeters, tellurometers//Entfernungsmessgeräte, Tachymeter, Tellurometer""",
    )

    dfg_0620_4 = VocabularyTerm(
        code="DFG_0620_4",
        label="0620 Geodimeters",
        description="""Geodimeters//Geodimeter""",
    )

    dfg_0620_5 = VocabularyTerm(
        code="DFG_0620_5",
        label="0620 Mecometers, laser mecometers",
        description="""Mecometers, laser mecometers//Mekometer, Laser-Mekometer""",
    )

    dfg_0620_6 = VocabularyTerm(
        code="DFG_0620_6",
        label="0620 Reduction tachymeters",
        description="""Reduction tachymeters//Reduktionstachymeter""",
    )

    dfg_0620_7 = VocabularyTerm(
        code="DFG_0620_7",
        label="0620 Distance measuring instruments (geodesy)",
        description="""Distance measuring instruments (geodesy)//Streckenmessgeräte (Geodäsie)""",
    )

    dfg_0640_1 = VocabularyTerm(
        code="DFG_0640_1",
        label="0640 Equalisation devices (aerial photo evaluation)",
        description="""Equalisation devices (aerial photo evaluation)//Entzerrungsgeräte (Luftbild-Auswertung)""",
    )

    dfg_0640_2 = VocabularyTerm(
        code="DFG_0640_2",
        label="0640 Mapping instruments (except 7400 and 7450)",
        description="""Mapping instruments (except 7400 and 7450)//Kartiergeräte (außer 7400 und 7450)""",
    )

    dfg_0640_3 = VocabularyTerm(
        code="DFG_0640_3",
        label="0640 Aerial image rectifiers",
        description="""Aerial image rectifiers//Luftbildentzerrgeräte""",
    )

    dfg_0640_4 = VocabularyTerm(
        code="DFG_0640_4",
        label="0640 Orthoprojection rigs",
        description="""Orthoprojection rigs//Orthoprojektionsgeräte""",
    )

    dfg_0640_5 = VocabularyTerm(
        code="DFG_0640_5",
        label="0640 Photogrammetric scanners (except measuring chambers 5450)",
        description="""Photogrammetric scanners (except measuring chambers 5450)//Photogrammetrische Geräte (außer Messkammern 5450)""",
    )

    dfg_0640_6 = VocabularyTerm(
        code="DFG_0640_6",
        label="0640 Planigraphs",
        description="""Planigraphs//Planigraphen""",
    )

    dfg_0640_7 = VocabularyTerm(
        code="DFG_0640_7",
        label="0640 Mirror stereoscopes",
        description="""Mirror stereoscopes//Spiegelstereoskope""",
    )

    dfg_0640_8 = VocabularyTerm(
        code="DFG_0640_8",
        label="0640 Stereo evaluation systems (photogrammetry)",
        description="""Stereo evaluation systems (photogrammetry)//Stereo-Auswertesysteme (Photogrammetrie)""",
    )

    dfg_0640_9 = VocabularyTerm(
        code="DFG_0640_9",
        label="0640 Stereocomparators (photogrammetry)",
        description="""Stereocomparators (photogrammetry)//Stereokomparatoren (Photogrammetrie)""",
    )

    dfg_0640_10 = VocabularyTerm(
        code="DFG_0640_10",
        label="0640 Stereoplanigraphs",
        description="""Stereoplanigraphs//Stereoplanigraphen""",
    )

    dfg_0640_11 = VocabularyTerm(
        code="DFG_0640_11",
        label="0640 Stereoscopes",
        description="""Stereoscopes//Stereoskope""",
    )

    dfg_0650_1 = VocabularyTerm(
        code="DFG_0650_1",
        label="0650 Geographical information systems",
        description="""Geographical information systems//Geographische Informationssysteme""",
    )

    dfg_0650_2 = VocabularyTerm(
        code="DFG_0650_2",
        label="0650 Map interpretation equipment",
        description="""Map interpretation equipment//Kartenauswertungsgeräte""",
    )

    dfg_0650_3 = VocabularyTerm(
        code="DFG_0650_3",
        label="0650 Special apparatus for map production (except 0640, 2250, 2260, 7450 and 7460)",
        description="""Special apparatus for map production (except 0640, 2250, 2260, 7450 and 7460)//Spezielle Geräte zur Kartenerstellung (außer 0640, 2250, 2260, 7450 und 7460)""",
    )

    dfg_0660_1 = VocabularyTerm(
        code="DFG_0660_1",
        label="0660 Image processing equipment for remote sensing (except 0640)",
        description="""Image processing equipment for remote sensing (except 0640)//Bildverarbeitungsgeräte für Fernerkundung (außer 0640)""",
    )

    dfg_0660_2 = VocabularyTerm(
        code="DFG_0660_2",
        label="0660 Geodetic positioning systems (GPS)",
        description="""Geodetic positioning systems (GPS)//Geodätische Positions-Empfangssysteme (GPS)""",
    )

    dfg_0660_3 = VocabularyTerm(
        code="DFG_0660_3",
        label="0660 GPS systems (satellite surveying)",
        description="""GPS systems (satellite surveying)//GPS-Systeme (Satellitenvermessung)""",
    )

    dfg_0660_4 = VocabularyTerm(
        code="DFG_0660_4",
        label="0660 Cinema theodolites, potentiometer theodolites",
        description="""Cinema theodolites, potentiometer theodolites//Kino-Theodoliten, Potenziometer-Theodoliten""",
    )

    dfg_0660_5 = VocabularyTerm(
        code="DFG_0660_5",
        label="0660 Passage instruments",
        description="""Passage instruments//Passageinstrumente""",
    )

    dfg_0660_6 = VocabularyTerm(
        code="DFG_0660_6",
        label="0660 Special instruments for astronomical surveying, satellite geodesy and remote sensing",
        description="""Special instruments for astronomical surveying, satellite geodesy and remote sensing//Spezielle Geräte für astronomische Vermessung, Satellitengeodäsie und Fernerkundung""",
    )

    dfg_0670_1 = VocabularyTerm(
        code="DFG_0670_1",
        label="0670 Special geodetic and surveying equipment and superstructures",
        description="""Special geodetic and surveying equipment and superstructures//Spezielle Einrichtungen und Aufbauten für Geodäsie und Vermessungstechnik""",
    )

    dfg_0690_1 = VocabularyTerm(
        code="DFG_0690_1",
        label="0690 Borehole surveying equipment",
        description="""Borehole surveying equipment//Bohrloch-Vermessungsgeräte""",
    )

    dfg_0690_2 = VocabularyTerm(
        code="DFG_0690_2",
        label="0690 Alignment rods, marking rods",
        description="""Alignment rods, marking rods//Fluchtstäbe, Markierungsstäbe""",
    )

    dfg_0690_3 = VocabularyTerm(
        code="DFG_0690_3",
        label="0690 Geodetic surveyors",
        description="""Geodetic surveyors//Gefällemesser""",
    )

    dfg_0690_4 = VocabularyTerm(
        code="DFG_0690_4",
        label="0690 Geodetic instruments (except 0600-0680)",
        description="""Geodetic instruments (except 0600-0680)//Geodätische Geräte (außer 0600-0680)""",
    )

    dfg_0690_5 = VocabularyTerm(
        code="DFG_0690_5",
        label="0690 Hand flute knife",
        description="""Hand flute knife//Handgefällemesser""",
    )

    dfg_0690_6 = VocabularyTerm(
        code="DFG_0690_6",
        label="0690 Plumb bobs, zenith bobs, nadir bobs",
        description="""Plumb bobs, zenith bobs, nadir bobs//Lotgeräte, Zenit-, Nadirlote""",
    )

    dfg_0690_7 = VocabularyTerm(
        code="DFG_0690_7",
        label="0690 Measuring rods, measuring chains",
        description="""Measuring rods, measuring chains//Messlatten, Messketten""",
    )

    dfg_0690_8 = VocabularyTerm(
        code="DFG_0690_8",
        label="0690 Measuring tables (topography)",
        description="""Measuring tables (topography)//Messtische (Topographie)""",
    )

    dfg_0690_9 = VocabularyTerm(
        code="DFG_0690_9",
        label="0690 Clinometers (except tide gauges 0410)",
        description="""Clinometers (except tide gauges 0410)//Neigungsmesser (außer Gezeitenpendel 0410)""",
    )

    dfg_0690_10 = VocabularyTerm(
        code="DFG_0690_10",
        label="0690 Other geodetic and topographic instruments",
        description="""Other geodetic and topographic instruments//Sonstige geodätische und topographische Geräte""",
    )

    dfg_0690_11 = VocabularyTerm(
        code="DFG_0690_11",
        label="0690 Topographic instruments (except 0600-0680)",
        description="""Topographic instruments (except 0600-0680)//Topographische Geräte (außer 0600-0680)""",
    )

    dfg_0690_12 = VocabularyTerm(
        code="DFG_0690_12",
        label="0690 Surveying instruments (except 0600-0680) and accessories",
        description="""Surveying instruments (except 0600-0680) and accessories//Vermessungsgeräte (außer 0600-0680) und Zubehör""",
    )

    dfg_0690_13 = VocabularyTerm(
        code="DFG_0690_13",
        label="0690 Spirit levels, plumb bobs",
        description="""Spirit levels, plumb bobs//Wasserwaagen, Lote""",
    )

    dfg_0690_14 = VocabularyTerm(
        code="DFG_0690_14",
        label="0690 Zenith and nadir plumb bobs",
        description="""Zenith and nadir plumb bobs//Zenit- und Nadir-Lote""",
    )

    dfg_0690_15 = VocabularyTerm(
        code="DFG_0690_15",
        label="0690 Accessories for geodetic instruments",
        description="""Accessories for geodetic instruments//Zubehör zu geodätischen Instrumenten""",
    )

    dfg_0700_1 = VocabularyTerm(
        code="DFG_0700_1",
        label="0700 Cassegrain telescopes",
        description="""Cassegrain telescopes//Cassegrain-Teleskope""",
    )

    dfg_0700_2 = VocabularyTerm(
        code="DFG_0700_2",
        label="0700 Telescopes, astronomical",
        description="""Telescopes, astronomical//Fernrohre, Astronomische""",
    )

    dfg_0700_3 = VocabularyTerm(
        code="DFG_0700_3",
        label="0700 Reflectors, astronomical telescopes",
        description="""Reflectors, astronomical telescopes//Reflektoren, astronomische Teleskope""",
    )

    dfg_0700_4 = VocabularyTerm(
        code="DFG_0700_4",
        label="0700 Refractors, astronomical",
        description="""Refractors, astronomical//Refraktoren, astronomische""",
    )

    dfg_0700_5 = VocabularyTerm(
        code="DFG_0700_5",
        label="0700 Solar telescopes",
        description="""Solar telescopes//Sonnenfernrohre""",
    )

    dfg_0700_6 = VocabularyTerm(
        code="DFG_0700_6",
        label="0700 Reflecting telescopes, Schmidt mirrors",
        description="""Reflecting telescopes, Schmidt mirrors//Spiegelteleskope, Schmidt-Spiegel""",
    )

    dfg_0700_7 = VocabularyTerm(
        code="DFG_0700_7",
        label="0700 Telescopes (astronomical)",
        description="""Telescopes (astronomical)//Teleskope (astronomische)""",
    )

    dfg_0710_1 = VocabularyTerm(
        code="DFG_0710_1",
        label="0710 Mechanical and electromechanical aids for telescopes, mounts",
        description="""Mechanical and electromechanical aids for telescopes, mounts//Mechanische und elektromechanische Hilfsgeräte für Teleskope, Montierung""",
    )

    dfg_0720_1 = VocabularyTerm(
        code="DFG_0720_1",
        label="0720 Astrographs",
        description="""Astrographs//Astrographen""",
    )

    dfg_0720_2 = VocabularyTerm(
        code="DFG_0720_2",
        label="0720 Astrocameras and accessories",
        description="""Astrocameras and accessories//Astrokameras und Zubehör""",
    )

    dfg_0720_3 = VocabularyTerm(
        code="DFG_0720_3",
        label="0720 Clostats, polar clostats",
        description="""Clostats, polar clostats//Cölostaten, Polar-Cölostaten""",
    )

    dfg_0720_4 = VocabularyTerm(
        code="DFG_0720_4",
        label="0720 Telescope accessories",
        description="""Telescope accessories//Fernrohr-Zubehör""",
    )

    dfg_0720_5 = VocabularyTerm(
        code="DFG_0720_5",
        label="0720 Optical aids and accessories for telescopes",
        description="""Optical aids and accessories for telescopes//Optische Hilfsgeräte und Zubehör für Teleskope""",
    )

    dfg_0730_1 = VocabularyTerm(
        code="DFG_0730_1",
        label="0730 Electronic aids for telescopes",
        description="""Electronic aids for telescopes//Elektronische Hilfsgeräte für Teleskope""",
    )

    dfg_0740_1 = VocabularyTerm(
        code="DFG_0740_1",
        label="0740 Radio telescopes and accessories (except 6000-6990)",
        description="""Radio telescopes and accessories (except 6000-6990)//Radio-Teleskope und Zubehör (außer 6000-6990)""",
    )

    dfg_0750_1 = VocabularyTerm(
        code="DFG_0750_1",
        label="0750 Special astronomical instruments (balloon telescopes, satellite instrumentation)",
        description="""Special astronomical instruments (balloon telescopes, satellite instrumentation)//Spezielle astronomische Geräte (Ballon-Teleskope, Satelliteninstrumentierung)""",
    )

    dfg_0760_1 = VocabularyTerm(
        code="DFG_0760_1",
        label="0760 Astronomical analysers",
        description="""Astronomical analysers//Astronomische Auswertegeräte""",
    )

    dfg_0760_2 = VocabularyTerm(
        code="DFG_0760_2",
        label="0760 Star photometer",
        description="""Star photometer//Sternphotometer""",
    )

    dfg_0790_1 = VocabularyTerm(
        code="DFG_0790_1",
        label="0790 Astronomical instruments and auxiliary equipment (except 0700-0760)",
        description="""Astronomical instruments and auxiliary equipment (except 0700-0760)//Astronomische Geräte und Hilfseinrichtungen (außer 0700-0760)""",
    )

    dfg_0790_2 = VocabularyTerm(
        code="DFG_0790_2",
        label="0790 Other astronomical instruments",
        description="""Other astronomical instruments//Sonstige astronomische Geräte""",
    )

    dfg_0800_1 = VocabularyTerm(
        code="DFG_0800_1",
        label="0800 Mssbauer drives, control devices, functions, generators",
        description="""Mssbauer drives, control devices, functions, generators//Mössbauer-Antriebe, -Regelungsgeräte, -Funktionen, -Generatoren""",
    )

    dfg_0800_2 = VocabularyTerm(
        code="DFG_0800_2",
        label="0800 Mssbauer measuring instruments",
        description="""Mssbauer measuring instruments//Mössbauer-Messplätze""",
    )

    dfg_0810_1 = VocabularyTerm(
        code="DFG_0810_1",
        label="0810 Neutron spectrometers, neutron diffraction equipment",
        description="""Neutron spectrometers, neutron diffraction equipment//Neutronenspektrometer, Neutronenbeugungsanlagen""",
    )

    dfg_0850_1 = VocabularyTerm(
        code="DFG_0850_1",
        label="0850 Diamond presses, high-pressure presses (except 4020, high-pressure X-ray cameras)",
        description="""Diamond presses, high-pressure presses (except 4020, high-pressure X-ray cameras)//Diamantpressen, -Hochdruckpressen (außer 4020, Hochdruck-Röntgenkameras)""",
    )

    dfg_0850_2 = VocabularyTerm(
        code="DFG_0850_2",
        label="0850 High-pressure presses, tetrahedron presses",
        description="""High-pressure presses, tetrahedron presses//Höchstdruckpressen, Tetraederpressen""",
    )

    dfg_0900_1 = VocabularyTerm(
        code="DFG_0900_1",
        label="0900 Hadron spectrometers",
        description="""Hadron spectrometers//Hadronen-Spektrometer""",
    )

    dfg_0900_2 = VocabularyTerm(
        code="DFG_0900_2",
        label="0900 High-energy spectrometers",
        description="""High-energy spectrometers//Hochenergie-Spektrometer""",
    )

    dfg_0910_1 = VocabularyTerm(
        code="DFG_0910_1",
        label="0910 Electron beam lithography systems",
        description="""Electron beam lithography systems//Elektronenstrahl-Lithographie-Systeme""",
    )

    dfg_0910_2 = VocabularyTerm(
        code="DFG_0910_2",
        label="0910 Epitaxy systems",
        description="""Epitaxy systems//Epitaxie-Anlagen""",
    )

    dfg_0910_3 = VocabularyTerm(
        code="DFG_0910_3",
        label="0910 Ion implantation and semiconductor doping equipment",
        description="""Ion implantation and semiconductor doping equipment//Geräte für Ionenimplantation und Halbleiterdotierung""",
    )

    dfg_0910_4 = VocabularyTerm(
        code="DFG_0910_4",
        label="0910 X-ray lithography systems",
        description="""X-ray lithography systems//Röntgen-Lithographie-Systeme""",
    )

    dfg_0920_1 = VocabularyTerm(
        code="DFG_0920_1",
        label="0920 Atomic and molecular beam equipment",
        description="""Atomic and molecular beam equipment//Atom- und Molekularstrahl-Apparaturen""",
    )

    dfg_0920_2 = VocabularyTerm(
        code="DFG_0920_2",
        label="0920 MOCVD equipment (molecular beam deposition)",
        description="""MOCVD equipment (molecular beam deposition)//MOCVD-Anlagen (Molekularstrahl-Beschichtung)""",
    )

    dfg_0920_3 = VocabularyTerm(
        code="DFG_0920_3",
        label="0920 PECVD (Plasma Emission Coating) equipment",
        description="""PECVD (Plasma Emission Coating) equipment//PECVD-Anlagen (Plasma-Emissions-Beschichtung)""",
    )

    dfg_0930_1 = VocabularyTerm(
        code="DFG_0930_1",
        label="0930 Mask alignment and mask exposure equipment, mask aligners for semiconductor technology",
        description="""Mask alignment and mask exposure equipment, mask aligners for semiconductor technology//Maskenjustier-, Maskenbelichtungs-Anlagen, Mask Aligner für Halbleitertechnologie""",
    )

    dfg_0930_2 = VocabularyTerm(
        code="DFG_0930_2",
        label="0930 Special optical equipment for semiconductor technology",
        description="""Special optical equipment for semiconductor technology//Optische Spezialgeräte für Halbleitertechnologie""",
    )

    dfg_0930_3 = VocabularyTerm(
        code="DFG_0930_3",
        label="0930 Special equipment for semiconductor process technology",
        description="""Special equipment for semiconductor process technology//Spezialgeräte der Halbleiterprozesstechnik""",
    )

    dfg_1000_1 = VocabularyTerm(
        code="DFG_1000_1",
        label="1000 Magnetic stirrers",
        description="""Magnetic stirrers//Magnetrührer""",
    )

    dfg_1000_2 = VocabularyTerm(
        code="DFG_1000_2",
        label="1000 Mixers, stirrers, kneaders",
        description="""Mixers, stirrers, kneaders//Mischer, Rührer, Kneter""",
    )

    dfg_1000_3 = VocabularyTerm(
        code="DFG_1000_3",
        label="1000 Mixing turbines",
        description="""Mixing turbines//Mischturbinen""",
    )

    dfg_1000_4 = VocabularyTerm(
        code="DFG_1000_4",
        label="1000 Mixing stands",
        description="""Mixing stands//Rührstative""",
    )

    dfg_1000_5 = VocabularyTerm(
        code="DFG_1000_5",
        label="1000 Mixers, stirrers, kneaders",
        description="""Mixers, stirrers, kneaders//Rührwerke, Rührmotore""",
    )

    dfg_1010_1 = VocabularyTerm(
        code="DFG_1010_1",
        label="1010 Grinding, grating, cutting and shredding machines",
        description="""Grinding, grating, cutting and shredding machines//Zerkleinerungsgeräte, Reib-, Schneide- und Schnitzel-Maschinen""",
    )

    dfg_1020_1 = VocabularyTerm(
        code="DFG_1020_1",
        label="1020 Jaw crushers",
        description="""Jaw crushers//Backenbrecher""",
    )

    dfg_1020_2 = VocabularyTerm(
        code="DFG_1020_2",
        label="1020 Ball mills",
        description="""Ball mills//Kugelmühlen""",
    )

    dfg_1020_3 = VocabularyTerm(
        code="DFG_1020_3",
        label="1020 Mrser, Mrsermills",
        description="""Mrser, Mrsermills//Mörser, Mörsermühlen""",
    )

    dfg_1020_4 = VocabularyTerm(
        code="DFG_1020_4",
        label="1020 Mills",
        description="""Mills//Mühlen""",
    )

    dfg_1020_5 = VocabularyTerm(
        code="DFG_1020_5",
        label="1020 Vibrating disc mills",
        description="""Vibrating disc mills//Scheibenschwingmühlen""",
    )

    dfg_1020_6 = VocabularyTerm(
        code="DFG_1020_6",
        label="1020 Beater mills",
        description="""Beater mills//Schlagmühlen""",
    )

    dfg_1020_7 = VocabularyTerm(
        code="DFG_1020_7",
        label="1020 Vibrating Mills",
        description="""Vibrating Mills//Schwingmühlen""",
    )

    dfg_1020_8 = VocabularyTerm(
        code="DFG_1020_8",
        label="1020 Roller crushers",
        description="""Roller crushers//Walzenbrecher""",
    )

    dfg_1020_9 = VocabularyTerm(
        code="DFG_1020_9",
        label="1020 Centrifugal Mills, Ultra Centrifugal Mills",
        description="""Centrifugal Mills, Ultra Centrifugal Mills//Zentrifugal-Mühlen, Ultra-Zentrifugalmühlen""",
    )

    dfg_1040_1 = VocabularyTerm(
        code="DFG_1040_1",
        label="1040 Aerosol generators",
        description="""Aerosol generators//Aerosol-Generatoren""",
    )

    dfg_1040_2 = VocabularyTerm(
        code="DFG_1040_2",
        label="1040 Dusting plants (for rubber and plastics)",
        description="""Dusting plants (for rubber and plastics)//Bestäubungsanlagen (für Gummi und Kunststoffe)""",
    )

    dfg_1040_3 = VocabularyTerm(
        code="DFG_1040_3",
        label="1040 Disintegrators",
        description="""Disintegrators//Desintegratoren""",
    )

    dfg_1040_4 = VocabularyTerm(
        code="DFG_1040_4",
        label="1040 Dispersers, atomisers, homogenisers",
        description="""Dispersers, atomisers, homogenisers//Dispergierer, Zerstäuber, Homogenisatoren""",
    )

    dfg_1040_5 = VocabularyTerm(
        code="DFG_1040_5",
        label="1040 Emulsifiers, emulsifying equipment",
        description="""Emulsifiers, emulsifying equipment//Emulgatoren, Emulgiergeräte""",
    )

    dfg_1040_6 = VocabularyTerm(
        code="DFG_1040_6",
        label="1040 Ultrasonic disintegrators",
        description="""Ultrasonic disintegrators//Ultraschall-Desintegratoren""",
    )

    dfg_1040_7 = VocabularyTerm(
        code="DFG_1040_7",
        label="1040 Ultrasonic foggers",
        description="""Ultrasonic foggers//Ultraschall-Nebler""",
    )

    dfg_1040_8 = VocabularyTerm(
        code="DFG_1040_8",
        label="1040 Foggers",
        description="""Foggers//Vernebelungsgeräte""",
    )

    dfg_1060_1 = VocabularyTerm(
        code="DFG_1060_1",
        label="1060 Dilutors, pipetting devices, samplers",
        description="""Dilutors, pipetting devices, samplers//Dilutoren, Pipettiergeräte, Probennehmer""",
    )

    dfg_1060_2 = VocabularyTerm(
        code="DFG_1060_2",
        label="1060 Dispensers (except 1070)",
        description="""Dispensers (except 1070)//Dispensoren (außer 1070)""",
    )

    dfg_1060_3 = VocabularyTerm(
        code="DFG_1060_3",
        label="1060 Air samplers",
        description="""Air samplers//Luftprobennehmer""",
    )

    dfg_1060_4 = VocabularyTerm(
        code="DFG_1060_4",
        label="1060 Microsampler",
        description="""Microsampler//Mikrosampler""",
    )

    dfg_1060_5 = VocabularyTerm(
        code="DFG_1060_5",
        label="1060 Samplers (except soil samples 0430 or hydrobiological 4440)",
        description="""Samplers (except soil samples 0430 or hydrobiological 4440)//Probennehmer (außer Bodenproben 0430 oder hydrobiologische 4440)""",
    )

    dfg_1060_6 = VocabularyTerm(
        code="DFG_1060_6",
        label="1060 Sample dividers, laboratory sample dividers",
        description="""Sample dividers, laboratory sample dividers//Probenteiler, Laborprobenteiler""",
    )

    dfg_1060_7 = VocabularyTerm(
        code="DFG_1060_7",
        label="1060 Dilution apparatus, automatic dilution apparatus",
        description="""Dilution apparatus, automatic dilution apparatus//Verdünnungsgeräte, -automaten""",
    )

    dfg_1070_1 = VocabularyTerm(
        code="DFG_1070_1",
        label="1070 Calibration gas generators and mixers",
        description="""Calibration gas generators and mixers//Eichgasgeber und -mischer""",
    )

    dfg_1070_2 = VocabularyTerm(
        code="DFG_1070_2",
        label="1070 Humidity generators (calibration gas with defined humidity)",
        description="""Humidity generators (calibration gas with defined humidity)//Feuchtigkeitsgeneratoren (Eichgas mit definierter Feuchtigkeit)""",
    )

    dfg_1070_3 = VocabularyTerm(
        code="DFG_1070_3",
        label="1070 Gas mixing and dosing devices, calibration gas generators",
        description="""Gas mixing and dosing devices, calibration gas generators//Gasmisch- und Dosiergeräte, Eichgasgeber""",
    )

    dfg_1070_4 = VocabularyTerm(
        code="DFG_1070_4",
        label="1070 Gas mixing pumps (except ventilation pumps 3700)",
        description="""Gas mixing pumps (except ventilation pumps 3700)//Gasmischpumpen (außer Beatmungspumpen 3700)""",
    )

    dfg_1070_5 = VocabularyTerm(
        code="DFG_1070_5",
        label="1070 Gradient formers and mixers, dosing devices",
        description="""Gradient formers and mixers, dosing devices//Gradientenformer und -mischer, Dosiergeräte""",
    )

    dfg_1070_6 = VocabularyTerm(
        code="DFG_1070_6",
        label="1070 Gradient pumps",
        description="""Gradient pumps//Gradientenpumpen""",
    )

    dfg_1070_7 = VocabularyTerm(
        code="DFG_1070_7",
        label="1070 Feeding troughs (dosing devices)",
        description="""Feeding troughs (dosing devices)//Zuteilrinnen (Dosiergeräte)""",
    )

    dfg_1080_1 = VocabularyTerm(
        code="DFG_1080_1",
        label="1080 Incubation shutter",
        description="""Incubation shutter//Inkubationsschüttler""",
    )

    dfg_1080_2 = VocabularyTerm(
        code="DFG_1080_2",
        label="1080 Slurry shakers",
        description="""Slurry shakers//Längsschüttelmaschinen""",
    )

    dfg_1080_3 = VocabularyTerm(
        code="DFG_1080_3",
        label="1080 Round shaking machines",
        description="""Round shaking machines//Rundschüttelmaschinen""",
    )

    dfg_1080_4 = VocabularyTerm(
        code="DFG_1080_4",
        label="1080 Shaking devices, rotators",
        description="""Shaking devices, rotators//Schüttelgeräte, Rüttler""",
    )

    dfg_1080_5 = VocabularyTerm(
        code="DFG_1080_5",
        label="1080 Shaking incubators",
        description="""Shaking incubators//Schüttelinkubatoren""",
    )

    dfg_1080_6 = VocabularyTerm(
        code="DFG_1080_6",
        label="1080 Shaking thermostats",
        description="""Shaking thermostats//Schüttelthermostate""",
    )

    dfg_1080_7 = VocabularyTerm(
        code="DFG_1080_7",
        label="1080 Shaking tables",
        description="""Shaking tables//Schütteltische""",
    )

    dfg_1080_8 = VocabularyTerm(
        code="DFG_1080_8",
        label="1080 Shaking water benders, water bath shakers",
        description="""Shaking water benders, water bath shakers//Schüttelwasserbäder, Wasserbad-Schüttler""",
    )

    dfg_1080_9 = VocabularyTerm(
        code="DFG_1080_9",
        label="1080 Thermostatic shutter",
        description="""Thermostatic shutter//Thermostatschüttler""",
    )

    dfg_1080_10 = VocabularyTerm(
        code="DFG_1080_10",
        label="1080 Vibrators (laboratory, except 0070 and 2920)",
        description="""Vibrators (laboratory, except 0070 and 2920)//Vibratoren (Labor-, außer 0070 und 2920)""",
    )

    dfg_1090_1 = VocabularyTerm(
        code="DFG_1090_1",
        label="1090 Paint rubbing-out machines",
        description="""Paint rubbing-out machines//Farbenausreibemaschinen""",
    )

    dfg_1090_2 = VocabularyTerm(
        code="DFG_1090_2",
        label="1090 Lse apparatus, Lse models",
        description="""Lse apparatus, Lse models//Löseapparate, Lösemodelle""",
    )

    dfg_1090_3 = VocabularyTerm(
        code="DFG_1090_3",
        label="1090 Other mixing and crushing apparatus (except 1000-1080)",
        description="""Other mixing and crushing apparatus (except 1000-1080)//Sonstige Geräte zum Mischen und Zerkleinern (außer 1000-1080)""",
    )

    dfg_1090_4 = VocabularyTerm(
        code="DFG_1090_4",
        label="1090 Static mixers",
        description="""Static mixers//Statische Mischgeräte""",
    )

    dfg_1100_1 = VocabularyTerm(
        code="DFG_1100_1",
        label="1100 Acetylene generators",
        description="""Acetylene generators//Acetylenentwickler""",
    )

    dfg_1100_2 = VocabularyTerm(
        code="DFG_1100_2",
        label="1100 Gas containers, gasometers (unpressurised)",
        description="""Gas containers, gasometers (unpressurised)//Gasbehälter, Gasometer (drucklos)""",
    )

    dfg_1100_3 = VocabularyTerm(
        code="DFG_1100_3",
        label="1100 Gas generators, gasification plants",
        description="""Gas generators, gasification plants//Gasentwicklungsgeräte, Vergasungsanlagen""",
    )

    dfg_1100_4 = VocabularyTerm(
        code="DFG_1100_4",
        label="1100 Gas dispensers (except gas cylinders 8280)",
        description="""Gas dispensers (except gas cylinders 8280)//Gasspender (außer Gasflaschen 8280)""",
    )

    dfg_1100_5 = VocabularyTerm(
        code="DFG_1100_5",
        label="1100 Tilting apparatus",
        description="""Tilting apparatus//Kippsche Apparate""",
    )

    dfg_1100_6 = VocabularyTerm(
        code="DFG_1100_6",
        label="1100 Hydrogen developing apparatus, generators",
        description="""Hydrogen developing apparatus, generators//Wasserstoff-Entwicklungsgeräte, -Generatoren""",
    )

    dfg_1110_1 = VocabularyTerm(
        code="DFG_1110_1",
        label="1110 Flow reactors (for radiochromatography)",
        description="""Flow reactors (for radiochromatography)//Durchfluss-Reaktoren (für Radiochromatographie)""",
    )

    dfg_1110_2 = VocabularyTerm(
        code="DFG_1110_2",
        label="1110 Liquid, fixed-bed reactors",
        description="""Liquid, fixed-bed reactors//Flüssigkeits-, Festbett-Reaktoren""",
    )

    dfg_1110_3 = VocabularyTerm(
        code="DFG_1110_3",
        label="1110 Low pressure reaction vessels (hydrogenation, catalysis, polymerisation)",
        description="""Low pressure reaction vessels (hydrogenation, catalysis, polymerisation)//Reaktionsgefäße für Niederdruck, (Hydrierung, Katalyse, Polymerisation""",
    )

    dfg_1120_1 = VocabularyTerm(
        code="DFG_1120_1",
        label="1120 Flash light reaction apparatus",
        description="""Flash light reaction apparatus//Blitzlicht-Reaktionsapparaturen""",
    )

    dfg_1120_2 = VocabularyTerm(
        code="DFG_1120_2",
        label="1120 Laser reaction apparatus",
        description="""Laser reaction apparatus//Laser-Reaktionsapparaturen""",
    )

    dfg_1120_3 = VocabularyTerm(
        code="DFG_1120_3",
        label="1120 Multi-mixing systems, reaction apparatus with several chambers",
        description="""Multi-mixing systems, reaction apparatus with several chambers//Multi-Mixing-Systeme, Reaktionsapparaturen mit mehreren Kammern""",
    )

    dfg_1120_4 = VocabularyTerm(
        code="DFG_1120_4",
        label="1120 Photolysis apparatus",
        description="""Photolysis apparatus//Photolyse-Apparaturen""",
    )

    dfg_1120_5 = VocabularyTerm(
        code="DFG_1120_5",
        label="1120 Special reaction apparatus (flash, laser, photolysis, stopped flow)",
        description="""Special reaction apparatus (flash, laser, photolysis, stopped flow)//Spezielle Reaktionsapparaturen (Blitzlicht-, Laser-, Photolyse, Stopped Flow)""",
    )

    dfg_1130_1 = VocabularyTerm(
        code="DFG_1130_1",
        label="1130 Chemical dialysis equipment, diffusion equipment",
        description="""Chemical dialysis equipment, diffusion equipment//Chemische Dialysegeräte, Diffusionsanlagen""",
    )

    dfg_1130_2 = VocabularyTerm(
        code="DFG_1130_2",
        label="1130 Dialysis apparatus (chemistry)",
        description="""Dialysis apparatus (chemistry)//Dialysier-Apparate (Chemie)""",
    )

    dfg_1130_3 = VocabularyTerm(
        code="DFG_1130_3",
        label="1130 Electro-dialysis shears",
        description="""Electro-dialysis shears//Elektro-Dialyse-Geräte""",
    )

    dfg_1130_4 = VocabularyTerm(
        code="DFG_1130_4",
        label="1130 Equilibrium dialysis units",
        description="""Equilibrium dialysis units//Gleichgewichts-Dialyse-Geräte""",
    )

    dfg_1130_5 = VocabularyTerm(
        code="DFG_1130_5",
        label="1130 Osmosis shears",
        description="""Osmosis shears//Osmose-Geräte""",
    )

    dfg_1130_6 = VocabularyTerm(
        code="DFG_1130_6",
        label="1130 Permeation apparatus, general",
        description="""Permeation apparatus, general//Permeations-Anlagen, allgemein""",
    )

    dfg_1130_7 = VocabularyTerm(
        code="DFG_1130_7",
        label="1130 Reverse osmosis shears",
        description="""Reverse osmosis shears//Revers-Osmose-Geräte""",
    )

    dfg_1130_8 = VocabularyTerm(
        code="DFG_1130_8",
        label="1130 Reverse osmosis plants (except 1970)",
        description="""Reverse osmosis plants (except 1970)//Umkehr-Osmose-Anlagen (außer 1970)""",
    )

    dfg_1140_1 = VocabularyTerm(
        code="DFG_1140_1",
        label="1140 Absorption plants, devices",
        description="""Absorption plants, devices//Absorptionsanlagen, -geräte""",
    )

    dfg_1140_2 = VocabularyTerm(
        code="DFG_1140_2",
        label="1140 Adsorption plants, scrubbers, dryers",
        description="""Adsorption plants, scrubbers, dryers//Adsorptionsanlagen, Wäscher, Trockner""",
    )

    dfg_1140_3 = VocabularyTerm(
        code="DFG_1140_3",
        label="1140 Dehydration equipment (chemical)",
        description="""Dehydration equipment (chemical)//Entwässerungsgeräte (Chemie-)""",
    )

    dfg_1140_4 = VocabularyTerm(
        code="DFG_1140_4",
        label="1140 Gas cleaning equipment, gas regeneration equipment",
        description="""Gas cleaning equipment, gas regeneration equipment//Gasreinigungsgeräte, Gas-Regenerieranlagen""",
    )

    dfg_1140_5 = VocabularyTerm(
        code="DFG_1140_5",
        label="1140 Sorption devices",
        description="""Sorption devices//Sorptions-Geräte""",
    )

    dfg_1150_1 = VocabularyTerm(
        code="DFG_1150_1",
        label="1150 PCR processors (polymerase chain reaction)",
        description="""PCR processors (polymerase chain reaction)//PCR-Prozessoren (Polymerase Chain Reaktion)""",
    )

    dfg_1150_2 = VocabularyTerm(
        code="DFG_1150_2",
        label="1150 Thermal cyclers",
        description="""Thermal cyclers//Thermal Cycler""",
    )

    dfg_1150_3 = VocabularyTerm(
        code="DFG_1150_3",
        label="1150 Thermal cyclers (PCR)",
        description="""Thermal cyclers (PCR)//Thermoblöcke (PCR)""",
    )

    dfg_1160_1 = VocabularyTerm(
        code="DFG_1160_1",
        label="1160 DNA synthesiser",
        description="""DNA synthesiser//DNA-Synthesizer""",
    )

    dfg_1160_2 = VocabularyTerm(
        code="DFG_1160_2",
        label="1160 Peptide synthesis automats",
        description="""Peptide synthesis automats//Peptid-Synthese-Automaten""",
    )

    dfg_1160_3 = VocabularyTerm(
        code="DFG_1160_3",
        label="1160 Biochemistry synthesis apparatuses Synthesis apparatuses",
        description="""Biochemistry synthesis apparatuses Synthesis apparatuses//Synthese-Apparaturen der Biochemie Synthese-Apparaturen""",
    )

    dfg_1170_1 = VocabularyTerm(
        code="DFG_1170_1",
        label="1170 Czochralski apparatuses",
        description="""Czochralski apparatuses//Czochralski-Apparaturen""",
    )

    dfg_1170_2 = VocabularyTerm(
        code="DFG_1170_2",
        label="1170 Crystal growing apparatuses, crystallisation plants",
        description="""Crystal growing apparatuses, crystallisation plants//Kristallzüchtungsapparaturen, Kristallisationsanlagen""",
    )

    dfg_1170_3 = VocabularyTerm(
        code="DFG_1170_3",
        label="1170 Lely apparatus",
        description="""Lely apparatus//Lely-Apparaturen""",
    )

    dfg_1190_1 = VocabularyTerm(
        code="DFG_1190_1",
        label="1190 Catalysts",
        description="""Catalysts//Katalysatoren""",
    )

    dfg_1190_2 = VocabularyTerm(
        code="DFG_1190_2",
        label="1190 Ozonisers, ozone plants",
        description="""Ozonisers, ozone plants//Ozonisatoren, Ozonanlagen""",
    )

    dfg_1190_3 = VocabularyTerm(
        code="DFG_1190_3",
        label="1190 Other equipment for preparative chemistry (except 1100-1170)",
        description="""Other equipment for preparative chemistry (except 1100-1170)//Sonstige Geräte für präparative Chemie (außer 1100-1170)""",
    )

    dfg_1200_1 = VocabularyTerm(
        code="DFG_1200_1",
        label="1200 Blood centrifuges",
        description="""Blood centrifuges//Blutzentrifugen""",
    )

    dfg_1200_2 = VocabularyTerm(
        code="DFG_1200_2",
        label="1200 Hmatocrit centrifuges",
        description="""Hmatocrit centrifuges//Hämatokrit-Zentrifugen""",
    )

    dfg_1200_3 = VocabularyTerm(
        code="DFG_1200_3",
        label="1200 High-speed centrifuges",
        description="""High-speed centrifuges//Hochgeschwindigkeits-Zentrifugen""",
    )

    dfg_1200_4 = VocabularyTerm(
        code="DFG_1200_4",
        label="1200 refrigerated centrifuges",
        description="""refrigerated centrifuges//Kühlzentrifugen""",
    )

    dfg_1200_5 = VocabularyTerm(
        code="DFG_1200_5",
        label="1200 Laboratory centrifuges (up to 25,000/min)",
        description="""Laboratory centrifuges (up to 25,000/min)//Laborzentrifugen (bis 25.000/Min)""",
    )

    dfg_1200_6 = VocabularyTerm(
        code="DFG_1200_6",
        label="1200 microcentrifuges",
        description="""microcentrifuges//Mikrozentrifugen""",
    )

    dfg_1200_7 = VocabularyTerm(
        code="DFG_1200_7",
        label="1200 benchtop centrifuges",
        description="""benchtop centrifuges//Tischzentrifugen""",
    )

    dfg_1210_1 = VocabularyTerm(
        code="DFG_1210_1",
        label="1210 Ultracentrifuges (over 25,000/min)",
        description="""Ultracentrifuges (over 25,000/min)//Ultrazentrifugen (über 25.000/Min)""",
    )

    dfg_1220_1 = VocabularyTerm(
        code="DFG_1220_1",
        label="1220 Blood cell centrifuges",
        description="""Blood cell centrifuges//Blutzellenzentrifugen""",
    )

    dfg_1220_2 = VocabularyTerm(
        code="DFG_1220_2",
        label="1220 Decanters (centrifuges)",
        description="""Decanters (centrifuges)//Dekanter (Zentrifugen)""",
    )

    dfg_1220_3 = VocabularyTerm(
        code="DFG_1220_3",
        label="1220 Filter centrifuges",
        description="""Filter centrifuges//Filterzentrifugen""",
    )

    dfg_1220_4 = VocabularyTerm(
        code="DFG_1220_4",
        label="1220 Gas centrifuges",
        description="""Gas centrifuges//Gaszentrifugen""",
    )

    dfg_1220_5 = VocabularyTerm(
        code="DFG_1220_5",
        label="1220 Separators (centrifuges)",
        description="""Separators (centrifuges)//Separatoren (Zentrifugen)""",
    )

    dfg_1220_6 = VocabularyTerm(
        code="DFG_1220_6",
        label="1220 Special centrifuges (process engineering, medicine)",
        description="""Special centrifuges (process engineering, medicine)//Spezielle Zentrifugen (Verfahrenstechnik, Medizin)""",
    )

    dfg_1220_7 = VocabularyTerm(
        code="DFG_1220_7",
        label="1220 Cell separators",
        description="""Cell separators//Zellseparatoren""",
    )

    dfg_1220_8 = VocabularyTerm(
        code="DFG_1220_8",
        label="1220 Cell-washing systems (with centrifuge and detergent addition)",
        description="""Cell-washing systems (with centrifuge and detergent addition)//Zell-Wasch-Systeme (mit Zentrifuge und Waschmittelzugabe)""",
    )

    dfg_1220_9 = VocabularyTerm(
        code="DFG_1220_9",
        label="1220 Centrifuges (for special preparative tasks)",
        description="""Centrifuges (for special preparative tasks)//Zentrifugen (für spezielle präparative Aufgaben)""",
    )

    dfg_1230_1 = VocabularyTerm(
        code="DFG_1230_1",
        label="1230 X-ray sedimentometers",
        description="""X-ray sedimentometers//Röntgen-Sedimentometer""",
    )

    dfg_1230_2 = VocabularyTerm(
        code="DFG_1230_2",
        label="1230 Disc centrifuges (for sedimentation analysis)",
        description="""Disc centrifuges (for sedimentation analysis)//Scheibenzentrifugen (für Sedimentations-Analysen)""",
    )

    dfg_1230_3 = VocabularyTerm(
        code="DFG_1230_3",
        label="1230 Sedimentation analysers and balances",
        description="""Sedimentation analysers and balances//Sedimentationsanalysatoren und -waagen""",
    )

    dfg_1230_4 = VocabularyTerm(
        code="DFG_1230_4",
        label="1230 Sedimentographs, scanning photo- and X-ray sedimentographs",
        description="""Sedimentographs, scanning photo- and X-ray sedimentographs//Sedimentographen, Scanning Photo- und Röntgen-Sedimentographen""",
    )

    dfg_1240_1 = VocabularyTerm(
        code="DFG_1240_1",
        label="1240 Centrifugal classifiers, separators",
        description="""Centrifugal classifiers, separators//Fliehkraftsichter, -abscheider""",
    )

    dfg_1240_2 = VocabularyTerm(
        code="DFG_1240_2",
        label="1240 Hydrocyclones",
        description="""Hydrocyclones//Hydrozyklone""",
    )

    dfg_1240_3 = VocabularyTerm(
        code="DFG_1240_3",
        label="1240 Sedimentation units, sedimentation compactors",
        description="""Sedimentation units, sedimentation compactors//Klärgeräte (Sedimentiergeräte), Klär-Eindichter""",
    )

    dfg_1240_4 = VocabularyTerm(
        code="DFG_1240_4",
        label="1240 Magnetic separators",
        description="""Magnetic separators//Magnetabscheider""",
    )

    dfg_1240_5 = VocabularyTerm(
        code="DFG_1240_5",
        label="1240 Oil separators (except air treatment 8220)",
        description="""Oil separators (except air treatment 8220)//Oelabscheider (außer Luftaufbereitung 8220)""",
    )

    dfg_1240_6 = VocabularyTerm(
        code="DFG_1240_6",
        label="1240 Gravity separators",
        description="""Gravity separators//Schwerkraftsichter""",
    )

    dfg_1240_7 = VocabularyTerm(
        code="DFG_1240_7",
        label="1240 Classifiers, separators, sedimentation plants (except 1230)",
        description="""Classifiers, separators, sedimentation plants (except 1230)//Sichter, Abscheider, Sedimentieranlagen (außer 1230)""",
    )

    dfg_1240_8 = VocabularyTerm(
        code="DFG_1240_8",
        label="1240 Separating nozzle equipment",
        description="""Separating nozzle equipment//Trenndüsen-Einrichtungen""",
    )

    dfg_1240_9 = VocabularyTerm(
        code="DFG_1240_9",
        label="1240 Droplet separators",
        description="""Droplet separators//Tropfenabscheider""",
    )

    dfg_1240_10 = VocabularyTerm(
        code="DFG_1240_10",
        label="1240 Air classifiers",
        description="""Air classifiers//Windsichter""",
    )

    dfg_1240_11 = VocabularyTerm(
        code="DFG_1240_11",
        label="1240 Cyclones",
        description="""Cyclones//Zyklone""",
    )

    dfg_1250_1 = VocabularyTerm(
        code="DFG_1250_1",
        label="1250 Grain size determination (screening machines)",
        description="""Grain size determination (screening machines)//Korngrößenbestimmung (Siebmaschinen)""",
    )

    dfg_1250_2 = VocabularyTerm(
        code="DFG_1250_2",
        label="1250 Sieves",
        description="""Sieves//Siebe""",
    )

    dfg_1250_3 = VocabularyTerm(
        code="DFG_1250_3",
        label="1250 Sieve sieves",
        description="""Sieve sieves//Siebgeräte""",
    )

    dfg_1250_4 = VocabularyTerm(
        code="DFG_1250_4",
        label="1250 Ultrasonic sieve sieves",
        description="""Ultrasonic sieve sieves//Ultraschall-Siebgeräte""",
    )

    dfg_1260_1 = VocabularyTerm(
        code="DFG_1260_1",
        label="1260 Sterilising filters",
        description="""Sterilising filters//Entkeimungsfilter""",
    )

    dfg_1260_2 = VocabularyTerm(
        code="DFG_1260_2",
        label="1260 Filter presses",
        description="""Filter presses//Filterpressen""",
    )

    dfg_1260_3 = VocabularyTerm(
        code="DFG_1260_3",
        label="1260 Filter presses, filters",
        description="""Filter presses, filters//Filtriergeräte, Filter""",
    )

    dfg_1260_4 = VocabularyTerm(
        code="DFG_1260_4",
        label="1260 Clarifying filters",
        description="""Clarifying filters//Klärfilter""",
    )

    dfg_1260_5 = VocabularyTerm(
        code="DFG_1260_5",
        label="1260 Air filters",
        description="""Air filters//Luftfilter""",
    )

    dfg_1260_6 = VocabularyTerm(
        code="DFG_1260_6",
        label="1260 Membrane filters and devices (except 1130)",
        description="""Membrane filters and devices (except 1130)//Membranfilter und -geräte (außer 1130)""",
    )

    dfg_1260_7 = VocabularyTerm(
        code="DFG_1260_7",
        label="1260 Microfilters",
        description="""Microfilters//Mikrofilter""",
    )

    dfg_1260_8 = VocabularyTerm(
        code="DFG_1260_8",
        label="1260 Molecular sieves",
        description="""Molecular sieves//Molekularsiebe""",
    )

    dfg_1260_9 = VocabularyTerm(
        code="DFG_1260_9",
        label="1260 Sterilisation filters",
        description="""Sterilisation filters//Sterilisationsfilter""",
    )

    dfg_1260_10 = VocabularyTerm(
        code="DFG_1260_10",
        label="1260 Ultrafiltration, membrane filters, hollow fibre concentrators",
        description="""Ultrafiltration, membrane filters, hollow fibre concentrators//Ultrafiltration, Membranfilter, Hohlfiber-Konzentratoren""",
    )

    dfg_1260_11 = VocabularyTerm(
        code="DFG_1260_11",
        label="1260 Vacuum filter chambers",
        description="""Vacuum filter chambers//Vakuumfilterkammern""",
    )

    dfg_1280_1 = VocabularyTerm(
        code="DFG_1280_1",
        label="1280 Processing equipment (except 0370, 1000-1040 and 1200-1260)",
        description="""Processing equipment (except 0370, 1000-1040 and 1200-1260)//Aufbereitungsanlagen (außer 0370, 1000-1040 und 1200-1260)""",
    )

    dfg_1280_2 = VocabularyTerm(
        code="DFG_1280_2",
        label="1280 Flotation, slurry apparatuses",
        description="""Flotation, slurry apparatuses//Flotations-, Schlämmapparate""",
    )

    dfg_1290_1 = VocabularyTerm(
        code="DFG_1290_1",
        label="1290 Swing-out rotors",
        description="""Swing-out rotors//Ausschwing-Rotoren""",
    )

    dfg_1290_2 = VocabularyTerm(
        code="DFG_1290_2",
        label="1290 Continuous rotors",
        description="""Continuous rotors//Durchlaufrotoren""",
    )

    dfg_1290_3 = VocabularyTerm(
        code="DFG_1290_3",
        label="1290 Filling devices for zonal rotors",
        description="""Filling devices for zonal rotors//Einfüllvorichtungen für Zonalrotoren""",
    )

    dfg_1290_4 = VocabularyTerm(
        code="DFG_1290_4",
        label="1290 Elutriator rotors",
        description="""Elutriator rotors//Elutriator-Rotoren""",
    )

    dfg_1290_5 = VocabularyTerm(
        code="DFG_1290_5",
        label="1290 Fixed angle rotors",
        description="""Fixed angle rotors//Festwinkelrotoren""",
    )

    dfg_1290_6 = VocabularyTerm(
        code="DFG_1290_6",
        label="1290 Disc rotors (for centrifuges)",
        description="""Disc rotors (for centrifuges)//Scheibenrotoren (für Zentrifugen)""",
    )

    dfg_1290_7 = VocabularyTerm(
        code="DFG_1290_7",
        label="1290 Swing-bucket rotors",
        description="""Swing-bucket rotors//Schwenkbecherrotoren""",
    )

    dfg_1290_8 = VocabularyTerm(
        code="DFG_1290_8",
        label="1290 Titanium rotors (for centrifuges)",
        description="""Titanium rotors (for centrifuges)//Titan-Rotoren (für Zentrifugen)""",
    )

    dfg_1290_9 = VocabularyTerm(
        code="DFG_1290_9",
        label="1290 Ultracentrifuge rotors",
        description="""Ultracentrifuge rotors//Ultrazentrifugen-Rotoren""",
    )

    dfg_1290_10 = VocabularyTerm(
        code="DFG_1290_10",
        label="1290 Vertical rotors",
        description="""Vertical rotors//Vertikalrotoren""",
    )

    dfg_1290_11 = VocabularyTerm(
        code="DFG_1290_11",
        label="1290 Centrifuge accessories, other equipment for mechanical separation (except 1230-1280)",
        description="""Centrifuge accessories, other equipment for mechanical separation (except 1230-1280)//Zentrifugenzubehör, sonstige Geräte für mechanische Trennverfahren (außer 1230-1280)""",
    )

    dfg_1290_12 = VocabularyTerm(
        code="DFG_1290_12",
        label="1290 Zonal rotors (for centrifuges)",
        description="""Zonal rotors (for centrifuges)//Zonalrotoren (für Zentrifugen)""",
    )

    dfg_1300_1 = VocabularyTerm(
        code="DFG_1300_1",
        label="1300 Double distillation apparatus",
        description="""Double distillation apparatus//Bidestilliergeräte""",
    )

    dfg_1300_2 = VocabularyTerm(
        code="DFG_1300_2",
        label="1300 Distilling and fractionating apparatus, rectifying apparatus",
        description="""Distilling and fractionating apparatus, rectifying apparatus//Destillier- und Fraktioniergeräte, Rektifiziergeräte""",
    )

    dfg_1300_3 = VocabularyTerm(
        code="DFG_1300_3",
        label="1300 Rotary columns",
        description="""Rotary columns//Drehbandkolonnen""",
    )

    dfg_1300_4 = VocabularyTerm(
        code="DFG_1300_4",
        label="1300 Columns for stills, distillation columns, columns",
        description="""Columns for stills, distillation columns, columns//Füllkörper-Säulen, Destillations-Säulen, -Kolonnen""",
    )

    dfg_1300_5 = VocabularyTerm(
        code="DFG_1300_5",
        label="1300 Micro rotary columns",
        description="""Micro rotary columns//Mikrodrehbandkolonnen""",
    )

    dfg_1300_6 = VocabularyTerm(
        code="DFG_1300_6",
        label="1300 Molecular distillation units",
        description="""Molecular distillation units//Molekulardestillationsanlagen""",
    )

    dfg_1300_7 = VocabularyTerm(
        code="DFG_1300_7",
        label="1300 Mercury purification and distillation units",
        description="""Mercury purification and distillation units//Quecksilber-Reinigungs-, -Destilliergeräte""",
    )

    dfg_1300_8 = VocabularyTerm(
        code="DFG_1300_8",
        label="1300 Reduction units",
        description="""Reduction units//Reduziergeräte""",
    )

    dfg_1300_9 = VocabularyTerm(
        code="DFG_1300_9",
        label="1300 Boiling apparatus",
        description="""Boiling apparatus//Siedeapparaturen""",
    )

    dfg_1300_10 = VocabularyTerm(
        code="DFG_1300_10",
        label="1300 Vacuum fractionation plants",
        description="""Vacuum fractionation plants//Vakuumfraktionieranlagen""",
    )

    dfg_1300_11 = VocabularyTerm(
        code="DFG_1300_11",
        label="1300 Water distillation apparatuses",
        description="""Water distillation apparatuses//Wasserdestillationsapparate""",
    )

    dfg_1310_1 = VocabularyTerm(
        code="DFG_1310_1",
        label="1310 Craig distribution apparatus",
        description="""Craig distribution apparatus//Craig-Verteilungsapparaturen""",
    )

    dfg_1310_2 = VocabularyTerm(
        code="DFG_1310_2",
        label="1310 Extraction grids, distribution apparatuses",
        description="""Extraction grids, distribution apparatuses//Extraktionsgeräte, Verteilungsapparaturen""",
    )

    dfg_1310_3 = VocabularyTerm(
        code="DFG_1310_3",
        label="1310 Extraction columns, columns, extractors",
        description="""Extraction columns, columns, extractors//Extraktions-Kolonnen, -Säulen, Extraktoren""",
    )

    dfg_1310_4 = VocabularyTerm(
        code="DFG_1310_4",
        label="1310 Flssig/flssig extraction apparatuses",
        description="""Flssig/flssig extraction apparatuses//Flüssig/flüssig-Extraktionsapparaturen""",
    )

    dfg_1310_5 = VocabularyTerm(
        code="DFG_1310_5",
        label="1310 Countercurrent distribution apparatus",
        description="""Countercurrent distribution apparatus//Gegenstrom-Verteilungsapparaturen""",
    )

    dfg_1320_1 = VocabularyTerm(
        code="DFG_1320_1",
        label="1320 Dnnlayer evaporators",
        description="""Dnnlayer evaporators//Dünnschicht-Verdampfer""",
    )

    dfg_1320_2 = VocabularyTerm(
        code="DFG_1320_2",
        label="1320 Evaporators, evaporators",
        description="""Evaporators, evaporators//Eindampfgeräte, Verdampfer""",
    )

    dfg_1320_3 = VocabularyTerm(
        code="DFG_1320_3",
        label="1320 Rotary evaporators",
        description="""Rotary evaporators//Rotationsverdampfer""",
    )

    dfg_1320_4 = VocabularyTerm(
        code="DFG_1320_4",
        label="1320 Spray drying apparatus",
        description="""Spray drying apparatus//Sprüh-Trocknungsanlagen""",
    )

    dfg_1320_5 = VocabularyTerm(
        code="DFG_1320_5",
        label="1320 Vacuum evaporators",
        description="""Vacuum evaporators//Vakuumverdampfer""",
    )

    dfg_1330_1 = VocabularyTerm(
        code="DFG_1330_1",
        label="1330 Zone melting devices",
        description="""Zone melting devices//Zonenschmelzgeräte""",
    )

    dfg_1340_1 = VocabularyTerm(
        code="DFG_1340_1",
        label="1340 Gas chromatographs (except GC-MS coupling)",
        description="""Gas chromatographs (except GC-MS coupling)//Gaschromatographen (außer GC-MS-Kopplung)""",
    )

    dfg_1340_2 = VocabularyTerm(
        code="DFG_1340_2",
        label="1340 Preparative gas chromatographs",
        description="""Preparative gas chromatographs//Präparative Gaschromatographen""",
    )

    dfg_1350_1 = VocabularyTerm(
        code="DFG_1350_1",
        label="1350 Aminosure analysers",
        description="""Aminosure analysers//Aminosäureanalysytoren""",
    )

    dfg_1350_2 = VocabularyTerm(
        code="DFG_1350_2",
        label="1350 Field-flow fractionation systems",
        description="""Field-flow fractionation systems//Field-Flow-Fraktionierungssysteme""",
    )

    dfg_1350_3 = VocabularyTerm(
        code="DFG_1350_3",
        label="1350 Liquid chromatographs (except ion exchangers)",
        description="""Liquid chromatographs (except ion exchangers)//Flüssigkeits-Chromatographen (außer Ionentauscher)""",
    )

    dfg_1350_4 = VocabularyTerm(
        code="DFG_1350_4",
        label="1350 FPLC systems",
        description="""FPLC systems//FPLC-Anlagen""",
    )

    dfg_1350_5 = VocabularyTerm(
        code="DFG_1350_5",
        label="1350 Gel permeation chromatographs (GPC)",
        description="""Gel permeation chromatographs (GPC)//Gel-Permeations-Chromatographen (GPC)""",
    )

    dfg_1350_6 = VocabularyTerm(
        code="DFG_1350_6",
        label="1350 High-pressure liquid chromatographs (HPLC)",
        description="""High-pressure liquid chromatographs (HPLC)//Hochdruck-Flüssigkeits-Chromatographen (HPLC)""",
    )

    dfg_1350_7 = VocabularyTerm(
        code="DFG_1350_7",
        label="1350 HPLC gels (high-pressure liquid chromatographs)",
        description="""HPLC gels (high-pressure liquid chromatographs)//HPLC-Geräte (Hochdruck-Flüssigkeits-Chromatographen)""",
    )

    dfg_1350_8 = VocabularyTerm(
        code="DFG_1350_8",
        label="1350 Ion chromatography systems",
        description="""Ion chromatography systems//Ionenchromatographie-Systeme""",
    )

    dfg_1350_9 = VocabularyTerm(
        code="DFG_1350_9",
        label="1350 Recycling chromatographs",
        description="""Recycling chromatographs//Recycling-Chromatographen""",
    )

    dfg_1350_10 = VocabularyTerm(
        code="DFG_1350_10",
        label="1350 Column chromatographs",
        description="""Column chromatographs//Säulenchromatographen""",
    )

    dfg_1350_11 = VocabularyTerm(
        code="DFG_1350_11",
        label="1350 Section columns (for chromatographs)",
        description="""Section columns (for chromatographs)//Sektionskolonnen (für Chromatographen)""",
    )

    dfg_1350_12 = VocabularyTerm(
        code="DFG_1350_12",
        label="1350 Super Fluid Chromatography Systems",
        description="""Super Fluid Chromatography Systems//Super Fluid Chromatographie-Systeme""",
    )

    dfg_1350_13 = VocabularyTerm(
        code="DFG_1350_13",
        label="1350 Bercritical fluid chromatographs",
        description="""Bercritical fluid chromatographs//Überkritische Flüssigchromatographen""",
    )

    dfg_1350_14 = VocabularyTerm(
        code="DFG_1350_14",
        label="1350 Sugar analysers",
        description="""Sugar analysers//Zuckeranalysatoren""",
    )

    dfg_1360_1 = VocabularyTerm(
        code="DFG_1360_1",
        label="1360 Thin layer, paper, gel chromatographs",
        description="""Thin layer, paper, gel chromatographs//Dünnschicht-, Papier-, Gel-Chromatographen""",
    )

    dfg_1370_1 = VocabularyTerm(
        code="DFG_1370_1",
        label="1370 Thin layer scanners (radiochromatography, except spark chambers 0280)",
        description="""Thin layer scanners (radiochromatography, except spark chambers 0280)//Dünnschicht-Scanner (Radiochromatographie, außer Funkenkammern 0280)""",
    )

    dfg_1370_2 = VocabularyTerm(
        code="DFG_1370_2",
        label="1370 Paper chromatogram scanners",
        description="""Paper chromatogram scanners//Papierchromatogramm-Scanner""",
    )

    dfg_1370_3 = VocabularyTerm(
        code="DFG_1370_3",
        label="1370 Radio chromatogram scanners",
        description="""Radio chromatogram scanners//Radio-Chromatogramm-Scanner""",
    )

    dfg_1370_4 = VocabularyTerm(
        code="DFG_1370_4",
        label="1370 Radio chromatographs, detectors and analysers",
        description="""Radio chromatographs, detectors and analysers//Radio-Chromatographen, Detektoren und Auswertegeräte""",
    )

    dfg_1370_5 = VocabularyTerm(
        code="DFG_1370_5",
        label="1370 Radio-Dnn layer chromatographs",
        description="""Radio-Dnn layer chromatographs//Radio-Dünnschicht-Chromatographen""",
    )

    dfg_1370_6 = VocabularyTerm(
        code="DFG_1370_6",
        label="1370 Radio-gas chromatographs",
        description="""Radio-gas chromatographs//Radio-Gaschromatographen""",
    )

    dfg_1370_7 = VocabularyTerm(
        code="DFG_1370_7",
        label="1370 Radio-paper chromatographs",
        description="""Radio-paper chromatographs//Radio-Papier-Chromatographen""",
    )

    dfg_1370_8 = VocabularyTerm(
        code="DFG_1370_8",
        label="1370 Radio-Column Chromatography Systems",
        description="""Radio-Column Chromatography Systems//Radio-Säulenchromatographie-Systeme""",
    )

    dfg_1380_1 = VocabularyTerm(
        code="DFG_1380_1",
        label="1380 Chromatogram spectrophotometers",
        description="""Chromatogram spectrophotometers//Chromatogramm-Spektralphotometer""",
    )

    dfg_1380_2 = VocabularyTerm(
        code="DFG_1380_2",
        label="1380 Chromatography data analysers, integrators",
        description="""Chromatography data analysers, integrators//Chromatographie-Datenanalysatoren, -integratoren""",
    )

    dfg_1380_3 = VocabularyTerm(
        code="DFG_1380_3",
        label="1380 Chromatography columns",
        description="""Chromatography columns//Chromatographie-Säulen""",
    )

    dfg_1380_4 = VocabularyTerm(
        code="DFG_1380_4",
        label="1380 Chromatography detectors (except radioactivity monitors 1370)",
        description="""Chromatography detectors (except radioactivity monitors 1370)//Detektoren für Chromatographie (außer Radioaktivitäts-Monitore 1370)""",
    )

    dfg_1380_5 = VocabularyTerm(
        code="DFG_1380_5",
        label="1380 Density gradient fractionators",
        description="""Density gradient fractionators//Dichtegradienten-Fraktionatoren""",
    )

    dfg_1380_6 = VocabularyTerm(
        code="DFG_1380_6",
        label="1380 Diode array detectors for chromatography",
        description="""Diode array detectors for chromatography//Dioden-Array-Detektoren für Chromatographie""",
    )

    dfg_1380_7 = VocabularyTerm(
        code="DFG_1380_7",
        label="1380 Double piston pumps for HPLC",
        description="""Double piston pumps for HPLC//Doppelkolbenpumpen für HPLC""",
    )

    dfg_1380_8 = VocabularyTerm(
        code="DFG_1380_8",
        label="1380 Flow-through photometers together with fraction collectors and recorders (for chromatography)",
        description="""Flow-through photometers together with fraction collectors and recorders (for chromatography)//Durchfluß-Photometer zusammen mit Fraktionensammler und Registriergerät (für Chromatographie)""",
    )

    dfg_1380_9 = VocabularyTerm(
        code="DFG_1380_9",
        label="1380 Electrochemical detectors (ELCD) (for chromatography)",
        description="""Electrochemical detectors (ELCD) (for chromatography)//Elektrochemische Detektoren (ELCD) (für Chromatographie)""",
    )

    dfg_1380_10 = VocabularyTerm(
        code="DFG_1380_10",
        label="1380 Electron capture detectors (ECD)",
        description="""Electron capture detectors (ECD)//Elektroneneinfangdetektoren (ECD)""",
    )

    dfg_1380_11 = VocabularyTerm(
        code="DFG_1380_11",
        label="1380 Elution apparatus for thin-layer chromatography",
        description="""Elution apparatus for thin-layer chromatography//Elutionsgeräte für Dünnschicht-Chromatographie""",
    )

    dfg_1380_12 = VocabularyTerm(
        code="DFG_1380_12",
        label="1380 Developing chambers for chromatography",
        description="""Developing chambers for chromatography//Entwicklungskammern für (Chromatographie)""",
    )

    dfg_1380_13 = VocabularyTerm(
        code="DFG_1380_13",
        label="1380 Flame ionisation detectors (FID)",
        description="""Flame ionisation detectors (FID)//Flammenionisationsdetektoren (FID)""",
    )

    dfg_1380_14 = VocabularyTerm(
        code="DFG_1380_14",
        label="1380 Fluorescence detectors (for chromatography)",
        description="""Fluorescence detectors (for chromatography)//Fluoreszenz-Detektoren (für Chromatographie)""",
    )

    dfg_1380_15 = VocabularyTerm(
        code="DFG_1380_15",
        label="1380 Fraction dividers",
        description="""Fraction dividers//Fraktionenteiler""",
    )

    dfg_1380_16 = VocabularyTerm(
        code="DFG_1380_16",
        label="1380 Fraction collectors",
        description="""Fraction collectors//Fraktionssammler""",
    )

    dfg_1380_17 = VocabularyTerm(
        code="DFG_1380_17",
        label="1380 Gas fraction collectors (gas chromatography)",
        description="""Gas fraction collectors (gas chromatography)//Gasfraktionensammler (Gaschromatographie)""",
    )

    dfg_1380_18 = VocabularyTerm(
        code="DFG_1380_18",
        label="1380 Gel (flat gel, round gel) fractionators",
        description="""Gel (flat gel, round gel) fractionators//Gel- (Flachgel-, Rundgel-) Fraktionatoren""",
    )

    dfg_1380_19 = VocabularyTerm(
        code="DFG_1380_19",
        label="1380 Gel preparation (polymerisation) grids",
        description="""Gel preparation (polymerisation) grids//Gel-Präparations- (Polymerisations-) Geräte""",
    )

    dfg_1380_20 = VocabularyTerm(
        code="DFG_1380_20",
        label="1380 Gel cutting grids",
        description="""Gel cutting grids//Gel-Schneidegeräte""",
    )

    dfg_1380_21 = VocabularyTerm(
        code="DFG_1380_21",
        label="1380 Gradient counters for chromatographs (solvent programmers)",
        description="""Gradient counters for chromatographs (solvent programmers)//Gradientenzusätze für Chromatographen (Solvent-Programmer)""",
    )

    dfg_1380_22 = VocabularyTerm(
        code="DFG_1380_22",
        label="1380 High pressure pumps (for chromatography)",
        description="""High pressure pumps (for chromatography)//Hochdruckpumpen (für Chromatographie)""",
    )

    dfg_1380_23 = VocabularyTerm(
        code="DFG_1380_23",
        label="1380 Integrators (for chromatography)",
        description="""Integrators (for chromatography)//Integratoren (für Chromatographie)""",
    )

    dfg_1380_24 = VocabularyTerm(
        code="DFG_1380_24",
        label="1380 Photoionisation detectors (for gas chromatography)",
        description="""Photoionisation detectors (for gas chromatography)//Photoionisations-Detektoren (für Gaschromatographie)""",
    )

    dfg_1380_25 = VocabularyTerm(
        code="DFG_1380_25",
        label="1380 Preparative auxiliary devices for gas chromatography",
        description="""Preparative auxiliary devices for gas chromatography//Präparative Zusatzgeräte zur Gaschromatographie""",
    )

    dfg_1380_26 = VocabularyTerm(
        code="DFG_1380_26",
        label="1380 Sample injectors for chromatographs",
        description="""Sample injectors for chromatographs//Probengeber für Chromatographen""",
    )

    dfg_1380_27 = VocabularyTerm(
        code="DFG_1380_27",
        label="1380 Sample injection systems, sample introduction systems for chromatographs",
        description="""Sample injection systems, sample introduction systems for chromatographs//Probeninjektionssysteme, Probenaufgabesysteme für Chromatographen""",
    )

    dfg_1380_28 = VocabularyTerm(
        code="DFG_1380_28",
        label="1380 Pumps for chromatography",
        description="""Pumps for chromatography//Pumpen für Chromatographie""",
    )

    dfg_1380_29 = VocabularyTerm(
        code="DFG_1380_29",
        label="1380 Coaters for thin layer chromatographs",
        description="""Coaters for thin layer chromatographs//Streichgeräte für Dünnschichtchromatographen""",
    )

    dfg_1380_30 = VocabularyTerm(
        code="DFG_1380_30",
        label="1380 Thermionic detectors for nitrogen, phosphorus (gas chromatography)",
        description="""Thermionic detectors for nitrogen, phosphorus (gas chromatography)//Thermionische Detektoren für Stickstoff, Phosphor (Gaschromatographie)""",
    )

    dfg_1380_31 = VocabularyTerm(
        code="DFG_1380_31",
        label="1380 Separating columns for chromatography",
        description="""Separating columns for chromatography//Trennsäulen für Chromatographie""",
    )

    dfg_1380_32 = VocabularyTerm(
        code="DFG_1380_32",
        label="1380 UV detectors for chromatography",
        description="""UV detectors for chromatography//UV-Detektoren für Chromatographie""",
    )

    dfg_1380_33 = VocabularyTerm(
        code="DFG_1380_33",
        label="1380 Thermal conductivity detectors",
        description="""Thermal conductivity detectors//Wärmeleitfähigkeits-Detektoren""",
    )

    dfg_1380_34 = VocabularyTerm(
        code="DFG_1380_34",
        label="1380 Accessories for chromatography",
        description="""Accessories for chromatography//Zubehör zur Chromatographie""",
    )

    dfg_1390_1 = VocabularyTerm(
        code="DFG_1390_1",
        label="1390 Chromatographs, special (except 1340-1370)",
        description="""Chromatographs, special (except 1340-1370)//Chromatographen, spezielle (außer 1340-1370)""",
    )

    dfg_1390_2 = VocabularyTerm(
        code="DFG_1390_2",
        label="1390 Curie point pyrolysers",
        description="""Curie point pyrolysers//Curie-Punkt-Pyrolysegeräte""",
    )

    dfg_1390_3 = VocabularyTerm(
        code="DFG_1390_3",
        label="1390 Pyrolysers, pyrolysers for gas chromatography",
        description="""Pyrolysers, pyrolysers for gas chromatography//Pyrolysatoren, Pyrolysegeräte für Gaschromatographie""",
    )

    dfg_1390_4 = VocabularyTerm(
        code="DFG_1390_4",
        label="1390 Other apparatus for thermal separation and chromatography (except 1300-1380)",
        description="""Other apparatus for thermal separation and chromatography (except 1300-1380)//Sonstige Geräte zur thermischen Trennung und zur Chromatographie (außer 1300-1380)""",
    )

    dfg_1400_1 = VocabularyTerm(
        code="DFG_1400_1",
        label="1400 Electrolysis apparatus, cells",
        description="""Electrolysis apparatus, cells//Elektrolyse-Apparate, -Zellen""",
    )

    dfg_1410_1 = VocabularyTerm(
        code="DFG_1410_1",
        label="1410 Disc electrophoresis apparatus",
        description="""Disc electrophoresis apparatus//Disk-Elektrophoresegeräte""",
    )

    dfg_1410_2 = VocabularyTerm(
        code="DFG_1410_2",
        label="1410 Electrophoresis apparatus (analytical and preparative)",
        description="""Electrophoresis apparatus (analytical and preparative)//Elektrophoresegeräte (analytisch und präparativ)""",
    )

    dfg_1410_3 = VocabularyTerm(
        code="DFG_1410_3",
        label="1410 Electro-ultrafiltration sieves (EUF)",
        description="""Electro-ultrafiltration sieves (EUF)//Elektro-Ultrafiltrationsgeräte (EUF)""",
    )

    dfg_1410_4 = VocabularyTerm(
        code="DFG_1410_4",
        label="1410 High-voltage electrophoreses",
        description="""High-voltage electrophoreses//Hochspannungselektrophoresegeräte""",
    )

    dfg_1410_5 = VocabularyTerm(
        code="DFG_1410_5",
        label="1410 Immuno-electrophoresis",
        description="""Immuno-electrophoresis//Immun-Elektrophoresegeräte""",
    )

    dfg_1410_6 = VocabularyTerm(
        code="DFG_1410_6",
        label="1410 Capillary electrophoresis systems",
        description="""Capillary electrophoresis systems//Kapillarelektrophorese-Systeme""",
    )

    dfg_1410_7 = VocabularyTerm(
        code="DFG_1410_7",
        label="1410 Cataphoresis apparatus",
        description="""Cataphoresis apparatus//Kataphoreseapparate""",
    )

    dfg_1410_8 = VocabularyTerm(
        code="DFG_1410_8",
        label="1410 Polyacrylamide electrophoreses",
        description="""Polyacrylamide electrophoreses//Polyacrylamid-Elektrophoresegeräte""",
    )

    dfg_1410_9 = VocabularyTerm(
        code="DFG_1410_9",
        label="1410 Carrier-free electrophoresis apparatuses",
        description="""Carrier-free electrophoresis apparatuses//Trägerfreie Elektrophoreseapparaturen""",
    )

    dfg_1420_1 = VocabularyTerm(
        code="DFG_1420_1",
        label="1420 Electrofocusing, isotachophoresis equipment",
        description="""Electrofocusing, isotachophoresis equipment//Elektrofokussierung, Isotachophoresegeräte""",
    )

    dfg_1420_2 = VocabularyTerm(
        code="DFG_1420_2",
        label="1420 Electrofocusing apparatus, columns",
        description="""Electrofocusing apparatus, columns//Elektrofokussierungsgeräte, -säulen""",
    )

    dfg_1420_3 = VocabularyTerm(
        code="DFG_1420_3",
        label="1420 Isoelectric focusing",
        description="""Isoelectric focusing//Isoelektrische Fokussierung""",
    )

    dfg_1440_1 = VocabularyTerm(
        code="DFG_1440_1",
        label="1440 Ion activity meters",
        description="""Ion activity meters//Ionen-Aktivitäts-Messgeräte""",
    )

    dfg_1440_2 = VocabularyTerm(
        code="DFG_1440_2",
        label="1440 Ion-sensitive electrodes (measuring devices)",
        description="""Ion-sensitive electrodes (measuring devices)//Ionensensitive Elektroden (Messgeräte)""",
    )

    dfg_1440_3 = VocabularyTerm(
        code="DFG_1440_3",
        label="1440 pH meters, ionometers",
        description="""pH meters, ionometers//ph-Messgeräte, Ionometer""",
    )

    dfg_1440_4 = VocabularyTerm(
        code="DFG_1440_4",
        label="1440 Redox measuring and control devices",
        description="""Redox measuring and control devices//Redoxmess- und Regelgeräte""",
    )

    dfg_1450_1 = VocabularyTerm(
        code="DFG_1450_1",
        label="1450 Pressure jump instruments (conductivity measurement)",
        description="""Pressure jump instruments (conductivity measurement)//Drucksprung-Geräte (Leitfähigkeitsmessung)""",
    )

    dfg_1450_2 = VocabularyTerm(
        code="DFG_1450_2",
        label="1450 Conductometers, conductoscopes",
        description="""Conductometers, conductoscopes//Konduktometer, Konduktoskope""",
    )

    dfg_1450_3 = VocabularyTerm(
        code="DFG_1450_3",
        label="1450 Conductivity meters",
        description="""Conductivity meters//Leitfähigkeitsmessgeräte""",
    )

    dfg_1450_4 = VocabularyTerm(
        code="DFG_1450_4",
        label="1450 Salinity meters (except marine research 0450)",
        description="""Salinity meters (except marine research 0450)//Salzgehaltsmessgeräte (außer Meeresforschung 0450)""",
    )

    dfg_1460_1 = VocabularyTerm(
        code="DFG_1460_1",
        label="1460 Polarographs",
        description="""Polarographs//Polarographen""",
    )

    dfg_1460_2 = VocabularyTerm(
        code="DFG_1460_2",
        label="1460 Pulse polarographs",
        description="""Pulse polarographs//Pulspolarographen""",
    )

    dfg_1460_3 = VocabularyTerm(
        code="DFG_1460_3",
        label="1460 Tactile polarographs",
        description="""Tactile polarographs//Tastpolarographen""",
    )

    dfg_1470_1 = VocabularyTerm(
        code="DFG_1470_1",
        label="1470 Coulometers",
        description="""Coulometers//Coulometer""",
    )

    dfg_1470_2 = VocabularyTerm(
        code="DFG_1470_2",
        label="1470 Electroanalytical systems (combined)",
        description="""Electroanalytical systems (combined)//Elektroanalytische Systeme (kombiniert)""",
    )

    dfg_1470_3 = VocabularyTerm(
        code="DFG_1470_3",
        label="1470 Galvanostats",
        description="""Galvanostats//Galvanostaten""",
    )

    dfg_1470_4 = VocabularyTerm(
        code="DFG_1470_4",
        label="1470 Potentiometers, instruments for amperometry, voltametry, coulometry",
        description="""Potentiometers, instruments for amperometry, voltametry, coulometry//Potenziometer, Geräte für Amperometrie, Voltametrie, Coulometrie""",
    )

    dfg_1470_5 = VocabularyTerm(
        code="DFG_1470_5",
        label="1470 Potentiostats",
        description="""Potentiostats//Potenziostaten""",
    )

    dfg_1490_1 = VocabularyTerm(
        code="DFG_1490_1",
        label="1490 Other electrochemical instruments (except 1400-1470)",
        description="""Other electrochemical instruments (except 1400-1470)//Sonstige Geräte der Elektrochemie (außer 1400-1470)""",
    )

    dfg_1500_1 = VocabularyTerm(
        code="DFG_1500_1",
        label="1500 High-speed ashing apparatus (except cold ashing and combustion apparatus for beta/gamma measuring plates 3370)",
        description="""High-speed ashing apparatus (except cold ashing and combustion apparatus for beta/gamma measuring plates 3370)//Schnellverascher (außer Kaltveraschungs- und Verbrennungsgeräte für Beta/Gamma-Messplätze 3370)""",
    )

    dfg_1500_2 = VocabularyTerm(
        code="DFG_1500_2",
        label="1500 Ashing apparatus, rapid ashing apparatus for elemental analysis",
        description="""Ashing apparatus, rapid ashing apparatus for elemental analysis//Veraschungsgeräte, Schnell-Verascher für Elementaranalyse""",
    )

    dfg_1500_3 = VocabularyTerm(
        code="DFG_1500_3",
        label="1500 Combustion apparatus for elemental analysis",
        description="""Combustion apparatus for elemental analysis//Verbrennungsapparaturen für Elementaranalyse""",
    )

    dfg_1500_4 = VocabularyTerm(
        code="DFG_1500_4",
        label="1500 Combustion furnaces for macro- and microanalysis",
        description="""Combustion furnaces for macro- and microanalysis//Verbrennungsöfen für Makro- und Mikroanalyse""",
    )

    dfg_1510_1 = VocabularyTerm(
        code="DFG_1510_1",
        label="1510 CHN analysers",
        description="""CHN analysers//CHN-Analysatoren""",
    )

    dfg_1510_2 = VocabularyTerm(
        code="DFG_1510_2",
        label="1510 Elemental analysis apparatus",
        description="""Elemental analysis apparatus//Geräte zur Elementaranalyse""",
    )

    dfg_1510_3 = VocabularyTerm(
        code="DFG_1510_3",
        label="1510 Lime determination apparatus",
        description="""Lime determination apparatus//Kalkbestimmungsapparate""",
    )

    dfg_1510_4 = VocabularyTerm(
        code="DFG_1510_4",
        label="1510 Carbon determination apparatus, carbon analysers",
        description="""Carbon determination apparatus, carbon analysers//Kohlenstoffbestimmungs-Apparate, Kohlenstoff-Analysatoren""",
    )

    dfg_1510_5 = VocabularyTerm(
        code="DFG_1510_5",
        label="1510 N-15 analysers (spectroscopic nitrogen determination)",
        description="""N-15 analysers (spectroscopic nitrogen determination)//N-15-Analysatoren (spektroskopische Stickstoffbestimmung)""",
    )

    dfg_1510_6 = VocabularyTerm(
        code="DFG_1510_6",
        label="1510 Mercury determination apparatuses",
        description="""Mercury determination apparatuses//Quecksilber-Bestimmungsgeräte""",
    )

    dfg_1510_7 = VocabularyTerm(
        code="DFG_1510_7",
        label="1510 Sulphur determination apparatus",
        description="""Sulphur determination apparatus//Schwefelbestimmungsapparaturen""",
    )

    dfg_1510_8 = VocabularyTerm(
        code="DFG_1510_8",
        label="1510 Nitrogen and sulphur determination apparatuses",
        description="""Nitrogen and sulphur determination apparatuses//Stickstoff- und Schwefelbestimmungsapparate""",
    )

    dfg_1510_9 = VocabularyTerm(
        code="DFG_1510_9",
        label="1510 TAC, TC analysers (total inorganic or total carbon content)",
        description="""TAC, TC analysers (total inorganic or total carbon content)//TAC, TC-Messgeräte (Totaler anorganischer oder Gesamt-Kohlenstoffgehalt)""",
    )

    dfg_1510_10 = VocabularyTerm(
        code="DFG_1510_10",
        label="1510 TOC analysers (organic carbon)",
        description="""TOC analysers (organic carbon)//TOC-Analysatoren (Organischer Kohlenstoff)""",
    )

    dfg_1510_11 = VocabularyTerm(
        code="DFG_1510_11",
        label="1510 Hydrogen analysers",
        description="""Hydrogen analysers//Wasserstoffbestimmungsapparate""",
    )

    dfg_1520_1 = VocabularyTerm(
        code="DFG_1520_1",
        label="1520 Exhaust gas analysers (except smoke analysers 1940 and mass spectrometers 1700-1720)",
        description="""Exhaust gas analysers (except smoke analysers 1940 and mass spectrometers 1700-1720)//Abgas-Analysengeräte (außer Rauchmessgeräte 1940 und Massenspektrometer 1700-1720)""",
    )

    dfg_1520_2 = VocabularyTerm(
        code="DFG_1520_2",
        label="1520 Gas analysers (except for physiology 3060 and gas analysers 9880)",
        description="""Gas analysers (except for physiology 3060 and gas analysers 9880)//Gasanalysegeräte (außer für Physiologie 3060 und Gasspürgeräte 9880)""",
    )

    dfg_1520_3 = VocabularyTerm(
        code="DFG_1520_3",
        label="1520 Gas measuring sensor systems",
        description="""Gas measuring sensor systems//Gas-Mess-Sensorsysteme""",
    )

    dfg_1520_4 = VocabularyTerm(
        code="DFG_1520_4",
        label="1520 Infrared gas analysers",
        description="""Infrared gas analysers//Infrarot-Gasanalysatoren""",
    )

    dfg_1520_5 = VocabularyTerm(
        code="DFG_1520_5",
        label="1520 Magnetic oxygen analysers",
        description="""Magnetic oxygen analysers//Magnetische Sauerstoff-Analysatoren""",
    )

    dfg_1520_6 = VocabularyTerm(
        code="DFG_1520_6",
        label="1520 Measuring instruments for gases (O2, CO2)",
        description="""Measuring instruments for gases (O2, CO2)//Messgeräte für Gase (O2, CO2)""",
    )

    dfg_1520_7 = VocabularyTerm(
        code="DFG_1520_7",
        label="1520 Ozone meters",
        description="""Ozone meters//Ozonmessgeräte""",
    )

    dfg_1520_8 = VocabularyTerm(
        code="DFG_1520_8",
        label="1520 Oxygen analysers",
        description="""Oxygen analysers//Sauerstoffmessgeräte""",
    )

    dfg_1530_1 = VocabularyTerm(
        code="DFG_1530_1",
        label="1530 Automatic analysers (except 1510, 1520 and clinical chemistry 3100-3130)",
        description="""Automatic analysers (except 1510, 1520 and clinical chemistry 3100-3130)//Analysenautomaten (außer 1510, 1520 und Klinische Chemie 3100-3130)""",
    )

    dfg_1550_1 = VocabularyTerm(
        code="DFG_1550_1",
        label="1550 Waste water analysers, monitoring systems",
        description="""Waste water analysers, monitoring systems//Abwasseruntersuchungsgeräte, -Überwachungsanlagen""",
    )

    dfg_1550_2 = VocabularyTerm(
        code="DFG_1550_2",
        label="1550 BOD measuring instruments (Biological Oxygen Demand, BOD)",
        description="""BOD measuring instruments (Biological Oxygen Demand, BOD)//BSB-Messgeräte (Biologischer Sauerstoffbedarf, BOD)""",
    )

    dfg_1550_3 = VocabularyTerm(
        code="DFG_1550_3",
        label="1550 COD (Chemical Oxygen Demand) meters",
        description="""COD (Chemical Oxygen Demand) meters//COD-Messgeräte (Chemischer Sauerstoff-Bedarf)""",
    )

    dfg_1550_4 = VocabularyTerm(
        code="DFG_1550_4",
        label="1550 Water testing equipment",
        description="""Water testing equipment//Gewässeruntersuchungsgeräte""",
    )

    dfg_1550_5 = VocabularyTerm(
        code="DFG_1550_5",
        label="1550 Groundwater monitoring instruments",
        description="""Groundwater monitoring instruments//Grundwasseruntersuchungsgeräte""",
    )

    dfg_1550_6 = VocabularyTerm(
        code="DFG_1550_6",
        label="1550 Laboratory (model) water treatment plants",
        description="""Laboratory (model) water treatment plants//Labor- (Modell-) Kläranlagen""",
    )

    dfg_1550_7 = VocabularyTerm(
        code="DFG_1550_7",
        label="1550 COD (Chemical Oxygen Demand), BOD (Biological Oxygen Demand), water testing instruments",
        description="""COD (Chemical Oxygen Demand), BOD (Biological Oxygen Demand), water testing instruments//Messgeräte für chemischen (COD), biologischen (BSB) Sauerstoffbedarf, Wasseruntersuchungsgeräte""",
    )

    dfg_1550_8 = VocabularyTerm(
        code="DFG_1550_8",
        label="1550 Sapromats (R)",
        description="""Sapromats (R)//Sapromaten (R)""",
    )

    dfg_1550_9 = VocabularyTerm(
        code="DFG_1550_9",
        label="1550 TOD measuring instruments (total oxygen demand)",
        description="""TOD measuring instruments (total oxygen demand)//TOD-Messgeräte (Totaler Sauerstoff-Bedarf)""",
    )

    dfg_1560_1 = VocabularyTerm(
        code="DFG_1560_1",
        label="1560 Air monitoring and analysis instruments (except dust, smoke and aerosol instruments 1920-1940)",
        description="""Air monitoring and analysis instruments (except dust, smoke and aerosol instruments 1920-1940)//Luftüberwachungs- und -analysengeräte (außer Staub-, Rauch- und Aerosolmessgeräte 1920-1940)""",
    )

    dfg_1570_1 = VocabularyTerm(
        code="DFG_1570_1",
        label="1570 Special instruments for food and genetic analysis",
        description="""Special instruments for food and genetic analysis//Spezielle Geräte für Lebens- und Genußmittel-Analytik""",
    )

    dfg_1580_1 = VocabularyTerm(
        code="DFG_1580_1",
        label="1580 Farinometers",
        description="""Farinometers//Farinometer""",
    )

    dfg_1580_2 = VocabularyTerm(
        code="DFG_1580_2",
        label="1580 Measuring and testing instruments for food technology",
        description="""Measuring and testing instruments for food technology//Mess- und Prüfgeräte für Lebensmitteltechnologie""",
    )

    dfg_1580_3 = VocabularyTerm(
        code="DFG_1580_3",
        label="1580 Milk fat measuring instruments",
        description="""Milk fat measuring instruments//Milchfettmessgeräte""",
    )

    dfg_1590_1 = VocabularyTerm(
        code="DFG_1590_1",
        label="1590 Ash content, measuring instruments",
        description="""Ash content, measuring instruments//Aschegehalt, Messgeräte""",
    )

    dfg_1590_2 = VocabularyTerm(
        code="DFG_1590_2",
        label="1590 Disintegration bombs (except cell disintegration bombs 3530)",
        description="""Disintegration bombs (except cell disintegration bombs 3530)//Aufschlußbomben (außer Zellaufbrechbomben 3530)""",
    )

    dfg_1590_3 = VocabularyTerm(
        code="DFG_1590_3",
        label="1590 Carbon analysers",
        description="""Carbon analysers//Kohlenuntersuchungsgeräte""",
    )

    dfg_1590_4 = VocabularyTerm(
        code="DFG_1590_4",
        label="1590 Sure digestion bombs",
        description="""Sure digestion bombs//Säureaufschlußbomben""",
    )

    dfg_1590_5 = VocabularyTerm(
        code="DFG_1590_5",
        label="1590 Other analytical instruments (except 1500-1580)",
        description="""Other analytical instruments (except 1500-1580)//Sonstige Analysengeräte (außer 1500-1580)""",
    )

    dfg_1600_1 = VocabularyTerm(
        code="DFG_1600_1",
        label="1600 Arometers",
        description="""Arometers//Aräometer""",
    )

    dfg_1600_2 = VocabularyTerm(
        code="DFG_1600_2",
        label="1600 Density meters",
        description="""Density meters//Dichtemessgeräte""",
    )

    dfg_1600_3 = VocabularyTerm(
        code="DFG_1600_3",
        label="1600 Density meters with nuclear radiation (except 4430)",
        description="""Density meters with nuclear radiation (except 4430)//Dichtemessgeräte mit Kernstrahlung (außer 4430)""",
    )

    dfg_1600_4 = VocabularyTerm(
        code="DFG_1600_4",
        label="1600 Density balances",
        description="""Density balances//Dichtewaagen""",
    )

    dfg_1600_5 = VocabularyTerm(
        code="DFG_1600_5",
        label="1600 Gas density meters",
        description="""Gas density meters//Gasdichtemessgeräte""",
    )

    dfg_1610_1 = VocabularyTerm(
        code="DFG_1610_1",
        label="1610 Balance rheometer",
        description="""Balance rheometer//Balance-Rheometer""",
    )

    dfg_1610_2 = VocabularyTerm(
        code="DFG_1610_2",
        label="1610 Brookfield viscometers",
        description="""Brookfield viscometers//Brookfield-Viskosimeter""",
    )

    dfg_1610_3 = VocabularyTerm(
        code="DFG_1610_3",
        label="1610 Consistency meters, consistometers",
        description="""Consistency meters, consistometers//Konsistenzmessgeräte, Konsistometer""",
    )

    dfg_1610_4 = VocabularyTerm(
        code="DFG_1610_4",
        label="1610 Falling sphere viscometers",
        description="""Falling sphere viscometers//Kugelfall-Viskosimeter""",
    )

    dfg_1610_5 = VocabularyTerm(
        code="DFG_1610_5",
        label="1610 Mechanical spectrometers (viscosity measurement)",
        description="""Mechanical spectrometers (viscosity measurement)//Mechanische Spektrometer (Zähigkeitsmessung)""",
    )

    dfg_1610_6 = VocabularyTerm(
        code="DFG_1610_6",
        label="1610 Micro viscometers",
        description="""Micro viscometers//Mikroviskosimeter""",
    )

    dfg_1610_7 = VocabularyTerm(
        code="DFG_1610_7",
        label="1610 Rotational viscometers",
        description="""Rotational viscometers//Rotationsviskosimeter""",
    )

    dfg_1610_8 = VocabularyTerm(
        code="DFG_1610_8",
        label="1610 Viscometers, rheometers",
        description="""Viscometers, rheometers//Viskosimeter, Rheometer""",
    )

    dfg_1610_9 = VocabularyTerm(
        code="DFG_1610_9",
        label="1610 Weissenberg rheometer",
        description="""Weissenberg rheometer//Weißenberg-Rheometer""",
    )

    dfg_1610_10 = VocabularyTerm(
        code="DFG_1610_10",
        label="1610 Toughness meters",
        description="""Toughness meters//Zähigkeitsmessgeräte""",
    )

    dfg_1620_1 = VocabularyTerm(
        code="DFG_1620_1",
        label="1620 Penetrometers, Plastometers",
        description="""Penetrometers, Plastometers//Penetrometer, Plastometer""",
    )

    dfg_1620_2 = VocabularyTerm(
        code="DFG_1620_2",
        label="1620 Plastizittsmessgerte, Plastometer",
        description="""Plastizittsmessgerte, Plastometer//Plastizitätsmessgeräte, Plastometer""",
    )

    dfg_1630_1 = VocabularyTerm(
        code="DFG_1630_1",
        label="1630 Vapour pressure osmometer",
        description="""Vapour pressure osmometer//Dampfdruck-Osmometer""",
    )

    dfg_1630_2 = VocabularyTerm(
        code="DFG_1630_2",
        label="1630 Ebullioscopes",
        description="""Ebullioscopes//Ebullioskope""",
    )

    dfg_1630_3 = VocabularyTerm(
        code="DFG_1630_3",
        label="1630 Freezing point depression, measuring devices",
        description="""Freezing point depression, measuring devices//Gefrierpunkt-Erniedrigung, Messgeräte""",
    )

    dfg_1630_4 = VocabularyTerm(
        code="DFG_1630_4",
        label="1630 Molecular weight measuring devices",
        description="""Molecular weight measuring devices//Geräte zur Molekulargewichtsbestimmung""",
    )

    dfg_1630_5 = VocabularyTerm(
        code="DFG_1630_5",
        label="1630 Membrane osmometers",
        description="""Membrane osmometers//Membranosmometer""",
    )

    dfg_1630_6 = VocabularyTerm(
        code="DFG_1630_6",
        label="1630 Osmometer",
        description="""Osmometer//Osmometer""",
    )

    dfg_1640_1 = VocabularyTerm(
        code="DFG_1640_1",
        label="1640 BET surface measuring devices (according to Brunauer, Emmett, Teller)",
        description="""BET surface measuring devices (according to Brunauer, Emmett, Teller)//BET-Oberflächenmessgeräte (nach Brunauer, Emmett, Teller)""",
    )

    dfg_1640_2 = VocabularyTerm(
        code="DFG_1640_2",
        label="1640 Pressure porosimeter",
        description="""Pressure porosimeter//Druckporosimeter""",
    )

    dfg_1640_3 = VocabularyTerm(
        code="DFG_1640_3",
        label="1640 Porometer, porosimeter",
        description="""Porometer, porosimeter//Porometer, Porosimeter""",
    )

    dfg_1640_4 = VocabularyTerm(
        code="DFG_1640_4",
        label="1640 Porosity and surface measuring instruments",
        description="""Porosity and surface measuring instruments//Porositäts-und Oberflächenmessgeräte""",
    )

    dfg_1650_1 = VocabularyTerm(
        code="DFG_1650_1",
        label="1650 Film balances (Langmuir triggers)",
        description="""Film balances (Langmuir triggers)//Filmwaagen (Langmuir-Tröge)""",
    )

    dfg_1650_2 = VocabularyTerm(
        code="DFG_1650_2",
        label="1650 Interfacial tensiometers",
        description="""Interfacial tensiometers//Interfacial-Tensiometer""",
    )

    dfg_1650_3 = VocabularyTerm(
        code="DFG_1650_3",
        label="1650 Surface tension meters",
        description="""Surface tension meters//Oberflächen-Spannungsmesser""",
    )

    dfg_1650_4 = VocabularyTerm(
        code="DFG_1650_4",
        label="1650 Stalagmometers (drop gauges)",
        description="""Stalagmometers (drop gauges)//Stalagmometer (Tropfengröße-Messgeräte)""",
    )

    dfg_1650_5 = VocabularyTerm(
        code="DFG_1650_5",
        label="1650 Tensiometer (surface tension)",
        description="""Tensiometer (surface tension)//Tensiometer (Oberflächenspannung)""",
    )

    dfg_1660_1 = VocabularyTerm(
        code="DFG_1660_1",
        label="1660 Decameter",
        description="""Decameter//Dekameter""",
    )

    dfg_1660_2 = VocabularyTerm(
        code="DFG_1660_2",
        label="1660 Dipole meter",
        description="""Dipole meter//Dipolmeter""",
    )

    dfg_1660_3 = VocabularyTerm(
        code="DFG_1660_3",
        label="1660 DK-meters",
        description="""DK-meters//DK-Messgeräte""",
    )

    dfg_1660_4 = VocabularyTerm(
        code="DFG_1660_4",
        label="1660 Multidecameter",
        description="""Multidecameter//Multidekameter""",
    )

    dfg_1690_1 = VocabularyTerm(
        code="DFG_1690_1",
        label="1690 Vapour pressure gauges (except 1630)",
        description="""Vapour pressure gauges (except 1630)//Dampfdruckmessgeräte (außer 1630)""",
    )

    dfg_1690_2 = VocabularyTerm(
        code="DFG_1690_2",
        label="1690 Instruments for measuring material constants (except strength 2900-2990, thermal values 8640-8690)",
        description="""Instruments for measuring material constants (except strength 2900-2990, thermal values 8640-8690)//Geräte zur Messung von Stoffkonstanten (außer Festigkeit 2900-2990, thermische Werte 8640-8690)""",
    )

    dfg_1700_1 = VocabularyTerm(
        code="DFG_1700_1",
        label="1700 Electrospray mass spectrometer",
        description="""Electrospray mass spectrometer//Elektrospray-Massenspektrometer""",
    )

    dfg_1700_2 = VocabularyTerm(
        code="DFG_1700_2",
        label="1700 Gas chromatograph-mass spectrometer",
        description="""Gas chromatograph-mass spectrometer//Gaschromatograph-Massenspektrometer""",
    )

    dfg_1700_3 = VocabularyTerm(
        code="DFG_1700_3",
        label="1700 GC-MS systems",
        description="""GC-MS systems//GC-MS-Systeme""",
    )

    dfg_1700_4 = VocabularyTerm(
        code="DFG_1700_4",
        label="1700 Isotope mass spectrometers",
        description="""Isotope mass spectrometers//Isotopen-Massenspektrometer""",
    )

    dfg_1700_5 = VocabularyTerm(
        code="DFG_1700_5",
        label="1700 Maldi mass spectrometer",
        description="""Maldi mass spectrometer//Maldi-Massenspektrometer""",
    )

    dfg_1700_6 = VocabularyTerm(
        code="DFG_1700_6",
        label="1700 Mass spectrometers",
        description="""Mass spectrometers//Massenspektrometer""",
    )

    dfg_1700_7 = VocabularyTerm(
        code="DFG_1700_7",
        label="1700 Thermionic mass spectrometers",
        description="""Thermionic mass spectrometers//Thermionische Massenspektrometer""",
    )

    dfg_1710_1 = VocabularyTerm(
        code="DFG_1710_1",
        label="1710 Mass filters",
        description="""Mass filters//Massenfilter""",
    )

    dfg_1710_2 = VocabularyTerm(
        code="DFG_1710_2",
        label="1710 Partial pressure, residual gas mass spectrometers",
        description="""Partial pressure, residual gas mass spectrometers//Partialdruck-, Restgas-Massenspektrometer""",
    )

    dfg_1710_3 = VocabularyTerm(
        code="DFG_1710_3",
        label="1710 Partial pressure analysers",
        description="""Partial pressure analysers//Partialdruckanalysatoren""",
    )

    dfg_1710_4 = VocabularyTerm(
        code="DFG_1710_4",
        label="1710 Quadrupole mass spectrometers",
        description="""Quadrupole mass spectrometers//Quadrupolmassenspektrometer""",
    )

    dfg_1710_5 = VocabularyTerm(
        code="DFG_1710_5",
        label="1710 Residual gas analysers",
        description="""Residual gas analysers//Restgasanalysatoren""",
    )

    dfg_1720_1 = VocabularyTerm(
        code="DFG_1720_1",
        label="1720 Solid body mass spectrometers",
        description="""Solid body mass spectrometers//Festkörper-Massenspektrometer""",
    )

    dfg_1720_2 = VocabularyTerm(
        code="DFG_1720_2",
        label="1720 FIM (Field Ion Mass Spectrometer)",
        description="""FIM (Field Ion Mass Spectrometer)//FIM (Feldionen-Massenspektrometer)""",
    )

    dfg_1720_3 = VocabularyTerm(
        code="DFG_1720_3",
        label="1720 Ion microanalysers, ion probes",
        description="""Ion microanalysers, ion probes//Ionen-Mikroanalysatoren, Ionensonden""",
    )

    dfg_1720_4 = VocabularyTerm(
        code="DFG_1720_4",
        label="1720 Laser mass analysers",
        description="""Laser mass analysers//Laser-Massen-Analysatoren""",
    )

    dfg_1720_5 = VocabularyTerm(
        code="DFG_1720_5",
        label="1720 Process control mass spectrometers",
        description="""Process control mass spectrometers//Prozesskontroll-Massenspektrometer""",
    )

    dfg_1720_6 = VocabularyTerm(
        code="DFG_1720_6",
        label="1720 Special mass spectrometers (cyclotron resonance, ion probes, SIMS, except 3060)",
        description="""Special mass spectrometers (cyclotron resonance, ion probes, SIMS, except 3060)//Spezielle Massenspektrometer (Cyclotronresonanz-, Ionensonden, SIMS, außer 3060)""",
    )

    dfg_1720_7 = VocabularyTerm(
        code="DFG_1720_7",
        label="1720 Secondary ion mass spectrometer",
        description="""Secondary ion mass spectrometer//Sekundärionen-Massenspektrometer""",
    )

    dfg_1740_1 = VocabularyTerm(
        code="DFG_1740_1",
        label="1740 NMR (Nuclear Magnetic Resonance) spectrometer",
        description="""NMR (Nuclear Magnetic Resonance) spectrometer//NMR (Nuklearmagnetische Resonanz)-Spektrometer""",
    )

    dfg_1741_1 = VocabularyTerm(
        code="DFG_1741_1",
        label="1741 Solid-state NMR spectrometer",
        description="""Solid-state NMR spectrometer//Festkörper-NMR-Spektrometer""",
    )

    dfg_1742_1 = VocabularyTerm(
        code="DFG_1742_1",
        label="1742 NMR spectrometers for imaging applications (except 3231)",
        description="""NMR spectrometers for imaging applications (except 3231)//NMR-Spektrometer für Imaging-Anwendung (außer 3231)""",
    )

    dfg_1760_1 = VocabularyTerm(
        code="DFG_1760_1",
        label="1760 Nuclear quadrupole resonance spectrometer (NQR)",
        description="""Nuclear quadrupole resonance spectrometer (NQR)//Kernquadrupolresonanz-Spektrometer (NQR)""",
    )

    dfg_1770_1 = VocabularyTerm(
        code="DFG_1770_1",
        label="1770 Electron spin resonance spectrometer (EPR, ESR)",
        description="""Electron spin resonance spectrometer (EPR, ESR)//Elektronenspinresonanz-Spektrometer (EPR, ESR)""",
    )

    dfg_1770_2 = VocabularyTerm(
        code="DFG_1770_2",
        label="1770 ENDOR shear (Electron-Nuclear-Double-Resonance)",
        description="""ENDOR shear (Electron-Nuclear-Double-Resonance)//ENDOR-Geräte (Electron-Nuclear-Double-Resonance)""",
    )

    dfg_1780_1 = VocabularyTerm(
        code="DFG_1780_1",
        label="1780 Auger electron spectrometer",
        description="""Auger electron spectrometer//Auger-Elektronenspektrometer""",
    )

    dfg_1780_2 = VocabularyTerm(
        code="DFG_1780_2",
        label="1780 ESCA apparatus",
        description="""ESCA apparatus//ESCA-Apparaturen""",
    )

    dfg_1780_3 = VocabularyTerm(
        code="DFG_1780_3",
        label="1780 Photoelectron spectrometers (PES, UPS, XPS)",
        description="""Photoelectron spectrometers (PES, UPS, XPS)//Photoelektronenspektrometer (PES, UPS, XPS)""",
    )

    dfg_1780_4 = VocabularyTerm(
        code="DFG_1780_4",
        label="1780 Cylinder Auger spectrometer",
        description="""Cylinder Auger spectrometer//Zylinder-Auger-Spektrometer""",
    )

    dfg_1790_1 = VocabularyTerm(
        code="DFG_1790_1",
        label="1790 Assemblies and accessories for spectrometers (mass-, NMR-)",
        description="""Assemblies and accessories for spectrometers (mass-, NMR-)//Baugruppen und Zubehör für Spektrometer (Massen-, NMR-)""",
    )

    dfg_1790_2 = VocabularyTerm(
        code="DFG_1790_2",
        label="1790 Spherical sector analysers, spherical capacitors for mass and electron spectrometers",
        description="""Spherical sector analysers, spherical capacitors for mass and electron spectrometers//Kugelsektor-Analysatoren, Kugel-Kondensatoren für Massen- und Elektronenspektrometer""",
    )

    dfg_1790_3 = VocabularyTerm(
        code="DFG_1790_3",
        label="1790 Microwave spectrometers",
        description="""Microwave spectrometers//Mikrowellen-Spektrometer""",
    )

    dfg_1790_4 = VocabularyTerm(
        code="DFG_1790_4",
        label="1790 Spectrometers (mass, NMR, except 1700-1780)",
        description="""Spectrometers (mass, NMR, except 1700-1780)//Spektrometer (Massen-, NMR-, außer 1700-1780)""",
    )

    dfg_1790_5 = VocabularyTerm(
        code="DFG_1790_5",
        label="1790 Cylindrical capacitors for mass and electron spectrometers",
        description="""Cylindrical capacitors for mass and electron spectrometers//Zylinderkondensatoren für Massen- und Elektronenspektrometer""",
    )

    dfg_1800_1 = VocabularyTerm(
        code="DFG_1800_1",
        label="1800 Grating spectrophotometers (UV and VIS)",
        description="""Grating spectrophotometers (UV and VIS)//Gitterspektralphotometer (UV und VIS)""",
    )

    dfg_1800_2 = VocabularyTerm(
        code="DFG_1800_2",
        label="1800 Grating spectrographs",
        description="""Grating spectrographs//Gitterspektrographen""",
    )

    dfg_1800_3 = VocabularyTerm(
        code="DFG_1800_3",
        label="1800 Prism spectrographs",
        description="""Prism spectrographs//Prismenspektrographen""",
    )

    dfg_1800_4 = VocabularyTerm(
        code="DFG_1800_4",
        label="1800 Quartz spectrographs",
        description="""Quartz spectrographs//Quarzspektrographen""",
    )

    dfg_1800_5 = VocabularyTerm(
        code="DFG_1800_5",
        label="1800 Spectral apparatus (except interferometer 5300)",
        description="""Spectral apparatus (except interferometer 5300)//Spektralapparate (außer Interferometer 5300)""",
    )

    dfg_1800_6 = VocabularyTerm(
        code="DFG_1800_6",
        label="1800 Spectrophotometers (UV, VIS), spectrographs (except monochromators 5650)",
        description="""Spectrophotometers (UV, VIS), spectrographs (except monochromators 5650)//Spektralphotometer (UV, VIS), Spektrographen (außer Monochromatoren 5650)""",
    )

    dfg_1800_7 = VocabularyTerm(
        code="DFG_1800_7",
        label="1800 Spectrographs, spectrometers (ultraviolet, visible light)",
        description="""Spectrographs, spectrometers (ultraviolet, visible light)//Spektrographen, Spektrometer (Ultraviolett, sichtbares Licht)""",
    )

    dfg_1800_8 = VocabularyTerm(
        code="DFG_1800_8",
        label="1800 Spectrophotometers (UV and VIS), single-beam, double-beam, double-beam spectrometers",
        description="""Spectrophotometers (UV and VIS), single-beam, double-beam, double-beam spectrometers//Spektrophotometer (UV und VIS), Einstrahl-, Zweistrahl-""",
    )

    dfg_1800_9 = VocabularyTerm(
        code="DFG_1800_9",
        label="1800 UV spectrometers, spectrographs",
        description="""UV spectrometers, spectrographs//UV-Spektrometer, -Spektrographen""",
    )

    dfg_1800_10 = VocabularyTerm(
        code="DFG_1800_10",
        label="1800 UV vacuum spectrographs",
        description="""UV vacuum spectrographs//UV-Vakuumspektrographen""",
    )

    dfg_1800_11 = VocabularyTerm(
        code="DFG_1800_11",
        label="1800 UV-VIS spectrophotometers",
        description="""UV-VIS spectrophotometers//UV-VIS-Spektralphotometer""",
    )

    dfg_1800_12 = VocabularyTerm(
        code="DFG_1800_12",
        label="1800 Vacuum spectrographs",
        description="""Vacuum spectrographs//Vakuumspektrographen""",
    )

    dfg_1800_13 = VocabularyTerm(
        code="DFG_1800_13",
        label="1800 Vacuum UV spectrometers",
        description="""Vacuum UV spectrometers//Vakuum-UV-Spektrometer""",
    )

    dfg_1800_14 = VocabularyTerm(
        code="DFG_1800_14",
        label="1800 XUV spectrographs",
        description="""XUV spectrographs//XUV-Spektrographen""",
    )

    dfg_1800_15 = VocabularyTerm(
        code="DFG_1800_15",
        label="1800 Dual wavelength spectrophotometers",
        description="""Dual wavelength spectrophotometers//Zweiwellenlängen-Spektralphotometer""",
    )

    dfg_1810_1 = VocabularyTerm(
        code="DFG_1810_1",
        label="1810 Atomic absorption spectrophotometer and special accessories (AAS)",
        description="""Atomic absorption spectrophotometer and special accessories (AAS)//Atomabsorptions-Spektrophotometer und Spezialzubehör (AAS)""",
    )

    dfg_1810_2 = VocabularyTerm(
        code="DFG_1810_2",
        label="1810 Flame spectrophotometer",
        description="""Flame spectrophotometer//Flammenspektralphotometer""",
    )

    dfg_1810_3 = VocabularyTerm(
        code="DFG_1810_3",
        label="1810 Graphite tube cuvettes (atomic absorption) and power supplies",
        description="""Graphite tube cuvettes (atomic absorption) and power supplies//Graphitrohrküvetten (Atomabsorption) und Netzanschlußgeräte""",
    )

    dfg_1810_4 = VocabularyTerm(
        code="DFG_1810_4",
        label="1810 Massmann cuvettes (atomic absorption spectrometer)",
        description="""Massmann cuvettes (atomic absorption spectrometer)//Massmann-Küvetten (Atomabsorptions-Spektrometer)""",
    )

    dfg_1811_1 = VocabularyTerm(
        code="DFG_1811_1",
        label="1811 Emission spectrometer",
        description="""Emission spectrometer//Emissions-Spektrometer""",
    )

    dfg_1811_2 = VocabularyTerm(
        code="DFG_1811_2",
        label="1811 Spark emission spectrometer",
        description="""Spark emission spectrometer//Funken-Emissionsspektrometer""",
    )

    dfg_1811_3 = VocabularyTerm(
        code="DFG_1811_3",
        label="1811 Glow discharge spectrometers (GDS)",
        description="""Glow discharge spectrometers (GDS)//Glimmentladungsspektrometer (GDS)""",
    )

    dfg_1811_4 = VocabularyTerm(
        code="DFG_1811_4",
        label="1811 ICP systems (plasma emission)",
        description="""ICP systems (plasma emission)//ICP-Systeme (Plasma-Emission)""",
    )

    dfg_1811_5 = VocabularyTerm(
        code="DFG_1811_5",
        label="1811 Plasma emission spectrometer",
        description="""Plasma emission spectrometer//Plasma-Emissionsspektrometer""",
    )

    dfg_1820_1 = VocabularyTerm(
        code="DFG_1820_1",
        label="1820 IR grating spectrometer",
        description="""IR grating spectrometer//IR-Gitter-Spektrometer""",
    )

    dfg_1820_2 = VocabularyTerm(
        code="DFG_1820_2",
        label="1820 Near-infrared spectrophotometer",
        description="""Near-infrared spectrophotometer//Nah-Infrarot-Spektralphotometer""",
    )

    dfg_1820_3 = VocabularyTerm(
        code="DFG_1820_3",
        label="1820 NIR spectrometer",
        description="""NIR spectrometer//NIR-Spektrometer""",
    )

    dfg_1820_4 = VocabularyTerm(
        code="DFG_1820_4",
        label="1820 THz spectrometer",
        description="""THz spectrometer//THz-Spektrometer""",
    )

    dfg_1830_1 = VocabularyTerm(
        code="DFG_1830_1",
        label="1830 Fourier Spectrometer (Infrared)",
        description="""Fourier Spectrometer (Infrared)//Fourier-Spektrometer (Infrarot)""",
    )

    dfg_1830_2 = VocabularyTerm(
        code="DFG_1830_2",
        label="1830 Fourier Transform IR Spectrometer",
        description="""Fourier Transform IR Spectrometer//Fourier-Transform-IR-Spektrometer""",
    )

    dfg_1830_3 = VocabularyTerm(
        code="DFG_1830_3",
        label="1830 FTIR spectrometer",
        description="""FTIR spectrometer//FTIR-Spektrometer""",
    )

    dfg_1830_4 = VocabularyTerm(
        code="DFG_1830_4",
        label="1830 Infrared Fourier spectrophotometer",
        description="""Infrared Fourier spectrophotometer//Infrarot-Fourier-Spektrophotometer""",
    )

    dfg_1830_5 = VocabularyTerm(
        code="DFG_1830_5",
        label="1830 IR interferometer",
        description="""IR interferometer//IR-Interferometer""",
    )

    dfg_1830_6 = VocabularyTerm(
        code="DFG_1830_6",
        label="1830 Lamellar grating interferometer far infrared",
        description="""Lamellar grating interferometer far infrared//Lamellar-Gitter-Interferometer für fernes Infrarot""",
    )

    dfg_1840_1 = VocabularyTerm(
        code="DFG_1840_1",
        label="1840 Laser Raman Molekl microprobes",
        description="""Laser Raman Molekl microprobes//Laser-Raman-Molekül-Mikrosonden""",
    )

    dfg_1840_2 = VocabularyTerm(
        code="DFG_1840_2",
        label="1840 Laser Raman spectrometer",
        description="""Laser Raman spectrometer//Laser-Raman-Spektrometer""",
    )

    dfg_1840_3 = VocabularyTerm(
        code="DFG_1840_3",
        label="1840 Raman spectrometer",
        description="""Raman spectrometer//Raman-Spektrometer""",
    )

    dfg_1850_1 = VocabularyTerm(
        code="DFG_1850_1",
        label="1850 Chemiluminescence spectrometer",
        description="""Chemiluminescence spectrometer//Chemolumineszenz-Spektrometer""",
    )

    dfg_1850_2 = VocabularyTerm(
        code="DFG_1850_2",
        label="1850 Chlorophyll fluorescence measuring instruments",
        description="""Chlorophyll fluorescence measuring instruments//Chlorophyll-Fluoreszenz-Messgeräte""",
    )

    dfg_1850_3 = VocabularyTerm(
        code="DFG_1850_3",
        label="1850 Fluorescence decay measuring devices",
        description="""Fluorescence decay measuring devices//Fluoreszenz-Abkling-Messeinrichtungen""",
    )

    dfg_1850_4 = VocabularyTerm(
        code="DFG_1850_4",
        label="1850 Fluorescence spectrophotometers",
        description="""Fluorescence spectrophotometers//Fluoreszenz-Spektralphotometer""",
    )

    dfg_1850_5 = VocabularyTerm(
        code="DFG_1850_5",
        label="1850 Phosphorescence spectrophotometer",
        description="""Phosphorescence spectrophotometer//Phosphoreszenz-Spektralphotometer""",
    )

    dfg_1850_6 = VocabularyTerm(
        code="DFG_1850_6",
        label="1850 Spectrofluorometers, luminescence spectrometers (except filter fluorometers)",
        description="""Spectrofluorometers, luminescence spectrometers (except filter fluorometers)//Spektralfluorometer, Lumineszenz-Spektrometer (außer Filterfluorometer)""",
    )

    dfg_1860_1 = VocabularyTerm(
        code="DFG_1860_1",
        label="1860 Flash light spectrometer (nanosecond)",
        description="""Flash light spectrometer (nanosecond)//Blitzlicht-Spektrometer (Nanosekunden-)""",
    )

    dfg_1860_2 = VocabularyTerm(
        code="DFG_1860_2",
        label="1860 Brioullin spectrometer",
        description="""Brioullin spectrometer//Brioullin-Spektrometer""",
    )

    dfg_1860_3 = VocabularyTerm(
        code="DFG_1860_3",
        label="1860 Three-prism spectrographs",
        description="""Three-prism spectrographs//Dreiprismenspektrographen""",
    )

    dfg_1860_4 = VocabularyTerm(
        code="DFG_1860_4",
        label="1860 Laser microprobes (emission spectrometers with laser excitation)",
        description="""Laser microprobes (emission spectrometers with laser excitation)//Laser-Mikrosonden (Emissions-Spektrometer mit Laser-Anregung)""",
    )

    dfg_1860_5 = VocabularyTerm(
        code="DFG_1860_5",
        label="1860 Optoacoustic spectrometers (OAS)",
        description="""Optoacoustic spectrometers (OAS)//Optoakustische Spektrometer (OAS)""",
    )

    dfg_1860_6 = VocabularyTerm(
        code="DFG_1860_6",
        label="1860 Photoacoustic spectrometers (PAS)",
        description="""Photoacoustic spectrometers (PAS)//Photoakustische Spektrometer (PAS)""",
    )

    dfg_1860_7 = VocabularyTerm(
        code="DFG_1860_7",
        label="1860 Picosecond spectrometer",
        description="""Picosecond spectrometer//Picosekunden-Spektrometer""",
    )

    dfg_1860_8 = VocabularyTerm(
        code="DFG_1860_8",
        label="1860 Rapids spectrometer",
        description="""Rapids spectrometer//Rapidspektrometer""",
    )

    dfg_1860_9 = VocabularyTerm(
        code="DFG_1860_9",
        label="1860 Rayleigh spectrometer",
        description="""Rayleigh spectrometer//Rayleigh-Spektrometer""",
    )

    dfg_1860_10 = VocabularyTerm(
        code="DFG_1860_10",
        label="1860 Remission spectrophotometer",
        description="""Remission spectrophotometer//Remissions-Spektralphotometer""",
    )

    dfg_1860_11 = VocabularyTerm(
        code="DFG_1860_11",
        label="1860 Spectrometers (special optical)",
        description="""Spectrometers (special optical)//Spektrometer (spezielle optische)""",
    )

    dfg_1860_12 = VocabularyTerm(
        code="DFG_1860_12",
        label="1860 Special spectrographs and spectrometers",
        description="""Special spectrographs and spectrometers//Spezielle Spektrographen und Spektrometer""",
    )

    dfg_1860_13 = VocabularyTerm(
        code="DFG_1860_13",
        label="1860 Stopped-flow spectrometer",
        description="""Stopped-flow spectrometer//Stopped-Flow-Spektrometer""",
    )

    dfg_1860_14 = VocabularyTerm(
        code="DFG_1860_14",
        label="1860 Temperature jump spectrometer",
        description="""Temperature jump spectrometer//Temperatursprung-Spektrometer""",
    )

    dfg_1870_1 = VocabularyTerm(
        code="DFG_1870_1",
        label="1870 Multichannel spectrographs (optical)",
        description="""Multichannel spectrographs (optical)//Mehrkanal-Spektrographen (optische)""",
    )

    dfg_1870_2 = VocabularyTerm(
        code="DFG_1870_2",
        label="1870 Multichannel optical analysers, spectrometers",
        description="""Multichannel optical analysers, spectrometers//Optische Vielkanalanalysatoren, -spektrometer""",
    )

    dfg_1870_3 = VocabularyTerm(
        code="DFG_1870_3",
        label="1870 Multichannel optical spectrographs",
        description="""Multichannel optical spectrographs//Optische Vielkanalspektrographen""",
    )

    dfg_1870_4 = VocabularyTerm(
        code="DFG_1870_4",
        label="1870 Spectrum analysers (optical)",
        description="""Spectrum analysers (optical)//Spektralanalysenautomaten (optische)""",
    )

    dfg_1870_5 = VocabularyTerm(
        code="DFG_1870_5",
        label="1870 Spectrum analysers (optical)",
        description="""Spectrum analysers (optical)//Spektrumanalysatoren (optische)""",
    )

    dfg_1870_6 = VocabularyTerm(
        code="DFG_1870_6",
        label="1870 Multichannel spectrographs, analysers (optical)",
        description="""Multichannel spectrographs, analysers (optical)//Vielkanalspektrographen, -analysatoren (optische)""",
    )

    dfg_1880_1 = VocabularyTerm(
        code="DFG_1880_1",
        label="1880 Excitation apparatus (spectrography)",
        description="""Excitation apparatus (spectrography)//Anregungsgeräte (Spektrographie)""",
    )

    dfg_1880_2 = VocabularyTerm(
        code="DFG_1880_2",
        label="1880 Evaluation apparatus, accessories and components for optical spectrometers",
        description="""Evaluation apparatus, accessories and components for optical spectrometers//Auswertegeräte, Zubehör und Bauelemente für optische Spektrometer""",
    )

    dfg_1880_3 = VocabularyTerm(
        code="DFG_1880_3",
        label="1880 Components for spectrometers (except monochromators 5650)",
        description="""Components for spectrometers (except monochromators 5650)//Bausteine für Spektrometer (außer Monochromatoren 5650)""",
    )

    dfg_1880_4 = VocabularyTerm(
        code="DFG_1880_4",
        label="1880 Burners for atomic absorption and emission spectrophotometers",
        description="""Burners for atomic absorption and emission spectrophotometers//Brenner für Atomabsorptions- und Emissionsspektrophotometer""",
    )

    dfg_1880_5 = VocabularyTerm(
        code="DFG_1880_5",
        label="1880 Spark arc generators, spark arc stands",
        description="""Spark arc generators, spark arc stands//Funkenbogengeneratoren, Funkenbogenstände""",
    )

    dfg_1880_6 = VocabularyTerm(
        code="DFG_1880_6",
        label="1880 Spark generators",
        description="""Spark generators//Funkenerzeuger""",
    )

    dfg_1880_7 = VocabularyTerm(
        code="DFG_1880_7",
        label="1880 Spark stands",
        description="""Spark stands//Funkenstative""",
    )

    dfg_1880_8 = VocabularyTerm(
        code="DFG_1880_8",
        label="1880 Graphite Electrode Sharpening Machines",
        description="""Graphite Electrode Sharpening Machines//Graphit-Elektroden-Spitzmaschinen""",
    )

    dfg_1880_9 = VocabularyTerm(
        code="DFG_1880_9",
        label="1880 IR Polarizers",
        description="""IR Polarizers//IR-Polarisatoren""",
    )

    dfg_1880_10 = VocabularyTerm(
        code="DFG_1880_10",
        label="1880 Condenser Optics for Spectrophotometers",
        description="""Condenser Optics for Spectrophotometers//Kondensoroptiken für Spektralphotometer""",
    )

    dfg_1880_11 = VocabularyTerm(
        code="DFG_1880_11",
        label="1880 Spheres (integrating spheres), sphere attachments for reflectance measurements",
        description="""Spheres (integrating spheres), sphere attachments for reflectance measurements//Kugeln (Ulbricht-), Kugelansätze für Remissionsmessungen""",
    )

    dfg_1880_12 = VocabularyTerm(
        code="DFG_1880_12",
        label="1880 Microilluminators",
        description="""Microilluminators//Mikroilluminatoren""",
    )

    dfg_1880_13 = VocabularyTerm(
        code="DFG_1880_13",
        label="1880 Photometer spheres, integrating spheres",
        description="""Photometer spheres, integrating spheres//Photometerkugeln, Ulbricht-Kugeln""",
    )

    dfg_1880_14 = VocabularyTerm(
        code="DFG_1880_14",
        label="1880 Reflectance mounts for spectrophotometers",
        description="""Reflectance mounts for spectrophotometers//Remissionsansätze für Spektralphotometer""",
    )

    dfg_1880_15 = VocabularyTerm(
        code="DFG_1880_15",
        label="1880 Spectrum Evaluators, Spectrum Calculators",
        description="""Spectrum Evaluators, Spectrum Calculators//Spektren-Auswertegeräte, Spektren-Rechengeräte""",
    )

    dfg_1880_16 = VocabularyTerm(
        code="DFG_1880_16",
        label="1880 Spectra Projectors",
        description="""Spectra Projectors//Spektrenprojektoren""",
    )

    dfg_1880_17 = VocabularyTerm(
        code="DFG_1880_17",
        label="1880 Spectrograph Slits",
        description="""Spectrograph Slits//Spektrographenspalte""",
    )

    dfg_1880_18 = VocabularyTerm(
        code="DFG_1880_18",
        label="1880 Nitrogen splicing equipment for IR spectrographs",
        description="""Nitrogen splicing equipment for IR spectrographs//Stickstoff-Spüleinrichtungen für IR-Spektrographen""",
    )

    dfg_1880_19 = VocabularyTerm(
        code="DFG_1880_19",
        label="1880 Stopped-flow conditions",
        description="""Stopped-flow conditions//Stopped-Flow-Zusätze""",
    )

    dfg_1880_20 = VocabularyTerm(
        code="DFG_1880_20",
        label="1880 Temperature Jump (for Stopped-Flow)",
        description="""Temperature Jump (for Stopped-Flow)//Temperatursprung-Zusätze (für Stopped-Flow)""",
    )

    dfg_1880_21 = VocabularyTerm(
        code="DFG_1880_21",
        label="1880 Transmission-extinction converters for optical spectrometers",
        description="""Transmission-extinction converters for optical spectrometers//Transmission-Extinktion-Wandler (-Rechner) für optische Spektrometer""",
    )

    dfg_1880_22 = VocabularyTerm(
        code="DFG_1880_22",
        label="1880 Accessories for spectrometers (except cuvettes 5280)",
        description="""Accessories for spectrometers (except cuvettes 5280)//Zubehör für Spektrometer (außer Küvetten 5280)""",
    )

    dfg_1890_1 = VocabularyTerm(
        code="DFG_1890_1",
        label="1890 Optical spectrometers (except 1800-1860)",
        description="""Optical spectrometers (except 1800-1860)//Optische Spektrometer (außer 1800-1860)""",
    )

    dfg_1900_1 = VocabularyTerm(
        code="DFG_1900_1",
        label="1900 Bretten (except 1070)",
        description="""Bretten (except 1070)//Büretten (außer 1070)""",
    )

    dfg_1900_2 = VocabularyTerm(
        code="DFG_1900_2",
        label="1900 Motorised boards",
        description="""Motorised boards//Motorbüretten""",
    )

    dfg_1900_3 = VocabularyTerm(
        code="DFG_1900_3",
        label="1900 Titration apparatus, stands",
        description="""Titration apparatus, stands//Titriergeräte, -stände""",
    )

    dfg_1910_1 = VocabularyTerm(
        code="DFG_1910_1",
        label="1910 Moisture meters (except air (0510) and soil (4430) moisture measurement)",
        description="""Moisture meters (except air (0510) and soil (4430) moisture measurement)//Feuchtigkeitsmessgeräte (außer Luft- (0510) und Bodenfeuchte (4430) -Messung)""",
    )

    dfg_1910_2 = VocabularyTerm(
        code="DFG_1910_2",
        label="1910 Moisture monitoring devices",
        description="""Moisture monitoring devices//Feuchtigkeits-Überwachungsgeräte""",
    )

    dfg_1910_3 = VocabularyTerm(
        code="DFG_1910_3",
        label="1910 Karl Fischer water determination instruments",
        description="""Karl Fischer water determination instruments//Karl-Fischer-Wasserbestimmungsgeräte""",
    )

    dfg_1910_4 = VocabularyTerm(
        code="DFG_1910_4",
        label="1910 Water content measuring instruments",
        description="""Water content measuring instruments//Wassergehaltsmessgeräte""",
    )

    dfg_1920_1 = VocabularyTerm(
        code="DFG_1920_1",
        label="1920 Flow and volume meters (except for blood 3010)",
        description="""Flow and volume meters (except for blood 3010)//Durchfluß- und Mengenmesser (außer für Blut 3010)""",
    )

    dfg_1920_2 = VocabularyTerm(
        code="DFG_1920_2",
        label="1920 Gas meters",
        description="""Gas meters//Gasmesser""",
    )

    dfg_1920_3 = VocabularyTerm(
        code="DFG_1920_3",
        label="1920 Gas meters",
        description="""Gas meters//Gasuhren""",
    )

    dfg_1920_4 = VocabularyTerm(
        code="DFG_1920_4",
        label="1920 Mass flow meters",
        description="""Mass flow meters//Massendurchflußmesser""",
    )

    dfg_1920_5 = VocabularyTerm(
        code="DFG_1920_5",
        label="1920 Oval wheel meters",
        description="""Oval wheel meters//Ovalradzähler""",
    )

    dfg_1920_6 = VocabularyTerm(
        code="DFG_1920_6",
        label="1920 Drum meters (flow meters)",
        description="""Drum meters (flow meters)//Trommelzähler (Durchflußmesser)""",
    )

    dfg_1920_7 = VocabularyTerm(
        code="DFG_1920_7",
        label="1920 Water meters, water meters",
        description="""Water meters, water meters//Wasseruhren, Wasserzähler""",
    )

    dfg_1920_8 = VocabularyTerm(
        code="DFG_1920_8",
        label="1920 Woltmann meters (flow meters)",
        description="""Woltmann meters (flow meters)//Woltmann-Zähler (Durchflußmesser)""",
    )

    dfg_1930_1 = VocabularyTerm(
        code="DFG_1930_1",
        label="1930 Aerosol and dust collectors",
        description="""Aerosol and dust collectors//Aerosol-, Staub-Sammler""",
    )

    dfg_1930_2 = VocabularyTerm(
        code="DFG_1930_2",
        label="1930 Impactors, cascade impactors",
        description="""Impactors, cascade impactors//Impaktoren, Kaskaden-Impaktoren""",
    )

    dfg_1930_3 = VocabularyTerm(
        code="DFG_1930_3",
        label="1930 Conimeter (dust measurement)",
        description="""Conimeter (dust measurement)//Konimeter (Staubmessung)""",
    )

    dfg_1930_4 = VocabularyTerm(
        code="DFG_1930_4",
        label="1930 Airborne germ examination and monitoring devices",
        description="""Airborne germ examination and monitoring devices//Luftkeim-Untersuchungs- und -Überwachungsgeräte""",
    )

    dfg_1930_5 = VocabularyTerm(
        code="DFG_1930_5",
        label="1930 Dust measuring instruments",
        description="""Dust measuring instruments//Staubmessgeräte""",
    )

    dfg_1930_6 = VocabularyTerm(
        code="DFG_1930_6",
        label="1930 Dust collectors",
        description="""Dust collectors//Staubsammelgeräte""",
    )

    dfg_1940_1 = VocabularyTerm(
        code="DFG_1940_1",
        label="1940 Smoke and SO2 measuring instruments (except scattered light photometer 5360)",
        description="""Smoke and SO2 measuring instruments (except scattered light photometer 5360)//Rauch- und SO2-Messgeräte (außer Streulichtphotometer 5360)""",
    )

    dfg_1940_2 = VocabularyTerm(
        code="DFG_1940_2",
        label="1940 Smoke measuring and monitoring instruments",
        description="""Smoke measuring and monitoring instruments//Rauchmess- und -überwachungsgeräte""",
    )

    dfg_1950_1 = VocabularyTerm(
        code="DFG_1950_1",
        label="1950 Aerosol (size) analysers, aerosol photometers",
        description="""Aerosol (size) analysers, aerosol photometers//Aerosol- (Size-) Analysatoren, Aerosol-Photometer""",
    )

    dfg_1950_2 = VocabularyTerm(
        code="DFG_1950_2",
        label="1950 Condensation core counters",
        description="""Condensation core counters//Kondensationskern-Zähler""",
    )

    dfg_1950_3 = VocabularyTerm(
        code="DFG_1950_3",
        label="1950 Grain size analysers (optical, electronic, except 1240, 1250,7430)",
        description="""Grain size analysers (optical, electronic, except 1240, 1250,7430)//Korngröße-Analysatoren (optisch, elektronisch, außer 1240, 1250,7430)""",
    )

    dfg_1950_4 = VocabularyTerm(
        code="DFG_1950_4",
        label="1950 Light flash spectrometers for particle counting and classification",
        description="""Light flash spectrometers for particle counting and classification//Lichtblitz-Spektrometer für Teilchenzählung und Klassierung""",
    )

    dfg_1950_5 = VocabularyTerm(
        code="DFG_1950_5",
        label="1950 Particle counters and classifiers (optical, electronic, except 3500)",
        description="""Particle counters and classifiers (optical, electronic, except 3500)//Partikelzählgeräte und -klassiergeräte (optisch, elektronisch, außer 3500)""",
    )

    dfg_1950_6 = VocabularyTerm(
        code="DFG_1950_6",
        label="1950 Spectral particle counters (aerosol analysis)",
        description="""Spectral particle counters (aerosol analysis)//Spektralteilchenzähler (Aerosol-Analyse)""",
    )

    dfg_1950_7 = VocabularyTerm(
        code="DFG_1950_7",
        label="1950 Scattered light bubble and particle counters (-counters)",
        description="""Scattered light bubble and particle counters (-counters)//Streulicht-Blasen- und -Partikelmessgeräte (-Zähler)""",
    )

    dfg_1950_8 = VocabularyTerm(
        code="DFG_1950_8",
        label="1950 Particle size analysers (except 1240, 1250 and 7430)",
        description="""Particle size analysers (except 1240, 1250 and 7430)//Teilchengröße-Analysatoren (außer 1240, 1250 und 7430)""",
    )

    dfg_1950_9 = VocabularyTerm(
        code="DFG_1950_9",
        label="1950 Droplet size spectrometers (except 0520)",
        description="""Droplet size spectrometers (except 0520)//Tropfengröße-Spektrometer (außer 0520)""",
    )

    dfg_1970_1 = VocabularyTerm(
        code="DFG_1970_1",
        label="1970 Deionisation plants for water",
        description="""Deionisation plants for water//Deionisierungsanlagen für Wasser""",
    )

    dfg_1970_2 = VocabularyTerm(
        code="DFG_1970_2",
        label="1970 Water sterilisation plants",
        description="""Water sterilisation plants//Entkeimungsanlagen für Wasser""",
    )

    dfg_1970_3 = VocabularyTerm(
        code="DFG_1970_3",
        label="1970 Desalination plants for water",
        description="""Desalination plants for water//Entsalzungsanlagen für Wasser""",
    )

    dfg_1970_4 = VocabularyTerm(
        code="DFG_1970_4",
        label="1970 Desilvering apparatus",
        description="""Desilvering apparatus//Entsilberungsgeräte""",
    )

    dfg_1970_5 = VocabularyTerm(
        code="DFG_1970_5",
        label="1970 Ion exchange plants for water treatment",
        description="""Ion exchange plants for water treatment//Ionenaustausch-Anlagen für Wasseraufbereitung""",
    )

    dfg_1970_6 = VocabularyTerm(
        code="DFG_1970_6",
        label="1970 Water Treatment Plants, Waste Water Purification Plants",
        description="""Water Treatment Plants, Waste Water Purification Plants//Wasseraufbereitungsgeräte, Abwasser-Reinigungsanlagen""",
    )

    dfg_1970_7 = VocabularyTerm(
        code="DFG_1970_7",
        label="1970 Water Dehydration Plants",
        description="""Water Dehydration Plants//Wasserenthärtungsanlagen""",
    )

    dfg_1970_8 = VocabularyTerm(
        code="DFG_1970_8",
        label="1970 Water purification apparatus (except distillation apparatus 1300)",
        description="""Water purification apparatus (except distillation apparatus 1300)//Wasserreinigungsgeräte (außer Destillationsgeräte 1300)""",
    )

    dfg_1980_1 = VocabularyTerm(
        code="DFG_1980_1",
        label="1980 Granulating machines",
        description="""Granulating machines//Granuliermaschinen""",
    )

    dfg_1980_2 = VocabularyTerm(
        code="DFG_1980_2",
        label="1980 Hydraulic laboratory presses",
        description="""Hydraulic laboratory presses//Hydraulische Laborpressen""",
    )

    dfg_1980_3 = VocabularyTerm(
        code="DFG_1980_3",
        label="1980 KBR tablet presses",
        description="""KBR tablet presses//KBR-Tablettenpressen""",
    )

    dfg_1980_4 = VocabularyTerm(
        code="DFG_1980_4",
        label="1980 Presses for laboratory and process technology",
        description="""Presses for laboratory and process technology//Pressen für Labor- und Verfahrenstechnik""",
    )

    dfg_1980_5 = VocabularyTerm(
        code="DFG_1980_5",
        label="1980 Tablet presses",
        description="""Tablet presses//Tablettenpressen""",
    )

    dfg_1990_1 = VocabularyTerm(
        code="DFG_1990_1",
        label="1990 Other equipment for chemical engineering",
        description="""Other equipment for chemical engineering//Sonstige Geräte der chemischen Betriebstechnik""",
    )

    dfg_1990_2 = VocabularyTerm(
        code="DFG_1990_2",
        label="1990 Tablet presses (breaking strength, dissolvability)",
        description="""Tablet presses (breaking strength, dissolvability)//Tablettenprüfgeräte (Bruchfestigkeit, Auflösbarkeit)""",
    )

    dfg_2000_1 = VocabularyTerm(
        code="DFG_2000_1",
        label="2000 Automatic lathes (NC and CNC)",
        description="""Automatic lathes (NC and CNC)//Drehautomaten (NC und CNC)""",
    )

    dfg_2000_2 = VocabularyTerm(
        code="DFG_2000_2",
        label="2000 Lathes",
        description="""Lathes//Drehbänke""",
    )

    dfg_2000_3 = VocabularyTerm(
        code="DFG_2000_3",
        label="2000 Lathes",
        description="""Lathes//Drehmaschinen""",
    )

    dfg_2000_4 = VocabularyTerm(
        code="DFG_2000_4",
        label="2000 Mechanics' lathes",
        description="""Mechanics` lathes//Mechaniker-Drehbänke""",
    )

    dfg_2000_5 = VocabularyTerm(
        code="DFG_2000_5",
        label="2000 Numerically controlled lathes",
        description="""Numerically controlled lathes//Numerisch gesteuerte Drehmaschinen""",
    )

    dfg_2010_1 = VocabularyTerm(
        code="DFG_2010_1",
        label="2010 Planing and planing machines",
        description="""Planing and planing machines//Hobel- und Stoßmaschinen""",
    )

    dfg_2010_2 = VocabularyTerm(
        code="DFG_2010_2",
        label="2010 Wood planing machines, -thickness planing machines",
        description="""Wood planing machines, -thickness planing machines//Holz-Hobelmaschinen, -Dickenhobelmaschinen""",
    )

    dfg_2010_3 = VocabularyTerm(
        code="DFG_2010_3",
        label="2010 Shaping machines",
        description="""Shaping machines//Shaping-Maschinen""",
    )

    dfg_2020_1 = VocabularyTerm(
        code="DFG_2020_1",
        label="2020 Boring machines (cutting)",
        description="""Boring machines (cutting)//Bohrmaschinen (spanend)""",
    )

    dfg_2020_2 = VocabularyTerm(
        code="DFG_2020_2",
        label="2020 Boring machines (except boring machines for civil engineering, mining 2390)",
        description="""Boring machines (except boring machines for civil engineering, mining 2390)//Bohrwerke (außer Bohrgeräte für Tiefbau, Bergbau 2390)""",
    )

    dfg_2020_3 = VocabularyTerm(
        code="DFG_2020_3",
        label="2020 Hand drills",
        description="""Hand drills//Handbohrmaschinen""",
    )

    dfg_2020_4 = VocabularyTerm(
        code="DFG_2020_4",
        label="2020 Impact drilling machines",
        description="""Impact drilling machines//Schlag-Bohrmaschinen""",
    )

    dfg_2020_5 = VocabularyTerm(
        code="DFG_2020_5",
        label="2020 Stationary drilling machines",
        description="""Stationary drilling machines//Ständer-Bohrmaschinen""",
    )

    dfg_2030_1 = VocabularyTerm(
        code="DFG_2030_1",
        label="2030 Milling machines",
        description="""Milling machines//Fräsmaschinen""",
    )

    dfg_2030_2 = VocabularyTerm(
        code="DFG_2030_2",
        label="2030 NC, (CNC) machine tools",
        description="""NC, (CNC) machine tools//NC-, (CNC-) Wekzeugmaschinen""",
    )

    dfg_2030_3 = VocabularyTerm(
        code="DFG_2030_3",
        label="2030 Numerically Controlled (NC) Machine Tools, Milling and Boring Machines",
        description="""Numerically Controlled (NC) Machine Tools, Milling and Boring Machines//Numerisch gesteuerte (NC) Werkzeugmaschinen, Fräs- und Bohrwerke""",
    )

    dfg_2030_4 = VocabularyTerm(
        code="DFG_2030_4",
        label="2030 Universal milling machines",
        description="""Universal milling machines//Universalfräsmaschinen""",
    )

    dfg_2030_5 = VocabularyTerm(
        code="DFG_2030_5",
        label="2030 Gear cutting machines",
        description="""Gear cutting machines//Verzahnungsmaschinen""",
    )

    dfg_2030_6 = VocabularyTerm(
        code="DFG_2030_6",
        label="2030 Wlzfrsmaschinen",
        description="""Wlzfrsmaschinen//Wälzfräsmaschinen""",
    )

    dfg_2040_1 = VocabularyTerm(
        code="DFG_2040_1",
        label="2040 Surface grinding machines",
        description="""Surface grinding machines//Flachschleifmaschinen""",
    )

    dfg_2040_2 = VocabularyTerm(
        code="DFG_2040_2",
        label="2040 Glass grinding machines",
        description="""Glass grinding machines//Glasschleifmaschinen""",
    )

    dfg_2040_3 = VocabularyTerm(
        code="DFG_2040_3",
        label="2040 Hand grinders",
        description="""Hand grinders//Handschleifmaschinen""",
    )

    dfg_2040_4 = VocabularyTerm(
        code="DFG_2040_4",
        label="2040 Honing machines",
        description="""Honing machines//Honmaschinen""",
    )

    dfg_2040_5 = VocabularyTerm(
        code="DFG_2040_5",
        label="2040 Lapping machines",
        description="""Lapping machines//Läppmaschinen""",
    )

    dfg_2040_6 = VocabularyTerm(
        code="DFG_2040_6",
        label="2040 Knife grinding machines, automatic machines",
        description="""Knife grinding machines, automatic machines//Messerschärfmaschinen, -automaten""",
    )

    dfg_2040_7 = VocabularyTerm(
        code="DFG_2040_7",
        label="2040 Cylindrical grinding machines",
        description="""Cylindrical grinding machines//Rundschleifmaschinen""",
    )

    dfg_2040_8 = VocabularyTerm(
        code="DFG_2040_8",
        label="2040 Grinding machines",
        description="""Grinding machines//Schleifmaschinen""",
    )

    dfg_2040_9 = VocabularyTerm(
        code="DFG_2040_9",
        label="2040 Tool grinding machines",
        description="""Tool grinding machines//Werkzeugschleifmaschinen""",
    )

    dfg_2050_1 = VocabularyTerm(
        code="DFG_2050_1",
        label="2050 Band saws",
        description="""Band saws//Bandsägen""",
    )

    dfg_2050_2 = VocabularyTerm(
        code="DFG_2050_2",
        label="2050 Glass cutting machines",
        description="""Glass cutting machines//Glassägen, -schneidemaschinen""",
    )

    dfg_2050_3 = VocabularyTerm(
        code="DFG_2050_3",
        label="2050 Cold cutting machines, cold circle cutting machines",
        description="""Cold cutting machines, cold circle cutting machines//Kaltsägen, Kaltkreissägen""",
    )

    dfg_2050_4 = VocabularyTerm(
        code="DFG_2050_4",
        label="2050 Chain cutting machines",
        description="""Chain cutting machines//Kettensägen""",
    )

    dfg_2050_5 = VocabularyTerm(
        code="DFG_2050_5",
        label="2050 Circular saws, hand-held circular saws",
        description="""Circular saws, hand-held circular saws//Kreissägen, Handkreissägen""",
    )

    dfg_2050_6 = VocabularyTerm(
        code="DFG_2050_6",
        label="2050 Sawing machines, saw frames",
        description="""Sawing machines, saw frames//Sägemaschinen, Sägegatter""",
    )

    dfg_2050_7 = VocabularyTerm(
        code="DFG_2050_7",
        label="2050 Shears for metals",
        description="""Shears for metals//Scheren für Metalle""",
    )

    dfg_2050_8 = VocabularyTerm(
        code="DFG_2050_8",
        label="2050 Stone saws (except 4630)",
        description="""Stone saws (except 4630)//Steinsägen (außer 4630)""",
    )

    dfg_2050_9 = VocabularyTerm(
        code="DFG_2050_9",
        label="2050 Jigsaws",
        description="""Jigsaws//Stichsägen""",
    )

    dfg_2050_10 = VocabularyTerm(
        code="DFG_2050_10",
        label="2050 Guillotine shears",
        description="""Guillotine shears//Tafelscheren""",
    )

    dfg_2050_11 = VocabularyTerm(
        code="DFG_2050_11",
        label="2050 Cutting-off machines (saws, shears)",
        description="""Cutting-off machines (saws, shears)//Trennmaschinen (Sägen, Scheren)""",
    )

    dfg_2050_12 = VocabularyTerm(
        code="DFG_2050_12",
        label="2050 Cutting-off machines",
        description="""Cutting-off machines//Trennschleifmaschinen""",
    )

    dfg_2060_1 = VocabularyTerm(
        code="DFG_2060_1",
        label="2060 Filing machines",
        description="""Filing machines//Feilmaschinen""",
    )

    dfg_2060_2 = VocabularyTerm(
        code="DFG_2060_2",
        label="2060 Thread-cutting machines, thread-slitting machines",
        description="""Thread-cutting machines, thread-slitting machines//Gewindeschneidmaschinen, -schälmaschinen""",
    )

    dfg_2060_3 = VocabularyTerm(
        code="DFG_2060_3",
        label="2060 Engraving machines (except computer-controlled 7450)",
        description="""Engraving machines (except computer-controlled 7450)//Graviermaschinen (außer rechnergesteuert 7450)""",
    )

    dfg_2060_4 = VocabularyTerm(
        code="DFG_2060_4",
        label="2060 Circular dividing machines",
        description="""Circular dividing machines//Kreis-Teilmaschinen""",
    )

    dfg_2060_5 = VocabularyTerm(
        code="DFG_2060_5",
        label="2060 Linear dividing machines",
        description="""Linear dividing machines//Längen-Teilmaschinen""",
    )

    dfg_2060_6 = VocabularyTerm(
        code="DFG_2060_6",
        label="2060 Roughing machines (production technology)",
        description="""Roughing machines (production technology)//Räummaschinen (Fertigungstechnik)""",
    )

    dfg_2060_7 = VocabularyTerm(
        code="DFG_2060_7",
        label="2060 Special cutting machine tools",
        description="""Special cutting machine tools//Spezielle spanende Werkzeugmaschinen""",
    )

    dfg_2070_1 = VocabularyTerm(
        code="DFG_2070_1",
        label="2070 Cutting and measuring platens",
        description="""Cutting and measuring platens//Anreiß- und Messplatten""",
    )

    dfg_2070_2 = VocabularyTerm(
        code="DFG_2070_2",
        label="2070 Clamping plates",
        description="""Clamping plates//Aufspannplatten""",
    )

    dfg_2070_3 = VocabularyTerm(
        code="DFG_2070_3",
        label="2070 Drilling jigs",
        description="""Drilling jigs//Bohrlehren""",
    )

    dfg_2070_4 = VocabularyTerm(
        code="DFG_2070_4",
        label="2070 Auxiliary equipment and measuring devices for machine tools",
        description="""Auxiliary equipment and measuring devices for machine tools//Hilfsgeräte und Messeinrichtungen für Werkzeugmaschinen""",
    )

    dfg_2070_5 = VocabularyTerm(
        code="DFG_2070_5",
        label="2070 Hydraulic cylinders, clamping and feed devices",
        description="""Hydraulic cylinders, clamping and feed devices//Hydraulik-Zylinder, -Spann- und Vorschubeinrichtungen""",
    )

    dfg_2070_6 = VocabularyTerm(
        code="DFG_2070_6",
        label="2070 Magnetic clamping plates",
        description="""Magnetic clamping plates//Magnetspannplatten""",
    )

    dfg_2070_7 = VocabularyTerm(
        code="DFG_2070_7",
        label="2070 Marking and labelling devices for metal",
        description="""Marking and labelling devices for metal//Markierungsgeräte, Beschriftungsgeräte für Metall""",
    )

    dfg_2070_8 = VocabularyTerm(
        code="DFG_2070_8",
        label="2070 Machine screws",
        description="""Machine screws//Maschinenschraubstöcke""",
    )

    dfg_2070_9 = VocabularyTerm(
        code="DFG_2070_9",
        label="2070 Models (production engineering and foundry)",
        description="""Models (production engineering and foundry)//Modelle (Fertigungstechnik und Gießerei)""",
    )

    dfg_2070_10 = VocabularyTerm(
        code="DFG_2070_10",
        label="2070 Pneumatic working cylinders, clamping and feed devices, except 2320",
        description="""Pneumatic working cylinders, clamping and feed devices, except 2320//Pneumatische Arbeitszylinder, Spann- und Vorschub- Einrichtungen, außer 2320""",
    )

    dfg_2070_11 = VocabularyTerm(
        code="DFG_2070_11",
        label="2070 Clamping devices",
        description="""Clamping devices//Spanneinrichtungen""",
    )

    dfg_2070_12 = VocabularyTerm(
        code="DFG_2070_12",
        label="2070 Dividing machines, dividing heads",
        description="""Dividing machines, dividing heads//Teilmaschinen, Teilköpfe""",
    )

    dfg_2070_13 = VocabularyTerm(
        code="DFG_2070_13",
        label="2070 Feed drives, copying controls (mechanical)",
        description="""Feed drives, copying controls (mechanical)//Vorschub-Antriebe, Kopiersteuerungen (mechanisch)""",
    )

    dfg_2070_14 = VocabularyTerm(
        code="DFG_2070_14",
        label="2070 Machine tool accessories",
        description="""Machine tool accessories//Werkzeugmaschinenzubehör""",
    )

    dfg_2070_15 = VocabularyTerm(
        code="DFG_2070_15",
        label="2070 Cylinders, rotary, stroke, linear (hydraulic, pneumatic, (except presses 2900-2920))",
        description="""Cylinders, rotary, stroke, linear (hydraulic, pneumatic, (except presses 2900-2920))//Zylinder, Dreh-, Hub-, Linear-Zylinder (hydraulisch, pneumatisch, (außer Prüfmaschinen 2900-2920))""",
    )

    dfg_2090_1 = VocabularyTerm(
        code="DFG_2090_1",
        label="2090 Flexible shafts, grinding and milling motors (except 3680, dentistry)",
        description="""Flexible shafts, grinding and milling motors (except 3680, dentistry)//Biegsame Wellen, Schleif- und Fräsmotore (außer 3680, Zahnmedizin)""",
    )

    dfg_2090_2 = VocabularyTerm(
        code="DFG_2090_2",
        label="2090 Universal workshop tools",
        description="""Universal workshop tools//Universal-Werkstattgeräte""",
    )

    dfg_2090_3 = VocabularyTerm(
        code="DFG_2090_3",
        label="2090 Machine tools, cutting (except 2000-2070)",
        description="""Machine tools, cutting (except 2000-2070)//Werkzeugmaschinen, spanend (außer 2000-2070)""",
    )

    dfg_2099_1 = VocabularyTerm(
        code="DFG_2099_1",
        label="2099 3D printers for metallic materials",
        description="""3D printers for metallic materials//3D-Drucker für metallische Werkstoffe""",
    )

    dfg_2100_1 = VocabularyTerm(
        code="DFG_2100_1",
        label="2100 Printing machines",
        description="""Printing machines//Druckgußmaschinen""",
    )

    dfg_2100_2 = VocabularyTerm(
        code="DFG_2100_2",
        label="2100 Casting machines (injection moulding, continuous casting)",
        description="""Casting machines (injection moulding, continuous casting)//Gießanlagen (Spritzguss, Strangguss)""",
    )

    dfg_2100_3 = VocabularyTerm(
        code="DFG_2100_3",
        label="2100 Centrifugal casting machines",
        description="""Centrifugal casting machines//Schleudergußmaschinen""",
    )

    dfg_2100_4 = VocabularyTerm(
        code="DFG_2100_4",
        label="2100 Injection moulding machines (for metals)",
        description="""Injection moulding machines (for metals)//Spritzgußmaschinen (für Metalle)""",
    )

    dfg_2100_5 = VocabularyTerm(
        code="DFG_2100_5",
        label="2100 Continuous casting machines",
        description="""Continuous casting machines//Stranggußanlagen""",
    )

    dfg_2110_1 = VocabularyTerm(
        code="DFG_2110_1",
        label="2110 Additive manufacturing equipment (except SLM/laser welding)",
        description="""Additive manufacturing equipment (except SLM/laser welding)//Anlagen der additiven Fertigung (außer SLM/Laserschweißverfahren)""",
    )

    dfg_2110_2 = VocabularyTerm(
        code="DFG_2110_2",
        label="2110 Moulding boxes (moulding)",
        description="""Moulding boxes (moulding)//Formkästen (Gießerei-)""",
    )

    dfg_2110_3 = VocabularyTerm(
        code="DFG_2110_3",
        label="2110 Moulding templates (moulding)",
        description="""Moulding templates (moulding)//Formschablonen (Gießerei-)""",
    )

    dfg_2110_4 = VocabularyTerm(
        code="DFG_2110_4",
        label="2110 Mould and pattern making and casting machines",
        description="""Mould and pattern making and casting machines//Maschinen zur Formen- und Modellherstellung und gießereitechnische Maschinen""",
    )

    dfg_2110_5 = VocabularyTerm(
        code="DFG_2110_5",
        label="2110 Machines for fettling (foundry)",
        description="""Machines for fettling foundry)//Putzereimaschinen (Gießerei-)""",
    )

    dfg_2110_6 = VocabularyTerm(
        code="DFG_2110_6",
        label="2110 Rapid prototyping, rapid tooling systems",
        description="""Rapid prototyping, rapid tooling systems//Rapid-Prototyping-, Rapid-Tooling-Systeme""",
    )

    dfg_2110_7 = VocabularyTerm(
        code="DFG_2110_7",
        label="2110 Stereo lithography systems",
        description="""Stereo lithography systems//Stereo-Lithographie-Systeme""",
    )

    dfg_2120_1 = VocabularyTerm(
        code="DFG_2120_1",
        label="2120 Drop hammers",
        description="""Drop hammers//Fallhämmer""",
    )

    dfg_2120_2 = VocabularyTerm(
        code="DFG_2120_2",
        label="2120 Drop forging presses",
        description="""Drop forging presses//Gesenkschmiedepressen""",
    )

    dfg_2120_3 = VocabularyTerm(
        code="DFG_2120_3",
        label="2120 Cold rolling",
        description="""Cold rolling//Kaltwalzen""",
    )

    dfg_2120_4 = VocabularyTerm(
        code="DFG_2120_4",
        label="2120 Rolling machines, rolling machines for threads",
        description="""Rolling machines, rolling machines for threads//Rolliermaschinen, Rollmaschinen für Gewinde""",
    )

    dfg_2120_5 = VocabularyTerm(
        code="DFG_2120_5",
        label="2120 Rolling",
        description="""Rolling//Walzen""",
    )

    dfg_2120_6 = VocabularyTerm(
        code="DFG_2120_6",
        label="2120 Rolling machines, hammer mills and forging presses",
        description="""Rolling machines, hammer mills and forging presses//Walzmaschinen, Hammerwerke und Schmiedepressen""",
    )

    dfg_2130_1 = VocabularyTerm(
        code="DFG_2130_1",
        label="2130 Press brakes",
        description="""Press brakes//Abkantpressen""",
    )

    dfg_2130_2 = VocabularyTerm(
        code="DFG_2130_2",
        label="2130 Press brakes",
        description="""Press brakes//Bördelmaschinen""",
    )

    dfg_2130_3 = VocabularyTerm(
        code="DFG_2130_3",
        label="2130 Wire drawing machines",
        description="""Wire drawing machines//Draht-Ziehmaschinen""",
    )

    dfg_2130_4 = VocabularyTerm(
        code="DFG_2130_4",
        label="2130 Spring bending, coiling machines",
        description="""Spring bending, coiling machines//Federbiege, -wickelmaschinen""",
    )

    dfg_2130_5 = VocabularyTerm(
        code="DFG_2130_5",
        label="2130 Fly presses",
        description="""Fly presses//Fließpressen""",
    )

    dfg_2130_6 = VocabularyTerm(
        code="DFG_2130_6",
        label="2130 Hydraulic presses (forming technology, except laboratory presses 1980 and forging presses 2120)",
        description="""Hydraulic presses (forming technology, except laboratory presses 1980 and forging presses 2120)//Hydraulische Pressen (Umformtechnik, außer Laborpressen 1980 und Schmiedepressen 2120)""",
    )

    dfg_2130_7 = VocabularyTerm(
        code="DFG_2130_7",
        label="2130 Presses (except 0850, 1980 and 2120)",
        description="""Presses (except 0850, 1980 and 2120)//Pressen (außer 0850, 1980 und 2120)""",
    )

    dfg_2130_8 = VocabularyTerm(
        code="DFG_2130_8",
        label="2130 Presses and machines for bending, stretching, punching, pressing, drawing",
        description="""Presses and machines for bending, stretching, punching, pressing, drawing//Pressen und Maschinen zum Biegen, Drücken, Stanzen, Prägen, Ziehen""",
    )

    dfg_2130_9 = VocabularyTerm(
        code="DFG_2130_9",
        label="2130 Profile drawing machines",
        description="""Profile drawing machines//Profil-Ziehmaschinen""",
    )

    dfg_2130_10 = VocabularyTerm(
        code="DFG_2130_10",
        label="2130 Straightening machines",
        description="""Straightening machines//Richtmaschinen""",
    )

    dfg_2130_11 = VocabularyTerm(
        code="DFG_2130_11",
        label="2130 Beading machines",
        description="""Beading machines//Sickenmaschinen""",
    )

    dfg_2130_12 = VocabularyTerm(
        code="DFG_2130_12",
        label="2130 Punching, pressing",
        description="""Punching, pressing//Stanzen, Pressen""",
    )

    dfg_2130_13 = VocabularyTerm(
        code="DFG_2130_13",
        label="2130 Extrusion presses",
        description="""Extrusion presses//Strangpressen""",
    )

    dfg_2130_14 = VocabularyTerm(
        code="DFG_2130_14",
        label="2130 Deep-drawing presses",
        description="""Deep-drawing presses//Tiefziehpressen""",
    )

    dfg_2140_1 = VocabularyTerm(
        code="DFG_2140_1",
        label="2140 Explosive forming equipment",
        description="""Explosive forming equipment//Explosionsumformungsgeräte""",
    )

    dfg_2140_2 = VocabularyTerm(
        code="DFG_2140_2",
        label="2140 Machines and equipment for special forming processes",
        description="""Machines and equipment for special forming processes//Maschinen und Einrichtungen für spezielle Umformverfahren""",
    )

    dfg_2150_1 = VocabularyTerm(
        code="DFG_2150_1",
        label="2150 Oxyacetylene welding equipment",
        description="""Oxyacetylene welding equipment//Autogen-Schweißgeräte""",
    )

    dfg_2150_2 = VocabularyTerm(
        code="DFG_2150_2",
        label="2150 Electric arc welding equipment (except 2620)",
        description="""Electric arc welding equipment (except 2620)//Elektro-, Lichtbogen -Schweißgeräte (außer 2620)""",
    )

    dfg_2150_3 = VocabularyTerm(
        code="DFG_2150_3",
        label="2150 Electron beam welders",
        description="""Electron beam welders//Elektronenstrahl-Schweißgeräte""",
    )

    dfg_2150_4 = VocabularyTerm(
        code="DFG_2150_4",
        label="2150 Arc welding equipment, machines",
        description="""Arc welding equipment, machines//Lichtbogen-Schweißgeräte, -Maschinen""",
    )

    dfg_2150_5 = VocabularyTerm(
        code="DFG_2150_5",
        label="2150 Arc spraying equipment",
        description="""Arc spraying equipment//Lichtbogen-Spritzeinrichtungen""",
    )

    dfg_2150_6 = VocabularyTerm(
        code="DFG_2150_6",
        label="2150 Metal spraying equipment (surface coating)",
        description="""Metal spraying equipment (surface coating)//Metall-Spritzgeräte (Oberflächen-Auftrag)""",
    )

    dfg_2150_7 = VocabularyTerm(
        code="DFG_2150_7",
        label="2150 Plasma welding equipment",
        description="""Plasma welding equipment//Plasma-Schweißgeräte""",
    )

    dfg_2150_8 = VocabularyTerm(
        code="DFG_2150_8",
        label="2150 Spot welding machines",
        description="""Spot welding machines//Punktschweißmaschinen""",
    )

    dfg_2150_9 = VocabularyTerm(
        code="DFG_2150_9",
        label="2150 Friction welding machines",
        description="""Friction welding machines//Reibschweißmaschinen""",
    )

    dfg_2150_10 = VocabularyTerm(
        code="DFG_2150_10",
        label="2150 Welding torches",
        description="""Welding torches//Schweißbrenner""",
    )

    dfg_2150_11 = VocabularyTerm(
        code="DFG_2150_11",
        label="2150 Welding and flame cutting machines",
        description="""Welding and flame cutting machines//Schweißmaschinen und Brennschneidemaschinen""",
    )

    dfg_2150_12 = VocabularyTerm(
        code="DFG_2150_12",
        label="2150 Butt welding machines",
        description="""Butt welding machines//Stumpfschweißmaschinen""",
    )

    dfg_2150_13 = VocabularyTerm(
        code="DFG_2150_13",
        label="2150 Resistance welding machines",
        description="""Resistance welding machines//Widerstandsschweißmaschinen""",
    )

    dfg_2160_1 = VocabularyTerm(
        code="DFG_2160_1",
        label="2160 Bonding machines",
        description="""Bonding machines//Bondergeräte""",
    )

    dfg_2160_2 = VocabularyTerm(
        code="DFG_2160_2",
        label="2160 Through-hole plating machines for printed circuit boards",
        description="""Through-hole plating machines for printed circuit boards//Durchkontaktiergeräte für Leiterplatten""",
    )

    dfg_2160_3 = VocabularyTerm(
        code="DFG_2160_3",
        label="2160 Dischargers",
        description="""Dischargers//Entlötgeräte""",
    )

    dfg_2160_4 = VocabularyTerm(
        code="DFG_2160_4",
        label="2160 Semiconductor contacting machines, wire bonders",
        description="""Semiconductor contacting machines, wire bonders//Halbleiter-Kontaktiergeräte, Drahtbonder""",
    )

    dfg_2160_5 = VocabularyTerm(
        code="DFG_2160_5",
        label="2160 Soldering machines, soldering belts, contacting devices",
        description="""Soldering machines, soldering belts, contacting devices//Lötmaschinen, Lötbäder, Kontaktiergeräte""",
    )

    dfg_2160_6 = VocabularyTerm(
        code="DFG_2160_6",
        label="2160 Soldering guns",
        description="""Soldering guns//Lötpistolen""",
    )

    dfg_2160_7 = VocabularyTerm(
        code="DFG_2160_7",
        label="2160 Spot heaters",
        description="""Spot heaters//Punktheizgeräte""",
    )

    dfg_2160_8 = VocabularyTerm(
        code="DFG_2160_8",
        label="2160 Thermocompression connectors, bonders",
        description="""Thermocompression connectors, bonders//Thermokompressionsverbinder, -bonder""",
    )

    dfg_2160_9 = VocabularyTerm(
        code="DFG_2160_9",
        label="2160 Tin bonders",
        description="""Tin bonders//Zinnbäder""",
    )

    dfg_2170_1 = VocabularyTerm(
        code="DFG_2170_1",
        label="2170 Tzgerte, -machines",
        description="""Tzgerte, -machines//Ätzgeräte, -Maschinen""",
    )

    dfg_2170_2 = VocabularyTerm(
        code="DFG_2170_2",
        label="2170 Chemical sges, electrolysis-tz machines, spark erosion sges",
        description="""Chemical sges, electrolysis-tz machines, spark erosion sges//Chemische Sägen, Elektrolyse-Ätz-Maschinen, Funkenerosionsgeräte""",
    )

    dfg_2170_3 = VocabularyTerm(
        code="DFG_2170_3",
        label="2170 Wire erosion machines (electrochemical)",
        description="""Wire erosion machines (electrochemical)//Draht-Erosionsmaschinen (elektrochemische)""",
    )

    dfg_2170_4 = VocabularyTerm(
        code="DFG_2170_4",
        label="2170 Electrochemical sinking machines (ECM), cutting-off machines",
        description="""Electrochemical sinking machines (ECM), cutting-off machines//Elektrochemische Senkmaschinen (ECM), Trennmaschinen""",
    )

    dfg_2170_5 = VocabularyTerm(
        code="DFG_2170_5",
        label="2170 Electro-erosion machines (EDM)",
        description="""Electro-erosion machines (EDM)//Elektroerosionsmaschinen (EDM)""",
    )

    dfg_2170_6 = VocabularyTerm(
        code="DFG_2170_6",
        label="2170 Printed circuit board etching machines",
        description="""Printed circuit board etching machines//Leiterplatten-Ätzmaschinen""",
    )

    dfg_2170_7 = VocabularyTerm(
        code="DFG_2170_7",
        label="2170 Countersinking machines, electrochemical",
        description="""Countersinking machines, electrochemical//Senkmaschinen, elektrochemische""",
    )

    dfg_2170_8 = VocabularyTerm(
        code="DFG_2170_8",
        label="2170 Ultrasonic processing machines",
        description="""Ultrasonic processing machines//Ultraschall-Bearbeitungsmaschinen""",
    )

    dfg_2180_1 = VocabularyTerm(
        code="DFG_2180_1",
        label="2180 Pickling tongs",
        description="""Pickling tongs//Beizgeräte""",
    )

    dfg_2180_2 = VocabularyTerm(
        code="DFG_2180_2",
        label="2180 Coating machines",
        description="""Coating machines//Beschichtungsgeräte""",
    )

    dfg_2180_3 = VocabularyTerm(
        code="DFG_2180_3",
        label="2180 Bonder tanning machines (pickling and bonding machines)",
        description="""Bonder tanning machines (pickling and bonding machines)//Bondergeräte (Beiz- und Bonderanlagen)""",
    )

    dfg_2180_4 = VocabularyTerm(
        code="DFG_2180_4",
        label="2180 Brst machines",
        description="""Brst machines//Bürst-Maschinen""",
    )

    dfg_2180_5 = VocabularyTerm(
        code="DFG_2180_5",
        label="2180 Anodising equipment",
        description="""Anodising equipment//Eloxiergeräte""",
    )

    dfg_2180_6 = VocabularyTerm(
        code="DFG_2180_6",
        label="2180 Paint spraying equipment",
        description="""Paint spraying equipment//Farbspritzgeräte""",
    )

    dfg_2180_7 = VocabularyTerm(
        code="DFG_2180_7",
        label="2180 Foil laminating equipment, laminators",
        description="""Foil laminating equipment, laminators//Folien-Laminiergeräte, Laminatoren""",
    )

    dfg_2180_8 = VocabularyTerm(
        code="DFG_2180_8",
        label="2180 Impregnating equipment",
        description="""Impregnating equipment//Imprägniergeräte""",
    )

    dfg_2180_9 = VocabularyTerm(
        code="DFG_2180_9",
        label="2180 Painting equipment",
        description="""Painting equipment//Lackiergeräte""",
    )

    dfg_2180_10 = VocabularyTerm(
        code="DFG_2180_10",
        label="2180 Laminators, coating equipment",
        description="""Laminators, coating equipment//Laminatoren, Beschichtungsgeräte""",
    )

    dfg_2180_11 = VocabularyTerm(
        code="DFG_2180_11",
        label="2180 Surface treatment machines (electropolishing, galvanising, painting, sandblasting)",
        description="""Surface treatment machines (electropolishing, galvanising, painting, sandblasting)//Maschinen für Oberflächenbehandlung (Elektropolieren, Galvanisieren, Lackieren, Sandstrahlen)""",
    )

    dfg_2190_1 = VocabularyTerm(
        code="DFG_2190_1",
        label="2190 PCB assembly machines",
        description="""PCB assembly machines//Bestückungsmaschinen für Leiterplattenfertigung""",
    )

    dfg_2190_2 = VocabularyTerm(
        code="DFG_2190_2",
        label="2190 Wire winding machines, armature winding machines",
        description="""Wire winding machines, armature winding machines//Draht-Wickelmaschinen, Ankerwickelmaschinen""",
    )

    dfg_2190_3 = VocabularyTerm(
        code="DFG_2190_3",
        label="2190 Reelers for strip and wire material",
        description="""Reelers for strip and wire material//Haspeln für Band- und Drahtmaterial""",
    )

    dfg_2190_4 = VocabularyTerm(
        code="DFG_2190_4",
        label="2190 Power wrenches, impact wrenches",
        description="""Power wrenches, impact wrenches//Kraftschrauber, Schlagschrauber""",
    )

    dfg_2190_5 = VocabularyTerm(
        code="DFG_2190_5",
        label="2190 Automatic assembly machines (except 2320 and 4660)",
        description="""Automatic assembly machines (except 2320 and 4660)//Montage-Maschinen, -Automaten (außer 2320 und 4660)""",
    )

    dfg_2190_6 = VocabularyTerm(
        code="DFG_2190_6",
        label="2190 Riveting machines, riveting hammers",
        description="""Riveting machines, riveting hammers//Nietmaschinen, Niethämmer""",
    )

    dfg_2190_7 = VocabularyTerm(
        code="DFG_2190_7",
        label="2190 Screwdriving tools, power screwdrivers",
        description="""Screwdriving tools, power screwdrivers//Schraubwerkzeuge, Kraftschrauber""",
    )

    dfg_2190_8 = VocabularyTerm(
        code="DFG_2190_8",
        label="2190 Coil winding machines",
        description="""Coil winding machines//Spulenwickelmaschinen""",
    )

    dfg_2190_9 = VocabularyTerm(
        code="DFG_2190_9",
        label="2190 Forming machines, machines (except 2100-2170)",
        description="""Forming machines, machines (except 2100-2170)//Umformtechnik, Maschinen (außer 2100-2170)""",
    )

    dfg_2190_10 = VocabularyTerm(
        code="DFG_2190_10",
        label="2190 Stranding machines",
        description="""Stranding machines//Verseilmaschinen""",
    )

    dfg_2190_11 = VocabularyTerm(
        code="DFG_2190_11",
        label="2190 Machine tools, non-cutting, machining (except 2100-2170)",
        description="""Machine tools, non-cutting, machining (except 2100-2170)//Werkzeugmaschinen, spanlos, Bearbeitungsmaschinen (außer 2100-2170)""",
    )

    dfg_2190_12 = VocabularyTerm(
        code="DFG_2190_12",
        label="2190 Winding machines for composite materials",
        description="""Winding machines for composite materials//Wickelmaschinen für Verbundwerkstoffe""",
    )

    dfg_2200_1 = VocabularyTerm(
        code="DFG_2200_1",
        label="2200 3D printers for plastics",
        description="""3D printers for plastics//3D-Drucker für Kunststoffe""",
    )

    dfg_2200_2 = VocabularyTerm(
        code="DFG_2200_2",
        label="2200 Extruders (for plastics)",
        description="""Extruders (for plastics)//Extruder (für Kunststoffe)""",
    )

    dfg_2200_3 = VocabularyTerm(
        code="DFG_2200_3",
        label="2200 Film blowing machines",
        description="""Film blowing machines//Folienblasmaschinen""",
    )

    dfg_2200_4 = VocabularyTerm(
        code="DFG_2200_4",
        label="2200 Plastics extruders and blow-moulding machines",
        description="""Plastics extruders and blow-moulding machines//Kunststoffextruder und -blasmaschinen""",
    )

    dfg_2200_5 = VocabularyTerm(
        code="DFG_2200_5",
        label="2200 Profile presses for plastics",
        description="""Profile presses for plastics//Profilpressen für Kunststoffe""",
    )

    dfg_2200_6 = VocabularyTerm(
        code="DFG_2200_6",
        label="2200 Screw presses for plastics",
        description="""Screw presses for plastics//Schneckenpressen für Kunststoffe""",
    )

    dfg_2210_1 = VocabularyTerm(
        code="DFG_2210_1",
        label="2210 Moulding machines for plastics",
        description="""Moulding machines for plastics//Formspritzmaschinen für Kunststoffe""",
    )

    dfg_2210_2 = VocabularyTerm(
        code="DFG_2210_2",
        label="2210 Moulding machines for plastics",
        description="""Moulding machines for plastics//Gießanlagen für Kunststoffe""",
    )

    dfg_2210_3 = VocabularyTerm(
        code="DFG_2210_3",
        label="2210 Plastic presses and injection moulding machines",
        description="""Plastic presses and injection moulding machines//Kunststoffpressen und -spritzgußgeräte""",
    )

    dfg_2210_4 = VocabularyTerm(
        code="DFG_2210_4",
        label="2210 Presses for plastic parts",
        description="""Presses for plastic parts//Pressen für Kunststoffteile""",
    )

    dfg_2210_5 = VocabularyTerm(
        code="DFG_2210_5",
        label="2210 Foaming and spraying machines for plastics",
        description="""Foaming and spraying machines for plastics//Schäum- und Spritzmaschinen für Kunststoffe""",
    )

    dfg_2220_1 = VocabularyTerm(
        code="DFG_2220_1",
        label="2220 Glass-working machines",
        description="""Glass-working machines//Glasbearbeitungsmaschinen""",
    )

    dfg_2220_2 = VocabularyTerm(
        code="DFG_2220_2",
        label="2220 Glass blowing equipment, machines",
        description="""Glass blowing equipment, machines//Glasblasgeräte, -maschinen""",
    )

    dfg_2220_3 = VocabularyTerm(
        code="DFG_2220_3",
        label="2220 Glass presses",
        description="""Glass presses//Glaspressen""",
    )

    dfg_2220_4 = VocabularyTerm(
        code="DFG_2220_4",
        label="2220 Glass melting furnaces, vats",
        description="""Glass melting furnaces, vats//Glasschmelzöfen, -wannen""",
    )

    dfg_2230_1 = VocabularyTerm(
        code="DFG_2230_1",
        label="2230 Tanning machines (laboratory) for textiles",
        description="""Tanning machines (laboratory) for textiles//Färbegeräte (Labor-) für Textilien""",
    )

    dfg_2230_2 = VocabularyTerm(
        code="DFG_2230_2",
        label="2230 Sewing machines (industrial)",
        description="""Sewing machines (industrial)//Nähmaschinen (industrielle)""",
    )

    dfg_2230_3 = VocabularyTerm(
        code="DFG_2230_3",
        label="2230 Spinning machines",
        description="""Spinning machines//Spinnmaschinen""",
    )

    dfg_2230_4 = VocabularyTerm(
        code="DFG_2230_4",
        label="2230 Control systems for weaving and knitting machines, Jacquard equipment",
        description="""Control systems for weaving and knitting machines, Jacquard equipment//Steuerungen für Web- und Wirkmaschinen, Jacquard- Einrichtungen""",
    )

    dfg_2230_5 = VocabularyTerm(
        code="DFG_2230_5",
        label="2230 Textile finishing equipment",
        description="""Textile finishing equipment//Textilausrüstungsgeräte""",
    )

    dfg_2230_6 = VocabularyTerm(
        code="DFG_2230_6",
        label="2230 Textile machinery",
        description="""Textile machinery//Textilmaschinen""",
    )

    dfg_2230_7 = VocabularyTerm(
        code="DFG_2230_7",
        label="2230 Textile cutting machines (CNC)",
        description="""Textile cutting machines (CNC)//Textil-Zuschnittmaschinen (CNC)""",
    )

    dfg_2230_8 = VocabularyTerm(
        code="DFG_2230_8",
        label="2230 Weaving machines",
        description="""Weaving machines//Webmaschinen""",
    )

    dfg_2230_9 = VocabularyTerm(
        code="DFG_2230_9",
        label="2230 Knitting machines, knitting machines",
        description="""Knitting machines, knitting machines//Wirkmaschinen, Strickmaschinen""",
    )

    dfg_2240_1 = VocabularyTerm(
        code="DFG_2240_1",
        label="2240 Veneering machines, presses",
        description="""Veneering machines, presses//Furniermaschinen, -pressen""",
    )

    dfg_2240_2 = VocabularyTerm(
        code="DFG_2240_2",
        label="2240 Woodworking machinery (except 2000-2050)",
        description="""Woodworking machinery (except 2000-2050)//Holzverarbeitungsmaschinen (außer 2000-2050)""",
    )

    dfg_2240_3 = VocabularyTerm(
        code="DFG_2240_3",
        label="2240 Imprinting machines (wood)",
        description="""Imprinting machines (wood)//Imprägniermaschinen (Holz-)""",
    )

    dfg_2240_4 = VocabularyTerm(
        code="DFG_2240_4",
        label="2240 Box nailing machines",
        description="""Box nailing machines//Kistennagelmaschinen""",
    )

    dfg_2240_5 = VocabularyTerm(
        code="DFG_2240_5",
        label="2240 Wood and paper processing machinery",
        description="""Wood and paper processing machinery//Maschinen für Holz- und Papierverarbeitung""",
    )

    dfg_2240_6 = VocabularyTerm(
        code="DFG_2240_6",
        label="2240 Paper machinery",
        description="""Paper machinery//Papiermaschinen""",
    )

    dfg_2240_7 = VocabularyTerm(
        code="DFG_2240_7",
        label="2240 Paper converting machinery (except 2260)",
        description="""Paper converting machinery (except 2260)//Papierverarbeitungs-Maschinen (außer 2260)""",
    )

    dfg_2250_1 = VocabularyTerm(
        code="DFG_2250_1",
        label="2250 Composing (setting) machines",
        description="""Composing (setting) machines//Composer (Setzmaschinen)""",
    )

    dfg_2250_2 = VocabularyTerm(
        code="DFG_2250_2",
        label="2250 Forme engraving machines",
        description="""Forme engraving machines//Druckform-Graviermaschinen""",
    )

    dfg_2250_3 = VocabularyTerm(
        code="DFG_2250_3",
        label="2250 Colour scanners (reproduction technology)",
        description="""Colour scanners (reproduction technology)//Farbscanner (Reproduktionstechnik)""",
    )

    dfg_2250_4 = VocabularyTerm(
        code="DFG_2250_4",
        label="2250 Light-setting machines",
        description="""Light-setting machines//Lichtsetzgeräte, -maschinen""",
    )

    dfg_2250_5 = VocabularyTerm(
        code="DFG_2250_5",
        label="2250 Photographic typesetting machines",
        description="""Photographic typesetting machines//Photosetzgeräte""",
    )

    dfg_2250_6 = VocabularyTerm(
        code="DFG_2250_6",
        label="2250 Typesetting equipment",
        description="""Typesetting equipment//Setzerei-Einrichtungen""",
    )

    dfg_2250_7 = VocabularyTerm(
        code="DFG_2250_7",
        label="2250 Typesetting machines, printing blocks and reproduction equipment (except cameras)",
        description="""Typesetting machines, printing blocks and reproduction equipment (except cameras)//Setzmaschinen, Klischiergeräte und reproduktionstechnische Geräte (außer Kameras)""",
    )

    dfg_2250_8 = VocabularyTerm(
        code="DFG_2250_8",
        label="2250 Line width converters, photographic",
        description="""Line width converters, photographic//Strichbreite-Wandler, photographische""",
    )

    dfg_2260_1 = VocabularyTerm(
        code="DFG_2260_1",
        label="2260 Bookbinding machines",
        description="""Bookbinding machines//Buchbindermaschinen""",
    )

    dfg_2260_2 = VocabularyTerm(
        code="DFG_2260_2",
        label="2260 Printing presses and auxiliary printing machinery",
        description="""Printing presses and auxiliary printing machinery//Druckmaschinen und Druckerei-Hilfsgeräte""",
    )

    dfg_2260_3 = VocabularyTerm(
        code="DFG_2260_3",
        label="2260 Hand punching machines (paper)",
        description="""Hand punching machines (paper)//Handstanzen (Papier)""",
    )

    dfg_2260_4 = VocabularyTerm(
        code="DFG_2260_4",
        label="2260 Stitching machines",
        description="""Stitching machines//Heftmaschinen""",
    )

    dfg_2260_5 = VocabularyTerm(
        code="DFG_2260_5",
        label="2260 Off-set printing machines",
        description="""Off-set printing machines//Off-Set-Druckmaschinen""",
    )

    dfg_2260_6 = VocabularyTerm(
        code="DFG_2260_6",
        label="2260 Paper drilling machines",
        description="""Paper drilling machines//Papierbohrmaschinen""",
    )

    dfg_2260_7 = VocabularyTerm(
        code="DFG_2260_7",
        label="2260 Perforating presses",
        description="""Perforating presses//Perforierpressen""",
    )

    dfg_2260_8 = VocabularyTerm(
        code="DFG_2260_8",
        label="2260 Presses (printing)",
        description="""Presses (printing)//Pressen (Druckerei)""",
    )

    dfg_2260_9 = VocabularyTerm(
        code="DFG_2260_9",
        label="2260 Cutting machines (paper)",
        description="""Cutting machines (paper)//Schneidemaschinen (Papier)""",
    )

    dfg_2260_10 = VocabularyTerm(
        code="DFG_2260_10",
        label="2260 Screen printing machines",
        description="""Screen printing machines//Siebdruckmaschinen""",
    )

    dfg_2260_11 = VocabularyTerm(
        code="DFG_2260_11",
        label="2260 Test and proof presses (printing)",
        description="""Test and proof presses (printing)//Test- und Prüfpressen (Druckerei)""",
    )

    dfg_2260_12 = VocabularyTerm(
        code="DFG_2260_12",
        label="2260 Rotogravure printing machines, rotogravure copying machines",
        description="""Rotogravure printing machines, rotogravure copying machines//Tiefdruckmaschinen, Tiefdruck-Kopiermaschinen""",
    )

    dfg_2270_1 = VocabularyTerm(
        code="DFG_2270_1",
        label="2270 Tanning machines",
        description="""Tanning machines//Gerbereigeräte""",
    )

    dfg_2270_2 = VocabularyTerm(
        code="DFG_2270_2",
        label="2270 Special processing machines for ceramic materials, rubber, leather",
        description="""Special processing machines for ceramic materials, rubber, leather//Spezielle Bearbeitungsmaschinen für keramische Werkstoffe, Gummi, Leder""",
    )

    dfg_2270_3 = VocabularyTerm(
        code="DFG_2270_3",
        label="2270 Vulcanising machines",
        description="""Vulcanising machines//Vulkanisiergeräte""",
    )

    dfg_2290_1 = VocabularyTerm(
        code="DFG_2290_1",
        label="2290 Calenders, laboratory calenders",
        description="""Calenders, laboratory calenders//Kalander, Laborkalander""",
    )

    dfg_2290_2 = VocabularyTerm(
        code="DFG_2290_2",
        label="2290 Gluing machines",
        description="""Gluing machines//Klebemaschinen""",
    )

    dfg_2290_3 = VocabularyTerm(
        code="DFG_2290_3",
        label="2290 Fibre optic processing equipment",
        description="""Fibre optic processing equipment//Lichtleiterbearbeitungs-Einrichtungen""",
    )

    dfg_2290_4 = VocabularyTerm(
        code="DFG_2290_4",
        label="2290 Welding machines (ultrasound) for plastics",
        description="""Welding machines (ultrasound) for plastics//Schweißmaschinen (Ultraschall) für Kunststoffe""",
    )

    dfg_2290_5 = VocabularyTerm(
        code="DFG_2290_5",
        label="2290 Other processing machines for non-metallic materials",
        description="""Other processing machines for non-metallic materials//Sonstige Bearbeitungsmaschinen für nichtmetallische Werkstoffe""",
    )

    dfg_2300_1 = VocabularyTerm(
        code="DFG_2300_1",
        label="2300 Building materials machinery",
        description="""Building materials machinery//Baustoffmaschinen""",
    )

    dfg_2300_2 = VocabularyTerm(
        code="DFG_2300_2",
        label="2300 Building material mixing machines",
        description="""Building material mixing machines//Baustoffmischmaschinen""",
    )

    dfg_2300_3 = VocabularyTerm(
        code="DFG_2300_3",
        label="2300 Building material presses, moulding machines",
        description="""Building material presses, moulding machines//Baustoffpressen, -formmaschinen""",
    )

    dfg_2300_4 = VocabularyTerm(
        code="DFG_2300_4",
        label="2300 Concrete mixing machines, silos",
        description="""Concrete mixing machines, silos//Beton-Mischmaschinen, -Silos""",
    )

    dfg_2300_5 = VocabularyTerm(
        code="DFG_2300_5",
        label="2300 Concrete mixers",
        description="""Concrete mixers//Mörtelmischer""",
    )

    dfg_2310_1 = VocabularyTerm(
        code="DFG_2310_1",
        label="2310 Passenger and freight elevators",
        description="""Passenger and freight elevators//Personen- und Lastenaufzüge""",
    )

    dfg_2320_1 = VocabularyTerm(
        code="DFG_2320_1",
        label="2320 Construction cranes",
        description="""Construction cranes//Baukräne""",
    )

    dfg_2320_2 = VocabularyTerm(
        code="DFG_2320_2",
        label="2320 Bottle crushers",
        description="""Bottle crushers//Flaschenzüge""",
    )

    dfg_2320_3 = VocabularyTerm(
        code="DFG_2320_3",
        label="2320 Flexible manufacturing and assembly systems",
        description="""Flexible manufacturing and assembly systems//Flexible Fertigungs- und Montage-Systeme""",
    )

    dfg_2320_4 = VocabularyTerm(
        code="DFG_2320_4",
        label="2320 Gripping and lifting tools, loading equipment",
        description="""Gripping and lifting tools, loading equipment//Greif- und Hebewerkzeuge, Verladeeinrichtungen""",
    )

    dfg_2320_5 = VocabularyTerm(
        code="DFG_2320_5",
        label="2320 Handling equipment",
        description="""Handling equipment//Handhabungsgeräte""",
    )

    dfg_2320_6 = VocabularyTerm(
        code="DFG_2320_6",
        label="2320 Lifting tables",
        description="""Lifting tables//Hubtische""",
    )

    dfg_2320_7 = VocabularyTerm(
        code="DFG_2320_7",
        label="2320 Industrial robots, handling equipment",
        description="""Industrial robots, handling equipment//Industrie-Roboter, Handhabungsgeräte""",
    )

    dfg_2320_8 = VocabularyTerm(
        code="DFG_2320_8",
        label="2320 Cranes",
        description="""Cranes//Kräne""",
    )

    dfg_2320_9 = VocabularyTerm(
        code="DFG_2320_9",
        label="2320 Palletising equipment",
        description="""Palletising equipment//Palettieranlagen""",
    )

    dfg_2320_10 = VocabularyTerm(
        code="DFG_2320_10",
        label="2320 Ropes, wire ropes",
        description="""Ropes, wire ropes//Seile, Drahtseile""",
    )

    dfg_2320_11 = VocabularyTerm(
        code="DFG_2320_11",
        label="2320 Winches",
        description="""Winches//Seilwinden""",
    )

    dfg_2320_12 = VocabularyTerm(
        code="DFG_2320_12",
        label="2320 Winches",
        description="""Winches//Winden""",
    )

    dfg_2330_1 = VocabularyTerm(
        code="DFG_2330_1",
        label="2330 Flyers",
        description="""Flyers//Fließbänder""",
    )

    dfg_2330_2 = VocabularyTerm(
        code="DFG_2330_2",
        label="2330 Belt and link conveyor systems",
        description="""Belt and link conveyor systems//Gurt- und Gliederförderanlagen""",
    )

    dfg_2330_3 = VocabularyTerm(
        code="DFG_2330_3",
        label="2330 Treadmills",
        description="""Treadmills//Laufbänder""",
    )

    dfg_2330_4 = VocabularyTerm(
        code="DFG_2330_4",
        label="2330 Transport belts and equipment",
        description="""Transport belts and equipment//Transportbänder und -anlagen""",
    )

    dfg_2340_1 = VocabularyTerm(
        code="DFG_2340_1",
        label="2340 Conveying equipment (except belt and link conveyors)",
        description="""Conveying equipment (except belt and link conveyors)//Förderanlagen (außer Gurt- und Gliederförderanlagen)""",
    )

    dfg_2340_2 = VocabularyTerm(
        code="DFG_2340_2",
        label="2340 Conveyor systems (pneumatic, hydraulic, vibratory)",
        description="""Conveyor systems (pneumatic, hydraulic, vibratory)//Förderanlagen (pneumatisch, hydraulisch, Vibrations-)""",
    )

    dfg_2340_3 = VocabularyTerm(
        code="DFG_2340_3",
        label="2340 Screw conveyors",
        description="""Screw conveyors//Förderschnecken""",
    )

    dfg_2340_4 = VocabularyTerm(
        code="DFG_2340_4",
        label="2340 Magnetic conveyors",
        description="""Magnetic conveyors//Magnetförderer""",
    )

    dfg_2340_5 = VocabularyTerm(
        code="DFG_2340_5",
        label="2340 Pipelines",
        description="""Pipelines//Pipelines""",
    )

    dfg_2340_6 = VocabularyTerm(
        code="DFG_2340_6",
        label="2340 Tubular conveyors (except pneumatic 6680)",
        description="""Tubular conveyors (except pneumatic 6680)//Rohrförderanlagen (außer Rohrpostanlagen 6680)""",
    )

    dfg_2340_7 = VocabularyTerm(
        code="DFG_2340_7",
        label="2340 Pipelines and accessories (conveyor systems)",
        description="""Pipelines and accessories (conveyor systems)//Rohrleitungen und Zubehör (Förderanlagen)""",
    )

    dfg_2340_8 = VocabularyTerm(
        code="DFG_2340_8",
        label="2340 Oscillating conveyors",
        description="""Oscillating conveyors//Schwingförderer""",
    )

    dfg_2340_9 = VocabularyTerm(
        code="DFG_2340_9",
        label="2340 Transport and conveying equipment (except 2330)",
        description="""Transport and conveying equipment (except 2330)//Transport- und Fördereinrichtungen (außer 2330)""",
    )

    dfg_2340_10 = VocabularyTerm(
        code="DFG_2340_10",
        label="2340 Rotary valves",
        description="""Rotary valves//Zellenradschleusen""",
    )

    dfg_2350_1 = VocabularyTerm(
        code="DFG_2350_1",
        label="2350 Bulldozers and dozers",
        description="""Bulldozers and dozers//Planiergeräte, -Raupen""",
    )

    dfg_2350_2 = VocabularyTerm(
        code="DFG_2350_2",
        label="2350 Bulldozers, excavators, caterpillars, loaders",
        description="""Bulldozers, excavators, caterpillars, loaders//Räumgeräte, Bagger, Raupen, Lader""",
    )

    dfg_2350_3 = VocabularyTerm(
        code="DFG_2350_3",
        label="2350 Snow blowers, snow blowers, snow ploughs",
        description="""Snow blowers, snow blowers, snow ploughs//Schneefräsen, -schleudern, Schneepflüge""",
    )

    dfg_2350_4 = VocabularyTerm(
        code="DFG_2350_4",
        label="2350 Road construction machinery (except 2370)",
        description="""Road construction machinery (except 2370)//Straßenbaumaschinen (außer 2370)""",
    )

    dfg_2360_1 = VocabularyTerm(
        code="DFG_2360_1",
        label="2360 Mining and stockpile research equipment and testing equipment",
        description="""Mining and stockpile research equipment and testing equipment//Geräte und Versuchseinrichtungen für Bergbau und Lagerstättenforschung""",
    )

    dfg_2370_1 = VocabularyTerm(
        code="DFG_2370_1",
        label="2370 Internal grinders",
        description="""Internal grinders//Innenrüttler""",
    )

    dfg_2370_2 = VocabularyTerm(
        code="DFG_2370_2",
        label="2370 Levelling rollers",
        description="""Levelling rollers//Planierwalzen""",
    )

    dfg_2370_3 = VocabularyTerm(
        code="DFG_2370_3",
        label="2370 Roller compactors",
        description="""Roller compactors//Rüttelverdichter""",
    )

    dfg_2370_4 = VocabularyTerm(
        code="DFG_2370_4",
        label="2370 Special machinery for construction material production and processing",
        description="""Special machinery for construction material production and processing//Spezielle Maschinen für Baustoffherstellung und -bearbeitung""",
    )

    dfg_2370_5 = VocabularyTerm(
        code="DFG_2370_5",
        label="2370 Tamper",
        description="""Tamper//Stampfer""",
    )

    dfg_2370_6 = VocabularyTerm(
        code="DFG_2370_6",
        label="2370 Road rollers",
        description="""Road rollers//Straßenwalzen""",
    )

    dfg_2370_7 = VocabularyTerm(
        code="DFG_2370_7",
        label="2370 Vibrators, rotators (construction)",
        description="""Vibrators, rotators (construction)//Vibratoren, Rüttler (Bau)""",
    )

    dfg_2380_1 = VocabularyTerm(
        code="DFG_2380_1",
        label="2380 Waste, packaging and sealing machines",
        description="""Waste, packaging and sealing machines//Abfüll-, Verpackungs-, Verschließmaschinen""",
    )

    dfg_2390_1 = VocabularyTerm(
        code="DFG_2390_1",
        label="2390 Demolition hammers",
        description="""Demolition hammers//Abbruchhämmer""",
    )

    dfg_2390_2 = VocabularyTerm(
        code="DFG_2390_2",
        label="2390 Construction pile drivers",
        description="""Construction pile drivers//Bau-Rammen""",
    )

    dfg_2390_3 = VocabularyTerm(
        code="DFG_2390_3",
        label="2390 Drilling rigs for civil engineering, mining, oil mining, drill bits, track-laying machinery",
        description="""Drilling rigs for civil engineering, mining, oil mining, drill bits, track-laying machinery//Bohrgeräte für Tiefbau, Bergbau, Ölförderung, Bohrkronen, Gleisbaumaschinen""",
    )

    dfg_2390_4 = VocabularyTerm(
        code="DFG_2390_4",
        label="2390 Hammers, electric and pneumatic",
        description="""Hammers, electric and pneumatic//Hämmer, Elektro- und Pressluft-""",
    )

    dfg_2390_5 = VocabularyTerm(
        code="DFG_2390_5",
        label="2390 Pneumatic hammers",
        description="""Pneumatic hammers//Presslufthämmer""",
    )

    dfg_2390_6 = VocabularyTerm(
        code="DFG_2390_6",
        label="2390 Pile drivers",
        description="""Pile drivers//Rammen""",
    )

    dfg_2390_7 = VocabularyTerm(
        code="DFG_2390_7",
        label="2390 Other construction machinery and equipment",
        description="""Other construction machinery and equipment//Sonstige Baumaschinen und -hilfsgeräte""",
    )

    dfg_2390_8 = VocabularyTerm(
        code="DFG_2390_8",
        label="2390 High-pressure water-jet equipment",
        description="""High-pressure water-jet equipment//Wasserstrahl-Hochdruckgeräte""",
    )

    dfg_2400_1 = VocabularyTerm(
        code="DFG_2400_1",
        label="2400 Research vessels",
        description="""Research vessels//Forschungsschiffe""",
    )

    dfg_2400_2 = VocabularyTerm(
        code="DFG_2400_2",
        label="2400 Motor boats",
        description="""Motor boats//Motorboote""",
    )

    dfg_2400_3 = VocabularyTerm(
        code="DFG_2400_3",
        label="2400 Ships, boats",
        description="""Ships, boats//Schiffe, Boote""",
    )

    dfg_2400_4 = VocabularyTerm(
        code="DFG_2400_4",
        label="2400 Inflatable boats",
        description="""Inflatable boats//Schlauchboote""",
    )

    dfg_2410_1 = VocabularyTerm(
        code="DFG_2410_1",
        label="2410 Rotary aircraft",
        description="""Rotary aircraft//Drehflügler""",
    )

    dfg_2410_2 = VocabularyTerm(
        code="DFG_2410_2",
        label="2410 Aircraft",
        description="""Aircraft//Flugzeuge""",
    )

    dfg_2410_3 = VocabularyTerm(
        code="DFG_2410_3",
        label="2410 Helicopters",
        description="""Helicopters//Hubschrauber""",
    )

    dfg_2410_4 = VocabularyTerm(
        code="DFG_2410_4",
        label="2410 Motor gliders",
        description="""Motor gliders//Motorsegler""",
    )

    dfg_2410_5 = VocabularyTerm(
        code="DFG_2410_5",
        label="2410 Gliders",
        description="""Gliders//Segelflugzeuge""",
    )

    dfg_2420_1 = VocabularyTerm(
        code="DFG_2420_1",
        label="2420 Shock-wave tubes",
        description="""Shock-wave tubes//Stoß-Wellenrohre""",
    )

    dfg_2420_2 = VocabularyTerm(
        code="DFG_2420_2",
        label="2420 Wind tunnels",
        description="""Wind tunnels//Windkanäle""",
    )

    dfg_2430_1 = VocabularyTerm(
        code="DFG_2430_1",
        label="2430 Water channels, experimental channels",
        description="""Water channels, experimental channels//Wasserkanäle, Versuchsgerinne""",
    )

    dfg_2440_1 = VocabularyTerm(
        code="DFG_2440_1",
        label="2440 Betz manometers",
        description="""Betz manometers//Betz-Manometer""",
    )

    dfg_2440_2 = VocabularyTerm(
        code="DFG_2440_2",
        label="2440 Auxiliary equipment and special measuring instruments for wind and water channels and hydraulic engineering installations",
        description="""Auxiliary equipment and special measuring instruments for wind and water channels and hydraulic engineering installations//Hilfseinrichtungen und spezielle Messgeräte für Wind- und Wasserkanäle und Anlagen des Wasserbaus""",
    )

    dfg_2440_3 = VocabularyTerm(
        code="DFG_2440_3",
        label="2440 Gauges, floats (flow measurement in open channels)",
        description="""Gauges, floats (flow measurement in open channels)//Messflügel, Schwimmflügel (Strömungsmessung in offenen Gerinnen)""",
    )

    dfg_2440_4 = VocabularyTerm(
        code="DFG_2440_4",
        label="2440 Weirs, Venturi flumes",
        description="""Weirs, Venturi flumes//Messwehre, Venturi-Rinnen""",
    )

    dfg_2440_5 = VocabularyTerm(
        code="DFG_2440_5",
        label="2440 Planar-motion installations",
        description="""Planar-motion installations//Planar-Motion-Anlagen""",
    )

    dfg_2440_6 = VocabularyTerm(
        code="DFG_2440_6",
        label="2440 Towed wagons (water channel)",
        description="""Towed wagons (water channel)//Schleppwagen (Wasserkanal)""",
    )

    dfg_2440_7 = VocabularyTerm(
        code="DFG_2440_7",
        label="2440 Six-component balances (wind tunnel)",
        description="""Six-component balances (wind tunnel)//Sechs-Komponentenwaagen (Windkanal)""",
    )

    dfg_2440_8 = VocabularyTerm(
        code="DFG_2440_8",
        label="2440 Flow pressure gauges",
        description="""Flow pressure gauges//Strömungsdruckmesser""",
    )

    dfg_2440_9 = VocabularyTerm(
        code="DFG_2440_9",
        label="2440 Flow research apparatus (except for oceanography 0470 and meteorology 0530)",
        description="""Flow research apparatus (except for oceanography 0470 and meteorology 0530)//Strömungsforschungs-Apparaturen (außer für Ozeanographie 0470 und Meteorologie 0530)""",
    )

    dfg_2440_10 = VocabularyTerm(
        code="DFG_2440_10",
        label="2440 Multiple manometers (wind tunnel)",
        description="""Multiple manometers (wind tunnel)//Vielfach-Manometer (Windkanal)""",
    )

    dfg_2440_11 = VocabularyTerm(
        code="DFG_2440_11",
        label="2440 Wave generating machines (water channel)",
        description="""Wave generating machines (water channel)//Wellenerzeuger-Maschinen (Wasserkanal)""",
    )

    dfg_2440_12 = VocabularyTerm(
        code="DFG_2440_12",
        label="2440 Wind generators",
        description="""Wind generators//Winderzeuger""",
    )

    dfg_2440_13 = VocabularyTerm(
        code="DFG_2440_13",
        label="2440 Wind tunnel instrumentation",
        description="""Wind tunnel instrumentation//Windkanal-Instrumentierung""",
    )

    dfg_2440_14 = VocabularyTerm(
        code="DFG_2440_14",
        label="2440 Wind tunnel balances",
        description="""Wind tunnel balances//Windkanal-Waagen""",
    )

    dfg_2450_1 = VocabularyTerm(
        code="DFG_2450_1",
        label="2450 Cavitation measuring equipment",
        description="""Cavitation measuring equipment//Kavitations-Messeinrichtungen""",
    )

    dfg_2450_2 = VocabularyTerm(
        code="DFG_2450_2",
        label="2450 Cavitation tanks, tunnels",
        description="""Cavitation tanks, tunnels//Kavitations-Tanks, -Tunnel""",
    )

    dfg_2460_1 = VocabularyTerm(
        code="DFG_2460_1",
        label="2460 Motion simulators, three-axis motion simulators",
        description="""Motion simulators, three-axis motion simulators//Bewegungssimulatoren, Drei-Achsen-Bewegungs-Simulatoren""",
    )

    dfg_2460_2 = VocabularyTerm(
        code="DFG_2460_2",
        label="2460 Rotary table systems, rotary acceleration platforms",
        description="""Rotary table systems, rotary acceleration platforms//Drehtischanlagen, Drehbeschleunigungs-Prüfstände""",
    )

    dfg_2460_3 = VocabularyTerm(
        code="DFG_2460_3",
        label="2460 Flight simulators",
        description="""Flight simulators//Flugsimulatoren""",
    )

    dfg_2460_4 = VocabularyTerm(
        code="DFG_2460_4",
        label="2460 Altimeters (electronic for aircraft)",
        description="""Altimeters (electronic for aircraft)//Höhenmesser (elektronisch für Flugzeuge)""",
    )

    dfg_2460_5 = VocabularyTerm(
        code="DFG_2460_5",
        label="2460 Navigation and measuring equipment for ships and aircraft",
        description="""Navigation and measuring equipment for ships and aircraft//Navigations- und Messgeräte für Schiffe und Flugzeuge""",
    )

    dfg_2460_6 = VocabularyTerm(
        code="DFG_2460_6",
        label="2460 Navigation systems, single units (except 0020, 0400-0590, 6600-6690)",
        description="""Navigation systems, single units (except 0020, 0400-0590, 6600-6690)//Navigationssysteme, Einzelgeräte (außer 0020, 0400-0590, 6600-6690)""",
    )

    dfg_2460_7 = VocabularyTerm(
        code="DFG_2460_7",
        label="2460 Direction finding equipment for navigation",
        description="""Direction finding equipment for navigation//Peilgeräte für Navigation""",
    )

    dfg_2460_8 = VocabularyTerm(
        code="DFG_2460_8",
        label="2460 Test equipment for navigation and control instruments",
        description="""Test equipment for navigation and control instruments//Prüfeinrichtungen für Navigations- und Kontrollgeräte""",
    )

    dfg_2460_9 = VocabularyTerm(
        code="DFG_2460_9",
        label="2460 Radar simulators (for training)",
        description="""Radar simulators (for training)//Radar-Simulatoren (für Ausbildung)""",
    )

    dfg_2460_10 = VocabularyTerm(
        code="DFG_2460_10",
        label="2460 Ship simulators",
        description="""Ship simulators//Schiffssimulatoren""",
    )

    dfg_2460_11 = VocabularyTerm(
        code="DFG_2460_11",
        label="2460 XY test tables for gyro and platform measurement",
        description="""XY test tables for gyro and platform measurement//XY-Prüftische für Kreisel- und Plattformvermessung""",
    )

    dfg_2470_1 = VocabularyTerm(
        code="DFG_2470_1",
        label="2470 Special rocketry and ballistics equipment",
        description="""Special rocketry and ballistics equipment//Spezielle Geräte der Raketentechnik und Ballistik""",
    )

    dfg_2490_1 = VocabularyTerm(
        code="DFG_2490_1",
        label="2490 Balloons (air), tethered balloons",
        description="""Balloons (air), tethered balloons//Ballone (Luft-), Fessel-Ballone""",
    )

    dfg_2490_2 = VocabularyTerm(
        code="DFG_2490_2",
        label="2490 Buoys, buoys, floating traffic signs",
        description="""Buoys, buoys, floating traffic signs//Bojen, Tonnen, schwimmende Verkehrszeichen""",
    )

    dfg_2490_3 = VocabularyTerm(
        code="DFG_2490_3",
        label="2490 Parachutes",
        description="""Parachutes//Fallschirme""",
    )

    dfg_2490_4 = VocabularyTerm(
        code="DFG_2490_4",
        label="2490 Aviation equipment",
        description="""Aviation equipment//Fliegerausrüstung""",
    )

    dfg_2490_5 = VocabularyTerm(
        code="DFG_2490_5",
        label="2490 Aircraft and ship accessories",
        description="""Aircraft and ship accessories//Flugzeug- und Schiffs-Zubehör""",
    )

    dfg_2490_6 = VocabularyTerm(
        code="DFG_2490_6",
        label="2490 Airships",
        description="""Airships//Luftschiffe""",
    )

    dfg_2490_7 = VocabularyTerm(
        code="DFG_2490_7",
        label="2490 Pontoons, floats",
        description="""Pontoons, floats//Pontons, Schwimmer""",
    )

    dfg_2490_8 = VocabularyTerm(
        code="DFG_2490_8",
        label="2490 Lifeboats, life rafts, life jackets",
        description="""Lifeboats, life rafts, life jackets//Rettungsboote, -flöße, -inseln, Schwimmwesten""",
    )

    dfg_2490_9 = VocabularyTerm(
        code="DFG_2490_9",
        label="2490 Shipbuilding test rigging",
        description="""Shipbuilding test rigging//Schiffbauversuchsgeräte""",
    )

    dfg_2490_10 = VocabularyTerm(
        code="DFG_2490_10",
        label="2490 Other air and water vehicles and accessories",
        description="""Other air and water vehicles and accessories//Sonstige Luft- und Wasserfahrzeuge und Zubehör""",
    )

    dfg_2500_1 = VocabularyTerm(
        code="DFG_2500_1",
        label="2500 Automobiles, passenger cars (trucks 2510, trucks 2520)",
        description="""Automobiles, passenger cars (trucks 2510, trucks 2520)//Automobile, PKWs (LKWs 2510, Geländewagen 2520)""",
    )

    dfg_2500_2 = VocabularyTerm(
        code="DFG_2500_2",
        label="2500 Passenger cars, omnibuses, station wagons",
        description="""Passenger cars, omnibuses, station wagons//Personen-Kraftwagen, Omnibusse, Kombiwagen""",
    )

    dfg_2510_1 = VocabularyTerm(
        code="DFG_2510_1",
        label="2510 Vans (motor vehicles)",
        description="""Vans (motor vehicles)//Kastenwagen (Kfz)""",
    )

    dfg_2510_2 = VocabularyTerm(
        code="DFG_2510_2",
        label="2510 Lorries",
        description="""Lorries//Lastkraftwagen""",
    )

    dfg_2520_1 = VocabularyTerm(
        code="DFG_2520_1",
        label="2520 Concrete transport vehicles",
        description="""Concrete transport vehicles//Beton-Transportfahrzeuge""",
    )

    dfg_2520_2 = VocabularyTerm(
        code="DFG_2520_2",
        label="2520 Gel lorries",
        description="""Gel lorries//Geländekraftwagen""",
    )

    dfg_2520_3 = VocabularyTerm(
        code="DFG_2520_3",
        label="2520 Track vehicles",
        description="""Track vehicles//Gleiskettenfahrzeuge""",
    )

    dfg_2520_4 = VocabularyTerm(
        code="DFG_2520_4",
        label="2520 Land rover (R)",
        description="""Land rover (R)//Landrover (R)""",
    )

    dfg_2520_5 = VocabularyTerm(
        code="DFG_2520_5",
        label="2520 Measuring and laboratory vehicles, measuring vehicles",
        description="""Measuring and laboratory vehicles, measuring vehicles//Mess- und Laborkraftwagen, Messfahrzeuge""",
    )

    dfg_2520_6 = VocabularyTerm(
        code="DFG_2520_6",
        label="2520 Special motor vehicles (motor vehicles)",
        description="""Special motor vehicles (motor vehicles)//Sonderfahrzeuge (Kfz)""",
    )

    dfg_2520_7 = VocabularyTerm(
        code="DFG_2520_7",
        label="2520 Special motor vehicles (tractors, fire engines, ambulances)",
        description="""Special motor vehicles (tractors, fire engines, ambulances)//Spezielle Kraftfahrzeuge (Zugmaschinen, Feuerwehrfahrzeuge, Krankenwagen)""",
    )

    dfg_2520_8 = VocabularyTerm(
        code="DFG_2520_8",
        label="2520 Street cleaning vehicles",
        description="""Street cleaning vehicles//Straßenreinigungs-Fahrzeuge""",
    )

    dfg_2520_9 = VocabularyTerm(
        code="DFG_2520_9",
        label="2520 Tank trucks (lorries)",
        description="""Tank trucks (lorries)//Tankwagen (Lkw)""",
    )

    dfg_2520_10 = VocabularyTerm(
        code="DFG_2520_10",
        label="2520 Tractors",
        description="""Tractors//Traktoren""",
    )

    dfg_2530_1 = VocabularyTerm(
        code="DFG_2530_1",
        label="2530 Trailers for motor vehicles",
        description="""Trailers for motor vehicles//Anhänger für Kraftfahrzeuge""",
    )

    dfg_2530_2 = VocabularyTerm(
        code="DFG_2530_2",
        label="2530 Camping trailers",
        description="""Camping trailers//Camping-Anhänger""",
    )

    dfg_2530_3 = VocabularyTerm(
        code="DFG_2530_3",
        label="2530 Low-loader trailers",
        description="""Low-loader trailers//Tiefladeanhänger""",
    )

    dfg_2530_4 = VocabularyTerm(
        code="DFG_2530_4",
        label="2530 Caravan trailers",
        description="""Caravan trailers//Wohnwagenanhänger""",
    )

    dfg_2540_1 = VocabularyTerm(
        code="DFG_2540_1",
        label="2540 Electric carts",
        description="""Electric carts//Elektrokarren""",
    )

    dfg_2540_2 = VocabularyTerm(
        code="DFG_2540_2",
        label="2540 Ground support vehicles",
        description="""Ground support vehicles//Flurförderfahrzeuge""",
    )

    dfg_2540_3 = VocabularyTerm(
        code="DFG_2540_3",
        label="2540 Forklift trucks",
        description="""Forklift trucks//Gabelstapler""",
    )

    dfg_2540_4 = VocabularyTerm(
        code="DFG_2540_4",
        label="2540 Lifting trucks",
        description="""Lifting trucks//Hebefahrzeuge""",
    )

    dfg_2540_5 = VocabularyTerm(
        code="DFG_2540_5",
        label="2540 Lifting trucks (motor-driven)",
        description="""Lifting trucks (motor-driven)//Hubwagen (motorgetrieben)""",
    )

    dfg_2540_6 = VocabularyTerm(
        code="DFG_2540_6",
        label="2540 Stacking vehicles",
        description="""Stacking vehicles//Stapelfahrzeuge""",
    )

    dfg_2550_1 = VocabularyTerm(
        code="DFG_2550_1",
        label="2550 Motorcycles, bicycles, vehicles for the disabled",
        description="""Motorcycles, bicycles, vehicles for the disabled//Krafträder, Fahrräder, Behinderten-Fahrzeuge""",
    )

    dfg_2550_2 = VocabularyTerm(
        code="DFG_2550_2",
        label="2550 Mopeds",
        description="""Mopeds//Mofas""",
    )

    dfg_2550_3 = VocabularyTerm(
        code="DFG_2550_3",
        label="2550 Motorcycles",
        description="""Motorcycles//Motorräder""",
    )

    dfg_2560_1 = VocabularyTerm(
        code="DFG_2560_1",
        label="2560 Wheel aligners",
        description="""Wheel aligners//Achsvermessungsgeräte""",
    )

    dfg_2560_2 = VocabularyTerm(
        code="DFG_2560_2",
        label="2560 Brake dynamometers",
        description="""Brake dynamometers//Bremsprüfstände""",
    )

    dfg_2560_3 = VocabularyTerm(
        code="DFG_2560_3",
        label="2560 Alternator and starter test rigs",
        description="""Alternator and starter test rigs //Lichtmaschinen- und Anlasser-Prüfstände""",
    )

    dfg_2560_4 = VocabularyTerm(
        code="DFG_2560_4",
        label="2560 Test rigs of vehicles and assemblies (except engine parts 2860)",
        description="""Test rigs of vehicles and assemblies (except engine parts 2860)//Prüfstände für Fahrzeuge und Aggregate (außer Motorenprüfstände 2860)""",
    )

    dfg_2560_5 = VocabularyTerm(
        code="DFG_2560_5",
        label="2560 Tyre test rigs",
        description="""Tyre test rigs//Reifenprüfstände""",
    )

    dfg_2560_6 = VocabularyTerm(
        code="DFG_2560_6",
        label="2560 Roller test rigs, rolling friction test rigs",
        description="""Roller test rigs, rolling friction test rigs//Rollenprüfstände, Rollreibungsprüfstände""",
    )

    dfg_2570_1 = VocabularyTerm(
        code="DFG_2570_1",
        label="2570 Railway research and testing equipment",
        description="""Railway research and testing equipment//Eisenbahntechnische Forschungsgeräte und Versuchsanlagen""",
    )

    dfg_2570_2 = VocabularyTerm(
        code="DFG_2570_2",
        label="2570 Track gauges (gauge, profile)",
        description="""Track gauges (gauge, profile)//Gleis-Messgeräte (Spurweite, Profil)""",
    )

    dfg_2570_3 = VocabularyTerm(
        code="DFG_2570_3",
        label="2570 Measuring instruments for railway vehicles and tracks",
        description="""Measuring instruments for railway vehicles and tracks//Messgeräte für Schienenfahrzeuge und Gleise""",
    )

    dfg_2580_1 = VocabularyTerm(
        code="DFG_2580_1",
        label="2580 Driving school equipment and apparatus",
        description="""Driving school equipment and apparatus//Fahrschuleinrichtung und -geräte""",
    )

    dfg_2580_2 = VocabularyTerm(
        code="DFG_2580_2",
        label="2580 Driving simulators, road and rail vehicle chassis",
        description="""Driving simulators, road and rail vehicle chassis//Fahrsimulatoren, Fahrstände für Straßen- und Schienenfahrzeuge""",
    )

    dfg_2580_3 = VocabularyTerm(
        code="DFG_2580_3",
        label="2580 Accessories and aggregates for motor vehicles",
        description="""Accessories and aggregates for motor vehicles//Zubehör und Aggregate für Kraftfahrzeuge""",
    )

    dfg_2590_1 = VocabularyTerm(
        code="DFG_2590_1",
        label="2590 Railway wagons",
        description="""Railway wagons//Eisenbahnwaggons""",
    )

    dfg_2590_2 = VocabularyTerm(
        code="DFG_2590_2",
        label="2590 Light railways, wagons and rolling stock (except 9020)",
        description="""Light railways, wagons and rolling stock (except 9020)//Feldbahnen, Waggons und Schienenmaterial (außer 9020)""",
    )

    dfg_2590_3 = VocabularyTerm(
        code="DFG_2590_3",
        label="2590 Track and rail measuring vehicles",
        description="""Track and rail measuring vehicles//Gleis- und Schienen-Messfahrzeuge""",
    )

    dfg_2590_4 = VocabularyTerm(
        code="DFG_2590_4",
        label="2590 Locomotives",
        description="""Locomotives//Lokomotiven""",
    )

    dfg_2590_5 = VocabularyTerm(
        code="DFG_2590_5",
        label="2590 Magnetic levitation trains and vehicles",
        description="""Magnetic levitation trains and vehicles//Magnetschwebebahnen und -fahrzeuge""",
    )

    dfg_2590_6 = VocabularyTerm(
        code="DFG_2590_6",
        label="2590 Other road and rail vehicles, light railways",
        description="""Other road and rail vehicles, light railways//Sonstige Straßen- und Schienenfahrzeuge, Feldbahnen""",
    )

    dfg_2600_1 = VocabularyTerm(
        code="DFG_2600_1",
        label="2600 Asynchronous motors",
        description="""Asynchronous motors//Asynchronmotoren""",
    )

    dfg_2600_2 = VocabularyTerm(
        code="DFG_2600_2",
        label="2600 Three-phase motors",
        description="""Three-phase motors//Drehstrommotoren""",
    )

    dfg_2600_3 = VocabularyTerm(
        code="DFG_2600_3",
        label="2600 Electric motors",
        description="""Electric motors//Elektromotoren""",
    )

    dfg_2600_4 = VocabularyTerm(
        code="DFG_2600_4",
        label="2600 Direct current motors",
        description="""Direct current motors//Gleichstrommotoren""",
    )

    dfg_2600_5 = VocabularyTerm(
        code="DFG_2600_5",
        label="2600 Linear motors",
        description="""Linear motors//Linearmotoren""",
    )

    dfg_2600_6 = VocabularyTerm(
        code="DFG_2600_6",
        label="2600 Disc motors",
        description="""Disc motors//Scheibenmotoren""",
    )

    dfg_2600_7 = VocabularyTerm(
        code="DFG_2600_7",
        label="2600 Stepper motors",
        description="""Stepper motors//Schrittmotoren""",
    )

    dfg_2600_8 = VocabularyTerm(
        code="DFG_2600_8",
        label="2600 Shaded pole motors",
        description="""Shaded pole motors//Spaltpolmotoren""",
    )

    dfg_2600_9 = VocabularyTerm(
        code="DFG_2600_9",
        label="2600 Synchronous motors",
        description="""Synchronous motors//Synchronmotoren""",
    )

    dfg_2600_10 = VocabularyTerm(
        code="DFG_2600_10",
        label="2600 Alternating current motors",
        description="""Alternating current motors//Wechselstrommotoren""",
    )

    dfg_2610_1 = VocabularyTerm(
        code="DFG_2610_1",
        label="2610 Three-phase generators",
        description="""Three-phase generators//Drehstromgeneratoren""",
    )

    dfg_2610_2 = VocabularyTerm(
        code="DFG_2610_2",
        label="2610 Three-phase converters",
        description="""Three-phase converters//Drehstromumformer""",
    )

    dfg_2610_3 = VocabularyTerm(
        code="DFG_2610_3",
        label="2610 Dynamo machines, on-board generators",
        description="""Dynamo machines, on-board generators//Dynamomaschinen, Bordgeneratoren""",
    )

    dfg_2610_4 = VocabularyTerm(
        code="DFG_2610_4",
        label="2610 Generators and rotary converters",
        description="""Generators and rotary converters//Generatoren und rotierende Umformer""",
    )

    dfg_2610_5 = VocabularyTerm(
        code="DFG_2610_5",
        label="2610 Direct current generators",
        description="""Direct current generators//Gleichstrom-Generatoren""",
    )

    dfg_2610_6 = VocabularyTerm(
        code="DFG_2610_6",
        label="2610 Direct current converters (rotating)",
        description="""Direct current converters (rotating)//Gleichstrom-Umformer (rotierend)""",
    )

    dfg_2610_7 = VocabularyTerm(
        code="DFG_2610_7",
        label="2610 Leonard drives",
        description="""Leonard drives//Leonard-Antriebe""",
    )

    dfg_2610_8 = VocabularyTerm(
        code="DFG_2610_8",
        label="2610 Medium frequency generators, converters (rotary, except 6040)",
        description="""Medium frequency generators, converters (rotary, except 6040)//Mittelfrequenzgeneratoren, -umformer (rotierend, außer 6040)""",
    )

    dfg_2620_1 = VocabularyTerm(
        code="DFG_2620_1",
        label="2620 High-voltage transformers",
        description="""High-voltage transformers//Hochspannungstransformatoren""",
    )

    dfg_2620_2 = VocabularyTerm(
        code="DFG_2620_2",
        label="2620 High current transformers",
        description="""High current transformers//Hochstromtransformatoren""",
    )

    dfg_2620_3 = VocabularyTerm(
        code="DFG_2620_3",
        label="2620 Machine transformers",
        description="""Machine transformers//Maschinentransformatoren""",
    )

    dfg_2620_4 = VocabularyTerm(
        code="DFG_2620_4",
        label="2620 Furnace transformers",
        description="""Furnace transformers//Ofentransformatoren""",
    )

    dfg_2620_5 = VocabularyTerm(
        code="DFG_2620_5",
        label="2620 Welding transformers",
        description="""Welding transformers//Schweißtransformatoren""",
    )

    dfg_2620_6 = VocabularyTerm(
        code="DFG_2620_6",
        label="2620 Transformers, chokes",
        description="""Transformers, chokes//Transformatoren, Drosseln""",
    )

    dfg_2620_7 = VocabularyTerm(
        code="DFG_2620_7",
        label="2620 Transformers",
        description="""Transformers//Umspanner""",
    )

    dfg_2630_1 = VocabularyTerm(
        code="DFG_2630_1",
        label="2630 Electric pulse rectifiers",
        description="""Electric pulse rectifiers//Elektrische Pulseinrichter""",
    )

    dfg_2630_2 = VocabularyTerm(
        code="DFG_2630_2",
        label="2630 Rectifiers (power rectifiers for traction current, electrolysis plants)",
        description="""Rectifiers (power rectifiers for traction current, electrolysis plants)//Gleichrichter (Leistungsgleichrichter für Bahnstrom, Elektrolyseanlagen""",
    )

    dfg_2630_3 = VocabularyTerm(
        code="DFG_2630_3",
        label="2630 High voltage rectifiers (except X-ray generators 3200 and 4000)",
        description="""High voltage rectifiers (except X-ray generators 3200 and 4000)//Hochspannungsgleichrichter (außer Röntgengeneratoren 3200 und 4000)""",
    )

    dfg_2630_4 = VocabularyTerm(
        code="DFG_2630_4",
        label="2630 Welding rectifiers, power supply (except transformers 2620 and welding units 6050)",
        description="""Welding rectifiers, power supply (except transformers 2620 and welding units 6050)//Schweißgleichrichter, -stromversorgung (außer Transformatoren 2620 und Schweiß-Aggregate 6050)""",
    )

    dfg_2630_5 = VocabularyTerm(
        code="DFG_2630_5",
        label="2630 Silicon rectifiers",
        description="""Silicon rectifiers//Silizium-Gleichrichter""",
    )

    dfg_2630_6 = VocabularyTerm(
        code="DFG_2630_6",
        label="2630 Power converters and power electronics (power transmission, drives)",
        description="""Power converters and power electronics (power transmission, drives)//Stromrichter und Leistungselektronik (Energieübertragung, Antriebe)""",
    )

    dfg_2630_7 = VocabularyTerm(
        code="DFG_2630_7",
        label="2630 Thyristor controllers, regulators",
        description="""Thyristor controllers, regulators//Thyristor-Regler, -Steller""",
    )

    dfg_2630_8 = VocabularyTerm(
        code="DFG_2630_8",
        label="2630 Thyristor power converters",
        description="""Thyristor power converters//Thyristor-Stromrichter""",
    )

    dfg_2630_9 = VocabularyTerm(
        code="DFG_2630_9",
        label="2630 Valves (electrical)",
        description="""Valves (electrical)//Ventile (elektrische)""",
    )

    dfg_2630_10 = VocabularyTerm(
        code="DFG_2630_10",
        label="2630 Four-quadrant thyristor controllers",
        description="""Four-quadrant thyristor controllers//Vierquadranten-Thyristor-Regler""",
    )

    dfg_2630_11 = VocabularyTerm(
        code="DFG_2630_11",
        label="2630 Inverters (for high-voltage systems, motor drives)",
        description="""Inverters (for high-voltage systems, motor drives)//Wechselrichter (für Hochspannungsanlagen, Motorantriebe)""",
    )

    dfg_2640_1 = VocabularyTerm(
        code="DFG_2640_1",
        label="2640 High-voltage capacitors",
        description="""High-voltage capacitors//Hochspannungskondensatoren""",
    )

    dfg_2640_2 = VocabularyTerm(
        code="DFG_2640_2",
        label="2640 Pulse capacitors",
        description="""Pulse capacitors//Impulskondensatoren""",
    )

    dfg_2640_3 = VocabularyTerm(
        code="DFG_2640_3",
        label="2640 Compensation capacitors",
        description="""Compensation capacitors//Kompensations-Kondensatoren""",
    )

    dfg_2640_4 = VocabularyTerm(
        code="DFG_2640_4",
        label="2640 Capacitor banks",
        description="""Capacitor banks//Kondensator-Bänke""",
    )

    dfg_2640_5 = VocabularyTerm(
        code="DFG_2640_5",
        label="2640 Capacitor batteries",
        description="""Capacitor batteries//Kondensatoren-Batterien""",
    )

    dfg_2640_6 = VocabularyTerm(
        code="DFG_2640_6",
        label="2640 Power capacitors, phase shifters",
        description="""Power capacitors, phase shifters//Leistungskondensatoren, Phasenschieber""",
    )

    dfg_2640_7 = VocabularyTerm(
        code="DFG_2640_7",
        label="2640 Motor capacitors",
        description="""Motor capacitors//Motorkondensatoren""",
    )

    dfg_2640_8 = VocabularyTerm(
        code="DFG_2640_8",
        label="2640 Pressed gas capacitors",
        description="""Pressed gas capacitors//Pressgaskondensatoren""",
    )

    dfg_2640_9 = VocabularyTerm(
        code="DFG_2640_9",
        label="2640 Power film capacitors",
        description="""Power film capacitors//Stoß-Kondensatoren""",
    )

    dfg_2650_1 = VocabularyTerm(
        code="DFG_2650_1",
        label="2650 Starters, regulators for electrical machines (except 2630)",
        description="""Starters, regulators for electrical machines (except 2630)//Anlasser, Regler für elektrische Maschinen (außer 2630)""",
    )

    dfg_2650_2 = VocabularyTerm(
        code="DFG_2650_2",
        label="2650 Motor circuit breakers",
        description="""Motor circuit breakers//Motorschutzschalter""",
    )

    dfg_2650_3 = VocabularyTerm(
        code="DFG_2650_3",
        label="2650 Control and protective devices for electrical machines and installations (except 2630)",
        description="""Control and protective devices for electrical machines and installations (except 2630)//Steuer-, Schutzgeräte für elektrische Maschinen und Anlagen (außer 2630)""",
    )

    dfg_2650_4 = VocabularyTerm(
        code="DFG_2650_4",
        label="2650 Synchronising devices for three-phase generators",
        description="""Synchronising devices for three-phase generators//Synchronisiereinrichtungen für Drehstrom-Generatoren""",
    )

    dfg_2650_5 = VocabularyTerm(
        code="DFG_2650_5",
        label="2650 Transformer supply, protection and monitoring devices",
        description="""Transformer supply, protection and monitoring devices//Transformatoren-Zubehör, -Schutz und -Überwachungsgeräte""",
    )

    dfg_2650_6 = VocabularyTerm(
        code="DFG_2650_6",
        label="2650 Voltage arresters",
        description="""Voltage arresters//Überspannungs-Ableiter""",
    )

    dfg_2660_1 = VocabularyTerm(
        code="DFG_2660_1",
        label="2660 High-voltage direct-current (HVDC) transmission model plants",
        description="""High-voltage direct-current (HVDC) transmission model plants//HGÜ-Modellanlagen (Hochspannungs-Gleichstrom-Übertragung)""",
    )

    dfg_2660_2 = VocabularyTerm(
        code="DFG_2660_2",
        label="2660 Power station replicas",
        description="""Power station replicas//Kraftwerksnachbildungen""",
    )

    dfg_2660_3 = VocabularyTerm(
        code="DFG_2660_3",
        label="2660 Models and test installations for electric motor drives",
        description="""Models and test installations for electric motor drives//Modelle und Versuchsanlagen für elektromotorische Antriebe""",
    )

    dfg_2660_4 = VocabularyTerm(
        code="DFG_2660_4",
        label="2660 Mains models and model installations",
        description="""Mains models and model installations//Netzmodelle und Modellanlagen""",
    )

    dfg_2670_1 = VocabularyTerm(
        code="DFG_2670_1",
        label="2670 High-voltage switches",
        description="""High-voltage switches//Hochspannungsschalter""",
    )

    dfg_2670_2 = VocabularyTerm(
        code="DFG_2670_2",
        label="2670 Circuit-breakers, load switches",
        description="""Circuit-breakers, load switches//Leistungsschalter, Lastschalter""",
    )

    dfg_2670_3 = VocabularyTerm(
        code="DFG_2670_3",
        label="2670 Switchboards",
        description="""Switchboards//Schaltschränke""",
    )

    dfg_2670_4 = VocabularyTerm(
        code="DFG_2670_4",
        label="2670 Switchboards, distribution boards",
        description="""Switchboards, distribution boards//Schalttafeln, Verteiler""",
    )

    dfg_2670_5 = VocabularyTerm(
        code="DFG_2670_5",
        label="2670 Special devices for electrical power transmission; cables, lines, switches, switch panels.",
        description="""`Special devices for electrical power transmission; cables, lines, switches, switch panels`.//Spezielle Geräte der elektrischen Energieübertragung; Kabel, Leitungen, Schalter, Schaltfelder""",
    )

    dfg_2670_6 = VocabularyTerm(
        code="DFG_2670_6",
        label="2670 Disconnectors",
        description="""Disconnectors//Trennschalter""",
    )

    dfg_2680_1 = VocabularyTerm(
        code="DFG_2680_1",
        label="2680 Spark gaps (ball)",
        description="""Spark gaps (ball)//Funkenstrecken (Kugel-)""",
    )

    dfg_2680_2 = VocabularyTerm(
        code="DFG_2680_2",
        label="2680 High-voltage boxes",
        description="""High-voltage boxes//Hochspannungsbaukästen""",
    )

    dfg_2680_3 = VocabularyTerm(
        code="DFG_2680_3",
        label="2680 High-voltage generators for laboratories",
        description="""High-voltage generators for laboratories//Hochspannungsgeneratoren für Laboratorien""",
    )

    dfg_2680_4 = VocabularyTerm(
        code="DFG_2680_4",
        label="2680 High-voltage insulators and bushings",
        description="""High-voltage insulators and bushings//Hochspannungsisolatoren, -durchführungen""",
    )

    dfg_2680_5 = VocabularyTerm(
        code="DFG_2680_5",
        label="2680 High-voltage measuring instruments, dividers",
        description="""High-voltage measuring instruments, dividers//Hochspannungsmessgeräte, -teiler""",
    )

    dfg_2680_6 = VocabularyTerm(
        code="DFG_2680_6",
        label="2680 Special apparatus for high voltage and high current laboratories",
        description="""Special apparatus for high voltage and high current laboratories//Spezielle Geräte für Hochspannungs- und Hochstromlaboratorien""",
    )

    dfg_2680_7 = VocabularyTerm(
        code="DFG_2680_7",
        label="2680 Surge voltage generators",
        description="""Surge voltage generators//Stoßspannungsgeneratoren""",
    )

    dfg_2680_8 = VocabularyTerm(
        code="DFG_2680_8",
        label="2680 Stator current generators",
        description="""Stator current generators//Stoßstromgeneratoren""",
    )

    dfg_2690_1 = VocabularyTerm(
        code="DFG_2690_1",
        label="2690 Burn-out devices for cable faults",
        description="""Burn-out devices for cable faults//Ausbrenngeräte für Kabelfehler""",
    )

    dfg_2690_2 = VocabularyTerm(
        code="DFG_2690_2",
        label="2690 Earthing devices",
        description="""Earthing devices//Erdungsgeräte""",
    )

    dfg_2690_3 = VocabularyTerm(
        code="DFG_2690_3",
        label="2690 High-voltage protection (shielding, earthing, insulation)",
        description="""High-voltage protection (shielding, earthing, insulation)//Hochspannungsschutz (Schirmung, Erdung, Isolation)""",
    )

    dfg_2690_4 = VocabularyTerm(
        code="DFG_2690_4",
        label="2690 Circuit breakers for switches and electrical components",
        description="""Circuit breakers for switches and electrical components//Prüfschaltungen für Schalter und elektrische Anlagenteile""",
    )

    dfg_2690_5 = VocabularyTerm(
        code="DFG_2690_5",
        label="2690 Other devices for electrical power engineering",
        description="""Other devices for electrical power engineering//Sonstige Geräte der Elektrischen Energietechnik""",
    )

    dfg_2700_1 = VocabularyTerm(
        code="DFG_2700_1",
        label="2700 Fibre optic cables (telecommunications)",
        description="""Fibre optic cables (telecommunications)//Glasfaserkabel (Nachrichtentechnik)""",
    )

    dfg_2700_2 = VocabularyTerm(
        code="DFG_2700_2",
        label="2700 Hollow cable systems",
        description="""Hollow cable systems//Hohlkabel-Systeme""",
    )

    dfg_2700_3 = VocabularyTerm(
        code="DFG_2700_3",
        label="2700 Optical cables (communications cables)",
        description="""Optical cables (communications cables)//Optische Kabel (Nachrichtenkabel)""",
    )

    dfg_2700_4 = VocabularyTerm(
        code="DFG_2700_4",
        label="2700 Special wires and cables for telecommunications, incl. assemblies",
        description="""Special wires and cables for telecommunications, incl. assemblies//Spezielle Leitungen und Kabel der Nachrichtentechnik einschl. Baugruppen""",
    )

    dfg_2700_5 = VocabularyTerm(
        code="DFG_2700_5",
        label="2700 Transmission systems, model systems for telecommunications (except 6600-6650)",
        description="""Transmission systems, model systems for telecommunications (except 6600-6650)//Übertragungssysteme, Modellanlagen der Nachrichtentechnik (außer 6600-6650)""",
    )

    dfg_2710_1 = VocabularyTerm(
        code="DFG_2710_1",
        label="2710 Fault locators (cables)",
        description="""Fault locators (cables)//Fehlerortungsgeräte (Kabel-)""",
    )

    dfg_2710_2 = VocabularyTerm(
        code="DFG_2710_2",
        label="2710 Group delay measuring plots",
        description="""Group delay measuring plots//Gruppenlaufzeit-Messplätze""",
    )

    dfg_2710_3 = VocabularyTerm(
        code="DFG_2710_3",
        label="2710 Pulse reflectometers (electrical)",
        description="""Pulse reflectometers (electrical)//Impulsreflektometer (elektrische)""",
    )

    dfg_2710_4 = VocabularyTerm(
        code="DFG_2710_4",
        label="2710 Measuring lines, slotted line",
        description="""Measuring lines, slotted line//Messleitungen, Slotted line""",
    )

    dfg_2710_5 = VocabularyTerm(
        code="DFG_2710_5",
        label="2710 Reflectographs, reflectometers (electrical)",
        description="""Reflectographs, reflectometers (electrical)//Reflektographen, Reflektometer (elektrische)""",
    )

    dfg_2710_6 = VocabularyTerm(
        code="DFG_2710_6",
        label="2710 Reflection and matching measuring instruments, time-of-flight measuring instruments",
        description="""Reflection and matching measuring instruments, time-of-flight measuring instruments//Reflexions- und Anpassungsmessgeräte, Laufzeit-Messgeräte""",
    )

    dfg_2710_7 = VocabularyTerm(
        code="DFG_2710_7",
        label="2710 Time-domain reflectometers",
        description="""Time-domain reflectometers//Time-Domain-Reflektometer""",
    )

    dfg_2710_8 = VocabularyTerm(
        code="DFG_2710_8",
        label="2710 Voltage standing wave ratio (VSWR) meters",
        description="""Voltage standing wave ratio (VSWR) meters//VSWR-Messgeräte (Voltage Standing wave ratio)""",
    )

    dfg_2710_9 = VocabularyTerm(
        code="DFG_2710_9",
        label="2710 Time-domain reflectometers",
        description="""Time-domain reflectometers//Zeitbereich-Reflektometer""",
    )

    dfg_2720_1 = VocabularyTerm(
        code="DFG_2720_1",
        label="2720 Antenna impedance meter",
        description="""Antenna impedance meter//Antennen-Impedanzmeter""",
    )

    dfg_2720_2 = VocabularyTerm(
        code="DFG_2720_2",
        label="2720 Attenuation meters for optical cables",
        description="""Attenuation meters for optical cables//Dämpfungsmessgeräte für optische Kabel""",
    )

    dfg_2720_3 = VocabularyTerm(
        code="DFG_2720_3",
        label="2720 Calibration cables",
        description="""Calibration cables//Eichleitungen""",
    )

    dfg_2720_4 = VocabularyTerm(
        code="DFG_2720_4",
        label="2720 Frequency response meters, analysers, calibrators",
        description="""Frequency response meters, analysers, calibrators//Frequenzgang-Messgeräte, -Analysatoren, -Sichtgeräte""",
    )

    dfg_2720_5 = VocabularyTerm(
        code="DFG_2720_5",
        label="2720 Impedance and attenuation meters, frequency response meters, network analysers",
        description="""Impedance and attenuation meters, frequency response meters, network analysers//Impedanz- und Dämpfungsmessgeräte, Frequenzgangmessgeräte, Netzwerkanalysatoren""",
    )

    dfg_2720_6 = VocabularyTerm(
        code="DFG_2720_6",
        label="2720 Impedance sweepers",
        description="""Impedance sweepers//Impedanzwobbler""",
    )

    dfg_2720_7 = VocabularyTerm(
        code="DFG_2720_7",
        label="2720 Line simulators, line simulators",
        description="""Line simulators, line simulators//Leitungsnachbildungen, line Simulator""",
    )

    dfg_2720_8 = VocabularyTerm(
        code="DFG_2720_8",
        label="2720 Level recorders (communications engineering)",
        description="""Level recorders (communications engineering)//Pegelschreiber (Nachrichtentechnik)""",
    )

    dfg_2720_9 = VocabularyTerm(
        code="DFG_2720_9",
        label="2720 Transfer function measuring plots",
        description="""Transfer function measuring plots//Transfer-Funktions-Messplätze""",
    )

    dfg_2720_10 = VocabularyTerm(
        code="DFG_2720_10",
        label="2720 Vector impedance meters, vector analyzers",
        description="""Vector impedance meters, vector analyzers//Vektor-Impedanzmeter, Vektor-Analyzer""",
    )

    dfg_2720_11 = VocabularyTerm(
        code="DFG_2720_11",
        label="2720 Sweep meters (except group delay meters 2710 and automatic meters 7330)",
        description="""Sweep meters (except group delay meters 2710 and automatic meters 7330)//Wobbelmessplätze (außer Gruppenlaufzeit-Messplätze 2710 und Messautomaten 7330)""",
    )

    dfg_2730_1 = VocabularyTerm(
        code="DFG_2730_1",
        label="2730 Compander (modulation)",
        description="""Compander (modulation)//Compander (Modulations-)""",
    )

    dfg_2730_2 = VocabularyTerm(
        code="DFG_2730_2",
        label="2730 Demodulators",
        description="""Demodulators//Demodulatoren""",
    )

    dfg_2730_3 = VocabularyTerm(
        code="DFG_2730_3",
        label="2730 Digital signal analysers",
        description="""Digital signal analysers//Digital-Signalanalysatoren""",
    )

    dfg_2730_4 = VocabularyTerm(
        code="DFG_2730_4",
        label="2730 Frequency (band) converters",
        description="""Frequency (band) converters//Frequenz- (Band-) Umsetzer""",
    )

    dfg_2730_5 = VocabularyTerm(
        code="DFG_2730_5",
        label="2730 Modulators, frequency deviation and modulation measuring instruments",
        description="""Modulators, frequency deviation and modulation measuring instruments//Modulatoren, Frequenzhub- und -modulationsmessgeräte""",
    )

    dfg_2730_6 = VocabularyTerm(
        code="DFG_2730_6",
        label="2730 PCM meters (except 2740)",
        description="""PCM meters (except 2740)//PCM-Messplätze (außer 2740)""",
    )

    dfg_2730_7 = VocabularyTerm(
        code="DFG_2730_7",
        label="2730 PCM modulators, signal conditioners",
        description="""PCM modulators, signal conditioners//PCM-Modulatoren, -Signal-Conditioner""",
    )

    dfg_2730_8 = VocabularyTerm(
        code="DFG_2730_8",
        label="2730 Ring modulators, ring mixers",
        description="""Ring modulators, ring mixers//Ringmodulatoren, -mischer""",
    )

    dfg_2730_9 = VocabularyTerm(
        code="DFG_2730_9",
        label="2730 Stereocoders",
        description="""Stereocoders//Stereocoder""",
    )

    dfg_2730_10 = VocabularyTerm(
        code="DFG_2730_10",
        label="2730 Stereo measurement decoders",
        description="""Stereo measurement decoders//Stereomessdecoder""",
    )

    dfg_2730_11 = VocabularyTerm(
        code="DFG_2730_11",
        label="2730 Vocoders",
        description="""Vocoders//Vocoder""",
    )

    dfg_2740_1 = VocabularyTerm(
        code="DFG_2740_1",
        label="2740 Data testers, special data measuring instruments",
        description="""Data testers, special data measuring instruments//Datentester, spezielle Datenmessgeräte""",
    )

    dfg_2740_2 = VocabularyTerm(
        code="DFG_2740_2",
        label="2740 Dispersion meters for optical cables",
        description="""Dispersion meters for optical cables//Dispersionsmessgeräte für optische Kabel""",
    )

    dfg_2740_3 = VocabularyTerm(
        code="DFG_2740_3",
        label="2740 Pulse meters for teletype and data transmission (except oscilloscopes)",
        description="""Pulse meters for teletype and data transmission (except oscilloscopes)//Impulsmessgeräte für Fernschreib- und Datentechnik (außer Oszilloskope)""",
    )

    dfg_2740_4 = VocabularyTerm(
        code="DFG_2740_4",
        label="2740 Phase distortion meters (teletype and data transmission)",
        description="""Phase distortion meters (teletype and data transmission)//Phasenverzerrungs-Messgeräte (Fernschreib- und Datentechnik)""",
    )

    dfg_2740_5 = VocabularyTerm(
        code="DFG_2740_5",
        label="2740 Special measuring instruments for teletype and data transmission (except autom. measuring machines, logic amplifiers 7330)",
        description="""Special measuring instruments for teletype and data transmission (except autom. measuring machines, logic amplifiers 7330)//Spezielle Messgeräte für Fernschreib- und Datentechnik (außer Messautomaten, Logikprüfgeräte 7330)""",
    )

    dfg_2740_6 = VocabularyTerm(
        code="DFG_2740_6",
        label="2740 Pulse detectors and counters, glitch detectors",
        description="""Pulse detectors and counters, glitch detectors//Störimpulsdetektoren und -zähler, Glitch-Detektoren""",
    )

    dfg_2750_1 = VocabularyTerm(
        code="DFG_2750_1",
        label="2750 Receivers (radio), special measuring receivers (except 6620)",
        description="""Receivers (radio), special measuring receivers (except 6620)//Empfänger (Funk-), spezielle Messempfänger (außer 6620)""",
    )

    dfg_2750_2 = VocabularyTerm(
        code="DFG_2750_2",
        label="2750 Noise voltage meters",
        description="""Noise voltage meters//Geräuschspannungsmessgeräte""",
    )

    dfg_2750_3 = VocabularyTerm(
        code="DFG_2750_3",
        label="2750 WOW & Flutter Meters",
        description="""WOW & Flutter Meters//Gleichlaufschwankungsmesser (WOW & Flutter Meter)""",
    )

    dfg_2750_4 = VocabularyTerm(
        code="DFG_2750_4",
        label="2750 Distortion analysers",
        description="""Distortion analysers//Klirranalysatoren""",
    )

    dfg_2750_5 = VocabularyTerm(
        code="DFG_2750_5",
        label="2750 Distortion measuring bridges",
        description="""Distortion measuring bridges//Klirrfaktormessbrücken""",
    )

    dfg_2750_6 = VocabularyTerm(
        code="DFG_2750_6",
        label="2750 Level meters (except 6420)",
        description="""Level meters (except 6420)//Pegelmessplätze (außer 6420)""",
    )

    dfg_2750_7 = VocabularyTerm(
        code="DFG_2750_7",
        label="2750 Psophometer",
        description="""Psophometer//Psophometer""",
    )

    dfg_2750_8 = VocabularyTerm(
        code="DFG_2750_8",
        label="2750 Noise distortion meters",
        description="""Noise distortion meters//Rausch-Klirr-Messplätze""",
    )

    dfg_2750_9 = VocabularyTerm(
        code="DFG_2750_9",
        label="2750 Noise voltage meters, noise level meters",
        description="""Noise voltage meters, noise level meters//Rauschspannungs-Messgeräte, Rauschpegelmesser""",
    )

    dfg_2750_10 = VocabularyTerm(
        code="DFG_2750_10",
        label="2750 Directional radio measuring sets (except 2710-2740)",
        description="""Directional radio measuring sets (except 2710-2740)//Richtfunkmessplätze (außer 2710-2740)""",
    )

    dfg_2750_11 = VocabularyTerm(
        code="DFG_2750_11",
        label="2750 Special measuring instruments for telephone, radio and sound studio technology (except television technology)",
        description="""Special measuring instruments for telephone, radio and sound studio technology (except television technology)//Spezielle Messgeräte der Fernsprech-, Funk- und Tonstudiotechnik (außer Fernsehtechnik)""",
    )

    dfg_2750_12 = VocabularyTerm(
        code="DFG_2750_12",
        label="2750 Voltage measuring instruments",
        description="""Voltage measuring instruments//Störspannungsmessgeräte""",
    )

    dfg_2750_13 = VocabularyTerm(
        code="DFG_2750_13",
        label="2750 String recording instruments",
        description="""String recording instruments//Störwerterfassungsgeräte""",
    )

    dfg_2750_14 = VocabularyTerm(
        code="DFG_2750_14",
        label="2750 Sound level fluctuation meters (WOW & Flutter meters)",
        description="""Sound level fluctuation meters (WOW & Flutter meters)//Tonhöhen-Schwankungsmesser (WOW & Flutter Meter)""",
    )

    dfg_2760_1 = VocabularyTerm(
        code="DFG_2760_1",
        label="2760 Picture pattern generators",
        description="""Picture pattern generators//Bildmuster-Generatoren""",
    )

    dfg_2760_2 = VocabularyTerm(
        code="DFG_2760_2",
        label="2760 Colour signal generators (colour bar generators)",
        description="""Colour signal generators (colour bar generators)//Farbsignal-, (Farbbalken-Generatoren)""",
    )

    dfg_2760_3 = VocabularyTerm(
        code="DFG_2760_3",
        label="2760 Special measuring instruments for television technology",
        description="""Special measuring instruments for television technology//Spezielle Messgeräte der Fernsehtechnik""",
    )

    dfg_2760_4 = VocabularyTerm(
        code="DFG_2760_4",
        label="2760 Video laboratory unit (A/D converter, D/A converter, display, combined)",
        description="""Video laboratory unit (A/D converter, D/A converter, display, combined)//Video-Laboratory-unit (A/D-Wandler, D/A-Wandler, Display, kombiniert)""",
    )

    dfg_2760_5 = VocabularyTerm(
        code="DFG_2760_5",
        label="2760 Video-prfsignal-, prfline-generators",
        description="""Video-prfsignal-, prfline-generators//Video-Prüfsignal-, Prüfzeilen-Generatoren""",
    )

    dfg_2770_1 = VocabularyTerm(
        code="DFG_2770_1",
        label="2770 Shielded rooms (electromagnetic)",
        description="""Shielded rooms (electromagnetic)//Abgeschirmte Räume (elektromagnetisch)""",
    )

    dfg_2770_2 = VocabularyTerm(
        code="DFG_2770_2",
        label="2770 Suppressed",
        description="""Suppressed//Entstörgeräte""",
    )

    dfg_2770_3 = VocabularyTerm(
        code="DFG_2770_3",
        label="2770 Filter circuits (electrical shielding, suppression)",
        description="""Filter circuits (electrical shielding, suppression)//Filterkreise (elektrische Abschirmung, Entstörung)""",
    )

    dfg_2770_4 = VocabularyTerm(
        code="DFG_2770_4",
        label="2770 Anechoic chambers (electromagnetic)",
        description="""Anechoic chambers (electromagnetic)//Reflexionsfreie Räume (elektromagnetisch)""",
    )

    dfg_2770_5 = VocabularyTerm(
        code="DFG_2770_5",
        label="2770 Current protection devices and systems, Faraday cages",
        description="""Current protection devices and systems, Faraday cages//Störschutzgeräte und -anlagen, Faraday-Käfige""",
    )

    dfg_2770_6 = VocabularyTerm(
        code="DFG_2770_6",
        label="2770 Current cleaners (smoothing)",
        description="""Current cleaners (smoothing)//Stromreiniger (Glättung)""",
    )

    dfg_2780_1 = VocabularyTerm(
        code="DFG_2780_1",
        label="2780 Characteristic recorders (for semiconductor components and tubes)",
        description="""Characteristic recorders (for semiconductor components and tubes)//Kennlinienschreiber (für Halbleiterbauelemente und Röhren)""",
    )

    dfg_2780_2 = VocabularyTerm(
        code="DFG_2780_2",
        label="2780 Probers (devices) for semiconductor components",
        description="""Probers (devices) for semiconductor components//Prober (Prüfgeräte) für Halbleiterbausteine""",
    )

    dfg_2780_3 = VocabularyTerm(
        code="DFG_2780_3",
        label="2780 Probes (wafer probers) for semiconductor devices",
        description="""Probes (wafer probers) for semiconductor devices//Sondenmessplätze (Wafer Prober) für Halbleiterbausteine""",
    )

    dfg_2780_4 = VocabularyTerm(
        code="DFG_2780_4",
        label="2780 Special measuring and testing instruments for semiconductors and tubes (except 6200-6590)",
        description="""Special measuring and testing instruments for semiconductors and tubes (except 6200-6590)//Spezielle Mess- und Prüfgeräte für Halbleiter und Röhren (außer 6200-6590)""",
    )

    dfg_2780_5 = VocabularyTerm(
        code="DFG_2780_5",
        label="2780 Transistor and tube testers",
        description="""Transistor and tube testers//Transistor-, Röhrenprüfgeräte""",
    )

    dfg_2790_1 = VocabularyTerm(
        code="DFG_2790_1",
        label="2790 Other communication equipment (except 2700-2780 and 6600-6790)",
        description="""Other communication equipment (except 2700-2780 and 6600-6790)//Sonstige nachrichtentechnische Geräte (außer 2700-2780 und 6600-6790)""",
    )

    dfg_2800_1 = VocabularyTerm(
        code="DFG_2800_1",
        label="2800 Outboard motors",
        description="""Outboard motors//Außenbordmotoren""",
    )

    dfg_2800_2 = VocabularyTerm(
        code="DFG_2800_2",
        label="2800 Boat engines",
        description="""Boat engines//Bootsmotoren""",
    )

    dfg_2800_3 = VocabularyTerm(
        code="DFG_2800_3",
        label="2800 Rotary engines, rotary lobe engines",
        description="""Rotary engines, rotary lobe engines//Drehkolben-, Wälzkolbenmotoren""",
    )

    dfg_2800_4 = VocabularyTerm(
        code="DFG_2800_4",
        label="2800 Engines (petrol, diesel)",
        description="""Engines (petrol, diesel)//Motoren (Otto-, Diesel-)""",
    )

    dfg_2800_5 = VocabularyTerm(
        code="DFG_2800_5",
        label="2800 Fuel engines (for fuels)",
        description="""Fuel engines (for fuels)//Prüfmotoren (für Kraftstoffe)""",
    )

    dfg_2800_6 = VocabularyTerm(
        code="DFG_2800_6",
        label="2800 Rotary engines",
        description="""Rotary engines//Rotationsmotoren""",
    )

    dfg_2800_7 = VocabularyTerm(
        code="DFG_2800_7",
        label="2800 Internal combustion engines",
        description="""Internal combustion engines//Verbrennungsmotoren""",
    )

    dfg_2810_1 = VocabularyTerm(
        code="DFG_2810_1",
        label="2810 Steam engines and turbines",
        description="""Steam engines and turbines//Dampfmaschinen und -turbinen""",
    )

    dfg_2810_2 = VocabularyTerm(
        code="DFG_2810_2",
        label="2810 Steam engines (except 8010 compressors)",
        description="""Steam engines (except 8010 compressors)//Kolbendampfmaschinen (außer Verdichter 8010)""",
    )

    dfg_2820_1 = VocabularyTerm(
        code="DFG_2820_1",
        label="2820 Compressed air and hydraulic engines",
        description="""Compressed air and hydraulic engines//Pressluft- und Hydromotoren""",
    )

    dfg_2820_2 = VocabularyTerm(
        code="DFG_2820_2",
        label="2820 Water engines",
        description="""Water engines//Wassermotoren""",
    )

    dfg_2830_1 = VocabularyTerm(
        code="DFG_2830_1",
        label="2830 lturbines",
        description="""lturbines//Ölturbinen""",
    )

    dfg_2830_2 = VocabularyTerm(
        code="DFG_2830_2",
        label="2830 Water motors",
        description="""Water motors//Wasserräder""",
    )

    dfg_2830_3 = VocabularyTerm(
        code="DFG_2830_3",
        label="2830 Water turbines and auxiliaries",
        description="""Water turbines and auxiliaries//Wasserturbinen und Hilfseinrichtungen""",
    )

    dfg_2840_1 = VocabularyTerm(
        code="DFG_2840_1",
        label="2840 Expansion turbines (gas desulphurisers)",
        description="""Expansion turbines (gas desulphurisers)//Expansionsturbinen (Gasverflüssiger)""",
    )

    dfg_2840_2 = VocabularyTerm(
        code="DFG_2840_2",
        label="2840 Gas turbines, jet engines, rocket engines",
        description="""Gas turbines, jet engines, rocket engines//Gasturbinen, Strahltriebwerke, Raketentriebwerke""",
    )

    dfg_2840_3 = VocabularyTerm(
        code="DFG_2840_3",
        label="2840 Ramjet engines",
        description="""Ramjet engines//Staustrahltriebwerke""",
    )

    dfg_2840_4 = VocabularyTerm(
        code="DFG_2840_4",
        label="2840 Turbines for gas, compressed air",
        description="""Turbines for gas, compressed air//Turbinen für Gas, Pressluft""",
    )

    dfg_2840_5 = VocabularyTerm(
        code="DFG_2840_5",
        label="2840 Turbochargers",
        description="""Turbochargers//Turbolader""",
    )

    dfg_2850_1 = VocabularyTerm(
        code="DFG_2850_1",
        label="2850 Propulsion units",
        description="""Propulsion units//Antriebe""",
    )

    dfg_2850_2 = VocabularyTerm(
        code="DFG_2850_2",
        label="2850 Brakes (machine elements)",
        description="""Brakes (machine elements)//Bremsen (Maschinenelemente)""",
    )

    dfg_2850_3 = VocabularyTerm(
        code="DFG_2850_3",
        label="2850 Torque converters",
        description="""Torque converters//Drehmomentwandler""",
    )

    dfg_2850_4 = VocabularyTerm(
        code="DFG_2850_4",
        label="2850 Speed converters, electromagnetic",
        description="""Speed converters, electromagnetic//Drehzahlwandler, elektromagnetische""",
    )

    dfg_2850_5 = VocabularyTerm(
        code="DFG_2850_5",
        label="2850 Gearboxes and special machine parts",
        description="""Gearboxes and special machine parts//Getriebe und spezielle Maschinenteile""",
    )

    dfg_2850_6 = VocabularyTerm(
        code="DFG_2850_6",
        label="2850 Hydraulic transmissions",
        description="""Hydraulic transmissions//Hydraulische Getriebe""",
    )

    dfg_2850_7 = VocabularyTerm(
        code="DFG_2850_7",
        label="2850 Ball bearing guides",
        description="""Ball bearing guides//Kugelführungen""",
    )

    dfg_2850_8 = VocabularyTerm(
        code="DFG_2850_8",
        label="2850 Clutches",
        description="""Clutches//Kupplungen""",
    )

    dfg_2850_9 = VocabularyTerm(
        code="DFG_2850_9",
        label="2850 Bearings (machine elements)",
        description="""Bearings (machine elements)//Lager (Maschinenelemente)""",
    )

    dfg_2850_10 = VocabularyTerm(
        code="DFG_2850_10",
        label="2850 Planetary gears",
        description="""Planetary gears//Planetengetriebe""",
    )

    dfg_2850_11 = VocabularyTerm(
        code="DFG_2850_11",
        label="2850 Positioning drives (except for optics 5900)",
        description="""Positioning drives (except for optics 5900)//Positionier-Antriebe (außer für Optik 5900)""",
    )

    dfg_2850_12 = VocabularyTerm(
        code="DFG_2850_12",
        label="2850 Variable speed gear",
        description="""Variable speed gear//Regelgetriebe""",
    )

    dfg_2850_13 = VocabularyTerm(
        code="DFG_2850_13",
        label="2850 Gearboxes",
        description="""Gearboxes//Schaltgetriebe""",
    )

    dfg_2850_14 = VocabularyTerm(
        code="DFG_2850_14",
        label="2850 Gate drives, drives for rollers",
        description="""Gate drives, drives for rollers//Torantriebe, Antriebe für Rolläden""",
    )

    dfg_2850_15 = VocabularyTerm(
        code="DFG_2850_15",
        label="2850 Rolling guide systems",
        description="""Rolling guide systems//Wälzführungssysteme""",
    )

    dfg_2860_1 = VocabularyTerm(
        code="DFG_2860_1",
        label="2860 Exhaust gas measuring equipment",
        description="""Exhaust gas measuring equipment//Abgasmesseinrichtungen""",
    )

    dfg_2860_2 = VocabularyTerm(
        code="DFG_2860_2",
        label="2860 Combustion chamber test rigs",
        description="""Combustion chamber test rigs//Brennkammerprüfstände""",
    )

    dfg_2860_3 = VocabularyTerm(
        code="DFG_2860_3",
        label="2860 Bearing assemblies",
        description="""Bearing assemblies//Lagerprüfstände""",
    )

    dfg_2860_4 = VocabularyTerm(
        code="DFG_2860_4",
        label="2860 Power measuring equipment for engines, power brakes",
        description="""Power measuring equipment for engines, power brakes//Leistungsmessanlagen für Motoren, Leistungsbremsen""",
    )

    dfg_2860_5 = VocabularyTerm(
        code="DFG_2860_5",
        label="2860 Engine and transmission test rigs, compressor test rigs",
        description="""Engine and transmission test rigs, compressor test rigs//Motoren- und Getriebeprüfstände, Verdichterprüfstände""",
    )

    dfg_2860_6 = VocabularyTerm(
        code="DFG_2860_6",
        label="2860 Engine dynamometers, testers",
        description="""Engine dynamometers, testers//Motorprüfgeräte, -tester""",
    )

    dfg_2860_7 = VocabularyTerm(
        code="DFG_2860_7",
        label="2860 Pendulum generators",
        description="""Pendulum generators//Pendelgeneratoren""",
    )

    dfg_2860_8 = VocabularyTerm(
        code="DFG_2860_8",
        label="2860 Turbine test stands",
        description="""Turbine test stands//Turbinenprüfstände""",
    )

    dfg_2860_9 = VocabularyTerm(
        code="DFG_2860_9",
        label="2860 Water brakes",
        description="""Water brakes//Wasserbremsen""",
    )

    dfg_2860_10 = VocabularyTerm(
        code="DFG_2860_10",
        label="2860 Eddy current brakes",
        description="""Eddy current brakes//Wirbelstrombremsen""",
    )

    dfg_2870_1 = VocabularyTerm(
        code="DFG_2870_1",
        label="2870 Steam generators, boiler plants for turbines and steam engines",
        description="""Steam generators, boiler plants for turbines and steam engines//Dampferzeuger-, Kesselanlagen für Turbinen und Dampfmaschinen""",
    )

    dfg_2870_2 = VocabularyTerm(
        code="DFG_2870_2",
        label="2870 Condensers, steam engine",
        description="""Condensers, steam engine//Kondensatoren, Dampfmaschinen-""",
    )

    dfg_2880_1 = VocabularyTerm(
        code="DFG_2880_1",
        label="2880 Exhaust gas systems, exhaust systems",
        description="""Exhaust gas systems, exhaust systems//Abgasanlagen, Auspuffanlagen""",
    )

    dfg_2880_2 = VocabularyTerm(
        code="DFG_2880_2",
        label="2880 Exhaust gas decontamination and purification plants",
        description="""Exhaust gas decontamination and purification plants//Abgas-Entgiftungs-, -Reinigungsanlagen""",
    )

    dfg_2880_3 = VocabularyTerm(
        code="DFG_2880_3",
        label="2880 Electrostatic precipitators (dust)",
        description="""Electrostatic precipitators (dust)//Elektrofilter (Staub-)""",
    )

    dfg_2880_4 = VocabularyTerm(
        code="DFG_2880_4",
        label="2880 Flue gas decontamination and dust removal plants",
        description="""Flue gas decontamination and dust removal plants//Entgiftungs- und Entstaubungsanlagen""",
    )

    dfg_2880_5 = VocabularyTerm(
        code="DFG_2880_5",
        label="2880 Flue gas neutralisation plants",
        description="""Flue gas neutralisation plants//Rauchgasneutralisationsanlagen""",
    )

    dfg_2880_6 = VocabularyTerm(
        code="DFG_2880_6",
        label="2880 Chimneys, flue gas stacks",
        description="""Chimneys, flue gas stacks//Schornsteine, Abgaskamine""",
    )

    dfg_2890_1 = VocabularyTerm(
        code="DFG_2890_1",
        label="2890 Ion thrusters",
        description="""Ion thrusters//Ionen-Triebwerke""",
    )

    dfg_2890_2 = VocabularyTerm(
        code="DFG_2890_2",
        label="2890 Flywheel accumulators",
        description="""Flywheel accumulators//Schwungradspeicher""",
    )

    dfg_2890_3 = VocabularyTerm(
        code="DFG_2890_3",
        label="2890 Other engines and prime movers",
        description="""Other engines and prime movers//Sonstige Motoren und Kraftmaschinen""",
    )

    dfg_2890_4 = VocabularyTerm(
        code="DFG_2890_4",
        label="2890 Engines, other (except 2800-2840)",
        description="""Engines, other (except 2800-2840)//Triebwerke, sonstige (außer 2800-2840)""",
    )

    dfg_2890_5 = VocabularyTerm(
        code="DFG_2890_5",
        label="2890 Wind engines",
        description="""Wind engines//Windkraftmaschinen""",
    )

    dfg_2890_6 = VocabularyTerm(
        code="DFG_2890_6",
        label="2890 Windrder",
        description="""Windrder//Windräder""",
    )

    dfg_2900_1 = VocabularyTerm(
        code="DFG_2900_1",
        label="2900 Bending machines (strength testing)",
        description="""Bending machines (strength testing)//Biegemaschinen (Festigkeitsprüfung)""",
    )

    dfg_2900_2 = VocabularyTerm(
        code="DFG_2900_2",
        label="2900 Compressive strength testing machines",
        description="""Compressive strength testing machines//Druckfestigkeitsprüfmaschinen""",
    )

    dfg_2900_3 = VocabularyTerm(
        code="DFG_2900_3",
        label="2900 Static and quasi-static testing machines and equipment",
        description="""Static and quasi-static testing machines and equipment//Statische und quasistatische Prüfmaschinen und -anlagen""",
    )

    dfg_2900_4 = VocabularyTerm(
        code="DFG_2900_4",
        label="2900 Creep testing machines",
        description="""Creep testing machines//Zeitstandprüfmaschinen""",
    )

    dfg_2900_5 = VocabularyTerm(
        code="DFG_2900_5",
        label="2900 Tensile testing machines",
        description="""Tensile testing machines//Zerreißmaschinen""",
    )

    dfg_2900_6 = VocabularyTerm(
        code="DFG_2900_6",
        label="2900 Tensile strength testing machines",
        description="""Tensile strength testing machines//Zugfestigkeitsmesser""",
    )

    dfg_2910_1 = VocabularyTerm(
        code="DFG_2910_1",
        label="2910 Dynamic testing machines and installations, pulsers",
        description="""Dynamic testing machines and installations, pulsers//Dynamische Prüfmaschinen und -anlagen, Pulser""",
    )

    dfg_2910_2 = VocabularyTerm(
        code="DFG_2910_2",
        label="2910 Spring testing machines",
        description="""Spring testing machines//Federprüfmaschinen""",
    )

    dfg_2910_3 = VocabularyTerm(
        code="DFG_2910_3",
        label="2910 Hydropulse machines",
        description="""Hydropulse machines//Hydropuls-Maschinen""",
    )

    dfg_2910_4 = VocabularyTerm(
        code="DFG_2910_4",
        label="2910 Pressing machines (with hydraulic cylinders)",
        description="""Pressing machines (with hydraulic cylinders)//Prüfgerüste (mit hydraulischen Zylindern)""",
    )

    dfg_2910_5 = VocabularyTerm(
        code="DFG_2910_5",
        label="2910 Vibration testing machines (resonance pulsers)",
        description="""Vibration testing machines (resonance pulsers)//Schwingprüfmaschinen (Resonanzpulser)""",
    )

    dfg_2910_6 = VocabularyTerm(
        code="DFG_2910_6",
        label="2910 Servo-hydraulic testing machines and equipment",
        description="""Servo-hydraulic testing machines and equipment//Servohydraulische Prüfmaschinen und Anlagen""",
    )

    dfg_2910_7 = VocabularyTerm(
        code="DFG_2910_7",
        label="2910 Torsion machines (testing machines)",
        description="""Torsion machines (testing machines)//Torsionsmaschinen (Prüfmaschinen)""",
    )

    dfg_2910_8 = VocabularyTerm(
        code="DFG_2910_8",
        label="2910 Universal testing machines (tension, compression, dynamic, static)",
        description="""Universal testing machines (tension, compression, dynamic, static)//Universal-Prüfmaschinen (Zug-, Druck-, dynamisch, statisch)""",
    )

    dfg_2920_1 = VocabularyTerm(
        code="DFG_2920_1",
        label="2920 Catapult machines for impact tests",
        description="""Catapult machines for impact tests//Katapultanlagen für Aufpralltests""",
    )

    dfg_2920_2 = VocabularyTerm(
        code="DFG_2920_2",
        label="2920 Test tables (material testing)",
        description="""Test tables (material testing)//Rütteltische (Werkstoff-Prüfung)""",
    )

    dfg_2920_3 = VocabularyTerm(
        code="DFG_2920_3",
        label="2920 Impact testing equipment",
        description="""Impact testing equipment//Schlagfestigkeitsprüfgeräte""",
    )

    dfg_2920_4 = VocabularyTerm(
        code="DFG_2920_4",
        label="2920 Impact testing machines, vibration and acceleration testing equipment",
        description="""Impact testing machines, vibration and acceleration testing equipment//Schlagprüfmaschinen, Vibrations- und Beschleunigungs-Prüfanlagen""",
    )

    dfg_2920_5 = VocabularyTerm(
        code="DFG_2920_5",
        label="2920 Shock testing equipment",
        description="""Shock testing equipment//Schockprüfanlagen""",
    )

    dfg_2920_6 = VocabularyTerm(
        code="DFG_2920_6",
        label="2920 Vibration test benches and equipment",
        description="""Vibration test benches and equipment//Schwingungs-Prüfstände und -Anlagen""",
    )

    dfg_2920_7 = VocabularyTerm(
        code="DFG_2920_7",
        label="2920 Testing tables",
        description="""Testing tables//Stoßtische""",
    )

    dfg_2920_8 = VocabularyTerm(
        code="DFG_2920_8",
        label="2920 Test centrifuges for acceleration and component testing",
        description="""Test centrifuges for acceleration and component testing//Testzentrifugen für Beschleunigungstests und Komponentenprüfung""",
    )

    dfg_2930_1 = VocabularyTerm(
        code="DFG_2930_1",
        label="2930 Hearing test equipment (optical)",
        description="""Hearing test equipment (optical)//Härteprüfer (optische)""",
    )

    dfg_2930_2 = VocabularyTerm(
        code="DFG_2930_2",
        label="2930 Hearing testing machines, friction and wear testing machines",
        description="""Hearing testing machines, friction and wear testing machines//Härteprüfmaschinen, Reibungs- und Verschleiß-Prüfmaschinen""",
    )

    dfg_2930_3 = VocabularyTerm(
        code="DFG_2930_3",
        label="2930 Point load testers (rock testing)",
        description="""Point load testers (rock testing)//Punktlastgeräte (Härteprüfung an Gestein)""",
    )

    dfg_2930_4 = VocabularyTerm(
        code="DFG_2930_4",
        label="2930 Lubricating impact machinery",
        description="""Lubricating impact machinery//Schmiermittelprüfmaschinen""",
    )

    dfg_2940_1 = VocabularyTerm(
        code="DFG_2940_1",
        label="2940 Bitumen testing machines (except 1610 and 1620)",
        description="""Bitumen testing machines (except 1610 and 1620)//Bitumen-Prüfgeräte (außer 1610 und 1620)""",
    )

    dfg_2940_2 = VocabularyTerm(
        code="DFG_2940_2",
        label="2940 Fluorophores, Vane samplers (soil shear strength testers)",
        description="""Fluorophores, Vane samplers (soil shear strength testers)//Flügelsonden, Vane-Proben (Bodenscherfestigkeitsmessgeräte)""",
    )

    dfg_2940_3 = VocabularyTerm(
        code="DFG_2940_3",
        label="2940 Gypsum testing machines",
        description="""Gypsum testing machines//Gipsprüfmaschinen""",
    )

    dfg_2940_4 = VocabularyTerm(
        code="DFG_2940_4",
        label="2940 Marshall presses, compaction equipment for bituminous building materials",
        description="""Marshall presses, compaction equipment for bituminous building materials//Marshall-Prüfpressen, -Verdichtungsgeräte für bituminöse Baustoffe""",
    )

    dfg_2940_5 = VocabularyTerm(
        code="DFG_2940_5",
        label="2940 Measuring and testing equipment for soil and rock mechanics, soil erosion",
        description="""Measuring and testing equipment for soil and rock mechanics, soil erosion//Mess- und Versuchsanlagen für Boden- und Felsmechanik, Bodenerosion""",
    )

    dfg_2940_6 = VocabularyTerm(
        code="DFG_2940_6",
        label="2940 Oedometer (soil test equipment)",
        description="""Oedometer (soil test equipment)//Oedometer (Bodenprüfgerät)""",
    )

    dfg_2940_7 = VocabularyTerm(
        code="DFG_2940_7",
        label="2940 Pressiometer (soil and building material testing)",
        description="""Pressiometer (soil and building material testing)//Pressiometer (Boden- und Baustoffprüfung)""",
    )

    dfg_2940_8 = VocabularyTerm(
        code="DFG_2940_8",
        label="2940 Proctor rigs (soil density according to Proctor)",
        description="""Proctor rigs (soil density according to Proctor)//Proctorgeräte (Bodendichte nach Proctor)""",
    )

    dfg_2940_9 = VocabularyTerm(
        code="DFG_2940_9",
        label="2940 Special soil and building material testers, shear testers",
        description="""Special soil and building material testers, shear testers//Spezielle Baustoff- und Bodenprüfgeräte, Schergeräte""",
    )

    dfg_2940_10 = VocabularyTerm(
        code="DFG_2940_10",
        label="2940 Triaxial testers (soil and building material testing)",
        description="""Triaxial testers (soil and building material testing)//Triaxialgeräte (Boden- und Baustoffprüfung)""",
    )

    dfg_2940_11 = VocabularyTerm(
        code="DFG_2940_11",
        label="2940 Cement testers",
        description="""Cement testers//Zementprüfgeräte""",
    )

    dfg_2950_1 = VocabularyTerm(
        code="DFG_2950_1",
        label="2950 Special embossing machines for wood and paper",
        description="""Special embossing machines for wood and paper//Spezielle Prüfmaschinen für Holz und Papier""",
    )

    dfg_2950_2 = VocabularyTerm(
        code="DFG_2950_2",
        label="2950 Pulp stamping machines",
        description="""Pulp stamping machines//Zellstoffprüfapparate""",
    )

    dfg_2960_1 = VocabularyTerm(
        code="DFG_2960_1",
        label="2960 Yarn tension testers, structure analysers",
        description="""Yarn tension testers, structure analysers//Faden-Spannungs-Messgeräte, -Strukturanalysegeräte""",
    )

    dfg_2960_2 = VocabularyTerm(
        code="DFG_2960_2",
        label="2960 Fibre strength testers",
        description="""Fibre strength testers//Faserfestigkeits-Prüfgeräte""",
    )

    dfg_2960_3 = VocabularyTerm(
        code="DFG_2960_3",
        label="2960 Yarn scales",
        description="""Yarn scales//Garnwaagen""",
    )

    dfg_2960_4 = VocabularyTerm(
        code="DFG_2960_4",
        label="2960 Special textile testing machines",
        description="""Special textile testing machines//Spezielle Prüfmaschinen für Textilien""",
    )

    dfg_2960_5 = VocabularyTerm(
        code="DFG_2960_5",
        label="2960 Spinning machines",
        description="""Spinning machines//Spinnprüfmaschinen""",
    )

    dfg_2960_6 = VocabularyTerm(
        code="DFG_2960_6",
        label="2960 Textile thickness gauges",
        description="""Textile thickness gauges//Textildickenmesser""",
    )

    dfg_2970_1 = VocabularyTerm(
        code="DFG_2970_1",
        label="2970 Paint and varnish testers (except 4130)",
        description="""Paint and varnish testers (except 4130)//Lack- und Farbenprüfgeräte (außer 4130)""",
    )

    dfg_2970_2 = VocabularyTerm(
        code="DFG_2970_2",
        label="2970 Light fastness testers",
        description="""Light fastness testers//Lichtechtheitsprüfgeräte""",
    )

    dfg_2970_3 = VocabularyTerm(
        code="DFG_2970_3",
        label="2970 Special testing machines for plastics, rubber, leather and varnish",
        description="""Special testing machines for plastics, rubber, leather and varnish//Spezielle Prüfmaschinen für Kunststoffe, Gummi, Leder und Lack""",
    )

    dfg_2980_1 = VocabularyTerm(
        code="DFG_2980_1",
        label="2980 Climatic test chambers for material testing",
        description="""Climatic test chambers for material testing//Klimaprüfkammern für Materialprüfung""",
    )

    dfg_2980_2 = VocabularyTerm(
        code="DFG_2980_2",
        label="2980 Test chambers (climatic, vacuum, vibration) and corrosion test equipment",
        description="""Test chambers (climatic, vacuum, vibration) and corrosion test equipment//Prüfkammern (Klima, Vakuum, Vibration) und Korrosionsprüfgeräte""",
    )

    dfg_2980_3 = VocabularyTerm(
        code="DFG_2980_3",
        label="2980 Vacuum test chambers",
        description="""Vacuum test chambers//Vakuumprüfkammern""",
    )

    dfg_2990_1 = VocabularyTerm(
        code="DFG_2990_1",
        label="2990 Dynamic mechanical spectrometers",
        description="""Dynamic mechanical spectrometers//Dynamisch-Mechanische Spektrometer""",
    )

    dfg_2990_2 = VocabularyTerm(
        code="DFG_2990_2",
        label="2990 Glaze testers",
        description="""Glaze testers//Glasurspannungsmesser""",
    )

    dfg_2990_3 = VocabularyTerm(
        code="DFG_2990_3",
        label="2990 Creep testers",
        description="""Creep testers//Kriechprüfgeräte""",
    )

    dfg_2990_4 = VocabularyTerm(
        code="DFG_2990_4",
        label="2990 Material testers - accessories",
        description="""Material testers - accessories//Materialprüfgeräte-Zubehör""",
    )

    dfg_2990_5 = VocabularyTerm(
        code="DFG_2990_5",
        label="2990 Other material testing machines and accessories (except 2900-2980 and 4100-4190)",
        description="""Other material testing machines and accessories (except 2900-2980 and 4100-4190)//Sonstige Werkstoff-Prüfmaschinen und Zubehör (außer 2900-2980 und 4100-4190)""",
    )

    dfg_2990_6 = VocabularyTerm(
        code="DFG_2990_6",
        label="2990 Clay testers, glaze testers",
        description="""Clay testers, glaze testers//Tonprüfgeräte, Glasurspannungsmesser""",
    )

    dfg_3000_1 = VocabularyTerm(
        code="DFG_3000_1",
        label="3000 Blood pressure gauges and sphygmographs",
        description="""Blood pressure gauges and sphygmographs//Blutdruckmessgeräte und Sphygmographen""",
    )

    dfg_3000_2 = VocabularyTerm(
        code="DFG_3000_2",
        label="3000 Pressure transducers for physiological measurements",
        description="""Pressure transducers for physiological measurements//Druckaufnehmer für physiologische Messungen""",
    )

    dfg_3000_3 = VocabularyTerm(
        code="DFG_3000_3",
        label="3000 Electromanometers (blood pressure measurement)",
        description="""Electromanometers (blood pressure measurement)//Elektromanometer (Blutdruckmessung)""",
    )

    dfg_3000_4 = VocabularyTerm(
        code="DFG_3000_4",
        label="3000 Vascular pressure measuring instruments",
        description="""Vascular pressure measuring instruments//Gefäßdruckmessgeräte""",
    )

    dfg_3000_5 = VocabularyTerm(
        code="DFG_3000_5",
        label="3000 Cardiac catheters, cardiac catheter measuring sets (except X-ray equipment 3210)",
        description="""Cardiac catheters, cardiac catheter measuring sets (except X-ray equipment 3210)//Herz-Katheter, Herz-Katheter-Messplätze (außer Röntgeneinrichtungen 3210)""",
    )

    dfg_3000_6 = VocabularyTerm(
        code="DFG_3000_6",
        label="3000 Korotkoff microphones (blood pressure measurement)",
        description="""Korotkoff microphones (blood pressure measurement)//Korotkoff-Mikrofone (Blutdruckmessung)""",
    )

    dfg_3000_7 = VocabularyTerm(
        code="DFG_3000_7",
        label="3000 Sphygmomanometers, -graphs",
        description="""Sphygmomanometers, -graphs//Sphygmomanometer, -graphen""",
    )

    dfg_3010_1 = VocabularyTerm(
        code="DFG_3010_1",
        label="3010 (blood flow measurement)",
        description="""(blood flow measurement)//(Durchblutungsmessung)""",
    )

    dfg_3010_2 = VocabularyTerm(
        code="DFG_3010_2",
        label="3010 Blood flowmeters",
        description="""Blood flowmeters//Blutdurchflussmessgeräte""",
    )

    dfg_3010_3 = VocabularyTerm(
        code="DFG_3010_3",
        label="3010 Blood flow meters (flowmeters)",
        description="""Blood flow meters (flowmeters)//Blutströmungsmessgeräte (Flowmeter)""",
    )

    dfg_3010_4 = VocabularyTerm(
        code="DFG_3010_4",
        label="3010 Blood flowmeters",
        description="""Blood flowmeters//Durchblutungsmessgeräte""",
    )

    dfg_3010_5 = VocabularyTerm(
        code="DFG_3010_5",
        label="3010 Flowmeter (blood flow measurement)",
        description="""Flowmeter (blood flow measurement)//Flowmeter (Blutflussmessung)""",
    )

    dfg_3010_6 = VocabularyTerm(
        code="DFG_3010_6",
        label="3010 Rheography, electrorheography and direct rheography instruments",
        description="""Rheography, electrorheography and direct rheography instruments//Rheographie-Geräte, Elektrorheographie-, Direktrheographiegeräte""",
    )

    dfg_3020_1 = VocabularyTerm(
        code="DFG_3020_1",
        label="3020 Hmoreflectometer (oximeter and HZV measurement)",
        description="""Hmoreflectometer (oximeter and HZV measurement)//Hämoreflektometer (Oximeter und HZV-Messung)""",
    )

    dfg_3020_2 = VocabularyTerm(
        code="DFG_3020_2",
        label="3020 Heart rate monitors",
        description="""Heart rate monitors//Herzfrequenz-Messgeräte""",
    )

    dfg_3020_3 = VocabularyTerm(
        code="DFG_3020_3",
        label="3020 Cardiac output (HZV) meters, calculators",
        description="""Cardiac output (HZV) meters, calculators//Herzzeitvolumen- (HZV) Messgeräte, -Rechner""",
    )

    dfg_3020_4 = VocabularyTerm(
        code="DFG_3020_4",
        label="3020 Histographs for cardiac rhythm analysis",
        description="""Histographs for cardiac rhythm analysis//Histographen für Herzrhythmik-Analyse""",
    )

    dfg_3020_5 = VocabularyTerm(
        code="DFG_3020_5",
        label="3020 Cardiotocographs",
        description="""Cardiotocographs//Kardiotokographen""",
    )

    dfg_3020_6 = VocabularyTerm(
        code="DFG_3020_6",
        label="3020 Pulse rate and cardiac output meters",
        description="""Pulse rate and cardiac output meters//Pulsfrequenz- und Herzleistungs-Messgeräte""",
    )

    dfg_3020_7 = VocabularyTerm(
        code="DFG_3020_7",
        label="3020 Thermodilution devices (HZV)",
        description="""Thermodilution devices (HZV)//Thermodilutionsgeräte (HZV)""",
    )

    dfg_3030_1 = VocabularyTerm(
        code="DFG_3030_1",
        label="3030 Defibrillators",
        description="""Defibrillators//Defibrillatoren""",
    )

    dfg_3030_2 = VocabularyTerm(
        code="DFG_3030_2",
        label="3030 Demand pacemakers (cardiac pacemakers)",
        description="""Demand pacemakers (cardiac pacemakers)//Demand-Pacemaker (Herzschrittmacher)""",
    )

    dfg_3030_3 = VocabularyTerm(
        code="DFG_3030_3",
        label="3030 Cardiac pacemakers, stimulators",
        description="""Cardiac pacemakers, stimulators//Herzschrittmacher, -stimulatoren""",
    )

    dfg_3030_4 = VocabularyTerm(
        code="DFG_3030_4",
        label="3030 Cardiac control and monitoring devices",
        description="""Cardiac control and monitoring devices//Herzsteuer- und -überwachungsgeräte""",
    )

    dfg_3030_5 = VocabularyTerm(
        code="DFG_3030_5",
        label="3030 Cardiac therapy devices, electrical",
        description="""Cardiac therapy devices, electrical//Herztherapiegeräte, elektrische""",
    )

    dfg_3030_6 = VocabularyTerm(
        code="DFG_3030_6",
        label="3030 Pacemakers (cardiac)",
        description="""Pacemakers (cardiac)//Pacemaker (Herzschrittmacher)""",
    )

    dfg_3030_7 = VocabularyTerm(
        code="DFG_3030_7",
        label="3030 Pacemakers (cardiac)",
        description="""Pacemakers (cardiac)//Schrittmacher (Herz-)""",
    )

    dfg_3040_1 = VocabularyTerm(
        code="DFG_3040_1",
        label="3040 Exercise testing, measuring apparatus (ergometers)",
        description="""Exercise testing, measuring apparatus (ergometers)//Belastungsprüfung, Messplätze (Ergometer)""",
    )

    dfg_3040_2 = VocabularyTerm(
        code="DFG_3040_2",
        label="3040 Ergometers",
        description="""Ergometers//Ergometer""",
    )

    dfg_3040_3 = VocabularyTerm(
        code="DFG_3040_3",
        label="3040 Bicycle ergometer",
        description="""Bicycle ergometer//Fahrrad-Ergometer""",
    )

    dfg_3040_4 = VocabularyTerm(
        code="DFG_3040_4",
        label="3040 Treadmill ergometer",
        description="""Treadmill ergometer//Laufband-Ergometer""",
    )

    dfg_3040_5 = VocabularyTerm(
        code="DFG_3040_5",
        label="3040 Power measuring equipment (physiological)",
        description="""Power measuring equipment (physiological)//Leistungsmesseinrichtungen (physiologische)""",
    )

    dfg_3040_6 = VocabularyTerm(
        code="DFG_3040_6",
        label="3040 Physiological measuring equipment for circulation and performance",
        description="""Physiological measuring equipment for circulation and performance//Physiologie-Messeinrichtungen für Kreislauf und Leistung""",
    )

    dfg_3050_1 = VocabularyTerm(
        code="DFG_3050_1",
        label="3050 Respiratory rate measuring devices",
        description="""Respiratory rate measuring devices//Atemfrequenz-Messgeräte""",
    )

    dfg_3050_2 = VocabularyTerm(
        code="DFG_3050_2",
        label="3050 Baby plethysmographs",
        description="""Baby plethysmographs//Baby-Plethysmographen""",
    )

    dfg_3050_3 = VocabularyTerm(
        code="DFG_3050_3",
        label="3050 Whole-body plethysmographs",
        description="""Whole-body plethysmographs//Ganzkörper-Plethysmographen""",
    )

    dfg_3050_4 = VocabularyTerm(
        code="DFG_3050_4",
        label="3050 Pulmonary function monitors",
        description="""Pulmonary function monitors//Lungenfunktionsmessgeräte""",
    )

    dfg_3050_5 = VocabularyTerm(
        code="DFG_3050_5",
        label="3050 Pneumotachographs",
        description="""Pneumotachographs//Pneumotachographen""",
    )

    dfg_3050_6 = VocabularyTerm(
        code="DFG_3050_6",
        label="3050 Spirometers, spirometry instruments",
        description="""Spirometers, spirometry instruments//Spirometer, Spirometrie-Messplätze""",
    )

    dfg_3060_1 = VocabularyTerm(
        code="DFG_3060_1",
        label="3060 Astrup devices",
        description="""Astrup devices//Astrupgeräte""",
    )

    dfg_3060_2 = VocabularyTerm(
        code="DFG_3060_2",
        label="3060 Breathing gas and blood gas analysers",
        description="""Breathing gas and blood gas analysers//Atemgas- und Blutgas-Analysatoren""",
    )

    dfg_3060_3 = VocabularyTerm(
        code="DFG_3060_3",
        label="3060 Diaferometers (determination of basal metabolic rate)",
        description="""Diaferometers (determination of basal metabolic rate)//Diaferometer (Grundumsatzbestimmung)""",
    )

    dfg_3060_4 = VocabularyTerm(
        code="DFG_3060_4",
        label="3060 Physiological gas analysers",
        description="""Physiological gas analysers//Gasanalysatoren für Physiologie""",
    )

    dfg_3060_5 = VocabularyTerm(
        code="DFG_3060_5",
        label="3060 Basal metabolic rate analysers",
        description="""Basal metabolic rate analysers//Grundumsatzgeräte""",
    )

    dfg_3060_6 = VocabularyTerm(
        code="DFG_3060_6",
        label="3060 O2 analysers (medicine)",
        description="""O2 analysers (medicine)//O2-Analysatoren (Medizin)""",
    )

    dfg_3060_7 = VocabularyTerm(
        code="DFG_3060_7",
        label="3060 Oximeters (medicine)",
        description="""Oximeters (medicine)//Oximeter (Medizin)""",
    )

    dfg_3060_8 = VocabularyTerm(
        code="DFG_3060_8",
        label="3060 Physiological gas analysers",
        description="""Physiological gas analysers//Physiologische Gasanalysatoren""",
    )

    dfg_3060_9 = VocabularyTerm(
        code="DFG_3060_9",
        label="3060 Respiratory mass spectrometers",
        description="""Respiratory mass spectrometers//Respirations-Massenspektrometer""",
    )

    dfg_3060_10 = VocabularyTerm(
        code="DFG_3060_10",
        label="3060 Respirometers (except gas exchange measuring devices 4410)",
        description="""Respirometers (except gas exchange measuring devices 4410)//Respirometer (außer Gaswechsel-Messeinrichtungen 4410)""",
    )

    dfg_3080_1 = VocabularyTerm(
        code="DFG_3080_1",
        label="3080 Intensive care and patient monitoring systems",
        description="""Intensive care and patient monitoring systems//Intensivpflege- und Patientenüberwachungssysteme""",
    )

    dfg_3080_2 = VocabularyTerm(
        code="DFG_3080_2",
        label="3080 Patient monitoring systems",
        description="""Patient monitoring systems//Patienten-Monitoring-Systeme""",
    )

    dfg_3090_1 = VocabularyTerm(
        code="DFG_3090_1",
        label="3090 Patient simulators",
        description="""Patient simulators//Patienten-Simulatoren""",
    )

    dfg_3090_2 = VocabularyTerm(
        code="DFG_3090_2",
        label="3090 Other circulatory measuring and monitoring equipment",
        description="""Other circulatory measuring and monitoring equipment//Sonstige Kreislauf-Mess- und -Überwachungsgeräte""",
    )

    dfg_3090_3 = VocabularyTerm(
        code="DFG_3090_3",
        label="3090 Metabolic measurement equipment (except 3040-3060, 3560 and 3910)",
        description="""Metabolic measurement equipment (except 3040-3060, 3560 and 3910)//Stoffwechsel-Messeinrichtungen (außer 3040-3060, 3560 und 3910)""",
    )

    dfg_3100_1 = VocabularyTerm(
        code="DFG_3100_1",
        label="3100 Chemiluminescence immunoassay devices",
        description="""Chemiluminescence immunoassay devices//Chemolumineszenz-Immunoassay-Geräte""",
    )

    dfg_3100_2 = VocabularyTerm(
        code="DFG_3100_2",
        label="3100 ELISA photometer-readers",
        description="""ELISA photometer-readers//ELISA-Photometer-Messplätze (-Reader)""",
    )

    dfg_3100_3 = VocabularyTerm(
        code="DFG_3100_3",
        label="3100 Enzyme immunoassay kits (except photometer 5200)",
        description="""Enzyme immunoassay kits (except photometer 5200)//Enzym-Immunoassay-Messgeräte (außer Photometer 5200)""",
    )

    dfg_3100_4 = VocabularyTerm(
        code="DFG_3100_4",
        label="3100 Enzyme analysers, calculators (except photometer 5200)",
        description="""Enzyme analysers, calculators (except photometer 5200)//Enzym-Messplätze, -Rechner (außer Photometer 5200)""",
    )

    dfg_3100_5 = VocabularyTerm(
        code="DFG_3100_5",
        label="3100 Immunochemical determination (except immunoelectrophoresis 1410)",
        description="""Immunochemical determination (except immunoelectrophoresis 1410)//Immunochemische Bestimmung (außer Immunelektrophorese 1410)""",
    )

    dfg_3100_6 = VocabularyTerm(
        code="DFG_3100_6",
        label="3100 Microplate reader",
        description="""Microplate reader//Microplate-Reader""",
    )

    dfg_3100_7 = VocabularyTerm(
        code="DFG_3100_7",
        label="3100 Microplate reader",
        description="""Microplate reader//Mikrotiter-Platten-Auswertegeräte""",
    )

    dfg_3100_8 = VocabularyTerm(
        code="DFG_3100_8",
        label="3100 Radio-immunoassay instruments (except gamma-counter 3360)",
        description="""Radio-immunoassay instruments (except gamma-counter 3360)//Radio-Immunoassay-Messplätze (außer Gammazähler 3360)""",
    )

    dfg_3100_9 = VocabularyTerm(
        code="DFG_3100_9",
        label="3100 Washing systems for ELISA analysers",
        description="""Washing systems for ELISA analysers//Waschsysteme für ELISA-Messplätze""",
    )

    dfg_3110_1 = VocabularyTerm(
        code="DFG_3110_1",
        label="3110 Electrolyte analysers (clinical chemistry)",
        description="""Electrolyte analysers (clinical chemistry)//Elektrolytautomaten, -analysatoren (Klinische Chemie)""",
    )

    dfg_3110_2 = VocabularyTerm(
        code="DFG_3110_2",
        label="3110 Glucose analysers (chromatographic sugar analysers see 1350)",
        description="""Glucose analysers (chromatographic sugar analysers see 1350)//Glucoseanalysatoren (chromatographische Zuckeranalysatoren s. 1350)""",
    )

    dfg_3110_3 = VocabularyTerm(
        code="DFG_3110_3",
        label="3110 Urea N analysers",
        description="""Urea N analysers//Harnstoff-N-Analysatoren""",
    )

    dfg_3110_4 = VocabularyTerm(
        code="DFG_3110_4",
        label="3110 Lactate analysers",
        description="""Lactate analysers//Lactat-Analysatoren""",
    )

    dfg_3110_5 = VocabularyTerm(
        code="DFG_3110_5",
        label="3110 Serum analysers for electrolyte and substrate concentration (except 1510, 1520 and 5200-5220)",
        description="""Serum analysers for electrolyte and substrate concentration (except 1510, 1520 and 5200-5220)//Serumanalysengeräte für Elektrolyt- und Substrat-Konzentration (außer 1510, 1520 und 5200-5220)""",
    )

    dfg_3110_6 = VocabularyTerm(
        code="DFG_3110_6",
        label="3110 Substrate analysers (except Photometer 5200)",
        description="""Substrate analysers (except Photometer 5200)//Substrat-Analysengeräte (außer Photometer 5200)""",
    )

    dfg_3120_1 = VocabularyTerm(
        code="DFG_3120_1",
        label="3120 Multichannel analysers for clinical chemistry",
        description="""Multichannel analysers for clinical chemistry//Mehrkanal-Analysenautomaten für Klinische Chemie""",
    )

    dfg_3120_2 = VocabularyTerm(
        code="DFG_3120_2",
        label="3120 Centrifugal analysers (clinical chemistry)",
        description="""Centrifugal analysers (clinical chemistry)//Zentrifugalanalysatoren (Klinische Chemie)""",
    )

    dfg_3130_1 = VocabularyTerm(
        code="DFG_3130_1",
        label="3130 Agglutinoscopes",
        description="""Agglutinoscopes//Agglutinoskope""",
    )

    dfg_3130_2 = VocabularyTerm(
        code="DFG_3130_2",
        label="3130 Aggregation meters, aggregometers",
        description="""Aggregation meters, aggregometers//Aggregationsmessgeräte, Aggregometer""",
    )

    dfg_3130_3 = VocabularyTerm(
        code="DFG_3130_3",
        label="3130 Blood analysis and differentiation instruments",
        description="""Blood analysis and differentiation instruments//Blutanalyse- und -differenziergeräte""",
    )

    dfg_3130_4 = VocabularyTerm(
        code="DFG_3130_4",
        label="3130 Blood count differentiators, differential counters",
        description="""Blood count differentiators, differential counters//Blutbild-Differenziergeräte, -Differentialzähler""",
    )

    dfg_3130_5 = VocabularyTerm(
        code="DFG_3130_5",
        label="3130 Blood coagulation (time) measuring devices",
        description="""Blood coagulation (time) measuring devices//Blutgerinnungs-(zeit-) Messgeräte""",
    )

    dfg_3130_6 = VocabularyTerm(
        code="DFG_3130_6",
        label="3130 Blood grouping instruments",
        description="""Blood grouping instruments//Blutgruppen-Bestimmungsgeräte""",
    )

    dfg_3130_7 = VocabularyTerm(
        code="DFG_3130_7",
        label="3130 Blood sedimentation measuring instruments",
        description="""Blood sedimentation measuring instruments//Blutsenkungsmessgeräte""",
    )

    dfg_3130_8 = VocabularyTerm(
        code="DFG_3130_8",
        label="3130 Blood analysers (except centrifuges 1200 and 3100-3120)",
        description="""Blood analysers (except centrifuges 1200 and 3100-3120)//Blutuntersuchungsgeräte (außer Zentrifugen 1200 und 3100-3120)""",
    )

    dfg_3130_9 = VocabularyTerm(
        code="DFG_3130_9",
        label="3130 Blood cell meters, blood cell counters",
        description="""Blood cell meters, blood cell counters//Blutzellenmessgeräte, Blutkörperchen-Zähler""",
    )

    dfg_3130_10 = VocabularyTerm(
        code="DFG_3130_10",
        label="3130 Coagulometers (blood), coagulometers",
        description="""Coagulometers (blood), coagulometers//Gerinnungsmessgeräte (Blut-), Koagulometer""",
    )

    dfg_3130_11 = VocabularyTerm(
        code="DFG_3130_11",
        label="3130 Platelet counters",
        description="""Platelet counters//Thrombozyten-Zähler""",
    )

    dfg_3140_1 = VocabularyTerm(
        code="DFG_3140_1",
        label="3140 Blood preservation and preparation devices",
        description="""Blood preservation and preparation devices//Blutkonservierungs- und -aufbereitungsgeräte""",
    )

    dfg_3140_2 = VocabularyTerm(
        code="DFG_3140_2",
        label="3140 Cytoglomerators (according to Huggins), blood washing devices",
        description="""Cytoglomerators (according to Huggins), blood washing devices//Cytoglomeratoren (nach Huggins), Blutwaschgeräte""",
    )

    dfg_3140_3 = VocabularyTerm(
        code="DFG_3140_3",
        label="3140 Special blood bank equipment (except 3130 and freezers 8540)",
        description="""Special blood bank equipment (except 3130 and freezers 8540)//Spezielle Geräte für Blutbank (außer 3130 und Tiefgefrieranlagen 8540)""",
    )

    dfg_3150_1 = VocabularyTerm(
        code="DFG_3150_1",
        label="3150 DNA sequencers",
        description="""DNA sequencers//DNA-Sequenzer""",
    )

    dfg_3150_2 = VocabularyTerm(
        code="DFG_3150_2",
        label="3150 Sequence analysers (DNA- Nucleotide-)",
        description="""Sequence analysers (DNA- Nucleotide-)//Sequenzanalysatoren (DNA- Nucleotid-)""",
    )

    dfg_3150_3 = VocabularyTerm(
        code="DFG_3150_3",
        label="3150 Next Generation Sequencers",
        description="""Next Generation Sequencers//Next Generation Sequenzer""",
    )

    dfg_3160_1 = VocabularyTerm(
        code="DFG_3160_1",
        label="3160 Biomolecular interaction systems",
        description="""Biomolecular interaction systems//Biomolekular-Interaktionssysteme""",
    )

    dfg_3160_2 = VocabularyTerm(
        code="DFG_3160_2",
        label="3160 Biosensor systems",
        description="""Biosensor systems//Biosensor-Systeme""",
    )

    dfg_3160_3 = VocabularyTerm(
        code="DFG_3160_3",
        label="3160 Surface Plasmon Resonance Systems (OPR, SPR)",
        description="""Surface Plasmon Resonance Systems (OPR, SPR)//Oberflächen-Plasmon-Resonanz-Systeme (OPR, SPR)""",
    )

    dfg_3161_1 = VocabularyTerm(
        code="DFG_3161_1",
        label="3161 Fluorescence correlation spectrometers (FCS)",
        description="""Fluorescence correlation spectrometers (FCS)//Fluoreszenz-Korrelations-Spektrometer (FCS)""",
    )

    dfg_3170_1 = VocabularyTerm(
        code="DFG_3170_1",
        label="3170 DNA array systems",
        description="""DNA array systems//DNA-Array-Systeme""",
    )

    dfg_3170_2 = VocabularyTerm(
        code="DFG_3170_2",
        label="3170 DNA chip systems",
        description="""DNA chip systems//DNA-Chip-Systeme""",
    )

    dfg_3180_1 = VocabularyTerm(
        code="DFG_3180_1",
        label="3180 Peptide, protein sequencers",
        description="""Peptide, protein sequencers//Peptid-, Protein-Sequenzer""",
    )

    dfg_3180_2 = VocabularyTerm(
        code="DFG_3180_2",
        label="3180 Sequence analysers (peptide, protein)",
        description="""Sequence analysers (peptide, protein)//Sequenzanalysatoren (Peptid-, Protein-)""",
    )

    dfg_3190_1 = VocabularyTerm(
        code="DFG_3190_1",
        label="3190 Hmatological analysers (except 3000-3060 and 3100-3180)",
        description="""Hmatological analysers (except 3000-3060 and 3100-3180)//Hämatologische Messgeräte (außer 3000-3060 und 3100-3180)""",
    )

    dfg_3190_2 = VocabularyTerm(
        code="DFG_3190_2",
        label="3190 Sample distribution and identification (clinical chemistry)",
        description="""Sample distribution and identification (clinical chemistry)//Probenverteilung und Identifikation (Klinische Chemie)""",
    )

    dfg_3190_3 = VocabularyTerm(
        code="DFG_3190_3",
        label="3190 Other instruments in clinical chemistry and molecular biology",
        description="""Other instruments in clinical chemistry and molecular biology//Sonstige Geräte der Klinischen Chemie und Molekularbiologie""",
    )

    dfg_3190_4 = VocabularyTerm(
        code="DFG_3190_4",
        label="3190 Biobank",
        description="""Biobank//Biobank""",
    )

    dfg_3190_5 = VocabularyTerm(
        code="DFG_3190_5",
        label="3190 Biospecimen cooling system",
        description="""Biospecimen cooling system//Bioproben-Kühlsystem""",
    )

    dfg_3200_1 = VocabularyTerm(
        code="DFG_3200_1",
        label="3200 Digital X-ray equipment (except angiography)",
        description="""Digital X-ray equipment (except angiography)//Digitale Röntgenanlagen (außer Angiographie)""",
    )

    dfg_3200_2 = VocabularyTerm(
        code="DFG_3200_2",
        label="3200 Pulmonary diagnostic X-ray equipment",
        description="""Pulmonary diagnostic X-ray equipment//Lungendiagnostik-Röntgengeräte""",
    )

    dfg_3200_3 = VocabularyTerm(
        code="DFG_3200_3",
        label="3200 X-ray diagnostic equipment (except angiography and tomography)",
        description="""X-ray diagnostic equipment (except angiography and tomography)//Röntgendagnostikgeräte (außer Angiographie und Tomographie)""",
    )

    dfg_3200_4 = VocabularyTerm(
        code="DFG_3200_4",
        label="3200 X-ray fluoroscopy workstations (medicine)",
        description="""X-ray fluoroscopy workstations (medicine)//Röntgendurchleuchtungs-Arbeitsplätze (Medizin)""",
    )

    dfg_3200_5 = VocabularyTerm(
        code="DFG_3200_5",
        label="3200 X-ray generators (medicine)",
        description="""X-ray generators (medicine)//Röntgengeneratoren (Medizin)""",
    )

    dfg_3200_6 = VocabularyTerm(
        code="DFG_3200_6",
        label="3200 Accident recording workstations (X-ray)",
        description="""Accident recording workstations (X-ray)//Unfallaufnahme-Arbeitsplätze (Röntgen)""",
    )

    dfg_3200_7 = VocabularyTerm(
        code="DFG_3200_7",
        label="3200 Urology radiography workstations",
        description="""Urology radiography workstations//Urologie-Röntgen-Arbeitsplätze""",
    )

    dfg_3200_8 = VocabularyTerm(
        code="DFG_3200_8",
        label="3200 Xeroradiography scopes (except angiography)",
        description="""Xeroradiography scopes (except angiography)//Xeroradiographie-Geräte (außer Angiographie)""",
    )

    dfg_3210_1 = VocabularyTerm(
        code="DFG_3210_1",
        label="3210 Angiography-radiography equipment",
        description="""Angiography-radiography equipment//Angiographie-Röntgenanlagen""",
    )

    dfg_3210_2 = VocabularyTerm(
        code="DFG_3210_2",
        label="3210 Digital-subtraction-x-ray systems (DSA systems)",
        description="""Digital-subtraction-x-ray systems (DSA systems)//Digital-Subtraktions-Röntgensysteme (DSA-Anlagen)""",
    )

    dfg_3210_3 = VocabularyTerm(
        code="DFG_3210_3",
        label="3210 Cardangiography equipment",
        description="""Cardangiography equipment//Kardangiographie-Einrichtungen""",
    )

    dfg_3210_4 = VocabularyTerm(
        code="DFG_3210_4",
        label="3210 Coronarography-radiography equipment",
        description="""Coronarography-radiography equipment//Koronarographie-Röntgeneinrichtungen""",
    )

    dfg_3210_5 = VocabularyTerm(
        code="DFG_3210_5",
        label="3210 X-ray workstations for angiography, venography, lymphography",
        description="""X-ray workstations for angiography, venography, lymphography//Röntgenarbeitsplätze für Angiographie, Venographie, Lymphographie""",
    )

    dfg_3210_6 = VocabularyTerm(
        code="DFG_3210_6",
        label="3210 X-ray cinematographic apparatus (except 4070)",
        description="""X-ray cinematographic apparatus (except 4070)//Röntgenkinematographische Apparate (außer 4070)""",
    )

    dfg_3210_7 = VocabularyTerm(
        code="DFG_3210_7",
        label="3210 Two-plane X-ray equipment",
        description="""Two-plane X-ray equipment//Zweiebenen-Röntgen-Einrichtungen""",
    )

    dfg_3220_1 = VocabularyTerm(
        code="DFG_3220_1",
        label="3220 Automatic exposure apparatus for radiographs (medical)",
        description="""Automatic exposure apparatus for radiographs (medical)//Belichtungsautomaten für Röntgenaufnahmen (Medizin)""",
    )

    dfg_3220_2 = VocabularyTerm(
        code="DFG_3220_2",
        label="3220 Sheet film changers",
        description="""Sheet film changers//Blattfilmwechsler""",
    )

    dfg_3220_3 = VocabularyTerm(
        code="DFG_3220_3",
        label="3220 Auxiliary equipment and medical X-ray accessories",
        description="""Auxiliary equipment and medical X-ray accessories//Hilfseinrichtungen und medizinisches Röntgenzubehör""",
    )

    dfg_3220_4 = VocabularyTerm(
        code="DFG_3220_4",
        label="3220 High-pressure syringes for X-ray contrast media",
        description="""High-pressure syringes for X-ray contrast media//Hochdruck-Spritzen für Röntgen-Kontrastmittel""",
    )

    dfg_3220_5 = VocabularyTerm(
        code="DFG_3220_5",
        label="3220 Positioning, grid, bucky tables for radiographs",
        description="""Positioning, grid, bucky tables for radiographs//Lagerungs-, Rasteraufnahme-, Bucky-Tische für Röntgenaufnahmen""",
    )

    dfg_3220_6 = VocabularyTerm(
        code="DFG_3220_6",
        label="3220 Stands for X-ray equipment",
        description="""Stands for X-ray equipment//Stative für Röntgengeräte""",
    )

    dfg_3220_7 = VocabularyTerm(
        code="DFG_3220_7",
        label="3220 Daylight developing machines",
        description="""Daylight developing machines//Tageslicht-Entwicklungsmaschinen""",
    )

    dfg_3220_8 = VocabularyTerm(
        code="DFG_3220_8",
        label="3220 Targets for radiographs",
        description="""Targets for radiographs//Zielgeräte für Röntgenaufnahmen""",
    )

    dfg_3230_1 = VocabularyTerm(
        code="DFG_3230_1",
        label="3230 CAT (Computerised Axial Tomography) scanners (medicine), materials science: 4070",
        description="""CAT (Computerised Axial Tomography) scanners (medicine), materials science: 4070//CAT-Scanner (Computerized Axial Tomography) (Medizin),  Materialwissenschaft: 4070""",
    )

    dfg_3230_2 = VocabularyTerm(
        code="DFG_3230_2",
        label="3230 Computerised tomography scanners (medicine), materials science: 4070",
        description="""Computerised tomography scanners (medicine), materials science: 4070//Computertomographen (Medizin),  Materialwissenschaft: 4070""",
    )

    dfg_3230_3 = VocabularyTerm(
        code="DFG_3230_3",
        label="3230 Computed tomography (X-ray) equipment (medicine), Materials science: 4070",
        description="""Computed tomography (X-ray) equipment (medicine), Materials science: 4070//Computertomographiegeräte (Röntgen-) (Medizin),  Materialwissenschaft: 4070""",
    )

    dfg_3230_4 = VocabularyTerm(
        code="DFG_3230_4",
        label="3230 CT (computed tomography) scaffolds (X-ray tomography) (medicine), Materials science: 4070",
        description="""CT (computed tomography) scaffolds (X-ray tomography) (medicine), Materials science: 4070//CT-(Computertomographie-) Geräte (Röntgen-Tomographie) (Medizin),  Materialwissenschaft: 4070""",
    )

    dfg_3230_5 = VocabularyTerm(
        code="DFG_3230_5",
        label="3230 Whole-body computed tomography (X-ray tomography) scanners, materials science: 4070",
        description="""Whole-body computed tomography (X-ray tomography) scanners, materials science: 4070//Ganzkörper-Computertomographen (Röntgen-Tomographie),  Materialwissenschaft: 4070""",
    )

    dfg_3230_6 = VocabularyTerm(
        code="DFG_3230_6",
        label="3230 Schdelscanner (X-ray tomography) (medicine), Materials science: 4070",
        description="""Schdelscanner (X-ray tomography) (medicine), Materials science: 4070//Schädelscanner (Röntgentomographie) (Medizin),  Materialwissenschaft: 4070""",
    )

    dfg_3231_1 = VocabularyTerm(
        code="DFG_3231_1",
        label="3231 Magnetic resonance tomographs, NMR spectrometers for imaging applications: 1742",
        description="""Magnetic resonance tomographs, NMR spectrometers for imaging applications: 1742//Kernspin-Tomographen, NMR-Spektrometer für Imaging-Anwendung: 1742""",
    )

    dfg_3231_2 = VocabularyTerm(
        code="DFG_3231_2",
        label="3231 MR tomographs (magnetic resonance), NMR spectrometers for imaging application: 1742",
        description="""MR tomographs (magnetic resonance), NMR spectrometers for imaging application: 1742//MR-Tomographen (Magnetresonanz-), NMR-Spektrometer für Imaging-Anwendung: 1742""",
    )

    dfg_3231_3 = VocabularyTerm(
        code="DFG_3231_3",
        label="3231 MR tomography system, NMR spectrometer for imaging application: 1742",
        description="""MR tomography system, NMR spectrometer for imaging application: 1742//MR-Tomographie-System, NMR-Spektrometer für Imaging-Anwendung: 1742""",
    )

    dfg_3232_1 = VocabularyTerm(
        code="DFG_3232_1",
        label="3232 Optical coherence tomography (OCT)",
        description="""Optical coherence tomography (OCT)//Optische Kohärenztomografie (OCT)""",
    )

    dfg_3233_1 = VocabularyTerm(
        code="DFG_3233_1",
        label="3233 Non-linear magnetic particle imaging, Magnetic Particle Imaging (MPI)",
        description="""Non-linear magnetic particle imaging, Magnetic Particle Imaging (MPI)//Nichtlineare Magnetpartikel Bildgebung, Magnetic Particle Imaging (MPI)""",
    )

    dfg_3240_1 = VocabularyTerm(
        code="DFG_3240_1",
        label="3240 Irradiation planning systems",
        description="""Irradiation planning systems//Bestrahlungsplanungs-Systeme""",
    )

    dfg_3240_2 = VocabularyTerm(
        code="DFG_3240_2",
        label="3240 Phantoms for radiology",
        description="""Phantoms for radiology//Phantome für Radiologie""",
    )

    dfg_3240_3 = VocabularyTerm(
        code="DFG_3240_3",
        label="3240 Therapy simulators, dose programmers",
        description="""Therapy simulators, dose programmers//Therapiesimulatoren, Dosisprogrammiergeräte""",
    )

    dfg_3250_1 = VocabularyTerm(
        code="DFG_3250_1",
        label="3250 Accelerators (medicine)",
        description="""Accelerators (medicine)//Beschleuniger (Medizin)""",
    )

    dfg_3250_2 = VocabularyTerm(
        code="DFG_3250_2",
        label="3250 Betatrons (Medicine)",
        description="""Betatrons (Medicine)//Betatrons (Medizin)""",
    )

    dfg_3250_3 = VocabularyTerm(
        code="DFG_3250_3",
        label="3250 High-voltage therapy systems",
        description="""High-voltage therapy systems//Hochvolttherapie-Anlagen""",
    )

    dfg_3250_4 = VocabularyTerm(
        code="DFG_3250_4",
        label="3250 Compact cyclotrons (medicine)",
        description="""Compact cyclotrons (medicine)//Kompaktzyklotrons (Medizin)""",
    )

    dfg_3250_5 = VocabularyTerm(
        code="DFG_3250_5",
        label="3250 Linear accelerators (medicine)",
        description="""Linear accelerators (medicine)//Linearbeschleuniger (Medizin)""",
    )

    dfg_3250_6 = VocabularyTerm(
        code="DFG_3250_6",
        label="3250 Neutron generators (medicine)",
        description="""Neutron generators (medicine)//Neutronengeneratoren (Medizin)""",
    )

    dfg_3250_7 = VocabularyTerm(
        code="DFG_3250_7",
        label="3250 X-ray therapy equipment",
        description="""X-ray therapy equipment//Röntgentherapiegeräte""",
    )

    dfg_3260_1 = VocabularyTerm(
        code="DFG_3260_1",
        label="3260 After-loading equipment (sealed radioisotopes)",
        description="""After-loading equipment (sealed radioisotopes)//After-Loading-Einrichtungen (umschlossene Radioisotope)""",
    )

    dfg_3260_2 = VocabularyTerm(
        code="DFG_3260_2",
        label="3260 Blood irradiation apparatus",
        description="""Blood irradiation apparatus//Blutbestrahlungsapparate""",
    )

    dfg_3260_3 = VocabularyTerm(
        code="DFG_3260_3",
        label="3260 Gamma irradiation systems (medicine)",
        description="""Gamma irradiation systems (medicine)//Gamma-Bestrahlungssysteme (Medizin)""",
    )

    dfg_3260_4 = VocabularyTerm(
        code="DFG_3260_4",
        label="3260 Cobalt 60 radiators",
        description="""Cobalt 60 radiators//Kobalt 60 -Strahler""",
    )

    dfg_3260_5 = VocabularyTerm(
        code="DFG_3260_5",
        label="3260 Radiators and irradiation equipment for medicine/biology (except accelerators 3250)",
        description="""Radiators and irradiation equipment for medicine/biology (except accelerators 3250)//Strahler und Bestrahlungsgeräte für Medizin/Biologie (außer Beschleuniger 3250)""",
    )

    dfg_3260_6 = VocabularyTerm(
        code="DFG_3260_6",
        label="3260 Telecobalt irradiators",
        description="""Telecobalt irradiators//Telekobalt-Bestrahlungsgeräte""",
    )

    dfg_3270_1 = VocabularyTerm(
        code="DFG_3270_1",
        label="3270 Recording and archiving apparatus for medical radiology",
        description="""Recording and archiving apparatus for medical radiology//Aufnahme- und Archivierungsgeräte für medizinische Röntgentechnik""",
    )

    dfg_3270_2 = VocabularyTerm(
        code="DFG_3270_2",
        label="3270 Viewing apparatus for radiographs",
        description="""Viewing apparatus for radiographs//Betrachtungsgeräte für Röntgenaufnahmen""",
    )

    dfg_3270_3 = VocabularyTerm(
        code="DFG_3270_3",
        label="3270 Imaging equipment for radiology",
        description="""Imaging equipment for radiology//Bildaufnahmegeräte für Radiologie""",
    )

    dfg_3270_4 = VocabularyTerm(
        code="DFG_3270_4",
        label="3270 Digital radiography systems",
        description="""Digital radiography systems//Digitale Radiographie-Systeme""",
    )

    dfg_3270_5 = VocabularyTerm(
        code="DFG_3270_5",
        label="3270 Copying equipment (contrast equalising) for X-ray films",
        description="""Copying equipment (contrast equalising) for X-ray films//Kopiereinrichtungen (kontrastausgleichend) für Röntgenfilme""",
    )

    dfg_3270_6 = VocabularyTerm(
        code="DFG_3270_6",
        label="3270 Laser imagers for radiography (medicine)",
        description="""Laser imagers for radiography (medicine)//Laser-Imager für Röntgenaufnahmen (Medizin)""",
    )

    dfg_3270_7 = VocabularyTerm(
        code="DFG_3270_7",
        label="3270 X-ray card indexes",
        description="""X-ray card indexes//Röntgen-Karteien""",
    )

    dfg_3280_1 = VocabularyTerm(
        code="DFG_3280_1",
        label="3280 Shielding equipment (X-ray) (medical)",
        description="""Shielding equipment (X-ray) (medical)//Abschirmeinrichtungen (Röntgen-) (für Medizin)""",
    )

    dfg_3280_2 = VocabularyTerm(
        code="DFG_3280_2",
        label="3280 Radiation protection equipment for medical X-ray and accelerator equipment (except 0320)",
        description="""Radiation protection equipment for medical X-ray and accelerator equipment (except 0320)//Strahlenschutzeinrichtungen für Röntgen- und Beschleunigeranlagen der Medizin (außer 0320)""",
    )

    dfg_3290_1 = VocabularyTerm(
        code="DFG_3290_1",
        label="3290 Bone density measuring systems",
        description="""Bone density measuring systems//Knochendichte-Messsysteme""",
    )

    dfg_3290_2 = VocabularyTerm(
        code="DFG_3290_2",
        label="3290 Mineral bone analysers (bone and tissue density)",
        description="""Mineral bone analysers (bone and tissue density)//Mineral Bone Analyzer (Knochen- und Gewebedichte)""",
    )

    dfg_3290_3 = VocabularyTerm(
        code="DFG_3290_3",
        label="3290 Osteoporosis diagnostic systems",
        description="""Osteoporosis diagnostic systems//Osteoporose-Diagnostik-Systeme""",
    )

    dfg_3290_4 = VocabularyTerm(
        code="DFG_3290_4",
        label="3290 X-ray accessories, see also electronic image intensifiers 5170, cinema cameras 5420 and video recorders 6750",
        description="""X-ray accessories, see also electronic image intensifiers 5170, cinema cameras 5420 and video recorders 6750//Röntgen-Zubehör, siehe auch elektronische Bildverstärker 5170, Kinokameras 5420 und Videorecorder 6750""",
    )

    dfg_3290_5 = VocabularyTerm(
        code="DFG_3290_5",
        label="3290 Other radiology equipment and accessories",
        description="""Other radiology equipment and accessories//Sonstige Geräte der Radiologie und Zubehör""",
    )

    dfg_3300_1 = VocabularyTerm(
        code="DFG_3300_1",
        label="3300 Blood flow meters (radionuclide-)",
        description="""Blood flow meters (radionuclide-)//Blutfluss-Messplätze (Radionuklid-)""",
    )

    dfg_3300_2 = VocabularyTerm(
        code="DFG_3300_2",
        label="3300 Renal clearency monitors",
        description="""Renal clearency monitors//Nieren-Clearence-Messplätze""",
    )

    dfg_3300_3 = VocabularyTerm(
        code="DFG_3300_3",
        label="3300 Radionuclide measuring plans (medicine, biology)",
        description="""Radionuclide measuring plans (medicine, biology)//Radionuklid-Messplätze (Medizin, Biologie)""",
    )

    dfg_3300_4 = VocabularyTerm(
        code="DFG_3300_4",
        label="3300 RCBF blood flow measuring plans (radionuclide)",
        description="""RCBF blood flow measuring plans (radionuclide)//RCBF-Blutfluss-Messplätze (Radionuklid-)""",
    )

    dfg_3300_5 = VocabularyTerm(
        code="DFG_3300_5",
        label="3300 Uptake measuring plans (radionuclide)",
        description="""Uptake measuring plans (radionuclide)//Uptake-Messplätze (Radionuklid-)""",
    )

    dfg_3310_1 = VocabularyTerm(
        code="DFG_3310_1",
        label="3310 Scintigraphy scanners",
        description="""Scintigraphy scanners//Szintigraphie-Scanner""",
    )

    dfg_3310_2 = VocabularyTerm(
        code="DFG_3310_2",
        label="3310 Tomography scanners (radionuclide)",
        description="""Tomography scanners (radionuclide)//Tomographie-Scanner (Radionuklid-)""",
    )

    dfg_3320_1 = VocabularyTerm(
        code="DFG_3320_1",
        label="3320 Gamma cameras (nuclear medicine)",
        description="""Gamma cameras (nuclear medicine)//Gammakameras (Nuklearmedizin)""",
    )

    dfg_3320_2 = VocabularyTerm(
        code="DFG_3320_2",
        label="3320 Positron cameras",
        description="""Positron cameras//Positronenkameras""",
    )

    dfg_3320_3 = VocabularyTerm(
        code="DFG_3320_3",
        label="3320 SPECT (single photon emission computed tomography)",
        description="""SPECT (single photon emission computed tomography)//SPECT (single photon emission computed tomography)""",
    )

    dfg_3320_4 = VocabularyTerm(
        code="DFG_3320_4",
        label="3320 Scintillation cameras",
        description="""Scintillation cameras//Szintillationskameras""",
    )

    dfg_3321_1 = VocabularyTerm(
        code="DFG_3321_1",
        label="3321 Emission computer tomographs (gamma or positron)",
        description="""Emission computer tomographs (gamma or positron)//Emissions-Computertomographen (Gamma- oder Positronen-)""",
    )

    dfg_3321_2 = VocabularyTerm(
        code="DFG_3321_2",
        label="3321 Positron emission tomographs",
        description="""Positron emission tomographs//Positronen-Emissions-Tomographen""",
    )

    dfg_3321_3 = VocabularyTerm(
        code="DFG_3321_3",
        label="3321 PET CT (positron emission tomograph with computer tomograph)",
        description="""PET CT (positron emission tomograph with computer tomograph)//PET CT (Positronen-Emissionstomograph mit Computertomograph)""",
    )

    dfg_3322_1 = VocabularyTerm(
        code="DFG_3322_1",
        label="3322 PET-MRI hybrid scanners (positron emission tomograph and magnetic resonance tomograph)",
        description="""PET-MRI hybrid scanners (positron emission tomograph and magnetic resonance tomograph)//PET-MRT-Hybridgeräte (Positronen-Emissions-Tomograph und Magnetresonanz-Tomograph)""",
    )

    dfg_3330_1 = VocabularyTerm(
        code="DFG_3330_1",
        label="3330 Whole-body monitors and other special monitors for nuclear medicine",
        description="""Whole-body monitors and other special monitors for nuclear medicine//Ganzkörper-Monitore und andere spezielle Monitore für Nuklearmedizin""",
    )

    dfg_3330_2 = VocabularyTerm(
        code="DFG_3330_2",
        label="3330 Whole-body counters (nuclear medicine)",
        description="""Whole-body counters (nuclear medicine)//Ganzkörper-Zähler (Nuklearmedizin)""",
    )

    dfg_3350_1 = VocabularyTerm(
        code="DFG_3350_1",
        label="3350 Liquid scintillation counters (sample changers), beta-scintillation counters for liquid samples",
        description="""Liquid scintillation counters (sample changers), beta-scintillation counters for liquid samples//Flüssigkeits-Szintillationszähler (Probenwechsler), Beta-Messplätze für flüssige Proben""",
    )

    dfg_3350_2 = VocabularyTerm(
        code="DFG_3350_2",
        label="3350 Liquid scintillation counter",
        description="""Liquid scintillation counter//Liquid-Scintillation-Counter""",
    )

    dfg_3350_3 = VocabularyTerm(
        code="DFG_3350_3",
        label="3350 Low-level beta measurement counters, sample changers",
        description="""Low-level beta measurement counters, sample changers//Low-Level-Beta-Messplätze, -Probenwechsler""",
    )

    dfg_3350_4 = VocabularyTerm(
        code="DFG_3350_4",
        label="3350 Sample changer (beta)",
        description="""Sample changer (beta)//Probenwechsler (Beta-)""",
    )

    dfg_3360_1 = VocabularyTerm(
        code="DFG_3360_1",
        label="3360 Filter band analysers (gamma counters) for RIA",
        description="""Filter band analysers (gamma counters) for RIA//Filterband-Auswertegeräte (Gammazähler) für RIA""",
    )

    dfg_3360_2 = VocabularyTerm(
        code="DFG_3360_2",
        label="3360 Gamma sample changer for liquid samples and radio-immunoassay (RIA)",
        description="""Gamma sample changer for liquid samples and radio-immunoassay (RIA)//Gammaprobenwechsler für flüssige Proben und Radio-Immuno-Assay (RIA)""",
    )

    dfg_3360_3 = VocabularyTerm(
        code="DFG_3360_3",
        label="3360 Radio immunoassay (RIA) systems",
        description="""Radio immunoassay (RIA) systems//Radio-Immuno-Assay (RIA) -Systeme""",
    )

    dfg_3360_4 = VocabularyTerm(
        code="DFG_3360_4",
        label="3360 RIA measuring platforms",
        description="""RIA measuring platforms//RIA-Messplätze""",
    )

    dfg_3370_1 = VocabularyTerm(
        code="DFG_3370_1",
        label="3370 Cold ashing apparatus, cold combustion apparatus",
        description="""Cold ashing apparatus, cold combustion apparatus//Kaltveraschungsgeräte, Kaltverbrennungsgeräte""",
    )

    dfg_3370_2 = VocabularyTerm(
        code="DFG_3370_2",
        label="3370 Wet ashing equipment",
        description="""Wet ashing equipment//Nassveraschungsgeräte""",
    )

    dfg_3370_3 = VocabularyTerm(
        code="DFG_3370_3",
        label="3370 Sample preparation, ashing devices for beta, gamma measuring plots",
        description="""Sample preparation, ashing devices for beta, gamma measuring plots//Probenaufbereitungs-, Veraschungsgeräte für Beta-, Gamma-Messplätze""",
    )

    dfg_3370_4 = VocabularyTerm(
        code="DFG_3370_4",
        label="3370 Low-temperature ashing (combustion) devices",
        description="""Low-temperature ashing (combustion) devices//Tieftemperatur-Veraschungs- (Verbrennungs-) Geräte""",
    )

    dfg_3370_5 = VocabularyTerm(
        code="DFG_3370_5",
        label="3370 Automatic incinerators for beta and gamma measuring plots",
        description="""Automatic incinerators for beta and gamma measuring plots//Verbrennungsautomaten für Beta- und Gammamessplätze""",
    )

    dfg_3390_1 = VocabularyTerm(
        code="DFG_3390_1",
        label="3390 Other nuclear medicine apparatus and accessories (except 3300-3380)",
        description="""Other nuclear medicine apparatus and accessories (except 3300-3380)//Sonstige Geräte der Nuklearmedizin und Zubehör (außer 3300-3380)""",
    )

    dfg_3400_1 = VocabularyTerm(
        code="DFG_3400_1",
        label="3400 Electrostimulation anaesthesia (ESA) equipment",
        description="""Electrostimulation anaesthesia (ESA) equipment//Elektrostimulations-Anästhesie (ESA) -Geräte""",
    )

    dfg_3400_2 = VocabularyTerm(
        code="DFG_3400_2",
        label="3400 Electrotherapy equipment",
        description="""Electrotherapy equipment//Elektrotherapiegeräte""",
    )

    dfg_3400_3 = VocabularyTerm(
        code="DFG_3400_3",
        label="3400 Nerve stimulation devices",
        description="""Nerve stimulation devices//Nervenreizgeräte""",
    )

    dfg_3400_4 = VocabularyTerm(
        code="DFG_3400_4",
        label="3400 Stimulation devices, stimulation generators, stimulation current devices",
        description="""Stimulation devices, stimulation generators, stimulation current devices//Reizgeräte, Reizgeneratoren, Reizstromgeräte""",
    )

    dfg_3400_5 = VocabularyTerm(
        code="DFG_3400_5",
        label="3400 Stimulus isolation units (Stimulus Isolation Units)",
        description="""Stimulus isolation units (Stimulus Isolation Units)//Reizisoliereinheiten (Stimulus-Isolation-Unit)""",
    )

    dfg_3400_6 = VocabularyTerm(
        code="DFG_3400_6",
        label="3400 Stimulators (stimulus devices)",
        description="""Stimulators (stimulus devices)//Stimulatoren (Reizgeräte)""",
    )

    dfg_3410_1 = VocabularyTerm(
        code="DFG_3410_1",
        label="3410 Biosignal systems",
        description="""Biosignal systems//Biosignal-Systeme""",
    )

    dfg_3410_2 = VocabularyTerm(
        code="DFG_3410_2",
        label="3410 Electromyographs, nystagmographs",
        description="""Electromyographs, nystagmographs//Elektromyographen, Nystagmographen""",
    )

    dfg_3410_3 = VocabularyTerm(
        code="DFG_3410_3",
        label="3410 EMG analysers, systems (electromyography)",
        description="""EMG analysers, systems (electromyography)//EMG-Analysatoren, -Systeme (Elektromyographie)""",
    )

    dfg_3410_4 = VocabularyTerm(
        code="DFG_3410_4",
        label="3410 Myographs",
        description="""Myographs//Myographen""",
    )

    dfg_3420_1 = VocabularyTerm(
        code="DFG_3420_1",
        label="3420 Analysis and evaluation equipment for electrocardiographs",
        description="""Analysis and evaluation equipment for electrocardiographs//Analyse- und Auswertegeräte für Elektrokardiographen""",
    )

    dfg_3420_2 = VocabularyTerm(
        code="DFG_3420_2",
        label="3420 ECG recording, playback, data storage (except intensive care 3080)",
        description="""ECG recording, playback, data storage (except intensive care 3080)//EKG-Aufnahme, -Wiedergabe, Datenspeicher (außer Intensivpflege 3080)""",
    )

    dfg_3420_3 = VocabularyTerm(
        code="DFG_3420_3",
        label="3420 ECG shape analysis, rhythm analysis equipment",
        description="""ECG shape analysis, rhythm analysis equipment//EKG-Formanalysen-, Rhythmus-Analysengeräte""",
    )

    dfg_3420_4 = VocabularyTerm(
        code="DFG_3420_4",
        label="3420 Electrocardiographs",
        description="""Electrocardiographs//Elektrokardiographen""",
    )

    dfg_3420_5 = VocabularyTerm(
        code="DFG_3420_5",
        label="3420 Impedance cardiographs",
        description="""Impedance cardiographs//Impedanzkardiographen""",
    )

    dfg_3420_6 = VocabularyTerm(
        code="DFG_3420_6",
        label="3420 Long-term ECG recording and storage devices",
        description="""Long-term ECG recording and storage devices//Langzeit-EKG-Registrier-, Speichergeräte""",
    )

    dfg_3420_7 = VocabularyTerm(
        code="DFG_3420_7",
        label="3420 Vector cardiographs",
        description="""Vector cardiographs//Vektor-Kardiographen""",
    )

    dfg_3430_1 = VocabularyTerm(
        code="DFG_3430_1",
        label="3430 EEG-gauges, EEG-analysis systems (with computer)",
        description="""EEG-gauges, EEG-analysis systems (with computer)//EEG-Geräte, EEG-Analysensysteme (mit Rechner)""",
    )

    dfg_3430_2 = VocabularyTerm(
        code="DFG_3430_2",
        label="3430 Electroencephalographs",
        description="""Electroencephalographs//Elektroenzephalographen""",
    )

    dfg_3440_1 = VocabularyTerm(
        code="DFG_3440_1",
        label="3440 Electrophysiological measuring systems (except 3000-3090 and 3400-3430)",
        description="""Electrophysiological measuring systems (except 3000-3090 and 3400-3430)//Elektrophysiologische Messsysteme (außer 3000-3090 und 3400-3430)""",
    )

    dfg_3440_2 = VocabularyTerm(
        code="DFG_3440_2",
        label="3440 Electroretinography, -myography systems",
        description="""Electroretinography, -myography systems//Elektroretinographie-, -myographiesysteme""",
    )

    dfg_3440_3 = VocabularyTerm(
        code="DFG_3440_3",
        label="3440 Electroretinography equipment",
        description="""Electroretinography equipment//Elektroretinographie-Einrichtungen""",
    )

    dfg_3440_4 = VocabularyTerm(
        code="DFG_3440_4",
        label="3440 Cerebral pressure measuring devices",
        description="""Cerebral pressure measuring devices//Hirndruckmessplätze""",
    )

    dfg_3440_5 = VocabularyTerm(
        code="DFG_3440_5",
        label="3440 Neurological examination equipment (except 3400-3430)",
        description="""Neurological examination equipment (except 3400-3430)//Neurologische Untersuchungsgeräte (außer 3400-3430)""",
    )

    dfg_3440_6 = VocabularyTerm(
        code="DFG_3440_6",
        label="3440 Polygraphy systems (physiology)",
        description="""Polygraphy systems (physiology)//Polygraphiesysteme (Physiologie)""",
    )

    dfg_3450_1 = VocabularyTerm(
        code="DFG_3450_1",
        label="3450 Magneto-encephalography systems",
        description="""Magneto-encephalography systems//Magnet-Enzephalographie-Systeme""",
    )

    dfg_3460_1 = VocabularyTerm(
        code="DFG_3460_1",
        label="3460 Kymographs, plethysmographs, muscle force measurement",
        description="""Kymographs, plethysmographs, muscle force measurement//Kymographen, Plethysmographen, Muskelkraft-Messung""",
    )

    dfg_3460_2 = VocabularyTerm(
        code="DFG_3460_2",
        label="3460 Plethysmographs (except lung function measurement 3050)",
        description="""Plethysmographs (except lung function measurement 3050)//Plethysmographen (außer Lungenfunktionsmessung 3050)""",
    )

    dfg_3460_3 = VocabularyTerm(
        code="DFG_3460_3",
        label="3460 Writing and grip pressure measuring instruments, hand dynamometers",
        description="""Writing and grip pressure measuring instruments, hand dynamometers//Schreib- und Griffdruck-Messgeräte, Hand-Dynamometer""",
    )

    dfg_3460_4 = VocabularyTerm(
        code="DFG_3460_4",
        label="3460 Tremor measuring devices",
        description="""Tremor measuring devices//Tremormessgeräte""",
    )

    dfg_3480_1 = VocabularyTerm(
        code="DFG_3480_1",
        label="3480 Acoustic sensors and devices for the deaf",
        description="""Acoustic sensors and devices for the deaf//Akustische Sensoren und Geräte für Gehörlose""",
    )

    dfg_3480_2 = VocabularyTerm(
        code="DFG_3480_2",
        label="3480 Biotelemetry devices",
        description="""Biotelemetry devices//Biotelemetriegeräte""",
    )

    dfg_3480_3 = VocabularyTerm(
        code="DFG_3480_3",
        label="3480 Guidance and warning devices for the blind",
        description="""Guidance and warning devices for the blind//Blindenleit- und -warngeräte""",
    )

    dfg_3480_4 = VocabularyTerm(
        code="DFG_3480_4",
        label="3480 Electrophysiological control devices for prostheses and assistive devices",
        description="""Electrophysiological control devices for prostheses and assistive devices//Elektrophysiologische Steuergeräte für Prothesen und Hilfsgeräte""",
    )

    dfg_3480_5 = VocabularyTerm(
        code="DFG_3480_5",
        label="3480 Telemetry devices (medical/biological), special sensors and control devices",
        description="""Telemetry devices (medical/biological), special sensors and control devices//Telemetriegeräte (Medizin/Biologie), spezielle Sensoren und Steuergeräte""",
    )

    dfg_3490_1 = VocabularyTerm(
        code="DFG_3490_1",
        label="3490 Other medical recording instruments and accessories",
        description="""Other medical recording instruments and accessories//Sonstige medizinische Registriergeräte und Zubehör""",
    )

    dfg_3490_2 = VocabularyTerm(
        code="DFG_3490_2",
        label="3490 Actometers (activity measurement)",
        description="""Actometers (activity measurement)//Aktometer (Aktivitätsmessung)""",
    )

    dfg_3490_3 = VocabularyTerm(
        code="DFG_3490_3",
        label="3490 Motion analysis systems",
        description="""Motion analysis systems//Bewegungsanalyse-Systeme""",
    )

    dfg_3490_4 = VocabularyTerm(
        code="DFG_3490_4",
        label="3490 Eye movement recorders, eye markers, eye view monitors",
        description="""Eye movement recorders, eye markers, eye view monitors//Blickbewegungs-Registriergeräte, Eye Marker, Eye View Monitor""",
    )

    dfg_3490_5 = VocabularyTerm(
        code="DFG_3490_5",
        label="3490 Swivel chairs for nystagmus examination",
        description="""Swivel chairs for nystagmus examination//Drehstühle für Nystagmus-Untersuchung""",
    )

    dfg_3490_6 = VocabularyTerm(
        code="DFG_3490_6",
        label="3490 Gnathography systems (mandibular movement)",
        description="""Gnathography systems (mandibular movement)//Gnathographiesysteme (Unterkieferbewegung)""",
    )

    dfg_3490_7 = VocabularyTerm(
        code="DFG_3490_7",
        label="3490 Jaw movement recording systems",
        description="""Jaw movement recording systems//Kieferbewegungs-Registriersystyeme""",
    )

    dfg_3490_8 = VocabularyTerm(
        code="DFG_3490_8",
        label="3490 Force measurement systems (medicine)+E5290",
        description="""Force measurement systems (medicine)+E5290//Kraftmess-Systeme (Medizin)+E5290""",
    )

    dfg_3490_9 = VocabularyTerm(
        code="DFG_3490_9",
        label="3490 Oculography (gaze direction registration) devices",
        description="""Oculography (gaze direction registration) devices//Okulographie (Blickrichtungs-Registrier-) -Geräte""",
    )

    dfg_3490_10 = VocabularyTerm(
        code="DFG_3490_10",
        label="3490 Pupillometry devices, pupillometers",
        description="""Pupillometry devices, pupillometers//Pupillometriegeräte, Pupillometer""",
    )

    dfg_3490_11 = VocabularyTerm(
        code="DFG_3490_11",
        label="3490 Eye tracker",
        description="""Eye tracker//Eye Tracker""",
    )

    dfg_3490_12 = VocabularyTerm(
        code="DFG_3490_12",
        label="3490 Recorders (medical) and accessories (except 3410-3480)",
        description="""Recorders (medical) and accessories (except 3410-3480)//Registriergeräte (medizinische)  und Zubehör (außer 3410-3480)""",
    )

    dfg_3500_1 = VocabularyTerm(
        code="DFG_3500_1",
        label="3500 Bacteria and cell counters",
        description="""Bacteria and cell counters//Bakterien- und Zell-Zählgeräte""",
    )

    dfg_3500_2 = VocabularyTerm(
        code="DFG_3500_2",
        label="3500 Bacteria colony counters",
        description="""Bacteria colony counters//Bakterien-Koloniezähler""",
    )

    dfg_3500_3 = VocabularyTerm(
        code="DFG_3500_3",
        label="3500 Cell sorter",
        description="""Cell sorter//Cell-Sorter""",
    )

    dfg_3500_4 = VocabularyTerm(
        code="DFG_3500_4",
        label="3500 Cytophotometers (pulse)",
        description="""Cytophotometers (pulse)//Cytophotometer (Impuls-)""",
    )

    dfg_3500_5 = VocabularyTerm(
        code="DFG_3500_5",
        label="3500 Flow cytophotometer",
        description="""Flow cytophotometer//Durchflusscytophotometer""",
    )

    dfg_3500_6 = VocabularyTerm(
        code="DFG_3500_6",
        label="3500 Pulse cytophotometer",
        description="""Pulse cytophotometer//Impulscytophotometer""",
    )

    dfg_3500_7 = VocabularyTerm(
        code="DFG_3500_7",
        label="3500 Classifier (cell counting and classifying)",
        description="""Classifier (cell counting and classifying)//Klassiergeräte (Zellzähl- und Klassiergeräte)""",
    )

    dfg_3500_8 = VocabularyTerm(
        code="DFG_3500_8",
        label="3500 Cell counting and classifying instruments (except blood analysis), colony counters",
        description="""Cell counting and classifying instruments (except blood analysis), colony counters//Zellzähl- und Klassiergeräte (außer Blutanalyse), Koloniezähler""",
    )

    dfg_3510_1 = VocabularyTerm(
        code="DFG_3510_1",
        label="3510 Biophotometers, multi-channel (for biological growth processes)",
        description="""Biophotometers, multi-channel (for biological growth processes)//Biophotometer, Mehrkanal- (für biologische Wachstumsprozesse)""",
    )

    dfg_3510_2 = VocabularyTerm(
        code="DFG_3510_2",
        label="3510 Incubators, light thermostats, tissue culture devices",
        description="""Incubators, light thermostats, tissue culture devices//Brutschränke, Lichtthermostaten, Gewebekulturgeräte""",
    )

    dfg_3510_3 = VocabularyTerm(
        code="DFG_3510_3",
        label="3510 Incubators, incubation cabinets",
        description="""Incubators, incubation cabinets//Inkubatoren, Inkubationsschränke""",
    )

    dfg_3510_4 = VocabularyTerm(
        code="DFG_3510_4",
        label="3510 Roller apparatus for tissue culture (except 1080)",
        description="""Roller apparatus for tissue culture (except 1080)//Rollergeräte zur Gewebekultur (außer 1080)""",
    )

    dfg_3520_1 = VocabularyTerm(
        code="DFG_3520_1",
        label="3520 Bioreactors",
        description="""Bioreactors//Bioreaktoren""",
    )

    dfg_3520_2 = VocabularyTerm(
        code="DFG_3520_2",
        label="3520 Bubble column fermenters",
        description="""Bubble column fermenters//Blasensäulen-Fermenter""",
    )

    dfg_3520_3 = VocabularyTerm(
        code="DFG_3520_3",
        label="3520 Fermenters, laboratory fermenters",
        description="""Fermenters, laboratory fermenters//Fermenter, Laborfermenter""",
    )

    dfg_3520_4 = VocabularyTerm(
        code="DFG_3520_4",
        label="3520 Submerged apparatus",
        description="""Submerged apparatus//Submersapparaturen""",
    )

    dfg_3530_1 = VocabularyTerm(
        code="DFG_3530_1",
        label="3530 Digestion apparatus for bacteria and cells",
        description="""Digestion apparatus for bacteria and cells//Aufschlußapparate für Bakterien und Zellen""",
    )

    dfg_3530_2 = VocabularyTerm(
        code="DFG_3530_2",
        label="3530 Bacteria presses",
        description="""Bacteria presses//Bakterien-Pressen""",
    )

    dfg_3530_3 = VocabularyTerm(
        code="DFG_3530_3",
        label="3530 French pressure cells, presses",
        description="""French pressure cells, presses//French-Druckzellen, -Pressen""",
    )

    dfg_3530_4 = VocabularyTerm(
        code="DFG_3530_4",
        label="3530 High-pressure homogenisers, digestors",
        description="""High-pressure homogenisers, digestors//Hochdruck-Homogenisatoren, -Aufschlußgeräte""",
    )

    dfg_3530_5 = VocabularyTerm(
        code="DFG_3530_5",
        label="3530 Lysotype apparatus, Lidwell apparatus (bacteria examination)",
        description="""Lysotype apparatus, Lidwell apparatus (bacteria examination)//Lysotypiegeräte, Lidwell-Apparate (Bakterien-Untersuchung)""",
    )

    dfg_3530_6 = VocabularyTerm(
        code="DFG_3530_6",
        label="3530 Cell disruptors, cell disruption bombs",
        description="""Cell disruptors, cell disruption bombs//Zellaufschlußgeräte, Zellaufbrechbomben""",
    )

    dfg_3530_7 = VocabularyTerm(
        code="DFG_3530_7",
        label="3530 Cell roller",
        description="""Cell roller//Zellroller""",
    )

    dfg_3540_1 = VocabularyTerm(
        code="DFG_3540_1",
        label="3540 Embedding machines, (for tissue examination)",
        description="""Embedding machines, (for tissue examination)//Einbettungsautomaten, (für Gewebeuntersuchung)""",
    )

    dfg_3540_2 = VocabularyTerm(
        code="DFG_3540_2",
        label="3540 Freezing apparatus (cryofixation of specimens)",
        description="""Freezing apparatus (cryofixation of specimens)//Gefriersprühgeräte (Kryofixation von Präparaten)""",
    )

    dfg_3540_3 = VocabularyTerm(
        code="DFG_3540_3",
        label="3540 Tissue embedding, fixation and fixation devices",
        description="""Tissue embedding, fixation and fixation devices//Gewebeeinbettungsgeräte, Fixier- und Färbegeräte""",
    )

    dfg_3540_4 = VocabularyTerm(
        code="DFG_3540_4",
        label="3540 Tissue mounts (biology)",
        description="""Tissue mounts (biology)//Gewebefärbegeräte (Biologie)""",
    )

    dfg_3540_5 = VocabularyTerm(
        code="DFG_3540_5",
        label="3540 Tissue dryers and embedding devices",
        description="""Tissue dryers and embedding devices//Gewebetrockner und Einbettungsgeräte""",
    )

    dfg_3540_6 = VocabularyTerm(
        code="DFG_3540_6",
        label="3540 Histomats (tissue embedding machines)",
        description="""Histomats (tissue embedding machines)//Histomaten (Gewebeeinbettungs-Automaten)""",
    )

    dfg_3540_7 = VocabularyTerm(
        code="DFG_3540_7",
        label="3540 Microfilter apparatus for dehydration and fixation of biological objects",
        description="""Microfilter apparatus for dehydration and fixation of biological objects//Mikrofiltergeräte zur Entwässerung und Fixierung biologischer Objekte""",
    )

    dfg_3540_8 = VocabularyTerm(
        code="DFG_3540_8",
        label="3540 Paraffin embedding devices",
        description="""Paraffin embedding devices//Paraffin-Einbettungsgeräte""",
    )

    dfg_3540_9 = VocabularyTerm(
        code="DFG_3540_9",
        label="3540 Tissue processors (tissue drying machines)",
        description="""Tissue processors (tissue drying machines)//Tissue-Prozessoren (Gewebetrocknungs-Automaten)""",
    )

    dfg_3560_1 = VocabularyTerm(
        code="DFG_3560_1",
        label="3560 Warburg apparatus, cell metabolism analysers",
        description="""Warburg apparatus, cell metabolism analysers//Warburg-Apparaturen, Zellstoffwechsel-Analysengeräte""",
    )

    dfg_3590_1 = VocabularyTerm(
        code="DFG_3590_1",
        label="3590 Biopsy scaffolds",
        description="""Biopsy scaffolds//Biopsiegeräte""",
    )

    dfg_3590_2 = VocabularyTerm(
        code="DFG_3590_2",
        label="3590 Electroporation devices",
        description="""Electroporation devices//Elektroporationsgeräte""",
    )

    dfg_3590_3 = VocabularyTerm(
        code="DFG_3590_3",
        label="3590 Patch clamp components (apparatus with microscope see 5040)",
        description="""Patch clamp components (apparatus with microscope see 5040)//Patch-Clamp-Komponenten (Apparaturen mit Mikroskop siehe 5040)""",
    )

    dfg_3590_4 = VocabularyTerm(
        code="DFG_3590_4",
        label="3590 Other apparatus for tissue and cell examination",
        description="""Other apparatus for tissue and cell examination//Sonstige Geräte für Gewebe- und Zelluntersuchung""",
    )

    dfg_3590_5 = VocabularyTerm(
        code="DFG_3590_5",
        label="3590 Cell collection devices, cell harvesters",
        description="""Cell collection devices, cell harvesters//Zellsammelgeräte, Zell-Harvester""",
    )

    dfg_3600_1 = VocabularyTerm(
        code="DFG_3600_1",
        label="3600 Dermatological instruments",
        description="""Dermatological instruments//Dermatologische Geräte""",
    )

    dfg_3600_2 = VocabularyTerm(
        code="DFG_3600_2",
        label="3600 Skin sensitivity testers, sthesiometers, sensitivity testers",
        description="""Skin sensitivity testers, sthesiometers, sensitivity testers//Hautempfindlichkeits-Prüfgeräte, Ästhesiometer, Sensitivity-Tester""",
    )

    dfg_3600_3 = VocabularyTerm(
        code="DFG_3600_3",
        label="3600 Skin testers (except psychological testers 3660)",
        description="""Skin testers (except psychological testers 3660)//Hautprüfgeräte (außer psychologische Prüfgeräte 3660)""",
    )

    dfg_3610_1 = VocabularyTerm(
        code="DFG_3610_1",
        label="3610 Gynaecological instruments (except X-ray 3200 and 3900-3920)",
        description="""Gynaecological instruments (except X-ray 3200 and 3900-3920)//Gynäkologische Geräte (außer Röntgen 3200 und 3900-3920)""",
    )

    dfg_3620_1 = VocabularyTerm(
        code="DFG_3620_1",
        label="3620 Audiometer",
        description="""Audiometer//Audiometer""",
    )

    dfg_3620_2 = VocabularyTerm(
        code="DFG_3620_2",
        label="3620 ERA (Electrical Response Audiometry) systems",
        description="""ERA (Electrical Response Audiometry) systems//ERA (Electrical Response Audiometry) -Systeme""",
    )

    dfg_3620_3 = VocabularyTerm(
        code="DFG_3620_3",
        label="3620 Ear analysis, objective analysis of ear and speech (ERA) instruments",
        description="""Ear analysis, objective analysis of ear and speech (ERA) instruments//Gehöranalyse, Geräte zur objektiven Analyse von Gehör und Sprache (ERA)""",
    )

    dfg_3620_4 = VocabularyTerm(
        code="DFG_3620_4",
        label="3620 Ear, nose and throat instruments",
        description="""Ear, nose and throat instruments//Geräte für Hals-Nasen-Ohrenheilkunde""",
    )

    dfg_3620_5 = VocabularyTerm(
        code="DFG_3620_5",
        label="3620 Glossometers, glossographs",
        description="""Glossometers, glossographs//Glossometer, Glossographen""",
    )

    dfg_3620_6 = VocabularyTerm(
        code="DFG_3620_6",
        label="3620 Hearing instruments",
        description="""Hearing instruments//Hörgeräte""",
    )

    dfg_3620_7 = VocabularyTerm(
        code="DFG_3620_7",
        label="3620 Impedance meters (otology)",
        description="""Impedance meters (otology)//Impedanzmessgeräte (Ohrenheilkunde)""",
    )

    dfg_3620_8 = VocabularyTerm(
        code="DFG_3620_8",
        label="3620 Laryngoscopes, laryngeal stroboscopes",
        description="""Laryngoscopes, laryngeal stroboscopes//Laryngoskope, Larynx-Stroboskope""",
    )

    dfg_3620_9 = VocabularyTerm(
        code="DFG_3620_9",
        label="3620 Otoscopes",
        description="""Otoscopes//Otoskope""",
    )

    dfg_3620_10 = VocabularyTerm(
        code="DFG_3620_10",
        label="3620 Sound impedance meters (otology)",
        description="""Sound impedance meters (otology)//Schallimpedanz-Messer (Ohrenheilkunde)""",
    )

    dfg_3620_11 = VocabularyTerm(
        code="DFG_3620_11",
        label="3620 Speech, voice and ear instruments",
        description="""Speech, voice and ear instruments//Sprach-, Stimm- und Gehör-Prüfgeräte""",
    )

    dfg_3620_12 = VocabularyTerm(
        code="DFG_3620_12",
        label="3620 Tympanographs (ear examination)",
        description="""Tympanographs (ear examination)//Tympanographen (Gehöruntersuchung)""",
    )

    dfg_3630_1 = VocabularyTerm(
        code="DFG_3630_1",
        label="3630 Special paediatric instruments",
        description="""Special paediatric instruments//Spezielle Geräte der Kinderheilkunde""",
    )

    dfg_3640_1 = VocabularyTerm(
        code="DFG_3640_1",
        label="3640 Anomaloscopes",
        description="""Anomaloscopes//Anomaloskope""",
    )

    dfg_3640_2 = VocabularyTerm(
        code="DFG_3640_2",
        label="3640 Fundus cameras, funduscopes",
        description="""Fundus cameras, funduscopes//Fundus-Kameras, Funduskope""",
    )

    dfg_3640_3 = VocabularyTerm(
        code="DFG_3640_3",
        label="3640 Ophthalmological scopes",
        description="""Ophthalmological scopes//Ophthalmologische Geräte""",
    )

    dfg_3640_4 = VocabularyTerm(
        code="DFG_3640_4",
        label="3640 Ophthalmometers, ophthalmoscopes",
        description="""Ophthalmometers, ophthalmoscopes//Ophthalmometer, Ophthalmoskope""",
    )

    dfg_3640_5 = VocabularyTerm(
        code="DFG_3640_5",
        label="3640 Perimeters",
        description="""Perimeters//Perimeter""",
    )

    dfg_3640_6 = VocabularyTerm(
        code="DFG_3640_6",
        label="3640 Ophthalmological ophthalmometers, ophthalmoscopes",
        description="""Ophthalmological ophthalmometers, ophthalmoscopes//Scheitelbrechwert-Messgeräte (Ophthalmologie)""",
    )

    dfg_3640_7 = VocabularyTerm(
        code="DFG_3640_7",
        label="3640 Slit lamps",
        description="""Slit lamps//Spaltlampen""",
    )

    dfg_3640_8 = VocabularyTerm(
        code="DFG_3640_8",
        label="3640 Specular microscopes (for corneal examination)",
        description="""Specular microscopes (for corneal examination)//Spekular-Mikroskope (für Hornhaut-Untersuchung)""",
    )

    dfg_3640_9 = VocabularyTerm(
        code="DFG_3640_9",
        label="3640 Tonometers (ophthalmology)",
        description="""Tonometers (ophthalmology)//Tonometer (Ophthalmologie)""",
    )

    dfg_3650_1 = VocabularyTerm(
        code="DFG_3650_1",
        label="3650 Orthopaedic instruments for examination and rehabilitation",
        description="""Orthopaedic instruments for examination and rehabilitation//Orthopädische Geräte für Untersuchung und Rehabilitation""",
    )

    dfg_3650_2 = VocabularyTerm(
        code="DFG_3650_2",
        label="3650 Prostheses",
        description="""Prostheses//Prothesen""",
    )

    dfg_3660_1 = VocabularyTerm(
        code="DFG_3660_1",
        label="3660 Biofeedback devices (except for skin resistance 3660, temperature 3910, EEG 3430, pulse 3020)",
        description="""Biofeedback devices (except for skin resistance 3660, temperature 3910, EEG 3430, pulse 3020)//Biofeedbackgeräte (außer für Hautwiderstand 3660, Temperatur 3910, EEG 3430, Puls 3020)""",
    )

    dfg_3660_2 = VocabularyTerm(
        code="DFG_3660_2",
        label="3660 Determination devices (psychology)",
        description="""Determination devices (psychology)//Determinationsgeräte (Psychologie)""",
    )

    dfg_3660_3 = VocabularyTerm(
        code="DFG_3660_3",
        label="3660 Skin resistance measuring devices",
        description="""Skin resistance measuring devices//Hautwiderstandsmessgeräte""",
    )

    dfg_3660_4 = VocabularyTerm(
        code="DFG_3660_4",
        label="3660 Programme control equipment for psychological tests",
        description="""Programme control equipment for psychological tests//Programmsteueranlagen für psychologische Tests""",
    )

    dfg_3660_5 = VocabularyTerm(
        code="DFG_3660_5",
        label="3660 Projection tachistoscopes",
        description="""Projection tachistoscopes//Projektionstachistoskope""",
    )

    dfg_3660_6 = VocabularyTerm(
        code="DFG_3660_6",
        label="3660 Psychological testing and examination equipment",
        description="""Psychological testing and examination equipment//Psychologische Test- und Untersuchungsgeräte""",
    )

    dfg_3660_7 = VocabularyTerm(
        code="DFG_3660_7",
        label="3660 Tachistoscopes",
        description="""Tachistoscopes//Tachistoskope""",
    )

    dfg_3660_8 = VocabularyTerm(
        code="DFG_3660_8",
        label="3660 Behaviour therapy instruments",
        description="""Behaviour therapy instruments//Verhaltenstherapie-Geräte""",
    )

    dfg_3670_1 = VocabularyTerm(
        code="DFG_3670_1",
        label="3670 Mictiometers, mictiographs",
        description="""Mictiometers, mictiographs//Mictiometer, Mictiographen""",
    )

    dfg_3670_2 = VocabularyTerm(
        code="DFG_3670_2",
        label="3670 Renal examination apparatus (except X-ray 3200 and nuclear medicine 3310)",
        description="""Renal examination apparatus (except X-ray 3200 and nuclear medicine 3310)//Nierenuntersuchungsgeräte (außer Röntgen 3200 und Nuklearmedizin 3310)""",
    )

    dfg_3670_3 = VocabularyTerm(
        code="DFG_3670_3",
        label="3670 Uroflowmeters, urodynamic measuring devices",
        description="""Uroflowmeters, urodynamic measuring devices//Uroflowmeter, urodynamische Messeinrichtungen""",
    )

    dfg_3670_4 = VocabularyTerm(
        code="DFG_3670_4",
        label="3670 Urological instruments (except X-ray 3200)",
        description="""Urological instruments (except X-ray 3200)//Urologische Geräte (außer Röntgen 3200)""",
    )

    dfg_3670_5 = VocabularyTerm(
        code="DFG_3670_5",
        label="3670 Uromanometers",
        description="""Uromanometers//Uromanometer""",
    )

    dfg_3680_1 = VocabularyTerm(
        code="DFG_3680_1",
        label="3680 Drilling machines for dentistry",
        description="""Drilling machines for dentistry//Bohrmaschinen für Zahnmedizin""",
    )

    dfg_3680_2 = VocabularyTerm(
        code="DFG_3680_2",
        label="3680 Dental instruments",
        description="""Dental instruments//Zahnmedizinische Geräte""",
    )

    dfg_3690_1 = VocabularyTerm(
        code="DFG_3690_1",
        label="3690 Specialised medical equipment (except 3600-3680)",
        description="""Specialised medical equipment (except 3600-3680)//Fachärztliche Spezialgeräte (außer 3600-3680)""",
    )

    dfg_3690_2 = VocabularyTerm(
        code="DFG_3690_2",
        label="3690 Other equipment for specialist use",
        description="""Other equipment for specialist use//Sonstige Geräte für fachärztlichen Gebrauch""",
    )

    dfg_3700_1 = VocabularyTerm(
        code="DFG_3700_1",
        label="3700 Respiratory gas humidifiers (except 1040)",
        description="""Respiratory gas humidifiers (except 1040)//Atemgas-Befeuchter (außer 1040)""",
    )

    dfg_3700_2 = VocabularyTerm(
        code="DFG_3700_2",
        label="3700 Inhalation devices (except 1040)",
        description="""Inhalation devices (except 1040)//Inhalationsgeräte (außer 1040)""",
    )

    dfg_3700_3 = VocabularyTerm(
        code="DFG_3700_3",
        label="3700 Anaesthetic and respiratory equipment",
        description="""Anaesthetic and respiratory equipment//Narkose- und Beatmungsgeräte""",
    )

    dfg_3700_4 = VocabularyTerm(
        code="DFG_3700_4",
        label="3700 Respirators, ventilators",
        description="""Respirators, ventilators//Respiratoren, Ventilatoren""",
    )

    dfg_3710_1 = VocabularyTerm(
        code="DFG_3710_1",
        label="3710 Blood pumps, heart-lung machines",
        description="""Blood pumps, heart-lung machines//Blutpumpen, Herz-Lungen-Maschinen""",
    )

    dfg_3710_2 = VocabularyTerm(
        code="DFG_3710_2",
        label="3710 Counterpulsation equipment for cardiac and circulatory support",
        description="""Counterpulsation equipment for cardiac and circulatory support//Gegenpulsationsanlagen zur Herz- und Kreislaufstützung""",
    )

    dfg_3710_3 = VocabularyTerm(
        code="DFG_3710_3",
        label="3710 Oxygenators",
        description="""Oxygenators//Oxygenatoren""",
    )

    dfg_3720_1 = VocabularyTerm(
        code="DFG_3720_1",
        label="3720 Infusion devices, catheters",
        description="""Infusion devices, catheters//Infusionsgeräte, Katheter""",
    )

    dfg_3720_2 = VocabularyTerm(
        code="DFG_3720_2",
        label="3720 Infusion pumps",
        description="""Infusion pumps//Infusionspumpen""",
    )

    dfg_3730_1 = VocabularyTerm(
        code="DFG_3730_1",
        label="3730 Operating tables",
        description="""Operating tables//Operationsmöbel""",
    )

    dfg_3730_2 = VocabularyTerm(
        code="DFG_3730_2",
        label="3730 Operating tables",
        description="""Operating tables//Operationstische""",
    )

    dfg_3740_1 = VocabularyTerm(
        code="DFG_3740_1",
        label="3740 Surgical lasers",
        description="""Surgical lasers//Chirurgie-Laser""",
    )

    dfg_3740_2 = VocabularyTerm(
        code="DFG_3740_2",
        label="3740 High-frequency surgical rigs",
        description="""High-frequency surgical rigs//Hochfrequenzchirurgiegeräte""",
    )

    dfg_3740_3 = VocabularyTerm(
        code="DFG_3740_3",
        label="3740 Coagulators (electrosurgery, laser)",
        description="""Coagulators (electrosurgery, laser)//Koagulatoren (Elektrochirurgie, Laser-)""",
    )

    dfg_3740_4 = VocabularyTerm(
        code="DFG_3740_4",
        label="3740 Laser coagulators",
        description="""Laser coagulators//Laser-Koagulatoren""",
    )

    dfg_3740_5 = VocabularyTerm(
        code="DFG_3740_5",
        label="3740 Medical lasers and electrosurgical scaffolds",
        description="""Medical lasers and electrosurgical scaffolds//Medizin-Laser und elektrochirurgische Geräte""",
    )

    dfg_3740_6 = VocabularyTerm(
        code="DFG_3740_6",
        label="3740 Retinal coagulators",
        description="""Retinal coagulators//Netzhaut-Koagulatoren""",
    )

    dfg_3750_1 = VocabularyTerm(
        code="DFG_3750_1",
        label="3750 Cryosurgical instruments",
        description="""Cryosurgical instruments//Kryochirurgische Geräte""",
    )

    dfg_3770_1 = VocabularyTerm(
        code="DFG_3770_1",
        label="3770 Instrument cabinets",
        description="""Instrument cabinets//Instrumentenschränke""",
    )

    dfg_3770_2 = VocabularyTerm(
        code="DFG_3770_2",
        label="3770 Surgical instrument sets (except 3740 and 3750)",
        description="""Surgical instrument sets (except 3740 and 3750)//Operationsinstrumentarien (außer 3740 und 3750)""",
    )

    dfg_3780_1 = VocabularyTerm(
        code="DFG_3780_1",
        label="3780 Incubators for newborns and premature babies",
        description="""Incubators for newborns and premature babies//Inkubatoren für Neu- und Frühgeborene""",
    )

    dfg_3780_2 = VocabularyTerm(
        code="DFG_3780_2",
        label="3780 Laminar-flow systems for operating theatres (except for pure workbenches and laminar-flow boxes 4680)",
        description="""Laminar-flow systems for operating theatres (except for pure workbenches and laminar-flow boxes 4680)//Laminar-Flow-Systeme für OP (außer reine Werkbänke und Laminar- Flow-Boxen 4680)""",
    )

    dfg_3780_3 = VocabularyTerm(
        code="DFG_3780_3",
        label="3780 Air flow isolators",
        description="""Air flow isolators//Luftstromisolatoren""",
    )

    dfg_3780_4 = VocabularyTerm(
        code="DFG_3780_4",
        label="3780 Patient isolators",
        description="""Patient isolators//Patientenisolatoren""",
    )

    dfg_3780_5 = VocabularyTerm(
        code="DFG_3780_5",
        label="3780 Special equipment for operating rooms, aseptic rooms",
        description="""Special equipment for operating rooms, aseptic rooms//Spezielle Ausstattung von Operationsräumen, keimfreie Räume""",
    )

    dfg_3790_1 = VocabularyTerm(
        code="DFG_3790_1",
        label="3790 MKM systems (micro-coordinate manipulators)",
        description="""MKM systems (micro-coordinate manipulators)//MKM-Systeme (Mikrokoordinatenmanipulatoren)""",
    )

    dfg_3790_2 = VocabularyTerm(
        code="DFG_3790_2",
        label="3790 Navigation systems (neurosurgery)",
        description="""Navigation systems (neurosurgery)//Navigationssysteme (Neurochirurgie)""",
    )

    dfg_3790_3 = VocabularyTerm(
        code="DFG_3790_3",
        label="3790 Neuronavigation systems",
        description="""Neuronavigation systems//Neuronavigationssysteme""",
    )

    dfg_3790_4 = VocabularyTerm(
        code="DFG_3790_4",
        label="3790 Organ replacement and implants (except pacemakers 3030 and prostheses 3650)",
        description="""Organ replacement and implants (except pacemakers 3030 and prostheses 3650)//Organersatz und Implantate (außer Schrittmacher 3030 und Prothesen 3650)""",
    )

    dfg_3790_5 = VocabularyTerm(
        code="DFG_3790_5",
        label="3790 Other special surgical devices",
        description="""Other special surgical devices//Sonstige spezielle Geräte der Chirurgie""",
    )

    dfg_3790_6 = VocabularyTerm(
        code="DFG_3790_6",
        label="3790 Viewing wall systems",
        description="""Viewing wall systems//Viewing Wand Systeme""",
    )

    dfg_3800_1 = VocabularyTerm(
        code="DFG_3800_1",
        label="3800 Instruments for animal examinations",
        description="""Instruments for animal examinations//Geräte für Tieruntersuchungen""",
    )

    dfg_3800_2 = VocabularyTerm(
        code="DFG_3800_2",
        label="3800 Special examination equipment for veterinary medicine",
        description="""Special examination equipment for veterinary medicine//Spezielle Untersuchungsgeräte für die Veterinärmedizin""",
    )

    dfg_3810_1 = VocabularyTerm(
        code="DFG_3810_1",
        label="3810 Surgical scaffolds for veterinary medicine",
        description="""Surgical scaffolds for veterinary medicine//Operationsgeräte für Veterinärmedizin""",
    )

    dfg_3850_1 = VocabularyTerm(
        code="DFG_3850_1",
        label="3850 Training and testing equipment, conditioning chambers",
        description="""Training and testing equipment, conditioning chambers//Lerngeräte, Testgeräte, Konditionierungskammern""",
    )

    dfg_3850_2 = VocabularyTerm(
        code="DFG_3850_2",
        label="3850 Skinner boxes",
        description="""Skinner boxes//Skinner-Boxen""",
    )

    dfg_3860_1 = VocabularyTerm(
        code="DFG_3860_1",
        label="3860 Activity measuring equipment (animal activity)",
        description="""Activity measuring equipment (animal activity)//Aktivitäts-Messanlagen (Tieraktivität)""",
    )

    dfg_3860_2 = VocabularyTerm(
        code="DFG_3860_2",
        label="3860 Locomotion compensation apparatus (Kramer ball) for insects",
        description="""Locomotion compensation apparatus (Kramer ball) for insects//Lokomotions-Kompensationsgeräte (Kramer-Kugel) für Insekten""",
    )

    dfg_3860_3 = VocabularyTerm(
        code="DFG_3860_3",
        label="3860 Motility test apparatus",
        description="""Motility test apparatus//Motilitäts-Testgeräte""",
    )

    dfg_3870_1 = VocabularyTerm(
        code="DFG_3870_1",
        label="3870 Stereotactic instruments",
        description="""Stereotactic instruments//Stereotaktische Instrumente""",
    )

    dfg_3880_1 = VocabularyTerm(
        code="DFG_3880_1",
        label="3880 Special facilities for laboratory animals",
        description="""Special facilities for laboratory animals//Spezielle Einrichtungen für Versuchstierhaltung""",
    )

    dfg_3890_1 = VocabularyTerm(
        code="DFG_3890_1",
        label="3890 Other veterinary and zoological instruments",
        description="""Other veterinary and zoological instruments//Sonstige veterinärmedizinische und zoologische Geräte""",
    )

    dfg_3900_1 = VocabularyTerm(
        code="DFG_3900_1",
        label="3900 Echo-encephalographs, -encephaloscopes (ultrasound)",
        description="""Echo-encephalographs, -encephaloscopes (ultrasound)//Echo-Enzephalographen, -Enzephaloskope (Ultraschall)""",
    )

    dfg_3900_2 = VocabularyTerm(
        code="DFG_3900_2",
        label="3900 Echo-cardiography apparatus",
        description="""Echo-cardiography apparatus//Echo-Kardiographiegeräte""",
    )

    dfg_3900_3 = VocabularyTerm(
        code="DFG_3900_3",
        label="3900 Echo-ophthalmographs (ultrasound)",
        description="""Echo-ophthalmographs (ultrasound)//Echo-Ophthalmographen (Ultraschall)""",
    )

    dfg_3900_4 = VocabularyTerm(
        code="DFG_3900_4",
        label="3900 Grey-scale ultrasound diagnostic scanners",
        description="""Grey-scale ultrasound diagnostic scanners//Grauwert-Ultraschall-Diagnostikgeräte""",
    )

    dfg_3900_5 = VocabularyTerm(
        code="DFG_3900_5",
        label="3900 Sector scanners, phased-array (ultrasound diagnostics)",
        description="""Sector scanners, phased-array (ultrasound diagnostics)//Sector-Scanner, Phased-Array- (Ultraschall-Diagnostik)""",
    )

    dfg_3900_6 = VocabularyTerm(
        code="DFG_3900_6",
        label="3900 Sonography equipment (ultrasound diagnostics)",
        description="""Sonography equipment (ultrasound diagnostics)//Sonographiegeräte (Ultraschall-Diagnostik)""",
    )

    dfg_3900_7 = VocabularyTerm(
        code="DFG_3900_7",
        label="3900 Ultrasound diagnostic rigs",
        description="""Ultrasound diagnostic rigs//Ultraschall-Diagnostikgeräte""",
    )

    dfg_3910_1 = VocabularyTerm(
        code="DFG_3910_1",
        label="3910 ELC thermosystems (skin temperature measurement with liquid crystal plates)",
        description="""ELC thermosystems (skin temperature measurement with liquid crystal plates)//ELC-Thermosysteme (Hauttemperaturmessung mit Flüssigkristallplatten)""",
    )

    dfg_3910_2 = VocabularyTerm(
        code="DFG_3910_2",
        label="3910 Skin temperature measuring devices",
        description="""Skin temperature measuring devices//Hauttemperaturmessgeräte""",
    )

    dfg_3910_3 = VocabularyTerm(
        code="DFG_3910_3",
        label="3910 Medical thermometers",
        description="""Medical thermometers//Medizinische Thermometer""",
    )

    dfg_3910_4 = VocabularyTerm(
        code="DFG_3910_4",
        label="3910 Thermographic diagnostic instruments, thermometers",
        description="""Thermographic diagnostic instruments, thermometers//Thermographische Diagnostikgeräte, Thermometer""",
    )

    dfg_3920_1 = VocabularyTerm(
        code="DFG_3920_1",
        label="3920 Arthroscopes",
        description="""Arthroscopes//Arthroskope""",
    )

    dfg_3920_2 = VocabularyTerm(
        code="DFG_3920_2",
        label="3920 Bronchoscopes",
        description="""Bronchoscopes//Bronchoskope""",
    )

    dfg_3920_3 = VocabularyTerm(
        code="DFG_3920_3",
        label="3920 Cystoscopes",
        description="""Cystoscopes//Cystoskope""",
    )

    dfg_3920_4 = VocabularyTerm(
        code="DFG_3920_4",
        label="3920 Endoscopes (medicine)",
        description="""Endoscopes (medicine)//Endoskope (Medizin)""",
    )

    dfg_3920_5 = VocabularyTerm(
        code="DFG_3920_5",
        label="3920 Colposcopes",
        description="""Colposcopes//Kolposkope""",
    )

    dfg_3940_1 = VocabularyTerm(
        code="DFG_3940_1",
        label="3940 Artificial kidneys",
        description="""Artificial kidneys//Künstliche Nieren""",
    )

    dfg_3940_2 = VocabularyTerm(
        code="DFG_3940_2",
        label="3940 Medical dialysis apparatus",
        description="""Medical dialysis apparatus//Medizinische Dialysegeräte""",
    )

    dfg_3950_1 = VocabularyTerm(
        code="DFG_3950_1",
        label="3950 Diathermy apparatus",
        description="""Diathermy apparatus//Diathermie-Apparate""",
    )

    dfg_3950_2 = VocabularyTerm(
        code="DFG_3950_2",
        label="3950 Light boxes, light baths",
        description="""Light boxes, light baths//Lichtkästen, Lichtbäder""",
    )

    dfg_3950_3 = VocabularyTerm(
        code="DFG_3950_3",
        label="3950 Lithotrypters (kidney stone crushing)",
        description="""Lithotrypters (kidney stone crushing)//Lithotrypter (Nierensteinzertrümmerung)""",
    )

    dfg_3950_4 = VocabularyTerm(
        code="DFG_3950_4",
        label="3950 Microwave therapy apparatus",
        description="""Microwave therapy apparatus//Mikrowellen-Therapiegeräte""",
    )

    dfg_3950_5 = VocabularyTerm(
        code="DFG_3950_5",
        label="3950 Kidney lithotrypters",
        description="""Kidney lithotrypters//Nierenlithotrypter""",
    )

    dfg_3950_6 = VocabularyTerm(
        code="DFG_3950_6",
        label="3950 Kidney stone disintegration systems",
        description="""Kidney stone disintegration systems//Nierenstein-Zertrümmerungs-Systeme""",
    )

    dfg_3950_7 = VocabularyTerm(
        code="DFG_3950_7",
        label="3950 Therapeutic radiant heaters",
        description="""Therapeutic radiant heaters//Therapeutische Wärmestrahler""",
    )

    dfg_3950_8 = VocabularyTerm(
        code="DFG_3950_8",
        label="3950 Ultrasound, heat and high-frequency therapy devices",
        description="""Ultrasound, heat and high-frequency therapy devices//Ultraschall-, Wärme-, und Hochfrequenz-Therapiegeräte""",
    )

    dfg_3950_9 = VocabularyTerm(
        code="DFG_3950_9",
        label="3950 Ultrasound therapy devices",
        description="""Ultrasound therapy devices//Ultraschall-Therapiegeräte""",
    )

    dfg_3960_1 = VocabularyTerm(
        code="DFG_3960_1",
        label="3960 Baths (medical), special equipment (except 9680)",
        description="""Baths (medical), special equipment (except 9680)//Bäder (medizinische), spezielle Geräte (außer 9680)""",
    )

    dfg_3960_2 = VocabularyTerm(
        code="DFG_3960_2",
        label="3960 Hyperthermia appliances (whole body)",
        description="""Hyperthermia appliances (whole body)//Hyperthermiegeräte (Ganzkörper-)""",
    )

    dfg_3960_3 = VocabularyTerm(
        code="DFG_3960_3",
        label="3960 Hypothermia, cryotherapy equipment",
        description="""Hypothermia, cryotherapy equipment//Hypothermie-, Kältetherapiegeräte""",
    )

    dfg_3960_4 = VocabularyTerm(
        code="DFG_3960_4",
        label="3960 Massage equipment",
        description="""Massage equipment//Massagegeräte""",
    )

    dfg_3960_5 = VocabularyTerm(
        code="DFG_3960_5",
        label="3960 Physical therapy apparatus and medical belts (except 3250, 3400, 3950, 3970, 9680)",
        description="""Physical therapy apparatus and medical belts (except 3250, 3400, 3950, 3970, 9680)//Physikalische Therapiegeräte und medizinische Bäder (außer 3250, 3400, 3950, 3970, 9680)""",
    )

    dfg_3960_6 = VocabularyTerm(
        code="DFG_3960_6",
        label="3960 Vibrators (therapy)",
        description="""Vibrators (therapy)//Vibratoren (Therapie)""",
    )

    dfg_3970_1 = VocabularyTerm(
        code="DFG_3970_1",
        label="3970 Pressure chambers for medicine, diving, special aeromedical equipment",
        description="""Pressure chambers for medicine, diving, special aeromedical equipment//Druckkammern für Medizin, Taucher, spezielle flugmedizinische Apparaturen""",
    )

    dfg_3970_2 = VocabularyTerm(
        code="DFG_3970_2",
        label="3970 Diving pressure chambers",
        description="""Diving pressure chambers//Taucherdruckkammern""",
    )

    dfg_3970_3 = VocabularyTerm(
        code="DFG_3970_3",
        label="3970 Negative pressure chambers (medicine, aeromedicine)",
        description="""Negative pressure chambers (medicine, aeromedicine)//Unterdruck-Kammern (Medizin, Flugmedizin)""",
    )

    dfg_3970_4 = VocabularyTerm(
        code="DFG_3970_4",
        label="3970 Centrifuges for aeromedical examinations",
        description="""Centrifuges for aeromedical examinations//Zentrifugen für flugmedizinische Untersuchungen""",
    )

    dfg_3980_1 = VocabularyTerm(
        code="DFG_3980_1",
        label="3980 Devices for preservation and storage of transplants",
        description="""Devices for preservation and storage of transplants//Geräte zur Konservierung und Lagerung von Transplantaten""",
    )

    dfg_4000_1 = VocabularyTerm(
        code="DFG_4000_1",
        label="4000 Rotary anode X-ray generators",
        description="""Rotary anode X-ray generators//Drehanoden-Röntgengeneratoren""",
    )

    dfg_4000_2 = VocabularyTerm(
        code="DFG_4000_2",
        label="4000 Single-tank X-ray generators",
        description="""Single-tank X-ray generators//Eintank-Röntgengeneratoren""",
    )

    dfg_4000_3 = VocabularyTerm(
        code="DFG_4000_3",
        label="4000 Radiography equipment (technical)",
        description="""Radiography equipment (technical)//Radiographiegeräte (technisch)""",
    )

    dfg_4000_4 = VocabularyTerm(
        code="DFG_4000_4",
        label="4000 X-ray equipment (except medicine 3200)",
        description="""X-ray equipment (except medicine 3200)//Röntgenanlagen (außer Medizin 3200)""",
    )

    dfg_4000_5 = VocabularyTerm(
        code="DFG_4000_5",
        label="4000 X-ray fluoroscopy equipment (workpiece and goods testing)",
        description="""X-ray fluoroscopy equipment (workpiece and goods testing)//Röntgendurchleuchtungseinrichtungen (Werkstück- und Warenprüfung)""",
    )

    dfg_4000_6 = VocabularyTerm(
        code="DFG_4000_6",
        label="4000 X-ray generators (structural research, materials testing)",
        description="""X-ray generators (structural research, materials testing)//Röntgengeneratoren (Strukturforschung, Werkstoffprüfung)""",
    )

    dfg_4000_7 = VocabularyTerm(
        code="DFG_4000_7",
        label="4000 X-ray equipment for materials analysis and testing",
        description="""X-ray equipment for materials analysis and testing//Röntgengeräte für Werkstoffanalyse und -prüfung""",
    )

    dfg_4010_1 = VocabularyTerm(
        code="DFG_4010_1",
        label="4010 Single crystal diffractometer",
        description="""Single crystal diffractometer//Einkristall-Diffraktometer""",
    )

    dfg_4010_2 = VocabularyTerm(
        code="DFG_4010_2",
        label="4010 Surface detector X-ray diffractometer (CCD, PDS)",
        description="""Surface detector X-ray diffractometer (CCD, PDS)//Flächendetektor-Röntgen-Diffraktometer (CCD, PDS)""",
    )

    dfg_4010_3 = VocabularyTerm(
        code="DFG_4010_3",
        label="4010 X-ray diffractometer",
        description="""X-ray diffractometer//Röntgendiffraktometer""",
    )

    dfg_4010_4 = VocabularyTerm(
        code="DFG_4010_4",
        label="4010 Four-circle diffractometer",
        description="""Four-circle diffractometer//Vierkreis-Diffraktometer""",
    )

    dfg_4011_1 = VocabularyTerm(
        code="DFG_4011_1",
        label="4011 Powder diffractometer (with Zhlrohr goniometer)",
        description="""Powder diffractometer (with Zhlrohr goniometer)//Pulverdiffraktometer (mit Zählrohr-Goniometer)""",
    )

    dfg_4011_2 = VocabularyTerm(
        code="DFG_4011_2",
        label="4011 Texture stress goniometer",
        description="""Texture stress goniometer//Textur-Spannungs-Goniometer""",
    )

    dfg_4020_1 = VocabularyTerm(
        code="DFG_4020_1",
        label="4020 Brier precession chambers, goniometers",
        description="""Brier precession chambers, goniometers//Bürger-Präzessions-Kammern, -Goniometer""",
    )

    dfg_4020_2 = VocabularyTerm(
        code="DFG_4020_2",
        label="4020 Debye-Shear cameras, cylinder chambers",
        description="""Debye-Shear cameras, cylinder chambers//Debye-Scherrer-Kameras, Zylinder-Kammern""",
    )

    dfg_4020_3 = VocabularyTerm(
        code="DFG_4020_3",
        label="4020 Flat chambers for X-ray structure studies",
        description="""Flat chambers for X-ray structure studies//Flachkammern für Röntgenstruktur-Untersuchungen""",
    )

    dfg_4020_4 = VocabularyTerm(
        code="DFG_4020_4",
        label="4020 Guinier chambers, Guinier-Simon chambers",
        description="""Guinier chambers, Guinier-Simon chambers//Guinier-Kammern, Guinier-Simon-Kammern""",
    )

    dfg_4020_5 = VocabularyTerm(
        code="DFG_4020_5",
        label="4020 High-pressure X-ray cameras (with diamond press-fittings)",
        description="""High-pressure X-ray cameras (with diamond press-fittings)//Hochdruck-Röntgenkameras (mit Diamant-Press-Stücken)""",
    )

    dfg_4020_6 = VocabularyTerm(
        code="DFG_4020_6",
        label="4020 High-temperature cameras (X-ray)",
        description="""High-temperature cameras (X-ray)//Hochtemperatur-Kameras (Röntgen)""",
    )

    dfg_4020_7 = VocabularyTerm(
        code="DFG_4020_7",
        label="4020 Small-angle cameras",
        description="""Small-angle cameras//Kleinwinkel-Kameras""",
    )

    dfg_4020_8 = VocabularyTerm(
        code="DFG_4020_8",
        label="4020 Kratky cameras",
        description="""Kratky cameras//Kratky-Kameras""",
    )

    dfg_4020_9 = VocabularyTerm(
        code="DFG_4020_9",
        label="4020 Long cameras (X-ray), X-ray micrography chambers",
        description="""Long cameras (X-ray), X-ray micrography chambers//Lang-Kameras (Röntgen-), Röntgenmikrographie-Kammern""",
    )

    dfg_4020_10 = VocabularyTerm(
        code="DFG_4020_10",
        label="4020 Precession chambers",
        description="""Precession chambers//Präzessionskammern""",
    )

    dfg_4020_11 = VocabularyTerm(
        code="DFG_4020_11",
        label="4020 Reciprocal Lattice Explorer",
        description="""Reciprocal Lattice Explorer//Reciprocal Lattice Explorer""",
    )

    dfg_4020_12 = VocabularyTerm(
        code="DFG_4020_12",
        label="4020 X-ray fine structure chambers, equipment (except diffractometer 4010)",
        description="""X-ray fine structure chambers, equipment (except diffractometer 4010)//Röntgenfeinstruktur-Kammern, -Anlagen (außer Diffraktometer 4010)""",
    )

    dfg_4020_13 = VocabularyTerm(
        code="DFG_4020_13",
        label="4020 X-ray cameras for fine structure and topography",
        description="""X-ray cameras for fine structure and topography//Röntgenkameras für Feinstruktur und Topographie""",
    )

    dfg_4020_14 = VocabularyTerm(
        code="DFG_4020_14",
        label="4020 X-ray vacuum cameras",
        description="""X-ray vacuum cameras//Röntgenvakuumkameras""",
    )

    dfg_4020_15 = VocabularyTerm(
        code="DFG_4020_15",
        label="4020 Low-temperature cameras (X-ray)",
        description="""Low-temperature cameras (X-ray)//Tieftemperatur-Kameras (Röntgen-)""",
    )

    dfg_4020_16 = VocabularyTerm(
        code="DFG_4020_16",
        label="4020 Weissenberg goniometer",
        description="""Weissenberg goniometer//Weißenberg-Goniometer""",
    )

    dfg_4030_1 = VocabularyTerm(
        code="DFG_4030_1",
        label="4030 Multichannel X-ray spectrometer (MRS)",
        description="""Multichannel X-ray spectrometer (MRS)//Mehrkanal-Röntgenspektrometer (MRS)""",
    )

    dfg_4030_2 = VocabularyTerm(
        code="DFG_4030_2",
        label="4030 Quantometer (X-ray)",
        description="""Quantometer (X-ray)//Quantometer (Röntgen)""",
    )

    dfg_4030_3 = VocabularyTerm(
        code="DFG_4030_3",
        label="4030 X-ray fluorescence spectrometer",
        description="""X-ray fluorescence spectrometer//Röntgenfluoreszenz-Spektrometer""",
    )

    dfg_4030_4 = VocabularyTerm(
        code="DFG_4030_4",
        label="4030 X-ray spectrometer",
        description="""X-ray spectrometer//Röntgenspektrometer""",
    )

    dfg_4030_5 = VocabularyTerm(
        code="DFG_4030_5",
        label="4030 X-ray vacuum spectrographs",
        description="""X-ray vacuum spectrographs//Röntgenvakuumspektrographen""",
    )

    dfg_4030_6 = VocabularyTerm(
        code="DFG_4030_6",
        label="4030 Sequence X-ray spectrometer (SRS)",
        description="""Sequence X-ray spectrometer (SRS)//Sequenz-Röntgenspektrometer (SRS)""",
    )

    dfg_4030_7 = VocabularyTerm(
        code="DFG_4030_7",
        label="4030 Simultaneous (multi-channel) X-ray spectrometers",
        description="""Simultaneous (multi-channel) X-ray spectrometers//Simultan- (Mehrkanal-) Röntgenspektrometer""",
    )

    dfg_4030_8 = VocabularyTerm(
        code="DFG_4030_8",
        label="4030 Vacuum X-ray spectrometer",
        description="""Vacuum X-ray spectrometer//Vakuumröntgenspektrometer""",
    )

    dfg_4040_1 = VocabularyTerm(
        code="DFG_4040_1",
        label="4040 Electron microprobe X-ray analysers",
        description="""Electron microprobe X-ray analysers//Electron-Microprobe-X-Ray-Analyzer""",
    )

    dfg_4040_2 = VocabularyTerm(
        code="DFG_4040_2",
        label="4040 Electron beam microanalysers",
        description="""Electron beam microanalysers//Elektronenstrahl-Mikroanalysatoren""",
    )

    dfg_4040_3 = VocabularyTerm(
        code="DFG_4040_3",
        label="4040 Electron beam X-ray spectrometers",
        description="""Electron beam X-ray spectrometers//Elektronenstrahl-Röntgenspektrometer""",
    )

    dfg_4040_4 = VocabularyTerm(
        code="DFG_4040_4",
        label="4040 Microanalysers (electron beam X-ray)",
        description="""Microanalysers (electron beam X-ray)//Mikroanalysatoren (Elektronenstrahl-Röntgen-)""",
    )

    dfg_4040_5 = VocabularyTerm(
        code="DFG_4040_5",
        label="4040 X-ray microprobes",
        description="""X-ray microprobes//Röntgenmikrosonden""",
    )

    dfg_4040_6 = VocabularyTerm(
        code="DFG_4040_6",
        label="4040 X-ray microanalyzers (microprobes)",
        description="""X-ray microanalyzers (microprobes)//X-Ray-Microanalyzer (Microprobes)""",
    )

    dfg_4050_1 = VocabularyTerm(
        code="DFG_4050_1",
        label="4050 Brag cells",
        description="""Brag cells//Bragzellen""",
    )

    dfg_4050_2 = VocabularyTerm(
        code="DFG_4050_2",
        label="4050 Euler scales",
        description="""Euler scales//Euler-Wiegen""",
    )

    dfg_4050_3 = VocabularyTerm(
        code="DFG_4050_3",
        label="4050 Eucentric goniometer probes",
        description="""Eucentric goniometer probes//Euzentrische Goniometerköpfe""",
    )

    dfg_4050_4 = VocabularyTerm(
        code="DFG_4050_4",
        label="4050 Goniometer heads (X-ray microprobes)",
        description="""Goniometer heads (X-ray microprobes)//Goniometer (Röntgen-Mikrosonden-)""",
    )

    dfg_4050_5 = VocabularyTerm(
        code="DFG_4050_5",
        label="4050 Goniometer heads (X-ray)",
        description="""Goniometer heads (X-ray)//Goniometer-Köpfe (Röntgen-)""",
    )

    dfg_4050_6 = VocabularyTerm(
        code="DFG_4050_6",
        label="4050 Measuring electronics and accessories for X-ray instruments",
        description="""Measuring electronics and accessories for X-ray instruments//Messelektronik und Zubehör für Röntgengeräte""",
    )

    dfg_4050_7 = VocabularyTerm(
        code="DFG_4050_7",
        label="4050 Tube holders for fine structure X-ray tubes",
        description="""Tube holders for fine structure X-ray tubes//Röhrenhalterungen für Feinstruktur-Röntgenröhren""",
    )

    dfg_4050_8 = VocabularyTerm(
        code="DFG_4050_8",
        label="4050 X-ray measuring electronics and accessories for structural research",
        description="""X-ray measuring electronics and accessories for structural research//Röntgenmesselektronik und Zubehör für Strukturforschung""",
    )

    dfg_4050_9 = VocabularyTerm(
        code="DFG_4050_9",
        label="4050 X-ray monochromators",
        description="""X-ray monochromators//Röntgenmonochromatoren""",
    )

    dfg_4050_10 = VocabularyTerm(
        code="DFG_4050_10",
        label="4050 Stepping switches (X-ray spectrometer)",
        description="""Stepping switches (X-ray spectrometer)//Schrittschaltwerke (Röntgenspektrometer-)""",
    )

    dfg_4060_1 = VocabularyTerm(
        code="DFG_4060_1",
        label="4060 Energy/wavelength dispersive X-ray analysers",
        description="""Energy/wavelength dispersive X-ray analysers//Energie-/Wellenlängen-dispersive Röntgenanalysegeräte""",
    )

    dfg_4060_2 = VocabularyTerm(
        code="DFG_4060_2",
        label="4060 Microanalysis apparatus (energy/wavelength dispersive)",
        description="""Microanalysis apparatus (energy/wavelength dispersive)//Mikroanalysegeräte, -Zusätze (Energie-/Wellenlängen-dispersiv)""",
    )

    dfg_4060_3 = VocabularyTerm(
        code="DFG_4060_3",
        label="4060 X-ray analysers",
        description="""X-ray analysers//Röntgenanalysengeräte""",
    )

    dfg_4060_4 = VocabularyTerm(
        code="DFG_4060_4",
        label="4060 Wavelength/energy dispersive X-ray analysers",
        description="""Wavelength/energy dispersive X-ray analysers//Wellenlängen-/Energie-dispersive Röntgenanalysegeräte""",
    )

    dfg_4070_1 = VocabularyTerm(
        code="DFG_4070_1",
        label="4070 CT (computed tomography) scanners (X-ray tomography) for materials science",
        description="""CT (computed tomography) scanners (X-ray tomography) for materials science//CT-(Computertomographie-) Geräte (Röntgen-Tomographie) für Materialwissenschaft""",
    )

    dfg_4070_2 = VocabularyTerm(
        code="DFG_4070_2",
        label="4070 Microradiography chambers (contact microradiography)",
        description="""Microradiography chambers (contact microradiography)//Mikroradiographiekammern (Kontakt-Mikroradiographie)""",
    )

    dfg_4070_3 = VocabularyTerm(
        code="DFG_4070_3",
        label="4070 X-ray flash equipment (except medicine 3210)",
        description="""X-ray flash equipment (except medicine 3210)//Röntgenblitz-Anlagen (außer Medizin 3210)""",
    )

    dfg_4070_4 = VocabularyTerm(
        code="DFG_4070_4",
        label="4070 X-ray equipment for structural analysis (except 4000-4060)",
        description="""X-ray equipment for structural analysis (except 4000-4060)//Röntgengeräte für Strukturanalyse (außer 4000-4060)""",
    )

    dfg_4070_5 = VocabularyTerm(
        code="DFG_4070_5",
        label="4070 X-ray macro probes",
        description="""X-ray macro probes//Röntgenmakrosonden""",
    )

    dfg_4070_6 = VocabularyTerm(
        code="DFG_4070_6",
        label="4070 X-ray reflex viewers",
        description="""X-ray reflex viewers//Röntgen-Reflexsichtgeräte""",
    )

    dfg_4070_7 = VocabularyTerm(
        code="DFG_4070_7",
        label="4070 Special X-ray instruments for material analysis, structure research, material irradiation",
        description="""Special X-ray instruments for material analysis, structure research, material irradiation//Spezielle Röntgengeräte für Material-Analyse, Strukturforschung, Werkstoff-Bestrahlung""",
    )

    dfg_4070_8 = VocabularyTerm(
        code="DFG_4070_8",
        label="4070 Texture goniometer (X-ray)",
        description="""Texture goniometer (X-ray)//Textur-Goniometer (Röntgen)""",
    )

    dfg_4080_1 = VocabularyTerm(
        code="DFG_4080_1",
        label="4080 Evaluation instruments for X-ray structure analysis (except densitometer 5230)",
        description="""Evaluation instruments for X-ray structure analysis (except densitometer 5230)//Auswertegeräte für Röntgenstrukturanalyse (außer Densitometer 5230)""",
    )

    dfg_4080_2 = VocabularyTerm(
        code="DFG_4080_2",
        label="4080 Diffraction measuring instruments (X-ray evaluators)",
        description="""Diffraction measuring instruments (X-ray evaluators)//Diffraktionsmessgeräte (Röntgen-Auswertegeräte)""",
    )

    dfg_4080_3 = VocabularyTerm(
        code="DFG_4080_3",
        label="4080 Measuring tables for diffraction diagrams",
        description="""Measuring tables for diffraction diagrams//Messtische für Diffraktions-Diagramme""",
    )

    dfg_4090_1 = VocabularyTerm(
        code="DFG_4090_1",
        label="4090 X-ray tubes and other X-ray instruments",
        description="""X-ray tubes and other X-ray instruments//Röntgenröhren und sonstige Röntgengeräte""",
    )

    dfg_4090_2 = VocabularyTerm(
        code="DFG_4090_2",
        label="4090 X-ray tubes (X-ray tubes)",
        description="""X-ray tubes (X-ray tubes)//Röntgenstrahler (Röntgenröhren)""",
    )

    dfg_4100_1 = VocabularyTerm(
        code="DFG_4100_1",
        label="4100 EC measuring instruments (elasticity, damping)",
        description="""EC measuring instruments (elasticity, damping)//EG-Messgeräte (Elastizität, Dämpfung)""",
    )

    dfg_4100_2 = VocabularyTerm(
        code="DFG_4100_2",
        label="4100 Elasticity, stress and damping measuring instruments",
        description="""Elasticity, stress and damping measuring instruments//Elastizitäts-, Spannungs- und Dämpfungsmessgeräte""",
    )

    dfg_4100_3 = VocabularyTerm(
        code="DFG_4100_3",
        label="4100 Mechanical spectrometers",
        description="""Mechanical spectrometers//Mechanische Spektrometer""",
    )

    dfg_4110_1 = VocabularyTerm(
        code="DFG_4110_1",
        label="4110 Acoustic emission analysers",
        description="""Acoustic emission analysers//Geräte zur Schallemissionsanalyse""",
    )

    dfg_4120_1 = VocabularyTerm(
        code="DFG_4120_1",
        label="4120 Acoustic holographic instruments",
        description="""Acoustic holographic instruments//Akustische Holographiegeräte""",
    )

    dfg_4120_2 = VocabularyTerm(
        code="DFG_4120_2",
        label="4120 Concrete and cement testers (ultrasonic testers)",
        description="""Concrete and cement testers (ultrasonic testers)//Beton- und Zementprüfgeräte (Ultraschallgeräte)""",
    )

    dfg_4120_3 = VocabularyTerm(
        code="DFG_4120_3",
        label="4120 Impulse holographic testers",
        description="""Impulse holographic testers//Impulsechomessgeräte""",
    )

    dfg_4120_4 = VocabularyTerm(
        code="DFG_4120_4",
        label="4120 Ultrasonic holographic testers",
        description="""Ultrasonic holographic testers//Ultraschall-Holographiegeräte""",
    )

    dfg_4120_5 = VocabularyTerm(
        code="DFG_4120_5",
        label="4120 Ultrasonic material testers",
        description="""Ultrasonic material testers//Ultraschall-Materialprüfgeräte""",
    )

    dfg_4130_1 = VocabularyTerm(
        code="DFG_4130_1",
        label="4130 Thickness gauges (magnetic, eddy current; mechanical see 8700).",
        description="""`Thickness gauges (magnetic, eddy current; mechanical see 8700)`.//Dickenmessgeräte (magnetisch, Wirbelstrom; mechanische siehe 8700)""",
    )

    dfg_4130_2 = VocabularyTerm(
        code="DFG_4130_2",
        label="4130 Thickness gauges using nuclear radiation",
        description="""Thickness gauges using nuclear radiation//Dickenmessgeräte mittels Kernstrahlung""",
    )

    dfg_4130_3 = VocabularyTerm(
        code="DFG_4130_3",
        label="4130 Weight-per-area measuring instruments",
        description="""Weight-per-area measuring instruments//Flächengewichts-Messeinrichtungen""",
    )

    dfg_4130_4 = VocabularyTerm(
        code="DFG_4130_4",
        label="4130 Pore testers for paints and coatings",
        description="""Pore testers for paints and coatings//Porenprüfgeräte für Lacke und Beschichtungen""",
    )

    dfg_4130_5 = VocabularyTerm(
        code="DFG_4130_5",
        label="4130 Coating thickness gauges (except ellipsometer 5360, vacuum evaporation 8380)",
        description="""Coating thickness gauges (except ellipsometer 5360, vacuum evaporation 8380)//Schichtdickenmessgeräte (außer Ellipsometer 5360, Vakuumbedampfung 8380)""",
    )

    dfg_4140_1 = VocabularyTerm(
        code="DFG_4140_1",
        label="4140 Flaw detectors (crack detection), electrical or magnetic",
        description="""Flaw detectors (crack detection), electrical or magnetic//Fehlerprüfgeräte (Rissprüfung), elektrische oder magnetische""",
    )

    dfg_4140_2 = VocabularyTerm(
        code="DFG_4140_2",
        label="4140 Direct current potential (PSV) crack detectors",
        description="""Direct current potential (PSV) crack detectors//Gleichstrom-Potenzialsonden- (PSV) Geräte (Rissprüfung)""",
    )

    dfg_4140_3 = VocabularyTerm(
        code="DFG_4140_3",
        label="4140 Kelvin probes (corrosion test)",
        description="""Kelvin probes (corrosion test)//Kelvin-Sonden (Korrosionsprüfung)""",
    )

    dfg_4140_4 = VocabularyTerm(
        code="DFG_4140_4",
        label="4140 Crack detectors (electrical, magnetic)",
        description="""Crack detectors (electrical, magnetic)//Rissprüfgeräte (elektrische, magnetische)""",
    )

    dfg_4140_5 = VocabularyTerm(
        code="DFG_4140_5",
        label="4140 Eddy current material testers (crack detection)",
        description="""Eddy current material testers (crack detection)//Wirbelstrom-Materialprüfgeräte (Rissprüfung)""",
    )

    dfg_4150_1 = VocabularyTerm(
        code="DFG_4150_1",
        label="4150 Flatness testers",
        description="""Flatness testers//Ebenheitsprüfer""",
    )

    dfg_4150_2 = VocabularyTerm(
        code="DFG_4150_2",
        label="4150 Surface testers (profile, roughness)",
        description="""Surface testers (profile, roughness)//Oberflächen-Prüfgeräte (Profil,Rauhtiefe)""",
    )

    dfg_4150_3 = VocabularyTerm(
        code="DFG_4150_3",
        label="4150 Perthometer (R) (roughness, profile)",
        description="""Perthometer (R) (roughness, profile)//Perthometer (R) (Rauhtiefe, Profil)""",
    )

    dfg_4150_4 = VocabularyTerm(
        code="DFG_4150_4",
        label="4150 Roughness gauges",
        description="""Roughness gauges//Rauhtiefemessgeräte""",
    )

    dfg_4170_1 = VocabularyTerm(
        code="DFG_4170_1",
        label="4170 Line detectors (metal detectors)",
        description="""Line detectors (metal detectors)//Leitungssuchgeräte (Metallsuchgeräte)""",
    )

    dfg_4170_2 = VocabularyTerm(
        code="DFG_4170_2",
        label="4170 Metal detector",
        description="""Metal detector//Metallsuchgeräte""",
    )

    dfg_4180_1 = VocabularyTerm(
        code="DFG_4180_1",
        label="4180 Flash point testers",
        description="""Flash point testers//Flammpunktprüfer""",
    )

    dfg_4180_2 = VocabularyTerm(
        code="DFG_4180_2",
        label="4180 Test equipment for safety-related material and device properties",
        description="""Test equipment for safety-related material and device properties//Prüfgeräte für sicherheitstechnische Stoff- und Geräteeigenschaften""",
    )

    dfg_4190_1 = VocabularyTerm(
        code="DFG_4190_1",
        label="4190 Microstructure measuring systems",
        description="""Microstructure measuring systems//Mikrostruktur-Messsysteme""",
    )

    dfg_4190_2 = VocabularyTerm(
        code="DFG_4190_2",
        label="4190 Surface simulation systems",
        description="""Surface simulation systems//Oberflächen-Simulations-Syteme""",
    )

    dfg_4190_3 = VocabularyTerm(
        code="DFG_4190_3",
        label="4190 Special devices for microsystems technology",
        description="""Special devices for microsystems technology//Spezielle Geräte der Mikrosystemtechnik""",
    )

    dfg_4300_1 = VocabularyTerm(
        code="DFG_4300_1",
        label="4300 Seed drills, parcel drills",
        description="""Seed drills, parcel drills//Drillmaschinen, Parzellendrillmaschinen""",
    )

    dfg_4300_2 = VocabularyTerm(
        code="DFG_4300_2",
        label="4300 Fertiliser spreaders",
        description="""Fertiliser spreaders//Düngerstreuer""",
    )

    dfg_4300_3 = VocabularyTerm(
        code="DFG_4300_3",
        label="4300 Harvesters",
        description="""Harvesters//Erntemaschinen""",
    )

    dfg_4300_4 = VocabularyTerm(
        code="DFG_4300_4",
        label="4300 Agricultural machinery",
        description="""Agricultural machinery//Landwirtschaftliche Bearbeitungsmaschinen""",
    )

    dfg_4300_5 = VocabularyTerm(
        code="DFG_4300_5",
        label="4300 Agricultural machinery (field work)",
        description="""Agricultural machinery (field work)//Landwirtschaftliche Maschinen (Feldarbeit)""",
    )

    dfg_4300_6 = VocabularyTerm(
        code="DFG_4300_6",
        label="4300 Planting and harvesting machinery",
        description="""Planting and harvesting machinery//Pflück- und Erntemaschinen""",
    )

    dfg_4300_7 = VocabularyTerm(
        code="DFG_4300_7",
        label="4300 Weed control equipment",
        description="""Weed control equipment//Unkrautbekämpfungsgeräte""",
    )

    dfg_4310_1 = VocabularyTerm(
        code="DFG_4310_1",
        label="4310 Pest control equipment",
        description="""Pest control equipment//Geräte zur Schädlingsbekämpfung""",
    )

    dfg_4310_2 = VocabularyTerm(
        code="DFG_4310_2",
        label="4310 Sprayers (pest control, except 9920)",
        description="""Sprayers (pest control, except 9920)//Spritzgeräte (Schädlingsbekämpfung, außer 9920)""",
    )

    dfg_4320_1 = VocabularyTerm(
        code="DFG_4320_1",
        label="4320 Crop cultivating implements",
        description="""Crop cultivating implements//Geräte zur Bearbeitung von landwirtschaftlichen Feldprodukten""",
    )

    dfg_4320_2 = VocabularyTerm(
        code="DFG_4320_2",
        label="4320 Grain-squeezing machines",
        description="""Grain-squeezing machines//Getreide-Quetschmaschinen""",
    )

    dfg_4320_3 = VocabularyTerm(
        code="DFG_4320_3",
        label="4320 Grain-sorting machines, -drying machines",
        description="""Grain-sorting machines, -drying machines//Getreide-Sortiermaschinen, -Trocknungsanlagen""",
    )

    dfg_4320_4 = VocabularyTerm(
        code="DFG_4320_4",
        label="4320 Chopping machines",
        description="""Chopping machines//Häckselmaschinen""",
    )

    dfg_4320_5 = VocabularyTerm(
        code="DFG_4320_5",
        label="4320 Cutter for rape",
        description="""Cutter for rape//Rübenschneider""",
    )

    dfg_4320_6 = VocabularyTerm(
        code="DFG_4320_6",
        label="4320 Seed cleaning equipment",
        description="""Seed cleaning equipment//Saatgutreinigungsanlagen""",
    )

    dfg_4320_7 = VocabularyTerm(
        code="DFG_4320_7",
        label="4320 Straw balers",
        description="""Straw balers//Strohpressen""",
    )

    dfg_4330_1 = VocabularyTerm(
        code="DFG_4330_1",
        label="4330 Fodder dampers, plants",
        description="""Fodder dampers, plants//Futterdämpfer, -anlagen""",
    )

    dfg_4330_2 = VocabularyTerm(
        code="DFG_4330_2",
        label="4330 Fodder machinery (except 1000-1090 and 1980)",
        description="""Fodder machinery (except 1000-1090 and 1980)//Futtermittelmaschinen (außer 1000-1090 und 1980)""",
    )

    dfg_4330_3 = VocabularyTerm(
        code="DFG_4330_3",
        label="4330 Feed processing machinery",
        description="""Feed processing machinery//Maschinen zur Bearbeitung von Futtermitteln""",
    )

    dfg_4330_4 = VocabularyTerm(
        code="DFG_4330_4",
        label="4330 Pelleting machinery (for animal feed)",
        description="""Pelleting machinery (for animal feed)//Pelletiermaschinen (für Tierfutter)""",
    )

    dfg_4340_1 = VocabularyTerm(
        code="DFG_4340_1",
        label="4340 Brooding machines for poultry farming",
        description="""Brooding machines for poultry farming//Brutmaschinen für Geflügelzucht""",
    )

    dfg_4340_2 = VocabularyTerm(
        code="DFG_4340_2",
        label="4340 Electric fences",
        description="""Electric fences//Elektrozäune""",
    )

    dfg_4340_3 = VocabularyTerm(
        code="DFG_4340_3",
        label="4340 Milking machines",
        description="""Milking machines//Melkmaschinen""",
    )

    dfg_4340_4 = VocabularyTerm(
        code="DFG_4340_4",
        label="4340 Self-trimming machines",
        description="""Self-trimming machines//Selbsttränken""",
    )

    dfg_4340_5 = VocabularyTerm(
        code="DFG_4340_5",
        label="4340 Special farm animal husbandry equipment (except 9910)",
        description="""Special farm animal husbandry equipment (except 9910)//Spezielle Einrichtungen für landwirtschaftliche Tierhaltung (außer 9910)""",
    )

    dfg_4350_1 = VocabularyTerm(
        code="DFG_4350_1",
        label="4350 Egg sorting machines",
        description="""Egg sorting machines//Eiersortiermaschinen""",
    )

    dfg_4350_2 = VocabularyTerm(
        code="DFG_4350_2",
        label="4350 Sorting machines for fruit, vegetables",
        description="""Sorting machines for fruit, vegetables//Sortieranlagen für Obst, Gemüse""",
    )

    dfg_4350_3 = VocabularyTerm(
        code="DFG_4350_3",
        label="4350 Special equipment for food processing",
        description="""Special equipment for food processing//Spezielle Geräte für Verarbeitung von Lebensmitteln""",
    )

    dfg_4360_1 = VocabularyTerm(
        code="DFG_4360_1",
        label="4360 Special equipment for dairy and beverage processing (except 1200-1320, 1570,1580)",
        description="""Special equipment for dairy and beverage processing (except 1200-1320, 1570,1580)//Spezielle Geräte für Milchwirtschaft und Getränkeverarbeitung (außer 1200-1320, 1570,1580)""",
    )

    dfg_4370_1 = VocabularyTerm(
        code="DFG_4370_1",
        label="4370 Dendrometers, tree-ring measuring machines",
        description="""Dendrometers, tree-ring measuring machines//Dendrometer, Jahrring-Messmaschinen""",
    )

    dfg_4370_2 = VocabularyTerm(
        code="DFG_4370_2",
        label="4370 Tree-ring measuring machines",
        description="""Tree-ring measuring machines//Jahrring-Messmaschinen""",
    )

    dfg_4370_3 = VocabularyTerm(
        code="DFG_4370_3",
        label="4370 Special forestry measuring and testing equipment",
        description="""Special forestry measuring and testing equipment//Spezielle forstwirtschaftliche Mess- und Prüfgeräte""",
    )

    dfg_4380_1 = VocabularyTerm(
        code="DFG_4380_1",
        label="4380 Engine-genes, beating machines and other forestry working machines",
        description="""Engine-genes, beating machines and other forestry working machines//Motorsägen, Schälmaschinen und andere forstwirtschaftliche Arbeitsmaschinen""",
    )

    dfg_4390_1 = VocabularyTerm(
        code="DFG_4390_1",
        label="4390 Other equipment for agricultural and forestry science (except 4300-4380)",
        description="""Other equipment for agricultural and forestry science (except 4300-4380)//Sonstige Geräte für Landwirtschafts- und Forstwissenschaft (außer 4300-4380)""",
    )

    dfg_4400_1 = VocabularyTerm(
        code="DFG_4400_1",
        label="4400 Climatic chambers for biology, medicine (except walk-in 9830 or material testing 2980)",
        description="""Climatic chambers for biology, medicine (except walk-in 9830 or material testing 2980)//Klimakammern für Biologie, Medizin (außer begehbare 9830 oder Materialprüfung 2980)""",
    )

    dfg_4400_2 = VocabularyTerm(
        code="DFG_4400_2",
        label="4400 Plant growth chambers and cabinets, climatic test facilities for biology and medicine",
        description="""Plant growth chambers and cabinets, climatic test facilities for biology and medicine//Pflanzenwuchskammern und -schränke, Klimaversuchsanlagen für Biologie, und Medizin""",
    )

    dfg_4400_3 = VocabularyTerm(
        code="DFG_4400_3",
        label="4400 Phytotrons",
        description="""Phytotrons//Phytotrone""",
    )

    dfg_4410_1 = VocabularyTerm(
        code="DFG_4410_1",
        label="4410 Gas exchange chambers",
        description="""Gas exchange chambers//Gaswechselmesskammern""",
    )

    dfg_4420_1 = VocabularyTerm(
        code="DFG_4420_1",
        label="4420 Lysimeters",
        description="""Lysimeters//Lysimeter""",
    )

    dfg_4430_1 = VocabularyTerm(
        code="DFG_4430_1",
        label="4430 Soil moisture, soil density meters",
        description="""Soil moisture, soil density meters//Bodenfeuchte-, Bodendichtemessgeräte""",
    )

    dfg_4430_2 = VocabularyTerm(
        code="DFG_4430_2",
        label="4430 Centrifugal time (CST) meters (capillary time of flow of mud)",
        description="""Centrifugal time (CST) meters (capillary time of flow of mud)//Fließzeit (CST)-Messgeräte (kapillare Fließzeit von Schlamm)""",
    )

    dfg_4430_3 = VocabularyTerm(
        code="DFG_4430_3",
        label="4430 Penetrographs, field penetrometers (soil density and compressibility)",
        description="""Penetrographs, field penetrometers (soil density and compressibility)//Penetrographen, Feld-Penetrometer (Bodendichte und -kompressibilität)""",
    )

    dfg_4430_4 = VocabularyTerm(
        code="DFG_4430_4",
        label="4430 Permeameter (water conductivity of soil)",
        description="""Permeameter (water conductivity of soil)//Permeameter (Wasserleitfähigkeit des Bodens)""",
    )

    dfg_4430_5 = VocabularyTerm(
        code="DFG_4430_5",
        label="4430 Tensiometers (water vapour tension in soil)",
        description="""Tensiometers (water vapour tension in soil)//Tensiometer (Wasserdampfspannung im Boden)""",
    )

    dfg_4430_6 = VocabularyTerm(
        code="DFG_4430_6",
        label="4430 Water conductivity meters (soil conductivity)",
        description="""Water conductivity meters (soil conductivity)//Wasserleitfähigkeits-Messgeräte (Leitfähigkeit des Bodens)""",
    )

    dfg_4440_1 = VocabularyTerm(
        code="DFG_4440_1",
        label="4440 Fishing rods",
        description="""Fishing rods//Angeln""",
    )

    dfg_4440_2 = VocabularyTerm(
        code="DFG_4440_2",
        label="4440 Soil grabs (hydrobiology)",
        description="""Soil grabs (hydrobiology)//Bodengreifer (Hydrobiologie)""",
    )

    dfg_4440_3 = VocabularyTerm(
        code="DFG_4440_3",
        label="4440 Soil testing equipment (biology) and hydrobiological sampling equipment (except 0430 and 4430)",
        description="""Soil testing equipment (biology) and hydrobiological sampling equipment (except 0430 and 4430)//Bodenuntersuchungsgeräte (Biologie) und hydrobiologische Probenahmegeräte (außer 0430 und 4430)""",
    )

    dfg_4440_4 = VocabularyTerm(
        code="DFG_4440_4",
        label="4440 Dredges",
        description="""Dredges//Dredgen""",
    )

    dfg_4440_5 = VocabularyTerm(
        code="DFG_4440_5",
        label="4440 Fishing gear, electric",
        description="""Fishing gear, electric//Fischfanggeräte, elektrisch""",
    )

    dfg_4440_6 = VocabularyTerm(
        code="DFG_4440_6",
        label="4440 Hunting equipment (except arms 9980)",
        description="""Hunting equipment (except arms 9980)//Jagdausrüstung (außer Waffen 9980)""",
    )

    dfg_4440_7 = VocabularyTerm(
        code="DFG_4440_7",
        label="4440 Multiple closing nets",
        description="""Multiple closing nets//Mehrfach-Schließnetze""",
    )

    dfg_4440_8 = VocabularyTerm(
        code="DFG_4440_8",
        label="4440 Nets (for fishing and hydrobiology)",
        description="""Nets (for fishing and hydrobiology)//Netze (für Fischerei und Hydrobiologie)""",
    )

    dfg_4440_9 = VocabularyTerm(
        code="DFG_4440_9",
        label="4440 Plankton fishing gear, nets",
        description="""Plankton fishing gear, nets//Planktonfanggeräte, -netze""",
    )

    dfg_4440_10 = VocabularyTerm(
        code="DFG_4440_10",
        label="4440 Mud dredgers (seabed samplers)",
        description="""Mud dredgers (seabed samplers)//Schlammbagger (Seeboden-Probenehmer)""",
    )

    dfg_4440_11 = VocabularyTerm(
        code="DFG_4440_11",
        label="4440 Silt bottles (water samplers), shovels",
        description="""Silt bottles (water samplers), shovels//Schöpfflaschen (Wasserprobenehmer), Schöpfer""",
    )

    dfg_4440_12 = VocabularyTerm(
        code="DFG_4440_12",
        label="4440 Sediment samplers (except 0430)",
        description="""Sediment samplers (except 0430)//Sedimentprobenehmer (außer 0430)""",
    )

    dfg_4450_1 = VocabularyTerm(
        code="DFG_4450_1",
        label="4450 Collecting and fishing gear (except 4440)",
        description="""Collecting and fishing gear (except 4440)//Sammelgeräte, Fanggeräte (außer 4440)""",
    )

    dfg_4470_1 = VocabularyTerm(
        code="DFG_4470_1",
        label="4470 Anthropological examination equipment",
        description="""Anthropological examination equipment//Anthropologische Untersuchungsgeräte""",
    )

    dfg_4490_1 = VocabularyTerm(
        code="DFG_4490_1",
        label="4490 Other biological instruments (except 3000-3990, 4400-4470, 4600-4690)",
        description="""Other biological instruments (except 3000-3990, 4400-4470, 4600-4690)//Sonstige Geräte der Biologie (außer 3000-3990, 4400-4470, 4600-4690)""",
    )

    dfg_4600_1 = VocabularyTerm(
        code="DFG_4600_1",
        label="4600 Freezing microtomes",
        description="""Freezing microtomes//Gefriermikrotome""",
    )

    dfg_4600_2 = VocabularyTerm(
        code="DFG_4600_2",
        label="4600 Tissue choppers (tissue cutting instruments)",
        description="""Tissue choppers (tissue cutting instruments)//Gewebeschneidegeräte (Tissue-Chopper)""",
    )

    dfg_4600_3 = VocabularyTerm(
        code="DFG_4600_3",
        label="4600 Base slide microtomes",
        description="""Base slide microtomes//Grundschlittenmikrotome""",
    )

    dfg_4600_4 = VocabularyTerm(
        code="DFG_4600_4",
        label="4600 Hard section microtomes",
        description="""Hard section microtomes//Hartschnittmikrotome""",
    )

    dfg_4600_5 = VocabularyTerm(
        code="DFG_4600_5",
        label="4600 Cryostat microtomes",
        description="""Cryostat microtomes//Kryostat-Mikrotome""",
    )

    dfg_4600_6 = VocabularyTerm(
        code="DFG_4600_6",
        label="4600 Cryotomes",
        description="""Cryotomes//Kryotome""",
    )

    dfg_4600_7 = VocabularyTerm(
        code="DFG_4600_7",
        label="4600 Microtomes, ultramicrotomes",
        description="""Microtomes, ultramicrotomes//Mikrotome, Ultramikrotome""",
    )

    dfg_4600_8 = VocabularyTerm(
        code="DFG_4600_8",
        label="4600 Rotational microtomes",
        description="""Rotational microtomes//Rotationsmikrotome""",
    )

    dfg_4600_9 = VocabularyTerm(
        code="DFG_4600_9",
        label="4600 Vibratomes (microtomy)",
        description="""Vibratomes (microtomy)//Vibratome (Mikrotomie)""",
    )

    dfg_4610_1 = VocabularyTerm(
        code="DFG_4610_1",
        label="4610 Knifemakers (Knife breakers)",
        description="""Knifemakers (Knife breakers)//Messerbrechgeräte (Knifemaker)""",
    )

    dfg_4610_2 = VocabularyTerm(
        code="DFG_4610_2",
        label="4610 Microtome knives, microtome tubes",
        description="""Microtome knives, microtome tubes//Mikrotommesser, Mikrotom-Zubehör""",
    )

    dfg_4610_3 = VocabularyTerm(
        code="DFG_4610_3",
        label="4610 Pyratomes",
        description="""Pyratomes//Pyratome""",
    )

    dfg_4610_4 = VocabularyTerm(
        code="DFG_4610_4",
        label="4610 Trimming tools and other accessories for ultramicrotomes",
        description="""Trimming tools and other accessories for ultramicrotomes//Trimmgeräte und andere Zubehörgeräte für Ultramikrotome""",
    )

    dfg_4630_1 = VocabularyTerm(
        code="DFG_4630_1",
        label="4630 Diamond cutting and shaping machines",
        description="""Diamond cutting and shaping machines//Diamantsägen, -sägemaschinen""",
    )

    dfg_4630_2 = VocabularyTerm(
        code="DFG_4630_2",
        label="4630 Internal hole saws",
        description="""Internal hole saws//Innenlochsägen""",
    )

    dfg_4630_3 = VocabularyTerm(
        code="DFG_4630_3",
        label="4630 Crystal sawing machines",
        description="""Crystal sawing machines//Kristall-Sägemaschinen""",
    )

    dfg_4630_4 = VocabularyTerm(
        code="DFG_4630_4",
        label="4630 Diamond scribers for semiconductor wafers",
        description="""Diamond scribers for semiconductor wafers//Ritzgeräte (Diamant-Ritzgeräte) für Halbleiterscheiben""",
    )

    dfg_4630_5 = VocabularyTerm(
        code="DFG_4630_5",
        label="4630 Microtomes",
        description="""Microtomes//Sägemikrotome""",
    )

    dfg_4640_1 = VocabularyTerm(
        code="DFG_4640_1",
        label="4640 Grinding and polishing machines (for laboratories)",
        description="""Grinding and polishing machines (for laboratories)//Schleif- und Poliermaschinen (für Labors)""",
    )

    dfg_4660_1 = VocabularyTerm(
        code="DFG_4660_1",
        label="4660 Chip positioning and mounting equipment",
        description="""Chip positioning and mounting equipment//Chip-Positionier- und -Montiergeräte""",
    )

    dfg_4660_2 = VocabularyTerm(
        code="DFG_4660_2",
        label="4660 Capillary extractors",
        description="""Capillary extractors//Kapillarausziehgeräte""",
    )

    dfg_4660_3 = VocabularyTerm(
        code="DFG_4660_3",
        label="4660 Microdissection systems",
        description="""Microdissection systems//Mikrodissektions-Systeme""",
    )

    dfg_4660_4 = VocabularyTerm(
        code="DFG_4660_4",
        label="4660 Micromanipulators, electrode pullers, microsmithing equipment",
        description="""Micromanipulators, electrode pullers, microsmithing equipment//Mikromanipulatoren, Elektrodenziehgeräte, Mikroschmieden""",
    )

    dfg_4670_1 = VocabularyTerm(
        code="DFG_4670_1",
        label="4670 Anaerobic chambers",
        description="""Anaerobic chambers//Anaerobe Kammern""",
    )

    dfg_4670_2 = VocabularyTerm(
        code="DFG_4670_2",
        label="4670 Glove boxes",
        description="""Glove boxes//Glove-Boxen""",
    )

    dfg_4670_3 = VocabularyTerm(
        code="DFG_4670_3",
        label="4670 Glove boxes, inert gas systems",
        description="""Glove boxes, inert gas systems//Handschuhkästen, Schutzgasanlagen""",
    )

    dfg_4670_4 = VocabularyTerm(
        code="DFG_4670_4",
        label="4670 Inert Gas Systems (Glove Boxes)",
        description="""Inert Gas Systems (Glove Boxes)//Inertgas-Anlagen (Handschuhkästen)""",
    )

    dfg_4680_1 = VocabularyTerm(
        code="DFG_4680_1",
        label="4680 Downdraft, Recirculating Air Workplaces",
        description="""Downdraft, Recirculating Air Workplaces//Fallstrom-, Umluft- Arbeitsplätze""",
    )

    dfg_4680_2 = VocabularyTerm(
        code="DFG_4680_2",
        label="4680 Horizontal flow boxes, cross flow boxes",
        description="""Horizontal flow boxes, cross flow boxes//Horizontalstrombänke, Querstrombänke""",
    )

    dfg_4680_3 = VocabularyTerm(
        code="DFG_4680_3",
        label="4680 Laminar flow boxes, plants",
        description="""Laminar flow boxes, plants//Laminarstrom-Boxen, -Werkbänke""",
    )

    dfg_4680_4 = VocabularyTerm(
        code="DFG_4680_4",
        label="4680 Microbiological safety booths",
        description="""Microbiological safety booths//Mikrobiologische Sicherheitskabinen""",
    )

    dfg_4680_5 = VocabularyTerm(
        code="DFG_4680_5",
        label="4680 Pure work benches, laminar flow benches",
        description="""Pure work benches, laminar flow benches//Reine Werkbänke, Laminar-Flow-Bänke""",
    )

    dfg_4680_6 = VocabularyTerm(
        code="DFG_4680_6",
        label="4680 Circulating-air workplaces",
        description="""Circulating-air workplaces//Umluft-Arbeitplätze""",
    )

    dfg_4690_1 = VocabularyTerm(
        code="DFG_4690_1",
        label="4690 Precious metal laboratory equipment (except 1000-1990)",
        description="""Precious metal laboratory equipment (except 1000-1990)//Edelmetall-Laborgeräte (außer 1000-1990)""",
    )

    dfg_4690_2 = VocabularyTerm(
        code="DFG_4690_2",
        label="4690 Moulds for samples (spectroscopy, X-ray)",
        description="""Moulds for samples (spectroscopy, X-ray)//Gießformen für Proben (Spektroskopie, Röntgen)""",
    )

    dfg_4690_3 = VocabularyTerm(
        code="DFG_4690_3",
        label="4690 Other equipment for specimen processing, laboratory equipment of precious metal",
        description="""Other equipment for specimen processing, laboratory equipment of precious metal//Sonstige Geräte für Probenbearbeitung, Laborgeräte aus Edelmetall""",
    )

    dfg_5000_1 = VocabularyTerm(
        code="DFG_5000_1",
        label="5000 Reflected light microscopes",
        description="""Reflected light microscopes//Auflichtmikroskope""",
    )

    dfg_5000_2 = VocabularyTerm(
        code="DFG_5000_2",
        label="5000 Transmitted light microscopes",
        description="""Transmitted light microscopes//Durchlichtmikroskope""",
    )

    dfg_5000_3 = VocabularyTerm(
        code="DFG_5000_3",
        label="5000 Fluorescence microscopes",
        description="""Fluorescence microscopes//Fluoreszenzmikroskope""",
    )

    dfg_5000_4 = VocabularyTerm(
        code="DFG_5000_4",
        label="5000 Heating table microscopes",
        description="""Heating table microscopes//Heiztischmikroskope""",
    )

    dfg_5000_5 = VocabularyTerm(
        code="DFG_5000_5",
        label="5000 Course microscopes",
        description="""Course microscopes//Kursmikroskope""",
    )

    dfg_5000_6 = VocabularyTerm(
        code="DFG_5000_6",
        label="5000 Laboratory microscopes",
        description="""Laboratory microscopes//Labormikroskope""",
    )

    dfg_5000_7 = VocabularyTerm(
        code="DFG_5000_7",
        label="5000 Phase contrast microscopes",
        description="""Phase contrast microscopes//Phasenkontrastmikroskope""",
    )

    dfg_5000_8 = VocabularyTerm(
        code="DFG_5000_8",
        label="5000 Polarisation microscopes",
        description="""Polarisation microscopes//Polarisationsmikroskope""",
    )

    dfg_5000_9 = VocabularyTerm(
        code="DFG_5000_9",
        label="5000 Preparation microscopes",
        description="""Preparation microscopes//Präparationsmikroskope""",
    )

    dfg_5010_1 = VocabularyTerm(
        code="DFG_5010_1",
        label="5010 Camera microscopes",
        description="""Camera microscopes//Kameramikroskope""",
    )

    dfg_5010_2 = VocabularyTerm(
        code="DFG_5010_2",
        label="5010 Macroscopes",
        description="""Macroscopes//Makroskope""",
    )

    dfg_5010_3 = VocabularyTerm(
        code="DFG_5010_3",
        label="5010 Photomicroscopes",
        description="""Photomicroscopes//Photomikroskope""",
    )

    dfg_5020_1 = VocabularyTerm(
        code="DFG_5020_1",
        label="5020 Binocular microscopes, magnifiers (stereoscopic)",
        description="""Binocular microscopes, magnifiers (stereoscopic)//Binokularmikroskope, -lupen (stereoskopische)""",
    )

    dfg_5020_2 = VocabularyTerm(
        code="DFG_5020_2",
        label="5020 Prismatic magnifiers",
        description="""Prismatic magnifiers//Prismenlupen""",
    )

    dfg_5020_3 = VocabularyTerm(
        code="DFG_5020_3",
        label="5020 Stereoscopic magnifiers",
        description="""Stereoscopic magnifiers//Stereolupen""",
    )

    dfg_5020_4 = VocabularyTerm(
        code="DFG_5020_4",
        label="5020 Stereomicroscopes",
        description="""Stereomicroscopes//Stereomikroskope""",
    )

    dfg_5020_5 = VocabularyTerm(
        code="DFG_5020_5",
        label="5020 Stereoscopic microscopes and magnifiers",
        description="""Stereoscopic microscopes and magnifiers//Stereoskopische Mikroskope und Lupen""",
    )

    dfg_5030_1 = VocabularyTerm(
        code="DFG_5030_1",
        label="5030 Profile projectors",
        description="""Profile projectors//Profilprojektoren""",
    )

    dfg_5030_2 = VocabularyTerm(
        code="DFG_5030_2",
        label="5030 Projection microscopes",
        description="""Projection microscopes//Projektionsmikroskope""",
    )

    dfg_5030_3 = VocabularyTerm(
        code="DFG_5030_3",
        label="5030 Workshop and measuring microscopes",
        description="""Workshop and measuring microscopes//Werkstatt- und Messmikroskope""",
    )

    dfg_5030_4 = VocabularyTerm(
        code="DFG_5030_4",
        label="5030 Tool measuring microscopes",
        description="""Tool measuring microscopes//Werkzeugmessmikroskope""",
    )

    dfg_5040_1 = VocabularyTerm(
        code="DFG_5040_1",
        label="5040 Reflected-light interference microscopes",
        description="""Reflected-light interference microscopes//Auflicht-Interferenzmikroskope""",
    )

    dfg_5040_2 = VocabularyTerm(
        code="DFG_5040_2",
        label="5040 Television microscopes",
        description="""Television microscopes//Fernsehmikroskope""",
    )

    dfg_5040_3 = VocabularyTerm(
        code="DFG_5040_3",
        label="5040 Interference microscopes",
        description="""Interference microscopes//Interferenzmikroskope""",
    )

    dfg_5040_4 = VocabularyTerm(
        code="DFG_5040_4",
        label="5040 Intravital microscopes",
        description="""Intravital microscopes//Intravitalmikroskope""",
    )

    dfg_5040_5 = VocabularyTerm(
        code="DFG_5040_5",
        label="5040 Inverse microscopes",
        description="""Inverse microscopes//Inversmikroskope""",
    )

    dfg_5040_6 = VocabularyTerm(
        code="DFG_5040_6",
        label="5040 Nuclear microscopes",
        description="""Nuclear microscopes//Kernspurmikroskope""",
    )

    dfg_5040_7 = VocabularyTerm(
        code="DFG_5040_7",
        label="5040 Metal microscopes",
        description="""Metal microscopes//Metallmikroskope""",
    )

    dfg_5040_8 = VocabularyTerm(
        code="DFG_5040_8",
        label="5040 Multipel interference microscopes",
        description="""Multipel interference microscopes//Multipel-Interferenzmikroskope""",
    )

    dfg_5040_9 = VocabularyTerm(
        code="DFG_5040_9",
        label="5040 Patch clamp apparatus (for components see 3590)",
        description="""Patch clamp apparatus (for components see 3590)//Patch-Clamp-Apparaturen (-Komponenten siehe 3590)""",
    )

    dfg_5040_10 = VocabularyTerm(
        code="DFG_5040_10",
        label="5040 Plankton microscopes",
        description="""Plankton microscopes//Planktonmikroskope""",
    )

    dfg_5040_11 = VocabularyTerm(
        code="DFG_5040_11",
        label="5040 Special microscopes (except 5000-5030)",
        description="""Special microscopes (except 5000-5030)//Spezielle Mikroskope (außer 5000-5030)""",
    )

    dfg_5040_12 = VocabularyTerm(
        code="DFG_5040_12",
        label="5040 Ultraviolet microscopes",
        description="""Ultraviolet microscopes//Ultraviolett-Mikroskope""",
    )

    dfg_5040_13 = VocabularyTerm(
        code="DFG_5040_13",
        label="5040 Inverted microscopes, inverted microscopes",
        description="""Inverted microscopes, inverted microscopes//Umgekehrte Mikroskope, Umkehrmikroskope""",
    )

    dfg_5040_14 = VocabularyTerm(
        code="DFG_5040_14",
        label="5040 Comparison microscopes, macroscopes",
        description="""Comparison microscopes, macroscopes//Vergleichsmikroskope, -makroskope""",
    )

    dfg_5040_15 = VocabularyTerm(
        code="DFG_5040_15",
        label="5040 Multibeam interference microscopes",
        description="""Multibeam interference microscopes//Vielstrahl-Interferenzmikroskope""",
    )

    dfg_5041_1 = VocabularyTerm(
        code="DFG_5041_1",
        label="5041 Surgical microscopes",
        description="""Surgical microscopes//Operationsmikroskope""",
    )

    dfg_5042_1 = VocabularyTerm(
        code="DFG_5042_1",
        label="5042 High-throughput and screening microscopes",
        description="""High-throughput and screening microscopes//Mikroskope für Hochdurchsatz und Screening""",
    )

    dfg_5050_1 = VocabularyTerm(
        code="DFG_5050_1",
        label="5050 Fluoro-microphotometers",
        description="""Fluoro-microphotometers//Fluoro-Mikrophotometer""",
    )

    dfg_5050_2 = VocabularyTerm(
        code="DFG_5050_2",
        label="5050 Microscope interferometers",
        description="""Microscope interferometers//Mikroskop-Interferometer""",
    )

    dfg_5050_3 = VocabularyTerm(
        code="DFG_5050_3",
        label="5050 Microscope photometer",
        description="""Microscope photometer//Mikroskopphotometer""",
    )

    dfg_5050_4 = VocabularyTerm(
        code="DFG_5050_4",
        label="5050 Microscope spectrophotometer",
        description="""Microscope spectrophotometer//Mikroskop-Spektralphotometer""",
    )

    dfg_5050_5 = VocabularyTerm(
        code="DFG_5050_5",
        label="5050 Microspectrophotometer",
        description="""Microspectrophotometer//Mikrospektralphotometer""",
    )

    dfg_5050_6 = VocabularyTerm(
        code="DFG_5050_6",
        label="5050 Scanning microscope photometer",
        description="""Scanning microscope photometer//Scanning-Mikroskop-Photometer""",
    )

    dfg_5060_1 = VocabularyTerm(
        code="DFG_5060_1",
        label="5060 Incident light illuminators",
        description="""Incident light illuminators//Auflicht-Illuminatoren""",
    )

    dfg_5060_2 = VocabularyTerm(
        code="DFG_5060_2",
        label="5060 Lamps (for microscopes)",
        description="""Lamps (for microscopes)//Lampenhäuser (für Mikroskope)""",
    )

    dfg_5060_3 = VocabularyTerm(
        code="DFG_5060_3",
        label="5060 Microflash devices",
        description="""Microflash devices//Mikroblitzgeräte""",
    )

    dfg_5060_4 = VocabularyTerm(
        code="DFG_5060_4",
        label="5060 Microscope illuminators",
        description="""Microscope illuminators//Mikroskopbeleuchtung""",
    )

    dfg_5060_5 = VocabularyTerm(
        code="DFG_5060_5",
        label="5060 Microscope lamps",
        description="""Microscope lamps//Mikroskopierlampen""",
    )

    dfg_5060_6 = VocabularyTerm(
        code="DFG_5060_6",
        label="5060 Power supply units for microscope illumination",
        description="""Power supply units for microscope illumination//Netzanschlussgeräte für Mikroskopbeleuchtung""",
    )

    dfg_5060_7 = VocabularyTerm(
        code="DFG_5060_7",
        label="5060 Opaque illuminators",
        description="""Opaque illuminators//Opak-Illuminatoren""",
    )

    dfg_5070_1 = VocabularyTerm(
        code="DFG_5070_1",
        label="5070 Microscope turntables, universal turntables (except 5900)",
        description="""Microscope turntables, universal turntables (except 5900)//Drehtische für Mikroskope, Universal-Drehtische (außer 5900)""",
    )

    dfg_5070_2 = VocabularyTerm(
        code="DFG_5070_2",
        label="5070 Heating and cooling tables for microscopes",
        description="""Heating and cooling tables for microscopes//Heiz- und Kühltische für Mikroskope""",
    )

    dfg_5070_3 = VocabularyTerm(
        code="DFG_5070_3",
        label="5070 Integration tables",
        description="""Integration tables//Integrationstische""",
    )

    dfg_5070_4 = VocabularyTerm(
        code="DFG_5070_4",
        label="5070 Coordinate tables for microscopes",
        description="""Coordinate tables for microscopes//Koordinatentische für Mikroskope""",
    )

    dfg_5070_5 = VocabularyTerm(
        code="DFG_5070_5",
        label="5070 Mechanical microscope accessories and auxiliary equipment",
        description="""Mechanical microscope accessories and auxiliary equipment//Mechanisches Mikroskop-Zubehör und Hilfsgeräte""",
    )

    dfg_5070_6 = VocabularyTerm(
        code="DFG_5070_6",
        label="5070 Phototubes (Photo-Antze fr)",
        description="""Phototubes (Photo-Antze fr)//Phototuben (Photo-Ansätze für)""",
    )

    dfg_5070_7 = VocabularyTerm(
        code="DFG_5070_7",
        label="5070 Scanning tables for microscopes",
        description="""Scanning tables for microscopes//Scanning-Tische für Mikroskope""",
    )

    dfg_5080_1 = VocabularyTerm(
        code="DFG_5080_1",
        label="5080 Image reflecting apparatus for microscopes",
        description="""Image reflecting apparatus for microscopes//Bildeinspiegelungsapparaturen für Mikroskope""",
    )

    dfg_5080_2 = VocabularyTerm(
        code="DFG_5080_2",
        label="5080 Fluorescence apparatus for microscopes",
        description="""Fluorescence apparatus for microscopes//Fluoreszenzeinrichtungen für Mikroskope""",
    )

    dfg_5080_3 = VocabularyTerm(
        code="DFG_5080_3",
        label="5080 Focusing devices",
        description="""Focusing devices//Fokussiereinrichtungen""",
    )

    dfg_5080_4 = VocabularyTerm(
        code="DFG_5080_4",
        label="5080 Auxiliary objectives for microscopes",
        description="""Auxiliary objectives for microscopes//Hilfsobjektive für Mikroskope""",
    )

    dfg_5080_5 = VocabularyTerm(
        code="DFG_5080_5",
        label="5080 Interference contrast devices for microscopes",
        description="""Interference contrast devices for microscopes//Interferenzkontrast-Einrichtungen für Mikroskope""",
    )

    dfg_5080_6 = VocabularyTerm(
        code="DFG_5080_6",
        label="5080 Compensators for microscopes",
        description="""Compensators for microscopes//Kompensatoren für Mikroskope""",
    )

    dfg_5080_7 = VocabularyTerm(
        code="DFG_5080_7",
        label="5080 Condensers for microscopes",
        description="""Condensers for microscopes//Kondensoren für Mikroskope""",
    )

    dfg_5080_8 = VocabularyTerm(
        code="DFG_5080_8",
        label="5080 Laser-scanning devices",
        description="""Laser-scanning devices//Laser-Scan-Zusätze""",
    )

    dfg_5080_9 = VocabularyTerm(
        code="DFG_5080_9",
        label="5080 Objectives for microscopes",
        description="""Objectives for microscopes//Objektive für Mikroskope""",
    )

    dfg_5080_10 = VocabularyTerm(
        code="DFG_5080_10",
        label="5080 Eyepieces for microscopes",
        description="""Eyepieces for microscopes//Okulare für Mikroskope""",
    )

    dfg_5080_11 = VocabularyTerm(
        code="DFG_5080_11",
        label="5080 Optical microscope accessories",
        description="""Optical microscope accessories//Optisches Mikroskopzubehör""",
    )

    dfg_5080_12 = VocabularyTerm(
        code="DFG_5080_12",
        label="5080 Phase contrasting equipment for microscopes",
        description="""Phase contrasting equipment for microscopes//Phasenkontrasteinrichtungen für Mikroskope""",
    )

    dfg_5080_13 = VocabularyTerm(
        code="DFG_5080_13",
        label="5080 Polarisation accessories for microscopes",
        description="""Polarisation accessories for microscopes//Polarisations-Zubehör für Mikroskope""",
    )

    dfg_5080_14 = VocabularyTerm(
        code="DFG_5080_14",
        label="5080 Projection equipment for microscopes",
        description="""Projection equipment for microscopes//Projektionseinrichtungen für Mikroskope""",
    )

    dfg_5080_15 = VocabularyTerm(
        code="DFG_5080_15",
        label="5080 Blocking filters (fluorescence microscopy)",
        description="""Blocking filters (fluorescence microscopy)//Sperrfilter (Fluoreszenz-Mikroskopie)""",
    )

    dfg_5080_16 = VocabularyTerm(
        code="DFG_5080_16",
        label="5080 Reticles for microscopes",
        description="""Reticles for microscopes//Strichplatten für Mikroskope""",
    )

    dfg_5080_17 = VocabularyTerm(
        code="DFG_5080_17",
        label="5080 Ultrasonic lenses",
        description="""Ultrasonic lenses//Ultraschallinsen""",
    )

    dfg_5080_18 = VocabularyTerm(
        code="DFG_5080_18",
        label="5080 Graduated filters for microscopes",
        description="""Graduated filters for microscopes//Verlauf-Filter für Mikroskope""",
    )

    dfg_5080_19 = VocabularyTerm(
        code="DFG_5080_19",
        label="5080 Drawing plates, mirrors for microscopes",
        description="""Drawing plates, mirrors for microscopes//Zeichenplatten, -spiegel für Mikroskope""",
    )

    dfg_5090_1 = VocabularyTerm(
        code="DFG_5090_1",
        label="5090 Laser scanning microscopes",
        description="""Laser scanning microscopes//Laser-Scanning-Mikroskope""",
    )

    dfg_5091_1 = VocabularyTerm(
        code="DFG_5091_1",
        label="5091 Scanning tunneling, atomic force microscopes",
        description="""Scanning tunneling, atomic force microscopes//Raster-Tunnel-, Rasterkraft-Mikroskope""",
    )

    dfg_5092_1 = VocabularyTerm(
        code="DFG_5092_1",
        label="5092 Acoustic microscopes",
        description="""Acoustic microscopes//Akustische Mikroskope""",
    )

    dfg_5092_2 = VocabularyTerm(
        code="DFG_5092_2",
        label="5092 Ultrasonic microscopes",
        description="""Ultrasonic microscopes//Ultraschall-Mikroskope""",
    )

    dfg_5100_1 = VocabularyTerm(
        code="DFG_5100_1",
        label="5100 Transmission electron microscopes",
        description="""Transmission electron microscopes//Elektronenmikroskope (Transmission)""",
    )

    dfg_5100_2 = VocabularyTerm(
        code="DFG_5100_2",
        label="5100 Transmission electron microscopes (TEM)",
        description="""Transmission electron microscopes (TEM)//Transmissions-Elektronenmikroskope (TEM)""",
    )

    dfg_5110_1 = VocabularyTerm(
        code="DFG_5110_1",
        label="5110 High-voltage electron microscopes",
        description="""High-voltage electron microscopes//Hochspannungs-Elektronenmikroskope""",
    )

    dfg_5111_1 = VocabularyTerm(
        code="DFG_5111_1",
        label="5111 High-voltage electron microscope",
        description="""High-voltage electron microscope//Hochspannungs-Elektronenmikroskop""",
    )

    dfg_5120_1 = VocabularyTerm(
        code="DFG_5120_1",
        label="5120 Reflected-light scanning electron microscopes",
        description="""Reflected-light scanning electron microscopes//Auflicht-Rasterelektronenmikroskope""",
    )

    dfg_5120_2 = VocabularyTerm(
        code="DFG_5120_2",
        label="5120 Scanning electron microscopes (incident light), with field emission cathode",
        description="""Scanning electron microscopes (incident light), with field emission cathode//Rasterelektronenmikroskope (Auflicht), mit Feldemissionskathode""",
    )

    dfg_5120_3 = VocabularyTerm(
        code="DFG_5120_3",
        label="5120 Scanning electron microscopes (SEM)",
        description="""Scanning electron microscopes (SEM)//Rasterelektronenmikroskope (REM)""",
    )

    dfg_5130_1 = VocabularyTerm(
        code="DFG_5130_1",
        label="5130 Transmission scanning electron microscopes",
        description="""Transmission scanning electron microscopes//Durchstrahlungs-Rasterelektronenmikroskope""",
    )

    dfg_5130_2 = VocabularyTerm(
        code="DFG_5130_2",
        label="5130 Field emission microscopes",
        description="""Field emission microscopes//Feldelektronenmikroskope""",
    )

    dfg_5130_3 = VocabularyTerm(
        code="DFG_5130_3",
        label="5130 Field emission microscopes",
        description="""Field emission microscopes//Feldemissions-Mikroskope""",
    )

    dfg_5130_4 = VocabularyTerm(
        code="DFG_5130_4",
        label="5130 Field ion microscopes",
        description="""Field ion microscopes//Feldionenmikroskope""",
    )

    dfg_5130_5 = VocabularyTerm(
        code="DFG_5130_5",
        label="5130 Photoemission microscopes",
        description="""Photoemission microscopes//Photoemissionsmikroskope""",
    )

    dfg_5130_6 = VocabularyTerm(
        code="DFG_5130_6",
        label="5130 Other special electron microscopes",
        description="""Other special electron microscopes//Sonstige spezielle Elektronenmikroskope""",
    )

    dfg_5130_7 = VocabularyTerm(
        code="DFG_5130_7",
        label="5130 Transmission scanning electron microscopes",
        description="""Transmission scanning electron microscopes//Transmissions-Rasterelektronenmikroskope""",
    )

    dfg_5140_1 = VocabularyTerm(
        code="DFG_5140_1",
        label="5140 Automatic exposure for electron microscopes",
        description="""Automatic exposure for electron microscopes//Belichtungsautomatik für Elektronenmikroskope""",
    )

    dfg_5140_2 = VocabularyTerm(
        code="DFG_5140_2",
        label="5140 Image current meters for electron microscopes",
        description="""Image current meters for electron microscopes//Bildstrom-Messplätze für Elektronenmikroskope""",
    )

    dfg_5140_3 = VocabularyTerm(
        code="DFG_5140_3",
        label="5140 Auxiliary electron-optical apparatus, other",
        description="""Auxiliary electron-optical apparatus, other//Elektronenoptische Hilfsgeräte, sonstige""",
    )

    dfg_5140_4 = VocabularyTerm(
        code="DFG_5140_4",
        label="5140 Auxiliary apparatus and accessories for electron microscopes",
        description="""Auxiliary apparatus and accessories for electron microscopes//Hilfsgeräte und Zubehör für Elektronenmikroskope""",
    )

    dfg_5140_5 = VocabularyTerm(
        code="DFG_5140_5",
        label="5140 Scanning generators, electron beam deflection generators (electron optics)",
        description="""Scanning generators, electron beam deflection generators (electron optics)//Rastergeneratoren, Elektronenstrahl-Ablenkgeneratoren (Elektronenoptik)""",
    )

    dfg_5150_1 = VocabularyTerm(
        code="DFG_5150_1",
        label="5150 Electron spectrometers, electron analysers",
        description="""Electron spectrometers, electron analysers//Elektronenspektrometer, Elektronenanalysatoren""",
    )

    dfg_5160_1 = VocabularyTerm(
        code="DFG_5160_1",
        label="5160 Electron diffraction apparatus, LEED, RHEED, SHEED apparatus",
        description="""Electron diffraction apparatus, LEED, RHEED, SHEED apparatus//Elektronenbeugungs-Apparaturen, LEED-, RHEED-, SHEED-Apparaturen""",
    )

    dfg_5160_2 = VocabularyTerm(
        code="DFG_5160_2",
        label="5160 Electron diffractometers (high energy)",
        description="""Electron diffractometers (high energy)//Elektronendiffraktometer (Hochenergie)""",
    )

    dfg_5160_3 = VocabularyTerm(
        code="DFG_5160_3",
        label="5160 LEED apparatus (Low Energy Electron Diffraction)",
        description="""LEED apparatus (Low Energy Electron Diffraction)//LEED-Apparaturen (Low Energy Electron Diffraction)""",
    )

    dfg_5160_4 = VocabularyTerm(
        code="DFG_5160_4",
        label="5160 LEED Auger apparatuses",
        description="""LEED Auger apparatuses//LEED-Auger-Apparaturen""",
    )

    dfg_5160_5 = VocabularyTerm(
        code="DFG_5160_5",
        label="5160 RHEED apparatus (Reflected High Energy Electron Diffraction)",
        description="""RHEED apparatus (Reflected High Energy Electron Diffraction)//RHEED-Apparaturen (Reflected High Energy Electron Diffraction)""",
    )

    dfg_5160_6 = VocabularyTerm(
        code="DFG_5160_6",
        label="5160 SHEED apparatus (Scanning High Energy Electron Diffraction)",
        description="""SHEED apparatus (Scanning High Energy Electron Diffraction)//SHEED-Apparaturen (Scanning High Energy Electron Diffraction)""",
    )

    dfg_5170_1 = VocabularyTerm(
        code="DFG_5170_1",
        label="5170 Image converter cameras",
        description="""Image converter cameras//Bildwandler-Kameras""",
    )

    dfg_5170_2 = VocabularyTerm(
        code="DFG_5170_2",
        label="5170 Electron-optical image converters and image intensifiers (except television 6730)",
        description="""Electron-optical image converters and image intensifiers (except television 6730)//Elektronenoptische Bildwandlergeräte und Bildverstärker (außer Fernsehanlagen 6730)""",
    )

    dfg_5170_3 = VocabularyTerm(
        code="DFG_5170_3",
        label="5170 Image converters, dissectors (electron-optical)",
        description="""Image converters, dissectors (electron-optical)//Image-Converter, -Dissektoren (elektronenoptisch)""",
    )

    dfg_5170_4 = VocabularyTerm(
        code="DFG_5170_4",
        label="5170 Infrared image converters and viewers",
        description="""Infrared image converters and viewers//Infrarot-Bildwandler, -Sichtgeräte""",
    )

    dfg_5170_5 = VocabularyTerm(
        code="DFG_5170_5",
        label="5170 Night vision devices",
        description="""Night vision devices//Nachtsichtgeräte""",
    )

    dfg_5170_6 = VocabularyTerm(
        code="DFG_5170_6",
        label="5170 Photoelectron amplifiers for electronographic recording",
        description="""Photoelectron amplifiers for electronographic recording//Photoelektronenverstärker für elektronographische Aufzeichnung""",
    )

    dfg_5170_7 = VocabularyTerm(
        code="DFG_5170_7",
        label="5170 Residual light cameras",
        description="""Residual light cameras//Restlichtkameras""",
    )

    dfg_5170_8 = VocabularyTerm(
        code="DFG_5170_8",
        label="5170 Residual light amplifiers",
        description="""Residual light amplifiers//Restlichtverstärker""",
    )

    dfg_5170_9 = VocabularyTerm(
        code="DFG_5170_9",
        label="5170 X-ray image intensifiers (electron-optical, except 3220)",
        description="""X-ray image intensifiers (electron-optical, except 3220)//Röntgen-Bildverstärker (elektronenoptisch, außer 3220)""",
    )

    dfg_5170_10 = VocabularyTerm(
        code="DFG_5170_10",
        label="5170 UV image converter",
        description="""UV image converter//UV-Bildwandler""",
    )

    dfg_5180_1 = VocabularyTerm(
        code="DFG_5180_1",
        label="5180 Argon (ion) guns, sources, (material processing)",
        description="""Argon (ion) guns, sources, (material processing)//Argon- (Ionen-) Kanonen, -Quellen, (Materialbearbeitung)""",
    )

    dfg_5180_2 = VocabularyTerm(
        code="DFG_5180_2",
        label="5180 Electron and ion beam sources",
        description="""Electron and ion beam sources//Elektronen- und Ionenstrahl-Quellen""",
    )

    dfg_5180_3 = VocabularyTerm(
        code="DFG_5180_3",
        label="5180 Electron injection equipment, electron beam devices",
        description="""Electron injection equipment, electron beam devices//Elektroneninjektionsanlagen, Elektronenstrahlgeräte""",
    )

    dfg_5180_4 = VocabularyTerm(
        code="DFG_5180_4",
        label="5180 Electron beam guns (except 8380 for vapour deposition equipment)",
        description="""Electron beam guns (except 8380 for vapour deposition equipment)//Elektronenstrahl-Kanonen (außer 8380 für Aufdampfanlagen)""",
    )

    dfg_5180_5 = VocabularyTerm(
        code="DFG_5180_5",
        label="5180 Ion etching equipment (surface machining and drilling, except preparation equipment 8330)",
        description="""Ion etching equipment (surface machining and drilling, except preparation equipment 8330)//Ionen-Ätzanlagen (Oberflächenbearbeitung und Bohren, außer Präparieranlagen 8330)""",
    )

    dfg_5190_1 = VocabularyTerm(
        code="DFG_5190_1",
        label="5190 Assemblies, controls and accessories for electron-optical instruments, except 5140)",
        description="""Assemblies, controls and accessories for electron-optical instruments, except 5140)//Baugruppen, Steuergeräte und Zubehör für elektronenoptische Geräte, außer 5140)""",
    )

    dfg_5190_2 = VocabularyTerm(
        code="DFG_5190_2",
        label="5190 Other electron-optical instruments (except 4040 and 5100-5180)",
        description="""Other electron-optical instruments (except 4040 and 5100-5180)//Sonstige elektronenoptische Geräte (außer 4040 und 5100-5180)""",
    )

    dfg_5200_1 = VocabularyTerm(
        code="DFG_5200_1",
        label="5200 Beaker photometer",
        description="""Beaker photometer//Becherglasphotometer""",
    )

    dfg_5200_2 = VocabularyTerm(
        code="DFG_5200_2",
        label="5200 Flow-through photometer (filter)",
        description="""Flow-through photometer (filter)//Durchflussphotometer (Filter-)""",
    )

    dfg_5200_3 = VocabularyTerm(
        code="DFG_5200_3",
        label="5200 Filter photometer",
        description="""Filter photometer//Filterphotometer""",
    )

    dfg_5200_4 = VocabularyTerm(
        code="DFG_5200_4",
        label="5200 Colourimeter",
        description="""Colourimeter//Kolorimeter""",
    )

    dfg_5200_5 = VocabularyTerm(
        code="DFG_5200_5",
        label="5200 Photometers, absorption photometers (except spectrophotometers 1800-1860)",
        description="""Photometers, absorption photometers (except spectrophotometers 1800-1860)//Photometer, Absorptionsphotometer (außer Spektralphotometer 1800-1860)""",
    )

    dfg_5200_6 = VocabularyTerm(
        code="DFG_5200_6",
        label="5200 Titration colourimeter",
        description="""Titration colourimeter//Titrierkolorimeter""",
    )

    dfg_5200_7 = VocabularyTerm(
        code="DFG_5200_7",
        label="5200 UV photometer (filter)",
        description="""UV photometer (filter)//UV-Photometer (Filter-)""",
    )

    dfg_5200_8 = VocabularyTerm(
        code="DFG_5200_8",
        label="5200 Double beam photometer (filter)",
        description="""Double beam photometer (filter)//Zweistrahl-Photometer (Filter-)""",
    )

    dfg_5210_1 = VocabularyTerm(
        code="DFG_5210_1",
        label="5210 ATP photometer (adenosine triphosphate photometer)",
        description="""ATP photometer (adenosine triphosphate photometer)//ATP-Photometer (Adenosin-Triphosphat-Photometer)""",
    )

    dfg_5210_2 = VocabularyTerm(
        code="DFG_5210_2",
        label="5210 Bioluminescence measuring instruments, photometers (ATP photometer, luciferase test)",
        description="""Bioluminescence measuring instruments, photometers (ATP photometer, luciferase test)//Biolumineszenz-Messgeräte, -Photometer (ATP-Photometer, Luziferasetest)""",
    )

    dfg_5210_3 = VocabularyTerm(
        code="DFG_5210_3",
        label="5210 Automatic calcium-magnesium analysers (flame photometer) for serum, blood plasma",
        description="""Automatic calcium-magnesium analysers (flame photometer) for serum, blood plasma//Calcium-Magnesium-Analysenautomaten (Flammenphotometer) für Serum, Blutplasma""",
    )

    dfg_5210_4 = VocabularyTerm(
        code="DFG_5210_4",
        label="5210 Flame photometer, emission photometer",
        description="""Flame photometer, emission photometer//Flammenphotometer, Emissionsphotometer""",
    )

    dfg_5210_5 = VocabularyTerm(
        code="DFG_5210_5",
        label="5210 Helium-glow photometer",
        description="""Helium-glow photometer//Helium-Glow-Photometer""",
    )

    dfg_5220_1 = VocabularyTerm(
        code="DFG_5220_1",
        label="5220 Fluorescence photometer, filter fluorometer",
        description="""Fluorescence photometer, filter fluorometer//Fluoreszenz-Photometer, Filterfluorometer""",
    )

    dfg_5220_2 = VocabularyTerm(
        code="DFG_5220_2",
        label="5220 Fluoro-nephelometer",
        description="""Fluoro-nephelometer//Fluoro-Nephelometer""",
    )

    dfg_5230_1 = VocabularyTerm(
        code="DFG_5230_1",
        label="5230 Autodensitometer",
        description="""Autodensitometer//Autodensitometer""",
    )

    dfg_5230_2 = VocabularyTerm(
        code="DFG_5230_2",
        label="5230 Autoradiography systems (densitometric)",
        description="""Autoradiography systems (densitometric)//Autoradiographie-Systeme (densitometrische)""",
    )

    dfg_5230_3 = VocabularyTerm(
        code="DFG_5230_3",
        label="5230 Densitometers, microphotometers",
        description="""Densitometers, microphotometers//Densitometer, Mikrophotometer""",
    )

    dfg_5230_4 = VocabularyTerm(
        code="DFG_5230_4",
        label="5230 Dnn layer scanners (optical)",
        description="""Dnn layer scanners (optical)//Dünnschichtscanner (optische)""",
    )

    dfg_5230_5 = VocabularyTerm(
        code="DFG_5230_5",
        label="5230 Electrophoresis analysers (densitometers, photometers)",
        description="""Electrophoresis analysers (densitometers, photometers)//Elektrophorese-Auswertegeräte (Densitometer, Photometer)""",
    )

    dfg_5230_6 = VocabularyTerm(
        code="DFG_5230_6",
        label="5230 Area scanning photometer (area scanner)",
        description="""Area scanning photometer (area scanner)//Flächenabtastphotometer (Area Scanner)""",
    )

    dfg_5230_7 = VocabularyTerm(
        code="DFG_5230_7",
        label="5230 Flying spot microphotometer",
        description="""Flying spot microphotometer//Flying-Spot-Mikrophotometer""",
    )

    dfg_5230_8 = VocabularyTerm(
        code="DFG_5230_8",
        label="5230 Gel scanner (photometer)",
        description="""Gel scanner (photometer)//Gel-Scanner (Photometer)""",
    )

    dfg_5230_9 = VocabularyTerm(
        code="DFG_5230_9",
        label="5230 Integrating photometer",
        description="""Integrating photometer//Integrationsphotometer""",
    )

    dfg_5230_10 = VocabularyTerm(
        code="DFG_5230_10",
        label="5230 Integrating microdensitometers",
        description="""Integrating microdensitometers//Integrierende Mikrodensitometer""",
    )

    dfg_5230_11 = VocabularyTerm(
        code="DFG_5230_11",
        label="5230 Comparator densitometer",
        description="""Comparator densitometer//Komparator-Densitometer""",
    )

    dfg_5230_12 = VocabularyTerm(
        code="DFG_5230_12",
        label="5230 Laser densitometer",
        description="""Laser densitometer//Laser-Densitometer""",
    )

    dfg_5230_13 = VocabularyTerm(
        code="DFG_5230_13",
        label="5230 Microdensitometer",
        description="""Microdensitometer//Mikrodensitometer""",
    )

    dfg_5230_14 = VocabularyTerm(
        code="DFG_5230_14",
        label="5230 Pherogram photometers",
        description="""Pherogram photometers//Pherogramm-Photometer""",
    )

    dfg_5230_15 = VocabularyTerm(
        code="DFG_5230_15",
        label="5230 Phosphor imager systems",
        description="""Phosphor imager systems//Phosphor-Imager-Systeme""",
    )

    dfg_5230_16 = VocabularyTerm(
        code="DFG_5230_16",
        label="5230 Spectro-densitometers",
        description="""Spectro-densitometers//Spektro-Densitometer""",
    )

    dfg_5230_17 = VocabularyTerm(
        code="DFG_5230_17",
        label="5230 Fluorescence imaging systems",
        description="""Fluorescence imaging systems//Fluoreszenz-Imagingsysteme""",
    )

    dfg_5240_1 = VocabularyTerm(
        code="DFG_5240_1",
        label="5240 Photon counting systems",
        description="""Photon counting systems//Photon-Counting-Systeme""",
    )

    dfg_5240_2 = VocabularyTerm(
        code="DFG_5240_2",
        label="5240 Photon counters, quantum photometers",
        description="""Photon counters, quantum photometers//Photonenzähler, Quantenphotometer""",
    )

    dfg_5250_1 = VocabularyTerm(
        code="DFG_5250_1",
        label="5250 Illuminometers",
        description="""Illuminometers//Beleuchtungsmesser""",
    )

    dfg_5250_2 = VocabularyTerm(
        code="DFG_5250_2",
        label="5250 Candelameters, light meters",
        description="""Candelameters, light meters//Candelameter, Lichtstärkemesser""",
    )

    dfg_5250_3 = VocabularyTerm(
        code="DFG_5250_3",
        label="5250 Brightness and illumination meters, exposure meters",
        description="""Brightness and illumination meters, exposure meters//Helligkeits- und Beleuchtungsmessgeräte, Belichtungsmesser""",
    )

    dfg_5250_4 = VocabularyTerm(
        code="DFG_5250_4",
        label="5250 Luminance meters",
        description="""Luminance meters//Leuchtdichte-Messgeräte""",
    )

    dfg_5250_5 = VocabularyTerm(
        code="DFG_5250_5",
        label="5250 Luminance photometers",
        description="""Luminance photometers//Leuchtdichte-Photometer""",
    )

    dfg_5250_6 = VocabularyTerm(
        code="DFG_5250_6",
        label="5250 Light meters",
        description="""Light meters//Lichtdosiergeräte""",
    )

    dfg_5250_7 = VocabularyTerm(
        code="DFG_5250_7",
        label="5250 Light meters",
        description="""Light meters//Lichtstärkemesser""",
    )

    dfg_5250_8 = VocabularyTerm(
        code="DFG_5250_8",
        label="5250 Luminous flux meters",
        description="""Luminous flux meters//Lichtstrommesser""",
    )

    dfg_5250_9 = VocabularyTerm(
        code="DFG_5250_9",
        label="5250 Lumen meters",
        description="""Lumen meters//Lumenmeter""",
    )

    dfg_5250_10 = VocabularyTerm(
        code="DFG_5250_10",
        label="5250 Luxmeter",
        description="""Luxmeter//Luxmeter""",
    )

    dfg_5250_11 = VocabularyTerm(
        code="DFG_5250_11",
        label="5250 Radiometers (photometers, general, except 0540, 5860 and 8620)",
        description="""Radiometers (photometers, general, except 0540, 5860 and 8620)//Radiometer (Photometer, allgemein, außer 0540, 5860 und 8620)""",
    )

    dfg_5250_12 = VocabularyTerm(
        code="DFG_5250_12",
        label="5250 Room illuminance meters",
        description="""Room illuminance meters//Raumbeleuchtungsstärke-Messgeräte""",
    )

    dfg_5250_13 = VocabularyTerm(
        code="DFG_5250_13",
        label="5250 Spot photometer (luminance measurement)",
        description="""Spot photometer (luminance measurement)//Spot-Photometer (Leuchtdichte-Messung)""",
    )

    dfg_5270_1 = VocabularyTerm(
        code="DFG_5270_1",
        label="5270 Suction pumps for cuvettes",
        description="""Suction pumps for cuvettes//Absaugpumpen für Küvetten""",
    )

    dfg_5270_2 = VocabularyTerm(
        code="DFG_5270_2",
        label="5270 Flow-through cuvettes",
        description="""Flow-through cuvettes//Durchfluss-Küvetten""",
    )

    dfg_5270_3 = VocabularyTerm(
        code="DFG_5270_3",
        label="5270 Colour analysers (optical)",
        description="""Colour analysers (optical)//Farbanalysatoren (optisch)""",
    )

    dfg_5270_4 = VocabularyTerm(
        code="DFG_5270_4",
        label="5270 Colour extractors",
        description="""Colour extractors//Farbauszugsgeräte""",
    )

    dfg_5270_5 = VocabularyTerm(
        code="DFG_5270_5",
        label="5270 Colour measuring machines",
        description="""Colour measuring machines//Farbenmessautomaten""",
    )

    dfg_5270_6 = VocabularyTerm(
        code="DFG_5270_6",
        label="5270 Colour meters, whiteness meters",
        description="""Colour meters, whiteness meters//Farbmessgeräte, Weißgradmesser""",
    )

    dfg_5270_7 = VocabularyTerm(
        code="DFG_5270_7",
        label="5270 Colour temperature measuring instruments",
        description="""Colour temperature measuring instruments//Farbtemperatur-Messgeräte""",
    )

    dfg_5270_8 = VocabularyTerm(
        code="DFG_5270_8",
        label="5270 High-pressure cuvettes, cells for spectrometers",
        description="""High-pressure cuvettes, cells for spectrometers//Hochdruck-Küvetten, -Zellen für Spektrometer""",
    )

    dfg_5270_9 = VocabularyTerm(
        code="DFG_5270_9",
        label="5270 Automatic cuvette changers, cuvette changers",
        description="""Automatic cuvette changers, cuvette changers//Küvettenautomaten, -wechsler""",
    )

    dfg_5270_10 = VocabularyTerm(
        code="DFG_5270_10",
        label="5270 Cell holders",
        description="""Cell holders//Küvettenhalter""",
    )

    dfg_5270_11 = VocabularyTerm(
        code="DFG_5270_11",
        label="5270 Leucometers",
        description="""Leucometers//Leukometer""",
    )

    dfg_5270_12 = VocabularyTerm(
        code="DFG_5270_12",
        label="5270 Microcuvettes",
        description="""Microcuvettes//Mikroküvetten""",
    )

    dfg_5270_13 = VocabularyTerm(
        code="DFG_5270_13",
        label="5270 Automatic sample dispensers, cuvette dispensers",
        description="""Automatic sample dispensers, cuvette dispensers//Probenautomaten, -geber, Küvettenautomaten""",
    )

    dfg_5270_14 = VocabularyTerm(
        code="DFG_5270_14",
        label="5270 Temperature-controlled cuvettes",
        description="""Temperature-controlled cuvettes//Temperierbare Küvetten""",
    )

    dfg_5270_15 = VocabularyTerm(
        code="DFG_5270_15",
        label="5270 Cryogenic cuvettes",
        description="""Cryogenic cuvettes//Tieftemperatur-Küvetten""",
    )

    dfg_5280_1 = VocabularyTerm(
        code="DFG_5280_1",
        label="5280 Cuvettes and accessories for photometers and spectrophotometers",
        description="""Cuvettes and accessories for photometers and spectrophotometers//Küvetten und Zubehör für Photometer und Spektralphotometer""",
    )

    dfg_5290_1 = VocabularyTerm(
        code="DFG_5290_1",
        label="5290 Laser photometers (integrators for light pulses)",
        description="""Laser photometers (integrators for light pulses)//Laser-Photometer (Integratoren für Lichtimpulse)""",
    )

    dfg_5290_2 = VocabularyTerm(
        code="DFG_5290_2",
        label="5290 Photometric measuring apparatus (radiation pattern)",
        description="""Photometric measuring apparatus (radiation pattern)//Photometrische Messeinrichtungen (Strahlungsdiagramm)""",
    )

    dfg_5290_3 = VocabularyTerm(
        code="DFG_5290_3",
        label="5290 Other photometers (except 1800-1890 and 5200-5270)",
        description="""Other photometers (except 1800-1890 and 5200-5270)//Sonstige Photometer (außer 1800-1890 und 5200-5270)""",
    )

    dfg_5300_1 = VocabularyTerm(
        code="DFG_5300_1",
        label="5300 Fabry-Perot interferometers",
        description="""Fabry-Perot interferometers//Fabry-Perot-Interferometer""",
    )

    dfg_5300_2 = VocabularyTerm(
        code="DFG_5300_2",
        label="5300 Fabry-Perot plates, etalons",
        description="""Fabry-Perot plates, etalons//Fabry-Perot-Platten, -Etalons""",
    )

    dfg_5300_3 = VocabularyTerm(
        code="DFG_5300_3",
        label="5300 Gas interferometer",
        description="""Gas interferometer//Gasinterferometer""",
    )

    dfg_5300_4 = VocabularyTerm(
        code="DFG_5300_4",
        label="5300 Interferometers, multi-beam interferometers, etalons",
        description="""Interferometers, multi-beam interferometers, etalons//Interferometer, Vielstrahl-Interferometer, Etalons""",
    )

    dfg_5310_1 = VocabularyTerm(
        code="DFG_5310_1",
        label="5310 Holographic interferometers (Mach-Zehnder type), cameras",
        description="""Holographic interferometers (Mach-Zehnder type), cameras//Holographische Interferometer (Mach-Zehnder-Typ), -Kameras""",
    )

    dfg_5310_2 = VocabularyTerm(
        code="DFG_5310_2",
        label="5310 Holographic material test apparatus (interferometer)",
        description="""Holographic material test apparatus (interferometer)//Holographische Material-Testgeräte (Interferometer)""",
    )

    dfg_5310_3 = VocabularyTerm(
        code="DFG_5310_3",
        label="5310 Interference apparatus, double-beam interferometers",
        description="""Interference apparatus, double-beam interferometers//Interferenzapparaturen, Zweistrahl-Interferometer""",
    )

    dfg_5310_4 = VocabularyTerm(
        code="DFG_5310_4",
        label="5310 Jamin plates, -interferometers",
        description="""Jamin plates, -interferometers//Jamin-Platten, -Interferometer""",
    )

    dfg_5310_5 = VocabularyTerm(
        code="DFG_5310_5",
        label="5310 Mach-Zehnder interferometer",
        description="""Mach-Zehnder interferometer//Mach-Zehnder-Interferometer""",
    )

    dfg_5310_6 = VocabularyTerm(
        code="DFG_5310_6",
        label="5310 Michelson interferometer (except Fourier IR interferometer 1830)",
        description="""Michelson interferometer (except Fourier IR interferometer 1830)//Michelson-Interferometer (außer Fourier-IR-Interferometer 1830)""",
    )

    dfg_5310_7 = VocabularyTerm(
        code="DFG_5310_7",
        label="5310 Piezoceramics for interferometers including control devices",
        description="""Piezoceramics for interferometers including control devices//Piezokeramik für Interferometer einschließlich Steuergeräte""",
    )

    dfg_5310_8 = VocabularyTerm(
        code="DFG_5310_8",
        label="5310 Fringe analysers (counting of interference fringes)",
        description="""Fringe analysers (counting of interference fringes)//Streifenanalysatoren (Zählung von Interferenzstreifen)""",
    )

    dfg_5320_1 = VocabularyTerm(
        code="DFG_5320_1",
        label="5320 Compensating polarimeters",
        description="""Compensating polarimeters//Kompensations-Polarimeter""",
    )

    dfg_5320_2 = VocabularyTerm(
        code="DFG_5320_2",
        label="5320 Circular polarimeters",
        description="""Circular polarimeters//Kreispolarimeter""",
    )

    dfg_5320_3 = VocabularyTerm(
        code="DFG_5320_3",
        label="5320 Polarimeters (for fixed frequencies) and polarisation instruments",
        description="""Polarimeters (for fixed frequencies) and polarisation instruments//Polarimeter (für feste Frequenzen) und Polarisationsgeräte""",
    )

    dfg_5320_4 = VocabularyTerm(
        code="DFG_5320_4",
        label="5320 Polarisation fluorometers",
        description="""Polarisation fluorometers//Polarisations-Fluorometer""",
    )

    dfg_5320_5 = VocabularyTerm(
        code="DFG_5320_5",
        label="5320 Polarisation degree meters, direction pointers",
        description="""Polarisation degree meters, direction pointers//Polarisationsgrad-Messgeräte, -Richtungszeiger""",
    )

    dfg_5320_6 = VocabularyTerm(
        code="DFG_5320_6",
        label="5320 Sugar polarimeters",
        description="""Sugar polarimeters//Zuckerpolarimeter""",
    )

    dfg_5330_1 = VocabularyTerm(
        code="DFG_5330_1",
        label="5330 Circular dichroism instruments, CD spectrometers",
        description="""Circular dichroism instruments, CD spectrometers//Circular-Dichroismusgeräte, CD-Spektrometer""",
    )

    dfg_5330_2 = VocabularyTerm(
        code="DFG_5330_2",
        label="5330 MCD (Magnetic Circular Dichroism)",
        description="""MCD (Magnetic Circular Dichroism)//MCD-Geräte (Magnetischer Circular-Dichroismus)""",
    )

    dfg_5330_3 = VocabularyTerm(
        code="DFG_5330_3",
        label="5330 ORD-garde (Optical Rotational Dispersion)",
        description="""ORD-garde (Optical Rotational Dispersion)//ORD-Geräte (Optische Rotations-Dispersion)""",
    )

    dfg_5330_4 = VocabularyTerm(
        code="DFG_5330_4",
        label="5330 Rotational dispersion spectrometer (ORD)",
        description="""Rotational dispersion spectrometer (ORD)//Rotationsdispersionsspektrometer (ORD)""",
    )

    dfg_5330_5 = VocabularyTerm(
        code="DFG_5330_5",
        label="5330 Spectral polarimeters (CD, ORD), dichrographs",
        description="""Spectral polarimeters (CD, ORD), dichrographs//Spektralpolarimeter (CD, ORD), Dichrographen""",
    )

    dfg_5350_1 = VocabularyTerm(
        code="DFG_5350_1",
        label="5350 Abbe refractometer",
        description="""Abbe refractometer//Abbe-Refraktometer""",
    )

    dfg_5350_2 = VocabularyTerm(
        code="DFG_5350_2",
        label="5350 Differential refractometer",
        description="""Differential refractometer//Differential-Refraktometer""",
    )

    dfg_5350_3 = VocabularyTerm(
        code="DFG_5350_3",
        label="5350 Flow refractometer",
        description="""Flow refractometer//Durchfluss-Refraktometer""",
    )

    dfg_5350_4 = VocabularyTerm(
        code="DFG_5350_4",
        label="5350 Immersion refractometer",
        description="""Immersion refractometer//Eintauchrefraktometer""",
    )

    dfg_5350_5 = VocabularyTerm(
        code="DFG_5350_5",
        label="5350 Microrefractometer",
        description="""Microrefractometer//Mikrorefraktometer""",
    )

    dfg_5350_6 = VocabularyTerm(
        code="DFG_5350_6",
        label="5350 Refractometer",
        description="""Refractometer//Refraktometer""",
    )

    dfg_5360_1 = VocabularyTerm(
        code="DFG_5360_1",
        label="5360 Aerosol photometer (scattered light photometer)",
        description="""Aerosol photometer (scattered light photometer)//Aerosol-Photometer (Streulichtphotometer)""",
    )

    dfg_5360_2 = VocabularyTerm(
        code="DFG_5360_2",
        label="5360 Albedo meters",
        description="""Albedo meters//Albedo-Messgeräte""",
    )

    dfg_5360_3 = VocabularyTerm(
        code="DFG_5360_3",
        label="5360 Charlson nephelometer",
        description="""Charlson nephelometer//Charlson-Nephelometer""",
    )

    dfg_5360_4 = VocabularyTerm(
        code="DFG_5360_4",
        label="5360 Ellipsometers, photoelectric",
        description="""Ellipsometers, photoelectric//Ellipsometer, Photoelektrische""",
    )

    dfg_5360_5 = VocabularyTerm(
        code="DFG_5360_5",
        label="5360 Gloss-meter",
        description="""Gloss-meter//Glanzmesser (Gloss-Meter)""",
    )

    dfg_5360_6 = VocabularyTerm(
        code="DFG_5360_6",
        label="5360 Goniophotometer",
        description="""Goniophotometer//Goniophotometer""",
    )

    dfg_5360_7 = VocabularyTerm(
        code="DFG_5360_7",
        label="5360 Laser nephelometer",
        description="""Laser nephelometer//Laser-Nephelometer""",
    )

    dfg_5360_8 = VocabularyTerm(
        code="DFG_5360_8",
        label="5360 Laser scattering photometer (molecular weight determination)",
        description="""Laser scattering photometer (molecular weight determination)//Laser-Streuphotometer (Molekulargewichtsbestimmung)""",
    )

    dfg_5360_9 = VocabularyTerm(
        code="DFG_5360_9",
        label="5360 Light scattering measuring instruments",
        description="""Light scattering measuring instruments//Lichtstreuungs-Messgeräte""",
    )

    dfg_5360_10 = VocabularyTerm(
        code="DFG_5360_10",
        label="5360 Measuring instruments for scattered and reflected light, optical surface testing",
        description="""Measuring instruments for scattered and reflected light, optical surface testing//Messgeräte für gestreutes und reflektiertes Licht, optische Oberflächenprüfung""",
    )

    dfg_5360_11 = VocabularyTerm(
        code="DFG_5360_11",
        label="5360 Opacimeter",
        description="""Opacimeter//Opazimeter""",
    )

    dfg_5360_12 = VocabularyTerm(
        code="DFG_5360_12",
        label="5360 Photogoniodiffusometers",
        description="""Photogoniodiffusometers//Photogoniodiffusometer""",
    )

    dfg_5360_13 = VocabularyTerm(
        code="DFG_5360_13",
        label="5360 Photon correlation spectrometers",
        description="""Photon correlation spectrometers//Photonkorrelationsspektrometer""",
    )

    dfg_5360_14 = VocabularyTerm(
        code="DFG_5360_14",
        label="5360 Reflectometers, optical",
        description="""Reflectometers, optical//Reflektometer, optische""",
    )

    dfg_5360_15 = VocabularyTerm(
        code="DFG_5360_15",
        label="5360 Reflectometers, optical range",
        description="""Reflectometers, optical range//Reflexionsmessgeräte, optischer Bereich""",
    )

    dfg_5360_16 = VocabularyTerm(
        code="DFG_5360_16",
        label="5360 Dust and smoke photometers (scattered light photometers)",
        description="""Dust and smoke photometers (scattered light photometers)//Staub- und Rauch-Photometer (Streulichtphotometer)""",
    )

    dfg_5360_17 = VocabularyTerm(
        code="DFG_5360_17",
        label="5360 Scattered light photometer",
        description="""Scattered light photometer//Streulichtphotometer""",
    )

    dfg_5360_18 = VocabularyTerm(
        code="DFG_5360_18",
        label="5360 Transmissometer (light transmission)",
        description="""Transmissometer (light transmission)//Transmissometer (Lichtdurchlässigkeit)""",
    )

    dfg_5360_19 = VocabularyTerm(
        code="DFG_5360_19",
        label="5360 Turbidity meter, turbidity photometer",
        description="""Turbidity meter, turbidity photometer//Trübungsmesser, Trübungs-Photometer""",
    )

    dfg_5360_20 = VocabularyTerm(
        code="DFG_5360_20",
        label="5360 Turbidostats (turbidity measurement)",
        description="""Turbidostats (turbidity measurement)//Turbidostaten (Trübungsmessung)""",
    )

    dfg_5370_1 = VocabularyTerm(
        code="DFG_5370_1",
        label="5370 Optical voltage testers, polariscopes",
        description="""Optical voltage testers, polariscopes//Optische Spannungsprüfgeräte, Polariskope""",
    )

    dfg_5370_2 = VocabularyTerm(
        code="DFG_5370_2",
        label="5370 Polarisation (shearing) interferometers",
        description="""Polarisation (shearing) interferometers//Polarisations- (Shearing-) Interferometer""",
    )

    dfg_5370_3 = VocabularyTerm(
        code="DFG_5370_3",
        label="5370 Polariscopes (voltage optics)",
        description="""Polariscopes (voltage optics)//Polariskope (Spannungsoptik)""",
    )

    dfg_5370_4 = VocabularyTerm(
        code="DFG_5370_4",
        label="5370 Shadow optical instruments",
        description="""Shadow optical instruments//Schattenoptische Geräte""",
    )

    dfg_5370_5 = VocabularyTerm(
        code="DFG_5370_5",
        label="5370 Voltage-optical instruments, schlieren apparatuses",
        description="""Voltage-optical instruments, schlieren apparatuses//Spannungsoptische Geräte, Schlierenapparaturen""",
    )

    dfg_5390_1 = VocabularyTerm(
        code="DFG_5390_1",
        label="5390 Diffractometers, optical",
        description="""Diffractometers, optical//Diffraktometer, optische""",
    )

    dfg_5390_2 = VocabularyTerm(
        code="DFG_5390_2",
        label="5390 Frequency meters, optical",
        description="""Frequency meters, optical//Frequenz-Messer, optische""",
    )

    dfg_5390_3 = VocabularyTerm(
        code="DFG_5390_3",
        label="5390 Interferometers, other and accessories (except 5300)",
        description="""Interferometers, other and accessories (except 5300)//Interferometer, sonstige und Zubehör (außer 5300)""",
    )

    dfg_5390_4 = VocabularyTerm(
        code="DFG_5390_4",
        label="5390 Polarimeters, other and accessories (except 5320)",
        description="""Polarimeters, other and accessories (except 5320)//Polarimeter, sonstige und Zubehör (außer 5320)""",
    )

    dfg_5390_5 = VocabularyTerm(
        code="DFG_5390_5",
        label="5390 Refractometers, other and accessories (except 5350)",
        description="""Refractometers, other and accessories (except 5350)//Refraktometer, sonstige und Zubehör (außer 5350)""",
    )

    dfg_5390_6 = VocabularyTerm(
        code="DFG_5390_6",
        label="5390 Other measuring instruments for refraction and reflection of light",
        description="""Other measuring instruments for refraction and reflection of light//Sonstige Messgeräte für Lichtbrechung, -reflexion""",
    )

    dfg_5400_1 = VocabularyTerm(
        code="DFG_5400_1",
        label="5400 35 mm cameras",
        description="""35 mm cameras//Kleinbildkameras""",
    )

    dfg_5400_2 = VocabularyTerm(
        code="DFG_5400_2",
        label="5400 Photographic cameras (35 mm cameras up to 24 x 36 mm)",
        description="""Photographic cameras (35 mm cameras up to 24 x 36 mm)//Photoapparate (Kleinbildkameras bis 24 x 36 mm)""",
    )

    dfg_5400_3 = VocabularyTerm(
        code="DFG_5400_3",
        label="5400 Reflex cameras (up to 24 x 36 mm)",
        description="""Reflex cameras (up to 24 x 36 mm)//Spiegelreflexkameras (bis 24 x 36 mm)""",
    )

    dfg_5410_1 = VocabularyTerm(
        code="DFG_5410_1",
        label="5410 Large format cameras",
        description="""Large format cameras//Großbildkameras""",
    )

    dfg_5410_2 = VocabularyTerm(
        code="DFG_5410_2",
        label="5410 Large format cameras",
        description="""Large format cameras//Großformatkameras""",
    )

    dfg_5410_3 = VocabularyTerm(
        code="DFG_5410_3",
        label="5410 Cameras (format larger than 24 x 36 mm)",
        description="""Cameras (format larger than 24 x 36 mm)//Photoapparate (Format größer als 24 x 36 mm)""",
    )

    dfg_5410_4 = VocabularyTerm(
        code="DFG_5410_4",
        label="5410 Plate cameras",
        description="""Plate cameras//Plattenkameras""",
    )

    dfg_5410_5 = VocabularyTerm(
        code="DFG_5410_5",
        label="5410 Polaroid cameras (R)",
        description="""Polaroid cameras (R)//Polaroid-Kameras (R)""",
    )

    dfg_5410_6 = VocabularyTerm(
        code="DFG_5410_6",
        label="5410 Rolleiflex cameras 6x6 (R)",
        description="""Rolleiflex cameras 6x6 (R)//Rolleiflex-Kameras 6x6 (R)""",
    )

    dfg_5410_7 = VocabularyTerm(
        code="DFG_5410_7",
        label="5410 Instant cameras",
        description="""Instant cameras//Sofortbildkameras""",
    )

    dfg_5420_1 = VocabularyTerm(
        code="DFG_5420_1",
        label="5420 Film cameras (up to 100 frames/sec)",
        description="""Film cameras (up to 100 frames/sec)//Filmkameras (bis 100 Bilder/Sek)""",
    )

    dfg_5420_2 = VocabularyTerm(
        code="DFG_5420_2",
        label="5420 Normal film cameras",
        description="""Normal film cameras//Normalfilm-Kameras""",
    )

    dfg_5420_3 = VocabularyTerm(
        code="DFG_5420_3",
        label="5420 Cine film cameras",
        description="""Cine film cameras//Schmalfilmkameras""",
    )

    dfg_5430_1 = VocabularyTerm(
        code="DFG_5430_1",
        label="5430 CCD cameras",
        description="""CCD cameras//CCD-Kameras""",
    )

    dfg_5430_2 = VocabularyTerm(
        code="DFG_5430_2",
        label="5430 Revolving prism cameras",
        description="""Revolving prism cameras//Drehprismenkameras""",
    )

    dfg_5430_3 = VocabularyTerm(
        code="DFG_5430_3",
        label="5430 Revolving mirror cameras",
        description="""Revolving mirror cameras//Drehspiegelkameras""",
    )

    dfg_5430_4 = VocabularyTerm(
        code="DFG_5430_4",
        label="5430 Spark-flash cameras",
        description="""Spark-flash cameras//Funkenblitzkameras""",
    )

    dfg_5430_5 = VocabularyTerm(
        code="DFG_5430_5",
        label="5430 Spark slow motion cameras",
        description="""Spark slow motion cameras//Funkenzeitlupen""",
    )

    dfg_5430_6 = VocabularyTerm(
        code="DFG_5430_6",
        label="5430 High-frequency cameras",
        description="""High-frequency cameras//Hochfrequenzkameras""",
    )

    dfg_5430_7 = VocabularyTerm(
        code="DFG_5430_7",
        label="5430 High-speed cameras (from 100 frames/sec)",
        description="""High-speed cameras (from 100 frames/sec)//Hochgeschwindigkeits-Kameras (ab 100 Bilder/Sek)""",
    )

    dfg_5430_8 = VocabularyTerm(
        code="DFG_5430_8",
        label="5430 Drum cameras",
        description="""Drum cameras//Trommelkameras""",
    )

    dfg_5430_9 = VocabularyTerm(
        code="DFG_5430_9",
        label="5430 Time-expansion cameras (from 100 frames/sec)",
        description="""Time-expansion cameras (from 100 frames/sec)//Zeitdehnerkameras (ab 100 Bilder/Sek)""",
    )

    dfg_5439_1 = VocabularyTerm(
        code="DFG_5439_1",
        label="5439 Photorepeaters",
        description="""Photorepeaters//Photorepeater""",
    )

    dfg_5440_1 = VocabularyTerm(
        code="DFG_5440_1",
        label="5440 Exposure equipment for photoresist foils, printed circuit boards",
        description="""Exposure equipment for photoresist foils, printed circuit boards//Belichtungsgeräte für Photoresistfolien, Leiterplatten""",
    )

    dfg_5440_2 = VocabularyTerm(
        code="DFG_5440_2",
        label="5440 Thick film laboratory systems",
        description="""Thick film laboratory systems//Dickschicht-Laborsysteme""",
    )

    dfg_5440_3 = VocabularyTerm(
        code="DFG_5440_3",
        label="5440 Reproduction cameras",
        description="""Reproduction cameras//Reproduktionskameras""",
    )

    dfg_5450_1 = VocabularyTerm(
        code="DFG_5450_1",
        label="5450 Measuring chambers, terrestrial",
        description="""Measuring chambers, terrestrial//Messkammern, terrestrische""",
    )

    dfg_5450_2 = VocabularyTerm(
        code="DFG_5450_2",
        label="5450 Measuring chamber systems, ballistic (satellite geodesy)",
        description="""Measuring chamber systems, ballistic (satellite geodesy)//Messkammersysteme, ballistisch (Satellitengeodäsie)""",
    )

    dfg_5450_3 = VocabularyTerm(
        code="DFG_5450_3",
        label="5450 Multispectral cameras",
        description="""Multispectral cameras//Multispektralkameras""",
    )

    dfg_5450_4 = VocabularyTerm(
        code="DFG_5450_4",
        label="5450 Oscillograph cameras",
        description="""Oscillograph cameras//Oszillographen-Kameras""",
    )

    dfg_5450_5 = VocabularyTerm(
        code="DFG_5450_5",
        label="5450 Special photographic cameras (aerial, recording, stereo, except 0640-0660, 5400-5440 and 5460)",
        description="""Special photographic cameras (aerial, recording, stereo, except 0640-0660, 5400-5440 and 5460)//Photographische Spezialkameras (Luftbild-, Registrier-, Stereo-, außer 0640-0660, 5400-5440 und 5460)""",
    )

    dfg_5450_6 = VocabularyTerm(
        code="DFG_5450_6",
        label="5450 Series measuring chambers (aerial photography)",
        description="""Series measuring chambers (aerial photography)//Reihen-Messkammern (Luftbild)""",
    )

    dfg_5450_7 = VocabularyTerm(
        code="DFG_5450_7",
        label="5450 Satellite cameras",
        description="""Satellite cameras//Satellitenkameras""",
    )

    dfg_5450_8 = VocabularyTerm(
        code="DFG_5450_8",
        label="5450 Screen cameras (for oscilloscopes)",
        description="""Screen cameras (for oscilloscopes)//Schirmbildkameras (für Oszilloskope)""",
    )

    dfg_5450_9 = VocabularyTerm(
        code="DFG_5450_9",
        label="5450 Instant cameras for thermoplastic film",
        description="""Instant cameras for thermoplastic film//Sofortbildgeräte für thermoplastischen Film""",
    )

    dfg_5450_10 = VocabularyTerm(
        code="DFG_5450_10",
        label="5450 Underwater cameras",
        description="""Underwater cameras//Unterwasser-Kameras""",
    )

    dfg_5460_1 = VocabularyTerm(
        code="DFG_5460_1",
        label="5460 Top-mounted cameras",
        description="""Top-mounted cameras//Aufsetzkameras""",
    )

    dfg_5460_2 = VocabularyTerm(
        code="DFG_5460_2",
        label="5460 Micro-mount cameras",
        description="""Micro-mount cameras//Mikroaufsetzkameras""",
    )

    dfg_5460_3 = VocabularyTerm(
        code="DFG_5460_3",
        label="5460 Microcinematographic equipment",
        description="""Microcinematographic equipment//Mikrokinematographische Einrichtungen""",
    )

    dfg_5460_4 = VocabularyTerm(
        code="DFG_5460_4",
        label="5460 Microphotographic equipment",
        description="""Microphotographic equipment//Mikrophotographische Einrichtungen""",
    )

    dfg_5460_5 = VocabularyTerm(
        code="DFG_5460_5",
        label="5460 Microscope cameras",
        description="""Microscope cameras//Mikroskopkameras""",
    )

    dfg_5470_1 = VocabularyTerm(
        code="DFG_5470_1",
        label="5470 Anamorphic apparatus",
        description="""Anamorphic apparatus//Anamorphote""",
    )

    dfg_5470_2 = VocabularyTerm(
        code="DFG_5470_2",
        label="5470 Bellows adjusting devices",
        description="""Bellows adjusting devices//Balgeneinstellgeräte""",
    )

    dfg_5470_3 = VocabularyTerm(
        code="DFG_5470_3",
        label="5470 Stand-by bags (cameras)",
        description="""Stand-by bags (cameras)//Bereitschaftstaschen (Kameras)""",
    )

    dfg_5470_4 = VocabularyTerm(
        code="DFG_5470_4",
        label="5470 Rangefinders (photographic accessories)",
        description="""Rangefinders (photographic accessories)//Entfernungsmesser (Photozubehör)""",
    )

    dfg_5470_5 = VocabularyTerm(
        code="DFG_5470_5",
        label="5470 Filters (Photography)",
        description="""Filters (Photography)//Filter (Photographie)""",
    )

    dfg_5470_6 = VocabularyTerm(
        code="DFG_5470_6",
        label="5470 Fish-eye lenses, -lenses",
        description="""Fish-eye lenses, -lenses//Fischaugenlinsen, -objektive""",
    )

    dfg_5470_7 = VocabularyTerm(
        code="DFG_5470_7",
        label="5470 Noise protection bonnets (blimp) for cameras",
        description="""Noise protection bonnets (blimp) for cameras//Geräuschschutzhauben (Blimp) für Kameras""",
    )

    dfg_5470_8 = VocabularyTerm(
        code="DFG_5470_8",
        label="5470 Compendiums (photography)",
        description="""Compendiums (photography)//Kompendien (Photo-)""",
    )

    dfg_5470_9 = VocabularyTerm(
        code="DFG_5470_9",
        label="5470 Close-up lenses",
        description="""Close-up lenses//Naheinstellgeräte""",
    )

    dfg_5470_10 = VocabularyTerm(
        code="DFG_5470_10",
        label="5470 Tilting Arms, Tripods",
        description="""Tilting Arms, Tripods//Neigeköpfe, -Stative""",
    )

    dfg_5470_11 = VocabularyTerm(
        code="DFG_5470_11",
        label="5470 Photo accessories (lenses, tripods, filters)",
        description="""Photo accessories (lenses, tripods, filters)//Photozubehör (Objektive, Stative, Filter)""",
    )

    dfg_5470_12 = VocabularyTerm(
        code="DFG_5470_12",
        label="5470 Polarising Filters (Photographic Accessories)",
        description="""Polarising Filters (Photographic Accessories)//Polarisations-Filter (Photozubehör)""",
    )

    dfg_5470_13 = VocabularyTerm(
        code="DFG_5470_13",
        label="5470 Reproduction equipment for cameras",
        description="""Reproduction equipment for cameras//Reproduktionsgeräte, -Zusätze für Kameras""",
    )

    dfg_5470_14 = VocabularyTerm(
        code="DFG_5470_14",
        label="5470 Quick setting devices (photographic accessories)",
        description="""Quick setting devices (photographic accessories)//Schnelleinstellgeräte (Photozubehör)""",
    )

    dfg_5470_15 = VocabularyTerm(
        code="DFG_5470_15",
        label="5470 Mirror boxes (photographic accessories)",
        description="""Mirror boxes (photographic accessories)//Spiegelkästen (Photo-Zubehör)""",
    )

    dfg_5470_16 = VocabularyTerm(
        code="DFG_5470_16",
        label="5470 Tripods for cameras",
        description="""Tripods for cameras//Stative für Kameras""",
    )

    dfg_5470_17 = VocabularyTerm(
        code="DFG_5470_17",
        label="5470 Viewfinders (photographic accessories)",
        description="""Viewfinders (photographic accessories)//Sucher (Photo-Zubehör)""",
    )

    dfg_5470_18 = VocabularyTerm(
        code="DFG_5470_18",
        label="5470 Bags for photographic equipment",
        description="""Bags for photographic equipment//Taschen für Photogeräte""",
    )

    dfg_5470_19 = VocabularyTerm(
        code="DFG_5470_19",
        label="5470 Telephoto lenses",
        description="""Telephoto lenses//Teleobjektive""",
    )

    dfg_5470_20 = VocabularyTerm(
        code="DFG_5470_20",
        label="5470 Shutters (Photo-Zubehr)",
        description="""Shutters (Photo-Zubehr)//Verschlüsse (Photo-Zubehör)""",
    )

    dfg_5470_21 = VocabularyTerm(
        code="DFG_5470_21",
        label="5470 Close-up lenses",
        description="""Close-up lenses//Vorsatzlinsen""",
    )

    dfg_5470_22 = VocabularyTerm(
        code="DFG_5470_22",
        label="5470 Soft-focus lenses",
        description="""Soft-focus lenses//Weichzeichner""",
    )

    dfg_5470_23 = VocabularyTerm(
        code="DFG_5470_23",
        label="5470 Wide-angle lenses",
        description="""Wide-angle lenses//Weitwinkelobjektive""",
    )

    dfg_5480_1 = VocabularyTerm(
        code="DFG_5480_1",
        label="5480 Automatic Exposure Machines (Photo Lab)",
        description="""Automatic Exposure Machines (Photo Lab)//Belichtungsautomaten (Photolabor)""",
    )

    dfg_5480_2 = VocabularyTerm(
        code="DFG_5480_2",
        label="5480 Exposure clocks (photo lab)",
        description="""Exposure clocks (photo lab)//Belichtungsuhren (Photolabor)""",
    )

    dfg_5480_3 = VocabularyTerm(
        code="DFG_5480_3",
        label="5480 Cropping machines (photo lab)",
        description="""Cropping machines (photo lab)//Beschneidemaschinen (Photolabor)""",
    )

    dfg_5480_4 = VocabularyTerm(
        code="DFG_5480_4",
        label="5480 Darkroom equipment",
        description="""Darkroom equipment//Dunkelkammer-Einrichtungen""",
    )

    dfg_5480_5 = VocabularyTerm(
        code="DFG_5480_5",
        label="5480 Developing apparatus, trays, carriers (photo-lab)",
        description="""Developing apparatus, trays, carriers (photo-lab)//Entwicklungsgeräte, Schalen, Tröge (Photolabor)""",
    )

    dfg_5480_6 = VocabularyTerm(
        code="DFG_5480_6",
        label="5480 Developing machines (photo and X-ray laboratory)",
        description="""Developing machines (photo and X-ray laboratory)//Entwicklungsmaschinen (Photo- und Röntgenlabor)""",
    )

    dfg_5480_7 = VocabularyTerm(
        code="DFG_5480_7",
        label="5480 Colour mixing bowls (greening equipment)",
        description="""Colour mixing bowls (greening equipment)//Farbmischköpfe (Vergrößerungsgeräte)""",
    )

    dfg_5480_8 = VocabularyTerm(
        code="DFG_5480_8",
        label="5480 Film developing machines",
        description="""Film developing machines//Filmentwicklungsmaschinen""",
    )

    dfg_5480_9 = VocabularyTerm(
        code="DFG_5480_9",
        label="5480 Film gluing machines",
        description="""Film gluing machines//Filmklebegeräte""",
    )

    dfg_5480_10 = VocabularyTerm(
        code="DFG_5480_10",
        label="5480 Film cutting tables",
        description="""Film cutting tables//Filmschneidetische""",
    )

    dfg_5480_11 = VocabularyTerm(
        code="DFG_5480_11",
        label="5480 Film spools",
        description="""Film spools//Filmspulen""",
    )

    dfg_5480_12 = VocabularyTerm(
        code="DFG_5480_12",
        label="5480 Film rewinders",
        description="""Film rewinders//Filmumroller""",
    )

    dfg_5480_13 = VocabularyTerm(
        code="DFG_5480_13",
        label="5480 Gluing presses (photo lab)",
        description="""Gluing presses (photo lab)//Klebepressen (Photolabor)""",
    )

    dfg_5480_14 = VocabularyTerm(
        code="DFG_5480_14",
        label="5480 Automatic copying machines, copying equipment (photographic laboratory)",
        description="""Automatic copying machines, copying equipment (photographic laboratory)//Kopierautomaten, Kopiergeräte (Photolabor)""",
    )

    dfg_5480_15 = VocabularyTerm(
        code="DFG_5480_15",
        label="5480 Photographic laboratory apparatus and machines",
        description="""Photographic laboratory apparatus and machines//Photographische Laborgeräte und Maschinen""",
    )

    dfg_5480_16 = VocabularyTerm(
        code="DFG_5480_16",
        label="5480 Processors, developing machines (photographic laboratory)",
        description="""Processors, developing machines (photographic laboratory)//Prozessoren, Entwicklungsmaschinen (Photolabor)""",
    )

    dfg_5480_17 = VocabularyTerm(
        code="DFG_5480_17",
        label="5480 Cutting machines for photographic laboratories",
        description="""Cutting machines for photographic laboratories//Schneidemaschinen für Photolabore""",
    )

    dfg_5480_18 = VocabularyTerm(
        code="DFG_5480_18",
        label="5480 Drying machines, drying presses (photographic laboratory)",
        description="""Drying machines, drying presses (photographic laboratory)//Trockenmaschinen, Trockenpressen (Photolabor)""",
    )

    dfg_5480_19 = VocabularyTerm(
        code="DFG_5480_19",
        label="5480 Photocopying machines, optical",
        description="""Photocopying machines, optical//Umkopiermaschinen, Optische""",
    )

    dfg_5480_20 = VocabularyTerm(
        code="DFG_5480_20",
        label="5480 Enlargement machines, automatic machines, printers",
        description="""Enlargement machines, automatic machines, printers//Vergrößerungsgeräte, -automaten, Printer""",
    )

    dfg_5480_21 = VocabularyTerm(
        code="DFG_5480_21",
        label="5480 Greening cassettes",
        description="""Greening cassettes//Vergrößerungs-Kassetten""",
    )

    dfg_5480_22 = VocabularyTerm(
        code="DFG_5480_22",
        label="5480 Enlargement frames",
        description="""Enlargement frames//Vergrößerungs-Rahmen""",
    )

    dfg_5490_1 = VocabularyTerm(
        code="DFG_5490_1",
        label="5490 Other photographic and cinematographic apparatus (except 5400-5460)",
        description="""Other photographic and cinematographic apparatus (except 5400-5460)//Sonstige Photo- und Kinoapparate (außer 5400-5460)""",
    )

    dfg_5500_1 = VocabularyTerm(
        code="DFG_5500_1",
        label="5500 Tape projectors",
        description="""Tape projectors//Bildbandprojektoren""",
    )

    dfg_5500_2 = VocabularyTerm(
        code="DFG_5500_2",
        label="5500 Slide projectors and episcopes",
        description="""Slide projectors and episcopes//Diaprojektoren und Episkope""",
    )

    dfg_5500_3 = VocabularyTerm(
        code="DFG_5500_3",
        label="5500 Continuous projectors",
        description="""Continuous projectors//Endlosprojektoren""",
    )

    dfg_5500_4 = VocabularyTerm(
        code="DFG_5500_4",
        label="5500 Epidiascopes",
        description="""Epidiascopes//Epidiaskope""",
    )

    dfg_5500_5 = VocabularyTerm(
        code="DFG_5500_5",
        label="5500 Carousel projectors",
        description="""Carousel projectors//Karussellprojektoren""",
    )

    dfg_5500_6 = VocabularyTerm(
        code="DFG_5500_6",
        label="5500 Slide projectors",
        description="""Slide projectors//Lichtbildprojektoren""",
    )

    dfg_5500_7 = VocabularyTerm(
        code="DFG_5500_7",
        label="5500 Overhead projectors",
        description="""Overhead projectors//Overhead-Projektoren""",
    )

    dfg_5500_8 = VocabularyTerm(
        code="DFG_5500_8",
        label="5500 Writing projectors",
        description="""Writing projectors//Schreibprojektoren""",
    )

    dfg_5500_9 = VocabularyTerm(
        code="DFG_5500_9",
        label="5500 Daylight projectors",
        description="""Daylight projectors//Tageslicht-Projektoren""",
    )

    dfg_5510_1 = VocabularyTerm(
        code="DFG_5510_1",
        label="5510 Evaluation projectors",
        description="""Evaluation projectors//Auswerteprojektoren""",
    )

    dfg_5510_2 = VocabularyTerm(
        code="DFG_5510_2",
        label="5510 Film viewing, cutting machines",
        description="""Film viewing, cutting machines//Filmbetrachtungs-, Schneidegeräte""",
    )

    dfg_5510_3 = VocabularyTerm(
        code="DFG_5510_3",
        label="5510 Film projectors and projection machines",
        description="""Film projectors and projection machines//Filmprojektoren und Projektionsmaschinen""",
    )

    dfg_5510_4 = VocabularyTerm(
        code="DFG_5510_4",
        label="5510 Cinema projectors",
        description="""Cinema projectors//Kinoprojektoren""",
    )

    dfg_5510_5 = VocabularyTerm(
        code="DFG_5510_5",
        label="5510 Sound projectors",
        description="""Sound projectors//Lichttonprojektoren""",
    )

    dfg_5510_6 = VocabularyTerm(
        code="DFG_5510_6",
        label="5510 Magnetic sound projectors",
        description="""Magnetic sound projectors//Magnettonprojektoren""",
    )

    dfg_5510_7 = VocabularyTerm(
        code="DFG_5510_7",
        label="5510 Narrow film projectors",
        description="""Narrow film projectors//Schmalfilmprojektoren""",
    )

    dfg_5510_8 = VocabularyTerm(
        code="DFG_5510_8",
        label="5510 Still projectors",
        description="""Still projectors//Stillstandprojektoren""",
    )

    dfg_5510_9 = VocabularyTerm(
        code="DFG_5510_9",
        label="5510 Sound film projectors",
        description="""Sound film projectors//Tonfilmprojektoren""",
    )

    dfg_5520_1 = VocabularyTerm(
        code="DFG_5520_1",
        label="5520 Fiche duplicators",
        description="""Fiche duplicators//Fiche-Duplizierer""",
    )

    dfg_5520_2 = VocabularyTerm(
        code="DFG_5520_2",
        label="5520 Microfilm readers",
        description="""Microfilm readers//Lesegeräte für Mikrofilm""",
    )

    dfg_5520_3 = VocabularyTerm(
        code="DFG_5520_3",
        label="5520 Microfilm readers (microfilm)",
        description="""Microfilm readers (microfilm)//Lichtblicklesegeräte (Mikrofilm)""",
    )

    dfg_5520_4 = VocabularyTerm(
        code="DFG_5520_4",
        label="5520 Microfilm rigs, automatic rigs",
        description="""Microfilm rigs, automatic rigs//Mikrofilmgeräte, -automaten""",
    )

    dfg_5520_5 = VocabularyTerm(
        code="DFG_5520_5",
        label="5520 Microfilm cameras, readers and back enlargers",
        description="""Microfilm cameras, readers and back enlargers//Mikrofilm-Kameras, -Lese- und -Rückvergrößerungsgeräte""",
    )

    dfg_5520_6 = VocabularyTerm(
        code="DFG_5520_6",
        label="5520 Sprocket cameras (35 mm, 16 mm)",
        description="""Sprocket cameras (35 mm, 16 mm)//Sprocket-Kameras (35 mm, 16 mm)""",
    )

    dfg_5530_1 = VocabularyTerm(
        code="DFG_5530_1",
        label="5530 Holographic apparatus (except interferometers 5310)",
        description="""Holographic apparatus (except interferometers 5310)//Holographie-Einrichtungen (außer Interferometer 5310)""",
    )

    dfg_5530_2 = VocabularyTerm(
        code="DFG_5530_2",
        label="5530 Pulse holographic apparatus",
        description="""Pulse holographic apparatus//Impulsholographiegeräte""",
    )

    dfg_5540_1 = VocabularyTerm(
        code="DFG_5540_1",
        label="5540 Physiological optical instruments (except ophthalmological instruments 3640 and 5500-5530)",
        description="""Physiological optical instruments (except ophthalmological instruments 3640 and 5500-5530)//Physiologisch-optische Geräte (außer ophthalmologische Geräte 3640 und 5500-5530)""",
    )

    dfg_5560_1 = VocabularyTerm(
        code="DFG_5560_1",
        label="5560 Reading telescopes, collimators, periscopes",
        description="""Reading telescopes, collimators, periscopes//Ablesefernrohre, Kollimatoren, Periskope""",
    )

    dfg_5560_2 = VocabularyTerm(
        code="DFG_5560_2",
        label="5560 Autocollimator telescopes",
        description="""Autocollimator telescopes//Autokollimationsfernrohre""",
    )

    dfg_5560_3 = VocabularyTerm(
        code="DFG_5560_3",
        label="5560 Borehole periscopes, probes",
        description="""Borehole periscopes, probes//Bohrloch-Periskope, -Sonden""",
    )

    dfg_5560_4 = VocabularyTerm(
        code="DFG_5560_4",
        label="5560 Endoscopes (technical)",
        description="""Endoscopes (technical)//Endoskope (technisch)""",
    )

    dfg_5560_5 = VocabularyTerm(
        code="DFG_5560_5",
        label="5560 Crosshair telescopes",
        description="""Crosshair telescopes//Fadenkreuzfernrohre""",
    )

    dfg_5560_6 = VocabularyTerm(
        code="DFG_5560_6",
        label="5560 Fiberscopes, technical endoscopes",
        description="""Fiberscopes, technical endoscopes//Fiberscope, technische Endoskope""",
    )

    dfg_5560_7 = VocabularyTerm(
        code="DFG_5560_7",
        label="5560 Escape telescopes",
        description="""Escape telescopes//Fluchtfernrohre""",
    )

    dfg_5560_8 = VocabularyTerm(
        code="DFG_5560_8",
        label="5560 Collimating telescopes",
        description="""Collimating telescopes//Kollimationsfernrohre""",
    )

    dfg_5560_9 = VocabularyTerm(
        code="DFG_5560_9",
        label="5560 Telescopic sights, sighting devices",
        description="""Telescopic sights, sighting devices//Zielfernrohre, Visiereinrichtungen""",
    )

    dfg_5570_1 = VocabularyTerm(
        code="DFG_5570_1",
        label="5570 Focal length measuring devices",
        description="""Focal length measuring devices//Brennweitemessgeräte""",
    )

    dfg_5570_2 = VocabularyTerm(
        code="DFG_5570_2",
        label="5570 Binoculars",
        description="""Binoculars//Feldstecher""",
    )

    dfg_5570_3 = VocabularyTerm(
        code="DFG_5570_3",
        label="5570 Telescopes, binoculars (except 0700 and 5560)",
        description="""Telescopes, binoculars (except 0700 and 5560)//Fernrohre, Ferngläser (außer 0700 und 5560)""",
    )

    dfg_5570_4 = VocabularyTerm(
        code="DFG_5570_4",
        label="5570 Lens adjustment devices",
        description="""Lens adjustment devices//Linsen-Justiergeräte""",
    )

    dfg_5570_5 = VocabularyTerm(
        code="DFG_5570_5",
        label="5570 Measuring and testing equipment for optical instruments",
        description="""Measuring and testing equipment for optical instruments//Mess- und Prüfeinrichtungen für optische Geräte""",
    )

    dfg_5570_6 = VocabularyTerm(
        code="DFG_5570_6",
        label="5570 Objective lens gauges",
        description="""Objective lens gauges//Objektiv-Prüfgeräte""",
    )

    dfg_5570_7 = VocabularyTerm(
        code="DFG_5570_7",
        label="5570 Prismatic glasses",
        description="""Prismatic glasses//Prismengläser""",
    )

    dfg_5570_8 = VocabularyTerm(
        code="DFG_5570_8",
        label="5570 Scissors telescopes",
        description="""Scissors telescopes//Scherenfernrohre""",
    )

    dfg_5570_9 = VocabularyTerm(
        code="DFG_5570_9",
        label="5570 Sphrometers",
        description="""Sphrometers//Sphärometer""",
    )

    dfg_5570_10 = VocabularyTerm(
        code="DFG_5570_10",
        label="5570 Transmission function (optical), measuring equipment",
        description="""Transmission function (optical), measuring equipment//Übertragungsfunktion (optische), Messeinrichtungen""",
    )

    dfg_5580_1 = VocabularyTerm(
        code="DFG_5580_1",
        label="5580 Terrestrial telescopes, binoculars",
        description="""Terrestrial telescopes, binoculars//Terrestrische Fernrohre, Ferngläser""",
    )

    dfg_5600_1 = VocabularyTerm(
        code="DFG_5600_1",
        label="5600 Hollow cathode lamps",
        description="""Hollow cathode lamps//Hohlkathodenlampen""",
    )

    dfg_5600_2 = VocabularyTerm(
        code="DFG_5600_2",
        label="5600 Sodium lamps",
        description="""Sodium lamps//Natriumlampen""",
    )

    dfg_5600_3 = VocabularyTerm(
        code="DFG_5600_3",
        label="5600 Spectral lamps",
        description="""Spectral lamps//Spektrallampen""",
    )

    dfg_5600_4 = VocabularyTerm(
        code="DFG_5600_4",
        label="5600 Spectral light sources",
        description="""Spectral light sources//Spektrallichtquellen""",
    )

    dfg_5610_1 = VocabularyTerm(
        code="DFG_5610_1",
        label="5610 Ribbon lamps",
        description="""Ribbon lamps//Bandlampen""",
    )

    dfg_5610_2 = VocabularyTerm(
        code="DFG_5610_2",
        label="5610 Incandescent lamps and infrared heaters for special applications",
        description="""Incandescent lamps and infrared heaters for special applications//Glühlampen und Infrarotstrahler für spezielle Anwendung""",
    )

    dfg_5610_3 = VocabularyTerm(
        code="DFG_5610_3",
        label="5610 Nernst pens",
        description="""Nernst pens//Nernst-Stifte""",
    )

    dfg_5610_4 = VocabularyTerm(
        code="DFG_5610_4",
        label="5610 Projection lamps",
        description="""Projection lamps//Projektionslampen""",
    )

    dfg_5610_5 = VocabularyTerm(
        code="DFG_5610_5",
        label="5610 Quartz iodine lamps",
        description="""Quartz iodine lamps//Quarzjodlampen""",
    )

    dfg_5610_6 = VocabularyTerm(
        code="DFG_5610_6",
        label="5610 Blackbody lamps (measuring standards)",
        description="""Blackbody lamps (measuring standards)//Schwarze Strahler (Messnormale)""",
    )

    dfg_5610_7 = VocabularyTerm(
        code="DFG_5610_7",
        label="5610 Tungsten ribbon lamps",
        description="""Tungsten ribbon lamps//Wolframbandlampen""",
    )

    dfg_5620_1 = VocabularyTerm(
        code="DFG_5620_1",
        label="5620 Analysis lamps, analysis quartz lamps",
        description="""Analysis lamps, analysis quartz lamps//Analysenlampen, Analysen-Quarzlampen""",
    )

    dfg_5620_2 = VocabularyTerm(
        code="DFG_5620_2",
        label="5620 Arc lamps",
        description="""Arc lamps//Bogenlampen""",
    )

    dfg_5620_3 = VocabularyTerm(
        code="DFG_5620_3",
        label="5620 Deuterium lamps",
        description="""Deuterium lamps//Deuteriumlampen""",
    )

    dfg_5620_4 = VocabularyTerm(
        code="DFG_5620_4",
        label="5620 Disinfection lamps",
        description="""Disinfection lamps//Entkeimungsstrahler""",
    )

    dfg_5620_5 = VocabularyTerm(
        code="DFG_5620_5",
        label="5620 Gas discharge lamps for special applications, UV lamps",
        description="""Gas discharge lamps for special applications, UV lamps//Gasentladungslampen für spezielle Anwendung, UV-Strahler""",
    )

    dfg_5620_6 = VocabularyTerm(
        code="DFG_5620_6",
        label="5620 Photoreaction lamps",
        description="""Photoreaction lamps//Photoreaktionslampen""",
    )

    dfg_5620_7 = VocabularyTerm(
        code="DFG_5620_7",
        label="5620 Quartz lamps (arc lamps)",
        description="""Quartz lamps (arc lamps)//Quarzlampen (Bogenlampen)""",
    )

    dfg_5620_8 = VocabularyTerm(
        code="DFG_5620_8",
        label="5620 High-pressure mercury lamps",
        description="""High-pressure mercury lamps//Quecksilber-Hochdrucklampen""",
    )

    dfg_5620_9 = VocabularyTerm(
        code="DFG_5620_9",
        label="5620 Immersion lamps (UV lamps)",
        description="""Immersion lamps (UV lamps)//Tauchlampen (UV-Lampen)""",
    )

    dfg_5620_10 = VocabularyTerm(
        code="DFG_5620_10",
        label="5620 Ultraviolet lamps",
        description="""Ultraviolet lamps//Ultraviolett-Lampen""",
    )

    dfg_5620_11 = VocabularyTerm(
        code="DFG_5620_11",
        label="5620 Ultraviolet lamps, irradiation systems",
        description="""Ultraviolet lamps, irradiation systems//Ultraviolett-Strahler, -Bestrahlungssysteme""",
    )

    dfg_5620_12 = VocabularyTerm(
        code="DFG_5620_12",
        label="5620 Hydrogen lamps",
        description="""Hydrogen lamps//Wasserstofflampen""",
    )

    dfg_5620_13 = VocabularyTerm(
        code="DFG_5620_13",
        label="5620 Xenon high-pressure lamps",
        description="""Xenon high-pressure lamps//Xenon-Hochdrucklampen""",
    )

    dfg_5640_1 = VocabularyTerm(
        code="DFG_5640_1",
        label="5640 Flash lamps",
        description="""Flash lamps//Blitzlampen""",
    )

    dfg_5640_2 = VocabularyTerm(
        code="DFG_5640_2",
        label="5640 Flash light guns (photography)",
        description="""Flash light guns (photography)//Blitzlichtgeräte (Photographie)""",
    )

    dfg_5640_3 = VocabularyTerm(
        code="DFG_5640_3",
        label="5640 Electron flash rifles (photography, traffic)",
        description="""Electron flash rifles (photography, traffic)//Elektronenblitzgeräte (Photographie, Verkehr)""",
    )

    dfg_5640_4 = VocabularyTerm(
        code="DFG_5640_4",
        label="5640 Sparking flash rifles",
        description="""Sparking flash rifles//Funkenblitzgeräte""",
    )

    dfg_5640_5 = VocabularyTerm(
        code="DFG_5640_5",
        label="5640 Spark chamber flash lamps",
        description="""Spark chamber flash lamps//Funkenkammer-Blitzlampen""",
    )

    dfg_5640_6 = VocabularyTerm(
        code="DFG_5640_6",
        label="5640 Pulse lamps, flash rifles, stroboscopes",
        description="""Pulse lamps, flash rifles, stroboscopes//Impulslampen, Blitzgeräte, Stroboskope""",
    )

    dfg_5640_7 = VocabularyTerm(
        code="DFG_5640_7",
        label="5640 Ring flash lamps",
        description="""Ring flash lamps//Ringblitzleuchten""",
    )

    dfg_5640_8 = VocabularyTerm(
        code="DFG_5640_8",
        label="5640 Stroboscopes (except high-speed cameras 5430)",
        description="""Stroboscopes (except high-speed cameras 5430)//Stroboskope (außer Hochgeschwindigkeitskameras 5430)""",
    )

    dfg_5640_9 = VocabularyTerm(
        code="DFG_5640_9",
        label="5640 Traffic warning lamps (strobe and flashing lamps)",
        description="""Traffic warning lamps (strobe and flashing lamps)//Verkehrswarnleuchten (Blitz- und Blinklampen)""",
    )

    dfg_5640_10 = VocabularyTerm(
        code="DFG_5640_10",
        label="5640 Warning flashing lights",
        description="""Warning flashing lights//Warnblinkleuchten""",
    )

    dfg_5650_1 = VocabularyTerm(
        code="DFG_5650_1",
        label="5650 Double monochromators",
        description="""Double monochromators//Doppelmonochromatoren""",
    )

    dfg_5650_2 = VocabularyTerm(
        code="DFG_5650_2",
        label="5650 Ebert monochromators",
        description="""Ebert monochromators//Ebert-Monochromatoren""",
    )

    dfg_5650_3 = VocabularyTerm(
        code="DFG_5650_3",
        label="5650 Single monochromators",
        description="""Single monochromators//Einfachmonochromatoren""",
    )

    dfg_5650_4 = VocabularyTerm(
        code="DFG_5650_4",
        label="5650 Straight-vision (mirror) monochromators",
        description="""Straight-vision (mirror) monochromators//Geradsicht- (Spiegel-) Monochromatoren""",
    )

    dfg_5650_5 = VocabularyTerm(
        code="DFG_5650_5",
        label="5650 Grid monochromators",
        description="""Grid monochromators//Gittermonochromatoren""",
    )

    dfg_5650_6 = VocabularyTerm(
        code="DFG_5650_6",
        label="5650 Littrow monochromators",
        description="""Littrow monochromators//Littrow-Monochromatoren""",
    )

    dfg_5650_7 = VocabularyTerm(
        code="DFG_5650_7",
        label="5650 Monochromators (except X-ray 4050)",
        description="""Monochromators (except X-ray 4050)//Monochromatoren (außer Röntgen- 4050)""",
    )

    dfg_5650_8 = VocabularyTerm(
        code="DFG_5650_8",
        label="5650 Polychromators",
        description="""Polychromators//Polychromatoren""",
    )

    dfg_5650_9 = VocabularyTerm(
        code="DFG_5650_9",
        label="5650 Prism monochromators",
        description="""Prism monochromators//Prismenmonochromatoren""",
    )

    dfg_5650_10 = VocabularyTerm(
        code="DFG_5650_10",
        label="5650 UV monochromators",
        description="""UV monochromators//UV-Monochromatoren""",
    )

    dfg_5650_11 = VocabularyTerm(
        code="DFG_5650_11",
        label="5650 Vacuum UV monochromators",
        description="""Vacuum UV monochromators//Vakuum-UV-Monochromatoren""",
    )

    dfg_5660_1 = VocabularyTerm(
        code="DFG_5660_1",
        label="5660 Studio lights",
        description="""Studio lights//Atelierleuchten""",
    )

    dfg_5660_2 = VocabularyTerm(
        code="DFG_5660_2",
        label="5660 Stage lamps",
        description="""Stage lamps//Bühnenleuchten""",
    )

    dfg_5660_3 = VocabularyTerm(
        code="DFG_5660_3",
        label="5660 Pit lamps",
        description="""Pit lamps//Grubenlampen""",
    )

    dfg_5660_4 = VocabularyTerm(
        code="DFG_5660_4",
        label="5660 Portable lamps",
        description="""Portable lamps//Handscheinwerfer""",
    )

    dfg_5660_5 = VocabularyTerm(
        code="DFG_5660_5",
        label="5660 Infrared spotlights",
        description="""Infrared spotlights//Infrarot-Scheinwerfer""",
    )

    dfg_5660_6 = VocabularyTerm(
        code="DFG_5660_6",
        label="5660 Operating lights",
        description="""Operating lights//Operationsleuchten""",
    )

    dfg_5660_7 = VocabularyTerm(
        code="DFG_5660_7",
        label="5660 Photo lights",
        description="""Photo lights//Photoleuchten""",
    )

    dfg_5660_8 = VocabularyTerm(
        code="DFG_5660_8",
        label="5660 Spotlights and special lights",
        description="""Spotlights and special lights//Scheinwerfer und spezielle Leuchten""",
    )

    dfg_5660_9 = VocabularyTerm(
        code="DFG_5660_9",
        label="5660 Cloud spotlights",
        description="""Cloud spotlights//Wolkenscheinwerfer""",
    )

    dfg_5680_1 = VocabularyTerm(
        code="DFG_5680_1",
        label="5680 Lighting controllers, dimmers",
        description="""Lighting controllers, dimmers//Beleuchtungsregler, Lichtregler, Dimmer""",
    )

    dfg_5680_2 = VocabularyTerm(
        code="DFG_5680_2",
        label="5680 Lamp housings",
        description="""Lamp housings//Lampengehäuse""",
    )

    dfg_5680_3 = VocabularyTerm(
        code="DFG_5680_3",
        label="5680 Lamp housings, fixtures and accessories for light sources",
        description="""Lamp housings, fixtures and accessories for light sources//Lampenhäuser, Zündgeräte und Zubehör zu Lichtquellen""",
    )

    dfg_5680_4 = VocabularyTerm(
        code="DFG_5680_4",
        label="5680 Reflectors (Optics, Lighting)",
        description="""Reflectors (Optics, Lighting)//Reflektoren (Optik, Beleuchtung)""",
    )

    dfg_5680_5 = VocabularyTerm(
        code="DFG_5680_5",
        label="5680 Control devices for light sources",
        description="""Control devices for light sources//Steuergeräte für Lichtquellen""",
    )

    dfg_5680_6 = VocabularyTerm(
        code="DFG_5680_6",
        label="5680 Ballasts (for light sources)",
        description="""Ballasts (for light sources)//Vorschaltgeräte (für Lichtquellen)""",
    )

    dfg_5690_1 = VocabularyTerm(
        code="DFG_5690_1",
        label="5690 Fibre light sources",
        description="""Fibre light sources//Faserlichtquellen""",
    )

    dfg_5690_2 = VocabularyTerm(
        code="DFG_5690_2",
        label="5690 Other light sources (except 5600-5680, 5700-5790, 9070, 9170)",
        description="""Other light sources (except 5600-5680, 5700-5790, 9070, 9170)//Sonstige Lichtquellen (außer 5600-5680, 5700-5790, 9070, 9170)""",
    )

    dfg_5700_1 = VocabularyTerm(
        code="DFG_5700_1",
        label="5700 Solid-state lasers",
        description="""Solid-state lasers//Festkörper-Laser""",
    )

    dfg_5700_2 = VocabularyTerm(
        code="DFG_5700_2",
        label="5700 Solid-state ring lasers",
        description="""Solid-state ring lasers//Festkörper-Ringlaser""",
    )

    dfg_5700_3 = VocabularyTerm(
        code="DFG_5700_3",
        label="5700 Glass laser",
        description="""Glass laser//Glaslaser""",
    )

    dfg_5700_4 = VocabularyTerm(
        code="DFG_5700_4",
        label="5700 Pulse laser (solid-state laser)",
        description="""Pulse laser (solid-state laser)//Impulslaser (Festkörperlaser)""",
    )

    dfg_5700_5 = VocabularyTerm(
        code="DFG_5700_5",
        label="5700 Neodymium glass laser",
        description="""Neodymium glass laser//Neodym-Glas-Laser""",
    )

    dfg_5700_6 = VocabularyTerm(
        code="DFG_5700_6",
        label="5700 Neodymium YAG laser",
        description="""Neodymium YAG laser//Neodym-YAG-Laser""",
    )

    dfg_5700_7 = VocabularyTerm(
        code="DFG_5700_7",
        label="5700 Giant pulse laser (solid-state laser)",
        description="""Giant pulse laser (solid-state laser)//Riesenimpuls-Laser (Festkörperlaser)""",
    )

    dfg_5700_8 = VocabularyTerm(
        code="DFG_5700_8",
        label="5700 Ruby laser",
        description="""Ruby laser//Rubinlaser""",
    )

    dfg_5700_9 = VocabularyTerm(
        code="DFG_5700_9",
        label="5700 Titanium-sapphire laser",
        description="""Titanium-sapphire laser//Titan-Saphir-Laser""",
    )

    dfg_5700_10 = VocabularyTerm(
        code="DFG_5700_10",
        label="5700 YAG laser",
        description="""YAG laser//YAG-Laser""",
    )

    dfg_5710_1 = VocabularyTerm(
        code="DFG_5710_1",
        label="5710 Argon ion laser",
        description="""Argon ion laser//Argon-Ionen-Laser""",
    )

    dfg_5710_2 = VocabularyTerm(
        code="DFG_5710_2",
        label="5710 Cadmium laser",
        description="""Cadmium laser//Cadmium-Laser""",
    )

    dfg_5710_3 = VocabularyTerm(
        code="DFG_5710_3",
        label="5710 CO2 laser",
        description="""CO2 laser//CO2-Laser""",
    )

    dfg_5710_4 = VocabularyTerm(
        code="DFG_5710_4",
        label="5710 Continuous wave gas laser",
        description="""Continuous wave gas laser//Dauerstrich-Gaslaser""",
    )

    dfg_5710_5 = VocabularyTerm(
        code="DFG_5710_5",
        label="5710 Excimer laser",
        description="""Excimer laser//Excimer-Laser""",
    )

    dfg_5710_6 = VocabularyTerm(
        code="DFG_5710_6",
        label="5710 Gas laser",
        description="""Gas laser//Gas-Laser""",
    )

    dfg_5710_7 = VocabularyTerm(
        code="DFG_5710_7",
        label="5710 Helium-neon laser",
        description="""Helium-neon laser//Helium-Neon-Laser""",
    )

    dfg_5710_8 = VocabularyTerm(
        code="DFG_5710_8",
        label="5710 Ion laser",
        description="""Ion laser//Ionen-Laser""",
    )

    dfg_5710_9 = VocabularyTerm(
        code="DFG_5710_9",
        label="5710 Carbon dioxide laser",
        description="""Carbon dioxide laser//Kohlendioxid-Laser""",
    )

    dfg_5710_10 = VocabularyTerm(
        code="DFG_5710_10",
        label="5710 Krypton laser",
        description="""Krypton laser//Krypton-Laser""",
    )

    dfg_5710_11 = VocabularyTerm(
        code="DFG_5710_11",
        label="5710 Multigas laser",
        description="""Multigas laser//Multigaslaser""",
    )

    dfg_5710_12 = VocabularyTerm(
        code="DFG_5710_12",
        label="5710 Selenium laser, helium-",
        description="""Selenium laser, helium-//Selen-Laser, Helium-""",
    )

    dfg_5710_13 = VocabularyTerm(
        code="DFG_5710_13",
        label="5710 Nitrogen laser, helium-",
        description="""Nitrogen laser, helium-//Stickstoff-Laser, Helium-""",
    )

    dfg_5710_14 = VocabularyTerm(
        code="DFG_5710_14",
        label="5710 Tea laser (Transversely Excited Atmospheric Laser)",
        description="""Tea laser (Transversely Excited Atmospheric Laser)//Tea-Laser (Transversely Excited Atmospheric Laser)""",
    )

    dfg_5720_1 = VocabularyTerm(
        code="DFG_5720_1",
        label="5720 Dye laser, dye cells (dye laser)",
        description="""Dye laser, dye cells (dye laser)//Dye-Laser, Dye-Zellen (Farbstoff-Laser)""",
    )

    dfg_5720_2 = VocabularyTerm(
        code="DFG_5720_2",
        label="5720 Dye laser",
        description="""Dye laser//Farbstoff-Laser""",
    )

    dfg_5720_3 = VocabularyTerm(
        code="DFG_5720_3",
        label="5720 Dye ring laser",
        description="""Dye ring laser//Farbstoff-Ringlaser""",
    )

    dfg_5720_4 = VocabularyTerm(
        code="DFG_5720_4",
        label="5720 Laser compound systems (dye laser with pump laser, argon, nitrogen)",
        description="""Laser compound systems (dye laser with pump laser, argon, nitrogen)//Laser-Verbundsysteme (Farbstofflaser mit Pumplaser, Argon-, Stickstoff-)""",
    )

    dfg_5720_5 = VocabularyTerm(
        code="DFG_5720_5",
        label="5720 Ring lasers",
        description="""Ring lasers//Ringlaser""",
    )

    dfg_5730_1 = VocabularyTerm(
        code="DFG_5730_1",
        label="5730 Chemical lasers",
        description="""Chemical lasers//Chemische Laser""",
    )

    dfg_5730_2 = VocabularyTerm(
        code="DFG_5730_2",
        label="5730 Semiconductor lasers",
        description="""Semiconductor lasers//Halbleiter-Laser""",
    )

    dfg_5730_3 = VocabularyTerm(
        code="DFG_5730_3",
        label="5730 Light amplifiers (lasers)",
        description="""Light amplifiers (lasers)//Lichtverstärker (Laser)""",
    )

    dfg_5730_4 = VocabularyTerm(
        code="DFG_5730_4",
        label="5730 Mode-lock states, mode stabilisers for lasers",
        description="""Mode-lock states, mode stabilisers for lasers//Mode-Lock-Zusätze, Moden-Stabilisatoren für Laser""",
    )

    dfg_5730_5 = VocabularyTerm(
        code="DFG_5730_5",
        label="5730 Special lasers and stabilisers (frequency, mode)",
        description="""Special lasers and stabilisers (frequency, mode)//Spezielle Laser und -Stabilisierungsgeräte (Frequenz, Mode)""",
    )

    dfg_5740_1 = VocabularyTerm(
        code="DFG_5740_1",
        label="5740 Processing lasers",
        description="""Processing lasers//Bearbeitungslaser""",
    )

    dfg_5740_2 = VocabularyTerm(
        code="DFG_5740_2",
        label="5740 Lasers in manufacturing",
        description="""Lasers in manufacturing//Laser in der Fertigung""",
    )

    dfg_5740_3 = VocabularyTerm(
        code="DFG_5740_3",
        label="5740 Laser drilling machines",
        description="""Laser drilling machines//Laser-Bohrmaschinen""",
    )

    dfg_5740_4 = VocabularyTerm(
        code="DFG_5740_4",
        label="5740 Laser machines",
        description="""Laser machines//Lasermaschinen""",
    )

    dfg_5740_5 = VocabularyTerm(
        code="DFG_5740_5",
        label="5740 Laser welding machines",
        description="""Laser welding machines//Laser-Schweißgeräte""",
    )

    dfg_5740_6 = VocabularyTerm(
        code="DFG_5740_6",
        label="5740 Laser trimming and scribing machines",
        description="""Laser trimming and scribing machines//Laser-Trimmgeräte und Scriber""",
    )

    dfg_5740_7 = VocabularyTerm(
        code="DFG_5740_7",
        label="5740 Selective laser melting (SLM)",
        description="""Selective laser melting (SLM)//Selektives Laserschmelzen (SLM)""",
    )

    dfg_5750_1 = VocabularyTerm(
        code="DFG_5750_1",
        label="5750 Special laser measuring systems (e.g. laser Doppler vibrometers)",
        description="""Special laser measuring systems (e.g. laser Doppler vibrometers)//Spezielle Laser-Mess-Systeme (z.B. Laser-Doppler-Vibrometer)""",
    )

    dfg_5760_1 = VocabularyTerm(
        code="DFG_5760_1",
        label="5760 Laser optics (beam expansion, mode filters)",
        description="""Laser optics (beam expansion, mode filters)//Laser-Optik (Strahlaufweitung, Modenfilter)""",
    )

    dfg_5760_2 = VocabularyTerm(
        code="DFG_5760_2",
        label="5760 Space filters (laser optics)",
        description="""Space filters (laser optics)//Raumfilter (Laser-Optik)""",
    )

    dfg_5770_1 = VocabularyTerm(
        code="DFG_5770_1",
        label="5770 Acousto-optical deflectors, modulators",
        description="""Acousto-optical deflectors, modulators//Akustooptische Deflektoren, Modulatoren""",
    )

    dfg_5770_2 = VocabularyTerm(
        code="DFG_5770_2",
        label="5770 Cavity dumpers (acousto-optical switches)",
        description="""Cavity dumpers (acousto-optical switches)//Cavity-Dumper (akustooptische Schalter)""",
    )

    dfg_5770_3 = VocabularyTerm(
        code="DFG_5770_3",
        label="5770 Electro-optical components (modulators, switches)",
        description="""Electro-optical components (modulators, switches)//Elektrooptische Bauelemente (Modulatoren, Schalter)""",
    )

    dfg_5770_4 = VocabularyTerm(
        code="DFG_5770_4",
        label="5770 Etalons (lasers)",
        description="""Etalons (lasers)//Etalons (Laser)""",
    )

    dfg_5770_5 = VocabularyTerm(
        code="DFG_5770_5",
        label="5770 Gt switches",
        description="""Gt switches//Güteschalter""",
    )

    dfg_5770_6 = VocabularyTerm(
        code="DFG_5770_6",
        label="5770 Kerr cells",
        description="""Kerr cells//Kerr-Zellen""",
    )

    dfg_5770_7 = VocabularyTerm(
        code="DFG_5770_7",
        label="5770 Laser timers",
        description="""Laser timers//Laser Timer""",
    )

    dfg_5770_8 = VocabularyTerm(
        code="DFG_5770_8",
        label="5770 Laser modulators",
        description="""Laser modulators//Laser-Modulatoren""",
    )

    dfg_5770_9 = VocabularyTerm(
        code="DFG_5770_9",
        label="5770 Light modulators, electro-optics, magneto-optics",
        description="""Light modulators, electro-optics, magneto-optics//Lichtmodulatoren, Elektrooptik, Magnetooptik""",
    )

    dfg_5770_10 = VocabularyTerm(
        code="DFG_5770_10",
        label="5770 Pockels cells",
        description="""Pockels cells//Pockels-Zellen""",
    )

    dfg_5770_11 = VocabularyTerm(
        code="DFG_5770_11",
        label="5770 Pulse cutting cells for lasers",
        description="""Pulse cutting cells for lasers//Pulsschneidezellen für Laser""",
    )

    dfg_5770_12 = VocabularyTerm(
        code="DFG_5770_12",
        label="5770 Pulse selectors",
        description="""Pulse selectors//Puls-Selektoren""",
    )

    dfg_5770_13 = VocabularyTerm(
        code="DFG_5770_13",
        label="5770 Q-Switches",
        description="""Q-Switches//Q-Switches""",
    )

    dfg_5770_14 = VocabularyTerm(
        code="DFG_5770_14",
        label="5770 Control devices for light modulators",
        description="""Control devices for light modulators//Steuergeräte für Lichtmodulatoren""",
    )

    dfg_5780_1 = VocabularyTerm(
        code="DFG_5780_1",
        label="5780 Frequency doublers, frequency multipliers (optics)",
        description="""Frequency doublers, frequency multipliers (optics)//Frequenz-Verdoppler, Frequenzvervielfacher (Optik)""",
    )

    dfg_5780_2 = VocabularyTerm(
        code="DFG_5780_2",
        label="5780 Laser frequency doublers",
        description="""Laser frequency doublers//Laser-Frequenz-Verdoppler""",
    )

    dfg_5780_3 = VocabularyTerm(
        code="DFG_5780_3",
        label="5780 Non-linear optics (frequency multipliers)",
        description="""Non-linear optics (frequency multipliers)//Nichtlineare Optik (Frequenzvervielfacher)""",
    )

    dfg_5790_1 = VocabularyTerm(
        code="DFG_5790_1",
        label="5790 Laser crystals",
        description="""Laser crystals//Laser-Kristalle""",
    )

    dfg_5790_2 = VocabularyTerm(
        code="DFG_5790_2",
        label="5790 Laser power supplies",
        description="""Laser power supplies//Laser-Netzgeräte""",
    )

    dfg_5790_3 = VocabularyTerm(
        code="DFG_5790_3",
        label="5790 Plasma tubes for lasers",
        description="""Plasma tubes for lasers//Plasma-Rohre für Laser""",
    )

    dfg_5790_4 = VocabularyTerm(
        code="DFG_5790_4",
        label="5790 Other lasers and accessories (except 5700-5780)",
        description="""Other lasers and accessories (except 5700-5780)//Sonstige Laser und Zubehör (außer 5700-5780)""",
    )

    dfg_5800_1 = VocabularyTerm(
        code="DFG_5800_1",
        label="5800 CdS photoresistors",
        description="""CdS photoresistors//CdS-Photowiderstände""",
    )

    dfg_5800_2 = VocabularyTerm(
        code="DFG_5800_2",
        label="5800 Visible light (VIS) detectors",
        description="""Visible light (VIS) detectors//Detektoren für sichtbares Licht (VIS)""",
    )

    dfg_5800_3 = VocabularyTerm(
        code="DFG_5800_3",
        label="5800 UV detectors",
        description="""UV detectors//Detektoren für UV""",
    )

    dfg_5800_4 = VocabularyTerm(
        code="DFG_5800_4",
        label="5800 Diode (photo) array, grid, photodiode lines",
        description="""Diode (photo) array, grid, photodiode lines//Dioden (Photo-)-Array, -Raster, Photodioden-Zeilen""",
    )

    dfg_5800_5 = VocabularyTerm(
        code="DFG_5800_5",
        label="5800 Photodetectors, -cells, -resistors for UV/VIS",
        description="""Photodetectors, -cells, -resistors for UV/VIS//Photodetektoren, -zellen, -widerstände für UV/VIS""",
    )

    dfg_5800_6 = VocabularyTerm(
        code="DFG_5800_6",
        label="5800 Photodiodes, -transistors",
        description="""Photodiodes, -transistors//Photodioden, -transistoren""",
    )

    dfg_5800_7 = VocabularyTerm(
        code="DFG_5800_7",
        label="5800 Photodiode arrays",
        description="""Photodiode arrays//Photodioden-Arrays""",
    )

    dfg_5800_8 = VocabularyTerm(
        code="DFG_5800_8",
        label="5800 Photoresistors, photoconductive detectors (for UV/VIS)",
        description="""Photoresistors, photoconductive detectors (for UV/VIS)//Photowiderstände, Photoleit-Detektoren (für UV/VIS)""",
    )

    dfg_5800_9 = VocabularyTerm(
        code="DFG_5800_9",
        label="5800 Photocells (vacuum and gas filled)",
        description="""Photocells (vacuum and gas filled)//Photozellen (vacuum- und gasgefüllte)""",
    )

    dfg_5800_10 = VocabularyTerm(
        code="DFG_5800_10",
        label="5800 Vacuum photocells",
        description="""Vacuum photocells//Vakuumphotozellen""",
    )

    dfg_5810_1 = VocabularyTerm(
        code="DFG_5810_1",
        label="5810 Photoelectric converters, photoelements, solar cells, photovoltaics",
        description="""Photoelectric converters, photoelements, solar cells, photovoltaics//Photoelektrische Wandler, Photoelemente, Solarzellen, Photovoltaik""",
    )

    dfg_5810_2 = VocabularyTerm(
        code="DFG_5810_2",
        label="5810 Photovoltaic systems",
        description="""Photovoltaic systems//Photovoltaik-Systeme""",
    )

    dfg_5810_3 = VocabularyTerm(
        code="DFG_5810_3",
        label="5810 Selenium cells",
        description="""Selenium cells//Selen-Zellen""",
    )

    dfg_5810_4 = VocabularyTerm(
        code="DFG_5810_4",
        label="5810 Silicon cells",
        description="""Silicon cells//Silizium-Zellen""",
    )

    dfg_5810_5 = VocabularyTerm(
        code="DFG_5810_5",
        label="5810 Solar cells",
        description="""Solar cells//Solarzellen""",
    )

    dfg_5820_1 = VocabularyTerm(
        code="DFG_5820_1",
        label="5820 Channeltrons",
        description="""Channeltrons//Channeltrons""",
    )

    dfg_5820_2 = VocabularyTerm(
        code="DFG_5820_2",
        label="5820 Electron multipliers",
        description="""Electron multipliers//Elektronenvervielfacher""",
    )

    dfg_5820_3 = VocabularyTerm(
        code="DFG_5820_3",
        label="5820 Channel electron multipliers",
        description="""Channel electron multipliers//Kanalelektronenvervielfacher""",
    )

    dfg_5820_4 = VocabularyTerm(
        code="DFG_5820_4",
        label="5820 Channel Plate Image Intensifier, Electron Multiplier",
        description="""Channel Plate Image Intensifier, Electron Multiplier//Kanalplattenbildverstärker, -elektronenvervielfacher""",
    )

    dfg_5820_5 = VocabularyTerm(
        code="DFG_5820_5",
        label="5820 Multiplier, Electron-",
        description="""Multiplier, Electron-//Multiplier, Electron-""",
    )

    dfg_5820_6 = VocabularyTerm(
        code="DFG_5820_6",
        label="5820 Photoelectron multiplier",
        description="""Photoelectron multiplier//Photoelektronen-Vervielfacher""",
    )

    dfg_5820_7 = VocabularyTerm(
        code="DFG_5820_7",
        label="5820 Photomultiplier",
        description="""Photomultiplier//Photomultiplier""",
    )

    dfg_5820_8 = VocabularyTerm(
        code="DFG_5820_8",
        label="5820 Secondary electron multipliers",
        description="""Secondary electron multipliers//Sekundär-Elektronen-Vervielfacher""",
    )

    dfg_5830_1 = VocabularyTerm(
        code="DFG_5830_1",
        label="5830 Thermoelectric transducers, thermocouples",
        description="""Thermoelectric transducers, thermocouples//Thermoelektrische Wandler, Thermosäulen""",
    )

    dfg_5830_2 = VocabularyTerm(
        code="DFG_5830_2",
        label="5830 Thermocouples",
        description="""Thermocouples//Thermoelemente""",
    )

    dfg_5840_1 = VocabularyTerm(
        code="DFG_5840_1",
        label="5840 Bolometers",
        description="""Bolometers//Bolometer""",
    )

    dfg_5840_2 = VocabularyTerm(
        code="DFG_5840_2",
        label="5840 Golay detectors",
        description="""Golay detectors//Golay-Detektoren""",
    )

    dfg_5840_3 = VocabularyTerm(
        code="DFG_5840_3",
        label="5840 Semiconductor detectors (IR)",
        description="""Semiconductor detectors (IR)//Halbleiter-Detektoren (IR)""",
    )

    dfg_5840_4 = VocabularyTerm(
        code="DFG_5840_4",
        label="5840 Infrared photoconductors",
        description="""Infrared photoconductors//Infrarot-Photowiderstände""",
    )

    dfg_5840_5 = VocabularyTerm(
        code="DFG_5840_5",
        label="5840 Pyroelectric detectors (except Joulemeter 5860)",
        description="""Pyroelectric detectors (except Joulemeter 5860)//Pyroelektrische Detektoren (außer Joulemeter 5860)""",
    )

    dfg_5840_6 = VocabularyTerm(
        code="DFG_5840_6",
        label="5840 Special infrared detectors",
        description="""Special infrared detectors//Spezielle Infrarot-Detektoren""",
    )

    dfg_5840_7 = VocabularyTerm(
        code="DFG_5840_7",
        label="5840 TGS detectors (triglycine sulphate)",
        description="""TGS detectors (triglycine sulphate)//TGS-Detektoren (Triglyzinsulfat)""",
    )

    dfg_5840_8 = VocabularyTerm(
        code="DFG_5840_8",
        label="5840 Thermistor bolometers",
        description="""Thermistor bolometers//Thermistor-Bolometer""",
    )

    dfg_5840_9 = VocabularyTerm(
        code="DFG_5840_9",
        label="5840 Triglycine sulphate detectors",
        description="""Triglycine sulphate detectors//Triglyzinsulfat-Detektoren""",
    )

    dfg_5860_1 = VocabularyTerm(
        code="DFG_5860_1",
        label="5860 Energy, power analyzers for the spatial analysis of laser beams (linear array)",
        description="""Energy, power analyzers for the spatial analysis of laser beams (linear array)//Energie-, Leistungsanalysatoren für räumliche Analyse von Laserstrahlen (Linear Array)""",
    )

    dfg_5860_2 = VocabularyTerm(
        code="DFG_5860_2",
        label="5860 Laser energy meters (Energy Meters)",
        description="""Laser energy meters (Energy Meters)//Energiemessgeräte für Laser (Energy Meters)""",
    )

    dfg_5860_3 = VocabularyTerm(
        code="DFG_5860_3",
        label="5860 Joulemeters (laser energy meters)",
        description="""Joulemeters (laser energy meters)//Joulemeter (Laser-Energiemessgeräte)""",
    )

    dfg_5860_4 = VocabularyTerm(
        code="DFG_5860_4",
        label="5860 Laser power meters",
        description="""Laser power meters//Laser-Leistungsmessgeräte""",
    )

    dfg_5860_5 = VocabularyTerm(
        code="DFG_5860_5",
        label="5860 Photon Drag Detectors",
        description="""Photon Drag Detectors//Photon Drag Detektoren""",
    )

    dfg_5860_6 = VocabularyTerm(
        code="DFG_5860_6",
        label="5860 Pyroelectric joulemeters",
        description="""Pyroelectric joulemeters//Pyroelektrische Joulemeter""",
    )

    dfg_5860_7 = VocabularyTerm(
        code="DFG_5860_7",
        label="5860 Radiometers for lasers",
        description="""Radiometers for lasers//Radiometer für Laser""",
    )

    dfg_5890_1 = VocabularyTerm(
        code="DFG_5890_1",
        label="5890 Opto-electronic couplers, opto-couplers",
        description="""Opto-electronic couplers, opto-couplers//Opto-elektronische Koppler, Opto-Koppler""",
    )

    dfg_5890_2 = VocabularyTerm(
        code="DFG_5890_2",
        label="5890 Photoreceivers (except 5800-5860)",
        description="""Photoreceivers (except 5800-5860)//Photoempfänger (außer 5800-5860)""",
    )

    dfg_5890_3 = VocabularyTerm(
        code="DFG_5890_3",
        label="5890 Other photodetectors (except 5800-5860)",
        description="""Other photodetectors (except 5800-5860)//Sonstige Photodetektoren (außer 5800-5860)""",
    )

    dfg_5900_1 = VocabularyTerm(
        code="DFG_5900_1",
        label="5900 Coordinate tables (for optical components)",
        description="""Coordinate tables (for optical components)//Koordinatentische (für optische Komponenten)""",
    )

    dfg_5900_2 = VocabularyTerm(
        code="DFG_5900_2",
        label="5900 Optical benches including mechanical components",
        description="""Optical benches including mechanical components//Optische Bänke einschl. mechanischer Bauelemente""",
    )

    dfg_5900_3 = VocabularyTerm(
        code="DFG_5900_3",
        label="5900 Optical tables",
        description="""Optical tables//Optische Tische""",
    )

    dfg_5900_4 = VocabularyTerm(
        code="DFG_5900_4",
        label="5900 Plates, base plates, granite plates for optical measuring systems",
        description="""Plates, base plates, granite plates for optical measuring systems//Platten, Grundplatten, Granitplatten für optische Messsysteme""",
    )

    dfg_5900_5 = VocabularyTerm(
        code="DFG_5900_5",
        label="5900 Positioning tables for optical components",
        description="""Positioning tables for optical components//Positionierungen für optische Komponenten""",
    )

    dfg_5900_6 = VocabularyTerm(
        code="DFG_5900_6",
        label="5900 Rotary tables, positioning tables (for optical components)",
        description="""Rotary tables, positioning tables (for optical components)//Rotationstische, Positioniertische (für optische Komponenten)""",
    )

    dfg_5900_7 = VocabularyTerm(
        code="DFG_5900_7",
        label="5900 Stepping motor drives for optical components",
        description="""Stepping motor drives for optical components//Schrittmotorantriebe für optische Komponenten""",
    )

    dfg_5900_8 = VocabularyTerm(
        code="DFG_5900_8",
        label="5900 Vibration-isolated tables (for optical measurements)",
        description="""Vibration-isolated tables (for optical measurements)//Schwingungsisolierte Tische (für optische Messungen)""",
    )

    dfg_5910_1 = VocabularyTerm(
        code="DFG_5910_1",
        label="5910 Prisms",
        description="""Prisms//Prismen""",
    )

    dfg_5920_1 = VocabularyTerm(
        code="DFG_5920_1",
        label="5920 Dichroic mirrors",
        description="""Dichroic mirrors//Dichroitische Spiegel""",
    )

    dfg_5920_2 = VocabularyTerm(
        code="DFG_5920_2",
        label="5920 Dielectric mirrors",
        description="""Dielectric mirrors//Dielektrische Spiegel""",
    )

    dfg_5920_3 = VocabularyTerm(
        code="DFG_5920_3",
        label="5920 Rotating mirrors, mirror systems",
        description="""Rotating mirrors, mirror systems//Drehspiegel, Spiegelsysteme""",
    )

    dfg_5920_4 = VocabularyTerm(
        code="DFG_5920_4",
        label="5920 Concave mirrors",
        description="""Concave mirrors//Hohlspiegel""",
    )

    dfg_5920_5 = VocabularyTerm(
        code="DFG_5920_5",
        label="5920 Black glass mirrors",
        description="""Black glass mirrors//Schwarzglasspiegel""",
    )

    dfg_5920_6 = VocabularyTerm(
        code="DFG_5920_6",
        label="5920 Mirrors, mirror optics",
        description="""Mirrors, mirror optics//Spiegel, Spiegel-Optik""",
    )

    dfg_5920_7 = VocabularyTerm(
        code="DFG_5920_7",
        label="5920 Triple mirrors, mirror corners",
        description="""Triple mirrors, mirror corners//Tripelspiegel, Spiegelecken""",
    )

    dfg_5930_1 = VocabularyTerm(
        code="DFG_5930_1",
        label="5930 Analysers (polarisation optics)",
        description="""Analysers (polarisation optics)//Analysatoren (Polarisationsoptik)""",
    )

    dfg_5930_2 = VocabularyTerm(
        code="DFG_5930_2",
        label="5930 Brewster plates",
        description="""Brewster plates//Brewster-Platten""",
    )

    dfg_5930_3 = VocabularyTerm(
        code="DFG_5930_3",
        label="5930 Roof prisms",
        description="""Roof prisms//Dachkantprismen""",
    )

    dfg_5930_4 = VocabularyTerm(
        code="DFG_5930_4",
        label="5930 Glan-Thompson prisms",
        description="""Glan-Thompson prisms//Glan-Thompson-Prismen""",
    )

    dfg_5930_5 = VocabularyTerm(
        code="DFG_5930_5",
        label="5930 Harmonic beam splitters",
        description="""Harmonic beam splitters//Harmonische Strahlenteiler""",
    )

    dfg_5930_6 = VocabularyTerm(
        code="DFG_5930_6",
        label="5930 Plane-parallel plates",
        description="""Plane-parallel plates//Planparallele Platten""",
    )

    dfg_5930_7 = VocabularyTerm(
        code="DFG_5930_7",
        label="5930 Polarisers",
        description="""Polarisers//Polarisatoren""",
    )

    dfg_5930_8 = VocabularyTerm(
        code="DFG_5930_8",
        label="5930 Prisms, beam splitters and polarisation optics",
        description="""Prisms, beam splitters and polarisation optics//Prismen, Strahlenteiler und Polarisationsoptik""",
    )

    dfg_5930_9 = VocabularyTerm(
        code="DFG_5930_9",
        label="5930 Divider cubes, plates (optics)",
        description="""Divider cubes, plates (optics)//Teilerwürfel, -platten (Optik)""",
    )

    dfg_5930_10 = VocabularyTerm(
        code="DFG_5930_10",
        label="5930 Dislocation plates (optics)",
        description="""Dislocation plates (optics)//Verzögerungsplatten (Optik)""",
    )

    dfg_5940_1 = VocabularyTerm(
        code="DFG_5940_1",
        label="5940 Diffraction gratings",
        description="""Diffraction gratings//Beugungsgitter""",
    )

    dfg_5940_2 = VocabularyTerm(
        code="DFG_5940_2",
        label="5940 Echelette gratings",
        description="""Echelette gratings//Echelette-Gitter""",
    )

    dfg_5940_3 = VocabularyTerm(
        code="DFG_5940_3",
        label="5940 Concave gratings",
        description="""Concave gratings//Konkavgitter""",
    )

    dfg_5940_4 = VocabularyTerm(
        code="DFG_5940_4",
        label="5940 Optical gratings",
        description="""Optical gratings//Optische Gitter""",
    )

    dfg_5940_5 = VocabularyTerm(
        code="DFG_5940_5",
        label="5940 Planar gratings",
        description="""Planar gratings//Plangitter""",
    )

    dfg_5940_6 = VocabularyTerm(
        code="DFG_5940_6",
        label="5940 UV gratings",
        description="""UV gratings//UV-Gitter""",
    )

    dfg_5950_1 = VocabularyTerm(
        code="DFG_5950_1",
        label="5950 Apertures, slits",
        description="""Apertures, slits//Blenden, Spalte""",
    )

    dfg_5950_2 = VocabularyTerm(
        code="DFG_5950_2",
        label="5950 Light chopper",
        description="""Light chopper//Lichtchopper""",
    )

    dfg_5950_3 = VocabularyTerm(
        code="DFG_5950_3",
        label="5950 Light interrupters",
        description="""Light interrupters//Lichtunterbrecher""",
    )

    dfg_5950_4 = VocabularyTerm(
        code="DFG_5950_4",
        label="5950 Light shutters",
        description="""Light shutters//Lichtverschlüsse""",
    )

    dfg_5950_5 = VocabularyTerm(
        code="DFG_5950_5",
        label="5950 Rotating shutters",
        description="""Rotating shutters//Rotierende Blenden""",
    )

    dfg_5950_6 = VocabularyTerm(
        code="DFG_5950_6",
        label="5950 Shutters (optical)",
        description="""Shutters (optical)//Verschlüsse (Optische)""",
    )

    dfg_5960_1 = VocabularyTerm(
        code="DFG_5960_1",
        label="5960 Filters (optical)",
        description="""Filters (optical)//Filter (optische)""",
    )

    dfg_5960_2 = VocabularyTerm(
        code="DFG_5960_2",
        label="5960 Grey filters",
        description="""Grey filters//Grau-Filter""",
    )

    dfg_5960_3 = VocabularyTerm(
        code="DFG_5960_3",
        label="5960 Interference filters",
        description="""Interference filters//Interferenzfilter""",
    )

    dfg_5960_4 = VocabularyTerm(
        code="DFG_5960_4",
        label="5960 Light filters",
        description="""Light filters//Lichtfilter""",
    )

    dfg_5960_5 = VocabularyTerm(
        code="DFG_5960_5",
        label="5960 Lyot filters",
        description="""Lyot filters//Lyot-Filter""",
    )

    dfg_5960_6 = VocabularyTerm(
        code="DFG_5960_6",
        label="5960 Polarisation interference filters",
        description="""Polarisation interference filters//Polarisations-Interferenz-Filter""",
    )

    dfg_5960_7 = VocabularyTerm(
        code="DFG_5960_7",
        label="5960 Narrow-band optical filters",
        description="""Narrow-band optical filters//Schmalbandfilter optische""",
    )

    dfg_5970_1 = VocabularyTerm(
        code="DFG_5970_1",
        label="5970 Aspherical lenses, condensers",
        description="""Aspherical lenses, condensers//Asphärische Linsen, Kondensoren""",
    )

    dfg_5970_2 = VocabularyTerm(
        code="DFG_5970_2",
        label="5970 Lenses, condensers",
        description="""Lenses, condensers//Linsen, Kondensoren""",
    )

    dfg_5970_3 = VocabularyTerm(
        code="DFG_5970_3",
        label="5970 Magnifiers, hand magnifiers",
        description="""Magnifiers, hand magnifiers//Lupen, Handlupen""",
    )

    dfg_5970_4 = VocabularyTerm(
        code="DFG_5970_4",
        label="5970 Objectives (except for cameras and microscopes)",
        description="""Objectives (except for cameras and microscopes)//Objektive (außer für Kameras und Mikroskope)""",
    )

    dfg_5980_1 = VocabularyTerm(
        code="DFG_5980_1",
        label="5980 Fibre optic components",
        description="""Fibre optic components//Faseroptische Bauelemente""",
    )

    dfg_5980_2 = VocabularyTerm(
        code="DFG_5980_2",
        label="5980 Fibre optics, fibre optics, components",
        description="""Fibre optics, fibre optics, components//Glasfaser-Optik, Fiberoptik, Bauelemente""",
    )

    dfg_5980_3 = VocabularyTerm(
        code="DFG_5980_3",
        label="5980 Optical fibres",
        description="""Optical fibres//Lichtleiter""",
    )

    dfg_5990_1 = VocabularyTerm(
        code="DFG_5990_1",
        label="5990 Other optical components",
        description="""Other optical components//Sonstige optische Bauelemente""",
    )

    dfg_6000_1 = VocabularyTerm(
        code="DFG_6000_1",
        label="6000 Batteries",
        description="""Batteries//Batterien""",
    )

    dfg_6000_2 = VocabularyTerm(
        code="DFG_6000_2",
        label="6000 Elements and accumulators",
        description="""Elements and accumulators//Elemente und Akkumulatoren""",
    )

    dfg_6000_3 = VocabularyTerm(
        code="DFG_6000_3",
        label="6000 Cadmium standard elements",
        description="""Cadmium standard elements//Kadmium-Normalelemente""",
    )

    dfg_6000_4 = VocabularyTerm(
        code="DFG_6000_4",
        label="6000 Standard elements",
        description="""Standard elements//Normalelemente""",
    )

    dfg_6000_5 = VocabularyTerm(
        code="DFG_6000_5",
        label="6000 Emergency batteries",
        description="""Emergency batteries//Notstrombatterien""",
    )

    dfg_6010_1 = VocabularyTerm(
        code="DFG_6010_1",
        label="6010 Battery chargers, battery monitors",
        description="""Battery chargers, battery monitors//Batterie-Ladegeräte, Batterie-Überwachungsgeräte""",
    )

    dfg_6010_2 = VocabularyTerm(
        code="DFG_6010_2",
        label="6010 Battery prf devices, -control devices",
        description="""Battery prf devices, -control devices//Batterie-Prüfgeräte, -Kontrollgeräte""",
    )

    dfg_6010_3 = VocabularyTerm(
        code="DFG_6010_3",
        label="6010 Emergency power devices (charging and switching devices)",
        description="""Emergency power devices (charging and switching devices)//Notstrom-Einrichtungen (Lade- und Schaltgeräte)""",
    )

    dfg_6020_1 = VocabularyTerm(
        code="DFG_6020_1",
        label="6020 Counter-voltage devices, automatic counter-voltage",
        description="""Counter-voltage devices, automatic counter-voltage//Gegenspannungsgeber, automatische Gegenspannung""",
    )

    dfg_6020_2 = VocabularyTerm(
        code="DFG_6020_2",
        label="6020 DC power supplies (except 0160, 6060 and 6070)",
        description="""DC power supplies (except 0160, 6060 and 6070)//Gleichspannungs-Netzgeräte (außer 0160, 6060 und 6070)""",
    )

    dfg_6020_3 = VocabularyTerm(
        code="DFG_6020_3",
        label="6020 DC voltage standards, calibration voltage transmitters (except 6000)",
        description="""DC voltage standards, calibration voltage transmitters (except 6000)//Gleichspannungs-Normale, Eichspannungsgeber (außer 6000)""",
    )

    dfg_6020_4 = VocabularyTerm(
        code="DFG_6020_4",
        label="6020 DC voltage sources (except potentiostats 1470)",
        description="""DC voltage sources (except potentiostats 1470)//Gleichspannungs-Quellen (außer Potenziostaten 1470)""",
    )

    dfg_6020_5 = VocabularyTerm(
        code="DFG_6020_5",
        label="6020 D.C. converters (static converters for laboratory and telecommunication apparatus)",
        description="""D.C. converters (static converters for laboratory and telecommunication apparatus)//Gleichstromwandler (statische Umrichter für Labor- und Fernmeldegeräte""",
    )

    dfg_6020_6 = VocabularyTerm(
        code="DFG_6020_6",
        label="6020 Calibration equipment for strain gauge chains",
        description="""Calibration equipment for strain gauge chains//Kalibriergeräte für Dehnungs-Messstreifen-Ketten""",
    )

    dfg_6020_7 = VocabularyTerm(
        code="DFG_6020_7",
        label="6020 Constant voltage instruments, voltage transducers",
        description="""Constant voltage instruments, voltage transducers//Konstantspannungsgeräte, Spannungsgeber""",
    )

    dfg_6020_8 = VocabularyTerm(
        code="DFG_6020_8",
        label="6020 Constant current devices, current transducers",
        description="""Constant current devices, current transducers//Konstantstromgeräte, Stromgeber""",
    )

    dfg_6020_9 = VocabularyTerm(
        code="DFG_6020_9",
        label="6020 Mains connection devices (general)",
        description="""Mains connection devices (general)//Netzanschlussgeräte (allgemein)""",
    )

    dfg_6020_10 = VocabularyTerm(
        code="DFG_6020_10",
        label="6020 Power supplies, switching power supplies",
        description="""Power supplies, switching power supplies//Netzteile, Schalt-Netzteile""",
    )

    dfg_6020_11 = VocabularyTerm(
        code="DFG_6020_11",
        label="6020 Low-voltage power supply units, power supplies",
        description="""Low-voltage power supply units, power supplies//Niederspannungs-Netzgeräte, -Versorgung""",
    )

    dfg_6020_12 = VocabularyTerm(
        code="DFG_6020_12",
        label="6020 ph simulators (calibration voltage transmitters)",
        description="""ph simulators (calibration voltage transmitters)//ph-Simulatoren (Eichspannungsgeber)""",
    )

    dfg_6020_13 = VocabularyTerm(
        code="DFG_6020_13",
        label="6020 Power-Pack, -Supply (power supply)",
        description="""Power-Pack, -Supply (power supply)//Power-Pack, -Supply (Stromversorgung)""",
    )

    dfg_6020_14 = VocabularyTerm(
        code="DFG_6020_14",
        label="6020 Power supply devices (electrical)",
        description="""Power supply devices (electrical)//Speisegeräte (elektrische)""",
    )

    dfg_6030_1 = VocabularyTerm(
        code="DFG_6030_1",
        label="6030 Three-phase current stabilisers",
        description="""Three-phase current stabilisers//Drehstromstabilisatoren""",
    )

    dfg_6030_2 = VocabularyTerm(
        code="DFG_6030_2",
        label="6030 Mains stabilisers",
        description="""Mains stabilisers//Netzstabilisatoren""",
    )

    dfg_6030_3 = VocabularyTerm(
        code="DFG_6030_3",
        label="6030 AC voltage stabilisers, voltage stabilisers",
        description="""AC voltage stabilisers, voltage stabilisers//Wechselspannungsstabilisatoren, Spannungskonstanthalter""",
    )

    dfg_6030_4 = VocabularyTerm(
        code="DFG_6030_4",
        label="6030 Alternating Current, Alternating Voltage Transducers and Standards",
        description="""Alternating Current, Alternating Voltage Transducers and Standards//Wechselstrom-, Wechselspannungsgeber und -standards""",
    )

    dfg_6040_1 = VocabularyTerm(
        code="DFG_6040_1",
        label="6040 Frequency Stabilisers",
        description="""Frequency Stabilisers//Frequenz-Stabilisatoren""",
    )

    dfg_6040_2 = VocabularyTerm(
        code="DFG_6040_2",
        label="6040 Frequency Converters (Static) and High-Frequency Generators",
        description="""Frequency Converters (Static) and High-Frequency Generators//Frequenz-Umformer (statisch) und Hochfrequenzgeneratoren""",
    )

    dfg_6040_3 = VocabularyTerm(
        code="DFG_6040_3",
        label="6040 Frequency converters (static), -converters with fixed frequency (except 2630)",
        description="""Frequency converters (static), -converters with fixed frequency (except 2630)//Frequenz-Wandler (statisch), -Umrichter mit fester Frequenz (außer 2630)""",
    )

    dfg_6040_4 = VocabularyTerm(
        code="DFG_6040_4",
        label="6040 Microwave generators (power generators, except medical heat 3950 and radio technology 6620, 6670)",
        description="""Microwave generators (power generators, except medical heat 3950 and radio technology 6620, 6670)//Mikrowellen-Generatoren (Leistungsgeneratoren, außer Medizin-Wärme 3950 und Funktechnik 6620, 6670)""",
    )

    dfg_6040_5 = VocabularyTerm(
        code="DFG_6040_5",
        label="6040 Medium-frequency generators (static) for heating",
        description="""Medium-frequency generators (static) for heating//Mittelfrequenz-Generatoren (statisch) für Erwärmung""",
    )

    dfg_6040_6 = VocabularyTerm(
        code="DFG_6040_6",
        label="6040 Inverters (battery connection of measuring instruments)",
        description="""Inverters (battery connection of measuring instruments)//Wechselrichter (Batterieanschluss von Messgeräten)""",
    )

    dfg_6050_1 = VocabularyTerm(
        code="DFG_6050_1",
        label="6050 Generating sets",
        description="""Generating sets//Aggregate für Stromerzeugung""",
    )

    dfg_6050_2 = VocabularyTerm(
        code="DFG_6050_2",
        label="6050 Emergency generators (transportable, except 2610 and 9850)",
        description="""Emergency generators (transportable, except 2610 and 9850)//Notstromaggregate (transportabel, außer 2610 und 9850)""",
    )

    dfg_6050_3 = VocabularyTerm(
        code="DFG_6050_3",
        label="6050 Welding gensets (portable generators)",
        description="""Welding gensets (portable generators)//Schweißaggregate (transportable Stromerzeuger)""",
    )

    dfg_6050_4 = VocabularyTerm(
        code="DFG_6050_4",
        label="6050 Portable Generating Sets",
        description="""Portable Generating Sets//Stromerzeuger, transportabel""",
    )

    dfg_6050_5 = VocabularyTerm(
        code="DFG_6050_5",
        label="6050 Portable generators (with drive motor)",
        description="""Portable generators (with drive motor)//Transportable Stromerzeuger (mit Antriebsmotor)""",
    )

    dfg_6060_1 = VocabularyTerm(
        code="DFG_6060_1",
        label="6060 Belt Generators, van de Graaff Generators (except 0210)",
        description="""Belt Generators, van de Graaff Generators (except 0210)//Bandgeneratoren, van-de-Graaff-Generatoren (außer 0210)""",
    )

    dfg_6060_2 = VocabularyTerm(
        code="DFG_6060_2",
        label="6060 High-voltage power supplies, built-in power supplies",
        description="""High-voltage power supplies, built-in power supplies//Hochspannungsnetzgeräte, -einbaunetzteile""",
    )

    dfg_6060_3 = VocabularyTerm(
        code="DFG_6060_3",
        label="6060 High-voltage power supply units (above 1 kV, except 2680)",
        description="""High-voltage power supply units (above 1 kV, except 2680)//Hochspannungsspeisegeräte (über 1 kV, außer 2680)""",
    )

    dfg_6060_4 = VocabularyTerm(
        code="DFG_6060_4",
        label="6060 Klystron power supplies",
        description="""Klystron power supplies//Klystron-Netzteile""",
    )

    dfg_6060_5 = VocabularyTerm(
        code="DFG_6060_5",
        label="6060 Microwave power supplies",
        description="""Microwave power supplies//Mikrowellen-Netzgeräte""",
    )

    dfg_6060_6 = VocabularyTerm(
        code="DFG_6060_6",
        label="6060 Photomultiplier power supplies, -power supply",
        description="""Photomultiplier power supplies, -power supply//Photomultiplier-Netzgeräte, -Spannungsversorgung""",
    )

    dfg_6060_7 = VocabularyTerm(
        code="DFG_6060_7",
        label="6060 SEV power supplies",
        description="""SEV power supplies//SEV-Betriebsgeräte""",
    )

    dfg_6070_1 = VocabularyTerm(
        code="DFG_6070_1",
        label="6070 Chopper",
        description="""Chopper//Chopper""",
    )

    dfg_6070_2 = VocabularyTerm(
        code="DFG_6070_2",
        label="6070 DC/DC converters",
        description="""DC/DC converters//DC/DC-Wandler""",
    )

    dfg_6070_3 = VocabularyTerm(
        code="DFG_6070_3",
        label="6070 Chargers for high voltage capacitors",
        description="""Chargers for high voltage capacitors//Ladegeräte für Hochspannungskondensatoren""",
    )

    dfg_6070_4 = VocabularyTerm(
        code="DFG_6070_4",
        label="6070 Programmable power supply units, power operation amplifiers",
        description="""Programmable power supply units, power operation amplifiers//Programmierbare Stromversorgungsgeräte, Leistungs-Operationsverstärker""",
    )

    dfg_6070_5 = VocabularyTerm(
        code="DFG_6070_5",
        label="6070 Special power supply units, power supply modules",
        description="""Special power supply units, power supply modules//Spezielle Stromversorgungsgeräte, Versorgungmodule""",
    )

    dfg_6070_6 = VocabularyTerm(
        code="DFG_6070_6",
        label="6070 Power Supply Modules",
        description="""Power Supply Modules//Stromversorgungsmodule""",
    )

    dfg_6070_7 = VocabularyTerm(
        code="DFG_6070_7",
        label="6070 Breakers",
        description="""Breakers//Unterbrecher""",
    )

    dfg_6070_8 = VocabularyTerm(
        code="DFG_6070_8",
        label="6070 Choppers",
        description="""Choppers//Zerhacker""",
    )

    dfg_6090_1 = VocabularyTerm(
        code="DFG_6090_1",
        label="6090 Fuel Cells",
        description="""Fuel Cells//Brennstoffzellen""",
    )

    dfg_6090_2 = VocabularyTerm(
        code="DFG_6090_2",
        label="6090 Other current and voltage sources (except 6000-6080)",
        description="""Other current and voltage sources (except 6000-6080)//Sonstige Strom- und Spannungsquellen (außer 6000-6080)""",
    )

    dfg_6100_1 = VocabularyTerm(
        code="DFG_6100_1",
        label="6100 Analogue Circuits",
        description="""Analogue Circuits//Analogschaltungen""",
    )

    dfg_6100_2 = VocabularyTerm(
        code="DFG_6100_2",
        label="6100 Broadband amplifiers",
        description="""Broadband amplifiers//Breitbandverstärker""",
    )

    dfg_6100_3 = VocabularyTerm(
        code="DFG_6100_3",
        label="6100 Differential amplifiers",
        description="""Differential amplifiers//Differenzverstärker""",
    )

    dfg_6100_4 = VocabularyTerm(
        code="DFG_6100_4",
        label="6100 Impedance converters (except for microwaves 6860)",
        description="""Impedance converters (except for microwaves 6860)//Impedanzwandler (außer für Mikrowellen 6860)""",
    )

    dfg_6100_5 = VocabularyTerm(
        code="DFG_6100_5",
        label="6100 Charge amplifiers",
        description="""Charge amplifiers//Ladungsverstärker""",
    )

    dfg_6100_6 = VocabularyTerm(
        code="DFG_6100_6",
        label="6100 Power amplifiers (except studio and transmitter technology)",
        description="""Power amplifiers (except studio and transmitter technology)//Leistungsverstärker (außer Studio- und Sendertechnik)""",
    )

    dfg_6100_7 = VocabularyTerm(
        code="DFG_6100_7",
        label="6100 Operational amplifiers",
        description="""Operational amplifiers//Operationsverstärker""",
    )

    dfg_6100_8 = VocabularyTerm(
        code="DFG_6100_8",
        label="6100 Reactance converter",
        description="""Reactance converter//Reaktanzwandler""",
    )

    dfg_6100_9 = VocabularyTerm(
        code="DFG_6100_9",
        label="6100 Sample & hold amplifiers, hold amplifiers",
        description="""Sample & hold amplifiers, hold amplifiers//Sample & Hold-Verstärker, Halteverstärker""",
    )

    dfg_6100_10 = VocabularyTerm(
        code="DFG_6100_10",
        label="6100 Drivers (amplifiers)",
        description="""Drivers (amplifiers)//Treiber (-Verstärker)""",
    )

    dfg_6100_11 = VocabularyTerm(
        code="DFG_6100_11",
        label="6100 Amplifiers and components of analogue measurement technology (except 6700-6790)",
        description="""Amplifiers and components of analogue measurement technology (except 6700-6790)//Verstärker und Bausteine der analogen Messtechnik (außer 6700-6790)""",
    )

    dfg_6100_12 = VocabularyTerm(
        code="DFG_6100_12",
        label="6100 Preamplifiers",
        description="""Preamplifiers//Vorverstärker""",
    )

    dfg_6110_1 = VocabularyTerm(
        code="DFG_6110_1",
        label="6110 Display amplifiers, tunable",
        description="""Display amplifiers, tunable//Anzeigeverstärker, abstimmbar""",
    )

    dfg_6110_2 = VocabularyTerm(
        code="DFG_6110_2",
        label="6110 Boxcar integrators, -averagers",
        description="""Boxcar integrators, -averagers//Boxcar-Integratoren, -Averager""",
    )

    dfg_6110_3 = VocabularyTerm(
        code="DFG_6110_3",
        label="6110 Selective amplifiers, lock-in amplifiers",
        description="""Selective amplifiers, lock-in amplifiers//Selektive Verstärker, Lock-in-Verstärker""",
    )

    dfg_6110_4 = VocabularyTerm(
        code="DFG_6110_4",
        label="6110 Trigger frequency amplifiers (except 8720, 8740, 8970)",
        description="""Trigger frequency amplifiers (except 8720, 8740, 8970)//Trägerfrequenz-Verstärker (außer 8720, 8740, 8970)""",
    )

    dfg_6120_1 = VocabularyTerm(
        code="DFG_6120_1",
        label="6120 Magnetic amplifiers",
        description="""Magnetic amplifiers//Magnetverstärker""",
    )

    dfg_6120_2 = VocabularyTerm(
        code="DFG_6120_2",
        label="6120 Maser",
        description="""Maser//Maser""",
    )

    dfg_6120_3 = VocabularyTerm(
        code="DFG_6120_3",
        label="6120 Other analogue amplifiers (e.g. parametric amplifiers, wandering field tube amplifiers)",
        description="""Other analogue amplifiers (e.g. parametric amplifiers, wandering field tube amplifiers)//Sonstige Analog-Verstärker (z.B. parametrische Verstärker, Wander feldröhren-Verstärker)""",
    )

    dfg_6120_4 = VocabularyTerm(
        code="DFG_6120_4",
        label="6120 TWT (Travelling Wave Tube) amplifiers",
        description="""TWT (Travelling Wave Tube) amplifiers//TWT-Verstärker (Travelling Wave Tube)""",
    )

    dfg_6140_1 = VocabularyTerm(
        code="DFG_6140_1",
        label="6140 Digital amplifier systems",
        description="""Digital amplifier systems//Digitale Verstärkersysteme""",
    )

    dfg_6140_2 = VocabularyTerm(
        code="DFG_6140_2",
        label="6140 Pulse shaper, pulse regenerator amplifiers",
        description="""Pulse shaper, pulse regenerator amplifiers//Impulsformer, -regenerierverstärker""",
    )

    dfg_6140_3 = VocabularyTerm(
        code="DFG_6140_3",
        label="6140 Pulse amplifier",
        description="""Pulse amplifier//Impulsverstärker""",
    )

    dfg_6140_4 = VocabularyTerm(
        code="DFG_6140_4",
        label="6140 Linear amplifiers, linear amplifiers",
        description="""Linear amplifiers, linear amplifiers//Linearverstärker, Linear-Amplifier""",
    )

    dfg_6140_5 = VocabularyTerm(
        code="DFG_6140_5",
        label="6140 Amplifiers and modules of digital electronics, pulse shapers",
        description="""Amplifiers and modules of digital electronics, pulse shapers//Verstärker und -Module der Digitalelektronik, Impulsformer""",
    )

    dfg_6150_1 = VocabularyTerm(
        code="DFG_6150_1",
        label="6150 Digital counters",
        description="""Digital counters//Digitalzähler""",
    )

    dfg_6150_2 = VocabularyTerm(
        code="DFG_6150_2",
        label="6150 Electronic counters",
        description="""Electronic counters//Elektronische Zähler""",
    )

    dfg_6150_3 = VocabularyTerm(
        code="DFG_6150_3",
        label="6150 Interval meters",
        description="""Interval meters//Intervallmesser""",
    )

    dfg_6150_4 = VocabularyTerm(
        code="DFG_6150_4",
        label="6150 Preset scaler, preset counters",
        description="""Preset scaler, preset counters//Preset Scaler, Vorwahl-Zähler""",
    )

    dfg_6150_5 = VocabularyTerm(
        code="DFG_6150_5",
        label="6150 Scaler, scaler timer",
        description="""Scaler, scaler timer//Scaler, Scaler-Timer""",
    )

    dfg_6150_6 = VocabularyTerm(
        code="DFG_6150_6",
        label="6150 Universal counters",
        description="""Universal counters//Universal-Zähler""",
    )

    dfg_6150_7 = VocabularyTerm(
        code="DFG_6150_7",
        label="6150 Reducer (digital counters)",
        description="""Reducer (digital counters)//Untersetzer (digitale Zählschaltungen)""",
    )

    dfg_6150_8 = VocabularyTerm(
        code="DFG_6150_8",
        label="6150 Preset counters",
        description="""Preset counters//Vorwahlzähler""",
    )

    dfg_6150_9 = VocabularyTerm(
        code="DFG_6150_9",
        label="6150 Counters (electronic), frequency counters and counter circuit modules",
        description="""Counters (electronic), frequency counters and counter circuit modules//Zählgeräte (elektronisch), Frequenzzähler und Zählschaltungsmodule""",
    )

    dfg_6150_10 = VocabularyTerm(
        code="DFG_6150_10",
        label="6150 Time interval meters (electrical)",
        description="""Time interval meters (electrical)//Zeitintervallmesser (elektrische)""",
    )

    dfg_6160_1 = VocabularyTerm(
        code="DFG_6160_1",
        label="6160 Alarm display, threshold and alarm indicators",
        description="""Alarm display, threshold and alarm indicators//Alarm-Display, Schwellen- und Alarmanzeigen""",
    )

    dfg_6160_2 = VocabularyTerm(
        code="DFG_6160_2",
        label="6160 Amplifier-analyzer, -discriminator",
        description="""Amplifier-analyzer, -discriminator//Amplifier-Analyzer, -Discriminator""",
    )

    dfg_6160_3 = VocabularyTerm(
        code="DFG_6160_3",
        label="6160 Biased Amplifier, Amplifier with Discriminator",
        description="""Biased Amplifier, Amplifier with Discriminator//Biased Amplifier, Verstärker mit Diskriminator""",
    )

    dfg_6160_4 = VocabularyTerm(
        code="DFG_6160_4",
        label="6160 Constant-Fraction Discriminators",
        description="""Constant-Fraction Discriminators//Constant-Fraction-Discriminatoren""",
    )

    dfg_6160_5 = VocabularyTerm(
        code="DFG_6160_5",
        label="6160 Discriminators, Single Channel Analysers (except Analogue Classifier 7340)",
        description="""Discriminators, Single Channel Analysers (except Analogue Classifier 7340)//Diskriminatoren, Einkanalanalysatoren (außer Analog-Klassiergeräte 7340)""",
    )

    dfg_6160_6 = VocabularyTerm(
        code="DFG_6160_6",
        label="6160 Window discriminators, generators",
        description="""Window discriminators, generators//Fenster-Diskriminatoren, -Generatoren""",
    )

    dfg_6170_1 = VocabularyTerm(
        code="DFG_6170_1",
        label="6170 Anti-coincidence units",
        description="""Anti-coincidence units//Antikoinzidenz-Einheiten""",
    )

    dfg_6170_2 = VocabularyTerm(
        code="DFG_6170_2",
        label="6170 Gate, gate or delay units, pulse shaping and delay units",
        description="""Gate, gate or delay units, pulse shaping and delay units//Gate-, Gate or Delay Units, Impulsformungs- und Verzögerungseinheiten""",
    )

    dfg_6170_3 = VocabularyTerm(
        code="DFG_6170_3",
        label="6170 Linear Gate, Linear Gate Circuits",
        description="""Linear Gate, Linear Gate Circuits//Linear Gate, Lineare Torschaltungen""",
    )

    dfg_6170_4 = VocabularyTerm(
        code="DFG_6170_4",
        label="6170 Gate circuits, coincidence circuits and digital logic modules",
        description="""Gate circuits, coincidence circuits and digital logic modules//Torschaltungen, Koinzidenzschaltungen und Digitallogik-Module""",
    )

    dfg_6180_1 = VocabularyTerm(
        code="DFG_6180_1",
        label="6180 Linear Ratemeter, Log Ratemeter",
        description="""Linear Ratemeter, Log Ratemeter//Linearratemeter, Log-Ratemeter""",
    )

    dfg_6180_2 = VocabularyTerm(
        code="DFG_6180_2",
        label="6180 Mean value meters, ratemeter, ratemeter integrators",
        description="""Mean value meters, ratemeter, ratemeter integrators//Mittelwertmesser, Ratemeter, Ratemeter-Integratoren""",
    )

    dfg_6180_3 = VocabularyTerm(
        code="DFG_6180_3",
        label="6180 Ratemeter, mean value meter",
        description="""Ratemeter, mean value meter//Ratemeter, Mittelwertmesser""",
    )

    dfg_6190_1 = VocabularyTerm(
        code="DFG_6190_1",
        label="6190 Digital circuits (except 6140-6180)",
        description="""Digital circuits (except 6140-6180)//Digitale Schaltungen (außer 6140-6180)""",
    )

    dfg_6190_2 = VocabularyTerm(
        code="DFG_6190_2",
        label="6190 Other amplifiers and components of nuclear electronics (except 6100-6180)",
        description="""Other amplifiers and components of nuclear electronics (except 6100-6180)//Sonstige Verstärker und Bausteine der Nuklearelektronik (außer 6100-6180)""",
    )

    dfg_6200_1 = VocabularyTerm(
        code="DFG_6200_1",
        label="6200 Wideband oscillographs and oscilloscopes",
        description="""Wideband oscillographs and oscilloscopes//Breitband-Oszillographen, -Oszilloskope""",
    )

    dfg_6200_2 = VocabularyTerm(
        code="DFG_6200_2",
        label="6200 Electron beam oscilloscopes (normal tube)",
        description="""Electron beam oscilloscopes (normal tube)//Elektronenstrahl-Oszilloskope (Normalröhre)""",
    )

    dfg_6200_3 = VocabularyTerm(
        code="DFG_6200_3",
        label="6200 Sampling oscillographs, oscilloscopes",
        description="""Sampling oscillographs, oscilloscopes//Sampling-Oszillographen, -Oszilloskope""",
    )

    dfg_6200_4 = VocabularyTerm(
        code="DFG_6200_4",
        label="6200 Service oscilloscopes",
        description="""Service oscilloscopes//Service-Oszilloskope""",
    )

    dfg_6200_5 = VocabularyTerm(
        code="DFG_6200_5",
        label="6200 Dual-beam, dual-channel oscilloscopes, oscilloscopes",
        description="""Dual-beam, dual-channel oscilloscopes, oscilloscopes//Zweistrahl-, Zweikanal-Oszillographen, -Oszilloskope""",
    )

    dfg_6210_1 = VocabularyTerm(
        code="DFG_6210_1",
        label="6210 Storage oscilloscopes",
        description="""Storage oscilloscopes//Speicheroszilloskope""",
    )

    dfg_6220_1 = VocabularyTerm(
        code="DFG_6220_1",
        label="6220 Large-image oscilloscopes",
        description="""Large-image oscilloscopes//Großbildoszilloskope""",
    )

    dfg_6220_2 = VocabularyTerm(
        code="DFG_6220_2",
        label="6220 Pulse spectroscopes (radiation measurement)",
        description="""Pulse spectroscopes (radiation measurement)//Impulsspektroskope (Strahlungsmessung)""",
    )

    dfg_6220_3 = VocabularyTerm(
        code="DFG_6220_3",
        label="6220 Sighting scopes (large-image oscilloscopes, except for computer and television equipment)",
        description="""Sighting scopes (large-image oscilloscopes, except for computer and television equipment)//Sichtgeräte (Großbild-Oszilloskope, außer für EDV- und Fernsehanlagen)""",
    )

    dfg_6220_4 = VocabularyTerm(
        code="DFG_6220_4",
        label="6220 Special electron beam oscilloscopes",
        description="""Special electron beam oscilloscopes//Spezielle Elektronenstrahl-Oszilloskope""",
    )

    dfg_6220_5 = VocabularyTerm(
        code="DFG_6220_5",
        label="6220 Surge voltage oscilloscopes",
        description="""Surge voltage oscilloscopes//Stoßspannungs-Oszilloskope""",
    )

    dfg_6230_1 = VocabularyTerm(
        code="DFG_6230_1",
        label="6230 Transducers",
        description="""Transducers//Abschwächer-Messköpfe""",
    )

    dfg_6230_2 = VocabularyTerm(
        code="DFG_6230_2",
        label="6230 Amplitude calibrators",
        description="""Amplitude calibrators//Amplituden-Eichgeräte""",
    )

    dfg_6230_3 = VocabularyTerm(
        code="DFG_6230_3",
        label="6230 Differential amplifier insertion units (for oscilloscopes)",
        description="""Differential amplifier insertion units (for oscilloscopes)//Differenz-Verstärker-Einschübe (für Oszilloskope)""",
    )

    dfg_6230_4 = VocabularyTerm(
        code="DFG_6230_4",
        label="6230 Oscilloscope tubes",
        description="""Oscilloscope tubes//Oszilloskope-Zubehör""",
    )

    dfg_6230_5 = VocabularyTerm(
        code="DFG_6230_5",
        label="6230 Photographic probes (for oscilloscopes)",
        description="""Photographic probes (for oscilloscopes)//Photovorsätze (für Oszilloskope)""",
    )

    dfg_6230_6 = VocabularyTerm(
        code="DFG_6230_6",
        label="6230 Calculation inserts (for oscilloscopes)",
        description="""Calculation inserts (for oscilloscopes)//Recheneinschübe (für Oszilloskope)""",
    )

    dfg_6230_7 = VocabularyTerm(
        code="DFG_6230_7",
        label="6230 Sampling inserts (for oscilloscopes)",
        description="""Sampling inserts (for oscilloscopes)//Sampling-Einschübe (für Oszilloskope)""",
    )

    dfg_6230_8 = VocabularyTerm(
        code="DFG_6230_8",
        label="6230 Sampling probes",
        description="""Sampling probes//Sampling-Messköpfe""",
    )

    dfg_6230_9 = VocabularyTerm(
        code="DFG_6230_9",
        label="6230 Spectrum analyser inserts",
        description="""Spectrum analyser inserts//Spektrumanalysatoreinschübe""",
    )

    dfg_6230_10 = VocabularyTerm(
        code="DFG_6230_10",
        label="6230 Amplifier insertion units (oscilloscopes)",
        description="""Amplifier insertion units (oscilloscopes)//Verstärker-Einschübe (Oszilloskope)""",
    )

    dfg_6230_11 = VocabularyTerm(
        code="DFG_6230_11",
        label="6230 Time base inserters",
        description="""Time base inserters//Zeitbasis-Einschübe""",
    )

    dfg_6230_12 = VocabularyTerm(
        code="DFG_6230_12",
        label="6230 Accessories and inserts for electron beam oscilloscopes",
        description="""Accessories and inserts for electron beam oscilloscopes//Zubehör und Einschübe für Elektronenstrahl-Oszilloskope""",
    )

    dfg_6250_1 = VocabularyTerm(
        code="DFG_6250_1",
        label="6250 Light spot recorder",
        description="""Light spot recorder//Lichtpunktschreiber""",
    )

    dfg_6250_2 = VocabularyTerm(
        code="DFG_6250_2",
        label="6250 Light beam oscillographs",
        description="""Light beam oscillographs//Lichtstrahl-Oszillographen""",
    )

    dfg_6250_3 = VocabularyTerm(
        code="DFG_6250_3",
        label="6250 Multi-channel recording oscillographs",
        description="""Multi-channel recording oscillographs//Mehrkanal-Registrier-Oszillographen""",
    )

    dfg_6250_4 = VocabularyTerm(
        code="DFG_6250_4",
        label="6250 Recording oscillographs",
        description="""Recording oscillographs//Registrieroszillographen""",
    )

    dfg_6250_5 = VocabularyTerm(
        code="DFG_6250_5",
        label="6250 Loop oscillographs",
        description="""Loop oscillographs//Schleifenoszillographen""",
    )

    dfg_6250_6 = VocabularyTerm(
        code="DFG_6250_6",
        label="6250 Coil Oscillographs",
        description="""Coil Oscillographs//Spulenschwinger-Oszillographen""",
    )

    dfg_6250_7 = VocabularyTerm(
        code="DFG_6250_7",
        label="6250 UV Recorders, UV Recording Oscillographs",
        description="""UV Recorders, UV Recording Oscillographs//UV-Schreiber, UV-Registrier-Oszillographen""",
    )

    dfg_6260_1 = VocabularyTerm(
        code="DFG_6260_1",
        label="6260 Oscillographs, direct oscillographs",
        description="""Oscillographs, direct oscillographs//Düsen-Oszillographen, -Direktschreiber""",
    )

    dfg_6260_2 = VocabularyTerm(
        code="DFG_6260_2",
        label="6260 Liquid jet oscillographs",
        description="""Liquid jet oscillographs//Flüssigkeitsstrahl-Oszillographen""",
    )

    dfg_6270_1 = VocabularyTerm(
        code="DFG_6270_1",
        label="6270 Galvanometers (for Light Beam Oscillographs)",
        description="""Galvanometers (for Light Beam Oscillographs)//Galvanometer (für Lichtstrahloszillographen)""",
    )

    dfg_6270_2 = VocabularyTerm(
        code="DFG_6270_2",
        label="6270 Loop transducers",
        description="""Loop transducers//Schleifenschwinger""",
    )

    dfg_6270_3 = VocabularyTerm(
        code="DFG_6270_3",
        label="6270 Coil transducers",
        description="""Coil transducers//Spulenschwinger""",
    )

    dfg_6270_4 = VocabularyTerm(
        code="DFG_6270_4",
        label="6270 Accessories and preamplifiers for light-beam and liquid-beam oscillographs",
        description="""Accessories and preamplifiers for light-beam and liquid-beam oscillographs//Zubehör und Vorverstärker für Lichtstrahl- und Flüssigkeitsstrahloszillographen""",
    )

    dfg_6290_1 = VocabularyTerm(
        code="DFG_6290_1",
        label="6290 Other oscillographs (except 6200-6270)",
        description="""Other oscillographs (except 6200-6270)//Sonstige Oszillographen (außer 6200-6270)""",
    )

    dfg_6300_1 = VocabularyTerm(
        code="DFG_6300_1",
        label="6300 Csium frequency standards",
        description="""Csium frequency standards//Cäsium-Frequenznormale""",
    )

    dfg_6300_2 = VocabularyTerm(
        code="DFG_6300_2",
        label="6300 Calibration frequency generators",
        description="""Calibration frequency generators//Eichfrequenz-Generatoren""",
    )

    dfg_6300_3 = VocabularyTerm(
        code="DFG_6300_3",
        label="6300 Receiver transmitters",
        description="""Receiver transmitters//Empfängerprüfsender""",
    )

    dfg_6300_4 = VocabularyTerm(
        code="DFG_6300_4",
        label="6300 Frequency decoders, synthesizers",
        description="""Frequency decoders, synthesizers//Frequenz-Dekaden, -Synthesizer""",
    )

    dfg_6300_5 = VocabularyTerm(
        code="DFG_6300_5",
        label="6300 Frequency generators, transmitters",
        description="""Frequency generators, transmitters//Frequenzgeneratoren, -geber""",
    )

    dfg_6300_6 = VocabularyTerm(
        code="DFG_6300_6",
        label="6300 Power measurement transmitters",
        description="""Power measurement transmitters//Leistungsmesssender""",
    )

    dfg_6300_7 = VocabularyTerm(
        code="DFG_6300_7",
        label="6300 Measuring generators, measuring transmitters, frequency standards",
        description="""Measuring generators, measuring transmitters, frequency standards//Messgeneratoren, Messsender, Frequenznormale""",
    )

    dfg_6300_8 = VocabularyTerm(
        code="DFG_6300_8",
        label="6300 Normal frequency generators",
        description="""Normal frequency generators//Normalfrequenz-Generatoren""",
    )

    dfg_6300_9 = VocabularyTerm(
        code="DFG_6300_9",
        label="6300 Oscillators",
        description="""Oscillators//Oszillatoren""",
    )

    dfg_6300_10 = VocabularyTerm(
        code="DFG_6300_10",
        label="6300 Level transmitters",
        description="""Level transmitters//Pegelsender""",
    )

    dfg_6300_11 = VocabularyTerm(
        code="DFG_6300_11",
        label="6300 Level transmitters",
        description="""Level transmitters//Prüfsender""",
    )

    dfg_6300_12 = VocabularyTerm(
        code="DFG_6300_12",
        label="6300 RC generators, RC oscillators",
        description="""RC generators, RC oscillators//RC-Generatoren, RC-Oszillatoren""",
    )

    dfg_6300_13 = VocabularyTerm(
        code="DFG_6300_13",
        label="6300 Resonance meters (dippers, grid dippers)",
        description="""Resonance meters (dippers, grid dippers)//Resonanzmeter (Dipper, Grid-Dipper)""",
    )

    dfg_6300_14 = VocabularyTerm(
        code="DFG_6300_14",
        label="6300 Rubidium frequency standards",
        description="""Rubidium frequency standards//Rubidium-Frequenznormale""",
    )

    dfg_6300_15 = VocabularyTerm(
        code="DFG_6300_15",
        label="6300 Floating buzzers",
        description="""Floating buzzers//Schwebungssummer""",
    )

    dfg_6300_16 = VocabularyTerm(
        code="DFG_6300_16",
        label="6300 Signal generators, signal transmitters",
        description="""Signal generators, signal transmitters//Signalgeneratoren, -messsender""",
    )

    dfg_6300_17 = VocabularyTerm(
        code="DFG_6300_17",
        label="6300 Sine wave generators",
        description="""Sine wave generators//Sinusgeneratoren""",
    )

    dfg_6300_18 = VocabularyTerm(
        code="DFG_6300_18",
        label="6300 Synthesizers (measurement generators)",
        description="""Synthesizers (measurement generators)//Synthesizer (Messgeneratoren)""",
    )

    dfg_6300_19 = VocabularyTerm(
        code="DFG_6300_19",
        label="6300 Low-frequency generators",
        description="""Low-frequency generators//Tieffrequenzgeneratoren""",
    )

    dfg_6320_1 = VocabularyTerm(
        code="DFG_6320_1",
        label="6320 Sweep generators",
        description="""Sweep generators//Sweep-Generatoren""",
    )

    dfg_6320_2 = VocabularyTerm(
        code="DFG_6320_2",
        label="6320 Sweep generators",
        description="""Sweep generators//Wobbelgeneratoren""",
    )

    dfg_6320_3 = VocabularyTerm(
        code="DFG_6320_3",
        label="6320 Sweep generators, sweep states",
        description="""Sweep generators, sweep states//Wobbelsender, Wobbelzusätze""",
    )

    dfg_6330_1 = VocabularyTerm(
        code="DFG_6330_1",
        label="6330 Flash generators, double flash generators (pulse generators)",
        description="""Flash generators, double flash generators (pulse generators)//Blitzgeneratoren, Doppelblitz-Generatoren (Impulsgeneratoren)""",
    )

    dfg_6330_2 = VocabularyTerm(
        code="DFG_6330_2",
        label="6330 Double pulse generators",
        description="""Double pulse generators//Doppelimpulsgeneratoren""",
    )

    dfg_6330_3 = VocabularyTerm(
        code="DFG_6330_3",
        label="6330 Pulse generators",
        description="""Pulse generators//Impulsgeneratoren""",
    )

    dfg_6330_4 = VocabularyTerm(
        code="DFG_6330_4",
        label="6330 Pulse generators",
        description="""Pulse generators//Pulsgeneratoren""",
    )

    dfg_6330_5 = VocabularyTerm(
        code="DFG_6330_5",
        label="6330 Scan delay generators, distorted pulse generators",
        description="""Scan delay generators, distorted pulse generators//Scan Delay Generatoren, verzögerte Pulsgeneratoren""",
    )

    dfg_6330_6 = VocabularyTerm(
        code="DFG_6330_6",
        label="6330 Trigger generators",
        description="""Trigger generators//Triggergeneratoren""",
    )

    dfg_6330_7 = VocabularyTerm(
        code="DFG_6330_7",
        label="6330 Univibrators",
        description="""Univibrators//Univibratoren""",
    )

    dfg_6330_8 = VocabularyTerm(
        code="DFG_6330_8",
        label="6330 Znd current generators (except 5680 for lamps and 8410 for burners)",
        description="""Znd current generators (except 5680 for lamps and 8410 for burners)//Zündstromgeneratoren (außer 5680 für Lampen und 8410 für Ölbrenner)""",
    )

    dfg_6340_1 = VocabularyTerm(
        code="DFG_6340_1",
        label="6340 Delta generators",
        description="""Delta generators//Dreieck-Generatoren""",
    )

    dfg_6340_2 = VocabularyTerm(
        code="DFG_6340_2",
        label="6340 Function generators",
        description="""Function generators//Funktionsgeneratoren""",
    )

    dfg_6340_3 = VocabularyTerm(
        code="DFG_6340_3",
        label="6340 Programme generators (digital)",
        description="""Programme generators (digital)//Programmgeneratoren (digitale)""",
    )

    dfg_6340_4 = VocabularyTerm(
        code="DFG_6340_4",
        label="6340 Ramp generators",
        description="""Ramp generators//Rampengeneratoren""",
    )

    dfg_6340_5 = VocabularyTerm(
        code="DFG_6340_5",
        label="6340 Square-wave generators",
        description="""Square-wave generators//Rechteck-Generatoren""",
    )

    dfg_6340_6 = VocabularyTerm(
        code="DFG_6340_6",
        label="6340 Sge number generators",
        description="""Sge number generators//Sägezahngeneratoren""",
    )

    dfg_6350_1 = VocabularyTerm(
        code="DFG_6350_1",
        label="6350 Bit-error measurement plots",
        description="""Bit-error measurement plots//Bit-Fehler-Messplätze""",
    )

    dfg_6350_2 = VocabularyTerm(
        code="DFG_6350_2",
        label="6350 Bit-pattern generators",
        description="""Bit-pattern generators//Bit-Muster-Generatoren""",
    )

    dfg_6350_3 = VocabularyTerm(
        code="DFG_6350_3",
        label="6350 Teletype and data signal generators",
        description="""Teletype and data signal generators//Fernschreib- und Daten-Signalgeneratoren""",
    )

    dfg_6350_4 = VocabularyTerm(
        code="DFG_6350_4",
        label="6350 Gauss time window generators",
        description="""Gauss time window generators//Gauß-Zeitfenster-Generatoren""",
    )

    dfg_6350_5 = VocabularyTerm(
        code="DFG_6350_5",
        label="6350 Measurement generators (except 6300-6340)",
        description="""Measurement generators (except 6300-6340)//Messgeneratoren (außer 6300-6340)""",
    )

    dfg_6350_6 = VocabularyTerm(
        code="DFG_6350_6",
        label="6350 Tracking control generators",
        description="""Tracking control generators//Nachlaufsteuergeneratoren""",
    )

    dfg_6350_7 = VocabularyTerm(
        code="DFG_6350_7",
        label="6350 Normal frequency receivers with frequency standard",
        description="""Normal frequency receivers with frequency standard//Normalfrequenz-Empfänger mit Frequenzstandard""",
    )

    dfg_6350_8 = VocabularyTerm(
        code="DFG_6350_8",
        label="6350 Noise generators",
        description="""Noise generators//Rauschgeneratoren""",
    )

    dfg_6350_9 = VocabularyTerm(
        code="DFG_6350_9",
        label="6350 Noise measurement plots",
        description="""Noise measurement plots//Rauschmessplätze""",
    )

    dfg_6350_10 = VocabularyTerm(
        code="DFG_6350_10",
        label="6350 Reference generators (for mechanical vibration systems)",
        description="""Reference generators (for mechanical vibration systems)//Referenzgeneratoren (für mechanische Schwingsysteme)""",
    )

    dfg_6350_11 = VocabularyTerm(
        code="DFG_6350_11",
        label="6350 Scan generators (digital)",
        description="""Scan generators (digital)//Scangeneratoren (digitale)""",
    )

    dfg_6350_12 = VocabularyTerm(
        code="DFG_6350_12",
        label="6350 Special measurement generators (except 6300-6340)",
        description="""Special measurement generators (except 6300-6340)//Spezielle Messgeneratoren (außer 6300-6340)""",
    )

    dfg_6350_13 = VocabularyTerm(
        code="DFG_6350_13",
        label="6350 Stereo transmitters",
        description="""Stereo transmitters//Stereomesssender""",
    )

    dfg_6350_14 = VocabularyTerm(
        code="DFG_6350_14",
        label="6350 Stereo signal generators",
        description="""Stereo signal generators//Stereosignalgeneratoren""",
    )

    dfg_6350_15 = VocabularyTerm(
        code="DFG_6350_15",
        label="6350 Stochastic meters (random and analytical, except 7340)",
        description="""Stochastic meters (random and analytical, except 7340)//Stochastic-Meter (Zufallsgenerator und Analysengerät, außer 7340)""",
    )

    dfg_6350_16 = VocabularyTerm(
        code="DFG_6350_16",
        label="6350 Word generators",
        description="""Word generators//Wortgeneratoren""",
    )

    dfg_6350_17 = VocabularyTerm(
        code="DFG_6350_17",
        label="6350 Random signal generators, pseudo-random signal generators",
        description="""Random signal generators, pseudo-random signal generators//Zufallsgeneratoren, Pseudo-Zufallssignal-Generatoren""",
    )

    dfg_6360_1 = VocabularyTerm(
        code="DFG_6360_1",
        label="6360 Analogue filters",
        description="""Analogue filters//Analogfilter""",
    )

    dfg_6360_2 = VocabularyTerm(
        code="DFG_6360_2",
        label="6360 Band-pass filters",
        description="""Band-pass filters//Bandpassfilter""",
    )

    dfg_6360_3 = VocabularyTerm(
        code="DFG_6360_3",
        label="6360 Digital filters",
        description="""Digital filters//Digitale Filter""",
    )

    dfg_6360_4 = VocabularyTerm(
        code="DFG_6360_4",
        label="6360 Filters (electrical), resonators",
        description="""Filters (electrical), resonators//Filter (elektrische), Resonatoren""",
    )

    dfg_6360_5 = VocabularyTerm(
        code="DFG_6360_5",
        label="6360 Frequency meters (resonance)",
        description="""Frequency meters (resonance)//Frequenzmessgeräte (Resonanz-)""",
    )

    dfg_6360_6 = VocabularyTerm(
        code="DFG_6360_6",
        label="6360 Crossovers",
        description="""Crossovers//Frequenzweichen""",
    )

    dfg_6360_7 = VocabularyTerm(
        code="DFG_6360_7",
        label="6360 High-pass filters",
        description="""High-pass filters//Hochpässe (Filter)""",
    )

    dfg_6360_8 = VocabularyTerm(
        code="DFG_6360_8",
        label="6360 Waveguide frequency meters",
        description="""Waveguide frequency meters//Hohlleiterfrequenzmesser""",
    )

    dfg_6360_9 = VocabularyTerm(
        code="DFG_6360_9",
        label="6360 Cavity resonators",
        description="""Cavity resonators//Hohlraumresonatoren""",
    )

    dfg_6360_10 = VocabularyTerm(
        code="DFG_6360_10",
        label="6360 Ceramic filters (frequency)",
        description="""Ceramic filters (frequency)//Keramikfilter (Frequenz-)""",
    )

    dfg_6360_11 = VocabularyTerm(
        code="DFG_6360_11",
        label="6360 Tracking filters",
        description="""Tracking filters//Mitlauffilter, Tracking Filter""",
    )

    dfg_6360_12 = VocabularyTerm(
        code="DFG_6360_12",
        label="6360 Mode filters, microwave filters",
        description="""Mode filters, microwave filters//Modenfilter, Mikrowellenfilter""",
    )

    dfg_6360_13 = VocabularyTerm(
        code="DFG_6360_13",
        label="6360 Quartz filters, oscillators (HF technology)",
        description="""Quartz filters, oscillators (HF technology)//Quarzfilter, -Schwinger (HF-Technik)""",
    )

    dfg_6360_14 = VocabularyTerm(
        code="DFG_6360_14",
        label="6360 Resonant frequency meters",
        description="""Resonant frequency meters//Resonanzfrequenzmesser""",
    )

    dfg_6360_15 = VocabularyTerm(
        code="DFG_6360_15",
        label="6360 Spectrum equaliser, -converter (filter channels)",
        description="""Spectrum equaliser, -converter (filter channels)//Spektrum-Entzerrer, -Umformer (Filterkanäle)""",
    )

    dfg_6360_16 = VocabularyTerm(
        code="DFG_6360_16",
        label="6360 Third-octave band filter",
        description="""Third-octave band filter//Terz/Oktav-Bandpässe, -filter""",
    )

    dfg_6360_17 = VocabularyTerm(
        code="DFG_6360_17",
        label="6360 Low psse (filter)",
        description="""Low psse (filter)//Tiefpässe (Filter)""",
    )

    dfg_6360_18 = VocabularyTerm(
        code="DFG_6360_18",
        label="6360 Tongue frequency meter",
        description="""Tongue frequency meter//Zungenfrequenzmesser""",
    )

    dfg_6370_1 = VocabularyTerm(
        code="DFG_6370_1",
        label="6370 Time-of-flight chains (also as energy storage)",
        description="""Time-of-flight chains (also as energy storage)//Laufzeit-Ketten (auch als Energiespeicher)""",
    )

    dfg_6370_2 = VocabularyTerm(
        code="DFG_6370_2",
        label="6370 RCL chains",
        description="""RCL chains//RCL-Ketten""",
    )

    dfg_6370_3 = VocabularyTerm(
        code="DFG_6370_3",
        label="6370 Ultrasound vergerungsleitungen",
        description="""Ultrasound vergerungsleitungen//Ultraschall-Verzögerungsleitungen""",
    )

    dfg_6370_4 = VocabularyTerm(
        code="DFG_6370_4",
        label="6370 Excitation chains, lines",
        description="""Excitation chains, lines//Verzögerungsketten, -leitungen""",
    )

    dfg_6380_1 = VocabularyTerm(
        code="DFG_6380_1",
        label="6380 Real-time narrow-band (frequency) analysers",
        description="""Real-time narrow-band (frequency) analysers//Echtzeit-Schmalband- (Frequenz-) Analysatoren""",
    )

    dfg_6380_2 = VocabularyTerm(
        code="DFG_6380_2",
        label="6380 FFT (Fast Fourier Transform) real time spectrum analysers (real time frequency analysers)",
        description="""FFT (Fast Fourier Transform) real time spectrum analysers (real time frequency analysers)//FFT (Fast-Fourier-Transform)-Real-Time Spectrum-Analyzer (Echtzeit-Frequenz-Analysatoren)""",
    )

    dfg_6380_3 = VocabularyTerm(
        code="DFG_6380_3",
        label="6380 Frequency analysers, vibration analysers",
        description="""Frequency analysers, vibration analysers//Frequenzanalysatoren, Schwingungsanalysatoren""",
    )

    dfg_6380_4 = VocabularyTerm(
        code="DFG_6380_4",
        label="6380 Tracking analysers",
        description="""Tracking analysers//Mitlaufanalysatoren""",
    )

    dfg_6380_5 = VocabularyTerm(
        code="DFG_6380_5",
        label="6380 Modal analysis systems",
        description="""Modal analysis systems//Modalanalyse-Systeme""",
    )

    dfg_6380_6 = VocabularyTerm(
        code="DFG_6380_6",
        label="6380 Harmonic analysers",
        description="""Harmonic analysers//Oberwellen-Analysatoren""",
    )

    dfg_6380_7 = VocabularyTerm(
        code="DFG_6380_7",
        label="6380 Spectrum analysers (electrical)",
        description="""Spectrum analysers (electrical)//Spektrumanalysatoren (elektrisch)""",
    )

    dfg_6380_8 = VocabularyTerm(
        code="DFG_6380_8",
        label="6380 Search tone analysers (except sound spectrographs 0050)",
        description="""Search tone analysers (except sound spectrographs 0050)//Suchton-Analysatoren (außer Schallspektrographen 0050)""",
    )

    dfg_6380_9 = VocabularyTerm(
        code="DFG_6380_9",
        label="6380 Wave analysers",
        description="""Wave analysers//Wave-Analyzer""",
    )

    dfg_6390_1 = VocabularyTerm(
        code="DFG_6390_1",
        label="6390 Frequency synchronisers, stabilisers (HF technology)",
        description="""Frequency synchronisers, stabilisers (HF technology)//Frequenz-Synchronisiergeräte, -Stabilisiergeräte (HF-Technik)""",
    )

    dfg_6390_2 = VocabularyTerm(
        code="DFG_6390_2",
        label="6390 Frequency divider, -reducer",
        description="""Frequency divider, -reducer//Frequenz-Teiler, -Untersetzer""",
    )

    dfg_6390_3 = VocabularyTerm(
        code="DFG_6390_3",
        label="6390 Frequency multiplier (electrical)",
        description="""Frequency multiplier (electrical)//Frequenz-Vervielfacher (elektrisch)""",
    )

    dfg_6390_4 = VocabularyTerm(
        code="DFG_6390_4",
        label="6390 Phase shifters (high-frequency technology)",
        description="""Phase shifters (high-frequency technology)//Phasenschieber (Hochfrequenztechnik)""",
    )

    dfg_6390_5 = VocabularyTerm(
        code="DFG_6390_5",
        label="6390 Synchronisers for frequency response analysers and measuring generators",
        description="""Synchronisers for frequency response analysers and measuring generators//Synchronisiergeräte für Frequenzgang-Analysatoren und Messgeneratoren""",
    )

    dfg_6390_6 = VocabularyTerm(
        code="DFG_6390_6",
        label="6390 Accessories for measuring and function generators",
        description="""Accessories for measuring and function generators//Zubehör zu Mess- und Funktionsgeneratoren""",
    )

    dfg_6400_1 = VocabularyTerm(
        code="DFG_6400_1",
        label="6400 Analogue multimeters",
        description="""Analogue multimeters//Analog-Multimeter""",
    )

    dfg_6400_2 = VocabularyTerm(
        code="DFG_6400_2",
        label="6400 Multimeters, analogue display",
        description="""Multimeters, analogue display//Multimeter, analog anzeigend""",
    )

    dfg_6400_3 = VocabularyTerm(
        code="DFG_6400_3",
        label="6400 Multi-measuring instruments (voltage, current, resistance), analogue",
        description="""Multi-measuring instruments (voltage, current, resistance), analogue//Vielfach-Messinstrumente (Spannung, Strom, Widerstand), analog""",
    )

    dfg_6410_1 = VocabularyTerm(
        code="DFG_6410_1",
        label="6410 AC voltmeter (analogue)",
        description="""AC voltmeter (analogue)//AC-Voltmeter (analog)""",
    )

    dfg_6410_2 = VocabularyTerm(
        code="DFG_6410_2",
        label="6410 Ammeter (analogue)",
        description="""Ammeter (analogue)//Amperemeter (analog)""",
    )

    dfg_6410_3 = VocabularyTerm(
        code="DFG_6410_3",
        label="6410 Analogue indicating ammeters and voltmeters",
        description="""Analogue indicating ammeters and voltmeters//Analog anzeigende Strom- und Spannungsmesser""",
    )

    dfg_6410_4 = VocabularyTerm(
        code="DFG_6410_4",
        label="6410 Ballistic galvanometers",
        description="""Ballistic galvanometers//Ballistische Galvanometer""",
    )

    dfg_6410_5 = VocabularyTerm(
        code="DFG_6410_5",
        label="6410 RMS voltmeters",
        description="""RMS voltmeters//Effektivwert-Voltmeter""",
    )

    dfg_6410_6 = VocabularyTerm(
        code="DFG_6410_6",
        label="6410 Galvanometers",
        description="""Galvanometers//Galvanometer""",
    )

    dfg_6410_7 = VocabularyTerm(
        code="DFG_6410_7",
        label="6410 Hot-wire ammeters",
        description="""Hot-wire ammeters//Hitzedraht-Amperemeter""",
    )

    dfg_6410_8 = VocabularyTerm(
        code="DFG_6410_8",
        label="6410 Light-mark galvanometers",
        description="""Light-mark galvanometers//Lichtmarkengalvanometer""",
    )

    dfg_6410_9 = VocabularyTerm(
        code="DFG_6410_9",
        label="6410 Microamperemeter (analogue)",
        description="""Microamperemeter (analogue)//Mikroamperemeter (analog)""",
    )

    dfg_6410_10 = VocabularyTerm(
        code="DFG_6410_10",
        label="6410 Microvoltmeter (analogue)",
        description="""Microvoltmeter (analogue)//Mikrovoltmeter (analog)""",
    )

    dfg_6410_11 = VocabularyTerm(
        code="DFG_6410_11",
        label="6410 Milliammeter (analogue)",
        description="""Milliammeter (analogue)//Milliamperemeter (analog)""",
    )

    dfg_6410_12 = VocabularyTerm(
        code="DFG_6410_12",
        label="6410 Millivoltmeter (analogue)",
        description="""Millivoltmeter (analogue)//Millivoltmeter (analog)""",
    )

    dfg_6410_13 = VocabularyTerm(
        code="DFG_6410_13",
        label="6410 Nanoamperemeter (analogue)",
        description="""Nanoamperemeter (analogue)//Nanoamperemeter (analog)""",
    )

    dfg_6410_14 = VocabularyTerm(
        code="DFG_6410_14",
        label="6410 Nanovoltmeter (analogue)",
        description="""Nanovoltmeter (analogue)//Nanovoltmeter (analog)""",
    )

    dfg_6410_15 = VocabularyTerm(
        code="DFG_6410_15",
        label="6410 Photocell galvanometer",
        description="""Photocell galvanometer//Photozellengalvanometer""",
    )

    dfg_6410_16 = VocabularyTerm(
        code="DFG_6410_16",
        label="6410 Picoammeter",
        description="""Picoammeter//Picoammeter""",
    )

    dfg_6410_17 = VocabularyTerm(
        code="DFG_6410_17",
        label="6410 Floating galvanometer",
        description="""Floating galvanometer//Schwimmgalvanometer""",
    )

    dfg_6410_18 = VocabularyTerm(
        code="DFG_6410_18",
        label="6410 Mirror galvanometer",
        description="""Mirror galvanometer//Spiegelgalvanometer""",
    )

    dfg_6410_19 = VocabularyTerm(
        code="DFG_6410_19",
        label="6410 Static voltmeters",
        description="""Static voltmeters//Statische Voltmeter""",
    )

    dfg_6410_20 = VocabularyTerm(
        code="DFG_6410_20",
        label="6410 Thermoamperemeter",
        description="""Thermoamperemeter//Thermoamperemeter""",
    )

    dfg_6410_21 = VocabularyTerm(
        code="DFG_6410_21",
        label="6410 Amplifier voltmeters (except 6420)",
        description="""Amplifier voltmeters (except 6420)//Verstärker-Voltmeter (außer 6420)""",
    )

    dfg_6410_22 = VocabularyTerm(
        code="DFG_6410_22",
        label="6410 Voltmeter (analogue)",
        description="""Voltmeter (analogue)//Voltmeter (analog)""",
    )

    dfg_6420_1 = VocabularyTerm(
        code="DFG_6420_1",
        label="6420 Antenna meters (measuring receivers for receiving antennas)",
        description="""Antenna meters (measuring receivers for receiving antennas)//Antennenmessgeräte (Messempfänger für Empfangsantennen)""",
    )

    dfg_6420_2 = VocabularyTerm(
        code="DFG_6420_2",
        label="6420 Measuring receivers, field strength meters",
        description="""Measuring receivers, field strength meters//Messempfänger, Feldstärkemessgeräte""",
    )

    dfg_6420_3 = VocabularyTerm(
        code="DFG_6420_3",
        label="6420 Millivoltmeters, selective",
        description="""Millivoltmeters, selective//Millivoltmeter, selektive""",
    )

    dfg_6420_4 = VocabularyTerm(
        code="DFG_6420_4",
        label="6420 Radiometers (microwaves), field meters",
        description="""Radiometers (microwaves), field meters//Radiometer (Mikrowellen), Feldstärkemessgeräte""",
    )

    dfg_6420_5 = VocabularyTerm(
        code="DFG_6420_5",
        label="6420 RF interferometers",
        description="""RF interferometers//RF-Interferometer""",
    )

    dfg_6420_6 = VocabularyTerm(
        code="DFG_6420_6",
        label="6420 Selective level meters",
        description="""Selective level meters//Selektive Pegelmesser""",
    )

    dfg_6420_7 = VocabularyTerm(
        code="DFG_6420_7",
        label="6420 Signal trackers",
        description="""Signal trackers//Signalverfolger""",
    )

    dfg_6430_1 = VocabularyTerm(
        code="DFG_6430_1",
        label="6430 Digital indicating meters for voltage, current, resistance",
        description="""Digital indicating meters for voltage, current, resistance//Digital anzeigende Messgeräte für Spannung, Strom, Widerstand""",
    )

    dfg_6430_2 = VocabularyTerm(
        code="DFG_6430_2",
        label="6430 Digital rms voltmeters, multimeters",
        description="""Digital rms voltmeters, multimeters//Digital-Effektivwert-Voltmeter, -Multimeter""",
    )

    dfg_6430_3 = VocabularyTerm(
        code="DFG_6430_3",
        label="6430 Digital multimeter",
        description="""Digital multimeter//Digital-Multimeter""",
    )

    dfg_6430_4 = VocabularyTerm(
        code="DFG_6430_4",
        label="6430 Digital voltmeters (DVM)",
        description="""Digital voltmeters (DVM)//Digital-Voltmeter (DVM)""",
    )

    dfg_6430_5 = VocabularyTerm(
        code="DFG_6430_5",
        label="6430 Multiple measuring instruments, digitally indicating",
        description="""Multiple measuring instruments, digitally indicating//Vielfach-Messinstrumente, digital anzeigend""",
    )

    dfg_6440_1 = VocabularyTerm(
        code="DFG_6440_1",
        label="6440 Level meters",
        description="""Level meters//Aussteuerungs-Messgeräte""",
    )

    dfg_6440_2 = VocabularyTerm(
        code="DFG_6440_2",
        label="6440 Reactive power meters",
        description="""Reactive power meters//Blindleistungsmesser""",
    )

    dfg_6440_3 = VocabularyTerm(
        code="DFG_6440_3",
        label="6440 cos phi meters",
        description="""cos phi meters//cos phi-Messgeräte""",
    )

    dfg_6440_4 = VocabularyTerm(
        code="DFG_6440_4",
        label="6440 Digital wattmeter",
        description="""Digital wattmeter//Digital-Wattmeter""",
    )

    dfg_6440_5 = VocabularyTerm(
        code="DFG_6440_5",
        label="6440 Direction of rotation indicator (three-phase current)",
        description="""Direction of rotation indicator (three-phase current)//Drehrichtungsanzeiger (Drehstrom)""",
    )

    dfg_6440_6 = VocabularyTerm(
        code="DFG_6440_6",
        label="6440 Insulation meters",
        description="""Insulation meters//Isolationsmesser""",
    )

    dfg_6440_7 = VocabularyTerm(
        code="DFG_6440_7",
        label="6440 Power meters, wattmeters",
        description="""Power meters, wattmeters//Leistungsmesser, Wattmeter""",
    )

    dfg_6440_8 = VocabularyTerm(
        code="DFG_6440_8",
        label="6440 Electric power meters, phase angle meters, other special electric meters",
        description="""Electric power meters, phase angle meters, other special electric meters//Messgeräte für elektrische Leistung, Phasenwinkel, andere spezielle elektrische Messgrössen""",
    )

    dfg_6440_9 = VocabularyTerm(
        code="DFG_6440_9",
        label="6440 Harmonic meters",
        description="""Harmonic meters//Oberwellenmessgeräte""",
    )

    dfg_6440_10 = VocabularyTerm(
        code="DFG_6440_10",
        label="6440 Phase meters (electrical)",
        description="""Phase meters (electrical)//Phasenmesser (elektrische)""",
    )

    dfg_6440_11 = VocabularyTerm(
        code="DFG_6440_11",
        label="6440 Apparent power meters",
        description="""Apparent power meters//Scheinleistungsmessgeräte""",
    )

    dfg_6440_12 = VocabularyTerm(
        code="DFG_6440_12",
        label="6440 Peak factor meters",
        description="""Peak factor meters//Scheitelfaktor-Messgeräte""",
    )

    dfg_6440_13 = VocabularyTerm(
        code="DFG_6440_13",
        label="6440 Peak voltmeters",
        description="""Peak voltmeters//Spitzenspannungsmesser""",
    )

    dfg_6440_14 = VocabularyTerm(
        code="DFG_6440_14",
        label="6440 Statistical voltmeters",
        description="""Statistical voltmeters//Statistische Voltmeter""",
    )

    dfg_6440_15 = VocabularyTerm(
        code="DFG_6440_15",
        label="6440 Surge voltage voltmeters",
        description="""Surge voltage voltmeters//Stoß-Spannungs-Voltmeter""",
    )

    dfg_6440_16 = VocabularyTerm(
        code="DFG_6440_16",
        label="6440 Transformer ratio meters",
        description="""Transformer ratio meters//Trafo-Übersetzungsmesser""",
    )

    dfg_6440_17 = VocabularyTerm(
        code="DFG_6440_17",
        label="6440 U-Functionmeter (electronic voltage and power measurement)",
        description="""U-Functionmeter (electronic voltage and power measurement)//U-Functionmeter (elektronische Spannungs- und Leistungsmessung)""",
    )

    dfg_6440_18 = VocabularyTerm(
        code="DFG_6440_18",
        label="6440 Vector component voltmeters",
        description="""Vector component voltmeters//Vektor-Komponenten-Voltmeter""",
    )

    dfg_6440_19 = VocabularyTerm(
        code="DFG_6440_19",
        label="6440 Vector voltmeter",
        description="""Vector voltmeter//Vektor-Voltmeter""",
    )

    dfg_6440_20 = VocabularyTerm(
        code="DFG_6440_20",
        label="6440 Wattmeter",
        description="""Wattmeter//Wattmeter""",
    )

    dfg_6440_21 = VocabularyTerm(
        code="DFG_6440_21",
        label="6440 Active power meter",
        description="""Active power meter//Wirkleistungsmesser""",
    )

    dfg_6450_1 = VocabularyTerm(
        code="DFG_6450_1",
        label="6450 Earth-fault detectors, -detectors",
        description="""Earth-fault detectors, -detectors//Erdschluss-Suchgeräte, -Detektoren""",
    )

    dfg_6450_2 = VocabularyTerm(
        code="DFG_6450_2",
        label="6450 Earth leakage meters, earth resistance meters",
        description="""Earth leakage meters, earth resistance meters//Erdungsmessgeräte, Erdwiderstands-Messgeräte""",
    )

    dfg_6450_3 = VocabularyTerm(
        code="DFG_6450_3",
        label="6450 Mutual inductance measuring bridges",
        description="""Mutual inductance measuring bridges//Gegeninduktivitäts-Messbrücken""",
    )

    dfg_6450_4 = VocabularyTerm(
        code="DFG_6450_4",
        label="6450 Gtefactor meters",
        description="""Gtefactor meters//Gütefaktormesser""",
    )

    dfg_6450_5 = VocabularyTerm(
        code="DFG_6450_5",
        label="6450 Immittance bridges",
        description="""Immittance bridges//Immittanzbrücken""",
    )

    dfg_6450_6 = VocabularyTerm(
        code="DFG_6450_6",
        label="6450 Inductive voltage dividers, measuring bridges",
        description="""Inductive voltage dividers, measuring bridges//Induktive Spannungsteiler, Messbrücken""",
    )

    dfg_6450_7 = VocabularyTerm(
        code="DFG_6450_7",
        label="6450 Inductance meters",
        description="""Inductance meters//Induktivitätsmessgeräte""",
    )

    dfg_6450_8 = VocabularyTerm(
        code="DFG_6450_8",
        label="6450 Capacitance meters",
        description="""Capacitance meters//Kapazitätsmessgeräte""",
    )

    dfg_6450_9 = VocabularyTerm(
        code="DFG_6450_9",
        label="6450 Conductance meters",
        description="""Conductance meters//Leitwertmessgeräte""",
    )

    dfg_6450_10 = VocabularyTerm(
        code="DFG_6450_10",
        label="6450 Measuring bridges and compensators, resistance measuring instruments",
        description="""Measuring bridges and compensators, resistance measuring instruments//Messbrücken und Kompensatoren, Widerstandsmessgeräte""",
    )

    dfg_6450_11 = VocabularyTerm(
        code="DFG_6450_11",
        label="6450 Ohmmeters",
        description="""Ohmmeters//Ohmmeter""",
    )

    dfg_6450_12 = VocabularyTerm(
        code="DFG_6450_12",
        label="6450 Q-meters",
        description="""Q-meters//Q-Meter""",
    )

    dfg_6450_13 = VocabularyTerm(
        code="DFG_6450_13",
        label="6450 RCL measuring blocks, measuring instruments",
        description="""RCL measuring blocks, measuring instruments//RCL-Messbrücken, -Messgeräte""",
    )

    dfg_6450_14 = VocabularyTerm(
        code="DFG_6450_14",
        label="6450 Apparent resistance measuring bridges",
        description="""Apparent resistance measuring bridges//Scheinwiderstands-Messbrücken""",
    )

    dfg_6450_15 = VocabularyTerm(
        code="DFG_6450_15",
        label="6450 Schering-Maxwell-bricks",
        description="""Schering-Maxwell-bricks//Schering-Maxwell-Brücken""",
    )

    dfg_6450_16 = VocabularyTerm(
        code="DFG_6450_16",
        label="6450 Teraohmmeter",
        description="""Teraohmmeter//Teraohmmeter""",
    )

    dfg_6450_17 = VocabularyTerm(
        code="DFG_6450_17",
        label="6450 Thermocouple compensators",
        description="""Thermocouple compensators//Thermokraftfreie Kompensatoren""",
    )

    dfg_6450_18 = VocabularyTerm(
        code="DFG_6450_18",
        label="6450 Dissipation factor meters",
        description="""Dissipation factor meters//Verlustfaktor-Messgeräte""",
    )

    dfg_6450_19 = VocabularyTerm(
        code="DFG_6450_19",
        label="6450 Roller bridges",
        description="""Roller bridges//Walzenbrücken""",
    )

    dfg_6450_20 = VocabularyTerm(
        code="DFG_6450_20",
        label="6450 Alternating voltage compensators",
        description="""Alternating voltage compensators//Wechselspannungs-Kompensatoren""",
    )

    dfg_6450_21 = VocabularyTerm(
        code="DFG_6450_21",
        label="6450 Wheatstone bridges",
        description="""Wheatstone bridges//Wheatstone-Brücken""",
    )

    dfg_6460_1 = VocabularyTerm(
        code="DFG_6460_1",
        label="6460 Instrument transformers, series resistors and accessories for measuring instruments",
        description="""Instrument transformers, series resistors and accessories for measuring instruments//Messwandler, Vorwiderstände und Zubehör zu Messinstrumenten""",
    )

    dfg_6460_2 = VocabularyTerm(
        code="DFG_6460_2",
        label="6460 Voltage transformers",
        description="""Voltage transformers//Spannungswandler""",
    )

    dfg_6460_3 = VocabularyTerm(
        code="DFG_6460_3",
        label="6460 Current transformers",
        description="""Current transformers//Stromwandler""",
    )

    dfg_6460_4 = VocabularyTerm(
        code="DFG_6460_4",
        label="6460 Clamp-type current transformers, current clamps",
        description="""Clamp-type current transformers, current clamps//Zangenstromwandler, Stromzangen""",
    )

    dfg_6470_1 = VocabularyTerm(
        code="DFG_6470_1",
        label="6470 Analogue-digital converters",
        description="""Analogue-digital converters//Analog-Digitalwandler""",
    )

    dfg_6470_2 = VocabularyTerm(
        code="DFG_6470_2",
        label="6470 Digital-to-analogue converters",
        description="""Digital-to-analogue converters//Digital-Analogwandler""",
    )

    dfg_6470_3 = VocabularyTerm(
        code="DFG_6470_3",
        label="6470 Frequency-to-analogue converter",
        description="""Frequency-to-analogue converter//Frequenz-Analogwandler""",
    )

    dfg_6470_4 = VocabularyTerm(
        code="DFG_6470_4",
        label="6470 DC-DC converters",
        description="""DC-DC converters//Gleichstrom-Messwandler""",
    )

    dfg_6470_5 = VocabularyTerm(
        code="DFG_6470_5",
        label="6470 Lin/log converters",
        description="""Lin/log converters//Lin/log-Konverter""",
    )

    dfg_6470_6 = VocabularyTerm(
        code="DFG_6470_6",
        label="6470 Logarithmic converters, voltage converters",
        description="""Logarithmic converters, voltage converters//Logarithmische Konverter, Spannungsumformer""",
    )

    dfg_6470_7 = VocabularyTerm(
        code="DFG_6470_7",
        label="6470 Instrument transformers, electronic (except 730-739)",
        description="""Instrument transformers, electronic (except 730-739)//Messwertwandler, elektronische (außer 730-739)""",
    )

    dfg_6470_8 = VocabularyTerm(
        code="DFG_6470_8",
        label="6470 Pulse code converters",
        description="""Pulse code converters//Pulse-Code-Umsetzer""",
    )

    dfg_6470_9 = VocabularyTerm(
        code="DFG_6470_9",
        label="6470 Voltage-frequency converters",
        description="""Voltage-frequency converters//Spannungsfrequenzumformer""",
    )

    dfg_6470_10 = VocabularyTerm(
        code="DFG_6470_10",
        label="6470 Time-amplitude converters",
        description="""Time-amplitude converters//Time-Amplitude-Converter""",
    )

    dfg_6470_11 = VocabularyTerm(
        code="DFG_6470_11",
        label="6470 VCO, Voltage Controlled Oscillator (transducer)",
        description="""VCO, Voltage Controlled Oscillator (transducer)//VCO, Voltage Controlled Oszillator (Messwertwandler)""",
    )

    dfg_6470_12 = VocabularyTerm(
        code="DFG_6470_12",
        label="6470 Voltage-to-Frequency Converter",
        description="""Voltage-to-Frequency Converter//Voltage-to-Frequency-Converter""",
    )

    dfg_6480_1 = VocabularyTerm(
        code="DFG_6480_1",
        label="6480 Electronics Laboratory Plates",
        description="""Electronics Laboratory Plates//Elektronik-Laborplätze""",
    )

    dfg_6480_2 = VocabularyTerm(
        code="DFG_6480_2",
        label="6480 Zhler-Prfpltze, Zhler-Calibration equipment",
        description="""Zhler-Prfpltze, Zhler-Calibration equipment//Zähler-Prüfplätze, Zähler-Eicheinrichtungen""",
    )

    dfg_6490_1 = VocabularyTerm(
        code="DFG_6490_1",
        label="6490 Electrical quantities, measuring instruments (except 271-276 and 640-648)",
        description="""Electrical quantities, measuring instruments (except 271-276 and 640-648)//Elektrische Größen, Messgeräte (außer 271-276 und 640-648)""",
    )

    dfg_6490_2 = VocabularyTerm(
        code="DFG_6490_2",
        label="6490 Electrometers (tubular)",
        description="""Electrometers (tubular)//Elektrometer (Röhren-)""",
    )

    dfg_6490_3 = VocabularyTerm(
        code="DFG_6490_3",
        label="6490 Filament galvanometers",
        description="""Filament galvanometers//Faden-Galvanometer""",
    )

    dfg_6490_4 = VocabularyTerm(
        code="DFG_6490_4",
        label="6490 Conducting instruments (except 640-645)",
        description="""Conducting instruments (except 640-645)//Leitungs-Prüfgeräte (außer 640-645)""",
    )

    dfg_6490_5 = VocabularyTerm(
        code="DFG_6490_5",
        label="6490 Measuring instruments (electrical and electronic), other",
        description="""Measuring instruments (electrical and electronic), other//Messgeräte (elektrische und elektronische), sonstige""",
    )

    dfg_6490_6 = VocabularyTerm(
        code="DFG_6490_6",
        label="6490 Quadrant electrometers",
        description="""Quadrant electrometers//Quadranten-Elektrometer""",
    )

    dfg_6490_7 = VocabularyTerm(
        code="DFG_6490_7",
        label="6490 String electrometers, galvanometers",
        description="""String electrometers, galvanometers//Saitenelektrometer, -galvanometer""",
    )

    dfg_6490_8 = VocabularyTerm(
        code="DFG_6490_8",
        label="6490 Oscillating capacitor electrometers",
        description="""Oscillating capacitor electrometers//Schwingkondensator-Elektrometer""",
    )

    dfg_6490_9 = VocabularyTerm(
        code="DFG_6490_9",
        label="6490 Partial discharge meters (PD meters)",
        description="""Partial discharge meters (PD meters)//Teilentladungs-Messgeräte (TE-Messgeräte)""",
    )

    dfg_6490_10 = VocabularyTerm(
        code="DFG_6490_10",
        label="6490 Vibrating electrometers, galvanometers",
        description="""Vibrating electrometers, galvanometers//Vibrations-Elektrometer, -Galvanometer""",
    )

    dfg_6500_1 = VocabularyTerm(
        code="DFG_6500_1",
        label="6500 Line recorders, drop-action recorders",
        description="""Line recorders, drop-action recorders//Linienschreiber, Fallbügelschreiber""",
    )

    dfg_6500_2 = VocabularyTerm(
        code="DFG_6500_2",
        label="6500 Multi-colour recorders",
        description="""Multi-colour recorders//Mehrfarbenschreiber""",
    )

    dfg_6510_1 = VocabularyTerm(
        code="DFG_6510_1",
        label="6510 Absorbance recorder",
        description="""Absorbance recorder//Extinktionsschreiber""",
    )

    dfg_6510_2 = VocabularyTerm(
        code="DFG_6510_2",
        label="6510 Flat desk recorder",
        description="""Flat desk recorder//Flachpultschreiber""",
    )

    dfg_6510_3 = VocabularyTerm(
        code="DFG_6510_3",
        label="6510 Compensation line recorder",
        description="""Compensation line recorder//Kompensationslinienschreiber""",
    )

    dfg_6510_4 = VocabularyTerm(
        code="DFG_6510_4",
        label="6510 Compensation recorder (XT recorder), dot plotter",
        description="""Compensation recorder (XT recorder), dot plotter//Kompensations-Schreiber (XT-Schreiber), Punktdrucker""",
    )

    dfg_6510_5 = VocabularyTerm(
        code="DFG_6510_5",
        label="6510 Lin/log recorder",
        description="""Lin/log recorder//Lin/log-Schreiber""",
    )

    dfg_6510_6 = VocabularyTerm(
        code="DFG_6510_6",
        label="6510 Multi-channel recorder",
        description="""Multi-channel recorder//Mehrkanalschreiber""",
    )

    dfg_6510_7 = VocabularyTerm(
        code="DFG_6510_7",
        label="6510 Multi pen recorder",
        description="""Multi pen recorder//Multi-Pen-Recorder""",
    )

    dfg_6510_8 = VocabularyTerm(
        code="DFG_6510_8",
        label="6510 Pigment recorder",
        description="""Pigment recorder//Pigmentschriftschreiber""",
    )

    dfg_6510_9 = VocabularyTerm(
        code="DFG_6510_9",
        label="6510 High-speed recorder",
        description="""High-speed recorder//Schnellschreiber""",
    )

    dfg_6510_10 = VocabularyTerm(
        code="DFG_6510_10",
        label="6510 Thermal recorder",
        description="""Thermal recorder//Thermoschreiber""",
    )

    dfg_6520_1 = VocabularyTerm(
        code="DFG_6520_1",
        label="6520 XY10-Y20 Recorder",
        description="""XY10-Y20 Recorder//XY10-Y20-Schreiber""",
    )

    dfg_6520_2 = VocabularyTerm(
        code="DFG_6520_2",
        label="6520 XY recorder",
        description="""XY recorder//XY-Schreiber""",
    )

    dfg_6520_3 = VocabularyTerm(
        code="DFG_6520_3",
        label="6520 XY-T recorder, compensation recorder",
        description="""XY-T recorder, compensation recorder//XY-T-Schreiber, -Kompensationsschreiber""",
    )

    dfg_6520_4 = VocabularyTerm(
        code="DFG_6520_4",
        label="6520 Two-coordinate compensation line recorder",
        description="""Two-coordinate compensation line recorder//Zweikoordinaten-Kompensations-Linienschreiber""",
    )

    dfg_6530_1 = VocabularyTerm(
        code="DFG_6530_1",
        label="6530 Atmospherics counter (event counter)",
        description="""Atmospherics counter (event counter)//Atmospherics-Counter (Ereigniszähler)""",
    )

    dfg_6530_2 = VocabularyTerm(
        code="DFG_6530_2",
        label="6530 Event recorder",
        description="""Event recorder//Event-Recorder""",
    )

    dfg_6530_3 = VocabularyTerm(
        code="DFG_6530_3",
        label="6530 Power recorders, reactive power recorders",
        description="""Power recorders, reactive power recorders//Leistungsschreiber, Blindleistungsschreiber""",
    )

    dfg_6530_4 = VocabularyTerm(
        code="DFG_6530_4",
        label="6530 Polar Coordinate Recorders",
        description="""Polar Coordinate Recorders//Polarkoordinatenschreiber""",
    )

    dfg_6530_5 = VocabularyTerm(
        code="DFG_6530_5",
        label="6530 Recorders, multi-channel recorders for seismic measurements",
        description="""Recorders, multi-channel recorders for seismic measurements//Registriergeräte, Mehrkanal-Registriergeräte für seismische Messungen""",
    )

    dfg_6530_6 = VocabularyTerm(
        code="DFG_6530_6",
        label="6530 Special recorders (event recorders, currents recorders, lightning recorders)",
        description="""Special recorders (event recorders, currents recorders, lightning recorders)//Spezielle Registriergeräte (Ereigniszähler, Störungsschreiber, Blitzzähler""",
    )

    dfg_6530_7 = VocabularyTerm(
        code="DFG_6530_7",
        label="6530 Time recorders",
        description="""Time recorders//Zeitschreiber""",
    )

    dfg_6540_1 = VocabularyTerm(
        code="DFG_6540_1",
        label="6540 Electricity meters",
        description="""Electricity meters//Elektrizitätszähler""",
    )

    dfg_6540_2 = VocabularyTerm(
        code="DFG_6540_2",
        label="6540 Watt-hour, kWh and operating hour meters",
        description="""Watt-hour, kWh and operating hour meters//Wattstunden-, kWh-Zähler, Betriebsstundenzähler""",
    )

    dfg_6550_1 = VocabularyTerm(
        code="DFG_6550_1",
        label="6550 Plug-in amplifiers for recording instruments",
        description="""Plug-in amplifiers for recording instruments//Einschubverstärker für Registriergeräte""",
    )

    dfg_6550_2 = VocabularyTerm(
        code="DFG_6550_2",
        label="6550 Accessories for electric recording instruments",
        description="""Accessories for electric recording instruments//Zubehör für elektrische Registriergeräte""",
    )

    dfg_6590_1 = VocabularyTerm(
        code="DFG_6590_1",
        label="6590 Recorders (electric, except 6500-6550)",
        description="""Recorders (electric, except 6500-6550)//Registriergeräte (elektrische, außer 6500-6550)""",
    )

    dfg_6590_2 = VocabularyTerm(
        code="DFG_6590_2",
        label="6590 Other electric recording instruments (except 6500-6550)",
        description="""Other electric recording instruments (except 6500-6550)//Sonstige elektrische Registriergeräte (außer 6500-6550)""",
    )

    dfg_6600_1 = VocabularyTerm(
        code="DFG_6600_1",
        label="6600 Telephone and exchange equipment",
        description="""Telephone and exchange equipment//Fernsprechanlagen, Vermittlungsanlagen""",
    )

    dfg_6600_2 = VocabularyTerm(
        code="DFG_6600_2",
        label="6600 Private branch exchanges",
        description="""Private branch exchanges//Nebenstellenanlagen""",
    )

    dfg_6600_3 = VocabularyTerm(
        code="DFG_6600_3",
        label="6600 Telephone installations and accessories",
        description="""Telephone installations and accessories//Telefonanlagen und Zubehör""",
    )

    dfg_6600_4 = VocabularyTerm(
        code="DFG_6600_4",
        label="6600 Telephone carriers (-swivel arm)",
        description="""Telephone carriers (-swivel arm)//Telefonträger (-Schwenkarm)""",
    )

    dfg_6600_5 = VocabularyTerm(
        code="DFG_6600_5",
        label="6600 Dialers, dialer racks (telephone equipment)",
        description="""Dialers, dialer racks (telephone equipment)//Wähler, Wählergestelle (Fernsprechtechnik)""",
    )

    dfg_6610_1 = VocabularyTerm(
        code="DFG_6610_1",
        label="6610 Facsimile recorders",
        description="""Facsimile recorders//Faksimile-Schreiber""",
    )

    dfg_6610_2 = VocabularyTerm(
        code="DFG_6610_2",
        label="6610 Fax machines",
        description="""Fax machines//Fax-Geräte""",
    )

    dfg_6610_3 = VocabularyTerm(
        code="DFG_6610_3",
        label="6610 Telecopiers",
        description="""Telecopiers//Fernkopierer""",
    )

    dfg_6610_4 = VocabularyTerm(
        code="DFG_6610_4",
        label="6610 Teletype machines, videotelegraphy machines",
        description="""Teletype machines, videotelegraphy machines//Fernschreibanlagen, Bildtelegraphiegeräte""",
    )

    dfg_6610_5 = VocabularyTerm(
        code="DFG_6610_5",
        label="6610 Teletype machines (for postal connection)",
        description="""Teletype machines (for postal connection)//Fernschreiber (für Postanschluss)""",
    )

    dfg_6610_6 = VocabularyTerm(
        code="DFG_6610_6",
        label="6610 Fax machines",
        description="""Fax machines//Telefaxgeräte""",
    )

    dfg_6610_7 = VocabularyTerm(
        code="DFG_6610_7",
        label="6610 Telephone copying machines",
        description="""Telephone copying machines//Telefon-Kopiergeräte""",
    )

    dfg_6610_8 = VocabularyTerm(
        code="DFG_6610_8",
        label="6610 Weather chart recorder",
        description="""Weather chart recorder//Wetterkartenschreiber""",
    )

    dfg_6620_1 = VocabularyTerm(
        code="DFG_6620_1",
        label="6620 Universal wave receivers",
        description="""Universal wave receivers//Allwellenempfänger""",
    )

    dfg_6620_2 = VocabularyTerm(
        code="DFG_6620_2",
        label="6620 Doppler measuring systems",
        description="""Doppler measuring systems//Dopplermesssysteme""",
    )

    dfg_6620_3 = VocabularyTerm(
        code="DFG_6620_3",
        label="6620 Receiving apparatus (radio equipment)",
        description="""Receiving apparatus (radio equipment)//Empfängeranlagen (Funkanlagen)""",
    )

    dfg_6620_4 = VocabularyTerm(
        code="DFG_6620_4",
        label="6620 Fixed frequency receivers",
        description="""Fixed frequency receivers//Festfrequenzempfänger""",
    )

    dfg_6620_5 = VocabularyTerm(
        code="DFG_6620_5",
        label="6620 Radio installations (except conference and hall intercoms)",
        description="""Radio installations (except conference and hall intercoms)//Funkanlagen (außer Konferenz- und Saal-Sprechanlagen)""",
    )

    dfg_6620_6 = VocabularyTerm(
        code="DFG_6620_6",
        label="6620 Radio transceivers",
        description="""Radio transceivers//Funksendeempfänger""",
    )

    dfg_6620_7 = VocabularyTerm(
        code="DFG_6620_7",
        label="6620 Radiotelephones",
        description="""Radiotelephones//Funksprechgeräte""",
    )

    dfg_6620_8 = VocabularyTerm(
        code="DFG_6620_8",
        label="6620 Hand-held radio sets",
        description="""Hand-held radio sets//Handfunkgeräte""",
    )

    dfg_6620_9 = VocabularyTerm(
        code="DFG_6620_9",
        label="6620 High-frequency transmitters and receivers",
        description="""High-frequency transmitters and receivers//Hochfrequenzsende- und -empfangsgeräte""",
    )

    dfg_6620_10 = VocabularyTerm(
        code="DFG_6620_10",
        label="6620 Emergency radio sets",
        description="""Emergency radio sets//Notfunkgeräte""",
    )

    dfg_6620_11 = VocabularyTerm(
        code="DFG_6620_11",
        label="6620 Radio relay stations, installations",
        description="""Radio relay stations, installations//Richtfunk-Stationen, -Anlagen""",
    )

    dfg_6620_12 = VocabularyTerm(
        code="DFG_6620_12",
        label="6620 Satellite radio stations, receiving stations",
        description="""Satellite radio stations, receiving stations//Satellitenfunkanlagen, -empfangsanlagen""",
    )

    dfg_6620_13 = VocabularyTerm(
        code="DFG_6620_13",
        label="6620 Transmitting stations",
        description="""Transmitting stations//Sendeanlagen""",
    )

    dfg_6620_14 = VocabularyTerm(
        code="DFG_6620_14",
        label="6620 Transmitter repeaters",
        description="""Transmitter repeaters//Senderverstärker""",
    )

    dfg_6620_15 = VocabularyTerm(
        code="DFG_6620_15",
        label="6620 Radiotelephony equipment (except conference and room intercom equipment)",
        description="""Radiotelephony equipment (except conference and room intercom equipment)//Sprechfunkgeräte (außer Konferenz- und Saal-Sprechanlagen)""",
    )

    dfg_6620_16 = VocabularyTerm(
        code="DFG_6620_16",
        label="6620 Transmitters, transceivers",
        description="""Transmitters, transceivers//Transmitter, Transceiver""",
    )

    dfg_6620_17 = VocabularyTerm(
        code="DFG_6620_17",
        label="6620 VHF/UHF receivers",
        description="""VHF/UHF receivers//VHF/UHF-Empfänger""",
    )

    dfg_6620_18 = VocabularyTerm(
        code="DFG_6620_18",
        label="6620 Time signal receivers",
        description="""Time signal receivers//Zeitsignal-Empfänger""",
    )

    dfg_6630_1 = VocabularyTerm(
        code="DFG_6630_1",
        label="6630 On-board intercom systems",
        description="""On-board intercom systems//Bordsprechanlagen""",
    )

    dfg_6630_2 = VocabularyTerm(
        code="DFG_6630_2",
        label="6630 Interpreter systems",
        description="""Interpreter systems//Dolmetscheranlagen""",
    )

    dfg_6630_3 = VocabularyTerm(
        code="DFG_6630_3",
        label="6630 Light call systems",
        description="""Light call systems//Lichtrufanlagen""",
    )

    dfg_6630_4 = VocabularyTerm(
        code="DFG_6630_4",
        label="6630 Intercom systems, call systems",
        description="""Intercom systems, call systems//Sprechanlagen, Rufanlagen""",
    )

    dfg_6630_5 = VocabularyTerm(
        code="DFG_6630_5",
        label="6630 Loudspeaker systems",
        description="""Loudspeaker systems//Türlautsprecheranlagen""",
    )

    dfg_6630_6 = VocabularyTerm(
        code="DFG_6630_6",
        label="6630 Intercom systems",
        description="""Intercom systems//Wechselsprechanlagen""",
    )

    dfg_6640_1 = VocabularyTerm(
        code="DFG_6640_1",
        label="6640 Alarm systems (except tank monitoring 9890)",
        description="""Alarm systems (except tank monitoring 9890)//Alarmanlagen (außer Öltanküberwachung 9890)""",
    )

    dfg_6640_2 = VocabularyTerm(
        code="DFG_6640_2",
        label="6640 Motion detectors",
        description="""Motion detectors//Bewegungsmelder""",
    )

    dfg_6640_3 = VocabularyTerm(
        code="DFG_6640_3",
        label="6640 Bell systems, lutes, gongs",
        description="""Bell systems, lutes, gongs//Klingelanlagen, Läutewerke, Gongs""",
    )

    dfg_6640_4 = VocabularyTerm(
        code="DFG_6640_4",
        label="6640 Signalling systems (except fire detectors 9860), light barriers",
        description="""Signalling systems (except fire detectors 9860), light barriers//Meldeanlagen (außer Feuermelder 9860), Lichtschranken""",
    )

    dfg_6640_5 = VocabularyTerm(
        code="DFG_6640_5",
        label="6640 Object protection and monitoring devices",
        description="""Object protection and monitoring devices//Objektschutz- und Überwachungsgeräte""",
    )

    dfg_6640_6 = VocabularyTerm(
        code="DFG_6640_6",
        label="6640 Room protection radar",
        description="""Room protection radar//Raumschutzradar""",
    )

    dfg_6640_7 = VocabularyTerm(
        code="DFG_6640_7",
        label="6640 Room surveillance equipment",
        description="""Room surveillance equipment//Raumüberwachungsgeräte""",
    )

    dfg_6640_8 = VocabularyTerm(
        code="DFG_6640_8",
        label="6640 Signalling equipment",
        description="""Signalling equipment//Signalanlagen""",
    )

    dfg_6640_9 = VocabularyTerm(
        code="DFG_6640_9",
        label="6640 Sirens (alarm)",
        description="""Sirens (alarm)//Sirenen (Alarm-)""",
    )

    dfg_6640_10 = VocabularyTerm(
        code="DFG_6640_10",
        label="6640 Sounders, horns, buzzers (alarm, signalling)",
        description="""Sounders, horns, buzzers (alarm, signalling)//Tongeber, Hörner, Summer (Alarm-, Signal-)""",
    )

    dfg_6640_11 = VocabularyTerm(
        code="DFG_6640_11",
        label="6640 Ultrasonic barriers",
        description="""Ultrasonic barriers//Ultraschall-Schranken""",
    )

    dfg_6640_12 = VocabularyTerm(
        code="DFG_6640_12",
        label="6640 Traffic control and counting installations (except radar 6670 and television installations 6730)",
        description="""Traffic control and counting installations (except radar 6670 and television installations 6730)//Verkehrsüberwachungs- und Zählanlagen (außer Radar 6670 und Fernsehanlagen 6730)""",
    )

    dfg_6650_1 = VocabularyTerm(
        code="DFG_6650_1",
        label="6650 Aerial installations",
        description="""Aerial installations//Antennenanlagen""",
    )

    dfg_6650_2 = VocabularyTerm(
        code="DFG_6650_2",
        label="6650 Antenna rotating antennas",
        description="""Antenna rotating antennas//Antennen-Drehstände""",
    )

    dfg_6650_3 = VocabularyTerm(
        code="DFG_6650_3",
        label="6650 Antenna couplers",
        description="""Antenna couplers//Antennen-Koppler""",
    )

    dfg_6650_4 = VocabularyTerm(
        code="DFG_6650_4",
        label="6650 Antenna masts, antenna systems (except radio telescopes 0740 and radar antennas 6670)",
        description="""Antenna masts, antenna systems (except radio telescopes 0740 and radar antennas 6670)//Antennenmasten, -systeme (außer Radioteleskope 0740 und Radarantennen 6670)""",
    )

    dfg_6650_5 = VocabularyTerm(
        code="DFG_6650_5",
        label="6650 Antenna amplifiers",
        description="""Antenna amplifiers//Antennen-Verstärker""",
    )

    dfg_6650_6 = VocabularyTerm(
        code="DFG_6650_6",
        label="6650 Community antenna systems",
        description="""Community antenna systems//Gemeinschaftsantennenanlagen""",
    )

    dfg_6660_1 = VocabularyTerm(
        code="DFG_6660_1",
        label="6660 Time clocks",
        description="""Time clocks//Stechuhren""",
    )

    dfg_6660_2 = VocabularyTerm(
        code="DFG_6660_2",
        label="6660 Time display and recording installations",
        description="""Time display and recording installations//Zeitanzeige- und -registrieranlagen""",
    )

    dfg_6660_3 = VocabularyTerm(
        code="DFG_6660_3",
        label="6660 Central clock installations",
        description="""Central clock installations//Zentraluhrenanlagen""",
    )

    dfg_6670_1 = VocabularyTerm(
        code="DFG_6670_1",
        label="6670 Collision warning devices",
        description="""Collision warning devices//Kollisionswarngeräte""",
    )

    dfg_6670_2 = VocabularyTerm(
        code="DFG_6670_2",
        label="6670 Navigation radar equipment",
        description="""Navigation radar equipment//Navigations-Radargeräte""",
    )

    dfg_6670_3 = VocabularyTerm(
        code="DFG_6670_3",
        label="6670 Radar equipment (except distance meters 0620 and Doppler radar 6640 and 8860)",
        description="""Radar equipment (except distance meters 0620 and Doppler radar 6640 and 8860)//Radaranlagen (außer Distanzmesser 0620 und Doppler-Radar 6640 und 8860)""",
    )

    dfg_6670_4 = VocabularyTerm(
        code="DFG_6670_4",
        label="6670 Radar antennae and reflectors",
        description="""Radar antennae and reflectors//Radar-Antennen, -Reflektoren""",
    )

    dfg_6670_5 = VocabularyTerm(
        code="DFG_6670_5",
        label="6670 Peripheral radar equipment (PPI)",
        description="""Peripheral radar equipment (PPI)//Rundsicht-Radargeräte (PPI)""",
    )

    dfg_6670_6 = VocabularyTerm(
        code="DFG_6670_6",
        label="6670 Weather radar equipment",
        description="""Weather radar equipment//Wetterradaranlagen""",
    )

    dfg_6680_1 = VocabularyTerm(
        code="DFG_6680_1",
        label="6680 Behlter conveyor systems (pneumatic tube systems)",
        description="""Behlter conveyor systems (pneumatic tube systems)//Behälter-Förderanlagen (Rohrpostanlagen)""",
    )

    dfg_6680_2 = VocabularyTerm(
        code="DFG_6680_2",
        label="6680 Pneumatic tube systems",
        description="""Pneumatic tube systems//Rohrpostanlagen""",
    )

    dfg_6690_1 = VocabularyTerm(
        code="DFG_6690_1",
        label="6690 Telephone transmitters (telephone)",
        description="""Telephone transmitters (telephone)//Gebührenzähler (Telefon)""",
    )

    dfg_6690_2 = VocabularyTerm(
        code="DFG_6690_2",
        label="6690 Other telecommunications equipment and installations",
        description="""Other telecommunications equipment and installations//Sonstige Fernmeldegeräte und Anlagen""",
    )

    dfg_6690_3 = VocabularyTerm(
        code="DFG_6690_3",
        label="6690 Voice keyboards",
        description="""Voice keyboards//Sprachschlüsselgeräte""",
    )

    dfg_6690_4 = VocabularyTerm(
        code="DFG_6690_4",
        label="6690 Telephone answering machines",
        description="""Telephone answering machines//Telefon-Anrufbeantworter""",
    )

    dfg_6690_5 = VocabularyTerm(
        code="DFG_6690_5",
        label="6690 Encryption devices, ciphering devices",
        description="""Encryption devices, ciphering devices//Verschlüsselungsgeräte, Chiffriergeräte""",
    )

    dfg_6700_1 = VocabularyTerm(
        code="DFG_6700_1",
        label="6700 Pressure chamber loudspeakers",
        description="""Pressure chamber loudspeakers//Druckkammerlautsprecher""",
    )

    dfg_6700_2 = VocabularyTerm(
        code="DFG_6700_2",
        label="6700 Headphones",
        description="""Headphones//Kopfhörer""",
    )

    dfg_6700_3 = VocabularyTerm(
        code="DFG_6700_3",
        label="6700 Loudspeaker and sound transmission equipment",
        description="""Loudspeaker and sound transmission equipment//Lautsprecher- und Tonübertragungsanlagen""",
    )

    dfg_6700_4 = VocabularyTerm(
        code="DFG_6700_4",
        label="6700 Loudspeaker boxes and columns",
        description="""Loudspeaker boxes and columns//Lautsprecherboxen und -säulen""",
    )

    dfg_6700_5 = VocabularyTerm(
        code="DFG_6700_5",
        label="6700 Megaphones (electronic)",
        description="""Megaphones (electronic)//Megaphone (elektronische)""",
    )

    dfg_6700_6 = VocabularyTerm(
        code="DFG_6700_6",
        label="6700 Radio receivers",
        description="""Radio receivers//Radioempfänger""",
    )

    dfg_6700_7 = VocabularyTerm(
        code="DFG_6700_7",
        label="6700 Radio recorders",
        description="""Radio recorders//Radiorecorder""",
    )

    dfg_6700_8 = VocabularyTerm(
        code="DFG_6700_8",
        label="6700 Stereo headphones",
        description="""Stereo headphones//Stereokopfhörer""",
    )

    dfg_6700_9 = VocabularyTerm(
        code="DFG_6700_9",
        label="6700 Sound columns",
        description="""Sound columns//Tonsäulen""",
    )

    dfg_6700_10 = VocabularyTerm(
        code="DFG_6700_10",
        label="6700 Transmission equipment (loudspeakers)",
        description="""Transmission equipment (loudspeakers)//Übertragungsanlagen (Lautsprecher)""",
    )

    dfg_6700_11 = VocabularyTerm(
        code="DFG_6700_11",
        label="6700 Underwater loudspeakers",
        description="""Underwater loudspeakers//Unterwasser-Lautsprecher""",
    )

    dfg_6710_1 = VocabularyTerm(
        code="DFG_6710_1",
        label="6710 DAT recorders (digital cassette)",
        description="""DAT recorders (digital cassette)//DAT-Recorder (Digital-Kassetten-)""",
    )

    dfg_6710_2 = VocabularyTerm(
        code="DFG_6710_2",
        label="6710 Cassette recorders for sound recording",
        description="""Cassette recorders for sound recording//Kassettenrekorder für Tonaufzeichnung""",
    )

    dfg_6710_3 = VocabularyTerm(
        code="DFG_6710_3",
        label="6710 Magnetic tapes and cassettes for sound recording",
        description="""Magnetic tapes and cassettes for sound recording//Magnetbänder und -kassetten für Tonaufzeichnung""",
    )

    dfg_6710_4 = VocabularyTerm(
        code="DFG_6710_4",
        label="6710 Magnetic tape recorders for music and speech (except 9230 dictation machines)",
        description="""Magnetic tape recorders for music and speech (except 9230 dictation machines)//Magnetbandgeräte für Musik und Sprache (außer Diktiergeräte 9230)""",
    )

    dfg_6710_5 = VocabularyTerm(
        code="DFG_6710_5",
        label="6710 Reportage tape recorders",
        description="""Reportage tape recorders//Reportage-Tonbandgeräte""",
    )

    dfg_6710_6 = VocabularyTerm(
        code="DFG_6710_6",
        label="6710 Tape recorders and accessories",
        description="""Tape recorders and accessories//Tonbandgeräte und Zubehör""",
    )

    dfg_6720_1 = VocabularyTerm(
        code="DFG_6720_1",
        label="6720 Compact disc players",
        description="""Compact disc players//Compact Disc -Abspielgeräte""",
    )

    dfg_6720_2 = VocabularyTerm(
        code="DFG_6720_2",
        label="6720 Record players, record changers",
        description="""Record players, record changers//Plattenspieler, Plattenwechsler""",
    )

    dfg_6720_3 = VocabularyTerm(
        code="DFG_6720_3",
        label="6720 Automatic record machines",
        description="""Automatic record machines//Schallplattenautomaten""",
    )

    dfg_6720_4 = VocabularyTerm(
        code="DFG_6720_4",
        label="6720 Record-cutting machines",
        description="""Record-cutting machines//Schallplatten-Schneidgeräte""",
    )

    dfg_6720_5 = VocabularyTerm(
        code="DFG_6720_5",
        label="6720 Control systems, mixing desks and record machines",
        description="""Control systems, mixing desks and record machines//Steueranlagen, Mischpulte und Schallplattengeräte""",
    )

    dfg_6720_6 = VocabularyTerm(
        code="DFG_6720_6",
        label="6720 Cartridges",
        description="""Cartridges//Tonabnehmer""",
    )

    dfg_6720_7 = VocabularyTerm(
        code="DFG_6720_7",
        label="6720 Recording studio equipment (except microphones 0040, loudspeakers 6700 and magnetic tape recorders 6710)",
        description="""Recording studio equipment (except microphones 0040, loudspeakers 6700 and magnetic tape recorders 6710)//Tonstudiotechnik, Geräte (außer Mikrofone 0040, Lautsprecher 6700 und Magnetbandgeräte 6710)""",
    )

    dfg_6720_8 = VocabularyTerm(
        code="DFG_6720_8",
        label="6720 Amplification equipment (recording studio)",
        description="""Amplification equipment (recording studio)//Verstärkeranlagen (Tonstudio)""",
    )

    dfg_6730_1 = VocabularyTerm(
        code="DFG_6730_1",
        label="6730 Videophones",
        description="""Videophones//Bild-Sprechgeräte""",
    )

    dfg_6730_2 = VocabularyTerm(
        code="DFG_6730_2",
        label="6730 Colour television cameras",
        description="""Colour television cameras//Farbfernsehkameras""",
    )

    dfg_6730_3 = VocabularyTerm(
        code="DFG_6730_3",
        label="6730 Television cameras and complete television installations",
        description="""Television cameras and complete television installations//Fernseh-Kameras und vollständige Fernsehanlagen""",
    )

    dfg_6730_4 = VocabularyTerm(
        code="DFG_6730_4",
        label="6730 Film scanners (television)",
        description="""Film scanners (television)//Filmabtaster (Fernseh-)""",
    )

    dfg_6730_5 = VocabularyTerm(
        code="DFG_6730_5",
        label="6730 Industrial television installations",
        description="""Industrial television installations//Industrie-Fernsehanlagen""",
    )

    dfg_6730_6 = VocabularyTerm(
        code="DFG_6730_6",
        label="6730 Infrared television cameras (except 8620 thermographic apparatus)",
        description="""Infrared television cameras (except 8620 thermographic apparatus)//Infrarot-Fernsehkameras (außer Thermographiegeräte 8620)""",
    )

    dfg_6730_7 = VocabularyTerm(
        code="DFG_6730_7",
        label="6730 SIT (Silicon Intensified Target) cameras",
        description="""SIT (Silicon Intensified Target) cameras//SIT (Silicon Intensified Target)-Kameras""",
    )

    dfg_6730_8 = VocabularyTerm(
        code="DFG_6730_8",
        label="6730 Classroom display systems",
        description="""Classroom display systems//Unterrichts-Mitschau-Anlagen""",
    )

    dfg_6730_9 = VocabularyTerm(
        code="DFG_6730_9",
        label="6730 Video cameras",
        description="""Video cameras//Videokameras""",
    )

    dfg_6730_10 = VocabularyTerm(
        code="DFG_6730_10",
        label="6730 Video-communication equipment",
        description="""Video-communication equipment//Video-Kommunikations-Anlagen""",
    )

    dfg_6730_11 = VocabularyTerm(
        code="DFG_6730_11",
        label="6730 Video-retrieval systems, complete (except tape drive controllers 7370)",
        description="""Video-retrieval systems, complete (except tape drive controllers 7370)//Video-Retrieval-Systeme, vollständig (außer Bandlauf-Steuergeräte 7370)""",
    )

    dfg_6740_1 = VocabularyTerm(
        code="DFG_6740_1",
        label="6740 Picture monitors",
        description="""Picture monitors//Bildmonitore""",
    )

    dfg_6740_2 = VocabularyTerm(
        code="DFG_6740_2",
        label="6740 Colour television receivers",
        description="""Colour television receivers//Farbfernsehempfänger""",
    )

    dfg_6740_3 = VocabularyTerm(
        code="DFG_6740_3",
        label="6740 Colour monitors",
        description="""Colour monitors//Farbmonitore""",
    )

    dfg_6740_4 = VocabularyTerm(
        code="DFG_6740_4",
        label="6740 Television receivers, monitors, projectors",
        description="""Television receivers, monitors, projectors//Fernseh-Empfänger, -Monitoren, -Projektoren""",
    )

    dfg_6740_5 = VocabularyTerm(
        code="DFG_6740_5",
        label="6740 Television large-screen projectors",
        description="""Television large-screen projectors//Fernseh-Großbildprojektoren""",
    )

    dfg_6740_6 = VocabularyTerm(
        code="DFG_6740_6",
        label="6740 Large-screen projectors (television)",
        description="""Large-screen projectors (television)//Großbildprojektoren (Fernseh-)""",
    )

    dfg_6750_1 = VocabularyTerm(
        code="DFG_6750_1",
        label="6750 Digital recording television equipment (magnetic tape, fr graphic display)",
        description="""Digital recording television equipment (magnetic tape, fr graphic display)//Digital speichernde Fernsehanlagen (Magnetband, für graphische Darstellung)""",
    )

    dfg_6750_2 = VocabularyTerm(
        code="DFG_6750_2",
        label="6750 Television picture recording apparatus",
        description="""Television picture recording apparatus//Fernseh-Bildaufzeichnungsapparaturen""",
    )

    dfg_6750_3 = VocabularyTerm(
        code="DFG_6750_3",
        label="6750 Magnetic tapes for video recorders",
        description="""Magnetic tapes for video recorders//Magnetbänder für Video-Recorder""",
    )

    dfg_6750_4 = VocabularyTerm(
        code="DFG_6750_4",
        label="6750 Magnetic tape recorders for television and X-rays",
        description="""Magnetic tape recorders for television and X-rays//Magnetbandspeicher für Fernsehen und Röntgen""",
    )

    dfg_6750_5 = VocabularyTerm(
        code="DFG_6750_5",
        label="6750 X-ray television picture recorders (magnetic tape)",
        description="""X-ray television picture recorders (magnetic tape)//Röntgen-Fernseh-Bildspeicher (Magnetband)""",
    )

    dfg_6750_6 = VocabularyTerm(
        code="DFG_6750_6",
        label="6750 VCR (video cassette recorder)",
        description="""VCR (video cassette recorder)//VCR (Video-Cassetten-Recorder)""",
    )

    dfg_6750_7 = VocabularyTerm(
        code="DFG_6750_7",
        label="6750 Video tape recorder",
        description="""Video tape recorder//Video-Bandgeräte""",
    )

    dfg_6750_8 = VocabularyTerm(
        code="DFG_6750_8",
        label="6750 Video disk storage",
        description="""Video disk storage//Video-Plattenspeicher""",
    )

    dfg_6750_9 = VocabularyTerm(
        code="DFG_6750_9",
        label="6750 Video recorder,-memory",
        description="""Video recorder,-memory//Video-Recorder,-Speicher""",
    )

    dfg_6760_1 = VocabularyTerm(
        code="DFG_6760_1",
        label="6760 Picture direction and control units, control devices",
        description="""Picture direction and control units, control devices//Bildregie- und Kontroll-Einheiten, Steuergeräte""",
    )

    dfg_6760_2 = VocabularyTerm(
        code="DFG_6760_2",
        label="6760 Colour converters (with quidensite display) for visual image evaluation",
        description="""Colour converters (with quidensite display) for visual image evaluation//Farbumsetzer (mit Äquidensiten-Darstellung) für visuelle Bildauswertung""",
    )

    dfg_6760_3 = VocabularyTerm(
        code="DFG_6760_3",
        label="6760 Television control units",
        description="""Television control units//Fernseh-Regie-Enrichtungen""",
    )

    dfg_6760_4 = VocabularyTerm(
        code="DFG_6760_4",
        label="6760 Television control centres",
        description="""Television control centres//Fernseh-Steuerzentralen""",
    )

    dfg_6760_5 = VocabularyTerm(
        code="DFG_6760_5",
        label="6760 Television trick mixing consoles",
        description="""Television trick mixing consoles//Fernseh-Trickmischpulte""",
    )

    dfg_6770_1 = VocabularyTerm(
        code="DFG_6770_1",
        label="6770 Language laboratories",
        description="""Language laboratories//Sprachlabors""",
    )

    dfg_6770_2 = VocabularyTerm(
        code="DFG_6770_2",
        label="6770 Language teaching systems, language laboratories",
        description="""Language teaching systems, language laboratories//Sprachlehrsysteme, Sprachlabors""",
    )

    dfg_6780_1 = VocabularyTerm(
        code="DFG_6780_1",
        label="6780 Audio-visual teaching systems and apparatus (except projection apparatus 5500, 5510 and television apparatus 6730)",
        description="""Audio-visual teaching systems and apparatus (except projection apparatus 5500, 5510 and television apparatus 6730)//Audio-visuelle Lehrsysteme und Geräte (außer Projektionsgeräte 5500, 5510 und Fernsehanlagen 6730)""",
    )

    dfg_6790_1 = VocabularyTerm(
        code="DFG_6790_1",
        label="6790 Television studio accessories",
        description="""Television studio accessories//Fernseh-Studio-Zubehör""",
    )

    dfg_6790_2 = VocabularyTerm(
        code="DFG_6790_2",
        label="6790 Sound recording apparatus",
        description="""Sound recording apparatus//Lichttonaufzeichnungsgeräte""",
    )

    dfg_6790_3 = VocabularyTerm(
        code="DFG_6790_3",
        label="6790 Measuring records",
        description="""Measuring records//Messschallplatten""",
    )

    dfg_6790_4 = VocabularyTerm(
        code="DFG_6790_4",
        label="6790 Other audio and video equipment (except 0040 microphones and 6700-6780)",
        description="""Other audio and video equipment (except 0040 microphones and 6700-6780)//Sonstige Geräte der Audio-, Videotechnik (außer 0040 Mikrofone und 6700-6780)""",
    )

    dfg_6790_5 = VocabularyTerm(
        code="DFG_6790_5",
        label="6790 Sound recording on film",
        description="""Sound recording on film//Tonaufzeichnung auf Film""",
    )

    dfg_6790_6 = VocabularyTerm(
        code="DFG_6790_6",
        label="6790 Recording studio accessories",
        description="""Recording studio accessories//Tonstudiozubehör""",
    )

    dfg_6800_1 = VocabularyTerm(
        code="DFG_6800_1",
        label="6800 Load resistors",
        description="""Load resistors//Belastungswiderstände""",
    )

    dfg_6800_2 = VocabularyTerm(
        code="DFG_6800_2",
        label="6800 Diode attenuators (PIN diode)",
        description="""Diode attenuators (PIN diode)//Dioden-Abschwächer, (PIN-Dioden-)""",
    )

    dfg_6800_3 = VocabularyTerm(
        code="DFG_6800_3",
        label="6800 Measuring resistors",
        description="""Measuring resistors//Messwiderstände""",
    )

    dfg_6800_4 = VocabularyTerm(
        code="DFG_6800_4",
        label="6800 Rheostats",
        description="""Rheostats//Rheostate""",
    )

    dfg_6800_5 = VocabularyTerm(
        code="DFG_6800_5",
        label="6800 Voltage dividers (except measuring bridges and compensators 6450)",
        description="""Voltage dividers (except measuring bridges and compensators 6450)//Spannungsteiler (außer Messbrücken und Kompensatoren 6450)""",
    )

    dfg_6800_6 = VocabularyTerm(
        code="DFG_6800_6",
        label="6800 Stpsel rheostats",
        description="""Stpsel rheostats//Stöpsel-Rheostaten""",
    )

    dfg_6800_7 = VocabularyTerm(
        code="DFG_6800_7",
        label="6800 Coil potentiometers",
        description="""Coil potentiometers//Wendelpotenziometer""",
    )

    dfg_6800_8 = VocabularyTerm(
        code="DFG_6800_8",
        label="6800 Resistors, potentiometers",
        description="""Resistors, potentiometers//Widerstände, Potenziometer""",
    )

    dfg_6800_9 = VocabularyTerm(
        code="DFG_6800_9",
        label="6800 Resistance decades",
        description="""Resistance decades//Widerstands-Dekaden""",
    )

    dfg_6810_1 = VocabularyTerm(
        code="DFG_6810_1",
        label="6810 Rotary capacitors",
        description="""Rotary capacitors//Drehkondensatoren""",
    )

    dfg_6810_2 = VocabularyTerm(
        code="DFG_6810_2",
        label="6810 Capacitance decades",
        description="""Capacitance decades//Kapazitäts-Dekaden""",
    )

    dfg_6810_3 = VocabularyTerm(
        code="DFG_6810_3",
        label="6810 Capacitance standards",
        description="""Capacitance standards//Kapazitäts-Normale""",
    )

    dfg_6810_4 = VocabularyTerm(
        code="DFG_6810_4",
        label="6810 Capacitor decades",
        description="""Capacitor decades//Kondensator-Dekaden""",
    )

    dfg_6810_5 = VocabularyTerm(
        code="DFG_6810_5",
        label="6810 Capacitors (tuning and measuring capacitors)",
        description="""Capacitors (tuning and measuring capacitors)//Kondensatoren (Abstimm- und Messkondensatoren)""",
    )

    dfg_6820_1 = VocabularyTerm(
        code="DFG_6820_1",
        label="6820 Chokes (for electronics)",
        description="""Chokes (for electronics)//Drosselspulen (für Elektronik)""",
    )

    dfg_6820_2 = VocabularyTerm(
        code="DFG_6820_2",
        label="6820 Faraday coils",
        description="""Faraday coils//Faradayspulen""",
    )

    dfg_6820_3 = VocabularyTerm(
        code="DFG_6820_3",
        label="6820 Inductors, transformers (bertrager)",
        description="""Inductors, transformers (bertrager)//Induktivitäten, Transformatoren (Übertrager)""",
    )

    dfg_6820_4 = VocabularyTerm(
        code="DFG_6820_4",
        label="6820 Inductance standards",
        description="""Inductance standards//Induktivitätsnormale""",
    )

    dfg_6820_5 = VocabularyTerm(
        code="DFG_6820_5",
        label="6820 Insulating transformers",
        description="""Insulating transformers//Isoliertransformatoren""",
    )

    dfg_6820_6 = VocabularyTerm(
        code="DFG_6820_6",
        label="6820 Mains transformers",
        description="""Mains transformers//Netztransformatoren""",
    )

    dfg_6820_7 = VocabularyTerm(
        code="DFG_6820_7",
        label="6820 Protection transformers",
        description="""Protection transformers//Schutztransformatoren""",
    )

    dfg_6820_8 = VocabularyTerm(
        code="DFG_6820_8",
        label="6820 Oscillating circuit coils",
        description="""Oscillating circuit coils//Schwingkreisspulen""",
    )

    dfg_6820_9 = VocabularyTerm(
        code="DFG_6820_9",
        label="6820 Isolating transformers",
        description="""Isolating transformers//Trenntransformatoren""",
    )

    dfg_6820_10 = VocabularyTerm(
        code="DFG_6820_10",
        label="6820 bertrager (transformers)",
        description="""bertrager (transformers)//Übertrager (Transformatoren)""",
    )

    dfg_6830_1 = VocabularyTerm(
        code="DFG_6830_1",
        label="6830 Coding switches",
        description="""Coding switches//Codier-Schalter""",
    )

    dfg_6830_2 = VocabularyTerm(
        code="DFG_6830_2",
        label="6830 Diode switches (PIN diode)",
        description="""Diode switches (PIN diode)//Dioden-Schalter (PIN-Dioden-)""",
    )

    dfg_6830_3 = VocabularyTerm(
        code="DFG_6830_3",
        label="6830 Fault voltage and current tripping devices",
        description="""Fault voltage and current tripping devices//Fehlerspannungs-, -stromauslöser""",
    )

    dfg_6830_4 = VocabularyTerm(
        code="DFG_6830_4",
        label="6830 Programme switches",
        description="""Programme switches//Programmschaltwerke""",
    )

    dfg_6830_5 = VocabularyTerm(
        code="DFG_6830_5",
        label="6830 Reed relays, contacts",
        description="""Reed relays, contacts//Reed-Relais, -Kontakte""",
    )

    dfg_6830_6 = VocabularyTerm(
        code="DFG_6830_6",
        label="6830 Switches, solenoids, relays, fuses",
        description="""Switches, solenoids, relays, fuses//Schalter, Magnete, Relais, Sicherungen""",
    )

    dfg_6830_7 = VocabularyTerm(
        code="DFG_6830_7",
        label="6830 Switchgear",
        description="""Switchgear//Schaltschütze""",
    )

    dfg_6830_8 = VocabularyTerm(
        code="DFG_6830_8",
        label="6830 Tap changers",
        description="""Tap changers//Stufenschalter""",
    )

    dfg_6830_9 = VocabularyTerm(
        code="DFG_6830_9",
        label="6830 Trigger solenoids",
        description="""Trigger solenoids//Türöffnermagnete""",
    )

    dfg_6830_10 = VocabularyTerm(
        code="DFG_6830_10",
        label="6830 Overcurrent self-triggering devices (except 2650)",
        description="""Overcurrent self-triggering devices (except 2650)//Überstrom-Selbstauslöser (außer 2650)""",
    )

    dfg_6840_1 = VocabularyTerm(
        code="DFG_6840_1",
        label="6840 Picture tubes",
        description="""Picture tubes//Bildröhren""",
    )

    dfg_6840_2 = VocabularyTerm(
        code="DFG_6840_2",
        label="6840 Picture memory tubes",
        description="""Picture memory tubes//Bildspeicherröhren""",
    )

    dfg_6840_3 = VocabularyTerm(
        code="DFG_6840_3",
        label="6840 Image Intensifier Silicon Vidicon SIT, ISIT)",
        description="""Image Intensifier Silicon Vidicon SIT, ISIT)//Bildverstärker-Silizium-Vidicon SIT, ISIT)""",
    )

    dfg_6840_4 = VocabularyTerm(
        code="DFG_6840_4",
        label="6840 Image converter tubes",
        description="""Image converter tubes//Bildwandlerröhren""",
    )

    dfg_6840_5 = VocabularyTerm(
        code="DFG_6840_5",
        label="6840 Brownian tubes",
        description="""Brownian tubes//Braunsche Röhren""",
    )

    dfg_6840_6 = VocabularyTerm(
        code="DFG_6840_6",
        label="6840 BWO (Backward Wave Oscillators)",
        description="""BWO (Backward Wave Oscillators)//BWO (Backward Wave Oszillatoren)""",
    )

    dfg_6840_7 = VocabularyTerm(
        code="DFG_6840_7",
        label="6840 Carcinotrons",
        description="""Carcinotrons//Carcinotrons""",
    )

    dfg_6840_8 = VocabularyTerm(
        code="DFG_6840_8",
        label="6840 Electron tubes, microwave generator tubes",
        description="""Electron tubes, microwave generator tubes//Elektronenröhren, Mikrowellen-Generatorröhren""",
    )

    dfg_6840_9 = VocabularyTerm(
        code="DFG_6840_9",
        label="6840 Electron beam tubes",
        description="""Electron beam tubes//Elektronenstrahl-Röhren""",
    )

    dfg_6840_10 = VocabularyTerm(
        code="DFG_6840_10",
        label="6840 Television recording tubes (Vidicon, Plumbicon)",
        description="""Television recording tubes (Vidicon, Plumbicon)//Fernseh-Aufnahme-Röhren (Vidicon, Plumbicon)""",
    )

    dfg_6840_11 = VocabularyTerm(
        code="DFG_6840_11",
        label="6840 Pulse magnetrons",
        description="""Pulse magnetrons//Impulsmagnetrons""",
    )

    dfg_6840_12 = VocabularyTerm(
        code="DFG_6840_12",
        label="6840 ISIT tubes",
        description="""ISIT tubes//ISIT-Röhren""",
    )

    dfg_6840_13 = VocabularyTerm(
        code="DFG_6840_13",
        label="6840 Klystrons",
        description="""Klystrons//Klystrons""",
    )

    dfg_6840_14 = VocabularyTerm(
        code="DFG_6840_14",
        label="6840 Magnetrons",
        description="""Magnetrons//Magnetrons""",
    )

    dfg_6840_15 = VocabularyTerm(
        code="DFG_6840_15",
        label="6840 Multi-chamber klystrons",
        description="""Multi-chamber klystrons//Mehrkammer-Klystrons""",
    )

    dfg_6840_16 = VocabularyTerm(
        code="DFG_6840_16",
        label="6840 Oscilloscope and oscilloscope tubes",
        description="""Oscilloscope and oscilloscope tubes//Oszillographen-, Oszilloskop-Röhren""",
    )

    dfg_6840_17 = VocabularyTerm(
        code="DFG_6840_17",
        label="6840 Reflex klystrons",
        description="""Reflex klystrons//Reflexklystrons""",
    )

    dfg_6840_18 = VocabularyTerm(
        code="DFG_6840_18",
        label="6840 Backwave oscillators",
        description="""Backwave oscillators//Rückwärtswellen-Oszillatoren""",
    )

    dfg_6840_19 = VocabularyTerm(
        code="DFG_6840_19",
        label="6840 Transmitter tubes",
        description="""Transmitter tubes//Senderöhren""",
    )

    dfg_6840_20 = VocabularyTerm(
        code="DFG_6840_20",
        label="6840 SIT-tubes",
        description="""SIT-tubes//SIT-Röhren""",
    )

    dfg_6840_21 = VocabularyTerm(
        code="DFG_6840_21",
        label="6840 Special tubes",
        description="""Special tubes//Spezialröhren""",
    )

    dfg_6840_22 = VocabularyTerm(
        code="DFG_6840_22",
        label="6840 Thyratron tubes",
        description="""Thyratron tubes//Thyratron-Röhren""",
    )

    dfg_6850_1 = VocabularyTerm(
        code="DFG_6850_1",
        label="6850 Diodes (except photodiodes 5800)",
        description="""Diodes (except photodiodes 5800)//Dioden (außer Photo-Dioden 5800)""",
    )

    dfg_6850_2 = VocabularyTerm(
        code="DFG_6850_2",
        label="6850 Semiconductor devices and integrated circuits",
        description="""Semiconductor devices and integrated circuits//Halbleiter-Bausteine und integrierte Schaltungen""",
    )

    dfg_6850_3 = VocabularyTerm(
        code="DFG_6850_3",
        label="6850 Transistors",
        description="""Transistors//Transistoren""",
    )

    dfg_6860_1 = VocabularyTerm(
        code="DFG_6860_1",
        label="6860 Terminators (Microwave)",
        description="""Terminators (Microwave)//Abschlusswiderstände (Mikrowellen-)""",
    )

    dfg_6860_2 = VocabularyTerm(
        code="DFG_6860_2",
        label="6860 Balanced Mixers",
        description="""Balanced Mixers//Balanced Mixer""",
    )

    dfg_6860_3 = VocabularyTerm(
        code="DFG_6860_3",
        label="6860 Attenuators (microwave)",
        description="""Attenuators (microwave)//Dämpfungsglieder (Mikrowellen)""",
    )

    dfg_6860_4 = VocabularyTerm(
        code="DFG_6860_4",
        label="6860 One-way waveguides (non-reciprocal)",
        description="""One-way waveguides (non-reciprocal)//Einweghohlleiter (nicht reziproke Leiter)""",
    )

    dfg_6860_5 = VocabularyTerm(
        code="DFG_6860_5",
        label="6860 Ferrite insulators (non-reciprocal conductors)",
        description="""Ferrite insulators (non-reciprocal conductors)//Ferrit-Isolatoren (nicht reziproke Leiter)""",
    )

    dfg_6860_6 = VocabularyTerm(
        code="DFG_6860_6",
        label="6860 Ferrite modulators",
        description="""Ferrite modulators//Ferritmodulatoren""",
    )

    dfg_6860_7 = VocabularyTerm(
        code="DFG_6860_7",
        label="6860 Waveguides, waveguide components",
        description="""Waveguides, waveguide components//Hohlleiter, Hohlleiter-Bauelemente""",
    )

    dfg_6860_8 = VocabularyTerm(
        code="DFG_6860_8",
        label="6860 Waveguide switches",
        description="""Waveguide switches//Hohlleiterschalter""",
    )

    dfg_6860_9 = VocabularyTerm(
        code="DFG_6860_9",
        label="6860 Horn antennas, horn radiators (except radar 6670)",
        description="""Horn antennas, horn radiators (except radar 6670)//Hornantennen, Hornstrahler (außer Radar 6670)""",
    )

    dfg_6860_10 = VocabularyTerm(
        code="DFG_6860_10",
        label="6860 Impedance converters (for microwaves)",
        description="""Impedance converters (for microwaves)//Impedanzwandler (für Mikrowellen)""",
    )

    dfg_6860_11 = VocabularyTerm(
        code="DFG_6860_11",
        label="6860 Insulators (non-reciprocal conductors)",
        description="""Insulators (non-reciprocal conductors)//Isolatoren (nicht reziproke Leiter)""",
    )

    dfg_6860_12 = VocabularyTerm(
        code="DFG_6860_12",
        label="6860 Coaxial components",
        description="""Coaxial components//Koaxiale Bauelemente""",
    )

    dfg_6860_13 = VocabularyTerm(
        code="DFG_6860_13",
        label="6860 Microwave components",
        description="""Microwave components//Mikrowellen-Bauelemente""",
    )

    dfg_6860_14 = VocabularyTerm(
        code="DFG_6860_14",
        label="6860 Reactance lines, short-circuit lines for microwaves",
        description="""Reactance lines, short-circuit lines for microwaves//Reaktanz-Leitungen, Kurzschluss-Leitungen für Mikrowellen""",
    )

    dfg_6860_15 = VocabularyTerm(
        code="DFG_6860_15",
        label="6860 Directional couplers",
        description="""Directional couplers//Richtkoppler""",
    )

    dfg_6860_16 = VocabularyTerm(
        code="DFG_6860_16",
        label="6860 Stripline conductors (microwave technology)",
        description="""Stripline conductors (microwave technology)//Streifenleiter (Mikrowellentechnik)""",
    )

    dfg_6860_17 = VocabularyTerm(
        code="DFG_6860_17",
        label="6860 Waveguides (high-frequency technology)",
        description="""Waveguides (high-frequency technology)//Wellenleiter (Hochfrequenztechnik)""",
    )

    dfg_6860_18 = VocabularyTerm(
        code="DFG_6860_18",
        label="6860 Waveguides, terminators for microwaves",
        description="""Waveguides, terminators for microwaves//Wellensümpfe, Abschlusswiderstände für Mikrowellen""",
    )

    dfg_6860_19 = VocabularyTerm(
        code="DFG_6860_19",
        label="6860 Circulators",
        description="""Circulators//Zirkulatoren""",
    )

    dfg_6870_1 = VocabularyTerm(
        code="DFG_6870_1",
        label="6870 Bin & Power Supply, frame with power supply (CAMAC)",
        description="""Bin & Power Supply, frame with power supply (CAMAC)//Bin & Power Supply, Überrahmen mit Netzteil (CAMAC)""",
    )

    dfg_6870_2 = VocabularyTerm(
        code="DFG_6870_2",
        label="6870 CAMAC-Crate, -Power Supply Crate, -overframe",
        description="""CAMAC-Crate, -Power Supply Crate, -overframe//CAMAC-Crate, -Power Supply Crate, -Überrahmen""",
    )

    dfg_6870_3 = VocabularyTerm(
        code="DFG_6870_3",
        label="6870 Housings, racks",
        description="""Housings, racks//Gehäuse, Racks""",
    )

    dfg_6870_4 = VocabularyTerm(
        code="DFG_6870_4",
        label="6870 NIM-frame (with power supply)",
        description="""NIM-frame (with power supply)//NIM-Überrahmen (mit Netzteil)""",
    )

    dfg_6870_5 = VocabularyTerm(
        code="DFG_6870_5",
        label="6870 Racks for electronic components",
        description="""Racks for electronic components//Racks für elektronische Bauelemente""",
    )

    dfg_6880_1 = VocabularyTerm(
        code="DFG_6880_1",
        label="6880 Rotary transducers (without slip rings, mercury contacts) for measured value transmission",
        description="""Rotary transducers (without slip rings, mercury contacts) for measured value transmission//Drehübertrager (schleifringlos, Quecksilber-Kontakte) für Messwertübertragung""",
    )

    dfg_6880_2 = VocabularyTerm(
        code="DFG_6880_2",
        label="6880 Connecting elements, plug-in devices, slip rings",
        description="""Connecting elements, plug-in devices, slip rings//Verbindungselemente, Steckvorrichtungen, Schleifringe""",
    )

    dfg_6890_1 = VocabularyTerm(
        code="DFG_6890_1",
        label="6890 Other electrical and electronic components",
        description="""Other electrical and electronic components//Sonstige elektrische und elektronische Bauelemente""",
    )

    dfg_6900_1 = VocabularyTerm(
        code="DFG_6900_1",
        label="6900 Electrical and mechanical control systems",
        description="""Electrical and mechanical control systems//Elektrische und mechanische Regelsysteme""",
    )

    dfg_6910_1 = VocabularyTerm(
        code="DFG_6910_1",
        label="6910 Pneumatic and other control systems (except 6900)",
        description="""Pneumatic and other control systems (except 6900)//Pneumatische und andere Regelsysteme (außer 6900)""",
    )

    dfg_6920_1 = VocabularyTerm(
        code="DFG_6920_1",
        label="6920 Electromechanical counters and movements",
        description="""Electromechanical counters and movements//Elektromechanische Zähler, Zählwerke""",
    )

    dfg_6920_2 = VocabularyTerm(
        code="DFG_6920_2",
        label="6920 Mechanical counters, plug counters",
        description="""Mechanical counters, plug counters//Mechanische Zähler, Stückzähler""",
    )

    dfg_6920_3 = VocabularyTerm(
        code="DFG_6920_3",
        label="6920 Mechanical, pneumatic and hydraulic counters and recorders",
        description="""Mechanical, pneumatic and hydraulic counters and recorders//Mechanische, pneumatische und hydraulische Zähl- und Registriergeräte""",
    )

    dfg_6930_1 = VocabularyTerm(
        code="DFG_6930_1",
        label="6930 CNC (Computerised Numerical Control) controls for machines",
        description="""CNC (Computerised Numerical Control) controls for machines//CNC-Steuerungen (Computerized Numerical Control) für Maschinen""",
    )

    dfg_6930_2 = VocabularyTerm(
        code="DFG_6930_2",
        label="6930 Electrical control equipment and installations",
        description="""Electrical control equipment and installations//Elektrische Steuergeräte und Anlagen""",
    )

    dfg_6930_3 = VocabularyTerm(
        code="DFG_6930_3",
        label="6930 NC controls for machines (numerical control)",
        description="""NC controls for machines (numerical control)//NC-Steuerungen für Maschinen (Numerical Control)""",
    )

    dfg_6930_4 = VocabularyTerm(
        code="DFG_6930_4",
        label="6930 Program generators (cam disc)",
        description="""Program generators (cam disc)//Programmgeber (Kurvenscheiben-)""",
    )

    dfg_6930_5 = VocabularyTerm(
        code="DFG_6930_5",
        label="6930 Program control units",
        description="""Program control units//Programmsteuerwerke""",
    )

    dfg_6930_6 = VocabularyTerm(
        code="DFG_6930_6",
        label="6930 Stepping motor controls",
        description="""Stepping motor controls//Schrittmotoransteuerungen""",
    )

    dfg_6940_1 = VocabularyTerm(
        code="DFG_6940_1",
        label="6940 Electropneumatic positioners, signal formers",
        description="""Electropneumatic positioners, signal formers//Elektropneumatische Stellungsregler, Signalformer""",
    )

    dfg_6940_2 = VocabularyTerm(
        code="DFG_6940_2",
        label="6940 Pneumatic controllers and test equipment",
        description="""Pneumatic controllers and test equipment//Pneumatische Steuergeräte und Versuchsanlagen""",
    )

    dfg_6940_3 = VocabularyTerm(
        code="DFG_6940_3",
        label="6940 Signal formers, electropneumatic",
        description="""Signal formers, electropneumatic//Signalformer, elektropneumatisch""",
    )

    dfg_6940_4 = VocabularyTerm(
        code="DFG_6940_4",
        label="6940 Positioners, electropneumatic",
        description="""Positioners, electropneumatic//Stellungsregler, elektropneumatisch""",
    )

    dfg_6950_1 = VocabularyTerm(
        code="DFG_6950_1",
        label="6950 Hydraulic control units",
        description="""Hydraulic control units//Hydraulik-Steuerungen""",
    )

    dfg_6950_2 = VocabularyTerm(
        code="DFG_6950_2",
        label="6950 Hydraulic control units and test systems",
        description="""Hydraulic control units and test systems//Hydraulische Steuergeräte und Versuchsanlagen""",
    )

    dfg_6960_1 = VocabularyTerm(
        code="DFG_6960_1",
        label="6960 Telemetering and telecontrol systems (except for medicine/biology 3480), control stations",
        description="""Telemetering and telecontrol systems (except for medicine/biology 3480), control stations//Fernmess- und Fernwirksysteme (außer für Medizin/Biologie 3480), Leitstände""",
    )

    dfg_6960_2 = VocabularyTerm(
        code="DFG_6960_2",
        label="6960 Control stations for measuring and test installations, traffic",
        description="""Control stations for measuring and test installations, traffic//Leitstände für Mess- und Versuchsanlagen, Verkehr""",
    )

    dfg_6960_3 = VocabularyTerm(
        code="DFG_6960_3",
        label="6960 Control rooms for power stations, process engineering",
        description="""Control rooms for power stations, process engineering//Warten für Kraftwerke, Verfahrenstechnik""",
    )

    dfg_6970_1 = VocabularyTerm(
        code="DFG_6970_1",
        label="6970 Proximity switches",
        description="""Proximity switches//Annäherungsschalter""",
    )

    dfg_6970_2 = VocabularyTerm(
        code="DFG_6970_2",
        label="6970 Display elements (liquid-crystal, laser-diode, plasma)",
        description="""Display elements (liquid-crystal, laser-diode, plasma)//Anzeigeelemente (Flüssigkristall-, Laserdioden-, Plasma-)""",
    )

    dfg_6970_3 = VocabularyTerm(
        code="DFG_6970_3",
        label="6970 Components and assemblies for telemetry, telecontrol and control systems",
        description="""Components and assemblies for telemetry, telecontrol and control systems//Bauelemente und Baugruppen für Fernmess-, Fernwirk- und Steuer-Systeme""",
    )

    dfg_6970_4 = VocabularyTerm(
        code="DFG_6970_4",
        label="6970 Displays, numeric and alphanumeric displays (except data protection 7200 for EDP)",
        description="""Displays, numeric and alphanumeric displays (except data protection 7200 for EDP)//Displays, Ziffern- und alphanumerische Displays (außer Datensichtgeräte 7200 für EDV)""",
    )

    dfg_6970_5 = VocabularyTerm(
        code="DFG_6970_5",
        label="6970 Electro-optical sensors (detection, shape recognition, except 8710)",
        description="""Electro-optical sensors (detection, shape recognition, except 8710)//Elektrooptische Sensoren (Annäherung, Formerkennung, außer 8710)""",
    )

    dfg_6970_6 = VocabularyTerm(
        code="DFG_6970_6",
        label="6970 Electro-optical isolators for telemetry systems",
        description="""Electro-optical isolators for telemetry systems//Elektrooptische Trennverstärker für Fernmesssysteme""",
    )

    dfg_6970_7 = VocabularyTerm(
        code="DFG_6970_7",
        label="6970 Television sensors for shape, position detection (except image analysers 7430)",
        description="""Television sensors for shape, position detection (except image analysers 7430)//Fernseh-Sensoren für Form-, Positionsprüfung (außer Bildanalysegeräte 7430)""",
    )

    dfg_6970_8 = VocabularyTerm(
        code="DFG_6970_8",
        label="6970 Remote control transmitters, receivers",
        description="""Remote control transmitters, receivers//Fernsteuersender, -Empfänger""",
    )

    dfg_6970_9 = VocabularyTerm(
        code="DFG_6970_9",
        label="6970 Liquid crystal displays (LCD)",
        description="""Liquid crystal displays (LCD)//Flüssigkristall-Anzeigen (LCD)""",
    )

    dfg_6970_10 = VocabularyTerm(
        code="DFG_6970_10",
        label="6970 Limit switches",
        description="""Limit switches//Grenzschalter""",
    )

    dfg_6970_11 = VocabularyTerm(
        code="DFG_6970_11",
        label="6970 Compensation indicators",
        description="""Compensation indicators//Kompensations-Anzeiger""",
    )

    dfg_6970_12 = VocabularyTerm(
        code="DFG_6970_12",
        label="6970 Laser diodes (LED) for measured value display",
        description="""Laser diodes (LED) for measured value display//Laserdioden (LED) für Messwertanzeige""",
    )

    dfg_6970_13 = VocabularyTerm(
        code="DFG_6970_13",
        label="6970 Luminous displays",
        description="""Luminous displays//Leuchtanzeigen""",
    )

    dfg_6970_14 = VocabularyTerm(
        code="DFG_6970_14",
        label="6970 Luminescent diode indicators",
        description="""Luminescent diode indicators//Lumineszenz-Dioden-Anzeigen""",
    )

    dfg_6970_15 = VocabularyTerm(
        code="DFG_6970_15",
        label="6970 Mechanical and electrical indicators",
        description="""Mechanical and electrical indicators//Mechanische und elektrische Messwertanzeigegeräte""",
    )

    dfg_6970_16 = VocabularyTerm(
        code="DFG_6970_16",
        label="6970 Mechanical and electrical measured value display units",
        description="""Mechanical and electrical measured value display units//Messwertanzeigegeräte, mechanisch, elektrisch""",
    )

    dfg_6970_17 = VocabularyTerm(
        code="DFG_6970_17",
        label="6970 Sensors (approach, shape recognition)",
        description="""Sensors (approach, shape recognition)//Sensoren (Annäherung, Formerkennung)""",
    )

    dfg_6970_18 = VocabularyTerm(
        code="DFG_6970_18",
        label="6970 Actuators, servo drives, servo actuators",
        description="""Actuators, servo drives, servo actuators//Stellglieder, Stellantriebe, Servoantriebe""",
    )

    dfg_6970_19 = VocabularyTerm(
        code="DFG_6970_19",
        label="6970 Telemetry transmitters and receivers (except medicine 3480)",
        description="""Telemetry transmitters and receivers (except medicine 3480)//Telemetriesender, -empfänger (außer Medizin 3480)""",
    )

    dfg_6970_20 = VocabularyTerm(
        code="DFG_6970_20",
        label="6970 Ultrasonic remote control units",
        description="""Ultrasonic remote control units//Ultraschall-Fernsteuergeräte""",
    )

    dfg_6970_21 = VocabularyTerm(
        code="DFG_6970_21",
        label="6970 Numerical display units, displays (CAMAC)",
        description="""Numerical display units, displays (CAMAC)//Ziffernanzeige-Einheiten, Displays (CAMAC)""",
    )

    dfg_6980_1 = VocabularyTerm(
        code="DFG_6980_1",
        label="6980 Mechanical and electrical measurement display units",
        description="""Mechanical and electrical measurement display units//Mechanische und elektrische Messwertanzeigegeräte""",
    )

    dfg_6980_2 = VocabularyTerm(
        code="DFG_6980_2",
        label="6980 Panels for signalling, call, control and traffic installations",
        description="""Panels for signalling, call, control and traffic installations//Tableaus für Melde-, Ruf-, Steuer- und Verkehrsanlagen""",
    )

    dfg_6980_3 = VocabularyTerm(
        code="DFG_6980_3",
        label="6980 Character generators (alpha-numeric) for displays",
        description="""Character generators (alpha-numeric) for displays//Zeichengeneratoren (alpha-numerisch) für Displays""",
    )

    dfg_6990_1 = VocabularyTerm(
        code="DFG_6990_1",
        label="6990 Fluidic elements and systems",
        description="""Fluidic elements and systems//Fluidik-Elemente und -Anlagen""",
    )

    dfg_6990_2 = VocabularyTerm(
        code="DFG_6990_2",
        label="6990 Other control systems and control devices",
        description="""Other control systems and control devices//Sonstige Regelsysteme und Steuergeräte""",
    )

    dfg_7000_1 = VocabularyTerm(
        code="DFG_7000_1",
        label="7000 Central computer systems: Computer centres (except storage)",
        description="""Central computer systems: Computer centres (except storage)//Zentrale Rechenanlagen: Rechenzentren (außer Storage)""",
    )

    dfg_7000_2 = VocabularyTerm(
        code="DFG_7000_2",
        label="7000 Central computer systems: computer centres (focus on storage)",
        description="""Central computer systems: computer centres (focus on storage)//Zentrale Rechenanlagen: Rechenzentren (Schwerpunkt Storage)""",
    )

    dfg_7000_3 = VocabularyTerm(
        code="DFG_7000_3",
        label="7000 Medical administration (HIS / KAS)",
        description="""Medical administration (HIS / KAS)//Medizinische Verwaltung (KIS / KAS)""",
    )

    dfg_7000_4 = VocabularyTerm(
        code="DFG_7000_4",
        label="7000 Libraries, administration",
        description="""Libraries, administration//Bibliotheken, Verwaltung""",
    )

    dfg_7010_1 = VocabularyTerm(
        code="DFG_7010_1",
        label="7010 RJE stations (remote job entry)",
        description="""RJE stations (remote job entry)//RJE-Stationen (Remote-Job-Entry-)""",
    )

    dfg_7010_2 = VocabularyTerm(
        code="DFG_7010_2",
        label="7010 Satellite computers, remote data stations",
        description="""Satellite computers, remote data stations//Satellitenrechner, Datenfernstationen""",
    )

    dfg_7030_1 = VocabularyTerm(
        code="DFG_7030_1",
        label="703  / 760 Dedicated computers, biology, analogue hybrid computer system",
        description="""/ 760 Dedicated computers, biology, analogue hybrid computer system//Dedizierte Rechner, Biologie, Analog-Hybrid-Rechenanlage""",
    )

    dfg_7030_2 = VocabularyTerm(
        code="DFG_7030_2",
        label="703  / 760 Dedicated computers, chemistry, analogue hybrid computer system",
        description="""/ 760 Dedicated computers, chemistry, analogue hybrid computer system//Dedizierte Rechner, Chemie, Analog-Hybrid-Rechenanlage""",
    )

    dfg_7030_3 = VocabularyTerm(
        code="DFG_7030_3",
        label="703  / 760 Dedicated computers, humanities, analogue hybrid computer system",
        description="""/ 760 Dedicated computers, humanities, analogue hybrid computer system//Dedizierte Rechner, Geisteswissenschaften, Analog-Hybrid-Rechenanlage""",
    )

    dfg_7030_4 = VocabularyTerm(
        code="DFG_7030_4",
        label="703  / 760 Dedicated computers, earth sciences, analogue hybrid computer system",
        description="""/ 760 Dedicated computers, earth sciences, analogue hybrid computer system//Dedizierte Rechner, Geowissenschaften, Analog-Hybrid-Rechenanlage""",
    )

    dfg_7030_5 = VocabularyTerm(
        code="DFG_7030_5",
        label="703  / 760 Dedicated computers, computer science, analogue hybrid computer system",
        description="""/ 760 Dedicated computers, computer science, analogue hybrid computer system//Dedizierte Rechner, Informatik, Analog-Hybrid-Rechenanlage""",
    )

    dfg_7030_6 = VocabularyTerm(
        code="DFG_7030_6",
        label="703  / 760 Dedicated computers, engineering sciences, analogue hybrid computer system",
        description="""/ 760 Dedicated computers, engineering sciences, analogue hybrid computer system//Dedizierte Rechner, Ingenieurwissenschaften, Analog-Hybrid-Rechenanlage""",
    )

    dfg_7030_7 = VocabularyTerm(
        code="DFG_7030_7",
        label="703  / 760 Dedicated computers, mathematics, analogue hybrid computer system",
        description="""/ 760 Dedicated computers, mathematics, analogue hybrid computer system//Dedizierte Rechner, Mathematik, Analog-Hybrid-Rechenanlage""",
    )

    dfg_7030_8 = VocabularyTerm(
        code="DFG_7030_8",
        label="703  / 760 Dedicated computers, medicine, analogue hybrid computer system",
        description="""/ 760 Dedicated computers, medicine, analogue hybrid computer system//Dedizierte Rechner, Medizin, Analog-Hybrid-Rechenanlage""",
    )

    dfg_7030_9 = VocabularyTerm(
        code="DFG_7030_9",
        label="703  / 760 Dedicated computers, physics, analogue hybrid computer system",
        description="""/ 760 Dedicated computers, physics, analogue hybrid computer system//Dedizierte Rechner, Physik, Analog-Hybrid-Rechenanlage""",
    )

    dfg_7031_1 = VocabularyTerm(
        code="DFG_7031_1",
        label="7031 Laboratory EDP systems",
        description="""Laboratory EDP systems//Labor-EDV-Systeme""",
    )

    dfg_7032_1 = VocabularyTerm(
        code="DFG_7032_1",
        label="7032 Patient data management systems (PDMS)",
        description="""Patient data management systems (PDMS)//Patienten-Datenmanagement-Systeme (PDMS)""",
    )

    dfg_7032_2 = VocabularyTerm(
        code="DFG_7032_2",
        label="7032 Anthesiology documentation systems",
        description="""Anthesiology documentation systems//Anäthesiologie-Dokumentationssysteme""",
    )

    dfg_7032_3 = VocabularyTerm(
        code="DFG_7032_3",
        label="7032 Intensive care documentation systems",
        description="""Intensive care documentation systems//Intensivmedizinische Dokumentationssysteme""",
    )

    dfg_7040_1 = VocabularyTerm(
        code="DFG_7040_1",
        label="7040 Vector, parallel computer system, high-performance computing (HPC)",
        description="""Vector, parallel computer system, high-performance computing (HPC)//Vektor-, Parallel-Rechner System, High-Performance-Computing (HPC)""",
    )

    dfg_7050_1 = VocabularyTerm(
        code="DFG_7050_1",
        label="7050 Radiological Information Systems, Image Archives, Nuclear Medicine",
        description="""Radiological Information Systems, Image Archives, Nuclear Medicine//Radiologische Informationssysteme, Bildarchive, Nuklearmedizin""",
    )

    dfg_7070_1 = VocabularyTerm(
        code="DFG_7070_1",
        label="7070 WAP clusters",
        description="""WAP clusters//WAP-Cluster""",
    )

    dfg_7080_1 = VocabularyTerm(
        code="DFG_7080_1",
        label="7080 Floating-point, floating-point computing units, states",
        description="""Floating-point, floating-point computing units, states//Gleitkomma-, Floating Point-Recheneinheiten, -Zusätze""",
    )

    dfg_7080_2 = VocabularyTerm(
        code="DFG_7080_2",
        label="7080 Transputer units",
        description="""Transputer units//Transputer-Einheiten""",
    )

    dfg_7080_3 = VocabularyTerm(
        code="DFG_7080_3",
        label="7080 Central assemblies for computer systems (except 710-749)",
        description="""Central assemblies for computer systems (except 710-749)//Zentrale Baugruppen für EDV-Anlagen (außer 710-749)""",
    )

    dfg_7100_1 = VocabularyTerm(
        code="DFG_7100_1",
        label="7100 Main memory, RAM",
        description="""Main memory, RAM//Arbeitsspeicher, RAM""",
    )

    dfg_7100_2 = VocabularyTerm(
        code="DFG_7100_2",
        label="7100 Semiconductor memory (except ROM 711)",
        description="""Semiconductor memory (except ROM 711)//Halbleiterspeicher (außer Festspeicher, ROM 711)""",
    )

    dfg_7100_3 = VocabularyTerm(
        code="DFG_7100_3",
        label="7100 Main memory units (for EDP)",
        description="""Main memory units (for EDP)//Hauptspeichereinheiten (für EDV)""",
    )

    dfg_7100_4 = VocabularyTerm(
        code="DFG_7100_4",
        label="7100 Memory expansion",
        description="""Memory expansion//Memory Expansion""",
    )

    dfg_7100_5 = VocabularyTerm(
        code="DFG_7100_5",
        label="7100 Buffer memory (CAMAC)",
        description="""Buffer memory (CAMAC)//Pufferspeicher (CAMAC)""",
    )

    dfg_7100_6 = VocabularyTerm(
        code="DFG_7100_6",
        label="7100 RAM memory boards",
        description="""RAM memory boards//RAM-Speicherplatinen""",
    )

    dfg_7110_1 = VocabularyTerm(
        code="DFG_7110_1",
        label="7110 Read-only memory (for microprograms) ROM, PROM",
        description="""Read-only memory (for microprograms) ROM, PROM//Festspeicher (für Mikroprogramme) ROM, PROM""",
    )

    dfg_7110_2 = VocabularyTerm(
        code="DFG_7110_2",
        label="7110 Microprogramme memory",
        description="""Microprogramme memory//Mikroprogrammspeicher""",
    )

    dfg_7110_3 = VocabularyTerm(
        code="DFG_7110_3",
        label="7110 Parameter memory",
        description="""Parameter memory//Parameterspeicher""",
    )

    dfg_7110_4 = VocabularyTerm(
        code="DFG_7110_4",
        label="7110 Programmable logic, PLA (Programmable Logic Arrays)",
        description="""Programmable logic, PLA (Programmable Logic Arrays)//Programmierbare Logik, PLA (Programmable Logic Arrays)""",
    )

    dfg_7110_5 = VocabularyTerm(
        code="DFG_7110_5",
        label="7110 Program memory, microprogram memory",
        description="""Program memory, microprogram memory//Programmspeicher, Mikroprogrammspeicher""",
    )

    dfg_7110_6 = VocabularyTerm(
        code="DFG_7110_6",
        label="7110 PROM, Programmable Read Only Memory",
        description="""PROM, Programmable Read Only Memory//PROM, Programmable Read Only Memory""",
    )

    dfg_7110_7 = VocabularyTerm(
        code="DFG_7110_7",
        label="7110 ROM, Read Only Memory",
        description="""ROM, Read Only Memory//ROM, Read Only Memory""",
    )

    dfg_7120_1 = VocabularyTerm(
        code="DFG_7120_1",
        label="7120 CD recorders (EDP)",
        description="""CD recorders (EDP)//CD-Brenner (EDV)""",
    )

    dfg_7120_2 = VocabularyTerm(
        code="DFG_7120_2",
        label="7120 Optical memory units and control devices (EDP)",
        description="""Optical memory units and control devices (EDP)//Optische Speichereinheiten und Steuergeräte (EDV)""",
    )

    dfg_7120_3 = VocabularyTerm(
        code="DFG_7120_3",
        label="7120 Optical storage unit controllers (EDP)",
        description="""Optical storage unit controllers (EDP)//Steuergeräte für optische Speichereinheiten (EDV)""",
    )

    dfg_7130_1 = VocabularyTerm(
        code="DFG_7130_1",
        label="7130 Hard disk storage units",
        description="""Hard disk storage units//Festplattenspeichereinheiten""",
    )

    dfg_7130_2 = VocabularyTerm(
        code="DFG_7130_2",
        label="7130 Floppy disc units",
        description="""Floppy disc units//Floppy-Disc-Einheiten""",
    )

    dfg_7130_3 = VocabularyTerm(
        code="DFG_7130_3",
        label="7130 Magnetic disk drives",
        description="""Magnetic disk drives//Magnetplattenlaufwerke""",
    )

    dfg_7130_4 = VocabularyTerm(
        code="DFG_7130_4",
        label="7130 Mass storage devices (magnetic disk)",
        description="""Mass storage devices (magnetic disk)//Massenspeicher (Magnetplatten-)""",
    )

    dfg_7130_5 = VocabularyTerm(
        code="DFG_7130_5",
        label="7130 Disk storage units, removable disk storage units",
        description="""Disk storage units, removable disk storage units//Plattenspeicher, Wechselplattenspeicher""",
    )

    dfg_7130_6 = VocabularyTerm(
        code="DFG_7130_6",
        label="7130 Control units (magnetic disk)",
        description="""Control units (magnetic disk)//Steuereinheiten (Magnetplatten-)""",
    )

    dfg_7130_7 = VocabularyTerm(
        code="DFG_7130_7",
        label="7130 Removable disk storage and control units",
        description="""Removable disk storage and control units//Wechselplattenspeicher und -steuereinheiten""",
    )

    dfg_7130_8 = VocabularyTerm(
        code="DFG_7130_8",
        label="7130 Winchester disk systems",
        description="""Winchester disk systems//Winchester-Plattensysteme""",
    )

    dfg_7140_1 = VocabularyTerm(
        code="DFG_7140_1",
        label="7140 Digital cassette recorders",
        description="""Digital cassette recorders//Digital-Kassettenrecorder""",
    )

    dfg_7140_2 = VocabularyTerm(
        code="DFG_7140_2",
        label="7140 Magnetic tape recorders (digital)",
        description="""Magnetic tape recorders (digital)//Magnetbandgeräte (digitale)""",
    )

    dfg_7140_3 = VocabularyTerm(
        code="DFG_7140_3",
        label="7140 Magnetic tape cassette units (digital)",
        description="""Magnetic tape cassette units (digital)//Magnetbandkassetteneinheiten (digital)""",
    )

    dfg_7140_4 = VocabularyTerm(
        code="DFG_7140_4",
        label="7140 Magnetic tape storage units (digital)",
        description="""Magnetic tape storage units (digital)//Magnetbandspeichergeräte (digital)""",
    )

    dfg_7140_5 = VocabularyTerm(
        code="DFG_7140_5",
        label="7140 Magnetic tape control units",
        description="""Magnetic tape control units//Magnetbandsteuereinheiten""",
    )

    dfg_7150_1 = VocabularyTerm(
        code="DFG_7150_1",
        label="7150 Calibration and adjustment equipment for magnetic tape recorders",
        description="""Calibration and adjustment equipment for magnetic tape recorders//Eich- und Justiergeräte für Magnetbandgeräte""",
    )

    dfg_7150_2 = VocabularyTerm(
        code="DFG_7150_2",
        label="7150 Demagnetising chokes for magnetic tape recorders",
        description="""Demagnetising chokes for magnetic tape recorders//Entmagnetisierdrosseln für Magnetbandgeräte""",
    )

    dfg_7150_3 = VocabularyTerm(
        code="DFG_7150_3",
        label="7150 FM magnetic tape recorders",
        description="""FM magnetic tape recorders//FM-Magnetbandgeräte""",
    )

    dfg_7150_4 = VocabularyTerm(
        code="DFG_7150_4",
        label="7150 Pulse encoders (for analogue tape recorders)",
        description="""Pulse encoders (for analogue tape recorders)//Impulscodiergeräte (für Analog-Bandgeräte)""",
    )

    dfg_7150_5 = VocabularyTerm(
        code="DFG_7150_5",
        label="7150 Magnetic tape recorders (analogue)",
        description="""Magnetic tape recorders (analogue)//Magnetbandspeichergeräte (Analog-)""",
    )

    dfg_7150_6 = VocabularyTerm(
        code="DFG_7150_6",
        label="7150 Measuring magnetic tape recorders (analogue and PCM)",
        description="""Measuring magnetic tape recorders (analogue and PCM)//Messmagnetbandgeräte (analog und PCM)""",
    )

    dfg_7150_7 = VocabularyTerm(
        code="DFG_7150_7",
        label="7150 PCM magnetic tape recorders (pulse code modulation)",
        description="""PCM magnetic tape recorders (pulse code modulation)//PCM-Magnetbandspeicher (Puls-Code-Modulation)""",
    )

    dfg_7150_8 = VocabularyTerm(
        code="DFG_7150_8",
        label="7150 Control units for magnetic tape recorders",
        description="""Control units for magnetic tape recorders//Steuereinheiten für Magnetbandgeräte""",
    )

    dfg_7170_1 = VocabularyTerm(
        code="DFG_7170_1",
        label="7170 Signal memories, digital",
        description="""Signal memories, digital//Signalspeicher, digitale""",
    )

    dfg_7170_2 = VocabularyTerm(
        code="DFG_7170_2",
        label="7170 Storage oscilloscopes, digital",
        description="""Storage oscilloscopes, digital//Speicheroszilloskope, digitale""",
    )

    dfg_7170_3 = VocabularyTerm(
        code="DFG_7170_3",
        label="7170 Transient digitizer (with multidiode frame memory)",
        description="""Transient digitizer (with multidiode frame memory)//Transient Digitizer (mit Multidioden-Bildspeicherröhre)""",
    )

    dfg_7170_4 = VocabularyTerm(
        code="DFG_7170_4",
        label="7170 Transient recorder",
        description="""Transient recorder//Transientenrecorder""",
    )

    dfg_7170_5 = VocabularyTerm(
        code="DFG_7170_5",
        label="7170 Waveform digitizer",
        description="""Waveform digitizer//Waveform Digitizer""",
    )

    dfg_7180_1 = VocabularyTerm(
        code="DFG_7180_1",
        label="7180 CD disks (computer)",
        description="""CD disks (computer)//CD-Platten (EDV-)""",
    )

    dfg_7180_2 = VocabularyTerm(
        code="DFG_7180_2",
        label="7180 Floppy disks for optical storage units",
        description="""Floppy disks for optical storage units//Disketten für optische Speichereinheiten""",
    )

    dfg_7180_3 = VocabularyTerm(
        code="DFG_7180_3",
        label="7180 Punched cards, punched tape",
        description="""Punched cards, punched tape//Lochkarten, Lochstreifen""",
    )

    dfg_7180_4 = VocabularyTerm(
        code="DFG_7180_4",
        label="7180 Magnetic tapes and cassettes for EDP",
        description="""Magnetic tapes and cassettes for EDP//Magnetbänder und -kassetten für EDV""",
    )

    dfg_7180_5 = VocabularyTerm(
        code="DFG_7180_5",
        label="7180 Magnetic discs, magnetic foils for data processing",
        description="""Magnetic discs, magnetic foils for data processing//Magnetplatten, Magnetfolien für EDV""",
    )

    dfg_7180_6 = VocabularyTerm(
        code="DFG_7180_6",
        label="7180 Disks, disk stacks for magnetic disk storage",
        description="""Disks, disk stacks for magnetic disk storage//Platten, Plattenstapel für Magnetplattenspeicher""",
    )

    dfg_7180_7 = VocabularyTerm(
        code="DFG_7180_7",
        label="7180 Computer storage media",
        description="""Computer storage media//Speichermedien für EDV""",
    )

    dfg_7190_1 = VocabularyTerm(
        code="DFG_7190_1",
        label="7190 Electron-optical data storage media",
        description="""Electron-optical data storage media//Datenspeicher, elektronenoptische""",
    )

    dfg_7190_2 = VocabularyTerm(
        code="DFG_7190_2",
        label="7190 Electron-optical data storage media",
        description="""Electron-optical data storage media//Elektronenoptische Datenspeicher""",
    )

    dfg_7200_1 = VocabularyTerm(
        code="DFG_7200_1",
        label="7200 Alphanumeric displays",
        description="""Alphanumeric displays//Alphanumerische Displays""",
    )

    dfg_7200_2 = VocabularyTerm(
        code="DFG_7200_2",
        label="7200 Display terminals",
        description="""Display terminals//Bildschirmterminals""",
    )

    dfg_7200_3 = VocabularyTerm(
        code="DFG_7200_3",
        label="7200 CRT displays (visual displays)",
        description="""CRT displays (visual displays)//CRT-Displays (Sichtgeräte)""",
    )

    dfg_7200_4 = VocabularyTerm(
        code="DFG_7200_4",
        label="7200 Display terminals",
        description="""Display terminals//Display Terminals""",
    )

    dfg_7200_5 = VocabularyTerm(
        code="DFG_7200_5",
        label="7200 Printer terminals",
        description="""Printer terminals//Druckerterminals""",
    )

    dfg_7200_6 = VocabularyTerm(
        code="DFG_7200_6",
        label="7200 Input terminals (computer)",
        description="""Input terminals (computer)//Eingabetastaturen (EDV-)""",
    )

    dfg_7200_7 = VocabularyTerm(
        code="DFG_7200_7",
        label="7200 Graphic terminals (except interactive graphic systems 746)",
        description="""Graphic terminals (except interactive graphic systems 746)//Graphische Terminals (außer interaktive graphische Systeme 746)""",
    )

    dfg_7200_8 = VocabularyTerm(
        code="DFG_7200_8",
        label="7200 Scope display driver (CAMAC)",
        description="""Scope display driver (CAMAC)//Scope Display Driver, Sichtgeräte-Ansteuerung (CAMAC)""",
    )

    dfg_7200_9 = VocabularyTerm(
        code="DFG_7200_9",
        label="7200 Visual display units (for EDP systems)",
        description="""Visual display units (for EDP systems)//Sichtgeräte (für EDV-Anlagen)""",
    )

    dfg_7200_10 = VocabularyTerm(
        code="DFG_7200_10",
        label="7200 Keyboards (EDP)",
        description="""Keyboards (EDP)//Tastaturen (EDV-)""",
    )

    dfg_7200_11 = VocabularyTerm(
        code="DFG_7200_11",
        label="7200 Terminal Driver (CAMAC)",
        description="""Terminal Driver (CAMAC)//Terminal Driver (CAMAC)""",
    )

    dfg_7200_12 = VocabularyTerm(
        code="DFG_7200_12",
        label="7200 Terminals",
        description="""Terminals//Terminals""",
    )

    dfg_7210_1 = VocabularyTerm(
        code="DFG_7210_1",
        label="7210 Output recorders",
        description="""Output recorders//Ausgabeschreibmaschinen""",
    )

    dfg_7210_2 = VocabularyTerm(
        code="DFG_7210_2",
        label="7210 Chart recorders",
        description="""Chart recorders//Blattschreiber""",
    )

    dfg_7210_3 = VocabularyTerm(
        code="DFG_7210_3",
        label="7210 Data recorder (EDP input/output)",
        description="""Data recorder (EDP input/output)//Datenschreiber (EDV-Ein-/ -Ausgabe)""",
    )

    dfg_7210_4 = VocabularyTerm(
        code="DFG_7210_4",
        label="7210 Teleprinter (for EDP)",
        description="""Teleprinter (for EDP)//Fernschreiber (für EDV)""",
    )

    dfg_7210_5 = VocabularyTerm(
        code="DFG_7210_5",
        label="7210 Matrix printers, printers",
        description="""Matrix printers, printers//Matrixdrucker, -printer""",
    )

    dfg_7210_6 = VocabularyTerm(
        code="DFG_7210_6",
        label="7210 Mosaic printer",
        description="""Mosaic printer//Mosaikdrucker""",
    )

    dfg_7210_7 = VocabularyTerm(
        code="DFG_7210_7",
        label="7210 Dot matrix printer",
        description="""Dot matrix printer//Nadeldrucker""",
    )

    dfg_7210_8 = VocabularyTerm(
        code="DFG_7210_8",
        label="7210 Writing stations (data input/output)",
        description="""Writing stations (data input/output)//Schreibstationen (Daten-Ein-/ -Ausgabe)""",
    )

    dfg_7210_9 = VocabularyTerm(
        code="DFG_7210_9",
        label="7210 Teletypes (TTY) (EDP input/output)",
        description="""Teletypes (TTY) (EDP input/output)//Teletypes (TTY) (EDV-Ein-/ -Ausgabe)""",
    )

    dfg_7210_10 = VocabularyTerm(
        code="DFG_7210_10",
        label="7210 Thermal printer",
        description="""Thermal printer//Thermodrucker""",
    )

    dfg_7240_1 = VocabularyTerm(
        code="DFG_7240_1",
        label="7240 Chain printer",
        description="""Chain printer//Kettendrucker""",
    )

    dfg_7240_2 = VocabularyTerm(
        code="DFG_7240_2",
        label="7240 Laser printer",
        description="""Laser printer//Laserdrucker""",
    )

    dfg_7240_3 = VocabularyTerm(
        code="DFG_7240_3",
        label="7240 Line printer",
        description="""Line printer//Lineprinter""",
    )

    dfg_7240_4 = VocabularyTerm(
        code="DFG_7240_4",
        label="7240 High-speed printer (EDP peripherals)",
        description="""High-speed printer (EDP peripherals)//Schnelldrucker (EDV-Peripherie)""",
    )

    dfg_7260_1 = VocabularyTerm(
        code="DFG_7260_1",
        label="7260 Image output devices (photo-write systems)",
        description="""Image output devices (photo-write systems)//Bildausgabegeräte (Photo-Write-Systeme)""",
    )

    dfg_7260_2 = VocabularyTerm(
        code="DFG_7260_2",
        label="7260 Microfilm output devices (EDP)",
        description="""Microfilm output devices (EDP)//Mikrofilmausgabegeräte (EDV)""",
    )

    dfg_7280_1 = VocabularyTerm(
        code="DFG_7280_1",
        label="7280 Clear character reader (OCR)",
        description="""Clear character reader (OCR)//Klarschriftleser (OCR)""",
    )

    dfg_7280_2 = VocabularyTerm(
        code="DFG_7280_2",
        label="7280 Mark reader",
        description="""Mark reader//Markierungsleser""",
    )

    dfg_7280_3 = VocabularyTerm(
        code="DFG_7280_3",
        label="7280 Scanner (EDP)",
        description="""Scanner (EDP)//Scanner (EDV)""",
    )

    dfg_7290_1 = VocabularyTerm(
        code="DFG_7290_1",
        label="7290 Output units (EDP), input and output (except 720-728)",
        description="""Output units (EDP), input and output (except 720-728)//Ausgabeeinheiten (EDV), Ein- und Ausgabe (außer 720-728)""",
    )

    dfg_7290_2 = VocabularyTerm(
        code="DFG_7290_2",
        label="7290 Input and output units (except 720-728)",
        description="""Input and output units (except 720-728)//Ein- und Ausgabeeinheiten (außer 720-728)""",
    )

    dfg_7290_3 = VocabularyTerm(
        code="DFG_7290_3",
        label="7290 Cassette reading and writing units (digital)",
        description="""Cassette reading and writing units (digital)//Kassetten-Lese- und -Schreibeinheiten (digital)""",
    )

    dfg_7290_4 = VocabularyTerm(
        code="DFG_7290_4",
        label="7290 Magnetic card output units",
        description="""Magnetic card output units//Magnetkartenausgabegeräte""",
    )

    dfg_7290_5 = VocabularyTerm(
        code="DFG_7290_5",
        label="7290 Magnetic card readers",
        description="""Magnetic card readers//Magnetkartenleser""",
    )

    dfg_7300_1 = VocabularyTerm(
        code="DFG_7300_1",
        label="7300 Networks, network components, data transmission",
        description="""Networks, network components, data transmission//Netze, Netzkomponenten, Datenübertragung""",
    )

    dfg_7310_1 = VocabularyTerm(
        code="DFG_7310_1",
        label="7310 A/D converter assemblies (process computers, CAMAC)",
        description="""A/D converter assemblies (process computers, CAMAC)//A/D-Wandler-Baugruppen (Prozeßrechner, CAMAC)""",
    )

    dfg_7310_2 = VocabularyTerm(
        code="DFG_7310_2",
        label="7310 Controller (CAMAC)",
        description="""Controller (CAMAC)//Controller (CAMAC)""",
    )

    dfg_7310_3 = VocabularyTerm(
        code="DFG_7310_3",
        label="7310 Crate controller (CAMAC)",
        description="""Crate controller (CAMAC)//Crate-Controller (CAMAC)""",
    )

    dfg_7310_4 = VocabularyTerm(
        code="DFG_7310_4",
        label="7310 D/A converter modules (process computer, CAMAC)",
        description="""D/A converter modules (process computer, CAMAC)//D/A-Wandler-Baugruppen (Prozeßrechner, CAMAC)""",
    )

    dfg_7310_5 = VocabularyTerm(
        code="DFG_7310_5",
        label="7310 Data exchange (coupling) units",
        description="""Data exchange (coupling) units//Datenaustausch- (-koppel-) Einheiten""",
    )

    dfg_7310_6 = VocabularyTerm(
        code="DFG_7310_6",
        label="7310 Data coupler (interface)",
        description="""Data coupler (interface)//Datenkoppler (Interface)""",
    )

    dfg_7310_7 = VocabularyTerm(
        code="DFG_7310_7",
        label="7310 IEC standard interfaces, interfaces",
        description="""IEC standard interfaces, interfaces//IEC-Standard-Schnittstellen, Interfaces""",
    )

    dfg_7310_8 = VocabularyTerm(
        code="DFG_7310_8",
        label="7310 Interfaces",
        description="""Interfaces//Interfaces""",
    )

    dfg_7310_9 = VocabularyTerm(
        code="DFG_7310_9",
        label="7310 Channel adapters (EDP)",
        description="""Channel adapters (EDP)//Kanaladapter (EDV)""",
    )

    dfg_7310_10 = VocabularyTerm(
        code="DFG_7310_10",
        label="7310 Line adapters, channel adapters (EDP)",
        description="""Line adapters, channel adapters (EDP)//Leitungsadapter, Kanaladapter (EDV)""",
    )

    dfg_7310_11 = VocabularyTerm(
        code="DFG_7310_11",
        label="7310 Linearisation units (measured value)",
        description="""Linearisation units (measured value)//Linearisierungseinheiten (Messwert-)""",
    )

    dfg_7310_12 = VocabularyTerm(
        code="DFG_7310_12",
        label="7310 Measuring device interfaces for IEC bus",
        description="""Measuring device interfaces for IEC bus//Messgeräte-Interfaces für IEC-Bus""",
    )

    dfg_7310_13 = VocabularyTerm(
        code="DFG_7310_13",
        label="7310 Multiprogrammer",
        description="""Multiprogrammer//Multiprogrammer""",
    )

    dfg_7310_14 = VocabularyTerm(
        code="DFG_7310_14",
        label="7310 Interface adapters and converters",
        description="""Interface adapters and converters//Schnittstellen-Anpaßgeräte, -Wandelgeräte""",
    )

    dfg_7310_15 = VocabularyTerm(
        code="DFG_7310_15",
        label="7310 Signal adapters",
        description="""Signal adapters//Signalanpaßgeräte""",
    )

    dfg_7320_1 = VocabularyTerm(
        code="DFG_7320_1",
        label="7320 Analogue multiplexers",
        description="""Analogue multiplexers//Analog-Multiplexer""",
    )

    dfg_7320_2 = VocabularyTerm(
        code="DFG_7320_2",
        label="7320 Data loggers",
        description="""Data loggers//Data-Logger""",
    )

    dfg_7320_3 = VocabularyTerm(
        code="DFG_7320_3",
        label="7320 Data acquisition devices, data loggers",
        description="""Data acquisition devices, data loggers//Datenerfassungsgeräte, Data-Logger""",
    )

    dfg_7320_4 = VocabularyTerm(
        code="DFG_7320_4",
        label="7320 I/O expanders",
        description="""I/O expanders//I/O-Expander""",
    )

    dfg_7320_5 = VocabularyTerm(
        code="DFG_7320_5",
        label="7320 Interrupt modules, registers (EDP)",
        description="""Interrupt modules, registers (EDP)//Interrupt-Moduln, -Register (EDV)""",
    )

    dfg_7320_6 = VocabularyTerm(
        code="DFG_7320_6",
        label="7320 Concentrators (data transmission)",
        description="""Concentrators (data transmission)//Konzentratoren (Datenübertragung)""",
    )

    dfg_7320_7 = VocabularyTerm(
        code="DFG_7320_7",
        label="7320 Measuring point sensors, scanners, controllers",
        description="""Measuring point sensors, scanners, controllers//Messstellenwähler, -abtaster, -steuergeräte""",
    )

    dfg_7320_8 = VocabularyTerm(
        code="DFG_7320_8",
        label="7320 Data acquisition systems (process peripherals or permanently programmed)",
        description="""Data acquisition systems (process peripherals or permanently programmed)//Messwerterfassungsanlagen (Prozeßperipherie oder fest programmierte)""",
    )

    dfg_7320_9 = VocabularyTerm(
        code="DFG_7320_9",
        label="7320 Multiplexer",
        description="""Multiplexer//Multiplexer""",
    )

    dfg_7320_10 = VocabularyTerm(
        code="DFG_7320_10",
        label="7320 Read-out, spark chamber (CAMAC), read-out electronics for spark chambers",
        description="""Read-out, spark chamber (CAMAC), read-out electronics for spark chambers//Read-Out, Spark Chamber- (CAMAC), Ausleseelektronik für Funkenkammern""",
    )

    dfg_7320_11 = VocabularyTerm(
        code="DFG_7320_11",
        label="7320 Registers, input, output, interrupt (CAMAC)",
        description="""Registers, input, output, interrupt (CAMAC)//Register, Input-, Output-, Interrupt- (CAMAC)""",
    )

    dfg_7320_12 = VocabularyTerm(
        code="DFG_7320_12",
        label="7320 Relay control",
        description="""Relay control//Relaisansteuerung""",
    )

    dfg_7320_13 = VocabularyTerm(
        code="DFG_7320_13",
        label="7320 Relay multiplexer",
        description="""Relay multiplexer//Relaismultiplexer""",
    )

    dfg_7320_14 = VocabularyTerm(
        code="DFG_7320_14",
        label="7320 Interface multiplexer",
        description="""Interface multiplexer//Schnittstellen-Vervielfacher""",
    )

    dfg_7320_15 = VocabularyTerm(
        code="DFG_7320_15",
        label="7320 Switching device for connection and adjustment of strain gauge measuring points",
        description="""Switching device for connection and adjustment of strain gauge measuring points//Umschaltgeräte zum Anschluß und Abgleich von DMS-Messstellen""",
    )

    dfg_7330_1 = VocabularyTerm(
        code="DFG_7330_1",
        label="7330 Measuring and test automats for logic components",
        description="""Measuring and test automats for logic components//Mess- und Prüfautomaten für Logik-Bausteine""",
    )

    dfg_7340_1 = VocabularyTerm(
        code="DFG_7340_1",
        label="7340 Analogue classifiers (except 750-753)",
        description="""Analogue classifiers (except 750-753)//Analog-Klassiergeräte (außer 750-753)""",
    )

    dfg_7340_2 = VocabularyTerm(
        code="DFG_7340_2",
        label="7340 Hardware monitoring devices for power measurements in data technology",
        description="""Hardware monitoring devices for power measurements in data technology//Hardware-Monitorgeräte für Leistungsmessungen in der Datentechnik""",
    )

    dfg_7340_3 = VocabularyTerm(
        code="DFG_7340_3",
        label="7340 Level meters",
        description="""Level meters//Pegelhäufigkeitszähler""",
    )

    dfg_7340_4 = VocabularyTerm(
        code="DFG_7340_4",
        label="7340 Probability meters, signal structure analysers for determining statistical parameters",
        description="""Probability meters, signal structure analysers for determining statistical parameters//Probability-Meter, Signalstruktur-Analysegeräte zum Ermitteln statistischer Kennwerte""",
    )

    dfg_7340_5 = VocabularyTerm(
        code="DFG_7340_5",
        label="7340 Statistical instruments (except 733, 743 and 750-753)",
        description="""Statistical instruments (except 733, 743 and 750-753)//Statistikgeräte (außer 733, 743 und 750-753)""",
    )

    dfg_7340_6 = VocabularyTerm(
        code="DFG_7340_6",
        label="7340 Structure analysers (signal structure, statistical coupling)",
        description="""Structure analysers (signal structure, statistical coupling)//Strukturanalysatoren (Signalstruktur, statistische Kopplung)""",
    )

    dfg_7360_1 = VocabularyTerm(
        code="DFG_7360_1",
        label="7360 Converter (computer)",
        description="""Converter (computer)//Converter (Rechner-)""",
    )

    dfg_7360_2 = VocabularyTerm(
        code="DFG_7360_2",
        label="7360 GDN, DC data transmission units (low level)",
        description="""GDN, DC data transmission units (low level)//GDN, Gleichstrom-Datenübertragungs-Einheiten (mit niedrigem Pegel)""",
    )

    dfg_7360_3 = VocabularyTerm(
        code="DFG_7360_3",
        label="7360 Direct current data transmission units",
        description="""Direct current data transmission units//Gleichstrom-Datenübertragungs-Einheiten""",
    )

    dfg_7360_4 = VocabularyTerm(
        code="DFG_7360_4",
        label="7360 Modems",
        description="""Modems//Modems""",
    )

    dfg_7360_5 = VocabularyTerm(
        code="DFG_7360_5",
        label="7360 Parallel/serial converters",
        description="""Parallel/serial converters//Parallel-/Serien-Umsetzer""",
    )

    dfg_7360_6 = VocabularyTerm(
        code="DFG_7360_6",
        label="7360 Control circuits, computer input/output control units (except 720-729)",
        description="""Control circuits, computer input/output control units (except 720-729)//Steuerschaltungen, Steuergeräte fur EDV-Ein-/ -Ausgabe (außer 720-729)""",
    )

    dfg_7370_1 = VocabularyTerm(
        code="DFG_7370_1",
        label="7370 Date/time clocks",
        description="""Date/time clocks//Datum-Uhrzeitgeber""",
    )

    dfg_7370_2 = VocabularyTerm(
        code="DFG_7370_2",
        label="7370 Real-time clocks (computer control)",
        description="""Real-time clocks (computer control)//Echtzeit-Uhren (Rechnersteuerung)""",
    )

    dfg_7370_3 = VocabularyTerm(
        code="DFG_7370_3",
        label="7370 Start stop control (CAMAC)",
        description="""Start stop control (CAMAC)//Start Stop Control (CAMAC)""",
    )

    dfg_7370_4 = VocabularyTerm(
        code="DFG_7370_4",
        label="7370 Clock generators",
        description="""Clock generators//Taktgeber, -generatoren""",
    )

    dfg_7370_5 = VocabularyTerm(
        code="DFG_7370_5",
        label="7370 Time clock, real time clocks",
        description="""Time clock, real time clocks//Time Clock, Echtzeituhren""",
    )

    dfg_7370_6 = VocabularyTerm(
        code="DFG_7370_6",
        label="7370 Time code generators, time dials",
        description="""Time code generators, time dials//Zeitcode-Generatoren, -Geräte""",
    )

    dfg_7400_1 = VocabularyTerm(
        code="DFG_7400_1",
        label="7400 Graphical data acquisition devices",
        description="""Graphical data acquisition devices//Graphische Datenerfassungsgeräte""",
    )

    dfg_7410_1 = VocabularyTerm(
        code="DFG_7410_1",
        label="7410 Chart scanners (automatic)",
        description="""Chart scanners (automatic)//Diagrammabtaster (automatisch)""",
    )

    dfg_7410_2 = VocabularyTerm(
        code="DFG_7410_2",
        label="7410 Curve digitizers (automatic)",
        description="""Curve digitizers (automatic)//Kurvendigitalisierer (automatisch)""",
    )

    dfg_7410_3 = VocabularyTerm(
        code="DFG_7410_3",
        label="7410 Curve follower (opto-electronic)",
        description="""Curve follower (opto-electronic)//Kurvenfolger (opto-elektronisch)""",
    )

    dfg_7430_1 = VocabularyTerm(
        code="DFG_7430_1",
        label="7430 Analytical image evaluation",
        description="""Analytical image evaluation//Analytische Bildauswertung""",
    )

    dfg_7450_1 = VocabularyTerm(
        code="DFG_7450_1",
        label="7450 Output units, graphic",
        description="""Output units, graphic//Ausgabeeinheiten, graphische""",
    )

    dfg_7450_2 = VocabularyTerm(
        code="DFG_7450_2",
        label="7450 Digital plotters",
        description="""Digital plotters//Digital-Plotter""",
    )

    dfg_7450_3 = VocabularyTerm(
        code="DFG_7450_3",
        label="7450 Engraving units (drawing machine-), computer-controlled",
        description="""Engraving units (drawing machine-), computer-controlled//Graviereinrichtungen (Zeichenmaschinen-), rechnergesteuert""",
    )

    dfg_7450_4 = VocabularyTerm(
        code="DFG_7450_4",
        label="7450 Plotters",
        description="""Plotters//Plotter""",
    )

    dfg_7450_5 = VocabularyTerm(
        code="DFG_7450_5",
        label="7450 Plotter drivers",
        description="""Plotter drivers//Plotter-Driver""",
    )

    dfg_7450_6 = VocabularyTerm(
        code="DFG_7450_6",
        label="7450 Drum plotters",
        description="""Drum plotters//Trommelplotter""",
    )

    dfg_7450_7 = VocabularyTerm(
        code="DFG_7450_7",
        label="7450 XY plotters (digitally controlled)",
        description="""XY plotters (digitally controlled)//XY-Plotter (digital angesteuert)""",
    )

    dfg_7450_8 = VocabularyTerm(
        code="DFG_7450_8",
        label="7450 Drawing machines, computer-controlled (automatic)",
        description="""Drawing machines, computer-controlled (automatic)//Zeichenmaschinen, rechnergesteuert (automatisch)""",
    )

    dfg_7460_1 = VocabularyTerm(
        code="DFG_7460_1",
        label="7460 Interactive graphics, cave systems, VR systems",
        description="""Interactive graphics, cave systems, VR systems//Interaktive Graphik, Cave-Systeme, VR-Systeme""",
    )

    dfg_7470_1 = VocabularyTerm(
        code="DFG_7470_1",
        label="7470 Graphic systems, CAD, Cax",
        description="""Graphic systems, CAD, Cax//Graphische Systeme, CAD, Cax""",
    )

    dfg_7480_1 = VocabularyTerm(
        code="DFG_7480_1",
        label="7480 Computer production planning, PPS, CIM",
        description="""Computer production planning, PPS, CIM//Rechner Produktionsplanung, PPS, CIM""",
    )

    dfg_7500_1 = VocabularyTerm(
        code="DFG_7500_1",
        label="7500 Averager, signal averager (average value computer)",
        description="""Averager, signal averager (average value computer)//Averager, Signal-Averager (Mittelwertrechner)""",
    )

    dfg_7500_2 = VocabularyTerm(
        code="DFG_7500_2",
        label="7500 Data acquisition and processing systems",
        description="""Data acquisition and processing systems//Messwerterfassungs- und -verarbeitungssysteme""",
    )

    dfg_7500_3 = VocabularyTerm(
        code="DFG_7500_3",
        label="7500 Mean value computers, correlators, microprocessor systems",
        description="""Mean value computers, correlators, microprocessor systems//Mittelwertrechner, Korrelator-, Mikroprozessorsysteme""",
    )

    dfg_7500_4 = VocabularyTerm(
        code="DFG_7500_4",
        label="7500 Multi-channel analyzers (except radiation analyzers 026)",
        description="""Multi-channel analyzers (except radiation analyzers 026)//Multi-Channel-Analyzer (außer Strahlungsmessplätze 026)""",
    )

    dfg_7500_5 = VocabularyTerm(
        code="DFG_7500_5",
        label="7500 Signal analysers, processors",
        description="""Signal analysers, processors//Signalanalysatoren, -prozessoren""",
    )

    dfg_7500_6 = VocabularyTerm(
        code="DFG_7500_6",
        label="7500 Multi-channel analysers (for radiation measurement, except radiation measuring points 0)",
        description="""Multi-channel analysers (for radiation measurement, except radiation measuring points 0)//Vielkanalanalysatoren (für Strahlenmessung, außer Strahlungsmessplätze 0""",
    )

    dfg_7520_1 = VocabularyTerm(
        code="DFG_7520_1",
        label="7520 Autocorrelation calculators, -processors",
        description="""Autocorrelation calculators, -processors//Autokorrelations-Rechner, -Zusätze""",
    )

    dfg_7520_2 = VocabularyTerm(
        code="DFG_7520_2",
        label="7520 Real-time correlators",
        description="""Real-time correlators//Echtzeit-Korrelatoren""",
    )

    dfg_7520_3 = VocabularyTerm(
        code="DFG_7520_3",
        label="7520 Correlators, digital correlators",
        description="""Correlators, digital correlators//Korrelatoren, digitale Korrelatoren""",
    )

    dfg_7530_1 = VocabularyTerm(
        code="DFG_7530_1",
        label="7530 FFT (Fast Fourier Transform) analysers",
        description="""FFT (Fast Fourier Transform) analysers//FFT (Fast-Fourier-Transform-)-Analysatoren""",
    )

    dfg_7530_2 = VocabularyTerm(
        code="DFG_7530_2",
        label="7530 Fourier transform calculators",
        description="""Fourier transform calculators//Fourier-Transform-Rechner""",
    )

    dfg_7530_3 = VocabularyTerm(
        code="DFG_7530_3",
        label="7530 Curve analysers, curve resolvers",
        description="""Curve analysers, curve resolvers//Kurvenanalysatoren, Curve-Resolver""",
    )

    dfg_7530_4 = VocabularyTerm(
        code="DFG_7530_4",
        label="7530 Curve synthesisers (analogue curve synthesis and analysis)",
        description="""Curve synthesisers (analogue curve synthesis and analysis)//Kurvensynthetisatoren (Analoge Kurven-Synthese und -Analyse)""",
    )

    dfg_7530_5 = VocabularyTerm(
        code="DFG_7530_5",
        label="7530 Time signal analysers, digital Fourier, modal, signature analysis",
        description="""Time signal analysers, digital Fourier, modal, signature analysis//Zeitsignalanalysatoren, digitale Fourier-, Modal-, Signatur-Analyse""",
    )

    dfg_7540_1 = VocabularyTerm(
        code="DFG_7540_1",
        label="7540 Pocket calculators",
        description="""Pocket calculators//Taschenrechner""",
    )

    dfg_7560_1 = VocabularyTerm(
        code="DFG_7560_1",
        label="7560 Development Systems for Microprocessors",
        description="""Development Systems for Microprocessors//Entwicklungssysteme für Mikroprozessoren""",
    )

    dfg_7560_2 = VocabularyTerm(
        code="DFG_7560_2",
        label="7560 Microprocessor development systems",
        description="""Microprocessor development systems//Mikroprozessor-Entwicklungssysteme""",
    )

    dfg_7560_3 = VocabularyTerm(
        code="DFG_7560_3",
        label="7560 Programmers for memories (PROM)",
        description="""Programmers for memories (PROM)//Programmiergeräte für Speicher (PROM)""",
    )

    dfg_7590_1 = VocabularyTerm(
        code="DFG_7590_1",
        label="7590 Mathematical Instruments (except Planimeters and Integraphs 876)",
        description="""Mathematical Instruments (except Planimeters and Integraphs 876)//Mathematische Instrumente (außer Planimeter und Integraphen 876)""",
    )

    dfg_7590_2 = VocabularyTerm(
        code="DFG_7590_2",
        label="7590 Calculating instruments, other (adding and slide rules)",
        description="""Calculating instruments, other (adding and slide rules)//Rechengeräte, sonstige (Addiergeräte, Rechenschieber)""",
    )

    dfg_7590_3 = VocabularyTerm(
        code="DFG_7590_3",
        label="7590 Slide rules",
        description="""Slide rules//Rechenschieber""",
    )

    dfg_7600_1 = VocabularyTerm(
        code="DFG_7600_1",
        label="7600 Software, operating system",
        description="""Software, operating system//Software, Betriebssystem-""",
    )

    dfg_7610_1 = VocabularyTerm(
        code="DFG_7610_1",
        label="7610 Interpreter software",
        description="""Interpreter software//Interpreter-Software""",
    )

    dfg_7610_2 = VocabularyTerm(
        code="DFG_7610_2",
        label="7610 Software, compiler, interpreter",
        description="""Software, compiler, interpreter//Software, Compiler-, Interpreter-""",
    )

    dfg_7700_1 = VocabularyTerm(
        code="DFG_7700_1",
        label="7700 Software, database",
        description="""Software, database//Software, Datenbank-""",
    )

    dfg_7710_1 = VocabularyTerm(
        code="DFG_7710_1",
        label="7710 Software, word processing",
        description="""Software, word processing//Software, Textverarbeitung""",
    )

    dfg_7720_1 = VocabularyTerm(
        code="DFG_7720_1",
        label="7720 Software, scientific",
        description="""Software, scientific//Software, Wissenschaftliche""",
    )

    dfg_7730_1 = VocabularyTerm(
        code="DFG_7730_1",
        label="7730 CAD, CAM software",
        description="""CAD, CAM software//CAD-, CAM-Software""",
    )

    dfg_7730_2 = VocabularyTerm(
        code="DFG_7730_2",
        label="7730 Software, graphics, CAD/CAM",
        description="""Software, graphics, CAD/CAM//Software, Graphik-, CAD/CAM-""",
    )

    dfg_8000_1 = VocabularyTerm(
        code="DFG_8000_1",
        label="8000 Axial blowers, fans",
        description="""Axial blowers, fans//Axialgebläse, -Lüfter""",
    )

    dfg_8000_2 = VocabularyTerm(
        code="DFG_8000_2",
        label="8000 Blower, fan",
        description="""Blower, fan//Gebläse, Lüfter""",
    )

    dfg_8000_3 = VocabularyTerm(
        code="DFG_8000_3",
        label="8000 Radial blowers, fans",
        description="""Radial blowers, fans//Radialgebläse, -lüfter""",
    )

    dfg_8010_1 = VocabularyTerm(
        code="DFG_8010_1",
        label="8010 Axial compressors",
        description="""Axial compressors//Axialverdichter""",
    )

    dfg_8010_2 = VocabularyTerm(
        code="DFG_8010_2",
        label="8010 Liquid ring pumps, compressors",
        description="""Liquid ring pumps, compressors//Flüssigkeitsring-Pumpen, -Verdichter""",
    )

    dfg_8010_3 = VocabularyTerm(
        code="DFG_8010_3",
        label="8010 Gas compressors, compressors",
        description="""Gas compressors, compressors//Gasverdichter, Kompressoren""",
    )

    dfg_8010_4 = VocabularyTerm(
        code="DFG_8010_4",
        label="8010 Piston compressors",
        description="""Piston compressors//Kolbenverdichter""",
    )

    dfg_8010_5 = VocabularyTerm(
        code="DFG_8010_5",
        label="8010 Centrifugal compressors",
        description="""Centrifugal compressors//Radialverdichter""",
    )

    dfg_8010_6 = VocabularyTerm(
        code="DFG_8010_6",
        label="8010 Screw compressors",
        description="""Screw compressors//Schraubenverdichter""",
    )

    dfg_8010_7 = VocabularyTerm(
        code="DFG_8010_7",
        label="8010 Side channel compressors",
        description="""Side channel compressors//Seitenkanalverdichter""",
    )

    dfg_8010_8 = VocabularyTerm(
        code="DFG_8010_8",
        label="8010 Dry-running compressors",
        description="""Dry-running compressors//Trockenlaufverdichter""",
    )

    dfg_8010_9 = VocabularyTerm(
        code="DFG_8010_9",
        label="8010 Compressors for gases",
        description="""Compressors for gases//Verdichter für Gase""",
    )

    dfg_8010_10 = VocabularyTerm(
        code="DFG_8010_10",
        label="8010 Water ring pumps",
        description="""Water ring pumps//Wasserringpumpen""",
    )

    dfg_8020_1 = VocabularyTerm(
        code="DFG_8020_1",
        label="8020 Immersion pumps",
        description="""Immersion pumps//Eintauchpumpen""",
    )

    dfg_8020_2 = VocabularyTerm(
        code="DFG_8020_2",
        label="8020 Drum pumps",
        description="""Drum pumps//Fasspumpen""",
    )

    dfg_8020_3 = VocabularyTerm(
        code="DFG_8020_3",
        label="8020 Gas circulation pumps",
        description="""Gas circulation pumps//Gasumlaufpumpen""",
    )

    dfg_8020_4 = VocabularyTerm(
        code="DFG_8020_4",
        label="8020 Hand pumps, hand presses (high pressure)",
        description="""Hand pumps, hand presses (high pressure)//Handpumpen, Handpressen (Hochdruck-)""",
    )

    dfg_8020_5 = VocabularyTerm(
        code="DFG_8020_5",
        label="8020 High-pressure pumps (for gases and liquids) above 200 bar, pressure boosters",
        description="""High-pressure pumps (for gases and liquids) above 200 bar, pressure boosters//Hochdruckpumpen (für Gase und Flüssigkeiten) über 200 bar, Druckverstärker""",
    )

    dfg_8020_6 = VocabularyTerm(
        code="DFG_8020_6",
        label="8020 Duct pumps",
        description="""Duct pumps//Kanalradpumpen""",
    )

    dfg_8020_7 = VocabularyTerm(
        code="DFG_8020_7",
        label="8020 Piston pumps",
        description="""Piston pumps//Kolbenpumpen""",
    )

    dfg_8020_8 = VocabularyTerm(
        code="DFG_8020_8",
        label="8020 Centrifugal pumps",
        description="""Centrifugal pumps//Kreiselpumpen""",
    )

    dfg_8020_9 = VocabularyTerm(
        code="DFG_8020_9",
        label="8020 Diaphragm compressors (high pressure)",
        description="""Diaphragm compressors (high pressure)//Membrankompressoren (Hochdruck-)""",
    )

    dfg_8020_10 = VocabularyTerm(
        code="DFG_8020_10",
        label="8020 Oval gear pumps",
        description="""Oval gear pumps//Ovalradpumpen""",
    )

    dfg_8020_11 = VocabularyTerm(
        code="DFG_8020_11",
        label="8020 Pumps for liquids",
        description="""Pumps for liquids//Pumpen für Flüssigkeiten""",
    )

    dfg_8020_12 = VocabularyTerm(
        code="DFG_8020_12",
        label="8020 Screw pumps",
        description="""Screw pumps//Schraubenpumpen""",
    )

    dfg_8020_13 = VocabularyTerm(
        code="DFG_8020_13",
        label="8020 Canned pumps",
        description="""Canned pumps//Spaltrohrpumpen""",
    )

    dfg_8020_14 = VocabularyTerm(
        code="DFG_8020_14",
        label="8020 Gear pumps",
        description="""Gear pumps//Zahnradpumpen""",
    )

    dfg_8030_1 = VocabularyTerm(
        code="DFG_8030_1",
        label="8030 Pressure intensifiers, pressure boosters",
        description="""Pressure intensifiers, pressure boosters//Druckverstärker, Drucksteigerer""",
    )

    dfg_8030_2 = VocabularyTerm(
        code="DFG_8030_2",
        label="8030 Gas circulation pumps",
        description="""Gas circulation pumps//Gasumlaufpumpen""",
    )

    dfg_8030_3 = VocabularyTerm(
        code="DFG_8030_3",
        label="8030 Hand pumps, hand presses (high-pressure)",
        description="""Hand pumps, hand presses (high-pressure)//Handpumpen, Handpressen (Hochdruck-)""",
    )

    dfg_8030_4 = VocabularyTerm(
        code="DFG_8030_4",
        label="8030 Diaphragm compressors (high pressure)",
        description="""Diaphragm compressors (high pressure)//Membrankompressoren (Hochdruck-)""",
    )

    dfg_8040_1 = VocabularyTerm(
        code="DFG_8040_1",
        label="8040 Metering pumps, peristaltic pumps",
        description="""Metering pumps, peristaltic pumps//Dosierpumpen, Schlauchpumpen""",
    )

    dfg_8040_2 = VocabularyTerm(
        code="DFG_8040_2",
        label="8040 High-pressure metering pumps (except chromatography 1380)",
        description="""High-pressure metering pumps (except chromatography 1380)//Hochdruck-Dosierpumpen (außer Chromatographie 1380)""",
    )

    dfg_8040_3 = VocabularyTerm(
        code="DFG_8040_3",
        label="8040 Peristaltic pumps",
        description="""Peristaltic pumps//Peristaltische Pumpen""",
    )

    dfg_8040_4 = VocabularyTerm(
        code="DFG_8040_4",
        label="8040 Precision pumps, metering pumps (except chromatography 1380)",
        description="""Precision pumps, metering pumps (except chromatography 1380)//Präzisionspumpen, Dosierpumpen (außer Chromatographie 1380)""",
    )

    dfg_8050_1 = VocabularyTerm(
        code="DFG_8050_1",
        label="8050 Electrodynamic pumps",
        description="""Electrodynamic pumps//Elektrodynamische Pumpen""",
    )

    dfg_8050_2 = VocabularyTerm(
        code="DFG_8050_2",
        label="8050 Induction pumps (liquid metal)",
        description="""Induction pumps (liquid metal)//Induktionspumpen (Flüssigmetall)""",
    )

    dfg_8050_3 = VocabularyTerm(
        code="DFG_8050_3",
        label="8050 Liquid gas pumps",
        description="""Liquid gas pumps//Pumpen für flüssige Gase""",
    )

    dfg_8050_4 = VocabularyTerm(
        code="DFG_8050_4",
        label="8050 Screw pumps",
        description="""Screw pumps//Schneckenpumpen""",
    )

    dfg_8050_5 = VocabularyTerm(
        code="DFG_8050_5",
        label="8050 Feed pumps",
        description="""Feed pumps//Speisepumpen""",
    )

    dfg_8050_6 = VocabularyTerm(
        code="DFG_8050_6",
        label="8050 Special pumps (except 3700, 3710 and 8000-8040)",
        description="""Special pumps (except 3700, 3710 and 8000-8040)//Spezielle Pumpen (außer 3700, 3710 und 8000-8040)""",
    )

    dfg_8060_1 = VocabularyTerm(
        code="DFG_8060_1",
        label="8060 Irrigation and drainage equipment",
        description="""Irrigation and drainage equipment//Be- und Entwässerungsanlagen""",
    )

    dfg_8060_2 = VocabularyTerm(
        code="DFG_8060_2",
        label="8060 Sprinklers, lawn sprinklers",
        description="""Sprinklers, lawn sprinklers//Rasensprenger, -regner""",
    )

    dfg_8060_3 = VocabularyTerm(
        code="DFG_8060_3",
        label="8060 Sprinklers, garden sprinklers",
        description="""Sprinklers, garden sprinklers//Regner, Garten-Beregnungsgeräte""",
    )

    dfg_8060_4 = VocabularyTerm(
        code="DFG_8060_4",
        label="8060 Waterworks",
        description="""Waterworks//Schöpfwerke""",
    )

    dfg_8070_1 = VocabularyTerm(
        code="DFG_8070_1",
        label="8070 Fittings, valves, slide valves (except 8170, 8180 and 8270)",
        description="""Fittings, valves, slide valves (except 8170, 8180 and 8270)//Armaturen, Ventile, Schieber (außer 8170, 8180 und 8270)""",
    )

    dfg_8070_2 = VocabularyTerm(
        code="DFG_8070_2",
        label="8070 Steam traps",
        description="""Steam traps//Kondensatableiter""",
    )

    dfg_8090_1 = VocabularyTerm(
        code="DFG_8090_1",
        label="8090 Pulsators (for extraction columns)",
        description="""Pulsators (for extraction columns)//Pulsatoren (für Extraktionskolonnen)""",
    )

    dfg_8090_2 = VocabularyTerm(
        code="DFG_8090_2",
        label="8090 Other pumps and compressors, accessories (except 8000-8070)",
        description="""Other pumps and compressors, accessories (except 8000-8070)//Sonstige Pumpen und Kompressoren, Zubehör (außer 8000-8070)""",
    )

    dfg_8100_1 = VocabularyTerm(
        code="DFG_8100_1",
        label="8100 Rotary lobe pumps",
        description="""Rotary lobe pumps//Drehkolbenpumpen""",
    )

    dfg_8100_2 = VocabularyTerm(
        code="DFG_8100_2",
        label="8100 Rotary vane pumps",
        description="""Rotary vane pumps//Drehschieber-Pumpen""",
    )

    dfg_8100_3 = VocabularyTerm(
        code="DFG_8100_3",
        label="8100 Gas ballast pumps",
        description="""Gas ballast pumps//Gasballastpumpen""",
    )

    dfg_8100_4 = VocabularyTerm(
        code="DFG_8100_4",
        label="8100 Mechanical vacuum pumps (backing pumps)",
        description="""Mechanical vacuum pumps (backing pumps)//Mechanische Vakuumpumpen (Vorpumpen)""",
    )

    dfg_8100_5 = VocabularyTerm(
        code="DFG_8100_5",
        label="8100 Roots pumps",
        description="""Roots pumps//Roots-Pumpen""",
    )

    dfg_8100_6 = VocabularyTerm(
        code="DFG_8100_6",
        label="8100 Rotary pumps",
        description="""Rotary pumps//Rotationspumpen""",
    )

    dfg_8100_7 = VocabularyTerm(
        code="DFG_8100_7",
        label="8100 Wlz piston pumps",
        description="""Wlz piston pumps//Wälzkolbenpumpen""",
    )

    dfg_8110_1 = VocabularyTerm(
        code="DFG_8110_1",
        label="8110 Booster pumps",
        description="""Booster pumps//Booster-Pumpen""",
    )

    dfg_8110_2 = VocabularyTerm(
        code="DFG_8110_2",
        label="8110 Ejectors",
        description="""Ejectors//Ejektoren""",
    )

    dfg_8110_3 = VocabularyTerm(
        code="DFG_8110_3",
        label="8110 Getter pumps",
        description="""Getter pumps//Getter-Pumpen""",
    )

    dfg_8110_4 = VocabularyTerm(
        code="DFG_8110_4",
        label="8110 Ion atomiser pumps",
        description="""Ion atomiser pumps//Ionen-Zerstäuberpumpen""",
    )

    dfg_8110_5 = VocabularyTerm(
        code="DFG_8110_5",
        label="8110 Cryogenic pumps",
        description="""Cryogenic pumps//Kryopumpen""",
    )

    dfg_8110_6 = VocabularyTerm(
        code="DFG_8110_6",
        label="8110 Steam jet pumps",
        description="""Steam jet pumps//Öldampfstrahlpumpen""",
    )

    dfg_8110_7 = VocabularyTerm(
        code="DFG_8110_7",
        label="8110 ldiffusion pumps",
        description="""ldiffusion pumps//Öldiffusionspumpen""",
    )

    dfg_8110_8 = VocabularyTerm(
        code="DFG_8110_8",
        label="8110 Mercury vapour jet pumps",
        description="""Mercury vapour jet pumps//Quecksilber-Dampfstrahlpumpen""",
    )

    dfg_8110_9 = VocabularyTerm(
        code="DFG_8110_9",
        label="8110 Mercury diffusion pumps",
        description="""Mercury diffusion pumps//Quecksilber-Diffusionspumpen""",
    )

    dfg_8110_10 = VocabularyTerm(
        code="DFG_8110_10",
        label="8110 Sorption pumps, ion pumps incl. power packs",
        description="""Sorption pumps, ion pumps incl. power packs//Sorptionspumpen, Ionenpumpen einschl. Netzgeräte""",
    )

    dfg_8110_11 = VocabularyTerm(
        code="DFG_8110_11",
        label="8110 Propellant pumps (steam jet, diffusion)",
        description="""Propellant pumps (steam jet, diffusion)//Treibmittelpumpen (Dampfstrahl, Diffusion)""",
    )

    dfg_8110_12 = VocabularyTerm(
        code="DFG_8110_12",
        label="8110 Water vapour jet pumps",
        description="""Water vapour jet pumps//Wasserdampfstrahlpumpen""",
    )

    dfg_8110_13 = VocabularyTerm(
        code="DFG_8110_13",
        label="8110 Water jet pumps",
        description="""Water jet pumps//Wasserstrahlpumpen""",
    )

    dfg_8120_1 = VocabularyTerm(
        code="DFG_8120_1",
        label="8120 Getter pumps",
        description="""Getter pumps//Getter-Pumpen""",
    )

    dfg_8120_2 = VocabularyTerm(
        code="DFG_8120_2",
        label="8120 Ion pumps, ion getter pumps",
        description="""Ion pumps, ion getter pumps//Ionenpumpen, Ionen-Getter-Pumpen""",
    )

    dfg_8120_3 = VocabularyTerm(
        code="DFG_8120_3",
        label="8120 Ion atomiser pumps",
        description="""Ion atomiser pumps//Ionen-Zerstäuberpumpen""",
    )

    dfg_8120_4 = VocabularyTerm(
        code="DFG_8120_4",
        label="8120 Cryogenic pumps",
        description="""Cryogenic pumps//Kryopumpen""",
    )

    dfg_8120_5 = VocabularyTerm(
        code="DFG_8120_5",
        label="8120 Power supplies for ion, titanium atomiser pumps",
        description="""Power supplies for ion, titanium atomiser pumps//Netzgeräte für Ionen-, Titan-Zerstäuberpumpen""",
    )

    dfg_8120_6 = VocabularyTerm(
        code="DFG_8120_6",
        label="8120 Titanium atomiser, vaporiser pumps",
        description="""Titanium atomiser, vaporiser pumps//Titan-Zerstäuber-, -Verdampferpumpen""",
    )

    dfg_8130_1 = VocabularyTerm(
        code="DFG_8130_1",
        label="8130 Turbomolecular pumps",
        description="""Turbomolecular pumps//Turbomolekularpumpen""",
    )

    dfg_8140_1 = VocabularyTerm(
        code="DFG_8140_1",
        label="8140 Liquid ring vacuum pumps",
        description="""Liquid ring vacuum pumps//Flüssigkeitsring-Vakuumpumpen""",
    )

    dfg_8140_2 = VocabularyTerm(
        code="DFG_8140_2",
        label="8140 Helium-tight backing pumps",
        description="""Helium-tight backing pumps//Heliumdichte Vorvakuumpumpen""",
    )

    dfg_8140_3 = VocabularyTerm(
        code="DFG_8140_3",
        label="8140 Special vacuum pumps",
        description="""Special vacuum pumps//Spezielle Vakuumpumpen""",
    )

    dfg_8160_1 = VocabularyTerm(
        code="DFG_8160_1",
        label="8160 Metering valves for high vacuum systems",
        description="""Metering valves for high vacuum systems//Dosierventile für Hochvakuumanlagen""",
    )

    dfg_8160_2 = VocabularyTerm(
        code="DFG_8160_2",
        label="8160 Spring bellows valves, bellows valves (for high vacuum systems)",
        description="""Spring bellows valves, bellows valves (for high vacuum systems)//Federbalgventile, Faltenbalgventile (für Hochvakuumanlagen)""",
    )

    dfg_8160_3 = VocabularyTerm(
        code="DFG_8160_3",
        label="8160 Gas inlet valves",
        description="""Gas inlet valves//Gaseinlassventile""",
    )

    dfg_8160_4 = VocabularyTerm(
        code="DFG_8160_4",
        label="8160 Column pumping stations",
        description="""Column pumping stations//Säulenpumpstände""",
    )

    dfg_8160_5 = VocabularyTerm(
        code="DFG_8160_5",
        label="8160 Table pumping stations",
        description="""Table pumping stations//Tischpumpstände""",
    )

    dfg_8160_6 = VocabularyTerm(
        code="DFG_8160_6",
        label="8160 Turbomolecular pumps",
        description="""Turbomolecular pumps//Turbomolekularpumpstände""",
    )

    dfg_8160_7 = VocabularyTerm(
        code="DFG_8160_7",
        label="8160 Vacuum pumping units (with backing and high vacuum pumps)",
        description="""Vacuum pumping units (with backing and high vacuum pumps)//Vakuumpumpstände (mit Vor- und Hochvakuumpumpen)""",
    )

    dfg_8160_8 = VocabularyTerm(
        code="DFG_8160_8",
        label="8160 Vacuum valves",
        description="""Vacuum valves//Vakuumschieber""",
    )

    dfg_8160_9 = VocabularyTerm(
        code="DFG_8160_9",
        label="8160 Vacuum valves",
        description="""Vacuum valves//Vakuumventile""",
    )

    dfg_8170_1 = VocabularyTerm(
        code="DFG_8170_1",
        label="8170 Metering valves for high vacuum systems",
        description="""Metering valves for high vacuum systems//Dosierventile für Hochvakuumanlagen""",
    )

    dfg_8170_2 = VocabularyTerm(
        code="DFG_8170_2",
        label="8170 Spring bellows valves, bellows valves (for high vacuum systems)",
        description="""Spring bellows valves, bellows valves (for high vacuum systems)//Federbalgventile, Faltenbalgventile (für Hochvakuumanlagen)""",
    )

    dfg_8170_3 = VocabularyTerm(
        code="DFG_8170_3",
        label="8170 Gas inlet valves",
        description="""Gas inlet valves//Gaseinlassventile""",
    )

    dfg_8170_4 = VocabularyTerm(
        code="DFG_8170_4",
        label="8170 Vacuum gate valves",
        description="""Vacuum gate valves//Vakuumschieber""",
    )

    dfg_8180_1 = VocabularyTerm(
        code="DFG_8180_1",
        label="8180 Absorption traps, fine vacuum absorption traps",
        description="""Absorption traps, fine vacuum absorption traps//Absorptionsfallen, Feinvakuum-Absorptionsfallen""",
    )

    dfg_8180_2 = VocabularyTerm(
        code="DFG_8180_2",
        label="8180 Flanges for vacuum and UHV systems",
        description="""Flanges for vacuum and UHV systems//Flansche für Vakuum- und UHV-Anlagen""",
    )

    dfg_8180_3 = VocabularyTerm(
        code="DFG_8180_3",
        label="8180 Condensers, Steam Condensers for Vacuum Plants",
        description="""Condensers, Steam Condensers for Vacuum Plants//Kondensatoren, Dampfkondensatoren für Vakuumanlagen""",
    )

    dfg_8180_4 = VocabularyTerm(
        code="DFG_8180_4",
        label="8180 Cold traps, spherical cold traps",
        description="""Cold traps, spherical cold traps//Kühlfallen, Kugelkühlfallen""",
    )

    dfg_8180_5 = VocabularyTerm(
        code="DFG_8180_5",
        label="8180 Manipulators for vacuum plants, rotary feedthroughs",
        description="""Manipulators for vacuum plants, rotary feedthroughs//Manipulatoren für Vakuumanlagen, Drehdurchführungen""",
    )

    dfg_8180_6 = VocabularyTerm(
        code="DFG_8180_6",
        label="8180 Vacuum components, recipients, vapour barriers",
        description="""Vacuum components, recipients, vapour barriers//Vakuumbauteile, Rezipienten, Dampfsperren""",
    )

    dfg_8190_1 = VocabularyTerm(
        code="DFG_8190_1",
        label="8190 Other vacuum pumps and accessories (except 8100-8180)",
        description="""Other vacuum pumps and accessories (except 8100-8180)//Sonstige Vakuumpumpen und Zubehör (außer 8100-8180)""",
    )

    dfg_8200_1 = VocabularyTerm(
        code="DFG_8200_1",
        label="8200 Heating autoclaves",
        description="""Heating autoclaves//Heizautoklaven""",
    )

    dfg_8200_2 = VocabularyTerm(
        code="DFG_8200_2",
        label="8200 Hydrothermal plants",
        description="""Hydrothermal plants//Hydrothermal-Anlagen""",
    )

    dfg_8200_3 = VocabularyTerm(
        code="DFG_8200_3",
        label="8200 High-pressure reaction vessels, autoclaves",
        description="""High-pressure reaction vessels, autoclaves//Reaktionsgefäße für Hochdruck, Autoklaven""",
    )

    dfg_8200_4 = VocabularyTerm(
        code="DFG_8200_4",
        label="8200 Rhrautoclaves",
        description="""Rhrautoclaves//Rührautoklaven""",
    )

    dfg_8200_5 = VocabularyTerm(
        code="DFG_8200_5",
        label="8200 Schttelautoclaves",
        description="""Schttelautoclaves//Schüttelautoklaven""",
    )

    dfg_8210_1 = VocabularyTerm(
        code="DFG_8210_1",
        label="8210 Containers, gas containers (experimental plants, except high-pressure 8200 and vacuum plants 8300-8330)",
        description="""Containers, gas containers (experimental plants, except high-pressure 8200 and vacuum plants 8300-8330)//Behälter, Gasbehälter (Experimentieranlagen, außer Hochdruck- 8200 und Vakuumanlagen 8300-8330)""",
    )

    dfg_8210_2 = VocabularyTerm(
        code="DFG_8210_2",
        label="8210 Pressure vessels (except gas cylinders)",
        description="""Pressure vessels (except gas cylinders)//Druckbehälter (außer Gasflaschen)""",
    )

    dfg_8220_1 = VocabularyTerm(
        code="DFG_8220_1",
        label="8220 Air conditioners, air treatment",
        description="""Air conditioners, air treatment//Air Conditioner, Luftaufbereitung""",
    )

    dfg_8220_2 = VocabularyTerm(
        code="DFG_8220_2",
        label="8220 Compressed air systems, compressed air supply",
        description="""Compressed air systems, compressed air supply//Druckluftanlagen, Druckluftversorgung""",
    )

    dfg_8220_3 = VocabularyTerm(
        code="DFG_8220_3",
        label="8220 Air supply plants, air treatment plants",
        description="""Air supply plants, air treatment plants//Luftversorgungsanlagen, -aufbereitungsanlagen""",
    )

    dfg_8230_1 = VocabularyTerm(
        code="DFG_8230_1",
        label="8230 Helium recovery plants (not: helium reflux plants 8570)",
        description="""Helium recovery plants (not: helium reflux plants 8570)//Helium-Rückgewinnungsanlagen (nicht: Helimverflüssigungsanlagen 8570)""",
    )

    dfg_8240_1 = VocabularyTerm(
        code="DFG_8240_1",
        label="8240 Hydraulic power units (pumps with drive motor and pressure accumulator)",
        description="""Hydraulic power units (pumps with drive motor and pressure accumulator)//Hydraulikaggregate (Pumpen mit Antriebsmotor und Druckspeicher)""",
    )

    dfg_8240_2 = VocabularyTerm(
        code="DFG_8240_2",
        label="8240 Hydraulic power generating plants (excluding presses)",
        description="""Hydraulic power generating plants (excluding presses)//Hydraulikanlagen (ohne Pressen)""",
    )

    dfg_8240_3 = VocabularyTerm(
        code="DFG_8240_3",
        label="8240 Water pressure generating plants (hydraulics)",
        description="""Water pressure generating plants (hydraulics)//Wasserdruck-Erzeugungsanlagen (Hydraulik)""",
    )

    dfg_8260_1 = VocabularyTerm(
        code="DFG_8260_1",
        label="8260 High-pressure plants",
        description="""High-pressure plants//Hochdruckanlagen""",
    )

    dfg_8270_1 = VocabularyTerm(
        code="DFG_8270_1",
        label="8270 Bursting plates",
        description="""Bursting plates//Berstplatten""",
    )

    dfg_8270_2 = VocabularyTerm(
        code="DFG_8270_2",
        label="8270 Explosion-protection installations (shielding, insulation)",
        description="""Explosion-protection installations (shielding, insulation)//Explosionsschutz-Anlagen (Abschirmung, Dämmung)""",
    )

    dfg_8270_3 = VocabularyTerm(
        code="DFG_8270_3",
        label="8270 High-pressure valves and components for high-pressure plants",
        description="""High-pressure valves and components for high-pressure plants//Hochdruckventile und Bauteile für Hochdruckanlagen""",
    )

    dfg_8270_4 = VocabularyTerm(
        code="DFG_8270_4",
        label="8270 Safety valves (especially for high-pressure installations)",
        description="""Safety valves (especially for high-pressure installations)//Sicherheitsventile (speziell für Hochdruckanlagen)""",
    )

    dfg_8280_1 = VocabularyTerm(
        code="DFG_8280_1",
        label="8280 Pressure reducers for gas cylinders",
        description="""Pressure reducers for gas cylinders//Druckminderer für Gasflaschen""",
    )

    dfg_8280_2 = VocabularyTerm(
        code="DFG_8280_2",
        label="8280 Gas cylinders and accessories",
        description="""Gas cylinders and accessories//Gasflaschen und Zubehör""",
    )

    dfg_8280_3 = VocabularyTerm(
        code="DFG_8280_3",
        label="8280 Gas cylinder valves",
        description="""Gas cylinder valves//Gasflaschenventile""",
    )

    dfg_8280_4 = VocabularyTerm(
        code="DFG_8280_4",
        label="8280 Steel cylinders for gases",
        description="""Steel cylinders for gases//Stahlflaschen für Gase""",
    )

    dfg_8290_1 = VocabularyTerm(
        code="DFG_8290_1",
        label="8290 Other pressure equipment (except 8200-8280)",
        description="""Other pressure equipment (except 8200-8280)//Sonstige Druckanlagen (außer 8200-8280)""",
    )

    dfg_8300_1 = VocabularyTerm(
        code="DFG_8300_1",
        label="8300 Laboratory vacuum equipment",
        description="""Laboratory vacuum equipment//Labor-Vakuumeinrichtung""",
    )

    dfg_8300_2 = VocabularyTerm(
        code="DFG_8300_2",
        label="8300 Vacuum chambers",
        description="""Vacuum chambers//Vakuumkammern""",
    )

    dfg_8310_1 = VocabularyTerm(
        code="DFG_8310_1",
        label="8310 UHV equipment with analytics",
        description="""UHV equipment with analytics//UHV-Anlagen mit Analytik""",
    )

    dfg_8320_1 = VocabularyTerm(
        code="DFG_8320_1",
        label="8320 Ultra-high vacuum equipment",
        description="""Ultra-high vacuum equipment//Ultrahochvakuumanlagen""",
    )

    dfg_8320_2 = VocabularyTerm(
        code="DFG_8320_2",
        label="8320 Space simulation equipment, space simulation chambers",
        description="""Space simulation equipment, space simulation chambers//Weltraum-Simulationsanlagen, Raum-Simulationskammern""",
    )

    dfg_8330_1 = VocabularyTerm(
        code="DFG_8330_1",
        label="8330 Argon ion cannons",
        description="""Argon ion cannons//Argon Ionenkanonen""",
    )

    dfg_8330_2 = VocabularyTerm(
        code="DFG_8330_2",
        label="8330 Freezing facilities",
        description="""Freezing facilities//Gefrierätzanlagen""",
    )

    dfg_8330_3 = VocabularyTerm(
        code="DFG_8330_3",
        label="8330 Glow facilities",
        description="""Glow facilities//Glimm-Einrichtungen""",
    )

    dfg_8330_4 = VocabularyTerm(
        code="DFG_8330_4",
        label="8330 Ion etching and degassing equipment",
        description="""Ion etching and degassing equipment//Ionen-Ätz- und -Abdünnanlagen""",
    )

    dfg_8330_5 = VocabularyTerm(
        code="DFG_8330_5",
        label="8330 Ion discharge systems",
        description="""Ion discharge systems//Ionendünnungsanlagen""",
    )

    dfg_8330_6 = VocabularyTerm(
        code="DFG_8330_6",
        label="8330 Cathode sputtering equipment",
        description="""Cathode sputtering equipment//Kathodenzerstäuber-Anlagen""",
    )

    dfg_8330_7 = VocabularyTerm(
        code="DFG_8330_7",
        label="8330 Sputtering equipment",
        description="""Sputtering equipment//Sputtering-Anlagen""",
    )

    dfg_8330_8 = VocabularyTerm(
        code="DFG_8330_8",
        label="8330 Vacuum evaporation and preparation plants",
        description="""Vacuum evaporation and preparation plants//Vakuumbedampfungsanlagen und -präparieranlagen""",
    )

    dfg_8340_1 = VocabularyTerm(
        code="DFG_8340_1",
        label="8340 Freeze-drying plants",
        description="""Freeze-drying plants//Gefriertrocknungsanlagen""",
    )

    dfg_8340_2 = VocabularyTerm(
        code="DFG_8340_2",
        label="8340 Lyophilisers",
        description="""Lyophilisers//Lyophilisatoren""",
    )

    dfg_8340_3 = VocabularyTerm(
        code="DFG_8340_3",
        label="8340 Plate-bell plants",
        description="""Plate-bell plants//Teller-Glocken-Anlagen""",
    )

    dfg_8350_1 = VocabularyTerm(
        code="DFG_8350_1",
        label="8350 Absolute pressure transducers, measuring instruments",
        description="""Absolute pressure transducers, measuring instruments//Absolutdruck-Aufnehmer, -Messgeräte""",
    )

    dfg_8350_2 = VocabularyTerm(
        code="DFG_8350_2",
        label="8350 Aneroid absolute pressure gauges (except barometer 0500)",
        description="""Aneroid absolute pressure gauges (except barometer 0500)//Aneroid-Absolutdruckmesser (außer Barometer 0500)""",
    )

    dfg_8350_3 = VocabularyTerm(
        code="DFG_8350_3",
        label="8350 Differential pressure transducers",
        description="""Differential pressure transducers//Differenz-Druckaufnehmer""",
    )

    dfg_8350_4 = VocabularyTerm(
        code="DFG_8350_4",
        label="8350 Pressure transducers for liquids and gases",
        description="""Pressure transducers for liquids and gases//Druckaufnehmer für Flüssigkeiten und Gase""",
    )

    dfg_8350_5 = VocabularyTerm(
        code="DFG_8350_5",
        label="8350 Pressure gauges (except 3000 and 8970)",
        description="""Pressure gauges (except 3000 and 8970)//Druckmessgeräte (außer 3000 und 8970)""",
    )

    dfg_8350_6 = VocabularyTerm(
        code="DFG_8350_6",
        label="8350 Pressure balances",
        description="""Pressure balances//Druckwaagen""",
    )

    dfg_8350_7 = VocabularyTerm(
        code="DFG_8350_7",
        label="8350 Precision pressure gauges",
        description="""Precision pressure gauges//Feindruckmesser""",
    )

    dfg_8350_8 = VocabularyTerm(
        code="DFG_8350_8",
        label="8350 Hydraulic scales",
        description="""Hydraulic scales//Hydraulische Waagen""",
    )

    dfg_8350_9 = VocabularyTerm(
        code="DFG_8350_9",
        label="8350 Capacitance pressure gauges",
        description="""Capacitance pressure gauges//Kapazitäts-Manometer""",
    )

    dfg_8350_10 = VocabularyTerm(
        code="DFG_8350_10",
        label="8350 Pressure gauges",
        description="""Pressure gauges//Manometer""",
    )

    dfg_8350_11 = VocabularyTerm(
        code="DFG_8350_11",
        label="8350 Pressure and vacuum gauges (mechanical and electromechanical), pressure and vacuum regulators",
        description="""Pressure and vacuum gauges (mechanical and electromechanical), pressure and vacuum regulators//Manometer und Vakuum-Meter (mechanisch und elektromechanisch), Druck- und Vakuum-Regelgeräte""",
    )

    dfg_8350_12 = VocabularyTerm(
        code="DFG_8350_12",
        label="8350 McLeod vacuum gauges",
        description="""McLeod vacuum gauges//McLeod-Vakuummeter""",
    )

    dfg_8350_13 = VocabularyTerm(
        code="DFG_8350_13",
        label="8350 Mechanical vacuum gauges",
        description="""Mechanical vacuum gauges//Mechanische Vakuummeter""",
    )

    dfg_8350_14 = VocabularyTerm(
        code="DFG_8350_14",
        label="8350 Diaphragm pressure gauges",
        description="""Diaphragm pressure gauges//Membran-Manometer""",
    )

    dfg_8350_15 = VocabularyTerm(
        code="DFG_8350_15",
        label="8350 Mercury vacuum gauges",
        description="""Mercury vacuum gauges//Quecksilber-Vakuummeter""",
    )

    dfg_8350_16 = VocabularyTerm(
        code="DFG_8350_16",
        label="8350 Immersion crescent gauge",
        description="""Immersion crescent gauge//Tauchsichel-Feindruckmesser""",
    )

    dfg_8360_1 = VocabularyTerm(
        code="DFG_8360_1",
        label="8360 Penning vacuum gauges",
        description="""Penning vacuum gauges//Penning-Vakuummeter""",
    )

    dfg_8360_2 = VocabularyTerm(
        code="DFG_8360_2",
        label="8360 Pirani vacuum gauge",
        description="""Pirani vacuum gauge//Pirani-Vakuummeter""",
    )

    dfg_8360_3 = VocabularyTerm(
        code="DFG_8360_3",
        label="8360 Vacuum gauges for high vacuum, UHV, thermal vacuum gauges, ionisation vacuum gauges",
        description="""Vacuum gauges for high vacuum, UHV, thermal vacuum gauges, ionisation vacuum gauges//Vakuummeter für Hochvakuum, UHV, thermische Vakuummeter, Ionisationsvakuummeter""",
    )

    dfg_8360_4 = VocabularyTerm(
        code="DFG_8360_4",
        label="8360 Heat conduction vacuum gauges",
        description="""Heat conduction vacuum gauges//Wärmeleitungs-Vakuummeter""",
    )

    dfg_8370_1 = VocabularyTerm(
        code="DFG_8370_1",
        label="8370 Leak detector",
        description="""Leak detector//Lecksucher""",
    )

    dfg_8370_2 = VocabularyTerm(
        code="DFG_8370_2",
        label="8370 Mass spectrometer leak detectors",
        description="""Mass spectrometer leak detectors//Massenspektrometer-Lecksuchgeräte""",
    )

    dfg_8380_1 = VocabularyTerm(
        code="DFG_8380_1",
        label="8380 Electron beam evaporation sources",
        description="""Electron beam evaporation sources//Elektronenstrahl-Verdampfungsquellen""",
    )

    dfg_8380_2 = VocabularyTerm(
        code="DFG_8380_2",
        label="8380 Ion beam sources (for sparking and polishing in vacuum)",
        description="""Ion beam sources (for sparking and polishing in vacuum)//Ionenstrahl-Quellen (zum Anätzen und Anpolieren im Vakuum)""",
    )

    dfg_8380_3 = VocabularyTerm(
        code="DFG_8380_3",
        label="8380 Carbon evaporation devices",
        description="""Carbon evaporation devices//Kohlebedampfungs-Einrichtungen""",
    )

    dfg_8380_4 = VocabularyTerm(
        code="DFG_8380_4",
        label="8380 Plasma monitors",
        description="""Plasma monitors//Plasmamonitore""",
    )

    dfg_8380_5 = VocabularyTerm(
        code="DFG_8380_5",
        label="8380 Coating thickness gauges, evaporation and control devices (for vacuum evaporation, except 8330)",
        description="""Coating thickness gauges, evaporation and control devices (for vacuum evaporation, except 8330)//Schichtdickenmessgeräte, Verdampfungs- und Steuergeräte (für Vakuumbedampfung, außer 8330)""",
    )

    dfg_8380_6 = VocabularyTerm(
        code="DFG_8380_6",
        label="8380 Oscillating quartz film thickness gauges",
        description="""Oscillating quartz film thickness gauges//Schwingquarz-Schichtdicken-Messgeräte""",
    )

    dfg_8390_1 = VocabularyTerm(
        code="DFG_8390_1",
        label="8390 Bake-out furnaces (for high vacuum systems)",
        description="""Bake-out furnaces (for high vacuum systems)//Ausheizöfen (für Hochvakuumanlagen)""",
    )

    dfg_8390_2 = VocabularyTerm(
        code="DFG_8390_2",
        label="8390 House vacuum systems (central vacuum supply)",
        description="""House vacuum systems (central vacuum supply)//Haus-Vakuumanlagen (zentrale Vakuumversorgung)""",
    )

    dfg_8390_3 = VocabularyTerm(
        code="DFG_8390_3",
        label="8390 Insulation preparation equipment",
        description="""Insulation preparation equipment//Isolieröl-Aufbereitungsanlagen""",
    )

    dfg_8390_4 = VocabularyTerm(
        code="DFG_8390_4",
        label="8390 Other vacuum equipment (except 8300-8380)",
        description="""Other vacuum equipment (except 8300-8380)//Sonstige Vakuumgeräte und -anlagen (außer 8300-8380)""",
    )

    dfg_8390_5 = VocabularyTerm(
        code="DFG_8390_5",
        label="8390 Vacuum energy resin plants",
        description="""Vacuum energy resin plants//Vakuumgießharz-Anlagen""",
    )

    dfg_8390_6 = VocabularyTerm(
        code="DFG_8390_6",
        label="8390 Valves (vacuum)",
        description="""Valves (vacuum)//Ventile (Vakuum)""",
    )

    dfg_8390_7 = VocabularyTerm(
        code="DFG_8390_7",
        label="8390 Accessories for high vacuum equipment",
        description="""Accessories for high vacuum equipment//Zubehörteile zu Hochvakuumanlagen""",
    )

    dfg_8400_1 = VocabularyTerm(
        code="DFG_8400_1",
        label="8400 Tempering fens",
        description="""Tempering fens//Anlassöfen""",
    )

    dfg_8400_2 = VocabularyTerm(
        code="DFG_8400_2",
        label="8400 Condensation fens",
        description="""Condensation fens//Auftaugeräte""",
    )

    dfg_8400_3 = VocabularyTerm(
        code="DFG_8400_3",
        label="8400 Diffusion furnaces",
        description="""Diffusion furnaces//Diffusionsöfen""",
    )

    dfg_8400_4 = VocabularyTerm(
        code="DFG_8400_4",
        label="8400 Three-zone furnaces",
        description="""Three-zone furnaces//Drei-Zonen-Öfen""",
    )

    dfg_8400_5 = VocabularyTerm(
        code="DFG_8400_5",
        label="8400 Electric furnaces",
        description="""Electric furnaces//Elektro-Rohröfen""",
    )

    dfg_8400_6 = VocabularyTerm(
        code="DFG_8400_6",
        label="8400 Glhfen, Glhanlagen",
        description="""Glhfen, Glhanlagen//Glühöfen, Glühanlagen""",
    )

    dfg_8400_7 = VocabularyTerm(
        code="DFG_8400_7",
        label="8400 Heating furnaces",
        description="""Heating furnaces//Härteöfen""",
    )

    dfg_8400_8 = VocabularyTerm(
        code="DFG_8400_8",
        label="8400 High temperature furnaces",
        description="""High temperature furnaces//Hochtemperaturöfen""",
    )

    dfg_8400_9 = VocabularyTerm(
        code="DFG_8400_9",
        label="8400 Chamber furnaces, muffle furnaces, tube furnaces",
        description="""Chamber furnaces, muffle furnaces, tube furnaces//Kammeröfen, Muffelöfen, Rohröfen""",
    )

    dfg_8400_10 = VocabularyTerm(
        code="DFG_8400_10",
        label="8400 Crucible furnaces",
        description="""Crucible furnaces//Tiegelöfen""",
    )

    dfg_8400_11 = VocabularyTerm(
        code="DFG_8400_11",
        label="8400 Heat treatment furnaces",
        description="""Heat treatment furnaces//Wärmebehandlungs-Öfen""",
    )

    dfg_8410_1 = VocabularyTerm(
        code="DFG_8410_1",
        label="8410 Burners for furnaces",
        description="""Burners for furnaces//Brenner für Öfen""",
    )

    dfg_8410_2 = VocabularyTerm(
        code="DFG_8410_2",
        label="8410 Burners and special heaters, ignition and monitoring devices",
        description="""Burners and special heaters, ignition and monitoring devices//Brenner und spezielle Wärmegeräte, Zünd- und Überwachungsgeräte""",
    )

    dfg_8410_3 = VocabularyTerm(
        code="DFG_8410_3",
        label="8410 Flares, flaring equipment",
        description="""Flares, flaring equipment//Fackeln, Abfackelanlagen""",
    )

    dfg_8410_4 = VocabularyTerm(
        code="DFG_8410_4",
        label="8410 Flame monitoring equipment",
        description="""Flame monitoring equipment//Flammenüberwachungsgeräte""",
    )

    dfg_8410_5 = VocabularyTerm(
        code="DFG_8410_5",
        label="8410 Flaming appliances",
        description="""Flaming appliances//Flämmgeräte""",
    )

    dfg_8410_6 = VocabularyTerm(
        code="DFG_8410_6",
        label="8410 burners",
        description="""burners//Ölbrenner""",
    )

    dfg_8410_7 = VocabularyTerm(
        code="DFG_8410_7",
        label="8410 Plasma burners, argon plasma burners",
        description="""Plasma burners, argon plasma burners//Plasma-Brenner, Argon-Plasmabrenner""",
    )

    dfg_8410_8 = VocabularyTerm(
        code="DFG_8410_8",
        label="8410 Draft regulators (furnace installations)",
        description="""Draft regulators (furnace installations)//Zugregelgeräte (Ofenanlagen)""",
    )

    dfg_8420_1 = VocabularyTerm(
        code="DFG_8420_1",
        label="8420 Electron beam melting furnaces",
        description="""Electron beam melting furnaces//Elektronenstrahl-Schmelzöfen""",
    )

    dfg_8420_2 = VocabularyTerm(
        code="DFG_8420_2",
        label="8420 High-frequency furnaces",
        description="""High-frequency furnaces//Hochfrequenzöfen""",
    )

    dfg_8420_3 = VocabularyTerm(
        code="DFG_8420_3",
        label="8420 Arc furnaces",
        description="""Arc furnaces//Lichtbogenschmelzöfen""",
    )

    dfg_8420_4 = VocabularyTerm(
        code="DFG_8420_4",
        label="8420 Microwave furnaces and heaters (except 3950 and 9500)",
        description="""Microwave furnaces and heaters (except 3950 and 9500)//Mikrowellenöfen und -wärmegeräte (außer 3950 und 9500)""",
    )

    dfg_8420_5 = VocabularyTerm(
        code="DFG_8420_5",
        label="8420 Medium-frequency furnaces",
        description="""Medium-frequency furnaces//Mittelfrequenzöfen""",
    )

    dfg_8420_6 = VocabularyTerm(
        code="DFG_8420_6",
        label="8420 Nernst-Tammann furnaces",
        description="""Nernst-Tammann furnaces//Nernst-Tammann-Öfen""",
    )

    dfg_8420_7 = VocabularyTerm(
        code="DFG_8420_7",
        label="8420 Plasma furnaces",
        description="""Plasma furnaces//Plasmaöfen""",
    )

    dfg_8420_8 = VocabularyTerm(
        code="DFG_8420_8",
        label="8420 Melting furnaces",
        description="""Melting furnaces//Schmelzöfen""",
    )

    dfg_8420_9 = VocabularyTerm(
        code="DFG_8420_9",
        label="8420 Solar furnaces",
        description="""Solar furnaces//Sonnenöfen""",
    )

    dfg_8420_10 = VocabularyTerm(
        code="DFG_8420_10",
        label="8420 Special furnaces (induction, arc heating, vacuum furnaces)",
        description="""Special furnaces (induction, arc heating, vacuum furnaces)//Spezielle Öfen (Induktions-, Lichtbogenheizung, Vakuumöfen)""",
    )

    dfg_8420_11 = VocabularyTerm(
        code="DFG_8420_11",
        label="8420 Radiant heating chambers",
        description="""Radiant heating chambers//Strahlungsheizkammern""",
    )

    dfg_8430_1 = VocabularyTerm(
        code="DFG_8430_1",
        label="8430 Heating air blower",
        description="""Heating air blower//Heißluftgebläse""",
    )

    dfg_8430_2 = VocabularyTerm(
        code="DFG_8430_2",
        label="8430 Heating devices (infrared)",
        description="""Heating devices (infrared)//Heizgeräte (Infrarot-)""",
    )

    dfg_8430_3 = VocabularyTerm(
        code="DFG_8430_3",
        label="8430 Air heaters, air heaters (transportable), infrared heaters",
        description="""Air heaters, air heaters (transportable), infrared heaters//Lufterhitzer, Luftheizgeräte (transportabel), Infrarotheizgeräte""",
    )

    dfg_8430_4 = VocabularyTerm(
        code="DFG_8430_4",
        label="8430 Radiant heaters (except for therapy 3950)",
        description="""Radiant heaters (except for therapy 3950)//Wärmestrahler (außer für Therapie 3950)""",
    )

    dfg_8440_1 = VocabularyTerm(
        code="DFG_8440_1",
        label="8440 Steam generators (for laboratories), steam systems",
        description="""Steam generators (for laboratories), steam systems//Dampferzeuger (für Laboratorien), Dämpfanlagen""",
    )

    dfg_8450_1 = VocabularyTerm(
        code="DFG_8450_1",
        label="8450 Critical point drying equipment",
        description="""Critical point drying equipment//Critical-Point-Trocknungsgeräte""",
    )

    dfg_8450_2 = VocabularyTerm(
        code="DFG_8450_2",
        label="8450 Fresh air drying ovens",
        description="""Fresh air drying ovens//Frischluft-Trockenöfen""",
    )

    dfg_8450_3 = VocabularyTerm(
        code="DFG_8450_3",
        label="8450 Laboratory glassware dryers",
        description="""Laboratory glassware dryers//Laborglas-Trockner""",
    )

    dfg_8450_4 = VocabularyTerm(
        code="DFG_8450_4",
        label="8450 Paint drying and baking ovens",
        description="""Paint drying and baking ovens//Lack-Trocken- und Einbrenn-Öfen""",
    )

    dfg_8450_5 = VocabularyTerm(
        code="DFG_8450_5",
        label="8450 Drying cabinets",
        description="""Drying cabinets//Trockenschränke""",
    )

    dfg_8450_6 = VocabularyTerm(
        code="DFG_8450_6",
        label="8450 Drying plants, desiccators",
        description="""Drying plants, desiccators//Trocknungsanlagen, Exsikkatoren""",
    )

    dfg_8450_7 = VocabularyTerm(
        code="DFG_8450_7",
        label="8450 Vacuum drying ovens",
        description="""Vacuum drying ovens//Vakuumtrockenschränke""",
    )

    dfg_8450_8 = VocabularyTerm(
        code="DFG_8450_8",
        label="8450 Roller dryers",
        description="""Roller dryers//Walzentrockner""",
    )

    dfg_8470_1 = VocabularyTerm(
        code="DFG_8470_1",
        label="8470 Bath and immersion thermostats, temperature control units",
        description="""Bath and immersion thermostats, temperature control units//Bad- und Einhängethermostaten, Temperiergeräte""",
    )

    dfg_8470_2 = VocabularyTerm(
        code="DFG_8470_2",
        label="8470 Thermostats for optical components",
        description="""Thermostats for optical components//Öfen (Thermostaten) für optische Bauelemente""",
    )

    dfg_8470_3 = VocabularyTerm(
        code="DFG_8470_3",
        label="8470 Thermostats (bath and immersion thermostats)",
        description="""Thermostats (bath and immersion thermostats)//Thermostate (Bad- und Einhänge-Thermostaten)""",
    )

    dfg_8470_4 = VocabularyTerm(
        code="DFG_8470_4",
        label="8470 Circulators",
        description="""Circulators//Umwälzthermostate""",
    )

    dfg_8470_5 = VocabularyTerm(
        code="DFG_8470_5",
        label="8470 Water baths (thermostats)",
        description="""Water baths (thermostats)//Wasserbäder (Thermostate)""",
    )

    dfg_8480_1 = VocabularyTerm(
        code="DFG_8480_1",
        label="8480 Gas burners (laboratory), Bunsen burners",
        description="""Gas burners (laboratory), Bunsen burners//Gasbrenner (Labor-), Bunsenbrenner""",
    )

    dfg_8480_2 = VocabularyTerm(
        code="DFG_8480_2",
        label="8480 Heating furnaces (except 9830)",
        description="""Heating furnaces (except 9830)//Heizöfen (außer 9830)""",
    )

    dfg_8480_3 = VocabularyTerm(
        code="DFG_8480_3",
        label="8480 Heating plates, heating elements",
        description="""Heating plates, heating elements//Heizplatten, Heizbänke""",
    )

    dfg_8480_4 = VocabularyTerm(
        code="DFG_8480_4",
        label="8480 Laboratory heaters and burners",
        description="""Laboratory heaters and burners//Laborheizgeräte und Brenner""",
    )

    dfg_8480_5 = VocabularyTerm(
        code="DFG_8480_5",
        label="8480 Burners",
        description="""Burners//Ölbäder""",
    )

    dfg_8480_6 = VocabularyTerm(
        code="DFG_8480_6",
        label="8480 Sandblowers",
        description="""Sandblowers//Sandbäder""",
    )

    dfg_8480_7 = VocabularyTerm(
        code="DFG_8480_7",
        label="8480 Water boilers, electric (laboratory)",
        description="""Water boilers, electric (laboratory)//Wasserkocher, elektrische (Labor-)""",
    )

    dfg_8490_1 = VocabularyTerm(
        code="DFG_8490_1",
        label="8490 Quenchers and quenching apparatus for use in the manufacture of goods",
        description="""Quenchers and quenching apparatus for use in the manufacture of goods//Abschreckbäder und -einrichtungen für Härterei""",
    )

    dfg_8490_2 = VocabularyTerm(
        code="DFG_8490_2",
        label="8490 Furnaces (ceramic, except 8400)",
        description="""Furnaces (ceramic, except 8400)//Brennöfen (Keramik-, außer 8400)""",
    )

    dfg_8490_3 = VocabularyTerm(
        code="DFG_8490_3",
        label="8490 Rotary kilns",
        description="""Rotary kilns//Drehrohröfen""",
    )

    dfg_8490_4 = VocabularyTerm(
        code="DFG_8490_4",
        label="8490 Field forging",
        description="""Field forging//Feldschmieden""",
    )

    dfg_8490_5 = VocabularyTerm(
        code="DFG_8490_5",
        label="8490 Hardening and quenching equipment, hardening machines",
        description="""Hardening and quenching equipment, hardening machines//Härte- und Abschreckanlagen, Härtemaschinen""",
    )

    dfg_8490_6 = VocabularyTerm(
        code="DFG_8490_6",
        label="8490 Heaters for technical equipment",
        description="""Heaters for technical equipment//Heizkörper für technische Geräte""",
    )

    dfg_8490_7 = VocabularyTerm(
        code="DFG_8490_7",
        label="8490 Other furnaces and heaters (except 8400-8480)",
        description="""Other furnaces and heaters (except 8400-8480)//Sonstige Öfen und Wärmegeräte (außer 8400-8480)""",
    )

    dfg_8490_8 = VocabularyTerm(
        code="DFG_8490_8",
        label="8490 Immersion heaters",
        description="""Immersion heaters//Tauchheizkörper""",
    )

    dfg_8490_9 = VocabularyTerm(
        code="DFG_8490_9",
        label="8490 Heat exchangers",
        description="""Heat exchangers//Wärmeaustauscher""",
    )

    dfg_8490_10 = VocabularyTerm(
        code="DFG_8490_10",
        label="8490 Heat pipes",
        description="""Heat pipes//Wärmeröhren (Heat Pipes)""",
    )

    dfg_8490_11 = VocabularyTerm(
        code="DFG_8490_11",
        label="8490 Heat accumulators",
        description="""Heat accumulators//Wärmespeicher""",
    )

    dfg_8500_1 = VocabularyTerm(
        code="DFG_8500_1",
        label="8500 Flake ice machines",
        description="""Flake ice machines//Flockeneisautomaten""",
    )

    dfg_8500_2 = VocabularyTerm(
        code="DFG_8500_2",
        label="8500 Cloth machines (with closed circuit)",
        description="""Cloth machines (with closed circuit)//Kälteanlagen (mit geschlossenem Kreislauf)""",
    )

    dfg_8500_3 = VocabularyTerm(
        code="DFG_8500_3",
        label="8500 Cloth machines (down to -100Grd C)",
        description="""Cloth machines (down to -100Grd C)//Kältemaschinen (bis -100Grd C)""",
    )

    dfg_8500_4 = VocabularyTerm(
        code="DFG_8500_4",
        label="8500 Cooling water circulation systems, recirculating cooling systems",
        description="""Cooling water circulation systems, recirculating cooling systems//Kühlwasserkreislaufsysteme, Rückkühlsysteme""",
    )

    dfg_8500_5 = VocabularyTerm(
        code="DFG_8500_5",
        label="8500 Laboratory ice machines",
        description="""Laboratory ice machines//Laboreisautomaten""",
    )

    dfg_8500_6 = VocabularyTerm(
        code="DFG_8500_6",
        label="8500 Refrigerators (to -100 degrees C)",
        description="""Refrigerators (to -100 degrees C)//Refrigeratoren (bis -100 Grad C)""",
    )

    dfg_8500_7 = VocabularyTerm(
        code="DFG_8500_7",
        label="8500 Brine coolers",
        description="""Brine coolers//Solekühler""",
    )

    dfg_8500_8 = VocabularyTerm(
        code="DFG_8500_8",
        label="8500 Dry ice generators",
        description="""Dry ice generators//Trockeneiserzeuger""",
    )

    dfg_8500_9 = VocabularyTerm(
        code="DFG_8500_9",
        label="8500 Circulating coolers (for laboratory equipment)",
        description="""Circulating coolers (for laboratory equipment)//Umlaufkühler (für Laborgeräte)""",
    )

    dfg_8510_1 = VocabularyTerm(
        code="DFG_8510_1",
        label="8510 Refrigerators and freezers (to -100 degrees C)",
        description="""Refrigerators and freezers (to -100 degrees C)//Kühlschränke und Gefriertruhen (bis -100 Grad C)""",
    )

    dfg_8510_2 = VocabularyTerm(
        code="DFG_8510_2",
        label="8510 Deep freezers, cabinets",
        description="""Deep freezers, cabinets//Tiefgefriertruhen, -Schränke""",
    )

    dfg_8510_3 = VocabularyTerm(
        code="DFG_8510_3",
        label="8510 Deep freezers",
        description="""Deep freezers//Tiefkühltruhen""",
    )

    dfg_8520_1 = VocabularyTerm(
        code="DFG_8520_1",
        label="8520 Immersion coolers",
        description="""Immersion coolers//Eintauchkühler""",
    )

    dfg_8520_2 = VocabularyTerm(
        code="DFG_8520_2",
        label="8520 Cryostats",
        description="""Cryostats//Kältethermostaten""",
    )

    dfg_8520_3 = VocabularyTerm(
        code="DFG_8520_3",
        label="8520 Cryostats, immersion coolers (to -100 degrees C)",
        description="""Cryostats, immersion coolers (to -100 degrees C)//Kryostaten, Tauchkühler (bis -100 Grad C)""",
    )

    dfg_8520_4 = VocabularyTerm(
        code="DFG_8520_4",
        label="8520 Cryostats, cryogenic housings for IR detectors and electron multipliers",
        description="""Cryostats, cryogenic housings for IR detectors and electron multipliers//Kühlgeräte, Kühlgehäuse für IR-Detektoren und Elektronen-Vervielfacher""",
    )

    dfg_8520_5 = VocabularyTerm(
        code="DFG_8520_5",
        label="8520 Microcryostats (microcryoscopes) for microscopy",
        description="""Microcryostats (microcryoscopes) for microscopy//Mikrokryostaten (Mikrokryoskope) für Mikroskopie""",
    )

    dfg_8520_6 = VocabularyTerm(
        code="DFG_8520_6",
        label="8520 Peltier refrigerators",
        description="""Peltier refrigerators//Peltier-Kühlgeräte""",
    )

    dfg_8520_7 = VocabularyTerm(
        code="DFG_8520_7",
        label="8520 Thermoelectric coolers, Peltier coolers",
        description="""Thermoelectric coolers, Peltier coolers//Thermoelektrische Kühlgeräte, Peltierkühler""",
    )

    dfg_8530_1 = VocabularyTerm(
        code="DFG_8530_1",
        label="8530 Cryogenerators, cryocoolers (closed circuit)",
        description="""Cryogenerators, cryocoolers (closed circuit)//Cryogeneratoren, Cryocooler (mit geschlossenem Kreislauf)""",
    )

    dfg_8530_2 = VocabularyTerm(
        code="DFG_8530_2",
        label="8530 Climatic machines and refrigerators (below -100 degrees C)",
        description="""Climatic machines and refrigerators (below -100 degrees C)//Kältemaschinen und Refrigeratoren (unter -100 Grad C)""",
    )

    dfg_8530_3 = VocabularyTerm(
        code="DFG_8530_3",
        label="8530 Closed-circuit refrigerators (below -100 degrees C)",
        description="""Closed-circuit refrigerators (below -100 degrees C)//Kreislaufkälteanlagen (unter -100 Grad C)""",
    )

    dfg_8540_1 = VocabularyTerm(
        code="DFG_8540_1",
        label="8540 Automatic freezers",
        description="""Automatic freezers//Einfrierautomaten""",
    )

    dfg_8540_2 = VocabularyTerm(
        code="DFG_8540_2",
        label="8540 Freezers for biological material",
        description="""Freezers for biological material//Einfriergeräte für biologisches Material""",
    )

    dfg_8540_3 = VocabularyTerm(
        code="DFG_8540_3",
        label="8540 Liquid nitrogen freezers",
        description="""Liquid nitrogen freezers//Flüssigstickstoff-Gefrierbehälter""",
    )

    dfg_8540_4 = VocabularyTerm(
        code="DFG_8540_4",
        label="8540 Deep-freezing plants (liquid nitrogen)",
        description="""Deep-freezing plants (liquid nitrogen)//Tiefgefrieranlagen (flüssiger Stickstoff)""",
    )

    dfg_8541_1 = VocabularyTerm(
        code="DFG_8541_1",
        label="8541 Freezing plants for sample preparation, e.g. in microscopy",
        description="""Freezing plants for sample preparation, e.g. in microscopy//Einfrieranlagen zur Probenvorbereitung, z.B. in der Mikroskopie""",
    )

    dfg_8550_1 = VocabularyTerm(
        code="DFG_8550_1",
        label="8550 Helium cryostats",
        description="""Helium cryostats//Helium-Kryostaten""",
    )

    dfg_8550_2 = VocabularyTerm(
        code="DFG_8550_2",
        label="8550 Mixed cryostats (helium-)",
        description="""Mixed cryostats (helium-)//Mischkryostaten (Helium-)""",
    )

    dfg_8550_3 = VocabularyTerm(
        code="DFG_8550_3",
        label="8550 Special cryostats (for lowest temperatures)",
        description="""Special cryostats (for lowest temperatures)//Spezielle Kryostaten (für tiefste Temperaturen)""",
    )

    dfg_8550_4 = VocabularyTerm(
        code="DFG_8550_4",
        label="8550 Nitrogen cryostats",
        description="""Nitrogen cryostats//Stickstoff-Kryostate""",
    )

    dfg_8550_5 = VocabularyTerm(
        code="DFG_8550_5",
        label="8550 Evaporator cryostats (helium)",
        description="""Evaporator cryostats (helium)//Verdampfer-Kryostaten (Helium-)""",
    )

    dfg_8560_1 = VocabularyTerm(
        code="DFG_8560_1",
        label="8560 Gas liquefaction and air separation plants",
        description="""Gas liquefaction and air separation plants//Gasverflüssigungs-, Luftzerlegungsanlagen""",
    )

    dfg_8560_2 = VocabularyTerm(
        code="DFG_8560_2",
        label="8560 Air liquefaction plants",
        description="""Air liquefaction plants//Luftverflüssigungsanlagen""",
    )

    dfg_8560_3 = VocabularyTerm(
        code="DFG_8560_3",
        label="8560 Nitrogen liquefaction plants",
        description="""Nitrogen liquefaction plants//Stickstoff-Verflüssigungsanlagen""",
    )

    dfg_8570_1 = VocabularyTerm(
        code="DFG_8570_1",
        label="8570 Helium and hydrogen liquefaction plants",
        description="""Helium and hydrogen liquefaction plants//Helium- und Wasserstoff-Verflüssigungsanlagen""",
    )

    dfg_8580_1 = VocabularyTerm(
        code="DFG_8580_1",
        label="8580 Liquid gas tanks",
        description="""Liquid gas tanks//Behälter für flüssige Gase""",
    )

    dfg_8580_2 = VocabularyTerm(
        code="DFG_8580_2",
        label="8580 Dewar flasks",
        description="""Dewar flasks//Dewargefäße""",
    )

    dfg_8580_3 = VocabularyTerm(
        code="DFG_8580_3",
        label="8580 Helium transport cans",
        description="""Helium transport cans//Helium-Transportkannen""",
    )

    dfg_8580_4 = VocabularyTerm(
        code="DFG_8580_4",
        label="8580 Cold gasifiers",
        description="""Cold gasifiers//Kaltvergaser""",
    )

    dfg_8590_1 = VocabularyTerm(
        code="DFG_8590_1",
        label="8590 Gas coolers (for compressors and wind tunnels)",
        description="""Gas coolers (for compressors and wind tunnels)//Gaskühler (für Kompressoren und Windkanäle)""",
    )

    dfg_8590_2 = VocabularyTerm(
        code="DFG_8590_2",
        label="8590 Gas liquefaction plants - accessories",
        description="""Gas liquefaction plants - accessories//Gasverflüssigungsanlagen-Zubehör""",
    )

    dfg_8590_3 = VocabularyTerm(
        code="DFG_8590_3",
        label="8590 Air-conditioning equipment-suppliers",
        description="""Air-conditioning equipment-suppliers//Kälteanlagen-Zubehör""",
    )

    dfg_8590_4 = VocabularyTerm(
        code="DFG_8590_4",
        label="8590 Cryostat siphons",
        description="""Cryostat siphons//Kryostaten-Heber""",
    )

    dfg_8590_5 = VocabularyTerm(
        code="DFG_8590_5",
        label="8590 Cooling systems, water recooling systems",
        description="""Cooling systems, water recooling systems//Kühltürme, Wasserrückkühlanlagen""",
    )

    dfg_8590_6 = VocabularyTerm(
        code="DFG_8590_6",
        label="8590 Other air-conditioning equipment (except 8500-8580)",
        description="""Other air-conditioning equipment (except 8500-8580)//Sonstige Kälteanlagen und -geräte (außer 8500-8580)""",
    )

    dfg_8590_7 = VocabularyTerm(
        code="DFG_8590_7",
        label="8590 Heat exchangers (air conditioning)",
        description="""Heat exchangers (air conditioning)//Wärmeaustauscher (Kältetechnik)""",
    )

    dfg_8600_1 = VocabularyTerm(
        code="DFG_8600_1",
        label="8600 Remote thermometers",
        description="""Remote thermometers//Fernthermometer""",
    )

    dfg_8600_2 = VocabularyTerm(
        code="DFG_8600_2",
        label="8600 Contact thermometers",
        description="""Contact thermometers//Kontaktthermometer""",
    )

    dfg_8600_3 = VocabularyTerm(
        code="DFG_8600_3",
        label="8600 Transmitters, amplifiers for thermocouples and resistance thermometers",
        description="""Transmitters, amplifiers for thermocouples and resistance thermometers//Messumformer, -verstärker für Thermoelemente und Widerstandsthermometer""",
    )

    dfg_8600_4 = VocabularyTerm(
        code="DFG_8600_4",
        label="8600 Surface thermometers (electronic) with temperature sensor",
        description="""Surface thermometers (electronic) with temperature sensor//Oberflächenthermometer (elektronisch) mit Temperaturfühler""",
    )

    dfg_8600_5 = VocabularyTerm(
        code="DFG_8600_5",
        label="8600 Quartz thermometers (electronic)",
        description="""Quartz thermometers (electronic)//Quarzthermometer (elektronisch)""",
    )

    dfg_8600_6 = VocabularyTerm(
        code="DFG_8600_6",
        label="8600 Thermocouples, indicators",
        description="""Thermocouples, indicators//Thermoelemente, Anzeigegeräte""",
    )

    dfg_8600_7 = VocabularyTerm(
        code="DFG_8600_7",
        label="8600 Thermometers (electronic) with temperature sensor",
        description="""Thermometers (electronic) with temperature sensor//Thermometer (elektronisch) mit Temperaturfühler""",
    )

    dfg_8600_8 = VocabularyTerm(
        code="DFG_8600_8",
        label="8600 Thermometers, general (except for geophysics 0450, 0510 and medicine 3910)",
        description="""Thermometers, general (except for geophysics 0450, 0510 and medicine 3910)//Thermometer, (Berührungsthermometer), allgemein (außer für Geophysik 0450, 0510 und Medizin 3910)""",
    )

    dfg_8600_9 = VocabularyTerm(
        code="DFG_8600_9",
        label="8600 Resistance thermometers (except for very low temperatures 8610)",
        description="""Resistance thermometers (except for very low temperatures 8610)//Widerstandsthermometer (außer für tiefste Temperaturen 8610)""",
    )

    dfg_8610_1 = VocabularyTerm(
        code="DFG_8610_1",
        label="8610 Special thermometers for very low temperatures (including electronic indicator)",
        description="""Special thermometers for very low temperatures (including electronic indicator)//Spezielle Thermometer für tiefste Temperaturen (einschließlich elektronischem Anzeigegerät)""",
    )

    dfg_8620_1 = VocabularyTerm(
        code="DFG_8620_1",
        label="8620 Colour pyrometer",
        description="""Colour pyrometer//Farb-Pyrometer""",
    )

    dfg_8620_2 = VocabularyTerm(
        code="DFG_8620_2",
        label="8620 Total radiation pyrometers",
        description="""Total radiation pyrometers//Gesamtstrahlungs-Pyrometer""",
    )

    dfg_8620_3 = VocabularyTerm(
        code="DFG_8620_3",
        label="8620 Infrared cameras (except 3910)",
        description="""Infrared cameras (except 3910)//Infrarot-Kameras (außer 3910)""",
    )

    dfg_8620_4 = VocabularyTerm(
        code="DFG_8620_4",
        label="8620 Infrared micro-scanners",
        description="""Infrared micro-scanners//Infrarot-Mikro-Scanner""",
    )

    dfg_8620_5 = VocabularyTerm(
        code="DFG_8620_5",
        label="8620 Infrared microscopes, microscanners",
        description="""Infrared microscopes, microscanners//Infrarot-Mikroskope, -Mikroscanner""",
    )

    dfg_8620_6 = VocabularyTerm(
        code="DFG_8620_6",
        label="8620 Infrared thermoprobes",
        description="""Infrared thermoprobes//Infrarot-Thermosonden""",
    )

    dfg_8620_7 = VocabularyTerm(
        code="DFG_8620_7",
        label="8620 Quotient pyrometers, distribution pyrometers",
        description="""Quotient pyrometers, distribution pyrometers//Quotienten-Pyrometer, Verteilungs-Pyrometer""",
    )

    dfg_8620_8 = VocabularyTerm(
        code="DFG_8620_8",
        label="8620 Radiometer (infrared)",
        description="""Radiometer (infrared)//Radiometer (Infrarot)""",
    )

    dfg_8620_9 = VocabularyTerm(
        code="DFG_8620_9",
        label="8620 Scanning infrared thermoprobes",
        description="""Scanning infrared thermoprobes//Scanning-Infrarot-Thermosonden""",
    )

    dfg_8620_10 = VocabularyTerm(
        code="DFG_8620_10",
        label="8620 Spectral pyrometers, partial radiation pyrometers",
        description="""Spectral pyrometers, partial radiation pyrometers//Spektralpyrometer, Teilstrahlungs-Pyrometer""",
    )

    dfg_8620_11 = VocabularyTerm(
        code="DFG_8620_11",
        label="8620 Radiation thermometers (except actinometer 0540)",
        description="""Radiation thermometers (except actinometer 0540)//Strahlungsthermometer (außer Aktinometer 0540)""",
    )

    dfg_8620_12 = VocabularyTerm(
        code="DFG_8620_12",
        label="8620 Radiation thermometers, pyrometers, thermoprobes",
        description="""Radiation thermometers, pyrometers, thermoprobes//Strahlungsthermometer, Pyrometer, Thermosonden""",
    )

    dfg_8620_13 = VocabularyTerm(
        code="DFG_8620_13",
        label="8620 Thermographic apparatus (technical)",
        description="""Thermographic apparatus (technical)//Thermographiegeräte (technisch)""",
    )

    dfg_8620_14 = VocabularyTerm(
        code="DFG_8620_14",
        label="8620 Thermometers, special",
        description="""Thermometers, special//Thermometer, spezielle""",
    )

    dfg_8620_15 = VocabularyTerm(
        code="DFG_8620_15",
        label="8620 Thermo-vision cameras (except medical 3910)",
        description="""Thermo-vision cameras (except medical 3910)//Thermovisionskameras (außer Medizin 3910)""",
    )

    dfg_8620_16 = VocabularyTerm(
        code="DFG_8620_16",
        label="8620 Thermal imaging cameras (except medicine 3910)",
        description="""Thermal imaging cameras (except medicine 3910)//Wärmebild-Kameras (außer Medizin 3910)""",
    )

    dfg_8640_1 = VocabularyTerm(
        code="DFG_8640_1",
        label="8640 Calorimeters",
        description="""Calorimeters//Heizwertmessgeräte""",
    )

    dfg_8640_2 = VocabularyTerm(
        code="DFG_8640_2",
        label="8640 Calorimeters and calorific value recorders (except 8650, 8660)",
        description="""Calorimeters and calorific value recorders (except 8650, 8660)//Kalorimeter und Heizwertschreiber (außer 8650, 8660)""",
    )

    dfg_8640_3 = VocabularyTerm(
        code="DFG_8640_3",
        label="8640 Heat quantity measuring and control devices",
        description="""Heat quantity measuring and control devices//Wärmemengen-Mess- und -Regelgeräte""",
    )

    dfg_8650_1 = VocabularyTerm(
        code="DFG_8650_1",
        label="8650 Dilatometer",
        description="""Dilatometer//Dilatometer""",
    )

    dfg_8650_2 = VocabularyTerm(
        code="DFG_8650_2",
        label="8650 Special calorimeters",
        description="""Special calorimeters//Spezielle Kalorimeter""",
    )

    dfg_8650_3 = VocabularyTerm(
        code="DFG_8650_3",
        label="8650 Thermal Evolution Analysers (TEA)",
        description="""Thermal Evolution Analysers (TEA)//Thermische Abbauanalysatoren (TEA, Thermal Evolution Analyzer)""",
    )

    dfg_8650_4 = VocabularyTerm(
        code="DFG_8650_4",
        label="8650 Thermogravimetry instruments",
        description="""Thermogravimetry instruments//Thermogravimetriegeräte""",
    )

    dfg_8660_1 = VocabularyTerm(
        code="DFG_8660_1",
        label="8660 Differential calorimeters",
        description="""Differential calorimeters//Differentialkalorimeter""",
    )

    dfg_8660_2 = VocabularyTerm(
        code="DFG_8660_2",
        label="8660 Differential Scanning Calorimeters (DSC)",
        description="""Differential Scanning Calorimeters (DSC)//Differential-Scanning-Kalorimeter (DSC)""",
    )

    dfg_8660_3 = VocabularyTerm(
        code="DFG_8660_3",
        label="8660 DTA Apparatus (Differential Thermal Analysis)",
        description="""DTA Apparatus (Differential Thermal Analysis)//DTA-Apparaturen (Differential-Thermoanalyse)""",
    )

    dfg_8660_4 = VocabularyTerm(
        code="DFG_8660_4",
        label="8660 Microcalorimeters",
        description="""Microcalorimeters//Mikrokalorimeter""",
    )

    dfg_8660_5 = VocabularyTerm(
        code="DFG_8660_5",
        label="8660 ITC - Microcalorimeter (isothermal titration calorimetry)",
        description="""ITC - Microcalorimeter (isothermal titration calorimetry)//ITC - Mikrokalorimeter (isothermal titration calorimetry)""",
    )

    dfg_8660_6 = VocabularyTerm(
        code="DFG_8660_6",
        label="8660 Thermal analysis apparatus (DTA, DTG), dilatometer",
        description="""Thermal analysis apparatus (DTA, DTG), dilatometer//Thermoanalysegeräte (DTA, DTG), Dilatometer""",
    )

    dfg_8660_7 = VocabularyTerm(
        code="DFG_8660_7",
        label="8660 Thermal balances",
        description="""Thermal balances//Thermowaagen""",
    )

    dfg_8670_1 = VocabularyTerm(
        code="DFG_8670_1",
        label="8670 Cryogenic and control devices",
        description="""Cryogenic and control devices//Kryomess- und -regelgeräte""",
    )

    dfg_8670_2 = VocabularyTerm(
        code="DFG_8670_2",
        label="8670 Room thermostats, temperature controllers",
        description="""Room thermostats, temperature controllers//Raumthermostaten, -temperaturregler""",
    )

    dfg_8670_3 = VocabularyTerm(
        code="DFG_8670_3",
        label="8670 Temperature controllers",
        description="""Temperature controllers//Temperaturregler""",
    )

    dfg_8670_4 = VocabularyTerm(
        code="DFG_8670_4",
        label="8670 Temperature-time programme controllers",
        description="""Temperature-time programme controllers//Temperatur-Zeit-Programmregler""",
    )

    dfg_8670_5 = VocabularyTerm(
        code="DFG_8670_5",
        label="8670 Thermostats (Temperature Controllers)",
        description="""Thermostats (Temperature Controllers)//Thermostate (Temperaturregler)""",
    )

    dfg_8680_1 = VocabularyTerm(
        code="DFG_8680_1",
        label="8680 Apparatus for measuring melting point, boiling point, dripping point",
        description="""Apparatus for measuring melting point, boiling point, dripping point//Geräte zur Messung von Schmelzpunkt, Siedepunkt, Tropfpunkt""",
    )

    dfg_8680_2 = VocabularyTerm(
        code="DFG_8680_2",
        label="8680 Equilibrium apparatus (liquid-vapour equilibrium)",
        description="""Equilibrium apparatus (liquid-vapour equilibrium)//Gleichgewichtsapparaturen (Flüssigkeits-Dampf-Gleichgewicht)""",
    )

    dfg_8680_3 = VocabularyTerm(
        code="DFG_8680_3",
        label="8680 Boiling point apparatus (except ebullioscopes 1630 for molecular weight determination)",
        description="""Boiling point apparatus (except ebullioscopes 1630 for molecular weight determination)//Siedepunktbestimmungsgeräte (außer Ebullioskope 1630 für Molekulargewichtsbestimmung)""",
    )

    dfg_8690_1 = VocabularyTerm(
        code="DFG_8690_1",
        label="8690 Ice-point reference apparatus, zero-point thermostats",
        description="""Ice-point reference apparatus, zero-point thermostats//Eispunkt-Referenzgeräte, Nullpunkt-Thermostate""",
    )

    dfg_8690_2 = VocabularyTerm(
        code="DFG_8690_2",
        label="8690 Gas adsorption and desorption isotherms, measuring instruments (except 1640)",
        description="""Gas adsorption and desorption isotherms, measuring instruments (except 1640)//Gasadsorptions- und Desorptions-Isothermen, Messgeräte (außer 1640)""",
    )

    dfg_8690_3 = VocabularyTerm(
        code="DFG_8690_3",
        label="8690 Other measuring instruments for thermal quantities (except 8600-8680)",
        description="""Other measuring instruments for thermal quantities (except 8600-8680)//Sonstige Messgeräte für thermische Größen (außer 8600-8680)""",
    )

    dfg_8690_4 = VocabularyTerm(
        code="DFG_8690_4",
        label="8690 Temperature gauges, accessories",
        description="""Temperature gauges, accessories//Temperaturmesser-Zubehör""",
    )

    dfg_8690_5 = VocabularyTerm(
        code="DFG_8690_5",
        label="8690 Temperature probes, non-metallic (for HF heating)",
        description="""Temperature probes, non-metallic (for HF heating)//Temperatursonden, nichtmetallisch (für HF-Heizung)""",
    )

    dfg_8690_6 = VocabularyTerm(
        code="DFG_8690_6",
        label="8690 Triple point cells (for thermocouples)",
        description="""Triple point cells (for thermocouples)//Tripelpunktzellen (für Thermoelemente)""",
    )

    dfg_8690_7 = VocabularyTerm(
        code="DFG_8690_7",
        label="8690 Heat flow measuring devices",
        description="""Heat flow measuring devices//Wärmefluss-Messeinrichtungen""",
    )

    dfg_8690_8 = VocabularyTerm(
        code="DFG_8690_8",
        label="8690 Thermal conductivity measuring instruments (except for chromatography 1380)",
        description="""Thermal conductivity measuring instruments (except for chromatography 1380)//Wärmeleitfähigkeits-Messgeräte (außer für Chromatographie 1380)""",
    )

    dfg_8700_1 = VocabularyTerm(
        code="DFG_8700_1",
        label="8700 Thickness gauges, mechanical (with core radiation see 4130, pneumatic see 8720)",
        description="""Thickness gauges, mechanical (with core radiation see 4130, pneumatic see 8720)//Dickenmessgeräte, mechanisch (mit Kernstrahlung siehe 4130, pneumatische siehe 8720)""",
    )

    dfg_8700_2 = VocabularyTerm(
        code="DFG_8700_2",
        label="8700 Gauge blocks, parallel gauge blocks",
        description="""Gauge blocks, parallel gauge blocks//Endmasse, Parallel-Endmaße""",
    )

    dfg_8700_3 = VocabularyTerm(
        code="DFG_8700_3",
        label="8700 Fine callipers, fine gauges",
        description="""Fine callipers, fine gauges//Feintaster, Feinmessgeräte""",
    )

    dfg_8700_4 = VocabularyTerm(
        code="DFG_8700_4",
        label="8700 Coordinate measuring machines (mechanical)",
        description="""Coordinate measuring machines (mechanical)//Koordinaten-Messmaschinen (mechanisch)""",
    )

    dfg_8700_5 = VocabularyTerm(
        code="DFG_8700_5",
        label="8700 Gauges, mechanical",
        description="""Gauges, mechanical//Lehren, mechanische""",
    )

    dfg_8700_6 = VocabularyTerm(
        code="DFG_8700_6",
        label="8700 Mechanically scanning length and thickness gauges, measuring machines",
        description="""Mechanically scanning length and thickness gauges, measuring machines//Mechanisch abtastende Längen- und Dickenmessgeräte, Messmaschinen""",
    )

    dfg_8700_7 = VocabularyTerm(
        code="DFG_8700_7",
        label="8700 Dial gauges (length, thickness)",
        description="""Dial gauges (length, thickness)//Messuhren (Länge, Dicke)""",
    )

    dfg_8700_8 = VocabularyTerm(
        code="DFG_8700_8",
        label="8700 Micrometers (screws)",
        description="""Micrometers (screws)//Mikrometer (-schrauben)""",
    )

    dfg_8700_9 = VocabularyTerm(
        code="DFG_8700_9",
        label="8700 Calipers",
        description="""Calipers//Schieblehren""",
    )

    dfg_8710_1 = VocabularyTerm(
        code="DFG_8710_1",
        label="8710 Electro-optical length and distance measuring instruments",
        description="""Electro-optical length and distance measuring instruments//Elektrooptische Längen- und Wegmessgeräte""",
    )

    dfg_8710_2 = VocabularyTerm(
        code="DFG_8710_2",
        label="8710 Encoders, optical (length measurement)",
        description="""Encoders, optical (length measurement)//Encoder, optische (Längenmessung)""",
    )

    dfg_8710_3 = VocabularyTerm(
        code="DFG_8710_3",
        label="8710 Television micrometers",
        description="""Television micrometers//Fernseh-Mikrometer""",
    )

    dfg_8710_4 = VocabularyTerm(
        code="DFG_8710_4",
        label="8710 Interference comparators",
        description="""Interference comparators//Interferenzkomparatoren""",
    )

    dfg_8710_5 = VocabularyTerm(
        code="DFG_8710_5",
        label="8710 Cathetometers",
        description="""Cathetometers//Kathetometer""",
    )

    dfg_8710_6 = VocabularyTerm(
        code="DFG_8710_6",
        label="8710 Comparators",
        description="""Comparators//Komparatoren""",
    )

    dfg_8710_7 = VocabularyTerm(
        code="DFG_8710_7",
        label="8710 Laser light-sectioning instruments",
        description="""Laser light-sectioning instruments//Laser-Lichtschnittgeräte""",
    )

    dfg_8710_8 = VocabularyTerm(
        code="DFG_8710_8",
        label="8710 Laser measuring machines, interferometers",
        description="""Laser measuring machines, interferometers//Laser-Messmaschinen, -Interferometer""",
    )

    dfg_8710_9 = VocabularyTerm(
        code="DFG_8710_9",
        label="8710 Laser telemetry systems",
        description="""Laser telemetry systems//Laser-Telemetrie-Systeme""",
    )

    dfg_8710_10 = VocabularyTerm(
        code="DFG_8710_10",
        label="8710 Light-sectioning instruments",
        description="""Light-sectioning instruments//Lichtschnittgeräte""",
    )

    dfg_8710_11 = VocabularyTerm(
        code="DFG_8710_11",
        label="8710 Optical length measuring instruments (except 0620-0670 and measuring microscopes 5030)",
        description="""Optical length measuring instruments (except 0620-0670 and measuring microscopes 5030)//Optische Längenmessgeräte (außer 0620-0670 und Messmikroskope 5030)""",
    )

    dfg_8710_12 = VocabularyTerm(
        code="DFG_8710_12",
        label="8710 Displacement transducers and measuring instruments (optical, electro-optical)",
        description="""Displacement transducers and measuring instruments (optical, electro-optical)//Wegaufnehmer und -messgeräte (optisch, elektrooptisch)""",
    )

    dfg_8720_1 = VocabularyTerm(
        code="DFG_8720_1",
        label="8720 Electronic and pneumatic length gauges, displacement transducers and indicators",
        description="""Electronic and pneumatic length gauges, displacement transducers and indicators//Elektronische und pneumatische Längenmessgeräte, Wegaufnehmer und Anzeigegeräte""",
    )

    dfg_8720_2 = VocabularyTerm(
        code="DFG_8720_2",
        label="8720 Form gauges, form testers, roundness gauges (electronic-mechanical, pneumatic)",
        description="""Form gauges, form testers, roundness gauges (electronic-mechanical, pneumatic)//Formprüfgeräte, Formtester, Rundheitsmessgeräte (elektronisch-mechanisch, pneumatisch)""",
    )

    dfg_8720_3 = VocabularyTerm(
        code="DFG_8720_3",
        label="8720 Inductive displacement transducers, feelers",
        description="""Inductive displacement transducers, feelers//Induktive Wegaufnehmer, Taster""",
    )

    dfg_8720_4 = VocabularyTerm(
        code="DFG_8720_4",
        label="8720 Capacitive displacement transducers",
        description="""Capacitive displacement transducers//Kapazitive Wegaufnehmer""",
    )

    dfg_8720_5 = VocabularyTerm(
        code="DFG_8720_5",
        label="8720 Laser measuring systems for form and position measurement",
        description="""Laser measuring systems for form and position measurement//Laser-Mess-Systeme für Form- und Positionsmessung""",
    )

    dfg_8720_6 = VocabularyTerm(
        code="DFG_8720_6",
        label="8720 Measuring machines (electronic-mechanical, pneumatic)",
        description="""Measuring machines (electronic-mechanical, pneumatic)//Messmaschinen (elektronisch-mechanisch, pneumatisch)""",
    )

    dfg_8720_7 = VocabularyTerm(
        code="DFG_8720_7",
        label="8720 Measuring amplifiers (carrier frequency) and measuring bridges for inductive and capacitive transducers",
        description="""Measuring amplifiers (carrier frequency) and measuring bridges for inductive and capacitive transducers//Messverstärker (Trägerfrequenz-) und Messbrücken für induktive und kapazitive Aufnehmer""",
    )

    dfg_8720_8 = VocabularyTerm(
        code="DFG_8720_8",
        label="8720 Position indicators (with displacement or angle transducers)",
        description="""Position indicators (with displacement or angle transducers)//Positions-Anzeigegeräte (mit Weg- oder Winkel-Aufnehmer)""",
    )

    dfg_8720_9 = VocabularyTerm(
        code="DFG_8720_9",
        label="8720 Profile measuring machines (electronic, mechanical)",
        description="""Profile measuring machines (electronic, mechanical)//Profilmessmaschinen (elektronisch, mechanisch)""",
    )

    dfg_8720_10 = VocabularyTerm(
        code="DFG_8720_10",
        label="8720 Roundness measuring machines",
        description="""Roundness measuring machines//Rundheitsmessgeräte""",
    )

    dfg_8720_11 = VocabularyTerm(
        code="DFG_8720_11",
        label="8720 Position measuring devices, transducers",
        description="""Position measuring devices, transducers//Stellungsmessgeräte, -messumformer""",
    )

    dfg_8720_12 = VocabularyTerm(
        code="DFG_8720_12",
        label="8720 Displacement transducers (electronic)",
        description="""Displacement transducers (electronic)//Verlagerungsaufnehmer (elektronisch)""",
    )

    dfg_8720_13 = VocabularyTerm(
        code="DFG_8720_13",
        label="8720 Tooth form, gear wheel gauges (electronic-mechanical)",
        description="""Tooth form, gear wheel gauges (electronic-mechanical)//Zahnform-, Zahnrad-Prüfgeräte (elektronisch-mechanisch)""",
    )

    dfg_8730_1 = VocabularyTerm(
        code="DFG_8730_1",
        label="8730 Bridge alignment units (for strain gauges)",
        description="""Bridge alignment units (for strain gauges)//Brückenabgleich-Einheiten (für Dehnungsmessbrücken)""",
    )

    dfg_8730_2 = VocabularyTerm(
        code="DFG_8730_2",
        label="8730 Strain gauges and gauging blocks",
        description="""Strain gauges and gauging blocks//Dehnungsmessgeräte und -messbrücken""",
    )

    dfg_8730_3 = VocabularyTerm(
        code="DFG_8730_3",
        label="8730 Strain gauges, strain gauges, strain gauging blocks",
        description="""Strain gauges, strain gauges, strain gauging blocks//DMS-, Dehnungsmessstreifen, -messbrücken""",
    )

    dfg_8730_4 = VocabularyTerm(
        code="DFG_8730_4",
        label="8730 Compensators, manual, automatic (digital) for strain gauges",
        description="""Compensators, manual, automatic (digital) for strain gauges//Kompensatoren, manuell, automatisch (digital) für Dehnungsmessstreifen""",
    )

    dfg_8730_5 = VocabularyTerm(
        code="DFG_8730_5",
        label="8730 Measuring transducers for strain gauges and strain gage transducers",
        description="""Measuring transducers for strain gauges and strain gage transducers//Messverstärker für Dehnungsmessstreifen und DMS-Aufnehmer""",
    )

    dfg_8730_6 = VocabularyTerm(
        code="DFG_8730_6",
        label="8730 Rotation transducers",
        description="""Rotation transducers//Rotationsgeber""",
    )

    dfg_8730_7 = VocabularyTerm(
        code="DFG_8730_7",
        label="8730 Vibrating wire strain gauges and transducers",
        description="""Vibrating wire strain gauges and transducers//Schwingsaiten-Dehnungsmessgeräte und -aufnehmer""",
    )

    dfg_8730_8 = VocabularyTerm(
        code="DFG_8730_8",
        label="8730 Pitch circle strain gauges",
        description="""Pitch circle strain gauges//Teilkreisprüfgeräte""",
    )

    dfg_8730_9 = VocabularyTerm(
        code="DFG_8730_9",
        label="8730 Strain-frequency bridges for strain gauges",
        description="""Strain-frequency bridges for strain gauges//Trägerfrequenz-Brücken für Dehnungsmessstreifen""",
    )

    dfg_8730_10 = VocabularyTerm(
        code="DFG_8730_10",
        label="8730 Angle encoders, step encoders",
        description="""Angle encoders, step encoders//Winkel-Codierer, -Schrittgeber""",
    )

    dfg_8730_11 = VocabularyTerm(
        code="DFG_8730_11",
        label="8730 Angle gauges, gages",
        description="""Angle gauges, gages//Winkel-Endmaße, -Prüfgeräte""",
    )

    dfg_8730_12 = VocabularyTerm(
        code="DFG_8730_12",
        label="8730 Angle encoders, goniometers, rotary encoders",
        description="""Angle encoders, goniometers, rotary encoders//Winkelmessgeräte, Goniometer, Drehgeber""",
    )

    dfg_8740_1 = VocabularyTerm(
        code="DFG_8740_1",
        label="8740 Bridge alignment units (for strain gauges)",
        description="""Bridge alignment units (for strain gauges)//Brückenabgleich-Einheiten (für Dehnungsmessbrücken)""",
    )

    dfg_8740_2 = VocabularyTerm(
        code="DFG_8740_2",
        label="8740 Strain gauges, strain gauges, strain gauging blocks",
        description="""Strain gauges, strain gauges, strain gauging blocks//DMS-, Dehnungsmessstreifen, -messbrücken""",
    )

    dfg_8740_3 = VocabularyTerm(
        code="DFG_8740_3",
        label="8740 Compensators, manual, automatic (digital) for strain gauges",
        description="""Compensators, manual, automatic (digital) for strain gauges//Kompensatoren, manuell, automatisch (digital) für Dehnungsmessstreifen""",
    )

    dfg_8740_4 = VocabularyTerm(
        code="DFG_8740_4",
        label="8740 Measuring bridges for strain gauges",
        description="""Measuring bridges for strain gauges//Messbrücken für Dehnungsmessstreifen""",
    )

    dfg_8740_5 = VocabularyTerm(
        code="DFG_8740_5",
        label="8740 Measuring amplifiers for strain gauges and strain gage transducers",
        description="""Measuring amplifiers for strain gauges and strain gage transducers//Messverstärker für Dehnungsmessstreifen und DMS-Aufnehmer""",
    )

    dfg_8740_6 = VocabularyTerm(
        code="DFG_8740_6",
        label="8740 Vibrating wire strain gauges and transducers",
        description="""Vibrating wire strain gauges and transducers//Schwingsaiten-Dehnungsmessgeräte und -aufnehmer""",
    )

    dfg_8740_7 = VocabularyTerm(
        code="DFG_8740_7",
        label="8740 Carrier-frequency bridges for strain gauges",
        description="""Carrier-frequency bridges for strain gauges//Trägerfrequenz-Brücken für Dehnungsmessstreifen""",
    )

    dfg_8760_1 = VocabularyTerm(
        code="DFG_8760_1",
        label="8760 Integraphs, mechanical",
        description="""Integraphs, mechanical//Integraphen, mechanische""",
    )

    dfg_8760_2 = VocabularyTerm(
        code="DFG_8760_2",
        label="8760 Planimeters, mechanical integraphs",
        description="""Planimeters, mechanical integraphs//Planimeter, mechanische Integraphen""",
    )

    dfg_8770_1 = VocabularyTerm(
        code="DFG_8770_1",
        label="8770 Level gauges (capacitive, nuclear, ultrasonic)",
        description="""Level gauges (capacitive, nuclear, ultrasonic)//Füllstandsmessgeräte (kapazitiv, Kernstrahlung, Ultraschall)""",
    )

    dfg_8770_2 = VocabularyTerm(
        code="DFG_8770_2",
        label="8770 Level gauges, transducers",
        description="""Level gauges, transducers//Niveaumessgeräte, -messumformer""",
    )

    dfg_8770_3 = VocabularyTerm(
        code="DFG_8770_3",
        label="8770 Water level indicators, gauges",
        description="""Water level indicators, gauges//Wasserstandszeiger, -gläser""",
    )

    dfg_8780_1 = VocabularyTerm(
        code="DFG_8780_1",
        label="8780 Calibration instruments",
        description="""Calibration instruments//Eichgefäße""",
    )

    dfg_8780_2 = VocabularyTerm(
        code="DFG_8780_2",
        label="8780 Litre gauges",
        description="""Litre gauges//Litermaße""",
    )

    dfg_8780_3 = VocabularyTerm(
        code="DFG_8780_3",
        label="8780 Air pycnometers, air comparison pycnometers",
        description="""Air pycnometers, air comparison pycnometers//Luftpyknometer, Luftvergleichs-Pyknometer""",
    )

    dfg_8780_4 = VocabularyTerm(
        code="DFG_8780_4",
        label="8780 Pycnometer",
        description="""Pycnometer//Pyknometer""",
    )

    dfg_8780_5 = VocabularyTerm(
        code="DFG_8780_5",
        label="8780 Tamping volumeters",
        description="""Tamping volumeters//Stampfvolumeter""",
    )

    dfg_8780_6 = VocabularyTerm(
        code="DFG_8780_6",
        label="8780 Volumetric meters (except 1900 and 1920)",
        description="""Volumetric meters (except 1900 and 1920)//Volumenmessgeräte (außer 1900 und 1920)""",
    )

    dfg_8780_7 = VocabularyTerm(
        code="DFG_8780_7",
        label="8780 Volumetric micrometers",
        description="""Volumetric micrometers//Volumetrische Mikrometer""",
    )

    dfg_8790_1 = VocabularyTerm(
        code="DFG_8790_1",
        label="8790 Surface measuring instruments (except 1640, 5230, 7430 and 8760)",
        description="""Surface measuring instruments (except 1640, 5230, 7430 and 8760)//Flächenmessgeräte (außer 1640, 5230, 7430 und 8760)""",
    )

    dfg_8790_2 = VocabularyTerm(
        code="DFG_8790_2",
        label="8790 Length measuring instruments (except 0620-0670 and 8700-8720)",
        description="""Length measuring instruments (except 0620-0670 and 8700-8720)//Längenmessgeräte (außer 0620-0670 und 8700-8720)""",
    )

    dfg_8790_3 = VocabularyTerm(
        code="DFG_8790_3",
        label="8790 Other measuring instruments for length, area, volume",
        description="""Other measuring instruments for length, area, volume//Sonstige Messgeräte für Länge, Fläche, Rauminhalt""",
    )

    dfg_8800_1 = VocabularyTerm(
        code="DFG_8800_1",
        label="8800 Astronomical clocks",
        description="""Astronomical clocks//Astronomische Uhren""",
    )

    dfg_8800_2 = VocabularyTerm(
        code="DFG_8800_2",
        label="8800 Radio-controlled clocks, clocks controlled by time signals",
        description="""Radio-controlled clocks, clocks controlled by time signals//Funk-Uhren, über Zeitzeichen gesteuerte Uhren""",
    )

    dfg_8800_3 = VocabularyTerm(
        code="DFG_8800_3",
        label="8800 Standard time equipment",
        description="""Standard time equipment//Normalzeitanlagen""",
    )

    dfg_8800_4 = VocabularyTerm(
        code="DFG_8800_4",
        label="8800 Time standards, atomic clocks",
        description="""Time standards, atomic clocks//Zeitnormale, Atomuhren""",
    )

    dfg_8810_1 = VocabularyTerm(
        code="DFG_8810_1",
        label="8810 Electronic clocks (except 6150 and 7370)",
        description="""Electronic clocks (except 6150 and 7370)//Elektronische Uhren (außer 6150 und 7370)""",
    )

    dfg_8810_2 = VocabularyTerm(
        code="DFG_8810_2",
        label="8810 Quartz clocks",
        description="""Quartz clocks//Quarzuhren""",
    )

    dfg_8820_1 = VocabularyTerm(
        code="DFG_8820_1",
        label="8820 Mechanical precision clocks, chronometers",
        description="""Mechanical precision clocks, chronometers//Mechanische Präzisionsuhren, Chronometer""",
    )

    dfg_8830_1 = VocabularyTerm(
        code="DFG_8830_1",
        label="8830 Laboratory clocks (short timers, stopwatches)",
        description="""Laboratory clocks (short timers, stopwatches)//Laboruhren (Kurzzeitmesser, Stoppuhren)""",
    )

    dfg_8840_1 = VocabularyTerm(
        code="DFG_8840_1",
        label="8840 Contact clocks",
        description="""Contact clocks//Kontaktuhren""",
    )

    dfg_8840_2 = VocabularyTerm(
        code="DFG_8840_2",
        label="8840 Time switches, time control devices",
        description="""Time switches, time control devices//Schaltuhren, Zeitsteuergeräte""",
    )

    dfg_8840_3 = VocabularyTerm(
        code="DFG_8840_3",
        label="8840 Time markers, generators (except 6550)",
        description="""Time markers, generators (except 6550)//Zeitmarkengeber, -generatoren (außer 6550)""",
    )

    dfg_8840_4 = VocabularyTerm(
        code="DFG_8840_4",
        label="8840 Time switches",
        description="""Time switches//Zeitschalter""",
    )

    dfg_8860_1 = VocabularyTerm(
        code="DFG_8860_1",
        label="8860 Anemometers (flow meters)",
        description="""Anemometers (flow meters)//Anemometer (Strömungsmesser)""",
    )

    dfg_8860_2 = VocabularyTerm(
        code="DFG_8860_2",
        label="8860 Doppler radar velocimeters (except navigation equipment 2460)",
        description="""Doppler radar velocimeters (except navigation equipment 2460)//Doppler-Radar-Geschwindigkeitsmesser (außer Navigationsgeräte 2460)""",
    )

    dfg_8860_3 = VocabularyTerm(
        code="DFG_8860_3",
        label="8860 Velocity meters (except 0470, 0530, 1920 and 2440)",
        description="""Velocity meters (except 0470, 0530, 1920 and 2440)//Geschwindigkeitsmessgeräte (außer 0470, 0530, 1920 und 2440)""",
    )

    dfg_8860_4 = VocabularyTerm(
        code="DFG_8860_4",
        label="8860 Hot film anemometer",
        description="""Hot film anemometer//Heißfilm-Anemometer""",
    )

    dfg_8860_5 = VocabularyTerm(
        code="DFG_8860_5",
        label="8860 Hot-wire anemometers, probes",
        description="""Hot-wire anemometers, probes//Hitzedraht-Anemometer, -Sonden""",
    )

    dfg_8860_6 = VocabularyTerm(
        code="DFG_8860_6",
        label="8860 Correlation optical sensors for velocity, displacement and acceleration",
        description="""Correlation optical sensors for velocity, displacement and acceleration//Korrelations-optische Sensoren für Geschwindigkeit, Weg und Beschleunigung""",
    )

    dfg_8860_7 = VocabularyTerm(
        code="DFG_8860_7",
        label="8860 Laser Doppler anemometers, velocimeters, PIVs",
        description="""Laser Doppler anemometers, velocimeters, PIVs//Laser-Doppler-Anemometer, -Velocimeter, PIV""",
    )

    dfg_8860_8 = VocabularyTerm(
        code="DFG_8860_8",
        label="8860 Sensors for speed measurement",
        description="""Sensors for speed measurement//Sensoren für Geschwindigkeitsmessung""",
    )

    dfg_8860_9 = VocabularyTerm(
        code="DFG_8860_9",
        label="8860 Tachometers",
        description="""Tachometers//Tachometer""",
    )

    dfg_8860_10 = VocabularyTerm(
        code="DFG_8860_10",
        label="8860 Turbulence meters",
        description="""Turbulence meters//Turbulenzgradmesser""",
    )

    dfg_8860_11 = VocabularyTerm(
        code="DFG_8860_11",
        label="8860 Ultrasonic flow and velocity meters (except 1920 and 3010)",
        description="""Ultrasonic flow and velocity meters (except 1920 and 3010)//Ultraschall-Strömungs- und -Geschwindigkeitsmesser (außer 1920 und 3010)""",
    )

    dfg_8870_1 = VocabularyTerm(
        code="DFG_8870_1",
        label="8870 Speed transducers, sensors",
        description="""Speed transducers, sensors//Drehzahlaufnehmer, -sensoren""",
    )

    dfg_8870_2 = VocabularyTerm(
        code="DFG_8870_2",
        label="8870 Speed sensors, revolution counters",
        description="""Speed sensors, revolution counters//Drehzahlmessgeräte, Umdrehungszähler""",
    )

    dfg_8870_3 = VocabularyTerm(
        code="DFG_8870_3",
        label="8870 Magnetic transducers for rotational speed and counting processes",
        description="""Magnetic transducers for rotational speed and counting processes//Magnetische Aufnehmer für Drehzahl und Zählvorgänge""",
    )

    dfg_8870_4 = VocabularyTerm(
        code="DFG_8870_4",
        label="8870 Optical transducers for speed and counter speeds",
        description="""Optical transducers for speed and counter speeds//Optische Aufnehmer für Drehzahl und Zählvorgänge""",
    )

    dfg_8870_5 = VocabularyTerm(
        code="DFG_8870_5",
        label="8870 Tachogenerators",
        description="""Tachogenerators//Tachogeneratoren""",
    )

    dfg_8890_1 = VocabularyTerm(
        code="DFG_8890_1",
        label="8890 Other measuring instruments for time, speed, rotational speed (except 8800-8870)",
        description="""Other measuring instruments for time, speed, rotational speed (except 8800-8870)//Sonstige Messgeräte für Zeit, Geschwindigkeit, Drehzahl (außer 8800-8870)""",
    )

    dfg_8890_2 = VocabularyTerm(
        code="DFG_8890_2",
        label="8890 Clock instruments",
        description="""Clock instruments//Uhren-Prüfgeräte""",
    )

    dfg_8890_3 = VocabularyTerm(
        code="DFG_8890_3",
        label="8890 Clocks and watches",
        description="""Clocks and watches//Uhren-Zubehör""",
    )

    dfg_8900_1 = VocabularyTerm(
        code="DFG_8900_1",
        label="8900 Waste and bagging scales",
        description="""Waste and bagging scales//Abfüll- und Absackwaagen""",
    )

    dfg_8900_2 = VocabularyTerm(
        code="DFG_8900_2",
        label="8900 Decimal scales",
        description="""Decimal scales//Dezimalwaagen""",
    )

    dfg_8900_3 = VocabularyTerm(
        code="DFG_8900_3",
        label="8900 Vehicle scales",
        description="""Vehicle scales//Fahrzeugwaagen""",
    )

    dfg_8900_4 = VocabularyTerm(
        code="DFG_8900_4",
        label="8900 Weights, weight units, weights",
        description="""Weights, weight units, weights//Gewichte, Gewichtsstücke, Gewichtssätze""",
    )

    dfg_8900_5 = VocabularyTerm(
        code="DFG_8900_5",
        label="8900 Industrial and commercial scales",
        description="""Industrial and commercial scales//Industrie- und Handelswaagen""",
    )

    dfg_8900_6 = VocabularyTerm(
        code="DFG_8900_6",
        label="8900 Table scales",
        description="""Table scales//Tafelwaagen""",
    )

    dfg_8900_7 = VocabularyTerm(
        code="DFG_8900_7",
        label="8900 Scales (technical)",
        description="""Scales (technical)//Waagen (technisch)""",
    )

    dfg_8900_8 = VocabularyTerm(
        code="DFG_8900_8",
        label="8900 Weighing equipment",
        description="""Weighing equipment//Wiegeanlagen""",
    )

    dfg_8910_1 = VocabularyTerm(
        code="DFG_8910_1",
        label="8910 Letter scales",
        description="""Letter scales//Briefwaagen""",
    )

    dfg_8910_2 = VocabularyTerm(
        code="DFG_8910_2",
        label="8910 Carat scales",
        description="""Carat scales//Karatwaagen""",
    )

    dfg_8910_3 = VocabularyTerm(
        code="DFG_8910_3",
        label="8910 Laboratory scales, precision scales",
        description="""Laboratory scales, precision scales//Laborwaagen, Präzisionswaagen""",
    )

    dfg_8910_4 = VocabularyTerm(
        code="DFG_8910_4",
        label="8910 Tare balances for centrifuge rotors",
        description="""Tare balances for centrifuge rotors//Tarierwaagen für Zentrifugenrotoren""",
    )

    dfg_8910_5 = VocabularyTerm(
        code="DFG_8910_5",
        label="8910 Torsion balances",
        description="""Torsion balances//Torsionswaagen""",
    )

    dfg_8920_1 = VocabularyTerm(
        code="DFG_8920_1",
        label="8920 Analytical balances (macro- micro-), mechanical and electronic",
        description="""Analytical balances (macro- micro-), mechanical and electronic//Analysenwaagen (Makro- Mikro-), mechanisch und elektronisch""",
    )

    dfg_8920_2 = VocabularyTerm(
        code="DFG_8920_2",
        label="8920 Microbalances",
        description="""Microbalances//Mikrowaagen""",
    )

    dfg_8920_3 = VocabularyTerm(
        code="DFG_8920_3",
        label="8920 Ultra-microbalances",
        description="""Ultra-microbalances//Ultramikrowaagen""",
    )

    dfg_8920_4 = VocabularyTerm(
        code="DFG_8920_4",
        label="8920 Vacuum microbalances",
        description="""Vacuum microbalances//Vakuummikrowaagen""",
    )

    dfg_8930_1 = VocabularyTerm(
        code="DFG_8930_1",
        label="8930 Bed scales",
        description="""Bed scales//Betten-Waagen""",
    )

    dfg_8930_2 = VocabularyTerm(
        code="DFG_8930_2",
        label="8930 Dosing scales",
        description="""Dosing scales//Dosierwaagen""",
    )

    dfg_8930_3 = VocabularyTerm(
        code="DFG_8930_3",
        label="8930 Wheel load gauges",
        description="""Wheel load gauges//Radlastenmesser""",
    )

    dfg_8930_4 = VocabularyTerm(
        code="DFG_8930_4",
        label="8930 Suspension scales, magnetic",
        description="""Suspension scales, magnetic//Schwebewaagen, magnetische""",
    )

    dfg_8930_5 = VocabularyTerm(
        code="DFG_8930_5",
        label="8930 Special scales (remote-controlled, recording)",
        description="""Special scales (remote-controlled, recording)//Spezielle Waagen (ferngesteuert, registrierend)""",
    )

    dfg_8950_1 = VocabularyTerm(
        code="DFG_8950_1",
        label="8950 Accelerometers",
        description="""Accelerometers//Accelerometer""",
    )

    dfg_8950_2 = VocabularyTerm(
        code="DFG_8950_2",
        label="8950 Indicators with force transducers and load cells (except strain gauges 8740)",
        description="""Indicators with force transducers and load cells (except strain gauges 8740)//Anzeigegeräte mit Messverstärker für Kraftmessung und Wägezellen (außer DMS-Messbrücken 8740)""",
    )

    dfg_8950_3 = VocabularyTerm(
        code="DFG_8950_3",
        label="8950 Accelerometers (except body transducers 0040)",
        description="""Accelerometers (except body transducers 0040)//Beschleunigungsaufnehmer (außer Körperschallaufnehmer 0040)""",
    )

    dfg_8950_4 = VocabularyTerm(
        code="DFG_8950_4",
        label="8950 Accelerometers (except seismometers)",
        description="""Accelerometers (except seismometers)//Beschleunigungsmessgeräte (außer Seismometer)""",
    )

    dfg_8950_5 = VocabularyTerm(
        code="DFG_8950_5",
        label="8950 Bending force transducers",
        description="""Bending force transducers//Biegekraft-Aufnehmer""",
    )

    dfg_8950_6 = VocabularyTerm(
        code="DFG_8950_6",
        label="8950 Brake (acceleration) measuring instruments",
        description="""Brake (acceleration) measuring instruments//Brems- (Beschleunigungs-) Messgeräte""",
    )

    dfg_8950_7 = VocabularyTerm(
        code="DFG_8950_7",
        label="8950 Pressure transducers (pressure, load cells)",
        description="""Pressure transducers (pressure, load cells)//Druckaufnehmer (Druck-, Kraftmessdosen)""",
    )

    dfg_8950_8 = VocabularyTerm(
        code="DFG_8950_8",
        label="8950 Pressure transducers (ground pressure measurement)",
        description="""Pressure transducers (ground pressure measurement)//Drucktöpfe (Bodendruckmessung)""",
    )

    dfg_8950_9 = VocabularyTerm(
        code="DFG_8950_9",
        label="8950 Dynamometer",
        description="""Dynamometer//Dynamometer""",
    )

    dfg_8950_10 = VocabularyTerm(
        code="DFG_8950_10",
        label="8950 Earthquake meters (except seismometer 0420)",
        description="""Earthquake meters (except seismometer 0420)//Erschütterungsmesser (außer Seismometer 0420)""",
    )

    dfg_8950_11 = VocabularyTerm(
        code="DFG_8950_11",
        label="8950 Load cells, force transducers",
        description="""Load cells, force transducers//Kraftmessdosen, Kraftaufnehmer""",
    )

    dfg_8950_12 = VocabularyTerm(
        code="DFG_8950_12",
        label="8950 Piezoelectric, piezoresistive pressure force transducers",
        description="""Piezoelectric, piezoresistive pressure force transducers//Piezoelektrische, piezoresistive Druckkraftaufnehmer""",
    )

    dfg_8950_13 = VocabularyTerm(
        code="DFG_8950_13",
        label="8950 Vibration force measuring instruments (except 0040)",
        description="""Vibration force measuring instruments (except 0040)//Schwingstärke-Messgeräte (außer 0040)""",
    )

    dfg_8950_14 = VocabularyTerm(
        code="DFG_8950_14",
        label="8950 Cable pull scales",
        description="""Cable pull scales//Seilzugwaagen""",
    )

    dfg_8950_15 = VocabularyTerm(
        code="DFG_8950_15",
        label="8950 Transport load cells",
        description="""Transport load cells//Transportstoßmessgeräte""",
    )

    dfg_8950_16 = VocabularyTerm(
        code="DFG_8950_16",
        label="8950 Load cells (for tension and compression)",
        description="""Load cells (for tension and compression)//Wägezellen (für Zug- und Druckbelastung)""",
    )

    dfg_8960_1 = VocabularyTerm(
        code="DFG_8960_1",
        label="8960 Balancing machines, unbalance measuring devices",
        description="""Balancing machines, unbalance measuring devices//Auswuchtmaschinen, Unwuchtmesseinrichtungen""",
    )

    dfg_8970_1 = VocabularyTerm(
        code="DFG_8970_1",
        label="8970 Force gauges (incl. electronic indicator)",
        description="""Force gauges (incl. electronic indicator)//Kraftmessgeräte (einschl. elektronischem Anzeigegerät)""",
    )

    dfg_8980_1 = VocabularyTerm(
        code="DFG_8980_1",
        label="8980 Indicators (electronic) for torque measurement (except strain gauge measuring bridges 8740)",
        description="""Indicators (electronic) for torque measurement (except strain gauge measuring bridges 8740)//Anzeigegeräte (elektronisch) für Drehmoment-Messung (außer DMS-Messbrücken 8740)""",
    )

    dfg_8980_2 = VocabularyTerm(
        code="DFG_8980_2",
        label="8980 Indicators (pressure, machine power)",
        description="""Indicators (pressure, machine power)//Indikatoren (Druck, Maschinenleistung)""",
    )

    dfg_8980_3 = VocabularyTerm(
        code="DFG_8980_3",
        label="8980 Power meters (machine power, except wattmeter 6440)",
        description="""Power meters (machine power, except wattmeter 6440)//Leistungsmessgeräte (Maschinenleistung, außer Wattmeter 6440)""",
    )

    dfg_8980_4 = VocabularyTerm(
        code="DFG_8980_4",
        label="8980 Measuring instruments for torque, mechanical power (measuring shafts) Indicators",
        description="""Measuring instruments for torque, mechanical power (measuring shafts) Indicators//Messgeräte für Drehmoment, mechanische Leistung (Messwellen) Anzeigegeräte""",
    )

    dfg_8980_5 = VocabularyTerm(
        code="DFG_8980_5",
        label="8980 Measuring shafts for torque measurement",
        description="""Measuring shafts for torque measurement//Messwellen für Drehmomentmessung""",
    )

    dfg_8990_1 = VocabularyTerm(
        code="DFG_8990_1",
        label="8990 Other measuring instruments for mass and force (except 8900 -8980)",
        description="""Other measuring instruments for mass and force (except 8900 -8980)//Sonstige Messgeräte für Masse und Kraft (außer 8900 -8980)""",
    )

    dfg_9000_1 = VocabularyTerm(
        code="DFG_9000_1",
        label="9000 Basic units (DIN 276 1.0.)",
        description="""Basic units (DIN 276 1.0.)//Grundstücke (DIN 276 1.0.)""",
    )

    dfg_9010_1 = VocabularyTerm(
        code="DFG_9010_1",
        label="9010 Development (DIN 276 2.2., except 9020, 9030, 9070 and 9800-9820)",
        description="""Development (DIN 276 2.2., except 9020, 9030, 9070 and 9800-9820)//Erschließung (DIN 276 2.2., außer 9020, 9030, 9070 und 9800-9820)""",
    )

    dfg_9020_1 = VocabularyTerm(
        code="DFG_9020_1",
        label="9020 Landing stages for watercraft",
        description="""Landing stages for watercraft//Anlegestellen für Wasserfahrzeuge""",
    )

    dfg_9020_2 = VocabularyTerm(
        code="DFG_9020_2",
        label="9020 Jetties for boats",
        description="""Jetties for boats//Boots-Stege""",
    )

    dfg_9020_3 = VocabularyTerm(
        code="DFG_9020_3",
        label="9020 Airfields",
        description="""Airfields//Flugplätze""",
    )

    dfg_9020_4 = VocabularyTerm(
        code="DFG_9020_4",
        label="9020 Railway tracks, railway equipment (fixed)",
        description="""Railway tracks, railway equipment (fixed)//Gleisanlagen, Eisenbahnmaterial (ortsfest)""",
    )

    dfg_9020_5 = VocabularyTerm(
        code="DFG_9020_5",
        label="9020 Parking lots",
        description="""Parking lots//Parkplätze""",
    )

    dfg_9020_6 = VocabularyTerm(
        code="DFG_9020_6",
        label="9020 Rail facilities",
        description="""Rail facilities//Schienenanlagen""",
    )

    dfg_9020_7 = VocabularyTerm(
        code="DFG_9020_7",
        label="9020 Roads",
        description="""Roads//Straßen""",
    )

    dfg_9020_8 = VocabularyTerm(
        code="DFG_9020_8",
        label="9020 Traffic installations (DIN 276 5.7.)",
        description="""Traffic installations (DIN 276 5.7.)//Verkehrsanlagen (DIN 276 5.7.)""",
    )

    dfg_9020_9 = VocabularyTerm(
        code="DFG_9020_9",
        label="9020 Traffic signs, signals",
        description="""Traffic signs, signals//Verkehrszeichen, -signale""",
    )

    dfg_9020_10 = VocabularyTerm(
        code="DFG_9020_10",
        label="9020 Paths",
        description="""Paths//Wege""",
    )

    dfg_9030_1 = VocabularyTerm(
        code="DFG_9030_1",
        label="9030 Gardens, grassland",
        description="""Gardens, grassland//Gartenanlagen, Grünflächen""",
    )

    dfg_9030_2 = VocabularyTerm(
        code="DFG_9030_2",
        label="9030 Landscaping, horticultural facilities, sports facilities",
        description="""Landscaping, horticultural facilities, sports facilities//Geländegestaltung, gärtnerische Anlagen, Sportanlagen""",
    )

    dfg_9030_3 = VocabularyTerm(
        code="DFG_9030_3",
        label="9030 Plantings",
        description="""Plantings//Pflanzungen""",
    )

    dfg_9030_4 = VocabularyTerm(
        code="DFG_9030_4",
        label="9030 Swimming pools",
        description="""Swimming pools//Schwimmbecken""",
    )

    dfg_9030_5 = VocabularyTerm(
        code="DFG_9030_5",
        label="9030 Sports grounds, sports facilities",
        description="""Sports grounds, sports facilities//Sportplätze, Sportanlagen""",
    )

    dfg_9030_6 = VocabularyTerm(
        code="DFG_9030_6",
        label="9030 Water basins, fountains",
        description="""Water basins, fountains//Wasserbecken, Springbrunnen""",
    )

    dfg_9040_1 = VocabularyTerm(
        code="DFG_9040_1",
        label="9040 Buildings (with living and working space, except 9060)",
        description="""Buildings (with living and working space, except 9060)//Gebäude (mit Wohn- und Arbeitsräumen, außer 9060)""",
    )

    dfg_9050_1 = VocabularyTerm(
        code="DFG_9050_1",
        label="9050 Shut-off devices",
        description="""Shut-off devices//Absperreinrichtungen""",
    )

    dfg_9050_2 = VocabularyTerm(
        code="DFG_9050_2",
        label="9050 Barrier chains",
        description="""Barrier chains//Absperrketten""",
    )

    dfg_9050_3 = VocabularyTerm(
        code="DFG_9050_3",
        label="9050 Fences, enclosures (DIN 276 5.1.)",
        description="""Fences, enclosures (DIN 276 5.1.)//Einzäunungen, Einfriedigungen (DIN 276 5.1.)""",
    )

    dfg_9050_4 = VocabularyTerm(
        code="DFG_9050_4",
        label="9050 Grids, fencing",
        description="""Grids, fencing//Gitter, Absperr-""",
    )

    dfg_9050_5 = VocabularyTerm(
        code="DFG_9050_5",
        label="9050 Fences (except electric fences 4340)",
        description="""Fences (except electric fences 4340)//Zäune (außer Elektro-Weidezäune 4340)""",
    )

    dfg_9060_1 = VocabularyTerm(
        code="DFG_9060_1",
        label="9060 Barracks, warehouses, machine halls",
        description="""Barracks, warehouses, machine halls//Baracken, Gewächshäuser, Maschinenhallen""",
    )

    dfg_9060_2 = VocabularyTerm(
        code="DFG_9060_2",
        label="9060 Aircraft hangars",
        description="""Aircraft hangars//Flugzeug-Hallen""",
    )

    dfg_9060_3 = VocabularyTerm(
        code="DFG_9060_3",
        label="9060 Garages",
        description="""Garages//Garagen""",
    )

    dfg_9060_4 = VocabularyTerm(
        code="DFG_9060_4",
        label="9060 Hangars",
        description="""Hangars//Hangars""",
    )

    dfg_9060_5 = VocabularyTerm(
        code="DFG_9060_5",
        label="9060 Sheds",
        description="""Sheds//Schuppen""",
    )

    dfg_9070_1 = VocabularyTerm(
        code="DFG_9070_1",
        label="9070 Outdoor lighting",
        description="""Outdoor lighting//Außenbeleuchtung""",
    )

    dfg_9070_2 = VocabularyTerm(
        code="DFG_9070_2",
        label="9070 Air traffic control lighting",
        description="""Air traffic control lighting//Flugsicherungs-Beleuchtung""",
    )

    dfg_9090_1 = VocabularyTerm(
        code="DFG_9090_1",
        label="9090 Other fixed assets (except 9000-9080)",
        description="""Other fixed assets (except 9000-9080)//Anlagevermögen, sonstiges (außer 9000-9080)""",
    )

    dfg_9090_2 = VocabularyTerm(
        code="DFG_9090_2",
        label="9090 Immovable fixed assets (except 9000-9080)",
        description="""Immovable fixed assets (except 9000-9080)//Unbewegliches Anlagevermögen (außer 9000-9080)""",
    )

    dfg_9100_1 = VocabularyTerm(
        code="DFG_9100_1",
        label="9100 Storage tables (on castors)",
        description="""Storage tables (on castors)//Abstelltische (auf Rollen)""",
    )

    dfg_9100_2 = VocabularyTerm(
        code="DFG_9100_2",
        label="9100 Work tables",
        description="""Work tables//Arbeitstische""",
    )

    dfg_9100_3 = VocabularyTerm(
        code="DFG_9100_3",
        label="9100 Side tables",
        description="""Side tables//Beistelltische""",
    )

    dfg_9100_4 = VocabularyTerm(
        code="DFG_9100_4",
        label="9100 Conference tables",
        description="""Conference tables//Besprechungstische""",
    )

    dfg_9100_5 = VocabularyTerm(
        code="DFG_9100_5",
        label="9100 Machine tables",
        description="""Machine tables//Maschinentische""",
    )

    dfg_9100_6 = VocabularyTerm(
        code="DFG_9100_6",
        label="9100 Tables on castors",
        description="""Tables on castors//Rolltische""",
    )

    dfg_9100_7 = VocabularyTerm(
        code="DFG_9100_7",
        label="9100 Tables, general",
        description="""Tables, general//Tische, allgemein""",
    )

    dfg_9100_8 = VocabularyTerm(
        code="DFG_9100_8",
        label="9100 Drawing tables",
        description="""Drawing tables//Zeichentische""",
    )

    dfg_9110_1 = VocabularyTerm(
        code="DFG_9110_1",
        label="9110 Bro machine tables",
        description="""Bro machine tables//Büro-Maschinentische""",
    )

    dfg_9110_2 = VocabularyTerm(
        code="DFG_9110_2",
        label="9110 Typewriter tables",
        description="""Typewriter tables//Schreibmaschinentische""",
    )

    dfg_9110_3 = VocabularyTerm(
        code="DFG_9110_3",
        label="9110 Writing tables",
        description="""Writing tables//Schreibtische""",
    )

    dfg_9120_1 = VocabularyTerm(
        code="DFG_9120_1",
        label="9120 Work chairs",
        description="""Work chairs//Arbeitsstühle""",
    )

    dfg_9120_2 = VocabularyTerm(
        code="DFG_9120_2",
        label="9120 Armrests for work chairs",
        description="""Armrests for work chairs//Armlehnen für Arbeitsstühle""",
    )

    dfg_9120_3 = VocabularyTerm(
        code="DFG_9120_3",
        label="9120 benches",
        description="""benches//Bänke""",
    )

    dfg_9120_4 = VocabularyTerm(
        code="DFG_9120_4",
        label="9120 Swivel chairs (also underframe)",
        description="""Swivel chairs (also underframe)//Drehsessel (auch Untergestell)""",
    )

    dfg_9120_5 = VocabularyTerm(
        code="DFG_9120_5",
        label="9120 Stool",
        description="""Stool//Hocker""",
    )

    dfg_9120_6 = VocabularyTerm(
        code="DFG_9120_6",
        label="9120 Desk chair",
        description="""Desk chair//Schreibtischsessel""",
    )

    dfg_9120_7 = VocabularyTerm(
        code="DFG_9120_7",
        label="9120 Armchair",
        description="""Armchair//Sessel""",
    )

    dfg_9120_8 = VocabularyTerm(
        code="DFG_9120_8",
        label="9120 Seats (chairs, benches)",
        description="""Seats (chairs, benches)//Sitzmöbel (Stühle, Bänke)""",
    )

    dfg_9130_1 = VocabularyTerm(
        code="DFG_9130_1",
        label="9130 Filing cabinets",
        description="""Filing cabinets//Aktenschränke""",
    )

    dfg_9130_2 = VocabularyTerm(
        code="DFG_9130_2",
        label="9130 Beds and couches (except hospital beds 9300)",
        description="""Beds and couches (except hospital beds 9300)//Betten und Liegemöbel (außer Krankenbetten 9300)""",
    )

    dfg_9130_3 = VocabularyTerm(
        code="DFG_9130_3",
        label="9130 Couch sets",
        description="""Couch sets//Couchgarnituren""",
    )

    dfg_9130_4 = VocabularyTerm(
        code="DFG_9130_4",
        label="9130 Built-in frames (for cupboards), built-in furniture",
        description="""Built-in frames (for cupboards), built-in furniture//Einbaurahmen (für Schränke), Einbaumöbel""",
    )

    dfg_9130_5 = VocabularyTerm(
        code="DFG_9130_5",
        label="9130 Built-in cupboards",
        description="""Built-in cupboards//Einbauschränke""",
    )

    dfg_9130_6 = VocabularyTerm(
        code="DFG_9130_6",
        label="9130 Wooden shelves",
        description="""Wooden shelves//Holzregale""",
    )

    dfg_9130_7 = VocabularyTerm(
        code="DFG_9130_7",
        label="9130 Wardrobes",
        description="""Wardrobes//Kleiderschränke""",
    )

    dfg_9130_8 = VocabularyTerm(
        code="DFG_9130_8",
        label="9130 Chests of drawers",
        description="""Chests of drawers//Kommoden""",
    )

    dfg_9130_9 = VocabularyTerm(
        code="DFG_9130_9",
        label="9130 Space-saving beds",
        description="""Space-saving beds//Raumsparbetten""",
    )

    dfg_9130_10 = VocabularyTerm(
        code="DFG_9130_10",
        label="9130 Roller wardrobes",
        description="""Roller wardrobes//Rollschränke""",
    )

    dfg_9130_11 = VocabularyTerm(
        code="DFG_9130_11",
        label="9130 Cupboard supports, tops",
        description="""Cupboard supports, tops//Schrankuntersätze, -aufsätze""",
    )

    dfg_9130_12 = VocabularyTerm(
        code="DFG_9130_12",
        label="9130 Wardrobe walls",
        description="""Wardrobe walls//Schrankwände""",
    )

    dfg_9130_13 = VocabularyTerm(
        code="DFG_9130_13",
        label="9130 Lockers",
        description="""Lockers//Spinde""",
    )

    dfg_9130_14 = VocabularyTerm(
        code="DFG_9130_14",
        label="9130 Steel cabinets",
        description="""Steel cabinets//Stahlschränke""",
    )

    dfg_9130_15 = VocabularyTerm(
        code="DFG_9130_15",
        label="9130 Cabinets",
        description="""Cabinets//Unterschränke""",
    )

    dfg_9140_1 = VocabularyTerm(
        code="DFG_9140_1",
        label="9140 Cabinets, shelving, library equipment (except laboratory cabinets 9480)",
        description="""Cabinets, shelving, library equipment (except laboratory cabinets 9480)//Schränke, Regale, Bibliothekseinrichtungen (außer Laborschränke 9480)""",
    )

    dfg_9150_1 = VocabularyTerm(
        code="DFG_9150_1",
        label="9150 File trolleys",
        description="""File trolleys//Aktenwagen""",
    )

    dfg_9150_2 = VocabularyTerm(
        code="DFG_9150_2",
        label="9150 Book shelves, book racks, magazine displays",
        description="""Book shelves, book racks, magazine displays//Bücherborde, Bücherregale, Zeitschriftenauslagen""",
    )

    dfg_9150_3 = VocabularyTerm(
        code="DFG_9150_3",
        label="9150 Furniture",
        description="""Furniture//Fußbänke""",
    )

    dfg_9150_4 = VocabularyTerm(
        code="DFG_9150_4",
        label="9150 Cloakroom equipment",
        description="""Cloakroom equipment//Garderobeeinrichtungen""",
    )

    dfg_9150_5 = VocabularyTerm(
        code="DFG_9150_5",
        label="9150 Cloakroom stands",
        description="""Cloakroom stands//Garderobenständer""",
    )

    dfg_9150_6 = VocabularyTerm(
        code="DFG_9150_6",
        label="9150 Hat hooks",
        description="""Hat hooks//Huthaken""",
    )

    dfg_9150_7 = VocabularyTerm(
        code="DFG_9150_7",
        label="9150 Coat hooks",
        description="""Coat hooks//Kleiderhaken""",
    )

    dfg_9150_8 = VocabularyTerm(
        code="DFG_9150_8",
        label="9150 Coat racks",
        description="""Coat racks//Kleiderständer""",
    )

    dfg_9150_9 = VocabularyTerm(
        code="DFG_9150_9",
        label="9150 Podiums",
        description="""Podiums//Podien""",
    )

    dfg_9150_10 = VocabularyTerm(
        code="DFG_9150_10",
        label="9150 Projector tables",
        description="""Projector tables//Projektortische""",
    )

    dfg_9150_11 = VocabularyTerm(
        code="DFG_9150_11",
        label="9150 Roller stands",
        description="""Roller stands//Rollböcke""",
    )

    dfg_9150_12 = VocabularyTerm(
        code="DFG_9150_12",
        label="9150 Mirrors (for wardrobes)",
        description="""Mirrors (for wardrobes)//Spiegel (für Garderoberäume)""",
    )

    dfg_9150_13 = VocabularyTerm(
        code="DFG_9150_13",
        label="9150 Standing desks",
        description="""Standing desks//Stehpulte""",
    )

    dfg_9150_14 = VocabularyTerm(
        code="DFG_9150_14",
        label="9150 Stands",
        description="""Stands//Stellwände""",
    )

    dfg_9150_15 = VocabularyTerm(
        code="DFG_9150_15",
        label="9150 Step stools (Kik-Step)",
        description="""Step stools (Kik-Step)//Tritthocker (Elefantenfüße, Kik-Step)""",
    )

    dfg_9150_16 = VocabularyTerm(
        code="DFG_9150_16",
        label="9150 Display cabinets",
        description="""Display cabinets//Vitrinen""",
    )

    dfg_9150_17 = VocabularyTerm(
        code="DFG_9150_17",
        label="9150 Ballot boxes",
        description="""Ballot boxes//Wahlurnen""",
    )

    dfg_9160_1 = VocabularyTerm(
        code="DFG_9160_1",
        label="9160 Small pedestals, file stands, desks",
        description="""Small pedestals, file stands, desks//Kleinmöbel, Aktenständer, Pulte""",
    )

    dfg_9170_1 = VocabularyTerm(
        code="DFG_9170_1",
        label="9170 Mobile luminaires and special lighting units",
        description="""Mobile luminaires and special lighting units//Bewegliche Leuchten und spezielle Beleuchtungskörper""",
    )

    dfg_9170_2 = VocabularyTerm(
        code="DFG_9170_2",
        label="9170 Hand lamps",
        description="""Hand lamps//Handlampen""",
    )

    dfg_9170_3 = VocabularyTerm(
        code="DFG_9170_3",
        label="9170 Chandeliers",
        description="""Chandeliers//Kronleuchter""",
    )

    dfg_9170_4 = VocabularyTerm(
        code="DFG_9170_4",
        label="9170 Desk lamps",
        description="""Desk lamps//Schreibtischlampen""",
    )

    dfg_9170_5 = VocabularyTerm(
        code="DFG_9170_5",
        label="9170 Swivel lamps",
        description="""Swivel lamps//Schwenklampen""",
    )

    dfg_9170_6 = VocabularyTerm(
        code="DFG_9170_6",
        label="9170 Floor lamps",
        description="""Floor lamps//Stehlampen""",
    )

    dfg_9180_1 = VocabularyTerm(
        code="DFG_9180_1",
        label="9180 Flags, banners",
        description="""Flags, banners//Fahnen, Flaggen""",
    )

    dfg_9180_2 = VocabularyTerm(
        code="DFG_9180_2",
        label="9180 Art objects, pictures, sacral objects",
        description="""Art objects, pictures, sacral objects//Kunstgegenstände, Bilder, sakrale Gegenstände""",
    )

    dfg_9190_1 = VocabularyTerm(
        code="DFG_9190_1",
        label="9190 Cover plates",
        description="""Cover plates//Abdeckplatten""",
    )

    dfg_9190_2 = VocabularyTerm(
        code="DFG_9190_2",
        label="9190 Check-in counters",
        description="""Check-in counters//Abfertigungsschalter""",
    )

    dfg_9190_3 = VocabularyTerm(
        code="DFG_9190_3",
        label="9190 Bedding chests",
        description="""Bedding chests//Bettzeug-Truhen""",
    )

    dfg_9190_4 = VocabularyTerm(
        code="DFG_9190_4",
        label="9190 Decorative objects, room decoration",
        description="""Decorative objects, room decoration//Dekorations-Gegenstände, Raumdekoration""",
    )

    dfg_9190_5 = VocabularyTerm(
        code="DFG_9190_5",
        label="9190 Furnishing objects",
        description="""Furnishing objects//Einrichtungsgegenstände""",
    )

    dfg_9190_6 = VocabularyTerm(
        code="DFG_9190_6",
        label="9190 Venetian blinds",
        description="""Venetian blinds//Jalousetten""",
    )

    dfg_9190_7 = VocabularyTerm(
        code="DFG_9190_7",
        label="9190 Concept holders",
        description="""Concept holders//Konzepthalter""",
    )

    dfg_9190_8 = VocabularyTerm(
        code="DFG_9190_8",
        label="9190 Trolleys",
        description="""Trolleys//Rollwagen""",
    )

    dfg_9190_9 = VocabularyTerm(
        code="DFG_9190_9",
        label="9190 Sound-absorbing bonnets for bromine machines",
        description="""Sound-absorbing bonnets for bromine machines//Schallschluckhauben für Büromaschinen""",
    )

    dfg_9190_10 = VocabularyTerm(
        code="DFG_9190_10",
        label="9190 Key boxes",
        description="""Key boxes//Schlüsselkästen""",
    )

    dfg_9190_11 = VocabularyTerm(
        code="DFG_9190_11",
        label="9190 Other general furniture and room furnishings",
        description="""Other general furniture and room furnishings//Sonstiges allgemeines Mobiliar und Raumausstattung""",
    )

    dfg_9190_12 = VocabularyTerm(
        code="DFG_9190_12",
        label="9190 Carpets, skins",
        description="""Carpets, skins//Teppiche, Felle""",
    )

    dfg_9190_13 = VocabularyTerm(
        code="DFG_9190_13",
        label="9190 Changing rooms",
        description="""Changing rooms//Umkleidekabinen""",
    )

    dfg_9190_14 = VocabularyTerm(
        code="DFG_9190_14",
        label="9190 Blackout roller blinds, curtains",
        description="""Blackout roller blinds, curtains//Verdunkelungs-Rollos, -Vorhänge""",
    )

    dfg_9190_15 = VocabularyTerm(
        code="DFG_9190_15",
        label="9190 Curtains",
        description="""Curtains//Vorhänge""",
    )

    dfg_9190_16 = VocabularyTerm(
        code="DFG_9190_16",
        label="9190 Voting booths, urns",
        description="""Voting booths, urns//Wahlkabinen, -urnen""",
    )

    dfg_9200_1 = VocabularyTerm(
        code="DFG_9200_1",
        label="9200 Braille machines",
        description="""Braille machines//Blindenschriftmaschinen""",
    )

    dfg_9200_2 = VocabularyTerm(
        code="DFG_9200_2",
        label="9200 Ballpoint (typewriter) heads",
        description="""Ballpoint (typewriter) heads//Kugelköpfe (Schreibmaschinen-)""",
    )

    dfg_9200_3 = VocabularyTerm(
        code="DFG_9200_3",
        label="9200 Typewriters",
        description="""Typewriters//Schreibmaschinen""",
    )

    dfg_9200_4 = VocabularyTerm(
        code="DFG_9200_4",
        label="9200 Shorthand machines",
        description="""Shorthand machines//Stenographiemaschinen""",
    )

    dfg_9210_1 = VocabularyTerm(
        code="DFG_9210_1",
        label="9210 Lettering machines (except 2070 for metal)",
        description="""Lettering machines (except 2070 for metal)//Beschriftungsmaschinen (außer 2070 für Metall)""",
    )

    dfg_9210_2 = VocabularyTerm(
        code="DFG_9210_2",
        label="9210 Magnetic tape typewriters (automatic typewriters)",
        description="""Magnetic tape typewriters (automatic typewriters)//Magnetbandschreibmaschinen (-schreibautomaten)""",
    )

    dfg_9210_3 = VocabularyTerm(
        code="DFG_9210_3",
        label="9210 Magnetic card recorders (automatic)",
        description="""Magnetic card recorders (automatic)//Magnetkartenschreiber (-schreibautomaten)""",
    )

    dfg_9210_4 = VocabularyTerm(
        code="DFG_9210_4",
        label="9210 Embossing machines (bro-)",
        description="""Embossing machines (bro-)//Prägemaschinen (Büro-)""",
    )

    dfg_9210_5 = VocabularyTerm(
        code="DFG_9210_5",
        label="9210 Automatic writing and organising machines, addressing machines",
        description="""Automatic writing and organising machines, addressing machines//Schreib- und Organisationsautomaten, Adressiermaschinen""",
    )

    dfg_9210_6 = VocabularyTerm(
        code="DFG_9210_6",
        label="9210 Punching machines (bro-)",
        description="""Punching machines (bro-)//Stanzmaschinen (Büro-)""",
    )

    dfg_9220_1 = VocabularyTerm(
        code="DFG_9220_1",
        label="9220 Accounting machines, cash registers, franking machines",
        description="""Accounting machines, cash registers, franking machines//Buchungsmaschinen, Registrierkassen, Frankiermaschinen""",
    )

    dfg_9220_2 = VocabularyTerm(
        code="DFG_9220_2",
        label="9220 Receipt machines",
        description="""Receipt machines//Quittungsmaschinen""",
    )

    dfg_9220_3 = VocabularyTerm(
        code="DFG_9220_3",
        label="9220 Stamping machines",
        description="""Stamping machines//Stempelmaschinen""",
    )

    dfg_9230_1 = VocabularyTerm(
        code="DFG_9230_1",
        label="9230 Dictating machines",
        description="""Dictating machines//Diktiergeräte""",
    )

    dfg_9230_2 = VocabularyTerm(
        code="DFG_9230_2",
        label="9230 Pocket dictation machines",
        description="""Pocket dictation machines//Taschendiktiergeräte""",
    )

    dfg_9230_3 = VocabularyTerm(
        code="DFG_9230_3",
        label="9230 Playback machines (dictation machines)",
        description="""Playback machines (dictation machines)//Wiedergabegeräte (Diktiergeräte)""",
    )

    dfg_9240_1 = VocabularyTerm(
        code="DFG_9240_1",
        label="9240 Card indexing machines",
        description="""Card indexing machines//Hängeregistraturen""",
    )

    dfg_9240_2 = VocabularyTerm(
        code="DFG_9240_2",
        label="9240 Card indexes, filing cabinets",
        description="""Card indexes, filing cabinets//Karteigeräte, Registraturen""",
    )

    dfg_9240_3 = VocabularyTerm(
        code="DFG_9240_3",
        label="9240 Card index boxes, cabinets, desks",
        description="""Card index boxes, cabinets, desks//Karteikästen, -schränke, -tische""",
    )

    dfg_9240_4 = VocabularyTerm(
        code="DFG_9240_4",
        label="9240 Card-index cabinets",
        description="""Card-index cabinets//Karteischränke""",
    )

    dfg_9240_5 = VocabularyTerm(
        code="DFG_9240_5",
        label="9240 Card index tables",
        description="""Card index tables//Karteitische""",
    )

    dfg_9240_6 = VocabularyTerm(
        code="DFG_9240_6",
        label="9240 Compact systems for files and books",
        description="""Compact systems for files and books//Kompaktanlagen für Akten und Bücher""",
    )

    dfg_9250_1 = VocabularyTerm(
        code="DFG_9250_1",
        label="9250 Drawing tools, drawing boards",
        description="""Drawing tools, drawing boards//Reißzeuge, Reißbretter""",
    )

    dfg_9250_2 = VocabularyTerm(
        code="DFG_9250_2",
        label="9250 Drawing instruments and aids",
        description="""Drawing instruments and aids//Zeichengeräte und -hilfsmittel""",
    )

    dfg_9250_3 = VocabularyTerm(
        code="DFG_9250_3",
        label="9250 Drawing machines and drawing aids (except computer-controlled 7450)",
        description="""Drawing machines and drawing aids (except computer-controlled 7450)//Zeichenmaschinen und -geräte (außer rechnergesteuert 7450)""",
    )

    dfg_9260_1 = VocabularyTerm(
        code="DFG_9260_1",
        label="9260 Bro-copying apparatus",
        description="""Bro-copying apparatus//Büro-Kopiergeräte""",
    )

    dfg_9260_2 = VocabularyTerm(
        code="DFG_9260_2",
        label="9260 Copying and tracing machines (except printing and auxiliary machines 2250 and 2260)",
        description="""Copying and tracing machines (except printing and auxiliary machines 2250 and 2260)//Kopiergeräte, Lichtpausmaschinen (außer Druckmaschinen und Hilfsgeräte 2250 und 2260)""",
    )

    dfg_9260_3 = VocabularyTerm(
        code="DFG_9260_3",
        label="9260 Off-set film exposure machines",
        description="""Off-set film exposure machines//Off-Set-Folienbelichtungsanlagen""",
    )

    dfg_9260_4 = VocabularyTerm(
        code="DFG_9260_4",
        label="9260 Transfer printers (spirit carbon, wax matrix)",
        description="""Transfer printers (spirit carbon, wax matrix)//Umdrucker (Spirit-Carbon, Wachsmatrizen-)""",
    )

    dfg_9260_5 = VocabularyTerm(
        code="DFG_9260_5",
        label="9260 Duplicating machines",
        description="""Duplicating machines//Vervielfältigungsapparate""",
    )

    dfg_9260_6 = VocabularyTerm(
        code="DFG_9260_6",
        label="9260 Xerographic copying machines",
        description="""Xerographic copying machines//Xerographie-Kopiergeräte""",
    )

    dfg_9280_1 = VocabularyTerm(
        code="DFG_9280_1",
        label="9280 Cash boxes",
        description="""Cash boxes//Geldkassetten""",
    )

    dfg_9280_2 = VocabularyTerm(
        code="DFG_9280_2",
        label="9280 Safes, special cash equipment",
        description="""Safes, special cash equipment//Tresore, spezielle Kassenausrüstung""",
    )

    dfg_9290_1 = VocabularyTerm(
        code="DFG_9290_1",
        label="9290 File transport equipment, cases, bags",
        description="""File transport equipment, cases, bags//Aktentransportmittel, -koffer, -taschen""",
    )

    dfg_9290_2 = VocabularyTerm(
        code="DFG_9290_2",
        label="9290 Document shredders",
        description="""Document shredders//Aktenvernichter""",
    )

    dfg_9290_3 = VocabularyTerm(
        code="DFG_9290_3",
        label="9290 Rewinders for drawing paper",
        description="""Rewinders for drawing paper//Aufrollvorrichtungen für Zeichenpapier""",
    )

    dfg_9290_4 = VocabularyTerm(
        code="DFG_9290_4",
        label="9290 Letter folders",
        description="""Letter folders//Brieföffner""",
    )

    dfg_9290_5 = VocabularyTerm(
        code="DFG_9290_5",
        label="9290 Bro (organisation) accessories",
        description="""Bro (organisation) accessories//Büro- (Organisations-) Zubehör""",
    )

    dfg_9290_6 = VocabularyTerm(
        code="DFG_9290_6",
        label="9290 Staplers (bro-)",
        description="""Staplers (bro-)//Heftgeräte (Büro-)""",
    )

    dfg_9290_7 = VocabularyTerm(
        code="DFG_9290_7",
        label="9290 Annual planners",
        description="""Annual planners//Jahresplaner""",
    )

    dfg_9290_8 = VocabularyTerm(
        code="DFG_9290_8",
        label="9290 Enveloping machines",
        description="""Enveloping machines//Kuvertiermaschinen""",
    )

    dfg_9290_9 = VocabularyTerm(
        code="DFG_9290_9",
        label="9290 Pagination machines",
        description="""Pagination machines//Paginiermaschinen""",
    )

    dfg_9290_10 = VocabularyTerm(
        code="DFG_9290_10",
        label="9290 Paper cranes",
        description="""Paper cranes//Papierkörbe""",
    )

    dfg_9290_11 = VocabularyTerm(
        code="DFG_9290_11",
        label="9290 Mail processing machines",
        description="""Mail processing machines//Postbearbeitungsmaschinen""",
    )

    dfg_9290_12 = VocabularyTerm(
        code="DFG_9290_12",
        label="9290 Typewriter trolleys",
        description="""Typewriter trolleys//Schreibmaschineneinzelwagen""",
    )

    dfg_9290_13 = VocabularyTerm(
        code="DFG_9290_13",
        label="9290 Other special broaching equipment",
        description="""Other special broaching equipment//Sonstige spezielle Büroeinrichtung""",
    )

    dfg_9290_14 = VocabularyTerm(
        code="DFG_9290_14",
        label="9290 Stamps",
        description="""Stamps//Stempel""",
    )

    dfg_9300_1 = VocabularyTerm(
        code="DFG_9300_1",
        label="9300 Hospital beds",
        description="""Hospital beds//Krankenbetten""",
    )

    dfg_9310_1 = VocabularyTerm(
        code="DFG_9310_1",
        label="9310 Ambulance trolleys, stretchers",
        description="""Ambulance trolleys, stretchers//Krankentransportwagen, Tragen""",
    )

    dfg_9310_2 = VocabularyTerm(
        code="DFG_9310_2",
        label="9310 Stretchers (e.g. ambulance)",
        description="""Stretchers (e.g. ambulance)//Tragen (z.B. Kranken-)""",
    )

    dfg_9320_1 = VocabularyTerm(
        code="DFG_9320_1",
        label="9320 Means of transport for medicines, food, linen in hospitals",
        description="""Means of transport for medicines, food, linen in hospitals//Transportmittel für Medikamente, Speisen, Wäsche in Kliniken""",
    )

    dfg_9330_1 = VocabularyTerm(
        code="DFG_9330_1",
        label="9330 Ambulance chairs",
        description="""Ambulance chairs//Krankenstühle""",
    )

    dfg_9330_2 = VocabularyTerm(
        code="DFG_9330_2",
        label="9330 Wheelchairs (except vehicles for the disabled 2550)",
        description="""Wheelchairs (except vehicles for the disabled 2550)//Rollstühle (außer Behinderten-Fahrzeuge 2550)""",
    )

    dfg_9330_3 = VocabularyTerm(
        code="DFG_9330_3",
        label="9330 Special chairs for the sick",
        description="""Special chairs for the sick//Spezialstühle für Kranke""",
    )

    dfg_9340_1 = VocabularyTerm(
        code="DFG_9340_1",
        label="9340 Bedside tables",
        description="""Bedside tables//Nachttische""",
    )

    dfg_9340_2 = VocabularyTerm(
        code="DFG_9340_2",
        label="9340 Special tables, bedside tables",
        description="""Special tables, bedside tables//Spezialtische, Nachttische""",
    )

    dfg_9350_1 = VocabularyTerm(
        code="DFG_9350_1",
        label="9350 Medicine cabinets, pharmacy equipment",
        description="""Medicine cabinets, pharmacy equipment//Medikamentenschränke, Apothekeneinrichtung""",
    )

    dfg_9370_1 = VocabularyTerm(
        code="DFG_9370_1",
        label="9370 Steam sterilisers",
        description="""Steam sterilisers//Dampfsterilisatoren""",
    )

    dfg_9370_2 = VocabularyTerm(
        code="DFG_9370_2",
        label="9370 Sterilisation and disinfection equipment",
        description="""Sterilisation and disinfection equipment//Sterilisations- und Desinfektionsanlagen""",
    )

    dfg_9370_3 = VocabularyTerm(
        code="DFG_9370_3",
        label="9370 Sterilisers",
        description="""Sterilisers//Sterilisatoren""",
    )

    dfg_9390_1 = VocabularyTerm(
        code="DFG_9390_1",
        label="9390 Hospital equipment, general (except 9300-9370)",
        description="""Hospital equipment, general (except 9300-9370)//Klinikeinrichtung, allgemeine (außer 9300-9370)""",
    )

    dfg_9390_2 = VocabularyTerm(
        code="DFG_9390_2",
        label="9390 Other general hospital equipment",
        description="""Other general hospital equipment//Sonstige allgemeine Klinikeinrichtung""",
    )

    dfg_9400_1 = VocabularyTerm(
        code="DFG_9400_1",
        label="9400 Workbenches, planing benches",
        description="""Workbenches, planing benches//Werktische, Hobelbänke""",
    )

    dfg_9410_1 = VocabularyTerm(
        code="DFG_9410_1",
        label="9410 Tool cabinets and trolleys, assembly boxes and trolleys",
        description="""Tool cabinets and trolleys, assembly boxes and trolleys//Werkzeugschränke und -wagen, Montagekästen und -wagen""",
    )

    dfg_9420_1 = VocabularyTerm(
        code="DFG_9420_1",
        label="9420 Construction stands",
        description="""Construction stands//Baugerüste""",
    )

    dfg_9420_2 = VocabularyTerm(
        code="DFG_9420_2",
        label="9420 Lifting platforms",
        description="""Lifting platforms//Hebebühnen""",
    )

    dfg_9420_3 = VocabularyTerm(
        code="DFG_9420_3",
        label="9420 Storage racks, special material storage equipment",
        description="""Storage racks, special material storage equipment//Lager-Gestelle, spezielle Materiallager-Einrichtungen""",
    )

    dfg_9420_4 = VocabularyTerm(
        code="DFG_9420_4",
        label="9420 Ladders, barley, racks, assembly equipment",
        description="""Ladders, barley, racks, assembly equipment//Leitern, Gerüste, Gestelle, Montagevorrichtungen""",
    )

    dfg_9420_5 = VocabularyTerm(
        code="DFG_9420_5",
        label="9420 Stands (workshop and laboratory, except 3220 and 5470)",
        description="""Stands (workshop and laboratory, except 3220 and 5470)//Stative (Werkstatt und Labor, außer 3220 und 5470)""",
    )

    dfg_9420_6 = VocabularyTerm(
        code="DFG_9420_6",
        label="9420 Struts, supports",
        description="""Struts, supports//Streben, Stützen""",
    )

    dfg_9430_1 = VocabularyTerm(
        code="DFG_9430_1",
        label="9430 Hand trolleys",
        description="""Hand trolleys//Handwagen""",
    )

    dfg_9430_2 = VocabularyTerm(
        code="DFG_9430_2",
        label="9430 Laboratory trolleys",
        description="""Laboratory trolleys//Laborwagen""",
    )

    dfg_9430_3 = VocabularyTerm(
        code="DFG_9430_3",
        label="9430 Wheelbarrows",
        description="""Wheelbarrows//Schubkarren""",
    )

    dfg_9430_4 = VocabularyTerm(
        code="DFG_9430_4",
        label="9430 Trolleys, lifting and tipping devices",
        description="""Trolleys, lifting and tipping devices//Transportkarren, Hebe- und Kippvorrichtungen""",
    )

    dfg_9440_1 = VocabularyTerm(
        code="DFG_9440_1",
        label="9440 Containers, tubs, barrels",
        description="""Containers, tubs, barrels//Behälter, Wannen, Fässer""",
    )

    dfg_9440_2 = VocabularyTerm(
        code="DFG_9440_2",
        label="9440 Containers, demijohns",
        description="""Containers, demijohns//Gebinde, Korbflaschen""",
    )

    dfg_9440_3 = VocabularyTerm(
        code="DFG_9440_3",
        label="9440 Vessels",
        description="""Vessels//Gefäße""",
    )

    dfg_9440_4 = VocabularyTerm(
        code="DFG_9440_4",
        label="9440 Canisters",
        description="""Canisters//Kanister""",
    )

    dfg_9450_1 = VocabularyTerm(
        code="DFG_9450_1",
        label="9450 Mobile Experiment Tables",
        description="""Mobile Experiment Tables//Fahrbare Experimentiertische""",
    )

    dfg_9450_2 = VocabularyTerm(
        code="DFG_9450_2",
        label="9450 Scaffolding Tables",
        description="""Scaffolding Tables//Gerätetische""",
    )

    dfg_9450_3 = VocabularyTerm(
        code="DFG_9450_3",
        label="9450 Laboratory tables and superstructures",
        description="""Laboratory tables and superstructures//Labortische und -aufbauten""",
    )

    dfg_9450_4 = VocabularyTerm(
        code="DFG_9450_4",
        label="9450 Microscopy tables",
        description="""Microscopy tables//Mikroskopiertische""",
    )

    dfg_9450_5 = VocabularyTerm(
        code="DFG_9450_5",
        label="9450 Wgetables",
        description="""Wgetables//Wägetische""",
    )

    dfg_9460_1 = VocabularyTerm(
        code="DFG_9460_1",
        label="9460 Extraction plants, laboratory fume cupboards (except isotope fume cupboards 0320)",
        description="""Extraction plants, laboratory fume cupboards (except isotope fume cupboards 0320)//Absauganlagen, Laborabzüge (außer Isotopenabzüge 0320)""",
    )

    dfg_9460_2 = VocabularyTerm(
        code="DFG_9460_2",
        label="9460 Air and gas extraction systems",
        description="""Air and gas extraction systems//Luft- und Gasabsauganlagen""",
    )

    dfg_9460_3 = VocabularyTerm(
        code="DFG_9460_3",
        label="9460 Suction equipment",
        description="""Suction equipment//Saugdüsengeräte""",
    )

    dfg_9470_1 = VocabularyTerm(
        code="DFG_9470_1",
        label="9470 Degreasing plants (steam, ultrasonic)",
        description="""Degreasing plants (steam, ultrasonic)//Entfettungsanlagen (Dampf-, Ultraschall-)""",
    )

    dfg_9470_2 = VocabularyTerm(
        code="DFG_9470_2",
        label="9470 Bottle-splitters",
        description="""Bottle-splitters//Flaschenspülgeräte""",
    )

    dfg_9470_3 = VocabularyTerm(
        code="DFG_9470_3",
        label="9470 High-Pressure Cleaners, Hot-Water High-Pressure Cleaners",
        description="""High-Pressure Cleaners, Hot-Water High-Pressure Cleaners//Hochdruck-Reiniger, Heißwasser-Hochdruckreiniger""",
    )

    dfg_9470_4 = VocabularyTerm(
        code="DFG_9470_4",
        label="9470 Laboratory splitting machines",
        description="""Laboratory splitting machines//Laborspülen""",
    )

    dfg_9470_5 = VocabularyTerm(
        code="DFG_9470_5",
        label="9470 Laboratory splitting machines and cleaning equipment",
        description="""Laboratory splitting machines and cleaning equipment//Labor-Spülmaschinen und -Reinigungsgeräte""",
    )

    dfg_9470_6 = VocabularyTerm(
        code="DFG_9470_6",
        label="9470 Pipette splitters",
        description="""Pipette splitters//Pipettenspülgeräte""",
    )

    dfg_9470_7 = VocabularyTerm(
        code="DFG_9470_7",
        label="9470 Cleaning equipment (laboratory)",
        description="""Cleaning equipment (laboratory)//Reinigungsgeräte (Labor-)""",
    )

    dfg_9470_8 = VocabularyTerm(
        code="DFG_9470_8",
        label="9470 Parts cleaning machines",
        description="""Parts cleaning machines//Teile-Reinigungsmaschinen""",
    )

    dfg_9470_9 = VocabularyTerm(
        code="DFG_9470_9",
        label="9470 Ultrasonic cleaning machines, -benders",
        description="""Ultrasonic cleaning machines, -benders//Ultraschall-Reinigungsanlagen, -Bäder""",
    )

    dfg_9470_10 = VocabularyTerm(
        code="DFG_9470_10",
        label="9470 Washing machines for laboratory glassware",
        description="""Washing machines for laboratory glassware//Waschmaschinen für Laborglas""",
    )

    dfg_9480_1 = VocabularyTerm(
        code="DFG_9480_1",
        label="9480 Laboratory cabinets, chemical cabinets",
        description="""Laboratory cabinets, chemical cabinets//Laborschränke, Chemikalien-Schränke""",
    )

    dfg_9490_1 = VocabularyTerm(
        code="DFG_9490_1",
        label="9490 Hand tools, general for machining and assembly (except measuring instruments and machines)",
        description="""Hand tools, general for machining and assembly (except measuring instruments and machines)//Handwerkzeug, allgemein für Bearbeitung und Montage (außer Messgeräte und Maschinen)""",
    )

    dfg_9490_2 = VocabularyTerm(
        code="DFG_9490_2",
        label="9490 Cable reel",
        description="""Cable reel//Kabeltrommel""",
    )

    dfg_9490_3 = VocabularyTerm(
        code="DFG_9490_3",
        label="9490 Laboratory equipment (except 9400-9480)",
        description="""Laboratory equipment (except 9400-9480)//Laborausrüstung (außer 9400-9480)""",
    )

    dfg_9490_4 = VocabularyTerm(
        code="DFG_9490_4",
        label="9490 Laboratory containers",
        description="""Laboratory containers//Laborcontainer""",
    )

    dfg_9490_5 = VocabularyTerm(
        code="DFG_9490_5",
        label="9490 Screwdrivers",
        description="""Screwdrivers//Schraubstöcke""",
    )

    dfg_9490_6 = VocabularyTerm(
        code="DFG_9490_6",
        label="9490 Other workshop and laboratory equipment, tools",
        description="""Other workshop and laboratory equipment, tools//Sonstige Werkstatt- und Laborausrüstung, Werkzeuge""",
    )

    dfg_9490_7 = VocabularyTerm(
        code="DFG_9490_7",
        label="9490 Tools, tool sets, special tools (except with mechanical drive 2000-2390)",
        description="""Tools, tool sets, special tools (except with mechanical drive 2000-2390)//Werkzeuge, Werkzeugsätze, Spezialwerkzeug (außer mit maschinellem Antrieb 2000-2390)""",
    )

    dfg_9500_1 = VocabularyTerm(
        code="DFG_9500_1",
        label="9500 Deep fat fryers, large",
        description="""Deep fat fryers, large//Friteusen, Groß-""",
    )

    dfg_9500_2 = VocabularyTerm(
        code="DFG_9500_2",
        label="9500 Cookers",
        description="""Cookers//Herde""",
    )

    dfg_9500_3 = VocabularyTerm(
        code="DFG_9500_3",
        label="9500 Cooking, baking and roasting equipment",
        description="""Cooking, baking and roasting equipment//Koch-, Back- und Bratanlagen""",
    )

    dfg_9500_4 = VocabularyTerm(
        code="DFG_9500_4",
        label="9500 Microwave ovens",
        description="""Microwave ovens//Mikrowellen-Herde""",
    )

    dfg_9510_1 = VocabularyTerm(
        code="DFG_9510_1",
        label="9510 Work pans (kitchen)",
        description="""Work pans (kitchen)//Arbeitswannen (Küchen-)""",
    )

    dfg_9510_2 = VocabularyTerm(
        code="DFG_9510_2",
        label="9510 Canning machines (kitchen), can openers",
        description="""Canning machines (kitchen), can openers//Dosenverschließmaschinen (Küche), Dosenöffner""",
    )

    dfg_9510_3 = VocabularyTerm(
        code="DFG_9510_3",
        label="9510 Electric kitchen appliances (except 9500, 9530 and 9550)",
        description="""Electric kitchen appliances (except 9500, 9530 and 9550)//Elektrische Küchengeräte (außer 9500, 9530 und 9550)""",
    )

    dfg_9510_4 = VocabularyTerm(
        code="DFG_9510_4",
        label="9510 Meat grinders",
        description="""Meat grinders//Fleischwölfe""",
    )

    dfg_9510_5 = VocabularyTerm(
        code="DFG_9510_5",
        label="9510 Kitchen machines and special kitchen appliances",
        description="""Kitchen machines and special kitchen appliances//Küchenmaschinen und spezielle Küchengeräte""",
    )

    dfg_9530_1 = VocabularyTerm(
        code="DFG_9530_1",
        label="9530 Dishwashing and drying appliances",
        description="""Dishwashing and drying appliances//Geschirrspül- und -trockengeräte""",
    )

    dfg_9530_2 = VocabularyTerm(
        code="DFG_9530_2",
        label="9530 Automatic dishwashers (kitchen)",
        description="""Automatic dishwashers (kitchen)//Spülautomaten (Küchen-)""",
    )

    dfg_9530_3 = VocabularyTerm(
        code="DFG_9530_3",
        label="9530 Dishwashing tables (also underframe)",
        description="""Dishwashing tables (also underframe)//Spültische (auch Unterbau)""",
    )

    dfg_9530_4 = VocabularyTerm(
        code="DFG_9530_4",
        label="9530 Dish dryers (kitchen)",
        description="""Dish dryers (kitchen)//Trockner für Geschirr (Küchen-)""",
    )

    dfg_9540_1 = VocabularyTerm(
        code="DFG_9540_1",
        label="9540 Shop fittings",
        description="""Shop fittings//Ladeneinrichtungen""",
    )

    dfg_9540_2 = VocabularyTerm(
        code="DFG_9540_2",
        label="9540 Counters",
        description="""Counters//Theken""",
    )

    dfg_9540_3 = VocabularyTerm(
        code="DFG_9540_3",
        label="9540 Display counters (shop)",
        description="""Display counters (shop)//Warenständer (Laden)""",
    )

    dfg_9550_1 = VocabularyTerm(
        code="DFG_9550_1",
        label="9550 Sideboards (kitchen)",
        description="""Sideboards (kitchen)//Anrichten (Küchen-)""",
    )

    dfg_9550_2 = VocabularyTerm(
        code="DFG_9550_2",
        label="9550 Coffee and tea equipment, beverage preparation, refrigerated display cases",
        description="""Coffee and tea equipment, beverage preparation, refrigerated display cases//Büffeteinrichtungen, Getränkezubereitung, Kühlvitrinen""",
    )

    dfg_9550_3 = VocabularyTerm(
        code="DFG_9550_3",
        label="9550 Beverage dispensers, vending machines",
        description="""Beverage dispensers, vending machines//Getränkespender, Automaten""",
    )

    dfg_9550_4 = VocabularyTerm(
        code="DFG_9550_4",
        label="9550 Beverage trolleys",
        description="""Beverage trolleys//Getränkewagen""",
    )

    dfg_9550_5 = VocabularyTerm(
        code="DFG_9550_5",
        label="9550 Snack trolleys",
        description="""Snack trolleys//Imbisswagen""",
    )

    dfg_9550_6 = VocabularyTerm(
        code="DFG_9550_6",
        label="9550 Coffee pots",
        description="""Coffee pots//Kaffeekannen""",
    )

    dfg_9550_7 = VocabularyTerm(
        code="DFG_9550_7",
        label="9550 Coffee machines",
        description="""Coffee machines//Kaffeemaschinen""",
    )

    dfg_9550_8 = VocabularyTerm(
        code="DFG_9550_8",
        label="9550 Food warmers",
        description="""Food warmers//Speisenwärmer""",
    )

    dfg_9550_9 = VocabularyTerm(
        code="DFG_9550_9",
        label="9550 Transport belts for coffee equipment",
        description="""Transport belts for coffee equipment//Transportbänder für Büffeteinrichtungen""",
    )

    dfg_9560_1 = VocabularyTerm(
        code="DFG_9560_1",
        label="9560 Vending machines, money changers",
        description="""Vending machines, money changers//Verkaufsautomaten, Geldwechselautomaten""",
    )

    dfg_9570_1 = VocabularyTerm(
        code="DFG_9570_1",
        label="9570 Serving trolleys",
        description="""Serving trolleys//Servierwagen""",
    )

    dfg_9580_1 = VocabularyTerm(
        code="DFG_9580_1",
        label="9580 Food Storage Rooms and Warehouses",
        description="""Food Storage Rooms and Warehouses//Kühlräume und Vorratslager für Lebensmittel""",
    )

    dfg_9590_1 = VocabularyTerm(
        code="DFG_9590_1",
        label="9590 Other kitchen and casino equipment",
        description="""Other kitchen and casino equipment//Sonstige Küchen- und Kasino- Einrichtungen""",
    )

    dfg_9600_1 = VocabularyTerm(
        code="DFG_9600_1",
        label="9600 Washing machines and vending machines",
        description="""Washing machines and vending machines//Waschmaschinen und -automaten""",
    )

    dfg_9610_1 = VocabularyTerm(
        code="DFG_9610_1",
        label="9610 Washing extractors, centrifuges",
        description="""Washing extractors, centrifuges//Wäscheschleudern, -zentrifugen""",
    )

    dfg_9610_2 = VocabularyTerm(
        code="DFG_9610_2",
        label="9610 Laundry dryers",
        description="""Laundry dryers//Wäschetrockengeräte""",
    )

    dfg_9620_1 = VocabularyTerm(
        code="DFG_9620_1",
        label="9620 Ironers and ironing machines",
        description="""Ironers and ironing machines//Bügelgeräte und -maschinen""",
    )

    dfg_9620_2 = VocabularyTerm(
        code="DFG_9620_2",
        label="9620 Heated ironers",
        description="""Heated ironers//Heißmangeln""",
    )

    dfg_9630_1 = VocabularyTerm(
        code="DFG_9630_1",
        label="9630 Sewing machines (household sewing machines)",
        description="""Sewing machines (household sewing machines)//Nähmaschinen (Haushalt-Nähmaschinen)""",
    )

    dfg_9640_1 = VocabularyTerm(
        code="DFG_9640_1",
        label="9640 Work clothes, uniforms, protective clothing",
        description="""Work clothes, uniforms, protective clothing//Arbeitskleidung, Dienstkleidung, Schutzkleidung""",
    )

    dfg_9640_2 = VocabularyTerm(
        code="DFG_9640_2",
        label="9640 Protective clothing (except X-ray radiation protection 3280)",
        description="""Protective clothing (except X-ray radiation protection 3280)//Schutzkleidung (außer Röntgen-Strahlenschutz 3280)""",
    )

    dfg_9640_3 = VocabularyTerm(
        code="DFG_9640_3",
        label="9640 Protective masks (except breathing apparatus 9880)",
        description="""Protective masks (except breathing apparatus 9880)//Schutzmasken (außer Atemgeräte 9880)""",
    )

    dfg_9650_1 = VocabularyTerm(
        code="DFG_9650_1",
        label="9650 Vacuum sweepers",
        description="""Vacuum sweepers//Kehrsaugmaschinen""",
    )

    dfg_9650_2 = VocabularyTerm(
        code="DFG_9650_2",
        label="9650 Room-care equipment (hoovers, floor polishers)",
        description="""Room-care equipment (hoovers, floor polishers)//Raumpflegegeräte (Staubsauger, Bohnermaschinen)""",
    )

    dfg_9650_3 = VocabularyTerm(
        code="DFG_9650_3",
        label="9650 Carpet shampooing equipment",
        description="""Carpet shampooing equipment//Teppich-Shampooniergeräte""",
    )

    dfg_9670_1 = VocabularyTerm(
        code="DFG_9670_1",
        label="9670 Water heaters, boilers (except 9830)",
        description="""Water heaters, boilers (except 9830)//Heißwasserspeicher, -Boiler (außer 9830)""",
    )

    dfg_9670_2 = VocabularyTerm(
        code="DFG_9670_2",
        label="9670 Hot water generators (storage tanks, instantaneous water heaters, bathing furnaces)",
        description="""Hot water generators (storage tanks, instantaneous water heaters, bathing furnaces)//Warmwassererzeuger (Speicher, Durchlauferhitzer, Badeöfen)""",
    )

    dfg_9680_1 = VocabularyTerm(
        code="DFG_9680_1",
        label="9680 Bathing equipment (except special medical baths 3960)",
        description="""Bathing equipment (except special medical baths 3960)//Badeeinrichtungen, -betriebsgeräte (außer spezielle medizinische Bäder 3960)""",
    )

    dfg_9680_2 = VocabularyTerm(
        code="DFG_9680_2",
        label="9680 Furnishings for sanitary rooms and appliances for body care",
        description="""Furnishings for sanitary rooms and appliances for body care//Einrichtungsgegenstände für sanitäre Räume und Geräte für Körperpflege""",
    )

    dfg_9680_3 = VocabularyTerm(
        code="DFG_9680_3",
        label="9680 Hair clippers",
        description="""Hair clippers//Haarschneidemaschinen""",
    )

    dfg_9680_4 = VocabularyTerm(
        code="DFG_9680_4",
        label="9680 Hand dryers",
        description="""Hand dryers//Händetrockner""",
    )

    dfg_9680_5 = VocabularyTerm(
        code="DFG_9680_5",
        label="9680 Towel holders, dispensers",
        description="""Towel holders, dispensers//Handtuchhalter, -spender""",
    )

    dfg_9680_6 = VocabularyTerm(
        code="DFG_9680_6",
        label="9680 Towel dispensers",
        description="""Towel dispensers//Handtuchspender""",
    )

    dfg_9680_7 = VocabularyTerm(
        code="DFG_9680_7",
        label="9680 Sanitary equipment",
        description="""Sanitary equipment//Sanitäre Einrichtungsgegenstände""",
    )

    dfg_9680_8 = VocabularyTerm(
        code="DFG_9680_8",
        label="9680 Sauna equipment",
        description="""Sauna equipment//Sauna-Einrichtungen""",
    )

    dfg_9690_1 = VocabularyTerm(
        code="DFG_9690_1",
        label="9690 Cage cleaning machines",
        description="""Cage cleaning machines//Käfigreinigungsmaschinen""",
    )

    dfg_9690_2 = VocabularyTerm(
        code="DFG_9690_2",
        label="9690 Other laundry and cleaning equipment",
        description="""Other laundry and cleaning equipment//Sonstige Geräte für Wäscherei und Reinigung""",
    )

    dfg_9690_3 = VocabularyTerm(
        code="DFG_9690_3",
        label="9690 Laundry boxes",
        description="""Laundry boxes//Wäschekisten""",
    )

    dfg_9700_1 = VocabularyTerm(
        code="DFG_9700_1",
        label="9700 Films (educational, informational)",
        description="""Films (educational, informational)//Filme (Lehrfilme, Information)""",
    )

    dfg_9700_2 = VocabularyTerm(
        code="DFG_9700_2",
        label="9700 Teaching aids, slides, educational films (except 6700-6790)",
        description="""Teaching aids, slides, educational films (except 6700-6790)//Lehrmittel, Diapositive, Lehrfilme (außer 6700-6790)""",
    )

    dfg_9700_3 = VocabularyTerm(
        code="DFG_9700_3",
        label="9700 Charts, educational boards",
        description="""Charts, educational boards//Schaubilder, Lehrtafeln""",
    )

    dfg_9700_4 = VocabularyTerm(
        code="DFG_9700_4",
        label="9700 Wall maps, maps",
        description="""Wall maps, maps//Wandkarten, Landkarten""",
    )

    dfg_9710_1 = VocabularyTerm(
        code="DFG_9710_1",
        label="9710 Demonstration apparatus, models",
        description="""Demonstration apparatus, models//Demonstrationsgeräte, Modelle""",
    )

    dfg_9710_2 = VocabularyTerm(
        code="DFG_9710_2",
        label="9710 Molekl models, model kits",
        description="""Molekl models, model kits//Molekül-Modelle, -Modell-Baukästen""",
    )

    dfg_9720_1 = VocabularyTerm(
        code="DFG_9720_1",
        label="9720 Electric musical instruments",
        description="""Electric musical instruments//Elektrische Musikinstrumente""",
    )

    dfg_9720_2 = VocabularyTerm(
        code="DFG_9720_2",
        label="9720 Metronomes",
        description="""Metronomes//Metronome""",
    )

    dfg_9720_3 = VocabularyTerm(
        code="DFG_9720_3",
        label="9720 Musical instruments and accessories",
        description="""Musical instruments and accessories//Musikinstrumente und Zubehör""",
    )

    dfg_9730_1 = VocabularyTerm(
        code="DFG_9730_1",
        label="9730 Office boards",
        description="""Office boards//Büro-Tafeln""",
    )

    dfg_9730_2 = VocabularyTerm(
        code="DFG_9730_2",
        label="9730 Information boards and aids, signposts",
        description="""Information boards and aids, signposts//Informationstafeln und -hilfsmittel, Wegweiser""",
    )

    dfg_9730_3 = VocabularyTerm(
        code="DFG_9730_3",
        label="9730 Blackboard stands",
        description="""Blackboard stands//Tafelstative""",
    )

    dfg_9730_4 = VocabularyTerm(
        code="DFG_9730_4",
        label="9730 Blackboards, map stands, projection screens",
        description="""Blackboards, map stands, projection screens//Wandtafeln, Kartenständer, Projektionswände""",
    )

    dfg_9740_1 = VocabularyTerm(
        code="DFG_9740_1",
        label="9740 Expedition and travel equipment",
        description="""Expedition and travel equipment//Expeditions- und Reiseausrüstung""",
    )

    dfg_9740_2 = VocabularyTerm(
        code="DFG_9740_2",
        label="9740 Wooden crates (for expeditions)",
        description="""Wooden crates (for expeditions)//Holzkästen (für Expeditionen)""",
    )

    dfg_9740_3 = VocabularyTerm(
        code="DFG_9740_3",
        label="9740 Storage equipment (for expeditions)",
        description="""Storage equipment (for expeditions)//Lagerausrüstungen (für Expeditionen)""",
    )

    dfg_9740_4 = VocabularyTerm(
        code="DFG_9740_4",
        label="9740 Metal crates (for expeditions)",
        description="""Metal crates (for expeditions)//Metallkästen (für Expeditionen)""",
    )

    dfg_9740_5 = VocabularyTerm(
        code="DFG_9740_5",
        label="9740 Travel equipment",
        description="""Travel equipment//Reiseausrüstungen""",
    )

    dfg_9740_6 = VocabularyTerm(
        code="DFG_9740_6",
        label="9740 Sea trunks",
        description="""Sea trunks//Überseekoffer""",
    )

    dfg_9740_7 = VocabularyTerm(
        code="DFG_9740_7",
        label="9740 Tents for expeditions",
        description="""Tents for expeditions//Zelte für Expeditionen""",
    )

    dfg_9750_1 = VocabularyTerm(
        code="DFG_9750_1",
        label="9750 Sports equipment, diving equipment",
        description="""Sports equipment, diving equipment//Sportgeräte, Taucherausrüstungen""",
    )

    dfg_9750_2 = VocabularyTerm(
        code="DFG_9750_2",
        label="9750 Diving equipment (except pressure chambers 3970)",
        description="""Diving equipment (except pressure chambers 3970)//Tauchergeräte (außer Druckkammern 3970)""",
    )

    dfg_9760_1 = VocabularyTerm(
        code="DFG_9760_1",
        label="9760 Construction and training kits",
        description="""Construction and training kits//Konstruktions- und Lehrbaukästen""",
    )

    dfg_9760_2 = VocabularyTerm(
        code="DFG_9760_2",
        label="9760 Training kits",
        description="""Training kits//Lehrbaukästen""",
    )

    dfg_9780_1 = VocabularyTerm(
        code="DFG_9780_1",
        label="9780 Collections",
        description="""Collections//Sammlungen""",
    )

    dfg_9800_1 = VocabularyTerm(
        code="DFG_9800_1",
        label="9800 Low-voltage installation (except 2600-2690 and 9850)",
        description="""Low-voltage installation (except 2600-2690 and 9850)//Niederspannungs-Installation (außer 2600-2690 und 9850)""",
    )

    dfg_9800_2 = VocabularyTerm(
        code="DFG_9800_2",
        label="9800 Power supply and low-voltage installation",
        description="""Power supply and low-voltage installation//Stromversorgung und Niederspannungs-Installation""",
    )

    dfg_9810_1 = VocabularyTerm(
        code="DFG_9810_1",
        label="9810 Sewage systems, pipes (except 1550 and 1970)",
        description="""Sewage systems, pipes (except 1550 and 1970)//Abwasseranlagen, -leitungen (außer 1550 und 1970)""",
    )

    dfg_9810_2 = VocabularyTerm(
        code="DFG_9810_2",
        label="9810 Fountain installations (except fountains 9030)",
        description="""Fountain installations (except fountains 9030)//Brunnenanlagen (außer Springbrunnen 9030)""",
    )

    dfg_9810_3 = VocabularyTerm(
        code="DFG_9810_3",
        label="9810 Sewage treatment plants (except laboratory and model sewage treatment plants 1550)",
        description="""Sewage treatment plants (except laboratory and model sewage treatment plants 1550)//Kläranlagen für Abwasser (außer Labor-, Modell- Kläranlagen 1550)""",
    )

    dfg_9810_4 = VocabularyTerm(
        code="DFG_9810_4",
        label="9810 Water supply and sanitation (except 1970)",
        description="""Water supply and sanitation (except 1970)//Wasserversorgung und -entsorgung (außer 1970)""",
    )

    dfg_9820_1 = VocabularyTerm(
        code="DFG_9820_1",
        label="9820 District heating",
        description="""District heating//Fernheizung""",
    )

    dfg_9820_2 = VocabularyTerm(
        code="DFG_9820_2",
        label="9820 Gas supply and district heating (except 1100 and 1920)",
        description="""Gas supply and district heating (except 1100 and 1920)//Gasversorgung und Fernheizung (außer 1100 und 1920)""",
    )

    dfg_9830_1 = VocabularyTerm(
        code="DFG_9830_1",
        label="9830 Ventilation systems",
        description="""Ventilation systems//Belüftungsanlagen""",
    )

    dfg_9830_2 = VocabularyTerm(
        code="DFG_9830_2",
        label="9830 Heating and air-conditioning systems, ventilation, climatic chambers, permanently installed (except 2870, 8480 and 9940)",
        description="""Heating and air-conditioning systems, ventilation, climatic chambers, permanently installed (except 2870, 8480 and 9940)//Heizungs- und Klimaanlagen, Lüftung, Klimakammern, fest installiert (außer 2870, 8480 und 9940)""",
    )

    dfg_9830_3 = VocabularyTerm(
        code="DFG_9830_3",
        label="9830 Air-conditioning equipment",
        description="""Air-conditioning equipment//Klimaanlagen""",
    )

    dfg_9830_4 = VocabularyTerm(
        code="DFG_9830_4",
        label="9830 Humidifiers",
        description="""Humidifiers//Luftbefeuchter""",
    )

    dfg_9830_5 = VocabularyTerm(
        code="DFG_9830_5",
        label="9830 Air dryers",
        description="""Air dryers//Lufttrockner""",
    )

    dfg_9830_6 = VocabularyTerm(
        code="DFG_9830_6",
        label="9830 Ventilation systems",
        description="""Ventilation systems//Lüftungsanlagen""",
    )

    dfg_9830_7 = VocabularyTerm(
        code="DFG_9830_7",
        label="9830 Space heaters",
        description="""Space heaters//Raumheizkörper""",
    )

    dfg_9830_8 = VocabularyTerm(
        code="DFG_9830_8",
        label="9830 Room air conditioners",
        description="""Room air conditioners//Raumklimageräte""",
    )

    dfg_9830_9 = VocabularyTerm(
        code="DFG_9830_9",
        label="9830 Ventilators",
        description="""Ventilators//Ventilatoren""",
    )

    dfg_9830_10 = VocabularyTerm(
        code="DFG_9830_10",
        label="9830 Central heating systems",
        description="""Central heating systems//Zentralheizungsanlagen""",
    )

    dfg_9840_1 = VocabularyTerm(
        code="DFG_9840_1",
        label="9840 Protective rooms and equipment",
        description="""Protective rooms and equipment//Schutzräume und -ausrüstung""",
    )

    dfg_9850_1 = VocabularyTerm(
        code="DFG_9850_1",
        label="9850 Emergency lighting installations (except 6010 and 6050)",
        description="""Emergency lighting installations (except 6010 and 6050)//Notbeleuchtungsanlagen (außer 6010 und 6050)""",
    )

    dfg_9850_2 = VocabularyTerm(
        code="DFG_9850_2",
        label="9850 Safety lighting, installations",
        description="""Safety lighting, installations//Sicherheitsbeleuchtung, Anlagen""",
    )

    dfg_9850_3 = VocabularyTerm(
        code="DFG_9850_3",
        label="9850 Uninterruptible power supply (except 2610, 6010 and 6050)",
        description="""Uninterruptible power supply (except 2610, 6010 and 6050)//Unterbrechungsfreie Stromversorgung (außer 2610, 6010 und 6050)""",
    )

    dfg_9860_1 = VocabularyTerm(
        code="DFG_9860_1",
        label="9860 Fire detection and fire alarm systems",
        description="""Fire detection and fire alarm systems//Brandmelder und -Anlagen""",
    )

    dfg_9860_2 = VocabularyTerm(
        code="DFG_9860_2",
        label="9860 Fire protection and alarm systems, lightning conductor systems",
        description="""Fire protection and alarm systems, lightning conductor systems//Feuerschutz- und -meldeanlagen, Blitzableiteranlagen""",
    )

    dfg_9860_3 = VocabularyTerm(
        code="DFG_9860_3",
        label="9860 Fire extinguishers",
        description="""Fire extinguishers//Löschgeräte""",
    )

    dfg_9860_4 = VocabularyTerm(
        code="DFG_9860_4",
        label="9860 Sprinkler systems (fire protection)",
        description="""Sprinkler systems (fire protection)//Sprinkleranlagen (Feuerschutz)""",
    )

    dfg_9860_5 = VocabularyTerm(
        code="DFG_9860_5",
        label="9860 Sprayers (chemical laboratory)",
        description="""Sprayers (chemical laboratory)//Türbrausen (Chemie-Labor)""",
    )

    dfg_9860_6 = VocabularyTerm(
        code="DFG_9860_6",
        label="9860 Fire alarms, fire detectors (except 8600)",
        description="""Fire alarms, fire detectors (except 8600)//Wärmemelder, Brandmelder (außer 8600)""",
    )

    dfg_9870_1 = VocabularyTerm(
        code="DFG_9870_1",
        label="9870 Fire extinguishers and fire-fighting equipment",
        description="""Fire extinguishers and fire-fighting equipment//Feuerlöschgeräte und Feuerwehrausrüstung""",
    )

    dfg_9870_2 = VocabularyTerm(
        code="DFG_9870_2",
        label="9870 Dry fire extinguishers",
        description="""Dry fire extinguishers//Trockenfeuerlöscher""",
    )

    dfg_9880_1 = VocabularyTerm(
        code="DFG_9880_1",
        label="9880 Breathing apparatus, masks (except 3700)",
        description="""Breathing apparatus, masks (except 3700)//Atemgeräte, -masken (außer 3700)""",
    )

    dfg_9880_2 = VocabularyTerm(
        code="DFG_9880_2",
        label="9880 First aid equipment",
        description="""First aid equipment//Erste Hilfe-Geräte""",
    )

    dfg_9880_3 = VocabularyTerm(
        code="DFG_9880_3",
        label="9880 Gas detectors, warning devices (except 152 gas analysis)",
        description="""Gas detectors, warning devices (except 152 gas analysis)//Gasspür-, Warngeräte (außer 152 Gasanalyse)""",
    )

    dfg_9880_4 = VocabularyTerm(
        code="DFG_9880_4",
        label="9880 First aid and disaster response equipment, self-rescuers",
        description="""First aid and disaster response equipment, self-rescuers//Geräte für Erste Hilfe und Katastrophen-Einsatz, Selbstretter""",
    )

    dfg_9880_5 = VocabularyTerm(
        code="DFG_9880_5",
        label="9880 First aid kits, first aid kits",
        description="""First aid kits, first aid kits//Sanitätsschränke, -kästen für erste Hilfe""",
    )

    dfg_9880_6 = VocabularyTerm(
        code="DFG_9880_6",
        label="9880 Self-rescuers, breathing apparatus",
        description="""Self-rescuers, breathing apparatus//Selbstretter, Atemgeräte""",
    )

    dfg_9880_7 = VocabularyTerm(
        code="DFG_9880_7",
        label="9880 First aid kits",
        description="""First aid kits//Verbandskästen""",
    )

    dfg_9880_8 = VocabularyTerm(
        code="DFG_9880_8",
        label="9880 Warning devices (gas and explosion protection)",
        description="""Warning devices (gas and explosion protection)//Warngeräte (Gas- und Explosionsschutz)""",
    )

    dfg_9880_9 = VocabularyTerm(
        code="DFG_9880_9",
        label="9880 Medical service (equipment)",
        description="""Medical service (equipment)//Werksärztlicher Dienst (Geräte)""",
    )

    dfg_9880_10 = VocabularyTerm(
        code="DFG_9880_10",
        label="9880 Resuscitation equipment (except anaesthesia and respiration equipment 3700)",
        description="""Resuscitation equipment (except anaesthesia and respiration equipment 3700)//Wiederbelebungsgeräte (außer Narkose- und Beatmungsgeräte 3700)""",
    )

    dfg_9890_1 = VocabularyTerm(
        code="DFG_9890_1",
        label="9890 Protective equipment (except 0300-0390, 3280 and 9840-9880)",
        description="""Protective equipment (except 0300-0390, 3280 and 9840-9880)//Schutzeinrichtungen (außer 0300-0390, 3280 und 9840-9880)""",
    )

    dfg_9890_2 = VocabularyTerm(
        code="DFG_9890_2",
        label="9890 Other supply and protective equipment",
        description="""Other supply and protective equipment//Sonstige Versorgungsanlagen und Schutzeinrichtungen""",
    )

    dfg_9890_3 = VocabularyTerm(
        code="DFG_9890_3",
        label="9890 Tank monitoring devices (leak protection, alarm devices)",
        description="""Tank monitoring devices (leak protection, alarm devices)//Tanküberwachungsgeräte (Leckschutz, Alarmgeber)""",
    )

    dfg_9890_4 = VocabularyTerm(
        code="DFG_9890_4",
        label="9890 Filling protection for tank installations",
        description="""Filling protection for tank installations//Überfüllungsschutz für Tankanlagen""",
    )

    dfg_9890_5 = VocabularyTerm(
        code="DFG_9890_5",
        label="9890 Supply installations (except 6600-6690 and 9800-9830)",
        description="""Supply installations (except 6600-6690 and 9800-9830)//Versorgungsanlagen (außer 6600-6690 und 9800-9830)""",
    )

    dfg_9900_1 = VocabularyTerm(
        code="DFG_9900_1",
        label="9900 Tarpaulins",
        description="""Tarpaulins//Abdeckplanen""",
    )

    dfg_9900_2 = VocabularyTerm(
        code="DFG_9900_2",
        label="9900 General equipment (for land and buildings, except 9000-9890)",
        description="""General equipment (for land and buildings, except 9000-9890)//Ausrüstung allgemein (für Grundstücke und Gebäude, außer 9000-9890)""",
    )

    dfg_9900_3 = VocabularyTerm(
        code="DFG_9900_3",
        label="9900 Snow removal equipment (hand tools)",
        description="""Snow removal equipment (hand tools)//Schneeräumgeräte (Handgeräte)""",
    )

    dfg_9900_4 = VocabularyTerm(
        code="DFG_9900_4",
        label="9900 Grit containers",
        description="""Grit containers//Streugutbehälter""",
    )

    dfg_9900_5 = VocabularyTerm(
        code="DFG_9900_5",
        label="9900 Tents (except travel and expedition tents 9740)",
        description="""Tents (except travel and expedition tents 9740)//Zelte (außer Reise- und Expeditionszelte 9740)""",
    )

    dfg_9910_1 = VocabularyTerm(
        code="DFG_9910_1",
        label="9910 Insectaries",
        description="""Insectaries//Insektarien""",
    )

    dfg_9910_2 = VocabularyTerm(
        code="DFG_9910_2",
        label="9910 Stables",
        description="""Stables//Stallanlagen""",
    )

    dfg_9910_3 = VocabularyTerm(
        code="DFG_9910_3",
        label="9910 Metabolic cages",
        description="""Metabolic cages//Stoffwechsel-Käfige""",
    )

    dfg_9910_4 = VocabularyTerm(
        code="DFG_9910_4",
        label="9910 Animal cages (except laboratory animals 3880)",
        description="""Animal cages (except laboratory animals 3880)//Tierkäfige (außer Versuchstierhaltung 3880)""",
    )

    dfg_9910_5 = VocabularyTerm(
        code="DFG_9910_5",
        label="9910 Animal houses, terrariums, aquariums, aviaries (except laboratory animals 3880)",
        description="""Animal houses, terrariums, aquariums, aviaries (except laboratory animals 3880)//Tierställe, Terrarien, Aquarien, Vogelkäfige  (außer Versuchstierhaltung 3880)""",
    )

    dfg_9920_1 = VocabularyTerm(
        code="DFG_9920_1",
        label="9920 Gardening tools",
        description="""Gardening tools//Fräsen (Garten-)""",
    )

    dfg_9920_2 = VocabularyTerm(
        code="DFG_9920_2",
        label="9920 Garden tools, portable greenhouses",
        description="""Garden tools, portable greenhouses//Gartengeräte, transportable Gewächshäuser""",
    )

    dfg_9920_3 = VocabularyTerm(
        code="DFG_9920_3",
        label="9920 Growing machines",
        description="""Growing machines//Großflächenmäher""",
    )

    dfg_9920_4 = VocabularyTerm(
        code="DFG_9920_4",
        label="9920 Hand sprayers (garden)",
        description="""Hand sprayers (garden)//Handspritzen (Garten)""",
    )

    dfg_9920_5 = VocabularyTerm(
        code="DFG_9920_5",
        label="9920 Sweepers (garden, lawn)",
        description="""Sweepers (garden, lawn)//Kehrmaschinen (Garten-, Rasen-)""",
    )

    dfg_9920_6 = VocabularyTerm(
        code="DFG_9920_6",
        label="9920 Plant pots, tubs",
        description="""Plant pots, tubs//Pflanzbehälter, -kübel""",
    )

    dfg_9920_7 = VocabularyTerm(
        code="DFG_9920_7",
        label="9920 Lawn mowers",
        description="""Lawn mowers//Rasenmäher""",
    )

    dfg_9930_1 = VocabularyTerm(
        code="DFG_9930_1",
        label="9930 Garage equipment, car washes",
        description="""Garage equipment, car washes//Garageneinrichtung, Autowaschanlagen""",
    )

    dfg_9940_1 = VocabularyTerm(
        code="DFG_9940_1",
        label="9940 Tanks for heating oil and fuels",
        description="""Tanks for heating oil and fuels//Tanks für Heizöl und Kraftstoffe""",
    )

    dfg_9940_2 = VocabularyTerm(
        code="DFG_9940_2",
        label="9940 Fuel dispensers",
        description="""Fuel dispensers//Zapfsäulen für Kraftstoffe""",
    )

    dfg_9950_1 = VocabularyTerm(
        code="DFG_9950_1",
        label="9950 Waste containers (except 0350 for radioactive material)",
        description="""Waste containers (except 0350 for radioactive material)//Abfallbehälter (außer 0350 für radioaktives Material)""",
    )

    dfg_9950_2 = VocabularyTerm(
        code="DFG_9950_2",
        label="9950 Waste paper presses",
        description="""Waste paper presses//Altpapierpressen""",
    )

    dfg_9950_3 = VocabularyTerm(
        code="DFG_9950_3",
        label="9950 Waste containers and plants, scrap metal processing plants",
        description="""Waste containers and plants, scrap metal processing plants//Müllbehälter und -anlagen, Schrottverwertungsanlagen""",
    )

    dfg_9950_4 = VocabularyTerm(
        code="DFG_9950_4",
        label="9950 Scrap metal processing equipment and installations (except 1000-1020, presses 2130 and melting furnaces 8420)",
        description="""Scrap metal processing equipment and installations (except 1000-1020, presses 2130 and melting furnaces 8420)//Schrottverarbeitungsgeräte und -anlagen (außer 1000-1020, Pressen 2130 und Schmelzöfen 8420)""",
    )

    dfg_9960_1 = VocabularyTerm(
        code="DFG_9960_1",
        label="9960 Packaging equipment (shipping)",
        description="""Packaging equipment (shipping)//Verpackungsgeräte (Versand-)""",
    )

    dfg_9970_1 = VocabularyTerm(
        code="DFG_9970_1",
        label="9970 Flagpoles",
        description="""Flagpoles//Fahnenmaste""",
    )

    dfg_9970_2 = VocabularyTerm(
        code="DFG_9970_2",
        label="9970 Bicycle stands, flagpoles, clothes poles",
        description="""Bicycle stands, flagpoles, clothes poles//Fahrradständer, Fahnenmaste, Wäschepfähle""",
    )

    dfg_9970_3 = VocabularyTerm(
        code="DFG_9970_3",
        label="9970 Flags",
        description="""Flags//Flaggen""",
    )

    dfg_9970_4 = VocabularyTerm(
        code="DFG_9970_4",
        label="9970 Carpet beating poles",
        description="""Carpet beating poles//Teppichklopfstangen""",
    )

    dfg_9970_5 = VocabularyTerm(
        code="DFG_9970_5",
        label="9970 Scrub poles",
        description="""Scrub poles//Wäschepfähle""",
    )

    dfg_9980_1 = VocabularyTerm(
        code="DFG_9980_1",
        label="9980 Hunting weapons",
        description="""Hunting weapons//Jagdwaffen""",
    )

    dfg_9980_2 = VocabularyTerm(
        code="DFG_9980_2",
        label="9980 Ammunition",
        description="""Ammunition//Munition""",
    )

    dfg_9980_3 = VocabularyTerm(
        code="DFG_9980_3",
        label="9980 Signal pistols, flare pistols",
        description="""Signal pistols, flare pistols//Signalpistolen, Leuchtpistolen""",
    )

    dfg_9980_4 = VocabularyTerm(
        code="DFG_9980_4",
        label="9980 Weapons",
        description="""Weapons//Waffen""",
    )


class DocumentType(VocabularyType):
    defs = VocabularyTypeDef(
        code="DOCUMENT_TYPE",
        description="""Document Types//Dokumententypen""",
    )

    acceptance_certificate = VocabularyTerm(
        code="ACCEPTANCE_CERTIFICATE",
        label="Acceptance Certificate",
        description="""Acceptance Certificate//Abnahmezeugnis""",
    )

    calibration_certificate = VocabularyTerm(
        code="CALIBRATION_CERTIFICATE",
        label="Calibration Certificate",
        description="""Calibration Certificate//Kalibrierschein""",
    )

    catalog = VocabularyTerm(
        code="CATALOG",
        label="Catalog",
        description="""Catalog/Katalog""",
    )

    datasheet = VocabularyTerm(
        code="DATASHEET",
        label="Datasheet",
        description="""Datasheet//Datenblatt""",
    )

    datasheet_msds = VocabularyTerm(
        code="DATASHEET_MSDS",
        label="Material Safety Datasheet (MSDS)",
        description="""Material Safety Datasheet (MSDS)//Sicherheitsdatenblatt""",
    )

    datasheet_technical = VocabularyTerm(
        code="DATASHEET_TECHNICAL",
        label="Technical Datasheet",
        description="""Technical Datasheet//Technisches Datenblatt""",
    )

    delivery_note = VocabularyTerm(
        code="DELIVERY_NOTE",
        label="Delivery Note",
        description="""Delivery Note//Lieferschein""",
    )

    diagram = VocabularyTerm(
        code="DIAGRAM",
        label="Diagram",
        description="""Diagram//Diagramm""",
    )

    fabrication_order = VocabularyTerm(
        code="FABRICATION_ORDER",
        label="Fabrication Order",
        description="""Fabrication Order//Fertigungsauftrag""",
    )

    inspection_certificate = VocabularyTerm(
        code="INSPECTION_CERTIFICATE",
        label="Inspection Certificate",
        description="""Inspection Certificate//Inspektionszeugnis""",
    )

    installation_manual = VocabularyTerm(
        code="INSTALLATION_MANUAL",
        label="Installation Manual",
        description="""Installation Manual//Installationsanleitung""",
    )

    invoice = VocabularyTerm(
        code="INVOICE",
        label="Invoice",
        description="""Invoice//Rechnung""",
    )

    maintenance_manual = VocabularyTerm(
        code="MAINTENANCE_MANUAL",
        label="Maintenance Manual",
        description="""Maintenance Manual//Wartungsanleitung""",
    )

    operating_instruction = VocabularyTerm(
        code="OPERATING_INSTRUCTION",
        label="Operating Instruction",
        description="""Operating Instruction//Betriebsanweisung""",
    )

    order = VocabularyTerm(
        code="ORDER",
        label="Order",
        description="""Order//Bestellung""",
    )

    photograph = VocabularyTerm(
        code="PHOTOGRAPH",
        label="Photograph",
        description="""Photograph//Foto""",
    )

    repair_manual = VocabularyTerm(
        code="REPAIR_MANUAL",
        label="Repair Manual",
        description="""Repair Manual//Reparaturanleitung""",
    )

    software_manual = VocabularyTerm(
        code="SOFTWARE_MANUAL",
        label="Software Manual",
        description="""Software Manual//Software Bedienungsanleitung""",
    )

    specification = VocabularyTerm(
        code="SPECIFICATION",
        label="Technical Specification",
        description="""Technical Specification//Technische Spezifikation""",
    )

    standard_procedure = VocabularyTerm(
        code="STANDARD_PROCEDURE",
        label="Standard Procedure",
        description="""Standard Procedure//Standardarbeitsanweisung (StAA)""",
    )

    technical_drawing = VocabularyTerm(
        code="TECHNICAL_DRAWING",
        label="Technical Drawing",
        description="""Technical Drawing//Technische Zeichnung""",
    )

    test_certificate = VocabularyTerm(
        code="TEST_CERTIFICATE",
        label="Test Certificate",
        description="""Test Certificate//Prüfzeugnis""",
    )

    training_document = VocabularyTerm(
        code="TRAINING_DOCUMENT",
        label="Training Document",
        description="""Training Document//Schulungsunterlagen""",
    )

    user_manual = VocabularyTerm(
        code="USER_MANUAL",
        label="User Manual",
        description="""User Manual//Bedienungsanleitung""",
    )


class ElectronicSmearing(VocabularyType):
    defs = VocabularyTypeDef(
        code="ELECTRONIC_SMEARING",
        description="""Partial occupancies//Teilbesetzungen""",
    )

    elec_smear_fermi = VocabularyTerm(
        code="ELEC_SMEAR_FERMI",
        label="Fermi Smearing",
        description="""Fermi smearing//Fermi-Schmiere""",
    