---
hide: toc
---

# Welcome to the BAM Data Store documentation page.

The BAM **Data Store** is a central system for digital Research Data Management at the Bundesanstalt für Materialforschung und -prüfung (BAM). It is a modified instance of [openBIS](https://openbis.ch/), so this documentation page does not intend to replace the openBIS documentation, but rather serve as an additional source of information for BAM employees who use the Data Store.

<!-- This documentation page is divided according to the [diataxis method](https://www.diataxis.fr/). -->


<div markdown="block" class="home-grid">

<div markdown="block">

<h3>Tutorials</h3>

The **Tutorials** are designed to guide you through the general and basic understanding of the functionalities of the Data Store. These are intended for learning the software in a first approach.

- [Creating Masterdata](tutorials/create-masterdata.md)
- [pyBIS tutorial](tutorials/pybis.md)

</div>

<div markdown="block">

<h3>How-to guides</h3>

The **How-to guides** provide step-by-step instructions for a wide range of tasks. These are oriented for a practical application so you can use them as a fast entry point when searching for specific information.


</div>

<div markdown="block">

<h3>Explanations</h3>

The **Explanations** give you a theoretical background about the main concepts used in the Data Store. These are overlapping with openBIS and pyBIS concepts, but also some specific Data Store ones, as well as on Research Data Management and Good Scientific Practices.

</div>

<div markdown="block">

<h3>References</h3>

The **References** include the glossary of used terms and API documentation.

</div>

</div>


## Contact
Many parts of this documentation are currently under construction. If you have further questions that are not yet answered here, please contact [datastore@bam.de](mailto:datastore@bam.de).

