---
layout: '@src/layouts/PageLayout.astro'
---

# Examples

The following `Jupyter` notebooks provide some examples of how this package can be used.

## Getting Started Guide

The `Getting Started` guide from the [intro](/intro).

<a href="https://github.com/benchmark-urbanism/cityseer-api/blob/master/demos/getting_started.ipynb" target="_blank">Github: getting_started.ipynb</a>

## Graph Cleaning Guide

`Graph Cleaning` as described in the [graph cleaning guide](/guide#graph-cleaning).

<a href="https://github.com/benchmark-urbanism/cityseer-api/blob/master/demos/graph_cleaning.ipynb" target="_blank">Github: graph_cleaning.ipynb</a>

## Importing OSM data

Examples showing how to import OSM data as discussed in [OSM and NetworkX](/guide#osm-and-networkx).

<a href="https://github.com/benchmark-urbanism/cityseer-api/blob/master/demos/osm_to_cityseer.ipynb" target="_blank">Github: osm_to_cityseer.ipynb</a>

## Centralities for London

Computing network centralities for London:

- OS Open data: <a href="https://github.com/benchmark-urbanism/cityseer-api/blob/master/demos/centrality/centrality_os_open.ipynb" target="_blank">Github: centrality_os_open.ipynb</a>

- OSM data: <a href="https://github.com/benchmark-urbanism/cityseer-api/blob/master/demos/centrality/centrality_osm.ipynb" target="_blank">Github: centrality_osm.ipynb</a>

## Landuse Accessibility for London

Computing landuse acccessibility to pubs and restaurants in London.

<a href="https://github.com/benchmark-urbanism/cityseer-api/blob/master/demos/london_amenities.ipynb" target="_blank">Github: london_amenities.ipynb</a>

## Street Network continuity

Computing street network continuities for street names, route identifiers, and highway types:

- OS Open data: <a href="https://github.com/benchmark-urbanism/cityseer-api/blob/master/demos/continuity/continuity_os_open.ipynb" target="_blank">Github: open_roads_continuity.ipynb</a>

- OSM data: <a href="https://github.com/benchmark-urbanism/cityseer-api/blob/master/demos/continuity/continuity_osm.ipynb" target="_blank">Github: osm_continuity.ipynb</a>
