"""
This module contains a mapping from ISO 3166-1 alpha-2 country codes to their names in English.
Data based on: https://github.com/SmileyChris/django-countries/blob/master/django_countries/data.py
"""
from django.utils.translation import gettext_lazy as _
from ..utils.translation_utils import gettext_many_lazy as __


#: Choices which can be used as primary countries for language objects
CHOICES = (
    ("ab", __(_("Arabic"), _("(non-political)"))),
    ("ad", _("Andorra")),
    ("ae", _("United Arab Emirates")),
    ("af", _("Afghanistan")),
    ("al", _("Albania")),
    ("am", _("Armenia")),
    ("ao", _("Angola")),
    ("ar", _("Argentina")),
    ("at", _("Austria")),
    ("au", _("Australia")),
    ("az", _("Azerbaijan")),
    ("ba", _("Bosnia and Herzegovina")),
    ("bd", _("Bangladesh")),
    ("be", _("Belgium")),
    ("bf", _("Burkina Faso")),
    ("bg", _("Bulgaria")),
    ("bh", _("Bahrain")),
    ("bi", _("Burundi")),
    ("bj", _("Benin")),
    ("bm", _("Bermuda")),
    ("bn", _("Brunei")),
    ("bo", _("Bolivia")),
    ("br", _("Brazil")),
    ("bt", _("Bhutan")),
    ("bw", _("Botswana")),
    ("by", _("Belarus")),
    ("ca", _("Canada")),
    ("cd", _("Congo (Democratic Republic)")),
    ("cf", _("Central African Republic")),
    ("cg", _("Congo (Republic)")),
    ("ch", _("Switzerland")),
    ("ci", _("Côte d'Ivoire")),
    ("cl", _("Chile")),
    ("cm", _("Cameroon")),
    ("cn", _("China")),
    ("co", _("Colombia")),
    ("cr", _("Costa Rica")),
    ("cu", _("Cuba")),
    ("cy", _("Cyprus")),
    ("cz", _("Czechia")),
    ("de", _("Germany")),
    ("dj", _("Djibouti")),
    ("dk", _("Denmark")),
    ("dm", _("Dominica")),
    ("do", _("Dominican Republic")),
    ("dz", _("Algeria")),
    ("ec", _("Ecuador")),
    ("ee", _("Estonia")),
    ("eg", _("Egypt")),
    ("er", _("Eritrea")),
    ("es", _("Spain")),
    ("et", _("Ethiopia")),
    ("fs", __(_("Farsi"), _("(non-political)"))),
    ("fi", _("Finland")),
    ("fr", _("France")),
    ("ga", _("Gabon")),
    ("gb", _("United Kingdom of Great Britain and Northern Ireland")),
    ("gd", _("Grenada")),
    ("ge", _("Georgia")),
    ("gf", _("French Guiana")),
    ("gg", _("Guernsey")),
    ("gh", _("Ghana")),
    ("gi", _("Gibraltar")),
    ("gl", _("Greenland")),
    ("gm", _("Gambia")),
    ("gn", _("Guinea")),
    ("gp", _("Guadeloupe")),
    ("gr", _("Greece")),
    ("gt", _("Guatemala")),
    ("gu", _("Guam")),
    ("gy", _("Guyana")),
    ("hk", _("Hong Kong")),
    ("hn", _("Honduras")),
    ("hr", _("Croatia")),
    ("ht", _("Haiti")),
    ("hu", _("Hungary")),
    ("id", _("Indonesia")),
    ("ie", _("Ireland")),
    ("il", _("Israel")),
    ("in", _("India")),
    ("iq", _("Iraq")),
    ("ir", _("Iran")),
    ("is", _("Iceland")),
    ("it", _("Italy")),
    ("jm", _("Jamaica")),
    ("jo", _("Jordan")),
    ("jp", _("Japan")),
    ("ke", _("Kenya")),
    ("kg", _("Kyrgyzstan")),
    ("kh", _("Cambodia")),
    ("kp", _("North Korea")),
    ("kr", _("South Korea")),
    ("kw", _("Kuwait")),
    ("kz", _("Kazakhstan")),
    ("lb", _("Lebanon")),
    ("li", _("Liechtenstein")),
    ("lr", _("Liberia")),
    ("ls", _("Lesotho")),
    ("lt", _("Lithuania")),
    ("lu", _("Luxembourg")),
    ("lv", _("Latvia")),
    ("ly", _("Libya")),
    ("ma", _("Morocco")),
    ("mc", _("Monaco")),
    ("md", _("Moldova")),
    ("me", _("Montenegro")),
    ("mg", _("Madagascar")),
    ("mk", _("North Macedonia")),
    ("ml", _("Mali")),
    ("mm", _("Myanmar")),
    ("mn", _("Mongolia")),
    ("mr", _("Mauritania")),
    ("mt", _("Malta")),
    ("mu", _("Mauritius")),
    ("mv", _("Maldives")),
    ("mw", _("Malawi")),
    ("mx", _("Mexico")),
    ("my", _("Malaysia")),
    ("mz", _("Mozambique")),
    ("na", _("Namibia")),
    ("ne", _("Niger")),
    ("ng", _("Nigeria")),
    ("ni", _("Nicaragua")),
    ("nl", _("Netherlands")),
    ("no", _("Norway")),
    ("np", _("Nepal")),
    ("nz", _("New Zealand")),
    ("om", _("Oman")),
    ("pa", _("Panama")),
    ("pe", _("Peru")),
    ("pf", _("French Polynesia")),
    ("pg", _("Papua New Guinea")),
    ("ph", _("Philippines")),
    ("pk", _("Pakistan")),
    ("pl", _("Poland")),
    ("ps", _("Palestine")),
    ("pt", _("Portugal")),
    ("py", _("Paraguay")),
    ("qa", _("Qatar")),
    ("ro", _("Romania")),
    ("rs", _("Serbia")),
    ("ru", _("Russian Federation")),
    ("rw", _("Rwanda")),
    ("sa", _("Saudi Arabia")),
    ("sd", _("Sudan")),
    ("se", _("Sweden")),
    ("si", _("Slovenia")),
    ("sk", _("Slovakia")),
    ("sl", _("Sierra Leone")),
    ("sn", _("Senegal")),
    ("so", _("Somalia")),
    ("ss", _("South Sudan")),
    ("sv", _("El Salvador")),
    ("sy", _("Syrian Arab Republic")),
    ("td", _("Chad")),
    ("th", _("Thailand")),
    ("tj", _("Tajikistan")),
    ("tm", _("Turkmenistan")),
    ("tn", _("Tunisia")),
    ("tr", _("Turkey")),
    ("tw", _("Taiwan")),
    ("tz", _("Tanzania")),
    ("ua", _("Ukraine")),
    ("ug", _("Uganda")),
    ("us", _("United States of America")),
    ("uy", _("Uruguay")),
    ("uz", _("Uzbekistan")),
    ("ve", _("Venezuela")),
    ("vn", _("Viet Nam")),
    ("xk", _("Kosovo")),
    ("ye", _("Yemen")),
    ("za", _("South Africa")),
    ("zm", _("Zambia")),
    ("zw", _("Zimbabwe")),
)

#: Choices which are currently inactive and cannot be used to represent languages
INACTIVE_CHOICES = (
    ("ac", _("Ascension")),
    ("ag", _("Antigua and Barbuda")),
    ("ai", _("Anguilla")),
    ("as", _("American Samoa")),
    ("aw", _("Aruba")),
    ("ax", _("Åland Islands")),
    ("bb", _("Barbados")),
    ("bl", _("Saint Barthélemy")),
    ("bq", _("Bonaire, Sint Eustatius and Saba")),
    ("bs", _("Bahamas")),
    ("bv", _("Bouvet Island")),
    ("bz", _("Belize")),
    ("cc", _("Cocos (Keeling) Islands")),
    ("ck", _("Cook Islands")),
    ("cv", _("Cabo Verde")),
    ("cw", _("Curaçao")),
    ("cx", _("Christmas Island")),
    ("eh", _("Western Sahara")),
    ("fj", _("Fiji")),
    ("fk", _("Falkland Islands (Malvinas)")),
    ("fm", _("Micronesia")),
    ("fo", _("Faroe Islands")),
    ("gq", _("Equatorial Guinea")),
    ("gs", _("South Georgia and the South Sandwich Islands")),
    ("gw", _("Guinea-Bissau")),
    ("hm", _("Heard Island and McDonald Islands")),
    ("im", _("Isle of Man")),
    ("io", _("British Indian Ocean Territory")),
    ("je", _("Jersey")),
    ("ki", _("Kiribati")),
    ("km", _("Comoros")),
    ("kn", _("Saint Kitts and Nevis")),
    ("ky", _("Cayman Islands")),
    ("la", _("Lao People's Democratic Republic")),
    ("lc", _("Saint Lucia")),
    ("lk", _("Sri Lanka")),
    ("mf", _("Saint Martin (French part)")),
    ("mh", _("Marshall Islands")),
    ("mo", _("Macao")),
    ("mp", _("Northern Mariana Islands")),
    ("mq", _("Martinique")),
    ("ms", _("Montserrat")),
    ("nc", _("New Caledonia")),
    ("nf", _("Norfolk Island")),
    ("nr", _("Nauru")),
    ("nu", _("Niue")),
    ("pm", _("Saint Pierre and Miquelon")),
    ("pn", _("Pitcairn")),
    ("pr", _("Puerto Rico")),
    ("pw", _("Palau")),
    ("re", _("Réunion")),
    ("sb", _("Solomon Islands")),
    ("sc", _("Seychelles")),
    ("sg", _("Singapore")),
    ("sh", _("Saint Helena")),
    ("sj", _("Svalbard and Jan Mayen")),
    ("sm", _("San Marino")),
    ("sr", _("Suriname")),
    ("st", _("Sao Tome and Principe")),
    ("sx", _("Sint Maarten (Dutch part)")),
    ("sz", _("Eswatini")),
    ("ta", _("Tristan da Cunha")),
    ("tc", _("Turks and Caicos Islands")),
    ("tf", _("French Southern Territories")),
    ("tg", _("Togo")),
    ("tk", _("Tokelau")),
    ("tl", _("Timor-Leste")),
    ("to", _("Tonga")),
    ("tt", _("Trinidad and Tobago")),
    ("tv", _("Tuvalu")),
    ("um", _("United States Minor Outlying Islands")),
    ("va", _("Holy See")),
    ("vc", _("Saint Vincent and the Grenadines")),
    ("vg", _("Virgin Islands (British)")),
    ("vi", _("Virgin Islands (U.S.)")),
    ("vu", _("Vanuatu")),
    ("wf", _("Wallis and Futuna")),
    ("ws", _("Samoa")),
    ("yt", _("Mayotte")),
)
