# MetaPhlAn: Metagenomic Phylogenetic Analysis
[![install with bioconda](https://img.shields.io/badge/install%20with-bioconda-brightgreen.svg?style=flat)](http://bioconda.github.io/recipes/metaphlan/README.html) [![PyPI - Downloads](https://img.shields.io/pypi/dm/metaphlan?label=MetaPhlAn%20on%20PyPi)](https://pypi.org/project/MetaPhlAn/) [![MetaPhlAn on DockerHub](https://img.shields.io/docker/pulls/biobakery/metaphlan?label=MetaPhlAn%20on%20DockerHub)](https://hub.docker.com/r/biobakery/metaphlan) [![Build MetaPhlAn package](https://github.com/biobakery/MetaPhlAn/workflows/Build%20MetaPhlAn%20package/badge.svg?branch=3.0)](https://github.com/biobakery/MetaPhlAn/actions?query=workflow%3A%22Build+MetaPhlAn+package%22)

MetaPhlAn is a computational tool for species-level microbial profiling (bacteria, archaea, eukaryotes, and viruses) from metagenomic shotgun sequencing data. 
StrainPhlAn (available within MetaPhlAn) allows strain-level microbial population genomics.

-------------

### Installation

To install MetaPhlan through conda run:

```
$ conda install -c bioconda metaphlan
```

For further installation instructions and alternative installation methods check the [MetaPhlAn documentation](https://github.com/biobakery/MetaPhlAn/wiki/MetaPhlAn-4#installation).

-------------

### Citation
If you use MetaPhlAn, please cite:

[**Extending and improving metagenomic taxonomic profiling with uncharacterized species using MetaPhlAn 4.**](https://doi.org/10.1038/s41587-023-01688-w) Aitor Blanco-Miguez, Francesco Beghini, Fabio Cumbo, Lauren J. McIver, Kelsey N. Thompson, Moreno Zolfo, Paolo Manghi, Leonard Dubois, Kun D. Huang, Andrew Maltez Thomas, Gianmarco Piccinno, Elisa Piperni, Michal Punčochář, Mireia Valles-Colomer, Adrian Tett, Francesca Giordano, Richard Davies, Jonathan Wolf, Sarah E. Berry, Tim D. Spector, Eric A. Franzosa, Edoardo Pasolli, Francesco Asnicar, Curtis Huttenhower, Nicola Segata. Nature Biotechnology (2023)

If you use StrainPhlAn, please cite the MetaPhlAn paper and the StrainPhlAn paper:

[**Microbial strain-level population structure and genetic diversity from metagenomes.**](http://genome.cshlp.org/content/27/4/626.full.pdf) Duy Tin Truong, Adrian Tett, Edoardo Pasolli, Curtis Huttenhower, Nicola Segata. Genome Research (2017)

If you use the MetaPhlAn viral module, please cite the MetaPhlAn paper and the MetaPhlan viral module paper:

[**Discovering and exploring the hidden diversity of human gut viruses using highly enriched virome samples.**](https://doi.org/10.1101/2024.02.19.580813 ) Moreno Zolfo, Andrea Silverj, Aitor Blanco-Míguez, Paolo Manghi, Omar Rota-Stabelli, Vitor Heidrich, Jordan Jensen, Sagun Maharjan, Eric Franzosa, Cristina Menni, Alessia Visconti, Federica Pinto, Matteo Ciciani, Curtis Huttenhower, Anna Cereseto, Francesco Asnicar, Hiroaki Kitano, Takuji Yamada, Nicola Segata. bioRxiv (2024)

-------------

### Tutorials and resources

* [MetaPhlan webpage](http://segatalab.cibio.unitn.it/tools/metaphlan/index.html)
* [MetaPhlAn documentation](https://github.com/biobakery/MetaPhlAn/wiki/MetaPhlAn-4)
* [MetaPhlan tutorial](https://github.com/biobakery/biobakery/wiki/metaphlan4)
* [MetaPhlan user support](https://forum.biobakery.org/c/microbial-community-profiling/metaphlan/)
* [MetaPhlan change log](https://github.com/biobakery/MetaPhlAn/blob/master/CHANGELOG.md)
* [StrainPhlAn webpage](http://segatalab.cibio.unitn.it/tools/strainphlan/index.html)
* [StrainPhlAn documentation](http://segatalab.cibio.unitn.it/tools/strainphlan/index.html)
* [StrainPhlan tutorial](https://github.com/biobakery/biobakery/wiki/strainphlan4)
* [StrainPhlan user support](https://forum.biobakery.org/c/microbial-community-profiling/strainphlan/)

#
MetaPhlAn and StrainPhlAn are part of the bioBakery suite. For further bioBakery tools and tutorials visit the [bioBakery wiki](https://github.com/biobakery/biobakery).
