# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing_extensions import Literal

import httpx

from ..types import oauth_token_create_params
from .._types import Body, Omit, Query, Headers, NotGiven, omit, not_given
from .._utils import maybe_transform, async_maybe_transform
from .._compat import cached_property
from .._resource import SyncAPIResource, AsyncAPIResource
from .._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from .._base_client import make_request_options
from ..types.oauth_token import OAuthToken

__all__ = ["OAuthTokensResource", "AsyncOAuthTokensResource"]


class OAuthTokensResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> OAuthTokensResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Increase/increase-python#accessing-raw-response-data-eg-headers
        """
        return OAuthTokensResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> OAuthTokensResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Increase/increase-python#with_streaming_response
        """
        return OAuthTokensResourceWithStreamingResponse(self)

    def create(
        self,
        *,
        grant_type: Literal["authorization_code", "production_token"],
        client_id: str | Omit = omit,
        client_secret: str | Omit = omit,
        code: str | Omit = omit,
        production_token: str | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> OAuthToken:
        """
        Create an OAuth Token

        Args:
          grant_type: The credential you request in exchange for the code. In Production, this is
              always `authorization_code`. In Sandbox, you can pass either enum value.

              - `authorization_code` - An OAuth authorization code.
              - `production_token` - An OAuth production token.

          client_id: The public identifier for your application.

          client_secret: The secret that confirms you own the application. This is redundant given that
              the request is made with your API key but it's a required component of OAuth
              2.0.

          code: The authorization code generated by the user and given to you as a query
              parameter.

          production_token: The production token you want to exchange for a sandbox token. This is only
              available in Sandbox. Set `grant_type` to `production_token` to use this
              parameter.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        return self._post(
            "/oauth/tokens",
            body=maybe_transform(
                {
                    "grant_type": grant_type,
                    "client_id": client_id,
                    "client_secret": client_secret,
                    "code": code,
                    "production_token": production_token,
                },
                oauth_token_create_params.OAuthTokenCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=OAuthToken,
        )


class AsyncOAuthTokensResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncOAuthTokensResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Increase/increase-python#accessing-raw-response-data-eg-headers
        """
        return AsyncOAuthTokensResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncOAuthTokensResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Increase/increase-python#with_streaming_response
        """
        return AsyncOAuthTokensResourceWithStreamingResponse(self)

    async def create(
        self,
        *,
        grant_type: Literal["authorization_code", "production_token"],
        client_id: str | Omit = omit,
        client_secret: str | Omit = omit,
        code: str | Omit = omit,
        production_token: str | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
        idempotency_key: str | None = None,
    ) -> OAuthToken:
        """
        Create an OAuth Token

        Args:
          grant_type: The credential you request in exchange for the code. In Production, this is
              always `authorization_code`. In Sandbox, you can pass either enum value.

              - `authorization_code` - An OAuth authorization code.
              - `production_token` - An OAuth production token.

          client_id: The public identifier for your application.

          client_secret: The secret that confirms you own the application. This is redundant given that
              the request is made with your API key but it's a required component of OAuth
              2.0.

          code: The authorization code generated by the user and given to you as a query
              parameter.

          production_token: The production token you want to exchange for a sandbox token. This is only
              available in Sandbox. Set `grant_type` to `production_token` to use this
              parameter.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds

          idempotency_key: Specify a custom idempotency key for this request
        """
        return await self._post(
            "/oauth/tokens",
            body=await async_maybe_transform(
                {
                    "grant_type": grant_type,
                    "client_id": client_id,
                    "client_secret": client_secret,
                    "code": code,
                    "production_token": production_token,
                },
                oauth_token_create_params.OAuthTokenCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                idempotency_key=idempotency_key,
            ),
            cast_to=OAuthToken,
        )


class OAuthTokensResourceWithRawResponse:
    def __init__(self, oauth_tokens: OAuthTokensResource) -> None:
        self._oauth_tokens = oauth_tokens

        self.create = to_raw_response_wrapper(
            oauth_tokens.create,
        )


class AsyncOAuthTokensResourceWithRawResponse:
    def __init__(self, oauth_tokens: AsyncOAuthTokensResource) -> None:
        self._oauth_tokens = oauth_tokens

        self.create = async_to_raw_response_wrapper(
            oauth_tokens.create,
        )


class OAuthTokensResourceWithStreamingResponse:
    def __init__(self, oauth_tokens: OAuthTokensResource) -> None:
        self._oauth_tokens = oauth_tokens

        self.create = to_streamed_response_wrapper(
            oauth_tokens.create,
        )


class AsyncOAuthTokensResourceWithStreamingResponse:
    def __init__(self, oauth_tokens: AsyncOAuthTokensResource) -> None:
        self._oauth_tokens = oauth_tokens

        self.create = async_to_streamed_response_wrapper(
            oauth_tokens.create,
        )
