import cupy as cp

from .color import (
    aces2065_1_to_acescct,
    aces2065_1_to_acescg,
    aces2065_1_to_rec709,
    acescct_to_aces2065_1,
    acescg_to_aces2065_1,
    apply_lut,
    apply_lut_cp,
    bgr_to_grayscale,
    bgr_to_hsv,
    bgr_to_rgb,
    bgr_to_ycbcr,
    hsv_to_bgr,
    hsv_to_rgb,
    ndi_uyvy422_to_ycbcr444,
    ndi_uyvy422_to_ycbcr444_cp,
    read_lut,
    rec709_to_aces2065_1,
    rgb_to_bgr,
    rgb_to_grayscale,
    rgb_to_hsv,
    rgb_to_ycbcr,
    uyvy422_to_ycbcr444,
    uyvy422_to_ycbcr444_cp,
    ycbcr_full_to_legal,
    ycbcr_legal_to_full,
    ycbcr_to_bgr,
    ycbcr_to_grayscale,
    ycbcr_to_rgb,
    yuv420p_to_ycbcr444,
    yuv420p_to_ycbcr444_cp,
    yuv422p10le_to_ycbcr444,
    yuv422p10le_to_ycbcr444_cp,
)
from .draw import add_label, circle, create_rounded_mask, put_text, rectangle
from .face import (
    GFPGAN,
    FaceDetection,
    FaceEmbedding,
    FaceSwap,
    PasteBack,
    PxFace,
    TrtFaceDetection,
    TrtFaceEmbedding,
    TrtFaceSwap,
    paste_back,
)
from .filter import GaussianBlur, gaussian_blur, get_gaussian_kernel
from .io import destroy_all_windows, imread, imshow, imwrite, waitkey
from .transform import (
    INTER_AREA,
    INTER_AUTO,
    INTER_B_SPLINE,
    INTER_CATMULL_ROM,
    INTER_CUBIC,
    INTER_LANCZOS2,
    INTER_LANCZOS3,
    INTER_LANCZOS4,
    INTER_LINEAR,
    INTER_MITCHELL,
    INTER_NEAREST,
    _resize,
    affine_transform,
    create_erode_kernel,
    crop_from_kps,
    erode,
    get_inverse_matrix,
    resize,
    stack_images,
)
from .upscale import (
    OnnxUpscaler,
    TorchUpscaler,
    TrtUpscaler,
    add_padding,
    batch_to_tile,
    create_gaussian_weights,
    merge_tiles,
    tile_image,
    to_batch,
)
from .utils import (
    batch_to_images,
    check_onnx_model,
    check_torch_model,
    images_to_batch,
    images_to_batch_pixelshift,
    infer_image_layout,
    onnx_to_onnx_dynamic,
    onnx_to_trt,
    onnx_to_trt_dynamic_shape,
    onnx_to_trt_fixed_shape,
    pixelshift_fuse,
    to_blob,
    to_cupy,
    to_dtype,
    to_float16,
    to_float32,
    to_float64,
    to_numpy,
    to_tensor,
    to_uint8,
    to_uint16,
    torch_to_onnx,
)

get_device_id = cp.cuda.device.get_device_id
get_device_count = cp.cuda.runtime.getDeviceCount
Device = cp.cuda.Device

__all__ = [
    # Color conversion functions
    "aces2065_1_to_acescct",
    "aces2065_1_to_acescg",
    "aces2065_1_to_rec709",
    "acescct_to_aces2065_1",
    "acescg_to_aces2065_1",
    "apply_lut",
    "apply_lut_cp",
    "bgr_to_grayscale",
    "bgr_to_hsv",
    "bgr_to_rgb",
    "bgr_to_ycbcr",
    "hsv_to_bgr",
    "hsv_to_rgb",
    "ndi_uyvy422_to_ycbcr444",
    "ndi_uyvy422_to_ycbcr444_cp",
    "read_lut",
    "rec709_to_aces2065_1",
    "rgb_to_bgr",
    "rgb_to_grayscale",
    "rgb_to_hsv",
    "rgb_to_ycbcr",
    "uyvy422_to_ycbcr444",
    "uyvy422_to_ycbcr444_cp",
    "ycbcr_full_to_legal",
    "ycbcr_legal_to_full",
    "ycbcr_to_bgr",
    "ycbcr_to_grayscale",
    "ycbcr_to_rgb",
    "yuv420p_to_ycbcr444",
    "yuv420p_to_ycbcr444_cp",
    "yuv422p10le_to_ycbcr444",
    "yuv422p10le_to_ycbcr444_cp",
    # Drawing functions
    "add_label",
    "circle",
    "create_rounded_mask",
    "put_text",
    "rectangle",
    # Face processing
    "FaceDetection",
    "FaceEmbedding",
    "FaceSwap",
    "GFPGAN",
    "PasteBack",
    "PxFace",
    "TrtFaceDetection",
    "TrtFaceEmbedding",
    "TrtFaceSwap",
    "paste_back",
    # Filtering
    "GaussianBlur",
    "gaussian_blur",
    "get_gaussian_kernel",
    # I/O operations
    "destroy_all_windows",
    "imread",
    "imshow",
    "imwrite",
    "waitkey",
    # Transform operations
    "INTER_AREA",
    "INTER_AUTO",
    "INTER_B_SPLINE",
    "INTER_CATMULL_ROM",
    "INTER_CUBIC",
    "INTER_LANCZOS2",
    "INTER_LANCZOS3",
    "INTER_LANCZOS4",
    "INTER_LINEAR",
    "INTER_MITCHELL",
    "INTER_NEAREST",
    "_resize",
    "affine_transform",
    "create_erode_kernel",
    "crop_from_kps",
    "erode",
    "get_inverse_matrix",
    "resize",
    "stack_images",
    # Upscaling
    "OnnxUpscaler",
    "TorchUpscaler",
    "TrtUpscaler",
    "add_padding",
    "batch_to_tile",
    "create_gaussian_weights",
    "merge_tiles",
    "tile_image",
    "to_batch",
    # Utilities
    "check_onnx_model",
    "check_torch_model",
    "torch_to_onnx",
    "onnx_to_onnx_dynamic",
    "onnx_to_trt",
    "onnx_to_trt_dynamic_shape",
    "onnx_to_trt_fixed_shape",
    "batch_to_images",
    "images_to_batch",
    "infer_image_layout",
    "images_to_batch_pixelshift",
    "pixelshift_fuse",
    "to_blob",
    "to_cupy",
    "to_dtype",
    "to_float16",
    "to_float32",
    "to_float64",
    "to_numpy",
    "to_tensor",
    "to_uint8",
    "to_uint16",
    # Device functions
    "Device",
    "get_device_count",
    "get_device_id",
]
