# API Key Gateway

A Python library that provides an `@apikey_login` decorator to validate API keys with service-aware authentication.

## Features

- Automatically adds `--apikey/-a` CLI parameter to decorated functions
- Validates API keys using argon2id hashing algorithm for strong security
- Service-aware validation: Keys are scoped to specific services
- Fetches valid public keys from a remote JSON endpoint
- Easy to use decorator interface with service parameter

## Installation

```bash
uv install apikey-gateway
```

## Usage

The `apikey_login` decorator requires a `service` parameter to scope keys to specific services.

```python
from apikey_gateway import apikey_login

@apikey_login(service="media-match")
def media_app():
    print("API key validated for media-match service!")
    # Your media application logic here

@apikey_login(service="analytics")
def analytics_app():
    print("API key validated for analytics service!")
    # Your analytics application logic here

if __name__ == "__main__":
    media_app()  # or analytics_app()
```

Run with:
```bash
python app.py --apikey your-secret-key
```

## How It Works

1. The application specifies the `service` name when using the `@apikey_login` decorator
2. The user provides a secret API key via the `--apikey/-a` CLI parameter
3. The library computes an argon2id hash (public key) from the secret key
4. It fetches the list of valid public keys from `https://api.jsonbin.io/v3/b/691ec6a543b1c97be9b8ea6d`
5. Valid keys are filtered to only those belonging to the specified service
6. If the computed public key matches any valid service-specific public key, access is granted

## JSON Format

The remote JSON follows a service-aware structure where keys are organized by service name:

### Service-Aware Structure
```json
{
  "service1": {
    "key_id_1": "argon2id_hash_here",
    "key_id_2": "another_hash_here"
  },
  "service2": "single_key_hash_here"
}
```

- Top-level keys are service names
- Each service can have either multiple keys (as a dictionary) or a single key (as a string)
- The library automatically handles both formats when fetching keys

## License

MIT
