# Copyright (c) 2024 Roboto Technologies, Inc.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at https://mozilla.org/MPL/2.0/.

import datetime
from typing import Optional

import pydantic

from roboto.auth.scope import ApiScope


class TokenContext(pydantic.BaseModel):
    """Context for token usage"""

    token_id: str
    name: str
    description: Optional[str] = None
    expires: datetime.datetime
    last_used: Optional[datetime.datetime] = None
    api_scopes: set[ApiScope]
    enabled: bool = True


class TokenRecord(pydantic.BaseModel):
    """A wire-transmissible representation of a token."""

    secret: Optional[str] = None
    user_id: Optional[str] = None
    context: Optional[TokenContext] = None
