# coding: utf-8

# flake8: noqa

"""
    API REST FactPulse

     API REST pour la facturation électronique en France : Factur-X, AFNOR PDP/PA, signatures électroniques.  ## 🎯 Fonctionnalités principales  ### 📄 Génération de factures Factur-X - **Formats** : XML seul ou PDF/A-3 avec XML embarqué - **Profils** : MINIMUM, BASIC, EN16931, EXTENDED - **Normes** : EN 16931 (directive UE 2014/55), ISO 19005-3 (PDF/A-3), CII (UN/CEFACT) - **🆕 Format simplifié** : Génération à partir de SIRET + auto-enrichissement (API Chorus Pro + Recherche Entreprises)  ### ✅ Validation et conformité - **Validation XML** : Schematron (45 à 210+ règles selon profil) - **Validation PDF** : PDF/A-3, métadonnées XMP Factur-X, signatures électroniques - **VeraPDF** : Validation stricte PDF/A (146+ règles ISO 19005-3) - **Traitement asynchrone** : Support Celery pour validations lourdes (VeraPDF)  ### 📡 Intégration AFNOR PDP/PA (XP Z12-013) - **Soumission de flux** : Envoi de factures vers Plateformes de Dématérialisation Partenaires - **Recherche de flux** : Consultation des factures soumises - **Téléchargement** : Récupération des PDF/A-3 avec XML - **Directory Service** : Recherche d'entreprises (SIREN/SIRET) - **Multi-client** : Support de plusieurs configs PDP par utilisateur (stored credentials ou zero-storage)  ### ✍️ Signature électronique PDF - **Standards** : PAdES-B-B, PAdES-B-T (horodatage RFC 3161), PAdES-B-LT (archivage long terme) - **Niveaux eIDAS** : SES (auto-signé), AdES (CA commerciale), QES (PSCO) - **Validation** : Vérification intégrité cryptographique et certificats - **Génération de certificats** : Certificats X.509 auto-signés pour tests  ### 🔄 Traitement asynchrone - **Celery** : Génération, validation et signature asynchrones - **Polling** : Suivi d'état via `/taches/{id_tache}/statut` - **Pas de timeout** : Idéal pour gros fichiers ou validations lourdes  ## 🔒 Authentification  Toutes les requêtes nécessitent un **token JWT** dans le header Authorization : ``` Authorization: Bearer YOUR_JWT_TOKEN ```  ### Comment obtenir un token JWT ?  #### 🔑 Méthode 1 : API `/api/token/` (Recommandée)  **URL :** `https://www.factpulse.fr/api/token/`  Cette méthode est **recommandée** pour l'intégration dans vos applications et workflows CI/CD.  **Prérequis :** Avoir défini un mot de passe sur votre compte  **Pour les utilisateurs inscrits via email/password :** - Vous avez déjà un mot de passe, utilisez-le directement  **Pour les utilisateurs inscrits via OAuth (Google/GitHub) :** - Vous devez d'abord définir un mot de passe sur : https://www.factpulse.fr/accounts/password/set/ - Une fois le mot de passe créé, vous pourrez utiliser l'API  **Exemple de requête :** ```bash curl -X POST https://www.factpulse.fr/api/token/ \\   -H \"Content-Type: application/json\" \\   -d '{     \"username\": \"votre_email@example.com\",     \"password\": \"votre_mot_de_passe\"   }' ```  **Réponse :** ```json {   \"access\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\",  // Token d'accès (validité: 30 min)   \"refresh\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\"  // Token de rafraîchissement (validité: 7 jours) } ```  **Avantages :** - ✅ Automatisation complète (CI/CD, scripts) - ✅ Gestion programmatique des tokens - ✅ Support du refresh token pour renouveler automatiquement l'accès - ✅ Intégration facile dans n'importe quel langage/outil  #### 🖥️ Méthode 2 : Génération via Dashboard (Alternative)  **URL :** https://www.factpulse.fr/dashboard/  Cette méthode convient pour des tests rapides ou une utilisation occasionnelle via l'interface graphique.  **Fonctionnement :** - Connectez-vous au dashboard - Utilisez les boutons \"Generate Test Token\" ou \"Generate Production Token\" - Fonctionne pour **tous** les utilisateurs (OAuth et email/password), sans nécessiter de mot de passe  **Types de tokens :** - **Token Test** : Validité 24h, quota 1000 appels/jour (gratuit) - **Token Production** : Validité 7 jours, quota selon votre forfait  **Avantages :** - ✅ Rapide pour tester l'API - ✅ Aucun mot de passe requis - ✅ Interface visuelle simple  **Inconvénients :** - ❌ Nécessite une action manuelle - ❌ Pas de refresh token - ❌ Moins adapté pour l'automatisation  ### 📚 Documentation complète  Pour plus d'informations sur l'authentification et l'utilisation de l'API : https://www.factpulse.fr/documentation-api/     

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "2.0.2"

# Define package exports
__all__ = [
    "AFNORPDPPAApi",
    "AFNORPDPPADirectoryServiceApi",
    "AFNORPDPPAFlowServiceApi",
    "ChorusProApi",
    "SantApi",
    "TraitementFactureApi",
    "UtilisateurApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "AdresseElectronique",
    "AdressePostale",
    "BodyAjouterFichierApiV1ChorusProTransversesAjouterFichierPost",
    "BodyCompleterFactureApiV1ChorusProFacturesCompleterPost",
    "BodyListerServicesStructureApiV1ChorusProStructuresIdStructureCppServicesGet",
    "BodyRechercherFacturesDestinataireApiV1ChorusProFacturesRechercherDestinatairePost",
    "BodyRechercherFacturesFournisseurApiV1ChorusProFacturesRechercherFournisseurPost",
    "BodyRecyclerFactureApiV1ChorusProFacturesRecyclerPost",
    "BodyTelechargerGroupeFacturesApiV1ChorusProFacturesTelechargerGroupePost",
    "BodyTraiterFactureRecueApiV1ChorusProFacturesTraiterFactureRecuePost",
    "BodyValideurConsulterFactureApiV1ChorusProFacturesValideurConsulterPost",
    "BodyValideurRechercherFacturesApiV1ChorusProFacturesValideurRechercherPost",
    "BodyValideurTraiterFactureApiV1ChorusProFacturesValideurTraiterPost",
    "CadreDeFacturation",
    "CategorieTVA",
    "CertificateInfoResponse",
    "ChorusProCredentials",
    "CodeCadreFacturation",
    "CodeRaisonReduction",
    "ConsulterFactureRequest",
    "ConsulterFactureResponse",
    "ConsulterStructureRequest",
    "ConsulterStructureResponse",
    "CredentialsAFNOR",
    "CredentialsChorusPro",
    "Destinataire",
    "Destination",
    "DestinationAFNOR",
    "DestinationChorusPro",
    "DirectionFlux",
    "DonneesFactureSimplifiees",
    "FactureEnrichieInfoInput",
    "FactureEnrichieInfoOutput",
    "FactureFacturX",
    "FluxResume",
    "FormatSortie",
    "Fournisseur",
    "GenerateCertificateRequest",
    "GenerateCertificateResponse",
    "HTTPValidationError",
    "InformationSignatureAPI",
    "LigneDePoste",
    "LigneDePosteMontantRemiseHt",
    "LigneDePosteTauxTvaManuel",
    "LigneDeTVA",
    "ModeDepot",
    "ModePaiement",
    "MontantAPayer",
    "MontantBaseHt",
    "MontantHtTotal",
    "MontantHtTotal1",
    "MontantRemiseGlobaleTtc",
    "MontantTotal",
    "MontantTotalAcompte",
    "MontantTotalLigneHt",
    "MontantTtcTotal",
    "MontantTtcTotal1",
    "MontantTva",
    "MontantTva1",
    "MontantUnitaireHt",
    "ObtenirIdChorusProRequest",
    "ObtenirIdChorusProResponse",
    "OptionsProcessing",
    "PDFFacturXInfo",
    "PDPCredentials",
    "ParametresSignature",
    "ParametresStructure",
    "PieceJointeComplementaire",
    "ProfilAPI",
    "ProfilFlux",
    "Quantite",
    "QuotaInfo",
    "RechercherServicesResponse",
    "RechercherStructureRequest",
    "RechercherStructureResponse",
    "References",
    "ReponseHealthcheckAFNOR",
    "ReponseRechercheFlux",
    "ReponseSoumissionFlux",
    "ReponseTache",
    "ReponseValidationErreur",
    "ReponseValidationSucces",
    "RequeteRechercheFlux",
    "RequeteSoumissionFlux",
    "ResultatAFNOR",
    "ResultatChorusPro",
    "ResultatValidationPDFAPI",
    "SchemeID",
    "ServiceStructure",
    "SignatureInfo",
    "SoumettreFactureCompleteRequest",
    "SoumettreFactureCompleteResponse",
    "SoumettreFactureRequest",
    "SoumettreFactureResponse",
    "StatutAcquittement",
    "StatutFacture",
    "StatutTache",
    "StructureInfo",
    "SyntaxeFlux",
    "Tauxmanuel",
    "TypeFacture",
    "TypeFlux",
    "TypeTVA",
    "Unite",
    "Utilisateur",
    "ValidationError",
    "ValidationErrorLocInner",
]

# import apis into sdk package
from factpulse.api.afnorpdppa_api import AFNORPDPPAApi as AFNORPDPPAApi
from factpulse.api.afnorpdppa_directory_service_api import AFNORPDPPADirectoryServiceApi as AFNORPDPPADirectoryServiceApi
from factpulse.api.afnorpdppa_flow_service_api import AFNORPDPPAFlowServiceApi as AFNORPDPPAFlowServiceApi
from factpulse.api.chorus_pro_api import ChorusProApi as ChorusProApi
from factpulse.api.sant_api import SantApi as SantApi
from factpulse.api.traitement_facture_api import TraitementFactureApi as TraitementFactureApi
from factpulse.api.utilisateur_api import UtilisateurApi as UtilisateurApi

# import ApiClient
from factpulse.api_response import ApiResponse as ApiResponse
from factpulse.api_client import ApiClient as ApiClient
from factpulse.configuration import Configuration as Configuration
from factpulse.exceptions import OpenApiException as OpenApiException
from factpulse.exceptions import ApiTypeError as ApiTypeError
from factpulse.exceptions import ApiValueError as ApiValueError
from factpulse.exceptions import ApiKeyError as ApiKeyError
from factpulse.exceptions import ApiAttributeError as ApiAttributeError
from factpulse.exceptions import ApiException as ApiException

# import models into sdk package
from factpulse.models.adresse_electronique import AdresseElectronique as AdresseElectronique
from factpulse.models.adresse_postale import AdressePostale as AdressePostale
from factpulse.models.body_ajouter_fichier_api_v1_chorus_pro_transverses_ajouter_fichier_post import BodyAjouterFichierApiV1ChorusProTransversesAjouterFichierPost as BodyAjouterFichierApiV1ChorusProTransversesAjouterFichierPost
from factpulse.models.body_completer_facture_api_v1_chorus_pro_factures_completer_post import BodyCompleterFactureApiV1ChorusProFacturesCompleterPost as BodyCompleterFactureApiV1ChorusProFacturesCompleterPost
from factpulse.models.body_lister_services_structure_api_v1_chorus_pro_structures_id_structure_cpp_services_get import BodyListerServicesStructureApiV1ChorusProStructuresIdStructureCppServicesGet as BodyListerServicesStructureApiV1ChorusProStructuresIdStructureCppServicesGet
from factpulse.models.body_rechercher_factures_destinataire_api_v1_chorus_pro_factures_rechercher_destinataire_post import BodyRechercherFacturesDestinataireApiV1ChorusProFacturesRechercherDestinatairePost as BodyRechercherFacturesDestinataireApiV1ChorusProFacturesRechercherDestinatairePost
from factpulse.models.body_rechercher_factures_fournisseur_api_v1_chorus_pro_factures_rechercher_fournisseur_post import BodyRechercherFacturesFournisseurApiV1ChorusProFacturesRechercherFournisseurPost as BodyRechercherFacturesFournisseurApiV1ChorusProFacturesRechercherFournisseurPost
from factpulse.models.body_recycler_facture_api_v1_chorus_pro_factures_recycler_post import BodyRecyclerFactureApiV1ChorusProFacturesRecyclerPost as BodyRecyclerFactureApiV1ChorusProFacturesRecyclerPost
from factpulse.models.body_telecharger_groupe_factures_api_v1_chorus_pro_factures_telecharger_groupe_post import BodyTelechargerGroupeFacturesApiV1ChorusProFacturesTelechargerGroupePost as BodyTelechargerGroupeFacturesApiV1ChorusProFacturesTelechargerGroupePost
from factpulse.models.body_traiter_facture_recue_api_v1_chorus_pro_factures_traiter_facture_recue_post import BodyTraiterFactureRecueApiV1ChorusProFacturesTraiterFactureRecuePost as BodyTraiterFactureRecueApiV1ChorusProFacturesTraiterFactureRecuePost
from factpulse.models.body_valideur_consulter_facture_api_v1_chorus_pro_factures_valideur_consulter_post import BodyValideurConsulterFactureApiV1ChorusProFacturesValideurConsulterPost as BodyValideurConsulterFactureApiV1ChorusProFacturesValideurConsulterPost
from factpulse.models.body_valideur_rechercher_factures_api_v1_chorus_pro_factures_valideur_rechercher_post import BodyValideurRechercherFacturesApiV1ChorusProFacturesValideurRechercherPost as BodyValideurRechercherFacturesApiV1ChorusProFacturesValideurRechercherPost
from factpulse.models.body_valideur_traiter_facture_api_v1_chorus_pro_factures_valideur_traiter_post import BodyValideurTraiterFactureApiV1ChorusProFacturesValideurTraiterPost as BodyValideurTraiterFactureApiV1ChorusProFacturesValideurTraiterPost
from factpulse.models.cadre_de_facturation import CadreDeFacturation as CadreDeFacturation
from factpulse.models.categorie_tva import CategorieTVA as CategorieTVA
from factpulse.models.certificate_info_response import CertificateInfoResponse as CertificateInfoResponse
from factpulse.models.chorus_pro_credentials import ChorusProCredentials as ChorusProCredentials
from factpulse.models.code_cadre_facturation import CodeCadreFacturation as CodeCadreFacturation
from factpulse.models.code_raison_reduction import CodeRaisonReduction as CodeRaisonReduction
from factpulse.models.consulter_facture_request import ConsulterFactureRequest as ConsulterFactureRequest
from factpulse.models.consulter_facture_response import ConsulterFactureResponse as ConsulterFactureResponse
from factpulse.models.consulter_structure_request import ConsulterStructureRequest as ConsulterStructureRequest
from factpulse.models.consulter_structure_response import ConsulterStructureResponse as ConsulterStructureResponse
from factpulse.models.credentials_afnor import CredentialsAFNOR as CredentialsAFNOR
from factpulse.models.credentials_chorus_pro import CredentialsChorusPro as CredentialsChorusPro
from factpulse.models.destinataire import Destinataire as Destinataire
from factpulse.models.destination import Destination as Destination
from factpulse.models.destination_afnor import DestinationAFNOR as DestinationAFNOR
from factpulse.models.destination_chorus_pro import DestinationChorusPro as DestinationChorusPro
from factpulse.models.direction_flux import DirectionFlux as DirectionFlux
from factpulse.models.donnees_facture_simplifiees import DonneesFactureSimplifiees as DonneesFactureSimplifiees
from factpulse.models.facture_enrichie_info_input import FactureEnrichieInfoInput as FactureEnrichieInfoInput
from factpulse.models.facture_enrichie_info_output import FactureEnrichieInfoOutput as FactureEnrichieInfoOutput
from factpulse.models.facture_factur_x import FactureFacturX as FactureFacturX
from factpulse.models.flux_resume import FluxResume as FluxResume
from factpulse.models.format_sortie import FormatSortie as FormatSortie
from factpulse.models.fournisseur import Fournisseur as Fournisseur
from factpulse.models.generate_certificate_request import GenerateCertificateRequest as GenerateCertificateRequest
from factpulse.models.generate_certificate_response import GenerateCertificateResponse as GenerateCertificateResponse
from factpulse.models.http_validation_error import HTTPValidationError as HTTPValidationError
from factpulse.models.information_signature_api import InformationSignatureAPI as InformationSignatureAPI
from factpulse.models.ligne_de_poste import LigneDePoste as LigneDePoste
from factpulse.models.ligne_de_poste_montant_remise_ht import LigneDePosteMontantRemiseHt as LigneDePosteMontantRemiseHt
from factpulse.models.ligne_de_poste_taux_tva_manuel import LigneDePosteTauxTvaManuel as LigneDePosteTauxTvaManuel
from factpulse.models.ligne_de_tva import LigneDeTVA as LigneDeTVA
from factpulse.models.mode_depot import ModeDepot as ModeDepot
from factpulse.models.mode_paiement import ModePaiement as ModePaiement
from factpulse.models.montant_a_payer import MontantAPayer as MontantAPayer
from factpulse.models.montant_base_ht import MontantBaseHt as MontantBaseHt
from factpulse.models.montant_ht_total import MontantHtTotal as MontantHtTotal
from factpulse.models.montant_ht_total1 import MontantHtTotal1 as MontantHtTotal1
from factpulse.models.montant_remise_globale_ttc import MontantRemiseGlobaleTtc as MontantRemiseGlobaleTtc
from factpulse.models.montant_total import MontantTotal as MontantTotal
from factpulse.models.montant_total_acompte import MontantTotalAcompte as MontantTotalAcompte
from factpulse.models.montant_total_ligne_ht import MontantTotalLigneHt as MontantTotalLigneHt
from factpulse.models.montant_ttc_total import MontantTtcTotal as MontantTtcTotal
from factpulse.models.montant_ttc_total1 import MontantTtcTotal1 as MontantTtcTotal1
from factpulse.models.montant_tva import MontantTva as MontantTva
from factpulse.models.montant_tva1 import MontantTva1 as MontantTva1
from factpulse.models.montant_unitaire_ht import MontantUnitaireHt as MontantUnitaireHt
from factpulse.models.obtenir_id_chorus_pro_request import ObtenirIdChorusProRequest as ObtenirIdChorusProRequest
from factpulse.models.obtenir_id_chorus_pro_response import ObtenirIdChorusProResponse as ObtenirIdChorusProResponse
from factpulse.models.options_processing import OptionsProcessing as OptionsProcessing
from factpulse.models.pdf_factur_x_info import PDFFacturXInfo as PDFFacturXInfo
from factpulse.models.pdp_credentials import PDPCredentials as PDPCredentials
from factpulse.models.parametres_signature import ParametresSignature as ParametresSignature
from factpulse.models.parametres_structure import ParametresStructure as ParametresStructure
from factpulse.models.piece_jointe_complementaire import PieceJointeComplementaire as PieceJointeComplementaire
from factpulse.models.profil_api import ProfilAPI as ProfilAPI
from factpulse.models.profil_flux import ProfilFlux as ProfilFlux
from factpulse.models.quantite import Quantite as Quantite
from factpulse.models.quota_info import QuotaInfo as QuotaInfo
from factpulse.models.rechercher_services_response import RechercherServicesResponse as RechercherServicesResponse
from factpulse.models.rechercher_structure_request import RechercherStructureRequest as RechercherStructureRequest
from factpulse.models.rechercher_structure_response import RechercherStructureResponse as RechercherStructureResponse
from factpulse.models.references import References as References
from factpulse.models.reponse_healthcheck_afnor import ReponseHealthcheckAFNOR as ReponseHealthcheckAFNOR
from factpulse.models.reponse_recherche_flux import ReponseRechercheFlux as ReponseRechercheFlux
from factpulse.models.reponse_soumission_flux import ReponseSoumissionFlux as ReponseSoumissionFlux
from factpulse.models.reponse_tache import ReponseTache as ReponseTache
from factpulse.models.reponse_validation_erreur import ReponseValidationErreur as ReponseValidationErreur
from factpulse.models.reponse_validation_succes import ReponseValidationSucces as ReponseValidationSucces
from factpulse.models.requete_recherche_flux import RequeteRechercheFlux as RequeteRechercheFlux
from factpulse.models.requete_soumission_flux import RequeteSoumissionFlux as RequeteSoumissionFlux
from factpulse.models.resultat_afnor import ResultatAFNOR as ResultatAFNOR
from factpulse.models.resultat_chorus_pro import ResultatChorusPro as ResultatChorusPro
from factpulse.models.resultat_validation_pdfapi import ResultatValidationPDFAPI as ResultatValidationPDFAPI
from factpulse.models.scheme_id import SchemeID as SchemeID
from factpulse.models.service_structure import ServiceStructure as ServiceStructure
from factpulse.models.signature_info import SignatureInfo as SignatureInfo
from factpulse.models.soumettre_facture_complete_request import SoumettreFactureCompleteRequest as SoumettreFactureCompleteRequest
from factpulse.models.soumettre_facture_complete_response import SoumettreFactureCompleteResponse as SoumettreFactureCompleteResponse
from factpulse.models.soumettre_facture_request import SoumettreFactureRequest as SoumettreFactureRequest
from factpulse.models.soumettre_facture_response import SoumettreFactureResponse as SoumettreFactureResponse
from factpulse.models.statut_acquittement import StatutAcquittement as StatutAcquittement
from factpulse.models.statut_facture import StatutFacture as StatutFacture
from factpulse.models.statut_tache import StatutTache as StatutTache
from factpulse.models.structure_info import StructureInfo as StructureInfo
from factpulse.models.syntaxe_flux import SyntaxeFlux as SyntaxeFlux
from factpulse.models.tauxmanuel import Tauxmanuel as Tauxmanuel
from factpulse.models.type_facture import TypeFacture as TypeFacture
from factpulse.models.type_flux import TypeFlux as TypeFlux
from factpulse.models.type_tva import TypeTVA as TypeTVA
from factpulse.models.unite import Unite as Unite
from factpulse.models.utilisateur import Utilisateur as Utilisateur
from factpulse.models.validation_error import ValidationError as ValidationError
from factpulse.models.validation_error_loc_inner import ValidationErrorLocInner as ValidationErrorLocInner

