# coding: utf-8

# flake8: noqa
"""
    API REST FactPulse

     API REST pour la facturation électronique en France : Factur-X, AFNOR PDP/PA, signatures électroniques.  ## 🎯 Fonctionnalités principales  ### 📄 Génération de factures Factur-X - **Formats** : XML seul ou PDF/A-3 avec XML embarqué - **Profils** : MINIMUM, BASIC, EN16931, EXTENDED - **Normes** : EN 16931 (directive UE 2014/55), ISO 19005-3 (PDF/A-3), CII (UN/CEFACT) - **🆕 Format simplifié** : Génération à partir de SIRET + auto-enrichissement (API Chorus Pro + Recherche Entreprises)  ### ✅ Validation et conformité - **Validation XML** : Schematron (45 à 210+ règles selon profil) - **Validation PDF** : PDF/A-3, métadonnées XMP Factur-X, signatures électroniques - **VeraPDF** : Validation stricte PDF/A (146+ règles ISO 19005-3) - **Traitement asynchrone** : Support Celery pour validations lourdes (VeraPDF)  ### 📡 Intégration AFNOR PDP/PA (XP Z12-013) - **Soumission de flux** : Envoi de factures vers Plateformes de Dématérialisation Partenaires - **Recherche de flux** : Consultation des factures soumises - **Téléchargement** : Récupération des PDF/A-3 avec XML - **Directory Service** : Recherche d'entreprises (SIREN/SIRET) - **Multi-client** : Support de plusieurs configs PDP par utilisateur (stored credentials ou zero-storage)  ### ✍️ Signature électronique PDF - **Standards** : PAdES-B-B, PAdES-B-T (horodatage RFC 3161), PAdES-B-LT (archivage long terme) - **Niveaux eIDAS** : SES (auto-signé), AdES (CA commerciale), QES (PSCO) - **Validation** : Vérification intégrité cryptographique et certificats - **Génération de certificats** : Certificats X.509 auto-signés pour tests  ### 🔄 Traitement asynchrone - **Celery** : Génération, validation et signature asynchrones - **Polling** : Suivi d'état via `/taches/{id_tache}/statut` - **Pas de timeout** : Idéal pour gros fichiers ou validations lourdes  ## 🔒 Authentification  Toutes les requêtes nécessitent un **token JWT** dans le header Authorization : ``` Authorization: Bearer YOUR_JWT_TOKEN ```  ### Comment obtenir un token JWT ?  #### 🔑 Méthode 1 : API `/api/token/` (Recommandée)  **URL :** `https://www.factpulse.fr/api/token/`  Cette méthode est **recommandée** pour l'intégration dans vos applications et workflows CI/CD.  **Prérequis :** Avoir défini un mot de passe sur votre compte  **Pour les utilisateurs inscrits via email/password :** - Vous avez déjà un mot de passe, utilisez-le directement  **Pour les utilisateurs inscrits via OAuth (Google/GitHub) :** - Vous devez d'abord définir un mot de passe sur : https://www.factpulse.fr/accounts/password/set/ - Une fois le mot de passe créé, vous pourrez utiliser l'API  **Exemple de requête :** ```bash curl -X POST https://www.factpulse.fr/api/token/ \\   -H \"Content-Type: application/json\" \\   -d '{     \"username\": \"votre_email@example.com\",     \"password\": \"votre_mot_de_passe\"   }' ```  **Réponse :** ```json {   \"access\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\",  // Token d'accès (validité: 30 min)   \"refresh\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\"  // Token de rafraîchissement (validité: 7 jours) } ```  **Avantages :** - ✅ Automatisation complète (CI/CD, scripts) - ✅ Gestion programmatique des tokens - ✅ Support du refresh token pour renouveler automatiquement l'accès - ✅ Intégration facile dans n'importe quel langage/outil  #### 🖥️ Méthode 2 : Génération via Dashboard (Alternative)  **URL :** https://www.factpulse.fr/dashboard/  Cette méthode convient pour des tests rapides ou une utilisation occasionnelle via l'interface graphique.  **Fonctionnement :** - Connectez-vous au dashboard - Utilisez les boutons \"Generate Test Token\" ou \"Generate Production Token\" - Fonctionne pour **tous** les utilisateurs (OAuth et email/password), sans nécessiter de mot de passe  **Types de tokens :** - **Token Test** : Validité 24h, quota 1000 appels/jour (gratuit) - **Token Production** : Validité 7 jours, quota selon votre forfait  **Avantages :** - ✅ Rapide pour tester l'API - ✅ Aucun mot de passe requis - ✅ Interface visuelle simple  **Inconvénients :** - ❌ Nécessite une action manuelle - ❌ Pas de refresh token - ❌ Moins adapté pour l'automatisation  ### 📚 Documentation complète  Pour plus d'informations sur l'authentification et l'utilisation de l'API : https://www.factpulse.fr/documentation-api/     

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

# import models into model package
from factpulse.models.adresse_electronique import AdresseElectronique
from factpulse.models.adresse_postale import AdressePostale
from factpulse.models.body_ajouter_fichier_api_v1_chorus_pro_transverses_ajouter_fichier_post import BodyAjouterFichierApiV1ChorusProTransversesAjouterFichierPost
from factpulse.models.body_completer_facture_api_v1_chorus_pro_factures_completer_post import BodyCompleterFactureApiV1ChorusProFacturesCompleterPost
from factpulse.models.body_lister_services_structure_api_v1_chorus_pro_structures_id_structure_cpp_services_get import BodyListerServicesStructureApiV1ChorusProStructuresIdStructureCppServicesGet
from factpulse.models.body_rechercher_factures_destinataire_api_v1_chorus_pro_factures_rechercher_destinataire_post import BodyRechercherFacturesDestinataireApiV1ChorusProFacturesRechercherDestinatairePost
from factpulse.models.body_rechercher_factures_fournisseur_api_v1_chorus_pro_factures_rechercher_fournisseur_post import BodyRechercherFacturesFournisseurApiV1ChorusProFacturesRechercherFournisseurPost
from factpulse.models.body_recycler_facture_api_v1_chorus_pro_factures_recycler_post import BodyRecyclerFactureApiV1ChorusProFacturesRecyclerPost
from factpulse.models.body_telecharger_groupe_factures_api_v1_chorus_pro_factures_telecharger_groupe_post import BodyTelechargerGroupeFacturesApiV1ChorusProFacturesTelechargerGroupePost
from factpulse.models.body_traiter_facture_recue_api_v1_chorus_pro_factures_traiter_facture_recue_post import BodyTraiterFactureRecueApiV1ChorusProFacturesTraiterFactureRecuePost
from factpulse.models.body_valideur_consulter_facture_api_v1_chorus_pro_factures_valideur_consulter_post import BodyValideurConsulterFactureApiV1ChorusProFacturesValideurConsulterPost
from factpulse.models.body_valideur_rechercher_factures_api_v1_chorus_pro_factures_valideur_rechercher_post import BodyValideurRechercherFacturesApiV1ChorusProFacturesValideurRechercherPost
from factpulse.models.body_valideur_traiter_facture_api_v1_chorus_pro_factures_valideur_traiter_post import BodyValideurTraiterFactureApiV1ChorusProFacturesValideurTraiterPost
from factpulse.models.cadre_de_facturation import CadreDeFacturation
from factpulse.models.categorie_tva import CategorieTVA
from factpulse.models.certificate_info_response import CertificateInfoResponse
from factpulse.models.chorus_pro_credentials import ChorusProCredentials
from factpulse.models.code_cadre_facturation import CodeCadreFacturation
from factpulse.models.code_raison_reduction import CodeRaisonReduction
from factpulse.models.consulter_facture_request import ConsulterFactureRequest
from factpulse.models.consulter_facture_response import ConsulterFactureResponse
from factpulse.models.consulter_structure_request import ConsulterStructureRequest
from factpulse.models.consulter_structure_response import ConsulterStructureResponse
from factpulse.models.credentials_afnor import CredentialsAFNOR
from factpulse.models.credentials_chorus_pro import CredentialsChorusPro
from factpulse.models.destinataire import Destinataire
from factpulse.models.destination import Destination
from factpulse.models.destination_afnor import DestinationAFNOR
from factpulse.models.destination_chorus_pro import DestinationChorusPro
from factpulse.models.direction_flux import DirectionFlux
from factpulse.models.donnees_facture_simplifiees import DonneesFactureSimplifiees
from factpulse.models.facture_enrichie_info_input import FactureEnrichieInfoInput
from factpulse.models.facture_enrichie_info_output import FactureEnrichieInfoOutput
from factpulse.models.facture_factur_x import FactureFacturX
from factpulse.models.flux_resume import FluxResume
from factpulse.models.format_sortie import FormatSortie
from factpulse.models.fournisseur import Fournisseur
from factpulse.models.generate_certificate_request import GenerateCertificateRequest
from factpulse.models.generate_certificate_response import GenerateCertificateResponse
from factpulse.models.http_validation_error import HTTPValidationError
from factpulse.models.information_signature_api import InformationSignatureAPI
from factpulse.models.ligne_de_poste import LigneDePoste
from factpulse.models.ligne_de_poste_montant_remise_ht import LigneDePosteMontantRemiseHt
from factpulse.models.ligne_de_poste_taux_tva_manuel import LigneDePosteTauxTvaManuel
from factpulse.models.ligne_de_tva import LigneDeTVA
from factpulse.models.mode_depot import ModeDepot
from factpulse.models.mode_paiement import ModePaiement
from factpulse.models.montant_a_payer import MontantAPayer
from factpulse.models.montant_base_ht import MontantBaseHt
from factpulse.models.montant_ht_total import MontantHtTotal
from factpulse.models.montant_ht_total1 import MontantHtTotal1
from factpulse.models.montant_remise_globale_ttc import MontantRemiseGlobaleTtc
from factpulse.models.montant_total import MontantTotal
from factpulse.models.montant_total_acompte import MontantTotalAcompte
from factpulse.models.montant_total_ligne_ht import MontantTotalLigneHt
from factpulse.models.montant_ttc_total import MontantTtcTotal
from factpulse.models.montant_ttc_total1 import MontantTtcTotal1
from factpulse.models.montant_tva import MontantTva
from factpulse.models.montant_tva1 import MontantTva1
from factpulse.models.montant_unitaire_ht import MontantUnitaireHt
from factpulse.models.obtenir_id_chorus_pro_request import ObtenirIdChorusProRequest
from factpulse.models.obtenir_id_chorus_pro_response import ObtenirIdChorusProResponse
from factpulse.models.options_processing import OptionsProcessing
from factpulse.models.pdf_factur_x_info import PDFFacturXInfo
from factpulse.models.pdp_credentials import PDPCredentials
from factpulse.models.parametres_signature import ParametresSignature
from factpulse.models.parametres_structure import ParametresStructure
from factpulse.models.piece_jointe_complementaire import PieceJointeComplementaire
from factpulse.models.profil_api import ProfilAPI
from factpulse.models.profil_flux import ProfilFlux
from factpulse.models.quantite import Quantite
from factpulse.models.quota_info import QuotaInfo
from factpulse.models.rechercher_services_response import RechercherServicesResponse
from factpulse.models.rechercher_structure_request import RechercherStructureRequest
from factpulse.models.rechercher_structure_response import RechercherStructureResponse
from factpulse.models.references import References
from factpulse.models.reponse_healthcheck_afnor import ReponseHealthcheckAFNOR
from factpulse.models.reponse_recherche_flux import ReponseRechercheFlux
from factpulse.models.reponse_soumission_flux import ReponseSoumissionFlux
from factpulse.models.reponse_tache import ReponseTache
from factpulse.models.reponse_validation_erreur import ReponseValidationErreur
from factpulse.models.reponse_validation_succes import ReponseValidationSucces
from factpulse.models.requete_recherche_flux import RequeteRechercheFlux
from factpulse.models.requete_soumission_flux import RequeteSoumissionFlux
from factpulse.models.resultat_afnor import ResultatAFNOR
from factpulse.models.resultat_chorus_pro import ResultatChorusPro
from factpulse.models.resultat_validation_pdfapi import ResultatValidationPDFAPI
from factpulse.models.scheme_id import SchemeID
from factpulse.models.service_structure import ServiceStructure
from factpulse.models.signature_info import SignatureInfo
from factpulse.models.soumettre_facture_complete_request import SoumettreFactureCompleteRequest
from factpulse.models.soumettre_facture_complete_response import SoumettreFactureCompleteResponse
from factpulse.models.soumettre_facture_request import SoumettreFactureRequest
from factpulse.models.soumettre_facture_response import SoumettreFactureResponse
from factpulse.models.statut_acquittement import StatutAcquittement
from factpulse.models.statut_facture import StatutFacture
from factpulse.models.statut_tache import StatutTache
from factpulse.models.structure_info import StructureInfo
from factpulse.models.syntaxe_flux import SyntaxeFlux
from factpulse.models.tauxmanuel import Tauxmanuel
from factpulse.models.type_facture import TypeFacture
from factpulse.models.type_flux import TypeFlux
from factpulse.models.type_tva import TypeTVA
from factpulse.models.unite import Unite
from factpulse.models.utilisateur import Utilisateur
from factpulse.models.validation_error import ValidationError
from factpulse.models.validation_error_loc_inner import ValidationErrorLocInner

