# coding: utf-8

"""
    API REST FactPulse

     API REST pour la facturation électronique en France : Factur-X, AFNOR PDP/PA, signatures électroniques.  ## 🎯 Fonctionnalités principales  ### 📄 Génération de factures Factur-X - **Formats** : XML seul ou PDF/A-3 avec XML embarqué - **Profils** : MINIMUM, BASIC, EN16931, EXTENDED - **Normes** : EN 16931 (directive UE 2014/55), ISO 19005-3 (PDF/A-3), CII (UN/CEFACT) - **🆕 Format simplifié** : Génération à partir de SIRET + auto-enrichissement (API Chorus Pro + Recherche Entreprises)  ### ✅ Validation et conformité - **Validation XML** : Schematron (45 à 210+ règles selon profil) - **Validation PDF** : PDF/A-3, métadonnées XMP Factur-X, signatures électroniques - **VeraPDF** : Validation stricte PDF/A (146+ règles ISO 19005-3) - **Traitement asynchrone** : Support Celery pour validations lourdes (VeraPDF)  ### 📡 Intégration AFNOR PDP/PA (XP Z12-013) - **Soumission de flux** : Envoi de factures vers Plateformes de Dématérialisation Partenaires - **Recherche de flux** : Consultation des factures soumises - **Téléchargement** : Récupération des PDF/A-3 avec XML - **Directory Service** : Recherche d'entreprises (SIREN/SIRET) - **Multi-client** : Support de plusieurs configs PDP par utilisateur (stored credentials ou zero-storage)  ### ✍️ Signature électronique PDF - **Standards** : PAdES-B-B, PAdES-B-T (horodatage RFC 3161), PAdES-B-LT (archivage long terme) - **Niveaux eIDAS** : SES (auto-signé), AdES (CA commerciale), QES (PSCO) - **Validation** : Vérification intégrité cryptographique et certificats - **Génération de certificats** : Certificats X.509 auto-signés pour tests  ### 🔄 Traitement asynchrone - **Celery** : Génération, validation et signature asynchrones - **Polling** : Suivi d'état via `/taches/{id_tache}/statut` - **Pas de timeout** : Idéal pour gros fichiers ou validations lourdes  ## 🔒 Authentification  Toutes les requêtes nécessitent un **token JWT** dans le header Authorization : ``` Authorization: Bearer YOUR_JWT_TOKEN ```  ### Comment obtenir un token JWT ?  #### 🔑 Méthode 1 : API `/api/token/` (Recommandée)  **URL :** `https://www.factpulse.fr/api/token/`  Cette méthode est **recommandée** pour l'intégration dans vos applications et workflows CI/CD.  **Prérequis :** Avoir défini un mot de passe sur votre compte  **Pour les utilisateurs inscrits via email/password :** - Vous avez déjà un mot de passe, utilisez-le directement  **Pour les utilisateurs inscrits via OAuth (Google/GitHub) :** - Vous devez d'abord définir un mot de passe sur : https://www.factpulse.fr/accounts/password/set/ - Une fois le mot de passe créé, vous pourrez utiliser l'API  **Exemple de requête :** ```bash curl -X POST https://www.factpulse.fr/api/token/ \\   -H \"Content-Type: application/json\" \\   -d '{     \"username\": \"votre_email@example.com\",     \"password\": \"votre_mot_de_passe\"   }' ```  **Réponse :** ```json {   \"access\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\",  // Token d'accès (validité: 30 min)   \"refresh\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\"  // Token de rafraîchissement (validité: 7 jours) } ```  **Avantages :** - ✅ Automatisation complète (CI/CD, scripts) - ✅ Gestion programmatique des tokens - ✅ Support du refresh token pour renouveler automatiquement l'accès - ✅ Intégration facile dans n'importe quel langage/outil  #### 🖥️ Méthode 2 : Génération via Dashboard (Alternative)  **URL :** https://www.factpulse.fr/dashboard/  Cette méthode convient pour des tests rapides ou une utilisation occasionnelle via l'interface graphique.  **Fonctionnement :** - Connectez-vous au dashboard - Utilisez les boutons \"Generate Test Token\" ou \"Generate Production Token\" - Fonctionne pour **tous** les utilisateurs (OAuth et email/password), sans nécessiter de mot de passe  **Types de tokens :** - **Token Test** : Validité 24h, quota 1000 appels/jour (gratuit) - **Token Production** : Validité 7 jours, quota selon votre forfait  **Avantages :** - ✅ Rapide pour tester l'API - ✅ Aucun mot de passe requis - ✅ Interface visuelle simple  **Inconvénients :** - ❌ Nécessite une action manuelle - ❌ Pas de refresh token - ❌ Moins adapté pour l'automatisation  ### 📚 Documentation complète  Pour plus d'informations sur l'authentification et l'utilisation de l'API : https://www.factpulse.fr/documentation-api/     

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from factpulse.models.cadre_de_facturation import CadreDeFacturation
from factpulse.models.destinataire import Destinataire
from factpulse.models.fournisseur import Fournisseur
from factpulse.models.ligne_de_poste import LigneDePoste
from factpulse.models.ligne_de_tva import LigneDeTVA
from factpulse.models.mode_depot import ModeDepot
from factpulse.models.montant_total import MontantTotal
from factpulse.models.piece_jointe_complementaire import PieceJointeComplementaire
from factpulse.models.references import References
from typing import Optional, Set
from typing_extensions import Self

class FactureFacturX(BaseModel):
    """
    Modèle de données pour une facture destinée à être convertie en Factur-X.
    """ # noqa: E501
    numero_facture: StrictStr = Field(alias="numeroFacture")
    date_echeance_paiement: StrictStr = Field(alias="dateEcheancePaiement")
    date_facture: Optional[StrictStr] = Field(default=None, alias="dateFacture")
    mode_depot: ModeDepot = Field(alias="modeDepot")
    destinataire: Destinataire
    fournisseur: Fournisseur
    cadre_de_facturation: CadreDeFacturation = Field(alias="cadreDeFacturation")
    references: References
    montant_total: MontantTotal = Field(alias="montantTotal")
    lignes_de_poste: Optional[List[LigneDePoste]] = Field(default=None, alias="lignesDePoste")
    lignes_de_tva: Optional[List[LigneDeTVA]] = Field(default=None, alias="lignesDeTva")
    commentaire: Optional[StrictStr] = None
    id_utilisateur_courant: Optional[StrictInt] = Field(default=None, alias="idUtilisateurCourant")
    pieces_jointes_complementaires: Optional[List[PieceJointeComplementaire]] = Field(default=None, alias="piecesJointesComplementaires")
    __properties: ClassVar[List[str]] = ["numeroFacture", "dateEcheancePaiement", "dateFacture", "modeDepot", "destinataire", "fournisseur", "cadreDeFacturation", "references", "montantTotal", "lignesDePoste", "lignesDeTva", "commentaire", "idUtilisateurCourant", "piecesJointesComplementaires"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FactureFacturX from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of destinataire
        if self.destinataire:
            _dict['destinataire'] = self.destinataire.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fournisseur
        if self.fournisseur:
            _dict['fournisseur'] = self.fournisseur.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cadre_de_facturation
        if self.cadre_de_facturation:
            _dict['cadreDeFacturation'] = self.cadre_de_facturation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of references
        if self.references:
            _dict['references'] = self.references.to_dict()
        # override the default output from pydantic by calling `to_dict()` of montant_total
        if self.montant_total:
            _dict['montantTotal'] = self.montant_total.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in lignes_de_poste (list)
        _items = []
        if self.lignes_de_poste:
            for _item_lignes_de_poste in self.lignes_de_poste:
                if _item_lignes_de_poste:
                    _items.append(_item_lignes_de_poste.to_dict())
            _dict['lignesDePoste'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in lignes_de_tva (list)
        _items = []
        if self.lignes_de_tva:
            for _item_lignes_de_tva in self.lignes_de_tva:
                if _item_lignes_de_tva:
                    _items.append(_item_lignes_de_tva.to_dict())
            _dict['lignesDeTva'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pieces_jointes_complementaires (list)
        _items = []
        if self.pieces_jointes_complementaires:
            for _item_pieces_jointes_complementaires in self.pieces_jointes_complementaires:
                if _item_pieces_jointes_complementaires:
                    _items.append(_item_pieces_jointes_complementaires.to_dict())
            _dict['piecesJointesComplementaires'] = _items
        # set to None if commentaire (nullable) is None
        # and model_fields_set contains the field
        if self.commentaire is None and "commentaire" in self.model_fields_set:
            _dict['commentaire'] = None

        # set to None if id_utilisateur_courant (nullable) is None
        # and model_fields_set contains the field
        if self.id_utilisateur_courant is None and "id_utilisateur_courant" in self.model_fields_set:
            _dict['idUtilisateurCourant'] = None

        # set to None if pieces_jointes_complementaires (nullable) is None
        # and model_fields_set contains the field
        if self.pieces_jointes_complementaires is None and "pieces_jointes_complementaires" in self.model_fields_set:
            _dict['piecesJointesComplementaires'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FactureFacturX from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "numeroFacture": obj.get("numeroFacture"),
            "dateEcheancePaiement": obj.get("dateEcheancePaiement"),
            "dateFacture": obj.get("dateFacture"),
            "modeDepot": obj.get("modeDepot"),
            "destinataire": Destinataire.from_dict(obj["destinataire"]) if obj.get("destinataire") is not None else None,
            "fournisseur": Fournisseur.from_dict(obj["fournisseur"]) if obj.get("fournisseur") is not None else None,
            "cadreDeFacturation": CadreDeFacturation.from_dict(obj["cadreDeFacturation"]) if obj.get("cadreDeFacturation") is not None else None,
            "references": References.from_dict(obj["references"]) if obj.get("references") is not None else None,
            "montantTotal": MontantTotal.from_dict(obj["montantTotal"]) if obj.get("montantTotal") is not None else None,
            "lignesDePoste": [LigneDePoste.from_dict(_item) for _item in obj["lignesDePoste"]] if obj.get("lignesDePoste") is not None else None,
            "lignesDeTva": [LigneDeTVA.from_dict(_item) for _item in obj["lignesDeTva"]] if obj.get("lignesDeTva") is not None else None,
            "commentaire": obj.get("commentaire"),
            "idUtilisateurCourant": obj.get("idUtilisateurCourant"),
            "piecesJointesComplementaires": [PieceJointeComplementaire.from_dict(_item) for _item in obj["piecesJointesComplementaires"]] if obj.get("piecesJointesComplementaires") is not None else None
        })
        return _obj


