# coding: utf-8

"""
    API REST FactPulse

     API REST pour la facturation électronique en France : Factur-X, AFNOR PDP/PA, signatures électroniques.  ## 🎯 Fonctionnalités principales  ### 📄 Génération de factures Factur-X - **Formats** : XML seul ou PDF/A-3 avec XML embarqué - **Profils** : MINIMUM, BASIC, EN16931, EXTENDED - **Normes** : EN 16931 (directive UE 2014/55), ISO 19005-3 (PDF/A-3), CII (UN/CEFACT) - **🆕 Format simplifié** : Génération à partir de SIRET + auto-enrichissement (API Chorus Pro + Recherche Entreprises)  ### ✅ Validation et conformité - **Validation XML** : Schematron (45 à 210+ règles selon profil) - **Validation PDF** : PDF/A-3, métadonnées XMP Factur-X, signatures électroniques - **VeraPDF** : Validation stricte PDF/A (146+ règles ISO 19005-3) - **Traitement asynchrone** : Support Celery pour validations lourdes (VeraPDF)  ### 📡 Intégration AFNOR PDP/PA (XP Z12-013) - **Soumission de flux** : Envoi de factures vers Plateformes de Dématérialisation Partenaires - **Recherche de flux** : Consultation des factures soumises - **Téléchargement** : Récupération des PDF/A-3 avec XML - **Directory Service** : Recherche d'entreprises (SIREN/SIRET) - **Multi-client** : Support de plusieurs configs PDP par utilisateur (stored credentials ou zero-storage)  ### ✍️ Signature électronique PDF - **Standards** : PAdES-B-B, PAdES-B-T (horodatage RFC 3161), PAdES-B-LT (archivage long terme) - **Niveaux eIDAS** : SES (auto-signé), AdES (CA commerciale), QES (PSCO) - **Validation** : Vérification intégrité cryptographique et certificats - **Génération de certificats** : Certificats X.509 auto-signés pour tests  ### 🔄 Traitement asynchrone - **Celery** : Génération, validation et signature asynchrones - **Polling** : Suivi d'état via `/taches/{id_tache}/statut` - **Pas de timeout** : Idéal pour gros fichiers ou validations lourdes  ## 🔒 Authentification  Toutes les requêtes nécessitent un **token JWT** dans le header Authorization : ``` Authorization: Bearer YOUR_JWT_TOKEN ```  ### Comment obtenir un token JWT ?  #### 🔑 Méthode 1 : API `/api/token/` (Recommandée)  **URL :** `https://www.factpulse.fr/api/token/`  Cette méthode est **recommandée** pour l'intégration dans vos applications et workflows CI/CD.  **Prérequis :** Avoir défini un mot de passe sur votre compte  **Pour les utilisateurs inscrits via email/password :** - Vous avez déjà un mot de passe, utilisez-le directement  **Pour les utilisateurs inscrits via OAuth (Google/GitHub) :** - Vous devez d'abord définir un mot de passe sur : https://www.factpulse.fr/accounts/password/set/ - Une fois le mot de passe créé, vous pourrez utiliser l'API  **Exemple de requête :** ```bash curl -X POST https://www.factpulse.fr/api/token/ \\   -H \"Content-Type: application/json\" \\   -d '{     \"username\": \"votre_email@example.com\",     \"password\": \"votre_mot_de_passe\"   }' ```  **Réponse :** ```json {   \"access\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\",  // Token d'accès (validité: 30 min)   \"refresh\": \"eyJ0eXAiOiJKV1QiLCJhbGc...\"  // Token de rafraîchissement (validité: 7 jours) } ```  **Avantages :** - ✅ Automatisation complète (CI/CD, scripts) - ✅ Gestion programmatique des tokens - ✅ Support du refresh token pour renouveler automatiquement l'accès - ✅ Intégration facile dans n'importe quel langage/outil  #### 🖥️ Méthode 2 : Génération via Dashboard (Alternative)  **URL :** https://www.factpulse.fr/dashboard/  Cette méthode convient pour des tests rapides ou une utilisation occasionnelle via l'interface graphique.  **Fonctionnement :** - Connectez-vous au dashboard - Utilisez les boutons \"Generate Test Token\" ou \"Generate Production Token\" - Fonctionne pour **tous** les utilisateurs (OAuth et email/password), sans nécessiter de mot de passe  **Types de tokens :** - **Token Test** : Validité 24h, quota 1000 appels/jour (gratuit) - **Token Production** : Validité 7 jours, quota selon votre forfait  **Avantages :** - ✅ Rapide pour tester l'API - ✅ Aucun mot de passe requis - ✅ Interface visuelle simple  **Inconvénients :** - ❌ Nécessite une action manuelle - ❌ Pas de refresh token - ❌ Moins adapté pour l'automatisation  ### 📚 Documentation complète  Pour plus d'informations sur l'authentification et l'utilisation de l'API : https://www.factpulse.fr/documentation-api/     

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest

from factpulse.models.facture_factur_x import FactureFacturX

class TestFactureFacturX(unittest.TestCase):
    """FactureFacturX unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional) -> FactureFacturX:
        """Test FactureFacturX
            include_optional is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `FactureFacturX`
        """
        model = FactureFacturX()
        if include_optional:
            return FactureFacturX(
                numero_facture = '',
                date_echeance_paiement = '',
                date_facture = '',
                mode_depot = 'SAISIE_API',
                destinataire = factpulse.models.destinataire.Destinataire(
                    adresse_electronique = factpulse.models.adresse_electronique.AdresseElectronique(
                        identifiant = '', 
                        scheme_id = '0225', ), 
                    code_service_executant = '', 
                    nom = '', 
                    adresse_postale = factpulse.models.adresse_postale.AdressePostale(
                        code_postal = '', 
                        ligne_un = '', 
                        ligne_deux = '', 
                        nom_ville = '', 
                        pays_code_iso = '', ), ),
                fournisseur = factpulse.models.fournisseur.Fournisseur(
                    adresse_electronique = factpulse.models.adresse_electronique.AdresseElectronique(
                        identifiant = '', 
                        scheme_id = '0225', ), 
                    id_fournisseur = 56, 
                    code_coordonnees_bancaires_fournisseur = 56, 
                    id_service_fournisseur = 56, 
                    nom = '', 
                    siret = '', 
                    numero_tva_intra = '', 
                    iban = '', 
                    adresse_postale = factpulse.models.adresse_postale.AdressePostale(
                        code_postal = '', 
                        ligne_un = '', 
                        ligne_deux = '', 
                        nom_ville = '', 
                        pays_code_iso = '', ), ),
                cadre_de_facturation = factpulse.models.cadre_de_facturation.CadreDeFacturation(
                    code_cadre_facturation = 'A1_FACTURE_FOURNISSEUR', 
                    code_service_valideur = '', 
                    code_structure_valideur = '', ),
                references = factpulse.models.references.References(
                    devise_facture = 'EUR', 
                    mode_paiement = 'CHEQUE', 
                    type_facture = 'FACTURE', 
                    type_tva = 'TVA_SUR_DEBIT', 
                    numero_marche = '', 
                    motif_exoneration_tva = '', 
                    numero_bon_commande = '', 
                    numero_facture_origine = '', ),
                montant_total = factpulse.models.montant_total.MontantTotal(
                    montant_ht_total = null, 
                    montant_tva = null, 
                    montant_ttc_total = null, 
                    montant_a_payer = null, 
                    acompte = null, 
                    montant_remise_globale_ttc = null, 
                    motif_remise_globale_ttc = '', ),
                lignes_de_poste = [
                    factpulse.models.ligne_de_poste.LigneDePoste(
                        numero = 56, 
                        reference = '', 
                        denomination = '', 
                        quantite = null, 
                        unite = 'PIECE', 
                        montant_unitaire_ht = null, 
                        montant_remise_ht = null, 
                        montant_total_ligne_ht = null, 
                        taux_tva = '', 
                        taux_tva_manuel = null, 
                        categorie_tva = 'S', 
                        date_debut_periode = '', 
                        date_fin_periode = '', 
                        code_raison_reduction = 'AA', 
                        raison_reduction = '', )
                    ],
                lignes_de_tva = [
                    factpulse.models.ligne_de_tva.LigneDeTVA(
                        montant_base_ht = null, 
                        montant_tva = null, 
                        taux = '', 
                        taux_manuel = null, 
                        categorie = 'S', )
                    ],
                commentaire = '',
                id_utilisateur_courant = 56,
                pieces_jointes_complementaires = [
                    factpulse.models.piece_jointe_complementaire.PieceJointeComplementaire(
                        designation = '', 
                        id = 56, 
                        id_liaison = 56, 
                        numero_ligne_facture = 56, 
                        type = '', )
                    ]
            )
        else:
            return FactureFacturX(
                numero_facture = '',
                date_echeance_paiement = '',
                mode_depot = 'SAISIE_API',
                destinataire = factpulse.models.destinataire.Destinataire(
                    adresse_electronique = factpulse.models.adresse_electronique.AdresseElectronique(
                        identifiant = '', 
                        scheme_id = '0225', ), 
                    code_service_executant = '', 
                    nom = '', 
                    adresse_postale = factpulse.models.adresse_postale.AdressePostale(
                        code_postal = '', 
                        ligne_un = '', 
                        ligne_deux = '', 
                        nom_ville = '', 
                        pays_code_iso = '', ), ),
                fournisseur = factpulse.models.fournisseur.Fournisseur(
                    adresse_electronique = factpulse.models.adresse_electronique.AdresseElectronique(
                        identifiant = '', 
                        scheme_id = '0225', ), 
                    id_fournisseur = 56, 
                    code_coordonnees_bancaires_fournisseur = 56, 
                    id_service_fournisseur = 56, 
                    nom = '', 
                    siret = '', 
                    numero_tva_intra = '', 
                    iban = '', 
                    adresse_postale = factpulse.models.adresse_postale.AdressePostale(
                        code_postal = '', 
                        ligne_un = '', 
                        ligne_deux = '', 
                        nom_ville = '', 
                        pays_code_iso = '', ), ),
                cadre_de_facturation = factpulse.models.cadre_de_facturation.CadreDeFacturation(
                    code_cadre_facturation = 'A1_FACTURE_FOURNISSEUR', 
                    code_service_valideur = '', 
                    code_structure_valideur = '', ),
                references = factpulse.models.references.References(
                    devise_facture = 'EUR', 
                    mode_paiement = 'CHEQUE', 
                    type_facture = 'FACTURE', 
                    type_tva = 'TVA_SUR_DEBIT', 
                    numero_marche = '', 
                    motif_exoneration_tva = '', 
                    numero_bon_commande = '', 
                    numero_facture_origine = '', ),
                montant_total = factpulse.models.montant_total.MontantTotal(
                    montant_ht_total = null, 
                    montant_tva = null, 
                    montant_ttc_total = null, 
                    montant_a_payer = null, 
                    acompte = null, 
                    montant_remise_globale_ttc = null, 
                    motif_remise_globale_ttc = '', ),
        )
        """

    def testFactureFacturX(self):
        """Test FactureFacturX"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
