# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class ApplyEciScalingConfigurationRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        format: str = None,
        region_id: str = None,
        scaling_configuration_id: str = None,
        scaling_group_id: str = None,
    ):
        # The content of the configuration file.
        # 
        # This parameter is required.
        self.content = content
        # Optional. Set the value to YAML.
        self.format = format
        # The region ID.
        self.region_id = region_id
        # The ID of the scaling configuration.
        # 
        # If you want the system to update a scaling configuration of the Elastic Container Instance type based on a YAML configuration file, you must specify `ScalingConfigurationId`. If you do not specify `ScalingConfigurationId`, the system creates a new scaling configuration based on the YAML configuration file.
        self.scaling_configuration_id = scaling_configuration_id
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class ApplyEciScalingConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_configuration_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the scaling configuration.
        self.scaling_configuration_id = scaling_configuration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        return self


class ApplyEciScalingConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyEciScalingConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyEciScalingConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyScalingGroupRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        format: str = None,
        region_id: str = None,
    ):
        # The content of the configuration file.
        # 
        # This parameter is required.
        self.content = content
        # Optional. The format of the configuration file. Default value: YAML. Set the value to YAML.
        self.format = format
        # The region ID.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ApplyScalingGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_group_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the enabled scaling group.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class ApplyScalingGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyScalingGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachAlbServerGroupsRequestAlbServerGroups(TeaModel):
    def __init__(
        self,
        alb_server_group_id: str = None,
        port: int = None,
        weight: int = None,
    ):
        # The ID of the ALB server group.
        # 
        # You can attach only a limited number of ALB server groups to a scaling group. To view the predefined quota limit or manually request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        # 
        # This parameter is required.
        self.alb_server_group_id = alb_server_group_id
        # The port used by ECS instances or elastic container instances after being added as backend servers to the ALB server group.
        # 
        # Valid values: 1 to 65535.
        # 
        # This parameter is required.
        self.port = port
        # The weight of an ECS instance or elastic container instance after being added as a backend server to the ALB server group. Valid values: 0 to 100.
        # 
        # If you assign a higher weight to an instance, the instance is allocated a larger proportion of access requests. If you assign zero weight to an instance, the instance is allocated no access requests.
        # 
        # This parameter is required.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alb_server_group_id is not None:
            result['AlbServerGroupId'] = self.alb_server_group_id
        if self.port is not None:
            result['Port'] = self.port
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlbServerGroupId') is not None:
            self.alb_server_group_id = m.get('AlbServerGroupId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class AttachAlbServerGroupsRequest(TeaModel):
    def __init__(
        self,
        alb_server_groups: List[AttachAlbServerGroupsRequestAlbServerGroups] = None,
        client_token: str = None,
        force_attach: bool = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        # The information about the ALB server groups.
        # 
        # This parameter is required.
        self.alb_server_groups = alb_server_groups
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [Ensure idempotence](https://help.aliyun.com/document_detail/25965.html).
        self.client_token = client_token
        # Specifies whether to add the existing Elastic Compute Service (ECS) instances or elastic container instances in the scaling group to the new ALB server group. Valid values:
        # 
        # *   true: adds the existing ECS instances or elastic container instances in the scaling group to the new ALB server group and returns the value of `ScalingActivityId`. You can query the value of ScalingActivityId to check whether the existing ECS instances are added to the ALB server group.
        # *   false: does not add the existing ECS instances or elastic container instances in the scaling group to the new ALB server group.
        # 
        # Default value: false.
        self.force_attach = force_attach
        self.owner_id = owner_id
        # The region ID of the scaling group.
        # 
        # Examples: `cn-hangzhou` and `cn-shanghai`. For more information about regions and zones, see [Regions and zones](https://help.aliyun.com/document_detail/40654.html).
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        if self.alb_server_groups:
            for k in self.alb_server_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlbServerGroups'] = []
        if self.alb_server_groups is not None:
            for k in self.alb_server_groups:
                result['AlbServerGroups'].append(k.to_map() if k else None)
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.force_attach is not None:
            result['ForceAttach'] = self.force_attach
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alb_server_groups = []
        if m.get('AlbServerGroups') is not None:
            for k in m.get('AlbServerGroups'):
                temp_model = AttachAlbServerGroupsRequestAlbServerGroups()
                self.alb_server_groups.append(temp_model.from_map(k))
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ForceAttach') is not None:
            self.force_attach = m.get('ForceAttach')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class AttachAlbServerGroupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_activity_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the scaling activity. During the scaling activity, the ALB server group is attached to the scaling group and the existing ECS instances or elastic container instances in the scaling group are added to the ALB server group.
        # 
        # >  This parameter is returned only if you set `ForceAttach` to `true`.
        self.scaling_activity_id = scaling_activity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_activity_id is not None:
            result['ScalingActivityId'] = self.scaling_activity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingActivityId') is not None:
            self.scaling_activity_id = m.get('ScalingActivityId')
        return self


class AttachAlbServerGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachAlbServerGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachAlbServerGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachDBInstancesRequest(TeaModel):
    def __init__(
        self,
        attach_mode: str = None,
        client_token: str = None,
        dbinstances: List[str] = None,
        force_attach: bool = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
        type: str = None,
    ):
        # The mode in which you want to attach the database to the scaling group. Valid values:
        # 
        # *   SecurityIp: adds the private IP addresses of scaled out ECS instances to the IP address whitelist of the database. Take note that you can choose this mode only when the database that you want to attach is an ApsaraDB RDS instance.
        # *   SecurityGroup: adds the security group of the scaling configuration based on which ECS instances are created in the scaling group to the security group whitelist of the database for registration.
        # 
        # Default value: SecurityIp.
        self.attach_mode = attach_mode
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the value, but you must ensure that the value is unique among different requests.
        # 
        # The token can only contain ASCII characters and cannot exceed 64 characters in length. For more information, see [How to ensure the idempotence of a request](https://help.aliyun.com/document_detail/25965.html).
        self.client_token = client_token
        # The IDs of the ApsaraDB RDS instances that you want to attach to the scaling group.
        # 
        # This parameter is required.
        self.dbinstances = dbinstances
        # Specifies whether to add the private IP addresses of all ECS instances in the scaling group to the IP address whitelist of the ApsaraDB RDS instance that you want to attach to the scaling group. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        self.force_attach = force_attach
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id
        # The type of the database that you want to attach to the scaling group. Valid values:
        # 
        # *   RDS
        # *   Redis
        # *   MongoDB
        # 
        # Default value: RDS.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attach_mode is not None:
            result['AttachMode'] = self.attach_mode
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dbinstances is not None:
            result['DBInstances'] = self.dbinstances
        if self.force_attach is not None:
            result['ForceAttach'] = self.force_attach
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttachMode') is not None:
            self.attach_mode = m.get('AttachMode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DBInstances') is not None:
            self.dbinstances = m.get('DBInstances')
        if m.get('ForceAttach') is not None:
            self.force_attach = m.get('ForceAttach')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AttachDBInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachDBInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachDBInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachDBInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachInstancesRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        entrusted: bool = None,
        ignore_invalid_instance: bool = None,
        instance_ids: List[str] = None,
        lifecycle_hook: bool = None,
        load_balancer_weights: List[int] = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        scaling_group_id: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [Ensure idempotence](https://help.aliyun.com/document_detail/25965.html).
        self.client_token = client_token
        # Specifies whether to use the scaling group to manage the lifecycles of manually added instances. Valid values:
        # 
        # *   true: The scaling group manages the lifecycles of manually added instances and automatically created instances in the same manner. In this case, Auto Scaling releases the instances when they are removed from the scaling group. This rule does not apply to instances that are removed by calling the DetachInstances operation.
        # *   false: The scaling group does not manage the lifecycles of manually added instances. In this case, Auto Scaling does not release the instances when they are removed from the scaling group.
        # 
        # >  You cannot specify this parameter for subscription instances, non-Alibaba Cloud instances, and instances in Economical Mode.
        # 
        # Default value: false.
        self.entrusted = entrusted
        # Specifies whether to ignore invalid instances when a batch of instances is added to the scaling group. Valid values:
        # 
        # *   true: ignores invalid instances. If invalid instances exist and valid instances are added, the corresponding scaling activity enters the Warning state. You can check the scaling activity details to view the invalid instances that are ignored.
        # *   false: does not ignore invalid instances. If invalid instances exist in the batch of instances that you want to add to the scaling group, an error is reported.
        # 
        # Default value: false.
        self.ignore_invalid_instance = ignore_invalid_instance
        # The IDs of the ECS instances, elastic container instances, non-Alibaba Cloud instances, or instances in Economical Mode.
        self.instance_ids = instance_ids
        # Specifies whether to trigger the lifecycle hook for scale-outs when you call this operation. Valid values:
        # 
        # *   true
        # *   false
        # 
        # >  You cannot specify this parameter for subscription instances and instances in Economical Mode.
        # 
        # Default value: false.
        self.lifecycle_hook = lifecycle_hook
        # The weight of an ECS instance or elastic container instance as a backend server. You can use this parameter to specify weights for multiple instances at the same time.
        self.load_balancer_weights = load_balancer_weights
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.entrusted is not None:
            result['Entrusted'] = self.entrusted
        if self.ignore_invalid_instance is not None:
            result['IgnoreInvalidInstance'] = self.ignore_invalid_instance
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.lifecycle_hook is not None:
            result['LifecycleHook'] = self.lifecycle_hook
        if self.load_balancer_weights is not None:
            result['LoadBalancerWeights'] = self.load_balancer_weights
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Entrusted') is not None:
            self.entrusted = m.get('Entrusted')
        if m.get('IgnoreInvalidInstance') is not None:
            self.ignore_invalid_instance = m.get('IgnoreInvalidInstance')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('LifecycleHook') is not None:
            self.lifecycle_hook = m.get('LifecycleHook')
        if m.get('LoadBalancerWeights') is not None:
            self.load_balancer_weights = m.get('LoadBalancerWeights')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class AttachInstancesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_activity_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the scaling activity.
        self.scaling_activity_id = scaling_activity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_activity_id is not None:
            result['ScalingActivityId'] = self.scaling_activity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingActivityId') is not None:
            self.scaling_activity_id = m.get('ScalingActivityId')
        return self


class AttachInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachLoadBalancersRequestLoadBalancerConfigs(TeaModel):
    def __init__(
        self,
        load_balancer_id: str = None,
        weight: int = None,
    ):
        # The ID of the CLB instance.
        self.load_balancer_id = load_balancer_id
        # The weight of an Elastic Compute Service (ECS) instance or elastic container instance as a backend sever of the CLB instance. If an instance has a higher weight, more access traffic is routed to the instance. If an instance has zero weight, no access traffic is routed to the instance.
        # 
        # Valid values: 0 to 100.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class AttachLoadBalancersRequest(TeaModel):
    def __init__(
        self,
        async_: bool = None,
        client_token: str = None,
        force_attach: bool = None,
        load_balancer_configs: List[AttachLoadBalancersRequestLoadBalancerConfigs] = None,
        load_balancers: List[str] = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        # Specifies whether to attach the CLB instance to the scaling group in an asynchronous manner. If you attach the CLB instance from the scaling group in an asynchronous manner, the call is successful only after all operations are successful. If a specific operation fails, the call fails. We recommend that you set this parameter to true. Valid values:
        # 
        # *   true: attaches the CLB instance to the scaling group in an asynchronous manner. In this case, the ID of the scaling activity is returned.
        # *   false: does not attach the CLB instance to the scaling group in an asynchronous manner.
        # 
        # Default value: false.
        self.async_ = async_
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [Ensure idempotence](https://help.aliyun.com/document_detail/25965.html).
        self.client_token = client_token
        # Specifies whether to add the existing instances in the scaling group as backend servers of the load balancer. Valid values:
        # 
        # *   true: If you set this parameter to `true`, the attachment of the load balancer entails the addition of the existing instances in the scaling group to the backend server groups of the load balancer.
        # 
        #     **\
        # 
        #     **Note** If a load balancer is currently attached to your scaling group, and you only want to add the instances in your scaling group to the backend server groups of the load balancer, you can call this operation again and set ForceAttach request to true.
        # 
        # *   false: If you set this parameter to false, the attachment of the load balancer does not entail the addition of the existing instances in the scaling group to the backend server groups of the load balancer.
        # 
        # Default value: false.
        self.force_attach = force_attach
        # The configurations of the classic load balancer (CLB, formerly known as SLB) instance.
        self.load_balancer_configs = load_balancer_configs
        # The IDs of the load balancers that you want to attach to the scaling group.
        self.load_balancers = load_balancers
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        if self.load_balancer_configs:
            for k in self.load_balancer_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.async_ is not None:
            result['Async'] = self.async_
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.force_attach is not None:
            result['ForceAttach'] = self.force_attach
        result['LoadBalancerConfigs'] = []
        if self.load_balancer_configs is not None:
            for k in self.load_balancer_configs:
                result['LoadBalancerConfigs'].append(k.to_map() if k else None)
        if self.load_balancers is not None:
            result['LoadBalancers'] = self.load_balancers
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Async') is not None:
            self.async_ = m.get('Async')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ForceAttach') is not None:
            self.force_attach = m.get('ForceAttach')
        self.load_balancer_configs = []
        if m.get('LoadBalancerConfigs') is not None:
            for k in m.get('LoadBalancerConfigs'):
                temp_model = AttachLoadBalancersRequestLoadBalancerConfigs()
                self.load_balancer_configs.append(temp_model.from_map(k))
        if m.get('LoadBalancers') is not None:
            self.load_balancers = m.get('LoadBalancers')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class AttachLoadBalancersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_activity_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the scaling activity.
        # 
        # This parameter is returned only if you set `Async` to `true`. You can call the DescribeScalingActivities operation to query the scaling activity IDs and status.
        self.scaling_activity_id = scaling_activity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_activity_id is not None:
            result['ScalingActivityId'] = self.scaling_activity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingActivityId') is not None:
            self.scaling_activity_id = m.get('ScalingActivityId')
        return self


class AttachLoadBalancersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachLoadBalancersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachLoadBalancersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachServerGroupsRequestServerGroups(TeaModel):
    def __init__(
        self,
        port: int = None,
        server_group_id: str = None,
        type: str = None,
        weight: int = None,
    ):
        # The port used by ECS instances or elastic container instances after being added as backend servers to the server group.
        # 
        # Valid values: 1 to 65535.
        # 
        # This parameter is required.
        self.port = port
        # The ID of the server group.
        # 
        # This parameter is required.
        self.server_group_id = server_group_id
        # The type of the server group. Valid values:
        # 
        # *   ALB
        # *   NLB
        # 
        # This parameter is required.
        self.type = type
        # The weight of an ECS instance or elastic container instance as a backend server of the server group. Valid values: 0 to 100.
        # 
        # If you assign a higher weight to an instance, the instance is allocated a larger proportion of access requests. If you assign zero weight to an instance, the instance is allocated no access requests.
        # 
        # This parameter is required.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.server_group_id is not None:
            result['ServerGroupId'] = self.server_group_id
        if self.type is not None:
            result['Type'] = self.type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ServerGroupId') is not None:
            self.server_group_id = m.get('ServerGroupId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class AttachServerGroupsRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        force_attach: bool = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
        server_groups: List[AttachServerGroupsRequestServerGroups] = None,
    ):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [Ensure idempotence](https://help.aliyun.com/document_detail/25965.html).
        self.client_token = client_token
        # Specifies whether to add the existing Elastic Compute Service (ECS) instances or elastic container instances in the scaling group to the server group. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        self.force_attach = force_attach
        self.owner_id = owner_id
        # The region ID of the scaling group.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id
        # The information about the server groups.
        # 
        # This parameter is required.
        self.server_groups = server_groups

    def validate(self):
        if self.server_groups:
            for k in self.server_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.force_attach is not None:
            result['ForceAttach'] = self.force_attach
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        result['ServerGroups'] = []
        if self.server_groups is not None:
            for k in self.server_groups:
                result['ServerGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ForceAttach') is not None:
            self.force_attach = m.get('ForceAttach')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        self.server_groups = []
        if m.get('ServerGroups') is not None:
            for k in m.get('ServerGroups'):
                temp_model = AttachServerGroupsRequestServerGroups()
                self.server_groups.append(temp_model.from_map(k))
        return self


class AttachServerGroupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_activity_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the scaling activity. During the scaling activity, the server group is attached to the scaling group and the existing ECS instances or elastic container instances in the scaling group are added to the server group.
        # 
        # >  This parameter is returned only if you set ForceAttach to true.
        self.scaling_activity_id = scaling_activity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_activity_id is not None:
            result['ScalingActivityId'] = self.scaling_activity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingActivityId') is not None:
            self.scaling_activity_id = m.get('ScalingActivityId')
        return self


class AttachServerGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachServerGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachServerGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachVServerGroupsRequestVServerGroupsVServerGroupAttributes(TeaModel):
    def __init__(
        self,
        port: int = None,
        vserver_group_id: str = None,
        weight: int = None,
    ):
        # The port number over which Auto Scaling adds ECS instances or elastic container instances to the new vServer group. Valid values: 1 to 65535.
        self.port = port
        # The ID of the vServer group.
        self.vserver_group_id = vserver_group_id
        # The weight of an ECS instance or elastic container instance as a backend server. Valid values: 0 to 100.
        # 
        # Default value: 50.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.vserver_group_id is not None:
            result['VServerGroupId'] = self.vserver_group_id
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('VServerGroupId') is not None:
            self.vserver_group_id = m.get('VServerGroupId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class AttachVServerGroupsRequestVServerGroups(TeaModel):
    def __init__(
        self,
        load_balancer_id: str = None,
        vserver_group_attributes: List[AttachVServerGroupsRequestVServerGroupsVServerGroupAttributes] = None,
    ):
        # The ID of the CLB instance to which the new vServer group belongs.
        self.load_balancer_id = load_balancer_id
        # The attributes of the vServer group.
        self.vserver_group_attributes = vserver_group_attributes

    def validate(self):
        if self.vserver_group_attributes:
            for k in self.vserver_group_attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        result['VServerGroupAttributes'] = []
        if self.vserver_group_attributes is not None:
            for k in self.vserver_group_attributes:
                result['VServerGroupAttributes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        self.vserver_group_attributes = []
        if m.get('VServerGroupAttributes') is not None:
            for k in m.get('VServerGroupAttributes'):
                temp_model = AttachVServerGroupsRequestVServerGroupsVServerGroupAttributes()
                self.vserver_group_attributes.append(temp_model.from_map(k))
        return self


class AttachVServerGroupsRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        force_attach: bool = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
        vserver_groups: List[AttachVServerGroupsRequestVServerGroups] = None,
    ):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [Ensure idempotence](https://help.aliyun.com/document_detail/25965.html).
        self.client_token = client_token
        # Specifies whether to add the existing Elastic Compute Service (ECS) instances or elastic container instances in the scaling group to the new vServer group. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        self.force_attach = force_attach
        self.owner_id = owner_id
        # The region ID of the scaling group. Examples: cn-hangzhou and cn-shanghai. For information about regions and zones, see [Regions and zones](https://help.aliyun.com/document_detail/40654.html).
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id
        # The information about the vServer groups.
        # 
        # This parameter is required.
        self.vserver_groups = vserver_groups

    def validate(self):
        if self.vserver_groups:
            for k in self.vserver_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.force_attach is not None:
            result['ForceAttach'] = self.force_attach
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        result['VServerGroups'] = []
        if self.vserver_groups is not None:
            for k in self.vserver_groups:
                result['VServerGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ForceAttach') is not None:
            self.force_attach = m.get('ForceAttach')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        self.vserver_groups = []
        if m.get('VServerGroups') is not None:
            for k in m.get('VServerGroups'):
                temp_model = AttachVServerGroupsRequestVServerGroups()
                self.vserver_groups.append(temp_model.from_map(k))
        return self


class AttachVServerGroupsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachVServerGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AttachVServerGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachVServerGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelInstanceRefreshRequest(TeaModel):
    def __init__(
        self,
        instance_refresh_task_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        # The ID of the instance refresh task.
        # 
        # This parameter is required.
        self.instance_refresh_task_id = instance_refresh_task_id
        self.owner_id = owner_id
        # The region ID of the scaling group.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_refresh_task_id is not None:
            result['InstanceRefreshTaskId'] = self.instance_refresh_task_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceRefreshTaskId') is not None:
            self.instance_refresh_task_id = m.get('InstanceRefreshTaskId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class CancelInstanceRefreshResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelInstanceRefreshResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelInstanceRefreshResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelInstanceRefreshResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeResourceGroupRequest(TeaModel):
    def __init__(
        self,
        new_resource_group_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_id: str = None,
        resource_owner_account: str = None,
        resource_type: str = None,
    ):
        # The ID of the resource group to which you want to move the scaling group.
        # 
        # This parameter is required.
        self.new_resource_group_id = new_resource_group_id
        self.owner_id = owner_id
        # The region ID of the scaling group.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the scaling group that you want to move from the current resource group to another resource group.
        # 
        # This parameter is required.
        self.resource_id = resource_id
        self.resource_owner_account = resource_owner_account
        # The resource type. Set the value to scalinggroup.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.new_resource_group_id is not None:
            result['NewResourceGroupId'] = self.new_resource_group_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NewResourceGroupId') is not None:
            self.new_resource_group_id = m.get('NewResourceGroupId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class ChangeResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CompleteLifecycleActionRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        lifecycle_action_result: str = None,
        lifecycle_action_token: str = None,
        lifecycle_hook_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [Ensure idempotence](https://help.aliyun.com/document_detail/25965.html).
        self.client_token = client_token
        # The action that you want Auto Scaling to perform after the lifecycle hook times out. Valid values:
        # 
        # *   CONTINUE: Auto Scaling continues to respond to a scale-in or scale-out request.
        # *   ABANDON: Auto Scaling releases Elastic Compute Service (ECS) instances that are created during scale-out activities or removes ECS instances from the scaling group during scale-in activities.
        # *   ROLLBACK: For scale-in activities, Auto Scaling rejects the requests to release ECS instances but rolls back ECS instances. For scale-out activities, the ROLLBACK setting has the same effect as the ABANDON setting.
        # 
        # If you do not specify this parameter, Auto Scaling performs the action that is specified by the `DefaultResult` parameter after the lifecycle hook times out.
        # 
        # If multiple lifecycle hooks exist in a scaling group and the lifecycle hooks are triggered at the same time, the following rules apply:
        # 
        # *   For scale-in activities, when lifecycle hooks whose LifecycleActionResult parameter is set to ABANDON or ROLLBACK time out, other lifecycle hooks time out ahead of schedule.
        # *   For scale-in and scale-out activities, if you set the LifecycleActionResult parameter for all lifecycle hooks to CONTINUE, Auto Scaling performs the next action only after the last lifecycle hook times out. The action that Auto Scaling performs varies based on the value that you specify for the LifecycleActionResult parameter of the lifecycle hook that last times out.
        self.lifecycle_action_result = lifecycle_action_result
        # The token of the lifecycle action. You can obtain the token from the Simple Message Queue (SMQ, formerly MNS) queue or topic that is specified for the lifecycle hook.
        # 
        # This parameter is required.
        self.lifecycle_action_token = lifecycle_action_token
        # The ID of the lifecycle hook.
        # 
        # This parameter is required.
        self.lifecycle_hook_id = lifecycle_hook_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.lifecycle_action_result is not None:
            result['LifecycleActionResult'] = self.lifecycle_action_result
        if self.lifecycle_action_token is not None:
            result['LifecycleActionToken'] = self.lifecycle_action_token
        if self.lifecycle_hook_id is not None:
            result['LifecycleHookId'] = self.lifecycle_hook_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('LifecycleActionResult') is not None:
            self.lifecycle_action_result = m.get('LifecycleActionResult')
        if m.get('LifecycleActionToken') is not None:
            self.lifecycle_action_token = m.get('LifecycleActionToken')
        if m.get('LifecycleHookId') is not None:
            self.lifecycle_hook_id = m.get('LifecycleHookId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        return self


class CompleteLifecycleActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CompleteLifecycleActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CompleteLifecycleActionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CompleteLifecycleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAlarmRequestDimensions(TeaModel):
    def __init__(
        self,
        dimension_key: str = None,
        dimension_value: str = None,
    ):
        # The dimension key of the metric. The valid values vary based on the metric type.
        # 
        # *   If you set MetricType to custom, you can specify this parameter based on your business requirements.
        # 
        # *   If you set MetricType to system, this parameter has the following valid values:
        # 
        #     *   user_id: the ID of your Alibaba Cloud account.
        #     *   scaling_group: the scaling group that you want to monitor by using the event-triggered task.
        #     *   device: the NIC type.
        #     *   state: the status of the TCP connection.
        self.dimension_key = dimension_key
        # The dimension value of the metric. The valid values of this parameter vary based on the value of Dimensions.DimensionKey.
        # 
        # *   If you set MetricType to custom, you can specify this parameter based on your business requirements.
        # 
        # *   If you set MetricType to system, this parameter has the following valid values:
        # 
        #     *   user_id: The system specifies the value.
        # 
        #     *   scaling_group: The system specifies the value.
        # 
        #     *   device: You can set this parameter to eth0 or eth1.
        # 
        #         *   For instances of the classic network type, eth0 specifies the internal NIC. Only one eth0 NIC exists on each instance that resides in VPCs.
        #         *   For instances of the classic network type, eth1 specifies the public NIC.
        # 
        #     *   state: You can set this parameter to TCP_TOTAL or ESTABLISHED.
        # 
        #         *   TCP_TOTAL specifies the total number of TCP connections.
        #         *   ESTABLISHED specifies the number of TCP connections that are established.
        self.dimension_value = dimension_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension_key is not None:
            result['DimensionKey'] = self.dimension_key
        if self.dimension_value is not None:
            result['DimensionValue'] = self.dimension_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DimensionKey') is not None:
            self.dimension_key = m.get('DimensionKey')
        if m.get('DimensionValue') is not None:
            self.dimension_value = m.get('DimensionValue')
        return self


class CreateAlarmRequestExpressions(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        metric_name: str = None,
        period: int = None,
        statistics: str = None,
        threshold: float = None,
    ):
        # The operator that you want to use to compare the metric value and the threshold in the multi-metric alert rule. Valid values:
        # 
        # *   If the metric value is greater than or equal to the threshold, set the value to >=.
        # *   If the metric value is less than or equal to the metric threshold, set the value to <=.
        # *   If the metric value is greater than the metric threshold, set the value to >.
        # *   If the metric value is less than the metric threshold, set the value to <.
        # 
        # Default value: >=.
        self.comparison_operator = comparison_operator
        # The names of the metrics in the multi-metric alert rule. The valid values of this parameter vary based on the metric type.
        # 
        # *   If you set MetricType to custom, the valid values are the metrics that you have.
        # 
        # *   If you set MetricType to system, this parameter has the following valid values:
        # 
        #     *   CpuUtilization: the CPU utilization. Unit: %.
        #     *   ConcurrentConnections: the number of concurrent connections.
        #     *   IntranetTx: the outbound traffic over an internal network. Unit: KB/min.
        #     *   IntranetRx: the inbound traffic over an internal network. Unit: KB/min.
        #     *   VpcInternetTx: the outbound traffic over a VPC. Unit: KB/min.
        #     *   VpcInternetRx: the inbound traffic over a VPC. Unit: KB/min.
        #     *   SystemDiskReadBps: the number of bytes read from the system disk per second.
        #     *   SystemDiskWriteBps: the number of bytes written to the system disk per second.
        #     *   SystemDiskReadOps: the read IOPS of the system disk. Unit: counts/s.
        #     *   SystemDiskWriteOps: the write IOPS of the system disk. Unit: counts/s.
        #     *   CpuUtilizationAgent: the CPU utilization. Unit: %.
        #     *   GpuUtilizationAgent: the GPU utilization. Unit: %.
        #     *   GpuMemoryFreeUtilizationAgent: the idle GPU memory usage. Unit: %.
        #     *   GpuMemoryUtilizationAgent: the GPU memory usage. Unit: %.
        #     *   MemoryUtilization: the memory usage. Unit: %.
        #     *   LoadAverage: the average system load.
        #     *   TcpConnection: the total number of TCP connections.
        #     *   TcpConnection: the number of established TCP connections.
        #     *   PackagesNetOut: the number of packets sent by the internal NIC. Unit: counts/s.
        #     *   PackagesNetIn: the number of packets received by the internal NIC. Unit: counts/s.
        #     *   PackagesNetOut: the number of packets sent by the public NIC. Unit: counts/s.
        #     *   PackagesNetIn: the number of packets received by the public NIC. Unit: counts/s.
        #     *   EciPodCpuUtilization: the CPU utilization. Unit: %.
        #     *   EciPodMemoryUtilization: the memory usage. Unit: %.
        #     *   LoadBalancerRealServerAverageQps: the QPS of an instance.
        # 
        # For more information, see [Event-triggered tasks of the system monitoring type](https://help.aliyun.com/document_detail/74854.html).
        self.metric_name = metric_name
        # The statistical period of the metric data in the multi-metric alert rule. Unit: seconds. Valid values:
        # 
        # *   15
        # *   60
        # *   120
        # *   300
        # *   900
        # 
        # >  You can set this parameter to 15 seconds only for scaling groups of the ECS type.
        # 
        # Default value: 300.
        self.period = period
        # The method that you want to use to aggregate the metric data in the multi-metric alert rule. Valid values:
        # 
        # *   Average: the average value.
        # *   Minimum: the minimum value
        # *   Maximum: the maximum value
        # 
        # Default value: Average.
        self.statistics = statistics
        # The threshold of the metric value in the multi-metric alert rule. If the threshold is reached the specified number of times within the statistical period, a scaling rule is executed.
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class CreateAlarmRequest(TeaModel):
    def __init__(
        self,
        alarm_actions: List[str] = None,
        comparison_operator: str = None,
        description: str = None,
        dimensions: List[CreateAlarmRequestDimensions] = None,
        effective: str = None,
        evaluation_count: int = None,
        expressions: List[CreateAlarmRequestExpressions] = None,
        expressions_logic_operator: str = None,
        group_id: int = None,
        metric_name: str = None,
        metric_type: str = None,
        name: str = None,
        owner_id: int = None,
        period: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
        statistics: str = None,
        threshold: float = None,
    ):
        # The list of unique identifiers of the scaling rules that are associated with the event-triggered task.
        self.alarm_actions = alarm_actions
        # The operator that you want to use to compare the metric value and the threshold. Valid values:
        # 
        # *   If the metric value is greater than or equal to the threshold, set the value to >=.
        # *   If the metric value is less than or equal to the metric threshold, set the value to <=.
        # *   If the metric value is greater than the metric threshold, set the value to >.
        # *   If the metric value is less than the metric threshold, set the value to <.
        # 
        # Default value: >=.
        self.comparison_operator = comparison_operator
        # The description of the event-triggered task.
        self.description = description
        # The metric dimensions.
        self.dimensions = dimensions
        # The effective period of the event-triggered task. By default, the event-triggered task is in effect all the time.
        # 
        # This parameter follows the cron expression format. The default format is `X X X X X ?`. In the format:
        # 
        # *   X: a placeholder for a field, which represents seconds, minutes, hours, days, and months in sequence. X can be a definite value or a special character that has logical meaning. For information about the valid values of X, see [Cron expression](https://help.aliyun.com/document_detail/25907.html).
        # *   ?: No value is specified.
        # 
        # > By default, this parameter value is specified in **UTC+8**. You can specify the time zone in the `TZ=+yy` format before a cron expression. y indicates the time zone. For example, `TZ=+00 * * 1-2 * * ?` specifies that the event-triggered task is in effect between 01:00 and 02:59 (UTC+0) every day.
        # 
        # Sample values:
        # 
        # *   ` * * * * * ?  `: The event-triggered task is in effect all the time.
        # *   ` * * 17-18 * * ?  `: The event-triggered task is in effect between 17:00 and 18:59 (UTC+8) every day.
        # *   `TZ=+00 * * 1-2 * * ?`: The event-triggered task is in effect between 01:00 and 02:59 (UTC+0) every day.
        self.effective = effective
        # The number of consecutive times that the threshold must be reached before a scaling rule is executed. For example, if you set this parameter to 3, the average CPU utilization must reach or exceed 80% three times in a row before the scaling rule is executed.
        # 
        # Default value: 3.
        self.evaluation_count = evaluation_count
        # The information about the multi-metric alert rules.
        self.expressions = expressions
        # The relationship between the trigger conditions in the multi-metric alert rule. Valid values:
        # 
        # *   `&&`: An alert is triggered only if all metrics in the multi-metric alert rule meet the trigger conditions. In this case, an alert is triggered only if the results of all trigger conditions that are specified in the multi-metric alert rule are `true`.
        # *   `||`: An alert is triggered if one of the metrics in the multi-metric alert rule meets the trigger conditions.
        # 
        # Default value: `&&`.
        self.expressions_logic_operator = expressions_logic_operator
        # The ID of the application group to which the custom metric belongs. If you set the MetricType parameter to custom, you must specify this parameter.
        self.group_id = group_id
        # The metric name. The valid values of this parameter vary based on the metric type.
        # 
        # *   If you set MetricType to custom, the valid values are the metrics that you have.
        # 
        # *   If you set MetricType to system, this parameter has the following valid values:
        # 
        #     *   CpuUtilization: the CPU utilization. Unit: %.
        #     *   ConcurrentConnections: the number of concurrent connections.
        #     *   IntranetTx: the outbound traffic over an internal network. Unit: KB/min.
        #     *   IntranetRx: the inbound traffic over an internal network. Unit: KB/min.
        #     *   VpcInternetTx: the outbound traffic over a virtual private cloud (VPC). Unit: KB/min.
        #     *   VpcInternetRx: the inbound traffic over a VPC. Unit: KB/min.
        #     *   SystemDiskReadBps: the number of bytes read from the system disk per second.
        #     *   SystemDiskWriteBps: the number of bytes written to the system disk per second.
        #     *   SystemDiskReadOps: the read IOPS of the system disk. Unit: counts/s.
        #     *   SystemDiskWriteOps: the write IOPS of the system disk. Unit: counts/s.
        #     *   CpuUtilizationAgent: the CPU utilization. Unit: %.
        #     *   GpuUtilizationAgent: the GPU utilization. Unit: %.
        #     *   GpuMemoryFreeUtilizationAgent: the idle GPU memory usage. Unit: %.
        #     *   GpuMemoryUtilizationAgent: the GPU memory usage. Unit: %.
        #     *   MemoryUtilization: the memory usage. Unit: %.
        #     *   LoadAverage: the average system load.
        #     *   TcpConnection: the total number of TCP connections.
        #     *   TcpConnection: the number of established TCP connections.
        #     *   PackagesNetOut: the number of packets sent by the internal network interface controller (NIC). Unit: counts/s.
        #     *   PackagesNetIn: the number of packets received by the internal NIC. Unit: counts/s.
        #     *   PackagesNetOut: the number of packets sent by the public NIC. Unit: counts/s.
        #     *   PackagesNetIn: the number of packets received by the public NIC. Unit: counts/s.
        #     *   EciPodCpuUtilization: the CPU utilization. Unit: %.
        #     *   EciPodMemoryUtilization: the memory usage. Unit: %.
        #     *   LoadBalancerRealServerAverageQps: the queries per second (QPS) of an instance.
        # 
        # For more information, see [Event-triggered tasks of the system monitoring type](https://help.aliyun.com/document_detail/74854.html).
        self.metric_name = metric_name
        # The metric type. Valid values:
        # 
        # *   system: a system metric of CloudMonitor.
        # *   custom: a custom metric that is reported to CloudMonitor.
        self.metric_type = metric_type
        # The name of the event-triggered task.
        self.name = name
        self.owner_id = owner_id
        # The statistical period of the metric data. Unit: seconds. Valid values:
        # 
        # *   15
        # *   60
        # *   120
        # *   300
        # *   900
        # 
        # >  You can set this parameter to 15 seconds only for scaling groups of the ECS type.
        # 
        # Default value: 300.
        self.period = period
        # The region ID of the scaling group.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The scaling group ID of the event-triggered task.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id
        # The statistical method of the metric data. Valid values:
        # 
        # *   Average: calculates the average value of the metric data.
        # *   Minimum: calculates the minimum value of the metric data.
        # *   Maximum: calculates the maximum value of the metric data.
        # 
        # Default value: Average.
        self.statistics = statistics
        # The threshold of the metric value. If the threshold is reached the specified number of times within the specified period, a scaling rule is executed.
        self.threshold = threshold

    def validate(self):
        if self.dimensions:
            for k in self.dimensions:
                if k:
                    k.validate()
        if self.expressions:
            for k in self.expressions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_actions is not None:
            result['AlarmActions'] = self.alarm_actions
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.description is not None:
            result['Description'] = self.description
        result['Dimensions'] = []
        if self.dimensions is not None:
            for k in self.dimensions:
                result['Dimensions'].append(k.to_map() if k else None)
        if self.effective is not None:
            result['Effective'] = self.effective
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        result['Expressions'] = []
        if self.expressions is not None:
            for k in self.expressions:
                result['Expressions'].append(k.to_map() if k else None)
        if self.expressions_logic_operator is not None:
            result['ExpressionsLogicOperator'] = self.expressions_logic_operator
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmActions') is not None:
            self.alarm_actions = m.get('AlarmActions')
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.dimensions = []
        if m.get('Dimensions') is not None:
            for k in m.get('Dimensions'):
                temp_model = CreateAlarmRequestDimensions()
                self.dimensions.append(temp_model.from_map(k))
        if m.get('Effective') is not None:
            self.effective = m.get('Effective')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        self.expressions = []
        if m.get('Expressions') is not None:
            for k in m.get('Expressions'):
                temp_model = CreateAlarmRequestExpressions()
                self.expressions.append(temp_model.from_map(k))
        if m.get('ExpressionsLogicOperator') is not None:
            self.expressions_logic_operator = m.get('ExpressionsLogicOperator')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class CreateAlarmResponseBody(TeaModel):
    def __init__(
        self,
        alarm_task_id: str = None,
        request_id: str = None,
    ):
        # The ID of the event-triggered task.
        self.alarm_task_id = alarm_task_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_task_id is not None:
            result['AlarmTaskId'] = self.alarm_task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmTaskId') is not None:
            self.alarm_task_id = m.get('AlarmTaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAlarmResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAlarmResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAlarmResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiagnoseReportRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        scaling_group_id: str = None,
    ):
        # The region ID of the scaling group.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class CreateDiagnoseReportResponseBody(TeaModel):
    def __init__(
        self,
        report_id: str = None,
        request_id: str = None,
    ):
        # The unique ID of the diagnostic report.
        self.report_id = report_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDiagnoseReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDiagnoseReportResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiagnoseReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEciScalingConfigurationRequestAcrRegistryInfos(TeaModel):
    def __init__(
        self,
        domains: List[str] = None,
        instance_id: str = None,
        instance_name: str = None,
        region_id: str = None,
    ):
        # The domain names of the Container Registry Enterprise Edition instances. By default, all domain names are displayed. Separate multiple domain names with commas (,).
        self.domains = domains
        # The ID of the Container Registry Enterprise Edition instance.
        self.instance_id = instance_id
        # The name of the Container Registry Enterprise Edition instance.
        self.instance_name = instance_name
        # The region ID of the Container Registry Enterprise Edition instance.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domains') is not None:
            self.domains = m.get('Domains')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateEciScalingConfigurationRequestContainersLivenessProbeExec(TeaModel):
    def __init__(
        self,
        commands: List[str] = None,
    ):
        self.commands = commands

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commands is not None:
            result['Commands'] = self.commands
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Commands') is not None:
            self.commands = m.get('Commands')
        return self


class CreateEciScalingConfigurationRequestContainersLivenessProbeHttpGet(TeaModel):
    def __init__(
        self,
        path: str = None,
        port: int = None,
        scheme: str = None,
    ):
        self.path = path
        self.port = port
        self.scheme = scheme

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.port is not None:
            result['Port'] = self.port
        if self.scheme is not None:
            result['Scheme'] = self.scheme
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Scheme') is not None:
            self.scheme = m.get('Scheme')
        return self


class CreateEciScalingConfigurationRequestContainersLivenessProbeTcpSocket(TeaModel):
    def __init__(
        self,
        port: int = None,
    ):
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class CreateEciScalingConfigurationRequestContainersLivenessProbe(TeaModel):
    def __init__(
        self,
        exec: CreateEciScalingConfigurationRequestContainersLivenessProbeExec = None,
        failure_threshold: int = None,
        http_get: CreateEciScalingConfigurationRequestContainersLivenessProbeHttpGet = None,
        initial_delay_seconds: int = None,
        period_seconds: int = None,
        success_threshold: int = None,
        tcp_socket: CreateEciScalingConfigurationRequestContainersLivenessProbeTcpSocket = None,
        timeout_seconds: int = None,
    ):
        self.exec = exec
        self.failure_threshold = failure_threshold
        self.http_get = http_get
        self.initial_delay_seconds = initial_delay_seconds
        self.period_seconds = period_seconds
        self.success_threshold = success_threshold
        self.tcp_socket = tcp_socket
        self.timeout_seconds = timeout_seconds

    def validate(self):
        if self.exec:
            self.exec.validate()
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec is not None:
            result['Exec'] = self.exec.to_map()
        if self.failure_threshold is not None:
            result['FailureThreshold'] = self.failure_threshold
        if self.http_get is not None:
            result['HttpGet'] = self.http_get.to_map()
        if self.initial_delay_seconds is not None:
            result['InitialDelaySeconds'] = self.initial_delay_seconds
        if self.period_seconds is not None:
            result['PeriodSeconds'] = self.period_seconds
        if self.success_threshold is not None:
            result['SuccessThreshold'] = self.success_threshold
        if self.tcp_socket is not None:
            result['TcpSocket'] = self.tcp_socket.to_map()
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Exec') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersLivenessProbeExec()
            self.exec = temp_model.from_map(m['Exec'])
        if m.get('FailureThreshold') is not None:
            self.failure_threshold = m.get('FailureThreshold')
        if m.get('HttpGet') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersLivenessProbeHttpGet()
            self.http_get = temp_model.from_map(m['HttpGet'])
        if m.get('InitialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('InitialDelaySeconds')
        if m.get('PeriodSeconds') is not None:
            self.period_seconds = m.get('PeriodSeconds')
        if m.get('SuccessThreshold') is not None:
            self.success_threshold = m.get('SuccessThreshold')
        if m.get('TcpSocket') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersLivenessProbeTcpSocket()
            self.tcp_socket = temp_model.from_map(m['TcpSocket'])
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class CreateEciScalingConfigurationRequestContainersReadinessProbeExec(TeaModel):
    def __init__(
        self,
        commands: List[str] = None,
    ):
        self.commands = commands

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commands is not None:
            result['Commands'] = self.commands
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Commands') is not None:
            self.commands = m.get('Commands')
        return self


class CreateEciScalingConfigurationRequestContainersReadinessProbeHttpGet(TeaModel):
    def __init__(
        self,
        path: str = None,
        port: int = None,
        scheme: str = None,
    ):
        self.path = path
        self.port = port
        self.scheme = scheme

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.port is not None:
            result['Port'] = self.port
        if self.scheme is not None:
            result['Scheme'] = self.scheme
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Scheme') is not None:
            self.scheme = m.get('Scheme')
        return self


class CreateEciScalingConfigurationRequestContainersReadinessProbeTcpSocket(TeaModel):
    def __init__(
        self,
        port: int = None,
    ):
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class CreateEciScalingConfigurationRequestContainersReadinessProbe(TeaModel):
    def __init__(
        self,
        exec: CreateEciScalingConfigurationRequestContainersReadinessProbeExec = None,
        failure_threshold: int = None,
        http_get: CreateEciScalingConfigurationRequestContainersReadinessProbeHttpGet = None,
        initial_delay_seconds: int = None,
        period_seconds: int = None,
        success_threshold: int = None,
        tcp_socket: CreateEciScalingConfigurationRequestContainersReadinessProbeTcpSocket = None,
        timeout_seconds: int = None,
    ):
        self.exec = exec
        self.failure_threshold = failure_threshold
        self.http_get = http_get
        self.initial_delay_seconds = initial_delay_seconds
        self.period_seconds = period_seconds
        self.success_threshold = success_threshold
        self.tcp_socket = tcp_socket
        self.timeout_seconds = timeout_seconds

    def validate(self):
        if self.exec:
            self.exec.validate()
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec is not None:
            result['Exec'] = self.exec.to_map()
        if self.failure_threshold is not None:
            result['FailureThreshold'] = self.failure_threshold
        if self.http_get is not None:
            result['HttpGet'] = self.http_get.to_map()
        if self.initial_delay_seconds is not None:
            result['InitialDelaySeconds'] = self.initial_delay_seconds
        if self.period_seconds is not None:
            result['PeriodSeconds'] = self.period_seconds
        if self.success_threshold is not None:
            result['SuccessThreshold'] = self.success_threshold
        if self.tcp_socket is not None:
            result['TcpSocket'] = self.tcp_socket.to_map()
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Exec') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersReadinessProbeExec()
            self.exec = temp_model.from_map(m['Exec'])
        if m.get('FailureThreshold') is not None:
            self.failure_threshold = m.get('FailureThreshold')
        if m.get('HttpGet') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersReadinessProbeHttpGet()
            self.http_get = temp_model.from_map(m['HttpGet'])
        if m.get('InitialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('InitialDelaySeconds')
        if m.get('PeriodSeconds') is not None:
            self.period_seconds = m.get('PeriodSeconds')
        if m.get('SuccessThreshold') is not None:
            self.success_threshold = m.get('SuccessThreshold')
        if m.get('TcpSocket') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersReadinessProbeTcpSocket()
            self.tcp_socket = temp_model.from_map(m['TcpSocket'])
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class CreateEciScalingConfigurationRequestContainersSecurityContextCapability(TeaModel):
    def __init__(
        self,
        add: List[str] = None,
    ):
        self.add = add

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add is not None:
            result['Add'] = self.add
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Add') is not None:
            self.add = m.get('Add')
        return self


class CreateEciScalingConfigurationRequestContainersSecurityContext(TeaModel):
    def __init__(
        self,
        capability: CreateEciScalingConfigurationRequestContainersSecurityContextCapability = None,
        read_only_root_filesystem: bool = None,
        run_as_user: int = None,
    ):
        self.capability = capability
        self.read_only_root_filesystem = read_only_root_filesystem
        self.run_as_user = run_as_user

    def validate(self):
        if self.capability:
            self.capability.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capability is not None:
            result['Capability'] = self.capability.to_map()
        if self.read_only_root_filesystem is not None:
            result['ReadOnlyRootFilesystem'] = self.read_only_root_filesystem
        if self.run_as_user is not None:
            result['RunAsUser'] = self.run_as_user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Capability') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersSecurityContextCapability()
            self.capability = temp_model.from_map(m['Capability'])
        if m.get('ReadOnlyRootFilesystem') is not None:
            self.read_only_root_filesystem = m.get('ReadOnlyRootFilesystem')
        if m.get('RunAsUser') is not None:
            self.run_as_user = m.get('RunAsUser')
        return self


class CreateEciScalingConfigurationRequestContainersEnvironmentVars(TeaModel):
    def __init__(
        self,
        field_ref_field_path: str = None,
        key: str = None,
        value: str = None,
    ):
        # >  This parameter is unavailable for use.
        self.field_ref_field_path = field_ref_field_path
        # The name of the environment variable. The name can be 1 to 128 characters in length and can contain letters, underscores (_), and digits. It cannot start with a digit. Specify the value in the [0-9a-zA-Z] format.
        self.key = key
        # The value of the environment variable. The value can be up to 256 characters in length.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_ref_field_path is not None:
            result['FieldRefFieldPath'] = self.field_ref_field_path
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldRefFieldPath') is not None:
            self.field_ref_field_path = m.get('FieldRefFieldPath')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateEciScalingConfigurationRequestContainersPorts(TeaModel):
    def __init__(
        self,
        port: int = None,
        protocol: str = None,
    ):
        # The port. Valid values: 1 to 65535.
        self.port = port
        # The type of the protocol. Valid values:
        # 
        # *   TCP.
        # *   UDP
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class CreateEciScalingConfigurationRequestContainersVolumeMounts(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        mount_propagation: str = None,
        name: str = None,
        read_only: bool = None,
        sub_path: str = None,
    ):
        # The directory in which the container mounts the volume.
        # 
        # >  Data in this directory is overwritten by data on the volume. Specify this parameter with caution.
        self.mount_path = mount_path
        # The mount propagation setting. Mount propagation enables volume sharing from one container to other containers within the same pod or to containers across separate pods on the same node. Valid values:
        # 
        # *   None: Subsequent mounts executed on the volume or its subdirectories are not propagated to the volume.
        # *   HostToCotainer: Subsequent mounts executed on the volume or its subdirectories are propagated to the volume.
        # *   Bidirectional: This value is similar to HostToCotainer. Subsequent mounts executed on the volume or its subdirectories are propagated to the volume. All volume mounts executed on the container are not only propagate back to the underlying host but also to all containers across every pod that uses the same volume.
        # 
        # Default value: None.
        self.mount_propagation = mount_propagation
        # The volume name. The value of this parameter is the same as the value of Volumes.Name.
        self.name = name
        # Specifies whether the volume is read-only. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        self.read_only = read_only
        # The volume subdirectory.
        self.sub_path = sub_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        if self.mount_propagation is not None:
            result['MountPropagation'] = self.mount_propagation
        if self.name is not None:
            result['Name'] = self.name
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.sub_path is not None:
            result['SubPath'] = self.sub_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        if m.get('MountPropagation') is not None:
            self.mount_propagation = m.get('MountPropagation')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('SubPath') is not None:
            self.sub_path = m.get('SubPath')
        return self


class CreateEciScalingConfigurationRequestContainers(TeaModel):
    def __init__(
        self,
        liveness_probe: CreateEciScalingConfigurationRequestContainersLivenessProbe = None,
        readiness_probe: CreateEciScalingConfigurationRequestContainersReadinessProbe = None,
        security_context: CreateEciScalingConfigurationRequestContainersSecurityContext = None,
        args: List[str] = None,
        commands: List[str] = None,
        cpu: float = None,
        environment_vars: List[CreateEciScalingConfigurationRequestContainersEnvironmentVars] = None,
        gpu: int = None,
        image: str = None,
        image_pull_policy: str = None,
        lifecycle_post_start_handler_execs: List[str] = None,
        lifecycle_post_start_handler_http_get_host: str = None,
        lifecycle_post_start_handler_http_get_path: str = None,
        lifecycle_post_start_handler_http_get_port: int = None,
        lifecycle_post_start_handler_http_get_scheme: str = None,
        lifecycle_post_start_handler_tcp_socket_host: str = None,
        lifecycle_post_start_handler_tcp_socket_port: int = None,
        lifecycle_pre_stop_handler_execs: List[str] = None,
        lifecycle_pre_stop_handler_http_get_host: str = None,
        lifecycle_pre_stop_handler_http_get_path: str = None,
        lifecycle_pre_stop_handler_http_get_port: int = None,
        lifecycle_pre_stop_handler_http_get_scheme: str = None,
        lifecycle_pre_stop_handler_tcp_socket_host: str = None,
        lifecycle_pre_stop_handler_tcp_socket_port: int = None,
        memory: float = None,
        name: str = None,
        ports: List[CreateEciScalingConfigurationRequestContainersPorts] = None,
        stdin: bool = None,
        stdin_once: bool = None,
        tty: bool = None,
        volume_mounts: List[CreateEciScalingConfigurationRequestContainersVolumeMounts] = None,
        working_dir: str = None,
    ):
        self.liveness_probe = liveness_probe
        self.readiness_probe = readiness_probe
        self.security_context = security_context
        # The startup arguments of the container. You can specify up to 10 arguments.
        self.args = args
        # The commands that you want to run by using the CLI for liveness probing within the container.
        self.commands = commands
        # The number of vCPUs per container.
        self.cpu = cpu
        # The environment variables.
        self.environment_vars = environment_vars
        # The number of GPUs per container.
        self.gpu = gpu
        # The image in the container.
        self.image = image
        # The image pulling policy. Valid values:
        # 
        # *   Always: Each time instances are created, image pulling is performed.
        # *   IfNotPresent: Image pulling is performed based on your business requirements. On-premises images are used by default. If no on-premises images are available, images are pulled from remote sources.
        # *   Never: Image pulling is not performed. On-premises images are always used. Image pulling is not performed.
        self.image_pull_policy = image_pull_policy
        # The commands that you want to run by using the CLI to configure the postStart callback function within the container.
        self.lifecycle_post_start_handler_execs = lifecycle_post_start_handler_execs
        # The IP address of the host to which you want to send HTTP GET requests to configure the postStart callback function.
        self.lifecycle_post_start_handler_http_get_host = lifecycle_post_start_handler_http_get_host
        # The path to which you want to send HTTP GET requests to configure the postStart callback function.
        self.lifecycle_post_start_handler_http_get_path = lifecycle_post_start_handler_http_get_path
        # The port over which you want to send HTTP GET requests to configure the postStart callback function.
        self.lifecycle_post_start_handler_http_get_port = lifecycle_post_start_handler_http_get_port
        # The protocol type of HTTP GET requests that you want to send to configure the postStart callback function. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        self.lifecycle_post_start_handler_http_get_scheme = lifecycle_post_start_handler_http_get_scheme
        # The IP address of the host detected by the TCP sockets that you want to use to configure the postStart callback function.
        self.lifecycle_post_start_handler_tcp_socket_host = lifecycle_post_start_handler_tcp_socket_host
        # The port detected by the TCP sockets that you want to use to configure the postStart callback function.
        self.lifecycle_post_start_handler_tcp_socket_port = lifecycle_post_start_handler_tcp_socket_port
        # The commands that you want to run by using the CLI to configure the preStop callback function within the container.
        self.lifecycle_pre_stop_handler_execs = lifecycle_pre_stop_handler_execs
        # The IP address of the host to which you want to send HTTP GET requests to configure the preStop callback function.
        self.lifecycle_pre_stop_handler_http_get_host = lifecycle_pre_stop_handler_http_get_host
        # The path to which you want to send HTTP GET requests to configure the preStop callback function.
        self.lifecycle_pre_stop_handler_http_get_path = lifecycle_pre_stop_handler_http_get_path
        # The port over which you want to send HTTP GET requests to configure the preStop callback function.
        self.lifecycle_pre_stop_handler_http_get_port = lifecycle_pre_stop_handler_http_get_port
        # The protocol type of the HTTP GET requests that you want to send to configure the preStop callback function. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        self.lifecycle_pre_stop_handler_http_get_scheme = lifecycle_pre_stop_handler_http_get_scheme
        # The IP address of the host detected by the TCP sockets that you want to use to configure the preStop callback function.
        self.lifecycle_pre_stop_handler_tcp_socket_host = lifecycle_pre_stop_handler_tcp_socket_host
        # The port detected by the TCP sockets that you want to use to configure the preStop callback function.
        self.lifecycle_pre_stop_handler_tcp_socket_port = lifecycle_pre_stop_handler_tcp_socket_port
        # The memory size that you want to allocate to the container. Unit: GiB.
        self.memory = memory
        # The name of the container image.
        self.name = name
        # The ports.
        self.ports = ports
        # Specifies whether the container allocates buffer resources to standard input streams during its active runtime. If you do not specify this parameter, an end-of-file (EOF) error occurs when standard input streams in the container are read.
        # 
        # Default value: false.
        self.stdin = stdin
        # Specifies whether standard input streams remain connected during multiple sessions if Stdin is set to true.
        # 
        # If you set StdinOnce to true, standard input streams are connected after the container is started, and remain idle until a client is connected to receive data. After the client is disconnected, streams are also disconnected and remain disconnected until the container is restarted.
        self.stdin_once = stdin_once
        # Specifies whether to enable interaction. Valid values:
        # 
        # *   true
        # *   false
        # 
        # If the command is a /bin/bash command, set the value to true.
        # 
        # Default value: false.
        self.tty = tty
        # The volume mounts of the container.
        self.volume_mounts = volume_mounts
        # The working directory of the container.
        self.working_dir = working_dir

    def validate(self):
        if self.liveness_probe:
            self.liveness_probe.validate()
        if self.readiness_probe:
            self.readiness_probe.validate()
        if self.security_context:
            self.security_context.validate()
        if self.environment_vars:
            for k in self.environment_vars:
                if k:
                    k.validate()
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.volume_mounts:
            for k in self.volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.liveness_probe is not None:
            result['LivenessProbe'] = self.liveness_probe.to_map()
        if self.readiness_probe is not None:
            result['ReadinessProbe'] = self.readiness_probe.to_map()
        if self.security_context is not None:
            result['SecurityContext'] = self.security_context.to_map()
        if self.args is not None:
            result['Args'] = self.args
        if self.commands is not None:
            result['Commands'] = self.commands
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        result['EnvironmentVars'] = []
        if self.environment_vars is not None:
            for k in self.environment_vars:
                result['EnvironmentVars'].append(k.to_map() if k else None)
        if self.gpu is not None:
            result['Gpu'] = self.gpu
        if self.image is not None:
            result['Image'] = self.image
        if self.image_pull_policy is not None:
            result['ImagePullPolicy'] = self.image_pull_policy
        if self.lifecycle_post_start_handler_execs is not None:
            result['LifecyclePostStartHandlerExecs'] = self.lifecycle_post_start_handler_execs
        if self.lifecycle_post_start_handler_http_get_host is not None:
            result['LifecyclePostStartHandlerHttpGetHost'] = self.lifecycle_post_start_handler_http_get_host
        if self.lifecycle_post_start_handler_http_get_path is not None:
            result['LifecyclePostStartHandlerHttpGetPath'] = self.lifecycle_post_start_handler_http_get_path
        if self.lifecycle_post_start_handler_http_get_port is not None:
            result['LifecyclePostStartHandlerHttpGetPort'] = self.lifecycle_post_start_handler_http_get_port
        if self.lifecycle_post_start_handler_http_get_scheme is not None:
            result['LifecyclePostStartHandlerHttpGetScheme'] = self.lifecycle_post_start_handler_http_get_scheme
        if self.lifecycle_post_start_handler_tcp_socket_host is not None:
            result['LifecyclePostStartHandlerTcpSocketHost'] = self.lifecycle_post_start_handler_tcp_socket_host
        if self.lifecycle_post_start_handler_tcp_socket_port is not None:
            result['LifecyclePostStartHandlerTcpSocketPort'] = self.lifecycle_post_start_handler_tcp_socket_port
        if self.lifecycle_pre_stop_handler_execs is not None:
            result['LifecyclePreStopHandlerExecs'] = self.lifecycle_pre_stop_handler_execs
        if self.lifecycle_pre_stop_handler_http_get_host is not None:
            result['LifecyclePreStopHandlerHttpGetHost'] = self.lifecycle_pre_stop_handler_http_get_host
        if self.lifecycle_pre_stop_handler_http_get_path is not None:
            result['LifecyclePreStopHandlerHttpGetPath'] = self.lifecycle_pre_stop_handler_http_get_path
        if self.lifecycle_pre_stop_handler_http_get_port is not None:
            result['LifecyclePreStopHandlerHttpGetPort'] = self.lifecycle_pre_stop_handler_http_get_port
        if self.lifecycle_pre_stop_handler_http_get_scheme is not None:
            result['LifecyclePreStopHandlerHttpGetScheme'] = self.lifecycle_pre_stop_handler_http_get_scheme
        if self.lifecycle_pre_stop_handler_tcp_socket_host is not None:
            result['LifecyclePreStopHandlerTcpSocketHost'] = self.lifecycle_pre_stop_handler_tcp_socket_host
        if self.lifecycle_pre_stop_handler_tcp_socket_port is not None:
            result['LifecyclePreStopHandlerTcpSocketPort'] = self.lifecycle_pre_stop_handler_tcp_socket_port
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.name is not None:
            result['Name'] = self.name
        result['Ports'] = []
        if self.ports is not None:
            for k in self.ports:
                result['Ports'].append(k.to_map() if k else None)
        if self.stdin is not None:
            result['Stdin'] = self.stdin
        if self.stdin_once is not None:
            result['StdinOnce'] = self.stdin_once
        if self.tty is not None:
            result['Tty'] = self.tty
        result['VolumeMounts'] = []
        if self.volume_mounts is not None:
            for k in self.volume_mounts:
                result['VolumeMounts'].append(k.to_map() if k else None)
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LivenessProbe') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersLivenessProbe()
            self.liveness_probe = temp_model.from_map(m['LivenessProbe'])
        if m.get('ReadinessProbe') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersReadinessProbe()
            self.readiness_probe = temp_model.from_map(m['ReadinessProbe'])
        if m.get('SecurityContext') is not None:
            temp_model = CreateEciScalingConfigurationRequestContainersSecurityContext()
            self.security_context = temp_model.from_map(m['SecurityContext'])
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('Commands') is not None:
            self.commands = m.get('Commands')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        self.environment_vars = []
        if m.get('EnvironmentVars') is not None:
            for k in m.get('EnvironmentVars'):
                temp_model = CreateEciScalingConfigurationRequestContainersEnvironmentVars()
                self.environment_vars.append(temp_model.from_map(k))
        if m.get('Gpu') is not None:
            self.gpu = m.get('Gpu')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImagePullPolicy') is not None:
            self.image_pull_policy = m.get('ImagePullPolicy')
        if m.get('LifecyclePostStartHandlerExecs') is not None:
            self.lifecycle_post_start_handler_execs = m.get('LifecyclePostStartHandlerExecs')
        if m.get('LifecyclePostStartHandlerHttpGetHost') is not None:
            self.lifecycle_post_start_handler_http_get_host = m.get('LifecyclePostStartHandlerHttpGetHost')
        if m.get('LifecyclePostStartHandlerHttpGetPath') is not None:
            self.lifecycle_post_start_handler_http_get_path = m.get('LifecyclePostStartHandlerHttpGetPath')
        if m.get('LifecyclePostStartHandlerHttpGetPort') is not None:
            self.lifecycle_post_start_handler_http_get_port = m.get('LifecyclePostStartHandlerHttpGetPort')
        if m.get('LifecyclePostStartHandlerHttpGetScheme') is not None:
            self.lifecycle_post_start_handler_http_get_scheme = m.get('LifecyclePostStartHandlerHttpGetScheme')
        if m.get('LifecyclePostStartHandlerTcpSocketHost') is not None:
            self.lifecycle_post_start_handler_tcp_socket_host = m.get('LifecyclePostStartHandlerTcpSocketHost')
        if m.get('LifecyclePostStartHandlerTcpSocketPort') is not None:
            self.lifecycle_post_start_handler_tcp_socket_port = m.get('LifecyclePostStartHandlerTcpSocketPort')
        if m.get('LifecyclePreStopHandlerExecs') is not None:
            self.lifecycle_pre_stop_handler_execs = m.get('LifecyclePreStopHandlerExecs')
        if m.get('LifecyclePreStopHandlerHttpGetHost') is not None:
            self.lifecycle_pre_stop_handler_http_get_host = m.get('LifecyclePreStopHandlerHttpGetHost')
        if m.get('LifecyclePreStopHandlerHttpGetPath') is not None:
            self.lifecycle_pre_stop_handler_http_get_path = m.get('LifecyclePreStopHandlerHttpGetPath')
        if m.get('LifecyclePreStopHandlerHttpGetPort') is not None:
            self.lifecycle_pre_stop_handler_http_get_port = m.get('LifecyclePreStopHandlerHttpGetPort')
        if m.get('LifecyclePreStopHandlerHttpGetScheme') is not None:
            self.lifecycle_pre_stop_handler_http_get_scheme = m.get('LifecyclePreStopHandlerHttpGetScheme')
        if m.get('LifecyclePreStopHandlerTcpSocketHost') is not None:
            self.lifecycle_pre_stop_handler_tcp_socket_host = m.get('LifecyclePreStopHandlerTcpSocketHost')
        if m.get('LifecyclePreStopHandlerTcpSocketPort') is not None:
            self.lifecycle_pre_stop_handler_tcp_socket_port = m.get('LifecyclePreStopHandlerTcpSocketPort')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.ports = []
        if m.get('Ports') is not None:
            for k in m.get('Ports'):
                temp_model = CreateEciScalingConfigurationRequestContainersPorts()
                self.ports.append(temp_model.from_map(k))
        if m.get('Stdin') is not None:
            self.stdin = m.get('Stdin')
        if m.get('StdinOnce') is not None:
            self.stdin_once = m.get('StdinOnce')
        if m.get('Tty') is not None:
            self.tty = m.get('Tty')
        self.volume_mounts = []
        if m.get('VolumeMounts') is not None:
            for k in m.get('VolumeMounts'):
                temp_model = CreateEciScalingConfigurationRequestContainersVolumeMounts()
                self.volume_mounts.append(temp_model.from_map(k))
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class CreateEciScalingConfigurationRequestDnsConfigOptions(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The variable name of the option.
        self.name = name
        # The variable value of the option.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateEciScalingConfigurationRequestHostAliases(TeaModel):
    def __init__(
        self,
        hostnames: List[str] = None,
        ip: str = None,
    ):
        # The hostnames of the containers that you want to add.
        self.hostnames = hostnames
        # The IP address of the container that you want to add.
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostnames is not None:
            result['Hostnames'] = self.hostnames
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Hostnames') is not None:
            self.hostnames = m.get('Hostnames')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class CreateEciScalingConfigurationRequestImageRegistryCredentials(TeaModel):
    def __init__(
        self,
        password: str = None,
        server: str = None,
        user_name: str = None,
    ):
        # The password of the image repository.
        self.password = password
        # The endpoint of the image repository.
        self.server = server
        # The username of the image repository.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.server is not None:
            result['Server'] = self.server
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateEciScalingConfigurationRequestInitContainersSecurityContextCapability(TeaModel):
    def __init__(
        self,
        adds: List[str] = None,
    ):
        self.adds = adds

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adds is not None:
            result['Adds'] = self.adds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Adds') is not None:
            self.adds = m.get('Adds')
        return self


class CreateEciScalingConfigurationRequestInitContainersSecurityContext(TeaModel):
    def __init__(
        self,
        capability: CreateEciScalingConfigurationRequestInitContainersSecurityContextCapability = None,
        read_only_root_filesystem: bool = None,
        run_as_user: int = None,
    ):
        self.capability = capability
        self.read_only_root_filesystem = read_only_root_filesystem
        self.run_as_user = run_as_user

    def validate(self):
        if self.capability:
            self.capability.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capability is not None:
            result['Capability'] = self.capability.to_map()
        if self.read_only_root_filesystem is not None:
            result['ReadOnlyRootFilesystem'] = self.read_only_root_filesystem
        if self.run_as_user is not None:
            result['RunAsUser'] = self.run_as_user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Capability') is not None:
            temp_model = CreateEciScalingConfigurationRequestInitContainersSecurityContextCapability()
            self.capability = temp_model.from_map(m['Capability'])
        if m.get('ReadOnlyRootFilesystem') is not None:
            self.read_only_root_filesystem = m.get('ReadOnlyRootFilesystem')
        if m.get('RunAsUser') is not None:
            self.run_as_user = m.get('RunAsUser')
        return self


class CreateEciScalingConfigurationRequestInitContainersInitContainerEnvironmentVars(TeaModel):
    def __init__(
        self,
        field_ref_field_path: str = None,
        key: str = None,
        value: str = None,
    ):
        # >  This parameter is unavailable for use.
        self.field_ref_field_path = field_ref_field_path
        # The name of the environment variable. The name can be 1 to 128 characters in length and can contain letters, underscores (_), and digits. It cannot start with a digit. Specify the value in the `[0-9a-zA-Z]` format.
        self.key = key
        # The value of the environment variable. The value can be up to 256 characters in length.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_ref_field_path is not None:
            result['FieldRefFieldPath'] = self.field_ref_field_path
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldRefFieldPath') is not None:
            self.field_ref_field_path = m.get('FieldRefFieldPath')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateEciScalingConfigurationRequestInitContainersInitContainerPorts(TeaModel):
    def __init__(
        self,
        port: int = None,
        protocol: str = None,
    ):
        # The port number. Valid values: 1 to 65535.
        self.port = port
        # The protocol type. Valid values:
        # 
        # *   TCP
        # *   UDP
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class CreateEciScalingConfigurationRequestInitContainersInitContainerVolumeMounts(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        mount_propagation: str = None,
        name: str = None,
        read_only: bool = None,
        sub_path: str = None,
    ):
        # The directory to which the init container mounts the volume. The data stored in this directory is overwritten by the data on the volume. Specify this parameter with caution.
        self.mount_path = mount_path
        # The mount propagation settings of the volume. Mount propagation enables volume sharing from one container to other containers within the same pod or to containers across separate pods on the same node. Valid values:
        # 
        # *   None: Subsequent mounts executed on the volume or its subdirectories do not propagate to the volume.
        # *   HostToCotainer: Subsequent mounts executed on the volume or its subdirectories propagate to the volume.
        # *   Bidirectional: This value is similar to HostToCotainer. Subsequent mounts executed on the volume or its subdirectories propagate to the volume. All volume mounts executed on the container not only propagate back to the underlying host but also to all containers across every pod that uses the same volume.
        self.mount_propagation = mount_propagation
        # The name of the volume.
        self.name = name
        # Specifies whether the mount path is read-only.
        # 
        # Default value: false.
        self.read_only = read_only
        # The subdirectory of the volume. The pod can mount different directories of the same volume to different subdirectories of init containers.
        self.sub_path = sub_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        if self.mount_propagation is not None:
            result['MountPropagation'] = self.mount_propagation
        if self.name is not None:
            result['Name'] = self.name
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.sub_path is not None:
            result['SubPath'] = self.sub_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        if m.get('MountPropagation') is not None:
            self.mount_propagation = m.get('MountPropagation')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('SubPath') is not None:
            self.sub_path = m.get('SubPath')
        return self


class CreateEciScalingConfigurationRequestInitContainers(TeaModel):
    def __init__(
        self,
        security_context: CreateEciScalingConfigurationRequestInitContainersSecurityContext = None,
        args: List[str] = None,
        commands: List[str] = None,
        cpu: float = None,
        gpu: int = None,
        image: str = None,
        image_pull_policy: str = None,
        init_container_environment_vars: List[CreateEciScalingConfigurationRequestInitContainersInitContainerEnvironmentVars] = None,
        init_container_ports: List[CreateEciScalingConfigurationRequestInitContainersInitContainerPorts] = None,
        init_container_volume_mounts: List[CreateEciScalingConfigurationRequestInitContainersInitContainerVolumeMounts] = None,
        memory: float = None,
        name: str = None,
        working_dir: str = None,
    ):
        self.security_context = security_context
        # The startup arguments of the init container. You can specify up to 10 arguments.
        self.args = args
        # The startup commands of the init container.
        self.commands = commands
        # The number of vCPUs per init container.
        self.cpu = cpu
        # The number of GPUs per init container.
        self.gpu = gpu
        # The image of the init container.
        self.image = image
        # The image pulling policy.
        self.image_pull_policy = image_pull_policy
        # The environment variables of the init container.
        self.init_container_environment_vars = init_container_environment_vars
        # The ports of init containers.
        self.init_container_ports = init_container_ports
        # The volume mounts of the init container.
        self.init_container_volume_mounts = init_container_volume_mounts
        # The memory size per init container. Unit: GiB.
        self.memory = memory
        # The name of the init container.
        self.name = name
        # The working directory of the init container.
        self.working_dir = working_dir

    def validate(self):
        if self.security_context:
            self.security_context.validate()
        if self.init_container_environment_vars:
            for k in self.init_container_environment_vars:
                if k:
                    k.validate()
        if self.init_container_ports:
            for k in self.init_container_ports:
                if k:
                    k.validate()
        if self.init_container_volume_mounts:
            for k in self.init_container_volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_context is not None:
            result['SecurityContext'] = self.security_context.to_map()
        if self.args is not None:
            result['Args'] = self.args
        if self.commands is not None:
            result['Commands'] = self.commands
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.gpu is not None:
            result['Gpu'] = self.gpu
        if self.image is not None:
            result['Image'] = self.image
        if self.image_pull_policy is not None:
            result['ImagePullPolicy'] = self.image_pull_policy
        result['InitContainerEnvironmentVars'] = []
        if self.init_container_environment_vars is not None:
            for k in self.init_container_environment_vars:
                result['InitContainerEnvironmentVars'].append(k.to_map() if k else None)
        result['InitContainerPorts'] = []
        if self.init_container_ports is not None:
            for k in self.init_container_ports:
                result['InitContainerPorts'].append(k.to_map() if k else None)
        result['InitContainerVolumeMounts'] = []
        if self.init_container_volume_mounts is not None:
            for k in self.init_container_volume_mounts:
                result['InitContainerVolumeMounts'].append(k.to_map() if k else None)
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.name is not None:
            result['Name'] = self.name
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityContext') is not None:
            temp_model = CreateEciScalingConfigurationRequestInitContainersSecurityContext()
            self.security_context = temp_model.from_map(m['SecurityContext'])
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('Commands') is not None:
            self.commands = m.get('Commands')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('Gpu') is not None:
            self.gpu = m.get('Gpu')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImagePullPolicy') is not None:
            self.image_pull_policy = m.get('ImagePullPolicy')
        self.init_container_environment_vars = []
        if m.get('InitContainerEnvironmentVars') is not None:
            for k in m.get('InitContainerEnvironmentVars'):
                temp_model = CreateEciScalingConfigurationRequestInitContainersInitContainerEnvironmentVars()
                self.init_container_environment_vars.append(temp_model.from_map(k))
        self.init_container_ports = []
        if m.get('InitContainerPorts') is not None:
            for k in m.get('InitContainerPorts'):
                temp_model = CreateEciScalingConfigurationRequestInitContainersInitContainerPorts()
                self.init_container_ports.append(temp_model.from_map(k))
        self.init_container_volume_mounts = []
        if m.get('InitContainerVolumeMounts') is not None:
            for k in m.get('InitContainerVolumeMounts'):
                temp_model = CreateEciScalingConfigurationRequestInitContainersInitContainerVolumeMounts()
                self.init_container_volume_mounts.append(temp_model.from_map(k))
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class CreateEciScalingConfigurationRequestSecurityContextSysctls(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The variable name of the security context in which the container group runs.
        self.name = name
        # The variable value of the security context in which the elastic container instance runs.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateEciScalingConfigurationRequestTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key of the elastic container instance.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 128 characters in length. It cannot start with `acs:` or `aliyun` or contain `http://` or `https://`.
        self.key = key
        # The tag value of the elastic container instance.
        # 
        # The tag value can be an empty string. The tag value can be up to 128 characters in length. It cannot start with `acs:` and cannot contain `http://` or `https://`.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateEciScalingConfigurationRequestVolumesDiskVolume(TeaModel):
    def __init__(
        self,
        disk_id: str = None,
        disk_size: int = None,
        fs_type: str = None,
    ):
        self.disk_id = disk_id
        self.disk_size = disk_size
        self.fs_type = fs_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        if self.fs_type is not None:
            result['FsType'] = self.fs_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        if m.get('FsType') is not None:
            self.fs_type = m.get('FsType')
        return self


class CreateEciScalingConfigurationRequestVolumesEmptyDirVolume(TeaModel):
    def __init__(
        self,
        medium: str = None,
        size_limit: str = None,
    ):
        self.medium = medium
        self.size_limit = size_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.medium is not None:
            result['Medium'] = self.medium
        if self.size_limit is not None:
            result['SizeLimit'] = self.size_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Medium') is not None:
            self.medium = m.get('Medium')
        if m.get('SizeLimit') is not None:
            self.size_limit = m.get('SizeLimit')
        return self


class CreateEciScalingConfigurationRequestVolumesFlexVolume(TeaModel):
    def __init__(
        self,
        driver: str = None,
        fs_type: str = None,
        options: str = None,
    ):
        self.driver = driver
        self.fs_type = fs_type
        self.options = options

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver is not None:
            result['Driver'] = self.driver
        if self.fs_type is not None:
            result['FsType'] = self.fs_type
        if self.options is not None:
            result['Options'] = self.options
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Driver') is not None:
            self.driver = m.get('Driver')
        if m.get('FsType') is not None:
            self.fs_type = m.get('FsType')
        if m.get('Options') is not None:
            self.options = m.get('Options')
        return self


class CreateEciScalingConfigurationRequestVolumesHostPathVolume(TeaModel):
    def __init__(
        self,
        path: str = None,
        type: str = None,
    ):
        self.path = path
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEciScalingConfigurationRequestVolumesNFSVolume(TeaModel):
    def __init__(
        self,
        path: str = None,
        read_only: bool = None,
        server: str = None,
    ):
        self.path = path
        self.read_only = read_only
        self.server = server

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.server is not None:
            result['Server'] = self.server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        return self


class CreateEciScalingConfigurationRequestVolumesConfigFileVolumeConfigFileToPaths(TeaModel):
    def __init__(
        self,
        content: str = None,
        mode: int = None,
        path: str = None,
    ):
        # The content of the configuration file (32 KB).
        self.content = content
        # The permissions on the configuration file.
        self.mode = mode
        # The name of the environment variable.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class CreateEciScalingConfigurationRequestVolumes(TeaModel):
    def __init__(
        self,
        disk_volume: CreateEciScalingConfigurationRequestVolumesDiskVolume = None,
        empty_dir_volume: CreateEciScalingConfigurationRequestVolumesEmptyDirVolume = None,
        flex_volume: CreateEciScalingConfigurationRequestVolumesFlexVolume = None,
        host_path_volume: CreateEciScalingConfigurationRequestVolumesHostPathVolume = None,
        nfsvolume: CreateEciScalingConfigurationRequestVolumesNFSVolume = None,
        config_file_volume_config_file_to_paths: List[CreateEciScalingConfigurationRequestVolumesConfigFileVolumeConfigFileToPaths] = None,
        config_file_volume_default_mode: int = None,
        name: str = None,
        type: str = None,
    ):
        self.disk_volume = disk_volume
        self.empty_dir_volume = empty_dir_volume
        self.flex_volume = flex_volume
        self.host_path_volume = host_path_volume
        self.nfsvolume = nfsvolume
        # The paths to the configuration files.
        self.config_file_volume_config_file_to_paths = config_file_volume_config_file_to_paths
        # The default permissions on the ConfigFile volume.
        self.config_file_volume_default_mode = config_file_volume_default_mode
        # The name of the volume.
        self.name = name
        # The type of the Host directory. Examples: File, Directory, and Socket.
        self.type = type

    def validate(self):
        if self.disk_volume:
            self.disk_volume.validate()
        if self.empty_dir_volume:
            self.empty_dir_volume.validate()
        if self.flex_volume:
            self.flex_volume.validate()
        if self.host_path_volume:
            self.host_path_volume.validate()
        if self.nfsvolume:
            self.nfsvolume.validate()
        if self.config_file_volume_config_file_to_paths:
            for k in self.config_file_volume_config_file_to_paths:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_volume is not None:
            result['DiskVolume'] = self.disk_volume.to_map()
        if self.empty_dir_volume is not None:
            result['EmptyDirVolume'] = self.empty_dir_volume.to_map()
        if self.flex_volume is not None:
            result['FlexVolume'] = self.flex_volume.to_map()
        if self.host_path_volume is not None:
            result['HostPathVolume'] = self.host_path_volume.to_map()
        if self.nfsvolume is not None:
            result['NFSVolume'] = self.nfsvolume.to_map()
        result['ConfigFileVolumeConfigFileToPaths'] = []
        if self.config_file_volume_config_file_to_paths is not None:
            for k in self.config_file_volume_config_file_to_paths:
                result['ConfigFileVolumeConfigFileToPaths'].append(k.to_map() if k else None)
        if self.config_file_volume_default_mode is not None:
            result['ConfigFileVolumeDefaultMode'] = self.config_file_volume_default_mode
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiskVolume') is not None:
            temp_model = CreateEciScalingConfigurationRequestVolumesDiskVolume()
            self.disk_volume = temp_model.from_map(m['DiskVolume'])
        if m.get('EmptyDirVolume') is not None:
            temp_model = CreateEciScalingConfigurationRequestVolumesEmptyDirVolume()
            self.empty_dir_volume = temp_model.from_map(m['EmptyDirVolume'])
        if m.get('FlexVolume') is not None:
            temp_model = CreateEciScalingConfigurationRequestVolumesFlexVolume()
            self.flex_volume = temp_model.from_map(m['FlexVolume'])
        if m.get('HostPathVolume') is not None:
            temp_model = CreateEciScalingConfigurationRequestVolumesHostPathVolume()
            self.host_path_volume = temp_model.from_map(m['HostPathVolume'])
        if m.get('NFSVolume') is not None:
            temp_model = CreateEciScalingConfigurationRequestVolumesNFSVolume()
            self.nfsvolume = temp_model.from_map(m['NFSVolume'])
        self.config_file_volume_config_file_to_paths = []
        if m.get('ConfigFileVolumeConfigFileToPaths') is not None:
            for k in m.get('ConfigFileVolumeConfigFileToPaths'):
                temp_model = CreateEciScalingConfigurationRequestVolumesConfigFileVolumeConfigFileToPaths()
                self.config_file_volume_config_file_to_paths.append(temp_model.from_map(k))
        if m.get('ConfigFileVolumeDefaultMode') is not None:
            self.config_file_volume_default_mode = m.get('ConfigFileVolumeDefaultMode')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEciScalingConfigurationRequest(TeaModel):
    def __init__(
        self,
        acr_registry_infos: List[CreateEciScalingConfigurationRequestAcrRegistryInfos] = None,
        active_deadline_seconds: int = None,
        auto_create_eip: bool = None,
        auto_match_image_cache: bool = None,
        container_group_name: str = None,
        containers: List[CreateEciScalingConfigurationRequestContainers] = None,
        cost_optimization: bool = None,
        cpu: float = None,
        cpu_options_core: int = None,
        cpu_options_threads_per_core: int = None,
        data_cache_bucket: str = None,
        data_cache_bursting_enabled: bool = None,
        data_cache_pl: str = None,
        data_cache_provisioned_iops: int = None,
        description: str = None,
        dns_config_name_servers: List[str] = None,
        dns_config_options: List[CreateEciScalingConfigurationRequestDnsConfigOptions] = None,
        dns_config_searchs: List[str] = None,
        dns_policy: str = None,
        egress_bandwidth: int = None,
        eip_bandwidth: int = None,
        enable_sls: bool = None,
        ephemeral_storage: int = None,
        gpu_driver_version: str = None,
        host_aliases: List[CreateEciScalingConfigurationRequestHostAliases] = None,
        host_name: str = None,
        image_registry_credentials: List[CreateEciScalingConfigurationRequestImageRegistryCredentials] = None,
        image_snapshot_id: str = None,
        ingress_bandwidth: int = None,
        init_containers: List[CreateEciScalingConfigurationRequestInitContainers] = None,
        instance_family_level: str = None,
        instance_types: List[str] = None,
        ipv_6address_count: int = None,
        load_balancer_weight: int = None,
        memory: float = None,
        ntp_servers: List[str] = None,
        owner_id: int = None,
        ram_role_name: str = None,
        resource_group_id: str = None,
        resource_owner_account: str = None,
        restart_policy: str = None,
        scaling_configuration_name: str = None,
        scaling_group_id: str = None,
        security_context_sysctls: List[CreateEciScalingConfigurationRequestSecurityContextSysctls] = None,
        security_group_id: str = None,
        spot_price_limit: float = None,
        spot_strategy: str = None,
        tags: List[CreateEciScalingConfigurationRequestTags] = None,
        termination_grace_period_seconds: int = None,
        volumes: List[CreateEciScalingConfigurationRequestVolumes] = None,
    ):
        # The Container Registry Enterprise Edition instances.
        self.acr_registry_infos = acr_registry_infos
        # The validity period of the scaling configuration. Unit: seconds.
        self.active_deadline_seconds = active_deadline_seconds
        # Specifies whether to automatically create elastic IP addresses (EIPs) and bind the EIPs to elastic container instances.
        self.auto_create_eip = auto_create_eip
        # Specifies whether to automatically match the image cache. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        self.auto_match_image_cache = auto_match_image_cache
        # The name series of elastic container instances.
        # 
        # If you want to use an ordered instance name, specify the value for this parameter in the following format: name_prefix[begin_number,bits]name_suffix.
        self.container_group_name = container_group_name
        # The containers per elastic container instance.
        self.containers = containers
        # Specifies whether to enable the Cost Optimization feature. Valid values:
        # 
        # *   true
        # *   false
        self.cost_optimization = cost_optimization
        # The number of vCPUs per elastic container instance.
        self.cpu = cpu
        # The number of physical CPU cores. You can specify this parameter for specific instance types. For more information, see [Specify CPU options](https://help.aliyun.com/document_detail/197781.html).
        self.cpu_options_core = cpu_options_core
        # The number of threads per core. You can specify this parameter for specific instance types. A value of 1 specifies that Hyper-Threading is disabled. For more information, see [Specify CPU options](https://help.aliyun.com/document_detail/197781.html).
        self.cpu_options_threads_per_core = cpu_options_threads_per_core
        # The bucket that you want to use to store data caches.
        self.data_cache_bucket = data_cache_bucket
        # Specifies whether to enable the performance burst feature when ESSD AutoPL disks are used to store data caches. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        # 
        # >  For more information about ESSD AutoPL disks, see [ESSD AutoPL disks](https://help.aliyun.com/document_detail/368372.html).
        self.data_cache_bursting_enabled = data_cache_bursting_enabled
        # The PL of the cloud disk that you want to use to store data caches. We recommend that you use ESSDs. Valid values:
        # 
        # *   PL0: An ESSD can provide up to 10,000 random read/write IOPS.
        # *   PL1: An ESSD can provide up to 50,000 random read/write IOPS.
        # *   PL2: An ESSD can provide up to 100,000 random read/write IOPS.
        # *   PL3: An ESSD can provide up to 1,000,000 random read/write IOPS.
        # 
        # Default value: PL1.
        # 
        # >  For more information about ESSDs, see [ESSDs](https://help.aliyun.com/document_detail/122389.html).
        self.data_cache_pl = data_cache_pl
        # The provisioned IOPS of the ESSD AutoPL disk that you want to use to store data caches. Valid values: 0 to min{50,000, 1,000 × *Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50 × *Capacity, 50,000}.
        # 
        # >  For more information about ESSD AutoPL disks, see [ESSD AutoPL disks](https://help.aliyun.com/document_detail/368372.html).
        self.data_cache_provisioned_iops = data_cache_provisioned_iops
        # >  This parameter is unavailable for use.
        self.description = description
        # The IP addresses of the DNS servers.
        self.dns_config_name_servers = dns_config_name_servers
        # The options. Each option is a name-value pair. The value in the name-value pair is optional.
        self.dns_config_options = dns_config_options
        # The search domains of the DNS servers.
        self.dns_config_searchs = dns_config_searchs
        # The Domain Name System (DNS) policy. Valid values:
        # 
        # *   None: uses the DNS that is specified by DnsConfig.
        # *   Default: uses the DNS that is specified for the runtime environment.
        self.dns_policy = dns_policy
        # The maximum outbound bandwidth. Unit: bit/s.
        self.egress_bandwidth = egress_bandwidth
        # The EIP bandwidth. Default value: 5. Unit: Mbit/s.
        self.eip_bandwidth = eip_bandwidth
        # >  This parameter is unavailable for use.
        self.enable_sls = enable_sls
        # The size of the temporary storage space. By default, an Enterprise SSD (ESSD) of performance level 1 (PL1) is used. Unit: GiB.
        self.ephemeral_storage = ephemeral_storage
        # The version of the GPU driver. Valid values:
        # 
        # *   tesla=470.82.01 (default)
        # *   tesla=525.85.12
        # 
        # >  You can switch the GPU driver version only for a few Elastic Compute Service (ECS) instance types. For more information, see [Specify GPU-accelerated ECS instance types to create an elastic container instance](https://help.aliyun.com/document_detail/2579486.html).
        self.gpu_driver_version = gpu_driver_version
        # The custom hostnames of the containers.
        self.host_aliases = host_aliases
        # The hostname series of elastic container instances.
        self.host_name = host_name
        # The image repositories.
        self.image_registry_credentials = image_registry_credentials
        # The ID of the image cache.
        self.image_snapshot_id = image_snapshot_id
        # The maximum inbound bandwidth. Unit: bit/s.
        self.ingress_bandwidth = ingress_bandwidth
        # The init containers.
        self.init_containers = init_containers
        # The level of the instance family. You can specify this parameter to match the available instance types. This parameter takes effect only if you set `CostOptimization` to true. Valid values:
        # 
        # *   EntryLevel: entry level (shared instance types). Instance types of this level are the most cost-effective, but may not ensure stable computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low. For more information, see [Shared instance families](https://help.aliyun.com/document_detail/108489.html).
        # *   EnterpriseLevel: enterprise level. Instance types of this level provide stable performance and dedicated resources, and are suitable for business scenarios that require high stability. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        # *   CreditEntryLevel: credit-based entry level (burstable instance types). CPU credits are used to ensure computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low but may fluctuate in specific cases. For more information, see [Overview](https://help.aliyun.com/document_detail/59977.html) of burstable instances.
        self.instance_family_level = instance_family_level
        # The ECS instance types that you want to use to create elastic container instances. You can specify up to five ECS instance types.
        self.instance_types = instance_types
        # The number of IPv6 addresses.
        self.ipv_6address_count = ipv_6address_count
        # The load balancing weight of each elastic container instance. Valid values: 1 to 100.
        # 
        # Default value: 50.
        self.load_balancer_weight = load_balancer_weight
        # The memory size per elastic container instance. Unit: GiB.
        self.memory = memory
        # The endpoints of the Network Time Protocol (NTP) servers.
        self.ntp_servers = ntp_servers
        self.owner_id = owner_id
        # The name of the instance Resource Access Management (RAM) role. Elastic container instances and Elastic Compute Service (ECS) instances can share the same RAM role. For more information, see [RAM roles](https://help.aliyun.com/document_detail/61175.html).
        self.ram_role_name = ram_role_name
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        self.resource_owner_account = resource_owner_account
        # The restart policy of elastic container instances. Valid values:
        # 
        # *   Always: always restarts elastic container instances.
        # *   Never: never restarts elastic container instances.
        # *   OnFailure: restarts elastic container instances upon failures.
        # 
        # Default value: Always.
        self.restart_policy = restart_policy
        # The name of the scaling configuration. The name must be 2 to 64 characters in length and can contain letters, digits, underscores (_), hyphens (-), and periods (.). It must start with a letter or a digit.
        # 
        # The name of the scaling configuration must be unique in a scaling group within a region. If you do not specify this parameter, the value of ScalingConfigurationId is used.
        self.scaling_configuration_name = scaling_configuration_name
        # The ID of the scaling group to which the scaling configuration belongs.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id
        # The system information of the security context in which the elastic container instance runs.
        self.security_context_sysctls = security_context_sysctls
        # The ID of the security group to which elastic container instances belong. Elastic container instances that belong to the same security group can communicate with each other.
        # 
        # If you do not specify a security group, the system uses the default security group in the region that you selected. Make sure that the inbound rules of the security group contain the protocols and port numbers of the containers that you want to expose. If you do not have a default security group in the region, the system creates a default security group, and then adds the container protocols and port numbers that you specified to the inbound rules of the security group.
        self.security_group_id = security_group_id
        # The maximum hourly price of preemptible elastic container instances. The value can be accurate to three decimal places.
        # 
        # If you set SpotStrategy to SpotWithPriceLimit, you must specify SpotPriceLimit.
        self.spot_price_limit = spot_price_limit
        # The instance bidding policy. Valid values:
        # 
        # *   NoSpot: The instances are created as pay-as-you-go instances.
        # *   SpotWithPriceLimit: The instances are preemptible instances for which you can specify the maximum hourly price.
        # *   SpotAsPriceGo: The instances are created as preemptible instances for which the market price at the time of purchase is used as the bid price.
        # 
        # Default value: NoSpot.
        self.spot_strategy = spot_strategy
        # The tags of elastic container instances. Tags must be specified as key-value pairs. You can specify up to 20 tags for each elastic container instance. When you specify Key and Value, take note of the following items:
        # 
        # *   A tag key can be up to 64 characters in length. The key cannot start with acs: or aliyun or contain `http://` or `https://`. You cannot specify an empty string as a tag key.
        # *   A tag value can be up to 128 characters in length. The value cannot start with acs: or aliyun or contain `http://` or `https://`. You can specify an empty string as a tag value.
        self.tags = tags
        # The buffer time during which a program handles operations before the program stops. Unit: seconds.
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # The volumes.
        self.volumes = volumes

    def validate(self):
        if self.acr_registry_infos:
            for k in self.acr_registry_infos:
                if k:
                    k.validate()
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()
        if self.dns_config_options:
            for k in self.dns_config_options:
                if k:
                    k.validate()
        if self.host_aliases:
            for k in self.host_aliases:
                if k:
                    k.validate()
        if self.image_registry_credentials:
            for k in self.image_registry_credentials:
                if k:
                    k.validate()
        if self.init_containers:
            for k in self.init_containers:
                if k:
                    k.validate()
        if self.security_context_sysctls:
            for k in self.security_context_sysctls:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.volumes:
            for k in self.volumes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AcrRegistryInfos'] = []
        if self.acr_registry_infos is not None:
            for k in self.acr_registry_infos:
                result['AcrRegistryInfos'].append(k.to_map() if k else None)
        if self.active_deadline_seconds is not None:
            result['ActiveDeadlineSeconds'] = self.active_deadline_seconds
        if self.auto_create_eip is not None:
            result['AutoCreateEip'] = self.auto_create_eip
        if self.auto_match_image_cache is not None:
            result['AutoMatchImageCache'] = self.auto_match_image_cache
        if self.container_group_name is not None:
            result['ContainerGroupName'] = self.container_group_name
        result['Containers'] = []
        if self.containers is not None:
            for k in self.containers:
                result['Containers'].append(k.to_map() if k else None)
        if self.cost_optimization is not None:
            result['CostOptimization'] = self.cost_optimization
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.cpu_options_core is not None:
            result['CpuOptionsCore'] = self.cpu_options_core
        if self.cpu_options_threads_per_core is not None:
            result['CpuOptionsThreadsPerCore'] = self.cpu_options_threads_per_core
        if self.data_cache_bucket is not None:
            result['DataCacheBucket'] = self.data_cache_bucket
        if self.data_cache_bursting_enabled is not None:
            result['DataCacheBurstingEnabled'] = self.data_cache_bursting_enabled
        if self.data_cache_pl is not None:
            result['DataCachePL'] = self.data_cache_pl
        if self.data_cache_provisioned_iops is not None:
            result['DataCacheProvisionedIops'] = self.data_cache_provisioned_iops
        if self.description is not None:
            result['Description'] = self.description
        if self.dns_config_name_servers is not None:
            result['DnsConfigNameServers'] = self.dns_config_name_servers
        result['DnsConfigOptions'] = []
        if self.dns_config_options is not None:
            for k in self.dns_config_options:
                result['DnsConfigOptions'].append(k.to_map() if k else None)
        if self.dns_config_searchs is not None:
            result['DnsConfigSearchs'] = self.dns_config_searchs
        if self.dns_policy is not None:
            result['DnsPolicy'] = self.dns_policy
        if self.egress_bandwidth is not None:
            result['EgressBandwidth'] = self.egress_bandwidth
        if self.eip_bandwidth is not None:
            result['EipBandwidth'] = self.eip_bandwidth
        if self.enable_sls is not None:
            result['EnableSls'] = self.enable_sls
        if self.ephemeral_storage is not None:
            result['EphemeralStorage'] = self.ephemeral_storage
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        result['HostAliases'] = []
        if self.host_aliases is not None:
            for k in self.host_aliases:
                result['HostAliases'].append(k.to_map() if k else None)
        if self.host_name is not None:
            result['HostName'] = self.host_name
        result['ImageRegistryCredentials'] = []
        if self.image_registry_credentials is not None:
            for k in self.image_registry_credentials:
                result['ImageRegistryCredentials'].append(k.to_map() if k else None)
        if self.image_snapshot_id is not None:
            result['ImageSnapshotId'] = self.image_snapshot_id
        if self.ingress_bandwidth is not None:
            result['IngressBandwidth'] = self.ingress_bandwidth
        result['InitContainers'] = []
        if self.init_containers is not None:
            for k in self.init_containers:
                result['InitContainers'].append(k.to_map() if k else None)
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.load_balancer_weight is not None:
            result['LoadBalancerWeight'] = self.load_balancer_weight
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.ntp_servers is not None:
            result['NtpServers'] = self.ntp_servers
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.restart_policy is not None:
            result['RestartPolicy'] = self.restart_policy
        if self.scaling_configuration_name is not None:
            result['ScalingConfigurationName'] = self.scaling_configuration_name
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        result['SecurityContextSysctls'] = []
        if self.security_context_sysctls is not None:
            for k in self.security_context_sysctls:
                result['SecurityContextSysctls'].append(k.to_map() if k else None)
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.termination_grace_period_seconds is not None:
            result['TerminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        result['Volumes'] = []
        if self.volumes is not None:
            for k in self.volumes:
                result['Volumes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acr_registry_infos = []
        if m.get('AcrRegistryInfos') is not None:
            for k in m.get('AcrRegistryInfos'):
                temp_model = CreateEciScalingConfigurationRequestAcrRegistryInfos()
                self.acr_registry_infos.append(temp_model.from_map(k))
        if m.get('ActiveDeadlineSeconds') is not None:
            self.active_deadline_seconds = m.get('ActiveDeadlineSeconds')
        if m.get('AutoCreateEip') is not None:
            self.auto_create_eip = m.get('AutoCreateEip')
        if m.get('AutoMatchImageCache') is not None:
            self.auto_match_image_cache = m.get('AutoMatchImageCache')
        if m.get('ContainerGroupName') is not None:
            self.container_group_name = m.get('ContainerGroupName')
        self.containers = []
        if m.get('Containers') is not None:
            for k in m.get('Containers'):
                temp_model = CreateEciScalingConfigurationRequestContainers()
                self.containers.append(temp_model.from_map(k))
        if m.get('CostOptimization') is not None:
            self.cost_optimization = m.get('CostOptimization')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CpuOptionsCore') is not None:
            self.cpu_options_core = m.get('CpuOptionsCore')
        if m.get('CpuOptionsThreadsPerCore') is not None:
            self.cpu_options_threads_per_core = m.get('CpuOptionsThreadsPerCore')
        if m.get('DataCacheBucket') is not None:
            self.data_cache_bucket = m.get('DataCacheBucket')
        if m.get('DataCacheBurstingEnabled') is not None:
            self.data_cache_bursting_enabled = m.get('DataCacheBurstingEnabled')
        if m.get('DataCachePL') is not None:
            self.data_cache_pl = m.get('DataCachePL')
        if m.get('DataCacheProvisionedIops') is not None:
            self.data_cache_provisioned_iops = m.get('DataCacheProvisionedIops')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DnsConfigNameServers') is not None:
            self.dns_config_name_servers = m.get('DnsConfigNameServers')
        self.dns_config_options = []
        if m.get('DnsConfigOptions') is not None:
            for k in m.get('DnsConfigOptions'):
                temp_model = CreateEciScalingConfigurationRequestDnsConfigOptions()
                self.dns_config_options.append(temp_model.from_map(k))
        if m.get('DnsConfigSearchs') is not None:
            self.dns_config_searchs = m.get('DnsConfigSearchs')
        if m.get('DnsPolicy') is not None:
            self.dns_policy = m.get('DnsPolicy')
        if m.get('EgressBandwidth') is not None:
            self.egress_bandwidth = m.get('EgressBandwidth')
        if m.get('EipBandwidth') is not None:
            self.eip_bandwidth = m.get('EipBandwidth')
        if m.get('EnableSls') is not None:
            self.enable_sls = m.get('EnableSls')
        if m.get('EphemeralStorage') is not None:
            self.ephemeral_storage = m.get('EphemeralStorage')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        self.host_aliases = []
        if m.get('HostAliases') is not None:
            for k in m.get('HostAliases'):
                temp_model = CreateEciScalingConfigurationRequestHostAliases()
                self.host_aliases.append(temp_model.from_map(k))
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        self.image_registry_credentials = []
        if m.get('ImageRegistryCredentials') is not None:
            for k in m.get('ImageRegistryCredentials'):
                temp_model = CreateEciScalingConfigurationRequestImageRegistryCredentials()
                self.image_registry_credentials.append(temp_model.from_map(k))
        if m.get('ImageSnapshotId') is not None:
            self.image_snapshot_id = m.get('ImageSnapshotId')
        if m.get('IngressBandwidth') is not None:
            self.ingress_bandwidth = m.get('IngressBandwidth')
        self.init_containers = []
        if m.get('InitContainers') is not None:
            for k in m.get('InitContainers'):
                temp_model = CreateEciScalingConfigurationRequestInitContainers()
                self.init_containers.append(temp_model.from_map(k))
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('LoadBalancerWeight') is not None:
            self.load_balancer_weight = m.get('LoadBalancerWeight')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NtpServers') is not None:
            self.ntp_servers = m.get('NtpServers')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('RestartPolicy') is not None:
            self.restart_policy = m.get('RestartPolicy')
        if m.get('ScalingConfigurationName') is not None:
            self.scaling_configuration_name = m.get('ScalingConfigurationName')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        self.security_context_sysctls = []
        if m.get('SecurityContextSysctls') is not None:
            for k in m.get('SecurityContextSysctls'):
                temp_model = CreateEciScalingConfigurationRequestSecurityContextSysctls()
                self.security_context_sysctls.append(temp_model.from_map(k))
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = CreateEciScalingConfigurationRequestTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('TerminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('TerminationGracePeriodSeconds')
        self.volumes = []
        if m.get('Volumes') is not None:
            for k in m.get('Volumes'):
                temp_model = CreateEciScalingConfigurationRequestVolumes()
                self.volumes.append(temp_model.from_map(k))
        return self


class CreateEciScalingConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_configuration_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The ID of the elastic container instance (container group).
        self.scaling_configuration_id = scaling_configuration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        return self


class CreateEciScalingConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateEciScalingConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateEciScalingConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLifecycleHookRequest(TeaModel):
    def __init__(
        self,
        default_result: str = None,
        heartbeat_timeout: int = None,
        lifecycle_hook_name: str = None,
        lifecycle_transition: str = None,
        notification_arn: str = None,
        notification_metadata: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        # The action that you want Auto Scaling to perform after the lifecycle hook times out. Valid values:
        # 
        # *   CONTINUE: Auto Scaling continues to respond to scale-in or scale-out requests.
        # *   ABANDON: Auto Scaling releases Elastic Compute Service (ECS) instances that are created during scale-out activities, or removes ECS instances from the scaling group during scale-in activities.
        # 
        # If multiple lifecycle hooks in a scaling group are triggered during scale-in activities and you set the DefaultResult parameter to ABANDON for one of the lifecycle hooks, Auto Scaling immediately performs the action after the lifecycle hook whose DefaultResult is set to ABANDON times out. As a result, other lifecycle hooks time out ahead of schedule. In other cases, Auto Scaling performs the action only after all lifecycle hooks time out.
        # 
        # Default value: CONTINUE.
        self.default_result = default_result
        # The period of time before the lifecycle hook times out. After the lifecycle hook times out, Auto Scaling performs the default action. Valid values: 30 to 21600. Unit: seconds.
        # 
        # After you create a lifecycle hook, you can call the RecordLifecycleActionHeartbeat operation to prolong the timeout period of the lifecycle hook. You can also call the CompleteLifecycleAction operation to end the timeout period of the lifecycle hook ahead of schedule.
        # 
        # Default value: 600.
        self.heartbeat_timeout = heartbeat_timeout
        # The name of the lifecycle hook. Each lifecycle hook name must be unique within a scaling group. The name must be 2 to 64 characters in length, and can contain letters, digits, underscores (_), hyphens (-), and periods (.). It must start with a letter or a digit.
        # 
        # If you do not specify this parameter, the value of the LifecycleHookId parameter is used.
        self.lifecycle_hook_name = lifecycle_hook_name
        # The type of the scaling activity to which the lifecycle hook applies. Valid values:
        # 
        # *   SCALE_OUT
        # *   SCALE_IN
        # 
        # This parameter is required.
        self.lifecycle_transition = lifecycle_transition
        # The Alibaba Cloud Resource Name (ARN) of the notification recipient. If you do not specify this parameter, no notification is sent when the lifecycle hook takes effect. If you specify this parameter, the value must be in one of the following formats:
        # 
        # *   If you specify a Simple Message Queue (SMQ, formerly MNS) as the notification recipient, specify the value in the acs:mns:{region-id}:{account-id}:queue/{queuename} format.
        # *   If you specify an SMQ topic as the notification recipient, specify the value in the acs:mns:{region-id}:{account-id}:topic/{topicname} format.
        # *   If you specify a CloudOps Orchestration Service (OOS) template as the notification recipient, specify the value in the acs:oos:{region-id}:{account-id}:template/{templatename} format.
        # *   If you specify an event bus as the notification recipient, specify the value in the acs:eventbridge:{region-id}:{account-id}:eventbus/default format.
        # 
        # The variables in the preceding value formats have the following meanings:
        # 
        # *   region-id: the region ID of your scaling group.
        # *   account-id: the ID of the Alibaba Cloud account. IDs of Resource Access Management (RAM) users are not supported.
        # *   queuename: the name of the SMQ queue.
        # *   topicname: the name of the SMQ topic.
        # *   templatename: the name of the OOS template.
        self.notification_arn = notification_arn
        # The notification metadata that is sent when the lifecycle hook takes effect. This helps you manage and categorize notifications in an efficient manner. If you specify this parameter, you must specify the NotificationArn parameter. The parameter value cannot exceed 4,096 characters in length.
        # 
        # If you use the NotificationArn parameter to specify a public or customOOS template, the value of the NotificationMetadata parameter must be a JSON string that contains the OOS template parameters. For example, your OOS template includes the following parameters: `{"dbInstanceId": "dds-bp17661e0135****", "modifyMode": "Append"}`, `dbInstanceId`, and `modifyMode`. Some parameters defined in your OOS template have default values. When you specify the NotificationMetadata parameter, specify parameters that do not have default values. If you specify parameters that have default values, the default values are overwritten. However, the default values of the following parameters must be retained to obtain information about scaling activities that are in progress:
        # 
        # *   `regionId`: the region ID of the scaling activity that is in progress. Default value: ${regionId}.
        # *   `instanceIds`: the IDs of ECS instances that are scaled in in the scaling activity. Default value: ${instanceIds}.
        # *   `lifecycleHookId`: the ID of the lifecycle hook. Default value: ${lifecycleHookId}.
        # *   `lifecycleActionToken`: the token of the lifecycle action. You can use the token to end the timeout period of the lifecycle hook ahead of schedule. Default value: ${lifecycleActionToken}
        # *   `scalingGroupId`: the ID of the scaling group in which the scaling activity is executed. Default value: ${scalingGroupId}.
        # 
        # > You can obtain template parameter information in the [OOS console](https://oos.console.aliyun.com/).
        self.notification_metadata = notification_metadata
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_result is not None:
            result['DefaultResult'] = self.default_result
        if self.heartbeat_timeout is not None:
            result['HeartbeatTimeout'] = self.heartbeat_timeout
        if self.lifecycle_hook_name is not None:
            result['LifecycleHookName'] = self.lifecycle_hook_name
        if self.lifecycle_transition is not None:
            result['LifecycleTransition'] = self.lifecycle_transition
        if self.notification_arn is not None:
            result['NotificationArn'] = self.notification_arn
        if self.notification_metadata is not None:
            result['NotificationMetadata'] = self.notification_metadata
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultResult') is not None:
            self.default_result = m.get('DefaultResult')
        if m.get('HeartbeatTimeout') is not None:
            self.heartbeat_timeout = m.get('HeartbeatTimeout')
        if m.get('LifecycleHookName') is not None:
            self.lifecycle_hook_name = m.get('LifecycleHookName')
        if m.get('LifecycleTransition') is not None:
            self.lifecycle_transition = m.get('LifecycleTransition')
        if m.get('NotificationArn') is not None:
            self.notification_arn = m.get('NotificationArn')
        if m.get('NotificationMetadata') is not None:
            self.notification_metadata = m.get('NotificationMetadata')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class CreateLifecycleHookResponseBody(TeaModel):
    def __init__(
        self,
        lifecycle_hook_id: str = None,
        request_id: str = None,
    ):
        # The ID of the lifecycle hook.
        self.lifecycle_hook_id = lifecycle_hook_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lifecycle_hook_id is not None:
            result['LifecycleHookId'] = self.lifecycle_hook_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LifecycleHookId') is not None:
            self.lifecycle_hook_id = m.get('LifecycleHookId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLifecycleHookResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateLifecycleHookResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLifecycleHookResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNotificationConfigurationRequest(TeaModel):
    def __init__(
        self,
        notification_arn: str = None,
        notification_types: List[str] = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
        time_zone: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the notification recipient. The following list describes the value formats of this parameter:
        # 
        # *   If you specify CloudMonitor as the notification recipient, specify the value in the `acs:ess:{region-id}:{account-id}:cloudmonitor` format.
        # *   If you specify an SMQ queue as the notification recipient, specify the value in the `acs:mns:{region-id}:{account-id}:queue/{queuename}` format.
        # *   If you specify an SMQ topic as the notification recipient, specify the value in the `acs:mns:{region-id}:{account-id}:topic/{topicname}` format.
        # 
        # The variables in the preceding formats have the following meanings:
        # 
        # *   `region-id`: the region ID of the scaling group.
        # *   `account-id`: the ID of the Alibaba Cloud account.
        # *   `queuename`: the name of the SMQ queue.
        # *   `topicname`: the name of the SMQ topic.
        # 
        # This parameter is required.
        self.notification_arn = notification_arn
        # The notification types. Specify multiple IDs in the repeated list form.
        # 
        # You can call the DescribeNotificationTypes operation to query the values of this parameter.
        # 
        # This parameter is required.
        self.notification_types = notification_types
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id
        # The time zone of the notification. Specify the value in UTC. For example, a value of UTC+8 specifies that the time is 8 hours ahead of Coordinated Universal Time, and a value of UTC-7 specifies that the time is 7 hours behind Coordinated Universal Time.
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notification_arn is not None:
            result['NotificationArn'] = self.notification_arn
        if self.notification_types is not None:
            result['NotificationTypes'] = self.notification_types
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NotificationArn') is not None:
            self.notification_arn = m.get('NotificationArn')
        if m.get('NotificationTypes') is not None:
            self.notification_types = m.get('NotificationTypes')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class CreateNotificationConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNotificationConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNotificationConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNotificationConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScalingConfigurationRequestImageOptions(TeaModel):
    def __init__(
        self,
        login_as_non_root: bool = None,
    ):
        # For more information about whether an ECS instance uses the ecs-user user user to log on to an ECS instance, see [Manage the login name of an ECS instance](https://help.aliyun.com/document_detail/388447.html). Value range:
        # 
        # - true: Yes.
        # - false: No.
        # 
        # Default value: false.
        self.login_as_non_root = login_as_non_root

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.login_as_non_root is not None:
            result['LoginAsNonRoot'] = self.login_as_non_root
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LoginAsNonRoot') is not None:
            self.login_as_non_root = m.get('LoginAsNonRoot')
        return self


class CreateScalingConfigurationRequestPrivatePoolOptions(TeaModel):
    def __init__(
        self,
        id: str = None,
        match_criteria: str = None,
    ):
        # The ID of the private pool. The ID of a private pool is the same as the ID of the elasticity assurance or capacity reservation for which the private pool is generated.
        self.id = id
        # The type of the private pool that you want to use to start ECS instances. A private pool is generated when an elasticity assurance or a capacity reservation takes effect. You can select a private pool to create ECS instances. Valid values:
        # 
        # *   Open: open private pool. Auto Scaling selects a matching open private pool to start instances. If no matching open private pools are found, Auto Scaling uses the resources in the public pool to start instances. In this case, you do not need to specify PrivatePoolOptions.Id.
        # *   Target: specified private pool. Auto Scaling uses the resources in the specified private pool to start ECS instances. If the specified private pool is unavailable, Auto Scaling cannot start ECS instances. If you set this parameter to Target, you must specify PrivatePoolOptions.Id.
        # *   None: no private pool. Auto Scaling does not use the resources in private pools to start ECS instances.
        self.match_criteria = match_criteria

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        return self


class CreateScalingConfigurationRequestSystemDisk(TeaModel):
    def __init__(
        self,
        auto_snapshot_policy_id: str = None,
        bursting_enabled: bool = None,
        category: str = None,
        description: str = None,
        disk_name: str = None,
        encrypt_algorithm: str = None,
        encrypted: bool = None,
        kmskey_id: str = None,
        performance_level: str = None,
        provisioned_iops: int = None,
        size: int = None,
    ):
        # The ID of the automatic snapshot policy that you want to apply to the system disk.
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        # Specifies whether to enable the burst feature for the system disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # > This parameter is available only if you set `SystemDisk.Category` to `cloud_auto`.
        self.bursting_enabled = bursting_enabled
        # The category of the system disk. Valid values:
        # 
        # *   cloud: basic disk
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   ephemeral_ssd: local SSD
        # *   cloud_essd: enhanced SSD (ESSD)
        # *   cloud_auto: ESSD AutoPL disk
        # 
        # If you specify SystemDisk.Category, you cannot specify `SystemDiskCategories`. If you do not specify SystemDisk.Category or `SystemDiskCategories`, the default value of SystemDisk.Category is used.
        # 
        # *   For I/O optimized instances, the default value is cloud_efficiency.
        # *   For non-I/O optimized instances, the default value is cloud.
        self.category = category
        # The description of the system disk. The description must be 2 to 256 characters in length. The description can contain letters and cannot start with `http://` or `https://`.
        self.description = description
        # The name of the system disk. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.disk_name = disk_name
        # The encryption algorithm that you want to use to encrypt the system disk. Valid values:
        # 
        # *   AES-256
        # *   SM4-128
        # 
        # Default value: AES-256
        self.encrypt_algorithm = encrypt_algorithm
        # Specifies whether to encrypt the system disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false
        self.encrypted = encrypted
        # The ID of the KMS key that you want to use to encrypt the system disk.
        self.kmskey_id = kmskey_id
        # The performance level (PL) of the system disk that is an enhanced SSD (ESSD). Valid values:
        # 
        # *   PL0: An ESSD can provide up to 10,000 random read/write IOPS.
        # *   PL1: An ESSD can provide up to 50,000 random read/write IOPS.
        # *   PL2: An ESSD can provide up to 100,000 random read/write IOPS.
        # *   PL3: An ESSD can provide up to 1,000,000 random read/write IOPS.
        # 
        # Default value: PL1.
        self.performance_level = performance_level
        # The IOPS metric that is preconfigured for the system disk.
        # 
        # > IOPS measures the number of read and write operations that an EBS device can process per second.
        self.provisioned_iops = provisioned_iops
        # The size of the system disk. Unit: GiB.
        # 
        # *   Basic disk: 20 to 500.
        # 
        # *   ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD.
        # 
        #     *   PL0 ESSD: 1 to 2048.
        #     *   PL1 ESSD: 20 to 2048.
        #     *   PL2 ESSD: 461 to 2048.
        #     *   PL3 ESSD: 1261 to 2048.
        # 
        # *   ESSD AutoPL disk (cloud_auto): 1 to 2048.
        # 
        # *   Other disk categories: 20 to 2048.
        # 
        # The value of this parameter must be at least 1 and greater than or equal to the image size.
        # 
        # Default value: 40 or the size of the image, whichever is larger.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class CreateScalingConfigurationRequestCustomPriorities(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        vswitch_id: str = None,
    ):
        # The ECS instance type.
        # 
        # >  The ECS instance type must be included in the instance types specified in the scaling configuration.
        self.instance_type = instance_type
        # The vSwitch ID.
        # 
        # >  The vSwitch must be included in the vSwitch list of the scaling group.
        self.vswitch_id = vswitch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class CreateScalingConfigurationRequestDataDisks(TeaModel):
    def __init__(
        self,
        auto_snapshot_policy_id: str = None,
        bursting_enabled: bool = None,
        categories: List[str] = None,
        category: str = None,
        delete_with_instance: bool = None,
        description: str = None,
        device: str = None,
        disk_name: str = None,
        encrypted: str = None,
        kmskey_id: str = None,
        performance_level: str = None,
        provisioned_iops: int = None,
        size: int = None,
        snapshot_id: str = None,
    ):
        # The ID of the automatic snapshot policy that you want to apply to the data disk.
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        # Specifies whether to enable the burst feature for the system disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # > This parameter is available only if you set `SystemDisk.Category` to `cloud_auto`.
        self.bursting_enabled = bursting_enabled
        # The categories of the data disks. If Auto Scaling cannot create instances by using the disk category that has the highest priority, Auto Scaling creates instances by using the disk category that has the next highest priority. Valid values:
        # 
        # *   cloud: basic disk. For a basic disk that is created together with the instance, DeleteWithInstance is set to true.
        # *   cloud_efficiency: ultra disk.
        # *   cloud_ssd: standard SSD.
        # *   cloud_essd: ESSD.
        # 
        # > If you specify Categories, you cannot specify `DataDisks.Category`.
        self.categories = categories
        # The category of the data disk. Valid values:
        # 
        # *   cloud: basic disk
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   cloud_essd: ESSD
        # *   ephemeral_ssd: local SSD
        # *   cloud_auto: ESSD AutoPL disk
        # 
        # If you specify this parameter, you cannot specify Categories. If you do not specify Category or Categories, the default value of Category is used.
        # 
        # *   For I/O optimized instances, the default value is cloud_efficiency.
        # *   For non-I/O optimized instances, the default value is cloud.
        self.category = category
        # Specifies whether to release the data disk when the instance to which the data disk is attached is released. Valid values:
        # 
        # *   true
        # *   false
        # 
        # This parameter is available only for independent disks whose value of Category is set to cloud, cloud_efficiency, cloud_ssd, or cloud_essd. If you specify this parameter for other disks, an error is reported.
        # 
        # Default value: true
        self.delete_with_instance = delete_with_instance
        # The description of the data disk. The description must be 2 to 256 characters in length. The description can contain letters and cannot start with `http://` or `https://`.
        self.description = description
        # The mount target of the data disk. If you do not specify Device, a mount target is automatically assigned when Auto Scaling creates ECS instances. The names of mount targets range from /dev/xvdb to /dev/xvdz.
        self.device = device
        # The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.disk_name = disk_name
        # Specifies whether to encrypt the data disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false
        self.encrypted = encrypted
        # The ID of the KMS key that you want to use to encrypt the data disk.
        self.kmskey_id = kmskey_id
        # The PL of the data disk that is an ESSD. Valid values:
        # 
        # *   PL0: An ESSD can provide up to 10,000 random read/write IOPS.
        # *   PL1: An ESSD can provide up to 50,000 random read/write IOPS.
        # *   PL2: An ESSD can provide up to 100,000 random read/write IOPS.
        # *   PL3: An ESSD can provide up to 1,000,000 random read/write IOPS.
        # 
        # > For more information about how to select ESSD PLs, see [ESSD](https://help.aliyun.com/document_detail/122389.html).
        self.performance_level = performance_level
        # The IOPS metric that is preconfigured for the data disk.
        # 
        # > IOPS measures the number of read and write operations that an EBS device can process per second.
        self.provisioned_iops = provisioned_iops
        # The size of the data disk. Unit: GiB. Valid values:
        # 
        # *   If you set Categories to cloud: 5 to 2000.
        # *   If you set Categories to cloud_efficiency: 20 to 32768.
        # *   If you set Categories to cloud_essd: 20 to 32768.
        # *   If you set Categories to ephemeral_ssd: 5 to 800.
        # 
        # The size of the data disk must be greater than or equal to the size of the snapshot that is specified by SnapshotId.
        self.size = size
        # The ID of the snapshot that you want to use to create data disks. If you specify this parameter, DataDisks.Size is ignored. The size of the data disk is the same as the size of the specified snapshot.
        # 
        # If you specify a snapshot that is created on or before July 15, 2013, the operation fails and the system returns InvalidSnapshot.TooOld.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.categories is not None:
            result['Categories'] = self.categories
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Categories') is not None:
            self.categories = m.get('Categories')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CreateScalingConfigurationRequestInstancePatternInfos(TeaModel):
    def __init__(
        self,
        architectures: List[str] = None,
        burstable_performance: str = None,
        cores: int = None,
        cpu_architectures: List[str] = None,
        excluded_instance_types: List[str] = None,
        gpu_specs: List[str] = None,
        instance_categories: List[str] = None,
        instance_family_level: str = None,
        instance_type_families: List[str] = None,
        max_price: float = None,
        maximum_cpu_core_count: int = None,
        maximum_gpu_amount: int = None,
        maximum_memory_size: float = None,
        memory: float = None,
        minimum_baseline_credit: int = None,
        minimum_cpu_core_count: int = None,
        minimum_eni_ipv_6address_quantity: int = None,
        minimum_eni_private_ip_address_quantity: int = None,
        minimum_eni_quantity: int = None,
        minimum_gpu_amount: int = None,
        minimum_initial_credit: int = None,
        minimum_memory_size: float = None,
        physical_processor_models: List[str] = None,
    ):
        # The architecture types of the instance types. Valid values:
        # 
        # *   X86: x86 architecture.
        # *   Heterogeneous: heterogeneous computing, such as GPU-accelerated or FPGA-accelerated.
        # *   BareMetal: ECS Bare Metal Instance.
        # *   Arm: Arm.
        # 
        # By default, all values are selected.
        self.architectures = architectures
        # Specifies whether to include burstable instance types. Valid values:
        # 
        # *   Exclude: excludes burstable instance types.
        # *   Include: includes burstable instance types.
        # *   Required: includes only burstable instance types.
        # 
        # Default value: Include.
        self.burstable_performance = burstable_performance
        # The number of vCPUs per instance type in intelligent configuration mode. You can specify this parameter to filter the available instance types. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        # 
        # Take note of the following items:
        # 
        # *   InstancePatternInfos applies only to scaling groups that reside in virtual private clouds (VPCs).
        # *   If you specify InstancePatternInfos, you must also specify InstancePatternInfos.Cores and InstancePatternInfos.Memory.
        # *   If you specify InstanceType or InstanceTypes, Auto Scaling preferentially uses the instance type specified by InstanceType or InstanceTypes to create instances during scale-out events. If the specified instance type has insufficient inventory, Auto Scaling uses the lowest-priced instance type specified by InstancePatternInfos to create instances during scale-out events.
        self.cores = cores
        # The CPU architectures of the instance types. Valid values:
        # 
        # >  You can specify up to two CPU architectures.
        # 
        # *   x86
        # *   Arm
        self.cpu_architectures = cpu_architectures
        # The instance types that you want to exclude. You can use an asterisk (\\*) as a wildcard character to exclude an instance type or an instance family. Examples:
        # 
        # *   ecs.c6.large: excludes the ecs.c6.large instance type.
        # *   ecs.c6.\\*: excludes the c6 instance family.
        self.excluded_instance_types = excluded_instance_types
        # The GPU models.
        self.gpu_specs = gpu_specs
        # The categories of the instance types. Valid values:
        # 
        # >  You can specify up to 10 categories.
        # 
        # *   General-purpose: general-purpose instance type.
        # *   Compute-optimized: compute-optimized instance type.
        # *   Memory-optimized: memory-optimized instance type.
        # *   Big data: big data instance type.
        # *   Local SSDs: instance type that uses local SSDs.
        # *   High Clock Speed: instance type that has high clock speeds.
        # *   Enhanced: enhanced instance type.
        # *   Shared: shared instance type.
        # *   Compute-optimized with GPU: GPU-accelerated compute-optimized instance type.
        # *   Visual Compute-optimized: visual compute-optimized instance type.
        # *   Heterogeneous Service: heterogeneous service instance type.
        # *   Compute-optimized with FPGA: FPGA-accelerated compute-optimized instance type.
        # *   Compute-optimized with NPU: NPU-accelerated compute-optimized instance type.
        # *   ECS Bare Metal: ECS Bare Metal Instance type.
        # *   High Performance Compute: HPC-optimized instance type.
        self.instance_categories = instance_categories
        # The level of the instance family. You can specify this parameter to match the available instance types. This parameter takes effect only if you set `CostOptimization` to true. Valid values:
        # 
        # *   EntryLevel: entry-level (shared instance types). Instance types of this level are the most cost-effective but may not ensure stable computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low. For more information, see [Shared instance families](https://help.aliyun.com/document_detail/108489.html).
        # *   EnterpriseLevel: enterprise-level. Instance types of this level provide stable performance and dedicated resources and are suitable for business scenarios that require high stability. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        # *   CreditEntryLevel: credit entry-level (burstable instance types). CPU credits are used to ensure computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low but may fluctuate in specific cases. For more information, see [Overview](https://help.aliyun.com/document_detail/59977.html) of burstable instances.
        self.instance_family_level = instance_family_level
        # The instance families that you want to specify. You can specify up to 10 instance families in each call.
        self.instance_type_families = instance_type_families
        # The maximum hourly price of pay-as-you-go or preemptible instances in intelligent configuration mode. You can specify this parameter to filter the available instance types.
        # 
        # >  If you set SpotStrategy to SpotWithPriceLimit, you must specify this parameter. In other cases, this parameter is optional.
        self.max_price = max_price
        # The maximum number of vCPUs per instance type.
        # 
        # >  The value of MaximumCpuCoreCount cannot exceed four times the value of MinimumCpuCoreCount.
        self.maximum_cpu_core_count = maximum_cpu_core_count
        # The maximum number of GPUs per instance. The value must be a positive integer.
        self.maximum_gpu_amount = maximum_gpu_amount
        # The maximum memory size per instance. Unit: GiB.
        self.maximum_memory_size = maximum_memory_size
        # The memory size per instance type in intelligent configuration mode. Unit: GiB. You can specify this parameter to filter the available instance types.
        self.memory = memory
        # The baseline vCPU computing performance (overall baseline performance of all vCPUs) per t5 or t6 burstable instance.
        self.minimum_baseline_credit = minimum_baseline_credit
        # The minimum number of vCPUs per instance type.
        self.minimum_cpu_core_count = minimum_cpu_core_count
        # The minimum number of IPv6 addresses per ENI.
        self.minimum_eni_ipv_6address_quantity = minimum_eni_ipv_6address_quantity
        # The minimum number of IPv4 addresses per ENI.
        self.minimum_eni_private_ip_address_quantity = minimum_eni_private_ip_address_quantity
        # The minimum number of elastic network interfaces (ENIs) per instance.
        self.minimum_eni_quantity = minimum_eni_quantity
        # The minimum number of GPUs per instance. The value must be a positive integer.
        self.minimum_gpu_amount = minimum_gpu_amount
        # The initial vCPU credits per t5 or t6 burstable instance.
        self.minimum_initial_credit = minimum_initial_credit
        # The minimum memory size per instance. Unit: GiB.
        self.minimum_memory_size = minimum_memory_size
        # The processor models of the instance types. You can specify up to 10 processor models.
        self.physical_processor_models = physical_processor_models

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architectures is not None:
            result['Architectures'] = self.architectures
        if self.burstable_performance is not None:
            result['BurstablePerformance'] = self.burstable_performance
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.cpu_architectures is not None:
            result['CpuArchitectures'] = self.cpu_architectures
        if self.excluded_instance_types is not None:
            result['ExcludedInstanceTypes'] = self.excluded_instance_types
        if self.gpu_specs is not None:
            result['GpuSpecs'] = self.gpu_specs
        if self.instance_categories is not None:
            result['InstanceCategories'] = self.instance_categories
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_type_families is not None:
            result['InstanceTypeFamilies'] = self.instance_type_families
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.maximum_cpu_core_count is not None:
            result['MaximumCpuCoreCount'] = self.maximum_cpu_core_count
        if self.maximum_gpu_amount is not None:
            result['MaximumGpuAmount'] = self.maximum_gpu_amount
        if self.maximum_memory_size is not None:
            result['MaximumMemorySize'] = self.maximum_memory_size
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.minimum_baseline_credit is not None:
            result['MinimumBaselineCredit'] = self.minimum_baseline_credit
        if self.minimum_cpu_core_count is not None:
            result['MinimumCpuCoreCount'] = self.minimum_cpu_core_count
        if self.minimum_eni_ipv_6address_quantity is not None:
            result['MinimumEniIpv6AddressQuantity'] = self.minimum_eni_ipv_6address_quantity
        if self.minimum_eni_private_ip_address_quantity is not None:
            result['MinimumEniPrivateIpAddressQuantity'] = self.minimum_eni_private_ip_address_quantity
        if self.minimum_eni_quantity is not None:
            result['MinimumEniQuantity'] = self.minimum_eni_quantity
        if self.minimum_gpu_amount is not None:
            result['MinimumGpuAmount'] = self.minimum_gpu_amount
        if self.minimum_initial_credit is not None:
            result['MinimumInitialCredit'] = self.minimum_initial_credit
        if self.minimum_memory_size is not None:
            result['MinimumMemorySize'] = self.minimum_memory_size
        if self.physical_processor_models is not None:
            result['PhysicalProcessorModels'] = self.physical_processor_models
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architectures') is not None:
            self.architectures = m.get('Architectures')
        if m.get('BurstablePerformance') is not None:
            self.burstable_performance = m.get('BurstablePerformance')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('CpuArchitectures') is not None:
            self.cpu_architectures = m.get('CpuArchitectures')
        if m.get('ExcludedInstanceTypes') is not None:
            self.excluded_instance_types = m.get('ExcludedInstanceTypes')
        if m.get('GpuSpecs') is not None:
            self.gpu_specs = m.get('GpuSpecs')
        if m.get('InstanceCategories') is not None:
            self.instance_categories = m.get('InstanceCategories')
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceTypeFamilies') is not None:
            self.instance_type_families = m.get('InstanceTypeFamilies')
        if m.get('MaxPrice') is not None:
            self.max_price = m.get('MaxPrice')
        if m.get('MaximumCpuCoreCount') is not None:
            self.maximum_cpu_core_count = m.get('MaximumCpuCoreCount')
        if m.get('MaximumGpuAmount') is not None:
            self.maximum_gpu_amount = m.get('MaximumGpuAmount')
        if m.get('MaximumMemorySize') is not None:
            self.maximum_memory_size = m.get('MaximumMemorySize')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MinimumBaselineCredit') is not None:
            self.minimum_baseline_credit = m.get('MinimumBaselineCredit')
        if m.get('MinimumCpuCoreCount') is not None:
            self.minimum_cpu_core_count = m.get('MinimumCpuCoreCount')
        if m.get('MinimumEniIpv6AddressQuantity') is not None:
            self.minimum_eni_ipv_6address_quantity = m.get('MinimumEniIpv6AddressQuantity')
        if m.get('MinimumEniPrivateIpAddressQuantity') is not None:
            self.minimum_eni_private_ip_address_quantity = m.get('MinimumEniPrivateIpAddressQuantity')
        if m.get('MinimumEniQuantity') is not None:
            self.minimum_eni_quantity = m.get('MinimumEniQuantity')
        if m.get('MinimumGpuAmount') is not None:
            self.minimum_gpu_amount = m.get('MinimumGpuAmount')
        if m.get('MinimumInitialCredit') is not None:
            self.minimum_initial_credit = m.get('MinimumInitialCredit')
        if m.get('MinimumMemorySize') is not None:
            self.minimum_memory_size = m.get('MinimumMemorySize')
        if m.get('PhysicalProcessorModels') is not None:
            self.physical_processor_models = m.get('PhysicalProcessorModels')
        return self


class CreateScalingConfigurationRequestInstanceTypeOverrides(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        weighted_capacity: int = None,
    ):
        # Instance type N that you want to use to override the instance type that is specified in the launch template.
        # 
        # If you want to trigger scale-outs based on the weighted capacities of instances, specify InstanceType and WeightedCapacity at the same time. You can specify N instance types by using the Extended Configurations feature. Valid values of N: 1 to 10.
        # 
        # > This parameter takes effect only if you specify LaunchTemplateId.
        # 
        # You can specify an instance type that is available for purchase as the value of InstanceType.
        self.instance_type = instance_type
        # The weight of instance type N. If you want to trigger scale-outs based on the weighted capacities of instances, you must specify WeightedCapacity after you specify InstanceType.
        # 
        # The weight of an instance type specifies the capacity of an instance of the instance type in the scaling group. A higher weight specifies that a smaller number of instances of the specified instance type is required to meet the expected capacity requirement.
        # 
        # Performance metrics, such as the number of vCPUs and the memory size of each instance type, may vary. You can specify different weights for different instance types based on your business requirements.
        # 
        # Example:
        # 
        # *   Current capacity: 0
        # *   Expected capacity: 6
        # *   Capacity of ecs.c5.xlarge: 4
        # 
        # To meet the expected capacity requirement, Auto Scaling must create and add two ecs.c5.xlarge instances.
        # 
        # > The capacity of the scaling group cannot exceed the sum of the maximum number of instances that is specified by MaxSize and the maximum weight of the instance types.
        # 
        # Valid values of WeightedCapacity: 1 to 500.
        self.weighted_capacity = weighted_capacity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.weighted_capacity is not None:
            result['WeightedCapacity'] = self.weighted_capacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('WeightedCapacity') is not None:
            self.weighted_capacity = m.get('WeightedCapacity')
        return self


class CreateScalingConfigurationRequestNetworkInterfaces(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        ipv_6address_count: int = None,
        network_interface_traffic_mode: str = None,
        security_group_ids: List[str] = None,
    ):
        self.instance_type = instance_type
        self.ipv_6address_count = ipv_6address_count
        self.network_interface_traffic_mode = network_interface_traffic_mode
        self.security_group_ids = security_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.network_interface_traffic_mode is not None:
            result['NetworkInterfaceTrafficMode'] = self.network_interface_traffic_mode
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('NetworkInterfaceTrafficMode') is not None:
            self.network_interface_traffic_mode = m.get('NetworkInterfaceTrafficMode')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        return self


class CreateScalingConfigurationRequestResourcePoolOptions(TeaModel):
    def __init__(
        self,
        private_pool_ids: List[str] = None,
        strategy: str = None,
    ):
        # The IDs of private pools. The ID of a private pool is the same as the ID of the elasticity assurance or capacity reservation that is associated with the private pool. You can specify the IDs of only targeted private pools for this parameter.
        self.private_pool_ids = private_pool_ids
        # The resource pool used for instance creation, which can be the public pool or a private pool associated with any active elasticity assurance or capacity reservation. Valid values:
        # 
        # *   PrivatePoolFirst: prioritizes private pools. When this option is set along with ResourcePoolOptions.PrivatePoolIds, the specified private pools are used first. If you leave ResourcePoolOptions.PrivatePoolIds empty or if the specified private pools lack sufficient capacity, the system will automatically use available open private pools instead. If no matching private pools are available, the system defaults to the public pool.
        # *   PrivatePoolOnly: uses only private pools. If you set this value, you must specify ResourcePoolOptions.PrivatePoolIds. If the specified private pools lack sufficient capacity, instance creation will fail.
        # *   None: uses no resource pools.
        # 
        # Default value: None.
        self.strategy = strategy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_ids is not None:
            result['PrivatePoolIds'] = self.private_pool_ids
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivatePoolIds') is not None:
            self.private_pool_ids = m.get('PrivatePoolIds')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        return self


class CreateScalingConfigurationRequestSecurityOptions(TeaModel):
    def __init__(
        self,
        confidential_computing_mode: str = None,
    ):
        # The confidential computing mode. Valid values:
        # 
        # *   Enclave: An enclave-based confidential computing environment is built on the instance. For more information, see [Build a confidential computing environment by using Enclave](https://help.aliyun.com/document_detail/203433.html).
        # *   TDX: A Trust Domain Extensions (TDX) confidential computing environment is built on the instance. For more information, see [Build a TDX confidential computing environment](https://help.aliyun.com/document_detail/479090.html).
        self.confidential_computing_mode = confidential_computing_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.confidential_computing_mode is not None:
            result['ConfidentialComputingMode'] = self.confidential_computing_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfidentialComputingMode') is not None:
            self.confidential_computing_mode = m.get('ConfidentialComputingMode')
        return self


class CreateScalingConfigurationRequestSpotPriceLimits(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        price_limit: float = None,
    ):
        # The instance type of the preemptible instance. This parameter takes effect only if you set SpotStrategy to SpotWithPriceLimit.
        self.instance_type = instance_type
        # The price limit of the preemptible instance. This parameter takes effect only if you set SpotStrategy to SpotWithPriceLimit.
        self.price_limit = price_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.price_limit is not None:
            result['PriceLimit'] = self.price_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('PriceLimit') is not None:
            self.price_limit = m.get('PriceLimit')
        return self


class CreateScalingConfigurationRequest(TeaModel):
    def __init__(
        self,
        image_options: CreateScalingConfigurationRequestImageOptions = None,
        private_pool_options: CreateScalingConfigurationRequestPrivatePoolOptions = None,
        system_disk: CreateScalingConfigurationRequestSystemDisk = None,
        affinity: str = None,
        client_token: str = None,
        cpu: int = None,
        credit_specification: str = None,
        custom_priorities: List[CreateScalingConfigurationRequestCustomPriorities] = None,
        data_disks: List[CreateScalingConfigurationRequestDataDisks] = None,
        dedicated_host_cluster_id: str = None,
        dedicated_host_id: str = None,
        deletion_protection: bool = None,
        deployment_set_id: str = None,
        host_name: str = None,
        hpc_cluster_id: str = None,
        http_endpoint: str = None,
        http_tokens: str = None,
        image_family: str = None,
        image_id: str = None,
        image_name: str = None,
        instance_description: str = None,
        instance_name: str = None,
        instance_pattern_infos: List[CreateScalingConfigurationRequestInstancePatternInfos] = None,
        instance_type: str = None,
        instance_type_overrides: List[CreateScalingConfigurationRequestInstanceTypeOverrides] = None,
        instance_types: List[str] = None,
        internet_charge_type: str = None,
        internet_max_bandwidth_in: int = None,
        internet_max_bandwidth_out: int = None,
        io_optimized: str = None,
        ipv_6address_count: int = None,
        key_pair_name: str = None,
        load_balancer_weight: int = None,
        memory: int = None,
        network_interfaces: List[CreateScalingConfigurationRequestNetworkInterfaces] = None,
        owner_account: str = None,
        owner_id: int = None,
        password: str = None,
        password_inherit: bool = None,
        ram_role_name: str = None,
        resource_group_id: str = None,
        resource_owner_account: str = None,
        resource_pool_options: CreateScalingConfigurationRequestResourcePoolOptions = None,
        scaling_configuration_name: str = None,
        scaling_group_id: str = None,
        scheduler_options: Dict[str, Any] = None,
        security_enhancement_strategy: str = None,
        security_group_id: str = None,
        security_group_ids: List[str] = None,
        security_options: CreateScalingConfigurationRequestSecurityOptions = None,
        spot_duration: int = None,
        spot_interruption_behavior: str = None,
        spot_price_limits: List[CreateScalingConfigurationRequestSpotPriceLimits] = None,
        spot_strategy: str = None,
        storage_set_id: str = None,
        storage_set_partition_number: int = None,
        system_disk_categories: List[str] = None,
        tags: str = None,
        tenancy: str = None,
        user_data: str = None,
        zone_id: str = None,
    ):
        self.image_options = image_options
        self.private_pool_options = private_pool_options
        self.system_disk = system_disk
        # Specifies whether to associate an ECS instance on a dedicated host with the dedicated host. Valid values:
        # 
        # *   default: does not associate the ECS instance with the dedicated host. If you start an ECS instance that was stopped in economical mode and the original dedicated host has insufficient resources, the ECS instance is automatically deployed to another dedicated host in the automatic deployment resource pool.
        # *   host: associates the ECS instance with the dedicated host. If you start an ECS instance that was stopped in economical mode, the instance remains on the original dedicated host. If the original dedicated host has insufficient resources, the ECS instance fails to start.
        # 
        # Default value: default
        self.affinity = affinity
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see the "[How to ensure the idempotence of a request](https://help.aliyun.com/document_detail/25693.html)" topic.
        self.client_token = client_token
        # The number of vCPUs.
        # 
        # You can specify the number of vCPUs and the memory size to determine the range of instance types. For example, you can set CPU to 2 and Memory to 16 to specify instance types that have 2 vCPUs and 16 GiB of memory. If you specify Cpu and Memory, Auto Scaling determines the available instance types based on factors such as I/O optimization requirements and zones. Then, Auto Scaling preferentially creates instances by using the lowest-priced instance type.
        # 
        # > You can specify Cpu and Memory to determine the range of instance types only if you set Scaling Policy to Cost Optimization Policy and you do not specify instance types in the scaling configuration.
        self.cpu = cpu
        # The performance mode of the burstable instance. Valid values:
        # 
        # *   Standard: standard mode
        # *   Unlimited: unlimited mode
        # 
        # For more information, see the "Performance modes" section in the "[Overview](https://help.aliyun.com/document_detail/59977.html)" topic.
        self.credit_specification = credit_specification
        # The priority of the custom ECS instance type + vSwitch combination.
        # 
        # >  This parameter takes effect only when Scaling Policy of the scaling group is set to Priority Policy.
        # 
        # If Auto Scaling cannot create ECS instances by using the custom ECS instance type + vSwitch combination of the highest priority, Auto Scaling creates ECS instances by using the custom ECS instance type + vSwitch combination of the next highest priority.
        # 
        # >  If you specify the priorities of only partial custom ECS instance type + vSwitch combinations, Auto Scaling preferentially creates ECS instances by using the custom combinations that have specified priorities. If the custom combinations that have specified priorities do not provide sufficient resources, Auto Scaling creates ECS instances by using the custom combinations that do not have specified priorities based on the specified orders of vSwitches and instance types.
        # 
        # *   Example: the specified order of vSwitches for your scaling group is vsw1 and vsw2 and the specified order of instance types in your scaling configuration is type1 and type 2. In addition, you use CustomPriorities to specify ["vsw2+type2", "vsw1+type2"]. In this example, the vsw2+type2 combination has the highest priority and the vsw2+type1 combination has the lowest priority. The vsw1+type2 combination has a higher priority than the vsw1+type1 combination.
        self.custom_priorities = custom_priorities
        # The data disks.
        self.data_disks = data_disks
        # The ID of the dedicated host cluster.
        self.dedicated_host_cluster_id = dedicated_host_cluster_id
        # The ID of the dedicated host on which you want to create an ECS instance. You cannot create preemptible instances on dedicated hosts. If you specify DedicatedHostId, SpotStrategy and SpotPriceLimit are ignored.
        # 
        # You can call the DescribeDedicatedHosts operation to query dedicated host IDs.
        self.dedicated_host_id = dedicated_host_id
        self.deletion_protection = deletion_protection
        # The ID of the deployment set of the ECS instances that are created by using the scaling configuration.
        self.deployment_set_id = deployment_set_id
        # The hostname of the ECS instance. The hostname cannot start or end with a period (.) or a hyphen (-). The hostname cannot contain consecutive periods (.) or hyphens (-). Naming conventions for different types of instances:
        # 
        # *   Windows instances: The hostname must be 2 to 15 characters in length and can contain letters, digits, and hyphens (-). The hostname cannot contain periods (.) or contain only digits.
        # *   Other instances, such as Linux instances: The hostname must be 2 to 64 characters in length. You can use periods (.) to separate a hostname into multiple segments. Each segment can contain letters, digits, and hyphens (-).
        self.host_name = host_name
        # The ID of the Elastic High Performance Computing (E-HPC) cluster to which the ECS instances that are created by using the scaling configuration belong.
        self.hpc_cluster_id = hpc_cluster_id
        # Specifies whether to enable the access channel for instance metadata. Valid values:
        # 
        # *   enabled
        # *   disabled
        # 
        # Default value: enabled.
        # 
        # >  For information about instance metadata, see [Obtain instance metadata](https://help.aliyun.com/document_detail/108460.html).
        self.http_endpoint = http_endpoint
        # Specifies whether to forcibly use the security hardening mode (IMDSv2) to access instance metadata. Valid values:
        # 
        # *   optional: does not forcibly use the security hardening mode (IMDSv2).
        # *   required: forcibly uses the security hardening mode (IMDSv2). If you set this parameter to required, you cannot access instance metadata in normal mode.
        # 
        # Default value: optional.
        # 
        # >  For more information about instance metadata access modes, see [Access modes of instance metadata](https://help.aliyun.com/document_detail/108460.html).
        self.http_tokens = http_tokens
        # The name of the image family. If you specify this parameter, the most recent custom images that are available in the specified image family are returned. You can use the images to create instances. If you specify ImageId, you cannot specify ImageFamily.
        self.image_family = image_family
        # The ID of the image that Auto Scaling uses to automatically create ECS instances.
        self.image_id = image_id
        # The name of the image. Each image name must be unique in a region. If you specify ImageId, ImageName is ignored.
        # 
        # You cannot use ImageName to specify images that are purchased from Alibaba Cloud Marketplace.
        self.image_name = image_name
        # The description of the ECS instance. The description must be 2 to 256 characters in length. The description can contain letters and cannot start with `http://` or `https://`.
        self.instance_description = instance_description
        # The name of the ECS instance that Auto Scaling creates based on the scaling configuration.
        self.instance_name = instance_name
        # The intelligent configuration settings, which determine the available instance types.
        self.instance_pattern_infos = instance_pattern_infos
        # The instance type of the ECS instance. For more information, see the [Instance families](https://help.aliyun.com/document_detail/25378.html) topic.
        self.instance_type = instance_type
        # The instance types.
        self.instance_type_overrides = instance_type_overrides
        # The instance types. If you specify InstanceTypes, InstanceType is ignored.
        # 
        # Auto Scaling creates instances based on a priority list of instance types. If it fails to create instances using the highest-priority type, it automatically moves to the next type in the priority order.
        self.instance_types = instance_types
        # The metering method for network usage. Valid values:
        # 
        # *   PayByBandwidth: You are charged for the maximum available bandwidth that is specified by InternetMaxBandwidthOut.
        # *   PayByTraffic: You are charged based on the amount of transferred data. InternetMaxBandwidthOut specifies only the maximum available bandwidth.
        # 
        # For the classic network, the default value is PayByBandwidth. For VPCs, the default value is PayByTraffic.
        self.internet_charge_type = internet_charge_type
        # The maximum inbound public bandwidth. Unit: Mbit/s. Valid values:
        # 
        # *   If the purchased outbound public bandwidth is less than or equal to 10 Mbit/s, the valid values of this parameter are 1 to 10, and the default value is 10.
        # *   If the purchased outbound public bandwidth is greater than 10 Mbit/s, the valid values of this parameter are 1 to the value of `InternetMaxBandwidthOut`, and the default value is the value of `InternetMaxBandwidthOut`.
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        # The maximum outbound public bandwidth. Unit: Mbit/s. Valid values: 0 to 100.
        # 
        # Default value: 0.
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        # Specifies whether to create an I/O optimized instance. Valid values:
        # 
        # none: does not create an I/O optimized instance. optimized: creates an I/O optimized instance.
        # 
        # For instances of retired instance types, the default value is none. For instances of other instance types, the default value is optimized.
        self.io_optimized = io_optimized
        # The number of randomly generated IPv6 addresses that you want to allocate to the elastic network interface (ENI).
        self.ipv_6address_count = ipv_6address_count
        # The name of the key pair that you want to use to log on to an ECS instance.
        # 
        # *   Windows instances do not support this parameter.
        # *   By default, the username and password authentication method is disabled for Linux instances.
        self.key_pair_name = key_pair_name
        # The weight of an ECS instance as a backend server. Valid values: 1 to 100.
        # 
        # Default value: 50
        self.load_balancer_weight = load_balancer_weight
        # The memory size. Unit: GiB.
        # 
        # You can specify the number of vCPUs and the memory size to determine the range of instance types. For example, you can set Cpu to 2 and Memory to 16 to specify instance types that have 2 vCPUs and 16 GiB of memory. If you specify Cpu and Memory, Auto Scaling determines the available instance types based on factors such as I/O optimization requirements and zones. Then, Auto Scaling preferentially creates instances by using the lowest-priced instance type.
        # 
        # > You can specify Cpu and Memory to determine the range of instance types only if you set Scaling Policy to Cost Optimization Policy and you do not specify instance types in the scaling configuration.
        self.memory = memory
        self.network_interfaces = network_interfaces
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The password that you want to use to log on to an ECS instance. The password must be 8 to 30 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. The following special characters are supported:
        # 
        # `` `() ~!@#$%^&*-_+=\\|{}[]:;\\"<>,.?/ ``
        # 
        # The password of a Windows instance cannot start with a forward slash (/).
        # 
        # > For security reasons, we recommend that you use HTTPS to send requests if you specify Password.
        self.password = password
        # Specifies whether to use the password that is preconfigured in the image. Before you use this parameter, make sure that a password is configured in the image. Valid values:
        # 
        # *   true
        # *   false
        self.password_inherit = password_inherit
        # The name of the RAM role that you attach to the ECS instance. The name is provided and maintained by Resource Access Management (RAM). You can call the ListRoles operation to query the available RAM roles.
        self.ram_role_name = ram_role_name
        # The ID of the resource group to which the ECS instances that are created by using the scaling configuration belong.
        self.resource_group_id = resource_group_id
        self.resource_owner_account = resource_owner_account
        # The resource pools used for instance creation, which can be the public pool or a private pool associated with any active elasticity assurance or capacity reservation. When you specify this parameter, take note of the following items:
        # 
        # *   This parameter takes effect only when you create pay-as-you-go instances.
        # *   If you specify this parameter, you cannot specify PrivatePoolOptions.MatchCriteria or PrivatePoolOptions.Id.
        self.resource_pool_options = resource_pool_options
        # The name of the scaling configuration. The name must be 2 to 64 characters in length and can contain letters, digits, underscores (_), hyphens (-), and periods (.). The name must start with a letter or a digit.
        # 
        # The name of the scaling configuration must be unique in a region. If you do not specify this parameter, the scaling configuration ID is used.
        self.scaling_configuration_name = scaling_configuration_name
        # The ID of the scaling group in which you want to create a scaling configuration.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id
        # The scheduler options.
        self.scheduler_options = scheduler_options
        # Specifies whether to enable security hardening. Valid values:
        # 
        # *   Active: enables security hardening. This value is applicable only to public images.
        # *   Deactive: disables security hardening. This value is applicable to all image types.
        self.security_enhancement_strategy = security_enhancement_strategy
        # The ID of the security group with which ECS instances are associated. ECS instances that are associated with the same security group can access each other.
        self.security_group_id = security_group_id
        # The IDs of the security groups with which you want to associate the ECS instances that are created by using the scaling configuration. For more information, see the "Security group limits" section of the "[Limits](https://help.aliyun.com/document_detail/25412.html)" topic.
        # 
        # > If you specify SecurityGroupId, you cannot specify SecurityGroupIds.
        self.security_group_ids = security_group_ids
        self.security_options = security_options
        # The retention period of the preemptible instance. Unit: hours. Valid values: 0, 1, 2, 3, 4, 5, and 6.
        # 
        # *   The following retention periods are available in invitational preview: 2, 3, 4, 5, and 6 hours. If you want to set this parameter to one of these values, submit a ticket.
        # *   If you set this parameter to 0, no protection period is specified for the preemptible instance.
        # 
        # Default value: 1
        self.spot_duration = spot_duration
        # The interruption mode of the preemptible instance. Set the value to Terminate. The value specifies that the preemptible instance is to be released.
        self.spot_interruption_behavior = spot_interruption_behavior
        # The billing information of the preemptible instances.
        self.spot_price_limits = spot_price_limits
        # The preemption policy that you want to apply to pay-as-you-go and preemptible instances. Valid values:
        # 
        # *   NoSpot: The instance is created as a pay-as-you-go instance.
        # *   SpotWithPriceLimit: The instance is a preemptible instance that has a user-defined maximum hourly price.
        # *   SpotAsPriceGo: The instance is created as a preemptible instance for which the market price at the time of purchase is automatically used as the bid price.
        # 
        # Default value: NoSpot
        self.spot_strategy = spot_strategy
        self.storage_set_id = storage_set_id
        self.storage_set_partition_number = storage_set_partition_number
        # The categories of the system disks. If Auto Scaling cannot create instances by using the disk category that has the highest priority, Auto Scaling creates instances by using the disk category that has the next highest priority. Valid values:
        # 
        # *   cloud: basic disk
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   cloud_essd: ESSD
        # 
        # > If you specify SystemDiskCategories, you cannot specify `SystemDisk.Category`.
        self.system_disk_categories = system_disk_categories
        # The tags of the ECS instance. Tags must be specified as key-value pairs. You can specify up to 20 tags. When you specify tag keys and tag values, take note of the following items:
        # 
        # *   A tag key can be up to 64 characters in length. The key cannot start with acs: or aliyun and cannot contain `http://` or `https://`. You cannot specify an empty string as a tag key.
        # *   A tag value can be up to 128 characters in length. The value cannot start with acs: or aliyun and cannot contain `http://` or `https://`. You can specify an empty string as a tag value.
        self.tags = tags
        # Specifies whether to create an ECS instance on a dedicated host. Valid values:
        # 
        # *   default: does not create an ECS instance on a dedicated host.
        # *   host: creates an ECS instance on a dedicated host. If you do not specify DedicatedHostId, Alibaba Cloud selects a dedicated host for the ECS instance.
        # 
        # Default value: default
        self.tenancy = tenancy
        # The user data of the Elastic Compute Service (ECS) instance. The user data must be encoded in Base64 format. The size of raw data before Base64 encoding cannot exceed 32 KB.
        self.user_data = user_data
        # The zone ID of the ECS instance.
        self.zone_id = zone_id

    def validate(self):
        if self.image_options:
            self.image_options.validate()
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.system_disk:
            self.system_disk.validate()
        if self.custom_priorities:
            for k in self.custom_priorities:
                if k:
                    k.validate()
        if self.data_disks:
            for k in self.data_disks:
                if k:
                    k.validate()
        if self.instance_pattern_infos:
            for k in self.instance_pattern_infos:
                if k:
                    k.validate()
        if self.instance_type_overrides:
            for k in self.instance_type_overrides:
                if k:
                    k.validate()
        if self.network_interfaces:
            for k in self.network_interfaces:
                if k:
                    k.validate()
        if self.resource_pool_options:
            self.resource_pool_options.validate()
        if self.security_options:
            self.security_options.validate()
        if self.spot_price_limits:
            for k in self.spot_price_limits:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_options is not None:
            result['ImageOptions'] = self.image_options.to_map()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.affinity is not None:
            result['Affinity'] = self.affinity
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        result['CustomPriorities'] = []
        if self.custom_priorities is not None:
            for k in self.custom_priorities:
                result['CustomPriorities'].append(k.to_map() if k else None)
        result['DataDisks'] = []
        if self.data_disks is not None:
            for k in self.data_disks:
                result['DataDisks'].append(k.to_map() if k else None)
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.http_endpoint is not None:
            result['HttpEndpoint'] = self.http_endpoint
        if self.http_tokens is not None:
            result['HttpTokens'] = self.http_tokens
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        result['InstancePatternInfos'] = []
        if self.instance_pattern_infos is not None:
            for k in self.instance_pattern_infos:
                result['InstancePatternInfos'].append(k.to_map() if k else None)
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        result['InstanceTypeOverrides'] = []
        if self.instance_type_overrides is not None:
            for k in self.instance_type_overrides:
                result['InstanceTypeOverrides'].append(k.to_map() if k else None)
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.load_balancer_weight is not None:
            result['LoadBalancerWeight'] = self.load_balancer_weight
        if self.memory is not None:
            result['Memory'] = self.memory
        result['NetworkInterfaces'] = []
        if self.network_interfaces is not None:
            for k in self.network_interfaces:
                result['NetworkInterfaces'].append(k.to_map() if k else None)
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_pool_options is not None:
            result['ResourcePoolOptions'] = self.resource_pool_options.to_map()
        if self.scaling_configuration_name is not None:
            result['ScalingConfigurationName'] = self.scaling_configuration_name
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.scheduler_options is not None:
            result['SchedulerOptions'] = self.scheduler_options
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.security_options is not None:
            result['SecurityOptions'] = self.security_options.to_map()
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_interruption_behavior is not None:
            result['SpotInterruptionBehavior'] = self.spot_interruption_behavior
        result['SpotPriceLimits'] = []
        if self.spot_price_limits is not None:
            for k in self.spot_price_limits:
                result['SpotPriceLimits'].append(k.to_map() if k else None)
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.system_disk_categories is not None:
            result['SystemDiskCategories'] = self.system_disk_categories
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.tenancy is not None:
            result['Tenancy'] = self.tenancy
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageOptions') is not None:
            temp_model = CreateScalingConfigurationRequestImageOptions()
            self.image_options = temp_model.from_map(m['ImageOptions'])
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateScalingConfigurationRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('SystemDisk') is not None:
            temp_model = CreateScalingConfigurationRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('Affinity') is not None:
            self.affinity = m.get('Affinity')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CreditSpecification') is not None:
            self.credit_specification = m.get('CreditSpecification')
        self.custom_priorities = []
        if m.get('CustomPriorities') is not None:
            for k in m.get('CustomPriorities'):
                temp_model = CreateScalingConfigurationRequestCustomPriorities()
                self.custom_priorities.append(temp_model.from_map(k))
        self.data_disks = []
        if m.get('DataDisks') is not None:
            for k in m.get('DataDisks'):
                temp_model = CreateScalingConfigurationRequestDataDisks()
                self.data_disks.append(temp_model.from_map(k))
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        if m.get('HttpEndpoint') is not None:
            self.http_endpoint = m.get('HttpEndpoint')
        if m.get('HttpTokens') is not None:
            self.http_tokens = m.get('HttpTokens')
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        self.instance_pattern_infos = []
        if m.get('InstancePatternInfos') is not None:
            for k in m.get('InstancePatternInfos'):
                temp_model = CreateScalingConfigurationRequestInstancePatternInfos()
                self.instance_pattern_infos.append(temp_model.from_map(k))
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        self.instance_type_overrides = []
        if m.get('InstanceTypeOverrides') is not None:
            for k in m.get('InstanceTypeOverrides'):
                temp_model = CreateScalingConfigurationRequestInstanceTypeOverrides()
                self.instance_type_overrides.append(temp_model.from_map(k))
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LoadBalancerWeight') is not None:
            self.load_balancer_weight = m.get('LoadBalancerWeight')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        self.network_interfaces = []
        if m.get('NetworkInterfaces') is not None:
            for k in m.get('NetworkInterfaces'):
                temp_model = CreateScalingConfigurationRequestNetworkInterfaces()
                self.network_interfaces.append(temp_model.from_map(k))
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourcePoolOptions') is not None:
            temp_model = CreateScalingConfigurationRequestResourcePoolOptions()
            self.resource_pool_options = temp_model.from_map(m['ResourcePoolOptions'])
        if m.get('ScalingConfigurationName') is not None:
            self.scaling_configuration_name = m.get('ScalingConfigurationName')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('SchedulerOptions') is not None:
            self.scheduler_options = m.get('SchedulerOptions')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('SecurityOptions') is not None:
            temp_model = CreateScalingConfigurationRequestSecurityOptions()
            self.security_options = temp_model.from_map(m['SecurityOptions'])
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('SpotInterruptionBehavior') is not None:
            self.spot_interruption_behavior = m.get('SpotInterruptionBehavior')
        self.spot_price_limits = []
        if m.get('SpotPriceLimits') is not None:
            for k in m.get('SpotPriceLimits'):
                temp_model = CreateScalingConfigurationRequestSpotPriceLimits()
                self.spot_price_limits.append(temp_model.from_map(k))
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        if m.get('SystemDiskCategories') is not None:
            self.system_disk_categories = m.get('SystemDiskCategories')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Tenancy') is not None:
            self.tenancy = m.get('Tenancy')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateScalingConfigurationShrinkRequestImageOptions(TeaModel):
    def __init__(
        self,
        login_as_non_root: bool = None,
    ):
        # For more information about whether an ECS instance uses the ecs-user user user to log on to an ECS instance, see [Manage the login name of an ECS instance](https://help.aliyun.com/document_detail/388447.html). Value range:
        # 
        # - true: Yes.
        # - false: No.
        # 
        # Default value: false.
        self.login_as_non_root = login_as_non_root

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.login_as_non_root is not None:
            result['LoginAsNonRoot'] = self.login_as_non_root
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LoginAsNonRoot') is not None:
            self.login_as_non_root = m.get('LoginAsNonRoot')
        return self


class CreateScalingConfigurationShrinkRequestPrivatePoolOptions(TeaModel):
    def __init__(
        self,
        id: str = None,
        match_criteria: str = None,
    ):
        # The ID of the private pool. The ID of a private pool is the same as the ID of the elasticity assurance or capacity reservation for which the private pool is generated.
        self.id = id
        # The type of the private pool that you want to use to start ECS instances. A private pool is generated when an elasticity assurance or a capacity reservation takes effect. You can select a private pool to create ECS instances. Valid values:
        # 
        # *   Open: open private pool. Auto Scaling selects a matching open private pool to start instances. If no matching open private pools are found, Auto Scaling uses the resources in the public pool to start instances. In this case, you do not need to specify PrivatePoolOptions.Id.
        # *   Target: specified private pool. Auto Scaling uses the resources in the specified private pool to start ECS instances. If the specified private pool is unavailable, Auto Scaling cannot start ECS instances. If you set this parameter to Target, you must specify PrivatePoolOptions.Id.
        # *   None: no private pool. Auto Scaling does not use the resources in private pools to start ECS instances.
        self.match_criteria = match_criteria

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        return self


class CreateScalingConfigurationShrinkRequestSystemDisk(TeaModel):
    def __init__(
        self,
        auto_snapshot_policy_id: str = None,
        bursting_enabled: bool = None,
        category: str = None,
        description: str = None,
        disk_name: str = None,
        encrypt_algorithm: str = None,
        encrypted: bool = None,
        kmskey_id: str = None,
        performance_level: str = None,
        provisioned_iops: int = None,
        size: int = None,
    ):
        # The ID of the automatic snapshot policy that you want to apply to the system disk.
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        # Specifies whether to enable the burst feature for the system disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # > This parameter is available only if you set `SystemDisk.Category` to `cloud_auto`.
        self.bursting_enabled = bursting_enabled
        # The category of the system disk. Valid values:
        # 
        # *   cloud: basic disk
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   ephemeral_ssd: local SSD
        # *   cloud_essd: enhanced SSD (ESSD)
        # *   cloud_auto: ESSD AutoPL disk
        # 
        # If you specify SystemDisk.Category, you cannot specify `SystemDiskCategories`. If you do not specify SystemDisk.Category or `SystemDiskCategories`, the default value of SystemDisk.Category is used.
        # 
        # *   For I/O optimized instances, the default value is cloud_efficiency.
        # *   For non-I/O optimized instances, the default value is cloud.
        self.category = category
        # The description of the system disk. The description must be 2 to 256 characters in length. The description can contain letters and cannot start with `http://` or `https://`.
        self.description = description
        # The name of the system disk. The name must be 2 to 128 characters in length. The name can contain letters, digits, colons (:), underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.disk_name = disk_name
        # The encryption algorithm that you want to use to encrypt the system disk. Valid values:
        # 
        # *   AES-256
        # *   SM4-128
        # 
        # Default value: AES-256
        self.encrypt_algorithm = encrypt_algorithm
        # Specifies whether to encrypt the system disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false
        self.encrypted = encrypted
        # The ID of the KMS key that you want to use to encrypt the system disk.
        self.kmskey_id = kmskey_id
        # The performance level (PL) of the system disk that is an enhanced SSD (ESSD). Valid values:
        # 
        # *   PL0: An ESSD can provide up to 10,000 random read/write IOPS.
        # *   PL1: An ESSD can provide up to 50,000 random read/write IOPS.
        # *   PL2: An ESSD can provide up to 100,000 random read/write IOPS.
        # *   PL3: An ESSD can provide up to 1,000,000 random read/write IOPS.
        # 
        # Default value: PL1.
        self.performance_level = performance_level
        # The IOPS metric that is preconfigured for the system disk.
        # 
        # > IOPS measures the number of read and write operations that an EBS device can process per second.
        self.provisioned_iops = provisioned_iops
        # The size of the system disk. Unit: GiB.
        # 
        # *   Basic disk: 20 to 500.
        # 
        # *   ESSD (cloud_essd): The valid values vary based on the performance level of the ESSD.
        # 
        #     *   PL0 ESSD: 1 to 2048.
        #     *   PL1 ESSD: 20 to 2048.
        #     *   PL2 ESSD: 461 to 2048.
        #     *   PL3 ESSD: 1261 to 2048.
        # 
        # *   ESSD AutoPL disk (cloud_auto): 1 to 2048.
        # 
        # *   Other disk categories: 20 to 2048.
        # 
        # The value of this parameter must be at least 1 and greater than or equal to the image size.
        # 
        # Default value: 40 or the size of the image, whichever is larger.
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class CreateScalingConfigurationShrinkRequestCustomPriorities(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        vswitch_id: str = None,
    ):
        # The ECS instance type.
        # 
        # >  The ECS instance type must be included in the instance types specified in the scaling configuration.
        self.instance_type = instance_type
        # The vSwitch ID.
        # 
        # >  The vSwitch must be included in the vSwitch list of the scaling group.
        self.vswitch_id = vswitch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class CreateScalingConfigurationShrinkRequestDataDisks(TeaModel):
    def __init__(
        self,
        auto_snapshot_policy_id: str = None,
        bursting_enabled: bool = None,
        categories: List[str] = None,
        category: str = None,
        delete_with_instance: bool = None,
        description: str = None,
        device: str = None,
        disk_name: str = None,
        encrypted: str = None,
        kmskey_id: str = None,
        performance_level: str = None,
        provisioned_iops: int = None,
        size: int = None,
        snapshot_id: str = None,
    ):
        # The ID of the automatic snapshot policy that you want to apply to the data disk.
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        # Specifies whether to enable the burst feature for the system disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # > This parameter is available only if you set `SystemDisk.Category` to `cloud_auto`.
        self.bursting_enabled = bursting_enabled
        # The categories of the data disks. If Auto Scaling cannot create instances by using the disk category that has the highest priority, Auto Scaling creates instances by using the disk category that has the next highest priority. Valid values:
        # 
        # *   cloud: basic disk. For a basic disk that is created together with the instance, DeleteWithInstance is set to true.
        # *   cloud_efficiency: ultra disk.
        # *   cloud_ssd: standard SSD.
        # *   cloud_essd: ESSD.
        # 
        # > If you specify Categories, you cannot specify `DataDisks.Category`.
        self.categories = categories
        # The category of the data disk. Valid values:
        # 
        # *   cloud: basic disk
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   cloud_essd: ESSD
        # *   ephemeral_ssd: local SSD
        # *   cloud_auto: ESSD AutoPL disk
        # 
        # If you specify this parameter, you cannot specify Categories. If you do not specify Category or Categories, the default value of Category is used.
        # 
        # *   For I/O optimized instances, the default value is cloud_efficiency.
        # *   For non-I/O optimized instances, the default value is cloud.
        self.category = category
        # Specifies whether to release the data disk when the instance to which the data disk is attached is released. Valid values:
        # 
        # *   true
        # *   false
        # 
        # This parameter is available only for independent disks whose value of Category is set to cloud, cloud_efficiency, cloud_ssd, or cloud_essd. If you specify this parameter for other disks, an error is reported.
        # 
        # Default value: true
        self.delete_with_instance = delete_with_instance
        # The description of the data disk. The description must be 2 to 256 characters in length. The description can contain letters and cannot start with `http://` or `https://`.
        self.description = description
        # The mount target of the data disk. If you do not specify Device, a mount target is automatically assigned when Auto Scaling creates ECS instances. The names of mount targets range from /dev/xvdb to /dev/xvdz.
        self.device = device
        # The name of the system disk. The name must be 2 to 128 characters in length and can contain letters, digits, colons (:), underscores (_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.disk_name = disk_name
        # Specifies whether to encrypt the data disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false
        self.encrypted = encrypted
        # The ID of the KMS key that you want to use to encrypt the data disk.
        self.kmskey_id = kmskey_id
        # The PL of the data disk that is an ESSD. Valid values:
        # 
        # *   PL0: An ESSD can provide up to 10,000 random read/write IOPS.
        # *   PL1: An ESSD can provide up to 50,000 random read/write IOPS.
        # *   PL2: An ESSD can provide up to 100,000 random read/write IOPS.
        # *   PL3: An ESSD can provide up to 1,000,000 random read/write IOPS.
        # 
        # > For more information about how to select ESSD PLs, see [ESSD](https://help.aliyun.com/document_detail/122389.html).
        self.performance_level = performance_level
        # The IOPS metric that is preconfigured for the data disk.
        # 
        # > IOPS measures the number of read and write operations that an EBS device can process per second.
        self.provisioned_iops = provisioned_iops
        # The size of the data disk. Unit: GiB. Valid values:
        # 
        # *   If you set Categories to cloud: 5 to 2000.
        # *   If you set Categories to cloud_efficiency: 20 to 32768.
        # *   If you set Categories to cloud_essd: 20 to 32768.
        # *   If you set Categories to ephemeral_ssd: 5 to 800.
        # 
        # The size of the data disk must be greater than or equal to the size of the snapshot that is specified by SnapshotId.
        self.size = size
        # The ID of the snapshot that you want to use to create data disks. If you specify this parameter, DataDisks.Size is ignored. The size of the data disk is the same as the size of the specified snapshot.
        # 
        # If you specify a snapshot that is created on or before July 15, 2013, the operation fails and the system returns InvalidSnapshot.TooOld.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.categories is not None:
            result['Categories'] = self.categories
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Categories') is not None:
            self.categories = m.get('Categories')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CreateScalingConfigurationShrinkRequestInstancePatternInfos(TeaModel):
    def __init__(
        self,
        architectures: List[str] = None,
        burstable_performance: str = None,
        cores: int = None,
        cpu_architectures: List[str] = None,
        excluded_instance_types: List[str] = None,
        gpu_specs: List[str] = None,
        instance_categories: List[str] = None,
        instance_family_level: str = None,
        instance_type_families: List[str] = None,
        max_price: float = None,
        maximum_cpu_core_count: int = None,
        maximum_gpu_amount: int = None,
        maximum_memory_size: float = None,
        memory: float = None,
        minimum_baseline_credit: int = None,
        minimum_cpu_core_count: int = None,
        minimum_eni_ipv_6address_quantity: int = None,
        minimum_eni_private_ip_address_quantity: int = None,
        minimum_eni_quantity: int = None,
        minimum_gpu_amount: int = None,
        minimum_initial_credit: int = None,
        minimum_memory_size: float = None,
        physical_processor_models: List[str] = None,
    ):
        # The architecture types of the instance types. Valid values:
        # 
        # *   X86: x86 architecture.
        # *   Heterogeneous: heterogeneous computing, such as GPU-accelerated or FPGA-accelerated.
        # *   BareMetal: ECS Bare Metal Instance.
        # *   Arm: Arm.
        # 
        # By default, all values are selected.
        self.architectures = architectures
        # Specifies whether to include burstable instance types. Valid values:
        # 
        # *   Exclude: excludes burstable instance types.
        # *   Include: includes burstable instance types.
        # *   Required: includes only burstable instance types.
        # 
        # Default value: Include.
        self.burstable_performance = burstable_performance
        # The number of vCPUs per instance type in intelligent configuration mode. You can specify this parameter to filter the available instance types. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        # 
        # Take note of the following items:
        # 
        # *   InstancePatternInfos applies only to scaling groups that reside in virtual private clouds (VPCs).
        # *   If you specify InstancePatternInfos, you must also specify InstancePatternInfos.Cores and InstancePatternInfos.Memory.
        # *   If you specify InstanceType or InstanceTypes, Auto Scaling preferentially uses the instance type specified by InstanceType or InstanceTypes to create instances during scale-out events. If the specified instance type has insufficient inventory, Auto Scaling uses the lowest-priced instance type specified by InstancePatternInfos to create instances during scale-out events.
        self.cores = cores
        # The CPU architectures of the instance types. Valid values:
        # 
        # >  You can specify up to two CPU architectures.
        # 
        # *   x86
        # *   Arm
        self.cpu_architectures = cpu_architectures
        # The instance types that you want to exclude. You can use an asterisk (\\*) as a wildcard character to exclude an instance type or an instance family. Examples:
        # 
        # *   ecs.c6.large: excludes the ecs.c6.large instance type.
        # *   ecs.c6.\\*: excludes the c6 instance family.
        self.excluded_instance_types = excluded_instance_types
        # The GPU models.
        self.gpu_specs = gpu_specs
        # The categories of the instance types. Valid values:
        # 
        # >  You can specify up to 10 categories.
        # 
        # *   General-purpose: general-purpose instance type.
        # *   Compute-optimized: compute-optimized instance type.
        # *   Memory-optimized: memory-optimized instance type.
        # *   Big data: big data instance type.
        # *   Local SSDs: instance type that uses local SSDs.
        # *   High Clock Speed: instance type that has high clock speeds.
        # *   Enhanced: enhanced instance type.
        # *   Shared: shared instance type.
        # *   Compute-optimized with GPU: GPU-accelerated compute-optimized instance type.
        # *   Visual Compute-optimized: visual compute-optimized instance type.
        # *   Heterogeneous Service: heterogeneous service instance type.
        # *   Compute-optimized with FPGA: FPGA-accelerated compute-optimized instance type.
        # *   Compute-optimized with NPU: NPU-accelerated compute-optimized instance type.
        # *   ECS Bare Metal: ECS Bare Metal Instance type.
        # *   High Performance Compute: HPC-optimized instance type.
        self.instance_categories = instance_categories
        # The level of the instance family. You can specify this parameter to match the available instance types. This parameter takes effect only if you set `CostOptimization` to true. Valid values:
        # 
        # *   EntryLevel: entry-level (shared instance types). Instance types of this level are the most cost-effective but may not ensure stable computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low. For more information, see [Shared instance families](https://help.aliyun.com/document_detail/108489.html).
        # *   EnterpriseLevel: enterprise-level. Instance types of this level provide stable performance and dedicated resources and are suitable for business scenarios that require high stability. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        # *   CreditEntryLevel: credit entry-level (burstable instance types). CPU credits are used to ensure computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low but may fluctuate in specific cases. For more information, see [Overview](https://help.aliyun.com/document_detail/59977.html) of burstable instances.
        self.instance_family_level = instance_family_level
        # The instance families that you want to specify. You can specify up to 10 instance families in each call.
        self.instance_type_families = instance_type_families
        # The maximum hourly price of pay-as-you-go or preemptible instances in intelligent configuration mode. You can specify this parameter to filter the available instance types.
        # 
        # >  If you set SpotStrategy to SpotWithPriceLimit, you must specify this parameter. In other cases, this parameter is optional.
        self.max_price = max_price
        # The maximum number of vCPUs per instance type.
        # 
        # >  The value of MaximumCpuCoreCount cannot exceed four times the value of MinimumCpuCoreCount.
        self.maximum_cpu_core_count = maximum_cpu_core_count
        # The maximum number of GPUs per instance. The value must be a positive integer.
        self.maximum_gpu_amount = maximum_gpu_amount
        # The maximum memory size per instance. Unit: GiB.
        self.maximum_memory_size = maximum_memory_size
        # The memory size per instance type in intelligent configuration mode. Unit: GiB. You can specify this parameter to filter the available instance types.
        self.memory = memory
        # The baseline vCPU computing performance (overall baseline performance of all vCPUs) per t5 or t6 burstable instance.
        self.minimum_baseline_credit = minimum_baseline_credit
        # The minimum number of vCPUs per instance type.
        self.minimum_cpu_core_count = minimum_cpu_core_count
        # The minimum number of IPv6 addresses per ENI.
        self.minimum_eni_ipv_6address_quantity = minimum_eni_ipv_6address_quantity
        # The minimum number of IPv4 addresses per ENI.
        self.minimum_eni_private_ip_address_quantity = minimum_eni_private_ip_address_quantity
        # The minimum number of elastic network interfaces (ENIs) per instance.
        self.minimum_eni_quantity = minimum_eni_quantity
        # The minimum number of GPUs per instance. The value must be a positive integer.
        self.minimum_gpu_amount = minimum_gpu_amount
        # The initial vCPU credits per t5 or t6 burstable instance.
        self.minimum_initial_credit = minimum_initial_credit
        # The minimum memory size per instance. Unit: GiB.
        self.minimum_memory_size = minimum_memory_size
        # The processor models of the instance types. You can specify up to 10 processor models.
        self.physical_processor_models = physical_processor_models

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architectures is not None:
            result['Architectures'] = self.architectures
        if self.burstable_performance is not None:
            result['BurstablePerformance'] = self.burstable_performance
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.cpu_architectures is not None:
            result['CpuArchitectures'] = self.cpu_architectures
        if self.excluded_instance_types is not None:
            result['ExcludedInstanceTypes'] = self.excluded_instance_types
        if self.gpu_specs is not None:
            result['GpuSpecs'] = self.gpu_specs
        if self.instance_categories is not None:
            result['InstanceCategories'] = self.instance_categories
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_type_families is not None:
            result['InstanceTypeFamilies'] = self.instance_type_families
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.maximum_cpu_core_count is not None:
            result['MaximumCpuCoreCount'] = self.maximum_cpu_core_count
        if self.maximum_gpu_amount is not None:
            result['MaximumGpuAmount'] = self.maximum_gpu_amount
        if self.maximum_memory_size is not None:
            result['MaximumMemorySize'] = self.maximum_memory_size
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.minimum_baseline_credit is not None:
            result['MinimumBaselineCredit'] = self.minimum_baseline_credit
        if self.minimum_cpu_core_count is not None:
            result['MinimumCpuCoreCount'] = self.minimum_cpu_core_count
        if self.minimum_eni_ipv_6address_quantity is not None:
            result['MinimumEniIpv6AddressQuantity'] = self.minimum_eni_ipv_6address_quantity
        if self.minimum_eni_private_ip_address_quantity is not None:
            result['MinimumEniPrivateIpAddressQuantity'] = self.minimum_eni_private_ip_address_quantity
        if self.minimum_eni_quantity is not None:
            result['MinimumEniQuantity'] = self.minimum_eni_quantity
        if self.minimum_gpu_amount is not None:
            result['MinimumGpuAmount'] = self.minimum_gpu_amount
        if self.minimum_initial_credit is not None:
            result['MinimumInitialCredit'] = self.minimum_initial_credit
        if self.minimum_memory_size is not None:
            result['MinimumMemorySize'] = self.minimum_memory_size
        if self.physical_processor_models is not None:
            result['PhysicalProcessorModels'] = self.physical_processor_models
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architectures') is not None:
            self.architectures = m.get('Architectures')
        if m.get('BurstablePerformance') is not None:
            self.burstable_performance = m.get('BurstablePerformance')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('CpuArchitectures') is not None:
            self.cpu_architectures = m.get('CpuArchitectures')
        if m.get('ExcludedInstanceTypes') is not None:
            self.excluded_instance_types = m.get('ExcludedInstanceTypes')
        if m.get('GpuSpecs') is not None:
            self.gpu_specs = m.get('GpuSpecs')
        if m.get('InstanceCategories') is not None:
            self.instance_categories = m.get('InstanceCategories')
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceTypeFamilies') is not None:
            self.instance_type_families = m.get('InstanceTypeFamilies')
        if m.get('MaxPrice') is not None:
            self.max_price = m.get('MaxPrice')
        if m.get('MaximumCpuCoreCount') is not None:
            self.maximum_cpu_core_count = m.get('MaximumCpuCoreCount')
        if m.get('MaximumGpuAmount') is not None:
            self.maximum_gpu_amount = m.get('MaximumGpuAmount')
        if m.get('MaximumMemorySize') is not None:
            self.maximum_memory_size = m.get('MaximumMemorySize')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MinimumBaselineCredit') is not None:
            self.minimum_baseline_credit = m.get('MinimumBaselineCredit')
        if m.get('MinimumCpuCoreCount') is not None:
            self.minimum_cpu_core_count = m.get('MinimumCpuCoreCount')
        if m.get('MinimumEniIpv6AddressQuantity') is not None:
            self.minimum_eni_ipv_6address_quantity = m.get('MinimumEniIpv6AddressQuantity')
        if m.get('MinimumEniPrivateIpAddressQuantity') is not None:
            self.minimum_eni_private_ip_address_quantity = m.get('MinimumEniPrivateIpAddressQuantity')
        if m.get('MinimumEniQuantity') is not None:
            self.minimum_eni_quantity = m.get('MinimumEniQuantity')
        if m.get('MinimumGpuAmount') is not None:
            self.minimum_gpu_amount = m.get('MinimumGpuAmount')
        if m.get('MinimumInitialCredit') is not None:
            self.minimum_initial_credit = m.get('MinimumInitialCredit')
        if m.get('MinimumMemorySize') is not None:
            self.minimum_memory_size = m.get('MinimumMemorySize')
        if m.get('PhysicalProcessorModels') is not None:
            self.physical_processor_models = m.get('PhysicalProcessorModels')
        return self


class CreateScalingConfigurationShrinkRequestInstanceTypeOverrides(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        weighted_capacity: int = None,
    ):
        # Instance type N that you want to use to override the instance type that is specified in the launch template.
        # 
        # If you want to trigger scale-outs based on the weighted capacities of instances, specify InstanceType and WeightedCapacity at the same time. You can specify N instance types by using the Extended Configurations feature. Valid values of N: 1 to 10.
        # 
        # > This parameter takes effect only if you specify LaunchTemplateId.
        # 
        # You can specify an instance type that is available for purchase as the value of InstanceType.
        self.instance_type = instance_type
        # The weight of instance type N. If you want to trigger scale-outs based on the weighted capacities of instances, you must specify WeightedCapacity after you specify InstanceType.
        # 
        # The weight of an instance type specifies the capacity of an instance of the instance type in the scaling group. A higher weight specifies that a smaller number of instances of the specified instance type is required to meet the expected capacity requirement.
        # 
        # Performance metrics, such as the number of vCPUs and the memory size of each instance type, may vary. You can specify different weights for different instance types based on your business requirements.
        # 
        # Example:
        # 
        # *   Current capacity: 0
        # *   Expected capacity: 6
        # *   Capacity of ecs.c5.xlarge: 4
        # 
        # To meet the expected capacity requirement, Auto Scaling must create and add two ecs.c5.xlarge instances.
        # 
        # > The capacity of the scaling group cannot exceed the sum of the maximum number of instances that is specified by MaxSize and the maximum weight of the instance types.
        # 
        # Valid values of WeightedCapacity: 1 to 500.
        self.weighted_capacity = weighted_capacity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.weighted_capacity is not None:
            result['WeightedCapacity'] = self.weighted_capacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('WeightedCapacity') is not None:
            self.weighted_capacity = m.get('WeightedCapacity')
        return self


class CreateScalingConfigurationShrinkRequestNetworkInterfaces(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        ipv_6address_count: int = None,
        network_interface_traffic_mode: str = None,
        security_group_ids: List[str] = None,
    ):
        self.instance_type = instance_type
        self.ipv_6address_count = ipv_6address_count
        self.network_interface_traffic_mode = network_interface_traffic_mode
        self.security_group_ids = security_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.network_interface_traffic_mode is not None:
            result['NetworkInterfaceTrafficMode'] = self.network_interface_traffic_mode
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('NetworkInterfaceTrafficMode') is not None:
            self.network_interface_traffic_mode = m.get('NetworkInterfaceTrafficMode')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        return self


class CreateScalingConfigurationShrinkRequestResourcePoolOptions(TeaModel):
    def __init__(
        self,
        private_pool_ids: List[str] = None,
        strategy: str = None,
    ):
        # The IDs of private pools. The ID of a private pool is the same as the ID of the elasticity assurance or capacity reservation that is associated with the private pool. You can specify the IDs of only targeted private pools for this parameter.
        self.private_pool_ids = private_pool_ids
        # The resource pool used for instance creation, which can be the public pool or a private pool associated with any active elasticity assurance or capacity reservation. Valid values:
        # 
        # *   PrivatePoolFirst: prioritizes private pools. When this option is set along with ResourcePoolOptions.PrivatePoolIds, the specified private pools are used first. If you leave ResourcePoolOptions.PrivatePoolIds empty or if the specified private pools lack sufficient capacity, the system will automatically use available open private pools instead. If no matching private pools are available, the system defaults to the public pool.
        # *   PrivatePoolOnly: uses only private pools. If you set this value, you must specify ResourcePoolOptions.PrivatePoolIds. If the specified private pools lack sufficient capacity, instance creation will fail.
        # *   None: uses no resource pools.
        # 
        # Default value: None.
        self.strategy = strategy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_ids is not None:
            result['PrivatePoolIds'] = self.private_pool_ids
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivatePoolIds') is not None:
            self.private_pool_ids = m.get('PrivatePoolIds')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        return self


class CreateScalingConfigurationShrinkRequestSecurityOptions(TeaModel):
    def __init__(
        self,
        confidential_computing_mode: str = None,
    ):
        # The confidential computing mode. Valid values:
        # 
        # *   Enclave: An enclave-based confidential computing environment is built on the instance. For more information, see [Build a confidential computing environment by using Enclave](https://help.aliyun.com/document_detail/203433.html).
        # *   TDX: A Trust Domain Extensions (TDX) confidential computing environment is built on the instance. For more information, see [Build a TDX confidential computing environment](https://help.aliyun.com/document_detail/479090.html).
        self.confidential_computing_mode = confidential_computing_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.confidential_computing_mode is not None:
            result['ConfidentialComputingMode'] = self.confidential_computing_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfidentialComputingMode') is not None:
            self.confidential_computing_mode = m.get('ConfidentialComputingMode')
        return self


class CreateScalingConfigurationShrinkRequestSpotPriceLimits(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        price_limit: float = None,
    ):
        # The instance type of the preemptible instance. This parameter takes effect only if you set SpotStrategy to SpotWithPriceLimit.
        self.instance_type = instance_type
        # The price limit of the preemptible instance. This parameter takes effect only if you set SpotStrategy to SpotWithPriceLimit.
        self.price_limit = price_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.price_limit is not None:
            result['PriceLimit'] = self.price_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('PriceLimit') is not None:
            self.price_limit = m.get('PriceLimit')
        return self


class CreateScalingConfigurationShrinkRequest(TeaModel):
    def __init__(
        self,
        image_options: CreateScalingConfigurationShrinkRequestImageOptions = None,
        private_pool_options: CreateScalingConfigurationShrinkRequestPrivatePoolOptions = None,
        system_disk: CreateScalingConfigurationShrinkRequestSystemDisk = None,
        affinity: str = None,
        client_token: str = None,
        cpu: int = None,
        credit_specification: str = None,
        custom_priorities: List[CreateScalingConfigurationShrinkRequestCustomPriorities] = None,
        data_disks: List[CreateScalingConfigurationShrinkRequestDataDisks] = None,
        dedicated_host_cluster_id: str = None,
        dedicated_host_id: str = None,
        deletion_protection: bool = None,
        deployment_set_id: str = None,
        host_name: str = None,
        hpc_cluster_id: str = None,
        http_endpoint: str = None,
        http_tokens: str = None,
        image_family: str = None,
        image_id: str = None,
        image_name: str = None,
        instance_description: str = None,
        instance_name: str = None,
        instance_pattern_infos: List[CreateScalingConfigurationShrinkRequestInstancePatternInfos] = None,
        instance_type: str = None,
        instance_type_overrides: List[CreateScalingConfigurationShrinkRequestInstanceTypeOverrides] = None,
        instance_types: List[str] = None,
        internet_charge_type: str = None,
        internet_max_bandwidth_in: int = None,
        internet_max_bandwidth_out: int = None,
        io_optimized: str = None,
        ipv_6address_count: int = None,
        key_pair_name: str = None,
        load_balancer_weight: int = None,
        memory: int = None,
        network_interfaces: List[CreateScalingConfigurationShrinkRequestNetworkInterfaces] = None,
        owner_account: str = None,
        owner_id: int = None,
        password: str = None,
        password_inherit: bool = None,
        ram_role_name: str = None,
        resource_group_id: str = None,
        resource_owner_account: str = None,
        resource_pool_options: CreateScalingConfigurationShrinkRequestResourcePoolOptions = None,
        scaling_configuration_name: str = None,
        scaling_group_id: str = None,
        scheduler_options_shrink: str = None,
        security_enhancement_strategy: str = None,
        security_group_id: str = None,
        security_group_ids: List[str] = None,
        security_options: CreateScalingConfigurationShrinkRequestSecurityOptions = None,
        spot_duration: int = None,
        spot_interruption_behavior: str = None,
        spot_price_limits: List[CreateScalingConfigurationShrinkRequestSpotPriceLimits] = None,
        spot_strategy: str = None,
        storage_set_id: str = None,
        storage_set_partition_number: int = None,
        system_disk_categories: List[str] = None,
        tags: str = None,
        tenancy: str = None,
        user_data: str = None,
        zone_id: str = None,
    ):
        self.image_options = image_options
        self.private_pool_options = private_pool_options
        self.system_disk = system_disk
        # Specifies whether to associate an ECS instance on a dedicated host with the dedicated host. Valid values:
        # 
        # *   default: does not associate the ECS instance with the dedicated host. If you start an ECS instance that was stopped in economical mode and the original dedicated host has insufficient resources, the ECS instance is automatically deployed to another dedicated host in the automatic deployment resource pool.
        # *   host: associates the ECS instance with the dedicated host. If you start an ECS instance that was stopped in economical mode, the instance remains on the original dedicated host. If the original dedicated host has insufficient resources, the ECS instance fails to start.
        # 
        # Default value: default
        self.affinity = affinity
        # The client token that is used to ensure the idempotence of the request. You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see the "[How to ensure the idempotence of a request](https://help.aliyun.com/document_detail/25693.html)" topic.
        self.client_token = client_token
        # The number of vCPUs.
        # 
        # You can specify the number of vCPUs and the memory size to determine the range of instance types. For example, you can set CPU to 2 and Memory to 16 to specify instance types that have 2 vCPUs and 16 GiB of memory. If you specify Cpu and Memory, Auto Scaling determines the available instance types based on factors such as I/O optimization requirements and zones. Then, Auto Scaling preferentially creates instances by using the lowest-priced instance type.
        # 
        # > You can specify Cpu and Memory to determine the range of instance types only if you set Scaling Policy to Cost Optimization Policy and you do not specify instance types in the scaling configuration.
        self.cpu = cpu
        # The performance mode of the burstable instance. Valid values:
        # 
        # *   Standard: standard mode
        # *   Unlimited: unlimited mode
        # 
        # For more information, see the "Performance modes" section in the "[Overview](https://help.aliyun.com/document_detail/59977.html)" topic.
        self.credit_specification = credit_specification
        # The priority of the custom ECS instance type + vSwitch combination.
        # 
        # >  This parameter takes effect only when Scaling Policy of the scaling group is set to Priority Policy.
        # 
        # If Auto Scaling cannot create ECS instances by using the custom ECS instance type + vSwitch combination of the highest priority, Auto Scaling creates ECS instances by using the custom ECS instance type + vSwitch combination of the next highest priority.
        # 
        # >  If you specify the priorities of only partial custom ECS instance type + vSwitch combinations, Auto Scaling preferentially creates ECS instances by using the custom combinations that have specified priorities. If the custom combinations that have specified priorities do not provide sufficient resources, Auto Scaling creates ECS instances by using the custom combinations that do not have specified priorities based on the specified orders of vSwitches and instance types.
        # 
        # *   Example: the specified order of vSwitches for your scaling group is vsw1 and vsw2 and the specified order of instance types in your scaling configuration is type1 and type 2. In addition, you use CustomPriorities to specify ["vsw2+type2", "vsw1+type2"]. In this example, the vsw2+type2 combination has the highest priority and the vsw2+type1 combination has the lowest priority. The vsw1+type2 combination has a higher priority than the vsw1+type1 combination.
        self.custom_priorities = custom_priorities
        # The data disks.
        self.data_disks = data_disks
        # The ID of the dedicated host cluster.
        self.dedicated_host_cluster_id = dedicated_host_cluster_id
        # The ID of the dedicated host on which you want to create an ECS instance. You cannot create preemptible instances on dedicated hosts. If you specify DedicatedHostId, SpotStrategy and SpotPriceLimit are ignored.
        # 
        # You can call the DescribeDedicatedHosts operation to query dedicated host IDs.
        self.dedicated_host_id = dedicated_host_id
        self.deletion_protection = deletion_protection
        # The ID of the deployment set of the ECS instances that are created by using the scaling configuration.
        self.deployment_set_id = deployment_set_id
        # The hostname of the ECS instance. The hostname cannot start or end with a period (.) or a hyphen (-). The hostname cannot contain consecutive periods (.) or hyphens (-). Naming conventions for different types of instances:
        # 
        # *   Windows instances: The hostname must be 2 to 15 characters in length and can contain letters, digits, and hyphens (-). The hostname cannot contain periods (.) or contain only digits.
        # *   Other instances, such as Linux instances: The hostname must be 2 to 64 characters in length. You can use periods (.) to separate a hostname into multiple segments. Each segment can contain letters, digits, and hyphens (-).
        self.host_name = host_name
        # The ID of the Elastic High Performance Computing (E-HPC) cluster to which the ECS instances that are created by using the scaling configuration belong.
        self.hpc_cluster_id = hpc_cluster_id
        # Specifies whether to enable the access channel for instance metadata. Valid values:
        # 
        # *   enabled
        # *   disabled
        # 
        # Default value: enabled.
        # 
        # >  For information about instance metadata, see [Obtain instance metadata](https://help.aliyun.com/document_detail/108460.html).
        self.http_endpoint = http_endpoint
        # Specifies whether to forcibly use the security hardening mode (IMDSv2) to access instance metadata. Valid values:
        # 
        # *   optional: does not forcibly use the security hardening mode (IMDSv2).
        # *   required: forcibly uses the security hardening mode (IMDSv2). If you set this parameter to required, you cannot access instance metadata in normal mode.
        # 
        # Default value: optional.
        # 
        # >  For more information about instance metadata access modes, see [Access modes of instance metadata](https://help.aliyun.com/document_detail/108460.html).
        self.http_tokens = http_tokens
        # The name of the image family. If you specify this parameter, the most recent custom images that are available in the specified image family are returned. You can use the images to create instances. If you specify ImageId, you cannot specify ImageFamily.
        self.image_family = image_family
        # The ID of the image that Auto Scaling uses to automatically create ECS instances.
        self.image_id = image_id
        # The name of the image. Each image name must be unique in a region. If you specify ImageId, ImageName is ignored.
        # 
        # You cannot use ImageName to specify images that are purchased from Alibaba Cloud Marketplace.
        self.image_name = image_name
        # The description of the ECS instance. The description must be 2 to 256 characters in length. The description can contain letters and cannot start with `http://` or `https://`.
        self.instance_description = instance_description
        # The name of the ECS instance that Auto Scaling creates based on the scaling configuration.
        self.instance_name = instance_name
        # The intelligent configuration settings, which determine the available instance types.
        self.instance_pattern_infos = instance_pattern_infos
        # The instance type of the ECS instance. For more information, see the [Instance families](https://help.aliyun.com/document_detail/25378.html) topic.
        self.instance_type = instance_type
        # The instance types.
        self.instance_type_overrides = instance_type_overrides
        # The instance types. If you specify InstanceTypes, InstanceType is ignored.
        # 
        # Auto Scaling creates instances based on a priority list of instance types. If it fails to create instances using the highest-priority type, it automatically moves to the next type in the priority order.
        self.instance_types = instance_types
        # The metering method for network usage. Valid values:
        # 
        # *   PayByBandwidth: You are charged for the maximum available bandwidth that is specified by InternetMaxBandwidthOut.
        # *   PayByTraffic: You are charged based on the amount of transferred data. InternetMaxBandwidthOut specifies only the maximum available bandwidth.
        # 
        # For the classic network, the default value is PayByBandwidth. For VPCs, the default value is PayByTraffic.
        self.internet_charge_type = internet_charge_type
        # The maximum inbound public bandwidth. Unit: Mbit/s. Valid values:
        # 
        # *   If the purchased outbound public bandwidth is less than or equal to 10 Mbit/s, the valid values of this parameter are 1 to 10, and the default value is 10.
        # *   If the purchased outbound public bandwidth is greater than 10 Mbit/s, the valid values of this parameter are 1 to the value of `InternetMaxBandwidthOut`, and the default value is the value of `InternetMaxBandwidthOut`.
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        # The maximum outbound public bandwidth. Unit: Mbit/s. Valid values: 0 to 100.
        # 
        # Default value: 0.
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        # Specifies whether to create an I/O optimized instance. Valid values:
        # 
        # none: does not create an I/O optimized instance. optimized: creates an I/O optimized instance.
        # 
        # For instances of retired instance types, the default value is none. For instances of other instance types, the default value is optimized.
        self.io_optimized = io_optimized
        # The number of randomly generated IPv6 addresses that you want to allocate to the elastic network interface (ENI).
        self.ipv_6address_count = ipv_6address_count
        # The name of the key pair that you want to use to log on to an ECS instance.
        # 
        # *   Windows instances do not support this parameter.
        # *   By default, the username and password authentication method is disabled for Linux instances.
        self.key_pair_name = key_pair_name
        # The weight of an ECS instance as a backend server. Valid values: 1 to 100.
        # 
        # Default value: 50
        self.load_balancer_weight = load_balancer_weight
        # The memory size. Unit: GiB.
        # 
        # You can specify the number of vCPUs and the memory size to determine the range of instance types. For example, you can set Cpu to 2 and Memory to 16 to specify instance types that have 2 vCPUs and 16 GiB of memory. If you specify Cpu and Memory, Auto Scaling determines the available instance types based on factors such as I/O optimization requirements and zones. Then, Auto Scaling preferentially creates instances by using the lowest-priced instance type.
        # 
        # > You can specify Cpu and Memory to determine the range of instance types only if you set Scaling Policy to Cost Optimization Policy and you do not specify instance types in the scaling configuration.
        self.memory = memory
        self.network_interfaces = network_interfaces
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The password that you want to use to log on to an ECS instance. The password must be 8 to 30 characters in length and must contain at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. The following special characters are supported:
        # 
        # `` `() ~!@#$%^&*-_+=\\|{}[]:;\\"<>,.?/ ``
        # 
        # The password of a Windows instance cannot start with a forward slash (/).
        # 
        # > For security reasons, we recommend that you use HTTPS to send requests if you specify Password.
        self.password = password
        # Specifies whether to use the password that is preconfigured in the image. Before you use this parameter, make sure that a password is configured in the image. Valid values:
        # 
        # *   true
        # *   false
        self.password_inherit = password_inherit
        # The name of the RAM role that you attach to the ECS instance. The name is provided and maintained by Resource Access Management (RAM). You can call the ListRoles operation to query the available RAM roles.
        self.ram_role_name = ram_role_name
        # The ID of the resource group to which the ECS instances that are created by using the scaling configuration belong.
        self.resource_group_id = resource_group_id
        self.resource_owner_account = resource_owner_account
        # The resource pools used for instance creation, which can be the public pool or a private pool associated with any active elasticity assurance or capacity reservation. When you specify this parameter, take note of the following items:
        # 
        # *   This parameter takes effect only when you create pay-as-you-go instances.
        # *   If you specify this parameter, you cannot specify PrivatePoolOptions.MatchCriteria or PrivatePoolOptions.Id.
        self.resource_pool_options = resource_pool_options
        # The name of the scaling configuration. The name must be 2 to 64 characters in length and can contain letters, digits, underscores (_), hyphens (-), and periods (.). The name must start with a letter or a digit.
        # 
        # The name of the scaling configuration must be unique in a region. If you do not specify this parameter, the scaling configuration ID is used.
        self.scaling_configuration_name = scaling_configuration_name
        # The ID of the scaling group in which you want to create a scaling configuration.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id
        # The scheduler options.
        self.scheduler_options_shrink = scheduler_options_shrink
        # Specifies whether to enable security hardening. Valid values:
        # 
        # *   Active: enables security hardening. This value is applicable only to public images.
        # *   Deactive: disables security hardening. This value is applicable to all image types.
        self.security_enhancement_strategy = security_enhancement_strategy
        # The ID of the security group with which ECS instances are associated. ECS instances that are associated with the same security group can access each other.
        self.security_group_id = security_group_id
        # The IDs of the security groups with which you want to associate the ECS instances that are created by using the scaling configuration. For more information, see the "Security group limits" section of the "[Limits](https://help.aliyun.com/document_detail/25412.html)" topic.
        # 
        # > If you specify SecurityGroupId, you cannot specify SecurityGroupIds.
        self.security_group_ids = security_group_ids
        self.security_options = security_options
        # The retention period of the preemptible instance. Unit: hours. Valid values: 0, 1, 2, 3, 4, 5, and 6.
        # 
        # *   The following retention periods are available in invitational preview: 2, 3, 4, 5, and 6 hours. If you want to set this parameter to one of these values, submit a ticket.
        # *   If you set this parameter to 0, no protection period is specified for the preemptible instance.
        # 
        # Default value: 1
        self.spot_duration = spot_duration
        # The interruption mode of the preemptible instance. Set the value to Terminate. The value specifies that the preemptible instance is to be released.
        self.spot_interruption_behavior = spot_interruption_behavior
        # The billing information of the preemptible instances.
        self.spot_price_limits = spot_price_limits
        # The preemption policy that you want to apply to pay-as-you-go and preemptible instances. Valid values:
        # 
        # *   NoSpot: The instance is created as a pay-as-you-go instance.
        # *   SpotWithPriceLimit: The instance is a preemptible instance that has a user-defined maximum hourly price.
        # *   SpotAsPriceGo: The instance is created as a preemptible instance for which the market price at the time of purchase is automatically used as the bid price.
        # 
        # Default value: NoSpot
        self.spot_strategy = spot_strategy
        self.storage_set_id = storage_set_id
        self.storage_set_partition_number = storage_set_partition_number
        # The categories of the system disks. If Auto Scaling cannot create instances by using the disk category that has the highest priority, Auto Scaling creates instances by using the disk category that has the next highest priority. Valid values:
        # 
        # *   cloud: basic disk
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   cloud_essd: ESSD
        # 
        # > If you specify SystemDiskCategories, you cannot specify `SystemDisk.Category`.
        self.system_disk_categories = system_disk_categories
        # The tags of the ECS instance. Tags must be specified as key-value pairs. You can specify up to 20 tags. When you specify tag keys and tag values, take note of the following items:
        # 
        # *   A tag key can be up to 64 characters in length. The key cannot start with acs: or aliyun and cannot contain `http://` or `https://`. You cannot specify an empty string as a tag key.
        # *   A tag value can be up to 128 characters in length. The value cannot start with acs: or aliyun and cannot contain `http://` or `https://`. You can specify an empty string as a tag value.
        self.tags = tags
        # Specifies whether to create an ECS instance on a dedicated host. Valid values:
        # 
        # *   default: does not create an ECS instance on a dedicated host.
        # *   host: creates an ECS instance on a dedicated host. If you do not specify DedicatedHostId, Alibaba Cloud selects a dedicated host for the ECS instance.
        # 
        # Default value: default
        self.tenancy = tenancy
        # The user data of the Elastic Compute Service (ECS) instance. The user data must be encoded in Base64 format. The size of raw data before Base64 encoding cannot exceed 32 KB.
        self.user_data = user_data
        # The zone ID of the ECS instance.
        self.zone_id = zone_id

    def validate(self):
        if self.image_options:
            self.image_options.validate()
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.system_disk:
            self.system_disk.validate()
        if self.custom_priorities:
            for k in self.custom_priorities:
                if k:
                    k.validate()
        if self.data_disks:
            for k in self.data_disks:
                if k:
                    k.validate()
        if self.instance_pattern_infos:
            for k in self.instance_pattern_infos:
                if k:
                    k.validate()
        if self.instance_type_overrides:
            for k in self.instance_type_overrides:
                if k:
                    k.validate()
        if self.network_interfaces:
            for k in self.network_interfaces:
                if k:
                    k.validate()
        if self.resource_pool_options:
            self.resource_pool_options.validate()
        if self.security_options:
            self.security_options.validate()
        if self.spot_price_limits:
            for k in self.spot_price_limits:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_options is not None:
            result['ImageOptions'] = self.image_options.to_map()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.affinity is not None:
            result['Affinity'] = self.affinity
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        result['CustomPriorities'] = []
        if self.custom_priorities is not None:
            for k in self.custom_priorities:
                result['CustomPriorities'].append(k.to_map() if k else None)
        result['DataDisks'] = []
        if self.data_disks is not None:
            for k in self.data_disks:
                result['DataDisks'].append(k.to_map() if k else None)
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.http_endpoint is not None:
            result['HttpEndpoint'] = self.http_endpoint
        if self.http_tokens is not None:
            result['HttpTokens'] = self.http_tokens
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        result['InstancePatternInfos'] = []
        if self.instance_pattern_infos is not None:
            for k in self.instance_pattern_infos:
                result['InstancePatternInfos'].append(k.to_map() if k else None)
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        result['InstanceTypeOverrides'] = []
        if self.instance_type_overrides is not None:
            for k in self.instance_type_overrides:
                result['InstanceTypeOverrides'].append(k.to_map() if k else None)
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.load_balancer_weight is not None:
            result['LoadBalancerWeight'] = self.load_balancer_weight
        if self.memory is not None:
            result['Memory'] = self.memory
        result['NetworkInterfaces'] = []
        if self.network_interfaces is not None:
            for k in self.network_interfaces:
                result['NetworkInterfaces'].append(k.to_map() if k else None)
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_pool_options is not None:
            result['ResourcePoolOptions'] = self.resource_pool_options.to_map()
        if self.scaling_configuration_name is not None:
            result['ScalingConfigurationName'] = self.scaling_configuration_name
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.scheduler_options_shrink is not None:
            result['SchedulerOptions'] = self.scheduler_options_shrink
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.security_options is not None:
            result['SecurityOptions'] = self.security_options.to_map()
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_interruption_behavior is not None:
            result['SpotInterruptionBehavior'] = self.spot_interruption_behavior
        result['SpotPriceLimits'] = []
        if self.spot_price_limits is not None:
            for k in self.spot_price_limits:
                result['SpotPriceLimits'].append(k.to_map() if k else None)
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.system_disk_categories is not None:
            result['SystemDiskCategories'] = self.system_disk_categories
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.tenancy is not None:
            result['Tenancy'] = self.tenancy
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageOptions') is not None:
            temp_model = CreateScalingConfigurationShrinkRequestImageOptions()
            self.image_options = temp_model.from_map(m['ImageOptions'])
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateScalingConfigurationShrinkRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('SystemDisk') is not None:
            temp_model = CreateScalingConfigurationShrinkRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('Affinity') is not None:
            self.affinity = m.get('Affinity')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CreditSpecification') is not None:
            self.credit_specification = m.get('CreditSpecification')
        self.custom_priorities = []
        if m.get('CustomPriorities') is not None:
            for k in m.get('CustomPriorities'):
                temp_model = CreateScalingConfigurationShrinkRequestCustomPriorities()
                self.custom_priorities.append(temp_model.from_map(k))
        self.data_disks = []
        if m.get('DataDisks') is not None:
            for k in m.get('DataDisks'):
                temp_model = CreateScalingConfigurationShrinkRequestDataDisks()
                self.data_disks.append(temp_model.from_map(k))
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        if m.get('HttpEndpoint') is not None:
            self.http_endpoint = m.get('HttpEndpoint')
        if m.get('HttpTokens') is not None:
            self.http_tokens = m.get('HttpTokens')
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        self.instance_pattern_infos = []
        if m.get('InstancePatternInfos') is not None:
            for k in m.get('InstancePatternInfos'):
                temp_model = CreateScalingConfigurationShrinkRequestInstancePatternInfos()
                self.instance_pattern_infos.append(temp_model.from_map(k))
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        self.instance_type_overrides = []
        if m.get('InstanceTypeOverrides') is not None:
            for k in m.get('InstanceTypeOverrides'):
                temp_model = CreateScalingConfigurationShrinkRequestInstanceTypeOverrides()
                self.instance_type_overrides.append(temp_model.from_map(k))
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LoadBalancerWeight') is not None:
            self.load_balancer_weight = m.get('LoadBalancerWeight')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        self.network_interfaces = []
        if m.get('NetworkInterfaces') is not None:
            for k in m.get('NetworkInterfaces'):
                temp_model = CreateScalingConfigurationShrinkRequestNetworkInterfaces()
                self.network_interfaces.append(temp_model.from_map(k))
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourcePoolOptions') is not None:
            temp_model = CreateScalingConfigurationShrinkRequestResourcePoolOptions()
            self.resource_pool_options = temp_model.from_map(m['ResourcePoolOptions'])
        if m.get('ScalingConfigurationName') is not None:
            self.scaling_configuration_name = m.get('ScalingConfigurationName')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('SchedulerOptions') is not None:
            self.scheduler_options_shrink = m.get('SchedulerOptions')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('SecurityOptions') is not None:
            temp_model = CreateScalingConfigurationShrinkRequestSecurityOptions()
            self.security_options = temp_model.from_map(m['SecurityOptions'])
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('SpotInterruptionBehavior') is not None:
            self.spot_interruption_behavior = m.get('SpotInterruptionBehavior')
        self.spot_price_limits = []
        if m.get('SpotPriceLimits') is not None:
            for k in m.get('SpotPriceLimits'):
                temp_model = CreateScalingConfigurationShrinkRequestSpotPriceLimits()
                self.spot_price_limits.append(temp_model.from_map(k))
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        if m.get('SystemDiskCategories') is not None:
            self.system_disk_categories = m.get('SystemDiskCategories')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Tenancy') is not None:
            self.tenancy = m.get('Tenancy')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateScalingConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_configuration_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the scaling configuration.
        self.scaling_configuration_id = scaling_configuration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        return self


class CreateScalingConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateScalingConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateScalingConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScalingGroupRequestAlbServerGroups(TeaModel):
    def __init__(
        self,
        alb_server_group_id: str = None,
        port: int = None,
        weight: int = None,
    ):
        # The ID of the ALB server group.
        # 
        # You can attach only a limited number of ALB server groups to a scaling group. To view the predefined quota limit or manually request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.alb_server_group_id = alb_server_group_id
        # The port number used by each ECS instance as a backend server in the ALB server group. Valid values: 1 to 65535.
        self.port = port
        # The weight of an ECS instance as a backend server in the ALB server group. If you increase the weight for an ECS instance, the number of requests that are forwarded to the ECS instance also increases. If you set the weight for an ECS instance to 0, no requests are forwarded to the ECS instance. Valid values: 0 to 100.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alb_server_group_id is not None:
            result['AlbServerGroupId'] = self.alb_server_group_id
        if self.port is not None:
            result['Port'] = self.port
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlbServerGroupId') is not None:
            self.alb_server_group_id = m.get('AlbServerGroupId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CreateScalingGroupRequestCapacityOptions(TeaModel):
    def __init__(
        self,
        compensate_with_on_demand: bool = None,
        on_demand_base_capacity: int = None,
        on_demand_percentage_above_base_capacity: int = None,
        price_comparison_mode: str = None,
        spot_auto_replace_on_demand: bool = None,
    ):
        # Specifies whether to automatically create pay-as-you-go ECS instances to reach the required number of ECS instances when preemptible ECS instances cannot be created due to high prices or insufficient inventory of resources. This parameter takes effect when you set `MultiAZPolicy` to `COST_OPTIMIZED`. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: true.
        self.compensate_with_on_demand = compensate_with_on_demand
        # The minimum number of pay-as-you-go instances required in the scaling group. When the number of pay-as-you-go instances drops below the value of this parameter, Auto Scaling preferentially creates pay-as-you-go instances. Valid values: 0 to 1000.
        # 
        # If you set `MultiAZPolicy` to `COMPOSABLE`, the default value is 0.
        self.on_demand_base_capacity = on_demand_base_capacity
        # The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances is reached. `OnDemandBaseCapacity` specifies the minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 100.
        # 
        # If you set `MultiAZPolicy` to `COMPOSABLE`, the default value is 100.
        self.on_demand_percentage_above_base_capacity = on_demand_percentage_above_base_capacity
        # The cost comparison method. Valid values:
        # 
        # *   PricePerUnit: Prices are compared based on the price per instance capacity.
        # 
        #     Capacity is determined by the weights assigned to instance types in the scaling group. If no weight is specified, a default weight of 1 is used, meaning each instance is assigned a capacity of 1.
        # 
        # *   PricePerVCpu: Prices are compared based on the price per vCPU.
        # 
        # Default value: PricePerUnit.
        self.price_comparison_mode = price_comparison_mode
        # Specifies whether to replace pay-as-you-go instances with preemptible instances. If you specify `CompensateWithOnDemand`, it may result in a higher percentage of pay-as-you-go instances compared to the value of `OnDemandPercentageAboveBaseCapacity`. In this scenario, Auto Scaling will try to deploy preemptible instances to replace the surplus pay-as-you-go instances. When `CompensateWithOnDemand` is specified, Auto Scaling creates pay-as-you-go instances if there are not enough preemptible instance types. To avoid keeping these pay-as-you-go ECS instances for long periods, Auto Scaling tries to replace them with preemptible instances as soon as enough of preemptible instance types become available. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        self.spot_auto_replace_on_demand = spot_auto_replace_on_demand

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compensate_with_on_demand is not None:
            result['CompensateWithOnDemand'] = self.compensate_with_on_demand
        if self.on_demand_base_capacity is not None:
            result['OnDemandBaseCapacity'] = self.on_demand_base_capacity
        if self.on_demand_percentage_above_base_capacity is not None:
            result['OnDemandPercentageAboveBaseCapacity'] = self.on_demand_percentage_above_base_capacity
        if self.price_comparison_mode is not None:
            result['PriceComparisonMode'] = self.price_comparison_mode
        if self.spot_auto_replace_on_demand is not None:
            result['SpotAutoReplaceOnDemand'] = self.spot_auto_replace_on_demand
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CompensateWithOnDemand') is not None:
            self.compensate_with_on_demand = m.get('CompensateWithOnDemand')
        if m.get('OnDemandBaseCapacity') is not None:
            self.on_demand_base_capacity = m.get('OnDemandBaseCapacity')
        if m.get('OnDemandPercentageAboveBaseCapacity') is not None:
            self.on_demand_percentage_above_base_capacity = m.get('OnDemandPercentageAboveBaseCapacity')
        if m.get('PriceComparisonMode') is not None:
            self.price_comparison_mode = m.get('PriceComparisonMode')
        if m.get('SpotAutoReplaceOnDemand') is not None:
            self.spot_auto_replace_on_demand = m.get('SpotAutoReplaceOnDemand')
        return self


class CreateScalingGroupRequestDBInstances(TeaModel):
    def __init__(
        self,
        attach_mode: str = None,
        dbinstance_id: str = None,
        type: str = None,
    ):
        # The mode in which you want to attach the database to the scaling group. Valid values:
        # 
        # *   SecurityIp: the mode in which Auto Scaling automatically adds the private IP addresses of ECS instances to the IP address whitelist of the database during scale-out events. You can set the value to SecurityIp only if you set Type to RDS.
        # *   SecurityGroup: the mode in which Auto Scaling adds the security group of the applied scaling configuration to the security group whitelist of the database. This setting allows ECS instances created from the scaling configuration to access the database.
        self.attach_mode = attach_mode
        # The database ID.
        self.dbinstance_id = dbinstance_id
        # The database type. Valid values:
        # 
        # *   RDS
        # *   Redis
        # *   MongoDB
        # 
        # Default value: RDS.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attach_mode is not None:
            result['AttachMode'] = self.attach_mode
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttachMode') is not None:
            self.attach_mode = m.get('AttachMode')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateScalingGroupRequestLaunchTemplateOverrides(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        spot_price_limit: float = None,
        weighted_capacity: int = None,
    ):
        # The instance type that you want to use to override the instance type that is specified in the launch template.
        # 
        # If you want to scale instances based on the weighted capacities of the instances, you must specify both the InstanceType and WeightedCapacity parameters.
        # 
        # > This parameter is available only if you specify the LaunchTemplateId parameter.
        # 
        # You can use the InstanceType parameter to specify only instance types that are available for purchase.
        self.instance_type = instance_type
        # The maximum bid price of the instance type that is specified by the `InstanceType` parameter. You can specify 1 to 10 instance types by using the Extended Configurations feature of the launch template.
        # 
        # > This parameter is available only if you specify the `LaunchTemplateId` parameter.
        self.spot_price_limit = spot_price_limit
        # The weight of the instance type. The weight specifies the capacity of an instance of the specified instance type in the scaling group. If you want to scale instances based on the weighted capacities of the instances, you must specify the WeightedCapacity parameter after you specify the InstanceType parameter.
        # 
        # A higher weight specifies that a smaller number of instances of the specified instance type are required to meet the expected capacity requirement.
        # 
        # Performance metrics, such as the number of vCPUs and the memory size of each instance type, may vary. You can specify different weights for different instance types based on your business requirements.
        # 
        # Example:
        # 
        # *   Current capacity: 0
        # *   Expected capacity: 6
        # *   Capacity of ecs.c5.xlarge: 4
        # 
        # To meet the expected capacity requirement, Auto Scaling must create and add two ecs.c5.xlarge instances.
        # 
        # > The capacity of the scaling group cannot exceed the sum of the maximum number of instances that is specified by the MaxSize parameter and the maximum weight of the instance types.
        # 
        # Valid values of the WeightedCapacity parameter: 1 to 500.
        self.weighted_capacity = weighted_capacity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.weighted_capacity is not None:
            result['WeightedCapacity'] = self.weighted_capacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('WeightedCapacity') is not None:
            self.weighted_capacity = m.get('WeightedCapacity')
        return self


class CreateScalingGroupRequestLifecycleHooks(TeaModel):
    def __init__(
        self,
        default_result: str = None,
        heartbeat_timeout: int = None,
        lifecycle_hook_name: str = None,
        lifecycle_transition: str = None,
        notification_arn: str = None,
        notification_metadata: str = None,
    ):
        # The action that Auto Scaling performs when the lifecycle hook times out. Valid values:
        # 
        # *   CONTINUE: Auto Scaling continues to respond to the scaling request.
        # *   ABANDON: Auto Scaling releases ECS instances that are created during scale-out events, or removes ECS instances from the scaling group during scale-in events.
        # 
        # If multiple lifecycle hooks in the scaling group are triggered during scale-in events, and you set DefaultResult to ABANDON for one of the lifecycle hooks, Auto Scaling immediately performs the action after the lifecycle hook whose DefaultResult is set to ABANDON times out. In this case, other lifecycle hooks time out ahead of schedule. In other cases, Auto Scaling performs the action only after all lifecycle hooks time out. The action that Auto Scaling performs is determined by the value of DefaultResult that you specify for the lifecycle hook that most recently times out.
        # 
        # Default value: CONTINUE.
        self.default_result = default_result
        # The period of time before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action that is specified by DefaultResult. Valid values: 30 to 21600. Unit: seconds.
        # 
        # After you create a lifecycle hook, you can call the RecordLifecycleActionHeartbeat operation to extend the timeout period of the lifecycle hook. You can also call the CompleteLifecycleAction operation to end the timeout period of the lifecycle hook ahead of schedule.
        # 
        # Default value: 600.
        self.heartbeat_timeout = heartbeat_timeout
        # The name of the lifecycle hook. After you specify this parameter, you cannot change the name of the lifecycle hook. If you do not specify this parameter, the name of the lifecycle hook is the same as the ID of the lifecycle hook.
        self.lifecycle_hook_name = lifecycle_hook_name
        # The type of the scaling activity to which you want to apply the lifecycle hook. Valid values:
        # 
        # *   SCALE_OUT
        # *   SCALE_IN
        # 
        # >  If you specify lifecycle hooks for the scaling group, you must specify LifecycleTransition. Other parameters are optional.
        self.lifecycle_transition = lifecycle_transition
        # The Alibaba Cloud Resource Name (ARN) of the notification recipient party. You can specify a Simple Message Queue (SMQ, formerly MNS) topic or queue as the recipient party. The value is in the acs:ess:{region}:{account-id}:{resource-relative-id} format.
        # 
        # *   region: the region ID of the scaling group
        # *   account-id: the ID of your Alibaba Cloud account.
        # 
        # Examples:
        # 
        # *   SMQ queue: acs:ess:{region}:{account-id}:queue/{queuename}
        # *   SMQ topic: acs:ess:{region}:{account-id}:topic/{topicname}
        self.notification_arn = notification_arn
        # The fixed string that you want to include in notifications. When a lifecycle hook takes effect, Auto Scaling sends a notification. The fixed string can contain up to 4,096 characters in length. When Auto Scaling sends a notification to the recipient party, it includes predefined notification metadata into the notification. This helps in managing and labeling notifications of different categories. NotificationMetadata takes effect only if you specify NotificationArn.
        self.notification_metadata = notification_metadata

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_result is not None:
            result['DefaultResult'] = self.default_result
        if self.heartbeat_timeout is not None:
            result['HeartbeatTimeout'] = self.heartbeat_timeout
        if self.lifecycle_hook_name is not None:
            result['LifecycleHookName'] = self.lifecycle_hook_name
        if self.lifecycle_transition is not None:
            result['LifecycleTransition'] = self.lifecycle_transition
        if self.notification_arn is not None:
            result['NotificationArn'] = self.notification_arn
        if self.notification_metadata is not None:
            result['NotificationMetadata'] = self.notification_metadata
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultResult') is not None:
            self.default_result = m.get('DefaultResult')
        if m.get('HeartbeatTimeout') is not None:
            self.heartbeat_timeout = m.get('HeartbeatTimeout')
        if m.get('LifecycleHookName') is not None:
            self.lifecycle_hook_name = m.get('LifecycleHookName')
        if m.get('LifecycleTransition') is not None:
            self.lifecycle_transition = m.get('LifecycleTransition')
        if m.get('NotificationArn') is not None:
            self.notification_arn = m.get('NotificationArn')
        if m.get('NotificationMetadata') is not None:
            self.notification_metadata = m.get('NotificationMetadata')
        return self


class CreateScalingGroupRequestLoadBalancerConfigs(TeaModel):
    def __init__(
        self,
        load_balancer_id: str = None,
        weight: int = None,
    ):
        # The ID of the CLB instance.
        self.load_balancer_id = load_balancer_id
        # The weight of each ECS instance as a backend server in the CLB backend server group. If you increase the weight for an ECS instance, the number of requests that are forwarded to the ECS instance also increases. If you set the weight for an ECS instance to 0, no requests are forwarded to the ECS instance. Valid values: 0 to 100.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CreateScalingGroupRequestServerGroups(TeaModel):
    def __init__(
        self,
        port: int = None,
        server_group_id: str = None,
        type: str = None,
        weight: int = None,
    ):
        # The port number used by each ECS instance as backend server in the vServer group. Valid values: 1 to 65535.
        self.port = port
        # The ID of the server group.
        self.server_group_id = server_group_id
        # The type of the server group. Valid values:
        # 
        # *   ALB
        # *   NLB
        self.type = type
        # The weight of each ECS instance as a backend server in the server group. Valid values: 0 to 100.
        # 
        # If you increase the weight for an ECS instance, the number of requests that are forwarded to the ECS instance also increases. If you set the weight for an ECS instance to 0, no requests are forwarded to the ECS instance.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.server_group_id is not None:
            result['ServerGroupId'] = self.server_group_id
        if self.type is not None:
            result['Type'] = self.type
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ServerGroupId') is not None:
            self.server_group_id = m.get('ServerGroupId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CreateScalingGroupRequestTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        propagate: bool = None,
        value: str = None,
    ):
        # The tag key that you want to add to the scaling group.
        self.key = key
        # Specifies whether to propagate the tag that you want to add to the scaling group. Valid values:
        # 
        # *   true: propagates the tag to only instances that are newly created.
        # *   false: does not propagate the tag to any instances.
        # 
        # Default value: false.
        self.propagate = propagate
        # The tag value that you want to add to the scaling group.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.propagate is not None:
            result['Propagate'] = self.propagate
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Propagate') is not None:
            self.propagate = m.get('Propagate')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateScalingGroupRequestVServerGroupsVServerGroupAttributes(TeaModel):
    def __init__(
        self,
        port: int = None,
        vserver_group_id: str = None,
        weight: int = None,
    ):
        # The port number used by each ECS instance as a backend server in the vServer group. Valid values: 1 to 65535.
        self.port = port
        # The ID of the vServer group.
        self.vserver_group_id = vserver_group_id
        # The weight of each ECS instance as a backend server in the vServer group. If you increase the weight for an ECS instance, the number of requests that are forwarded to the ECS instance also increases. If you set the weight for an ECS instance to 0, no requests are forwarded to the ECS instance. Valid values: 0 to 100.
        # 
        # Default value: 50.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.vserver_group_id is not None:
            result['VServerGroupId'] = self.vserver_group_id
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('VServerGroupId') is not None:
            self.vserver_group_id = m.get('VServerGroupId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class CreateScalingGroupRequestVServerGroups(TeaModel):
    def __init__(
        self,
        load_balancer_id: str = None,
        vserver_group_attributes: List[CreateScalingGroupRequestVServerGroupsVServerGroupAttributes] = None,
    ):
        # The ID of the CLB instance to which the backend vServer group belongs.
        self.load_balancer_id = load_balancer_id
        # The attributes of the backend vServer group.
        self.vserver_group_attributes = vserver_group_attributes

    def validate(self):
        if self.vserver_group_attributes:
            for k in self.vserver_group_attributes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.load_balancer_id is not None:
            result['LoadBalancerId'] = self.load_balancer_id
        result['VServerGroupAttributes'] = []
        if self.vserver_group_attributes is not None:
            for k in self.vserver_group_attributes:
                result['VServerGroupAttributes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LoadBalancerId') is not None:
            self.load_balancer_id = m.get('LoadBalancerId')
        self.vserver_group_attributes = []
        if m.get('VServerGroupAttributes') is not None:
            for k in m.get('VServerGroupAttributes'):
                temp_model = CreateScalingGroupRequestVServerGroupsVServerGroupAttributes()
                self.vserver_group_attributes.append(temp_model.from_map(k))
        return self


class CreateScalingGroupRequest(TeaModel):
    def __init__(
        self,
        alb_server_groups: List[CreateScalingGroupRequestAlbServerGroups] = None,
        allocation_strategy: str = None,
        az_balance: bool = None,
        capacity_options: CreateScalingGroupRequestCapacityOptions = None,
        client_token: str = None,
        compensate_with_on_demand: bool = None,
        container_group_id: str = None,
        custom_policy_arn: str = None,
        dbinstance_ids: str = None,
        dbinstances: List[CreateScalingGroupRequestDBInstances] = None,
        default_cooldown: int = None,
        desired_capacity: int = None,
        group_deletion_protection: bool = None,
        group_type: str = None,
        health_check_type: str = None,
        health_check_types: List[str] = None,
        instance_id: str = None,
        launch_template_id: str = None,
        launch_template_overrides: List[CreateScalingGroupRequestLaunchTemplateOverrides] = None,
        launch_template_version: str = None,
        lifecycle_hooks: List[CreateScalingGroupRequestLifecycleHooks] = None,
        load_balancer_configs: List[CreateScalingGroupRequestLoadBalancerConfigs] = None,
        load_balancer_ids: str = None,
        max_instance_lifetime: int = None,
        max_size: int = None,
        min_size: int = None,
        multi_azpolicy: str = None,
        on_demand_base_capacity: int = None,
        on_demand_percentage_above_base_capacity: int = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        removal_policies: List[str] = None,
        resource_group_id: str = None,
        resource_owner_account: str = None,
        scaling_group_name: str = None,
        scaling_policy: str = None,
        server_groups: List[CreateScalingGroupRequestServerGroups] = None,
        spot_allocation_strategy: str = None,
        spot_instance_pools: int = None,
        spot_instance_remedy: bool = None,
        stop_instance_timeout: int = None,
        sync_alarm_rule_to_cms: bool = None,
        tags: List[CreateScalingGroupRequestTags] = None,
        vserver_groups: List[CreateScalingGroupRequestVServerGroups] = None,
        v_switch_id: str = None,
        v_switch_ids: List[str] = None,
    ):
        # The Application Load Balancer (ALB) server groups.
        self.alb_server_groups = alb_server_groups
        # The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create the required number of instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only when you set the `MultiAZPolicy` parameter to `COMPOSABLE`. Valid values:
        # 
        # *   priority: Auto Scaling selects instance types based on the specified order of the instance types to create the required number of instances.
        # *   lowestPrice: Auto Scaling selects instance types that have the lowest unit price of vCPUs to create the required number of instances.
        # 
        # Default value: priority.
        self.allocation_strategy = allocation_strategy
        # Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set `MultiAZPolicy` to `COMPOSABLE`. Valid values:
        # 
        # *   true
        # *   false
        # 
        # >  If you set `MultiAZPolicy` to `COMPOSABLE` and enable `AzBalance` to `true`, this setting has an equivalent effect to setting `MultiAZPolicy` to `BALANCE`.
        # 
        # Default value: false.
        self.az_balance = az_balance
        # The capacity options.
        self.capacity_options = capacity_options
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the token, but you must make sure that the token is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length. For more information, see [Ensure idempotence](https://help.aliyun.com/document_detail/25965.html).
        self.client_token = client_token
        # Specifies whether to automatically create pay-as-you-go instances to meet the requirement on the number of ECS instances when the expected capacity of preemptible instances cannot be provided due to reasons such as cost-related issues and insufficient resources. This parameter is available only if you set the MultiAZPolicy parameter to COST_OPTIMIZED. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: true.
        self.compensate_with_on_demand = compensate_with_on_demand
        # The ID of the elastic container instance.
        self.container_group_id = container_group_id
        # The Alibaba Cloud Resource Name (ARN) of the custom scale-in policy (Function). This parameter is available only if you specify CustomPolicy as the first step to remove instances.
        self.custom_policy_arn = custom_policy_arn
        # The IDs of the ApsaraDB RDS instances that you want to associate with the scaling group. The value can be a JSON array that contains multiple ApsaraDB RDS instance IDs. Separate multiple IDs with commas (,).
        # 
        # You can associate only a limited number of ApsaraDB RDS instances with a scaling group. Go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas) to check the maximum number of ApsaraDB RDS instances that you can associate with a scaling group.
        self.dbinstance_ids = dbinstance_ids
        # The databases that you want to attach to the scaling group.
        self.dbinstances = dbinstances
        # The cooldown period of the scaling group after a scaling activity is complete in the scaling group. Valid values: 0 to 86400. Unit: seconds.
        # 
        # During the cooldown period, Auto Scaling does not execute scaling activities that are triggered by CloudMonitor event-triggered tasks.
        # 
        # Default value: 300.
        self.default_cooldown = default_cooldown
        # The expected number of ECS instances in the scaling group. Auto Scaling automatically maintains the specified expected number of ECS instances. The DesiredCapacity value cannot be greater than the MaxSize value or less than the MinSize value.
        self.desired_capacity = desired_capacity
        # Specifies whether to enable deletion protection for the scaling group. Valid values:
        # 
        # *   true: enables deletion protection for the scaling group. This way, the scaling group cannot be deleted.
        # *   false: disables deletion protection for the scaling group.
        # 
        # Default value: false.
        self.group_deletion_protection = group_deletion_protection
        # The type of the instances that are managed by the scaling group. Valid values:
        # 
        # *   ECS: ECS instances.
        # *   ECI: elastic container instances.
        # 
        # Default value: ECS.
        self.group_type = group_type
        # The health check mode of the scaling group. Valid values:
        # 
        # *   NONE: Auto Scaling does not check the health status of instances.
        # *   ECS: Auto Scaling checks the health status of instances in the scaling group. If you want to enable instance health check, you can set the value to ECS, regardless of whether the scaling group is of ECS type or Elastic Container Instance type.
        # *   LOAD_BALANCER: Auto Scaling checks the health status of instances in the scaling group based on the health check results of load balancers. The health check results of Classic Load Balancer (CLB) instances are not supported as the health check basis for instances in the scaling group.
        # 
        # Default value: ECS.
        # 
        # >  If you want to enable instance health check and load balancer health check at the same time, we recommend that you specify `HealthCheckTypes`.
        self.health_check_type = health_check_type
        # The health check mode of the scaling group.
        # 
        # >  You can specify multiple values for this parameter to enable multiple health check options at the same time. If you specify `HealthCheckType`, this parameter is ignored.
        self.health_check_types = health_check_types
        # The ID of the ECS instance. When you create a scaling group, you can specify an existing ECS instance. Auto Scaling obtains the configurations of the ECS instance and automatically creates a scaling configuration from the obtained configurations.
        self.instance_id = instance_id
        # The ID of the launch template that provides instance configurations for Auto Scaling to create instances.
        self.launch_template_id = launch_template_id
        # Details of the instance types that you specify by using the Extended Configurations feature of the launch template.
        self.launch_template_overrides = launch_template_overrides
        # The version number of the launch template. Valid values:
        # 
        # *   A fixed template version number.
        # *   Default: the default template version.
        # *   Latest: the latest template version.
        self.launch_template_version = launch_template_version
        # The lifecycle hooks.
        self.lifecycle_hooks = lifecycle_hooks
        # The load balancer configurations.
        self.load_balancer_configs = load_balancer_configs
        # The IDs of the CLB instances that you want to associate with the scaling group. The value can be a JSON array that contains multiple CLB instance IDs. Separate multiple IDs with commas (,).
        # 
        # You can associate only a limited number of CLB instances with a scaling group. Go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas) to check the maximum number of CLB instances that you can associate with a scaling group.
        self.load_balancer_ids = load_balancer_ids
        # The maximum life span of an instance in the scaling group. Unit: seconds.
        # 
        # Valid values: 86400 to the value of the Integer.maxValue parameter.
        # 
        # Default value: null.
        self.max_instance_lifetime = max_instance_lifetime
        # The maximum number of instances that can be contained in the scaling group. When the total number of ECS instances in the scaling group exceeds the value of MaxSize, Auto Scaling automatically removes ECS instances from the scaling group until the total number equals the maximum number.
        # 
        # The value range of MaxSize is directly correlated with the degree of dependency your business has on Auto Scaling. You can go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas) to check **the maximum number of instances that a single scaling group can contain.**\
        # 
        # If **a single scaling group can contain up to 2,000 ECS instances**, the value range of MaxSize is 0 to 2,000.
        # 
        # This parameter is required.
        self.max_size = max_size
        # The minimum number of instances that must be contained in the scaling group. When the total number of ECS instances in the scaling group is less than the value of MinSize, Auto Scaling automatically creates ECS instances in the scaling group until the total number reaches the minimum number.
        # 
        # >  The value of MinSize must be less than or equal to the value of MaxSize.
        # 
        # This parameter is required.
        self.min_size = min_size
        # The scaling policy for ECS instances in the multi-zone scaling group. Valid values:
        # 
        # *   PRIORITY: scale ECS instances based on the priority of the vSwitches specified by VSwitchIds. Auto Scaling preferentially scales instances in the zone where the vSwitch of the highest priority resides. If the scaling fails, Auto Scaling scales instances in the zone where the vSwitch of the next highest priority resides.
        # 
        # *   COST_OPTIMIZED: create ECS instances that have the lowest unit price of vCPUs during scale-out events and removes ECS instances that have the highest unit price of vCPUs during scale-in events. If you specify preemptible instance types in your scaling configuration, Auto Scaling will preferentially create preemptible instances. You can also specify CompensateWithOnDemand to allow Auto Scaling to create pay-as-you-go instances in the case that preemptible instances cannot be created due to limited stock.
        # 
        #     **\
        # 
        #     **Note** The COST_OPTIMIZED setting takes effect only when your scaling configuration contains multiple instance types or specifically contains preemptible instance types.
        # 
        # *   BALANCE: evenly distribute ECS instances across the zones that are specified for the scaling group. If ECS instances are unevenly distributed across the specified zones due to insufficient inventory, you can call the [RebalanceInstance](https://help.aliyun.com/document_detail/71516.html) operation to evenly distribute the instances across the zones.
        # 
        #     **\
        # 
        #     **Note** When you set `MultiAZPolicy` to `BALANCE`, this setting has an equivalent effect to setting `MultiAZPolicy` to `COMPOSABLE` and enabling `AzBalance` to `true`.
        # 
        # *   COMPOSABLE: combine the preceding policies into a custom scaling policy based on your business requirements. Alternatively, you can specify custom parameters to finely control the capacity of the scaling group.
        # 
        # Default value: PRIORITY.
        self.multi_azpolicy = multi_azpolicy
        # The minimum number of pay-as-you-go instances that must be contained in the scaling group. Valid values: 0 to 1000. If the number of pay-as-you-go instances is less than the value of this parameter, Auto Scaling preferentially creates pay-as-you-go instances.
        self.on_demand_base_capacity = on_demand_base_capacity
        # The percentage of pay-as-you-go instances in the excess instances when the minimum number of pay-as-you-go instances reaches the requirement. Valid values: 0 to 100.
        self.on_demand_percentage_above_base_capacity = on_demand_percentage_above_base_capacity
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region ID of the scaling group.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The instance removal policies. Valid values:
        # 
        # *   OldestInstance: removes ECS instances that are added at the earliest point in time to the scaling group.
        # *   NewestInstance: removes ECS instances that are most recently added to the scaling group.
        # *   OldestScalingConfiguration: removes ECS instances that are created based on the earliest scaling configuration.
        # *   CustomPolicy: removes ECS instances based on the custom scale-in policy (Function).
        # 
        # The scaling configuration source specified by the OldestScalingConfiguration setting can be a scaling configuration or a launch template. The CustomPolicy setting takes effect only if you specify it as the first step to remove instances. If you specify CustomPolicy, you must also specify the CustomPolicyARN parameter.
        # 
        # > The removal of ECS instances from a scaling group is also affected by the value of the MultiAZPolicy parameter. For more information, see the [Configure a combination policy for removing instances](https://help.aliyun.com/document_detail/254822.html) topic.
        self.removal_policies = removal_policies
        # The ID of the resource group to which you want to add the scaling group.
        # 
        # > If you specify this parameter, new scaling groups are added to the specified resource group. If you do not specify this parameter, new scaling groups are added to the default resource group.
        self.resource_group_id = resource_group_id
        self.resource_owner_account = resource_owner_account
        # The name of the scaling group. The name of each scaling group must be unique in a region.
        # 
        # The name must be 2 to 64 characters in length, and can contain letters, digits, underscores (_), hyphens (-), and periods (.). The name must start with a letter or a digit.
        # 
        # If you do not specify this parameter, the value of the ScalingGroupId parameter is used.
        self.scaling_group_name = scaling_group_name
        # The reclaim mode of the scaling group. Valid values:
        # 
        # *   recycle: the economical mode
        # 
        # *   release: the release mode
        # 
        # *   forcerelease: the forced release mode
        # 
        #     **\
        # 
        #     **Note** If you set the value to forcerelease, Auto Scaling will forcibly release the ECS instances that are in the `Running` state during the scale-out events. Forced release equates to an immediate power-off, resulting in the irreversible deletion of all ephemeral data stored on the instance. Once executed, this action cannot be undone and the lost data cannot be recovered. Exercise caution when you select this option.
        # 
        # *   forcerecycle: the forced recycle mode
        # 
        #     **\
        # 
        #     **Note** If you set the value to forcerecycle, Auto Scaling will forcibly shut down the ECS instances that are in the `Running` state during the scale-out events. Forced recycle equates to an immediate power-off, resulting in the irreversible deletion of all ephemeral data stored on the instance. Once executed, this action cannot be undone and the lost data cannot be recovered. Exercise caution when you select this option.
        # 
        # ScalingPolicy specifies the reclaim mode of the scaling group. RemovePolicy of the RemoveInstances operation specifies the specific instance removal action. For more information, see [RemoveInstances](https://help.aliyun.com/document_detail/25955.html).
        self.scaling_policy = scaling_policy
        # The server groups.
        # 
        # >  You cannot use AlbServerGroups and ServerGroups to specify the same server group.
        self.server_groups = server_groups
        # The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy of preemptible instances. This parameter takes effect only if you set the `MultiAZPolicy` parameter to `COMPOSABLE`. Valid values:
        # 
        # *   priority: Auto Scaling selects instance types based on the specified order of the instance types to create the required number of preemptible instances.
        # *   lowestPrice: Auto Scaling selects instance types that have the lowest unit price of vCPUs to create the required number of preemptible instances.
        # 
        # Default value: priority.
        self.spot_allocation_strategy = spot_allocation_strategy
        # The number of available instance types. Auto Scaling evenly creates preemptible instances of multiple instance types that are provided at the lowest cost in the scaling group. Valid values: 1 to 10.
        self.spot_instance_pools = spot_instance_pools
        # Specifies whether to supplement preemptible instances. If you set this parameter to true, Auto Scaling creates an instance to replace a preemptible instance when Auto Scaling receives a system message which indicates that the preemptible instance is to be reclaimed.
        self.spot_instance_remedy = spot_instance_remedy
        # The period of time required by the ECS instance to enter the Stopped state. Unit: seconds. Valid values: 30 to 240.
        # 
        # > 
        # 
        # *   This parameter takes effect only if you set ScalingPolicy to release.
        # 
        # *   If you specify this parameter, the system will wait for the ECS instance to enter the Stopped state for the specified period of time before continuing with the scale-in operation, regardless of the status of the ECS instance.
        # 
        # *   If you do not specify this parameter, the system will wait for the ECS instance to stop before continuing with the scale-in operation. If the ECS instance is not successfully stopped, the scale-in process will be rolled back and considered failed.
        self.stop_instance_timeout = stop_instance_timeout
        # > This parameter is unavailable.
        self.sync_alarm_rule_to_cms = sync_alarm_rule_to_cms
        # The tags that you want to add to the scaling group.
        self.tags = tags
        # The backend vServer group that you want to associate with the scaling group.
        self.vserver_groups = vserver_groups
        # The ID of the vSwitch. If you specify the VSwitchId parameter, the network type of the scaling group is VPC.
        # 
        # > If you do not specify the VSwitchId or VSwitchIds parameter, the network type of the scaling group is classic network.
        self.v_switch_id = v_switch_id
        # The IDs of the vSwitches. If you specify VSwitchIds, VSwitchId is ignored. If you specify VSwitchIds, the network type of the scaling group is VPC.
        # 
        # If you specify multiple vSwitches, take note of the following items:
        # 
        # *   The vSwitches must belong to the same VPC.
        # *   The vSwitches can belong to different zones.
        # *   vSwitches are sorted in ascending order based on their priorities. The first vSwitch has the highest priority. If Auto Scaling fails to create ECS instances in the zone where the vSwitch of the highest priority resides, Auto Scaling attempts to create ECS instances in the zone where the vSwitch of the next highest priority resides.
        # 
        # >  If you do not specify VSwitchId or VSwitchIds for your scaling group, the network type of the scaling group is classic network.
        self.v_switch_ids = v_switch_ids

    def validate(self):
        if self.alb_server_groups:
            for k in self.alb_server_groups:
                if k:
                    k.validate()
        if self.capacity_options:
            self.capacity_options.validate()
        if self.dbinstances:
            for k in self.dbinstances:
                if k:
                    k.validate()
        if self.launch_template_overrides:
            for k in self.launch_template_overrides:
                if k:
                    k.validate()
        if self.lifecycle_hooks:
            for k in self.lifecycle_hooks:
                if k:
                    k.validate()
        if self.load_balancer_configs:
            for k in self.load_balancer_configs:
                if k:
                    k.validate()
        if self.server_groups:
            for k in self.server_groups:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.vserver_groups:
            for k in self.vserver_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlbServerGroups'] = []
        if self.alb_server_groups is not None:
            for k in self.alb_server_groups:
                result['AlbServerGroups'].append(k.to_map() if k else None)
        if self.allocation_strategy is not None:
            result['AllocationStrategy'] = self.allocation_strategy
        if self.az_balance is not None:
            result['AzBalance'] = self.az_balance
        if self.capacity_options is not None:
            result['CapacityOptions'] = self.capacity_options.to_map()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.compensate_with_on_demand is not None:
            result['CompensateWithOnDemand'] = self.compensate_with_on_demand
        if self.container_group_id is not None:
            result['ContainerGroupId'] = self.container_group_id
        if self.custom_policy_arn is not None:
            result['CustomPolicyARN'] = self.custom_policy_arn
        if self.dbinstance_ids is not None:
            result['DBInstanceIds'] = self.dbinstance_ids
        result['DBInstances'] = []
        if self.dbinstances is not None:
            for k in self.dbinstances:
                result['DBInstances'].append(k.to_map() if k else None)
        if self.default_cooldown is not None:
            result['DefaultCooldown'] = self.default_cooldown
        if self.desired_capacity is not None:
            result['DesiredCapacity'] = self.desired_capacity
        if self.group_deletion_protection is not None:
            result['GroupDeletionProtection'] = self.group_deletion_protection
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.health_check_type is not None:
            result['HealthCheckType'] = self.health_check_type
        if self.health_check_types is not None:
            result['HealthCheckTypes'] = self.health_check_types
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateOverrides'] = []
        if self.launch_template_overrides is not None:
            for k in self.launch_template_overrides:
                result['LaunchTemplateOverrides'].append(k.to_map() if k else None)
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        result['LifecycleHooks'] = []
        if self.lifecycle_hooks is not None:
            for k in self.lifecycle_hooks:
                result['LifecycleHooks'].append(k.to_map() if k else None)
        result['LoadBalancerConfigs'] = []
        if self.load_balancer_configs is not None:
            for k in self.load_balancer_configs:
                result['LoadBalancerConfigs'].append(k.to_map() if k else None)
        if self.load_balancer_ids is not None:
            result['LoadBalancerIds'] = self.load_balancer_ids
        if self.max_instance_lifetime is not None:
            result['MaxInstanceLifetime'] = self.max_instance_lifetime
        if self.max_size is not None:
            result['MaxSize'] = self.max_size
        if self.min_size is not None:
            result['MinSize'] = self.min_size
        if self.multi_azpolicy is not None:
            result['MultiAZPolicy'] = self.multi_azpolicy
        if self.on_demand_base_capacity is not None:
            result['OnDemandBaseCapacity'] = self.on_demand_base_capacity
        if self.on_demand_percentage_above_base_capacity is not None:
            result['OnDemandPercentageAboveBaseCapacity'] = self.on_demand_percentage_above_base_capacity
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.removal_policies is not None:
            result['RemovalPolicies'] = self.removal_policies
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_name is not None:
            result['ScalingGroupName'] = self.scaling_group_name
        if self.scaling_policy is not None:
            result['ScalingPolicy'] = self.scaling_policy
        result['ServerGroups'] = []
        if self.server_groups is not None:
            for k in self.server_groups:
                result['ServerGroups'].append(k.to_map() if k else None)
        if self.spot_allocation_strategy is not None:
            result['SpotAllocationStrategy'] = self.spot_allocation_strategy
        if self.spot_instance_pools is not None:
            result['SpotInstancePools'] = self.spot_instance_pools
        if self.spot_instance_remedy is not None:
            result['SpotInstanceRemedy'] = self.spot_instance_remedy
        if self.stop_instance_timeout is not None:
            result['StopInstanceTimeout'] = self.stop_instance_timeout
        if self.sync_alarm_rule_to_cms is not None:
            result['SyncAlarmRuleToCms'] = self.sync_alarm_rule_to_cms
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        result['VServerGroups'] = []
        if self.vserver_groups is not None:
            for k in self.vserver_groups:
                result['VServerGroups'].append(k.to_map() if k else None)
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alb_server_groups = []
        if m.get('AlbServerGroups') is not None:
            for k in m.get('AlbServerGroups'):
                temp_model = CreateScalingGroupRequestAlbServerGroups()
                self.alb_server_groups.append(temp_model.from_map(k))
        if m.get('AllocationStrategy') is not None:
            self.allocation_strategy = m.get('AllocationStrategy')
        if m.get('AzBalance') is not None:
            self.az_balance = m.get('AzBalance')
        if m.get('CapacityOptions') is not None:
            temp_model = CreateScalingGroupRequestCapacityOptions()
            self.capacity_options = temp_model.from_map(m['CapacityOptions'])
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CompensateWithOnDemand') is not None:
            self.compensate_with_on_demand = m.get('CompensateWithOnDemand')
        if m.get('ContainerGroupId') is not None:
            self.container_group_id = m.get('ContainerGroupId')
        if m.get('CustomPolicyARN') is not None:
            self.custom_policy_arn = m.get('CustomPolicyARN')
        if m.get('DBInstanceIds') is not None:
            self.dbinstance_ids = m.get('DBInstanceIds')
        self.dbinstances = []
        if m.get('DBInstances') is not None:
            for k in m.get('DBInstances'):
                temp_model = CreateScalingGroupRequestDBInstances()
                self.dbinstances.append(temp_model.from_map(k))
        if m.get('DefaultCooldown') is not None:
            self.default_cooldown = m.get('DefaultCooldown')
        if m.get('DesiredCapacity') is not None:
            self.desired_capacity = m.get('DesiredCapacity')
        if m.get('GroupDeletionProtection') is not None:
            self.group_deletion_protection = m.get('GroupDeletionProtection')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('HealthCheckType') is not None:
            self.health_check_type = m.get('HealthCheckType')
        if m.get('HealthCheckTypes') is not None:
            self.health_check_types = m.get('HealthCheckTypes')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        self.launch_template_overrides = []
        if m.get('LaunchTemplateOverrides') is not None:
            for k in m.get('LaunchTemplateOverrides'):
                temp_model = CreateScalingGroupRequestLaunchTemplateOverrides()
                self.launch_template_overrides.append(temp_model.from_map(k))
        if m.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = m.get('LaunchTemplateVersion')
        self.lifecycle_hooks = []
        if m.get('LifecycleHooks') is not None:
            for k in m.get('LifecycleHooks'):
                temp_model = CreateScalingGroupRequestLifecycleHooks()
                self.lifecycle_hooks.append(temp_model.from_map(k))
        self.load_balancer_configs = []
        if m.get('LoadBalancerConfigs') is not None:
            for k in m.get('LoadBalancerConfigs'):
                temp_model = CreateScalingGroupRequestLoadBalancerConfigs()
                self.load_balancer_configs.append(temp_model.from_map(k))
        if m.get('LoadBalancerIds') is not None:
            self.load_balancer_ids = m.get('LoadBalancerIds')
        if m.get('MaxInstanceLifetime') is not None:
            self.max_instance_lifetime = m.get('MaxInstanceLifetime')
        if m.get('MaxSize') is not None:
            self.max_size = m.get('MaxSize')
        if m.get('MinSize') is not None:
            self.min_size = m.get('MinSize')
        if m.get('MultiAZPolicy') is not None:
            self.multi_azpolicy = m.get('MultiAZPolicy')
        if m.get('OnDemandBaseCapacity') is not None:
            self.on_demand_base_capacity = m.get('OnDemandBaseCapacity')
        if m.get('OnDemandPercentageAboveBaseCapacity') is not None:
            self.on_demand_percentage_above_base_capacity = m.get('OnDemandPercentageAboveBaseCapacity')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemovalPolicies') is not None:
            self.removal_policies = m.get('RemovalPolicies')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupName') is not None:
            self.scaling_group_name = m.get('ScalingGroupName')
        if m.get('ScalingPolicy') is not None:
            self.scaling_policy = m.get('ScalingPolicy')
        self.server_groups = []
        if m.get('ServerGroups') is not None:
            for k in m.get('ServerGroups'):
                temp_model = CreateScalingGroupRequestServerGroups()
                self.server_groups.append(temp_model.from_map(k))
        if m.get('SpotAllocationStrategy') is not None:
            self.spot_allocation_strategy = m.get('SpotAllocationStrategy')
        if m.get('SpotInstancePools') is not None:
            self.spot_instance_pools = m.get('SpotInstancePools')
        if m.get('SpotInstanceRemedy') is not None:
            self.spot_instance_remedy = m.get('SpotInstanceRemedy')
        if m.get('StopInstanceTimeout') is not None:
            self.stop_instance_timeout = m.get('StopInstanceTimeout')
        if m.get('SyncAlarmRuleToCms') is not None:
            self.sync_alarm_rule_to_cms = m.get('SyncAlarmRuleToCms')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = CreateScalingGroupRequestTags()
                self.tags.append(temp_model.from_map(k))
        self.vserver_groups = []
        if m.get('VServerGroups') is not None:
            for k in m.get('VServerGroups'):
                temp_model = CreateScalingGroupRequestVServerGroups()
                self.vserver_groups.append(temp_model.from_map(k))
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        return self


class CreateScalingGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_group_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class CreateScalingGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateScalingGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScalingRuleRequestAlarmDimensions(TeaModel):
    def __init__(
        self,
        dimension_key: str = None,
        dimension_value: str = None,
    ):
        # The dimension key of the metric.
        self.dimension_key = dimension_key
        # The dimension value of the metric.
        self.dimension_value = dimension_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension_key is not None:
            result['DimensionKey'] = self.dimension_key
        if self.dimension_value is not None:
            result['DimensionValue'] = self.dimension_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DimensionKey') is not None:
            self.dimension_key = m.get('DimensionKey')
        if m.get('DimensionValue') is not None:
            self.dimension_value = m.get('DimensionValue')
        return self


class CreateScalingRuleRequestAlarmOptions(TeaModel):
    def __init__(
        self,
        period: int = None,
    ):
        self.period = period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.period is not None:
            result['Period'] = self.period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Period') is not None:
            self.period = m.get('Period')
        return self


class CreateScalingRuleRequestHybridMetricsDimensions(TeaModel):
    def __init__(
        self,
        dimension_key: str = None,
        dimension_value: str = None,
    ):
        # The key of the metric dimension.
        self.dimension_key = dimension_key
        # The value of the metric dimension.
        self.dimension_value = dimension_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension_key is not None:
            result['DimensionKey'] = self.dimension_key
        if self.dimension_value is not None:
            result['DimensionValue'] = self.dimension_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DimensionKey') is not None:
            self.dimension_key = m.get('DimensionKey')
        if m.get('DimensionValue') is not None:
            self.dimension_value = m.get('DimensionValue')
        return self


class CreateScalingRuleRequestHybridMetrics(TeaModel):
    def __init__(
        self,
        dimensions: List[CreateScalingRuleRequestHybridMetricsDimensions] = None,
        expression: str = None,
        id: str = None,
        metric_name: str = None,
        statistic: str = None,
    ):
        # The metric dimensions. You can use this parameter to specify the monitored resources.
        self.dimensions = dimensions
        # The metric expression that consists of multiple Hybrid Cloud Monitoring metrics. It calculates a result used to trigger scaling events.
        # 
        # The expression must be written in Reverse Polish Notation (RPN) format and supports only the following operators: `+, -, *, /`.
        self.expression = expression
        # The reference ID of the metric in the metric expression.
        self.id = id
        # The name of the Hybrid Cloud Monitoring metric.
        self.metric_name = metric_name
        # The statistical method of the metric value. Valid values:
        # 
        # *   Average: calculates the average value of all metric values within a specified interval.
        # *   Minimum: calculates the minimum value of all metric values within a specified interval.
        # *   Maximum: calculates the maximum value of all metric values within a specified interval.
        self.statistic = statistic

    def validate(self):
        if self.dimensions:
            for k in self.dimensions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Dimensions'] = []
        if self.dimensions is not None:
            for k in self.dimensions:
                result['Dimensions'].append(k.to_map() if k else None)
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.id is not None:
            result['Id'] = self.id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.statistic is not None:
            result['Statistic'] = self.statistic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dimensions = []
        if m.get('Dimensions') is not None:
            for k in m.get('Dimensions'):
                temp_model = CreateScalingRuleRequestHybridMetricsDimensions()
                self.dimensions.append(temp_model.from_map(k))
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Statistic') is not None:
            self.statistic = m.get('Statistic')
        return self


class CreateScalingRuleRequestStepAdjustments(TeaModel):
    def __init__(
        self,
        metric_interval_lower_bound: float = None,
        metric_interval_upper_bound: float = None,
        scaling_adjustment: int = None,
    ):
        # The lower limit specified in a step adjustment. This parameter is available only if you set the ScalingRuleType parameter to StepScalingRule. Valid values: -9.999999E18 to 9.999999E18.
        self.metric_interval_lower_bound = metric_interval_lower_bound
        # The upper limit that is specified in a step adjustment. Valid values: -9.999999E18 to 9.999999E18.
        self.metric_interval_upper_bound = metric_interval_upper_bound
        # The number of ECS instances that you want to scale in a step adjustment. This parameter is available only if you set the ScalingRuleType parameter to StepScalingRule.
        self.scaling_adjustment = scaling_adjustment

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_interval_lower_bound is not None:
            result['MetricIntervalLowerBound'] = self.metric_interval_lower_bound
        if self.metric_interval_upper_bound is not None:
            result['MetricIntervalUpperBound'] = self.metric_interval_upper_bound
        if self.scaling_adjustment is not None:
            result['ScalingAdjustment'] = self.scaling_adjustment
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricIntervalLowerBound') is not None:
            self.metric_interval_lower_bound = m.get('MetricIntervalLowerBound')
        if m.get('MetricIntervalUpperBound') is not None:
            self.metric_interval_upper_bound = m.get('MetricIntervalUpperBound')
        if m.get('ScalingAdjustment') is not None:
            self.scaling_adjustment = m.get('ScalingAdjustment')
        return self


class CreateScalingRuleRequest(TeaModel):
    def __init__(
        self,
        adjustment_type: str = None,
        adjustment_value: int = None,
        alarm_dimensions: List[CreateScalingRuleRequestAlarmDimensions] = None,
        alarm_options: CreateScalingRuleRequestAlarmOptions = None,
        cooldown: int = None,
        disable_scale_in: bool = None,
        estimated_instance_warmup: int = None,
        hybrid_metrics: List[CreateScalingRuleRequestHybridMetrics] = None,
        hybrid_monitor_namespace: str = None,
        initial_max_size: int = None,
        metric_name: str = None,
        metric_type: str = None,
        min_adjustment_magnitude: int = None,
        owner_account: str = None,
        owner_id: int = None,
        predictive_scaling_mode: str = None,
        predictive_task_buffer_time: int = None,
        predictive_value_behavior: str = None,
        predictive_value_buffer: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scale_in_evaluation_count: int = None,
        scale_out_evaluation_count: int = None,
        scaling_group_id: str = None,
        scaling_rule_name: str = None,
        scaling_rule_type: str = None,
        step_adjustments: List[CreateScalingRuleRequestStepAdjustments] = None,
        target_value: float = None,
    ):
        # The scaling method of the scaling rule. This parameter is required only if you set the ScalingRuleType parameter to SimpleScalingRule or StepScalingRule. Valid values:
        # 
        # *   QuantityChangeInCapacity: adds the specified number of ECS instances to or removes the specified number of ECS instances from the scaling group.
        # *   PercentChangeInCapacity: adds the specified percentage of ECS instances to or removes the specified percentage of ECS instances from the scaling group.
        # *   TotalCapacity: adjusts the number of ECS instances in the scaling group to a specified number.
        self.adjustment_type = adjustment_type
        # The number of instances that must be scaled based on the scaling rule. This parameter is required only if you set the ScalingRuleType parameter to SimpleScalingRule or StepScalingRule. The number of ECS instances that are scaled in a single scaling activity cannot exceed 1,000.
        # 
        # *   Valid values if you set the AdjustmentType parameter to QuantityChangeInCapacity: -1000 to 1000.
        # *   Valid values if you set the AdjustmentType parameter to PercentChangeInCapacity: -100 to 10000.
        # *   Valid values if you set the AdjustmentType parameter to TotalCapacity: 0 to 2000.
        self.adjustment_value = adjustment_value
        # The metric dimensions. This parameter is applicable to target tracking scaling rules. If your predefined metric requires extra dimensions, you must specify this parameter. For example, if you use LoadBalancerRealServerAverageQps as your predefined metric, you must use this parameter to specify the rulePool dimension.
        self.alarm_dimensions = alarm_dimensions
        self.alarm_options = alarm_options
        # The cooldown time of the scaling rule. This parameter is available only if you set the ScalingRuleType parameter to SimpleScalingRule. Valid values: 0 to 86400. Unit: seconds.
        # 
        # By default, this parameter is left empty.
        self.cooldown = cooldown
        # Specifies whether to disable scale-in. This parameter is available only if you set ScalingRuleType to TargetTrackingScalingRule.
        # 
        # Default value: false.
        self.disable_scale_in = disable_scale_in
        # The warmup period of an instance. This parameter is available only if you set the ScalingRuleType parameter to TargetTrackingScalingRule or PredictiveScalingRule. Auto Scaling adds ECS instances that are in the warmup state to a scaling group but does not report monitoring data to CloudMonitor during the warmup period.
        # 
        # > Auto Scaling calculates the number of ECS instances that must be scaled. ECS instances in the warmup state are not counted towards the current capacity of the scaling group.
        # 
        # Valid values: 0 to 86400. Unit: seconds.
        # 
        # Default value: 300.
        self.estimated_instance_warmup = estimated_instance_warmup
        # The Hybrid Cloud Monitoring metrics. For more information, see [Create a custom target tracking scaling rule](https://help.aliyun.com/document_detail/2852162.html).
        self.hybrid_metrics = hybrid_metrics
        # The ID of the Hybrid Cloud Monitoring namespace.
        # 
        # For information about how to manage Hybrid Cloud Monitoring namespaces, see [Manage namespaces](https://help.aliyun.com/document_detail/217606.html).
        self.hybrid_monitor_namespace = hybrid_monitor_namespace
        # The maximum number of ECS instances that can be contained in the scaling group. If you specify InitialMaxSize, you must specify `PredictiveValueBehavior`.
        # 
        # The default value of this parameter is the value of MaxSize.
        self.initial_max_size = initial_max_size
        # The predefined metric that you want to monitor. If you set ScalingRuleType to TargetTrackingScalingRule or PredictiveScalingRule, you must specify this parameter.
        # 
        # Valid values if you set ScalingRuleType to TargetTrackingScalingRule:
        # 
        # *   CpuUtilizationAgent (recommended): the CPU utilization.
        # *   MemoryUtilization (recommended): the memory usage.
        # *   CpuUtilization: the average CPU utilization.
        # *   IntranetTx: the outbound traffic over an internal network.
        # *   IntranetRx: the average inbound traffic over an internal network.
        # *   VpcInternetTx: the outbound traffic from a virtual private cloud (VPC) to the Internet.
        # *   VpcInternetRx: the inbound traffic from the Internet to a VPC.
        # *   LoadBalancerRealServerAverageQps:the queries per second (QPS) per Application Load Balancer (ALB) server group.
        # 
        # Valid values if you set ScalingRuleType to PredictiveScalingRule:
        # 
        # *   CpuUtilization: the average CPU utilization.
        # *   IntranetRx: the average inbound traffic over an internal network.
        # *   IntranetTx: the average outbound traffic over an internal network.
        # 
        # For more information, see [Event-triggered tasks of the system monitoring type](https://help.aliyun.com/document_detail/74854.html).
        self.metric_name = metric_name
        # The metric type. Valid values:
        # 
        # *   system: system metrics of CloudMonitor.
        # *   custom: custom metrics that are reported to CloudMonitor.
        # *   hybrid: metrics of Hybrid Cloud Monitoring.
        self.metric_type = metric_type
        # The minimum number of instances that must be scaled when the AdjustmentType parameter is set to PercentChangeInCapacity. This parameter takes effect only if you set the ScalingRuleType parameter to SimpleScalingRule or StepScalingRule.
        self.min_adjustment_magnitude = min_adjustment_magnitude
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The mode of the predictive scaling rule. Valid values:
        # 
        # *   PredictAndScale: produces predictions and creates prediction tasks.
        # *   PredictOnly: produces predictions but does not create prediction tasks.
        # 
        # Default value: PredictAndScale.
        self.predictive_scaling_mode = predictive_scaling_mode
        # The amount of buffer time before the prediction task is executed. By default, all prediction tasks that are automatically created for a predictive scaling rule are executed on the hour. You can specify an amount of buffer time for resource preparation before the prediction tasks are executed. Valid values: 0 to 60. Unit: minutes.
        # 
        # Default value: 0.
        self.predictive_task_buffer_time = predictive_task_buffer_time
        # The maximum value for predication tasks. Valid values:
        # 
        # *   MaxOverridePredictiveValue: uses the initial maximum capacity as the maximum value for prediction tasks if the predicted value is greater than the initial maximum capacity.
        # *   PredictiveValueOverrideMax: uses the predicted value as the maximum value for prediction tasks if the predicted value is greater than the initial maximum capacity.
        # *   PredictiveValueOverrideMaxWithBuffer: increases the predicted value by a percentage that is specified by the PredictiveValueBuffer parameter. If the predicted value that is increased by the percentage is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks.
        # 
        # Default value: MaxOverridePredictiveValue.
        self.predictive_value_behavior = predictive_value_behavior
        # The ratio based on which the predicted value is increased when you set `PredictiveValueBehavior` to `PredictiveValueOverrideMaxWithBuffer`. If the predicted value increased by this ratio is greater than the initial maximum capacity, the increased value is used as the maximum value for prediction tasks. Valid values: 0 to 100.
        # 
        # Default value: 0.
        self.predictive_value_buffer = predictive_value_buffer
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The number of consecutive times that the event-triggered task created for scale-in activities must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and then associated with the target tracking scaling rule.
        # 
        # Default value: 15.
        self.scale_in_evaluation_count = scale_in_evaluation_count
        # The number of consecutive times that the event-triggered task created for scale-out activities must meet the threshold conditions before an alert is triggered. After a target tracking scaling rule is created, an event-triggered task is automatically created and then associated with the target tracking scaling rule.
        # 
        # Default value: 3.
        self.scale_out_evaluation_count = scale_out_evaluation_count
        # The ID of the scaling group to which the scaling rule belongs.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id
        # The name of the scaling rule. The name must be 2 to 64 characters in length, and can contain letters, digits, underscores (_), hyphens (-), and periods (.). The name must start with a letter or a digit.
        # 
        # The name of each scaling rule must be unique under the same account within a region.
        # 
        # If you leave this parameter empty, the scaling rule ID is used.
        self.scaling_rule_name = scaling_rule_name
        # The type of the scaling rule. Valid values:
        # 
        # *   SimpleScalingRule: a simple scaling rule. After you execute a simple scaling rule, Auto Scaling adjusts the number of ECS instances or elastic container instances in the scaling group based on the values of AdjustmentType and AdjustmentValue.
        # *   TargetTrackingScalingRule: a target tracking scaling rule. After you execute a target tracking scaling rule, Auto Scaling dynamically calculates the number of ECS instances or elastic container instances to scale based on the predefined metric (MetricName) and attempts to maintain the metric value close to the expected value (TargetValue).
        # *   StepScalingRule: a step scaling rule. After you execute a step scaling rule, Auto Scaling scales instances step by step based on the predefined thresholds and metric values.
        # *   PredictiveScalingRule: a predictive scaling rule. After you execute a predictive scaling rule, Auto Scaling uses machine learning to analyze historical monitoring data of the scaling group and predicts the future values of metrics. In addition, Auto Scaling automatically creates scheduled tasks to adjust the boundary values for the scaling group.
        # 
        # Default value: SimpleScalingRule.
        self.scaling_rule_type = scaling_rule_type
        # Details of the step adjustments.
        self.step_adjustments = step_adjustments
        # The target value. This parameter is required only if you set the ScalingRuleType parameter to TargetTrackingScalingRule or PredictiveScalingRule. The value must be greater than 0 and can have up to three decimal places.
        self.target_value = target_value

    def validate(self):
        if self.alarm_dimensions:
            for k in self.alarm_dimensions:
                if k:
                    k.validate()
        if self.alarm_options:
            self.alarm_options.validate()
        if self.hybrid_metrics:
            for k in self.hybrid_metrics:
                if k:
                    k.validate()
        if self.step_adjustments:
            for k in self.step_adjustments:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjustment_type is not None:
            result['AdjustmentType'] = self.adjustment_type
        if self.adjustment_value is not None:
            result['AdjustmentValue'] = self.adjustment_value
        result['AlarmDimensions'] = []
        if self.alarm_dimensions is not None:
            for k in self.alarm_dimensions:
                result['AlarmDimensions'].append(k.to_map() if k else None)
        if self.alarm_options is not None:
            result['AlarmOptions'] = self.alarm_options.to_map()
        if self.cooldown is not None:
            result['Cooldown'] = self.cooldown
        if self.disable_scale_in is not None:
            result['DisableScaleIn'] = self.disable_scale_in
        if self.estimated_instance_warmup is not None:
            result['EstimatedInstanceWarmup'] = self.estimated_instance_warmup
        result['HybridMetrics'] = []
        if self.hybrid_metrics is not None:
            for k in self.hybrid_metrics:
                result['HybridMetrics'].append(k.to_map() if k else None)
        if self.hybrid_monitor_namespace is not None:
            result['HybridMonitorNamespace'] = self.hybrid_monitor_namespace
        if self.initial_max_size is not None:
            result['InitialMaxSize'] = self.initial_max_size
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.min_adjustment_magnitude is not None:
            result['MinAdjustmentMagnitude'] = self.min_adjustment_magnitude
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.predictive_scaling_mode is not None:
            result['PredictiveScalingMode'] = self.predictive_scaling_mode
        if self.predictive_task_buffer_time is not None:
            result['PredictiveTaskBufferTime'] = self.predictive_task_buffer_time
        if self.predictive_value_behavior is not None:
            result['PredictiveValueBehavior'] = self.predictive_value_behavior
        if self.predictive_value_buffer is not None:
            result['PredictiveValueBuffer'] = self.predictive_value_buffer
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scale_in_evaluation_count is not None:
            result['ScaleInEvaluationCount'] = self.scale_in_evaluation_count
        if self.scale_out_evaluation_count is not None:
            result['ScaleOutEvaluationCount'] = self.scale_out_evaluation_count
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.scaling_rule_name is not None:
            result['ScalingRuleName'] = self.scaling_rule_name
        if self.scaling_rule_type is not None:
            result['ScalingRuleType'] = self.scaling_rule_type
        result['StepAdjustments'] = []
        if self.step_adjustments is not None:
            for k in self.step_adjustments:
                result['StepAdjustments'].append(k.to_map() if k else None)
        if self.target_value is not None:
            result['TargetValue'] = self.target_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustmentType') is not None:
            self.adjustment_type = m.get('AdjustmentType')
        if m.get('AdjustmentValue') is not None:
            self.adjustment_value = m.get('AdjustmentValue')
        self.alarm_dimensions = []
        if m.get('AlarmDimensions') is not None:
            for k in m.get('AlarmDimensions'):
                temp_model = CreateScalingRuleRequestAlarmDimensions()
                self.alarm_dimensions.append(temp_model.from_map(k))
        if m.get('AlarmOptions') is not None:
            temp_model = CreateScalingRuleRequestAlarmOptions()
            self.alarm_options = temp_model.from_map(m['AlarmOptions'])
        if m.get('Cooldown') is not None:
            self.cooldown = m.get('Cooldown')
        if m.get('DisableScaleIn') is not None:
            self.disable_scale_in = m.get('DisableScaleIn')
        if m.get('EstimatedInstanceWarmup') is not None:
            self.estimated_instance_warmup = m.get('EstimatedInstanceWarmup')
        self.hybrid_metrics = []
        if m.get('HybridMetrics') is not None:
            for k in m.get('HybridMetrics'):
                temp_model = CreateScalingRuleRequestHybridMetrics()
                self.hybrid_metrics.append(temp_model.from_map(k))
        if m.get('HybridMonitorNamespace') is not None:
            self.hybrid_monitor_namespace = m.get('HybridMonitorNamespace')
        if m.get('InitialMaxSize') is not None:
            self.initial_max_size = m.get('InitialMaxSize')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('MinAdjustmentMagnitude') is not None:
            self.min_adjustment_magnitude = m.get('MinAdjustmentMagnitude')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PredictiveScalingMode') is not None:
            self.predictive_scaling_mode = m.get('PredictiveScalingMode')
        if m.get('PredictiveTaskBufferTime') is not None:
            self.predictive_task_buffer_time = m.get('PredictiveTaskBufferTime')
        if m.get('PredictiveValueBehavior') is not None:
            self.predictive_value_behavior = m.get('PredictiveValueBehavior')
        if m.get('PredictiveValueBuffer') is not None:
            self.predictive_value_buffer = m.get('PredictiveValueBuffer')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScaleInEvaluationCount') is not None:
            self.scale_in_evaluation_count = m.get('ScaleInEvaluationCount')
        if m.get('ScaleOutEvaluationCount') is not None:
            self.scale_out_evaluation_count = m.get('ScaleOutEvaluationCount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('ScalingRuleName') is not None:
            self.scaling_rule_name = m.get('ScalingRuleName')
        if m.get('ScalingRuleType') is not None:
            self.scaling_rule_type = m.get('ScalingRuleType')
        self.step_adjustments = []
        if m.get('StepAdjustments') is not None:
            for k in m.get('StepAdjustments'):
                temp_model = CreateScalingRuleRequestStepAdjustments()
                self.step_adjustments.append(temp_model.from_map(k))
        if m.get('TargetValue') is not None:
            self.target_value = m.get('TargetValue')
        return self


class CreateScalingRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_rule_ari: str = None,
        scaling_rule_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The unique identifier of the scaling rule.
        self.scaling_rule_ari = scaling_rule_ari
        # The ID of the scaling rule, which is generated by the system and is globally unique.
        self.scaling_rule_id = scaling_rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_rule_ari is not None:
            result['ScalingRuleAri'] = self.scaling_rule_ari
        if self.scaling_rule_id is not None:
            result['ScalingRuleId'] = self.scaling_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingRuleAri') is not None:
            self.scaling_rule_ari = m.get('ScalingRuleAri')
        if m.get('ScalingRuleId') is not None:
            self.scaling_rule_id = m.get('ScalingRuleId')
        return self


class CreateScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateScalingRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateScalingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScheduledTaskRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        desired_capacity: int = None,
        launch_expiration_time: int = None,
        launch_time: str = None,
        max_value: int = None,
        min_value: int = None,
        owner_account: str = None,
        owner_id: int = None,
        recurrence_end_time: str = None,
        recurrence_type: str = None,
        recurrence_value: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
        scheduled_action: str = None,
        scheduled_task_name: str = None,
        task_enabled: bool = None,
    ):
        # The description of the scheduled task. The description must be 2 to 200 characters in length.
        self.description = description
        # The expected number of instances in the scaling group if you specify the ScalingGroupId parameter.
        # 
        # > You must specify the `DesiredCapacity` parameter when you create a scaling group.
        self.desired_capacity = desired_capacity
        # The time period during which the failed scheduled task can be retried. Unit: seconds. Valid values: 0 to 1800.
        # 
        # Default value: 600.
        self.launch_expiration_time = launch_expiration_time
        # The point in time at which the scheduled task is triggered. Specify the time in the ISO 8601 standard. The time must be in UTC. You cannot trigger a scheduled task more than 90 days after its creation.
        # 
        # *   If you specify `RecurrenceType`, the scheduled task is repeatedly triggered at the point in time that is specified by LaunchTime.
        # *   If you do not specify `RecurrenceType`, the scheduled task is triggered only once at the time point that is specified by LaunchTime.
        self.launch_time = launch_time
        # The maximum number of instances in the scaling group if you specify the ScalingGroupId parameter.
        self.max_value = max_value
        # The minimum number of instances in the scaling group if you specify the ScalingGroupId parameter.
        self.min_value = min_value
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The end time of the scheduled task. Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mmZ format.
        # 
        # The time must be in UTC. You cannot enter a point in time that is later than 365 days from the point in time at which the scheduled task is created.
        self.recurrence_end_time = recurrence_end_time
        # The interval at which the scheduled task is repeated. Valid values:
        # 
        # *   Daily: The scheduled task is executed once every specified number of days.
        # *   Weekly: The scheduled task is executed on each specified day of the week.
        # *   Monthly: The scheduled task is executed on each specified day of the month.
        # *   Cron: The scheduled task is executed based on the specified cron expression.
        # 
        # You must specify the `RecurrenceType` and `RecurrenceValue` parameters at the same time.
        self.recurrence_type = recurrence_type
        # The number of recurrences of the scheduled task.
        # 
        # *   If you set the `RecurrenceType` parameter to `Daily`, you can specify only one value for this parameter. Valid values: 1 to 31.
        # *   If you set the `RecurrenceType` parameter to `Weekly`, you can specify multiple values for this parameter. Separate the values with commas (,). The values that correspond to Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, and Saturday are 0, 1, 2, 3, 4, 5, and 6.``
        # *   If you set the `RecurrenceType` parameter to `Monthly`, you can specify two values in the `A-B` format for this parameter. Valid values of A and B: 1 to 31. B must be greater than or equal to A.
        # *   If you set the `RecurrenceType` parameter to `Cron`, you can specify a cron expression. A cron expression is written in UTC time and consists of the following fields: minute, hour, day, month, and week. The expression can contain the letters L and W and the following wildcard characters: commas (,), question marks (?), hyphens (-), asterisks (\\*), number signs (#), and forward slashes (/).
        # 
        # You must specify both the `RecurrenceType` parameter and the `RecurrenceValue` parameter.
        self.recurrence_value = recurrence_value
        # The region ID of the scheduled task.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group. If you specify this parameter, the number of instances in the scaling group will be changed when the scheduled task is triggered.
        # 
        # If you specify `ScalingGroupId`, you must also specify at least one of the following parameters: `MinValue`, `MaxValue`, and `DesiredCapacity`. You cannot specify `ScheduledAction` and `ScalingGroupId` at the same time.
        self.scaling_group_id = scaling_group_id
        # The scaling rule that you want to execute when the scheduled task is triggered. Specify the unique identifier of the scaling rule.
        # 
        # If you specify `ScheduledAction`, the scheduled task uses an existing scaling rule. You cannot specify `ScheduledAction` and `ScalingGroupId` at the same time.
        self.scheduled_action = scheduled_action
        # The name of the scheduled task. The name must be 2 to 64 characters in length, and can contain letters, digits, underscores (_), hyphens (-), and periods (.). The name must start with a letter or a digit. The name of the scheduled task must be unique in the region and within the Alibaba Cloud account.
        # 
        # If you do not specify this parameter, the value of the `ScheduledTaskId` parameter is used.
        self.scheduled_task_name = scheduled_task_name
        # Specifies whether to enable the scheduled task.
        # 
        # *   true
        # *   false
        # 
        # Default value: true.
        self.task_enabled = task_enabled

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.desired_capacity is not None:
            result['DesiredCapacity'] = self.desired_capacity
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        if self.max_value is not None:
            result['MaxValue'] = self.max_value
        if self.min_value is not None:
            result['MinValue'] = self.min_value
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.scheduled_action is not None:
            result['ScheduledAction'] = self.scheduled_action
        if self.scheduled_task_name is not None:
            result['ScheduledTaskName'] = self.scheduled_task_name
        if self.task_enabled is not None:
            result['TaskEnabled'] = self.task_enabled
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DesiredCapacity') is not None:
            self.desired_capacity = m.get('DesiredCapacity')
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        if m.get('MaxValue') is not None:
            self.max_value = m.get('MaxValue')
        if m.get('MinValue') is not None:
            self.min_value = m.get('MinValue')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('ScheduledAction') is not None:
            self.scheduled_action = m.get('ScheduledAction')
        if m.get('ScheduledTaskName') is not None:
            self.scheduled_task_name = m.get('ScheduledTaskName')
        if m.get('TaskEnabled') is not None:
            self.task_enabled = m.get('TaskEnabled')
        return self


class CreateScheduledTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scheduled_task_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The globally unique ID of the scheduled task. The globally unique ID is generated by the system.
        self.scheduled_task_id = scheduled_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scheduled_task_id is not None:
            result['ScheduledTaskId'] = self.scheduled_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScheduledTaskId') is not None:
            self.scheduled_task_id = m.get('ScheduledTaskId')
        return self


class CreateScheduledTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateScheduledTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateScheduledTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactivateScalingConfigurationRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        scaling_configuration_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling configuration.
        # 
        # This parameter is required.
        self.scaling_configuration_id = scaling_configuration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        return self


class DeactivateScalingConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeactivateScalingConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeactivateScalingConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeactivateScalingConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAlarmRequest(TeaModel):
    def __init__(
        self,
        alarm_task_id: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
    ):
        # The ID of the event-triggered task.
        # 
        # This parameter is required.
        self.alarm_task_id = alarm_task_id
        self.owner_id = owner_id
        # The ID of the region.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_task_id is not None:
            result['AlarmTaskId'] = self.alarm_task_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmTaskId') is not None:
            self.alarm_task_id = m.get('AlarmTaskId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        return self


class DeleteAlarmResponseBody(TeaModel):
    def __init__(
        self,
        alarm_task_id: str = None,
        request_id: str = None,
    ):
        # The ID of the event-triggered task.
        self.alarm_task_id = alarm_task_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_task_id is not None:
            result['AlarmTaskId'] = self.alarm_task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmTaskId') is not None:
            self.alarm_task_id = m.get('AlarmTaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAlarmResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAlarmResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAlarmResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEciScalingConfigurationRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_configuration_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling configuration that you want to delete.
        # 
        # This parameter is required.
        self.scaling_configuration_id = scaling_configuration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        return self


class DeleteEciScalingConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        # 
        # The request ID is consistently returned in the response, irrespective of whether the request is executed successfully or encounters an error.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEciScalingConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteEciScalingConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteEciScalingConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLifecycleHookRequest(TeaModel):
    def __init__(
        self,
        lifecycle_hook_id: str = None,
        lifecycle_hook_name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        # The ID of the lifecycle hook.
        self.lifecycle_hook_id = lifecycle_hook_id
        # The name of the lifecycle hook.
        self.lifecycle_hook_name = lifecycle_hook_name
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lifecycle_hook_id is not None:
            result['LifecycleHookId'] = self.lifecycle_hook_id
        if self.lifecycle_hook_name is not None:
            result['LifecycleHookName'] = self.lifecycle_hook_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LifecycleHookId') is not None:
            self.lifecycle_hook_id = m.get('LifecycleHookId')
        if m.get('LifecycleHookName') is not None:
            self.lifecycle_hook_name = m.get('LifecycleHookName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DeleteLifecycleHookResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLifecycleHookResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLifecycleHookResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLifecycleHookResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNotificationConfigurationRequest(TeaModel):
    def __init__(
        self,
        notification_arn: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the notification recipient. Specify the value in one of the following formats:
        # 
        # *   If you specify CloudMonitor as the notification recipient, specify the value in the acs:ess:{region-id}:{account-id}:cloudmonitor format.
        # *   If you specify a Simple Message Queue (SMQ, formerly MNS) queue as the notification recipient, specify the value in the acs:mns:{region-id}:{account-id}:queue/{queuename} format.
        # *   If you specify an SMQ queue as the notification recipient, specify the value in the acs:mns:{region-id}:{account-id}:topic/{topicname} format.
        # 
        # The variables in the preceding value formats have the following meanings:
        # 
        # *   region-id: the region ID of the scaling group.
        # *   account-id: the ID of your Alibaba Cloud cloud.
        # *   queuename: the name of the SMQ queue.
        # *   topicname: the name of the SMQ topic.
        # 
        # This parameter is required.
        self.notification_arn = notification_arn
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notification_arn is not None:
            result['NotificationArn'] = self.notification_arn
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NotificationArn') is not None:
            self.notification_arn = m.get('NotificationArn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DeleteNotificationConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNotificationConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNotificationConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNotificationConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScalingConfigurationRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        scaling_configuration_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling configuration that you want to delete.
        # 
        # This parameter is required.
        self.scaling_configuration_id = scaling_configuration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        return self


class DeleteScalingConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request. The request ID is returned regardless of whether the call is successful.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteScalingConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteScalingConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteScalingConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScalingGroupRequest(TeaModel):
    def __init__(
        self,
        force_delete: bool = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        # Specifies whether to enforce the deletion of the scaling group, including the removal of the current ECS instances or elastic container instances from the scaling group and their subsequent release, even if the scaling group is actively undergoing scaling activities. Valid values:
        # 
        # *   true: enforces the deletion of the scaling group. In this case, the scaling group first enters the Disabled state, ceasing acceptance of new scaling requests. Auto Scaling awaits the conclusion of all ongoing scaling activities in the scaling group before it automatically removes the current ECS instances or elastic container instances from the scaling group and enforces the deletion operation. Note that manually added instances are merely removed from the scaling group, whereas auto-provisioned instances are removed and deleted.
        # 
        # *   false: does not enforce the deletion of the scaling group. The scaling group will be disabled and then deleted once all the following requirements are satisfied:
        # 
        #     *   The scaling group has no ongoing scaling activities.
        #     *   The scaling group contains no ECS instances or elastic container instances (Total Capacity=0).
        # 
        # Default value: false.
        self.force_delete = force_delete
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force_delete is not None:
            result['ForceDelete'] = self.force_delete
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ForceDelete') is not None:
            self.force_delete = m.get('ForceDelete')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DeleteScalingGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteScalingGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteScalingGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScalingRuleRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_rule_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling rule that you want to delete.
        # 
        # This parameter is required.
        self.scaling_rule_id = scaling_rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_rule_id is not None:
            result['ScalingRuleId'] = self.scaling_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingRuleId') is not None:
            self.scaling_rule_id = m.get('ScalingRuleId')
        return self


class DeleteScalingRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteScalingRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteScalingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScheduledTaskRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scheduled_task_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region ID of the scheduled task.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scheduled task. An ID is a globally unique identifier (GUID) that is generated by the system for a scheduled task.
        # 
        # This parameter is required.
        self.scheduled_task_id = scheduled_task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scheduled_task_id is not None:
            result['ScheduledTaskId'] = self.scheduled_task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScheduledTaskId') is not None:
            self.scheduled_task_id = m.get('ScheduledTaskId')
        return self


class DeleteScheduledTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteScheduledTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteScheduledTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteScheduledTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmsRequest(TeaModel):
    def __init__(
        self,
        alarm_task_id: str = None,
        is_enable: bool = None,
        metric_name: str = None,
        metric_type: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
        state: str = None,
    ):
        # The ID of the event-triggered task.
        self.alarm_task_id = alarm_task_id
        # Specifies whether to enable the event-triggered task. Valid values:
        # 
        # *   true: enables the event-triggered task.
        # *   false: disables the event-triggered task.
        self.is_enable = is_enable
        # The metric name.
        self.metric_name = metric_name
        # The metric type. Valid values:
        # 
        # *   system: a system metric of CloudMonitor
        # *   custom: a custom metric that is reported to CloudMonitor.
        # *   hybrid: a metric of Hybrid Cloud Monitoring.
        self.metric_type = metric_type
        self.owner_id = owner_id
        # The page number. Pages start from page 1.
        # 
        # Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Valid values: 1 to 50.
        # 
        # Default value: 10.
        self.page_size = page_size
        # The region ID of the event-triggered task.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group with which the event-triggered task is associated.
        self.scaling_group_id = scaling_group_id
        # The status of the event-triggered task. Valid values:
        # 
        # *   ALARM: The alert condition is met and an alert is triggered.
        # *   OK: The alert condition is not met.
        # *   INSUFFICIENT_DATA: Auto Scaling cannot determine whether the alert condition is met due to insufficient data.
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_task_id is not None:
            result['AlarmTaskId'] = self.alarm_task_id
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmTaskId') is not None:
            self.alarm_task_id = m.get('AlarmTaskId')
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeAlarmsResponseBodyAlarmListDimensions(TeaModel):
    def __init__(
        self,
        dimension_key: str = None,
        dimension_value: str = None,
    ):
        # The dimension key of the metric. Valid values:
        # 
        # *   user_id: the ID of your Alibaba Cloud account.
        # *   scaling_group: the scaling group that is monitored by the event-triggered task.
        # *   device: the NIC type.
        # *   state: the status of the TCP connection.
        self.dimension_key = dimension_key
        # The dimension value of the metric. The value of DimensionValue varies based on the value of DimensionKey.
        # 
        # *   If you set DimensionKey to `user_id`, the system specifies the value of DimensionValue.
        # 
        # *   If you set DimensionKey to `scaling_group`, the system specifies the value of DimensionValue.
        # 
        # *   If you set DimensionKey to `device`, you can set DimensionValue to eth0 or eth1.
        # 
        #     *   For instances of the classic network type, eth0 indicates the internal NIC. Only one eth0 NIC exists on each instance that resides in VPCs.
        #     *   For instances of the classic network type, eth1 indicates the public NIC.
        # 
        # *   If you set DimensionKey to `state`, you can set DimensionValue to TCP_TOTAL or ESTABLISHED.
        # 
        #     *   TCP_TOTAL indicates the total number of TCP connections.
        #     *   ESTABLISHED indicates the number of TCP connections that are established.
        self.dimension_value = dimension_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension_key is not None:
            result['DimensionKey'] = self.dimension_key
        if self.dimension_value is not None:
            result['DimensionValue'] = self.dimension_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DimensionKey') is not None:
            self.dimension_key = m.get('DimensionKey')
        if m.get('DimensionValue') is not None:
            self.dimension_value = m.get('DimensionValue')
        return self


class DescribeAlarmsResponseBodyAlarmListExpressions(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        metric_name: str = None,
        period: int = None,
        statistics: str = None,
        threshold: float = None,
    ):
        # The operator that is used to compare the metric value and the threshold.
        # 
        # *   Valid value if the metric value is greater than or equal to the threshold: >=.
        # *   Valid value if the metric value is less than or equal to the threshold: <=.
        # *   Valid value if the metric value is greater than the threshold: >.
        # *   Valid value if the metric value is less than the threshold: <.
        self.comparison_operator = comparison_operator
        # The name of the metric that is specified in the multi-metric alert rule. Valid values:
        # 
        # *   CpuUtilization: the CPU utilization of an ECS instance. Unit: %.
        # *   ConcurrentConnections: the number of current connections to an ECS instance.
        # *   IntranetTx: the outbound traffic over an internal network. Unit: KB/min.
        # *   IntranetRx: the inbound traffic over an internal network. Unit: KB/min.
        # *   VpcInternetTx: the outbound traffic over a VPC. Unit: KB/min.
        # *   VpcInternetRx: the inbound traffic over a VPC. Unit: KB/min.
        # *   SystemDiskReadBps: the number of bytes read from the system disk per second.
        # *   SystemDiskWriteBps: the number of bytes written to the system disk per second.
        # *   SystemDiskReadOps: the read IOPS of the system disk. Unit: counts/s.
        # *   SystemDiskWriteOps: the write IOPS of the system disk. Unit: counts/s.
        # *   CpuUtilizationAgent: the CPU utilization. Unit: %.
        # *   GpuUtilizationAgent: the GPU utilization. Unit: %.
        # *   GpuMemoryFreeUtilizationAgent: the idle GPU memory usage. Unit: %.
        # *   GpuMemoryUtilizationAgent: the GPU memory usage. Unit: %.
        # *   MemoryUtilization: the memory usage. Unit: %.
        # *   LoadAverage: the average system load.
        # *   TcpConnection: the total number of TCP connections.
        # *   TcpConnection: the number of established TCP connections.
        # *   PackagesNetOut: the number of packets sent by the internal NIC. Unit: counts/s.
        # *   PackagesNetIn: the number of packets received by the internal NIC. Unit: counts/s.
        # *   PackagesNetOut: the number of packets sent by the public NIC. Unit: counts/s.
        # *   PackagesNetIn: the number of packets received by the public NIC. Unit: counts/s.
        # *   EciPodCpuUtilization: the CPU utilization. Unit: %.
        # *   EciPodMemoryUtilization: the memory usage. Unit: %.
        # *   LoadBalancerRealServerAverageQps: the QPS of an instance.
        # 
        # For more information, see [Event-triggered tasks of the system monitoring type](https://help.aliyun.com/document_detail/74854.html).
        self.metric_name = metric_name
        # The statistical period of the metric data in the multi-metric alert rule. Unit: seconds. Valid values:
        # 
        # *   15
        # *   60
        # *   120
        # *   300
        # *   900
        # 
        # >  If your scaling group is of the ECS type and the event-triggered task that is associated with your scaling group monitors CloudMonitor metrics, you can set Period to 15. In most cases, the name of a CloudMonitor metric contains Agent.
        self.period = period
        # The method that is used to aggregate statistics about the metrics in the multi-metric alert rule. Valid values:
        # 
        # *   Average: the average value
        # *   Minimum: the minimum value
        # *   Maximum: the maximum value
        self.statistics = statistics
        # The threshold of the metric value. If the threshold is reached the specified number of times within the specified period, a scaling rule is executed.
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeAlarmsResponseBodyAlarmListHybridMetricsDimensions(TeaModel):
    def __init__(
        self,
        dimension_key: str = None,
        dimension_value: str = None,
    ):
        # The key of the metric dimension.
        self.dimension_key = dimension_key
        # The key of the metric dimension.
        self.dimension_value = dimension_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dimension_key is not None:
            result['DimensionKey'] = self.dimension_key
        if self.dimension_value is not None:
            result['DimensionValue'] = self.dimension_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DimensionKey') is not None:
            self.dimension_key = m.get('DimensionKey')
        if m.get('DimensionValue') is not None:
            self.dimension_value = m.get('DimensionValue')
        return self


class DescribeAlarmsResponseBodyAlarmListHybridMetrics(TeaModel):
    def __init__(
        self,
        dimensions: List[DescribeAlarmsResponseBodyAlarmListHybridMetricsDimensions] = None,
        expression: str = None,
        id: str = None,
        metric_name: str = None,
        statistic: str = None,
    ):
        # The metric dimensions. This parameter is used to specify the monitored resources.
        self.dimensions = dimensions
        # The metric expression that consists of multiple Hybrid Cloud Monitoring metrics. It calculates a result used to trigger scaling events.
        # 
        # The expression is written in Reverse Polish Notation (RPN) format and supports only the following operators: `+, -, *, /`.
        self.expression = expression
        # The reference ID of the metric in the metric expression.
        self.id = id
        # The name of the Hybrid Cloud Monitoring metric.
        self.metric_name = metric_name
        # The statistical method of the metric value. Valid values:
        # 
        # *   Average: The average value of all metric values within a specified interval is calculated.
        # *   Minimum: The minimum value of all metric values within a specified interval is calculated.
        # *   Maximum: The maximum value of all metric values within a specified interval is calculated.
        self.statistic = statistic

    def validate(self):
        if self.dimensions:
            for k in self.dimensions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Dimensions'] = []
        if self.dimensions is not None:
            for k in self.dimensions:
                result['Dimensions'].append(k.to_map() if k else None)
        if self.expression is not None:
            result['Expression'] = self.expression
        if self.id is not None:
            result['Id'] = self.id
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.statistic is not None:
            result['Statistic'] = self.statistic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dimensions = []
        if m.get('Dimensions') is not None:
            for k in m.get('Dimensions'):
                temp_model = DescribeAlarmsResponseBodyAlarmListHybridMetricsDimensions()
                self.dimensions.append(temp_model.from_map(k))
        if m.get('Expression') is not None:
            self.expression = m.get('Expression')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Statistic') is not None:
            self.statistic = m.get('Statistic')
        return self


class DescribeAlarmsResponseBodyAlarmList(TeaModel):
    def __init__(
        self,
        alarm_actions: List[str] = None,
        alarm_task_id: str = None,
        comparison_operator: str = None,
        description: str = None,
        dimensions: List[DescribeAlarmsResponseBodyAlarmListDimensions] = None,
        effective: str = None,
        enable: bool = None,
        evaluation_count: int = None,
        expressions: List[DescribeAlarmsResponseBodyAlarmListExpressions] = None,
        expressions_logic_operator: str = None,
        hybrid_metrics: List[DescribeAlarmsResponseBodyAlarmListHybridMetrics] = None,
        hybrid_monitor_namespace: str = None,
        metric_name: str = None,
        metric_type: str = None,
        name: str = None,
        period: int = None,
        prom_ql: str = None,
        scaling_group_id: str = None,
        state: str = None,
        statistics: str = None,
        threshold: float = None,
    ):
        # The unique identifiers of the scaling rules that are associated with the event-triggered task.
        self.alarm_actions = alarm_actions
        # The ID of the event-triggered task.
        self.alarm_task_id = alarm_task_id
        # The operator that is used to compare the metric value and the metric threshold.
        # 
        # *   Valid value if the metric value is greater than or equal to the threshold: >=.
        # *   Valid value if the metric value is less than or equal to the threshold: <=.
        # *   Valid value if the metric value is greater than the threshold: >.
        # *   Valid value if the metric value is less than the threshold: <.
        self.comparison_operator = comparison_operator
        # The description of the event-triggered task.
        self.description = description
        # The metric dimensions.
        self.dimensions = dimensions
        # The effective period of the event-triggered task.
        self.effective = effective
        # Indicates whether the event-triggered task feature is enabled. Valid values:
        # 
        # *   true
        # *   false
        self.enable = enable
        # The number of consecutive times that the threshold must be reached before a scaling rule is executed. For example, if you set this parameter to 3, the average CPU utilization must reach or exceed 80% three times in a row before a scaling rule is executed.
        self.evaluation_count = evaluation_count
        # The alert conditions of the multi-metric alert rule.
        self.expressions = expressions
        # The relationship between the trigger conditions that are specified in the multi-metric alert rule. Valid values:
        # 
        # *   `&&`: An alert is triggered only if all metrics in the multi-metric alert rule meet their trigger conditions. In this case, an alert is triggered only if the results of all trigger conditions that are specified in the multi-metric alert rule are `true`.
        # *   `||`: An alert is triggered only if one of the metrics in the multi-metric alert rule meets its trigger condition.
        self.expressions_logic_operator = expressions_logic_operator
        # The Hybrid Cloud Monitoring metrics.
        self.hybrid_metrics = hybrid_metrics
        # The ID of the Hybrid Cloud Monitoring namespace.
        # 
        # For information about how to manage Hybrid Cloud Monitoring namespaces, see [Manage namespaces](https://help.aliyun.com/document_detail/217606.html).
        self.hybrid_monitor_namespace = hybrid_monitor_namespace
        # The metric name. Valid values:
        # 
        # *   CpuUtilization: the CPU utilization of an Elastic Compute Service (ECS) instance. Unit: %.
        # *   ConcurrentConnections: the number of current connections to an ECS instance.
        # *   IntranetTx: the outbound traffic over an internal network. Unit: KB/min.
        # *   IntranetRx: the inbound traffic over an internal network. Unit: KB/min.
        # *   VpcInternetTx: the outbound traffic over a virtual private cloud (VPC). Unit: KB/min.
        # *   VpcInternetRx: the inbound traffic over a VPC. Unit: KB/min.
        # *   SystemDiskReadBps: the number of bytes read from the system disk per second.
        # *   SystemDiskWriteBps: the number of bytes written to the system disk per second.
        # *   SystemDiskReadOps: the read IOPS of the system disk. Unit: counts/s.
        # *   SystemDiskWriteOps: the write IOPS of the system disk. Unit: counts/s.
        # *   CpuUtilizationAgent: the CPU utilization. Unit: %.
        # *   GpuUtilizationAgent: the GPU utilization. Unit: %.
        # *   GpuMemoryFreeUtilizationAgent: the idle GPU memory usage. Unit: %.
        # *   GpuMemoryUtilizationAgent: the GPU memory usage. Unit: %.
        # *   MemoryUtilization: the memory usage. Unit: %.
        # *   LoadAverage: the average system load.
        # *   TcpConnection: the total number of TCP connections.
        # *   TcpConnection: the number of established TCP connections.
        # *   PackagesNetOut: the number of packets sent by the internal NIC. Unit: counts/s.
        # *   PackagesNetIn: the number of packets received by the internal NIC. Unit: counts/s.
        # *   PackagesNetOut: the number of packets sent by the public NIC. Unit: counts/s.
        # *   PackagesNetIn: the number of packets received by the public NIC. Unit: counts/s.
        # *   EciPodCpuUtilization: the CPU utilization. Unit: %.
        # *   EciPodMemoryUtilization: the memory usage. Unit: %.
        # *   LoadBalancerRealServerAverageQps: the queries per second (QPS) of an instance.
        # 
        # For more information, see [Event-triggered tasks of the system monitoring type](https://help.aliyun.com/document_detail/74854.html).
        self.metric_name = metric_name
        # The type of the metric. Valid values:
        # 
        # *   system: system metrics of CloudMonitor
        # *   custom: custom metrics that are reported to CloudMonitor.
        # *   hybrid: metrics of Hybrid Cloud Monitoring.
        self.metric_type = metric_type
        # The name of the event-triggered task.
        self.name = name
        # The statistical period of the metric data. Unit: seconds. Valid values:
        # 
        # *   15
        # *   60
        # *   120
        # *   300
        # *   900
        # 
        # >  You can set the value of this parameter to 15 Seconds only for scaling groups of the ECS type.
        self.period = period
        # The PromQL statement of Hybrid Cloud Monitoring.
        self.prom_ql = prom_ql
        # The ID of the scaling group to which the event-triggered task is associated.
        self.scaling_group_id = scaling_group_id
        # The status of the event-triggered task. Valid values:
        # 
        # *   ALARM: The alert condition is met and an alert is triggered.
        # *   OK: The alert condition is not met.
        # *   INSUFFICIENT_DATA: Auto Scaling cannot determine whether the alert condition is met due to insufficient data.
        self.state = state
        # The method that is used to aggregate the metric data. Valid values:
        # 
        # *   Average: the average value
        # *   Minimum: the minimum value
        # *   Maximum: the maximum value
        self.statistics = statistics
        # The threshold of the metric. If the threshold is reached the specified number of times within the statistical period, a scaling rule is executed.
        self.threshold = threshold

    def validate(self):
        if self.dimensions:
            for k in self.dimensions:
                if k:
                    k.validate()
        if self.expressions:
            for k in self.expressions:
                if k:
                    k.validate()
        if self.hybrid_metrics:
            for k in self.hybrid_metrics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_actions is not None:
            result['AlarmActions'] = self.alarm_actions
        if self.alarm_task_id is not None:
            result['AlarmTaskId'] = self.alarm_task_id
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.description is not None:
            result['Description'] = self.description
        result['Dimensions'] = []
        if self.dimensions is not None:
            for k in self.dimensions:
                result['Dimensions'].append(k.to_map() if k else None)
        if self.effective is not None:
            result['Effective'] = self.effective
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        result['Expressions'] = []
        if self.expressions is not None:
            for k in self.expressions:
                result['Expressions'].append(k.to_map() if k else None)
        if self.expressions_logic_operator is not None:
            result['ExpressionsLogicOperator'] = self.expressions_logic_operator
        result['HybridMetrics'] = []
        if self.hybrid_metrics is not None:
            for k in self.hybrid_metrics:
                result['HybridMetrics'].append(k.to_map() if k else None)
        if self.hybrid_monitor_namespace is not None:
            result['HybridMonitorNamespace'] = self.hybrid_monitor_namespace
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.name is not None:
            result['Name'] = self.name
        if self.period is not None:
            result['Period'] = self.period
        if self.prom_ql is not None:
            result['PromQL'] = self.prom_ql
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.state is not None:
            result['State'] = self.state
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmActions') is not None:
            self.alarm_actions = m.get('AlarmActions')
        if m.get('AlarmTaskId') is not None:
            self.alarm_task_id = m.get('AlarmTaskId')
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.dimensions = []
        if m.get('Dimensions') is not None:
            for k in m.get('Dimensions'):
                temp_model = DescribeAlarmsResponseBodyAlarmListDimensions()
                self.dimensions.append(temp_model.from_map(k))
        if m.get('Effective') is not None:
            self.effective = m.get('Effective')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        self.expressions = []
        if m.get('Expressions') is not None:
            for k in m.get('Expressions'):
                temp_model = DescribeAlarmsResponseBodyAlarmListExpressions()
                self.expressions.append(temp_model.from_map(k))
        if m.get('ExpressionsLogicOperator') is not None:
            self.expressions_logic_operator = m.get('ExpressionsLogicOperator')
        self.hybrid_metrics = []
        if m.get('HybridMetrics') is not None:
            for k in m.get('HybridMetrics'):
                temp_model = DescribeAlarmsResponseBodyAlarmListHybridMetrics()
                self.hybrid_metrics.append(temp_model.from_map(k))
        if m.get('HybridMonitorNamespace') is not None:
            self.hybrid_monitor_namespace = m.get('HybridMonitorNamespace')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PromQL') is not None:
            self.prom_ql = m.get('PromQL')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeAlarmsResponseBody(TeaModel):
    def __init__(
        self,
        alarm_list: List[DescribeAlarmsResponseBodyAlarmList] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The event-triggered tasks.
        self.alarm_list = alarm_list
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of event-triggered tasks.
        self.total_count = total_count

    def validate(self):
        if self.alarm_list:
            for k in self.alarm_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlarmList'] = []
        if self.alarm_list is not None:
            for k in self.alarm_list:
                result['AlarmList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alarm_list = []
        if m.get('AlarmList') is not None:
            for k in m.get('AlarmList'):
                temp_model = DescribeAlarmsResponseBodyAlarmList()
                self.alarm_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAlarmsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlarmsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlarmsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlertConfigurationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        self.owner_id = owner_id
        # The region ID of the scaling group.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DescribeAlertConfigurationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scale_statuses: List[str] = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The status of the scaling activities that trigger text message, internal message, or email-based notifications.
        self.scale_statuses = scale_statuses

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scale_statuses is not None:
            result['ScaleStatuses'] = self.scale_statuses
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScaleStatuses') is not None:
            self.scale_statuses = m.get('ScaleStatuses')
        return self


class DescribeAlertConfigurationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlertConfigurationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlertConfigurationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDiagnoseReportsRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        report_ids: List[str] = None,
        scaling_group_id: str = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The region ID of the scaling group.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The IDs of the diagnostic reports. You can specify at most 20 IDs.
        self.report_ids = report_ids
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.report_ids is not None:
            result['ReportIds'] = self.report_ids
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReportIds') is not None:
            self.report_ids = m.get('ReportIds')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DescribeDiagnoseReportsResponseBodyReportsDetails(TeaModel):
    def __init__(
        self,
        diagnose_type: str = None,
        error_code: str = None,
        resource_id: str = None,
        status: str = None,
    ):
        # The type of the diagnostic item. Valid values:
        # 
        # *   AccountArrearage: Checks whether your Alibaba Cloud account has overdue payments.
        # *   AccountNotEnoughBalance: Checks whether the balance of your Alibaba Cloud account at the China site (aliyun.com) is greater than or equal to CNY 100.
        # *   ElasticStrength: Checks whether the instance types that are specified in the scaling configuration are sufficient.
        # *   VSwitch: Checks whether a specific vSwitch can work as expected. For example, if a vSwitch is deleted, the vSwitch cannot provide services and an exception occurs.
        # *   SecurityGroup: Checks whether a specific security group can work as expected. For example, if a security group is deleted, the security group cannot provide services and an exception occurs.
        # *   KeyPair: Checks whether the key pair is available. If the specified key pair is deleted, specify another key pair for the scaling group.
        # *   SlbBackendServerQuota: Checks whether the number of ECS instances that are added to the default server group and the vServer groups of the SLB instances associated with the scaling group has reached the upper limit.
        # *   AlbBackendServerQuota: Checks whether the number of ECS instances that are added to the backend server groups of the ALB instances associated with the scaling group has reached the upper limit.
        # *   NlbBackendServerQuota: Checks whether the number of ECS instances that are added to the backend server groups of the NLB instances associated with the scaling group has reached the upper limit.
        self.diagnose_type = diagnose_type
        # The error code of the diagnostic item. Valid values:
        # 
        # *   VSwitchIdNotFound: The vSwitch does not exist.
        # *   SecurityGroupNotFound: The security group does not exist.
        # *   KeyPairNotFound: The key pair does not exist.
        # *   SlbBackendServerQuotaExceeded: The number of ECS instances that are added to the default server group and the vServer groups of the SLB instances associated with the scaling group has reached the upper limit.
        # *   AlbBackendServerQuotaExceeded: The number of ECS instances that are attached to the ALB instances of the scaling group has reached the upper limit.
        # *   NlbBackendServerQuotaExceeded: The number of ECS instances that are attached to the NLB instances of the scaling group has reached the upper limit.
        # *   AccountArrearage: Your account has overdue payments.
        # *   AccountNotEnoughBalance: The balance of your Alibaba Cloud account is less than CNY 100.
        # *   ElasticStrengthAlert: The inventory levels are lower than expected.
        self.error_code = error_code
        # The ID of the resource.
        self.resource_id = resource_id
        # The status of the diagnostic item. Valid values:
        # 
        # *   Normal: The diagnostic result is normal.
        # *   Warn: The diagnostic result is warning.
        # *   Critical: The diagnostic result is critical.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.diagnose_type is not None:
            result['DiagnoseType'] = self.diagnose_type
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiagnoseType') is not None:
            self.diagnose_type = m.get('DiagnoseType')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDiagnoseReportsResponseBodyReports(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        details: List[DescribeDiagnoseReportsResponseBodyReportsDetails] = None,
        diagnose_status: str = None,
        process_status: str = None,
        region_id: str = None,
        report_id: str = None,
        scaling_group_id: str = None,
        user_id: str = None,
    ):
        # The time when the diagnostic report was created.
        self.creation_time = creation_time
        # The details of the diagnostic report.
        self.details = details
        # The status of the diagnostic item. Only the severe status is displayed in the diagnostic report. Valid values:
        # 
        # *   Normal: The diagnostic result is normal.
        # *   Warn: The diagnostic result is warning.
        # *   Critical: The diagnostic result is critical.
        self.diagnose_status = diagnose_status
        # The status of the diagnostic report. Valid values:
        # 
        # *   processing: The diagnosis is in progress.
        # *   Finished: The diagnosis is complete.
        self.process_status = process_status
        # The ID of the region.
        self.region_id = region_id
        # The ID of the diagnostic report.
        self.report_id = report_id
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id
        # The user ID of the scaling group.
        self.user_id = user_id

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        if self.diagnose_status is not None:
            result['DiagnoseStatus'] = self.diagnose_status
        if self.process_status is not None:
            result['ProcessStatus'] = self.process_status
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DescribeDiagnoseReportsResponseBodyReportsDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('DiagnoseStatus') is not None:
            self.diagnose_status = m.get('DiagnoseStatus')
        if m.get('ProcessStatus') is not None:
            self.process_status = m.get('ProcessStatus')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DescribeDiagnoseReportsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        reports: List[DescribeDiagnoseReportsResponseBodyReports] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The page number.
        self.page_number = page_number
        # The number of entries per page.
        self.page_size = page_size
        # The diagnostic reports.
        self.reports = reports
        # The ID of the request.
        self.request_id = request_id
        # The total number of diagnostic reports.
        self.total_count = total_count

    def validate(self):
        if self.reports:
            for k in self.reports:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Reports'] = []
        if self.reports is not None:
            for k in self.reports:
                result['Reports'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.reports = []
        if m.get('Reports') is not None:
            for k in m.get('Reports'):
                temp_model = DescribeDiagnoseReportsResponseBodyReports()
                self.reports.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDiagnoseReportsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDiagnoseReportsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDiagnoseReportsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEciScalingConfigurationDetailRequest(TeaModel):
    def __init__(
        self,
        output_format: str = None,
        region_id: str = None,
        scaling_configuration_id: str = None,
        scaling_group_id: str = None,
    ):
        # The output format. Set the value to YAML.
        self.output_format = output_format
        # The region ID of the scaling group to which the scaling configuration belongs.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the scaling configuration based on which elastic container instances are created.
        # 
        # This parameter is required.
        self.scaling_configuration_id = scaling_configuration_id
        # The ID of the scaling group to which the scaling configuration belongs.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_format is not None:
            result['OutputFormat'] = self.output_format
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OutputFormat') is not None:
            self.output_format = m.get('OutputFormat')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationAcrRegistryInfos(TeaModel):
    def __init__(
        self,
        domains: List[str] = None,
        instance_id: str = None,
        instance_name: str = None,
        region_id: str = None,
    ):
        # The domain names of the Container Registry Enterprise Edition instance. By default, all domain names of the instance are displayed. Multiple domain names are separated by commas (,).
        self.domains = domains
        # The ID of the Container Registry Enterprise Edition instance.
        self.instance_id = instance_id
        # The name of the Container Registry Enterprise Edition instance.
        self.instance_name = instance_name
        # The region ID of the Container Registry Enterprise Edition instance.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domains') is not None:
            self.domains = m.get('Domains')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainersEnvironmentVars(TeaModel):
    def __init__(
        self,
        field_ref_field_path: str = None,
        key: str = None,
        value: str = None,
    ):
        # >  This parameter is not available for use.
        self.field_ref_field_path = field_ref_field_path
        # The name of the environment variable.
        self.key = key
        # The value of the environment variable.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_ref_field_path is not None:
            result['FieldRefFieldPath'] = self.field_ref_field_path
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldRefFieldPath') is not None:
            self.field_ref_field_path = m.get('FieldRefFieldPath')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainersPorts(TeaModel):
    def __init__(
        self,
        port: int = None,
        protocol: str = None,
    ):
        # The port number. Valid values: 1 to 65535.
        self.port = port
        # The protocol type. Valid values:
        # 
        # *   TCP
        # *   UDP
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainersVolumeMounts(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        mount_propagation: str = None,
        name: str = None,
        read_only: bool = None,
        sub_path: str = None,
    ):
        # The directory in which the container mounts the volume.
        # 
        # >  Data in this directory is overwritten by the data on the volume. Proceed with caution if you specify this parameter.
        self.mount_path = mount_path
        # The mount propagation setting of the volume. Mount propagation enables volumes mounted on one container to be shared among other containers within the same pod or across distinct pods residing on the same node. Valid values:
        # 
        # *   None: Subsequent mounts executed either on the volume itself or its subdirectories do not propagate to the already established volume mount.
        # *   HostToCotainer: Subsequent mounts executed either on the volume itself or its subdirectories propagate to the already established volume mount.
        # *   Bidirectional: This value is similar to HostToCotainer. Subsequent mounts executed either on the volume itself or its subdirectories propagate to the already established volume mount. In addition, any volume mounts executed on the container not only propagate back to the underlying host but also to all containers across every pod that uses the same volume.
        # 
        # Default value: None.
        self.mount_propagation = mount_propagation
        # The volume name.
        self.name = name
        # Indicates whether the volume is read-only.
        # 
        # Default value: false.
        self.read_only = read_only
        # The subdirectory of the volume.
        self.sub_path = sub_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        if self.mount_propagation is not None:
            result['MountPropagation'] = self.mount_propagation
        if self.name is not None:
            result['Name'] = self.name
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.sub_path is not None:
            result['SubPath'] = self.sub_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        if m.get('MountPropagation') is not None:
            self.mount_propagation = m.get('MountPropagation')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('SubPath') is not None:
            self.sub_path = m.get('SubPath')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainers(TeaModel):
    def __init__(
        self,
        args: List[str] = None,
        commands: List[str] = None,
        cpu: float = None,
        environment_vars: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainersEnvironmentVars] = None,
        gpu: int = None,
        image: str = None,
        image_pull_policy: str = None,
        lifecycle_post_start_handler_execs: List[str] = None,
        lifecycle_post_start_handler_http_get_host: str = None,
        lifecycle_post_start_handler_http_get_path: str = None,
        lifecycle_post_start_handler_http_get_port: int = None,
        lifecycle_post_start_handler_http_get_scheme: str = None,
        lifecycle_post_start_handler_tcp_socket_host: str = None,
        lifecycle_post_start_handler_tcp_socket_port: int = None,
        lifecycle_pre_stop_handler_execs: List[str] = None,
        lifecycle_pre_stop_handler_http_get_host: str = None,
        lifecycle_pre_stop_handler_http_get_path: str = None,
        lifecycle_pre_stop_handler_http_get_port: int = None,
        lifecycle_pre_stop_handler_http_get_scheme: str = None,
        lifecycle_pre_stop_handler_tcp_socket_host: str = None,
        lifecycle_pre_stop_handler_tcp_socket_port: int = None,
        liveness_probe_exec_commands: List[str] = None,
        liveness_probe_failure_threshold: int = None,
        liveness_probe_http_get_path: str = None,
        liveness_probe_http_get_port: int = None,
        liveness_probe_http_get_scheme: str = None,
        liveness_probe_initial_delay_seconds: int = None,
        liveness_probe_period_seconds: int = None,
        liveness_probe_success_threshold: int = None,
        liveness_probe_tcp_socket_port: int = None,
        liveness_probe_timeout_seconds: int = None,
        memory: float = None,
        name: str = None,
        ports: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainersPorts] = None,
        readiness_probe_exec_commands: List[str] = None,
        readiness_probe_failure_threshold: int = None,
        readiness_probe_http_get_path: str = None,
        readiness_probe_http_get_port: int = None,
        readiness_probe_http_get_scheme: str = None,
        readiness_probe_initial_delay_seconds: int = None,
        readiness_probe_period_seconds: int = None,
        readiness_probe_success_threshold: int = None,
        readiness_probe_tcp_socket_port: int = None,
        readiness_probe_timeout_seconds: int = None,
        security_context_capability_adds: List[str] = None,
        security_context_read_only_root_filesystem: bool = None,
        security_context_run_as_user: int = None,
        stdin: bool = None,
        stdin_once: bool = None,
        tty: bool = None,
        volume_mounts: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainersVolumeMounts] = None,
        working_dir: str = None,
    ):
        # The arguments that are passed to the container startup commands.
        self.args = args
        # The container startup commands.
        self.commands = commands
        # The number of vCPUs that are allocated to the elastic container instance.
        self.cpu = cpu
        # The environment variables.
        self.environment_vars = environment_vars
        # The number of GPUs.
        self.gpu = gpu
        # The container image.
        self.image = image
        # The image pulling policy.
        self.image_pull_policy = image_pull_policy
        # The commands that are run by using a CLI for configuring the postStart callback function within the container.
        self.lifecycle_post_start_handler_execs = lifecycle_post_start_handler_execs
        # The IP address of the host to the HTTP GET requests for configuring the postStart callback function are sent.
        self.lifecycle_post_start_handler_http_get_host = lifecycle_post_start_handler_http_get_host
        # The path to the HTTP GET requests for configuring the postStart callback function are sent.
        self.lifecycle_post_start_handler_http_get_path = lifecycle_post_start_handler_http_get_path
        # The port over which the HTTP GET requests for configuring the postStart callback function are sent.
        self.lifecycle_post_start_handler_http_get_port = lifecycle_post_start_handler_http_get_port
        # The protocol type of the HTTP Get requests that are used for configuring the postStart callback function.
        self.lifecycle_post_start_handler_http_get_scheme = lifecycle_post_start_handler_http_get_scheme
        # The IP address of the host detected by the TCP sockets that are used for configuring the postStart callback function.
        self.lifecycle_post_start_handler_tcp_socket_host = lifecycle_post_start_handler_tcp_socket_host
        # The port detected by the TCP sockets that are used for configuring the postStart callback function.
        self.lifecycle_post_start_handler_tcp_socket_port = lifecycle_post_start_handler_tcp_socket_port
        # The commands that are run by using a CLI for configuring the preStop callback function within the container.
        self.lifecycle_pre_stop_handler_execs = lifecycle_pre_stop_handler_execs
        # The IP address of the host to which the HTTP GET requests for configuring the preStop callback function are sent.
        self.lifecycle_pre_stop_handler_http_get_host = lifecycle_pre_stop_handler_http_get_host
        # The path to which the HTTP GET requests for configuring the preStop callback function are sent.
        self.lifecycle_pre_stop_handler_http_get_path = lifecycle_pre_stop_handler_http_get_path
        # The port over which the HTTP GET requests for configuring the preStop callback function are sent.
        self.lifecycle_pre_stop_handler_http_get_port = lifecycle_pre_stop_handler_http_get_port
        # The protocol type of the HTTP Get requests that are used for configuring the preStop callback function.
        self.lifecycle_pre_stop_handler_http_get_scheme = lifecycle_pre_stop_handler_http_get_scheme
        # The IP address of the host detected by the TCP sockets that are used for configuring the preStop callback function.
        self.lifecycle_pre_stop_handler_tcp_socket_host = lifecycle_pre_stop_handler_tcp_socket_host
        # The port detected by the TCP sockets that are used for configuring the preStop callback function.
        self.lifecycle_pre_stop_handler_tcp_socket_port = lifecycle_pre_stop_handler_tcp_socket_port
        # The commands that are run in the container when you use a CLI to perform liveness probes.
        self.liveness_probe_exec_commands = liveness_probe_exec_commands
        # The minimum number of consecutive failures before a successful liveness probe is considered failed.
        # 
        # Default value: 3.
        self.liveness_probe_failure_threshold = liveness_probe_failure_threshold
        # The path to which HTTP Get requests are sent when you use the HTTP requests to perform liveness probes.
        self.liveness_probe_http_get_path = liveness_probe_http_get_path
        # The port detected by HTTP Get requests when you use the HTTP requests to perform liveness probes.
        self.liveness_probe_http_get_port = liveness_probe_http_get_port
        # The protocol type of HTTP GET requests when you use the HTTP requests to perform liveness probes. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        self.liveness_probe_http_get_scheme = liveness_probe_http_get_scheme
        # The number of seconds that elapses from the startup of the container to the start time of a liveness probe.
        self.liveness_probe_initial_delay_seconds = liveness_probe_initial_delay_seconds
        # The interval at which liveness probes are performed. Unit: seconds. Default value: 10. Minimum value: 1.
        self.liveness_probe_period_seconds = liveness_probe_period_seconds
        # The minimum number of consecutive successes before a failed liveness probe is considered successful. Default value: 1. Valid value: 1.
        self.liveness_probe_success_threshold = liveness_probe_success_threshold
        # The port detected by TCP sockets when you use the TCP sockets to perform liveness probes.
        self.liveness_probe_tcp_socket_port = liveness_probe_tcp_socket_port
        # The timeout period of a liveness probe. Default value: 1. Minimum value: 1. Unit: seconds.
        self.liveness_probe_timeout_seconds = liveness_probe_timeout_seconds
        # The memory size.
        self.memory = memory
        # The container name.
        self.name = name
        # The exposed ports and protocols.
        self.ports = ports
        # The commands that are run in the container when you use a CLI to perform readiness probes.
        self.readiness_probe_exec_commands = readiness_probe_exec_commands
        # The minimum number of consecutive failures before a successful readiness probe is considered failed.
        # 
        # Default value: 3.
        self.readiness_probe_failure_threshold = readiness_probe_failure_threshold
        # The path to which HTTP Get requests are sent when you use the HTTP requests to perform readiness probes.
        self.readiness_probe_http_get_path = readiness_probe_http_get_path
        # The path to which HTTP Get requests are sent when you use the HTTP Get requests to perform readiness probes.
        self.readiness_probe_http_get_port = readiness_probe_http_get_port
        # The protocol type of HTTP GET requests when you use the HTTP requests to perform readiness probes. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        self.readiness_probe_http_get_scheme = readiness_probe_http_get_scheme
        # The number of seconds that elapses from the startup of the container to the start time of a readiness probe.
        self.readiness_probe_initial_delay_seconds = readiness_probe_initial_delay_seconds
        # The interval at which readiness probes are performed. Unit: seconds. Default value: 10. Minimum value: 1.
        self.readiness_probe_period_seconds = readiness_probe_period_seconds
        # The minimum number of consecutive successes before a failed readiness probe is considered successful. Default value: 1. Valid value: 1.
        self.readiness_probe_success_threshold = readiness_probe_success_threshold
        # The port detected by TCP sockets when you use the TCP sockets to perform readiness probes.
        self.readiness_probe_tcp_socket_port = readiness_probe_tcp_socket_port
        # The timeout period of a readiness probe. Default value: 1. Minimum value: 1. Unit: seconds.
        self.readiness_probe_timeout_seconds = readiness_probe_timeout_seconds
        # The permissions that are granted to the processes in the container. Valid values: NET_ADMIN and NET_RAW.
        self.security_context_capability_adds = security_context_capability_adds
        # Indicates whether the root file system on which the container runs is read-only. Valid value: true.
        self.security_context_read_only_root_filesystem = security_context_read_only_root_filesystem
        # The ID of the user that runs the entry point of the container process.
        self.security_context_run_as_user = security_context_run_as_user
        # Indicates whether the container allocates buffer resources to standard input streams when the container is running. If this parameter is not specified, an end-of-file (EOF) error may occur when standard input streams in the container are read. Default value: false.
        self.stdin = stdin
        # Indicates whether standard input streams are disconnected after a client is disconnected. If Stdin is set to true, standard input streams remain connected among multiple sessions.
        # 
        # If StdinOnce is set to true, standard input streams are connected after the container is started, and remain idle until a client is connected to receive data. After the client is disconnected, streams are also disconnected, and remain disconnected until the container restarts.
        self.stdin_once = stdin_once
        # Specifies whether to enable the Interaction feature. Valid values:
        # 
        # *   true
        # *   false
        # 
        # If the command is a /bin/bash command, the value of this parameter is true.
        # 
        # Default value: false.
        self.tty = tty
        # The volumes that are mounted to the container.
        self.volume_mounts = volume_mounts
        # The working directory in the container.
        self.working_dir = working_dir

    def validate(self):
        if self.environment_vars:
            for k in self.environment_vars:
                if k:
                    k.validate()
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.volume_mounts:
            for k in self.volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['Args'] = self.args
        if self.commands is not None:
            result['Commands'] = self.commands
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        result['EnvironmentVars'] = []
        if self.environment_vars is not None:
            for k in self.environment_vars:
                result['EnvironmentVars'].append(k.to_map() if k else None)
        if self.gpu is not None:
            result['Gpu'] = self.gpu
        if self.image is not None:
            result['Image'] = self.image
        if self.image_pull_policy is not None:
            result['ImagePullPolicy'] = self.image_pull_policy
        if self.lifecycle_post_start_handler_execs is not None:
            result['LifecyclePostStartHandlerExecs'] = self.lifecycle_post_start_handler_execs
        if self.lifecycle_post_start_handler_http_get_host is not None:
            result['LifecyclePostStartHandlerHttpGetHost'] = self.lifecycle_post_start_handler_http_get_host
        if self.lifecycle_post_start_handler_http_get_path is not None:
            result['LifecyclePostStartHandlerHttpGetPath'] = self.lifecycle_post_start_handler_http_get_path
        if self.lifecycle_post_start_handler_http_get_port is not None:
            result['LifecyclePostStartHandlerHttpGetPort'] = self.lifecycle_post_start_handler_http_get_port
        if self.lifecycle_post_start_handler_http_get_scheme is not None:
            result['LifecyclePostStartHandlerHttpGetScheme'] = self.lifecycle_post_start_handler_http_get_scheme
        if self.lifecycle_post_start_handler_tcp_socket_host is not None:
            result['LifecyclePostStartHandlerTcpSocketHost'] = self.lifecycle_post_start_handler_tcp_socket_host
        if self.lifecycle_post_start_handler_tcp_socket_port is not None:
            result['LifecyclePostStartHandlerTcpSocketPort'] = self.lifecycle_post_start_handler_tcp_socket_port
        if self.lifecycle_pre_stop_handler_execs is not None:
            result['LifecyclePreStopHandlerExecs'] = self.lifecycle_pre_stop_handler_execs
        if self.lifecycle_pre_stop_handler_http_get_host is not None:
            result['LifecyclePreStopHandlerHttpGetHost'] = self.lifecycle_pre_stop_handler_http_get_host
        if self.lifecycle_pre_stop_handler_http_get_path is not None:
            result['LifecyclePreStopHandlerHttpGetPath'] = self.lifecycle_pre_stop_handler_http_get_path
        if self.lifecycle_pre_stop_handler_http_get_port is not None:
            result['LifecyclePreStopHandlerHttpGetPort'] = self.lifecycle_pre_stop_handler_http_get_port
        if self.lifecycle_pre_stop_handler_http_get_scheme is not None:
            result['LifecyclePreStopHandlerHttpGetScheme'] = self.lifecycle_pre_stop_handler_http_get_scheme
        if self.lifecycle_pre_stop_handler_tcp_socket_host is not None:
            result['LifecyclePreStopHandlerTcpSocketHost'] = self.lifecycle_pre_stop_handler_tcp_socket_host
        if self.lifecycle_pre_stop_handler_tcp_socket_port is not None:
            result['LifecyclePreStopHandlerTcpSocketPort'] = self.lifecycle_pre_stop_handler_tcp_socket_port
        if self.liveness_probe_exec_commands is not None:
            result['LivenessProbeExecCommands'] = self.liveness_probe_exec_commands
        if self.liveness_probe_failure_threshold is not None:
            result['LivenessProbeFailureThreshold'] = self.liveness_probe_failure_threshold
        if self.liveness_probe_http_get_path is not None:
            result['LivenessProbeHttpGetPath'] = self.liveness_probe_http_get_path
        if self.liveness_probe_http_get_port is not None:
            result['LivenessProbeHttpGetPort'] = self.liveness_probe_http_get_port
        if self.liveness_probe_http_get_scheme is not None:
            result['LivenessProbeHttpGetScheme'] = self.liveness_probe_http_get_scheme
        if self.liveness_probe_initial_delay_seconds is not None:
            result['LivenessProbeInitialDelaySeconds'] = self.liveness_probe_initial_delay_seconds
        if self.liveness_probe_period_seconds is not None:
            result['LivenessProbePeriodSeconds'] = self.liveness_probe_period_seconds
        if self.liveness_probe_success_threshold is not None:
            result['LivenessProbeSuccessThreshold'] = self.liveness_probe_success_threshold
        if self.liveness_probe_tcp_socket_port is not None:
            result['LivenessProbeTcpSocketPort'] = self.liveness_probe_tcp_socket_port
        if self.liveness_probe_timeout_seconds is not None:
            result['LivenessProbeTimeoutSeconds'] = self.liveness_probe_timeout_seconds
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.name is not None:
            result['Name'] = self.name
        result['Ports'] = []
        if self.ports is not None:
            for k in self.ports:
                result['Ports'].append(k.to_map() if k else None)
        if self.readiness_probe_exec_commands is not None:
            result['ReadinessProbeExecCommands'] = self.readiness_probe_exec_commands
        if self.readiness_probe_failure_threshold is not None:
            result['ReadinessProbeFailureThreshold'] = self.readiness_probe_failure_threshold
        if self.readiness_probe_http_get_path is not None:
            result['ReadinessProbeHttpGetPath'] = self.readiness_probe_http_get_path
        if self.readiness_probe_http_get_port is not None:
            result['ReadinessProbeHttpGetPort'] = self.readiness_probe_http_get_port
        if self.readiness_probe_http_get_scheme is not None:
            result['ReadinessProbeHttpGetScheme'] = self.readiness_probe_http_get_scheme
        if self.readiness_probe_initial_delay_seconds is not None:
            result['ReadinessProbeInitialDelaySeconds'] = self.readiness_probe_initial_delay_seconds
        if self.readiness_probe_period_seconds is not None:
            result['ReadinessProbePeriodSeconds'] = self.readiness_probe_period_seconds
        if self.readiness_probe_success_threshold is not None:
            result['ReadinessProbeSuccessThreshold'] = self.readiness_probe_success_threshold
        if self.readiness_probe_tcp_socket_port is not None:
            result['ReadinessProbeTcpSocketPort'] = self.readiness_probe_tcp_socket_port
        if self.readiness_probe_timeout_seconds is not None:
            result['ReadinessProbeTimeoutSeconds'] = self.readiness_probe_timeout_seconds
        if self.security_context_capability_adds is not None:
            result['SecurityContextCapabilityAdds'] = self.security_context_capability_adds
        if self.security_context_read_only_root_filesystem is not None:
            result['SecurityContextReadOnlyRootFilesystem'] = self.security_context_read_only_root_filesystem
        if self.security_context_run_as_user is not None:
            result['SecurityContextRunAsUser'] = self.security_context_run_as_user
        if self.stdin is not None:
            result['Stdin'] = self.stdin
        if self.stdin_once is not None:
            result['StdinOnce'] = self.stdin_once
        if self.tty is not None:
            result['Tty'] = self.tty
        result['VolumeMounts'] = []
        if self.volume_mounts is not None:
            for k in self.volume_mounts:
                result['VolumeMounts'].append(k.to_map() if k else None)
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('Commands') is not None:
            self.commands = m.get('Commands')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        self.environment_vars = []
        if m.get('EnvironmentVars') is not None:
            for k in m.get('EnvironmentVars'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainersEnvironmentVars()
                self.environment_vars.append(temp_model.from_map(k))
        if m.get('Gpu') is not None:
            self.gpu = m.get('Gpu')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImagePullPolicy') is not None:
            self.image_pull_policy = m.get('ImagePullPolicy')
        if m.get('LifecyclePostStartHandlerExecs') is not None:
            self.lifecycle_post_start_handler_execs = m.get('LifecyclePostStartHandlerExecs')
        if m.get('LifecyclePostStartHandlerHttpGetHost') is not None:
            self.lifecycle_post_start_handler_http_get_host = m.get('LifecyclePostStartHandlerHttpGetHost')
        if m.get('LifecyclePostStartHandlerHttpGetPath') is not None:
            self.lifecycle_post_start_handler_http_get_path = m.get('LifecyclePostStartHandlerHttpGetPath')
        if m.get('LifecyclePostStartHandlerHttpGetPort') is not None:
            self.lifecycle_post_start_handler_http_get_port = m.get('LifecyclePostStartHandlerHttpGetPort')
        if m.get('LifecyclePostStartHandlerHttpGetScheme') is not None:
            self.lifecycle_post_start_handler_http_get_scheme = m.get('LifecyclePostStartHandlerHttpGetScheme')
        if m.get('LifecyclePostStartHandlerTcpSocketHost') is not None:
            self.lifecycle_post_start_handler_tcp_socket_host = m.get('LifecyclePostStartHandlerTcpSocketHost')
        if m.get('LifecyclePostStartHandlerTcpSocketPort') is not None:
            self.lifecycle_post_start_handler_tcp_socket_port = m.get('LifecyclePostStartHandlerTcpSocketPort')
        if m.get('LifecyclePreStopHandlerExecs') is not None:
            self.lifecycle_pre_stop_handler_execs = m.get('LifecyclePreStopHandlerExecs')
        if m.get('LifecyclePreStopHandlerHttpGetHost') is not None:
            self.lifecycle_pre_stop_handler_http_get_host = m.get('LifecyclePreStopHandlerHttpGetHost')
        if m.get('LifecyclePreStopHandlerHttpGetPath') is not None:
            self.lifecycle_pre_stop_handler_http_get_path = m.get('LifecyclePreStopHandlerHttpGetPath')
        if m.get('LifecyclePreStopHandlerHttpGetPort') is not None:
            self.lifecycle_pre_stop_handler_http_get_port = m.get('LifecyclePreStopHandlerHttpGetPort')
        if m.get('LifecyclePreStopHandlerHttpGetScheme') is not None:
            self.lifecycle_pre_stop_handler_http_get_scheme = m.get('LifecyclePreStopHandlerHttpGetScheme')
        if m.get('LifecyclePreStopHandlerTcpSocketHost') is not None:
            self.lifecycle_pre_stop_handler_tcp_socket_host = m.get('LifecyclePreStopHandlerTcpSocketHost')
        if m.get('LifecyclePreStopHandlerTcpSocketPort') is not None:
            self.lifecycle_pre_stop_handler_tcp_socket_port = m.get('LifecyclePreStopHandlerTcpSocketPort')
        if m.get('LivenessProbeExecCommands') is not None:
            self.liveness_probe_exec_commands = m.get('LivenessProbeExecCommands')
        if m.get('LivenessProbeFailureThreshold') is not None:
            self.liveness_probe_failure_threshold = m.get('LivenessProbeFailureThreshold')
        if m.get('LivenessProbeHttpGetPath') is not None:
            self.liveness_probe_http_get_path = m.get('LivenessProbeHttpGetPath')
        if m.get('LivenessProbeHttpGetPort') is not None:
            self.liveness_probe_http_get_port = m.get('LivenessProbeHttpGetPort')
        if m.get('LivenessProbeHttpGetScheme') is not None:
            self.liveness_probe_http_get_scheme = m.get('LivenessProbeHttpGetScheme')
        if m.get('LivenessProbeInitialDelaySeconds') is not None:
            self.liveness_probe_initial_delay_seconds = m.get('LivenessProbeInitialDelaySeconds')
        if m.get('LivenessProbePeriodSeconds') is not None:
            self.liveness_probe_period_seconds = m.get('LivenessProbePeriodSeconds')
        if m.get('LivenessProbeSuccessThreshold') is not None:
            self.liveness_probe_success_threshold = m.get('LivenessProbeSuccessThreshold')
        if m.get('LivenessProbeTcpSocketPort') is not None:
            self.liveness_probe_tcp_socket_port = m.get('LivenessProbeTcpSocketPort')
        if m.get('LivenessProbeTimeoutSeconds') is not None:
            self.liveness_probe_timeout_seconds = m.get('LivenessProbeTimeoutSeconds')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.ports = []
        if m.get('Ports') is not None:
            for k in m.get('Ports'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainersPorts()
                self.ports.append(temp_model.from_map(k))
        if m.get('ReadinessProbeExecCommands') is not None:
            self.readiness_probe_exec_commands = m.get('ReadinessProbeExecCommands')
        if m.get('ReadinessProbeFailureThreshold') is not None:
            self.readiness_probe_failure_threshold = m.get('ReadinessProbeFailureThreshold')
        if m.get('ReadinessProbeHttpGetPath') is not None:
            self.readiness_probe_http_get_path = m.get('ReadinessProbeHttpGetPath')
        if m.get('ReadinessProbeHttpGetPort') is not None:
            self.readiness_probe_http_get_port = m.get('ReadinessProbeHttpGetPort')
        if m.get('ReadinessProbeHttpGetScheme') is not None:
            self.readiness_probe_http_get_scheme = m.get('ReadinessProbeHttpGetScheme')
        if m.get('ReadinessProbeInitialDelaySeconds') is not None:
            self.readiness_probe_initial_delay_seconds = m.get('ReadinessProbeInitialDelaySeconds')
        if m.get('ReadinessProbePeriodSeconds') is not None:
            self.readiness_probe_period_seconds = m.get('ReadinessProbePeriodSeconds')
        if m.get('ReadinessProbeSuccessThreshold') is not None:
            self.readiness_probe_success_threshold = m.get('ReadinessProbeSuccessThreshold')
        if m.get('ReadinessProbeTcpSocketPort') is not None:
            self.readiness_probe_tcp_socket_port = m.get('ReadinessProbeTcpSocketPort')
        if m.get('ReadinessProbeTimeoutSeconds') is not None:
            self.readiness_probe_timeout_seconds = m.get('ReadinessProbeTimeoutSeconds')
        if m.get('SecurityContextCapabilityAdds') is not None:
            self.security_context_capability_adds = m.get('SecurityContextCapabilityAdds')
        if m.get('SecurityContextReadOnlyRootFilesystem') is not None:
            self.security_context_read_only_root_filesystem = m.get('SecurityContextReadOnlyRootFilesystem')
        if m.get('SecurityContextRunAsUser') is not None:
            self.security_context_run_as_user = m.get('SecurityContextRunAsUser')
        if m.get('Stdin') is not None:
            self.stdin = m.get('Stdin')
        if m.get('StdinOnce') is not None:
            self.stdin_once = m.get('StdinOnce')
        if m.get('Tty') is not None:
            self.tty = m.get('Tty')
        self.volume_mounts = []
        if m.get('VolumeMounts') is not None:
            for k in m.get('VolumeMounts'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainersVolumeMounts()
                self.volume_mounts.append(temp_model.from_map(k))
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationDnsConfigOptions(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The variable name of the option.
        self.name = name
        # The variable value of the option.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationHostAliases(TeaModel):
    def __init__(
        self,
        hostnames: List[str] = None,
        ip: str = None,
    ):
        # The added hostnames.
        self.hostnames = hostnames
        # The added IP address.
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostnames is not None:
            result['Hostnames'] = self.hostnames
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Hostnames') is not None:
            self.hostnames = m.get('Hostnames')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationImageRegistryCredentials(TeaModel):
    def __init__(
        self,
        password: str = None,
        server: str = None,
        user_name: str = None,
    ):
        # The password of the image repository.
        self.password = password
        # The domain name of the image repository.
        self.server = server
        # The username of the image repository.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.server is not None:
            result['Server'] = self.server
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainersInitContainerEnvironmentVars(TeaModel):
    def __init__(
        self,
        field_ref_field_path: str = None,
        key: str = None,
        value: str = None,
    ):
        # >  This parameter is not available for use.
        self.field_ref_field_path = field_ref_field_path
        # The name of the environment variable.
        self.key = key
        # The value of the environment variable.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_ref_field_path is not None:
            result['FieldRefFieldPath'] = self.field_ref_field_path
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldRefFieldPath') is not None:
            self.field_ref_field_path = m.get('FieldRefFieldPath')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainersInitContainerPorts(TeaModel):
    def __init__(
        self,
        port: int = None,
        protocol: str = None,
    ):
        # The port number. Valid values: 1 to 65535.
        self.port = port
        # The protocol type. Valid values:
        # 
        # *   TCP
        # *   UDP
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainersInitContainerVolumeMounts(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        mount_propagation: str = None,
        name: str = None,
        read_only: bool = None,
        sub_path: str = None,
    ):
        # The directory to which the init container mounts the volume.
        # 
        # >  Data in this directory is overwritten by the data on the volume. Proceed with caution if you specify this parameter.
        self.mount_path = mount_path
        # The mount propagation setting of the volume. Mount propagation enables volumes mounted on one container to be shared among other containers within the same pod or across distinct pods residing on the same node. Valid values:
        # 
        # *   None: Subsequent mounts executed either on the volume itself or its subdirectories do not propagate to the already established volume mount.
        # *   HostToCotainer: Subsequent mounts executed either on the volume itself or its subdirectories propagate to the already established volume mount.
        # *   Bidirectional: This value is similar to HostToCotainer. Subsequent mounts executed either on the volume itself or its subdirectories propagate to the already established volume mount. In addition, any volume mounts executed on the container not only propagate back to the underlying host but also to all containers across every pod that uses the same volume.
        # 
        # Default value: None.
        self.mount_propagation = mount_propagation
        # The volume name.
        self.name = name
        # Indicates whether the mount directory is read-only.
        # 
        # Default value: false.
        self.read_only = read_only
        # The subdirectory of the volume.
        self.sub_path = sub_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        if self.mount_propagation is not None:
            result['MountPropagation'] = self.mount_propagation
        if self.name is not None:
            result['Name'] = self.name
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.sub_path is not None:
            result['SubPath'] = self.sub_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        if m.get('MountPropagation') is not None:
            self.mount_propagation = m.get('MountPropagation')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('SubPath') is not None:
            self.sub_path = m.get('SubPath')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainers(TeaModel):
    def __init__(
        self,
        cpu: float = None,
        gpu: int = None,
        image: str = None,
        image_pull_policy: str = None,
        init_container_args: List[str] = None,
        init_container_commands: List[str] = None,
        init_container_environment_vars: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainersInitContainerEnvironmentVars] = None,
        init_container_ports: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainersInitContainerPorts] = None,
        init_container_volume_mounts: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainersInitContainerVolumeMounts] = None,
        memory: float = None,
        name: str = None,
        security_context_capability_adds: List[str] = None,
        security_context_read_only_root_filesystem: bool = None,
        security_context_run_as_user: str = None,
        working_dir: str = None,
    ):
        # The number of vCPUs that are allocated to the init container.
        self.cpu = cpu
        # The number of GPUs that are allocated to the init container.
        self.gpu = gpu
        # The image of the init container.
        self.image = image
        # The image pulling policy.
        self.image_pull_policy = image_pull_policy
        # The arguments that are passed to the startup commands of the init container.
        self.init_container_args = init_container_args
        # The commands that are used to start the init container.
        self.init_container_commands = init_container_commands
        # The environment variables of the init container.
        self.init_container_environment_vars = init_container_environment_vars
        # The ports of the init container.
        self.init_container_ports = init_container_ports
        # The volume mounts of the init container.
        self.init_container_volume_mounts = init_container_volume_mounts
        # The memory size of the init container.
        self.memory = memory
        # The name of the init container.
        self.name = name
        # The permissions that are granted to the processes in the init container. Valid values: NET_ADMIN and NET_RAW.
        self.security_context_capability_adds = security_context_capability_adds
        # Indicates whether the root file system on which the init container runs is read-only. Valid value: true.
        self.security_context_read_only_root_filesystem = security_context_read_only_root_filesystem
        # The ID of the user that runs the init container.
        self.security_context_run_as_user = security_context_run_as_user
        # The working directory of the init container.
        self.working_dir = working_dir

    def validate(self):
        if self.init_container_environment_vars:
            for k in self.init_container_environment_vars:
                if k:
                    k.validate()
        if self.init_container_ports:
            for k in self.init_container_ports:
                if k:
                    k.validate()
        if self.init_container_volume_mounts:
            for k in self.init_container_volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.gpu is not None:
            result['Gpu'] = self.gpu
        if self.image is not None:
            result['Image'] = self.image
        if self.image_pull_policy is not None:
            result['ImagePullPolicy'] = self.image_pull_policy
        if self.init_container_args is not None:
            result['InitContainerArgs'] = self.init_container_args
        if self.init_container_commands is not None:
            result['InitContainerCommands'] = self.init_container_commands
        result['InitContainerEnvironmentVars'] = []
        if self.init_container_environment_vars is not None:
            for k in self.init_container_environment_vars:
                result['InitContainerEnvironmentVars'].append(k.to_map() if k else None)
        result['InitContainerPorts'] = []
        if self.init_container_ports is not None:
            for k in self.init_container_ports:
                result['InitContainerPorts'].append(k.to_map() if k else None)
        result['InitContainerVolumeMounts'] = []
        if self.init_container_volume_mounts is not None:
            for k in self.init_container_volume_mounts:
                result['InitContainerVolumeMounts'].append(k.to_map() if k else None)
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.name is not None:
            result['Name'] = self.name
        if self.security_context_capability_adds is not None:
            result['SecurityContextCapabilityAdds'] = self.security_context_capability_adds
        if self.security_context_read_only_root_filesystem is not None:
            result['SecurityContextReadOnlyRootFilesystem'] = self.security_context_read_only_root_filesystem
        if self.security_context_run_as_user is not None:
            result['SecurityContextRunAsUser'] = self.security_context_run_as_user
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('Gpu') is not None:
            self.gpu = m.get('Gpu')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImagePullPolicy') is not None:
            self.image_pull_policy = m.get('ImagePullPolicy')
        if m.get('InitContainerArgs') is not None:
            self.init_container_args = m.get('InitContainerArgs')
        if m.get('InitContainerCommands') is not None:
            self.init_container_commands = m.get('InitContainerCommands')
        self.init_container_environment_vars = []
        if m.get('InitContainerEnvironmentVars') is not None:
            for k in m.get('InitContainerEnvironmentVars'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainersInitContainerEnvironmentVars()
                self.init_container_environment_vars.append(temp_model.from_map(k))
        self.init_container_ports = []
        if m.get('InitContainerPorts') is not None:
            for k in m.get('InitContainerPorts'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainersInitContainerPorts()
                self.init_container_ports.append(temp_model.from_map(k))
        self.init_container_volume_mounts = []
        if m.get('InitContainerVolumeMounts') is not None:
            for k in m.get('InitContainerVolumeMounts'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainersInitContainerVolumeMounts()
                self.init_container_volume_mounts.append(temp_model.from_map(k))
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SecurityContextCapabilityAdds') is not None:
            self.security_context_capability_adds = m.get('SecurityContextCapabilityAdds')
        if m.get('SecurityContextReadOnlyRootFilesystem') is not None:
            self.security_context_read_only_root_filesystem = m.get('SecurityContextReadOnlyRootFilesystem')
        if m.get('SecurityContextRunAsUser') is not None:
            self.security_context_run_as_user = m.get('SecurityContextRunAsUser')
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationSecurityContextSysCtls(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The system name of the security context in which the elastic container instance runs.
        self.name = name
        # The variable value of the security context in which the elastic container instance runs.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key.
        self.key = key
        # The tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationVolumesConfigFileVolumeConfigFileToPaths(TeaModel):
    def __init__(
        self,
        content: str = None,
        mode: int = None,
        path: str = None,
    ):
        # The content of the configuration file.
        self.content = content
        # The permissions on the ConfigFile volume.
        self.mode = mode
        # The path to the configuration file.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationVolumes(TeaModel):
    def __init__(
        self,
        config_file_volume_config_file_to_paths: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationVolumesConfigFileVolumeConfigFileToPaths] = None,
        config_file_volume_default_mode: int = None,
        disk_volume_disk_id: str = None,
        disk_volume_disk_size: int = None,
        disk_volume_fs_type: str = None,
        empty_dir_volume_medium: str = None,
        empty_dir_volume_size_limit: str = None,
        flex_volume_driver: str = None,
        flex_volume_fs_type: str = None,
        flex_volume_options: str = None,
        host_path_volume_path: str = None,
        host_path_volume_type: str = None,
        nfsvolume_path: str = None,
        nfsvolume_read_only: bool = None,
        nfsvolume_server: str = None,
        name: str = None,
        type: str = None,
    ):
        # The paths to the configuration files.
        self.config_file_volume_config_file_to_paths = config_file_volume_config_file_to_paths
        # The default permissions on the ConfigFile volume.
        self.config_file_volume_default_mode = config_file_volume_default_mode
        # The ID of the disk volume.
        self.disk_volume_disk_id = disk_volume_disk_id
        # The size of the disk volume. Unit: GiB.
        self.disk_volume_disk_size = disk_volume_disk_size
        # The system type of the disk volume.
        self.disk_volume_fs_type = disk_volume_fs_type
        # The storage medium of the emptyDir volume. If you do not specify a storage medium for the emptyDir volume, the volume stores data in the file system of the node by default. We recommend that you set this parameter to memory. In this case, the emptyDir volume stores data in the specified memory.
        self.empty_dir_volume_medium = empty_dir_volume_medium
        # The storage size of the emptyDir volume.
        self.empty_dir_volume_size_limit = empty_dir_volume_size_limit
        # The name of the FlexVolume driver.
        self.flex_volume_driver = flex_volume_driver
        # The type of the mounted file system. The default value is determined by the script of FlexVolume.
        self.flex_volume_fs_type = flex_volume_fs_type
        # The FlexVolume options.
        self.flex_volume_options = flex_volume_options
        # The path to the HostPath volume on the host.
        self.host_path_volume_path = host_path_volume_path
        # The type of the HostPath volume.
        self.host_path_volume_type = host_path_volume_type
        # The path to the Network File System (NFS) volume.
        self.nfsvolume_path = nfsvolume_path
        # Indicates whether the NFS volume is read-only.
        # 
        # Default value: false.
        self.nfsvolume_read_only = nfsvolume_read_only
        # The endpoint of the NFS server.
        self.nfsvolume_server = nfsvolume_server
        # The volume name.
        self.name = name
        # The volume type. Valid values:
        # 
        # *   EmptyDirVolume
        # *   NFSVolume
        # *   ConfigFileVolume
        # *   FlexVolume
        self.type = type

    def validate(self):
        if self.config_file_volume_config_file_to_paths:
            for k in self.config_file_volume_config_file_to_paths:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigFileVolumeConfigFileToPaths'] = []
        if self.config_file_volume_config_file_to_paths is not None:
            for k in self.config_file_volume_config_file_to_paths:
                result['ConfigFileVolumeConfigFileToPaths'].append(k.to_map() if k else None)
        if self.config_file_volume_default_mode is not None:
            result['ConfigFileVolumeDefaultMode'] = self.config_file_volume_default_mode
        if self.disk_volume_disk_id is not None:
            result['DiskVolumeDiskId'] = self.disk_volume_disk_id
        if self.disk_volume_disk_size is not None:
            result['DiskVolumeDiskSize'] = self.disk_volume_disk_size
        if self.disk_volume_fs_type is not None:
            result['DiskVolumeFsType'] = self.disk_volume_fs_type
        if self.empty_dir_volume_medium is not None:
            result['EmptyDirVolumeMedium'] = self.empty_dir_volume_medium
        if self.empty_dir_volume_size_limit is not None:
            result['EmptyDirVolumeSizeLimit'] = self.empty_dir_volume_size_limit
        if self.flex_volume_driver is not None:
            result['FlexVolumeDriver'] = self.flex_volume_driver
        if self.flex_volume_fs_type is not None:
            result['FlexVolumeFsType'] = self.flex_volume_fs_type
        if self.flex_volume_options is not None:
            result['FlexVolumeOptions'] = self.flex_volume_options
        if self.host_path_volume_path is not None:
            result['HostPathVolumePath'] = self.host_path_volume_path
        if self.host_path_volume_type is not None:
            result['HostPathVolumeType'] = self.host_path_volume_type
        if self.nfsvolume_path is not None:
            result['NFSVolumePath'] = self.nfsvolume_path
        if self.nfsvolume_read_only is not None:
            result['NFSVolumeReadOnly'] = self.nfsvolume_read_only
        if self.nfsvolume_server is not None:
            result['NFSVolumeServer'] = self.nfsvolume_server
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_file_volume_config_file_to_paths = []
        if m.get('ConfigFileVolumeConfigFileToPaths') is not None:
            for k in m.get('ConfigFileVolumeConfigFileToPaths'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationVolumesConfigFileVolumeConfigFileToPaths()
                self.config_file_volume_config_file_to_paths.append(temp_model.from_map(k))
        if m.get('ConfigFileVolumeDefaultMode') is not None:
            self.config_file_volume_default_mode = m.get('ConfigFileVolumeDefaultMode')
        if m.get('DiskVolumeDiskId') is not None:
            self.disk_volume_disk_id = m.get('DiskVolumeDiskId')
        if m.get('DiskVolumeDiskSize') is not None:
            self.disk_volume_disk_size = m.get('DiskVolumeDiskSize')
        if m.get('DiskVolumeFsType') is not None:
            self.disk_volume_fs_type = m.get('DiskVolumeFsType')
        if m.get('EmptyDirVolumeMedium') is not None:
            self.empty_dir_volume_medium = m.get('EmptyDirVolumeMedium')
        if m.get('EmptyDirVolumeSizeLimit') is not None:
            self.empty_dir_volume_size_limit = m.get('EmptyDirVolumeSizeLimit')
        if m.get('FlexVolumeDriver') is not None:
            self.flex_volume_driver = m.get('FlexVolumeDriver')
        if m.get('FlexVolumeFsType') is not None:
            self.flex_volume_fs_type = m.get('FlexVolumeFsType')
        if m.get('FlexVolumeOptions') is not None:
            self.flex_volume_options = m.get('FlexVolumeOptions')
        if m.get('HostPathVolumePath') is not None:
            self.host_path_volume_path = m.get('HostPathVolumePath')
        if m.get('HostPathVolumeType') is not None:
            self.host_path_volume_type = m.get('HostPathVolumeType')
        if m.get('NFSVolumePath') is not None:
            self.nfsvolume_path = m.get('NFSVolumePath')
        if m.get('NFSVolumeReadOnly') is not None:
            self.nfsvolume_read_only = m.get('NFSVolumeReadOnly')
        if m.get('NFSVolumeServer') is not None:
            self.nfsvolume_server = m.get('NFSVolumeServer')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeEciScalingConfigurationDetailResponseBodyScalingConfiguration(TeaModel):
    def __init__(
        self,
        acr_registry_infos: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationAcrRegistryInfos] = None,
        active_deadline_seconds: int = None,
        auto_create_eip: bool = None,
        auto_match_image_cache: bool = None,
        compute_category: List[str] = None,
        container_group_name: str = None,
        containers: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainers] = None,
        cost_optimization: bool = None,
        cpu: float = None,
        cpu_options_core: int = None,
        cpu_options_threads_per_core: int = None,
        creation_time: str = None,
        data_cache_bucket: str = None,
        data_cache_bursting_enabled: bool = None,
        data_cache_pl: str = None,
        data_cache_provisioned_iops: int = None,
        description: str = None,
        dns_config_name_servers: List[str] = None,
        dns_config_options: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationDnsConfigOptions] = None,
        dns_config_searches: List[str] = None,
        dns_policy: str = None,
        egress_bandwidth: int = None,
        eip_bandwidth: int = None,
        eip_common_bandwidth_package: str = None,
        eip_isp: str = None,
        eip_public_ip_address_pool_id: str = None,
        ephemeral_storage: int = None,
        host_aliases: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationHostAliases] = None,
        host_name: str = None,
        image_registry_credentials: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationImageRegistryCredentials] = None,
        image_snapshot_id: str = None,
        ingress_bandwidth: int = None,
        init_containers: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainers] = None,
        instance_family_level: str = None,
        instance_types: List[str] = None,
        ipv_6address_count: int = None,
        lifecycle_state: str = None,
        load_balancer_weight: int = None,
        memory: float = None,
        ntp_servers: List[str] = None,
        ram_role_name: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        restart_policy: str = None,
        scaling_configuration_id: str = None,
        scaling_configuration_name: str = None,
        scaling_group_id: str = None,
        security_context_sys_ctls: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationSecurityContextSysCtls] = None,
        security_group_id: str = None,
        sls_enable: bool = None,
        spot_price_limit: float = None,
        spot_strategy: str = None,
        tags: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationTags] = None,
        termination_grace_period_seconds: int = None,
        volumes: List[DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationVolumes] = None,
    ):
        # The information about the Container Registry Enterprise Edition instance.
        self.acr_registry_infos = acr_registry_infos
        # The validity period of the scaling configuration. Unit: seconds.
        self.active_deadline_seconds = active_deadline_seconds
        # Indicates whether an elastic IP address (EIP) is automatically created and bound to the elastic container instance.
        self.auto_create_eip = auto_create_eip
        # Indicates whether the image cache is automatically matched. Default value: false.
        self.auto_match_image_cache = auto_match_image_cache
        # The computing power types. A value of economy indicates that economic instance types are returned.
        self.compute_category = compute_category
        # The name of the container group.
        self.container_group_name = container_group_name
        # The containers in the elastic container instance.
        self.containers = containers
        # Indicates whether the Cost Optimization feature is enabled. Valid values:
        # 
        # *   true
        # *   false
        self.cost_optimization = cost_optimization
        # The number of vCPUs that are allocated to the elastic container instance.
        self.cpu = cpu
        # The number of physical CPU cores. You can specify this parameter for only specific instance types.
        self.cpu_options_core = cpu_options_core
        # The number of threads per core. You can specify this parameter for only specific instance types. A value of 1 indicates that Hyper-Threading is disabled. For more information, see [Specify CPU options](https://help.aliyun.com/document_detail/197781.html).
        self.cpu_options_threads_per_core = cpu_options_threads_per_core
        # The time when the scaling configuration was created.
        self.creation_time = creation_time
        # The bucket that caches data.
        self.data_cache_bucket = data_cache_bucket
        # Indicates whether the Performance Burst feature is enabled for the ESSD AutoPL disk that caches data. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        # 
        # >  For more information about ESSD AutoPL disks, see [ESSD AutoPL disks](https://help.aliyun.com/document_detail/122389.html).
        self.data_cache_bursting_enabled = data_cache_bursting_enabled
        # The performance level (PL) of the cloud disk that caches data. We recommend that you use enhanced SSDs (ESSDs). Valid values:
        # 
        # *   PL0: An ESSD can provide up to 10,000 random read/write IOPS.
        # *   PL1: An ESSD can provide up to 50,000 random read/write IOPS.
        # *   PL2: An ESSD can provide up to 100,000 random read/write IOPS.
        # *   PL3: An ESSD can provide up to 1,000,000 random read/write IOPS.
        # 
        # >  For more information about ESSDs, see [ESSDs](https://help.aliyun.com/document_detail/122389.html).
        self.data_cache_pl = data_cache_pl
        # The provisioned read/write IOPS of the ESSD AutoPL disk that caches data. Valid values: 0 to min{50,000, 1,000 x *Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50* x Capacity, 50,000}.
        # 
        # >  For more information about ESSD AutoPL disks, see [ESSD AutoPL disks](https://help.aliyun.com/document_detail/368372.html).
        self.data_cache_provisioned_iops = data_cache_provisioned_iops
        # >  This parameter is not available for use.
        self.description = description
        # The IP addresses of DNS servers.
        self.dns_config_name_servers = dns_config_name_servers
        # The DNS options.
        self.dns_config_options = dns_config_options
        # The search domains of the DNS servers.
        self.dns_config_searches = dns_config_searches
        # The Domain Name System (DNS) policy.
        self.dns_policy = dns_policy
        # The maximum outbound bandwidth. Unit: bit/s.
        self.egress_bandwidth = egress_bandwidth
        # The bandwidth of the EIP. Default value: 5. Unit: Mbit/s.
        self.eip_bandwidth = eip_bandwidth
        # The bound EIP bandwidth plan.
        self.eip_common_bandwidth_package = eip_common_bandwidth_package
        # The line type of the EIP. Valid values:
        # 
        # *   BGP: BGP (Multi-ISP) lines
        # *   BGP_PRO: BGP (Multi-ISP) Pro
        self.eip_isp = eip_isp
        # The ID of the IP address pool.
        self.eip_public_ip_address_pool_id = eip_public_ip_address_pool_id
        # The size of the temporary storage space. Unit: GiB.
        self.ephemeral_storage = ephemeral_storage
        # The custom hostname mappings of a container in the elastic container instance.
        self.host_aliases = host_aliases
        # The hostname.
        self.host_name = host_name
        # The image repositories.
        self.image_registry_credentials = image_registry_credentials
        # The ID of the image cache.
        self.image_snapshot_id = image_snapshot_id
        # The maximum inbound bandwidth. Unit: bit/s.
        self.ingress_bandwidth = ingress_bandwidth
        # The init containers.
        self.init_containers = init_containers
        # The level of the instance family, which is used to filter instance types that meet the specified criteria. This parameter takes effect only if `CostOptimization` is set to true. Valid values:
        # 
        # *   EntryLevel: entry level (shared instance types). Instance types of this level are the most cost-effective but may not provide stable computing performance in a consistent manner. Instance types of this level are suitable for business scenarios in which the CPU utilization is low. For more information, see [Shared instance families](https://help.aliyun.com/document_detail/108489.html).
        # *   EnterpriseLevel: enterprise level. Instance types of this level provide stable performance and dedicated resources and are suitable for business scenarios that require high stability. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        # *   CreditEntryLevel: credit entry level (burstable instance types). CPU credits are used to ensure computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low but may fluctuate in specific cases. For more information, see [Overview](https://help.aliyun.com/document_detail/59977.html) of burstable instances.
        self.instance_family_level = instance_family_level
        # The specified ECS instance types. You can specify up to five instance types.
        self.instance_types = instance_types
        # The number of IPv6 addresses.
        self.ipv_6address_count = ipv_6address_count
        # The state of the scaling configuration in the scaling group. Valid values:
        # 
        # *   Active: The scaling configuration is active in the scaling group. Auto Scaling uses the active scaling configuration to automatically create elastic container instances.
        # *   Inactive: The scaling configuration is inactive in the scaling group. Inactive scaling configurations are retained in scaling groups. However, Auto Scaling does not use inactive scaling groups to create elastic container instances.
        self.lifecycle_state = lifecycle_state
        # The weight of an elastic container instance as a Server Load Balancer (SLB) backend server. Valid values: 1 to 100.
        # 
        # Default value: 50.
        self.load_balancer_weight = load_balancer_weight
        # The memory size. Unit: GiB.
        # 
        # You can specify CPU and Memory to define the range of instance types. For example, if you set CPU to 2 and Memory to 16, the instance types that have 2 vCPUs and 16 GiB are returned. If you specify CPU and Memory, Auto Scaling determines the available instance types based on factors such as I/O optimization requirements and zones and preferentially creates instances by using the lowest-priced instance type.
        # 
        # >  You can specify CPU and Memory to define instance types only when you set Scaling Policy to Cost Optimization and no instance type is specified in the scaling configuration.
        self.memory = memory
        # The endpoints of the Network Time Protocol (NTP) servers.
        self.ntp_servers = ntp_servers
        # The Resource Access Management (RAM) role of the elastic container instance. Elastic container instances and Elastic Compute Service (ECS) instances can share the same RAM role. For more information, see [Use the instance RAM role by calling APIs](https://help.aliyun.com/document_detail/61178.html).
        self.ram_role_name = ram_role_name
        # The region ID of the scaling group to which the scaling configuration belongs.
        self.region_id = region_id
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The restart policy of the container group. Valid values:
        # 
        # *   Never: The container group is never restarted.
        # *   Always: The container group is always restarted.
        # *   OnFailure: The container group is restarted upon failures.
        self.restart_policy = restart_policy
        # The ID of the scaling configuration.
        self.scaling_configuration_id = scaling_configuration_id
        # The name of the scaling configuration.
        self.scaling_configuration_name = scaling_configuration_name
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id
        # The system information of the security context in which the elastic container instance is run.
        self.security_context_sys_ctls = security_context_sys_ctls
        # The ID of the security group with which the elastic container instance is associated. Elastic container instances that are associated with the same security group can access each other.
        self.security_group_id = security_group_id
        # Indicates whether user logs are collected. Default value: **false**.
        self.sls_enable = sls_enable
        # The maximum hourly price for the preemptible instance.
        # 
        # This parameter is returned only when SpotStrategy is set to SpotWithPriceLimit.
        self.spot_price_limit = spot_price_limit
        # The preemption policy of the instance. Valid values:
        # 
        # *   NoSpot: The instance is created as a regular pay-as-you-go instance.
        # *   SpotWithPriceLimit: The instance is a preemptible instance with a user-defined maximum hourly price.
        # *   SpotAsPriceGo: The instance is a preemptible instance for which the market price at the time of purchase is used as the bid price.
        self.spot_strategy = spot_strategy
        # The tags of the elastic container instance. Tags are specified in the key-value format.
        self.tags = tags
        # The buffer time during which a program handles operations before the program stops.
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # The volumes.
        self.volumes = volumes

    def validate(self):
        if self.acr_registry_infos:
            for k in self.acr_registry_infos:
                if k:
                    k.validate()
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()
        if self.dns_config_options:
            for k in self.dns_config_options:
                if k:
                    k.validate()
        if self.host_aliases:
            for k in self.host_aliases:
                if k:
                    k.validate()
        if self.image_registry_credentials:
            for k in self.image_registry_credentials:
                if k:
                    k.validate()
        if self.init_containers:
            for k in self.init_containers:
                if k:
                    k.validate()
        if self.security_context_sys_ctls:
            for k in self.security_context_sys_ctls:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.volumes:
            for k in self.volumes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AcrRegistryInfos'] = []
        if self.acr_registry_infos is not None:
            for k in self.acr_registry_infos:
                result['AcrRegistryInfos'].append(k.to_map() if k else None)
        if self.active_deadline_seconds is not None:
            result['ActiveDeadlineSeconds'] = self.active_deadline_seconds
        if self.auto_create_eip is not None:
            result['AutoCreateEip'] = self.auto_create_eip
        if self.auto_match_image_cache is not None:
            result['AutoMatchImageCache'] = self.auto_match_image_cache
        if self.compute_category is not None:
            result['ComputeCategory'] = self.compute_category
        if self.container_group_name is not None:
            result['ContainerGroupName'] = self.container_group_name
        result['Containers'] = []
        if self.containers is not None:
            for k in self.containers:
                result['Containers'].append(k.to_map() if k else None)
        if self.cost_optimization is not None:
            result['CostOptimization'] = self.cost_optimization
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.cpu_options_core is not None:
            result['CpuOptionsCore'] = self.cpu_options_core
        if self.cpu_options_threads_per_core is not None:
            result['CpuOptionsThreadsPerCore'] = self.cpu_options_threads_per_core
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.data_cache_bucket is not None:
            result['DataCacheBucket'] = self.data_cache_bucket
        if self.data_cache_bursting_enabled is not None:
            result['DataCacheBurstingEnabled'] = self.data_cache_bursting_enabled
        if self.data_cache_pl is not None:
            result['DataCachePL'] = self.data_cache_pl
        if self.data_cache_provisioned_iops is not None:
            result['DataCacheProvisionedIops'] = self.data_cache_provisioned_iops
        if self.description is not None:
            result['Description'] = self.description
        if self.dns_config_name_servers is not None:
            result['DnsConfigNameServers'] = self.dns_config_name_servers
        result['DnsConfigOptions'] = []
        if self.dns_config_options is not None:
            for k in self.dns_config_options:
                result['DnsConfigOptions'].append(k.to_map() if k else None)
        if self.dns_config_searches is not None:
            result['DnsConfigSearches'] = self.dns_config_searches
        if self.dns_policy is not None:
            result['DnsPolicy'] = self.dns_policy
        if self.egress_bandwidth is not None:
            result['EgressBandwidth'] = self.egress_bandwidth
        if self.eip_bandwidth is not None:
            result['EipBandwidth'] = self.eip_bandwidth
        if self.eip_common_bandwidth_package is not None:
            result['EipCommonBandwidthPackage'] = self.eip_common_bandwidth_package
        if self.eip_isp is not None:
            result['EipISP'] = self.eip_isp
        if self.eip_public_ip_address_pool_id is not None:
            result['EipPublicIpAddressPoolId'] = self.eip_public_ip_address_pool_id
        if self.ephemeral_storage is not None:
            result['EphemeralStorage'] = self.ephemeral_storage
        result['HostAliases'] = []
        if self.host_aliases is not None:
            for k in self.host_aliases:
                result['HostAliases'].append(k.to_map() if k else None)
        if self.host_name is not None:
            result['HostName'] = self.host_name
        result['ImageRegistryCredentials'] = []
        if self.image_registry_credentials is not None:
            for k in self.image_registry_credentials:
                result['ImageRegistryCredentials'].append(k.to_map() if k else None)
        if self.image_snapshot_id is not None:
            result['ImageSnapshotId'] = self.image_snapshot_id
        if self.ingress_bandwidth is not None:
            result['IngressBandwidth'] = self.ingress_bandwidth
        result['InitContainers'] = []
        if self.init_containers is not None:
            for k in self.init_containers:
                result['InitContainers'].append(k.to_map() if k else None)
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.lifecycle_state is not None:
            result['LifecycleState'] = self.lifecycle_state
        if self.load_balancer_weight is not None:
            result['LoadBalancerWeight'] = self.load_balancer_weight
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.ntp_servers is not None:
            result['NtpServers'] = self.ntp_servers
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.restart_policy is not None:
            result['RestartPolicy'] = self.restart_policy
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        if self.scaling_configuration_name is not None:
            result['ScalingConfigurationName'] = self.scaling_configuration_name
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        result['SecurityContextSysCtls'] = []
        if self.security_context_sys_ctls is not None:
            for k in self.security_context_sys_ctls:
                result['SecurityContextSysCtls'].append(k.to_map() if k else None)
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.sls_enable is not None:
            result['SlsEnable'] = self.sls_enable
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.termination_grace_period_seconds is not None:
            result['TerminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        result['Volumes'] = []
        if self.volumes is not None:
            for k in self.volumes:
                result['Volumes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acr_registry_infos = []
        if m.get('AcrRegistryInfos') is not None:
            for k in m.get('AcrRegistryInfos'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationAcrRegistryInfos()
                self.acr_registry_infos.append(temp_model.from_map(k))
        if m.get('ActiveDeadlineSeconds') is not None:
            self.active_deadline_seconds = m.get('ActiveDeadlineSeconds')
        if m.get('AutoCreateEip') is not None:
            self.auto_create_eip = m.get('AutoCreateEip')
        if m.get('AutoMatchImageCache') is not None:
            self.auto_match_image_cache = m.get('AutoMatchImageCache')
        if m.get('ComputeCategory') is not None:
            self.compute_category = m.get('ComputeCategory')
        if m.get('ContainerGroupName') is not None:
            self.container_group_name = m.get('ContainerGroupName')
        self.containers = []
        if m.get('Containers') is not None:
            for k in m.get('Containers'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationContainers()
                self.containers.append(temp_model.from_map(k))
        if m.get('CostOptimization') is not None:
            self.cost_optimization = m.get('CostOptimization')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CpuOptionsCore') is not None:
            self.cpu_options_core = m.get('CpuOptionsCore')
        if m.get('CpuOptionsThreadsPerCore') is not None:
            self.cpu_options_threads_per_core = m.get('CpuOptionsThreadsPerCore')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DataCacheBucket') is not None:
            self.data_cache_bucket = m.get('DataCacheBucket')
        if m.get('DataCacheBurstingEnabled') is not None:
            self.data_cache_bursting_enabled = m.get('DataCacheBurstingEnabled')
        if m.get('DataCachePL') is not None:
            self.data_cache_pl = m.get('DataCachePL')
        if m.get('DataCacheProvisionedIops') is not None:
            self.data_cache_provisioned_iops = m.get('DataCacheProvisionedIops')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DnsConfigNameServers') is not None:
            self.dns_config_name_servers = m.get('DnsConfigNameServers')
        self.dns_config_options = []
        if m.get('DnsConfigOptions') is not None:
            for k in m.get('DnsConfigOptions'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationDnsConfigOptions()
                self.dns_config_options.append(temp_model.from_map(k))
        if m.get('DnsConfigSearches') is not None:
            self.dns_config_searches = m.get('DnsConfigSearches')
        if m.get('DnsPolicy') is not None:
            self.dns_policy = m.get('DnsPolicy')
        if m.get('EgressBandwidth') is not None:
            self.egress_bandwidth = m.get('EgressBandwidth')
        if m.get('EipBandwidth') is not None:
            self.eip_bandwidth = m.get('EipBandwidth')
        if m.get('EipCommonBandwidthPackage') is not None:
            self.eip_common_bandwidth_package = m.get('EipCommonBandwidthPackage')
        if m.get('EipISP') is not None:
            self.eip_isp = m.get('EipISP')
        if m.get('EipPublicIpAddressPoolId') is not None:
            self.eip_public_ip_address_pool_id = m.get('EipPublicIpAddressPoolId')
        if m.get('EphemeralStorage') is not None:
            self.ephemeral_storage = m.get('EphemeralStorage')
        self.host_aliases = []
        if m.get('HostAliases') is not None:
            for k in m.get('HostAliases'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationHostAliases()
                self.host_aliases.append(temp_model.from_map(k))
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        self.image_registry_credentials = []
        if m.get('ImageRegistryCredentials') is not None:
            for k in m.get('ImageRegistryCredentials'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationImageRegistryCredentials()
                self.image_registry_credentials.append(temp_model.from_map(k))
        if m.get('ImageSnapshotId') is not None:
            self.image_snapshot_id = m.get('ImageSnapshotId')
        if m.get('IngressBandwidth') is not None:
            self.ingress_bandwidth = m.get('IngressBandwidth')
        self.init_containers = []
        if m.get('InitContainers') is not None:
            for k in m.get('InitContainers'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationInitContainers()
                self.init_containers.append(temp_model.from_map(k))
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('LifecycleState') is not None:
            self.lifecycle_state = m.get('LifecycleState')
        if m.get('LoadBalancerWeight') is not None:
            self.load_balancer_weight = m.get('LoadBalancerWeight')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NtpServers') is not None:
            self.ntp_servers = m.get('NtpServers')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RestartPolicy') is not None:
            self.restart_policy = m.get('RestartPolicy')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        if m.get('ScalingConfigurationName') is not None:
            self.scaling_configuration_name = m.get('ScalingConfigurationName')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        self.security_context_sys_ctls = []
        if m.get('SecurityContextSysCtls') is not None:
            for k in m.get('SecurityContextSysCtls'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationSecurityContextSysCtls()
                self.security_context_sys_ctls.append(temp_model.from_map(k))
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SlsEnable') is not None:
            self.sls_enable = m.get('SlsEnable')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('TerminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('TerminationGracePeriodSeconds')
        self.volumes = []
        if m.get('Volumes') is not None:
            for k in m.get('Volumes'):
                temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfigurationVolumes()
                self.volumes.append(temp_model.from_map(k))
        return self


class DescribeEciScalingConfigurationDetailResponseBody(TeaModel):
    def __init__(
        self,
        output: str = None,
        request_id: str = None,
        scaling_configuration: DescribeEciScalingConfigurationDetailResponseBodyScalingConfiguration = None,
    ):
        # The YAML output of the scaling configuration.
        self.output = output
        # The request ID.
        self.request_id = request_id
        # The information about the scaling configuration.
        self.scaling_configuration = scaling_configuration

    def validate(self):
        if self.scaling_configuration:
            self.scaling_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output is not None:
            result['Output'] = self.output
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_configuration is not None:
            result['ScalingConfiguration'] = self.scaling_configuration.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Output') is not None:
            self.output = m.get('Output')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingConfiguration') is not None:
            temp_model = DescribeEciScalingConfigurationDetailResponseBodyScalingConfiguration()
            self.scaling_configuration = temp_model.from_map(m['ScalingConfiguration'])
        return self


class DescribeEciScalingConfigurationDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEciScalingConfigurationDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEciScalingConfigurationDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEciScalingConfigurationsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        scaling_configuration_ids: List[str] = None,
        scaling_configuration_names: List[str] = None,
        scaling_group_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The page number. Pages start from page 1.
        # 
        # Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Maximum value: 50.
        # 
        # Default value: 10.
        self.page_size = page_size
        # The region ID of the scaling group to which the scaling configuration belongs.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        # The IDs of the scaling configurations that you want to query. You can specify 1 to 10 scaling configuration IDs.
        # 
        # The IDs of active and inactive scaling configurations are displayed in the query results. You can distinguish between active and inactive scaling configurations based on the value of `LifecycleState`.
        self.scaling_configuration_ids = scaling_configuration_ids
        # The names of the scaling configurations that you want to query. You can specify 1 to 10 scaling configuration names.
        # 
        # The names of inactive scaling configurations are not displayed in the query results, and no error is reported.
        self.scaling_configuration_names = scaling_configuration_names
        # The ID of the scaling group. You can use the ID to query all scaling configurations in the scaling group.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scaling_configuration_ids is not None:
            result['ScalingConfigurationIds'] = self.scaling_configuration_ids
        if self.scaling_configuration_names is not None:
            result['ScalingConfigurationNames'] = self.scaling_configuration_names
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ScalingConfigurationIds') is not None:
            self.scaling_configuration_ids = m.get('ScalingConfigurationIds')
        if m.get('ScalingConfigurationNames') is not None:
            self.scaling_configuration_names = m.get('ScalingConfigurationNames')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsAcrRegistryInfos(TeaModel):
    def __init__(
        self,
        domains: List[str] = None,
        instance_id: str = None,
        instance_name: str = None,
        region_id: str = None,
    ):
        # The domain names of the Container Registry Enterprise Edition instance. By default, all domain names of the instance are displayed. Multiple domain names are separated by commas (,).
        self.domains = domains
        # The ID of the Container Registry Enterprise Edition instance.
        self.instance_id = instance_id
        # The name of the Container Registry Enterprise Edition instance.
        self.instance_name = instance_name
        # The region ID of the Container Registry Enterprise Edition instance.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domains') is not None:
            self.domains = m.get('Domains')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainersEnvironmentVars(TeaModel):
    def __init__(
        self,
        field_ref_field_path: str = None,
        key: str = None,
        value: str = None,
    ):
        # >  This parameter is not available for use.
        self.field_ref_field_path = field_ref_field_path
        # The name of the environment variable.
        self.key = key
        # The value of the environment variable.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_ref_field_path is not None:
            result['FieldRefFieldPath'] = self.field_ref_field_path
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldRefFieldPath') is not None:
            self.field_ref_field_path = m.get('FieldRefFieldPath')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainersPorts(TeaModel):
    def __init__(
        self,
        port: int = None,
        protocol: str = None,
    ):
        # The port number. Valid values: 1 to 65535.
        self.port = port
        # The protocol type. Valid values:
        # 
        # *   TCP
        # *   UDP
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainersVolumeMounts(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        mount_propagation: str = None,
        name: str = None,
        read_only: bool = None,
        sub_path: str = None,
    ):
        # The directory to which the volume is mounted.
        # 
        # >  Data in this directory is overwritten by the data on the volume. Proceed with caution if you specify this parameter.
        self.mount_path = mount_path
        # The mount propagation settings. Mount propagation enables volumes mounted on one container to be shared among other containers within the same pod or across distinct pods residing on the same node. Valid values:
        # 
        # *   None: Subsequent mounts executed either on the volume itself or its subdirectories do not propagate to the already established volume mount.
        # *   HostToCotainer: Subsequent mounts executed either on the volume itself or its subdirectories propagate to the already established volume mount.
        # *   Bidirectional: This value is similar to HostToCotainer. Subsequent mounts executed either on the volume itself or its subdirectories propagate to the already established volume mount. In addition, any volume mounts executed on a container not only propagate back to the underlying host but also to all containers across every pod that uses the same volume.
        # 
        # Default value: None.
        self.mount_propagation = mount_propagation
        # The volume name. The value of this parameter is the same as the name of the volume that is mounted to containers.
        self.name = name
        # Indicates whether the volume is read-only.
        # 
        # Default value: false.
        self.read_only = read_only
        # The volume subdirectory.
        self.sub_path = sub_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        if self.mount_propagation is not None:
            result['MountPropagation'] = self.mount_propagation
        if self.name is not None:
            result['Name'] = self.name
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.sub_path is not None:
            result['SubPath'] = self.sub_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        if m.get('MountPropagation') is not None:
            self.mount_propagation = m.get('MountPropagation')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('SubPath') is not None:
            self.sub_path = m.get('SubPath')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainers(TeaModel):
    def __init__(
        self,
        args: List[str] = None,
        commands: List[str] = None,
        cpu: float = None,
        environment_vars: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainersEnvironmentVars] = None,
        gpu: int = None,
        image: str = None,
        image_pull_policy: str = None,
        lifecycle_post_start_handler_execs: List[str] = None,
        lifecycle_post_start_handler_http_get_host: str = None,
        lifecycle_post_start_handler_http_get_path: str = None,
        lifecycle_post_start_handler_http_get_port: int = None,
        lifecycle_post_start_handler_http_get_scheme: str = None,
        lifecycle_post_start_handler_tcp_socket_host: str = None,
        lifecycle_post_start_handler_tcp_socket_port: int = None,
        lifecycle_pre_stop_handler_execs: List[str] = None,
        lifecycle_pre_stop_handler_http_get_host: str = None,
        lifecycle_pre_stop_handler_http_get_path: str = None,
        lifecycle_pre_stop_handler_http_get_port: int = None,
        lifecycle_pre_stop_handler_http_get_scheme: str = None,
        lifecycle_pre_stop_handler_tcp_socket_host: str = None,
        lifecycle_pre_stop_handler_tcp_socket_port: int = None,
        liveness_probe_exec_commands: List[str] = None,
        liveness_probe_failure_threshold: int = None,
        liveness_probe_http_get_path: str = None,
        liveness_probe_http_get_port: int = None,
        liveness_probe_http_get_scheme: str = None,
        liveness_probe_initial_delay_seconds: int = None,
        liveness_probe_period_seconds: int = None,
        liveness_probe_success_threshold: int = None,
        liveness_probe_tcp_socket_port: int = None,
        liveness_probe_timeout_seconds: int = None,
        memory: float = None,
        name: str = None,
        ports: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainersPorts] = None,
        readiness_probe_exec_commands: List[str] = None,
        readiness_probe_failure_threshold: int = None,
        readiness_probe_http_get_path: str = None,
        readiness_probe_http_get_port: int = None,
        readiness_probe_http_get_scheme: str = None,
        readiness_probe_initial_delay_seconds: int = None,
        readiness_probe_period_seconds: int = None,
        readiness_probe_success_threshold: int = None,
        readiness_probe_tcp_socket_port: int = None,
        readiness_probe_timeout_seconds: int = None,
        security_context_capability_adds: List[str] = None,
        security_context_read_only_root_filesystem: bool = None,
        security_context_run_as_user: int = None,
        stdin: bool = None,
        stdin_once: bool = None,
        tty: bool = None,
        volume_mounts: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainersVolumeMounts] = None,
        working_dir: str = None,
    ):
        # The container startup arguments. You can specify up to 10 arguments.
        self.args = args
        # The container startup commands. You can specify up to 20 commands. Each command can contain up to 256 characters.
        self.commands = commands
        # The number of vCPUs per container.
        self.cpu = cpu
        # The environment variables.
        self.environment_vars = environment_vars
        # The number of GPUs.
        self.gpu = gpu
        # The container image.
        self.image = image
        # The image pulling policy. Valid values:
        # 
        # *   Always: Each time image pulling is performed.
        # *   IfNotPresent: Image pulling is performed as needed. On-premises images are preferentially used. If no on-premises images are available, image pulling is performed.
        # *   Never: On-premises images are always used. Image pulling is not performed.
        self.image_pull_policy = image_pull_policy
        # The commands that are run for configuring the postStart callback function by using the CLI within the container.
        self.lifecycle_post_start_handler_execs = lifecycle_post_start_handler_execs
        # The IP address of the host to which HTTP GET requests for configuring the postStart callback function are sent.
        self.lifecycle_post_start_handler_http_get_host = lifecycle_post_start_handler_http_get_host
        # The path to which HTTP GET requests for configuring the postStart callback function are sent.
        self.lifecycle_post_start_handler_http_get_path = lifecycle_post_start_handler_http_get_path
        # The port over which HTTP GET requests for configuring the postStart callback function are sent.
        self.lifecycle_post_start_handler_http_get_port = lifecycle_post_start_handler_http_get_port
        # The protocol type of the HTTP GET requests that are sent for configuring the postStart callback function.
        self.lifecycle_post_start_handler_http_get_scheme = lifecycle_post_start_handler_http_get_scheme
        # The IP address of the host detected by the TCP sockets used for configuring the postStart callback function.
        self.lifecycle_post_start_handler_tcp_socket_host = lifecycle_post_start_handler_tcp_socket_host
        # The port detected by the TCP sockets used for configuring the postStart callback function.
        self.lifecycle_post_start_handler_tcp_socket_port = lifecycle_post_start_handler_tcp_socket_port
        # The commands that are run for configuring the preStop callback function by using the CLI within the container.
        self.lifecycle_pre_stop_handler_execs = lifecycle_pre_stop_handler_execs
        # The IP address of the host to which HTTP GET requests for configuring the preStop callback function are sent.
        self.lifecycle_pre_stop_handler_http_get_host = lifecycle_pre_stop_handler_http_get_host
        # The path to which HTTP GET requests for configuring the preStop callback function are sent.
        self.lifecycle_pre_stop_handler_http_get_path = lifecycle_pre_stop_handler_http_get_path
        # The port over which HTTP GET requests for configuring the preStop callback function are sent.
        self.lifecycle_pre_stop_handler_http_get_port = lifecycle_pre_stop_handler_http_get_port
        # The protocol type of the HTTP Get requests that are sent for configuring the preStop callback function.
        self.lifecycle_pre_stop_handler_http_get_scheme = lifecycle_pre_stop_handler_http_get_scheme
        # The IP address of the host detected by the TCP sockets used for configuring the preStop callback function.
        self.lifecycle_pre_stop_handler_tcp_socket_host = lifecycle_pre_stop_handler_tcp_socket_host
        # The port detected by the TCP sockets used for configuring the preStop callback function.
        self.lifecycle_pre_stop_handler_tcp_socket_port = lifecycle_pre_stop_handler_tcp_socket_port
        # The commands that are run in the container when you use the CLI to perform liveness probes.
        self.liveness_probe_exec_commands = liveness_probe_exec_commands
        # The minimum number of consecutive failures before a successful liveness probe is considered failed.
        # 
        # Default value: 3.
        self.liveness_probe_failure_threshold = liveness_probe_failure_threshold
        # The path to which HTTP GET requests are sent when you use the HTTP GET requests to perform liveness probes.
        self.liveness_probe_http_get_path = liveness_probe_http_get_path
        # The port to which HTTP GET requests are sent to perform liveness probes.
        self.liveness_probe_http_get_port = liveness_probe_http_get_port
        # The protocol type of HTTP GET requests when you use the HTTP GET requests to perform liveness probes. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        self.liveness_probe_http_get_scheme = liveness_probe_http_get_scheme
        # The number of seconds that elapses from the startup of the container to the start time of a liveness probe.
        self.liveness_probe_initial_delay_seconds = liveness_probe_initial_delay_seconds
        # The interval at which liveness probes are performed. Unit: seconds. Default value: 10. Minimum value: 1.
        self.liveness_probe_period_seconds = liveness_probe_period_seconds
        # The minimum number of consecutive successes before a failed liveness probe is considered successful. Default value: 1. Valid value: 1.
        self.liveness_probe_success_threshold = liveness_probe_success_threshold
        # The port detected by TCP sockets when you use the TCP sockets to perform liveness probes.
        self.liveness_probe_tcp_socket_port = liveness_probe_tcp_socket_port
        # The timeout period of a liveness probe. Default value: 1. Minimum value: 1. Unit: seconds.
        self.liveness_probe_timeout_seconds = liveness_probe_timeout_seconds
        # The memory size per container.
        self.memory = memory
        # The custom name of the container.
        self.name = name
        # The exposed ports and protocols.
        self.ports = ports
        # The commands that are run in the container when you use the CLI to perform readiness probes.
        self.readiness_probe_exec_commands = readiness_probe_exec_commands
        # The minimum number of consecutive failures before a successful readiness probe is considered failed.
        # 
        # Default value: 3.
        self.readiness_probe_failure_threshold = readiness_probe_failure_threshold
        # The path to which HTTP GET requests are sent when you use the HTTP GET requests to perform readiness probes.
        self.readiness_probe_http_get_path = readiness_probe_http_get_path
        # The path to which HTTP GET requests are sent when you use the HTTP GET requests to perform readiness probes.
        self.readiness_probe_http_get_port = readiness_probe_http_get_port
        # The protocol type of HTTP GET requests when you use the HTTP requests to perform readiness probes. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        self.readiness_probe_http_get_scheme = readiness_probe_http_get_scheme
        # The number of seconds that elapses from the startup of the container to the start time of a readiness probe.
        self.readiness_probe_initial_delay_seconds = readiness_probe_initial_delay_seconds
        # The interval at which readiness probes are performed. Unit: seconds. Default value: 10. Minimum value: 1.
        self.readiness_probe_period_seconds = readiness_probe_period_seconds
        # The minimum number of consecutive successes before a failed readiness probe is considered successful. Default value: 1. Valid value: 1.
        self.readiness_probe_success_threshold = readiness_probe_success_threshold
        # The port detected by TCP sockets when you use the TCP sockets to perform readiness probes.
        self.readiness_probe_tcp_socket_port = readiness_probe_tcp_socket_port
        # The timeout period of a readiness probe. Default value: 1. Minimum value: 1. Unit: seconds.
        self.readiness_probe_timeout_seconds = readiness_probe_timeout_seconds
        # The permissions that are granted to the processes in the container. Valid values: NET_ADMIN and NET_RAW.
        # 
        # >  To use NET_RAW, you must submit a ticket.
        self.security_context_capability_adds = security_context_capability_adds
        # Indicates whether the root file system on which the container runs is read-only. Valid value: true.
        self.security_context_read_only_root_filesystem = security_context_read_only_root_filesystem
        # The ID of the user that runs the entry point of the container process.
        self.security_context_run_as_user = security_context_run_as_user
        # Indicates whether the container allocates buffer resources to standard input streams when the container is running. If this parameter is not specified, an end-of-file (EOF) error may occur when standard input streams in the container are read. Default value: false.
        self.stdin = stdin
        # Indicates whether standard input streams are disconnected after a client is disconnected. If Stdin is set to true, standard input streams remain connected among multiple sessions.
        # 
        # If StdinOnce is set to true, standard input streams are connected after the container is started, and remain idle until a client is connected to receive data. After the client is disconnected, streams are also disconnected, and remain disconnected until the container restarts.
        self.stdin_once = stdin_once
        # Indicates whether the Interaction feature is enabled. Valid values:
        # 
        # *   true
        # *   false
        # 
        # If the command is a /bin/bash command, the value of this parameter is true.
        # 
        # Default value: false.
        self.tty = tty
        # The mounted volumes.
        self.volume_mounts = volume_mounts
        # The working directory.
        self.working_dir = working_dir

    def validate(self):
        if self.environment_vars:
            for k in self.environment_vars:
                if k:
                    k.validate()
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.volume_mounts:
            for k in self.volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['Args'] = self.args
        if self.commands is not None:
            result['Commands'] = self.commands
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        result['EnvironmentVars'] = []
        if self.environment_vars is not None:
            for k in self.environment_vars:
                result['EnvironmentVars'].append(k.to_map() if k else None)
        if self.gpu is not None:
            result['Gpu'] = self.gpu
        if self.image is not None:
            result['Image'] = self.image
        if self.image_pull_policy is not None:
            result['ImagePullPolicy'] = self.image_pull_policy
        if self.lifecycle_post_start_handler_execs is not None:
            result['LifecyclePostStartHandlerExecs'] = self.lifecycle_post_start_handler_execs
        if self.lifecycle_post_start_handler_http_get_host is not None:
            result['LifecyclePostStartHandlerHttpGetHost'] = self.lifecycle_post_start_handler_http_get_host
        if self.lifecycle_post_start_handler_http_get_path is not None:
            result['LifecyclePostStartHandlerHttpGetPath'] = self.lifecycle_post_start_handler_http_get_path
        if self.lifecycle_post_start_handler_http_get_port is not None:
            result['LifecyclePostStartHandlerHttpGetPort'] = self.lifecycle_post_start_handler_http_get_port
        if self.lifecycle_post_start_handler_http_get_scheme is not None:
            result['LifecyclePostStartHandlerHttpGetScheme'] = self.lifecycle_post_start_handler_http_get_scheme
        if self.lifecycle_post_start_handler_tcp_socket_host is not None:
            result['LifecyclePostStartHandlerTcpSocketHost'] = self.lifecycle_post_start_handler_tcp_socket_host
        if self.lifecycle_post_start_handler_tcp_socket_port is not None:
            result['LifecyclePostStartHandlerTcpSocketPort'] = self.lifecycle_post_start_handler_tcp_socket_port
        if self.lifecycle_pre_stop_handler_execs is not None:
            result['LifecyclePreStopHandlerExecs'] = self.lifecycle_pre_stop_handler_execs
        if self.lifecycle_pre_stop_handler_http_get_host is not None:
            result['LifecyclePreStopHandlerHttpGetHost'] = self.lifecycle_pre_stop_handler_http_get_host
        if self.lifecycle_pre_stop_handler_http_get_path is not None:
            result['LifecyclePreStopHandlerHttpGetPath'] = self.lifecycle_pre_stop_handler_http_get_path
        if self.lifecycle_pre_stop_handler_http_get_port is not None:
            result['LifecyclePreStopHandlerHttpGetPort'] = self.lifecycle_pre_stop_handler_http_get_port
        if self.lifecycle_pre_stop_handler_http_get_scheme is not None:
            result['LifecyclePreStopHandlerHttpGetScheme'] = self.lifecycle_pre_stop_handler_http_get_scheme
        if self.lifecycle_pre_stop_handler_tcp_socket_host is not None:
            result['LifecyclePreStopHandlerTcpSocketHost'] = self.lifecycle_pre_stop_handler_tcp_socket_host
        if self.lifecycle_pre_stop_handler_tcp_socket_port is not None:
            result['LifecyclePreStopHandlerTcpSocketPort'] = self.lifecycle_pre_stop_handler_tcp_socket_port
        if self.liveness_probe_exec_commands is not None:
            result['LivenessProbeExecCommands'] = self.liveness_probe_exec_commands
        if self.liveness_probe_failure_threshold is not None:
            result['LivenessProbeFailureThreshold'] = self.liveness_probe_failure_threshold
        if self.liveness_probe_http_get_path is not None:
            result['LivenessProbeHttpGetPath'] = self.liveness_probe_http_get_path
        if self.liveness_probe_http_get_port is not None:
            result['LivenessProbeHttpGetPort'] = self.liveness_probe_http_get_port
        if self.liveness_probe_http_get_scheme is not None:
            result['LivenessProbeHttpGetScheme'] = self.liveness_probe_http_get_scheme
        if self.liveness_probe_initial_delay_seconds is not None:
            result['LivenessProbeInitialDelaySeconds'] = self.liveness_probe_initial_delay_seconds
        if self.liveness_probe_period_seconds is not None:
            result['LivenessProbePeriodSeconds'] = self.liveness_probe_period_seconds
        if self.liveness_probe_success_threshold is not None:
            result['LivenessProbeSuccessThreshold'] = self.liveness_probe_success_threshold
        if self.liveness_probe_tcp_socket_port is not None:
            result['LivenessProbeTcpSocketPort'] = self.liveness_probe_tcp_socket_port
        if self.liveness_probe_timeout_seconds is not None:
            result['LivenessProbeTimeoutSeconds'] = self.liveness_probe_timeout_seconds
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.name is not None:
            result['Name'] = self.name
        result['Ports'] = []
        if self.ports is not None:
            for k in self.ports:
                result['Ports'].append(k.to_map() if k else None)
        if self.readiness_probe_exec_commands is not None:
            result['ReadinessProbeExecCommands'] = self.readiness_probe_exec_commands
        if self.readiness_probe_failure_threshold is not None:
            result['ReadinessProbeFailureThreshold'] = self.readiness_probe_failure_threshold
        if self.readiness_probe_http_get_path is not None:
            result['ReadinessProbeHttpGetPath'] = self.readiness_probe_http_get_path
        if self.readiness_probe_http_get_port is not None:
            result['ReadinessProbeHttpGetPort'] = self.readiness_probe_http_get_port
        if self.readiness_probe_http_get_scheme is not None:
            result['ReadinessProbeHttpGetScheme'] = self.readiness_probe_http_get_scheme
        if self.readiness_probe_initial_delay_seconds is not None:
            result['ReadinessProbeInitialDelaySeconds'] = self.readiness_probe_initial_delay_seconds
        if self.readiness_probe_period_seconds is not None:
            result['ReadinessProbePeriodSeconds'] = self.readiness_probe_period_seconds
        if self.readiness_probe_success_threshold is not None:
            result['ReadinessProbeSuccessThreshold'] = self.readiness_probe_success_threshold
        if self.readiness_probe_tcp_socket_port is not None:
            result['ReadinessProbeTcpSocketPort'] = self.readiness_probe_tcp_socket_port
        if self.readiness_probe_timeout_seconds is not None:
            result['ReadinessProbeTimeoutSeconds'] = self.readiness_probe_timeout_seconds
        if self.security_context_capability_adds is not None:
            result['SecurityContextCapabilityAdds'] = self.security_context_capability_adds
        if self.security_context_read_only_root_filesystem is not None:
            result['SecurityContextReadOnlyRootFilesystem'] = self.security_context_read_only_root_filesystem
        if self.security_context_run_as_user is not None:
            result['SecurityContextRunAsUser'] = self.security_context_run_as_user
        if self.stdin is not None:
            result['Stdin'] = self.stdin
        if self.stdin_once is not None:
            result['StdinOnce'] = self.stdin_once
        if self.tty is not None:
            result['Tty'] = self.tty
        result['VolumeMounts'] = []
        if self.volume_mounts is not None:
            for k in self.volume_mounts:
                result['VolumeMounts'].append(k.to_map() if k else None)
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('Commands') is not None:
            self.commands = m.get('Commands')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        self.environment_vars = []
        if m.get('EnvironmentVars') is not None:
            for k in m.get('EnvironmentVars'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainersEnvironmentVars()
                self.environment_vars.append(temp_model.from_map(k))
        if m.get('Gpu') is not None:
            self.gpu = m.get('Gpu')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImagePullPolicy') is not None:
            self.image_pull_policy = m.get('ImagePullPolicy')
        if m.get('LifecyclePostStartHandlerExecs') is not None:
            self.lifecycle_post_start_handler_execs = m.get('LifecyclePostStartHandlerExecs')
        if m.get('LifecyclePostStartHandlerHttpGetHost') is not None:
            self.lifecycle_post_start_handler_http_get_host = m.get('LifecyclePostStartHandlerHttpGetHost')
        if m.get('LifecyclePostStartHandlerHttpGetPath') is not None:
            self.lifecycle_post_start_handler_http_get_path = m.get('LifecyclePostStartHandlerHttpGetPath')
        if m.get('LifecyclePostStartHandlerHttpGetPort') is not None:
            self.lifecycle_post_start_handler_http_get_port = m.get('LifecyclePostStartHandlerHttpGetPort')
        if m.get('LifecyclePostStartHandlerHttpGetScheme') is not None:
            self.lifecycle_post_start_handler_http_get_scheme = m.get('LifecyclePostStartHandlerHttpGetScheme')
        if m.get('LifecyclePostStartHandlerTcpSocketHost') is not None:
            self.lifecycle_post_start_handler_tcp_socket_host = m.get('LifecyclePostStartHandlerTcpSocketHost')
        if m.get('LifecyclePostStartHandlerTcpSocketPort') is not None:
            self.lifecycle_post_start_handler_tcp_socket_port = m.get('LifecyclePostStartHandlerTcpSocketPort')
        if m.get('LifecyclePreStopHandlerExecs') is not None:
            self.lifecycle_pre_stop_handler_execs = m.get('LifecyclePreStopHandlerExecs')
        if m.get('LifecyclePreStopHandlerHttpGetHost') is not None:
            self.lifecycle_pre_stop_handler_http_get_host = m.get('LifecyclePreStopHandlerHttpGetHost')
        if m.get('LifecyclePreStopHandlerHttpGetPath') is not None:
            self.lifecycle_pre_stop_handler_http_get_path = m.get('LifecyclePreStopHandlerHttpGetPath')
        if m.get('LifecyclePreStopHandlerHttpGetPort') is not None:
            self.lifecycle_pre_stop_handler_http_get_port = m.get('LifecyclePreStopHandlerHttpGetPort')
        if m.get('LifecyclePreStopHandlerHttpGetScheme') is not None:
            self.lifecycle_pre_stop_handler_http_get_scheme = m.get('LifecyclePreStopHandlerHttpGetScheme')
        if m.get('LifecyclePreStopHandlerTcpSocketHost') is not None:
            self.lifecycle_pre_stop_handler_tcp_socket_host = m.get('LifecyclePreStopHandlerTcpSocketHost')
        if m.get('LifecyclePreStopHandlerTcpSocketPort') is not None:
            self.lifecycle_pre_stop_handler_tcp_socket_port = m.get('LifecyclePreStopHandlerTcpSocketPort')
        if m.get('LivenessProbeExecCommands') is not None:
            self.liveness_probe_exec_commands = m.get('LivenessProbeExecCommands')
        if m.get('LivenessProbeFailureThreshold') is not None:
            self.liveness_probe_failure_threshold = m.get('LivenessProbeFailureThreshold')
        if m.get('LivenessProbeHttpGetPath') is not None:
            self.liveness_probe_http_get_path = m.get('LivenessProbeHttpGetPath')
        if m.get('LivenessProbeHttpGetPort') is not None:
            self.liveness_probe_http_get_port = m.get('LivenessProbeHttpGetPort')
        if m.get('LivenessProbeHttpGetScheme') is not None:
            self.liveness_probe_http_get_scheme = m.get('LivenessProbeHttpGetScheme')
        if m.get('LivenessProbeInitialDelaySeconds') is not None:
            self.liveness_probe_initial_delay_seconds = m.get('LivenessProbeInitialDelaySeconds')
        if m.get('LivenessProbePeriodSeconds') is not None:
            self.liveness_probe_period_seconds = m.get('LivenessProbePeriodSeconds')
        if m.get('LivenessProbeSuccessThreshold') is not None:
            self.liveness_probe_success_threshold = m.get('LivenessProbeSuccessThreshold')
        if m.get('LivenessProbeTcpSocketPort') is not None:
            self.liveness_probe_tcp_socket_port = m.get('LivenessProbeTcpSocketPort')
        if m.get('LivenessProbeTimeoutSeconds') is not None:
            self.liveness_probe_timeout_seconds = m.get('LivenessProbeTimeoutSeconds')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.ports = []
        if m.get('Ports') is not None:
            for k in m.get('Ports'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainersPorts()
                self.ports.append(temp_model.from_map(k))
        if m.get('ReadinessProbeExecCommands') is not None:
            self.readiness_probe_exec_commands = m.get('ReadinessProbeExecCommands')
        if m.get('ReadinessProbeFailureThreshold') is not None:
            self.readiness_probe_failure_threshold = m.get('ReadinessProbeFailureThreshold')
        if m.get('ReadinessProbeHttpGetPath') is not None:
            self.readiness_probe_http_get_path = m.get('ReadinessProbeHttpGetPath')
        if m.get('ReadinessProbeHttpGetPort') is not None:
            self.readiness_probe_http_get_port = m.get('ReadinessProbeHttpGetPort')
        if m.get('ReadinessProbeHttpGetScheme') is not None:
            self.readiness_probe_http_get_scheme = m.get('ReadinessProbeHttpGetScheme')
        if m.get('ReadinessProbeInitialDelaySeconds') is not None:
            self.readiness_probe_initial_delay_seconds = m.get('ReadinessProbeInitialDelaySeconds')
        if m.get('ReadinessProbePeriodSeconds') is not None:
            self.readiness_probe_period_seconds = m.get('ReadinessProbePeriodSeconds')
        if m.get('ReadinessProbeSuccessThreshold') is not None:
            self.readiness_probe_success_threshold = m.get('ReadinessProbeSuccessThreshold')
        if m.get('ReadinessProbeTcpSocketPort') is not None:
            self.readiness_probe_tcp_socket_port = m.get('ReadinessProbeTcpSocketPort')
        if m.get('ReadinessProbeTimeoutSeconds') is not None:
            self.readiness_probe_timeout_seconds = m.get('ReadinessProbeTimeoutSeconds')
        if m.get('SecurityContextCapabilityAdds') is not None:
            self.security_context_capability_adds = m.get('SecurityContextCapabilityAdds')
        if m.get('SecurityContextReadOnlyRootFilesystem') is not None:
            self.security_context_read_only_root_filesystem = m.get('SecurityContextReadOnlyRootFilesystem')
        if m.get('SecurityContextRunAsUser') is not None:
            self.security_context_run_as_user = m.get('SecurityContextRunAsUser')
        if m.get('Stdin') is not None:
            self.stdin = m.get('Stdin')
        if m.get('StdinOnce') is not None:
            self.stdin_once = m.get('StdinOnce')
        if m.get('Tty') is not None:
            self.tty = m.get('Tty')
        self.volume_mounts = []
        if m.get('VolumeMounts') is not None:
            for k in m.get('VolumeMounts'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainersVolumeMounts()
                self.volume_mounts.append(temp_model.from_map(k))
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsDnsConfigOptions(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The variable name of the option.
        self.name = name
        # The variable value of the option.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsHostAliases(TeaModel):
    def __init__(
        self,
        hostnames: List[str] = None,
        ip: str = None,
    ):
        # The added hostnames.
        self.hostnames = hostnames
        # The added IP address.
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostnames is not None:
            result['Hostnames'] = self.hostnames
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Hostnames') is not None:
            self.hostnames = m.get('Hostnames')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsImageRegistryCredentials(TeaModel):
    def __init__(
        self,
        password: str = None,
        server: str = None,
        user_name: str = None,
    ):
        # The password of the image repository.
        self.password = password
        # The domain name of the image repository.
        self.server = server
        # The username of the image repository.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.server is not None:
            result['Server'] = self.server
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('Server') is not None:
            self.server = m.get('Server')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainersInitContainerEnvironmentVars(TeaModel):
    def __init__(
        self,
        field_ref_field_path: str = None,
        key: str = None,
        value: str = None,
    ):
        # >  This parameter is not available for use.
        self.field_ref_field_path = field_ref_field_path
        # The name of the environment variable.
        self.key = key
        # The value of the environment variable.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_ref_field_path is not None:
            result['FieldRefFieldPath'] = self.field_ref_field_path
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FieldRefFieldPath') is not None:
            self.field_ref_field_path = m.get('FieldRefFieldPath')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainersInitContainerPorts(TeaModel):
    def __init__(
        self,
        port: int = None,
        protocol: str = None,
    ):
        # The port number. Valid values: 1 to 65535.
        self.port = port
        # The protocol type. Valid values:
        # 
        # *   TCP
        # *   UDP
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainersInitContainerVolumeMounts(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        mount_propagation: str = None,
        name: str = None,
        read_only: bool = None,
        sub_path: str = None,
    ):
        # The directory to which the volume is mounted. Data under this directory is overwritten by the data on the volume.
        self.mount_path = mount_path
        # The mount propagation setting. Mount propagation enables volumes mounted on one container to be shared among other containers within the same pod or across distinct pods residing on the same node. Valid values:
        # 
        # *   None: Subsequent mounts executed either on the volume itself or its subdirectories do not propagate to the already established volume mount.
        # *   HostToCotainer: Subsequent mounts executed either on the volume itself or its subdirectories propagate to the already established volume mount.
        # *   Bidirectional: This value is similar to HostToCotainer. Subsequent mounts executed either on the volume itself or its subdirectories propagate to the already established volume mount. In addition, any volume mounts executed on a container not only propagate back to the underlying host but also to all containers across every pod that uses the same volume.
        # 
        # Default value: None.
        self.mount_propagation = mount_propagation
        # The volume name.
        self.name = name
        # Indicates whether the mount directory is read-only.
        # 
        # Default value: false.
        self.read_only = read_only
        # The volume subdirectory. A pod can mount different directories of the same volume to different directories of the init container.
        self.sub_path = sub_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        if self.mount_propagation is not None:
            result['MountPropagation'] = self.mount_propagation
        if self.name is not None:
            result['Name'] = self.name
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.sub_path is not None:
            result['SubPath'] = self.sub_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        if m.get('MountPropagation') is not None:
            self.mount_propagation = m.get('MountPropagation')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('SubPath') is not None:
            self.sub_path = m.get('SubPath')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainers(TeaModel):
    def __init__(
        self,
        cpu: float = None,
        gpu: int = None,
        image: str = None,
        image_pull_policy: str = None,
        init_container_args: List[str] = None,
        init_container_commands: List[str] = None,
        init_container_environment_vars: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainersInitContainerEnvironmentVars] = None,
        init_container_ports: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainersInitContainerPorts] = None,
        init_container_volume_mounts: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainersInitContainerVolumeMounts] = None,
        memory: float = None,
        name: str = None,
        security_context_capability_adds: List[str] = None,
        security_context_read_only_root_filesystem: bool = None,
        security_context_run_as_user: str = None,
        working_dir: str = None,
    ):
        # The number of vCPUs per init container.
        self.cpu = cpu
        # The number of GPUs per init container.
        self.gpu = gpu
        # The image of the init container.
        self.image = image
        # The image pulling policy.
        self.image_pull_policy = image_pull_policy
        # The container startup arguments.
        self.init_container_args = init_container_args
        # The container startup commands.
        self.init_container_commands = init_container_commands
        # The environment variables.
        self.init_container_environment_vars = init_container_environment_vars
        # The ports of the init container.
        self.init_container_ports = init_container_ports
        # The volumes that are mounted to the init container.
        self.init_container_volume_mounts = init_container_volume_mounts
        # The memory size per init container.
        self.memory = memory
        # The name of the init container.
        self.name = name
        # The permissions that are granted to the processes in the init container. Valid values: NET_ADMIN and NET_RAW.
        # 
        # >  To use NET_RAW, you must submit a ticket.
        self.security_context_capability_adds = security_context_capability_adds
        # Indicates whether the root file system is read-only. Valid value: true.
        self.security_context_read_only_root_filesystem = security_context_read_only_root_filesystem
        # The ID of the user that runs the init container.
        self.security_context_run_as_user = security_context_run_as_user
        # The working directory.
        self.working_dir = working_dir

    def validate(self):
        if self.init_container_environment_vars:
            for k in self.init_container_environment_vars:
                if k:
                    k.validate()
        if self.init_container_ports:
            for k in self.init_container_ports:
                if k:
                    k.validate()
        if self.init_container_volume_mounts:
            for k in self.init_container_volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.gpu is not None:
            result['Gpu'] = self.gpu
        if self.image is not None:
            result['Image'] = self.image
        if self.image_pull_policy is not None:
            result['ImagePullPolicy'] = self.image_pull_policy
        if self.init_container_args is not None:
            result['InitContainerArgs'] = self.init_container_args
        if self.init_container_commands is not None:
            result['InitContainerCommands'] = self.init_container_commands
        result['InitContainerEnvironmentVars'] = []
        if self.init_container_environment_vars is not None:
            for k in self.init_container_environment_vars:
                result['InitContainerEnvironmentVars'].append(k.to_map() if k else None)
        result['InitContainerPorts'] = []
        if self.init_container_ports is not None:
            for k in self.init_container_ports:
                result['InitContainerPorts'].append(k.to_map() if k else None)
        result['InitContainerVolumeMounts'] = []
        if self.init_container_volume_mounts is not None:
            for k in self.init_container_volume_mounts:
                result['InitContainerVolumeMounts'].append(k.to_map() if k else None)
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.name is not None:
            result['Name'] = self.name
        if self.security_context_capability_adds is not None:
            result['SecurityContextCapabilityAdds'] = self.security_context_capability_adds
        if self.security_context_read_only_root_filesystem is not None:
            result['SecurityContextReadOnlyRootFilesystem'] = self.security_context_read_only_root_filesystem
        if self.security_context_run_as_user is not None:
            result['SecurityContextRunAsUser'] = self.security_context_run_as_user
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('Gpu') is not None:
            self.gpu = m.get('Gpu')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImagePullPolicy') is not None:
            self.image_pull_policy = m.get('ImagePullPolicy')
        if m.get('InitContainerArgs') is not None:
            self.init_container_args = m.get('InitContainerArgs')
        if m.get('InitContainerCommands') is not None:
            self.init_container_commands = m.get('InitContainerCommands')
        self.init_container_environment_vars = []
        if m.get('InitContainerEnvironmentVars') is not None:
            for k in m.get('InitContainerEnvironmentVars'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainersInitContainerEnvironmentVars()
                self.init_container_environment_vars.append(temp_model.from_map(k))
        self.init_container_ports = []
        if m.get('InitContainerPorts') is not None:
            for k in m.get('InitContainerPorts'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainersInitContainerPorts()
                self.init_container_ports.append(temp_model.from_map(k))
        self.init_container_volume_mounts = []
        if m.get('InitContainerVolumeMounts') is not None:
            for k in m.get('InitContainerVolumeMounts'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainersInitContainerVolumeMounts()
                self.init_container_volume_mounts.append(temp_model.from_map(k))
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SecurityContextCapabilityAdds') is not None:
            self.security_context_capability_adds = m.get('SecurityContextCapabilityAdds')
        if m.get('SecurityContextReadOnlyRootFilesystem') is not None:
            self.security_context_read_only_root_filesystem = m.get('SecurityContextReadOnlyRootFilesystem')
        if m.get('SecurityContextRunAsUser') is not None:
            self.security_context_run_as_user = m.get('SecurityContextRunAsUser')
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsSecurityContextSysCtls(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The system name of the security context in which the elastic container instance runs.
        self.name = name
        # The variable value of the security context in which the elastic container instance runs.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key.
        self.key = key
        # The tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsVolumesConfigFileVolumeConfigFileToPaths(TeaModel):
    def __init__(
        self,
        content: str = None,
        mode: int = None,
        path: str = None,
    ):
        # The content of the configuration file (32 KB).
        self.content = content
        # The permissions on the ConfigFile volume.
        self.mode = mode
        # The relative path to the configuration file.
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsVolumes(TeaModel):
    def __init__(
        self,
        config_file_volume_config_file_to_paths: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsVolumesConfigFileVolumeConfigFileToPaths] = None,
        config_file_volume_default_mode: int = None,
        disk_volume_disk_id: str = None,
        disk_volume_disk_size: int = None,
        disk_volume_fs_type: str = None,
        empty_dir_volume_medium: str = None,
        empty_dir_volume_size_limit: str = None,
        flex_volume_driver: str = None,
        flex_volume_fs_type: str = None,
        flex_volume_options: str = None,
        host_path_volume_path: str = None,
        host_path_volume_type: str = None,
        nfsvolume_path: str = None,
        nfsvolume_read_only: bool = None,
        nfsvolume_server: str = None,
        name: str = None,
        type: str = None,
    ):
        # The paths to configuration files.
        self.config_file_volume_config_file_to_paths = config_file_volume_config_file_to_paths
        # The default permissions on the ConfigFile volume.
        self.config_file_volume_default_mode = config_file_volume_default_mode
        # The size of the disk volume. Unit: GiB.
        self.disk_volume_disk_id = disk_volume_disk_id
        # The size of the disk volume. Unit: GiB.
        self.disk_volume_disk_size = disk_volume_disk_size
        # The system type of the disk volume.
        self.disk_volume_fs_type = disk_volume_fs_type
        # The storage medium of the emptyDir volume. If you do not specify a storage medium for the emptyDir volume, the volume stores data in the file system of a node by default. We recommend that you set this parameter to memory. In this case, the emptyDir volume stores data in the specified memory.
        self.empty_dir_volume_medium = empty_dir_volume_medium
        # The storage size of the emptyDir volume.
        self.empty_dir_volume_size_limit = empty_dir_volume_size_limit
        # The name of the FlexVolume driver.
        self.flex_volume_driver = flex_volume_driver
        # The type of the mounted file system. The default value is determined by the script of FlexVolume.
        self.flex_volume_fs_type = flex_volume_fs_type
        # The FlexVolume options. Each option is a key-value pair in a JSON string.
        # 
        # For example, if you use FlexVolume to mount a disk, the format of Options is `{"volumeId":"d-2zehdahrwoa7srg****","performanceLevel": "PL2"}`.
        self.flex_volume_options = flex_volume_options
        # The path to the HostPath volume on the host.
        self.host_path_volume_path = host_path_volume_path
        # The type of the HostPath volume.
        self.host_path_volume_type = host_path_volume_type
        # The path to the Network File System (NFS) volume.
        self.nfsvolume_path = nfsvolume_path
        # Indicates whether the NFS volume is read-only.
        # 
        # Default value: false.
        self.nfsvolume_read_only = nfsvolume_read_only
        # The endpoint of the NFS server.
        self.nfsvolume_server = nfsvolume_server
        # The volume name.
        self.name = name
        # The volume type. Valid values:
        # 
        # *   EmptyDirVolume
        # *   NFSVolume
        # *   ConfigFileVolume
        # *   FlexVolume
        self.type = type

    def validate(self):
        if self.config_file_volume_config_file_to_paths:
            for k in self.config_file_volume_config_file_to_paths:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigFileVolumeConfigFileToPaths'] = []
        if self.config_file_volume_config_file_to_paths is not None:
            for k in self.config_file_volume_config_file_to_paths:
                result['ConfigFileVolumeConfigFileToPaths'].append(k.to_map() if k else None)
        if self.config_file_volume_default_mode is not None:
            result['ConfigFileVolumeDefaultMode'] = self.config_file_volume_default_mode
        if self.disk_volume_disk_id is not None:
            result['DiskVolumeDiskId'] = self.disk_volume_disk_id
        if self.disk_volume_disk_size is not None:
            result['DiskVolumeDiskSize'] = self.disk_volume_disk_size
        if self.disk_volume_fs_type is not None:
            result['DiskVolumeFsType'] = self.disk_volume_fs_type
        if self.empty_dir_volume_medium is not None:
            result['EmptyDirVolumeMedium'] = self.empty_dir_volume_medium
        if self.empty_dir_volume_size_limit is not None:
            result['EmptyDirVolumeSizeLimit'] = self.empty_dir_volume_size_limit
        if self.flex_volume_driver is not None:
            result['FlexVolumeDriver'] = self.flex_volume_driver
        if self.flex_volume_fs_type is not None:
            result['FlexVolumeFsType'] = self.flex_volume_fs_type
        if self.flex_volume_options is not None:
            result['FlexVolumeOptions'] = self.flex_volume_options
        if self.host_path_volume_path is not None:
            result['HostPathVolumePath'] = self.host_path_volume_path
        if self.host_path_volume_type is not None:
            result['HostPathVolumeType'] = self.host_path_volume_type
        if self.nfsvolume_path is not None:
            result['NFSVolumePath'] = self.nfsvolume_path
        if self.nfsvolume_read_only is not None:
            result['NFSVolumeReadOnly'] = self.nfsvolume_read_only
        if self.nfsvolume_server is not None:
            result['NFSVolumeServer'] = self.nfsvolume_server
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_file_volume_config_file_to_paths = []
        if m.get('ConfigFileVolumeConfigFileToPaths') is not None:
            for k in m.get('ConfigFileVolumeConfigFileToPaths'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsVolumesConfigFileVolumeConfigFileToPaths()
                self.config_file_volume_config_file_to_paths.append(temp_model.from_map(k))
        if m.get('ConfigFileVolumeDefaultMode') is not None:
            self.config_file_volume_default_mode = m.get('ConfigFileVolumeDefaultMode')
        if m.get('DiskVolumeDiskId') is not None:
            self.disk_volume_disk_id = m.get('DiskVolumeDiskId')
        if m.get('DiskVolumeDiskSize') is not None:
            self.disk_volume_disk_size = m.get('DiskVolumeDiskSize')
        if m.get('DiskVolumeFsType') is not None:
            self.disk_volume_fs_type = m.get('DiskVolumeFsType')
        if m.get('EmptyDirVolumeMedium') is not None:
            self.empty_dir_volume_medium = m.get('EmptyDirVolumeMedium')
        if m.get('EmptyDirVolumeSizeLimit') is not None:
            self.empty_dir_volume_size_limit = m.get('EmptyDirVolumeSizeLimit')
        if m.get('FlexVolumeDriver') is not None:
            self.flex_volume_driver = m.get('FlexVolumeDriver')
        if m.get('FlexVolumeFsType') is not None:
            self.flex_volume_fs_type = m.get('FlexVolumeFsType')
        if m.get('FlexVolumeOptions') is not None:
            self.flex_volume_options = m.get('FlexVolumeOptions')
        if m.get('HostPathVolumePath') is not None:
            self.host_path_volume_path = m.get('HostPathVolumePath')
        if m.get('HostPathVolumeType') is not None:
            self.host_path_volume_type = m.get('HostPathVolumeType')
        if m.get('NFSVolumePath') is not None:
            self.nfsvolume_path = m.get('NFSVolumePath')
        if m.get('NFSVolumeReadOnly') is not None:
            self.nfsvolume_read_only = m.get('NFSVolumeReadOnly')
        if m.get('NFSVolumeServer') is not None:
            self.nfsvolume_server = m.get('NFSVolumeServer')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeEciScalingConfigurationsResponseBodyScalingConfigurations(TeaModel):
    def __init__(
        self,
        acr_registry_infos: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsAcrRegistryInfos] = None,
        active_deadline_seconds: int = None,
        auto_create_eip: bool = None,
        auto_match_image_cache: bool = None,
        container_group_name: str = None,
        containers: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainers] = None,
        cost_optimization: bool = None,
        cpu: float = None,
        cpu_options_core: int = None,
        cpu_options_threads_per_core: int = None,
        creation_time: str = None,
        data_cache_bucket: str = None,
        data_cache_bursting_enabled: bool = None,
        data_cache_pl: str = None,
        data_cache_provisioned_iops: int = None,
        description: str = None,
        dns_config_name_servers: List[str] = None,
        dns_config_options: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsDnsConfigOptions] = None,
        dns_config_searches: List[str] = None,
        dns_policy: str = None,
        egress_bandwidth: int = None,
        eip_bandwidth: int = None,
        ephemeral_storage: int = None,
        gpu_driver_version: str = None,
        host_aliases: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsHostAliases] = None,
        host_name: str = None,
        image_registry_credentials: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsImageRegistryCredentials] = None,
        image_snapshot_id: str = None,
        ingress_bandwidth: int = None,
        init_containers: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainers] = None,
        instance_family_level: str = None,
        instance_types: List[str] = None,
        ipv_6address_count: int = None,
        lifecycle_state: str = None,
        load_balancer_weight: int = None,
        memory: float = None,
        ntp_servers: List[str] = None,
        ram_role_name: str = None,
        region_id: str = None,
        resource_group_id: str = None,
        restart_policy: str = None,
        scaling_configuration_id: str = None,
        scaling_configuration_name: str = None,
        scaling_group_id: str = None,
        security_context_sys_ctls: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsSecurityContextSysCtls] = None,
        security_group_id: str = None,
        sls_enable: bool = None,
        spot_price_limit: float = None,
        spot_strategy: str = None,
        tags: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsTags] = None,
        termination_grace_period_seconds: int = None,
        volumes: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsVolumes] = None,
    ):
        # The Container Registry Enterprise Edition instances.
        self.acr_registry_infos = acr_registry_infos
        # The validity period of the scaling configuration. Unit: seconds.
        self.active_deadline_seconds = active_deadline_seconds
        # Indicates whether elastic IP addresses (EIPs) are automatically created and bound to elastic container instances.
        self.auto_create_eip = auto_create_eip
        # Indicates whether the image cache is automatically matched. Default value: false.
        self.auto_match_image_cache = auto_match_image_cache
        # The name series of elastic container instances.
        self.container_group_name = container_group_name
        # The containers in an elastic container instance.
        self.containers = containers
        # Indicates whether the Cost Optimization feature is enabled. Valid values:
        # 
        # *   true
        # *   false
        self.cost_optimization = cost_optimization
        # The number of vCPUs per elastic container instance.
        self.cpu = cpu
        # The number of physical CPU cores. This parameter can be specified for only specific instance types. For more information, see [Specify CPU options](https://help.aliyun.com/document_detail/197781.html).
        self.cpu_options_core = cpu_options_core
        # The number of threads per core. This parameter can be specified for only specific instance types. A value of 1 indicates that Hyper-Threading is disabled. For more information, see [Specify CPU options](https://help.aliyun.com/document_detail/197781.html).
        self.cpu_options_threads_per_core = cpu_options_threads_per_core
        # The time at which the scaling configuration was created.
        self.creation_time = creation_time
        # The bucket that stores the data cache.
        self.data_cache_bucket = data_cache_bucket
        # Indicates whether the Performance Burst feature is enabled for the ESSD AutoPL disk that stores the data cache. Valid values:
        # 
        # *   true
        # *   false
        # 
        # >  For more information about ESSD AutoPL disks, see [ESSD AutoPL disks](https://help.aliyun.com/document_detail/368372.html).
        self.data_cache_bursting_enabled = data_cache_bursting_enabled
        # The performance level (PL) of the cloud disk that stores the data cache. We recommend that you use enterprise SSDs (ESSDs). Valid values:
        # 
        # *   PL0: An ESSD can provide up to 10,000 random read/write IOPS.
        # *   PL1: An ESSD can provide up to 50,000 random read/write IOPS.
        # *   PL2: An ESSD can provide up to 100,000 random read/write IOPS.
        # *   PL3: An ESSD can provide up to 1,000,000 random read/write IOPS.
        # 
        # >  For more information about ESSDs, see [ESSDs](https://help.aliyun.com/document_detail/122389.html).
        self.data_cache_pl = data_cache_pl
        # The provisioned read/write IOPS of the ESSD AutoPL disk that stores the data cache. Valid values: 0 to min{50,000, 1000 x *Capacity - Baseline IOPS}. Baseline IOPS = min{1,800 + 50* x Capacity, 50,000}.
        # 
        # >  For more information about ESSD AutoPL disks, see [ESSD AutoPL disks](https://help.aliyun.com/document_detail/368372.html).
        self.data_cache_provisioned_iops = data_cache_provisioned_iops
        # >  This parameter is not available for use.
        self.description = description
        # The IP addresses of the Domain Name Service (DNS) server.
        self.dns_config_name_servers = dns_config_name_servers
        # The options. Each option is a name-value pair. The value in the name-value pair is optional.
        self.dns_config_options = dns_config_options
        # The search domains of the DNS servers.
        self.dns_config_searches = dns_config_searches
        # The Domain Name System (DNS) policy.
        self.dns_policy = dns_policy
        # The maximum outbound public bandwidth. Unit: bit/s.
        self.egress_bandwidth = egress_bandwidth
        # The EIP bandwidth. Default value: 5. Unit: Mbit/s.
        self.eip_bandwidth = eip_bandwidth
        # The capacity of the ephemeral storage. Unit: GiB.
        self.ephemeral_storage = ephemeral_storage
        # The version of the GPU driver.
        self.gpu_driver_version = gpu_driver_version
        # The hostnames and IP addresses for a container that are added to the hosts file of the elastic container instance.
        self.host_aliases = host_aliases
        # The hostname series.
        self.host_name = host_name
        # The information about the image repository.
        self.image_registry_credentials = image_registry_credentials
        # The ID of the image cache.
        self.image_snapshot_id = image_snapshot_id
        # The maximum inbound public bandwidth. Unit: bit/s.
        self.ingress_bandwidth = ingress_bandwidth
        # The init containers.
        self.init_containers = init_containers
        # The level of the instance family, which is used to filter the available instance types that meet the specified requirements. This parameter takes effect only if `CostOptimization` is set to true. Valid values:
        # 
        # *   EntryLevel: entry level (shared instance types). Instance types of this level are the most cost-effective but may not provide stable computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low. For more information, see [Shared instance families](https://help.aliyun.com/document_detail/108489.html).
        # *   EnterpriseLevel: enterprise level. Instance types of this level provide stable performance and dedicated resources, and are suitable for business scenarios that require high stability. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        # *   CreditEntryLevel: credit-based entry level (burstable instance types). CPU credits are used to ensure computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low but may fluctuate in specific cases. For more information, see [Overview of burstable instances](https://help.aliyun.com/document_detail/59977.html).
        self.instance_family_level = instance_family_level
        # The specified ECS instance types. You can specify up to five instance types.
        self.instance_types = instance_types
        # The number of IPv6 addresses.
        self.ipv_6address_count = ipv_6address_count
        # The status of the scaling configuration in the scaling group. Valid values:
        # 
        # *   Active: The scaling configuration is active in the scaling group. Auto Scaling uses the scaling configuration that is in the Active state to create instances during scale-out events.
        # *   Inactive: The scaling configuration is inactive in the scaling group. Scaling configurations that are in the Inactive state are still contained in the scaling group, but Auto Scaling does not use the inactive scaling configurations to create instances during scale-out events.
        self.lifecycle_state = lifecycle_state
        # The load balancing weight of each elastic container instance as a backend server. Valid values: 1 to 100.
        self.load_balancer_weight = load_balancer_weight
        # The memory size.
        # 
        # You can specify CPU and Memory to define the range of instance types. For example, if you set CPU to 2 and Memory to 16, the instance types that have 2 vCPUs and 16 GiB are returned. After you specify CPU and Memory, Auto Scaling determines the available instance types based on factors such as I/O optimization requirements and zones and preferentially creates instances by using the lowest-priced instance type.
        # 
        # >  You can specify CPU and Memory to define instance types only if you set Scaling Policy to Cost Optimization and no instance type is specified in the scaling configuration.
        self.memory = memory
        # The endpoints of the Network Time Protocol (NTP) server.
        self.ntp_servers = ntp_servers
        # The Resource Access Management (RAM) role of elastic container instances. Elastic container instances and Elastic Compute Service (ECS) instances can share the same RAM role. For more information, see [Use an instance RAM role by calling API operations](https://help.aliyun.com/document_detail/61178.html).
        self.ram_role_name = ram_role_name
        # The region ID of elastic container instances.
        self.region_id = region_id
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The restart policy of elastic container instances. Valid values:
        # 
        # *   Never: Elastic container instances are never restarted.
        # *   Always: Elastic container instances are always restarted.
        # *   OnFailure: Elastic container instances are restarted upon failures.
        self.restart_policy = restart_policy
        # The ID of the scaling configuration.
        self.scaling_configuration_id = scaling_configuration_id
        # The name of the scaling configuration.
        self.scaling_configuration_name = scaling_configuration_name
        # The ID of the scaling group to which the scaling configuration belongs.
        self.scaling_group_id = scaling_group_id
        # The system information of the security context in which the elastic container instance runs.
        self.security_context_sys_ctls = security_context_sys_ctls
        # The ID of the security group with which elastic container instances are associated. Elastic container instances that are associated with the same security group can communicate with each other.
        self.security_group_id = security_group_id
        # >  This parameter is not available for use.
        self.sls_enable = sls_enable
        # The maximum hourly price for preemptible elastic container instances.
        # 
        # This parameter is returned only if you set SpotStrategy to SpotWithPriceLimit.
        self.spot_price_limit = spot_price_limit
        # The bidding policy for elastic container instances. Valid values:
        # 
        # *   NoSpot: The instances are created as regular pay-as-you-go instances.
        # *   SpotWithPriceLimit: The instances are created as preemptible instances with a user-defined maximum hourly price.
        # *   SpotAsPriceGo: The instances are created as preemptible instances for which the market price at the time of purchase is automatically used as the bid price.
        self.spot_strategy = spot_strategy
        # The tags of elastic container instances. Tags are specified in the key-value format.
        self.tags = tags
        # The buffer time during which a program handles operations before the program stops.
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # The volumes.
        self.volumes = volumes

    def validate(self):
        if self.acr_registry_infos:
            for k in self.acr_registry_infos:
                if k:
                    k.validate()
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()
        if self.dns_config_options:
            for k in self.dns_config_options:
                if k:
                    k.validate()
        if self.host_aliases:
            for k in self.host_aliases:
                if k:
                    k.validate()
        if self.image_registry_credentials:
            for k in self.image_registry_credentials:
                if k:
                    k.validate()
        if self.init_containers:
            for k in self.init_containers:
                if k:
                    k.validate()
        if self.security_context_sys_ctls:
            for k in self.security_context_sys_ctls:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.volumes:
            for k in self.volumes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AcrRegistryInfos'] = []
        if self.acr_registry_infos is not None:
            for k in self.acr_registry_infos:
                result['AcrRegistryInfos'].append(k.to_map() if k else None)
        if self.active_deadline_seconds is not None:
            result['ActiveDeadlineSeconds'] = self.active_deadline_seconds
        if self.auto_create_eip is not None:
            result['AutoCreateEip'] = self.auto_create_eip
        if self.auto_match_image_cache is not None:
            result['AutoMatchImageCache'] = self.auto_match_image_cache
        if self.container_group_name is not None:
            result['ContainerGroupName'] = self.container_group_name
        result['Containers'] = []
        if self.containers is not None:
            for k in self.containers:
                result['Containers'].append(k.to_map() if k else None)
        if self.cost_optimization is not None:
            result['CostOptimization'] = self.cost_optimization
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.cpu_options_core is not None:
            result['CpuOptionsCore'] = self.cpu_options_core
        if self.cpu_options_threads_per_core is not None:
            result['CpuOptionsThreadsPerCore'] = self.cpu_options_threads_per_core
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.data_cache_bucket is not None:
            result['DataCacheBucket'] = self.data_cache_bucket
        if self.data_cache_bursting_enabled is not None:
            result['DataCacheBurstingEnabled'] = self.data_cache_bursting_enabled
        if self.data_cache_pl is not None:
            result['DataCachePL'] = self.data_cache_pl
        if self.data_cache_provisioned_iops is not None:
            result['DataCacheProvisionedIops'] = self.data_cache_provisioned_iops
        if self.description is not None:
            result['Description'] = self.description
        if self.dns_config_name_servers is not None:
            result['DnsConfigNameServers'] = self.dns_config_name_servers
        result['DnsConfigOptions'] = []
        if self.dns_config_options is not None:
            for k in self.dns_config_options:
                result['DnsConfigOptions'].append(k.to_map() if k else None)
        if self.dns_config_searches is not None:
            result['DnsConfigSearches'] = self.dns_config_searches
        if self.dns_policy is not None:
            result['DnsPolicy'] = self.dns_policy
        if self.egress_bandwidth is not None:
            result['EgressBandwidth'] = self.egress_bandwidth
        if self.eip_bandwidth is not None:
            result['EipBandwidth'] = self.eip_bandwidth
        if self.ephemeral_storage is not None:
            result['EphemeralStorage'] = self.ephemeral_storage
        if self.gpu_driver_version is not None:
            result['GpuDriverVersion'] = self.gpu_driver_version
        result['HostAliases'] = []
        if self.host_aliases is not None:
            for k in self.host_aliases:
                result['HostAliases'].append(k.to_map() if k else None)
        if self.host_name is not None:
            result['HostName'] = self.host_name
        result['ImageRegistryCredentials'] = []
        if self.image_registry_credentials is not None:
            for k in self.image_registry_credentials:
                result['ImageRegistryCredentials'].append(k.to_map() if k else None)
        if self.image_snapshot_id is not None:
            result['ImageSnapshotId'] = self.image_snapshot_id
        if self.ingress_bandwidth is not None:
            result['IngressBandwidth'] = self.ingress_bandwidth
        result['InitContainers'] = []
        if self.init_containers is not None:
            for k in self.init_containers:
                result['InitContainers'].append(k.to_map() if k else None)
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.lifecycle_state is not None:
            result['LifecycleState'] = self.lifecycle_state
        if self.load_balancer_weight is not None:
            result['LoadBalancerWeight'] = self.load_balancer_weight
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.ntp_servers is not None:
            result['NtpServers'] = self.ntp_servers
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.restart_policy is not None:
            result['RestartPolicy'] = self.restart_policy
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        if self.scaling_configuration_name is not None:
            result['ScalingConfigurationName'] = self.scaling_configuration_name
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        result['SecurityContextSysCtls'] = []
        if self.security_context_sys_ctls is not None:
            for k in self.security_context_sys_ctls:
                result['SecurityContextSysCtls'].append(k.to_map() if k else None)
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.sls_enable is not None:
            result['SlsEnable'] = self.sls_enable
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.termination_grace_period_seconds is not None:
            result['TerminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        result['Volumes'] = []
        if self.volumes is not None:
            for k in self.volumes:
                result['Volumes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acr_registry_infos = []
        if m.get('AcrRegistryInfos') is not None:
            for k in m.get('AcrRegistryInfos'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsAcrRegistryInfos()
                self.acr_registry_infos.append(temp_model.from_map(k))
        if m.get('ActiveDeadlineSeconds') is not None:
            self.active_deadline_seconds = m.get('ActiveDeadlineSeconds')
        if m.get('AutoCreateEip') is not None:
            self.auto_create_eip = m.get('AutoCreateEip')
        if m.get('AutoMatchImageCache') is not None:
            self.auto_match_image_cache = m.get('AutoMatchImageCache')
        if m.get('ContainerGroupName') is not None:
            self.container_group_name = m.get('ContainerGroupName')
        self.containers = []
        if m.get('Containers') is not None:
            for k in m.get('Containers'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsContainers()
                self.containers.append(temp_model.from_map(k))
        if m.get('CostOptimization') is not None:
            self.cost_optimization = m.get('CostOptimization')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CpuOptionsCore') is not None:
            self.cpu_options_core = m.get('CpuOptionsCore')
        if m.get('CpuOptionsThreadsPerCore') is not None:
            self.cpu_options_threads_per_core = m.get('CpuOptionsThreadsPerCore')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DataCacheBucket') is not None:
            self.data_cache_bucket = m.get('DataCacheBucket')
        if m.get('DataCacheBurstingEnabled') is not None:
            self.data_cache_bursting_enabled = m.get('DataCacheBurstingEnabled')
        if m.get('DataCachePL') is not None:
            self.data_cache_pl = m.get('DataCachePL')
        if m.get('DataCacheProvisionedIops') is not None:
            self.data_cache_provisioned_iops = m.get('DataCacheProvisionedIops')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DnsConfigNameServers') is not None:
            self.dns_config_name_servers = m.get('DnsConfigNameServers')
        self.dns_config_options = []
        if m.get('DnsConfigOptions') is not None:
            for k in m.get('DnsConfigOptions'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsDnsConfigOptions()
                self.dns_config_options.append(temp_model.from_map(k))
        if m.get('DnsConfigSearches') is not None:
            self.dns_config_searches = m.get('DnsConfigSearches')
        if m.get('DnsPolicy') is not None:
            self.dns_policy = m.get('DnsPolicy')
        if m.get('EgressBandwidth') is not None:
            self.egress_bandwidth = m.get('EgressBandwidth')
        if m.get('EipBandwidth') is not None:
            self.eip_bandwidth = m.get('EipBandwidth')
        if m.get('EphemeralStorage') is not None:
            self.ephemeral_storage = m.get('EphemeralStorage')
        if m.get('GpuDriverVersion') is not None:
            self.gpu_driver_version = m.get('GpuDriverVersion')
        self.host_aliases = []
        if m.get('HostAliases') is not None:
            for k in m.get('HostAliases'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsHostAliases()
                self.host_aliases.append(temp_model.from_map(k))
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        self.image_registry_credentials = []
        if m.get('ImageRegistryCredentials') is not None:
            for k in m.get('ImageRegistryCredentials'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsImageRegistryCredentials()
                self.image_registry_credentials.append(temp_model.from_map(k))
        if m.get('ImageSnapshotId') is not None:
            self.image_snapshot_id = m.get('ImageSnapshotId')
        if m.get('IngressBandwidth') is not None:
            self.ingress_bandwidth = m.get('IngressBandwidth')
        self.init_containers = []
        if m.get('InitContainers') is not None:
            for k in m.get('InitContainers'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsInitContainers()
                self.init_containers.append(temp_model.from_map(k))
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('LifecycleState') is not None:
            self.lifecycle_state = m.get('LifecycleState')
        if m.get('LoadBalancerWeight') is not None:
            self.load_balancer_weight = m.get('LoadBalancerWeight')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NtpServers') is not None:
            self.ntp_servers = m.get('NtpServers')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RestartPolicy') is not None:
            self.restart_policy = m.get('RestartPolicy')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        if m.get('ScalingConfigurationName') is not None:
            self.scaling_configuration_name = m.get('ScalingConfigurationName')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        self.security_context_sys_ctls = []
        if m.get('SecurityContextSysCtls') is not None:
            for k in m.get('SecurityContextSysCtls'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsSecurityContextSysCtls()
                self.security_context_sys_ctls.append(temp_model.from_map(k))
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SlsEnable') is not None:
            self.sls_enable = m.get('SlsEnable')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('TerminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('TerminationGracePeriodSeconds')
        self.volumes = []
        if m.get('Volumes') is not None:
            for k in m.get('Volumes'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurationsVolumes()
                self.volumes.append(temp_model.from_map(k))
        return self


class DescribeEciScalingConfigurationsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        scaling_configurations: List[DescribeEciScalingConfigurationsResponseBodyScalingConfigurations] = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The scaling configurations.
        self.scaling_configurations = scaling_configurations
        # The total number of scaling configurations.
        self.total_count = total_count

    def validate(self):
        if self.scaling_configurations:
            for k in self.scaling_configurations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ScalingConfigurations'] = []
        if self.scaling_configurations is not None:
            for k in self.scaling_configurations:
                result['ScalingConfigurations'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.scaling_configurations = []
        if m.get('ScalingConfigurations') is not None:
            for k in m.get('ScalingConfigurations'):
                temp_model = DescribeEciScalingConfigurationsResponseBodyScalingConfigurations()
                self.scaling_configurations.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEciScalingConfigurationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEciScalingConfigurationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEciScalingConfigurationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeElasticStrengthRequest(TeaModel):
    def __init__(
        self,
        data_disk_categories: List[str] = None,
        image_family: str = None,
        image_id: str = None,
        image_name: str = None,
        instance_types: List[str] = None,
        ipv_6address_count: int = None,
        priority_strategy: str = None,
        region_id: str = None,
        scaling_group_id: str = None,
        scaling_group_ids: List[str] = None,
        spot_strategy: str = None,
        system_disk_categories: List[str] = None,
        v_switch_ids: List[str] = None,
    ):
        # The disk categories of the data disks. The disk categories that do not match the specified criteria are returned after you call this operation.
        # 
        # >  If you do not specify the scaling group ID, you must specify this parameter.
        self.data_disk_categories = data_disk_categories
        # The name of the image family. You can specify the ImageFamily request parameter to obtain the most recent available images in the current image family for instance creation. If you specify ImageId, you cannot specify ImageFamily.
        # 
        # >  If you do not specify the scaling group ID, you must specify at least one of ImageId, ImageName, and ImageFamily.
        self.image_family = image_family
        # The ID of the image file that provides the image resource for Auto Scaling to create instances.
        # 
        # >  If you do not specify the scaling group ID, you must specify at least one of ImageId, ImageName, and ImageFamily.
        self.image_id = image_id
        # The name of the image. Each image name must be unique in a region. If you specify ImageId, ImageName is ignored.
        # 
        # You cannot use ImageName to specify an Alibaba Cloud Marketplace image.
        # 
        # >  If you do not specify the scaling group ID, you must specify at least one of ImageId, ImageName, and ImageFamily.
        self.image_name = image_name
        # The instance types. The instance types specified by this parameter overwrite the instance types specified in the scaling configuration.
        self.instance_types = instance_types
        # The number of IPv6 addresses. If the instance type that you specified does meet the requirement for the number of IPv6 addresses, the scaling strength is weak.
        # 
        # >  If you do not specify the scaling group ID, you must specify this parameter.
        self.ipv_6address_count = ipv_6address_count
        # **\
        # 
        # **Warning** This parameter is deprecated. We recommend that you use SpotStrategy.
        # 
        # The preemption policy that you want to apply to pay-as-you-go instances. The preemption policy specified by this parameter overwrites the preemption policy specified in the scaling configuration. Valid values:
        # 
        # *   NoSpot: The instances are created as regular pay-as-you-go instances.
        # *   SpotWithPriceLimit: The instances are created as preemptible instances with a user-defined maximum hourly price.
        # *   SpotAsPriceGo: The instances are created as preemptible instances for which the market price at the time of purchase is automatically used as the bidding price.
        # 
        # Default value: NoSpot.
        self.priority_strategy = priority_strategy
        # The region ID of the scaling group.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id
        # The IDs of the scaling groups that you want to query.
        self.scaling_group_ids = scaling_group_ids
        # The instance bidding policy. Valid values:
        # 
        # *   NoSpot: The instances are created as pay-as-you-go instances.
        # *   SpotWithPriceLimit: The instances are created as preemptible instances with a user-defined maximum hourly price.
        # *   SpotAsPriceGo: The instances are created as preemptible instances for which the market price at the time of purchase is used as the bid price.
        # 
        # Default value: NoSpot.
        self.spot_strategy = spot_strategy
        # The categories of the system disks. The categories of the system disks specified by this parameter overwrite the categories of the system disks specified in the scaling configuration. Valid values:
        # 
        # *   cloud: basic disk.
        # *   cloud_efficiency: ultra disk.
        # *   cloud_ssd: standard SSD.
        # *   cloud_essd: Enterprise SSD (ESSD).
        # 
        # >  If you do not specify the scaling group ID, you must specify this parameter.
        self.system_disk_categories = system_disk_categories
        # The vSwitch IDs.
        # 
        # >  If you do not specify the scaling group ID, you must specify this parameter.
        self.v_switch_ids = v_switch_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_disk_categories is not None:
            result['DataDiskCategories'] = self.data_disk_categories
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.priority_strategy is not None:
            result['PriorityStrategy'] = self.priority_strategy
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.scaling_group_ids is not None:
            result['ScalingGroupIds'] = self.scaling_group_ids
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.system_disk_categories is not None:
            result['SystemDiskCategories'] = self.system_disk_categories
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataDiskCategories') is not None:
            self.data_disk_categories = m.get('DataDiskCategories')
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('PriorityStrategy') is not None:
            self.priority_strategy = m.get('PriorityStrategy')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('ScalingGroupIds') is not None:
            self.scaling_group_ids = m.get('ScalingGroupIds')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('SystemDiskCategories') is not None:
            self.system_disk_categories = m.get('SystemDiskCategories')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        return self


class DescribeElasticStrengthResponseBodyElasticStrengthModelsResourcePoolsInventoryHealth(TeaModel):
    def __init__(
        self,
        adequacy_score: int = None,
        health_score: int = None,
        hot_score: int = None,
        supply_score: int = None,
    ):
        # The adequacy score.
        # 
        # Valid values: 0 to 3.
        self.adequacy_score = adequacy_score
        # The score of the inventory health.
        # 
        # *   A score between 5 and 6 indicates a sufficient inventory.
        # *   A score between 1 and 4 indicates that there is no guarantee of a sufficient inventory. Select a reservation as necessary.
        # *   A score between -3 and 0 indicates that the inventory is sufficient, and an alert is triggered. Select another instance type.
        # 
        # Calculation formula: `HealthScore` = `AdequacyScore` + `SupplyScore` - `HotScore`.
        self.health_score = health_score
        # The popularity score.
        # 
        # Valid values: 0 to 3.
        self.hot_score = hot_score
        # The score of the replenishment capability.
        # 
        # Valid values: 0 to 3.
        self.supply_score = supply_score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adequacy_score is not None:
            result['AdequacyScore'] = self.adequacy_score
        if self.health_score is not None:
            result['HealthScore'] = self.health_score
        if self.hot_score is not None:
            result['HotScore'] = self.hot_score
        if self.supply_score is not None:
            result['SupplyScore'] = self.supply_score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdequacyScore') is not None:
            self.adequacy_score = m.get('AdequacyScore')
        if m.get('HealthScore') is not None:
            self.health_score = m.get('HealthScore')
        if m.get('HotScore') is not None:
            self.hot_score = m.get('HotScore')
        if m.get('SupplyScore') is not None:
            self.supply_score = m.get('SupplyScore')
        return self


class DescribeElasticStrengthResponseBodyElasticStrengthModelsResourcePools(TeaModel):
    def __init__(
        self,
        code: str = None,
        instance_type: str = None,
        inventory_health: DescribeElasticStrengthResponseBodyElasticStrengthModelsResourcePoolsInventoryHealth = None,
        msg: str = None,
        status: str = None,
        strength: float = None,
        v_switch_ids: List[str] = None,
        zone_id: str = None,
    ):
        # The error code returned when the scaling strength is the weakest.
        self.code = code
        # The instance type of the resource pool.
        self.instance_type = instance_type
        # The inventory health.
        self.inventory_health = inventory_health
        # The error message returned when the scaling strength is the weakest.
        self.msg = msg
        # Indicates whether the resource pool is available. Valid values:
        # 
        # *   Available
        # *   Unavailable (If a constraint is not provided, the instance type is not deployed, or the instance type is out of stock, the resource pool becomes unavailable.)
        self.status = status
        # The scaling strength of the resource pool.
        # 
        # **\
        # 
        # **Warning** This parameter is deprecated.
        self.strength = strength
        # The IDs of the vSwitches in the zones of the resource pool.
        self.v_switch_ids = v_switch_ids
        # The zone ID of the resource pool.
        self.zone_id = zone_id

    def validate(self):
        if self.inventory_health:
            self.inventory_health.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.inventory_health is not None:
            result['InventoryHealth'] = self.inventory_health.to_map()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.status is not None:
            result['Status'] = self.status
        if self.strength is not None:
            result['Strength'] = self.strength
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InventoryHealth') is not None:
            temp_model = DescribeElasticStrengthResponseBodyElasticStrengthModelsResourcePoolsInventoryHealth()
            self.inventory_health = temp_model.from_map(m['InventoryHealth'])
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Strength') is not None:
            self.strength = m.get('Strength')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeElasticStrengthResponseBodyElasticStrengthModels(TeaModel):
    def __init__(
        self,
        elastic_strength: str = None,
        resource_pools: List[DescribeElasticStrengthResponseBodyElasticStrengthModelsResourcePools] = None,
        scaling_group_id: str = None,
        total_strength: float = None,
    ):
        # The scaling strength level of the scaling group. Valid values:
        # 
        # *   Strong
        # *   Medium
        # *   Weak
        self.elastic_strength = elastic_strength
        # The resource pools.
        self.resource_pools = resource_pools
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id
        # The scaling strength score of the scaling group. Each combination of instance type + zone is scored from 0 to 1 based on its availability, with 0 being the weakest scaling strength and 1 being the strongest. The scaling strength score of the scaling group is measured by the combined scores of all the combinations of instance type + zone.
        # 
        # **\
        # 
        # **Warning** This parameter is deprecated.
        self.total_strength = total_strength

    def validate(self):
        if self.resource_pools:
            for k in self.resource_pools:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.elastic_strength is not None:
            result['ElasticStrength'] = self.elastic_strength
        result['ResourcePools'] = []
        if self.resource_pools is not None:
            for k in self.resource_pools:
                result['ResourcePools'].append(k.to_map() if k else None)
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.total_strength is not None:
            result['TotalStrength'] = self.total_strength
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ElasticStrength') is not None:
            self.elastic_strength = m.get('ElasticStrength')
        self.resource_pools = []
        if m.get('ResourcePools') is not None:
            for k in m.get('ResourcePools'):
                temp_model = DescribeElasticStrengthResponseBodyElasticStrengthModelsResourcePools()
                self.resource_pools.append(temp_model.from_map(k))
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('TotalStrength') is not None:
            self.total_strength = m.get('TotalStrength')
        return self


class DescribeElasticStrengthResponseBodyResourcePoolsInventoryHealth(TeaModel):
    def __init__(
        self,
        adequacy_score: int = None,
        health_score: int = None,
        hot_score: int = None,
        supply_score: int = None,
    ):
        # The adequacy score.
        # 
        # Valid values: 0 to 3.
        self.adequacy_score = adequacy_score
        # The inventory health score.
        # 
        # *   A score between 5 and 6 indicates a sufficient inventory.
        # *   A score between 1 and 4 indicates that there is no guarantee of a sufficient inventory. Select a reservation as necessary.
        # *   A score between -3 and 0 indicates that the inventory is sufficient, and an alert is triggered. Select another instance type.
        # 
        # Calculation formula: `HealthScore` = `AdequacyScore` + `SupplyScore` - `HotScore`.
        self.health_score = health_score
        # The popularity score.
        # 
        # Valid values: 0 to 3.
        self.hot_score = hot_score
        # The replenishment capability score.
        # 
        # Valid values: 0 to 3.
        self.supply_score = supply_score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adequacy_score is not None:
            result['AdequacyScore'] = self.adequacy_score
        if self.health_score is not None:
            result['HealthScore'] = self.health_score
        if self.hot_score is not None:
            result['HotScore'] = self.hot_score
        if self.supply_score is not None:
            result['SupplyScore'] = self.supply_score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdequacyScore') is not None:
            self.adequacy_score = m.get('AdequacyScore')
        if m.get('HealthScore') is not None:
            self.health_score = m.get('HealthScore')
        if m.get('HotScore') is not None:
            self.hot_score = m.get('HotScore')
        if m.get('SupplyScore') is not None:
            self.supply_score = m.get('SupplyScore')
        return self


class DescribeElasticStrengthResponseBodyResourcePools(TeaModel):
    def __init__(
        self,
        code: str = None,
        instance_type: str = None,
        inventory_health: DescribeElasticStrengthResponseBodyResourcePoolsInventoryHealth = None,
        msg: str = None,
        status: str = None,
        strength: float = None,
        v_switch_ids: List[str] = None,
        zone_id: str = None,
    ):
        # The error code returned when the scaling strength is the weakest.
        self.code = code
        # The instance type of the resource pool.
        self.instance_type = instance_type
        # The inventory health.
        self.inventory_health = inventory_health
        # The error message returned when the scaling strength is the weakest.
        self.msg = msg
        # Indicates whether the resource pool is available. Valid values:
        # 
        # *   Available
        # *   Unavailable (If a constraint is not provided, the instance type is not deployed, or the instance type is out of stock, the resource pool becomes unavailable.)
        self.status = status
        # The scaling strength of the resource pool.
        self.strength = strength
        # The IDs of the vSwitches in the zones of the resource pool.
        self.v_switch_ids = v_switch_ids
        # The zone ID of the resource pool.
        self.zone_id = zone_id

    def validate(self):
        if self.inventory_health:
            self.inventory_health.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.inventory_health is not None:
            result['InventoryHealth'] = self.inventory_health.to_map()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.status is not None:
            result['Status'] = self.status
        if self.strength is not None:
            result['Strength'] = self.strength
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InventoryHealth') is not None:
            temp_model = DescribeElasticStrengthResponseBodyResourcePoolsInventoryHealth()
            self.inventory_health = temp_model.from_map(m['InventoryHealth'])
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Strength') is not None:
            self.strength = m.get('Strength')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeElasticStrengthResponseBody(TeaModel):
    def __init__(
        self,
        elastic_strength: str = None,
        elastic_strength_models: List[DescribeElasticStrengthResponseBodyElasticStrengthModels] = None,
        request_id: str = None,
        resource_pools: List[DescribeElasticStrengthResponseBodyResourcePools] = None,
        total_strength: float = None,
    ):
        # The scaling strength level of the scaling group. Valid values:
        # 
        # *   Strong
        # *   Medium
        # *   Weak
        self.elastic_strength = elastic_strength
        # The scaling strength models.
        self.elastic_strength_models = elastic_strength_models
        # The request ID.
        self.request_id = request_id
        # The resource pools.
        self.resource_pools = resource_pools
        # The scaling strength score of the scaling group. Each combination of instance type + zone is scored from 0 to 1 based on its availability, with 0 being the weakest scaling strength and 1 being the strongest. The scaling strength score of the scaling group is measured by the combined scores of all the combinations of instance type + zone.
        # 
        # **\
        # 
        # **Warning** This parameter is deprecated.
        self.total_strength = total_strength

    def validate(self):
        if self.elastic_strength_models:
            for k in self.elastic_strength_models:
                if k:
                    k.validate()
        if self.resource_pools:
            for k in self.resource_pools:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.elastic_strength is not None:
            result['ElasticStrength'] = self.elastic_strength
        result['ElasticStrengthModels'] = []
        if self.elastic_strength_models is not None:
            for k in self.elastic_strength_models:
                result['ElasticStrengthModels'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ResourcePools'] = []
        if self.resource_pools is not None:
            for k in self.resource_pools:
                result['ResourcePools'].append(k.to_map() if k else None)
        if self.total_strength is not None:
            result['TotalStrength'] = self.total_strength
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ElasticStrength') is not None:
            self.elastic_strength = m.get('ElasticStrength')
        self.elastic_strength_models = []
        if m.get('ElasticStrengthModels') is not None:
            for k in m.get('ElasticStrengthModels'):
                temp_model = DescribeElasticStrengthResponseBodyElasticStrengthModels()
                self.elastic_strength_models.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.resource_pools = []
        if m.get('ResourcePools') is not None:
            for k in m.get('ResourcePools'):
                temp_model = DescribeElasticStrengthResponseBodyResourcePools()
                self.resource_pools.append(temp_model.from_map(k))
        if m.get('TotalStrength') is not None:
            self.total_strength = m.get('TotalStrength')
        return self


class DescribeElasticStrengthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeElasticStrengthResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeElasticStrengthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceRefreshesRequest(TeaModel):
    def __init__(
        self,
        instance_refresh_task_ids: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        scaling_group_id: str = None,
    ):
        # The IDs of the instance refresh tasks that you want to query.
        self.instance_refresh_task_ids = instance_refresh_task_ids
        # The maximum number of entries per page. Valid values: 1 to 50. Default value: 10.
        self.max_results = max_results
        # The pagination token that is used in the next request to retrieve a new page of results. You do not need to specify this parameter for the first request. You must specify the token that is obtained from the previous query as the value of NextToken.
        self.next_token = next_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The region ID of the scaling group to which the instance refresh task belongs.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        # The ID of the scaling group.
        # 
        # >  When you call this operation, you must specify one of the following parameters: ScalingGroupId and InstanceRefreshTaskIds. You cannot specify both of them. If you specify neither of them, an error is reported.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_refresh_task_ids is not None:
            result['InstanceRefreshTaskIds'] = self.instance_refresh_task_ids
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceRefreshTaskIds') is not None:
            self.instance_refresh_task_ids = m.get('InstanceRefreshTaskIds')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DescribeInstanceRefreshesResponseBodyInstanceRefreshTasksDesiredConfiguration(TeaModel):
    def __init__(
        self,
        image_id: str = None,
        scaling_configuration_id: str = None,
    ):
        # The ID of the image file that provides the image resource for Auto Scaling to create instances.
        self.image_id = image_id
        # The ID of the scaling configuration.
        self.scaling_configuration_id = scaling_configuration_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        return self


class DescribeInstanceRefreshesResponseBodyInstanceRefreshTasks(TeaModel):
    def __init__(
        self,
        desired_configuration: DescribeInstanceRefreshesResponseBodyInstanceRefreshTasksDesiredConfiguration = None,
        detail: str = None,
        end_time: str = None,
        finished_update_capacity: int = None,
        instance_refresh_task_id: str = None,
        max_healthy_percentage: int = None,
        min_healthy_percentage: int = None,
        region_id: str = None,
        scaling_group_id: str = None,
        skip_matching: bool = None,
        start_time: str = None,
        status: str = None,
        total_need_update_capacity: int = None,
    ):
        # The desired configurations of the instance refresh task.
        self.desired_configuration = desired_configuration
        # The reason why the instance refresh task failed to be executed.
        self.detail = detail
        # The end time of the instance refresh task.
        self.end_time = end_time
        # The refreshed number of instances in the scaling group.
        self.finished_update_capacity = finished_update_capacity
        # The ID of the instance refresh task.
        self.instance_refresh_task_id = instance_refresh_task_id
        # The ratio by which the number of instances in the scaling group can exceed the upper limit for the number of instances in the scaling group during instance refresh.
        self.max_healthy_percentage = max_healthy_percentage
        # The ratio of the number of instances that provide services to the total number of instances in the scaling group during instance refresh.
        self.min_healthy_percentage = min_healthy_percentage
        # The region ID of the scaling group.
        self.region_id = region_id
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id
        # Indicates whether instances that match the desired scaling configuration are skipped.
        # 
        # >  The system determines the match based on the ID of the desired scaling configuration rather than individual configuration items.
        # 
        # Valid values:
        # 
        # *   true: Instances that match the desired scaling configuration are skipped. When you initiate an instance refresh task, the system checks the configurations of all instances. The refresh operation is skipped for instances created based on the desired scaling configuration.
        # *   false: Instances that match the desired scaling configuration are not skipped. When an instance refresh task is initiated, all instances in the scaling group at the time of initiation are refreshed.
        self.skip_matching = skip_matching
        # The start time of the instance refresh task.
        self.start_time = start_time
        # The status of the instance refresh task. Valid values:
        # 
        # *   Pending: The instance refresh task is created and is waiting to be scheduled.
        # *   InProgress: The instance refresh task is being executed.
        # *   Paused: The instance refresh task is suspended.
        # *   Failed: The instance refresh task failed to be executed.
        # *   Successful: The instance refresh task is successful.
        # *   Cancelling: The instance refresh task is being canceled.
        # *   Cancelled: The instance refresh task is canceled.
        # *   RollbackInProgress: The instance refresh task is being rolled back.
        # *   RollbackSuccessful: The instance refresh task is rolled back.
        # *   RollbackFailed: The instance refresh task fails to be rolled back.
        self.status = status
        # The total number of instances whose configurations are refreshed.
        self.total_need_update_capacity = total_need_update_capacity

    def validate(self):
        if self.desired_configuration:
            self.desired_configuration.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desired_configuration is not None:
            result['DesiredConfiguration'] = self.desired_configuration.to_map()
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.finished_update_capacity is not None:
            result['FinishedUpdateCapacity'] = self.finished_update_capacity
        if self.instance_refresh_task_id is not None:
            result['InstanceRefreshTaskId'] = self.instance_refresh_task_id
        if self.max_healthy_percentage is not None:
            result['MaxHealthyPercentage'] = self.max_healthy_percentage
        if self.min_healthy_percentage is not None:
            result['MinHealthyPercentage'] = self.min_healthy_percentage
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.skip_matching is not None:
            result['SkipMatching'] = self.skip_matching
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.total_need_update_capacity is not None:
            result['TotalNeedUpdateCapacity'] = self.total_need_update_capacity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DesiredConfiguration') is not None:
            temp_model = DescribeInstanceRefreshesResponseBodyInstanceRefreshTasksDesiredConfiguration()
            self.desired_configuration = temp_model.from_map(m['DesiredConfiguration'])
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FinishedUpdateCapacity') is not None:
            self.finished_update_capacity = m.get('FinishedUpdateCapacity')
        if m.get('InstanceRefreshTaskId') is not None:
            self.instance_refresh_task_id = m.get('InstanceRefreshTaskId')
        if m.get('MaxHealthyPercentage') is not None:
            self.max_healthy_percentage = m.get('MaxHealthyPercentage')
        if m.get('MinHealthyPercentage') is not None:
            self.min_healthy_percentage = m.get('MinHealthyPercentage')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('SkipMatching') is not None:
            self.skip_matching = m.get('SkipMatching')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalNeedUpdateCapacity') is not None:
            self.total_need_update_capacity = m.get('TotalNeedUpdateCapacity')
        return self


class DescribeInstanceRefreshesResponseBody(TeaModel):
    def __init__(
        self,
        instance_refresh_tasks: List[DescribeInstanceRefreshesResponseBodyInstanceRefreshTasks] = None,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The instance refresh tasks.
        self.instance_refresh_tasks = instance_refresh_tasks
        # The maximum number of entries per page.
        self.max_results = max_results
        # A pagination token. It can be used in the next request to retrieve a new page of results. If NextToken is empty, no next page exists.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id
        # The total number of instance refresh tasks.
        self.total_count = total_count

    def validate(self):
        if self.instance_refresh_tasks:
            for k in self.instance_refresh_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceRefreshTasks'] = []
        if self.instance_refresh_tasks is not None:
            for k in self.instance_refresh_tasks:
                result['InstanceRefreshTasks'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_refresh_tasks = []
        if m.get('InstanceRefreshTasks') is not None:
            for k in m.get('InstanceRefreshTasks'):
                temp_model = DescribeInstanceRefreshesResponseBodyInstanceRefreshTasks()
                self.instance_refresh_tasks.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceRefreshesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceRefreshesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceRefreshesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLifecycleActionsRequest(TeaModel):
    def __init__(
        self,
        lifecycle_action_status: str = None,
        max_results: int = None,
        next_token: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_activity_id: str = None,
    ):
        # The status of the lifecycle action. Valid values:
        # 
        # *   If a lifecycle action is in the Pending state, Elastic Compute Service (ECS) instances are waiting to be added to a scaling group or waiting to be removed from a scaling group.
        # *   If a lifecycle action is in the Timeout state, the lifecycle hook that triggers the lifecycle action ends, and ECS instances are added to or removed from the scaling group.
        # *   If a lifecycle action is in the Completed state, you manually end the lifecycle hook that triggers the lifecycle action ahead of schedule.
        self.lifecycle_action_status = lifecycle_action_status
        # The maximum number of entries to return on each page. Valid values: 1 to 50.
        # 
        # Default value: 10.
        self.max_results = max_results
        # The token that is used to specify the lifecycle action from which the query starts.
        # 
        # For example, after the first 10 lifecycle actions are queried, the query starts from the 11th lifecycle action. Set this parameter to the NextToken value that is returned in the previous API call. If you do not specify this parameter, the query starts from the beginning.
        self.next_token = next_token
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling activity.
        # 
        # This parameter is required.
        self.scaling_activity_id = scaling_activity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lifecycle_action_status is not None:
            result['LifecycleActionStatus'] = self.lifecycle_action_status
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_activity_id is not None:
            result['ScalingActivityId'] = self.scaling_activity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LifecycleActionStatus') is not None:
            self.lifecycle_action_status = m.get('LifecycleActionStatus')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingActivityId') is not None:
            self.scaling_activity_id = m.get('ScalingActivityId')
        return self


class DescribeLifecycleActionsResponseBodyLifecycleActions(TeaModel):
    def __init__(
        self,
        instance_ids: List[str] = None,
        lifecycle_action_result: str = None,
        lifecycle_action_status: str = None,
        lifecycle_action_token: str = None,
        lifecycle_hook_id: str = None,
    ):
        # The IDs of the ECS instances on which the lifecycle hook takes effect
        self.instance_ids = instance_ids
        # The subsequent action that Auto Scaling performs after the lifecycle hook times out. Valid values:
        # 
        # *   CONTINUE: Auto Scaling continues to respond to a scale-in or scale-out request.
        # *   ABANDON: Auto Scaling releases ECS instances that are created during scale-out events, or removes ECS instances from the scaling group during scale-in events.
        self.lifecycle_action_result = lifecycle_action_result
        # The status of the lifecycle hook action.
        self.lifecycle_action_status = lifecycle_action_status
        # The token of the lifecycle hook action.
        self.lifecycle_action_token = lifecycle_action_token
        # The ID of the lifecycle hook.
        self.lifecycle_hook_id = lifecycle_hook_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.lifecycle_action_result is not None:
            result['LifecycleActionResult'] = self.lifecycle_action_result
        if self.lifecycle_action_status is not None:
            result['LifecycleActionStatus'] = self.lifecycle_action_status
        if self.lifecycle_action_token is not None:
            result['LifecycleActionToken'] = self.lifecycle_action_token
        if self.lifecycle_hook_id is not None:
            result['LifecycleHookId'] = self.lifecycle_hook_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('LifecycleActionResult') is not None:
            self.lifecycle_action_result = m.get('LifecycleActionResult')
        if m.get('LifecycleActionStatus') is not None:
            self.lifecycle_action_status = m.get('LifecycleActionStatus')
        if m.get('LifecycleActionToken') is not None:
            self.lifecycle_action_token = m.get('LifecycleActionToken')
        if m.get('LifecycleHookId') is not None:
            self.lifecycle_hook_id = m.get('LifecycleHookId')
        return self


class DescribeLifecycleActionsResponseBody(TeaModel):
    def __init__(
        self,
        lifecycle_actions: List[DescribeLifecycleActionsResponseBodyLifecycleActions] = None,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The actions of the lifecycle hook.
        self.lifecycle_actions = lifecycle_actions
        # The maximum number of entries returned per page.
        self.max_results = max_results
        # The query token returned in this call.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id
        # The total number of the queried lifecycle actions.
        self.total_count = total_count

    def validate(self):
        if self.lifecycle_actions:
            for k in self.lifecycle_actions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LifecycleActions'] = []
        if self.lifecycle_actions is not None:
            for k in self.lifecycle_actions:
                result['LifecycleActions'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.lifecycle_actions = []
        if m.get('LifecycleActions') is not None:
            for k in m.get('LifecycleActions'):
                temp_model = DescribeLifecycleActionsResponseBodyLifecycleActions()
                self.lifecycle_actions.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeLifecycleActionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLifecycleActionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLifecycleActionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLifecycleHooksRequest(TeaModel):
    def __init__(
        self,
        lifecycle_hook_ids: List[str] = None,
        lifecycle_hook_name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        # The IDs of the lifecycle hooks that you want to query.
        self.lifecycle_hook_ids = lifecycle_hook_ids
        # The name of the lifecycle hook.
        self.lifecycle_hook_name = lifecycle_hook_name
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The number of the page to return. Pages start from page 1.
        # 
        # Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: 50.
        # 
        # Default value: 50.
        self.page_size = page_size
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lifecycle_hook_ids is not None:
            result['LifecycleHookIds'] = self.lifecycle_hook_ids
        if self.lifecycle_hook_name is not None:
            result['LifecycleHookName'] = self.lifecycle_hook_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LifecycleHookIds') is not None:
            self.lifecycle_hook_ids = m.get('LifecycleHookIds')
        if m.get('LifecycleHookName') is not None:
            self.lifecycle_hook_name = m.get('LifecycleHookName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DescribeLifecycleHooksResponseBodyLifecycleHooks(TeaModel):
    def __init__(
        self,
        default_result: str = None,
        heartbeat_timeout: int = None,
        lifecycle_hook_id: str = None,
        lifecycle_hook_name: str = None,
        lifecycle_hook_status: str = None,
        lifecycle_transition: str = None,
        notification_arn: str = None,
        notification_metadata: str = None,
        scaling_group_id: str = None,
    ):
        # The next action that is performed after the lifecycle hook times out.
        self.default_result = default_result
        # The period of time before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action that is specified by DefaultResult.
        self.heartbeat_timeout = heartbeat_timeout
        # The ID of the lifecycle hook.
        self.lifecycle_hook_id = lifecycle_hook_id
        # The name of the lifecycle hook.
        self.lifecycle_hook_name = lifecycle_hook_name
        # The status of the lifecycle hook. Valid values:
        # 
        # *   Active: The lifecycle hook is enabled.
        # *   InActive: The lifecycle hook is disabled.
        self.lifecycle_hook_status = lifecycle_hook_status
        # The type of the scaling activity to which the lifecycle hook applies.
        self.lifecycle_transition = lifecycle_transition
        # The ARN of the notification recipient when the lifecycle hook takes effect. The value of this parameter must be in one of the following formats:
        # 
        # *   If you do not create a notification rule, specify the value in the `acs:ess:{region-id}:{account-id}:null/null` format.
        # *   If you specify a Simple Message Queue (SMQ, formerly MNS) queue as the notification recipient, specify the value in the `acs:mns:{region-id}:{account-id}:queue/{queuename}` format.
        # *   If you specify an SMQ as the notification recipient, specify the value in the `acs:mns:{region-id}:{account-id}:topic/{topicname}` format.
        # *   If you specify a CloudOps Orchestration Service (OOS) template as the notification recipient, specify the value in the `acs:oos:{region-id}:{account-id}:template/{templatename}` format.
        # *   If you specify an event bus as the notification recipient, specify the value in the `acs:eventbridge:{region-id}:{account-id}:eventbus/default` format.
        # 
        # The variables in the preceding value formats have the following meanings:
        # 
        # *   region-id: the region ID of your scaling group.
        # *   account-id: the ID of your Alibaba Cloud account.
        # *   queuename: the name of the SMQ queue.
        # *   topicname: the name of the SMQ topic.
        # *   templatename: the name of the OOS template.
        self.notification_arn = notification_arn
        # The fixed string that is included in a notification that Auto Scaling sends when the lifecycle hook takes effect.
        self.notification_metadata = notification_metadata
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_result is not None:
            result['DefaultResult'] = self.default_result
        if self.heartbeat_timeout is not None:
            result['HeartbeatTimeout'] = self.heartbeat_timeout
        if self.lifecycle_hook_id is not None:
            result['LifecycleHookId'] = self.lifecycle_hook_id
        if self.lifecycle_hook_name is not None:
            result['LifecycleHookName'] = self.lifecycle_hook_name
        if self.lifecycle_hook_status is not None:
            result['LifecycleHookStatus'] = self.lifecycle_hook_status
        if self.lifecycle_transition is not None:
            result['LifecycleTransition'] = self.lifecycle_transition
        if self.notification_arn is not None:
            result['NotificationArn'] = self.notification_arn
        if self.notification_metadata is not None:
            result['NotificationMetadata'] = self.notification_metadata
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultResult') is not None:
            self.default_result = m.get('DefaultResult')
        if m.get('HeartbeatTimeout') is not None:
            self.heartbeat_timeout = m.get('HeartbeatTimeout')
        if m.get('LifecycleHookId') is not None:
            self.lifecycle_hook_id = m.get('LifecycleHookId')
        if m.get('LifecycleHookName') is not None:
            self.lifecycle_hook_name = m.get('LifecycleHookName')
        if m.get('LifecycleHookStatus') is not None:
            self.lifecycle_hook_status = m.get('LifecycleHookStatus')
        if m.get('LifecycleTransition') is not None:
            self.lifecycle_transition = m.get('LifecycleTransition')
        if m.get('NotificationArn') is not None:
            self.notification_arn = m.get('NotificationArn')
        if m.get('NotificationMetadata') is not None:
            self.notification_metadata = m.get('NotificationMetadata')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DescribeLifecycleHooksResponseBody(TeaModel):
    def __init__(
        self,
        lifecycle_hooks: List[DescribeLifecycleHooksResponseBodyLifecycleHooks] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # Details about the lifecycle hooks.
        self.lifecycle_hooks = lifecycle_hooks
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of lifecycle hooks.
        self.total_count = total_count

    def validate(self):
        if self.lifecycle_hooks:
            for k in self.lifecycle_hooks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LifecycleHooks'] = []
        if self.lifecycle_hooks is not None:
            for k in self.lifecycle_hooks:
                result['LifecycleHooks'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.lifecycle_hooks = []
        if m.get('LifecycleHooks') is not None:
            for k in m.get('LifecycleHooks'):
                temp_model = DescribeLifecycleHooksResponseBodyLifecycleHooks()
                self.lifecycle_hooks.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeLifecycleHooksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLifecycleHooksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLifecycleHooksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLimitationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        return self


class DescribeLimitationResponseBody(TeaModel):
    def __init__(
        self,
        max_number_of_alb_server_group: int = None,
        max_number_of_dbinstances: int = None,
        max_number_of_lifecycle_hooks: int = None,
        max_number_of_load_balancers: int = None,
        max_number_of_max_size: int = None,
        max_number_of_min_size: int = None,
        max_number_of_nlb_server_group: int = None,
        max_number_of_notification_configurations: int = None,
        max_number_of_scaling_configurations: int = None,
        max_number_of_scaling_groups: int = None,
        max_number_of_scaling_instances: int = None,
        max_number_of_scaling_rules: int = None,
        max_number_of_scheduled_tasks: int = None,
        max_number_of_vserver_groups: int = None,
        request_id: str = None,
    ):
        # The maximum number of Application Load Balancer (ALB) server groups that can be attached to a scaling group.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_alb_server_group = max_number_of_alb_server_group
        # The maximum number of ApsaraDB RDS instances that can be associated with a scaling group.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_dbinstances = max_number_of_dbinstances
        # The maximum number of lifecycle hooks that can be created in a scaling group.
        self.max_number_of_lifecycle_hooks = max_number_of_lifecycle_hooks
        # The maximum number of Classic Load Balancer (CLB, formerly known as SLB) instances that can be associated with a scaling group.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_load_balancers = max_number_of_load_balancers
        # The maximum number of instances that can be contained in a scaling group.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_max_size = max_number_of_max_size
        # The minimum number of instances that must be contained in a scaling group. The value of `MaxNumberOfMinSize` must be consistent with the value of `MaxNumberOfMaxSize`.
        self.max_number_of_min_size = max_number_of_min_size
        # The maximum number of Network Load Balancer (NLB) server groups that can be attached to a scaling group.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_nlb_server_group = max_number_of_nlb_server_group
        # The maximum number of notification rules that can be created in a scaling group.
        self.max_number_of_notification_configurations = max_number_of_notification_configurations
        # The maximum number of scaling configurations that can be created in a scaling group.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_scaling_configurations = max_number_of_scaling_configurations
        # The maximum number of scaling groups that can be created in a region by using an Alibaba Cloud account.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_scaling_groups = max_number_of_scaling_groups
        # The maximum number of Elastic Compute Service (ECS) instances or elastic container instances that can be automatically scaled in a scaling group at the same time.
        self.max_number_of_scaling_instances = max_number_of_scaling_instances
        # The maximum number of scaling rules that can be created in a scaling group.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_scaling_rules = max_number_of_scaling_rules
        # The maximum number of scheduled tasks that can be created in a region by using an Alibaba Cloud account.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_scheduled_tasks = max_number_of_scheduled_tasks
        # The maximum number of CLB vServer groups that can be attached to a scaling group.
        # 
        # >  To view the quota or request a quota increase, go to [Quota Center](https://quotas.console.aliyun.com/products/ess/quotas).
        self.max_number_of_vserver_groups = max_number_of_vserver_groups
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_number_of_alb_server_group is not None:
            result['MaxNumberOfAlbServerGroup'] = self.max_number_of_alb_server_group
        if self.max_number_of_dbinstances is not None:
            result['MaxNumberOfDBInstances'] = self.max_number_of_dbinstances
        if self.max_number_of_lifecycle_hooks is not None:
            result['MaxNumberOfLifecycleHooks'] = self.max_number_of_lifecycle_hooks
        if self.max_number_of_load_balancers is not None:
            result['MaxNumberOfLoadBalancers'] = self.max_number_of_load_balancers
        if self.max_number_of_max_size is not None:
            result['MaxNumberOfMaxSize'] = self.max_number_of_max_size
        if self.max_number_of_min_size is not None:
            result['MaxNumberOfMinSize'] = self.max_number_of_min_size
        if self.max_number_of_nlb_server_group is not None:
            result['MaxNumberOfNlbServerGroup'] = self.max_number_of_nlb_server_group
        if self.max_number_of_notification_configurations is not None:
            result['MaxNumberOfNotificationConfigurations'] = self.max_number_of_notification_configurations
        if self.max_number_of_scaling_configurations is not None:
            result['MaxNumberOfScalingConfigurations'] = self.max_number_of_scaling_configurations
        if self.max_number_of_scaling_groups is not None:
            result['MaxNumberOfScalingGroups'] = self.max_number_of_scaling_groups
        if self.max_number_of_scaling_instances is not None:
            result['MaxNumberOfScalingInstances'] = self.max_number_of_scaling_instances
        if self.max_number_of_scaling_rules is not None:
            result['MaxNumberOfScalingRules'] = self.max_number_of_scaling_rules
        if self.max_number_of_scheduled_tasks is not None:
            result['MaxNumberOfScheduledTasks'] = self.max_number_of_scheduled_tasks
        if self.max_number_of_vserver_groups is not None:
            result['MaxNumberOfVServerGroups'] = self.max_number_of_vserver_groups
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxNumberOfAlbServerGroup') is not None:
            self.max_number_of_alb_server_group = m.get('MaxNumberOfAlbServerGroup')
        if m.get('MaxNumberOfDBInstances') is not None:
            self.max_number_of_dbinstances = m.get('MaxNumberOfDBInstances')
        if m.get('MaxNumberOfLifecycleHooks') is not None:
            self.max_number_of_lifecycle_hooks = m.get('MaxNumberOfLifecycleHooks')
        if m.get('MaxNumberOfLoadBalancers') is not None:
            self.max_number_of_load_balancers = m.get('MaxNumberOfLoadBalancers')
        if m.get('MaxNumberOfMaxSize') is not None:
            self.max_number_of_max_size = m.get('MaxNumberOfMaxSize')
        if m.get('MaxNumberOfMinSize') is not None:
            self.max_number_of_min_size = m.get('MaxNumberOfMinSize')
        if m.get('MaxNumberOfNlbServerGroup') is not None:
            self.max_number_of_nlb_server_group = m.get('MaxNumberOfNlbServerGroup')
        if m.get('MaxNumberOfNotificationConfigurations') is not None:
            self.max_number_of_notification_configurations = m.get('MaxNumberOfNotificationConfigurations')
        if m.get('MaxNumberOfScalingConfigurations') is not None:
            self.max_number_of_scaling_configurations = m.get('MaxNumberOfScalingConfigurations')
        if m.get('MaxNumberOfScalingGroups') is not None:
            self.max_number_of_scaling_groups = m.get('MaxNumberOfScalingGroups')
        if m.get('MaxNumberOfScalingInstances') is not None:
            self.max_number_of_scaling_instances = m.get('MaxNumberOfScalingInstances')
        if m.get('MaxNumberOfScalingRules') is not None:
            self.max_number_of_scaling_rules = m.get('MaxNumberOfScalingRules')
        if m.get('MaxNumberOfScheduledTasks') is not None:
            self.max_number_of_scheduled_tasks = m.get('MaxNumberOfScheduledTasks')
        if m.get('MaxNumberOfVServerGroups') is not None:
            self.max_number_of_vserver_groups = m.get('MaxNumberOfVServerGroups')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLimitationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLimitationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLimitationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNotificationConfigurationsRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        scaling_group_id: str = None,
    ):
        self.owner_id = owner_id
        # The region ID of the scaling group.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        # The ID of the scaling group.
        # 
        # This parameter is required.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DescribeNotificationConfigurationsResponseBodyNotificationConfigurationModels(TeaModel):
    def __init__(
        self,
        notification_arn: str = None,
        notification_types: List[str] = None,
        scaling_group_id: str = None,
        time_zone: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the notification recipient. The value is in one of the following formats:
        # 
        # *   If you specify CloudMonitor as the notification recipient, the value is in the acs:ess:{region-id}:{account-id}:cloudmonitor format.
        # *   If you specify a Simple Message Queue (SMQ, formerly MNS) as the notification recipient, the value is in the acs:mns:{region-id}:{account-id}:queue/{queuename} format.
        # *   If you specify an SMQ topic as the notification recipient, the value is in the acs:mns:{region-id}:{account-id}:topic/{topicname} format.
        # 
        # The variables in the preceding value formats have the following meanings:
        # 
        # *   region-id: the region ID of your scaling group.
        # *   account-id: the ID of your Alibaba Cloud account.
        # *   queuename: the name of the SMQ queue.
        # *   topicname: the name of the SMQ topic.
        self.notification_arn = notification_arn
        # The types of the notifications.
        self.notification_types = notification_types
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id
        # The time zone of the notification. The value must be in UTC. For example, a value of UTC+8 indicates that the time is 8 hours ahead of Coordinated Universal Time, and a value of UTC-7 indicates that the time is 7 hours behind Coordinated Universal Time.
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notification_arn is not None:
            result['NotificationArn'] = self.notification_arn
        if self.notification_types is not None:
            result['NotificationTypes'] = self.notification_types
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NotificationArn') is not None:
            self.notification_arn = m.get('NotificationArn')
        if m.get('NotificationTypes') is not None:
            self.notification_types = m.get('NotificationTypes')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class DescribeNotificationConfigurationsResponseBody(TeaModel):
    def __init__(
        self,
        notification_configuration_models: List[DescribeNotificationConfigurationsResponseBodyNotificationConfigurationModels] = None,
        request_id: str = None,
    ):
        # The notification settings.
        self.notification_configuration_models = notification_configuration_models
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.notification_configuration_models:
            for k in self.notification_configuration_models:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NotificationConfigurationModels'] = []
        if self.notification_configuration_models is not None:
            for k in self.notification_configuration_models:
                result['NotificationConfigurationModels'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.notification_configuration_models = []
        if m.get('NotificationConfigurationModels') is not None:
            for k in m.get('NotificationConfigurationModels'):
                temp_model = DescribeNotificationConfigurationsResponseBodyNotificationConfigurationModels()
                self.notification_configuration_models.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNotificationConfigurationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNotificationConfigurationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNotificationConfigurationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNotificationTypesRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        return self


class DescribeNotificationTypesResponseBody(TeaModel):
    def __init__(
        self,
        notification_types: List[str] = None,
        request_id: str = None,
    ):
        # The types of the notifications.
        # 
        # *   AUTOSCALING:SCALE_OUT_SUCCESS: The scale-out activity succeeds.
        # *   AUTOSCALING:SCALE_IN_SUCCESS: The scale-in activity succeeds.
        # *   AUTOSCALING:SCALE_OUT_ERROR: The scale-out activity fails.
        # *   AUTOSCALING:SCALE_IN_ERROR: The scale-in activity fails.
        # *   AUTOSCALING:SCALE_REJECT: The request for scaling activities is rejected.
        # *   AUTOSCALING:SCALE_OUT_START: The scale-out activity starts.
        # *   AUTOSCALING:SCALE_IN_START: The scale-in activity starts.
        # *   AUTOSCALING:SCHEDULE_TASK_EXPIRING: Auto Scaling sends a notification when a scheduled task is about to expire.
        self.notification_types = notification_types
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notification_types is not None:
            result['NotificationTypes'] = self.notification_types
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NotificationTypes') is not None:
            self.notification_types = m.get('NotificationTypes')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNotificationTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNotificationTypesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNotificationTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePatternTypesRequest(TeaModel):
    def __init__(
        self,
        architecture: List[str] = None,
        burstable_performance: str = None,
        channel_id: int = None,
        cores: int = None,
        cores_list: List[int] = None,
        cpu_architectures: List[str] = None,
        excluded_instance_type: List[str] = None,
        gpu_specs: List[str] = None,
        instance_categories: List[str] = None,
        instance_family_level: str = None,
        instance_type_families: List[str] = None,
        max_price: float = None,
        maximum_cpu_core_count: int = None,
        maximum_gpu_amount: int = None,
        maximum_memory_size: float = None,
        memory: float = None,
        memory_list: List[float] = None,
        minimum_baseline_credit: int = None,
        minimum_cpu_core_count: int = None,
        minimum_eni_ipv_6address_quantity: int = None,
        minimum_eni_private_ip_address_quantity: int = None,
        minimum_eni_quantity: int = None,
        minimum_gpu_amount: int = None,
        minimum_initial_credit: int = None,
        minimum_memory_size: float = None,
        physical_processor_models: List[str] = None,
        region_id: str = None,
        spot_strategy: str = None,
        v_switch_id: List[str] = None,
        zone_id: List[str] = None,
    ):
        # The architecture types of the instance types. Valid values:
        # 
        # *   X86: x86 architecture.
        # *   Heterogeneous: heterogeneous computing, such as GPU-accelerated or FPGA-accelerated.
        # *   BareMetal: ECS Bare Metal Instance.
        # *   Arm: Arm.
        # 
        # By default, all values are selected.
        self.architecture = architecture
        # Specifies whether to include burstable instance types. Valid values:
        # 
        # *   Exclude: does not include burstable instance types.
        # *   Include: includes burstable instance types.
        # *   Required: includes only burstable instance types.
        # 
        # Default value: Include.
        self.burstable_performance = burstable_performance
        # The channel ID. This parameter is not for public use.
        self.channel_id = channel_id
        # The number of vCPUs that you want to assign to the instance type.
        self.cores = cores
        # The number of vCPUs that you want to assign to the instance type. You can specify multiple vCPUs.
        self.cores_list = cores_list
        # The CPU architectures of the instance types. Valid values:
        # 
        # >  You can specify 1 to 2 CPU architectures.
        # 
        # *   x86
        # *   Arm
        self.cpu_architectures = cpu_architectures
        self.excluded_instance_type = excluded_instance_type
        # The GPU models.
        self.gpu_specs = gpu_specs
        # The classifications of the instance types. Valid values:
        # 
        # *   General-purpose: general-purpose instance type.
        # *   Compute-optimized: compute-optimized instance type.
        # *   Memory-optimized: memory-optimized instance type.
        # *   Big data: big data instance type.
        # *   Local SSDs: instance type with local SSDs.
        # *   High Clock Speed: instance type with high clock speeds.
        # *   Enhanced: enhanced instance type.
        # *   Shared: shared instance type.
        # *   Compute-optimized with GPU: GPU-accelerated compute-optimized instance type.
        # *   Visual Compute-optimized: visual compute-optimized instance type.
        # *   Heterogeneous Service: heterogeneous service instance type.
        # *   Compute-optimized with FPGA: FPGA-accelerated compute-optimized instance type.
        # *   Compute-optimized with NPU: NPU-accelerated compute-optimized instance type.
        # *   ECS Bare Metal: ECS Bare Metal Instance type.
        # *   High Performance Compute: HPC-optimized instance type.
        self.instance_categories = instance_categories
        # The level of the instance family. Valid values:
        # 
        # *   EntryLevel: entry level
        # *   EnterpriseLevel: enterprise level
        # *   CreditEntryLevel: credit-based entry level For more information, see [Burstable instance families](https://help.aliyun.com/document_detail/59977.html).
        self.instance_family_level = instance_family_level
        # The instance families that you want to query. You can query 1 to 10 instance families in each call.
        self.instance_type_families = instance_type_families
        # The maximum hourly price for pay-as-you-go or preemptible instances.
        self.max_price = max_price
        # The maximum number of vCPUs per instance type.
        self.maximum_cpu_core_count = maximum_cpu_core_count
        # The maximum number of GPUs per instance. The value must be a positive integer.
        self.maximum_gpu_amount = maximum_gpu_amount
        # The maximum memory size per instance. Unit: GiB.
        self.maximum_memory_size = maximum_memory_size
        # The memory size that you want to assign to the instance type. Unit: GiB.
        self.memory = memory
        # The memory size that you want to assign to the instance type. Unit: GiB. You can specify multiple memory sizes.
        self.memory_list = memory_list
        # The baseline vCPU computing performance (overall baseline performance of all vCPUs) per t5 or t6 burstable instance.
        self.minimum_baseline_credit = minimum_baseline_credit
        # The minimum number of vCPUs per instance type.
        self.minimum_cpu_core_count = minimum_cpu_core_count
        # The minimum number of IPv6 addresses per ENI.
        self.minimum_eni_ipv_6address_quantity = minimum_eni_ipv_6address_quantity
        # The minimum number of IPv4 addresses per ENI.
        self.minimum_eni_private_ip_address_quantity = minimum_eni_private_ip_address_quantity
        # The minimum number of elastic network interfaces (ENIs) per instance.
        self.minimum_eni_quantity = minimum_eni_quantity
        # The minimum number of GPUs per instance. The value must be a positive integer.
        self.minimum_gpu_amount = minimum_gpu_amount
        # The initial vCPU credits per t5 or t6 burstable instance.
        self.minimum_initial_credit = minimum_initial_credit
        # The minimum memory size per instance. Unit: GiB.
        self.minimum_memory_size = minimum_memory_size
        # The processor models of the instance types. You can specify 1 to 10 processor models.
        self.physical_processor_models = physical_processor_models
        # The region ID.
        # 
        # This parameter is required.
        self.region_id = region_id
        # The preemption policy that you want to apply to pay-as-you-go instances. Valid values:
        # 
        # *   NoSpot: The instances are created as regular pay-as-you-go instances.
        # *   SpotWithPriceLimit: The instances are created as preemptible instances that have a user-defined maximum hourly price.
        # *   SpotAsPriceGo: The instances are created as preemptible instances for which the market price at the time of purchase is automatically used as the bidding price.
        # 
        # Default value: NoSpot.
        self.spot_strategy = spot_strategy
        # The IDs of the vSwitches.
        self.v_switch_id = v_switch_id
        # The zone IDs. If you pass vSwitch IDs to the system, this parameter does not take effect.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.burstable_performance is not None:
            result['BurstablePerformance'] = self.burstable_performance
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.cores_list is not None:
            result['CoresList'] = self.cores_list
        if self.cpu_architectures is not None:
            result['CpuArchitectures'] = self.cpu_architectures
        if self.excluded_instance_type is not None:
            result['ExcludedInstanceType'] = self.excluded_instance_type
        if self.gpu_specs is not None:
            result['GpuSpecs'] = self.gpu_specs
        if self.instance_categories is not None:
            result['InstanceCategories'] = self.instance_categories
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_type_families is not None:
            result['InstanceTypeFamilies'] = self.instance_type_families
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.maximum_cpu_core_count is not None:
            result['MaximumCpuCoreCount'] = self.maximum_cpu_core_count
        if self.maximum_gpu_amount is not None:
            result['MaximumGpuAmount'] = self.maximum_gpu_amount
        if self.maximum_memory_size is not None:
            result['MaximumMemorySize'] = self.maximum_memory_size
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.memory_list is not None:
            result['MemoryList'] = self.memory_list
        if self.minimum_baseline_credit is not None:
            result['MinimumBaselineCredit'] = self.minimum_baseline_credit
        if self.minimum_cpu_core_count is not None:
            result['MinimumCpuCoreCount'] = self.minimum_cpu_core_count
        if self.minimum_eni_ipv_6address_quantity is not None:
            result['MinimumEniIpv6AddressQuantity'] = self.minimum_eni_ipv_6address_quantity
        if self.minimum_eni_private_ip_address_quantity is not None:
            result['MinimumEniPrivateIpAddressQuantity'] = self.minimum_eni_private_ip_address_quantity
        if self.minimum_eni_quantity is not None:
            result['MinimumEniQuantity'] = self.minimum_eni_quantity
        if self.minimum_gpu_amount is not None:
            result['MinimumGpuAmount'] = self.minimum_gpu_amount
        if self.minimum_initial_credit is not None:
            result['MinimumInitialCredit'] = self.minimum_initial_credit
        if self.minimum_memory_size is not None:
            result['MinimumMemorySize'] = self.minimum_memory_size
        if self.physical_processor_models is not None:
            result['PhysicalProcessorModels'] = self.physical_processor_models
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('BurstablePerformance') is not None:
            self.burstable_performance = m.get('BurstablePerformance')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('CoresList') is not None:
            self.cores_list = m.get('CoresList')
        if m.get('CpuArchitectures') is not None:
            self.cpu_architectures = m.get('CpuArchitectures')
        if m.get('ExcludedInstanceType') is not None:
            self.excluded_instance_type = m.get('ExcludedInstanceType')
        if m.get('GpuSpecs') is not None:
            self.gpu_specs = m.get('GpuSpecs')
        if m.get('InstanceCategories') is not None:
            self.instance_categories = m.get('InstanceCategories')
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceTypeFamilies') is not None:
            self.instance_type_families = m.get('InstanceTypeFamilies')
        if m.get('MaxPrice') is not None:
            self.max_price = m.get('MaxPrice')
        if m.get('MaximumCpuCoreCount') is not None:
            self.maximum_cpu_core_count = m.get('MaximumCpuCoreCount')
        if m.get('MaximumGpuAmount') is not None:
            self.maximum_gpu_amount = m.get('MaximumGpuAmount')
        if m.get('MaximumMemorySize') is not None:
            self.maximum_memory_size = m.get('MaximumMemorySize')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MemoryList') is not None:
            self.memory_list = m.get('MemoryList')
        if m.get('MinimumBaselineCredit') is not None:
            self.minimum_baseline_credit = m.get('MinimumBaselineCredit')
        if m.get('MinimumCpuCoreCount') is not None:
            self.minimum_cpu_core_count = m.get('MinimumCpuCoreCount')
        if m.get('MinimumEniIpv6AddressQuantity') is not None:
            self.minimum_eni_ipv_6address_quantity = m.get('MinimumEniIpv6AddressQuantity')
        if m.get('MinimumEniPrivateIpAddressQuantity') is not None:
            self.minimum_eni_private_ip_address_quantity = m.get('MinimumEniPrivateIpAddressQuantity')
        if m.get('MinimumEniQuantity') is not None:
            self.minimum_eni_quantity = m.get('MinimumEniQuantity')
        if m.get('MinimumGpuAmount') is not None:
            self.minimum_gpu_amount = m.get('MinimumGpuAmount')
        if m.get('MinimumInitialCredit') is not None:
            self.minimum_initial_credit = m.get('MinimumInitialCredit')
        if m.get('MinimumMemorySize') is not None:
            self.minimum_memory_size = m.get('MinimumMemorySize')
        if m.get('PhysicalProcessorModels') is not None:
            self.physical_processor_models = m.get('PhysicalProcessorModels')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribePatternTypesResponseBodyPatternTypes(TeaModel):
    def __init__(
        self,
        cores: int = None,
        instance_family_level: str = None,
        instance_type: str = None,
        instance_type_family: str = None,
        memory: float = None,
    ):
        # The number of vCPUs that are assigned to the instance type.
        self.cores = cores
        # The level of the instance family.
        # 
        # *   EntryLevel: entry level (shared instance types) Instance types of this level are the most cost-effective but may not provide stable computing performance. Instance types of this level are suitable for business scenarios in which the CPU utilization is low. For more information, see [Shared instance families](https://help.aliyun.com/document_detail/108489.html).
        # *   EnterpriseLevel: enterprise level. Instance types of this level provide stable performance and dedicated resources and are suitable for scenarios that require high stability. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        # *   CreditEntryLevel: credit-based entry level (burstable instance types). CPU credits are used to ensure computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low but may fluctuate in specific cases. For more information, see [Overview of burstable instances](https://help.aliyun.com/document_detail/59977.html).
        self.instance_family_level = instance_family_level
        # The name of the instance type.
        self.instance_type = instance_type
        # The instance family.
        self.instance_type_family = instance_type_family
        # The memory size that are assigned to the instance type. Unit: GiB.
        self.memory = memory

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_type_family is not None:
            result['InstanceTypeFamily'] = self.instance_type_family
        if self.memory is not None:
            result['Memory'] = self.memory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceTypeFamily') is not None:
            self.instance_type_family = m.get('InstanceTypeFamily')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        return self


class DescribePatternTypesResponseBody(TeaModel):
    def __init__(
        self,
        pattern_types: List[DescribePatternTypesResponseBodyPatternTypes] = None,
        request_id: str = None,
    ):
        # The instance types that meet the specified requirements.
        self.pattern_types = pattern_types
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.pattern_types:
            for k in self.pattern_types:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PatternTypes'] = []
        if self.pattern_types is not None:
            for k in self.pattern_types:
                result['PatternTypes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.pattern_types = []
        if m.get('PatternTypes') is not None:
            for k in m.get('PatternTypes'):
                temp_model = DescribePatternTypesResponseBodyPatternTypes()
                self.pattern_types.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePatternTypesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePatternTypesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePatternTypesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionsRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        # The language for the response. For more information, see [RFC7231](https://tools.ietf.org/html/rfc7231). Valid values:
        # 
        # *   zh-CN: Chinese
        # *   en-US: English
        # *   ja: Japanese
        # 
        # Default value: zh-CN.
        self.accept_language = accept_language
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        classic_unavailable: bool = None,
        local_name: str = None,
        region_endpoint: str = None,
        region_id: str = None,
        vpc_unavailable: bool = None,
    ):
        # Indicates whether the current region supports scaling groups that reside in the classic network. Valid values:
        # 
        # *   true
        # *   false
        self.classic_unavailable = classic_unavailable
        # The region name.
        self.local_name = local_name
        # The region endpoint.
        self.region_endpoint = region_endpoint
        # The region ID.
        self.region_id = region_id
        # Indicates whether the current region supports scaling groups that reside in virtual private clouds (VPCs). Valid values:
        # 
        # *   true
        # *   false
        self.vpc_unavailable = vpc_unavailable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.classic_unavailable is not None:
            result['ClassicUnavailable'] = self.classic_unavailable
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.region_endpoint is not None:
            result['RegionEndpoint'] = self.region_endpoint
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_unavailable is not None:
            result['VpcUnavailable'] = self.vpc_unavailable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClassicUnavailable') is not None:
            self.classic_unavailable = m.get('ClassicUnavailable')
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('RegionEndpoint') is not None:
            self.region_endpoint = m.get('RegionEndpoint')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcUnavailable') is not None:
            self.vpc_unavailable = m.get('VpcUnavailable')
        return self


class DescribeRegionsResponseBody(TeaModel):
    def __init__(
        self,
        regions: List[DescribeRegionsResponseBodyRegions] = None,
        request_id: str = None,
    ):
        # The collection of region information.
        self.regions = regions
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.regions:
            for k in self.regions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Regions'] = []
        if self.regions is not None:
            for k in self.regions:
                result['Regions'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.regions = []
        if m.get('Regions') is not None:
            for k in m.get('Regions'):
                temp_model = DescribeRegionsResponseBodyRegions()
                self.regions.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRegionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingActivitiesRequest(TeaModel):
    def __init__(
        self,
        instance_refresh_task_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        scaling_activity_ids: List[str] = None,
        scaling_group_id: str = None,
        status_code: str = None,
    ):
        # The ID of the instance refresh task. If you specify this parameter, this operation returns the list of scaling activities associated with the instance refresh task.
        self.instance_refresh_task_id = instance_refresh_task_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The page number. Pages start from page 1.
        # 
        # Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Maximum value: 50.
        # 
        # Default value: 10.
        self.page_size = page_size
        # The region ID of the scaling group to which the scaling activity that you want to query belongs.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        # The IDs of the scaling activities that you want to query.
        # 
        # >  When you call this operation, you must specify one of the following parameters: `ScalingGroupId` and `ScalingActivityIds`. You cannot specify both of them at the same time. If you specify neither of them, an error is reported.
        self.scaling_activity_ids = scaling_activity_ids
        # The ID of the scaling group.
        # 
        # >  When you call this operation, you must specify one of the following parameters: `ScalingGroupId` and `ScalingActivityIds`. You cannot specify both of them at the same time. If you specify neither of them, an error is reported.
        self.scaling_group_id = scaling_group_id
        # The status of the scaling activity. Valid values:
        # 
        # *   Successful: The scaling activity is successful.
        # *   Warning: The scaling activity is partially successful.
        # *   Failed: The scaling activity failed.
        # *   InProgress: The scaling activity is in progress.
        # *   Rejected: The request to trigger the scaling activity is rejected.
        self.status_code = status_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_refresh_task_id is not None:
            result['InstanceRefreshTaskId'] = self.instance_refresh_task_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scaling_activity_ids is not None:
            result['ScalingActivityIds'] = self.scaling_activity_ids
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceRefreshTaskId') is not None:
            self.instance_refresh_task_id = m.get('InstanceRefreshTaskId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ScalingActivityIds') is not None:
            self.scaling_activity_ids = m.get('ScalingActivityIds')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        return self


class DescribeScalingActivitiesResponseBodyScalingActivitiesErrorMessages(TeaModel):
    def __init__(
        self,
        code: str = None,
        description: str = None,
        failed_instance_ids: List[str] = None,
        message: str = None,
    ):
        # The error code that is returned when the scaling activity failed.
        self.code = code
        # The description of the scaling activity exception.
        self.description = description
        # The IDs of the instances included in the failed scaling activities.
        self.failed_instance_ids = failed_instance_ids
        # The error message that is returned when the scaling activity failed or is partially successful.
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.description is not None:
            result['Description'] = self.description
        if self.failed_instance_ids is not None:
            result['FailedInstanceIds'] = self.failed_instance_ids
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FailedInstanceIds') is not None:
            self.failed_instance_ids = m.get('FailedInstanceIds')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DescribeScalingActivitiesResponseBodyScalingActivitiesLifecycleHookContext(TeaModel):
    def __init__(
        self,
        disable_lifecycle_hook: bool = None,
        ignored_lifecycle_hook_ids: List[str] = None,
    ):
        # Indicates whether all lifecycle hooks are disabled when the scaling activity is triggered. Valid values:
        # 
        # *   true
        # *   false
        self.disable_lifecycle_hook = disable_lifecycle_hook
        # The IDs of the lifecycle hooks that are disabled.
        self.ignored_lifecycle_hook_ids = ignored_lifecycle_hook_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disable_lifecycle_hook is not None:
            result['DisableLifecycleHook'] = self.disable_lifecycle_hook
        if self.ignored_lifecycle_hook_ids is not None:
            result['IgnoredLifecycleHookIds'] = self.ignored_lifecycle_hook_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisableLifecycleHook') is not None:
            self.disable_lifecycle_hook = m.get('DisableLifecycleHook')
        if m.get('IgnoredLifecycleHookIds') is not None:
            self.ignored_lifecycle_hook_ids = m.get('IgnoredLifecycleHookIds')
        return self


class DescribeScalingActivitiesResponseBodyScalingActivities(TeaModel):
    def __init__(
        self,
        activity_metadata: str = None,
        attached_capacity: str = None,
        auto_created_capacity: str = None,
        cause: str = None,
        created_capacity: int = None,
        created_instances: List[str] = None,
        description: str = None,
        destroyed_capacity: int = None,
        destroyed_instances: List[str] = None,
        detail: str = None,
        end_time: str = None,
        error_code: str = None,
        error_message: str = None,
        error_messages: List[DescribeScalingActivitiesResponseBodyScalingActivitiesErrorMessages] = None,
        instance_refresh_task_id: str = None,
        lifecycle_hook_context: DescribeScalingActivitiesResponseBodyScalingActivitiesLifecycleHookContext = None,
        progress: int = None,
        scaling_activity_id: str = None,
        scaling_group_id: str = None,
        scaling_instance_number: int = None,
        start_time: str = None,
        started_capacity: int = None,
        started_instances: List[str] = None,
        status_code: str = None,
        status_message: str = None,
        stopped_capacity: int = None,
        stopped_instances: List[str] = None,
        total_capacity: str = None,
        trigger_source_id: str = None,
        trigger_source_type: str = None,
    ):
        # The metadata of the scaling activity.
        self.activity_metadata = activity_metadata
        # The total number of instances that are manually added to the scaling group after the scaling activity is complete.
        self.attached_capacity = attached_capacity
        # The total number of instances that are created by Auto Scaling after the scaling activity was complete.
        self.auto_created_capacity = auto_created_capacity
        # The reason why the scaling activity was triggered.
        self.cause = cause
        # The number of instances that are created during the scale-out event.
        self.created_capacity = created_capacity
        # The instances that are created during the scale-out event.
        self.created_instances = created_instances
        # The description of the scaling activity.
        self.description = description
        # The number of instances that are released during the scale-in event.
        self.destroyed_capacity = destroyed_capacity
        # The instances that are released during the scale-in event.
        self.destroyed_instances = destroyed_instances
        # Details of the scaling activity.
        self.detail = detail
        # The time when the scaling activity was complete.
        self.end_time = end_time
        # The error code that is returned when the scaling activity failed.
        self.error_code = error_code
        # The error message that is returned when the scaling activity failed.
        self.error_message = error_message
        # The error messages that are returned when the scaling activities failed or are partially successful.
        self.error_messages = error_messages
        # The ID of the instance refresh task.
        self.instance_refresh_task_id = instance_refresh_task_id
        # The context of the lifecycle hook.
        self.lifecycle_hook_context = lifecycle_hook_context
        # The execution progress of the scaling activity.
        self.progress = progress
        # The ID of the scaling activity.
        self.scaling_activity_id = scaling_activity_id
        # The ID of the scaling group.
        self.scaling_group_id = scaling_group_id
        # *   If you query a scale-out activity, the value of this parameter indicates the number of instances that are created or the number of instances that are started from Economical Mode.
        # *   If you query a scale-in activity, the value of this parameter indicates the number of instances that are deleted or the number of instances that are stopped in Economical Mode.
        self.scaling_instance_number = scaling_instance_number
        # The time when the scaling activity was started.
        self.start_time = start_time
        # The number of instances that are started from the Economical Mode during the scale-out event.
        self.started_capacity = started_capacity
        # The instances that are started from the Economical Mode during the scale-out event.
        self.started_instances = started_instances
        # The status of the scaling activity. Valid values:
        # 
        # *   Successful: The scaling activity is successful.
        # *   Warning: The scaling activity is partially successful.
        # *   Failed: The scaling activity failed.
        # *   InProgress: The scaling activity is in progress.
        # *   Rejected: The request to trigger the scaling activity is rejected.
        self.status_code = status_code
        # The status message of the scaling activity.
        self.status_message = status_message
        # The number of instances that are stopped in the Economical Mode during the scale-in event.
        self.stopped_capacity = stopped_capacity
        # The instances that are stopped in the Economical Mode during the scale-in event.
        self.stopped_instances = stopped_instances
        # The total number of instances in the scaling group after the scaling activity was complete.
        self.total_capacity = total_capacity
        # The ID of the trigger source of the scaling activity. Valid values:
        # 
        # *   If the scaling activity is triggered by an event-triggered task, the ID of the trigger source is the ID of the event-triggered task.
        # *   If the scaling activity is triggered by calling an API operation, the ID of the trigger source is the ID of the Alibaba Cloud account or Resource Access Management (RAM) user that you use to call the API operation.
        # *   If the scaling activity is triggered by Auto Scaling, the ID of the trigger source is null.
        self.trigger_source_id = trigger_source_id
        # The type of the trigger source of the scaling activity. Valid values:
        # 
        # *   Cms: The scaling activity is triggered by an event-triggered task.
        # *   APIs: The scaling activity is triggered by calling an API operation.
        # *   Ess: The scaling activity is triggered by Auto Scaling.
        self.trigger_source_type = trigger_source_type

    def validate(self):
        if self.error_messages:
            for k in self.error_messages:
                if k:
                    k.validate()
        if self.lifecycle_hook_context:
            self.lifecycle_hook_context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_metadata is not None:
            result['ActivityMetadata'] = self.activity_metadata
        if self.attached_capacity is not None:
            result['AttachedCapacity'] = self.attached_capacity
        if self.auto_created_capacity is not None:
            result['AutoCreatedCapacity'] = self.auto_created_capacity
        if self.cause is not None:
            result['Cause'] = self.cause
        if self.created_capacity is not None:
            result['CreatedCapacity'] = self.created_capacity
        if self.created_instances is not None:
            result['CreatedInstances'] = self.created_instances
        if self.description is not None:
            result['Description'] = self.description
        if self.destroyed_capacity is not None:
            result['DestroyedCapacity'] = self.destroyed_capacity
        if self.destroyed_instances is not None:
            result['DestroyedInstances'] = self.destroyed_instances
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['ErrorMessages'] = []
        if self.error_messages is not None:
            for k in self.error_messages:
                result['ErrorMessages'].append(k.to_map() if k else None)
        if self.instance_refresh_task_id is not None:
            result['InstanceRefreshTaskId'] = self.instance_refresh_task_id
        if self.lifecycle_hook_context is not None:
            result['LifecycleHookContext'] = self.lifecycle_hook_context.to_map()
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.scaling_activity_id is not None:
            result['ScalingActivityId'] = self.scaling_activity_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.scaling_instance_number is not None:
            result['ScalingInstanceNumber'] = self.scaling_instance_number
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.started_capacity is not None:
            result['StartedCapacity'] = self.started_capacity
        if self.started_instances is not None:
            result['StartedInstances'] = self.started_instances
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        if self.status_message is not None:
            result['StatusMessage'] = self.status_message
        if self.stopped_capacity is not None:
            result['StoppedCapacity'] = self.stopped_capacity
        if self.stopped_instances is not None:
            result['StoppedInstances'] = self.stopped_instances
        if self.total_capacity is not None:
            result['TotalCapacity'] = self.total_capacity
        if self.trigger_source_id is not None:
            result['TriggerSourceId'] = self.trigger_source_id
        if self.trigger_source_type is not None:
            result['TriggerSourceType'] = self.trigger_source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActivityMetadata') is not None:
            self.activity_metadata = m.get('ActivityMetadata')
        if m.get('AttachedCapacity') is not None:
            self.attached_capacity = m.get('AttachedCapacity')
        if m.get('AutoCreatedCapacity') is not None:
            self.auto_created_capacity = m.get('AutoCreatedCapacity')
        if m.get('Cause') is not None:
            self.cause = m.get('Cause')
        if m.get('CreatedCapacity') is not None:
            self.created_capacity = m.get('CreatedCapacity')
        if m.get('CreatedInstances') is not None:
            self.created_instances = m.get('CreatedInstances')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestroyedCapacity') is not None:
            self.destroyed_capacity = m.get('DestroyedCapacity')
        if m.get('DestroyedInstances') is not None:
            self.destroyed_instances = m.get('DestroyedInstances')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.error_messages = []
        if m.get('ErrorMessages') is not None:
            for k in m.get('ErrorMessages'):
                temp_model = DescribeScalingActivitiesResponseBodyScalingActivitiesErrorMessages()
                self.error_messages.append(temp_model.from_map(k))
        if m.get('InstanceRefreshTaskId') is not None:
            self.instance_refresh_task_id = m.get('InstanceRefreshTaskId')
        if m.get('LifecycleHookContext') is not None:
            temp_model = DescribeScalingActivitiesResponseBodyScalingActivitiesLifecycleHookContext()
            self.lifecycle_hook_context = temp_model.from_map(m['LifecycleHookContext'])
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ScalingActivityId') is not None:
            self.scaling_activity_id = m.get('ScalingActivityId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('ScalingInstanceNumber') is not None:
            self.scaling_instance_number = m.get('ScalingInstanceNumber')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StartedCapacity') is not None:
            self.started_capacity = m.get('StartedCapacity')
        if m.get('StartedInstances') is not None:
            self.started_instances = m.get('StartedInstances')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        if m.get('StatusMessage') is not None:
            self.status_message = m.get('StatusMessage')
        if m.get('StoppedCapacity') is not None:
            self.stopped_capacity = m.get('StoppedCapacity')
        if m.get('StoppedInstances') is not None:
            self.stopped_instances = m.get('StoppedInstances')
        if m.get('TotalCapacity') is not None:
            self.total_capacity = m.get('TotalCapacity')
        if m.get('TriggerSourceId') is not None:
            self.trigger_source_id = m.get('TriggerSourceId')
        if m.get('TriggerSourceType') is not None:
            self.trigger_source_type = m.get('TriggerSourceType')
        return self


class DescribeScalingActivitiesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        scaling_activities: List[DescribeScalingActivitiesResponseBodyScalingActivities] = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The scaling activities.
        self.scaling_activities = scaling_activities
        # The total number of scaling activities.
        self.total_count = total_count

    def validate(self):
        if self.scaling_activities:
            for k in self.scaling_activities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ScalingActivities'] = []
        if self.scaling_activities is not None:
            for k in self.scaling_activities:
                result['ScalingActivities'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.scaling_activities = []
        if m.get('ScalingActivities') is not None:
            for k in m.get('ScalingActivities'):
                temp_model = DescribeScalingActivitiesResponseBodyScalingActivities()
                self.scaling_activities.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeScalingActivitiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeScalingActivitiesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeScalingActivitiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingActivityDetailRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        scaling_activity_id: str = None,
    ):
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        # The ID of the scaling activity that you want to query. You can call the DescribeScalingActivities operation to query the IDs of scaling activities.
        # 
        # This parameter is required.
        self.scaling_activity_id = scaling_activity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scaling_activity_id is not None:
            result['ScalingActivityId'] = self.scaling_activity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ScalingActivityId') is not None:
            self.scaling_activity_id = m.get('ScalingActivityId')
        return self


class DescribeScalingActivityDetailResponseBody(TeaModel):
    def __init__(
        self,
        detail: str = None,
        request_id: str = None,
        scaling_activity_id: str = None,
    ):
        # The details of the scaling activity. The result of a scaling activity is either successful or failed. If the scaling activity is rejected, no scaling activity details are returned.
        self.detail = detail
        # The ID of the request.
        self.request_id = request_id
        # The ID of the scaling activity.
        self.scaling_activity_id = scaling_activity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_activity_id is not None:
            result['ScalingActivityId'] = self.scaling_activity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingActivityId') is not None:
            self.scaling_activity_id = m.get('ScalingActivityId')
        return self


class DescribeScalingActivityDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeScalingActivityDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeScalingActivityDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingConfigurationsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        scaling_configuration_ids: List[str] = None,
        scaling_configuration_names: List[str] = None,
        scaling_group_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        # The page number. Pages start from page 1.
        # 
        # Default value: 1.
        self.page_number = page_number
        # The number of entries per page. Maximum value: 50.
        # 
        # Default value: 10.
        self.page_size = page_size
        # The region ID of the scaling group to which the scaling configuration that you want to query belongs.
        # 
        # This parameter is required.
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        # The IDs of the scaling configurations that you want to query.
        # 
        # The IDs of active and inactive scaling configurations are displayed in the query results. You can differentiate between active and inactive scaling configurations based on the value of the `LifecycleState` parameter.
        self.scaling_configuration_ids = scaling_configuration_ids
        # The names of the scaling configurations that you want to query.
        # 
        # The names of inactive scaling configurations are not displayed in the query results, and no error is reported.
        self.scaling_configuration_names = scaling_configuration_names
        # The ID of the scaling group. You can use the ID to query all scaling configurations in the scaling group.
        self.scaling_group_id = scaling_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.scaling_configuration_ids is not None:
            result['ScalingConfigurationIds'] = self.scaling_configuration_ids
        if self.scaling_configuration_names is not None:
            result['ScalingConfigurationNames'] = self.scaling_configuration_names
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ScalingConfigurationIds') is not None:
            self.scaling_configuration_ids = m.get('ScalingConfigurationIds')
        if m.get('ScalingConfigurationNames') is not None:
            self.scaling_configuration_names = m.get('ScalingConfigurationNames')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurationsCustomPriorities(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        vswitch_id: str = None,
    ):
        # The ECS instance type.
        self.instance_type = instance_type
        # The vSwitch ID.
        self.vswitch_id = vswitch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurationsDataDisks(TeaModel):
    def __init__(
        self,
        auto_snapshot_policy_id: str = None,
        bursting_enabled: bool = None,
        categories: List[str] = None,
        category: str = None,
        delete_with_instance: bool = None,
        description: str = None,
        device: str = None,
        disk_name: str = None,
        encrypted: str = None,
        kmskey_id: str = None,
        performance_level: str = None,
        provisioned_iops: int = None,
        size: int = None,
        snapshot_id: str = None,
    ):
        # The ID of the automatic snapshot policy that is applied to the data disk.
        self.auto_snapshot_policy_id = auto_snapshot_policy_id
        # Indicates whether the Performance Burst feature is enabled for the data disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # >  This parameter is available only when you set `DataDisk.Category` to `cloud_auto`.
        self.bursting_enabled = bursting_enabled
        # The categories of the data disks. The values are sorted based on their priorities. The first value has the highest priority. If Auto Scaling cannot create instances by using the disk category of the highest priority, Auto Scaling creates instances by using the disk category of the next highest priority. Valid values:
        # 
        # *   cloud: basic disk. DeleteWithInstance of a basic disk created along with the ECS instance is set to true.
        # *   cloud_efficiency: ultra disk.
        # *   cloud_ssd: standard SSD.
        # *   cloud_essd: ESSD.
        self.categories = categories
        # The category of the data disk. Valid values:
        # 
        # *   cloud: basic disk. DeleteWithInstance of a basic disk created along with the ECS instance is set to true.
        # *   cloud_efficiency: ultra disk.
        # *   cloud_ssd: standard SSD.
        # *   ephemeral_ssd: local SSD.
        # *   cloud_essd: ESSD.
        # *   cloud_auto: ESSD AutoPL.
        self.category = category
        # Indicates whether the data disk is released when the instance to which the data disk is attached is released. Valid values:
        # 
        # *   true
        # *   false
        self.delete_with_instance = delete_with_instance
        # The description of the data disk.
        self.description = description
        # The mount target of the data disk.
        self.device = device
        # The name of the data disk.
        self.disk_name = disk_name
        # Indicates whether the data disk is encrypted. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        self.encrypted = encrypted
        # The ID of the Key Management Service (KMS) key that is applied to the data disk.
        self.kmskey_id = kmskey_id
        # The PL of the data disk that is an ESSD.
        self.performance_level = performance_level
        # The provisioned IOPS of the data disk.
        # 
        # >  IOPS measures the number of read and write operations that an Elastic Block Storage (EBS) device can process per second.
        self.provisioned_iops = provisioned_iops
        # The size of the data disk. Unit: GB. Valid values:
        # 
        # *   5 to 2000 if you set Category to cloud.
        # *   20 to 32768 if you set Category to cloud_efficiency.
        # *   20 to 32768 if you set Category to cloud_ssd.
        # *   20 to 32768 if you set Category to cloud_essd.
        # *   5 to 800 if you set Category to ephemeral_ssd.
        self.size = size
        # The ID of the snapshot based on which the data disk is created.
        self.snapshot_id = snapshot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.categories is not None:
            result['Categories'] = self.categories
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Categories') is not None:
            self.categories = m.get('Categories')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurationsInstancePatternInfos(TeaModel):
    def __init__(
        self,
        architectures: List[str] = None,
        burstable_performance: str = None,
        cores: int = None,
        cpu_architectures: List[str] = None,
        excluded_instance_types: List[str] = None,
        gpu_specs: List[str] = None,
        instance_categories: List[str] = None,
        instance_family_level: str = None,
        instance_type_families: List[str] = None,
        max_price: float = None,
        maximum_cpu_core_count: int = None,
        maximum_gpu_amount: int = None,
        maximum_memory_size: float = None,
        memory: float = None,
        minimum_baseline_credit: int = None,
        minimum_cpu_core_count: int = None,
        minimum_eni_ipv_6address_quantity: int = None,
        minimum_eni_private_ip_address_quantity: int = None,
        minimum_eni_quantity: int = None,
        minimum_gpu_amount: int = None,
        minimum_initial_credit: int = None,
        minimum_memory_size: float = None,
        physical_processor_models: List[str] = None,
    ):
        # The architectures of instance types. Valid values:
        # 
        # *   X86: x86.
        # *   Heterogeneous: heterogeneous computing, such as GPU-accelerated or FPGA-accelerated.
        # *   BareMetal: ECS Bare Metal Instance.
        # *   Arm: Arm.
        self.architectures = architectures
        # Indicates whether burstable instance types are included. Valid values:
        # 
        # *   Exclude: Burstable instance types are not included.
        # *   Include: Burstable instance types are included.
        # *   Required: Only burstable instance types are included.
        self.burstable_performance = burstable_performance
        # The number of vCPUs of the instance type.
        self.cores = cores
        # The CPU architectures of the instance types. Valid values:
        # 
        # >  You can specify 1 to 2 CPU architectures.
        # 
        # *   x86
        # *   Arm
        self.cpu_architectures = cpu_architectures
        # The instance types that are excluded. You can use wildcard characters, such as an asterisk (\\*), to exclude an instance type or an instance family. Examples:
        # 
        # *   ecs.c6.large: The ecs.c6.large instance type is excluded.
        # *   ecs.c6.\\*: The c6 instance family is excluded.
        self.excluded_instance_types = excluded_instance_types
        # The GPU models.
        self.gpu_specs = gpu_specs
        # The categories of ECS instances. Valid values:
        # 
        # >  Up to 10 categories of ECS instances are supported.
        # 
        # *   General-purpose: general-purpose instance type.
        # *   Compute-optimized: compute-optimized instance type.
        # *   Memory-optimized: memory-optimized instance type.
        # *   Big data: big data instance type.
        # *   Local SSDs: instance type with local SSDs.
        # *   High Clock Speed: instance type with high clock speeds.
        # *   Enhanced: enhanced instance type.
        # *   Shared: shared instance type.
        # *   Compute-optimized with GPU: GPU-accelerated compute-optimized instance type.
        # *   Visual Compute-optimized: visual compute-optimized instance type.
        # *   Heterogeneous Service: heterogeneous service instance type.
        # *   Compute-optimized with FPGA: FPGA-accelerated compute-optimized instance type.
        # *   Compute-optimized with NPU: NPU-accelerated compute-optimized instance type.
        # *   ECS Bare Metal: ECS Bare Metal Instance type.
        # *   High Performance Compute: HPC-optimized instance type.
        self.instance_categories = instance_categories
        # The level of the instance family.
        # 
        # *   EntryLevel: entry level (shared instance types). Instance types of this level are the most cost-effective but may not provide stable computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low. For more information, see [Shared instance families](https://help.aliyun.com/document_detail/108489.html).
        # *   EnterpriseLevel: enterprise level. Instance types of this level provide stable performance and dedicated resources, and are suitable for scenarios that require high stability. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        # *   CreditEntryLevel: credit entry level (burstable instance types). CPU credits are used to ensure computing performance. Instance types of this level are suitable for scenarios in which the CPU utilization is low but may fluctuate in specific cases. For more information, see [Overview of burstable instances](https://help.aliyun.com/document_detail/59977.html).
        self.instance_family_level = instance_family_level
        # The instance families that are queried. You can query 1 to 10 instance families in each call.
        self.instance_type_families = instance_type_families
        # The maximum hourly price for the pay-as-you-go or preemptible instances.
        self.max_price = max_price
        # The maximum number of vCPUs per instance type.
        # 
        # >  The value of MaximumCpuCoreCount cannot exceed four times the value of MinimumCpuCoreCount.
        self.maximum_cpu_core_count = maximum_cpu_core_count
        # The maximum number of GPUs per instance. The value must be a positive integer.
        self.maximum_gpu_amount = maximum_gpu_amount
        # The maximum memory size per instance. Unit: GiB.
        self.maximum_memory_size = maximum_memory_size
        # The memory size of the instance type. Unit: GiB.
        self.memory = memory
        # The baseline vCPU computing performance (overall baseline performance of all vCPUs) per t5 or t6 burstable instance.
        self.minimum_baseline_credit = minimum_baseline_credit
        # The minimum number of vCPUs per instance type.
        self.minimum_cpu_core_count = minimum_cpu_core_count
        # The minimum number of IPv6 addresses per ENI.
        self.minimum_eni_ipv_6address_quantity = minimum_eni_ipv_6address_quantity
        # The minimum number of IPv4 addresses per ENI.
        self.minimum_eni_private_ip_address_quantity = minimum_eni_private_ip_address_quantity
        # The minimum number of elastic network interfaces (ENIs) per instance.
        self.minimum_eni_quantity = minimum_eni_quantity
        # The minimum number of GPUs per instance. The value must be a positive integer.
        self.minimum_gpu_amount = minimum_gpu_amount
        # The initial vCPU credits per t5 or t6 burstable instance.
        self.minimum_initial_credit = minimum_initial_credit
        # The minimum memory size per instance. Unit: GiB.
        self.minimum_memory_size = minimum_memory_size
        # The processor models of the instance types. You can specify 1 to 10 processor models.
        self.physical_processor_models = physical_processor_models

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architectures is not None:
            result['Architectures'] = self.architectures
        if self.burstable_performance is not None:
            result['BurstablePerformance'] = self.burstable_performance
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.cpu_architectures is not None:
            result['CpuArchitectures'] = self.cpu_architectures
        if self.excluded_instance_types is not None:
            result['ExcludedInstanceTypes'] = self.excluded_instance_types
        if self.gpu_specs is not None:
            result['GpuSpecs'] = self.gpu_specs
        if self.instance_categories is not None:
            result['InstanceCategories'] = self.instance_categories
        if self.instance_family_level is not None:
            result['InstanceFamilyLevel'] = self.instance_family_level
        if self.instance_type_families is not None:
            result['InstanceTypeFamilies'] = self.instance_type_families
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.maximum_cpu_core_count is not None:
            result['MaximumCpuCoreCount'] = self.maximum_cpu_core_count
        if self.maximum_gpu_amount is not None:
            result['MaximumGpuAmount'] = self.maximum_gpu_amount
        if self.maximum_memory_size is not None:
            result['MaximumMemorySize'] = self.maximum_memory_size
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.minimum_baseline_credit is not None:
            result['MinimumBaselineCredit'] = self.minimum_baseline_credit
        if self.minimum_cpu_core_count is not None:
            result['MinimumCpuCoreCount'] = self.minimum_cpu_core_count
        if self.minimum_eni_ipv_6address_quantity is not None:
            result['MinimumEniIpv6AddressQuantity'] = self.minimum_eni_ipv_6address_quantity
        if self.minimum_eni_private_ip_address_quantity is not None:
            result['MinimumEniPrivateIpAddressQuantity'] = self.minimum_eni_private_ip_address_quantity
        if self.minimum_eni_quantity is not None:
            result['MinimumEniQuantity'] = self.minimum_eni_quantity
        if self.minimum_gpu_amount is not None:
            result['MinimumGpuAmount'] = self.minimum_gpu_amount
        if self.minimum_initial_credit is not None:
            result['MinimumInitialCredit'] = self.minimum_initial_credit
        if self.minimum_memory_size is not None:
            result['MinimumMemorySize'] = self.minimum_memory_size
        if self.physical_processor_models is not None:
            result['PhysicalProcessorModels'] = self.physical_processor_models
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Architectures') is not None:
            self.architectures = m.get('Architectures')
        if m.get('BurstablePerformance') is not None:
            self.burstable_performance = m.get('BurstablePerformance')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('CpuArchitectures') is not None:
            self.cpu_architectures = m.get('CpuArchitectures')
        if m.get('ExcludedInstanceTypes') is not None:
            self.excluded_instance_types = m.get('ExcludedInstanceTypes')
        if m.get('GpuSpecs') is not None:
            self.gpu_specs = m.get('GpuSpecs')
        if m.get('InstanceCategories') is not None:
            self.instance_categories = m.get('InstanceCategories')
        if m.get('InstanceFamilyLevel') is not None:
            self.instance_family_level = m.get('InstanceFamilyLevel')
        if m.get('InstanceTypeFamilies') is not None:
            self.instance_type_families = m.get('InstanceTypeFamilies')
        if m.get('MaxPrice') is not None:
            self.max_price = m.get('MaxPrice')
        if m.get('MaximumCpuCoreCount') is not None:
            self.maximum_cpu_core_count = m.get('MaximumCpuCoreCount')
        if m.get('MaximumGpuAmount') is not None:
            self.maximum_gpu_amount = m.get('MaximumGpuAmount')
        if m.get('MaximumMemorySize') is not None:
            self.maximum_memory_size = m.get('MaximumMemorySize')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MinimumBaselineCredit') is not None:
            self.minimum_baseline_credit = m.get('MinimumBaselineCredit')
        if m.get('MinimumCpuCoreCount') is not None:
            self.minimum_cpu_core_count = m.get('MinimumCpuCoreCount')
        if m.get('MinimumEniIpv6AddressQuantity') is not None:
            self.minimum_eni_ipv_6address_quantity = m.get('MinimumEniIpv6AddressQuantity')
        if m.get('MinimumEniPrivateIpAddressQuantity') is not None:
            self.minimum_eni_private_ip_address_quantity = m.get('MinimumEniPrivateIpAddressQuantity')
        if m.get('MinimumEniQuantity') is not None:
            self.minimum_eni_quantity = m.get('MinimumEniQuantity')
        if m.get('MinimumGpuAmount') is not None:
            self.minimum_gpu_amount = m.get('MinimumGpuAmount')
        if m.get('MinimumInitialCredit') is not None:
            self.minimum_initial_credit = m.get('MinimumInitialCredit')
        if m.get('MinimumMemorySize') is not None:
            self.minimum_memory_size = m.get('MinimumMemorySize')
        if m.get('PhysicalProcessorModels') is not None:
            self.physical_processor_models = m.get('PhysicalProcessorModels')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurationsNetworkInterfaces(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        ipv_6address_count: int = None,
        network_interface_traffic_mode: str = None,
        security_group_ids: List[str] = None,
    ):
        # The ENI type. Valid values:
        # 
        # *   Primary: the primary ENI
        # *   Secondary: the secondary ENI
        self.instance_type = instance_type
        # The number of randomly generated IPv6 addresses that are allocated to the primary ENI.
        self.ipv_6address_count = ipv_6address_count
        # The communication mode of the ENI. Valid values:
        # 
        # *   Standard: The TCP communication mode is used.
        # *   HighPerformance: The Elastic RDMA Interface (ERI) is enabled and the remote direct memory access (RDMA) communication mode is used.
        self.network_interface_traffic_mode = network_interface_traffic_mode
        # The IDs of the security groups to which the ENIs belong.
        self.security_group_ids = security_group_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.network_interface_traffic_mode is not None:
            result['NetworkInterfaceTrafficMode'] = self.network_interface_traffic_mode
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('NetworkInterfaceTrafficMode') is not None:
            self.network_interface_traffic_mode = m.get('NetworkInterfaceTrafficMode')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurationsResourcePoolOptions(TeaModel):
    def __init__(
        self,
        private_pool_ids: List[str] = None,
        strategy: str = None,
    ):
        # The IDs of private pools. The ID of a private pool is the same as the ID of the elasticity assurance or capacity reservation that is associated with the private pool.
        self.private_pool_ids = private_pool_ids
        # The resource pool used for instance creation, which can be the public pool or a private pool associated with any active elasticity assurance or capacity reservation. Valid values:
        # 
        # *   PrivatePoolFirst: prioritizes private pools. When this option is set along with ResourcePoolOptions.PrivatePoolIds, the specified private pools are used first. If you leave ResourcePoolOptions.PrivatePoolIds empty or if the specified private pools lack sufficient capacity, the system will automatically use available open private pools instead. If no matching private pools are available, the system defaults to the public pool.
        # *   PrivatePoolOnly: uses only private pools. If you use this value, you must specify ResourcePoolOptions.PrivatePoolIds. If the specified private pools lack sufficient capacity, instance creation will fail.
        # *   None: uses no resource pools.
        self.strategy = strategy

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_ids is not None:
            result['PrivatePoolIds'] = self.private_pool_ids
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrivatePoolIds') is not None:
            self.private_pool_ids = m.get('PrivatePoolIds')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurationsSchedulerOptions(TeaModel):
    def __init__(
        self,
        managed_private_space_id: str = None,
    ):
        # >  This parameter is in invitational preview and is not available for use.
        self.managed_private_space_id = managed_private_space_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.managed_private_space_id is not None:
            result['ManagedPrivateSpaceId'] = self.managed_private_space_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ManagedPrivateSpaceId') is not None:
            self.managed_private_space_id = m.get('ManagedPrivateSpaceId')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurationsSecurityOptions(TeaModel):
    def __init__(
        self,
        confidential_computing_mode: str = None,
    ):
        self.confidential_computing_mode = confidential_computing_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.confidential_computing_mode is not None:
            result['ConfidentialComputingMode'] = self.confidential_computing_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfidentialComputingMode') is not None:
            self.confidential_computing_mode = m.get('ConfidentialComputingMode')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurationsSpotPriceLimits(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        price_limit: float = None,
    ):
        # The instance type of the preemptible instances.
        self.instance_type = instance_type
        # The price limit of the preemptible instances.
        self.price_limit = price_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.price_limit is not None:
            result['PriceLimit'] = self.price_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('PriceLimit') is not None:
            self.price_limit = m.get('PriceLimit')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurationsTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key of the ECS instance. You can specify up to 20 tags for each ECS instance.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 128 characters in length. It cannot start with `acs:` or `aliyun` and cannot contain `http://` or `https://`.
        self.key = key
        # The tag value of the ECS instance. You can specify up to 20 tags for each ECS instance.
        # 
        # The tag value can be an empty string. The tag value can be up to 128 characters in length. It cannot start with `acs:` and cannot contain `http://` or `https://`.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeScalingConfigurationsResponseBodyScalingConfigurations(TeaModel):
    def __init__(
        self,
        affinity: str = None,
        cpu: int = None,
        creation_time: str = None,
        credit_specification: str = None,
        custom_priorities: List[DescribeScalingConfigurationsResponseBodyScalingConfigurationsCustomPriorities] = None,
        data_disks: List[DescribeScalingConfigurationsResponseBodyScalingConfigurationsDataDisks] = None,
        dedicated_host_cluster_id: str = None,
        dedicated_host_id: str = None,
        deletion_protection: bool = None,
        deployment_set_id: str = None,
        host_name: str = None,
        hpc_cluster_id: str = None,
        http_endpoint: str = None,
        http_tokens: str = None,
        image_family: str = None,
        image_id: str = None,
        image_name: str = None,
        image_options_login_as_non_root: bool = None,
        image_owner_alias: str = None,
        instance_description: str = None,
        instance_generation: str = None,
        instance_name: str = None,
        instance_pattern_infos: List[DescribeScalingConfigurationsResponseBodyScalingConfigurationsInstancePatternInfos] = None,
        instance_type: str = None,
        instance_types: List[str] = None,
        internet_charge_type: str = None,
        internet_max_bandwidth_in: int = None,
        internet_max_bandwidth_out: int = None,
        io_optimized: str = None,
        ipv_6address_count: int = None,
        key_pair_name: str = None,
        lifecycle_state: str = None,
        load_balancer_weight: int = None,
        memory: int = None,
        network_interfaces: List[DescribeScalingConfigurationsResponseBodyScalingConfigurationsNetworkInterfaces] = None,
        password_inherit: bool = None,
        password_setted: bool = None,
        private_pool_options_id: str = None,
        private_pool_options_match_criteria: str = None,
        ram_role_name: str = None,
        resource_group_id: str = None,
        resource_pool_options: DescribeScalingConfigurationsResponseBodyScalingConfigurationsResourcePoolOptions = None,
        scaling_configuration_id: str = None,
        scaling_configuration_name: str = None,
        scaling_group_id: str = None,
        scheduler_options: DescribeScalingConfigurationsResponseBodyScalingConfigurationsSchedulerOptions = None,
        security_enhancement_strategy: str = None,
        security_group_id: str = None,
        security_group_ids: List[str] = None,
        security_options: DescribeScalingConfigurationsResponseBodyScalingConfigurationsSecurityOptions = None,
        spot_duration: int = None,
        spot_interruption_behavior: str = None,
        spot_price_limits: List[DescribeScalingConfigurationsResponseBodyScalingConfigurationsSpotPriceLimits] = None,
        spot_strategy: str = None,
        storage_set_id: str = None,
        storage_set_partition_number: int = None,
        system_disk_auto_snapshot_policy_id: str = None,
        system_disk_bursting_enabled: bool = None,
        system_disk_categories: List[str] = None,
        system_disk_category: str = None,
        system_disk_description: str = None,
        system_disk_encrypt_algorithm: str = None,
        system_disk_encrypted: bool = None,
        system_disk_kmskey_id: str = None,
        system_disk_name: str = None,
        system_disk_performance_level: str = None,
        system_disk_provisioned_iops: int = None,
        system_disk_size: int = None,
        tags: List[DescribeScalingConfigurationsResponseBodyScalingConfigurationsTags] = None,
        tenancy: str = None,
        user_data: str = None,
        weighted_capacities: List[int] = None,
        zone_id: str = None,
    ):
        # Indicates whether the ECS instance on a dedicated host is associated with the dedicated host. Valid values:
        # 
        # *   default: The instance is not associated with the dedicated host. If you restart an instance that was stopped in Economical Mode and the original dedicated host of the instance has insufficient resources, the instance is automatically deployed to another dedicated host in the automatic deployment resource pool.
        # *   host: The instance is associated with the dedicated host. If you restart an instance that was stopped in Economical Mode, the instance remains on the original dedicated host. If the available resources of the original dedicated host are insufficient, the instance cannot be restarted.
        self.affinity = affinity
        # The number of vCPUs.
        # 
        # You can specify CPU and Memory to define the range of instance types. For example, if you set CPU to 2 and Memory to 16, the instance types that have 2 vCPUs and 16 GiB are returned. If you specify CPU and Memory, Auto Scaling determines the available instance types based on factors such as I/O optimization requirements and zones and preferentially creates instances by using the lowest-priced instance type.
        # 
        # >  You can specify CPU and Memory to define instance types only when you set Scaling Policy to Cost Optimization and no instance type is specified in the scaling configuration.
        self.cpu = cpu
        # The time at which the scaling configuration was created.
        self.creation_time = creation_time
        # The performance mode of the burstable instances. Valid values:
        # 
        # *   Standard: the standard mode. For more information, see the "Standard mode" section in the [Overview of burstable instances](https://help.aliyun.com/document_detail/59977.html) topic.
        # *   Unlimited: the unlimited mode. For more information, see the "Unlimited mode" section in [Overview of burstable instances](https://help.aliyun.com/document_detail/59977.html).
        self.credit_specification = credit_specification
        # The priority of the custom ECS instance type + vSwitch combination.
        # 
        # >  This parameter takes effect only when Scaling Policy of the scaling group is set to Priority Policy.
        # 
        # If Auto Scaling cannot create ECS instances by using the custom ECS instance type + vSwitch combination of the highest priority, Auto Scaling creates ECS instances by using the custom ECS instance type + vSwitch combination of the next highest priority.
        # 
        # >  If you specify the priorities of only a portion of custom ECS instance type + vSwitch combinations, Auto Scaling preferentially creates ECS instances by using the custom combinations that have specified priorities. If the custom combinations that have specified priorities do not provide sufficient resources, Auto Scaling creates ECS instances by using the custom combinations that do not have specified priorities based on the specified orders of vSwitches and instance types.
        # 
        # *   Example: the specified order of vSwitches for your scaling group is vsw1 and vsw2 and the specified order of instance types in your scaling configuration is type1 and type 2. In addition, you use CustomPriorities to specify ["vsw2+type2", "vsw1+type2"]. In this example, the vsw2+type2 combination has the highest priority and the vsw2+type1 combination has the lowest priority. The vsw1+type2 combination has a higher priority than the vsw1+type1 combination.
        self.custom_priorities = custom_priorities
        # The data disks.
        self.data_disks = data_disks
        # The ID of the dedicated host cluster.
        self.dedicated_host_cluster_id = dedicated_host_cluster_id
        # The ID of the dedicated host on which the ECS instance is created. Preemptible instances are not supported by dedicated hosts. Therefore, if you specify DedicatedHostId, SpotStrategy and SpotPriceLimit are ignored.
        # 
        # You can call the DescribeDedicatedHosts operation to query the IDs of dedicated hosts.
        self.dedicated_host_id = dedicated_host_id
        # Indicates whether Release Protection is enabled for the ECS instances. You can specify this parameter to determine whether the ECS instances can be deleted by using the ECS console or calling the DeleteInstance operation. Valid values:
        # 
        # *   true: Release Protection is enabled for the ECS instances. You cannot delete the ECS instances by using the ECS console or calling the DeleteInstance operation.
        # *   false: Release Protection is disabled for the ECS instances. You can delete the ECS instances by using the ECS console or calling the DeleteInstance operation.
        # 
        # >  You can enable Release Protection for only pay-as-you-go instances to prevent unexpected instance deletion during scale-in events. The Release Protection feature does not affect normal scaling activities. In other words, an instance that meets the criteria of scale-in policies may be removed from a scaling group during a scale-in event even if you enabled Release Protection for the instance.
        self.deletion_protection = deletion_protection
        # The ID of the deployment set to which the Elastic Compute Service (ECS) instances belong.
        self.deployment_set_id = deployment_set_id
        # The hostname series of the ECS instances.
        self.host_name = host_name
        # The ID of the High Performance Computing (HPC) cluster to which the ECS instances belong.
        self.hpc_cluster_id = hpc_cluster_id
        # Indicates whether the access channel is enabled for instance metadata. Valid values:
        # 
        # *   enabled
        # *   disabled
        self.http_endpoint = http_endpoint
        # Indicates whether the security hardening mode (IMDSv2) is forcefully used to access instance metadata. Valid values:
        # 
        # *   optional: The security hardening mode IMDSv2 is not forcibly used.
        # *   required: The security hardening mode (IMDSv2) is forcibly used. After you set this parameter to required, you cannot access instance metadata in normal mode.
        self.http_tokens = http_tokens
        # The name of the image family. You can specify this parameter to obtain the latest available images in the current image family for instance creation. If you specify ImageId, you cannot specify `ImageFamily`.
        self.image_family = image_family
        # The ID of the image file that provides the image resource for Auto Scaling to create ECS instances.
        self.image_id = image_id
        # The name of the image file.
        self.image_name = image_name
        # Indicates whether the ecs-user username can be used to log on to an ECS instance created from the scaling configuration. Valid values:
        # 
        # *   true
        # *   false
        self.image_options_login_as_non_root = image_options_login_as_non_root
        # The image source. Valid values:
        # 
        # *   system: a public image provided by Alibaba Cloud
        # *   self: a custom image that you created
        # *   others: a shared image from another Alibaba Cloud account or a community image published by another Alibaba Cloud account
        # *   marketplace: an Alibaba Cloud Marketplace image
        self.image_owner_alias = image_owner_alias
        # The description of the ECS instances.
        self.instance_description = instance_description
        # The generation of the ECS instances.
        self.instance_generation = instance_generation
        # The naming series of the ECS instances.
        self.instance_name = instance_name
        # The intelligent configuration settings, which determine the available instance types.
        self.instance_pattern_infos = instance_pattern_infos
        # The instance types of the ECS instances.
        self.instance_type = instance_type
        # The ECS instance types.
        self.instance_types = instance_types
        # The billing method for network usage. Valid values:
        # 
        # *   PayByBandwidth: pay-by-bandwidth. You are charged for the bandwidth that you specified by using InternetMaxBandwidthOut.
        # *   PayByTraffic: pay-by-traffic. You are charged for the actual traffic that you used. InternetMaxBandwidthOut specifies only the maximum available bandwidth.
        self.internet_charge_type = internet_charge_type
        # The maximum inbound public bandwidth. Unit: Mbit/s.
        self.internet_max_bandwidth_in = internet_max_bandwidth_in
        # The maximum outbound public bandwidth. Unit: Mbit/s.
        self.internet_max_bandwidth_out = internet_max_bandwidth_out
        # Indicates whether the ECS instances are I/O optimized. Valid values:
        # 
        # *   none: The ECS instances are not I/O optimized.
        # *   optimized: The ECS instances are I/O optimized.
        self.io_optimized = io_optimized
        # The number of randomly generated IPv6 addresses that are allocated to the elastic network interface (ENI).
        self.ipv_6address_count = ipv_6address_count
        # The name of the key pair that is used to log on to an ECS instance created from the scaling configuration.
        self.key_pair_name = key_pair_name
        # The status of the scaling configuration in the scaling group. Valid values:
        # 
        # *   Active: The scaling configuration is active in the scaling group. Auto Scaling uses the scaling configuration that is in the Active state to create ECS instances during scale-out events.
        # *   Inactive: The scaling configuration is inactive in the scaling group. Scaling configurations that are in the Inactive state are still contained in the scaling group, but Auto Scaling does not use the inactive scaling configurations to create ECS instances during scale-out events.
        self.lifecycle_state = lifecycle_state
        # The weight of an ECS instance as a backend server. Valid values: 1 to 100.
        self.load_balancer_weight = load_balancer_weight
        # The memory size. Unit: GiB.
        # 
        # You can specify CPU and Memory to define the range of instance types. For example, if you set CPU to 2 and Memory to 16, the instance types that have 2 vCPUs and 16 GiB are returned. If you specify CPU and Memory, Auto Scaling determines the available instance types based on factors such as I/O optimization requirements and zones and preferentially creates instances by using the lowest-priced instance type.
        # 
        # >  You can specify CPU and Memory to define instance types only when you set Scaling Policy to Cost Optimization and no instance type is specified in the scaling configuration.
        self.memory = memory
        # The ENIs.
        self.network_interfaces = network_interfaces
        # Indicates whether the password preconfigured in the image is used.
        self.password_inherit = password_inherit
        # Indicates whether a password is configured for the instance.
        self.password_setted = password_setted
        self.private_pool_options_id = private_pool_options_id
        self.private_pool_options_match_criteria = private_pool_options_match_criteria
        # The name of the Resource Access Management (RAM) role assumed by the ECS instances. This name is provided and maintained by RAM. You can call the ListRoles operation to query the available RAM roles.
        self.ram_role_name = ram_role_name
        # The ID of the resource group to which the ECS instances belong.
        self.resource_group_id = resource_group_id
        # The resource pools used for instance creation, which can be the public pool or a private pool associated with any active elasticity assurance or capacity reservation.
        # 
        # *   This parameter takes effect only when you create pay-as-you-go instances.
        self.resource_pool_options = resource_pool_options
        # The ID of the scaling configuration.
        self.scaling_configuration_id = scaling_configuration_id
        # The name of the scaling configuration.
        self.scaling_configuration_name = scaling_configuration_name
        # The ID of the scaling group to which the scaling configuration belongs.
        self.scaling_group_id = scaling_group_id
        # >  This parameter is in invitational preview and is not available for use.
        self.scheduler_options = scheduler_options
        # Indicates whether Security Hardening is enabled. Valid values:
        # 
        # *   Active: Security Hardening is enabled. This value is applicable to only public images.
        # *   Deactive: Security Hardening is disabled. This value is applicable to all images.
        self.security_enhancement_strategy = security_enhancement_strategy
        # The ID of the security group to which the ECS instances belong. ECS instances that belong to the same security group can communicate with each other.
        self.security_group_id = security_group_id
        # The IDs of the security groups to which the ECS instances belong. ECS instances that belong to the same security group can communicate with each other.
        self.security_group_ids = security_group_ids
        self.security_options = security_options
        # The protection period of the preemptible instances. Unit: hours.
        self.spot_duration = spot_duration
        # The interruption event of the preemptible instances.
        self.spot_interruption_behavior = spot_interruption_behavior
        # The preemptible instances.
        self.spot_price_limits = spot_price_limits
        # The preemption policy that is applied to pay-as-you-go instances. Valid values:
        # 
        # *   NoSpot: The instances are created as regular pay-as-you-go instances.
        # *   SpotWithPriceLimit: The instances are created as preemptible instances that have a user-defined maximum hourly price.
        # *   SpotAsPriceGo: The instances are preemptible instances for which the market price at the time of purchase is automatically used as the bid price.
        self.spot_strategy = spot_strategy
        # The ID of the storage set.
        self.storage_set_id = storage_set_id
        # The maximum number of partitions in the storage set. The value is an integer that is greater than or equal to 2.
        self.storage_set_partition_number = storage_set_partition_number
        # The ID of the automatic snapshot policy that is applied to the system disk.
        self.system_disk_auto_snapshot_policy_id = system_disk_auto_snapshot_policy_id
        # Indicates whether the Performance Burst feature is enabled for the system disk. Valid values:
        # 
        # *   true
        # *   false
        # 
        # >  This parameter is available only when you set SystemDisk.Category to cloud_auto.
        self.system_disk_bursting_enabled = system_disk_bursting_enabled
        # The categories of the system disks. The values are sorted based on their priorities. The first value has the highest priority. If Auto Scaling cannot create instances by using the disk category of the highest priority, Auto Scaling creates instances by using the disk category of the next highest priority. Valid values:
        # 
        # *   cloud: basic disk
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   cloud_essd: ESSD
        self.system_disk_categories = system_disk_categories
        # The category of the system disk. Valid values:
        # 
        # *   cloud: basic disk
        # *   cloud_efficiency: ultra disk
        # *   cloud_ssd: standard SSD
        # *   ephemeral_ssd: local SSD
        # *   cloud_essd: enterprise SSD (ESSD)
        # *   cloud_auto: ESSD AutoPL
        self.system_disk_category = system_disk_category
        # The description of the system disk.
        self.system_disk_description = system_disk_description
        # The encryption algorithm that is applied to the system disk. Valid values:
        # 
        # *   AES-256
        # *   SM4-128
        self.system_disk_encrypt_algorithm = system_disk_encrypt_algorithm
        # Indicates whether the system disk is encrypted. Valid values:
        # 
        # *   true
        # *   false
        self.system_disk_encrypted = system_disk_encrypted
        # The ID of the KMS key that is applied to the system disk.
        self.system_disk_kmskey_id = system_disk_kmskey_id
        # The name of the system disk.
        self.system_disk_name = system_disk_name
        # The performance level (PL) of the system disk that is an ESSD.
        self.system_disk_performance_level = system_disk_performance_level
        # The provisioned IOPS of the system disk.
        # 
        # >  IOPS measures the number of read and write operations that an EBS device can process per second.
        self.system_disk_provisioned_iops = system_disk_provisioned_iops
        # The size of the system disk. Unit: GiB.
        self.system_disk_size = system_disk_size
        # The tags.
        self.tags = tags
        # Indicates whether the ECS instance is created on a dedicated host. Valid values:
        # 
        # *   default: The ECS instance is created on a non-dedicated host.
        # *   host: The ECS instance is created on a dedicated host. If you do not specify DedicatedHostId, the system selects a dedicated host for the ECS instance.
        # 
        # Default value: default.
        self.tenancy = tenancy
        # The user data of the ECS instances.
        self.user_data = user_data
        # The weights of the instance types. The value of this parameter indicates the capacity of an instance of the specified instance type in the scaling group. A higher weight indicates that a smaller number of instances of the instance type are required to meet the expected capacity requirement.
        self.weighted_capacities = weighted_capacities
        # The ID of the zone in which the ECS instances are created. You can call the DescribeZones operation to query the zone IDs.
        self.zone_id = zone_id

    def validate(self):
        if self.custom_priorities:
            for k in self.custom_priorities:
                if k:
                    k.validate()
        if self.data_disks:
            for k in self.data_disks:
                if k:
                    k.validate()
        if self.instance_pattern_infos:
            for k in self.instance_pattern_infos:
                if k:
                    k.validate()
        if self.network_interfaces:
            for k in self.network_interfaces:
                if k:
                    k.validate()
        if self.resource_pool_options:
            self.resource_pool_options.validate()
        if self.scheduler_options:
            self.scheduler_options.validate()
        if self.security_options:
            self.security_options.validate()
        if self.spot_price_limits:
            for k in self.spot_price_limits:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.affinity is not None:
            result['Affinity'] = self.affinity
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        result['CustomPriorities'] = []
        if self.custom_priorities is not None:
            for k in self.custom_priorities:
                result['CustomPriorities'].append(k.to_map() if k else None)
        result['DataDisks'] = []
        if self.data_disks is not None:
            for k in self.data_disks:
                result['DataDisks'].append(k.to_map() if k else None)
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.http_endpoint is not None:
            result['HttpEndpoint'] = self.http_endpoint
        if self.http_tokens is not None:
            result['HttpTokens'] = self.http_tokens
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_options_login_as_non_root is not None:
            result['ImageOptionsLoginAsNonRoot'] = self.image_options_login_as_non_root
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        result['InstancePatternInfos'] = []
        if self.instance_pattern_infos is not None:
            for k in self.instance_pattern_infos:
                result['InstancePatternInfos'].append(k.to_map() if k else None)
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.instance_types is not None:
            result['InstanceTypes'] = self.instance_types
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.lifecycle_state is not None:
            result['LifecycleState'] = self.lifecycle_state
        if self.load_balancer_weight is not None:
            result['LoadBalancerWeight'] = self.load_balancer_weight
        if self.memory is not None:
            result['Memory'] = self.memory
        result['NetworkInterfaces'] = []
        if self.network_interfaces is not None:
            for k in self.network_interfaces:
                result['NetworkInterfaces'].append(k.to_map() if k else None)
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.password_setted is not None:
            result['PasswordSetted'] = self.password_setted
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptions.Id'] = self.private_pool_options_id
        if self.private_pool_options_match_criteria is not None:
            result['PrivatePoolOptions.MatchCriteria'] = self.private_pool_options_match_criteria
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_pool_options is not None:
            result['ResourcePoolOptions'] = self.resource_pool_options.to_map()
        if self.scaling_configuration_id is not None:
            result['ScalingConfigurationId'] = self.scaling_configuration_id
        if self.scaling_configuration_name is not None:
            result['ScalingConfigurationName'] = self.scaling_configuration_name
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.scheduler_options is not None:
            result['SchedulerOptions'] = self.scheduler_options.to_map()
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.security_options is not None:
            result['SecurityOptions'] = self.security_options.to_map()
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_interruption_behavior is not None:
            result['SpotInterruptionBehavior'] = self.spot_interruption_behavior
        result['SpotPriceLimits'] = []
        if self.spot_price_limits is not None:
            for k in self.spot_price_limits:
                result['SpotPriceLimits'].append(k.to_map() if k else None)
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.system_disk_auto_snapshot_policy_id is not None:
            result['SystemDiskAutoSnapshotPolicyId'] = self.system_disk_auto_snapshot_policy_id
        if self.system_disk_bursting_enabled is not None:
            result['SystemDiskBurstingEnabled'] = self.system_disk_bursting_enabled
        if self.system_disk_categories is not None:
            result['SystemDiskCategories'] = self.system_disk_categories
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_description is not None:
            result['SystemDiskDescription'] = self.system_disk_description
        if self.system_disk_encrypt_algorithm is not None:
            result['SystemDiskEncryptAlgorithm'] = self.system_disk_encrypt_algorithm
        if self.system_disk_encrypted is not None:
            result['SystemDiskEncrypted'] = self.system_disk_encrypted
        if self.system_disk_kmskey_id is not None:
            result['SystemDiskKMSKeyId'] = self.system_disk_kmskey_id
        if self.system_disk_name is not None:
            result['SystemDiskName'] = self.system_disk_name
        if self.system_disk_performance_level is not None:
            result['SystemDiskPerformanceLevel'] = self.system_disk_performance_level
        if self.system_disk_provisioned_iops is not None:
            result['SystemDiskProvisionedIops'] = self.system_disk_provisioned_iops
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.tenancy is not None:
            result['Tenancy'] = self.tenancy
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.weighted_capacities is not None:
            result['WeightedCapacities'] = self.weighted_capacities
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Affinity') is not None:
            self.affinity = m.get('Affinity')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('CreditSpecification') is not None:
            self.credit_specification = m.get('CreditSpecification')
        self.custom_priorities = []
        if m.get('CustomPriorities') is not None:
            for k in m.get('CustomPriorities'):
                temp_model = DescribeScalingConfigurationsResponseBodyScalingConfigurationsCustomPriorities()
                self.custom_priorities.append(temp_model.from_map(k))
        self.data_disks = []
        if m.get('DataDisks') is not None:
            for k in m.get('DataDisks'):
                temp_model = DescribeScalingConfigurationsResponseBodyScalingConfigurationsDataDisks()
                self.data_disks.append(temp_model.from_map(k))
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        if m.get('HttpEndpoint') is not None:
            self.http_endpoint = m.get('HttpEndpoint')
        if m.get('HttpTokens') is not None:
            self.http_tokens = m.get('HttpTokens')
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageOptionsLoginAsNonRoot') is not None:
            self.image_options_login_as_non_root = m.get('ImageOptionsLoginAsNonRoot')
        if m.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = m.get('ImageOwnerAlias')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        self.instance_pattern_infos = []
        if m.get('InstancePatternInfos') is not None:
            for k in m.get('InstancePatternInfos'):
                temp_model = DescribeScalingConfigurationsResponseBodyScalingConfigurationsInstancePatternInfos()
                self.instance_pattern_infos.append(temp_model.from_map(k))
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InstanceTypes') is not None:
            self.instance_types = m.get('InstanceTypes')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LifecycleState') is not None:
            self.lifecycle_state = m.get('LifecycleState')
        if m.get('LoadBalancerWeight') is not None:
            self.load_balancer_weight = m.get('LoadBalancerWeight')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        self.network_interfaces = []
        if m.get('NetworkInterfaces') is not None:
            for k in m.get('NetworkInterfaces'):
                temp_model = DescribeScalingConfigurationsResponseBodyScalingConfigurationsNetworkInterfaces()
                self.network_interfaces.append(temp_model.from_map(k))
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('PasswordSetted') is not None:
            self.password_setted = m.get('PasswordSetted')
        if m.get('PrivatePoolOptions.Id') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptions.Id')
        if m.get('PrivatePoolOptions.MatchCriteria') is not None:
            self.private_pool_options_match_criteria = m.get('PrivatePoolOptions.MatchCriteria')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourcePoolOptions') is not None:
            temp_model = DescribeScalingConfigurationsResponseBodyScalingConfigurationsResourcePoolOptions()
            self.resource_pool_options = temp_model.from_map(m['ResourcePoolOptions'])
        if m.get('ScalingConfigurationId') is not None:
            self.scaling_configuration_id = m.get('ScalingConfigurationId')
        if m.get('ScalingConfigurationName') is not None:
            self.scaling_configuration_name = m.get('ScalingConfigurationName')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('SchedulerOptions') is not None:
            temp_model = DescribeScalingConfigurationsResponseBodyScalingConfigurationsSchedulerOptions()
            self.scheduler_options = temp_model.from_map(m['SchedulerOptions'])
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('SecurityOptions') is not None:
            temp_model = DescribeScalingConfigurationsResponseBodyScalingConfigurationsSecurityOptions()
            self.security_options = temp_model.from_map(m['SecurityOptions'])
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('SpotInterruptionBehavior') is not None:
            self.spot_interruption_behavior = m.get('SpotInterruptionBehavior')
        self.spot_price_limits = []
        if m.get('SpotPriceLimits') is not None:
            for k in m.get('SpotPriceLimits'):
                temp_model = DescribeScalingConfigurationsResponseBodyScalingConfigurationsSpotPriceLimits()
                self.spot_price_limits.append(temp_model.from_map(k))
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        if m.get('SystemDiskAutoSnapshotPolicyId') is not None:
            self.system_disk_auto_snapshot_policy_id = m.get('SystemDiskAutoSnapshotPolicyId')
        if m.get('SystemDiskBurstingEnabled') is not None:
            self.system_disk_bursting_enabled = m.get('SystemDiskBurstingEnabled')
        if m.get('SystemDiskCategories') is not None:
            self.system_disk_categories = m.get('SystemDiskCategories')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('SystemDiskDescription') is not None:
            self.system_disk_description = m.get('SystemDiskDescription')
        if m.get('SystemDiskEncryptAlgorithm') is not None:
            self.system_disk_encrypt_algorithm = m.get('SystemDiskEncryptAlgorithm')
        if m.get('SystemDiskEncrypted') is not None:
            self.system_disk_encrypted = m.get('SystemDiskEncrypted')
        if m.get('SystemDiskKMSKeyId') is not None:
            self.system_disk_kmskey_id = m.get('SystemDiskKMSKeyId')
        if m.get('SystemDiskName') is not None:
            self.system_disk_name = m.get('SystemDiskName')
        if m.get('SystemDiskPerformanceLevel') is not None:
            self.system_disk_performance_level = m.get('SystemDiskPerformanceLevel')
        if m.get('SystemDiskProvisionedIops') is not None:
            self.system_disk_provisioned_iops = m.get('SystemDiskProvisionedIops')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeScalingConfigurationsResponseBodyScalingConfigurationsTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('Tenancy') is not None:
            self.tenancy = m.get('Tenancy')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('WeightedCapacities') is not None:
            self.weighted_capacities = m.get('WeightedCapacities')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeScalingConfigurationsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        scaling_configurations: List[DescribeScalingConfigurationsResponseBodyScalingConfigurations] = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The scaling configurations.
        self.scaling_configurations = scaling_configurations
        # The total number of scaling configurations.
        self.total_count = total_count

    def validate(self):
        if self.scaling_configurations:
            for k in self.scaling_configurations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['ScalingConfigurations'] = []
        if self.scaling_configurations is not None:
            for k in self.scaling_configurations:
                result['ScalingConfigurations'].append(k.to_map() if k else None)
        if self.total_count is not Non