# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.dataset import Dataset
from ..types.http_validation_error import HttpValidationError
from ..types.time_series_data_point import TimeSeriesDataPoint
from .types.create_geospatial_static_api_v_1_dashboard_datasets_geospatial_static_post_request_geometry_type import (
    CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType,
)
from .types.create_timeseries_live_api_v_1_dashboard_datasets_timeseries_live_post_request_data_format import (
    CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDatasetsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_timeseries_static(
        self,
        *,
        name: str,
        data: typing.Sequence[TimeSeriesDataPoint],
        description: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Dataset]:
        """
        Create a static timeseries dataset.

        Parameters
        ----------
        name : str

        data : typing.Sequence[TimeSeriesDataPoint]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Dataset]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/timeseries-static",
            method="POST",
            params={
                "name": name,
                "description": description,
            },
            json={
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Sequence[TimeSeriesDataPoint], direction="write"
                ),
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_timeseries_live(
        self,
        *,
        name: str,
        url: str,
        data_format: typing.Optional[
            CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat
        ] = None,
        datetime_format: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        aliases: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        headers: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Dataset]:
        """
        Create a live timeseries dataset.

        Parameters
        ----------
        name : str

        url : str

        data_format : typing.Optional[CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat]

        datetime_format : typing.Optional[str]

        description : typing.Optional[str]

        params : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        aliases : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        headers : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Dataset]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/timeseries-live",
            method="POST",
            params={
                "name": name,
                "url": url,
                "data_format": data_format,
                "datetime_format": datetime_format,
                "description": description,
            },
            json={
                "params": params,
                "aliases": aliases,
                "headers": headers,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_tabular_static(
        self,
        *,
        name: str,
        data: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        description: typing.Optional[str] = None,
        column_schema: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Create a static tabular dataset (placeholder).

        Parameters
        ----------
        name : str

        data : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]

        description : typing.Optional[str]

        column_schema : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/tabular-static",
            method="POST",
            params={
                "name": name,
                "description": description,
            },
            json={
                "data": data,
                "column_schema": column_schema,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_geospatial_static(
        self,
        *,
        name: str,
        data: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        coordinate_system: typing.Optional[str] = None,
        geometry_type: typing.Optional[
            CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType
        ] = None,
        description: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Dataset]:
        """
        Create a static geospatial dataset compatible with deck.gl data formats.

        Parameters
        ----------
        name : str

        data : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]

        coordinate_system : typing.Optional[str]

        geometry_type : typing.Optional[CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Dataset]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/geospatial-static",
            method="POST",
            params={
                "name": name,
                "coordinate_system": coordinate_system,
                "geometry_type": geometry_type,
                "description": description,
            },
            json={
                "data": data,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_datasets(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[Dataset]]:
        """
        List all datasets for the user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[Dataset]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Dataset],
                    parse_obj_as(
                        type_=typing.List[Dataset],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_dataset(
        self, dataset_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Dataset]:
        """
        Retrieve a single dataset by its ID.

        Parameters
        ----------
        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Dataset]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/datasets/{jsonable_encoder(dataset_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_dataset(
        self,
        dataset_id: str,
        *,
        name: str,
        description: typing.Optional[str] = None,
        request: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Dataset]:
        """
        Update a dataset's basic properties (name, description, metadata only).

        Parameters
        ----------
        dataset_id : str

        name : str

        description : typing.Optional[str]

        request : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Dataset]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/datasets/{jsonable_encoder(dataset_id)}",
            method="PUT",
            params={
                "name": name,
                "description": description,
            },
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_dataset(
        self, dataset_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Delete a dataset.

        Parameters
        ----------
        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/datasets/{jsonable_encoder(dataset_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_dataset_data(
        self,
        dataset_id: str,
        *,
        start: typing.Optional[str] = None,
        end: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Get dataset data with optional time filtering. Works for static and live datasets of all types.

        Parameters
        ----------
        dataset_id : str

        start : typing.Optional[str]

        end : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/datasets/{jsonable_encoder(dataset_id)}/data",
            method="GET",
            params={
                "start": start,
                "end": end,
            },
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDatasetsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_timeseries_static(
        self,
        *,
        name: str,
        data: typing.Sequence[TimeSeriesDataPoint],
        description: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Dataset]:
        """
        Create a static timeseries dataset.

        Parameters
        ----------
        name : str

        data : typing.Sequence[TimeSeriesDataPoint]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Dataset]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/timeseries-static",
            method="POST",
            params={
                "name": name,
                "description": description,
            },
            json={
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Sequence[TimeSeriesDataPoint], direction="write"
                ),
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_timeseries_live(
        self,
        *,
        name: str,
        url: str,
        data_format: typing.Optional[
            CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat
        ] = None,
        datetime_format: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        aliases: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        headers: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Dataset]:
        """
        Create a live timeseries dataset.

        Parameters
        ----------
        name : str

        url : str

        data_format : typing.Optional[CreateTimeseriesLiveApiV1DashboardDatasetsTimeseriesLivePostRequestDataFormat]

        datetime_format : typing.Optional[str]

        description : typing.Optional[str]

        params : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        aliases : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        headers : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Dataset]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/timeseries-live",
            method="POST",
            params={
                "name": name,
                "url": url,
                "data_format": data_format,
                "datetime_format": datetime_format,
                "description": description,
            },
            json={
                "params": params,
                "aliases": aliases,
                "headers": headers,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_tabular_static(
        self,
        *,
        name: str,
        data: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        description: typing.Optional[str] = None,
        column_schema: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Create a static tabular dataset (placeholder).

        Parameters
        ----------
        name : str

        data : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]

        description : typing.Optional[str]

        column_schema : typing.Optional[typing.Dict[str, typing.Optional[str]]]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/tabular-static",
            method="POST",
            params={
                "name": name,
                "description": description,
            },
            json={
                "data": data,
                "column_schema": column_schema,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_geospatial_static(
        self,
        *,
        name: str,
        data: typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]],
        coordinate_system: typing.Optional[str] = None,
        geometry_type: typing.Optional[
            CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType
        ] = None,
        description: typing.Optional[str] = None,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Dataset]:
        """
        Create a static geospatial dataset compatible with deck.gl data formats.

        Parameters
        ----------
        name : str

        data : typing.Sequence[typing.Dict[str, typing.Optional[typing.Any]]]

        coordinate_system : typing.Optional[str]

        geometry_type : typing.Optional[CreateGeospatialStaticApiV1DashboardDatasetsGeospatialStaticPostRequestGeometryType]

        description : typing.Optional[str]

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Dataset]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/geospatial-static",
            method="POST",
            params={
                "name": name,
                "coordinate_system": coordinate_system,
                "geometry_type": geometry_type,
                "description": description,
            },
            json={
                "data": data,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_datasets(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[Dataset]]:
        """
        List all datasets for the user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[Dataset]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/datasets/",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Dataset],
                    parse_obj_as(
                        type_=typing.List[Dataset],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_dataset(
        self, dataset_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Dataset]:
        """
        Retrieve a single dataset by its ID.

        Parameters
        ----------
        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Dataset]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/datasets/{jsonable_encoder(dataset_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_dataset(
        self,
        dataset_id: str,
        *,
        name: str,
        description: typing.Optional[str] = None,
        request: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Dataset]:
        """
        Update a dataset's basic properties (name, description, metadata only).

        Parameters
        ----------
        dataset_id : str

        name : str

        description : typing.Optional[str]

        request : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Dataset]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/datasets/{jsonable_encoder(dataset_id)}",
            method="PUT",
            params={
                "name": name,
                "description": description,
            },
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Dataset,
                    parse_obj_as(
                        type_=Dataset,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_dataset(
        self, dataset_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Delete a dataset.

        Parameters
        ----------
        dataset_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/datasets/{jsonable_encoder(dataset_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_dataset_data(
        self,
        dataset_id: str,
        *,
        start: typing.Optional[str] = None,
        end: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Get dataset data with optional time filtering. Works for static and live datasets of all types.

        Parameters
        ----------
        dataset_id : str

        start : typing.Optional[str]

        end : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/datasets/{jsonable_encoder(dataset_id)}/data",
            method="GET",
            params={
                "start": start,
                "end": end,
            },
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
