# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.map_layer import MapLayer
from ..types.ui_config import UiConfig
from .raw_client import AsyncRawMapLayersClient, RawMapLayersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MapLayersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMapLayersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMapLayersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMapLayersClient
        """
        return self._raw_client

    def list_map_layers(self, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[MapLayer]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[MapLayer]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.map_layers.list_map_layers()
        """
        _response = self._raw_client.list_map_layers(request_options=request_options)
        return _response.data

    def create_map_layer(
        self,
        *,
        name: str,
        type: str,
        dataset_id: str,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MapLayer:
        """
        Parameters
        ----------
        name : str

        type : str

        dataset_id : str

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapLayer
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.map_layers.create_map_layer(
            name="name",
            type="type",
            dataset_id="dataset_id",
        )
        """
        _response = self._raw_client.create_map_layer(
            name=name,
            type=type,
            dataset_id=dataset_id,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    def get_map_layer(self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> MapLayer:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapLayer
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.map_layers.get_map_layer(
            layer_id="layer_id",
        )
        """
        _response = self._raw_client.get_map_layer(layer_id, request_options=request_options)
        return _response.data

    def update_map_layer(
        self,
        layer_id: str,
        *,
        name: str,
        type: str,
        dataset_id: str,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MapLayer:
        """
        Parameters
        ----------
        layer_id : str

        name : str

        type : str

        dataset_id : str

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapLayer
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.map_layers.update_map_layer(
            layer_id="layer_id",
            name="name",
            type="type",
            dataset_id="dataset_id",
        )
        """
        _response = self._raw_client.update_map_layer(
            layer_id,
            name=name,
            type=type,
            dataset_id=dataset_id,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    def delete_map_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.map_layers.delete_map_layer(
            layer_id="layer_id",
        )
        """
        _response = self._raw_client.delete_map_layer(layer_id, request_options=request_options)
        return _response.data


class AsyncMapLayersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMapLayersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMapLayersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMapLayersClient
        """
        return self._raw_client

    async def list_map_layers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[MapLayer]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[MapLayer]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.map_layers.list_map_layers()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_map_layers(request_options=request_options)
        return _response.data

    async def create_map_layer(
        self,
        *,
        name: str,
        type: str,
        dataset_id: str,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MapLayer:
        """
        Parameters
        ----------
        name : str

        type : str

        dataset_id : str

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapLayer
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.map_layers.create_map_layer(
                name="name",
                type="type",
                dataset_id="dataset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_map_layer(
            name=name,
            type=type,
            dataset_id=dataset_id,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    async def get_map_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MapLayer:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapLayer
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.map_layers.get_map_layer(
                layer_id="layer_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_map_layer(layer_id, request_options=request_options)
        return _response.data

    async def update_map_layer(
        self,
        layer_id: str,
        *,
        name: str,
        type: str,
        dataset_id: str,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MapLayer:
        """
        Parameters
        ----------
        layer_id : str

        name : str

        type : str

        dataset_id : str

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MapLayer
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.map_layers.update_map_layer(
                layer_id="layer_id",
                name="name",
                type="type",
                dataset_id="dataset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_map_layer(
            layer_id,
            name=name,
            type=type,
            dataset_id=dataset_id,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    async def delete_map_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.map_layers.delete_map_layer(
                layer_id="layer_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_map_layer(layer_id, request_options=request_options)
        return _response.data
