# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .dataformat import Dataformat


class LiveDataSource(UniversalBaseModel):
    url: str = pydantic.Field()
    """
    Base URL for the external API
    """

    params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Query parameters with {start}/{end} placeholders
    """

    data_format: typing_extensions.Annotated[typing.Optional[Dataformat], FieldMetadata(alias="dataFormat")] = (
        pydantic.Field(default=None)
    )
    """
    Expected data format from API
    """

    aliases: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Column name mapping (original -> target)
    """

    headers: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Optional HTTP headers
    """

    datetime_format: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="datetimeFormat")] = (
        pydantic.Field(default=None)
    )
    """
    strftime format for datetime parameters (e.g., '%Y-%m-%dT%H:%M' for DK API)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
