# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .ui_config import UiConfig


class MapLayer(UniversalBaseModel):
    """
    A single data layer on a map, inspired by deck.gl and aligned with frontend.
    """

    id: typing.Optional[str] = None
    user_id: typing_extensions.Annotated[str, FieldMetadata(alias="userId")]
    name: str = pydantic.Field()
    """
    User-defined name for the layer, e.g., 'Danish Wind Turbines'.
    """

    type: str = pydantic.Field()
    """
    Deck.gl layer type, e.g., 'GeoJsonLayer', 'ScatterplotLayer'.
    """

    dataset_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="datasetId")] = pydantic.Field(
        default=None
    )
    """
    Reference to dataset providing the data for this layer.
    """

    deckgl_props: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="deckglProps")
    ] = pydantic.Field(default=None)
    """
    Base DeckGL layer configuration (styling, interactions, etc.).
    """

    ui_config: typing_extensions.Annotated[typing.Optional[UiConfig], FieldMetadata(alias="uiConfig")] = pydantic.Field(
        default=None
    )
    """
    Configuration for interactive UI controls that can modify layer properties.
    """

    created_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="createdAt")] = None
    updated_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="updatedAt")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
