# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ReactGridLayoutConfig(UniversalBaseModel):
    cols: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of columns in the grid
    """

    row_height: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="rowHeight")] = pydantic.Field(
        default=None
    )
    """
    Height of a single row in pixels
    """

    margin: typing.Optional[typing.List[int]] = pydantic.Field(default=None)
    """
    Margin between items [x, y]
    """

    container_padding: typing_extensions.Annotated[
        typing.Optional[typing.List[int]], FieldMetadata(alias="containerPadding")
    ] = pydantic.Field(default=None)
    """
    Padding around the container [x, y]
    """

    is_draggable: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isDraggable")] = (
        pydantic.Field(default=None)
    )
    """
    Whether items can be dragged
    """

    is_resizable: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="isResizable")] = (
        pydantic.Field(default=None)
    )
    """
    Whether items can be resized
    """

    auto_size: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="autoSize")] = pydantic.Field(
        default=None
    )
    """
    Whether the container should auto-size to fit contents
    """

    use_css_transforms: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="useCssTransforms")] = (
        pydantic.Field(default=None)
    )
    """
    Whether to use CSS transforms for positioning
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
