# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .ui_control_config import UiControlConfig


class UiConfig(UniversalBaseModel):
    """
    Configuration defining which layer properties can be interactively modified.
    """

    controls: typing.Optional[typing.Dict[str, UiControlConfig]] = pydantic.Field(default=None)
    """
    Map of control ID to control configuration
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
