# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .layertype import Layertype
from .ui_config import UiConfig


class WeatherLayer(UniversalBaseModel):
    id: typing.Optional[str] = None
    user_id: typing_extensions.Annotated[str, FieldMetadata(alias="userId")]
    name: str
    weather_model_id: typing_extensions.Annotated[str, FieldMetadata(alias="weatherModelId")]
    variable: str
    altitude: int
    run_hour: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="runHour")] = pydantic.Field(
        default=None
    )
    """
    Forecast run hour (0, 6, 12, 18) - only for forecast models
    """

    run_day: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="runDay")] = pydantic.Field(
        default=None
    )
    """
    Forecast run day in ISO format (YYYY-MM-DD) - only for forecast models
    """

    layer_type: typing_extensions.Annotated[Layertype, FieldMetadata(alias="layerType")] = pydantic.Field()
    """
    Type of weather layer visualization
    """

    deckgl_props: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="deckglProps")
    ] = pydantic.Field(default=None)
    """
    Base DeckGL layer configuration (styling, interactions, etc.).
    """

    ui_config: typing_extensions.Annotated[typing.Optional[UiConfig], FieldMetadata(alias="uiConfig")] = pydantic.Field(
        default=None
    )
    """
    Configuration for interactive UI controls that can modify layer properties.
    """

    created_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="createdAt")] = None
    updated_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="updatedAt")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
