# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class WeatherMapConfig(UniversalBaseModel):
    """
    Configuration specific to a weather map component.
    """

    latitude: typing.Optional[float] = pydantic.Field(default=None)
    """
    Initial map center latitude.
    """

    longitude: typing.Optional[float] = pydantic.Field(default=None)
    """
    Initial map center longitude.
    """

    zoom: typing.Optional[int] = pydantic.Field(default=None)
    """
    Initial map zoom level
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
