# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.image_meta_response import ImageMetaResponse
from ..types.model_meta import ModelMeta
from ..types.model_meta_response import ModelMetaResponse
from ..types.model_runs_response import ModelRunsResponse


class RawWeatherClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_model_list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ModelMeta]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ModelMeta]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/weather/model/list",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ModelMeta],
                    parse_obj_as(
                        type_=typing.List[ModelMeta],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_model_meta(
        self, model: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ModelMetaResponse]:
        """
        Parameters
        ----------
        model : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ModelMetaResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/weather/model/{jsonable_encoder(model)}/meta",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ModelMetaResponse,
                    parse_obj_as(
                        type_=ModelMetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_available_model_runs_for_date(
        self, model: str, year: int, month: int, day: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ModelRunsResponse]:
        """
        Parameters
        ----------
        model : str

        year : int

        month : int

        day : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ModelRunsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/weather/model/{jsonable_encoder(model)}/runs/{jsonable_encoder(year)}/{jsonable_encoder(month)}/{jsonable_encoder(day)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ModelRunsResponse,
                    parse_obj_as(
                        type_=ModelRunsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_forecast_run(
        self,
        model: str,
        year: int,
        month: int,
        day: int,
        hour: int,
        variable: str,
        height: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ImageMetaResponse]:
        """
        Parameters
        ----------
        model : str

        year : int

        month : int

        day : int

        hour : int

        variable : str

        height : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ImageMetaResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/weather/model/{jsonable_encoder(model)}/run/{jsonable_encoder(year)}/{jsonable_encoder(month)}/{jsonable_encoder(day)}/{jsonable_encoder(hour)}/{jsonable_encoder(variable)}/{jsonable_encoder(height)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ImageMetaResponse,
                    parse_obj_as(
                        type_=ImageMetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_historical_data(
        self,
        model: str,
        variable: str,
        height: str,
        *,
        start_date: str,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ImageMetaResponse]:
        """
        Parameters
        ----------
        model : str

        variable : str

        height : str

        start_date : str
            Start date in YYYY-MM-DD format

        end_date : typing.Optional[str]
            End date in YYYY-MM-DD format (optional, defaults to start_date, inclusive)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ImageMetaResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/weather/model/{jsonable_encoder(model)}/historical/{jsonable_encoder(variable)}/{jsonable_encoder(height)}",
            method="GET",
            params={
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ImageMetaResponse,
                    parse_obj_as(
                        type_=ImageMetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawWeatherClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_model_list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ModelMeta]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ModelMeta]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/weather/model/list",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ModelMeta],
                    parse_obj_as(
                        type_=typing.List[ModelMeta],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_model_meta(
        self, model: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ModelMetaResponse]:
        """
        Parameters
        ----------
        model : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ModelMetaResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/weather/model/{jsonable_encoder(model)}/meta",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ModelMetaResponse,
                    parse_obj_as(
                        type_=ModelMetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_available_model_runs_for_date(
        self, model: str, year: int, month: int, day: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ModelRunsResponse]:
        """
        Parameters
        ----------
        model : str

        year : int

        month : int

        day : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ModelRunsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/weather/model/{jsonable_encoder(model)}/runs/{jsonable_encoder(year)}/{jsonable_encoder(month)}/{jsonable_encoder(day)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ModelRunsResponse,
                    parse_obj_as(
                        type_=ModelRunsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_forecast_run(
        self,
        model: str,
        year: int,
        month: int,
        day: int,
        hour: int,
        variable: str,
        height: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ImageMetaResponse]:
        """
        Parameters
        ----------
        model : str

        year : int

        month : int

        day : int

        hour : int

        variable : str

        height : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ImageMetaResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/weather/model/{jsonable_encoder(model)}/run/{jsonable_encoder(year)}/{jsonable_encoder(month)}/{jsonable_encoder(day)}/{jsonable_encoder(hour)}/{jsonable_encoder(variable)}/{jsonable_encoder(height)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ImageMetaResponse,
                    parse_obj_as(
                        type_=ImageMetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_historical_data(
        self,
        model: str,
        variable: str,
        height: str,
        *,
        start_date: str,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ImageMetaResponse]:
        """
        Parameters
        ----------
        model : str

        variable : str

        height : str

        start_date : str
            Start date in YYYY-MM-DD format

        end_date : typing.Optional[str]
            End date in YYYY-MM-DD format (optional, defaults to start_date, inclusive)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ImageMetaResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/weather/model/{jsonable_encoder(model)}/historical/{jsonable_encoder(variable)}/{jsonable_encoder(height)}",
            method="GET",
            params={
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ImageMetaResponse,
                    parse_obj_as(
                        type_=ImageMetaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
