# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.ui_config import UiConfig
from ..types.weather_layer import WeatherLayer
from .raw_client import AsyncRawWeatherLayersClient, RawWeatherLayersClient
from .types.create_weather_layer_api_v_1_dashboard_weather_layers_post_request_layer_type import (
    CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType,
)
from .types.update_weather_layer_api_v_1_dashboard_weather_layers_layer_id_put_request_layer_type import (
    UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WeatherLayersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWeatherLayersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWeatherLayersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWeatherLayersClient
        """
        return self._raw_client

    def list_weather_layers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[WeatherLayer]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[WeatherLayer]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather_layers.list_weather_layers()
        """
        _response = self._raw_client.list_weather_layers(request_options=request_options)
        return _response.data

    def create_weather_layer(
        self,
        *,
        name: str,
        weather_model_id: str,
        variable: str,
        altitude: int,
        layer_type: CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WeatherLayer:
        """
        Parameters
        ----------
        name : str

        weather_model_id : str

        variable : str

        altitude : int

        layer_type : CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WeatherLayer
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather_layers.create_weather_layer(
            name="name",
            weather_model_id="weather_model_id",
            variable="variable",
            altitude=1,
            layer_type="raster",
        )
        """
        _response = self._raw_client.create_weather_layer(
            name=name,
            weather_model_id=weather_model_id,
            variable=variable,
            altitude=altitude,
            layer_type=layer_type,
            run_hour=run_hour,
            run_day=run_day,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    def get_weather_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WeatherLayer:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WeatherLayer
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather_layers.get_weather_layer(
            layer_id="layer_id",
        )
        """
        _response = self._raw_client.get_weather_layer(layer_id, request_options=request_options)
        return _response.data

    def update_weather_layer(
        self,
        layer_id: str,
        *,
        name: str,
        weather_model_id: str,
        variable: str,
        altitude: int,
        layer_type: UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WeatherLayer:
        """
        Parameters
        ----------
        layer_id : str

        name : str

        weather_model_id : str

        variable : str

        altitude : int

        layer_type : UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WeatherLayer
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather_layers.update_weather_layer(
            layer_id="layer_id",
            name="name",
            weather_model_id="weather_model_id",
            variable="variable",
            altitude=1,
            layer_type="raster",
        )
        """
        _response = self._raw_client.update_weather_layer(
            layer_id,
            name=name,
            weather_model_id=weather_model_id,
            variable=variable,
            altitude=altitude,
            layer_type=layer_type,
            run_hour=run_hour,
            run_day=run_day,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    def delete_weather_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from rebase_dashboard import RebaseDashboardApi

        client = RebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )
        client.weather_layers.delete_weather_layer(
            layer_id="layer_id",
        )
        """
        _response = self._raw_client.delete_weather_layer(layer_id, request_options=request_options)
        return _response.data


class AsyncWeatherLayersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWeatherLayersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWeatherLayersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWeatherLayersClient
        """
        return self._raw_client

    async def list_weather_layers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[WeatherLayer]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[WeatherLayer]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather_layers.list_weather_layers()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_weather_layers(request_options=request_options)
        return _response.data

    async def create_weather_layer(
        self,
        *,
        name: str,
        weather_model_id: str,
        variable: str,
        altitude: int,
        layer_type: CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WeatherLayer:
        """
        Parameters
        ----------
        name : str

        weather_model_id : str

        variable : str

        altitude : int

        layer_type : CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WeatherLayer
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather_layers.create_weather_layer(
                name="name",
                weather_model_id="weather_model_id",
                variable="variable",
                altitude=1,
                layer_type="raster",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_weather_layer(
            name=name,
            weather_model_id=weather_model_id,
            variable=variable,
            altitude=altitude,
            layer_type=layer_type,
            run_hour=run_hour,
            run_day=run_day,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    async def get_weather_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WeatherLayer:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WeatherLayer
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather_layers.get_weather_layer(
                layer_id="layer_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_weather_layer(layer_id, request_options=request_options)
        return _response.data

    async def update_weather_layer(
        self,
        layer_id: str,
        *,
        name: str,
        weather_model_id: str,
        variable: str,
        altitude: int,
        layer_type: UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WeatherLayer:
        """
        Parameters
        ----------
        layer_id : str

        name : str

        weather_model_id : str

        variable : str

        altitude : int

        layer_type : UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WeatherLayer
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather_layers.update_weather_layer(
                layer_id="layer_id",
                name="name",
                weather_model_id="weather_model_id",
                variable="variable",
                altitude=1,
                layer_type="raster",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_weather_layer(
            layer_id,
            name=name,
            weather_model_id=weather_model_id,
            variable=variable,
            altitude=altitude,
            layer_type=layer_type,
            run_hour=run_hour,
            run_day=run_day,
            deckgl_props=deckgl_props,
            ui_config=ui_config,
            request_options=request_options,
        )
        return _response.data

    async def delete_weather_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from rebase_dashboard import AsyncRebaseDashboardApi

        client = AsyncRebaseDashboardApi(
            token="YOUR_TOKEN",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.weather_layers.delete_weather_layer(
                layer_id="layer_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_weather_layer(layer_id, request_options=request_options)
        return _response.data
