# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.ui_config import UiConfig
from ..types.weather_layer import WeatherLayer
from .types.create_weather_layer_api_v_1_dashboard_weather_layers_post_request_layer_type import (
    CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType,
)
from .types.update_weather_layer_api_v_1_dashboard_weather_layers_layer_id_put_request_layer_type import (
    UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawWeatherLayersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_weather_layers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[WeatherLayer]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[WeatherLayer]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/weather-layers/",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[WeatherLayer],
                    parse_obj_as(
                        type_=typing.List[WeatherLayer],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_weather_layer(
        self,
        *,
        name: str,
        weather_model_id: str,
        variable: str,
        altitude: int,
        layer_type: CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WeatherLayer]:
        """
        Parameters
        ----------
        name : str

        weather_model_id : str

        variable : str

        altitude : int

        layer_type : CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WeatherLayer]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/weather-layers/",
            method="POST",
            params={
                "name": name,
                "weather_model_id": weather_model_id,
                "variable": variable,
                "altitude": altitude,
                "layer_type": layer_type,
                "run_hour": run_hour,
                "run_day": run_day,
            },
            json={
                "deckgl_props": deckgl_props,
                "ui_config": convert_and_respect_annotation_metadata(
                    object_=ui_config, annotation=UiConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WeatherLayer,
                    parse_obj_as(
                        type_=WeatherLayer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_weather_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WeatherLayer]:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WeatherLayer]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/weather-layers/{jsonable_encoder(layer_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WeatherLayer,
                    parse_obj_as(
                        type_=WeatherLayer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_weather_layer(
        self,
        layer_id: str,
        *,
        name: str,
        weather_model_id: str,
        variable: str,
        altitude: int,
        layer_type: UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WeatherLayer]:
        """
        Parameters
        ----------
        layer_id : str

        name : str

        weather_model_id : str

        variable : str

        altitude : int

        layer_type : UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WeatherLayer]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/weather-layers/{jsonable_encoder(layer_id)}",
            method="PUT",
            params={
                "name": name,
                "weather_model_id": weather_model_id,
                "variable": variable,
                "altitude": altitude,
                "layer_type": layer_type,
                "run_hour": run_hour,
                "run_day": run_day,
            },
            json={
                "deckgl_props": deckgl_props,
                "ui_config": convert_and_respect_annotation_metadata(
                    object_=ui_config, annotation=UiConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WeatherLayer,
                    parse_obj_as(
                        type_=WeatherLayer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_weather_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/weather-layers/{jsonable_encoder(layer_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawWeatherLayersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_weather_layers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[WeatherLayer]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[WeatherLayer]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/weather-layers/",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[WeatherLayer],
                    parse_obj_as(
                        type_=typing.List[WeatherLayer],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_weather_layer(
        self,
        *,
        name: str,
        weather_model_id: str,
        variable: str,
        altitude: int,
        layer_type: CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WeatherLayer]:
        """
        Parameters
        ----------
        name : str

        weather_model_id : str

        variable : str

        altitude : int

        layer_type : CreateWeatherLayerApiV1DashboardWeatherLayersPostRequestLayerType

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WeatherLayer]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/dashboard/weather-layers/",
            method="POST",
            params={
                "name": name,
                "weather_model_id": weather_model_id,
                "variable": variable,
                "altitude": altitude,
                "layer_type": layer_type,
                "run_hour": run_hour,
                "run_day": run_day,
            },
            json={
                "deckgl_props": deckgl_props,
                "ui_config": convert_and_respect_annotation_metadata(
                    object_=ui_config, annotation=UiConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WeatherLayer,
                    parse_obj_as(
                        type_=WeatherLayer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_weather_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WeatherLayer]:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WeatherLayer]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/weather-layers/{jsonable_encoder(layer_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WeatherLayer,
                    parse_obj_as(
                        type_=WeatherLayer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_weather_layer(
        self,
        layer_id: str,
        *,
        name: str,
        weather_model_id: str,
        variable: str,
        altitude: int,
        layer_type: UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType,
        run_hour: typing.Optional[int] = None,
        run_day: typing.Optional[str] = None,
        deckgl_props: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ui_config: typing.Optional[UiConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WeatherLayer]:
        """
        Parameters
        ----------
        layer_id : str

        name : str

        weather_model_id : str

        variable : str

        altitude : int

        layer_type : UpdateWeatherLayerApiV1DashboardWeatherLayersLayerIdPutRequestLayerType

        run_hour : typing.Optional[int]

        run_day : typing.Optional[str]

        deckgl_props : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]

        ui_config : typing.Optional[UiConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WeatherLayer]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/weather-layers/{jsonable_encoder(layer_id)}",
            method="PUT",
            params={
                "name": name,
                "weather_model_id": weather_model_id,
                "variable": variable,
                "altitude": altitude,
                "layer_type": layer_type,
                "run_hour": run_hour,
                "run_day": run_day,
            },
            json={
                "deckgl_props": deckgl_props,
                "ui_config": convert_and_respect_annotation_metadata(
                    object_=ui_config, annotation=UiConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WeatherLayer,
                    parse_obj_as(
                        type_=WeatherLayer,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_weather_layer(
        self, layer_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        layer_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/dashboard/weather-layers/{jsonable_encoder(layer_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
