<h1 align="center">
  <img src="https://e-dyn.github.io/gloria/_static/glorialogo.png" alt="Gloria Logo" style="width:70%;">
</h1><br>

![Static Badge](https://img.shields.io/badge/python-3.9%20%7C%203.10%20%7C%203.11%20%7C%203.12-blue)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Linting: Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/charliermarsh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff)
[![Checked with mypy](https://www.mypy-lang.org/static/mypy_badge.svg)](https://mypy-lang.org/)
[![Pydantic v2](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/pydantic/pydantic/main/docs/badge/v2.json)](https://docs.pydantic.dev/latest/contributing/#badges)

Gloria is a modern open-source framework for time series analysis and forecasting, designed for the demands of complex, real-world data. It combines robust statistical modeling with flexible controls and full transparency to enable trustworthy forecasting.

## Key Features

* **Distributional Flexibility**: Go beyond the normal distribution and model count data (Poisson, Binomial, Negative Binomial, Beta-Binomial), bounded rates (Beta), or non-negative floats (Gamma) natively
* **Any Time Grid**: Gloria handles arbitrary sampling intervals (not just daily)
* **Rich Event Modeling**: Parametric and extensible event library to handle holidays, campaigns, or maintenance windows - any event, any shape, for realistic impacts and reduced overfitting.
* **Fully Explainable**: Gloria's models are explicit, fully documented, and always inspectable.
* **Modern Python Stack**: Type hints, pydantic for validation, and a clean API design reminiscent of [Prophet](https://facebook.github.io/prophet/) but with a much more maintainable and extensible codebase.

## Important Links
* **Documentation**: https://e-dyn.github.io/gloria/
* **Installation**: https://e-dyn.github.io/gloria/get_started/installation.html
* **Source Code**: https://github.com/e-dyn/gloria
* **Bug Reports and Feature Requests**: https://github.com/e-dyn/gloria/issues
* **License**: [MIT](https://github.com/e-dyn/gloria/blob/main/LICENSE)


