"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupableResourcesCollector = void 0;
const dynamodb = require("@aws-cdk/aws-dynamodb");
const ec2 = require("@aws-cdk/aws-ec2");
const efs = require("@aws-cdk/aws-efs");
const rds = require("@aws-cdk/aws-rds");
const core_1 = require("@aws-cdk/core");
class BackupableResourcesCollector {
    constructor() {
        this.resources = [];
    }
    visit(node) {
        if (node instanceof efs.CfnFileSystem) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'elasticfilesystem',
                resource: 'file-system',
                resourceName: node.ref,
            }));
        }
        if (node instanceof dynamodb.CfnTable) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'dynamodb',
                resource: 'table',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnInstance) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'instance',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnVolume) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'volume',
                resourceName: node.ref,
            }));
        }
        if (node instanceof rds.CfnDBInstance) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'rds',
                resource: 'db',
                sep: ':',
                resourceName: node.ref,
            }));
        }
    }
}
exports.BackupableResourcesCollector = BackupableResourcesCollector;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFja3VwYWJsZS1yZXNvdXJjZXMtY29sbGVjdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYmFja3VwYWJsZS1yZXNvdXJjZXMtY29sbGVjdG9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGtEQUFrRDtBQUNsRCx3Q0FBd0M7QUFDeEMsd0NBQXdDO0FBQ3hDLHdDQUF3QztBQUN4Qyx3Q0FBMkQ7QUFFM0QsTUFBYSw0QkFBNEI7SUFBekM7UUFDa0IsY0FBUyxHQUFhLEVBQUUsQ0FBQztJQTRDM0MsQ0FBQztJQTFDUSxLQUFLLENBQUMsSUFBZ0I7UUFDM0IsSUFBSSxJQUFJLFlBQVksR0FBRyxDQUFDLGFBQWEsRUFBRTtZQUNyQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxZQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsQ0FBQztnQkFDM0MsT0FBTyxFQUFFLG1CQUFtQjtnQkFDNUIsUUFBUSxFQUFFLGFBQWE7Z0JBQ3ZCLFlBQVksRUFBRSxJQUFJLENBQUMsR0FBRzthQUN2QixDQUFDLENBQUMsQ0FBQztTQUNMO1FBRUQsSUFBSSxJQUFJLFlBQVksUUFBUSxDQUFDLFFBQVEsRUFBRTtZQUNyQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxZQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLFNBQVMsQ0FBQztnQkFDM0MsT0FBTyxFQUFFLFVBQVU7Z0JBQ25CLFFBQVEsRUFBRSxPQUFPO2dCQUNqQixZQUFZLEVBQUUsSUFBSSxDQUFDLEdBQUc7YUFDdkIsQ0FBQyxDQUFDLENBQUM7U0FDTDtRQUVELElBQUksSUFBSSxZQUFZLEdBQUcsQ0FBQyxXQUFXLEVBQUU7WUFDbkMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7Z0JBQzNDLE9BQU8sRUFBRSxLQUFLO2dCQUNkLFFBQVEsRUFBRSxVQUFVO2dCQUNwQixZQUFZLEVBQUUsSUFBSSxDQUFDLEdBQUc7YUFDdkIsQ0FBQyxDQUFDLENBQUM7U0FDTDtRQUVELElBQUksSUFBSSxZQUFZLEdBQUcsQ0FBQyxTQUFTLEVBQUU7WUFDakMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7Z0JBQzNDLE9BQU8sRUFBRSxLQUFLO2dCQUNkLFFBQVEsRUFBRSxRQUFRO2dCQUNsQixZQUFZLEVBQUUsSUFBSSxDQUFDLEdBQUc7YUFDdkIsQ0FBQyxDQUFDLENBQUM7U0FDTDtRQUVELElBQUksSUFBSSxZQUFZLEdBQUcsQ0FBQyxhQUFhLEVBQUU7WUFDckMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsWUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxTQUFTLENBQUM7Z0JBQzNDLE9BQU8sRUFBRSxLQUFLO2dCQUNkLFFBQVEsRUFBRSxJQUFJO2dCQUNkLEdBQUcsRUFBRSxHQUFHO2dCQUNSLFlBQVksRUFBRSxJQUFJLENBQUMsR0FBRzthQUN2QixDQUFDLENBQUMsQ0FBQztTQUNMO0lBQ0gsQ0FBQztDQUNGO0FBN0NELG9FQTZDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGR5bmFtb2RiIGZyb20gJ0Bhd3MtY2RrL2F3cy1keW5hbW9kYic7XG5pbXBvcnQgKiBhcyBlYzIgZnJvbSAnQGF3cy1jZGsvYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBlZnMgZnJvbSAnQGF3cy1jZGsvYXdzLWVmcyc7XG5pbXBvcnQgKiBhcyByZHMgZnJvbSAnQGF3cy1jZGsvYXdzLXJkcyc7XG5pbXBvcnQgeyBJQXNwZWN0LCBJQ29uc3RydWN0LCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5leHBvcnQgY2xhc3MgQmFja3VwYWJsZVJlc291cmNlc0NvbGxlY3RvciBpbXBsZW1lbnRzIElBc3BlY3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgcmVzb3VyY2VzOiBzdHJpbmdbXSA9IFtdO1xuXG4gIHB1YmxpYyB2aXNpdChub2RlOiBJQ29uc3RydWN0KSB7XG4gICAgaWYgKG5vZGUgaW5zdGFuY2VvZiBlZnMuQ2ZuRmlsZVN5c3RlbSkge1xuICAgICAgdGhpcy5yZXNvdXJjZXMucHVzaChTdGFjay5vZihub2RlKS5mb3JtYXRBcm4oe1xuICAgICAgICBzZXJ2aWNlOiAnZWxhc3RpY2ZpbGVzeXN0ZW0nLFxuICAgICAgICByZXNvdXJjZTogJ2ZpbGUtc3lzdGVtJyxcbiAgICAgICAgcmVzb3VyY2VOYW1lOiBub2RlLnJlZixcbiAgICAgIH0pKTtcbiAgICB9XG5cbiAgICBpZiAobm9kZSBpbnN0YW5jZW9mIGR5bmFtb2RiLkNmblRhYmxlKSB7XG4gICAgICB0aGlzLnJlc291cmNlcy5wdXNoKFN0YWNrLm9mKG5vZGUpLmZvcm1hdEFybih7XG4gICAgICAgIHNlcnZpY2U6ICdkeW5hbW9kYicsXG4gICAgICAgIHJlc291cmNlOiAndGFibGUnLFxuICAgICAgICByZXNvdXJjZU5hbWU6IG5vZGUucmVmLFxuICAgICAgfSkpO1xuICAgIH1cblxuICAgIGlmIChub2RlIGluc3RhbmNlb2YgZWMyLkNmbkluc3RhbmNlKSB7XG4gICAgICB0aGlzLnJlc291cmNlcy5wdXNoKFN0YWNrLm9mKG5vZGUpLmZvcm1hdEFybih7XG4gICAgICAgIHNlcnZpY2U6ICdlYzInLFxuICAgICAgICByZXNvdXJjZTogJ2luc3RhbmNlJyxcbiAgICAgICAgcmVzb3VyY2VOYW1lOiBub2RlLnJlZixcbiAgICAgIH0pKTtcbiAgICB9XG5cbiAgICBpZiAobm9kZSBpbnN0YW5jZW9mIGVjMi5DZm5Wb2x1bWUpIHtcbiAgICAgIHRoaXMucmVzb3VyY2VzLnB1c2goU3RhY2sub2Yobm9kZSkuZm9ybWF0QXJuKHtcbiAgICAgICAgc2VydmljZTogJ2VjMicsXG4gICAgICAgIHJlc291cmNlOiAndm9sdW1lJyxcbiAgICAgICAgcmVzb3VyY2VOYW1lOiBub2RlLnJlZixcbiAgICAgIH0pKTtcbiAgICB9XG5cbiAgICBpZiAobm9kZSBpbnN0YW5jZW9mIHJkcy5DZm5EQkluc3RhbmNlKSB7XG4gICAgICB0aGlzLnJlc291cmNlcy5wdXNoKFN0YWNrLm9mKG5vZGUpLmZvcm1hdEFybih7XG4gICAgICAgIHNlcnZpY2U6ICdyZHMnLFxuICAgICAgICByZXNvdXJjZTogJ2RiJyxcbiAgICAgICAgc2VwOiAnOicsXG4gICAgICAgIHJlc291cmNlTmFtZTogbm9kZS5yZWYsXG4gICAgICB9KSk7XG4gICAgfVxuICB9XG59XG4iXX0=