import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [amplifyuibuilder](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyuibuilder.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Amplifyuibuilder extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [amplifyuibuilder](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyuibuilder.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a component
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_CreateComponent.html
     */
    toCreateComponent(): this;
    /**
     * Grants permission to create a form
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_CreateForm.html
     */
    toCreateForm(): this;
    /**
     * Grants permission to create a theme
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_CreateTheme.html
     */
    toCreateTheme(): this;
    /**
     * Grants permission to delete a component
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_DeleteComponent.html
     */
    toDeleteComponent(): this;
    /**
     * Grants permission to delete a form
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_DeleteForm.html
     */
    toDeleteForm(): this;
    /**
     * Grants permission to delete a theme
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_DeleteTheme.html
     */
    toDeleteTheme(): this;
    /**
     * Grants permission to export components
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ExportComponents.html
     */
    toExportComponents(): this;
    /**
     * Grants permission to export forms
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ExportForms.html
     */
    toExportForms(): this;
    /**
     * Grants permission to export themes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ExportThemes.html
     */
    toExportThemes(): this;
    /**
     * Grants permission to get an existing component
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_GetComponent.html
     */
    toGetComponent(): this;
    /**
     * Grants permission to get an existing form
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_GetForm.html
     */
    toGetForm(): this;
    /**
     * Grants permission to get an existing metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_GetMetadata.html
     */
    toGetMetadata(): this;
    /**
     * Grants permission to get an existing theme
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_GetTheme.html
     */
    toGetTheme(): this;
    /**
     * Grants permission to list components
     *
     * Access Level: List
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ListComponents.html
     */
    toListComponents(): this;
    /**
     * Grants permission to list forms
     *
     * Access Level: List
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ListForms.html
     */
    toListForms(): this;
    /**
     * Grants permission to list themes
     *
     * Access Level: List
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ListThemes.html
     */
    toListThemes(): this;
    /**
     * Grants permission to put an existing metadata
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_PutMetadataFlag.html
     */
    toPutMetadataFlag(): this;
    /**
     * Grants permission to reset an existing metadata
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_ResetMetadataFlag.html
     */
    toResetMetadataFlag(): this;
    /**
     * Grants permission to update a component
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_UpdateComponent.html
     */
    toUpdateComponent(): this;
    /**
     * Grants permission to update a form
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_UpdateForm.html
     */
    toUpdateForm(): this;
    /**
     * Grants permission to update a theme
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - amplify:GetApp
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_UpdateTheme.html
     */
    toUpdateTheme(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ComponentResource to the statement
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Component.html
     *
     * @param appId - Identifier for the appId.
     * @param environmentName - Identifier for the environmentName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifComponentResourceAppId()
     * - .ifComponentResourceEnvironmentName()
     * - .ifComponentResourceId()
     * - .ifAwsResourceTag()
     */
    onComponentResource(appId: string, environmentName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type FormResource to the statement
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Form.html
     *
     * @param appId - Identifier for the appId.
     * @param environmentName - Identifier for the environmentName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifFormResourceAppId()
     * - .ifFormResourceEnvironmentName()
     * - .ifFormResourceId()
     * - .ifAwsResourceTag()
     */
    onFormResource(appId: string, environmentName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ThemeResource to the statement
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Theme.html
     *
     * @param appId - Identifier for the appId.
     * @param environmentName - Identifier for the environmentName.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifThemeResourceAppId()
     * - .ifThemeResourceEnvironmentName()
     * - .ifThemeResourceId()
     * - .ifAwsResourceTag()
     */
    onThemeResource(appId: string, environmentName: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the app ID
     *
     * https://docs.aws.amazon.com/amplify/latest/APIReference/API_App.html
     *
     * Applies to resource types:
     * - ComponentResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifComponentResourceAppId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the backend environment name
     *
     * https://docs.aws.amazon.com/amplify/latest/APIReference/API_BackendEnvironment.html
     *
     * Applies to resource types:
     * - ComponentResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifComponentResourceEnvironmentName(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the component ID
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Component.html
     *
     * Applies to resource types:
     * - ComponentResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifComponentResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the app ID
     *
     * https://docs.aws.amazon.com/amplify/latest/APIReference/API_App.html
     *
     * Applies to resource types:
     * - FormResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifFormResourceAppId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the backend environment name
     *
     * https://docs.aws.amazon.com/amplify/latest/APIReference/API_BackendEnvironment.html
     *
     * Applies to resource types:
     * - FormResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifFormResourceEnvironmentName(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the form ID
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Form.html
     *
     * Applies to resource types:
     * - FormResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifFormResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the app ID
     *
     * https://docs.aws.amazon.com/amplify/latest/APIReference/API_App.html
     *
     * Applies to resource types:
     * - ThemeResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifThemeResourceAppId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the backend environment name
     *
     * https://docs.aws.amazon.com/amplify/latest/APIReference/API_BackendEnvironment.html
     *
     * Applies to resource types:
     * - ThemeResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifThemeResourceEnvironmentName(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the theme ID
     *
     * https://docs.aws.amazon.com/amplifyuibuilder/latest/APIReference/API_Theme.html
     *
     * Applies to resource types:
     * - ThemeResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifThemeResourceId(value: string | string[], operator?: Operator | string): this;
}
