import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [apprunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapprunner.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Apprunner extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [apprunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsapprunner.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to associate your own domain name with the AWS App Runner subdomain URL of your App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_AssociateCustomDomain.html
     */
    toAssociateCustomDomain(): this;
    /**
     * Grants permission to associate the service with an AWS WAF web ACL
     *
     * Access Level: Write
     */
    toAssociateWebAcl(): this;
    /**
     * Grants permission to create an AWS App Runner automatic scaling configuration resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateAutoScalingConfiguration.html
     */
    toCreateAutoScalingConfiguration(): this;
    /**
     * Grants permission to create an AWS App Runner connection resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateConnection.html
     */
    toCreateConnection(): this;
    /**
     * Grants permission to create an AWS App Runner observability configuration resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateObservabilityConfiguration.html
     */
    toCreateObservabilityConfiguration(): this;
    /**
     * Grants permission to create an AWS App Runner service resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifConnectionArn()
     * - .ifAutoScalingConfigurationArn()
     * - .ifObservabilityConfigurationArn()
     * - .ifVpcConnectorArn()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html
     */
    toCreateService(): this;
    /**
     * Grants permission to create an AWS App Runner VPC connector resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateVpcConnector.html
     */
    toCreateVpcConnector(): this;
    /**
     * Grants permission to create an AWS App Runner VpcIngressConnection resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifServiceArn()
     * - .ifVpcId()
     * - .ifVpcEndpointId()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_CreateVpcIngressConnection.html
     */
    toCreateVpcIngressConnection(): this;
    /**
     * Grants permission to delete an AWS App Runner automatic scaling configuration resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteAutoScalingConfiguration.html
     */
    toDeleteAutoScalingConfiguration(): this;
    /**
     * Grants permission to delete an AWS App Runner connection resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteConnection.html
     */
    toDeleteConnection(): this;
    /**
     * Grants permission to delete an AWS App Runner observability configuration resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteObservabilityConfiguration.html
     */
    toDeleteObservabilityConfiguration(): this;
    /**
     * Grants permission to delete an AWS App Runner service resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html
     */
    toDeleteService(): this;
    /**
     * Grants permission to delete an AWS App Runner VPC connector resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteVpcConnector.html
     */
    toDeleteVpcConnector(): this;
    /**
     * Grants permission to delete an AWS App Runner VpcIngressConnection resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteVpcIngressConnection.html
     */
    toDeleteVpcIngressConnection(): this;
    /**
     * Grants permission to retrieve the description of an AWS App Runner automatic scaling configuration resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeAutoScalingConfiguration.html
     */
    toDescribeAutoScalingConfiguration(): this;
    /**
     * Grants permission to retrieve descriptions of custom domain names associated with an AWS App Runner service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeCustomDomains.html
     */
    toDescribeCustomDomains(): this;
    /**
     * Grants permission to retrieve the description of an AWS App Runner observability configuration resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeObservabilityConfiguration.html
     */
    toDescribeObservabilityConfiguration(): this;
    /**
     * Grants permission to retrieve the description of an operation that occurred on an AWS App Runner service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeOperation.html
     */
    toDescribeOperation(): this;
    /**
     * Grants permission to retrieve the description of an AWS App Runner service resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html
     */
    toDescribeService(): this;
    /**
     * Grants permission to retrieve the description of an AWS App Runner VPC connector resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeVpcConnector.html
     */
    toDescribeVpcConnector(): this;
    /**
     * Grants permission to retrieve the description of an AWS App Runner VpcIngressConnection resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeVpcIngressConnection.html
     */
    toDescribeVpcIngressConnection(): this;
    /**
     * Grants permission to get the AWS WAF web ACL that is associated with an AWS App Runner service
     *
     * Access Level: Read
     */
    toDescribeWebAclForService(): this;
    /**
     * Grants permission to disassociate a custom domain name from an AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_DisassociateCustomDomain.html
     */
    toDisassociateCustomDomain(): this;
    /**
     * Grants permission to disassociate the service with an AWS WAF web ACL
     *
     * Access Level: Write
     */
    toDisassociateWebAcl(): this;
    /**
     * Grants permission to list the services that are associated with an AWS WAF web ACL
     *
     * Access Level: List
     */
    toListAssociatedServicesForWebAcl(): this;
    /**
     * Grants permission to retrieve a list of AWS App Runner automatic scaling configurations in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListAutoScalingConfigurations.html
     */
    toListAutoScalingConfigurations(): this;
    /**
     * Grants permission to retrieve a list of AWS App Runner connections in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListConnections.html
     */
    toListConnections(): this;
    /**
     * Grants permission to retrieve a list of AWS App Runner observability configurations in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListObservabilityConfigurations.html
     */
    toListObservabilityConfigurations(): this;
    /**
     * Grants permission to retrieve a list of operations that occurred on an AWS App Runner service resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html
     */
    toListOperations(): this;
    /**
     * Grants permission to retrieve a list of running AWS App Runner services in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html
     */
    toListServices(): this;
    /**
     * Grants permission to list tags associated with an AWS App Runner resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to retrieve a list of AWS App Runner VPC connectors in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListVpcConnectors.html
     */
    toListVpcConnectors(): this;
    /**
     * Grants permission to retrieve a list of AWS App Runner VpcIngressConnections in your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ListVpcConnections.html
     */
    toListVpcIngressConnections(): this;
    /**
     * Grants permission to pause an active AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_PauseService.html
     */
    toPauseService(): this;
    /**
     * Grants permission to resume an active AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_ResumeService.html
     */
    toResumeService(): this;
    /**
     * Grants permission to initiate a manual deployemnt to an AWS App Runner service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_StartDeployment.html
     */
    toStartDeployment(): this;
    /**
     * Grants permission to add tags to, or update tag values of, an AWS App Runner resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from an AWS App Runner resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an AWS App Runner service resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifConnectionArn()
     * - .ifAutoScalingConfigurationArn()
     * - .ifObservabilityConfigurationArn()
     * - .ifVpcConnectorArn()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UpdateService.html
     */
    toUpdateService(): this;
    /**
     * Grants permission to update an AWS App Runner VpcIngressConnection resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifVpcId()
     * - .ifVpcEndpointId()
     *
     * https://docs.aws.amazon.com/apprunner/latest/api/API_UpdateVpcIngressConnection.html
     */
    toUpdateVpcIngressConnection(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type service to the statement
     *
     * @param serviceName - Identifier for the serviceName.
     * @param serviceId - Identifier for the serviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onService(serviceName: string, serviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type connection to the statement
     *
     * @param connectionName - Identifier for the connectionName.
     * @param connectionId - Identifier for the connectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnection(connectionName: string, connectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type autoscalingconfiguration to the statement
     *
     * @param autoscalingConfigurationName - Identifier for the autoscalingConfigurationName.
     * @param autoscalingConfigurationVersion - Identifier for the autoscalingConfigurationVersion.
     * @param autoscalingConfigurationId - Identifier for the autoscalingConfigurationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAutoscalingconfiguration(autoscalingConfigurationName: string, autoscalingConfigurationVersion: string, autoscalingConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type observabilityconfiguration to the statement
     *
     * @param observabilityConfigurationName - Identifier for the observabilityConfigurationName.
     * @param observabilityConfigurationVersion - Identifier for the observabilityConfigurationVersion.
     * @param observabilityConfigurationId - Identifier for the observabilityConfigurationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onObservabilityconfiguration(observabilityConfigurationName: string, observabilityConfigurationVersion: string, observabilityConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpcconnector to the statement
     *
     * @param vpcConnectorName - Identifier for the vpcConnectorName.
     * @param vpcConnectorVersion - Identifier for the vpcConnectorVersion.
     * @param vpcConnectorId - Identifier for the vpcConnectorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVpcconnector(vpcConnectorName: string, vpcConnectorVersion: string, vpcConnectorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vpcingressconnection to the statement
     *
     * @param vpcIngressConnectionName - Identifier for the vpcIngressConnectionName.
     * @param vpcIngressConnectionId - Identifier for the vpcIngressConnectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVpcingressconnection(vpcIngressConnectionName: string, vpcIngressConnectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type webacl to the statement
     *
     * @param scope - Identifier for the scope.
     * @param name - Identifier for the name.
     * @param id - Identifier for the id.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWebacl(scope: string, name: string, id: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated AutoScalingConfiguration resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifAutoScalingConfigurationArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated Connection resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifConnectionArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated ObservabilityConfiguration resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifObservabilityConfigurationArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the CreateVpcIngressConnection action based on the ARN of an associated Service resource
     *
     * Applies to actions:
     * - .toCreateVpcIngressConnection()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifServiceArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the CreateService and UpdateService actions based on the ARN of an associated VpcConnector resource
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toUpdateService()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifVpcConnectorArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the CreateVpcIngressConnection and UpdateVpcIngressConnection actions based on the VPC Endpoint in the request
     *
     * Applies to actions:
     * - .toCreateVpcIngressConnection()
     * - .toUpdateVpcIngressConnection()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcEndpointId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the CreateVpcIngressConnection and UpdateVpcIngressConnection actions based on the VPC in the request
     *
     * Applies to actions:
     * - .toCreateVpcIngressConnection()
     * - .toUpdateVpcIngressConnection()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcId(value: string | string[], operator?: Operator | string): this;
}
