import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [backup-storage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackupstorage.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class BackupStorage extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [backup-storage](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackupstorage.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to commit backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toCommitBackupJob(): this;
    /**
     * Grants permission to delete objects
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toDeleteObjects(): this;
    /**
     * Grants permission to describe backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toDescribeBackupJob(): this;
    /**
     * Grants permission to get base backup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toGetBaseBackup(): this;
    /**
     * Grants permission to get data from a recovery point for a restore job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toGetChunk(): this;
    /**
     * Grants permission to get incremental base backup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toGetIncrementalBaseBackup(): this;
    /**
     * Grants permission to get metadata from a recovery point for a restore job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toGetObjectMetadata(): this;
    /**
     * Grants permission to list data from a recovery point for a restore job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toListChunks(): this;
    /**
     * Grants permission to list data from a recovery point for a restore job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toListObjects(): this;
    /**
     * Associates a KMS key to a backup vault
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateBackupVault.html
     */
    toMountCapsule(): this;
    /**
     * Grants permission to mark an uploaded data as completed for a backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toNotifyObjectComplete(): this;
    /**
     * Grants permission to upload data to an AWS Backup-managed recovery point for a backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toPutChunk(): this;
    /**
     * Grants permission to put object
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toPutObject(): this;
    /**
     * Grants permission to upload data to an AWS Backup-managed recovery point for a backup job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toStartObject(): this;
    /**
     * Grants permission to update object complete
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-data-transfer.html
     */
    toUpdateObjectComplete(): this;
    protected accessLevelList: AccessLevelList;
}
