import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [chatbot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Chatbot extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [chatbot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an AWS Chatbot Chime Webhook Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toCreateChimeWebhookConfiguration(): this;
    /**
     * Grants permission to create an AWS Chatbot Microsoft Teams Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toCreateMicrosoftTeamsChannelConfiguration(): this;
    /**
     * Grants permission to create an AWS Chatbot Slack Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toCreateSlackChannelConfiguration(): this;
    /**
     * Grants permission to delete an AWS Chatbot Chime Webhook Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteChimeWebhookConfiguration(): this;
    /**
     * Grants permission to delete an AWS Chatbot Microsoft Teams Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteMicrosoftTeamsChannelConfiguration(): this;
    /**
     * Grants permission to delete the Microsoft Teams configured with AWS Chatbot in an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteMicrosoftTeamsConfiguredTeam(): this;
    /**
     * Grants permission to delete an AWS Chatbot Microsoft Teams User Identity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteMicrosoftTeamsUserIdentity(): this;
    /**
     * Grants permission to delete an AWS Chatbot Slack Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteSlackChannelConfiguration(): this;
    /**
     * Grants permission to delete an AWS Chatbot Slack User Identity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteSlackUserIdentity(): this;
    /**
     * Grants permission to delete the Slack workspace authorization with AWS Chatbot, associated with an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteSlackWorkspaceAuthorization(): this;
    /**
     * Grants permission to list all AWS Chatbot Chime Webhook Configurations in an AWS Account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeChimeWebhookConfigurations(): this;
    /**
     * Grants permission to list all AWS Chatbot Slack Channel Configurations in an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeSlackChannelConfigurations(): this;
    /**
     * Grants permission to list all public Slack channels in the Slack workspace connected to the AWS Account onboarded with AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeSlackChannels(): this;
    /**
     * Grants permission to describe AWS Chatbot Slack User Identities
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeSlackUserIdentities(): this;
    /**
     * Grants permission to list all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeSlackWorkspaces(): this;
    /**
     * Grants permission to retrieve AWS Chatbot account preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toGetAccountPreferences(): this;
    /**
     * Grants permission to get a single AWS Chatbot Microsoft Teams Channel Configurations in an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toGetMicrosoftTeamsChannelConfiguration(): this;
    /**
     * Grants permission to generate OAuth parameters to request Microsoft Teams OAuth code to be used by the AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toGetMicrosoftTeamsOauthParameters(): this;
    /**
     * Grants permission to generate OAuth parameters to request Slack OAuth code to be used by the AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toGetSlackOauthParameters(): this;
    /**
     * Grants permission to list all AWS Chatbot Microsoft Teams Channel Configurations in an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toListMicrosoftTeamsChannelConfigurations(): this;
    /**
     * Grants permission to list all Microsoft Teams connected to the AWS Account onboarded with AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toListMicrosoftTeamsConfiguredTeams(): this;
    /**
     * Grants permission to describe AWS Chatbot Microsoft Teams User Identities
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toListMicrosoftTeamsUserIdentities(): this;
    /**
     * Grants permission to redeem previously generated parameters with Microsoft APIs, to acquire OAuth tokens to be used by the AWS Chatbot service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toRedeemMicrosoftTeamsOauthCode(): this;
    /**
     * Grants permission to redeem previously generated parameters with Slack API, to acquire OAuth tokens to be used by the AWS Chatbot service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toRedeemSlackOauthCode(): this;
    /**
     * Grants permission to update AWS Chatbot account preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toUpdateAccountPreferences(): this;
    /**
     * Grants permission to update an AWS Chatbot Chime Webhook Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toUpdateChimeWebhookConfiguration(): this;
    /**
     * Grants permission to update an AWS Chatbot Microsoft Teams Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toUpdateMicrosoftTeamsChannelConfiguration(): this;
    /**
     * Grants permission to update an AWS Chatbot Slack Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toUpdateSlackChannelConfiguration(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ChatbotConfiguration to the statement
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     *
     * @param configurationType - Identifier for the configurationType.
     * @param chatbotConfigurationName - Identifier for the chatbotConfigurationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onChatbotConfiguration(configurationType: string, chatbotConfigurationName: string, account?: string, partition?: string): this;
}
