import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [codecatalyst](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodecatalyst.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Codecatalyst extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [codecatalyst](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodecatalyst.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to accept a request to connect this account to a CodeCatalyst space
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toAcceptConnection(): this;
    /**
     * Grants permission to associate an IAM role to a connection
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toAssociateIamRoleToConnection(): this;
    /**
     * Grants permission to delete a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toDeleteConnection(): this;
    /**
     * Grants permission to disassociate an IAM role from a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toDisassociateIamRoleFromConnection(): this;
    /**
     * Grants permission to describe the billing authorization for a connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toGetBillingAuthorization(): this;
    /**
     * Grants permission to get a connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toGetConnection(): this;
    /**
     * Grants permission to get a pending request to connect this account to a CodeCatalyst space
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toGetPendingConnection(): this;
    /**
     * Grants permission to list connections which are not pending
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toListConnections(): this;
    /**
     * Grants permission to list IAM roles associated with a connection
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toListIamRolesForConnection(): this;
    /**
     * Grants permission to creates or update the billing authorization for a connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toPutBillingAuthorization(): this;
    /**
     * Grants permission to reject a request to connect this account to a CodeCatalyst space
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     */
    toRejectConnection(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type connections to the statement
     *
     * https://docs.aws.amazon.com/codecatalyst/latest/userguide/#
     *
     * @param connectionId - Identifier for the connectionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConnections(connectionId: string, account?: string, region?: string, partition?: string): this;
}
