import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [codeguru-security](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodegurusecurity.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class CodeguruSecurity extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [codeguru-security](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncodegurusecurity.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to batch retrieve specific findings generated by CodeGuru Security
     *
     * Access Level: Read
     */
    toBatchGetFindings(): this;
    /**
     * Grants permission to create CodeGuru Security scan
     *
     * Access Level: Write
     */
    toCreateScan(): this;
    /**
     * Grants permission to generate a presigned url for uploading code archives
     *
     * Access Level: Write
     */
    toCreateUploadUrl(): this;
    /**
     * Grants permission to delete all the scans and related findings from CodeGuru Security by given category
     *
     * Access Level: Write
     */
    toDeleteScansByCategory(): this;
    /**
     * Grants permission to retrieve CodeGuru Security scan metadata
     *
     * Access Level: Read
     */
    toGetScan(): this;
    /**
     * Grants permission to retrieve findings generated by CodeGuru Security
     *
     * Access Level: List
     */
    toListFindings(): this;
    /**
     * Grants permission to retrieve list of CodeGuru Security scan metadata
     *
     * Access Level: List
     */
    toListScans(): this;
    /**
     * Grants permission to update the account level configurations
     *
     * Access Level: Write
     */
    toUpdateAccountConfiguration(): this;
    protected accessLevelList: AccessLevelList;
}
