"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeOptimizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscomputeoptimizer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ComputeOptimizer extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscomputeoptimizer.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'compute-optimizer';
        this.accessLevelList = {
            Write: [
                'DeleteRecommendationPreferences',
                'ExportAutoScalingGroupRecommendations',
                'ExportEBSVolumeRecommendations',
                'ExportEC2InstanceRecommendations',
                'ExportECSServiceRecommendations',
                'ExportLambdaFunctionRecommendations',
                'PutRecommendationPreferences',
                'UpdateEnrollmentStatus'
            ],
            List: [
                'DescribeRecommendationExportJobs',
                'GetAutoScalingGroupRecommendations',
                'GetEBSVolumeRecommendations',
                'GetEC2InstanceRecommendations',
                'GetEC2RecommendationProjectedMetrics',
                'GetECSServiceRecommendationProjectedMetrics',
                'GetECSServiceRecommendations',
                'GetEnrollmentStatus',
                'GetEnrollmentStatusesForOrganization',
                'GetLambdaFunctionRecommendations',
                'GetRecommendationSummaries'
            ],
            Read: [
                'GetEffectiveRecommendationPreferences',
                'GetRecommendationPreferences'
            ]
        };
    }
    /**
     * Grants permission to delete recommendation preferences
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceType()
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DeleteRecommendationPreferences.html
     */
    toDeleteRecommendationPreferences() {
        return this.to('DeleteRecommendationPreferences');
    }
    /**
     * Grants permission to view the status of recommendation export jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DescribeRecommendationExportJobs.html
     */
    toDescribeRecommendationExportJobs() {
        return this.to('DescribeRecommendationExportJobs');
    }
    /**
     * Grants permission to export AutoScaling group recommendations to S3 for the provided accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - compute-optimizer:GetAutoScalingGroupRecommendations
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportAutoScalingGroupRecommendations.html
     */
    toExportAutoScalingGroupRecommendations() {
        return this.to('ExportAutoScalingGroupRecommendations');
    }
    /**
     * Grants permission to export EBS volume recommendations to S3 for the provided accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetEBSVolumeRecommendations
     * - ec2:DescribeVolumes
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEBSVolumeRecommendations.html
     */
    toExportEBSVolumeRecommendations() {
        return this.to('ExportEBSVolumeRecommendations');
    }
    /**
     * Grants permission to export EC2 instance recommendations to S3 for the provided accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetEC2InstanceRecommendations
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEC2InstanceRecommendations.html
     */
    toExportEC2InstanceRecommendations() {
        return this.to('ExportEC2InstanceRecommendations');
    }
    /**
     * Grants permission to export ECS service recommendations to S3 for the provided accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetECSServiceRecommendations
     * - ecs:ListClusters
     * - ecs:ListServices
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportECSServiceRecommendations.html
     */
    toExportECSServiceRecommendations() {
        return this.to('ExportECSServiceRecommendations');
    }
    /**
     * Grants permission to export Lambda function recommendations to S3 for the provided accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetLambdaFunctionRecommendations
     * - lambda:ListFunctions
     * - lambda:ListProvisionedConcurrencyConfigs
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportLambdaFunctionRecommendations.html
     */
    toExportLambdaFunctionRecommendations() {
        return this.to('ExportLambdaFunctionRecommendations');
    }
    /**
     * Grants permission to get recommendations for the provided AutoScaling groups
     *
     * Access Level: List
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetAutoScalingGroupRecommendations.html
     */
    toGetAutoScalingGroupRecommendations() {
        return this.to('GetAutoScalingGroupRecommendations');
    }
    /**
     * Grants permission to get recommendations for the provided EBS volumes
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeVolumes
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEBSVolumeRecommendations.html
     */
    toGetEBSVolumeRecommendations() {
        return this.to('GetEBSVolumeRecommendations');
    }
    /**
     * Grants permission to get recommendations for the provided EC2 instances
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2InstanceRecommendations.html
     */
    toGetEC2InstanceRecommendations() {
        return this.to('GetEC2InstanceRecommendations');
    }
    /**
     * Grants permission to get the recommendation projected metrics of the specified instance
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2RecommendationProjectedMetrics.html
     */
    toGetEC2RecommendationProjectedMetrics() {
        return this.to('GetEC2RecommendationProjectedMetrics');
    }
    /**
     * Grants permission to get the recommendation projected metrics of the specified ECS service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetECSServiceRecommendationProjectedMetrics.html
     */
    toGetECSServiceRecommendationProjectedMetrics() {
        return this.to('GetECSServiceRecommendationProjectedMetrics');
    }
    /**
     * Grants permission to get recommendations for the provided ECS services
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ecs:ListClusters
     * - ecs:ListServices
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetECSServiceRecommendations.html
     */
    toGetECSServiceRecommendations() {
        return this.to('GetECSServiceRecommendations');
    }
    /**
     * Grants permission to get recommendation preferences that are in effect
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifResourceType()
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - autoscaling:DescribeAutoScalingInstances
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEffectiveRecommendationPreferences.html
     */
    toGetEffectiveRecommendationPreferences() {
        return this.to('GetEffectiveRecommendationPreferences');
    }
    /**
     * Grants permission to get the enrollment status for the specified account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatus.html
     */
    toGetEnrollmentStatus() {
        return this.to('GetEnrollmentStatus');
    }
    /**
     * Grants permission to get the enrollment statuses for member accounts of the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatusesForOrganization.html
     */
    toGetEnrollmentStatusesForOrganization() {
        return this.to('GetEnrollmentStatusesForOrganization');
    }
    /**
     * Grants permission to get recommendations for the provided Lambda functions
     *
     * Access Level: List
     *
     * Dependent actions:
     * - lambda:ListFunctions
     * - lambda:ListProvisionedConcurrencyConfigs
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetLambdaFunctionRecommendations.html
     */
    toGetLambdaFunctionRecommendations() {
        return this.to('GetLambdaFunctionRecommendations');
    }
    /**
     * Grants permission to get recommendation preferences
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifResourceType()
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationPreferences.html
     */
    toGetRecommendationPreferences() {
        return this.to('GetRecommendationPreferences');
    }
    /**
     * Grants permission to get the recommendation summaries for the specified account(s)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationSummaries.html
     */
    toGetRecommendationSummaries() {
        return this.to('GetRecommendationSummaries');
    }
    /**
     * Grants permission to put recommendation preferences
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceType()
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - autoscaling:DescribeAutoScalingInstances
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_PutRecommendationPreferences.html
     */
    toPutRecommendationPreferences() {
        return this.to('PutRecommendationPreferences');
    }
    /**
     * Grants permission to update the enrollment status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_UpdateEnrollmentStatus.html
     */
    toUpdateEnrollmentStatus() {
        return this.to('UpdateEnrollmentStatus');
    }
    /**
     * Filters access by the resource type
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html
     *
     * Applies to actions:
     * - .toDeleteRecommendationPreferences()
     * - .toGetEffectiveRecommendationPreferences()
     * - .toGetRecommendationPreferences()
     * - .toPutRecommendationPreferences()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceType(value, operator) {
        return this.if(`ResourceType`, value, operator || 'StringLike');
    }
}
exports.ComputeOptimizer = ComputeOptimizer;
_a = JSII_RTTI_SYMBOL_1;
ComputeOptimizer[_a] = { fqn: "iam-floyd.ComputeOptimizer", version: "0.494.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcHV0ZW9wdGltaXplci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNvbXB1dGVvcHRpbWl6ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxzQ0FBc0Q7QUFFdEQ7Ozs7R0FJRztBQUNILE1BQWEsZ0JBQWlCLFNBQVEsd0JBQWU7SUFHbkQ7Ozs7T0FJRztJQUNILFlBQVksR0FBWTtRQUN0QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFSTixrQkFBYSxHQUFHLG1CQUFtQixDQUFDO1FBc1RqQyxvQkFBZSxHQUFvQjtZQUMzQyxLQUFLLEVBQUU7Z0JBQ0wsaUNBQWlDO2dCQUNqQyx1Q0FBdUM7Z0JBQ3ZDLGdDQUFnQztnQkFDaEMsa0NBQWtDO2dCQUNsQyxpQ0FBaUM7Z0JBQ2pDLHFDQUFxQztnQkFDckMsOEJBQThCO2dCQUM5Qix3QkFBd0I7YUFDekI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osa0NBQWtDO2dCQUNsQyxvQ0FBb0M7Z0JBQ3BDLDZCQUE2QjtnQkFDN0IsK0JBQStCO2dCQUMvQixzQ0FBc0M7Z0JBQ3RDLDZDQUE2QztnQkFDN0MsOEJBQThCO2dCQUM5QixxQkFBcUI7Z0JBQ3JCLHNDQUFzQztnQkFDdEMsa0NBQWtDO2dCQUNsQyw0QkFBNEI7YUFDN0I7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osdUNBQXVDO2dCQUN2Qyw4QkFBOEI7YUFDL0I7U0FDRixDQUFDO0lBelVGLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7OztPQWFHO0lBQ0ksaUNBQWlDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSx1Q0FBdUM7UUFDNUMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVDQUF1QyxDQUFDLENBQUM7SUFDMUQsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxnQ0FBZ0M7UUFDckMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVEOzs7Ozs7Ozs7OztPQVdHO0lBQ0ksaUNBQWlDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLHFDQUFxQztRQUMxQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUNBQXFDLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksb0NBQW9DO1FBQ3pDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSw2QkFBNkI7UUFDbEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLCtCQUErQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksc0NBQXNDO1FBQzNDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw2Q0FBNkM7UUFDbEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDZDQUE2QyxDQUFDLENBQUM7SUFDaEUsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSw4QkFBOEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7OztPQWNHO0lBQ0ksdUNBQXVDO1FBQzVDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDO0lBQzFELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNDQUFzQztRQUMzQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0NBQXNDLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksOEJBQThCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7OztPQWNHO0lBQ0ksOEJBQThCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQztJQWdDRDs7Ozs7Ozs7Ozs7OztPQWFHO0lBQ0ksY0FBYyxDQUFDLEtBQXdCLEVBQUUsUUFBNEI7UUFDMUUsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsRUFBRSxLQUFLLEVBQUUsUUFBUSxJQUFJLFlBQVksQ0FBQyxDQUFDO0lBQ2xFLENBQUM7O0FBcldILDRDQXNXQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50LCBPcGVyYXRvciB9IGZyb20gJy4uL3NoYXJlZCc7XG5cbi8qKlxuICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtjb21wdXRlLW9wdGltaXplcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYXdzY29tcHV0ZW9wdGltaXplci5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIENvbXB1dGVPcHRpbWl6ZXIgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdjb21wdXRlLW9wdGltaXplcic7XG5cbiAgLyoqXG4gICAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbY29tcHV0ZS1vcHRpbWl6ZXJdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2F3c2NvbXB1dGVvcHRpbWl6ZXIuaHRtbCkuXG4gICAqXG4gICAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICAgKi9cbiAgY29uc3RydWN0b3Ioc2lkPzogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2lkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgcmVjb21tZW5kYXRpb24gcHJlZmVyZW5jZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZlJlc291cmNlVHlwZSgpXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGF1dG9zY2FsaW5nOkRlc2NyaWJlQXV0b1NjYWxpbmdHcm91cHNcbiAgICogLSBlYzI6RGVzY3JpYmVJbnN0YW5jZXNcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0RlbGV0ZVJlY29tbWVuZGF0aW9uUHJlZmVyZW5jZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlUmVjb21tZW5kYXRpb25QcmVmZXJlbmNlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlUmVjb21tZW5kYXRpb25QcmVmZXJlbmNlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgdGhlIHN0YXR1cyBvZiByZWNvbW1lbmRhdGlvbiBleHBvcnQgam9ic1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0Rlc2NyaWJlUmVjb21tZW5kYXRpb25FeHBvcnRKb2JzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlUmVjb21tZW5kYXRpb25FeHBvcnRKb2JzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZVJlY29tbWVuZGF0aW9uRXhwb3J0Sm9icycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGV4cG9ydCBBdXRvU2NhbGluZyBncm91cCByZWNvbW1lbmRhdGlvbnMgdG8gUzMgZm9yIHRoZSBwcm92aWRlZCBhY2NvdW50c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGF1dG9zY2FsaW5nOkRlc2NyaWJlQXV0b1NjYWxpbmdHcm91cHNcbiAgICogLSBjb21wdXRlLW9wdGltaXplcjpHZXRBdXRvU2NhbGluZ0dyb3VwUmVjb21tZW5kYXRpb25zXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FeHBvcnRBdXRvU2NhbGluZ0dyb3VwUmVjb21tZW5kYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0V4cG9ydEF1dG9TY2FsaW5nR3JvdXBSZWNvbW1lbmRhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0V4cG9ydEF1dG9TY2FsaW5nR3JvdXBSZWNvbW1lbmRhdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBleHBvcnQgRUJTIHZvbHVtZSByZWNvbW1lbmRhdGlvbnMgdG8gUzMgZm9yIHRoZSBwcm92aWRlZCBhY2NvdW50c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGNvbXB1dGUtb3B0aW1pemVyOkdldEVCU1ZvbHVtZVJlY29tbWVuZGF0aW9uc1xuICAgKiAtIGVjMjpEZXNjcmliZVZvbHVtZXNcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0V4cG9ydEVCU1ZvbHVtZVJlY29tbWVuZGF0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9FeHBvcnRFQlNWb2x1bWVSZWNvbW1lbmRhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0V4cG9ydEVCU1ZvbHVtZVJlY29tbWVuZGF0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGV4cG9ydCBFQzIgaW5zdGFuY2UgcmVjb21tZW5kYXRpb25zIHRvIFMzIGZvciB0aGUgcHJvdmlkZWQgYWNjb3VudHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBjb21wdXRlLW9wdGltaXplcjpHZXRFQzJJbnN0YW5jZVJlY29tbWVuZGF0aW9uc1xuICAgKiAtIGVjMjpEZXNjcmliZUluc3RhbmNlc1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRXhwb3J0RUMySW5zdGFuY2VSZWNvbW1lbmRhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRXhwb3J0RUMySW5zdGFuY2VSZWNvbW1lbmRhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0V4cG9ydEVDMkluc3RhbmNlUmVjb21tZW5kYXRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZXhwb3J0IEVDUyBzZXJ2aWNlIHJlY29tbWVuZGF0aW9ucyB0byBTMyBmb3IgdGhlIHByb3ZpZGVkIGFjY291bnRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gY29tcHV0ZS1vcHRpbWl6ZXI6R2V0RUNTU2VydmljZVJlY29tbWVuZGF0aW9uc1xuICAgKiAtIGVjczpMaXN0Q2x1c3RlcnNcbiAgICogLSBlY3M6TGlzdFNlcnZpY2VzXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9FeHBvcnRFQ1NTZXJ2aWNlUmVjb21tZW5kYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0V4cG9ydEVDU1NlcnZpY2VSZWNvbW1lbmRhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0V4cG9ydEVDU1NlcnZpY2VSZWNvbW1lbmRhdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBleHBvcnQgTGFtYmRhIGZ1bmN0aW9uIHJlY29tbWVuZGF0aW9ucyB0byBTMyBmb3IgdGhlIHByb3ZpZGVkIGFjY291bnRzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gY29tcHV0ZS1vcHRpbWl6ZXI6R2V0TGFtYmRhRnVuY3Rpb25SZWNvbW1lbmRhdGlvbnNcbiAgICogLSBsYW1iZGE6TGlzdEZ1bmN0aW9uc1xuICAgKiAtIGxhbWJkYTpMaXN0UHJvdmlzaW9uZWRDb25jdXJyZW5jeUNvbmZpZ3NcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0V4cG9ydExhbWJkYUZ1bmN0aW9uUmVjb21tZW5kYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0V4cG9ydExhbWJkYUZ1bmN0aW9uUmVjb21tZW5kYXRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdFeHBvcnRMYW1iZGFGdW5jdGlvblJlY29tbWVuZGF0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCByZWNvbW1lbmRhdGlvbnMgZm9yIHRoZSBwcm92aWRlZCBBdXRvU2NhbGluZyBncm91cHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGF1dG9zY2FsaW5nOkRlc2NyaWJlQXV0b1NjYWxpbmdHcm91cHNcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEF1dG9TY2FsaW5nR3JvdXBSZWNvbW1lbmRhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0QXV0b1NjYWxpbmdHcm91cFJlY29tbWVuZGF0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QXV0b1NjYWxpbmdHcm91cFJlY29tbWVuZGF0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCByZWNvbW1lbmRhdGlvbnMgZm9yIHRoZSBwcm92aWRlZCBFQlMgdm9sdW1lc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gZWMyOkRlc2NyaWJlVm9sdW1lc1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RUJTVm9sdW1lUmVjb21tZW5kYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEVCU1ZvbHVtZVJlY29tbWVuZGF0aW9ucygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RUJTVm9sdW1lUmVjb21tZW5kYXRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHJlY29tbWVuZGF0aW9ucyBmb3IgdGhlIHByb3ZpZGVkIEVDMiBpbnN0YW5jZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGVjMjpEZXNjcmliZUluc3RhbmNlc1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RUMySW5zdGFuY2VSZWNvbW1lbmRhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RUMySW5zdGFuY2VSZWNvbW1lbmRhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEVDMkluc3RhbmNlUmVjb21tZW5kYXRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHRoZSByZWNvbW1lbmRhdGlvbiBwcm9qZWN0ZWQgbWV0cmljcyBvZiB0aGUgc3BlY2lmaWVkIGluc3RhbmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBlYzI6RGVzY3JpYmVJbnN0YW5jZXNcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEVDMlJlY29tbWVuZGF0aW9uUHJvamVjdGVkTWV0cmljcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRFQzJSZWNvbW1lbmRhdGlvblByb2plY3RlZE1ldHJpY3MoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEVDMlJlY29tbWVuZGF0aW9uUHJvamVjdGVkTWV0cmljcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCB0aGUgcmVjb21tZW5kYXRpb24gcHJvamVjdGVkIG1ldHJpY3Mgb2YgdGhlIHNwZWNpZmllZCBFQ1Mgc2VydmljZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbXB1dGUtb3B0aW1pemVyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldEVDU1NlcnZpY2VSZWNvbW1lbmRhdGlvblByb2plY3RlZE1ldHJpY3MuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RUNTU2VydmljZVJlY29tbWVuZGF0aW9uUHJvamVjdGVkTWV0cmljcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RUNTU2VydmljZVJlY29tbWVuZGF0aW9uUHJvamVjdGVkTWV0cmljcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCByZWNvbW1lbmRhdGlvbnMgZm9yIHRoZSBwcm92aWRlZCBFQ1Mgc2VydmljZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGVjczpMaXN0Q2x1c3RlcnNcbiAgICogLSBlY3M6TGlzdFNlcnZpY2VzXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRFQ1NTZXJ2aWNlUmVjb21tZW5kYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEVDU1NlcnZpY2VSZWNvbW1lbmRhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEVDU1NlcnZpY2VSZWNvbW1lbmRhdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgcmVjb21tZW5kYXRpb24gcHJlZmVyZW5jZXMgdGhhdCBhcmUgaW4gZWZmZWN0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZlJlc291cmNlVHlwZSgpXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGF1dG9zY2FsaW5nOkRlc2NyaWJlQXV0b1NjYWxpbmdHcm91cHNcbiAgICogLSBhdXRvc2NhbGluZzpEZXNjcmliZUF1dG9TY2FsaW5nSW5zdGFuY2VzXG4gICAqIC0gZWMyOkRlc2NyaWJlSW5zdGFuY2VzXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRFZmZlY3RpdmVSZWNvbW1lbmRhdGlvblByZWZlcmVuY2VzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEVmZmVjdGl2ZVJlY29tbWVuZGF0aW9uUHJlZmVyZW5jZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEVmZmVjdGl2ZVJlY29tbWVuZGF0aW9uUHJlZmVyZW5jZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgdGhlIGVucm9sbG1lbnQgc3RhdHVzIGZvciB0aGUgc3BlY2lmaWVkIGFjY291bnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRFbnJvbGxtZW50U3RhdHVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEVucm9sbG1lbnRTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEVucm9sbG1lbnRTdGF0dXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgdGhlIGVucm9sbG1lbnQgc3RhdHVzZXMgZm9yIG1lbWJlciBhY2NvdW50cyBvZiB0aGUgb3JnYW5pemF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0RW5yb2xsbWVudFN0YXR1c2VzRm9yT3JnYW5pemF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEVucm9sbG1lbnRTdGF0dXNlc0Zvck9yZ2FuaXphdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0RW5yb2xsbWVudFN0YXR1c2VzRm9yT3JnYW5pemF0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHJlY29tbWVuZGF0aW9ucyBmb3IgdGhlIHByb3ZpZGVkIExhbWJkYSBmdW5jdGlvbnNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGxhbWJkYTpMaXN0RnVuY3Rpb25zXG4gICAqIC0gbGFtYmRhOkxpc3RQcm92aXNpb25lZENvbmN1cnJlbmN5Q29uZmlnc1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0TGFtYmRhRnVuY3Rpb25SZWNvbW1lbmRhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0TGFtYmRhRnVuY3Rpb25SZWNvbW1lbmRhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldExhbWJkYUZ1bmN0aW9uUmVjb21tZW5kYXRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHJlY29tbWVuZGF0aW9uIHByZWZlcmVuY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZlJlc291cmNlVHlwZSgpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9HZXRSZWNvbW1lbmRhdGlvblByZWZlcmVuY2VzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlY29tbWVuZGF0aW9uUHJlZmVyZW5jZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFJlY29tbWVuZGF0aW9uUHJlZmVyZW5jZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgdGhlIHJlY29tbWVuZGF0aW9uIHN1bW1hcmllcyBmb3IgdGhlIHNwZWNpZmllZCBhY2NvdW50KHMpXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfR2V0UmVjb21tZW5kYXRpb25TdW1tYXJpZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0UmVjb21tZW5kYXRpb25TdW1tYXJpZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFJlY29tbWVuZGF0aW9uU3VtbWFyaWVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcHV0IHJlY29tbWVuZGF0aW9uIHByZWZlcmVuY2VzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZSZXNvdXJjZVR5cGUoKVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBhdXRvc2NhbGluZzpEZXNjcmliZUF1dG9TY2FsaW5nR3JvdXBzXG4gICAqIC0gYXV0b3NjYWxpbmc6RGVzY3JpYmVBdXRvU2NhbGluZ0luc3RhbmNlc1xuICAgKiAtIGVjMjpEZXNjcmliZUluc3RhbmNlc1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfUHV0UmVjb21tZW5kYXRpb25QcmVmZXJlbmNlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9QdXRSZWNvbW1lbmRhdGlvblByZWZlcmVuY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdQdXRSZWNvbW1lbmRhdGlvblByZWZlcmVuY2VzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIHRoZSBlbnJvbGxtZW50IHN0YXR1c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb21wdXRlLW9wdGltaXplci9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9VcGRhdGVFbnJvbGxtZW50U3RhdHVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUVucm9sbG1lbnRTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUVucm9sbG1lbnRTdGF0dXMnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0RlbGV0ZVJlY29tbWVuZGF0aW9uUHJlZmVyZW5jZXMnLFxuICAgICAgJ0V4cG9ydEF1dG9TY2FsaW5nR3JvdXBSZWNvbW1lbmRhdGlvbnMnLFxuICAgICAgJ0V4cG9ydEVCU1ZvbHVtZVJlY29tbWVuZGF0aW9ucycsXG4gICAgICAnRXhwb3J0RUMySW5zdGFuY2VSZWNvbW1lbmRhdGlvbnMnLFxuICAgICAgJ0V4cG9ydEVDU1NlcnZpY2VSZWNvbW1lbmRhdGlvbnMnLFxuICAgICAgJ0V4cG9ydExhbWJkYUZ1bmN0aW9uUmVjb21tZW5kYXRpb25zJyxcbiAgICAgICdQdXRSZWNvbW1lbmRhdGlvblByZWZlcmVuY2VzJyxcbiAgICAgICdVcGRhdGVFbnJvbGxtZW50U3RhdHVzJ1xuICAgIF0sXG4gICAgTGlzdDogW1xuICAgICAgJ0Rlc2NyaWJlUmVjb21tZW5kYXRpb25FeHBvcnRKb2JzJyxcbiAgICAgICdHZXRBdXRvU2NhbGluZ0dyb3VwUmVjb21tZW5kYXRpb25zJyxcbiAgICAgICdHZXRFQlNWb2x1bWVSZWNvbW1lbmRhdGlvbnMnLFxuICAgICAgJ0dldEVDMkluc3RhbmNlUmVjb21tZW5kYXRpb25zJyxcbiAgICAgICdHZXRFQzJSZWNvbW1lbmRhdGlvblByb2plY3RlZE1ldHJpY3MnLFxuICAgICAgJ0dldEVDU1NlcnZpY2VSZWNvbW1lbmRhdGlvblByb2plY3RlZE1ldHJpY3MnLFxuICAgICAgJ0dldEVDU1NlcnZpY2VSZWNvbW1lbmRhdGlvbnMnLFxuICAgICAgJ0dldEVucm9sbG1lbnRTdGF0dXMnLFxuICAgICAgJ0dldEVucm9sbG1lbnRTdGF0dXNlc0Zvck9yZ2FuaXphdGlvbicsXG4gICAgICAnR2V0TGFtYmRhRnVuY3Rpb25SZWNvbW1lbmRhdGlvbnMnLFxuICAgICAgJ0dldFJlY29tbWVuZGF0aW9uU3VtbWFyaWVzJ1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0dldEVmZmVjdGl2ZVJlY29tbWVuZGF0aW9uUHJlZmVyZW5jZXMnLFxuICAgICAgJ0dldFJlY29tbWVuZGF0aW9uUHJlZmVyZW5jZXMnXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBGaWx0ZXJzIGFjY2VzcyBieSB0aGUgcmVzb3VyY2UgdHlwZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29tcHV0ZS1vcHRpbWl6ZXIvbGF0ZXN0L3VnL3NlY3VyaXR5LWlhbS5odG1sXG4gICAqXG4gICAqIEFwcGxpZXMgdG8gYWN0aW9uczpcbiAgICogLSAudG9EZWxldGVSZWNvbW1lbmRhdGlvblByZWZlcmVuY2VzKClcbiAgICogLSAudG9HZXRFZmZlY3RpdmVSZWNvbW1lbmRhdGlvblByZWZlcmVuY2VzKClcbiAgICogLSAudG9HZXRSZWNvbW1lbmRhdGlvblByZWZlcmVuY2VzKClcbiAgICogLSAudG9QdXRSZWNvbW1lbmRhdGlvblByZWZlcmVuY2VzKClcbiAgICpcbiAgICogQHBhcmFtIHZhbHVlIFRoZSB2YWx1ZShzKSB0byBjaGVja1xuICAgKiBAcGFyYW0gb3BlcmF0b3IgV29ya3Mgd2l0aCBbc3RyaW5nIG9wZXJhdG9yc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19jb25kaXRpb25fb3BlcmF0b3JzLmh0bWwjQ29uZGl0aW9uc19TdHJpbmcpLiAqKkRlZmF1bHQ6KiogYFN0cmluZ0xpa2VgXG4gICAqL1xuICBwdWJsaWMgaWZSZXNvdXJjZVR5cGUodmFsdWU6IHN0cmluZyB8IHN0cmluZ1tdLCBvcGVyYXRvcj86IE9wZXJhdG9yIHwgc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMuaWYoYFJlc291cmNlVHlwZWAsIHZhbHVlLCBvcGVyYXRvciB8fCAnU3RyaW5nTGlrZScpO1xuICB9XG59XG4iXX0=