import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [cur](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostandusagereport.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Cur extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [cur](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscostandusagereport.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to delete Cost and Usage Report Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_DeleteReportDefinition.html
     */
    toDeleteReportDefinition(): this;
    /**
     * Grants permission to get Cost and Usage Report Definitions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_DescribeReportDefinitions.html
     */
    toDescribeReportDefinitions(): this;
    /**
     * Grants permission to get Bills CSV report
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toGetClassicReport(): this;
    /**
     * Grants permission to get the classic report enablement status for Usage Reports
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toGetClassicReportPreferences(): this;
    /**
     * Grants permission to get list of AWS services, usage type and operation for the Usage Report workflow. Allows or denies download of usage reports too
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toGetUsageReport(): this;
    /**
     * Grants permission to modify Cost and Usage Report Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_ModifyReportDefinition.html
     */
    toModifyReportDefinition(): this;
    /**
     * Grants permission to enable classic reports
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toPutClassicReportPreferences(): this;
    /**
     * Grants permission to write Cost and Usage Report Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_cur_PutReportDefinition.html
     */
    toPutReportDefinition(): this;
    /**
     * Grants permission to validates if the s3 bucket exists with appropriate permissions for CUR delivery
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/security.html#user-permissions
     */
    toValidateReportDestination(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type cur to the statement
     *
     * https://docs.aws.amazon.com/cur/latest/userguide/what-is-cur.html
     *
     * @param reportName - Identifier for the reportName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCur(reportName: string, account?: string, region?: string, partition?: string): this;
}
