import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [mediatailor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediatailor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mediatailor extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [mediatailor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselementalmediatailor.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to configure logs on the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/configurelogs-channel.html
     */
    toConfigureLogsForChannel(): this;
    /**
     * Grants permission to configure logs for a playback configuration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/configurelogs-playbackconfiguration.html
     */
    toConfigureLogsForPlaybackConfiguration(): this;
    /**
     * Grants permission to create a new channel
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     */
    toCreateChannel(): this;
    /**
     * Grants permission to create a new live source on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     */
    toCreateLiveSource(): this;
    /**
     * Grants permission to create a prefetch schedule for the playback configuration with the specified playback configuration name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname-name.html
     */
    toCreatePrefetchSchedule(): this;
    /**
     * Grants permission to create a new program on the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     */
    toCreateProgram(): this;
    /**
     * Grants permission to create a new source location
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     */
    toCreateSourceLocation(): this;
    /**
     * Grants permission to create a new VOD source on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     */
    toCreateVodSource(): this;
    /**
     * Grants permission to delete the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     */
    toDeleteChannel(): this;
    /**
     * Grants permission to delete the IAM policy on the channel with the specified channel name
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-policy.html
     */
    toDeleteChannelPolicy(): this;
    /**
     * Grants permission to delete the live source with the specified live source name on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     */
    toDeleteLiveSource(): this;
    /**
     * Grants permission to delete the specified playback configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration-name.html
     */
    toDeletePlaybackConfiguration(): this;
    /**
     * Grants permission to delete a prefetch schedule for a playback configuration with the specified prefetch schedule name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname-name.html
     */
    toDeletePrefetchSchedule(): this;
    /**
     * Grants permission to delete the program with the specified program name on the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     */
    toDeleteProgram(): this;
    /**
     * Grants permission to delete the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     */
    toDeleteSourceLocation(): this;
    /**
     * Grants permission to delete the VOD source with the specified VOD source name on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     */
    toDeleteVodSource(): this;
    /**
     * Grants permission to retrieve the channel with the specified channel name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     */
    toDescribeChannel(): this;
    /**
     * Grants permission to retrieve the live source with the specified live source name on the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     */
    toDescribeLiveSource(): this;
    /**
     * Grants permission to retrieve the program with the specified program name on the channel with the specified channel name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     */
    toDescribeProgram(): this;
    /**
     * Grants permission to retrieve the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     */
    toDescribeSourceLocation(): this;
    /**
     * Grants permission to retrieve the VOD source with the specified VOD source name on the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     */
    toDescribeVodSource(): this;
    /**
     * Grants permission to read the IAM policy on the channel with the specified channel name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-policy.html
     */
    toGetChannelPolicy(): this;
    /**
     * Grants permission to retrieve the schedule of programs on the channel with the specified channel name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-schedule.html
     */
    toGetChannelSchedule(): this;
    /**
     * Grants permission to retrieve the configuration for the specified name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration-name.html
     */
    toGetPlaybackConfiguration(): this;
    /**
     * Grants permission to retrieve prefetch schedule for a playback configuration with the specified prefetch schedule name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname-name.html
     */
    toGetPrefetchSchedule(): this;
    /**
     * Grants permission to retrieve the list of alerts on a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/alerts.html
     */
    toListAlerts(): this;
    /**
     * Grants permission to retrieve the list of existing channels
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channels.html
     */
    toListChannels(): this;
    /**
     * Grants permission to retrieve the list of existing live sources on the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesources.html
     */
    toListLiveSources(): this;
    /**
     * Grants permission to retrieve the list of available configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfigurations.html
     */
    toListPlaybackConfigurations(): this;
    /**
     * Grants permission to retrieve the list of prefetch schedules for a playback configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname.html
     */
    toListPrefetchSchedules(): this;
    /**
     * Grants permission to retrieve the list of existing source locations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocations.html
     */
    toListSourceLocations(): this;
    /**
     * Grants permission to list the tags assigned to the specified playback configuration resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/tags-resourcearn.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to retrieve the list of existing VOD sources on the source location with the specified source location name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsources.html
     */
    toListVodSources(): this;
    /**
     * Grants permission to set the IAM policy on the channel with the specified channel name
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-policy.html
     */
    toPutChannelPolicy(): this;
    /**
     * Grants permission to add a new configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration.html
     */
    toPutPlaybackConfiguration(): this;
    /**
     * Grants permission to start the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-start.html
     */
    toStartChannel(): this;
    /**
     * Grants permission to stop the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-stop.html
     */
    toStopChannel(): this;
    /**
     * Grants permission to add tags to the specified playback configuration resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/tags-resourcearn.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from the specified playback configuration resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/tags-resourcearn.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     */
    toUpdateChannel(): this;
    /**
     * Grants permission to update the live source with the specified live source name on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     */
    toUpdateLiveSource(): this;
    /**
     * Grants permission to update the program with the specified program name on the channel with the specified channel name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     */
    toUpdateProgram(): this;
    /**
     * Grants permission to update the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     */
    toUpdateSourceLocation(): this;
    /**
     * Grants permission to update the VOD source with the specified VOD source name on the source location with the specified source location name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     */
    toUpdateVodSource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type playbackConfiguration to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/playbackconfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPlaybackConfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type prefetchSchedule to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/prefetchschedule-playbackconfigurationname-name.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPrefetchSchedule(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type channel to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname.html
     *
     * @param channelName - Identifier for the channelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChannel(channelName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type program to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/channel-channelname-program-programname.html
     *
     * @param channelName - Identifier for the channelName.
     * @param programName - Identifier for the programName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProgram(channelName: string, programName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type sourceLocation to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname.html
     *
     * @param sourceLocationName - Identifier for the sourceLocationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSourceLocation(sourceLocationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type vodSource to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-vodsource-vodsourcename.html
     *
     * @param sourceLocationName - Identifier for the sourceLocationName.
     * @param vodSourceName - Identifier for the vodSourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVodSource(sourceLocationName: string, vodSourceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type liveSource to the statement
     *
     * https://docs.aws.amazon.com/mediatailor/latest/apireference/sourcelocation-sourcelocationname-livesource-livesourcename.html
     *
     * @param sourceLocationName - Identifier for the sourceLocationName.
     * @param liveSourceName - Identifier for the liveSourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLiveSource(sourceLocationName: string, liveSourceName: string, account?: string, region?: string, partition?: string): this;
}
