import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [identity-sync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitysync.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class IdentitySync extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [identity-sync](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentitysync.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a sync filter on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncFilter(): this;
    /**
     * Grants permission to create a sync profile for the identity source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncProfile(): this;
    /**
     * Grants permission to create a sync target for the identity source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toCreateSyncTarget(): this;
    /**
     * Grants permission to delete a sync filter from the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncFilter(): this;
    /**
     * Grants permission to delete a sync profile from the source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncProfile(): this;
    /**
     * Grants permission to delete a sync target from the source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toDeleteSyncTarget(): this;
    /**
     * Grants permission to retrieve a sync profile by using a sync profile name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toGetSyncProfile(): this;
    /**
     * Grants permission to retrieve a sync target from the sync profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toGetSyncTarget(): this;
    /**
     * Grants permission to list the sync filters from the sync profile
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toListSyncFilters(): this;
    /**
     * Grants permission to start a sync process or to resume a sync process that was previously paused
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toStartSync(): this;
    /**
     * Grants permission to stop any planned sync process in the sync schedule from starting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toStopSync(): this;
    /**
     * Grants permission to update a sync target on the sync profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     */
    toUpdateSyncTarget(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type SyncProfileResource to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     *
     * @param syncProfileName - Identifier for the syncProfileName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSyncProfileResource(syncProfileName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SyncTargetResource to the statement
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/security-iam-awsmanpol.html
     *
     * @param syncProfileName - Identifier for the syncProfileName.
     * @param syncTargetName - Identifier for the syncTargetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSyncTargetResource(syncProfileName: string, syncTargetName: string, account?: string, region?: string, partition?: string): this;
}
