import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [ivschat](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninteractivevideoservicechat.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Ivschat extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [ivschat](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoninteractivevideoservicechat.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an encrypted token that is used to establish an individual WebSocket connection to a room
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_CreateChatToken.html
     */
    toCreateChatToken(): this;
    /**
     * Grants permission to create a logging configuration that allows clients to record room messages
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_CreateLoggingConfiguration.html
     */
    toCreateLoggingConfiguration(): this;
    /**
     * Grants permission to create a room that allows clients to connect and pass messages
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_CreateRoom.html
     */
    toCreateRoom(): this;
    /**
     * Grants permission to delete the logging configuration for a specified logging configuration ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_DeleteLoggingConfiguration.html
     */
    toDeleteLoggingConfiguration(): this;
    /**
     * Grants permission to send an event to a specific room which directs clients to delete a specific message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_DeleteMessage.html
     */
    toDeleteMessage(): this;
    /**
     * Grants permission to delete the room for a specified room ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_DeleteRoom.html
     */
    toDeleteRoom(): this;
    /**
     * Grants permission to disconnect all connections using a specified user ID from a room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_DisconnectUser.html
     */
    toDisconnectUser(): this;
    /**
     * Grants permission to get the logging configuration for a specified logging configuration ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_GetLoggingConfiguration.html
     */
    toGetLoggingConfiguration(): this;
    /**
     * Grants permission to get the room configuration for a specified room ARN
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_GetRoom.html
     */
    toGetRoom(): this;
    /**
     * Grants permission to get summary information about logging configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_ListLoggingConfigurations.html
     */
    toListLoggingConfigurations(): this;
    /**
     * Grants permission to get summary information about rooms
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_ListRooms.html
     */
    toListRooms(): this;
    /**
     * Grants permission to get information about the tags for a specified ARN
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to send an event to a room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_SendEvent.html
     */
    toSendEvent(): this;
    /**
     * Grants permission to add or update tags for a resource with a specified ARN
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags for a resource with a specified ARN
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the logging configuration for a specified logging configuration ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_UpdateLoggingConfiguration.html
     */
    toUpdateLoggingConfiguration(): this;
    /**
     * Grants permission to update the room configuration for a specified room ARN
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_UpdateRoom.html
     */
    toUpdateRoom(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Room to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_Room.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRoom(resourceId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type Logging-Configuration to the statement
     *
     * https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_LoggingConfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLoggingConfiguration(resourceId: string, account?: string, partition?: string): this;
}
