"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IqPermission = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iq-permission](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiqpermissions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class IqPermission extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iq-permission](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiqpermissions.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iq-permission';
        this.accessLevelList = {
            Write: [
                'ApproveAccessGrant',
                'ApprovePermissionRequest',
                'CreatePermissionRequest',
                'RejectPermissionRequest',
                'RevokePermissionRequest',
                'WithdrawPermissionRequest'
            ],
            Read: [
                'GetPermissionRequest',
                'ListPermissionRequests'
            ]
        };
    }
    /**
     * Grants permission to approve a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApproveAccessGrant() {
        return this.to('ApproveAccessGrant');
    }
    /**
     * Grants permission to approve a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApprovePermissionRequest() {
        return this.to('ApprovePermissionRequest');
    }
    /**
     * Grants permission to create a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreatePermissionRequest() {
        return this.to('CreatePermissionRequest');
    }
    /**
     * Grants permission to get a permission request
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetPermissionRequest() {
        return this.to('GetPermissionRequest');
    }
    /**
     * Grants permission to list permission requests
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListPermissionRequests() {
        return this.to('ListPermissionRequests');
    }
    /**
     * Grants permission to reject a permission request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRejectPermissionRequest() {
        return this.to('RejectPermissionRequest');
    }
    /**
     * Grants permission to revoke a permission request which was previously approved
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRevokePermissionRequest() {
        return this.to('RevokePermissionRequest');
    }
    /**
     * Grants permission to withdraw a permission request that has not been approved or declined
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWithdrawPermissionRequest() {
        return this.to('WithdrawPermissionRequest');
    }
    /**
     * Adds a resource of type permission to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param permissionRequestId - Identifier for the permissionRequestId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPermission(permissionRequestId, region, partition) {
        return this.on(`arn:${partition || IqPermission.defaultPartition}:iq-permission:${region || '*'}::permission/${permissionRequestId}`);
    }
}
exports.IqPermission = IqPermission;
_a = JSII_RTTI_SYMBOL_1;
IqPermission[_a] = { fqn: "iam-floyd.IqPermission", version: "0.494.0" };
//# sourceMappingURL=data:application/json;base64,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