import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [license-manager-linux-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanagerlinuxsubscriptionsmanager.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class LicenseManagerLinuxSubscriptions extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [license-manager-linux-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslicensemanagerlinuxsubscriptionsmanager.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to get the service settings for Linux subscriptions in AWS License Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_GetServiceSettings.html
     */
    toGetServiceSettings(): this;
    /**
     * Grants permission to list all instances with Linux subscriptions in AWS License Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListLinuxSubscriptionInstances.html
     */
    toListLinuxSubscriptionInstances(): this;
    /**
     * Grants permission to list all Linux subscriptions in AWS License Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListLinuxSubscriptions.html
     */
    toListLinuxSubscriptions(): this;
    /**
     * Grants permission to update the service settings for Linux subscriptions in AWS License Manager
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/license-manager/latest/APIReference/API_UpdateServiceSettings.html
     */
    toUpdateServiceSettings(): this;
    protected accessLevelList: AccessLevelList;
}
