import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [nimble](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonnimblestudio.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Nimble extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [nimble](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonnimblestudio.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to accept EULAs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_AcceptEulas.html
     */
    toAcceptEulas(): this;
    /**
     * Grants permission to create a launch profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcEndpoints
     * - ec2:RunInstances
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateLaunchProfile.html
     */
    toCreateLaunchProfile(): this;
    /**
     * Grants permission to create a streaming image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:DescribeImages
     * - ec2:DescribeSnapshots
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifySnapshotAttribute
     * - ec2:RegisterImage
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingImage.html
     */
    toCreateStreamingImage(): this;
    /**
     * Grants permission to create a streaming session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:CreateNetworkInterfacePermission
     * - nimble:GetLaunchProfile
     * - nimble:GetLaunchProfileInitialization
     * - nimble:ListEulaAcceptances
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingSession.html
     */
    toCreateStreamingSession(): this;
    /**
     * Grants permission to create a StreamingSessionStream
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStreamingSessionStream.html
     */
    toCreateStreamingSessionStream(): this;
    /**
     * Grants permission to create a studio
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - iam:PassRole
     * - sso:CreateManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStudio.html
     */
    toCreateStudio(): this;
    /**
     * Grants permission to create a studio component. A studio component designates a network resource to which a launch profile will provide access
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_CreateStudioComponent.html
     */
    toCreateStudioComponent(): this;
    /**
     * Grants permission to delete a launch profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteLaunchProfile.html
     */
    toDeleteLaunchProfile(): this;
    /**
     * Grants permission to delete a launch profile member
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteLaunchProfileMember.html
     */
    toDeleteLaunchProfileMember(): this;
    /**
     * Grants permission to delete a streaming image
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DeleteSnapshot
     * - ec2:DeregisterImage
     * - ec2:ModifyInstanceAttribute
     * - ec2:ModifySnapshotAttribute
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStreamingImage.html
     */
    toDeleteStreamingImage(): this;
    /**
     * Grants permission to delete a streaming session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - ec2:DeleteNetworkInterface
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStreamingSession.html
     */
    toDeleteStreamingSession(): this;
    /**
     * Grants permission to delete a studio
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:DeleteManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudio.html
     */
    toDeleteStudio(): this;
    /**
     * Grants permission to delete a studio component
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudioComponent.html
     */
    toDeleteStudioComponent(): this;
    /**
     * Grants permission to delete a studio member
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_DeleteStudioMember.html
     */
    toDeleteStudioMember(): this;
    /**
     * Grants permission to get a EULA
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetEula.html
     */
    toGetEula(): this;
    /**
     * Grants permission to allow Nimble Studio portal to show the appropriate features for this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     */
    toGetFeatureMap(): this;
    /**
     * Grants permission to get a launch profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfile.html
     */
    toGetLaunchProfile(): this;
    /**
     * Grants permission to get a launch profile's details, which includes the summary of studio components and streaming images used by the launch profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileDetails.html
     */
    toGetLaunchProfileDetails(): this;
    /**
     * Grants permission to get a launch profile initialization. A launch profile initialization is a dereferenced version of a launch profile, including attached studio component connection information
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileInitialization.html
     */
    toGetLaunchProfileInitialization(): this;
    /**
     * Grants permission to get a launch profile member
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetLaunchProfileMember.html
     */
    toGetLaunchProfileMember(): this;
    /**
     * Grants permission to get a streaming image
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingImage.html
     */
    toGetStreamingImage(): this;
    /**
     * Grants permission to get a streaming session
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingSession.html
     */
    toGetStreamingSession(): this;
    /**
     * Grants permission to get a streaming session backup
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingSessionBackup.html
     */
    toGetStreamingSessionBackup(): this;
    /**
     * Grants permission to get a streaming session stream
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStreamingSessionStream.html
     */
    toGetStreamingSessionStream(): this;
    /**
     * Grants permission to get a studio
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudio.html
     */
    toGetStudio(): this;
    /**
     * Grants permission to get a studio component
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudioComponent.html
     */
    toGetStudioComponent(): this;
    /**
     * Grants permission to get a studio member
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_GetStudioMember.html
     */
    toGetStudioMember(): this;
    /**
     * Grants permission to list EULA acceptances
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListEulaAcceptances.html
     */
    toListEulaAcceptances(): this;
    /**
     * Grants permission to list EULAs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListEulas.html
     */
    toListEulas(): this;
    /**
     * Grants permission to list launch profile members
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListLaunchProfileMembers.html
     */
    toListLaunchProfileMembers(): this;
    /**
     * Grants permission to list launch profiles
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifPrincipalId()
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListLaunchProfiles.html
     */
    toListLaunchProfiles(): this;
    /**
     * Grants permission to list streaming images
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStreamingImages.html
     */
    toListStreamingImages(): this;
    /**
     * Grants permission to list streaming session backups
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStreamingSessionBackups.html
     */
    toListStreamingSessionBackups(): this;
    /**
     * Grants permission to list streaming sessions
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifCreatedBy()
     * - .ifOwnedBy()
     * - .ifRequesterPrincipalId()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStreamingSessions.html
     */
    toListStreamingSessions(): this;
    /**
     * Grants permission to list studio components
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudioComponents.html
     */
    toListStudioComponents(): this;
    /**
     * Grants permission to list studio members
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudioMembers.html
     */
    toListStudioMembers(): this;
    /**
     * Grants permission to list all studios
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListStudios.html
     */
    toListStudios(): this;
    /**
     * Grants permission to list all tags on a Nimble Studio resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to add/update launch profile members
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso-directory:DescribeUsers
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_PutLaunchProfileMembers.html
     */
    toPutLaunchProfileMembers(): this;
    /**
     * Grants permission to report metrics and logs for the Nimble Studio portal to monitor application health
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     */
    toPutStudioLogEvents(): this;
    /**
     * Grants permission to add/update studio members
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso-directory:DescribeUsers
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_PutStudioMembers.html
     */
    toPutStudioMembers(): this;
    /**
     * Grants permission to start a streaming session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - nimble:GetLaunchProfile
     * - nimble:GetLaunchProfileMember
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StartStreamingSession.html
     */
    toStartStreamingSession(): this;
    /**
     * Grants permission to repair the studio's AWS IAM Identity Center configuration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - sso:CreateManagedApplicationInstance
     * - sso:GetManagedApplicationInstance
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StartStudioSSOConfigurationRepair.html
     */
    toStartStudioSSOConfigurationRepair(): this;
    /**
     * Grants permission to stop a streaming session
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifRequesterPrincipalId()
     *
     * Dependent actions:
     * - nimble:GetLaunchProfile
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StopStreamingSession.html
     */
    toStopStreamingSession(): this;
    /**
     * Grants permission to add or overwrite one or more tags for the specified Nimble Studio resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to disassociate one or more tags from the specified Nimble Studio resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a launch profile
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeNatGateways
     * - ec2:DescribeNetworkAcls
     * - ec2:DescribeRouteTables
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcEndpoints
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateLaunchProfile.html
     */
    toUpdateLaunchProfile(): this;
    /**
     * Grants permission to update a launch profile member
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateLaunchProfileMember.html
     */
    toUpdateLaunchProfileMember(): this;
    /**
     * Grants permission to update a streaming image
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStreamingImage.html
     */
    toUpdateStreamingImage(): this;
    /**
     * Grants permission to update a studio
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStudio.html
     */
    toUpdateStudio(): this;
    /**
     * Grants permission to update a studio component
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:DescribeDirectories
     * - ec2:DescribeSecurityGroups
     * - fsx:DescribeFileSystems
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_UpdateStudioComponent.html
     */
    toUpdateStudioComponent(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type studio to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_Studio.html
     *
     * @param studioId - Identifier for the studioId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifStudioId()
     */
    onStudio(studioId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type streaming-image to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StreamingImage.html
     *
     * @param streamingImageId - Identifier for the streamingImageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifStudioId()
     */
    onStreamingImage(streamingImageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type studio-component to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StudioComponent.html
     *
     * @param studioComponentId - Identifier for the studioComponentId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifStudioId()
     */
    onStudioComponent(studioComponentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type launch-profile to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_LaunchProfile.html
     *
     * @param launchProfileId - Identifier for the launchProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifStudioId()
     */
    onLaunchProfile(launchProfileId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type streaming-session to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StreamingSession.html
     *
     * @param streamingSessionId - Identifier for the streamingSessionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifCreatedBy()
     * - .ifOwnedBy()
     */
    onStreamingSession(streamingSessionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type streaming-session-backup to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_StreamingSessionBackup.html
     *
     * @param streamingSessionBackupId - Identifier for the streamingSessionBackupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifOwnedBy()
     */
    onStreamingSessionBackup(streamingSessionBackupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type eula to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_Eula.html
     *
     * @param eulaId - Identifier for the eulaId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEula(eulaId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type eula-acceptance to the statement
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/APIReference/API_EulaAcceptance.html
     *
     * @param eulaAcceptanceId - Identifier for the eulaAcceptanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifStudioId()
     */
    onEulaAcceptance(eulaAcceptanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the createdBy request parameter or the ID of the creator of the resource
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListStreamingSessions()
     *
     * Applies to resource types:
     * - streaming-session
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifCreatedBy(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ownedBy request parameter or the ID of the owner of the resource
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListStreamingSessions()
     *
     * Applies to resource types:
     * - streaming-session
     * - streaming-session-backup
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifOwnedBy(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the principalId request parameter
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toListLaunchProfiles()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifPrincipalId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of the logged in user
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to actions:
     * - .toCreateStreamingSessionStream()
     * - .toDeleteStreamingSession()
     * - .toGetStreamingSession()
     * - .toGetStreamingSessionBackup()
     * - .toGetStreamingSessionStream()
     * - .toListLaunchProfiles()
     * - .toListStreamingSessionBackups()
     * - .toListStreamingSessions()
     * - .toStartStreamingSession()
     * - .toStopStreamingSession()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRequesterPrincipalId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by a specific studio
     *
     * https://docs.aws.amazon.com/nimble-studio/latest/userguide/security-iam-service-with-iam.html
     *
     * Applies to resource types:
     * - studio
     * - streaming-image
     * - studio-component
     * - launch-profile
     * - eula-acceptance
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifStudioId(value: string | string[], operator?: Operator | string): this;
}
