import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [sagemaker-groundtruth-synthetic](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakergroundtruthsynthetic.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SagemakerGroundtruthSynthetic extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [sagemaker-groundtruth-synthetic](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakergroundtruthsynthetic.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a project
     *
     * Access Level: Write
     */
    toCreateProject(): this;
    /**
     * Grants permission to delete a project
     *
     * Access Level: Write
     */
    toDeleteProject(): this;
    /**
     * Grants permission to get account details
     *
     * Access Level: Read
     */
    toGetAccountDetails(): this;
    /**
     * Grants permission to get a batch
     *
     * Access Level: Read
     */
    toGetBatch(): this;
    /**
     * Grants permission to get a project
     *
     * Access Level: Read
     */
    toGetProject(): this;
    /**
     * Grants permission to list batch data transfers
     *
     * Access Level: List
     */
    toListBatchDataTransfers(): this;
    /**
     * Grants permission to list batch summaries
     *
     * Access Level: List
     */
    toListBatchSummaries(): this;
    /**
     * Grants permission to list project data transfers
     *
     * Access Level: List
     */
    toListProjectDataTransfers(): this;
    /**
     * Grants permission to list project summaries
     *
     * Access Level: List
     */
    toListProjectSummaries(): this;
    /**
     * Grants permission to start a batch data transfer
     *
     * Access Level: Write
     */
    toStartBatchDataTransfer(): this;
    /**
     * Grants permission to start a project data transfer
     *
     * Access Level: Write
     */
    toStartProjectDataTransfer(): this;
    /**
     * Grants permission to update a batch
     *
     * Access Level: Write
     */
    toUpdateBatch(): this;
    protected accessLevelList: AccessLevelList;
}
