import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [supportapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportappinslack.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Supportapp extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [supportapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportappinslack.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a Slack channel configuration for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_CreateSlackChannelConfiguration.html
     */
    toCreateSlackChannelConfiguration(): this;
    /**
     * Grants permission to delete an alias from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_DeleteAccountAlias.html
     */
    toDeleteAccountAlias(): this;
    /**
     * Grants permission to delete a Slack channel configuration from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_DeleteSlackChannelConfiguration.html
     */
    toDeleteSlackChannelConfiguration(): this;
    /**
     * Grants permission to delete a Slack workspace configuration from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_DeleteSlackWorkspaceConfiguration.html
     */
    toDeleteSlackWorkspaceConfiguration(): this;
    /**
     * Grants permission to list all public Slack channels in a workspace that have invited the AWS Support App
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/slack-authorization-permissions.html
     */
    toDescribeSlackChannels(): this;
    /**
     * Grants permission to get the alias for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_GetAccountAlias.html
     */
    toGetAccountAlias(): this;
    /**
     * Grants permission to get parameters for the Slack OAuth code, which the AWS Support App uses to authorize the workspace
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/slack-authorization-permissions.html
     */
    toGetSlackOauthParameters(): this;
    /**
     * Grants permission to list all Slack channel configurations for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_ListSlackChannelConfigurations.html
     */
    toListSlackChannelConfigurations(): this;
    /**
     * Grants permission to list all Slack workspace configurations for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_ListSlackWorkspaceConfigurations.html
     */
    toListSlackWorkspaceConfigurations(): this;
    /**
     * Grants permission to create or update an alias for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_PutAccountAlias.html
     */
    toPutAccountAlias(): this;
    /**
     * Grants permission to redeem the Slack OAuth code, which the AWS Support App uses to authorize the workspace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/slack-authorization-permissions.html
     */
    toRedeemSlackOauthCode(): this;
    /**
     * Grants permission to register a Slack workspace for an AWS account that is part of an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_RegisterSlackWorkspaceForOrganization.html
     */
    toRegisterSlackWorkspaceForOrganization(): this;
    /**
     * Grants permission to update a Slack channel configuration for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_UpdateSlackChannelConfiguration.html
     */
    toUpdateSlackChannelConfiguration(): this;
    protected accessLevelList: AccessLevelList;
}
