<!-- Powered by BMAD™ Core -->

# Product Manager (PM) Requirements Checklist

This checklist serves as a comprehensive framework to ensure the Product Requirements Document (PRD) and Epic definitions are complete, well-structured, and appropriately scoped for MVP development. The PM should systematically work through each item during the product definition process.

[[LLM: INITIALIZATION INSTRUCTIONS - PM CHECKLIST

Before proceeding with this checklist, ensure you have access to:

1. prd.md - The Product Requirements Document (check docs/internal/prd.md)
2. Any user research, market analysis, or competitive analysis documents
3. Business goals and strategy documents
4. Any existing epic definitions or user stories

IMPORTANT: If the PRD is missing, immediately ask the user for its location or content before proceeding.

VALIDATION APPROACH:

1. User-Centric - Every requirement should tie back to user value
2. MVP Focus - Ensure scope is truly minimal while viable
3. Clarity - Requirements should be unambiguous and testable
4. Completeness - All aspects of the product vision are covered
5. Feasibility - Requirements are technically achievable

EXECUTION MODE:
Ask the user if they want to work through the checklist:

- Section by section (interactive mode) - Review each section, present findings, get confirmation before proceeding
- All at once (comprehensive mode) - Complete full analysis and present comprehensive report at end]]

## 1. PROBLEM DEFINITION & CONTEXT

[[LLM: The foundation of any product is a clear problem statement. As you review this section:

1. Verify the problem is real and worth solving
2. Check that the target audience is specific, not "everyone"
3. Ensure success metrics are measurable, not vague aspirations
4. Look for evidence of user research, not just assumptions
5. Confirm the problem-solution fit is logical]]

### 1.1 Problem Statement

- [ ] Clear articulation of the problem being solved
- [ ] Identification of who experiences the problem
- [ ] Explanation of why solving this problem matters
- [ ] Quantification of problem impact (if possible)
- [ ] Differentiation from existing solutions

### 1.2 Business Goals & Success Metrics

- [ ] Specific, measurable business objectives defined
- [ ] Clear success metrics and KPIs established
- [ ] Metrics are tied to user and business value
- [ ] Baseline measurements identified (if applicable)
- [ ] Timeframe for achieving goals specified

### 1.3 User Research & Insights

- [ ] Target user personas clearly defined
- [ ] User needs and pain points documented
- [ ] User research findings summarized (if available)
- [ ] Competitive analysis included
- [ ] Market context provided

## 2. MVP SCOPE DEFINITION

[[LLM: MVP scope is critical - too much and you waste resources, too little and you can't validate. Check:

1. Is this truly minimal? Challenge every feature
2. Does each feature directly address the core problem?
3. Are "nice-to-haves" clearly separated from "must-haves"?
4. Is the rationale for inclusion/exclusion documented?
5. Can you ship this in the target timeframe?]]

### 2.1 Core Functionality

- [ ] Essential features clearly distinguished from nice-to-haves
- [ ] Features directly address defined problem statement
- [ ] Each Epic ties back to specific user needs
- [ ] Features and Stories are described from user perspective
- [ ] Minimum requirements for success defined

### 2.2 Scope Boundaries

- [ ] Clear articulation of what is OUT of scope
- [ ] Future enhancements section included
- [ ] Rationale for scope decisions documented
- [ ] MVP minimizes functionality while maximizing learning
- [ ] Scope has been reviewed and refined multiple times

### 2.3 MVP Validation Approach

- [ ] Method for testing MVP success defined
- [ ] Initial user feedback mechanisms planned
- [ ] Criteria for moving beyond MVP specified
- [ ] Learning goals for MVP articulated
- [ ] Timeline expectations set

## 3. USER EXPERIENCE REQUIREMENTS

[[LLM: UX requirements bridge user needs and technical implementation. Validate:

1. User flows cover the primary use cases completely
2. Edge cases are identified (even if deferred)
3. Accessibility isn't an afterthought
4. Performance expectations are realistic
5. Error states and recovery are planned]]

### 3.1 User Journeys & Flows

- [ ] Primary user flows documented
- [ ] Entry and exit points for each flow identified
- [ ] Decision points and branches mapped
- [ ] Critical path highlighted
- [ ] Edge cases considered

### 3.2 Usability Requirements

- [ ] Accessibility considerations documented
- [ ] Platform/device compatibility specified
- [ ] Performance expectations from user perspective defined
- [ ] Error handling and recovery approaches outlined
- [ ] User feedback mechanisms identified

### 3.3 UI Requirements

- [ ] Information architecture outlined
- [ ] Critical UI components identified
- [ ] Visual design guidelines referenced (if applicable)
- [ ] Content requirements specified
- [ ] High-level navigation structure defined

## 4. FUNCTIONAL REQUIREMENTS

[[LLM: Functional requirements must be clear enough for implementation. Check:

1. Requirements focus on WHAT not HOW (no implementation details)
2. Each requirement is testable (how would QA verify it?)
3. Dependencies are explicit (what needs to be built first?)
4. Requirements use consistent terminology
5. Complex features are broken into manageable pieces]]

### 4.1 Feature Completeness

- [ ] All required features for MVP documented
- [ ] Features have clear, user-focused descriptions
- [ ] Feature priority/criticality indicated
- [ ] Requirements are testable and verifiable
- [ ] Dependencies between features identified

### 4.2 Requirements Quality

- [ ] Requirements are specific and unambiguous
- [ ] Requirements focus on WHAT not HOW
- [ ] Requirements use consistent terminology
- [ ] Complex requirements broken into simpler parts
- [ ] Technical jargon minimized or explained

### 4.3 User Stories & Acceptance Criteria

- [ ] Stories follow consistent format
- [ ] Acceptance criteria are testable
- [ ] Stories are sized appropriately (not too large)
- [ ] Stories are independent where possible
- [ ] Stories include necessary context
- [ ] Local testability requirements (e.g., via CLI) defined in ACs for relevant backend/data stories

## 5. NON-FUNCTIONAL REQUIREMENTS

### 5.1 Performance Requirements

- [ ] Response time expectations defined
- [ ] Throughput/capacity requirements specified
- [ ] Scalability needs documented
- [ ] Resource utilization constraints identified
- [ ] Load handling expectations set

### 5.2 Security & Compliance

- [ ] Data protection requirements specified
- [ ] Authentication/authorization needs defined
- [ ] Compliance requirements documented
- [ ] Security testing requirements outlined
- [ ] Privacy considerations addressed

### 5.3 Reliability & Resilience

- [ ] Availability requirements defined
- [ ] Backup and recovery needs documented
- [ ] Fault tolerance expectations set
- [ ] Error handling requirements specified
- [ ] Maintenance and support considerations included

### 5.4 Technical Constraints

- [ ] Platform/technology constraints documented
- [ ] Integration requirements outlined
- [ ] Third-party service dependencies identified
- [ ] Infrastructure requirements specified
- [ ] Development environment needs identified

## 6. EPIC & STORY STRUCTURE

### 6.1 Epic Definition

- [ ] Epics represent cohesive units of functionality
- [ ] Epics focus on user/business value delivery
- [ ] Epic goals clearly articulated
- [ ] Epics are sized appropriately for incremental delivery
- [ ] Epic sequence and dependencies identified

### 6.2 Story Breakdown

- [ ] Stories are broken down to appropriate size
- [ ] Stories have clear, independent value
- [ ] Stories include appropriate acceptance criteria
- [ ] Story dependencies and sequence documented
- [ ] Stories aligned with epic goals

### 6.3 First Epic Completeness

- [ ] First epic includes all necessary setup steps
- [ ] Project scaffolding and initialization addressed
- [ ] Core infrastructure setup included
- [ ] Development environment setup addressed
- [ ] Local testability established early

## 7. TECHNICAL GUIDANCE

### 7.1 Architecture Guidance

- [ ] Initial architecture direction provided
- [ ] Technical constraints clearly communicated
- [ ] Integration points identified
- [ ] Performance considerations highlighted
- [ ] Security requirements articulated
- [ ] Known areas of high complexity or technical risk flagged for architectural deep-dive

### 7.2 Technical Decision Framework

- [ ] Decision criteria for technical choices provided
- [ ] Trade-offs articulated for key decisions
- [ ] Rationale for selecting primary approach over considered alternatives documented (for key design/feature choices)
- [ ] Non-negotiable technical requirements highlighted
- [ ] Areas requiring technical investigation identified
- [ ] Guidance on technical debt approach provided

### 7.3 Implementation Considerations

- [ ] Development approach guidance provided
- [ ] Testing requirements articulated
- [ ] Deployment expectations set
- [ ] Monitoring needs identified
- [ ] Documentation requirements specified

## 8. CROSS-FUNCTIONAL REQUIREMENTS

### 8.1 Data Requirements

- [ ] Data entities and relationships identified
- [ ] Data storage requirements specified
- [ ] Data quality requirements defined
- [ ] Data retention policies identified
- [ ] Data migration needs addressed (if applicable)
- [ ] Schema changes planned iteratively, tied to stories requiring them

### 8.2 Integration Requirements

- [ ] External system integrations identified
- [ ] API requirements documented
- [ ] Authentication for integrations specified
- [ ] Data exchange formats defined
- [ ] Integration testing requirements outlined

### 8.3 Operational Requirements

- [ ] Deployment frequency expectations set
- [ ] Environment requirements defined
- [ ] Monitoring and alerting needs identified
- [ ] Support requirements documented
- [ ] Performance monitoring approach specified

## 9. CLARITY & COMMUNICATION

### 9.1 Documentation Quality

- [ ] Documents use clear, consistent language
- [ ] Documents are well-structured and organized
- [ ] Technical terms are defined where necessary
- [ ] Diagrams/visuals included where helpful
- [ ] Documentation is versioned appropriately

### 9.2 Stakeholder Alignment

- [ ] Key stakeholders identified
- [ ] Stakeholder input incorporated
- [ ] Potential areas of disagreement addressed
- [ ] Communication plan for updates established
- [ ] Approval process defined

## PRD & EPIC VALIDATION SUMMARY

[[LLM: FINAL PM CHECKLIST REPORT GENERATION

Create a comprehensive validation report that includes:

1. Executive Summary
   - Overall PRD completeness (percentage)
   - MVP scope appropriateness (Too Large/Just Right/Too Small)
   - Readiness for architecture phase (Ready/Nearly Ready/Not Ready)
   - Most critical gaps or concerns

2. Category Analysis Table
   Fill in the actual table with:
   - Status: PASS (90%+ complete), PARTIAL (60-89%), FAIL (<60%)
   - Critical Issues: Specific problems that block progress

3. Top Issues by Priority
   - BLOCKERS: Must fix before architect can proceed
   - HIGH: Should fix for quality
   - MEDIUM: Would improve clarity
   - LOW: Nice to have

4. MVP Scope Assessment
   - Features that might be cut for true MVP
   - Missing features that are essential
   - Complexity concerns
   - Timeline realism

5. Technical Readiness
   - Clarity of technical constraints
   - Identified technical risks
   - Areas needing architect investigation

6. Recommendations
   - Specific actions to address each blocker
   - Suggested improvements
   - Next steps

After presenting the report, ask if the user wants:

- Detailed analysis of any failed sections
- Suggestions for improving specific areas
- Help with refining MVP scope]]

### Category Statuses

| Category                         | Status | Critical Issues |
| -------------------------------- | ------ | --------------- |
| 1. Problem Definition & Context  | _TBD_  |                 |
| 2. MVP Scope Definition          | _TBD_  |                 |
| 3. User Experience Requirements  | _TBD_  |                 |
| 4. Functional Requirements       | _TBD_  |                 |
| 5. Non-Functional Requirements   | _TBD_  |                 |
| 6. Epic & Story Structure        | _TBD_  |                 |
| 7. Technical Guidance            | _TBD_  |                 |
| 8. Cross-Functional Requirements | _TBD_  |                 |
| 9. Clarity & Communication       | _TBD_  |                 |

### Critical Deficiencies

(To be populated during validation)

### Recommendations

(To be populated during validation)

### Final Decision

- **READY FOR ARCHITECT**: The PRD and epics are comprehensive, properly structured, and ready for architectural design.
- **NEEDS REFINEMENT**: The requirements documentation requires additional work to address the identified deficiencies.
