# RustyBT Examples & Tutorials

**Purpose**: Practical examples and tutorials demonstrating RustyBT usage
**Audience**: RustyBT users learning the framework
**Status**: Part of user-facing documentation

---

## Overview

This directory contains executable examples demonstrating RustyBT's features and capabilities. All examples are fully functional and can be run directly after installing RustyBT.

## What's Available

### 📓 Interactive Jupyter Notebooks
**13 comprehensive notebooks** covering everything from quick starts to advanced optimization:

- **Quick Start Examples** - Get up and running quickly with crypto and equity backtesting
- **Getting Started Tutorials** - Step-by-step guides for data ingestion and strategy development
- **Analysis & Optimization** - Performance metrics, parameter tuning, and risk analytics
- **Complete Workflows** - End-to-end examples combining all RustyBT features

➡️ **[Browse All Notebooks](notebooks/)** (13 notebooks with interactive examples)

### 📚 Related Documentation

For comprehensive framework documentation:

- **[Getting Started](../getting-started/installation.md)** - Installation and initial setup
- **[User Guides](../guides/broker-setup-guide.md)** - Detailed feature guides
- **[API Reference](../api/datasource-api.md)** - Complete API documentation

## Quick Navigation

| I want to... | Go to... |
|--------------|----------|
| Try RustyBT immediately | [10_full_workflow.ipynb](notebooks/10_full_workflow.ipynb) ⭐ Recommended |
| Learn data ingestion | [02_data_ingestion.ipynb](notebooks/02_data_ingestion.ipynb) |
| Build my first strategy | [03_strategy_development.ipynb](notebooks/03_strategy_development.ipynb) |
| Optimize parameters | [05_optimization.ipynb](notebooks/05_optimization.ipynb) |
| Analyze risk metrics | [07_risk_analytics.ipynb](notebooks/07_risk_analytics.ipynb) |
| Test with live data | [09_live_paper_trading.ipynb](notebooks/09_live_paper_trading.ipynb) |

---

**Maintained By**: RustyBT Development Team
**Last Updated**: 2025-10-18 (Documentation restructure)
